/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CookMakeTask<B extends BlockEntity, R extends Recipe<? extends Container>>
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final ICookTask<B, R> task;
    private final MaidCookManager<R> cm;
    private final AbstractCookRule<B, R> rule;
    private final CookBeBase<B> cookBe;

    public CookMakeTask(ICookTask<B, R> task, MaidCookManager<R> cm, AbstractCookRule<B, R> rule, CookBeBase<B> cookBe) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MkEntities.WORK_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.task = task;
        this.cm = cm;
        this.rule = rule;
        this.cookBe = cookBe;
    }

    @SafeRun
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!this.cm.inited()) {
            MemoryUtil.resetCookWorkState(maid);
            this.cm.resetState();
            return false;
        }
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)MkEntities.WORK_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty()) {
                    MemoryUtil.eraseWorkPos(maid);
                    this.cm.resetState();
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        MemoryUtil.getWorkPos(maid).ifPresent(posWrapper -> {
            BlockPos basePos = posWrapper.m_6675_();
            BlockEntity blockEntity = worldIn.m_7702_(basePos);
            if (blockEntity != null && this.cookBe.isCookBe(blockEntity)) {
                this.rule.cookMake(this.cookBe, this.cm);
                this.sync();
            }
        });
    }

    @SafeRun
    protected void tick(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        this.rule.tickCookMake(this.cookBe, this.cm);
    }

    protected void sync() {
        this.cookBe.markChanged();
        this.cm.itemOutput2Chest();
        this.cm.syncInv();
        this.cm.updateInvIngredients();
    }

    @TimeRecord
    @SafeRun
    protected void stop(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        this.rule.tickStop(this.cookBe, this.cm);
        this.sync();
        this.cookBe.clear();
        MemoryUtil.eraseWorkPos(maid);
    }

    @SafeRun
    protected boolean canStillUse(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        return this.rule.tickCan(this.cookBe, this.cm);
    }

    protected boolean m_7773_(long pGameTime) {
        return false;
    }
}

