/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.network.packet.c2s;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record GiveRecipeIngredientPacket(List<ItemStack> list) {
    public static void encode(GiveRecipeIngredientPacket packet, FriendlyByteBuf buf) {
        List<ItemStack> list = packet.list();
        buf.m_130130_(list.size());
        for (ItemStack itemStack : list) {
            buf.m_130055_(itemStack);
        }
    }

    public static GiveRecipeIngredientPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130267_());
        }
        return new GiveRecipeIngredientPacket(list);
    }

    public static void handle(GiveRecipeIngredientPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                for (ItemStack itemStack : packet.list()) {
                    sender.m_36356_(itemStack);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

