/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.request;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.network.JEIRequestResultPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;

public class IngredientRequest {
    public static void onRequest(ServerPlayer actor, List<ItemStack> data, int maidId) {
        EntityMaid maid;
        Level level = actor.m_9236_();
        Entity entity = level.m_6815_(maidId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)actor)) {
            if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.CO_WORK) {
                Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> actor), (Object)new JEIRequestResultPacket((Component)Component.m_237110_((String)"gui.maid_storage_manager.jei_request.invalid", (Object[])new Object[]{maid.m_5446_()})));
                return;
            }
            ItemStack listItem = RequestItemUtil.makeVirtualItemStack(data, null, (Entity)actor, "JEI");
            if (!InvUtil.tryPlace((IItemHandler)maid.getAvailableInv(true), listItem).m_41619_()) {
                Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> actor), (Object)new JEIRequestResultPacket((Component)Component.m_237110_((String)"gui.maid_storage_manager.jei_request.full", (Object[])new Object[]{maid.m_5446_()})));
                return;
            }
        } else {
            Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> actor), (Object)new JEIRequestResultPacket((Component)Component.m_237115_((String)"gui.maid_storage_manager.jei_request.not_found")));
            return;
        }
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> actor), (Object)new JEIRequestResultPacket((Component)Component.m_237110_((String)"gui.maid_storage_manager.jei_request.start", (Object[])new Object[]{maid.m_5446_()})));
    }
}

