/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.furnace;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class FurnaceCraftMenu
extends AbstractCraftMenu<FurnaceCraftMenu> {
    public FurnaceCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_FURNACE.get(), p_38852_, player);
    }

    @Override
    protected void addFilterSlots() {
        int i = 0;
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 45, 45));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 45, 81));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 105, 63, true));
    }

    @Override
    protected void addSpecialSlots() {
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(0), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(1), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(2), this.stepDataContainer));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                ListTag list = data.m_128437_("inputs", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStackUtil.parseStack(list.m_128728_(i));
                    this.stepDataContainer.setItemNoTrigger(0, stack);
                }
                if (this.stepDataContainer.m_8020_(1).m_41619_()) {
                    this.stepDataContainer.setItemNoTrigger(1, Items.f_42413_.m_7968_());
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
                break;
            }
            case COUNT: {
                this.stepDataContainer.setCount(key, value);
                this.stepDataContainer.m_6596_();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        if (ForgeHooks.getBurnTime((ItemStack)this.stepDataContainer.m_8020_(1), (RecipeType)RecipeType.f_44108_) == 0) {
            this.stepDataContainer.setItemNoTrigger(1, ItemStack.f_41583_);
            return;
        }
        Optional<SmeltingRecipe> recipe = RecipeUtil.getSmeltingRecipe(this.player.m_9236_(), this.stepDataContainer.m_8020_(0).m_255036_(1));
        recipe.ifPresentOrElse(craftingRecipe -> {
            ItemStack resultItem = craftingRecipe.m_8043_(this.player.m_9236_().m_9598_());
            this.stepDataContainer.setItemNoTrigger(2, resultItem);
            this.stepDataContainer.setCount(2, resultItem.m_41613_() * this.stepDataContainer.getCount(0));
        }, () -> this.stepDataContainer.setItemNoTrigger(2, ItemStack.f_41583_));
    }
}

