/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ae2;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.parts.IPart;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.MEStorage;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.parts.reporting.AbstractTerminalPart;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import studio.fantasyit.maid_storage_manager.craft.context.special.AeCraftingAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.type.AE2Type;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.AbstractFilterableBlockStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageCraftDataProvider;

public abstract class Ae2BaseContext
extends AbstractFilterableBlockStorage
implements IStorageCraftDataProvider,
IStorageContext {
    protected MEStorage inv;
    protected IGrid grid;
    protected Target target;
    protected IPart part;
    boolean isDone = false;

    public boolean init(EntityMaid maid, ServerLevel level, Target target) {
        BlockEntity blockEntity = level.m_7702_(target.pos);
        if (blockEntity instanceof CableBusBlockEntity) {
            CableBusBlockEntity cbbe = (CableBusBlockEntity)blockEntity;
            Optional<Direction> first = Arrays.stream(Direction.m_122382_((Entity)maid)).filter(direction -> {
                boolean bl;
                IPart part = cbbe.getCableBus().getPart(direction);
                if (part instanceof AbstractTerminalPart) {
                    AbstractTerminalPart atp = (AbstractTerminalPart)part;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).findFirst();
            if (first.isEmpty()) {
                return false;
            }
            this.part = cbbe.getCableBus().getPart(first.get());
            IGridNode terminal = cbbe.getGridNode(first.get());
            if (terminal != null) {
                this.grid = terminal.getGrid();
                if (this.grid != null) {
                    this.inv = this.grid.getStorageService().getInventory();
                    this.target = target;
                    return this.inv != null;
                }
            }
        }
        return false;
    }

    public ICraftingService getCraftingService() {
        return this.grid.getCraftingService();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public IPart getPart() {
        return this.part;
    }

    @Override
    public List<CraftGuideData> getCraftGuideData() {
        ArrayList<CraftGuideData> list = new ArrayList<CraftGuideData>();
        this.inv.getAvailableStacks().keySet().stream().filter(key -> {
            AEItemKey aek;
            return key instanceof AEItemKey && (aek = (AEItemKey)key).getReadOnlyStack().m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get());
        }).map(key -> CraftGuideData.fromItemStack(((AEItemKey)key).getReadOnlyStack())).filter(CraftGuideData::available).forEach(list::add);
        ICraftingService crafting = this.getCraftingService();
        Set craftables = crafting.getCraftables(AEItemKey.filter());
        craftables.stream().filter(aeKey -> aeKey instanceof AEItemKey).map(key -> {
            List<CraftGuideStepData> steps = List.of(new CraftGuideStepData(this.target, List.of(), List.of(((AEItemKey)key).getReadOnlyStack().m_255036_(1)), AeCraftingAction.TYPE));
            return new CraftGuideData(steps, AE2Type.TYPE);
        }).forEach(list::add);
        this.setDone(true);
        return list;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public void setDone(boolean done) {
        this.isDone = done;
    }
}

