/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.rs;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.context.special.RsCraftingAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.type.RSType;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.AbstractFilterableBlockStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageCraftDataProvider;

public abstract class AbstractRSContext
extends AbstractFilterableBlockStorage
implements IStorageCraftDataProvider {
    protected IStackList<ItemStack> stackList;
    protected Collection<StackListEntry<ItemStack>> stackListStacks;
    protected IStackList<ItemStack> craftable;
    public INetwork network;
    ServerLevel level;
    Target target;
    protected INetworkNode node;
    boolean done = false;

    private void reinit() {
        INetworkNodeManager networkNodeManager = API.instance().getNetworkNodeManager(this.level);
        this.node = networkNodeManager.getNode(this.target.pos);
        if (this.node == null) {
            return;
        }
        this.network = this.node.getNetwork();
        if (this.network != null) {
            IStorageCache itemStorageCache = this.network.getItemStorageCache();
            this.stackList = itemStorageCache.getList();
            this.stackListStacks = new ArrayList<StackListEntry<ItemStack>>(this.stackList.getStacks());
            this.craftable = itemStorageCache.getCraftablesList();
        }
    }

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
        this.level = level;
        this.target = target;
        this.reinit();
    }

    @Override
    public void reset() {
        super.reset();
        this.reinit();
        this.done = false;
    }

    @Override
    public void finish() {
        super.finish();
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public List<CraftGuideData> getCraftGuideData() {
        ArrayList<CraftGuideData> list = new ArrayList<CraftGuideData>(this.craftable.getStacks().stream().filter(entry -> ((ItemStack)entry.getStack()).m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())).map(entry -> CraftGuideData.fromItemStack((ItemStack)entry.getStack())).toList());
        Collection craftableStacks = this.craftable.getStacks();
        craftableStacks.stream().map(key -> {
            List<CraftGuideStepData> steps = List.of(new CraftGuideStepData(this.target, List.of(), List.of((ItemStack)key.getStack()), RsCraftingAction.TYPE));
            return new CraftGuideData(steps, RSType.TYPE);
        }).forEach(list::add);
        this.done = true;
        return list;
    }
}

