/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class MoveUtil {
    public static boolean isValidTarget(ServerLevel level, EntityMaid maid, Target target, boolean bypassNoAccess) {
        List<Target> rewrite = StorageAccessUtil.findTargetRewrite(level, maid, target, bypassNoAccess);
        return rewrite.contains(target);
    }

    public static List<BlockPos> getAllAvailablePosForTarget(ServerLevel level, EntityMaid maid, BlockPos target, MaidPathFindingBFS pathFinding) {
        Function<BlockPos, @Nullable BlockPos> predictor = pos -> {
            if (!PosUtil.isSafePos((Level)level, pos)) {
                return null;
            }
            if (maid.m_21444_(pos) && PosUtil.canTouch(level, pos, target) && pathFinding.canPathReach(pos)) {
                return pos;
            }
            return null;
        };
        if (maid.m_20183_().m_123333_((Vec3i)target) <= 2 && predictor.apply(maid.m_20183_()) != null) {
            return List.of(maid.m_20183_());
        }
        return PosUtil.gatherAroundUpAndDown(target, predictor);
    }

    @Nullable
    public static BlockPos getNearestFromTargetList(ServerLevel level, EntityMaid maid, List<BlockPos> posListToEval) {
        if (posListToEval.contains(maid.m_20183_())) {
            return maid.m_20183_();
        }
        List<Pair> posList = posListToEval.stream().map(pos -> {
            if (Config.fastPathSchedule) {
                return new Pair(pos, (Object)((int)maid.m_20238_(pos.m_252807_())));
            }
            Path path = maid.m_21573_().m_7864_(pos, 0);
            if (path != null && path.m_77403_()) {
                return new Pair(pos, (Object)path.m_77398_());
            }
            return null;
        }).filter(Objects::nonNull).toList();
        return posList.stream().min(Comparator.comparingInt(Pair::getB)).map(Pair::getA).orElse(null);
    }

    @Nullable
    public static BlockPos selectPosForTarget(ServerLevel level, EntityMaid maid, BlockPos target) {
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
        @NotNull List<BlockPos> posListToEval = MoveUtil.getAllAvailablePosForTarget(level, maid, target, pathFinding);
        pathFinding.finish();
        return MoveUtil.getNearestFromTargetList(level, maid, posListToEval);
    }

    @Nullable
    public static Target findTargetForPos(ServerLevel level, EntityMaid maid, BlockPos blockPos, AbstractTargetMemory memory, boolean allowRequestOnly, Predicate<Target> validator) {
        return PosUtil.findAroundUpAndDown(blockPos, pos -> {
            Target validTarget = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, (BlockPos)pos);
            if (validTarget == null || !PosUtil.canTouch(level, blockPos, pos)) {
                return null;
            }
            List<Target> list = StorageAccessUtil.findTargetRewrite(level, maid, validTarget, allowRequestOnly);
            for (Target storage : list) {
                if (memory.isVisitedPos(storage) || !validator.test(storage)) continue;
                return storage;
            }
            return null;
        });
    }

    public static boolean setMovementIfColliedTarget(ServerLevel level, EntityMaid maid, Target target) {
        if (target.side == null) {
            return MoveUtil.setMovementIfColliedTarget(level, maid, target.pos);
        }
        return MoveUtil.setMovementIfColliedTarget(level, maid, target.pos.m_121945_(target.side));
    }

    public static boolean setMovementIfColliedTarget(ServerLevel level, EntityMaid maid, BlockPos pos) {
        if (maid.m_20191_().m_82381_(new AABB(pos))) {
            if (maid.m_20184_().m_82553_() > 0.1) {
                return false;
            }
            Vec3 dMove = maid.m_20318_(0.0f).m_82546_(pos.m_252807_()).m_82541_().m_82490_((double)0.4f);
            dMove = dMove.m_193103_(Direction.Axis.Y, 0.0);
            maid.m_20256_(dMove);
            return false;
        }
        return true;
    }

    public static boolean setMovementIfNotReached(EntityMaid maid) {
        BlockPos targetPos = MemoryUtil.getTargetPos(maid);
        if (targetPos == null) {
            return false;
        }
        double maidX = maid.m_20185_();
        double maidZ = maid.m_20189_();
        Vec3 center = targetPos.m_252807_();
        double targetCenterX = center.f_82479_;
        double targetCenterZ = center.f_82481_;
        if (Math.abs(maidX - targetCenterX) > 0.3 || Math.abs(maidZ - targetCenterZ) > 0.3) {
            maid.m_20256_(new Vec3(targetCenterX - maidX, 0.0, targetCenterZ - maidZ).m_82541_().m_82490_(0.1));
            return true;
        }
        return false;
    }

    public static void setMovementTowardsTargetSlowly(EntityMaid maid) {
        BlockPos targetPos = MemoryUtil.getTargetPos(maid);
        if (targetPos == null) {
            return;
        }
        double maidX = maid.m_20185_();
        double maidZ = maid.m_20189_();
        Vec3 center = targetPos.m_252807_();
        double targetCenterX = center.f_82479_;
        double targetCenterZ = center.f_82481_;
        maid.m_20256_(new Vec3(targetCenterX - maidX, 0.0, targetCenterZ - maidZ).m_82541_().m_82490_(0.1));
    }
}

