package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CheeseTankBkock extends TankBlock {
    public CheeseTankBkock(Properties pProperties) {
        super(pProperties);
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return ladleOut(pLevel, pPos, pPlayer);
    }

    public InteractionResult ladleOut(Level pLevel, BlockPos pPos, Player pPlayer){
        ItemUtil.givePlayerItem(pPlayer,new ItemStack(BakeriesItems.CHEESE_CUBE.get(),4));
        pLevel.setBlockAndUpdate(pPos, BakeriesBlocks.FERMENTATION_TANK.get().defaultBlockState());
        return InteractionResult.SUCCESS;
    }
}
