package com.renyigesai.bakeries.block.cake_box;

import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CakeBoxBlock extends BaseEntityBlock {
    public static final VoxelShape BOX = box(2.0,0.0,2.0,14.0,11.0,14.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public CakeBoxBlock() {
        super(BlockBehaviour.Properties.of().strength(0.1f).sound(SoundType.WOOD));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOX;
    }

    @Override
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CakeBoxBlockEntity boxBlock){
            if (!boxBlock.isEmpty()){
                ItemStack stackInSlot = boxBlock.getInventory().getStackInSlot(0);
                boxBlock.getInventory().setStackInSlot(0,ItemStack.EMPTY);
                pLevel.destroyBlock(pPos,false);
                if (stackInSlot.getItem() instanceof BlockItem blockItem){
                    pLevel.setBlock(pPos,blockItem.getBlock().defaultBlockState(),3);
                }else {
                    ItemUtil.spawnItemEntity(pLevel,stackInSlot,pPos);
                }
            }else {
                pLevel.destroyBlock(pPos,false);
            }
            ItemUtil.givePlayerItem(pPlayer,new ItemStack(BakeriesItems.CAKE_BOX.get()));
            return InteractionResult.SUCCESS;
        }
        return super.use(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nullable
    @Override
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CakeBoxBlockEntity(pPos,pState);
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return pState.setValue(FACING, pRot.rotate(pState.getValue(FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation(pState.getValue(FACING)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.defaultBlockState().setValue(FACING, pContext.getHorizontalDirection());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(FACING);
    }
}
