/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin.ext;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.ext.FileKt;
import me.leon.ext.fx.FXExtKt;
import me.leon.toolsfx.plugin.ext.ColorKt;
import me.leon.toolsfx.plugin.ext.ImagesKt;
import me.leon.toolsfx.plugin.ext.KernelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aH\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014\u001a\u001e\u0010\u0015\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\t\u001a\u0014\u0010\u0018\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007\u001a\n\u0010\u001a\u001a\u00020\u0013*\u00020\u0013\u001a\u0014\u0010\u001b\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007\u001a\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0014\u0010\u001f\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0016\u0010 \u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007H\u0002\u001a\u001e\u0010 \u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010!\u001a\u00020\u0007\u001a\u0016\u0010\"\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\"\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010!\u001a\u00020\u0007\u001a\u0014\u0010#\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007\u001a\n\u0010$\u001a\u00020\u0013*\u00020\u0013\u001a\u0016\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130&*\u00020\u0013\u001a\n\u0010'\u001a\u00020\u0013*\u00020\u0013\u001a\u0015\u0010(\u001a\u00020\u0013*\u00020\u00132\u0006\u0010)\u001a\u00020\u0013H\u0086\u0002\u001a\n\u0010*\u001a\u00020\u0013*\u00020\u0013\u001a\n\u0010+\u001a\u00020\u0013*\u00020\u0013\u001a\u0014\u0010,\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010-\u001a\u00020\u0007\u001a\u0014\u0010.\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010-\u001a\u00020\u0007\u001a\u0014\u0010/\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007\u001a\n\u00100\u001a\u00020\u0007*\u00020\u0013\u001a\f\u00101\u001a\u000202*\u00020\u0013H\u0002\u001a\u001c\u00103\u001a\u00020\u0013*\u00020\u00132\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0007\u001a\u0014\u00106\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u00107\u001a\u00020\u0014*\u00020\u00132\u0006\u00108\u001a\u00020\t\u001a\n\u00109\u001a\u00020\u0013*\u00020:\u001a\u0014\u0010;\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0007\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"FILE_PATH", "Lkotlin/text/Regex;", "getFILE_PATH", "()Lkotlin/text/Regex;", "setFILE_PATH", "(Lkotlin/text/Regex;)V", "FILE_PATH_MAX_LENGTH", "", "isLine", "", "left", "right", "bottom", "top", "leftBottom", "rightTop", "leftTop", "rightBottom", "autoConvertToBufferImage", "Ljava/awt/image/BufferedImage;", "", "binary", "threshold", "isGray", "blackHat", "kernelSize", "cleanBinary", "closeOp", "convolve", "kernel", "Ljava/awt/image/Kernel;", "denoise", "dilate", "iteration", "erode", "gradient", "gray", "grayOstu", "Lkotlin/Pair;", "inverse", "minus", "other", "mirrorHeight", "mirrorWidth", "mosaic", "size", "oilPaint", "openOp", "ostu", "removeLines", "", "scale", "", "interpolationType", "sharpen", "toBinaryString", "isBlackOne", "toBufferImage", "Ljava/io/File;", "topHat", "plugin-image"})
@SourceDebugExtension(value={"SMAP\nBufferedImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedImage.kt\nme/leon/toolsfx/plugin/ext/BufferedImageKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,434:1\n1#2:435\n*E\n"})
public final class BufferedImageKt {
    public static final int FILE_PATH_MAX_LENGTH = 1024;
    @NotNull
    private static Regex FILE_PATH = new Regex("[:\\\\/]");

    @NotNull
    public static final BufferedImage gray(@NotNull BufferedImage $this$gray) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$gray, (String)"<this>");
        BufferedImage $this$gray_u24lambda_u243 = bufferedImage = new BufferedImage($this$gray.getWidth(), $this$gray.getHeight(), $this$gray.getType());
        boolean bl = false;
        int n = $this$gray_u24lambda_u243.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$gray_u24lambda_u243.getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl3 = false;
                Color $this$gray_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240 = new Color($this$gray.getRGB(x, y));
                boolean bl4 = false;
                int gray = (int)(0.3 * (double)$this$gray_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRed() + 0.59 * (double)$this$gray_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getGreen() + 0.11 * (double)$this$gray_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getBlue());
                $this$gray_u24lambda_u243.setRGB(x, y, new Color(gray, gray, gray).hashCode());
            }
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage binary(@NotNull BufferedImage $this$binary, int threshold, boolean isGray) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$binary, (String)"<this>");
        BufferedImage $this$binary_u24lambda_u248 = bufferedImage = new BufferedImage($this$binary.getWidth(), $this$binary.getHeight(), $this$binary.getType());
        boolean bl = false;
        int n = $this$binary_u24lambda_u248.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$binary_u24lambda_u248.getHeight();
            for (int j = 0; j < n2; ++j) {
                int y = j;
                boolean bl3 = false;
                Color $this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 = new Color($this$binary.getRGB(x, y));
                boolean bl4 = false;
                int gray = isGray ? (int)(0.3 * (double)$this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getRed() + 0.59 * (double)$this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getGreen() + 0.11 * (double)$this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getBlue()) : ($this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getRed() + $this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getGreen() + $this$binary_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getBlue()) / 3;
                Integer n3 = 255;
                int it = ((Number)n3).intValue();
                boolean bl5 = false;
                Integer n4 = gray > threshold ? n3 : null;
                int color = n4 != null ? n4 : 0;
                $this$binary_u24lambda_u248.setRGB(x, y, new Color(color, color, color).getRGB());
            }
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage binary$default(BufferedImage bufferedImage, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 159;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return BufferedImageKt.binary(bufferedImage, n, bl);
    }

    @NotNull
    public static final BufferedImage cleanBinary(@NotNull BufferedImage $this$cleanBinary) {
        BufferedImage buff;
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$cleanBinary, (String)"<this>");
        BufferedImage $this$cleanBinary_u24lambda_u2414 = bufferedImage = new BufferedImage($this$cleanBinary.getWidth(), $this$cleanBinary.getHeight(), $this$cleanBinary.getType());
        boolean bl = false;
        Pair<Integer, BufferedImage> pair = BufferedImageKt.grayOstu($this$cleanBinary);
        int threshold = ((Number)pair.component1()).intValue();
        BufferedImage $this$cleanBinary_u24lambda_u2414_u24lambda_u2413 = buff = (BufferedImage)pair.component2();
        boolean bl2 = false;
        int n = $this$cleanBinary_u24lambda_u2414_u24lambda_u2413.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl3 = false;
            int n2 = $this$cleanBinary_u24lambda_u2414_u24lambda_u2413.getHeight();
            for (int j = 0; j < n2; ++j) {
                int y = j;
                boolean bl4 = false;
                Color $this$cleanBinary_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = new Color($this$cleanBinary_u24lambda_u2414_u24lambda_u2413.getRGB(x, y));
                boolean bl5 = false;
                Integer n3 = 255;
                int it = ((Number)n3).intValue();
                boolean bl6 = false;
                Integer n4 = $this$cleanBinary_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.getRed() > threshold ? n3 : null;
                int color = n4 != null ? n4 : 0;
                $this$cleanBinary_u24lambda_u2414.setRGB(x, y, new Color(color, color, color).getRGB());
            }
        }
        System.out.println(threshold);
        BufferedImageKt.removeLines($this$cleanBinary_u24lambda_u2414);
        return bufferedImage;
    }

    private static final void removeLines(BufferedImage $this$removeLines) {
        int n = $this$removeLines.getHeight() - 1;
        for (int y = 1; y < n; ++y) {
            int n2 = $this$removeLines.getWidth() - 1;
            for (int x = 1; x < n2; ++x) {
                int rightBottom;
                int center = $this$removeLines.getRGB(x, y);
                if (!ColorKt.isBlack(center)) continue;
                int left = $this$removeLines.getRGB(x - 1, y);
                int right = $this$removeLines.getRGB(x + 1, y);
                int top = $this$removeLines.getRGB(x, y - 1);
                int bottom = $this$removeLines.getRGB(x, y + 1);
                int leftBottom = $this$removeLines.getRGB(x - 1, y + 1);
                int leftTop = $this$removeLines.getRGB(x - 1, y - 1);
                int rightTop = $this$removeLines.getRGB(x + 1, y - 1);
                if (!BufferedImageKt.isLine(left, right, bottom, top, leftBottom, rightTop, leftTop, rightBottom = $this$removeLines.getRGB(x + 1, y + 1))) continue;
                $this$removeLines.setRGB(x, y, Color.WHITE.getRGB());
            }
        }
    }

    private static final boolean isLine(int left, int right, int bottom, int top, int leftBottom, int rightTop, int leftTop, int rightBottom) {
        return ColorKt.isWhite(left) && ColorKt.isWhite(right) && ColorKt.isWhite(bottom) && ColorKt.isWhite(top) && ColorKt.isWhite(leftBottom) && ColorKt.isWhite(rightTop) || ColorKt.isWhite(leftTop) && ColorKt.isWhite(rightBottom) && ColorKt.isWhite(leftBottom) && ColorKt.isWhite(rightTop);
    }

    @NotNull
    public static final BufferedImage sharpen(@NotNull BufferedImage $this$sharpen, @NotNull Kernel kernel) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$sharpen, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        BufferedImage $this$sharpen_u24lambda_u2415 = bufferedImage = new BufferedImage($this$sharpen.getWidth(), $this$sharpen.getHeight(), 5);
        boolean bl = false;
        new ConvolveOp(kernel).filter($this$sharpen, $this$sharpen_u24lambda_u2415);
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage sharpen$default(BufferedImage bufferedImage, Kernel kernel, int n, Object object) {
        if ((n & 1) != 0) {
            kernel = KernelKt.getDEFAULT_KERNEL_3x3();
        }
        return BufferedImageKt.sharpen(bufferedImage, kernel);
    }

    @NotNull
    public static final BufferedImage denoise(@NotNull BufferedImage $this$denoise, @NotNull Kernel kernel) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$denoise, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        BufferedImage $this$denoise_u24lambda_u2416 = bufferedImage = new BufferedImage($this$denoise.getWidth(), $this$denoise.getHeight(), 5);
        boolean bl = false;
        new ConvolveOp(kernel).filter($this$denoise, $this$denoise_u24lambda_u2416);
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage denoise$default(BufferedImage bufferedImage, Kernel kernel, int n, Object object) {
        if ((n & 1) != 0) {
            kernel = KernelKt.getDENOISE_KERNEL_GAUSSIAN();
        }
        return BufferedImageKt.denoise(bufferedImage, kernel);
    }

    @NotNull
    public static final BufferedImage convolve(@NotNull BufferedImage $this$convolve, @NotNull Kernel kernel) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$convolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        BufferedImage $this$convolve_u24lambda_u2417 = bufferedImage = new BufferedImage($this$convolve.getWidth(), $this$convolve.getHeight(), 5);
        boolean bl = false;
        new ConvolveOp(kernel).filter($this$convolve, $this$convolve_u24lambda_u2417);
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage convolve$default(BufferedImage bufferedImage, Kernel kernel, int n, Object object) {
        if ((n & 1) != 0) {
            kernel = KernelKt.getEDGE_SOBEL_KERNEL();
        }
        return BufferedImageKt.convolve(bufferedImage, kernel);
    }

    @NotNull
    public static final BufferedImage inverse(@NotNull BufferedImage $this$inverse) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$inverse, (String)"<this>");
        BufferedImage $this$inverse_u24lambda_u2421 = bufferedImage = new BufferedImage($this$inverse.getWidth(), $this$inverse.getHeight(), $this$inverse.getType());
        boolean bl = false;
        int n = $this$inverse_u24lambda_u2421.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$inverse_u24lambda_u2421.getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl3 = false;
                Color $this$inverse_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418 = new Color($this$inverse.getRGB(x, y));
                boolean bl4 = false;
                $this$inverse_u24lambda_u2421.setRGB(x, y, ColorKt.invert($this$inverse_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418).getRGB());
            }
        }
        return bufferedImage;
    }

    @NotNull
    public static final Pair<Integer, BufferedImage> grayOstu(@NotNull BufferedImage $this$grayOstu) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$grayOstu, (String)"<this>");
        int[] histData = new int[256];
        BufferedImage it = bufferedImage = new BufferedImage($this$grayOstu.getWidth(), $this$grayOstu.getHeight(), $this$grayOstu.getType());
        boolean bl = false;
        int n = $this$grayOstu.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$grayOstu.getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl3 = false;
                Color $this$grayOstu_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422 = new Color($this$grayOstu.getRGB(x, y));
                boolean bl4 = false;
                int r = RangesKt.coerceAtMost((int)((int)((double)$this$grayOstu_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getRed() * 1.1 + (double)30)), (int)255);
                int g = RangesKt.coerceAtMost((int)((int)((double)$this$grayOstu_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getGreen() * 1.1 + (double)30)), (int)255);
                int b = RangesKt.coerceAtMost((int)((int)((double)$this$grayOstu_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.getBlue() * 1.1 + (double)30)), (int)255);
                int gray = (int)Math.pow(Math.pow(r, 2.2) * 0.2973 + Math.pow(g, 2.2) * 0.6274 + Math.pow(b, 2.2) * 0.0753, 0.45454545454545453);
                it.setRGB(x, y, new Color(gray, gray, gray).getRGB());
                int n4 = histData[gray];
                histData[gray] = n4 + 1;
            }
        }
        BufferedImage buff = bufferedImage;
        int total = $this$grayOstu.getWidth() * $this$grayOstu.getHeight();
        float sum = 0.0f;
        for (int t = 0; t < 256; ++t) {
            sum += (float)(t * histData[t]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int t = 0; t < 256; ++t) {
            float mF;
            float varBetween;
            if ((wB += histData[t]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(t * histData[t])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = t;
        }
        return TuplesKt.to((Object)threshold, (Object)buff);
    }

    public static final int ostu(@NotNull BufferedImage $this$ostu) {
        Intrinsics.checkNotNullParameter((Object)$this$ostu, (String)"<this>");
        int[] histData = new int[256];
        int n = $this$ostu.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = $this$ostu.getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl2 = false;
                int n4 = $this$ostu.getRGB(x, y) & 0xFF;
                int n5 = histData[n4];
                histData[n4] = n5 + 1;
            }
        }
        int total = $this$ostu.getWidth() * $this$ostu.getHeight();
        float sum = 0.0f;
        for (int t = 0; t < 256; ++t) {
            sum += (float)(t * histData[t]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int t = 0; t < 256; ++t) {
            float mF;
            float varBetween;
            if ((wB += histData[t]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(t * histData[t])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = t;
        }
        return threshold;
    }

    @NotNull
    public static final BufferedImage mirrorHeight(@NotNull BufferedImage $this$mirrorHeight) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$mirrorHeight, (String)"<this>");
        BufferedImage $this$mirrorHeight_u24lambda_u2431 = bufferedImage = new BufferedImage($this$mirrorHeight.getWidth(), $this$mirrorHeight.getHeight(), $this$mirrorHeight.getType());
        boolean bl = false;
        int n = $this$mirrorHeight_u24lambda_u2431.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$mirrorHeight_u24lambda_u2431.getHeight() / 2;
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl3 = false;
                Color $this$mirrorHeight_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = new Color($this$mirrorHeight.getRGB(x, y));
                boolean bl4 = false;
                int tmp = new Color($this$mirrorHeight.getRGB(x, $this$mirrorHeight_u24lambda_u2431.getHeight() - 1 - y)).getRGB();
                $this$mirrorHeight_u24lambda_u2431.setRGB(x, $this$mirrorHeight_u24lambda_u2431.getHeight() - y - 1, $this$mirrorHeight_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.getRGB());
                $this$mirrorHeight_u24lambda_u2431.setRGB(x, y, tmp);
            }
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage mirrorWidth(@NotNull BufferedImage $this$mirrorWidth) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$mirrorWidth, (String)"<this>");
        BufferedImage $this$mirrorWidth_u24lambda_u2435 = bufferedImage = new BufferedImage($this$mirrorWidth.getWidth(), $this$mirrorWidth.getHeight(), $this$mirrorWidth.getType());
        boolean bl = false;
        int n = $this$mirrorWidth_u24lambda_u2435.getHeight();
        for (int i = 0; i < n; ++i) {
            int y = i;
            boolean bl2 = false;
            int n2 = $this$mirrorWidth_u24lambda_u2435.getWidth() / 2;
            int n3 = 0;
            while (n3 < n2) {
                int x = n3++;
                boolean bl3 = false;
                Color $this$mirrorWidth_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432 = new Color($this$mirrorWidth.getRGB(x, y));
                boolean bl4 = false;
                int tmp = new Color($this$mirrorWidth.getRGB($this$mirrorWidth_u24lambda_u2435.getWidth() - 1 - x, y)).getRGB();
                $this$mirrorWidth_u24lambda_u2435.setRGB($this$mirrorWidth_u24lambda_u2435.getWidth() - 1 - x, y, $this$mirrorWidth_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.getRGB());
                $this$mirrorWidth_u24lambda_u2435.setRGB(x, y, tmp);
            }
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage mosaic(@NotNull BufferedImage $this$mosaic, int size) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$mosaic, (String)"<this>");
        BufferedImage $this$mosaic_u24lambda_u2436 = bufferedImage = new BufferedImage($this$mosaic.getWidth(), $this$mosaic.getHeight(), 2);
        boolean bl = false;
        Graphics g = $this$mosaic_u24lambda_u2436.getGraphics();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)($this$mosaic_u24lambda_u2436.getWidth() - size))), (int)size);
        int x = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
            while (true) {
                IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)($this$mosaic_u24lambda_u2436.getHeight() - size))), (int)size);
                int y = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && y <= n3 || n4 < 0 && n3 <= y) {
                    while (true) {
                        g.setColor(ColorKt.toColor($this$mosaic.getRGB(x, y)));
                        g.fillRect(x, y, size, size);
                        if (y == n3) break;
                        y += n4;
                    }
                }
                if (x == n) break;
                x += n2;
            }
        }
        g.drawImage($this$mosaic_u24lambda_u2436, 0, 0, null);
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage mosaic$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.mosaic(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage oilPaint(@NotNull BufferedImage $this$oilPaint, int size) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$oilPaint, (String)"<this>");
        BufferedImage $this$oilPaint_u24lambda_u2437 = bufferedImage = new BufferedImage($this$oilPaint.getWidth(), $this$oilPaint.getHeight(), 2);
        boolean bl = false;
        Graphics g = $this$oilPaint_u24lambda_u2437.getGraphics();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$oilPaint_u24lambda_u2437.getWidth())), (int)size);
        int x = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
            while (true) {
                IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$oilPaint_u24lambda_u2437.getHeight())), (int)size);
                int y = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && y <= n3 || n4 < 0 && n3 <= y) {
                    while (true) {
                        g.setColor(ColorKt.toColor($this$oilPaint.getRGB(x, y)));
                        int r = Random.Default.nextInt(20) + size;
                        g.fillOval(x, y, r, r);
                        if (y == n3) break;
                        y += n4;
                    }
                }
                if (x == n) break;
                x += n2;
            }
        }
        g.drawImage($this$oilPaint_u24lambda_u2437, 0, 0, null);
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage oilPaint$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        return BufferedImageKt.oilPaint(bufferedImage, n);
    }

    private static final BufferedImage erode(BufferedImage $this$erode, int kernelSize) {
        BufferedImage bufferedImage;
        BufferedImage $this$erode_u24lambda_u2441 = bufferedImage = new BufferedImage($this$erode.getWidth(), $this$erode.getHeight(), $this$erode.getType());
        boolean bl = false;
        int n = $this$erode_u24lambda_u2441.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$erode_u24lambda_u2441.getHeight();
            for (int j = 0; j < n2; ++j) {
                Color color;
                int y = j;
                boolean bl3 = false;
                int min = 0;
                min = 255;
                int n3 = x + kernelSize;
                for (int i2 = x; i2 < n3; ++i2) {
                    int n4 = y + kernelSize;
                    for (int j2 = y; j2 < n4; ++j2) {
                        boolean bl4 = 0 <= i2 ? i2 < $this$erode_u24lambda_u2441.getWidth() : false;
                        if (!bl4) continue;
                        boolean bl5 = 0 <= j2 ? j2 < $this$erode_u24lambda_u2441.getHeight() : false;
                        if (!bl5) continue;
                        min = RangesKt.coerceAtMost((int)($this$erode.getRGB(i2, j2) & 0xFF), (int)min);
                    }
                }
                Color j2 = color = Color.WHITE;
                int n5 = y;
                int n6 = x;
                BufferedImage bufferedImage2 = $this$erode_u24lambda_u2441;
                boolean bl6 = false;
                boolean bl7 = min == 255;
                Color color2 = bl7 ? color : null;
                if (color2 == null) {
                    color2 = Color.BLACK;
                }
                bufferedImage2.setRGB(n6, n5, color2.getRGB());
            }
        }
        return bufferedImage;
    }

    static /* synthetic */ BufferedImage erode$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.erode(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage erode(@NotNull BufferedImage $this$erode, int kernelSize, int iteration) {
        Intrinsics.checkNotNullParameter((Object)$this$erode, (String)"<this>");
        BufferedImage bufferedImage = null;
        bufferedImage = BufferedImageKt.erode($this$erode, kernelSize);
        int n = iteration - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            bufferedImage = BufferedImageKt.erode(bufferedImage, kernelSize);
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage erode$default(BufferedImage bufferedImage, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 3;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return BufferedImageKt.erode(bufferedImage, n, n2);
    }

    private static final BufferedImage dilate(BufferedImage $this$dilate, int kernelSize) {
        BufferedImage bufferedImage;
        BufferedImage $this$dilate_u24lambda_u2446 = bufferedImage = new BufferedImage($this$dilate.getWidth(), $this$dilate.getHeight(), $this$dilate.getType());
        boolean bl = false;
        int n = $this$dilate_u24lambda_u2446.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$dilate_u24lambda_u2446.getHeight();
            for (int j = 0; j < n2; ++j) {
                Color color;
                int y = j;
                boolean bl3 = false;
                int max = 0;
                int n3 = x + kernelSize;
                for (int i2 = x; i2 < n3; ++i2) {
                    int n4 = y + kernelSize;
                    for (int j2 = y; j2 < n4; ++j2) {
                        boolean bl4 = 0 <= i2 ? i2 < $this$dilate_u24lambda_u2446.getWidth() : false;
                        if (!bl4) continue;
                        boolean bl5 = 0 <= j2 ? j2 < $this$dilate_u24lambda_u2446.getHeight() : false;
                        if (!bl5) continue;
                        max = RangesKt.coerceAtLeast((int)($this$dilate.getRGB(i2, j2) & 0xFF), (int)max);
                    }
                }
                Color j2 = color = Color.WHITE;
                int n5 = y;
                int n6 = x;
                BufferedImage bufferedImage2 = $this$dilate_u24lambda_u2446;
                boolean bl6 = false;
                boolean bl7 = max == 255;
                Color color2 = bl7 ? color : null;
                if (color2 == null) {
                    color2 = Color.BLACK;
                }
                bufferedImage2.setRGB(n6, n5, color2.getRGB());
            }
        }
        return bufferedImage;
    }

    static /* synthetic */ BufferedImage dilate$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.dilate(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage dilate(@NotNull BufferedImage $this$dilate, int kernelSize, int iteration) {
        Intrinsics.checkNotNullParameter((Object)$this$dilate, (String)"<this>");
        BufferedImage bufferedImage = null;
        bufferedImage = BufferedImageKt.dilate($this$dilate, kernelSize);
        int n = iteration - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            bufferedImage = BufferedImageKt.dilate(bufferedImage, kernelSize);
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage dilate$default(BufferedImage bufferedImage, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 3;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return BufferedImageKt.dilate(bufferedImage, n, n2);
    }

    @NotNull
    public static final BufferedImage openOp(@NotNull BufferedImage $this$openOp, int kernelSize) {
        Intrinsics.checkNotNullParameter((Object)$this$openOp, (String)"<this>");
        return BufferedImageKt.dilate(BufferedImageKt.erode($this$openOp, kernelSize), kernelSize);
    }

    public static /* synthetic */ BufferedImage openOp$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.openOp(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage closeOp(@NotNull BufferedImage $this$closeOp, int kernelSize) {
        Intrinsics.checkNotNullParameter((Object)$this$closeOp, (String)"<this>");
        return BufferedImageKt.erode(BufferedImageKt.dilate($this$closeOp, kernelSize), kernelSize);
    }

    public static /* synthetic */ BufferedImage closeOp$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.closeOp(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage gradient(@NotNull BufferedImage $this$gradient, int kernelSize) {
        Intrinsics.checkNotNullParameter((Object)$this$gradient, (String)"<this>");
        return BufferedImageKt.minus(BufferedImageKt.dilate($this$gradient, kernelSize), BufferedImageKt.erode($this$gradient, kernelSize));
    }

    public static /* synthetic */ BufferedImage gradient$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.gradient(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage blackHat(@NotNull BufferedImage $this$blackHat, int kernelSize) {
        Intrinsics.checkNotNullParameter((Object)$this$blackHat, (String)"<this>");
        return BufferedImageKt.minus(BufferedImageKt.closeOp($this$blackHat, kernelSize), $this$blackHat);
    }

    public static /* synthetic */ BufferedImage blackHat$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.blackHat(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage topHat(@NotNull BufferedImage $this$topHat, int kernelSize) {
        Intrinsics.checkNotNullParameter((Object)$this$topHat, (String)"<this>");
        return BufferedImageKt.minus($this$topHat, BufferedImageKt.openOp($this$topHat, kernelSize));
    }

    public static /* synthetic */ BufferedImage topHat$default(BufferedImage bufferedImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return BufferedImageKt.topHat(bufferedImage, n);
    }

    @NotNull
    public static final BufferedImage minus(@NotNull BufferedImage $this$minus, @NotNull BufferedImage other) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BufferedImage $this$minus_u24lambda_u2450 = bufferedImage = new BufferedImage($this$minus.getWidth(), $this$minus.getHeight(), $this$minus.getType());
        boolean bl = false;
        int n = $this$minus_u24lambda_u2450.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$minus_u24lambda_u2450.getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl3 = false;
                Color color = ColorKt.minus(ColorKt.toColor($this$minus.getRGB(x, y)), ColorKt.toColor(other.getRGB(x, y)));
                $this$minus_u24lambda_u2450.setRGB(x, y, color.getRGB());
            }
        }
        return bufferedImage;
    }

    @NotNull
    public static final String toBinaryString(@NotNull BufferedImage $this$toBinaryString, boolean isBlackOne) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryString, (String)"<this>");
        StringBuilder $this$toBinaryString_u24lambda_u2454 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = $this$toBinaryString.getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl2 = false;
            int n2 = $this$toBinaryString.getHeight();
            for (int j = 0; j < n2; ++j) {
                int y = j;
                boolean bl3 = false;
                Integer n3 = 1;
                int n4 = ((Number)n3).intValue();
                StringBuilder stringBuilder2 = $this$toBinaryString_u24lambda_u2454;
                boolean bl4 = false;
                Integer n5 = Boolean.valueOf(ColorKt.isWhite($this$toBinaryString.getRGB(x, y)) ^ isBlackOne) != false ? n3 : null;
                stringBuilder2.append(n5 != null ? n5 : 0);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final BufferedImage toBufferImage(@NotNull File $this$toBufferImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toBufferImage, (String)"<this>");
        BufferedImage bufferedImage = ImageIO.read($this$toBufferImage);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage scale(@NotNull BufferedImage $this$scale, double scale, int interpolationType) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        int w2 = (int)((double)$this$scale.getWidth() * scale);
        int h2 = (int)((double)$this$scale.getHeight() * scale);
        if (!(1 <= w2 ? w2 < 4097 : false)) {
            boolean $i$a$-require-BufferedImageKt$scale$32 = false;
            String $i$a$-require-BufferedImageKt$scale$32 = "scaled width must in [1,4096]";
            throw new IllegalArgumentException($i$a$-require-BufferedImageKt$scale$32.toString());
        }
        if (!(1 <= h2 ? h2 < 4097 : false)) {
            boolean $i$a$-require-BufferedImageKt$scale$42 = false;
            String $i$a$-require-BufferedImageKt$scale$42 = "scaled height must in [1,4096]";
            throw new IllegalArgumentException($i$a$-require-BufferedImageKt$scale$42.toString());
        }
        BufferedImage after = new BufferedImage(w2, h2, $this$scale.getType());
        AffineTransform scaleInstance = AffineTransform.getScaleInstance(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(scaleInstance, interpolationType);
        scaleOp.filter($this$scale, after);
        return after;
    }

    public static /* synthetic */ BufferedImage scale$default(BufferedImage bufferedImage, double d, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return BufferedImageKt.scale(bufferedImage, d, n);
    }

    @NotNull
    public static final Regex getFILE_PATH() {
        return FILE_PATH;
    }

    public static final void setFILE_PATH(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        FILE_PATH = regex;
    }

    @Nullable
    public static final BufferedImage autoConvertToBufferImage(@NotNull String $this$autoConvertToBufferImage) {
        Object object;
        File file;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$autoConvertToBufferImage, (String)"<this>");
        if ($this$autoConvertToBufferImage.length() <= 1024 && FILE_PATH.containsMatchIn((CharSequence)(object2 = (CharSequence)$this$autoConvertToBufferImage)) && (file = FileKt.toFile((String)$this$autoConvertToBufferImage)).exists() && ArraysKt.contains((Object[])ImagesKt.getEXTENSION_IMAGE(), (Object)FileKt.realExtension((File)file))) {
            return BufferedImageKt.toBufferImage(file);
        }
        object2 = $this$autoConvertToBufferImage;
        try {
            CharSequence $this$autoConvertToBufferImage_u24lambda_u2457 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)FXExtKt.toBufferImage((Image)FXExtKt.base64Image((String)StringsKt.substringAfter$default((String)$this$autoConvertToBufferImage_u24lambda_u2457, (char)',', null, (int)2, null))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (BufferedImage)(Result.isFailure-impl((Object)object2) ? null : object2);
    }
}

