/*
 * Decompiled with CFR 0.152.
 */
package me.leon.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.config.ConfigKt;
import me.leon.ext.ByteArrayKt;
import me.leon.ext.ConcurrencyKt;
import me.leon.ext.ExceptionKt;
import me.leon.ext.FileKt;
import me.leon.ext.StringKt;
import me.leon.ext.crypto.CrcKt;
import me.leon.ext.crypto.HashCrackKt;
import me.leon.ext.crypto.PasswordHashingType;
import me.leon.ext.crypto.TypesKt;
import me.leon.hash.CRCKt;
import me.leon.hash.CrcParam;
import me.leon.hash.WindowsHashKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.Controller;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J&\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lme/leon/controller/DigestController;", "Ltornadofx/Controller;", "<init>", "()V", "dicts", "", "", "getDicts", "()Ljava/util/List;", "digest", "method", "data", "inputEncode", "singleLine", "", "passwordHashingCrack", "hashed", "digestFile", "path", "crack", "maskCrack", "mask", "dict", "app"})
@SourceDebugExtension(value={"SMAP\nDigestController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestController.kt\nme/leon/controller/DigestController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n3919#2:110\n4434#2,2:111\n1374#3:113\n1460#3,5:114\n1#4:119\n*S KotlinDebug\n*F\n+ 1 DigestController.kt\nme/leon/controller/DigestController\n*L\n16#1:110\n16#1:111,2\n17#1:113\n17#1:114,5\n*E\n"})
public final class DigestController
extends Controller {
    /*
     * WARNING - void declaration
     */
    private final List<String> getDicts() {
        List list;
        List list2;
        File[] fileArray = FileKt.toFile(ConfigKt.getDICT_DIR()).listFiles();
        if (fileArray != null) {
            void $this$flatMapTo$iv$iv;
            File it;
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".txt", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String digest(@NotNull String method, @NotNull String data, @NotNull String inputEncode, boolean singleLine) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)inputEncode, (String)"inputEncode");
        return (String)ExceptionKt.catch(DigestController::digest$lambda$0, () -> DigestController.digest$lambda$1(singleLine, data, this, method, inputEncode));
    }

    public static /* synthetic */ String digest$default(DigestController digestController, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "raw";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return digestController.digest(string, string2, string3, bl);
    }

    private final String digest(String method, String data, String inputEncode) {
        String string;
        if (StringsKt.startsWith$default((String)method, (String)"CRC", (boolean)false, (int)2, null)) {
            CrcParam crcParam = CRCKt.getCRC_MAPPING().get(StringsKt.substringAfter$default((String)method, (String)"CRC", null, (int)2, null));
            Intrinsics.checkNotNull((Object)crcParam);
            string = CRCKt.crc(crcParam).digest(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (Intrinsics.areEqual((Object)method, (Object)"Adler32")) {
            string = CrcKt.adler32(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (Intrinsics.areEqual((Object)method, (Object)"NTLM")) {
            string = WindowsHashKt.ntlmHash$default(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), null, 1, null);
        } else if (Intrinsics.areEqual((Object)method, (Object)"MD5_MIDDLE")) {
            String string2 = DigestsKt.hash2String$default(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), null, 1, null).substring(8, 24);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (Intrinsics.areEqual((Object)method, (Object)"LM")) {
            string = WindowsHashKt.lmHash(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (TypesKt.passwordHashingType(method) != null) {
            PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(method);
            Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
            string = passwordHashingType.hash(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else {
            string = DigestsKt.hash2String(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), method);
        }
        return string;
    }

    @NotNull
    public final String passwordHashingCrack(@NotNull String method, @NotNull String hashed) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
        return (String)ExceptionKt.catch(DigestController::passwordHashingCrack$lambda$0, () -> DigestController.passwordHashingCrack$lambda$1(method, hashed, this));
    }

    @NotNull
    public final String digestFile(@NotNull String method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (String)ExceptionKt.catch(DigestController::digestFile$lambda$0, () -> DigestController.digestFile$lambda$1(path, method));
    }

    @NotNull
    public final String crack(@NotNull String method, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (String)ExceptionKt.catch(DigestController::crack$lambda$0, () -> DigestController.crack$lambda$1(data, this, method));
    }

    @NotNull
    public final String maskCrack(@NotNull String method, @NotNull String hashed, @NotNull String mask, @NotNull String dict) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        return (String)ExceptionKt.catch(DigestController::maskCrack$lambda$0, () -> DigestController.maskCrack$lambda$1(hashed, this, method, mask, dict));
    }

    private static final String digest$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "digest error: " + it;
    }

    private static final String digest$lambda$1(boolean $singleLine, String $data, DigestController this$0, String $method, String $inputEncode) {
        return $singleLine ? StringKt.lineAction2String($data, (Function1<? super String, String>)((Function1)arg_0 -> DigestController.digest$lambda$1$0(this$0, $method, $inputEncode, arg_0))) : this$0.digest($method, $data, $inputEncode);
    }

    private static final String digest$lambda$1$0(DigestController this$0, String $method, String $inputEncode, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.digest($method, it, $inputEncode);
    }

    private static final String passwordHashingCrack$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "digest crack error: " + it;
    }

    private static final String passwordHashingCrack$lambda$1(String $method, String $hashed, DigestController this$0) {
        String string;
        Object v2;
        block3: {
            PasswordHashingType passwordHashingType = TypesKt.passwordHashingType($method);
            Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
            if (!(passwordHashingType.hash(new byte[0]).length() == $hashed.length())) {
                boolean bl = false;
                String string2 = "Wrong Method!!! ";
                throw new IllegalArgumentException(string2.toString());
            }
            Iterable iterable = this$0.getDicts();
            for (Object t : iterable) {
                String pw = (String)t;
                boolean bl = false;
                PasswordHashingType passwordHashingType2 = TypesKt.passwordHashingType($method);
                Intrinsics.checkNotNull((Object)((Object)passwordHashingType2));
                if (!passwordHashingType2.check(pw, $hashed)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        if ((string = (String)v2) == null) {
            string = "";
        }
        return string;
    }

    private static final String digestFile$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "digest file error: " + it;
    }

    private static final String digestFile$lambda$1(String $path, String $method) {
        String string;
        if (((CharSequence)$path).length() == 0) {
            string = "";
        } else if (StringsKt.startsWith$default((String)$method, (String)"CRC", (boolean)false, (int)2, null)) {
            File file = FileKt.toFile($path);
            CrcParam crcParam = CRCKt.getCRC_MAPPING().get(StringsKt.substringAfter$default((String)$method, (String)"CRC", null, (int)2, null));
            Intrinsics.checkNotNull((Object)crcParam);
            string = CRCKt.crc(file, crcParam);
        } else if (Intrinsics.areEqual((Object)$method, (Object)"Adler32")) {
            string = CrcKt.adler32File($path);
        } else {
            if (TypesKt.passwordHashingType($method) != null) {
                throw new IllegalStateException("not support".toString());
            }
            if (Intrinsics.areEqual((Object)$method, (Object)"MD5_MIDDLE")) {
                String string2 = DigestsKt.fileHash$default($path, null, 1, null).substring(8, 24);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = DigestsKt.fileHash($path, $method);
            }
        }
        return string;
    }

    private static final String crack$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "digest crack error: " + it;
    }

    private static final String crack$lambda$1(String $data, DigestController this$0, String $method) {
        String string = $data.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lower = string;
        if (!(this$0.digest($method, "", "raw").length() == $data.length())) {
            boolean bl = false;
            String string2 = "Wrong Method!!! ";
            throw new IllegalArgumentException(string2.toString());
        }
        System.out.println((Object)("crack " + $method + ' ' + $data));
        return ConcurrencyKt.findParallel((Collection)this$0.getDicts(), "", arg_0 -> DigestController.crack$lambda$1$1(this$0, $method, lower, arg_0));
    }

    private static final boolean crack$lambda$1$1(DigestController this$0, String $method, String $lower, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.digest($method, it, "raw"), (Object)$lower);
    }

    private static final String maskCrack$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "digest crack error: " + it;
    }

    private static final String maskCrack$lambda$1(String $hashed, DigestController this$0, String $method, String $mask, String $dict) {
        Function1 cond;
        String string = $hashed.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lower = string;
        Regex regex = StringKt.regexpParse(lower);
        if (!(regex != null || this$0.digest($method, "", "raw").length() == $hashed.length())) {
            boolean bl = false;
            String string2 = "Wrong Method!!! ";
            throw new IllegalArgumentException(string2.toString());
        }
        Function1 function1 = cond = regex != null ? arg_0 -> DigestController.maskCrack$lambda$1$1(regex, this$0, $method, arg_0) : (StringsKt.startsWith$default((String)$method, (String)"SpringSecurity", (boolean)false, (int)2, null) ? arg_0 -> DigestController.maskCrack$lambda$1$2($method, lower, arg_0) : arg_0 -> DigestController.maskCrack$lambda$1$3(this$0, $method, lower, arg_0));
        String string3 = HashCrackKt.maskParallel($mask, $dict, (Function1<? super String, Boolean>)cond);
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private static final boolean maskCrack$lambda$1$1(Regex $regex, DigestController this$0, String $method, String pw) {
        Intrinsics.checkNotNullParameter((Object)pw, (String)"pw");
        return $regex.containsMatchIn((CharSequence)this$0.digest($method, pw, "raw"));
    }

    private static final boolean maskCrack$lambda$1$2(String $method, String $lower, String pw) {
        Intrinsics.checkNotNullParameter((Object)pw, (String)"pw");
        PasswordHashingType passwordHashingType = TypesKt.passwordHashingType($method);
        Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
        return passwordHashingType.check(pw, $lower);
    }

    private static final boolean maskCrack$lambda$1$3(DigestController this$0, String $method, String $lower, String pw) {
        Intrinsics.checkNotNullParameter((Object)pw, (String)"pw");
        return Intrinsics.areEqual((Object)this$0.digest($method, pw, "raw"), (Object)$lower);
    }
}

