/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf.rsa;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.leon.ConstantsKt;
import me.leon.ctf.rsa.FactorsKt;
import me.leon.ctf.rsa.RsaSolverKt;
import me.leon.ext.ConcurrencyKt;
import me.leon.ext.math.BigIntegerKt;
import me.leon.ext.math.DivideResult;
import me.leon.ext.math.KgcdKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019J\u001c\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010\u001c\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010\u001d\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010\u001f\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010 \u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001a\u0010!\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019J\u001c\u0010\"\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J \u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002J \u0010&\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001aJ \u0010+\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u001c\u0010,\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010-\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001a\u0010.\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019J(\u0010.\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lme/leon/ctf/rsa/RsaSolver;", "", "<init>", "()V", "modeNECP", "", "", "modeNEC", "modeDEC_P_NEXT_Q", "modeN2EC", "modeNCD", "modePQREC", "modePQRnEC", "modeN2E2C2", "modeN2EC2", "modeNE2C2", "modeEC", "modeNECPhi", "modePQEC", "modePQEC2", "modeDpDq", "modeDp", "modeBroadcastN3C3", "solve", "params", "", "Ljava/math/BigInteger;", "solveDEC", "solvePQREC", "solveNCD", "solveBroadCast", "solveN2EC2", "solveNE2C2", "solveN2E2C2", "solveNEC", "n", "e", "c", "defaultNec", "ammAlg", "", "x", "p", "smallE", "dpLeak", "solveDpDq", "solvePQEC", "q", "app"})
@SourceDebugExtension(value={"SMAP\nRsaSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsaSolver.kt\nme/leon/ctf/rsa/RsaSolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,441:1\n1#2:442\n1#2:466\n774#3:443\n865#3,2:444\n1563#3:446\n1634#3,3:447\n774#3:450\n865#3,2:451\n774#3:453\n865#3,2:454\n1617#3,9:456\n1869#3:465\n1870#3:467\n1626#3:468\n2783#3,7:469\n1788#3,4:476\n774#3:480\n865#3,2:481\n1563#3:483\n1634#3,3:484\n295#3,2:487\n1491#3:489\n1516#3,3:490\n1519#3,3:500\n382#4,7:493\n*S KotlinDebug\n*F\n+ 1 RsaSolver.kt\nme/leon/ctf/rsa/RsaSolver\n*L\n147#1:466\n106#1:443\n106#1:444,2\n107#1:446\n107#1:447,3\n108#1:450\n108#1:451,2\n146#1:453\n146#1:454,2\n147#1:456,9\n147#1:465\n147#1:467\n147#1:468\n148#1:469,7\n149#1:476,4\n152#1:480\n152#1:481,2\n153#1:483\n153#1:484,3\n220#1:487,2\n250#1:489\n250#1:490,3\n250#1:500,3\n250#1:493,7\n*E\n"})
public final class RsaSolver {
    @NotNull
    public static final RsaSolver INSTANCE = new RsaSolver();
    @NotNull
    private static final List<String> modeNECP;
    @NotNull
    private static final List<String> modeNEC;
    @NotNull
    private static final List<String> modeDEC_P_NEXT_Q;
    @NotNull
    private static final List<String> modeN2EC;
    @NotNull
    private static final List<String> modeNCD;
    @NotNull
    private static final List<String> modePQREC;
    @NotNull
    private static final List<String> modePQRnEC;
    @NotNull
    private static final List<String> modeN2E2C2;
    @NotNull
    private static final List<String> modeN2EC2;
    @NotNull
    private static final List<String> modeNE2C2;
    @NotNull
    private static final List<String> modeEC;
    @NotNull
    private static final List<String> modeNECPhi;
    @NotNull
    private static final List<String> modePQEC;
    @NotNull
    private static final List<String> modePQEC2;
    @NotNull
    private static final List<String> modeDpDq;
    @NotNull
    private static final List<String> modeDp;
    @NotNull
    private static final List<String> modeBroadcastN3C3;

    private RsaSolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String solve(@NotNull Map<String, BigInteger> params) {
        String string;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        if (RsaSolverKt.containKeys(params, modeNECPhi)) {
            String string2;
            BigInteger bigInteger = params.get("c");
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = params.get("e");
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger3 = params.get("phi");
            Intrinsics.checkNotNull((Object)bigInteger3);
            BigInteger bigInteger4 = BigIntegerKt.invert(bigInteger2, bigInteger3);
            BigInteger bigInteger5 = params.get("n");
            Intrinsics.checkNotNull((Object)bigInteger5);
            String it = string2 = BigIntegerKt.decrypt2String(bigInteger, bigInteger4, bigInteger5);
            boolean bl = false;
            System.out.println((Object)"solve N E C Phi ");
            string = string2;
        } else if (RsaSolverKt.containKeys(params, modeBroadcastN3C3)) {
            string = this.solveBroadCast(params);
        } else if (RsaSolverKt.containKeys(params, modeDp) && params.get("dq") == null) {
            string = this.dpLeak(params);
        } else if (RsaSolverKt.containKeys(params, modeN2EC)) {
            void $this$solve_u24lambda_u241;
            Map<String, BigInteger> map;
            Map<String, BigInteger> it = map = params;
            RsaSolver rsaSolver = this;
            boolean bl = false;
            Object v = $this$solve_u24lambda_u241.get("c");
            Intrinsics.checkNotNull(v);
            $this$solve_u24lambda_u241.put("c1", v);
            Object v2 = $this$solve_u24lambda_u241.get("c");
            Intrinsics.checkNotNull(v2);
            $this$solve_u24lambda_u241.put("c2", v2);
            string = rsaSolver.solveN2EC2(map);
        } else if (RsaSolverKt.containKeys(params, modeDpDq)) {
            string = this.solveDpDq(params);
        } else if (RsaSolverKt.containKeys(params, modeDEC_P_NEXT_Q)) {
            string = this.solveDEC(params);
        } else if (RsaSolverKt.containKeys(params, modePQREC) || RsaSolverKt.containKeys(params, modePQRnEC)) {
            string = this.solvePQREC(params);
        } else if (RsaSolverKt.containKeys(params, modeNCD)) {
            string = this.solveNCD(params);
        } else if (RsaSolverKt.containKeys(params, modeN2E2C2)) {
            string = this.solveN2E2C2(params);
        } else if (RsaSolverKt.containKeys(params, modePQEC2)) {
            void $this$solve_u24lambda_u242;
            Map<String, BigInteger> map;
            Map<String, BigInteger> $this$solve_u24lambda_u241 = map = params;
            RsaSolver rsaSolver = this;
            boolean bl = false;
            BigInteger bigInteger = params.get("p1");
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger6 = params.get("q1");
            Intrinsics.checkNotNull((Object)bigInteger6);
            BigInteger bigInteger7 = bigInteger.multiply(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"multiply(...)");
            $this$solve_u24lambda_u242.put("n1", bigInteger7);
            BigInteger bigInteger8 = params.get("p2");
            Intrinsics.checkNotNull((Object)bigInteger8);
            BigInteger bigInteger9 = params.get("q2");
            Intrinsics.checkNotNull((Object)bigInteger9);
            BigInteger bigInteger10 = bigInteger8.multiply(bigInteger9);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"multiply(...)");
            $this$solve_u24lambda_u242.put("n2", bigInteger10);
            string = rsaSolver.solveN2E2C2(map);
        } else if (RsaSolverKt.containKeys(params, modeNE2C2)) {
            string = this.solveNE2C2(params);
        } else if (RsaSolverKt.containKeys(params, modeN2EC2)) {
            string = this.solveN2EC2(params);
        } else if (RsaSolverKt.containKeys(params, modePQEC)) {
            string = this.solvePQEC(params);
        } else if (RsaSolverKt.containKeys(params, modeNECP)) {
            string = this.solvePQEC(params);
        } else if (RsaSolverKt.containKeys(params, modeNEC)) {
            string = this.solveNEC(params);
        } else if (RsaSolverKt.containKeys(params, modeEC) && Intrinsics.areEqual((Object)params.get("e"), (Object)BigInteger.ONE)) {
            BigInteger bigInteger = params.get("c");
            Intrinsics.checkNotNull((Object)bigInteger);
            string = BigIntegerKt.n2s(bigInteger);
        } else {
            throw new IllegalStateException("wrong parameters!!!".toString());
        }
        return string;
    }

    private final String solveDEC(Map<String, BigInteger> params) {
        int kEnd;
        System.out.println((Object)"solve D E C nbits");
        BigInteger bigInteger = params.get("d");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger d = bigInteger;
        BigInteger bigInteger2 = params.get("e");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger2;
        BigInteger bigInteger3 = params.get("nbits");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        int nLen = bigInteger3.intValue();
        BigInteger bigInteger4 = e.multiply(d);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
        BigInteger bigInteger5 = bigInteger4;
        BigInteger bigInteger6 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"ONE");
        BigInteger bigInteger7 = bigInteger5.subtract(bigInteger6);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"subtract(...)");
        BigInteger kPhi = bigInteger7;
        int kBits = kPhi.bitLength() - nLen;
        int kStart = (int)Math.pow(2.0, (double)kBits - 1.0);
        int k = kEnd = (int)Math.pow(2.0, kBits);
        if (kStart <= k) {
            while (true) {
                BigInteger bigInteger8 = BigInteger.valueOf(k);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
                BigInteger bigInteger9 = kPhi.remainder(bigInteger8);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"remainder(...)");
                if (Intrinsics.areEqual((Object)bigInteger9, (Object)BigInteger.ZERO)) {
                    BigInteger phi;
                    BigInteger bigInteger10 = BigInteger.valueOf(k);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"valueOf(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)kPhi.divide(bigInteger10), (String)"divide(...)");
                    BigInteger p = BigIntegerKt.preProbablePrime((BigInteger)ArraysKt.first((Object[])BigIntegerKt.root(phi, 2)));
                    BigInteger q = p.nextProbablePrime();
                    Intrinsics.checkNotNull((Object)q);
                    if (Intrinsics.areEqual((Object)BigIntegerKt.phi(p, q), (Object)phi)) {
                        System.out.println((Object)("got p=" + p + " q =" + q));
                        params.put("p", p);
                        params.put("q", q);
                        return this.solvePQEC(params);
                    }
                }
                if (k == kStart) break;
                --k;
            }
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private final String solvePQREC(Map<String, BigInteger> params) {
        String string;
        BigInteger d;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        System.out.println((Object)"solve P Q R E C");
        BigInteger bigInteger = params.get("e");
        if (bigInteger == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        BigInteger e = bigInteger;
        BigInteger bigInteger2 = params.get("c");
        if (bigInteger2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        BigInteger c = bigInteger2;
        Iterable iterable = params.keySet();
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it, (String)"r", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)it, (Object)"p") || Intrinsics.areEqual((Object)it, (Object)"q"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BigInteger bigInteger3 = params.get(it);
            Intrinsics.checkNotNull((Object)bigInteger3);
            collection.add(bigInteger3);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BigInteger)element$iv$iv;
            boolean bl = false;
            if (!((BigInteger)it).isProbablePrime(100)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List factors = (List)destination$iv$iv;
        BigInteger n = BigIntegerKt.product(factors);
        BigInteger phi = BigIntegerKt.phi(factors);
        BigInteger gcd = e.gcd(phi);
        if (Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
            System.out.println((Object)("e phi are co-prime " + phi));
            d = BigIntegerKt.invert(e, phi);
            String it2 = $i$f$filterTo = BigIntegerKt.decrypt2String(c, d, n);
            boolean bl = false;
            System.out.println((Object)it2);
            string = $i$f$filterTo;
        } else {
            System.out.println((Object)("e phi are not are co-prime  " + gcd));
            Intrinsics.checkNotNull((Object)gcd);
            BigInteger bigInteger4 = e.divide(gcd);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
            d = BigIntegerKt.invert(bigInteger4, phi);
            BigInteger m = c.modPow(d, n);
            String result = "";
            for (int i = 0; i < 1000001; ++i) {
                Intrinsics.checkNotNull((Object)m);
                BigInteger bigInteger5 = BigInteger.valueOf(i);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                BigInteger bigInteger6 = n.multiply(bigInteger5);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"multiply(...)");
                BigInteger bigInteger7 = m.add(bigInteger6);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"add(...)");
                Object[] root = BigIntegerKt.root(bigInteger7, gcd.intValue());
                if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])root), (Object)BigInteger.ZERO)) continue;
                result = BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])root));
                System.out.println((Object)("times " + i + ' ' + ArraysKt.first((Object[])root) + ' ' + result));
                break;
            }
            string = result;
        }
        return string;
    }

    private final String solveNCD(Map<String, BigInteger> params) {
        System.out.println((Object)"solve N C D ");
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("d");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger d = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        return BigIntegerKt.decrypt2String(c, d, n);
    }

    /*
     * WARNING - void declaration
     */
    private final String solveBroadCast(Map<String, BigInteger> params) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        int n;
        void $this$mapNotNullTo$iv$iv;
        Object it2;
        Iterable $this$filterTo$iv$iv2;
        System.out.println((Object)"solve broadcast");
        Iterable $this$filter$iv2 = params.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it2, (String)"n", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it2 = $this$forEach$iv$iv$iv.iterator();
        while (it2.hasNext()) {
            BigInteger it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it2.next();
            boolean bl = false;
            String it3 = (String)element$iv$iv;
            boolean bl2 = false;
            if (params.get(it3) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            BigInteger $i$f$mapNotNullTo2 = (BigInteger)iterator$iv.next();
            BigInteger acc = (BigInteger)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)s), (String)"multiply(...)");
        }
        BigInteger modular = (BigInteger)accumulator$iv;
        Iterable $this$count$iv = params.keySet();
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it4 = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it4, (String)"n", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int e = n;
        Iterable $i$f$count22 = params.keySet();
        boolean $i$f$filter2 = false;
        void s = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"n", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append('c');
            String string = it.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            BigInteger bigInteger = params.get(stringBuilder.append(string).toString());
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = params.get(it);
            Intrinsics.checkNotNull((Object)bigInteger2);
            collection.add(new DivideResult(bigInteger, bigInteger2));
        }
        List divides = (List)destination$iv$iv2;
        BigInteger me = KgcdKt.crt(divides);
        BigInteger bigInteger = me.remainder(modular);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"remainder(...)");
        BigInteger cx = bigInteger;
        for (int i = e - 1; i < 101; ++i) {
            Object[] result = BigIntegerKt.root(cx, i);
            if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])result), (Object)BigInteger.ZERO)) continue;
            System.out.println((Object)(i + " got result " + ArraysKt.first((Object[])result)));
            return BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])result));
        }
        return "no solution!!!";
    }

    private final String solveN2EC2(Map<String, BigInteger> params) {
        System.out.println((Object)"solve N2 E C2");
        BigInteger bigInteger = params.get("e");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger;
        BigInteger bigInteger2 = params.get("n1");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n1 = bigInteger2;
        BigInteger bigInteger3 = params.get("c1");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c1 = bigInteger3;
        BigInteger bigInteger4 = params.get("c2");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c2 = bigInteger4;
        BigInteger bigInteger5 = params.get("n2");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n2 = bigInteger5;
        BigInteger p = n1.gcd(n2);
        Intrinsics.checkNotNull((Object)p);
        BigInteger bigInteger6 = n1.divide(p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"divide(...)");
        BigInteger q1 = bigInteger6;
        BigInteger bigInteger7 = n2.divide(p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"divide(...)");
        BigInteger q2 = bigInteger7;
        System.out.println((Object)("gcd: " + e.gcd(BigIntegerKt.phi(p, q1))));
        BigInteger d2 = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q2));
        BigInteger c = c2.modPow(d2, n2);
        BigInteger d1 = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q1));
        Intrinsics.checkNotNull((Object)c);
        String decrypt = BigIntegerKt.decrypt2String(c, d1, n1);
        boolean matches = ConstantsKt.getREG_NUMBER().matches((CharSequence)decrypt);
        return matches ? BigIntegerKt.decrypt2String(c1, d1, n1) : decrypt;
    }

    private final String solveNE2C2(Map<String, BigInteger> params) {
        Map<String, BigInteger> map = params;
        String string = "n1";
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        BigInteger bigInteger2 = bigInteger;
        map.put(string, bigInteger2);
        map = params;
        string = "n2";
        BigInteger bigInteger3 = params.get("n");
        if (bigInteger3 == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        bigInteger2 = bigInteger3;
        map.put(string, bigInteger2);
        return this.solveN2E2C2(params);
    }

    @NotNull
    public final String solveN2E2C2(@NotNull Map<String, BigInteger> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        System.out.println((Object)"solve N2 E2 C2");
        BigInteger bigInteger = params.get("n1");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n1 = bigInteger;
        BigInteger bigInteger2 = params.get("n2");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n2 = bigInteger2;
        BigInteger bigInteger3 = params.get("e1");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e1 = bigInteger3;
        BigInteger bigInteger4 = params.get("e2");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e2 = bigInteger4;
        BigInteger bigInteger5 = params.get("c1");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c1 = bigInteger5;
        BigInteger bigInteger6 = params.get("c2");
        if (bigInteger6 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c2 = bigInteger6;
        BigInteger[] bigIntegerArray = BigIntegerKt.gcdExt(e1, e2);
        BigInteger s1 = bigIntegerArray[1];
        BigInteger s2 = bigIntegerArray[2];
        BigInteger bigInteger7 = c1.modPow(s1, n1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"modPow(...)");
        BigInteger bigInteger8 = bigInteger7;
        BigInteger bigInteger9 = c2.modPow(s2, n2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"modPow(...)");
        BigInteger bigInteger10 = bigInteger8.multiply(bigInteger9);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"multiply(...)");
        BigInteger bigInteger11 = bigInteger10.remainder(n1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"remainder(...)");
        return BigIntegerKt.n2s(bigInteger11);
    }

    private final String solveNEC(Map<String, BigInteger> params) {
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("e");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        return this.solveNEC(n, e, c);
    }

    /*
     * WARNING - void declaration
     */
    private final String solveNEC(BigInteger n, BigInteger e, BigInteger c) {
        String string;
        System.out.println((Object)"solve N E C");
        if (Intrinsics.areEqual((Object)e, (Object)BigInteger.ONE)) {
            String string2;
            String it = string2 = BigIntegerKt.n2s(c);
            boolean bl = false;
            System.out.println((Object)"e = 1");
            string = string2;
        } else if (n.isProbablePrime(100)) {
            System.out.println((Object)"nec n is prime");
            BigInteger it = n;
            BigInteger bigInteger = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
            BigInteger bigInteger2 = it.subtract(bigInteger);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"subtract(...)");
            BigInteger phi = bigInteger2;
            if (Intrinsics.areEqual((Object)e.gcd(phi), (Object)e)) {
                Object v3;
                block14: {
                    void $this$firstOrNull$iv;
                    Iterable bl = this.ammAlg(c, e, n);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BigInteger it2 = (BigInteger)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence = BigIntegerKt.n2s(it2);
                        if (!(!ConstantsKt.getREG_NON_PRINTABLE().containsMatchIn(charSequence))) continue;
                        v3 = element$iv;
                        break block14;
                    }
                    v3 = null;
                }
                it = v3;
                string = it != null ? BigIntegerKt.n2s(it) : null;
                if (string == null) {
                    string = "";
                }
            } else {
                BigInteger bigInteger3 = c.modPow(BigIntegerKt.invert(e, phi), n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"modPow(...)");
                string = BigIntegerKt.n2s(bigInteger3);
            }
        } else {
            BigInteger bigInteger = BigInteger.valueOf(6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            if (e.compareTo(bigInteger) < 0) {
                string = this.smallE(n, c, e);
            } else if (e.bitLength() > 100) {
                BigInteger $this$solveNEC_u24lambda_u242 = BigIntegerKt.wiener(e, n);
                boolean bl = false;
                System.out.println((Object)"wiener attack");
                BigInteger bigInteger4 = $this$solveNEC_u24lambda_u242;
                string = bigInteger4 == null ? "wiener failed" : BigIntegerKt.decrypt2String(c, bigInteger4, n);
            } else if (!Intrinsics.areEqual((Object)n.gcd(c), (Object)BigInteger.ONE)) {
                System.out.println((Object)"n c are not co-prime");
                BigInteger p = n.gcd(c);
                Intrinsics.checkNotNull((Object)p);
                BigInteger bigInteger5 = n.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"divide(...)");
                BigInteger q = bigInteger5;
                BigInteger phi = BigIntegerKt.phi(p, q);
                BigInteger bigInteger6 = c.modPow(BigIntegerKt.invert(e, phi), n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"modPow(...)");
                BigInteger bigInteger7 = bigInteger6;
                BigInteger bigInteger8 = bigInteger7.divide(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"divide(...)");
                string = BigIntegerKt.n2s(bigInteger8);
            } else {
                string = this.defaultNec(n, e, c);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String defaultNec(BigInteger n, BigInteger e, BigInteger c) {
        Object object;
        Map map;
        BigInteger $this$groupByTo$iv$iv;
        List<BigInteger> factors;
        System.out.println((Object)"factor: start");
        List<BigInteger> it = factors = FactorsKt.factor(n);
        boolean bl = false;
        Iterable $this$groupBy$iv = it;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv = iterator.next();
            BigInteger it2 = (BigInteger)element$iv$iv;
            boolean bl2 = false;
            BigInteger key$iv$iv = it2;
            map = destination$iv$iv;
            BigInteger key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        if (destination$iv$iv.size() == 1) {
            System.out.println((Object)("euler solve " + CollectionsKt.first(it) + " ^ " + it.size()));
            BigInteger phi = BigIntegerKt.eulerPhi((BigInteger)CollectionsKt.first(it), it.size());
            $this$groupByTo$iv$iv = BigIntegerKt.invert(e, phi);
            Object it3 = $this$groupByTo$iv$iv;
            boolean bl4 = false;
            System.out.println(it3);
            BigInteger d = $this$groupByTo$iv$iv;
            BigInteger propN = BigIntegerKt.propN(it, n);
            Object it4 = it3 = BigIntegerKt.decrypt2String(c, d, propN);
            boolean bl5 = false;
            System.out.println(it4);
            object = it3;
        } else if (it.size() >= 2) {
            BigInteger d;
            Object it5;
            System.out.println(it);
            List<BigInteger> properFactors = BigIntegerKt.phiMutualPrime(it, e);
            BigInteger phi = BigIntegerKt.phi(properFactors);
            BigInteger gcd = e.gcd(phi);
            System.out.println((Object)("" + properFactors + ' ' + phi + ' ' + gcd));
            if (Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
                System.out.println((Object)("e phi are co-prime " + phi));
                BigInteger it4 = BigIntegerKt.invert(e, phi);
                it5 = it4;
                boolean bl6 = false;
                System.out.println(it5);
                d = it4;
                BigInteger propN = BigIntegerKt.product(properFactors);
                Object it6 = it5 = BigIntegerKt.decrypt2String(c, d, propN);
                boolean bl7 = false;
                System.out.println(it6);
                object = it5;
            } else {
                System.out.println((Object)("e phi are not are co-prime  " + gcd));
                BigInteger propN = e;
                Intrinsics.checkNotNull((Object)gcd);
                BigInteger bigInteger = propN.divide(gcd);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
                propN = BigIntegerKt.invert(bigInteger, phi);
                it5 = propN;
                boolean bl8 = false;
                System.out.println(it5);
                d = propN;
                BigInteger m = c.modPow(d, n);
                String result = "";
                for (int i = 0; i < 1000001; ++i) {
                    Intrinsics.checkNotNull((Object)m);
                    BigInteger bigInteger2 = m;
                    BigInteger bigInteger3 = n;
                    Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(i), (String)"valueOf(...)");
                    BigInteger bigInteger4 = bigInteger3.multiply((BigInteger)((Object)map));
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
                    bigInteger3 = bigInteger4;
                    BigInteger bigInteger5 = bigInteger2.add(bigInteger3);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"add(...)");
                    Object[] root = BigIntegerKt.root(bigInteger5, gcd.intValue());
                    if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])root), (Object)BigInteger.ZERO)) continue;
                    result = BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])root));
                    System.out.println((Object)("times " + i + ' ' + ArraysKt.first((Object[])root) + ' ' + result));
                    break;
                }
                object = result;
            }
        } else {
            object = "no solution";
        }
        return object;
    }

    @NotNull
    public final Set<BigInteger> ammAlg(@NotNull BigInteger x, @NotNull BigInteger e, @NotNull BigInteger p) {
        BigInteger d;
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        BigInteger bigInteger2 = p;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"subtract(...)");
        BigInteger y = BigIntegerKt.random$default(bigInteger4, null, 1, null);
        while (true) {
            bigInteger2 = p;
            BigInteger bigInteger5 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ONE");
            BigInteger bigInteger6 = bigInteger2.subtract(bigInteger5);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"subtract(...)");
            BigInteger bigInteger7 = bigInteger6.divide(e);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"divide(...)");
            if (!Intrinsics.areEqual((Object)y.modPow(bigInteger7, p), (Object)BigInteger.ONE)) break;
            bigInteger2 = p;
            BigInteger bigInteger8 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"ONE");
            BigInteger bigInteger9 = bigInteger2.subtract(bigInteger8);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"subtract(...)");
            y = BigIntegerKt.random$default(bigInteger9, null, 1, null);
        }
        int t = 1;
        while (true) {
            BigInteger bigInteger10 = p.remainder(e);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"remainder(...)");
            if (!Intrinsics.areEqual((Object)bigInteger10, (Object)BigInteger.ZERO)) break;
            ++t;
        }
        BigInteger bigInteger11 = p;
        BigInteger bigInteger12 = e.pow(t);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"pow(...)");
        BigInteger bigInteger13 = bigInteger11.divide(bigInteger12);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger13, (String)"divide(...)");
        BigInteger s = bigInteger13;
        BigInteger k = BigInteger.ONE;
        while (true) {
            BigInteger bigInteger14 = s;
            bigInteger = k;
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger15 = bigInteger14.multiply(bigInteger);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger15, (String)"multiply(...)");
            bigInteger14 = bigInteger15;
            BigInteger bigInteger16 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger16, (String)"ONE");
            BigInteger bigInteger17 = bigInteger14.add(bigInteger16);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger17, (String)"add(...)");
            BigInteger bigInteger18 = bigInteger17.remainder(e);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger18, (String)"remainder(...)");
            if (Intrinsics.areEqual((Object)bigInteger18, (Object)BigInteger.ZERO)) break;
            bigInteger14 = k;
            Intrinsics.checkNotNull((Object)bigInteger14);
            BigInteger bigInteger19 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger19, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger14.add(bigInteger19), (String)"add(...)");
        }
        bigInteger = s;
        BigInteger bigInteger20 = k;
        Intrinsics.checkNotNull((Object)bigInteger20);
        BigInteger bigInteger21 = bigInteger.multiply(bigInteger20);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger21, (String)"multiply(...)");
        bigInteger = bigInteger21;
        BigInteger bigInteger22 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger22, (String)"ONE");
        BigInteger bigInteger23 = bigInteger.add(bigInteger22);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger23, (String)"add(...)");
        BigInteger bigInteger24 = bigInteger23.divide(e);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger24, (String)"divide(...)");
        BigInteger alpha = bigInteger24;
        BigInteger bigInteger25 = e.pow(t - 1);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger25, (String)"pow(...)");
        BigInteger bigInteger26 = bigInteger25.multiply(s);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger26, (String)"multiply(...)");
        BigInteger bigInteger27 = bigInteger26;
        BigInteger a = y.modPow(bigInteger27, p);
        BigInteger bigInteger28 = e.multiply(alpha);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger28, (String)"multiply(...)");
        BigInteger bigInteger29 = bigInteger28;
        BigInteger bigInteger30 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger30, (String)"ONE");
        BigInteger bigInteger31 = bigInteger29.subtract(bigInteger30);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger31, (String)"subtract(...)");
        BigInteger b = x.modPow(bigInteger31, p);
        BigInteger c = y.modPow(s, p);
        BigInteger h = BigInteger.ONE;
        int n = t;
        for (int i = 1; i < n; ++i) {
            d = b.modPow(e.pow(t - 1 - i), p);
            BigInteger j = Intrinsics.areEqual((Object)d, (Object)BigInteger.ONE) ? BigInteger.ZERO : new BigDecimal(String.valueOf(-Math.log(d.doubleValue()) / Math.log(a.doubleValue()))).toBigInteger();
            BigInteger bigInteger32 = b;
            Intrinsics.checkNotNull((Object)bigInteger32);
            BigInteger bigInteger33 = c.modPow(e, p).modPow(j, p);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger33, (String)"modPow(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger32.multiply(bigInteger33), (String)"multiply(...)");
            bigInteger32 = h;
            Intrinsics.checkNotNull((Object)bigInteger32);
            BigInteger bigInteger34 = c.modPow(j, p);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger34, (String)"modPow(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger32.multiply(bigInteger34), (String)"multiply(...)");
            c = c.modPow(e, p);
        }
        d = alpha;
        BigInteger bigInteger35 = h;
        Intrinsics.checkNotNull((Object)bigInteger35);
        BigInteger bigInteger36 = d.multiply(bigInteger35);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger36, (String)"multiply(...)");
        BigInteger bigInteger37 = x.modPow(bigInteger36, p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger37, (String)"modPow(...)");
        BigInteger bigInteger38 = bigInteger37.remainder(p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger38, (String)"remainder(...)");
        BigInteger root = bigInteger38;
        Set roots = new LinkedHashSet();
        int i = 1;
        int n2 = e.intValue();
        if (i <= n2) {
            while (true) {
                BigInteger mp2;
                BigInteger bigInteger39 = root;
                BigInteger bigInteger40 = BigInteger.valueOf(i);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger40, (String)"valueOf(...)");
                BigInteger bigInteger41 = a.modPow(bigInteger40, p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger41, (String)"modPow(...)");
                BigInteger bigInteger42 = bigInteger39.multiply(bigInteger41);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger42, (String)"multiply(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger42.remainder(p), (String)"remainder(...)");
                if (Intrinsics.areEqual((Object)mp2.modPow(e, p), (Object)x)) {
                    roots.add(mp2);
                }
                if (i == n2) break;
                ++i;
            }
        }
        return roots;
    }

    private final String smallE(BigInteger n, BigInteger c, BigInteger e) {
        int exp = e.intValue();
        System.out.println((Object)("small e= " + exp));
        for (int k = 0; k < 10001; ++k) {
            BigInteger bigInteger = BigInteger.valueOf(k);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            BigInteger bigInteger2 = bigInteger.multiply(n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"multiply(...)");
            BigInteger bigInteger3 = bigInteger2.add(c);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
            Object[] m = BigIntegerKt.root(bigInteger3, exp);
            if (!Intrinsics.areEqual((Object)m[1], (Object)BigInteger.ZERO)) continue;
            return BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])m));
        }
        return this.defaultNec(n, e, c);
    }

    private final String dpLeak(Map<String, BigInteger> params) {
        System.out.println((Object)"dp leak");
        BigInteger bigInteger = params.get("n");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger n = bigInteger;
        BigInteger bigInteger2 = params.get("e");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        BigInteger bigInteger4 = params.get("dp");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dp = bigInteger4;
        BigInteger p = BigInteger.ONE;
        BigInteger q = BigInteger.ONE;
        for (int k = 1; k < 65538; ++k) {
            BigInteger bigInteger5;
            BigInteger bigInteger6 = e.multiply(dp);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"multiply(...)");
            BigInteger bigInteger7 = bigInteger6;
            BigInteger bigInteger8 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"ONE");
            BigInteger bigInteger9 = bigInteger7.subtract(bigInteger8);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"subtract(...)");
            bigInteger7 = bigInteger9;
            Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(k), (String)"valueOf(...)");
            BigInteger bigInteger10 = bigInteger7.divide(bigInteger5);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"divide(...)");
            bigInteger7 = bigInteger10;
            BigInteger bigInteger11 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7.add(bigInteger11), (String)"add(...)");
            if (Intrinsics.areEqual((Object)n.gcd(p), (Object)BigInteger.ONE)) continue;
            BigInteger bigInteger12 = n.divide(p);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"divide(...)");
            q = bigInteger12;
            break;
        }
        BigInteger bigInteger13 = p;
        Intrinsics.checkNotNull((Object)bigInteger13);
        BigInteger bigInteger14 = bigInteger13;
        bigInteger13 = q;
        Intrinsics.checkNotNull((Object)bigInteger13);
        return BigIntegerKt.decrypt2String(c, BigIntegerKt.invert(e, BigIntegerKt.phi(bigInteger14, bigInteger13)), n);
    }

    private final String solveDpDq(Map<String, BigInteger> params) {
        System.out.println((Object)"solveDpDq");
        BigInteger bigInteger = params.get("p");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger p = bigInteger;
        BigInteger bigInteger2 = params.get("q");
        if (bigInteger2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger q = bigInteger2;
        BigInteger bigInteger3 = params.get("c");
        if (bigInteger3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger3;
        BigInteger bigInteger4 = params.get("dp");
        if (bigInteger4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dp = bigInteger4;
        BigInteger bigInteger5 = params.get("dq");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger dq = bigInteger5;
        BigInteger invQ = BigIntegerKt.invert(q, p);
        BigInteger mp = c.modPow(dp, p);
        BigInteger mq = c.modPow(dq, q);
        Intrinsics.checkNotNull((Object)mp);
        Intrinsics.checkNotNull((Object)mq);
        BigInteger bigInteger6 = mp.subtract(mq);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"subtract(...)");
        BigInteger bigInteger7 = bigInteger6.multiply(invQ);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"multiply(...)");
        BigInteger bigInteger8 = bigInteger7.remainder(p);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"remainder(...)");
        BigInteger bigInteger9 = bigInteger8.multiply(q);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
        BigInteger bigInteger10 = bigInteger9.add(mq);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
        BigInteger m = bigInteger10;
        return BigIntegerKt.n2s(m);
    }

    @NotNull
    public final String solvePQEC(@NotNull Map<String, BigInteger> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        BigInteger bigInteger = params.get("p");
        if (bigInteger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger p = bigInteger;
        BigInteger bigInteger2 = params.get("q");
        if (bigInteger2 == null) {
            BigInteger bigInteger3 = params.get("n");
            Intrinsics.checkNotNull((Object)bigInteger3);
            BigInteger bigInteger4 = bigInteger3.divide(p);
            bigInteger2 = bigInteger4;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
        }
        BigInteger q = bigInteger2;
        BigInteger bigInteger5 = params.get("e");
        if (bigInteger5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger e = bigInteger5;
        BigInteger bigInteger6 = params.get("c");
        if (bigInteger6 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger c = bigInteger6;
        return this.solvePQEC(p, q, e, c);
    }

    private final String solvePQEC(BigInteger p, BigInteger q, BigInteger e, BigInteger c) {
        String string;
        System.out.println((Object)"solve P Q E C");
        BigInteger bigInteger = p.multiply(q);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        BigInteger n = bigInteger;
        BigInteger phi = BigIntegerKt.phi(p, q);
        if (Intrinsics.areEqual((Object)e.gcd(phi), (Object)BigInteger.ONE)) {
            System.out.println((Object)"solve P Q E C e phi are co-prime");
            BigInteger d = BigIntegerKt.invert(e, BigIntegerKt.phi(p, q));
            BigInteger bigInteger2 = p.multiply(q);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"multiply(...)");
            string = BigIntegerKt.decrypt2String(c, d, bigInteger2);
        } else {
            BigInteger t = e.gcd(phi);
            Intrinsics.checkNotNull((Object)t);
            BigInteger bigInteger3 = e.divide(t);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"divide(...)");
            BigInteger t1 = bigInteger3;
            System.out.println((Object)("solve P Q E C e phi not are co-prime!! " + t + ' ' + t1));
            if (Intrinsics.areEqual((Object)t1, (Object)BigInteger.ONE)) {
                BigInteger bigInteger4 = c.remainder(p);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"remainder(...)");
                Set<BigInteger> mps = this.ammAlg(bigInteger4, e, p);
                BigInteger bigInteger5 = c.remainder(q);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"remainder(...)");
                Set<BigInteger> mqs = this.ammAlg(bigInteger5, e, q);
                Object[] objectArray = new BigInteger[]{p, q};
                List modulusList = CollectionsKt.listOf((Object[])objectArray);
                Ref.ObjectRef qq = new Ref.ObjectRef();
                BigInteger r = ConcurrencyKt.findParallel((Collection)mps, BigInteger.ZERO, arg_0 -> RsaSolver.solvePQEC$lambda$0(mqs, modulusList, qq, arg_0));
                Object[] objectArray2 = new BigInteger[2];
                Intrinsics.checkNotNull((Object)r);
                Intrinsics.checkNotNull((Object)qq.element);
                string = BigIntegerKt.n2s(KgcdKt.crt(CollectionsKt.listOf((Object[])objectArray2), modulusList));
            } else {
                BigInteger dt1 = BigIntegerKt.invert(t1, phi);
                BigInteger bigInteger6 = c.modPow(dt1, n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"modPow(...)");
                string = BigIntegerKt.n2s((BigInteger)ArraysKt.first((Object[])BigIntegerKt.root(bigInteger6, t.intValue())));
            }
        }
        return string;
    }

    private static final boolean solvePQEC$lambda$0(Set $mqs, List $modulusList, Ref.ObjectRef $qq, BigInteger mpp) {
        Object v0;
        block2: {
            Iterable iterable = $mqs;
            for (Object object : iterable) {
                BigInteger mqq = (BigInteger)object;
                boolean bl = false;
                Object object2 = new BigInteger[]{mpp, mqq};
                object2 = BigIntegerKt.n2s(KgcdKt.crt(CollectionsKt.listOf((Object[])object2), $modulusList));
                if (!(!ConstantsKt.getREG_NON_PRINTABLE().containsMatchIn((CharSequence)object2))) continue;
                v0 = object;
                break block2;
            }
            v0 = null;
        }
        Object var4_11 = v0;
        BigInteger it = var4_11;
        boolean bl = false;
        if (it != null) {
            Object object;
            $qq.element = it;
            object = new BigInteger[]{mpp, it};
            object = "got " + mpp + " \n" + $qq.element + '\n' + BigIntegerKt.n2s(KgcdKt.crt(CollectionsKt.listOf(object), $modulusList)) + "\n\n";
            System.out.println(object);
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"n", "e", "c", "p"};
        modeNECP = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "e", "c"};
        modeNEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"d", "e", "c", "nbits"};
        modeDEC_P_NEXT_Q = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "n2", "e", "c"};
        modeN2EC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "c", "d"};
        modeNCD = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "r", "e", "c"};
        modePQREC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "r1", "r2", "e", "c"};
        modePQRnEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "e1", "c1", "n2", "e2", "c2"};
        modeN2E2C2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "c1", "n2", "e", "c2"};
        modeN2EC2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "c1", "e2", "e1", "c2"};
        modeNE2C2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"e", "c"};
        modeEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n", "e", "c", "phi"};
        modeNECPhi = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p", "q", "e", "c"};
        modePQEC = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"p1", "q1", "e1", "c1", "p2", "q2", "e2", "c2"};
        modePQEC2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"dp", "dq", "p", "q", "c"};
        modeDpDq = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"dp", "e", "c", "n"};
        modeDp = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"n1", "c1", "n2", "c2", "n3", "c3"};
        modeBroadcastN3C3 = CollectionsKt.listOf((Object[])objectArray);
    }
}

