/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.GsonUtilKt;
import me.leon.ext.crypto.MACsKt;
import me.leon.ext.crypto.SignatureKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"JWT", "", "JWT_HMAC_ALGS", "", "getJWT_HMAC_ALGS", "()Ljava/util/Map;", "JWT_SIGNATURE_ALGS", "getJWT_SIGNATURE_ALGS", "HEADER_FORMAT", "jwt", "alg", "key", "generateBase64Sig", "toEncryptData", "jwtVerify", "", "jwtParse", "Lkotlin/Pair;", "app"})
@SourceDebugExtension(value={"SMAP\nJwt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jwt.kt\nme/leon/ext/JwtKt\n+ 2 Exts.kt\nme/leon/ext/ExtsKt\n*L\n1#1,71:1\n3#2:72\n3#2:73\n*S KotlinDebug\n*F\n+ 1 Jwt.kt\nme/leon/ext/JwtKt\n*L\n52#1:72\n67#1:73\n*E\n"})
public final class JwtKt {
    @NotNull
    public static final String JWT = "JWT";
    @NotNull
    private static final Map<String, String> JWT_HMAC_ALGS;
    @NotNull
    private static final Map<String, String> JWT_SIGNATURE_ALGS;
    @NotNull
    public static final String HEADER_FORMAT = "{\"typ\":\"JWT\",\"alg\":\"%s\"}";

    @NotNull
    public static final Map<String, String> getJWT_HMAC_ALGS() {
        return JWT_HMAC_ALGS;
    }

    @NotNull
    public static final Map<String, String> getJWT_SIGNATURE_ALGS() {
        return JWT_SIGNATURE_ALGS;
    }

    @NotNull
    public static final String jwt(@NotNull String $this$jwt, @NotNull String alg, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$jwt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = HEADER_FORMAT;
        Object[] objectArray = new Object[]{alg};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String header = Base64Kt.base64Url$default(string2, null, 1, null);
        String payload = Base64Kt.base64Url$default($this$jwt, null, 1, null);
        String toEncryptData = header + '.' + payload;
        String base64Sig = JwtKt.generateBase64Sig(toEncryptData, alg, key);
        return header + '.' + payload + '.' + base64Sig;
    }

    private static final String generateBase64Sig(String toEncryptData, String alg, String key) {
        String string;
        block3: {
            block2: {
                string = JWT_HMAC_ALGS.get(alg);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                byte[] byArray = toEncryptData.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = key.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                String string2 = JWT_HMAC_ALGS.get(alg);
                Intrinsics.checkNotNull((Object)string2);
                String string3 = Base64Kt.base64Url$default(MACsKt.mac(byArray, byArray2, string2), null, 1, null);
                string = string3;
                if (string3 != null) break block3;
            }
            String string4 = JWT_SIGNATURE_ALGS.get(alg);
            Intrinsics.checkNotNull((Object)string4);
            String $this$generateBase64Sig_u24lambda_u241 = string4;
            boolean bl = false;
            String[] stringArray = new String[]{"/"};
            List list = StringsKt.split$default((CharSequence)$this$generateBase64Sig_u24lambda_u241, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String kpAlg = (String)list.get(0);
            String sigAlg = (String)list.get(1);
            byte[] byArray = toEncryptData.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = Base64Kt.base64Url$default(SignatureKt.sign(byArray, kpAlg, sigAlg, key), null, 1, null);
        }
        String base64Sig = string;
        return base64Sig;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean jwtVerify(@NotNull String $this$jwtVerify, @NotNull String key) {
        boolean bl;
        String string;
        void $this$safeAs$iv;
        Intrinsics.checkNotNullParameter((Object)$this$jwtVerify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String[] stringArray = new String[]{"."};
        List jwtParts = StringsKt.split$default((CharSequence)$this$jwtVerify, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String header = Base64Kt.base64UrlDecode2String$default((String)jwtParts.get(0), null, 1, null);
        Object v = ((Map)GsonUtilKt.fromJson(header, LinkedHashMap.class)).get("alg");
        boolean $i$f$safeAs = false;
        Object v0 = $this$safeAs$iv;
        if (!(v0 instanceof String)) {
            v0 = null;
        }
        if ((string = (String)v0) == null) {
            string = "";
        }
        String alg = string;
        String sig = (String)jwtParts.get(2);
        if (StringsKt.startsWith$default((String)alg, (String)"HS", (boolean)false, (int)2, null)) {
            String base64Sig = JwtKt.generateBase64Sig(StringsKt.substringBeforeLast$default((String)$this$jwtVerify, (String)".", null, (int)2, null), alg, key);
            bl = Intrinsics.areEqual((Object)sig, (Object)base64Sig);
        } else {
            String string2 = JWT_SIGNATURE_ALGS.get(alg);
            Intrinsics.checkNotNull((Object)string2);
            String[] stringArray2 = new String[]{"/"};
            List list = StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String kpAlg = (String)list.get(0);
            String sigAlg = (String)list.get(1);
            String string3 = StringsKt.substringBeforeLast$default((String)$this$jwtVerify, (String)".", null, (int)2, null);
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            bl = SignatureKt.verify(byArray, kpAlg, sigAlg, key, Base64Kt.base64UrlDecode$default(sig, null, 1, null));
        }
        return bl;
    }

    @NotNull
    public static final Pair<String, String> jwtParse(@NotNull String $this$jwtParse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$jwtParse, (String)"<this>");
        String[] stringArray = new String[]{"."};
        List jwtParts = StringsKt.split$default((CharSequence)$this$jwtParse, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String header = Base64Kt.base64UrlDecode2String$default((String)jwtParts.get(0), null, 1, null);
        Object $this$safeAs$iv = ((Map)GsonUtilKt.fromJson(header, LinkedHashMap.class)).get("alg");
        boolean $i$f$safeAs = false;
        Object v = $this$safeAs$iv;
        if (!(v instanceof String)) {
            v = null;
        }
        if ((string = (String)v) == null) {
            string = "HS256";
        }
        String alg = string;
        String payload = Base64Kt.base64UrlDecode2String$default((String)jwtParts.get(1), null, 1, null);
        return TuplesKt.to((Object)alg, (Object)payload);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"HS256", (Object)"HmacSHA256"), TuplesKt.to((Object)"HS384", (Object)"HmacSHA384"), TuplesKt.to((Object)"HS512", (Object)"HmacSHA512")};
        JWT_HMAC_ALGS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"RS256", (Object)"RSA/SHA256withRSA"), TuplesKt.to((Object)"RS384", (Object)"RSA/SHA384withRSA"), TuplesKt.to((Object)"RS512", (Object)"RSA/SHA512withRSA"), TuplesKt.to((Object)"ES256", (Object)"ECDSA/SHA256withPLAIN-ECDSA"), TuplesKt.to((Object)"ES384", (Object)"ECDSA/SHA384withPLAIN-ECDSA"), TuplesKt.to((Object)"ES512", (Object)"ECDSA/SHA512withPLAIN-ECDSA"), TuplesKt.to((Object)"PS256", (Object)"RSA/SHA256withRSAandMGF1"), TuplesKt.to((Object)"PS384", (Object)"RSA/SHA384withRSAandMGF1"), TuplesKt.to((Object)"PS512", (Object)"RSA/SHA512withRSAandMGF1")};
        JWT_SIGNATURE_ALGS = MapsKt.mapOf((Pair[])pairArray);
    }
}

