/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import me.leon.classical.ADFGVXKt;
import me.leon.classical.ADFGXKt;
import me.leon.classical.AffineCipherKt;
import me.leon.classical.AlphabetaIndexKt;
import me.leon.classical.AtbashKt;
import me.leon.classical.AutoKeyKt;
import me.leon.classical.BaconCipherKt;
import me.leon.classical.BeaufortKt;
import me.leon.classical.BifidKt;
import me.leon.classical.CitrixCtx1Kt;
import me.leon.classical.FourSquareKt;
import me.leon.classical.GrayCodeKt;
import me.leon.classical.GronsfeldKt;
import me.leon.classical.HackWordKt;
import me.leon.classical.HillsKt;
import me.leon.classical.ManchesterCipherKt;
import me.leon.classical.MorseKt;
import me.leon.classical.NihilistCipherKt;
import me.leon.classical.OneTimePadCipherKt;
import me.leon.classical.PlayFairKt;
import me.leon.classical.PolybiusSquareCipherKt;
import me.leon.classical.PortaKt;
import me.leon.classical.RailFenceKt;
import me.leon.classical.RailFenceWKt;
import me.leon.classical.RotKt;
import me.leon.classical.TableSubsKt;
import me.leon.classical.TapCodeCipherKt;
import me.leon.classical.TrifidKt;
import me.leon.classical.Type7Kt;
import me.leon.classical.VirgeneneKt;
import me.leon.classical.Zero1248Kt;
import me.leon.ctf.AsciiSumKt;
import me.leon.ctf.BaiJiaXingKt;
import me.leon.ctf.Base60Kt;
import me.leon.ctf.Base64CaseCrackKt;
import me.leon.ctf.Base64StegKt;
import me.leon.ctf.BauDotKt;
import me.leon.ctf.BrailleKt;
import me.leon.ctf.BrainFuckKt;
import me.leon.ctf.BubbleBabbleKt;
import me.leon.ctf.BuddhaCipherKt;
import me.leon.ctf.BuddhaPbeCipherKt;
import me.leon.ctf.CaesarBoxCipherKt;
import me.leon.ctf.CetaceanCipherKt;
import me.leon.ctf.CurveCipherKt;
import me.leon.ctf.DNAKt;
import me.leon.ctf.EightDiagramKt;
import me.leon.ctf.ElementPeriodicTableKt;
import me.leon.ctf.EmojiSubstitutionKt;
import me.leon.ctf.FenhamCipherKt;
import me.leon.ctf.FracMorseKt;
import me.leon.ctf.OokKt;
import me.leon.ctf.PawnShopKt;
import me.leon.ctf.QWEKt;
import me.leon.ctf.Rot8000Kt;
import me.leon.ctf.SocialistCoreValuesKt;
import me.leon.ctf.TrollScriptKt;
import me.leon.ctf.TwinHexCipherKt;
import me.leon.ctf.YygqCipherKt;
import me.leon.ctf.ZeroWidthCharKt;
import me.leon.ctf.rsa.RsaSolver;
import me.leon.ext.ExtsKt;
import me.leon.ext.FileKt;
import me.leon.ext.ParamsParserKt;
import me.leon.ext.StringKt;
import me.leon.ext.crypto.ClassicalHintConfigKt;
import me.leon.ext.crypto.IClassical;
import me.leon.ext.crypto.JavascriptCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\bI\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010M\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040NH\u0016\u00a2\u0006\u0002\u0010OJ\u0015\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040NH\u0016\u00a2\u0006\u0002\u0010OR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bL\u00a8\u0006Q"}, d2={"Lme/leon/ext/crypto/ClassicalCryptoType;", "Lme/leon/ext/crypto/IClassical;", "", "type", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "CAESAR", "ROT5", "ROT13", "ROT18", "ROT47", "AFFINE", "RAILFENCE", "VIRGENENE", "ATBASH", "MORSE", "QWE", "POLYBIUS", "NIHILIST", "ADFGX", "PLAYFAIR", "AUTOKEY", "BACON24", "OTP", "SOCIALISM", "BRAINFUCK", "Ook", "TROLLSCRIPT", "Braille", "BauDot", "AlphabetIndex", "Zero1248", "BubbleBabble", "ZWC", "ZWC_UNICODE", "PeriodicTable", "PawnShop", "AsciiSum", "CurveCipher", "EmojiSubstitute", "HandyCode", "Vowel", "Porta", "Beaufort", "FourSquare", "Gronsfeld", "Trifid", "Bifid", "GrayCode", "BuddhaSay", "HILL", "Rabbit", "AAEncode", "JJEncode", "RSA_CRACK", "DNA", "TAP_CODE", "CAESAR_BOX", "ROT8000", "CETACEAN", "YYGQ", "MANCHESTER", "MANCHESTER_DIFF", "EIGHT_DIAGRAM", "STEM_BRANCH", "FRAC_MORSE", "FENHAM", "TWIN_HEX", "BAI_JIA_XING", "TYPE7", "CITRIX_CTX1", "STEG_BASE64", "BASE64_CASE", "HACKER", "paramsHints", "", "()[Ljava/lang/String;", "checkboxHints", "app"})
@SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,756:1\n18#2:757\n18#2:758\n*S KotlinDebug\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType\n*L\n749#1:757\n753#1:758\n*E\n"})
public abstract class ClassicalCryptoType
extends Enum<ClassicalCryptoType>
implements IClassical {
    @NotNull
    private final String type;
    public static final /* enum */ ClassicalCryptoType CAESAR = new CAESAR("CAESAR", 0);
    public static final /* enum */ ClassicalCryptoType ROT5 = new ROT5("ROT5", 1);
    public static final /* enum */ ClassicalCryptoType ROT13 = new ROT13("ROT13", 2);
    public static final /* enum */ ClassicalCryptoType ROT18 = new ROT18("ROT18", 3);
    public static final /* enum */ ClassicalCryptoType ROT47 = new ROT47("ROT47", 4);
    public static final /* enum */ ClassicalCryptoType AFFINE = new AFFINE("AFFINE", 5);
    public static final /* enum */ ClassicalCryptoType RAILFENCE = new RAILFENCE("RAILFENCE", 6);
    public static final /* enum */ ClassicalCryptoType VIRGENENE = new VIRGENENE("VIRGENENE", 7);
    public static final /* enum */ ClassicalCryptoType ATBASH = new ATBASH("ATBASH", 8);
    public static final /* enum */ ClassicalCryptoType MORSE = new MORSE("MORSE", 9);
    public static final /* enum */ ClassicalCryptoType QWE = new QWE("QWE", 10);
    public static final /* enum */ ClassicalCryptoType POLYBIUS = new POLYBIUS("POLYBIUS", 11);
    public static final /* enum */ ClassicalCryptoType NIHILIST = new NIHILIST("NIHILIST", 12);
    public static final /* enum */ ClassicalCryptoType ADFGX = new ADFGX("ADFGX", 13);
    public static final /* enum */ ClassicalCryptoType PLAYFAIR = new PLAYFAIR("PLAYFAIR", 14);
    public static final /* enum */ ClassicalCryptoType AUTOKEY = new AUTOKEY("AUTOKEY", 15);
    public static final /* enum */ ClassicalCryptoType BACON24 = new BACON24("BACON24", 16);
    public static final /* enum */ ClassicalCryptoType OTP = new OTP("OTP", 17);
    public static final /* enum */ ClassicalCryptoType SOCIALISM = new SOCIALISM("SOCIALISM", 18);
    public static final /* enum */ ClassicalCryptoType BRAINFUCK = new BRAINFUCK("BRAINFUCK", 19);
    public static final /* enum */ ClassicalCryptoType Ook = new Ook("Ook", 20);
    public static final /* enum */ ClassicalCryptoType TROLLSCRIPT = new TROLLSCRIPT("TROLLSCRIPT", 21);
    public static final /* enum */ ClassicalCryptoType Braille = new Braille("Braille", 22);
    public static final /* enum */ ClassicalCryptoType BauDot = new BauDot("BauDot", 23);
    public static final /* enum */ ClassicalCryptoType AlphabetIndex = new AlphabetIndex("AlphabetIndex", 24);
    public static final /* enum */ ClassicalCryptoType Zero1248 = new Zero1248("Zero1248", 25);
    public static final /* enum */ ClassicalCryptoType BubbleBabble = new BubbleBabble("BubbleBabble", 26);
    public static final /* enum */ ClassicalCryptoType ZWC = new ZWC("ZWC", 27);
    public static final /* enum */ ClassicalCryptoType ZWC_UNICODE = new ZWC_UNICODE("ZWC_UNICODE", 28);
    public static final /* enum */ ClassicalCryptoType PeriodicTable = new PeriodicTable("PeriodicTable", 29);
    public static final /* enum */ ClassicalCryptoType PawnShop = new PawnShop("PawnShop", 30);
    public static final /* enum */ ClassicalCryptoType AsciiSum = new AsciiSum("AsciiSum", 31);
    public static final /* enum */ ClassicalCryptoType CurveCipher = new CurveCipher("CurveCipher", 32);
    public static final /* enum */ ClassicalCryptoType EmojiSubstitute = new EmojiSubstitute("EmojiSubstitute", 33);
    public static final /* enum */ ClassicalCryptoType HandyCode = new HandyCode("HandyCode", 34);
    public static final /* enum */ ClassicalCryptoType Vowel = new Vowel("Vowel", 35);
    public static final /* enum */ ClassicalCryptoType Porta = new Porta("Porta", 36);
    public static final /* enum */ ClassicalCryptoType Beaufort = new Beaufort("Beaufort", 37);
    public static final /* enum */ ClassicalCryptoType FourSquare = new FourSquare("FourSquare", 38);
    public static final /* enum */ ClassicalCryptoType Gronsfeld = new Gronsfeld("Gronsfeld", 39);
    public static final /* enum */ ClassicalCryptoType Trifid = new Trifid("Trifid", 40);
    public static final /* enum */ ClassicalCryptoType Bifid = new Bifid("Bifid", 41);
    public static final /* enum */ ClassicalCryptoType GrayCode = new GrayCode("GrayCode", 42);
    public static final /* enum */ ClassicalCryptoType BuddhaSay = new BuddhaSay("BuddhaSay", 43);
    public static final /* enum */ ClassicalCryptoType HILL = new HILL("HILL", 44);
    public static final /* enum */ ClassicalCryptoType Rabbit = new Rabbit("Rabbit", 45);
    public static final /* enum */ ClassicalCryptoType AAEncode = new AAEncode("AAEncode", 46);
    public static final /* enum */ ClassicalCryptoType JJEncode = new JJEncode("JJEncode", 47);
    public static final /* enum */ ClassicalCryptoType RSA_CRACK = new RSA_CRACK("RSA_CRACK", 48);
    public static final /* enum */ ClassicalCryptoType DNA = new DNA("DNA", 49);
    public static final /* enum */ ClassicalCryptoType TAP_CODE = new TAP_CODE("TAP_CODE", 50);
    public static final /* enum */ ClassicalCryptoType CAESAR_BOX = new CAESAR_BOX("CAESAR_BOX", 51);
    public static final /* enum */ ClassicalCryptoType ROT8000 = new ROT8000("ROT8000", 52);
    public static final /* enum */ ClassicalCryptoType CETACEAN = new CETACEAN("CETACEAN", 53);
    public static final /* enum */ ClassicalCryptoType YYGQ = new YYGQ("YYGQ", 54);
    public static final /* enum */ ClassicalCryptoType MANCHESTER = new MANCHESTER("MANCHESTER", 55);
    public static final /* enum */ ClassicalCryptoType MANCHESTER_DIFF = new MANCHESTER_DIFF("MANCHESTER_DIFF", 56);
    public static final /* enum */ ClassicalCryptoType EIGHT_DIAGRAM = new EIGHT_DIAGRAM("EIGHT_DIAGRAM", 57);
    public static final /* enum */ ClassicalCryptoType STEM_BRANCH = new STEM_BRANCH("STEM_BRANCH", 58);
    public static final /* enum */ ClassicalCryptoType FRAC_MORSE = new FRAC_MORSE("FRAC_MORSE", 59);
    public static final /* enum */ ClassicalCryptoType FENHAM = new FENHAM("FENHAM", 60);
    public static final /* enum */ ClassicalCryptoType TWIN_HEX = new TWIN_HEX("TWIN_HEX", 61);
    public static final /* enum */ ClassicalCryptoType BAI_JIA_XING = new BAI_JIA_XING("BAI_JIA_XING", 62);
    public static final /* enum */ ClassicalCryptoType TYPE7 = new TYPE7("TYPE7", 63);
    public static final /* enum */ ClassicalCryptoType CITRIX_CTX1 = new CITRIX_CTX1("CITRIX_CTX1", 64);
    public static final /* enum */ ClassicalCryptoType STEG_BASE64 = new STEG_BASE64("STEG_BASE64", 65);
    public static final /* enum */ ClassicalCryptoType BASE64_CASE = new BASE64_CASE("BASE64_CASE", 66);
    public static final /* enum */ ClassicalCryptoType HACKER = new HACKER("HACKER", 67);
    private static final /* synthetic */ ClassicalCryptoType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ClassicalCryptoType(String type2) {
        this.type = type2;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String[] paramsHints() {
        Map<String, String[]> map = ClassicalHintConfigKt.getCLASSIC_CONFIG().get(this);
        String[] $this$orEmpty$iv = map != null ? map.get("hint") : null;
        boolean $i$f$orEmpty = false;
        String[] stringArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] checkboxHints() {
        Map<String, String[]> map = ClassicalHintConfigKt.getCLASSIC_CONFIG().get(this);
        String[] $this$orEmpty$iv = map != null ? map.get("check") : null;
        boolean $i$f$orEmpty = false;
        String[] stringArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static ClassicalCryptoType[] values() {
        return (ClassicalCryptoType[])$VALUES.clone();
    }

    public static ClassicalCryptoType valueOf(String value) {
        return Enum.valueOf(ClassicalCryptoType.class, value);
    }

    @NotNull
    public static EnumEntries<ClassicalCryptoType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ ClassicalCryptoType(String $enum$name, int $enum$ordinal, String type2, DefaultConstructorMarker $constructor_marker) {
        this(type2);
    }

    static {
        $VALUES = classicalCryptoTypeArray = new ClassicalCryptoType[]{ClassicalCryptoType.CAESAR, ClassicalCryptoType.ROT5, ClassicalCryptoType.ROT13, ClassicalCryptoType.ROT18, ClassicalCryptoType.ROT47, ClassicalCryptoType.AFFINE, ClassicalCryptoType.RAILFENCE, ClassicalCryptoType.VIRGENENE, ClassicalCryptoType.ATBASH, ClassicalCryptoType.MORSE, ClassicalCryptoType.QWE, ClassicalCryptoType.POLYBIUS, ClassicalCryptoType.NIHILIST, ClassicalCryptoType.ADFGX, ClassicalCryptoType.PLAYFAIR, ClassicalCryptoType.AUTOKEY, ClassicalCryptoType.BACON24, ClassicalCryptoType.OTP, ClassicalCryptoType.SOCIALISM, ClassicalCryptoType.BRAINFUCK, ClassicalCryptoType.Ook, ClassicalCryptoType.TROLLSCRIPT, ClassicalCryptoType.Braille, ClassicalCryptoType.BauDot, ClassicalCryptoType.AlphabetIndex, ClassicalCryptoType.Zero1248, ClassicalCryptoType.BubbleBabble, ClassicalCryptoType.ZWC, ClassicalCryptoType.ZWC_UNICODE, ClassicalCryptoType.PeriodicTable, ClassicalCryptoType.PawnShop, ClassicalCryptoType.AsciiSum, ClassicalCryptoType.CurveCipher, ClassicalCryptoType.EmojiSubstitute, ClassicalCryptoType.HandyCode, ClassicalCryptoType.Vowel, ClassicalCryptoType.Porta, ClassicalCryptoType.Beaufort, ClassicalCryptoType.FourSquare, ClassicalCryptoType.Gronsfeld, ClassicalCryptoType.Trifid, ClassicalCryptoType.Bifid, ClassicalCryptoType.GrayCode, ClassicalCryptoType.BuddhaSay, ClassicalCryptoType.HILL, ClassicalCryptoType.Rabbit, ClassicalCryptoType.AAEncode, ClassicalCryptoType.JJEncode, ClassicalCryptoType.RSA_CRACK, ClassicalCryptoType.DNA, ClassicalCryptoType.TAP_CODE, ClassicalCryptoType.CAESAR_BOX, ClassicalCryptoType.ROT8000, ClassicalCryptoType.CETACEAN, ClassicalCryptoType.YYGQ, ClassicalCryptoType.MANCHESTER, ClassicalCryptoType.MANCHESTER_DIFF, ClassicalCryptoType.EIGHT_DIAGRAM, ClassicalCryptoType.STEM_BRANCH, ClassicalCryptoType.FRAC_MORSE, ClassicalCryptoType.FENHAM, ClassicalCryptoType.TWIN_HEX, ClassicalCryptoType.BAI_JIA_XING, ClassicalCryptoType.TYPE7, ClassicalCryptoType.CITRIX_CTX1, ClassicalCryptoType.STEG_BASE64, ClassicalCryptoType.BASE64_CASE, ClassicalCryptoType.HACKER};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.AAEncode", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class AAEncode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AAEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.aaEncode(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.aaDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ADFGX", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$ADFGX\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class ADFGX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ADFGX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String it;
                String string4;
                String string5 = string4 = params.get("p1");
                String string6 = raw;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = charSequence == null || charSequence.length() == 0;
                String string7 = !bl2 ? string4 : null;
                if (string7 == null) {
                    string7 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                }
                it = string4 = params.get("p2");
                String string8 = string7;
                boolean bl3 = false;
                charSequence = it;
                boolean bl4 = charSequence == null || charSequence.length() == 0;
                String string9 = !bl4 ? string4 : null;
                if (string9 == null) {
                    string9 = "12345";
                }
                string = ADFGVXKt.adfgvx(string6, string8, string9);
            } else {
                String string10;
                String it = string10 = params.get("p1");
                String string11 = raw;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl5 = charSequence == null || charSequence.length() == 0;
                String string12 = !bl5 ? string10 : null;
                if (string12 == null) {
                    string12 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                }
                it = string10 = params.get("p2");
                String string13 = string12;
                boolean bl6 = false;
                charSequence = it;
                boolean bl7 = charSequence == null || charSequence.length() == 0;
                String string14 = !bl7 ? string10 : null;
                if (string14 == null) {
                    string14 = "12345";
                }
                string = ADFGXKt.adfgx$default(string11, string13, string14, null, null, 12, null);
            }
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String it;
                String string4;
                String string5 = string4 = params.get("p1");
                String string6 = raw;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = charSequence == null || charSequence.length() == 0;
                String string7 = !bl2 ? string4 : null;
                if (string7 == null) {
                    string7 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                }
                it = string4 = params.get("p2");
                String string8 = string7;
                boolean bl3 = false;
                charSequence = it;
                boolean bl4 = charSequence == null || charSequence.length() == 0;
                String string9 = !bl4 ? string4 : null;
                if (string9 == null) {
                    string9 = "12345";
                }
                string = ADFGVXKt.adfgvxDecrypt(string6, string8, string9);
            } else {
                String string10;
                String it = string10 = params.get("p1");
                String string11 = raw;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl5 = charSequence == null || charSequence.length() == 0;
                String string12 = !bl5 ? string10 : null;
                if (string12 == null) {
                    string12 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                }
                it = string10 = params.get("p2");
                String string13 = string12;
                boolean bl6 = false;
                charSequence = it;
                boolean bl7 = charSequence == null || charSequence.length() == 0;
                String string14 = !bl7 ? string10 : null;
                if (string14 == null) {
                    string14 = "12345";
                }
                string = ADFGXKt.adfgxDecrypt$default(string11, string13, string14, null, 4, null);
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.AFFINE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "hasCrack", "crack", "keyword", "app"})
    static final class AFFINE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AFFINE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return AffineCipherKt.affineEncrypt$default(raw, n, Integer.parseInt(string2), null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return AffineCipherKt.affineDecrypt$default(raw, n, Integer.parseInt(string2), null, 4, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            StringBuilder sb = new StringBuilder();
            for (int a = 1; a < 27; ++a) {
                for (int b = 1; b < 27; ++b) {
                    Object object;
                    AFFINE aFFINE = this;
                    try {
                        AFFINE $this$crack_u24lambda_u240 = aFFINE;
                        boolean bl = false;
                        String decrypted = AffineCipherKt.affineDecrypt$default(raw, a, b, null, 4, null);
                        if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                            StringBuilder stringBuilder = sb.append(a + "*x+" + b + ": " + System.lineSeparator() + '\t' + decrypted);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                            stringBuilder.append('\n');
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ATBASH", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ATBASH
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ATBASH() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AtbashKt.atBash(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AtbashKt.atBash(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.AUTOKEY", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$AUTOKEY\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class AUTOKEY
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AUTOKEY() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return AutoKeyKt.autoKey(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return AutoKeyKt.autoKeyDecrypt(string3, string4);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.AlphabetIndex", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$AlphabetIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class AlphabetIndex
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AlphabetIndex() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            String string2;
            String string3;
            String string4;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string5 = raw;
            String string6 = params.get("p1");
            if (string6 != null) {
                CharSequence charSequence2;
                charSequence = string6;
                if (charSequence.length() == 0) {
                    string4 = string5;
                    boolean bl = false;
                    charSequence2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                    string5 = string4;
                } else {
                    charSequence2 = charSequence;
                }
                string3 = (String)charSequence2;
            } else {
                string3 = " ";
            }
            String string7 = params.get("p2");
            if (string7 != null) {
                CharSequence charSequence3;
                charSequence = string7;
                if (charSequence.length() == 0) {
                    String string8 = string3;
                    string4 = string5;
                    boolean bl = false;
                    String string9 = " ";
                    string5 = string4;
                    string3 = string8;
                    charSequence3 = string9;
                } else {
                    charSequence3 = charSequence;
                }
                string2 = (String)charSequence3;
            } else {
                string2 = " ";
            }
            String it = string = AlphabetaIndexKt.alphabetIndex$default(string5, string3, string2, false, 4, null);
            boolean bl = false;
            System.out.println((Object)("alphabetIndex " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AlphabetaIndexKt.alphabetIndexDecode$default(raw, null, false, 3, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.AsciiSum", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class AsciiSum
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        AsciiSum() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AsciiSumKt.asciiSum(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return AsciiSumKt.asciiSumDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BACON24", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class BACON24
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BACON24() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return Boolean.parseBoolean(string) ? BaconCipherKt.baconEncrypt26(raw) : BaconCipherKt.baconEncrypt24(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return Boolean.parseBoolean(string) ? BaconCipherKt.baconDecrypt26(raw) : BaconCipherKt.baconDecrypt24(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BAI_JIA_XING", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class BAI_JIA_XING
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BAI_JIA_XING() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaiJiaXingKt.baiJiaXing(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BaiJiaXingKt.baiJiaXingDecode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BASE64_CASE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class BASE64_CASE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BASE64_CASE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return StringKt.lineAction2String(raw, (Function1<? super String, String>)((Function1)BASE64_CASE::encrypt$lambda$0));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            return Base64CaseCrackKt.base64CaseCrack(raw, string);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        private static final String encrypt$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Base64CaseCrackKt.base64UpperCase(it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BRAINFUCK", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class BRAINFUCK
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BRAINFUCK() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrainFuckKt.brainFuckEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrainFuckKt.brainFuckDecrypt(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BauDot", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$BauDot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class BauDot
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BauDot() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = BauDotKt.baudot(raw);
            boolean bl = false;
            System.out.println((Object)("baudot " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BauDotKt.baudotDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Beaufort", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Beaufort\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Beaufort
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Beaufort() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "beaufort";
            }
            return BeaufortKt.beaufort(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "beaufort";
            }
            return BeaufortKt.beaufort(string3, string4);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Bifid", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Bifid\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Bifid
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Bifid() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            CharSequence charSequence;
            String string2;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            Intrinsics.checkNotNull((Object)string4);
            CharSequence charSequence2 = string4;
            if (charSequence2.length() == 0) {
                string2 = string3;
                boolean bl = false;
                charSequence = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                string3 = string2;
            } else {
                charSequence = charSequence2;
            }
            String string5 = string = params.get("p2");
            String string6 = (String)charSequence;
            string2 = string3;
            boolean bl = false;
            CharSequence charSequence3 = (CharSequence)it;
            boolean bl2 = charSequence3 == null || charSequence3.length() == 0;
            String string7 = !bl2 ? string : null;
            return BifidKt.bifid(string2, string6, string7 != null ? Integer.parseInt(string7) : 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            CharSequence charSequence;
            String string2;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            Intrinsics.checkNotNull((Object)string4);
            CharSequence charSequence2 = string4;
            if (charSequence2.length() == 0) {
                string2 = string3;
                boolean bl = false;
                charSequence = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
                string3 = string2;
            } else {
                charSequence = charSequence2;
            }
            String string5 = string = params.get("p2");
            String string6 = (String)charSequence;
            string2 = string3;
            boolean bl = false;
            CharSequence charSequence3 = (CharSequence)it;
            boolean bl2 = charSequence3 == null || charSequence3.length() == 0;
            String string7 = !bl2 ? string : null;
            return BifidKt.bifidDecrypt(string2, string6, string7 != null ? Integer.parseInt(string7) : 5);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Braille", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Braille\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Braille
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Braille() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = BrailleKt.blindEncode(raw);
            boolean bl = false;
            System.out.println((Object)("Braille " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BrailleKt.blindDecode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BubbleBabble", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class BubbleBabble
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BubbleBabble() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BubbleBabbleKt.bubbleBabble(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return BubbleBabbleKt.bubbleBabbleDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.BuddhaSay", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class BuddhaSay
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        BuddhaSay() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String string4 = params.get("p1");
                if (string4 == null) {
                    String string5 = "Required value was null.";
                    throw new IllegalArgumentException(string5.toString());
                }
                string = BuddhaPbeCipherKt.buddhaPbe(raw, string4);
            } else {
                string = BuddhaCipherKt.buddhaSays(raw);
            }
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String string4 = params.get("p1");
                if (string4 == null) {
                    String string5 = "Required value was null.";
                    throw new IllegalArgumentException(string5.toString());
                }
                string = BuddhaPbeCipherKt.buddhaPbeDecrypt(raw, string4);
            } else {
                string = BuddhaCipherKt.buddhaExplain(raw);
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.CAESAR", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "hasCrack", "crack", "keyword", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$CAESAR\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,756:1\n1#2:757\n1104#3,3:758\n1104#3,3:761\n*S KotlinDebug\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$CAESAR\n*L\n30#1:758,3\n31#1:761,3\n*E\n"})
    static final class CAESAR
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CAESAR() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = raw;
            String string2 = params.get("p1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            int n = Integer.parseInt(string2);
            String string4 = params.get("p2");
            if (string4 == null) {
                String string5 = "Required value was null.";
                throw new IllegalArgumentException(string5.toString());
            }
            CharSequence charSequence2 = string4;
            if (charSequence2.length() == 0) {
                int n2 = n;
                String string6 = string;
                boolean bl = false;
                String string7 = params.get("p1");
                string = string6;
                n = n2;
                charSequence = string7;
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNull((Object)charSequence);
            return RotKt.shift26(string, n, Integer.parseInt((String)charSequence));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = raw;
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            int n = 26 - Integer.parseInt(string2);
            int n2 = 26;
            String string3 = params.get("p2");
            Intrinsics.checkNotNull((Object)string3);
            CharSequence charSequence2 = string3;
            if (charSequence2.length() == 0) {
                int n3 = n2;
                int n4 = n;
                String string4 = string;
                boolean bl = false;
                String string5 = params.get("p1");
                string = string4;
                n = n4;
                n2 = n3;
                charSequence = string5;
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNull((Object)charSequence);
            return RotKt.shift26(string, n, n2 - Integer.parseInt((String)charSequence));
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            int element$iv;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            CharSequence $this$count$iv = raw;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                int it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!Character.isLowerCase((char)it)) continue;
                ++count$iv;
            }
            int lowerCount = count$iv;
            CharSequence $this$count$iv2 = raw;
            boolean $i$f$count2 = false;
            int count$iv2 = 0;
            for (element$iv = 0; element$iv < $this$count$iv2.length(); ++element$iv) {
                char element$iv2;
                char it = element$iv2 = $this$count$iv2.charAt(element$iv);
                boolean bl = false;
                if (!Character.isUpperCase(it)) continue;
                ++count$iv2;
            }
            int upperCount = count$iv2;
            boolean isOneCase = lowerCount == 0 || upperCount == 0;
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < 26; ++i) {
                for (int j = 1; !(j >= 26 || isOneCase && j > 1); ++j) {
                    Integer n = j;
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    Integer n2 = !isOneCase ? n : null;
                    int biasLower = n2 != null ? n2 : i;
                    String decrypted = RotKt.shift26(raw, 26 - i, 26 - biasLower);
                    if (!ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) continue;
                    StringBuilder stringBuilder = sb.append("shift: " + i + " shift(lower): " + biasLower + System.lineSeparator() + '\t' + decrypted);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    stringBuilder.append('\n');
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.CAESAR_BOX", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class CAESAR_BOX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CAESAR_BOX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return CaesarBoxCipherKt.caesarBox(raw, Integer.parseInt(string));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return CaesarBoxCipherKt.caesarBoxDecrypt(raw, Integer.parseInt(string));
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.CETACEAN", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class CETACEAN
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CETACEAN() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CetaceanCipherKt.cetacean(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CetaceanCipherKt.cetaceanDecrypt(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.CITRIX_CTX1", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class CITRIX_CTX1
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CITRIX_CTX1() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CitrixCtx1Kt.citrixCtx1(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return CitrixCtx1Kt.citrixCtx1Decode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.CurveCipher", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class CurveCipher
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        CurveCipher() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return CurveCipherKt.curveCipher(raw, n, Integer.parseInt(string2));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            int n = Integer.parseInt(string);
            String string2 = params.get("p2");
            Intrinsics.checkNotNull((Object)string2);
            return CurveCipherKt.curveCipherDecode(raw, n, Integer.parseInt(string2));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.DNA", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class DNA
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        DNA() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return DNAKt.dna(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return DNAKt.dnaDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.EIGHT_DIAGRAM", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$EIGHT_DIAGRAM\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class EIGHT_DIAGRAM
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        EIGHT_DIAGRAM() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            System.out.println(it);
            String string4 = string;
            if (string4 == null) {
                string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return EightDiagramKt.eightDiagram(string3, string4);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return EightDiagramKt.eightDiagramDecode(raw, string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.EmojiSubstitute", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$EmojiSubstitute\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class EmojiSubstitute
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        EmojiSubstitute() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            return EmojiSubstitutionKt.emojiReplace(string3, string4 != null ? Integer.parseInt(string4) : 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            return EmojiSubstitutionKt.emojiReplaceDecode(string3, string4 != null ? Integer.parseInt(string4) : 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.FENHAM", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class FENHAM
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        FENHAM() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return FenhamCipherKt.fenham(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return FenhamCipherKt.fenhamDecrypt(raw, string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.FRAC_MORSE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class FRAC_MORSE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        FRAC_MORSE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return FracMorseKt.fracMorse(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return FracMorseKt.fracMorseDecrypt(raw, string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.FourSquare", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$FourSquare\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class FourSquare
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        FourSquare() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return FourSquareKt.fourSquare(string3, string5, string6);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return FourSquareKt.fourSquareDecrypt(string3, string5, string6);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.GrayCode", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$GrayCode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class GrayCode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        GrayCode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            int n;
            String string2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            if (string4 != null) {
                CharSequence charSequence2;
                charSequence = string4;
                if (charSequence.length() == 0) {
                    string2 = string3;
                    boolean bl = false;
                    charSequence2 = "0";
                    string3 = string2;
                } else {
                    charSequence2 = charSequence;
                }
                n = Integer.parseInt((String)charSequence2);
            } else {
                n = 0;
            }
            String string5 = params.get("p2");
            if (string5 != null) {
                CharSequence charSequence3;
                charSequence = string5;
                if (charSequence.length() == 0) {
                    int n2 = n;
                    string2 = string3;
                    boolean bl = false;
                    String string6 = " ";
                    string3 = string2;
                    n = n2;
                    charSequence3 = string6;
                } else {
                    charSequence3 = charSequence;
                }
                string = (String)charSequence3;
            } else {
                string = " ";
            }
            return GrayCodeKt.grayEncode(string3, n, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            int n;
            String string2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string3 = raw;
            String string4 = params.get("p1");
            if (string4 != null) {
                CharSequence charSequence2;
                charSequence = string4;
                if (charSequence.length() == 0) {
                    string2 = string3;
                    boolean bl = false;
                    charSequence2 = "0";
                    string3 = string2;
                } else {
                    charSequence2 = charSequence;
                }
                n = Integer.parseInt((String)charSequence2);
            } else {
                n = 0;
            }
            String string5 = params.get("p2");
            if (string5 != null) {
                CharSequence charSequence3;
                charSequence = string5;
                if (charSequence.length() == 0) {
                    int n2 = n;
                    string2 = string3;
                    boolean bl = false;
                    String string6 = " ";
                    string3 = string2;
                    n = n2;
                    charSequence3 = string6;
                } else {
                    charSequence3 = charSequence;
                }
                string = (String)charSequence3;
            } else {
                string = " ";
            }
            return GrayCodeKt.grayDecode(string3, n, string);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Gronsfeld", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Gronsfeld\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Gronsfeld
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Gronsfeld() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "123456";
            }
            return GronsfeldKt.gronsfeld(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "123456";
            }
            return GronsfeldKt.gronsfeldDecrypt(string3, string4);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.HACKER", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class HACKER
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        HACKER() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return HackWordKt.hackWord(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return HackWordKt.hackWordDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.HILL", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "hasCrack", "", "crack", "keyword", "app"})
    static final class HILL
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        HILL() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            String string2 = params.get("p2");
            return HillsKt.hillEncrypt$default(raw, string, null, string2 != null ? ((CharSequence)string2).length() == 0 : true, 2, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            String string2 = params.get("p2");
            return HillsKt.hillDecrypt$default(raw, string, null, string2 != null ? ((CharSequence)string2).length() == 0 : true, 2, null);
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            IntRange range = new IntRange(0, 25);
            List results = new ArrayList();
            int k1 = range.getFirst();
            int n = range.getLast();
            if (k1 <= n) {
                while (true) {
                    int n2;
                    int k2;
                    if ((k2 = range.getFirst()) <= (n2 = range.getLast())) {
                        while (true) {
                            int n3;
                            int k3;
                            if ((k3 = range.getFirst()) <= (n3 = range.getLast())) {
                                while (true) {
                                    int n4;
                                    int k4;
                                    if ((k4 = range.getFirst()) <= (n4 = range.getLast())) {
                                        while (true) {
                                            Object object;
                                            HILL hILL = this;
                                            try {
                                                HILL $this$crack_u24lambda_u240 = hILL;
                                                boolean bl = false;
                                                String decrypted = HillsKt.hillDecrypt$default(raw, "" + k1 + ' ' + k2 + ' ' + k3 + ' ' + k4, null, false, 2, null);
                                                if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                                                    results.add("hill " + k1 + ' ' + k2 + ' ' + k3 + ' ' + k4 + ": " + System.lineSeparator() + '\t' + decrypted);
                                                }
                                                object = Result.constructor-impl((Object)Unit.INSTANCE);
                                            }
                                            catch (Throwable throwable) {
                                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                            }
                                            if (k4 == n4) break;
                                            ++k4;
                                        }
                                    }
                                    if (k3 == n3) break;
                                    ++k3;
                                }
                            }
                            if (k2 == n2) break;
                            ++k2;
                        }
                    }
                    if (k1 == n) break;
                    ++k1;
                }
            }
            Iterable iterable = results;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.HandyCode", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$HandyCode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class HandyCode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        HandyCode() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "2 22 222 3 33 333 4 44 444 5 55 555 6 66 666 7 77 777 7777 8 88 888 9 99 999 9999";
            }
            return TableSubsKt.tableEncode$default(string3, string4, null, '\u0000', 6, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "2 22 222 3 33 333 4 44 444 5 55 555 6 66 666 7 77 777 7777 8 88 888 9 99 999 9999";
            }
            return TableSubsKt.tableDecode$default(string3, string4, null, '\u0000', 6, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.JJEncode", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class JJEncode
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        JJEncode() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "$";
            }
            String string2 = params.get("p2");
            return JavascriptCipher.INSTANCE.jjEncode(raw, string, string2 != null ? ((CharSequence)string2).length() == 0 : true);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return JavascriptCipher.INSTANCE.jjDecode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.MANCHESTER", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class MANCHESTER
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        MANCHESTER() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = params.get("c2");
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            return ManchesterCipherKt.manchester(raw, Boolean.parseBoolean(string), Boolean.parseBoolean(string3));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = params.get("c2");
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            return ManchesterCipherKt.manchesterDecode(raw, Boolean.parseBoolean(string), Boolean.parseBoolean(string3));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.MANCHESTER_DIFF", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class MANCHESTER_DIFF
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        MANCHESTER_DIFF() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return ManchesterCipherKt.manchesterDiff(raw, Boolean.parseBoolean(string));
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return ManchesterCipherKt.manchesterDiffDecode(raw, Boolean.parseBoolean(string));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.MORSE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$MORSE\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class MORSE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        MORSE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = ".";
            String string4 = MorseKt.morseEncrypt(raw);
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string5 = !bl2 ? string : null;
            if (string5 == null) {
                string5 = ".";
            }
            String string6 = StringsKt.replace$default((String)string4, (String)string3, (String)string5, (boolean)false, (int)4, null);
            it = string = params.get("p2");
            string3 = "-";
            string4 = string6;
            boolean bl3 = false;
            charSequence = it;
            bl2 = charSequence == null || charSequence.length() == 0;
            String string7 = !bl2 ? string : null;
            if (string7 == null) {
                string7 = "-";
            }
            return StringsKt.replace$default((String)string4, (String)string3, (String)string7, (boolean)false, (int)4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = ".";
            }
            it = string = params.get("p2");
            string3 = StringsKt.replace$default((String)string3, (String)string4, (String)".", (boolean)false, (int)4, null);
            boolean bl3 = false;
            charSequence = it;
            bl2 = charSequence == null || charSequence.length() == 0;
            String string5 = !bl2 ? string : null;
            if (string5 == null) {
                string5 = "-";
            }
            return MorseKt.morseDecrypt$default(StringsKt.replace$default((String)string3, (String)string5, (String)"-", (boolean)false, (int)4, null), null, null, null, 7, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.NIHILIST", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$NIHILIST\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class NIHILIST
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        NIHILIST() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return NihilistCipherKt.nihilist$default(string3, string5, string6, null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return NihilistCipherKt.nihilistDecrypt(string3, string5, string6);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.OTP", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class OTP
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        OTP() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return OneTimePadCipherKt.oneTimePad(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return OneTimePadCipherKt.oneTimePadDecrypt(raw, string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Ook", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class Ook
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Ook() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return OokKt.ookEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return OokKt.ookDecrypt(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.PLAYFAIR", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$PLAYFAIR\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class PLAYFAIR
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PLAYFAIR() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return PlayFairKt.playFair(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            return PlayFairKt.playFairDecrypt(string3, string4);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.POLYBIUS", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$POLYBIUS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class POLYBIUS
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        POLYBIUS() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return PolybiusSquareCipherKt.polybius$default(string3, string5, string6, null, 4, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
            }
            it = string = params.get("p2");
            String string5 = string4;
            boolean bl3 = false;
            charSequence = it;
            boolean bl4 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl4 ? string : null;
            if (string6 == null) {
                string6 = "12345";
            }
            return PolybiusSquareCipherKt.polybiusDecrypt(string3, string5, string6);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.PawnShop", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class PawnShop
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PawnShop() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PawnShopKt.pawnshop(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return PawnShopKt.pawnshopDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.PeriodicTable", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class PeriodicTable
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        PeriodicTable() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return ElementPeriodicTableKt.elementPeriodEncode(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return ElementPeriodicTableKt.elementPeriodDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Porta", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Porta\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Porta
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Porta() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "porta";
            }
            return PortaKt.porta(string3, string4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = string = params.get("p1");
            String string3 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string4 = !bl2 ? string : null;
            if (string4 == null) {
                string4 = "porta";
            }
            return PortaKt.porta(string3, string4);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.QWE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class QWE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        QWE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return QWEKt.qweEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return QWEKt.qweDecrypt(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\f"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.RAILFENCE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "hasCrack", "", "crack", "keyword", "app"})
    static final class RAILFENCE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        RAILFENCE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                Object object;
                String string4 = params.get("p1");
                Intrinsics.checkNotNull((Object)string4);
                string = RailFenceWKt.railFenceWEncrypt(raw, Integer.parseInt(string4), (object = params.get("p2")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0);
            } else {
                String string5 = params.get("p1");
                Intrinsics.checkNotNull((Object)string5);
                string = RailFenceKt.railFenceEncrypt(raw, Integer.parseInt(string5));
            }
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                Object object;
                String string4 = params.get("p1");
                Intrinsics.checkNotNull((Object)string4);
                string = RailFenceWKt.railFenceWDecrypt(raw, Integer.parseInt(string4), (object = params.get("p2")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0);
            } else {
                String string5 = params.get("p1");
                Intrinsics.checkNotNull((Object)string5);
                string = RailFenceKt.railFenceDecrypt(raw, Integer.parseInt(string5));
            }
            return string;
        }

        @Override
        public boolean hasCrack() {
            return true;
        }

        @Override
        @NotNull
        public String crack(@NotNull String raw, @NotNull String keyword, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            StringBuilder sb = new StringBuilder();
            Function2 func = (arg_0, arg_1) -> RAILFENCE.crack$lambda$0(params, arg_0, arg_1);
            int n = raw.length();
            for (int i = 2; i < n; ++i) {
                Object object;
                RAILFENCE rAILFENCE = this;
                try {
                    RAILFENCE $this$crack_u24lambda_u241 = rAILFENCE;
                    boolean bl = false;
                    String decrypted = (String)func.invoke((Object)raw, (Object)i);
                    if (ExtsKt.containsRegexIgnoreCase(decrypted, keyword)) {
                        StringBuilder stringBuilder = sb.append("railFence " + i + ": " + System.lineSeparator() + '\t' + decrypted);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                        stringBuilder.append('\n');
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                    continue;
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final String crack$lambda$0(Map $params, String s, int i) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Object v = $params.get("c1");
            if (v == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return Boolean.parseBoolean((String)v) ? RailFenceWKt.railFenceWDecrypt$default(s, i, 0, 2, null) : RailFenceKt.railFenceDecrypt(s, i);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ROT13", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ROT13
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT13() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift26$default(raw, 13, 0, 2, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift26$default(raw, 13, 0, 2, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ROT18", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ROT18
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT18() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.rot18(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.rot18(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ROT47", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ROT47
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT47() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift94(raw, 47);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift94(raw, 47);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ROT5", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ROT5
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift10(raw, 5);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return RotKt.shift10(raw, 5);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ROT8000", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class ROT8000
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ROT8000() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Rot8000Kt.rot8000$default(raw, 0, 1, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Rot8000Kt.rot8000$default(raw, 0, 1, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.RSA_CRACK", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$RSA_CRACK\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class RSA_CRACK
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        RSA_CRACK() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return this.decrypt(raw, params);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Map<String, BigInteger> $this$decrypt_u24lambda_u240 = ParamsParserKt.parseRsaParams(raw);
            boolean bl = false;
            return RsaSolver.INSTANCE.solve($this$decrypt_u24lambda_u240);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Rabbit", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class Rabbit
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Rabbit() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            return JavascriptCipher.INSTANCE.rabbitEncrypt(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                string = "";
            }
            return JavascriptCipher.INSTANCE.rabbitDecrypt(raw, string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.SOCIALISM", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class SOCIALISM
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        SOCIALISM() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return SocialistCoreValuesKt.socialistCoreValues(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return SocialistCoreValuesKt.socialistCoreValuesDecrypt(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.STEG_BASE64", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class STEG_BASE64
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        STEG_BASE64() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = params.get("c1");
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            return Base64StegKt.baseStegEncrypt(raw, FilesKt.readText$default((File)FileKt.toFile(string), null, (int)1, null), Boolean.parseBoolean(string3) ? "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567" : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("c1");
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            return Base64StegKt.baseStegDecrypt(raw, Boolean.parseBoolean(string) ? "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567" : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.STEM_BRANCH", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class STEM_BRANCH
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        STEM_BRANCH() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Base60Kt.stemBranch(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Base60Kt.stemBranchDecode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.TAP_CODE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class TAP_CODE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TAP_CODE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TapCodeCipherKt.tapCode$default(raw, null, null, 3, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TapCodeCipherKt.tapCodeDecrypt$default(raw, null, null, 3, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.TROLLSCRIPT", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class TROLLSCRIPT
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TROLLSCRIPT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TrollScriptKt.trollScriptEncrypt(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TrollScriptKt.trollScriptDecrypt(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.TWIN_HEX", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    static final class TWIN_HEX
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TWIN_HEX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TwinHexCipherKt.twinHex(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TwinHexCipherKt.twinHexDecrypt(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.TYPE7", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$TYPE7\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class TYPE7
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        TYPE7() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            int n;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = raw;
            String string2 = params.get("p1");
            if (string2 != null) {
                void it;
                String string3;
                String string4 = string3 = string2;
                String string5 = string;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                string = string5;
                string2 = bl2 ? string3 : null;
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                    return Type7Kt.type7(string, n);
                }
            }
            n = 0;
            return Type7Kt.type7(string, n);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Type7Kt.type7Decode(raw);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Trifid", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Trifid\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Trifid
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Trifid() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string = params.get("p2");
            String string4 = string2;
            String string5 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl2 ? string : null;
            return TrifidKt.trifid(string5, string4, string6 != null ? Integer.parseInt(string6) : 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void it;
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("p1");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string = params.get("p2");
            String string4 = string2;
            String string5 = raw;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl2 = charSequence == null || charSequence.length() == 0;
            String string6 = !bl2 ? string : null;
            return TrifidKt.trifidDecrypt(string5, string4, string6 != null ? Integer.parseInt(string6) : 5);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.VIRGENENE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class VIRGENENE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        VIRGENENE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return VirgeneneKt.virgeneneEncode(raw, string);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = params.get("p1");
            Intrinsics.checkNotNull((Object)string);
            return VirgeneneKt.virgeneneDecode$default(raw, string, 0, 2, null);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Vowel", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class Vowel
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Vowel() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return TableSubsKt.tableEncode$default(raw, "1 11 12 13 2 21 22 23 3 31 32 33 34 35 4 41 42 43 44 45 5 51 52 53 54 55", null, '\u0000', 6, null);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = TableSubsKt.tableDecode$default(raw, "1 11 12 13 2 21 22 23 3 31 32 33 34 35 4 41 42 43 44 45 5 51 52 53 54 55", null, '\u0000', 6, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.YYGQ", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "isIgnoreSpace", "", "app"})
    static final class YYGQ
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        YYGQ() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return YygqCipherKt.yygq(raw);
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return YygqCipherKt.yygqDecode(raw);
        }

        @Override
        public boolean isIgnoreSpace() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ZWC", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$ZWC\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,756:1\n1#2:757\n488#3,11:758\n*S KotlinDebug\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$ZWC\n*L\n347#1:758,11\n*E\n"})
    static final class ZWC
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ZWC() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String string4;
                String string5 = raw;
                String string6 = params.get("p1");
                if (string6 != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = string6;
                    if (charSequence2.length() == 0) {
                        String string7 = string5;
                        boolean bl = false;
                        charSequence = "show";
                        string5 = string7;
                    } else {
                        charSequence = charSequence2;
                    }
                    string4 = (String)charSequence;
                } else {
                    string4 = "show";
                }
                string = ZeroWidthCharKt.zwcMorse(string5, string4);
            } else {
                String string8;
                String string9 = raw;
                String string10 = params.get("p1");
                if (string10 != null) {
                    CharSequence charSequence;
                    CharSequence charSequence3 = string10;
                    if (charSequence3.length() == 0) {
                        String string11 = string9;
                        boolean bl = false;
                        charSequence = "show";
                        string9 = string11;
                    } else {
                        charSequence = charSequence3;
                    }
                    string8 = (String)charSequence;
                } else {
                    string8 = "show";
                }
                string = ZeroWidthCharKt.zwcBinary(string9, string8);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            StringBuilder $this$decrypt_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String string = raw;
            StringBuilder stringBuilder2 = $this$decrypt_u24lambda_u240;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl2 = false;
                if (ZeroWidthCharKt.getZeroWidthDict().contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            stringBuilder2.append(((StringBuilder)destination$iv$iv).toString());
            $this$decrypt_u24lambda_u240.append('\n');
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            $this$decrypt_u24lambda_u240.append(Boolean.parseBoolean(string2) ? ZeroWidthCharKt.zwcMorseDecode(raw) : ZeroWidthCharKt.zwcBinaryDecode(raw));
            return stringBuilder.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.ZWC_UNICODE", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$ZWC_UNICODE\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,756:1\n1#2:757\n488#3,11:758\n*S KotlinDebug\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$ZWC_UNICODE\n*L\n373#1:758,11\n*E\n"})
    static final class ZWC_UNICODE
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        ZWC_UNICODE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string2 = params.get("c1");
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            if (Boolean.parseBoolean(string2)) {
                String string4;
                String string5;
                String string6;
                CharSequence charSequence;
                String string7 = raw;
                String string8 = params.get("p1");
                if (string8 != null) {
                    CharSequence charSequence2;
                    charSequence = string8;
                    if (charSequence.length() == 0) {
                        string6 = string7;
                        boolean bl = false;
                        charSequence2 = "show";
                        string7 = string6;
                    } else {
                        charSequence2 = charSequence;
                    }
                    string5 = (String)charSequence2;
                } else {
                    string5 = "show";
                }
                String string9 = params.get("p2");
                if (string9 != null) {
                    CharSequence charSequence3;
                    charSequence = string9;
                    if (charSequence.length() == 0) {
                        String string10 = string5;
                        string6 = string7;
                        boolean bl = false;
                        String string11 = "\\u200c\\u200d\\u202c\\ufeff";
                        string7 = string6;
                        string5 = string10;
                        charSequence3 = string11;
                    } else {
                        charSequence3 = charSequence;
                    }
                    string4 = (String)charSequence3;
                } else {
                    string4 = "\\u200c\\u200d\\u202c\\ufeff";
                }
                string = ZeroWidthCharKt.zwcUnicodeBinary(string7, string5, string4);
            } else {
                String string12;
                String string13;
                String string14;
                CharSequence charSequence;
                String string15 = raw;
                String string16 = params.get("p1");
                if (string16 != null) {
                    CharSequence charSequence4;
                    charSequence = string16;
                    if (charSequence.length() == 0) {
                        string14 = string15;
                        boolean bl = false;
                        charSequence4 = "show";
                        string15 = string14;
                    } else {
                        charSequence4 = charSequence;
                    }
                    string13 = (String)charSequence4;
                } else {
                    string13 = "show";
                }
                String string17 = params.get("p2");
                if (string17 != null) {
                    CharSequence charSequence5;
                    charSequence = string17;
                    if (charSequence.length() == 0) {
                        String string18 = string13;
                        string14 = string15;
                        boolean bl = false;
                        String string19 = "\\u200c\\u200d\\u202c\\ufeff";
                        string15 = string14;
                        string13 = string18;
                        charSequence5 = string19;
                    } else {
                        charSequence5 = charSequence;
                    }
                    string12 = (String)charSequence5;
                } else {
                    string12 = "\\u200c\\u200d\\u202c\\ufeff";
                }
                string = ZeroWidthCharKt.zwcUnicode(string15, string13, string12);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            block15: {
                String string2;
                String string3;
                block17: {
                    block16: {
                        CharSequence charSequence;
                        CharSequence charSequence2;
                        StringBuilder stringBuilder3;
                        block12: {
                            String string4;
                            String string5;
                            block14: {
                                block13: {
                                    CharSequence charSequence3;
                                    void $this$filterNotTo$iv$iv;
                                    void $this$filterNot$iv;
                                    Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
                                    Intrinsics.checkNotNullParameter(params, (String)"params");
                                    StringBuilder $this$decrypt_u24lambda_u240 = stringBuilder2 = new StringBuilder();
                                    boolean bl = false;
                                    String string6 = raw;
                                    stringBuilder3 = $this$decrypt_u24lambda_u240;
                                    boolean $i$f$filterNot = false;
                                    charSequence2 = (CharSequence)$this$filterNot$iv;
                                    Appendable destination$iv$iv = new StringBuilder();
                                    boolean $i$f$filterNotTo = false;
                                    for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                                        char element$iv$iv;
                                        char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                                        boolean bl2 = false;
                                        if (ZeroWidthCharKt.getZeroWidthDict().contains(Character.valueOf(it))) continue;
                                        destination$iv$iv.append(element$iv$iv);
                                    }
                                    stringBuilder3.append(((StringBuilder)destination$iv$iv).toString());
                                    $this$decrypt_u24lambda_u240.append('\n');
                                    stringBuilder = $this$decrypt_u24lambda_u240;
                                    String string7 = params.get("c1");
                                    if (string7 == null) {
                                        String string8 = "Required value was null.";
                                        throw new IllegalArgumentException(string8.toString());
                                    }
                                    if (!Boolean.parseBoolean(string7)) break block12;
                                    string5 = raw;
                                    string4 = params.get("p2");
                                    if (string4 == null) break block13;
                                    charSequence2 = string4;
                                    if (charSequence2.length() == 0) {
                                        String string9 = string5;
                                        stringBuilder3 = stringBuilder;
                                        boolean bl3 = false;
                                        String string10 = "\\u200c\\u200d\\u202c\\ufeff";
                                        stringBuilder = stringBuilder3;
                                        string5 = string9;
                                        charSequence3 = string10;
                                    } else {
                                        charSequence3 = charSequence2;
                                    }
                                    if ((string4 = (String)charSequence3) != null) break block14;
                                }
                                string4 = "\\u200c\\u200d\\u202c\\ufeff";
                            }
                            string = ZeroWidthCharKt.zwcUnicodeDecodeBinary(string5, string4);
                            break block15;
                        }
                        string3 = raw;
                        string2 = params.get("p2");
                        if (string2 == null) break block16;
                        charSequence2 = string2;
                        if (charSequence2.length() == 0) {
                            String string11 = string3;
                            stringBuilder3 = stringBuilder;
                            boolean bl = false;
                            String string12 = "\\u200c\\u200d\\u202c\\ufeff";
                            stringBuilder = stringBuilder3;
                            string3 = string11;
                            charSequence = string12;
                        } else {
                            charSequence = charSequence2;
                        }
                        if ((string2 = (String)charSequence) != null) break block17;
                    }
                    string2 = "\\u200c\\u200d\\u202c\\ufeff";
                }
                string = ZeroWidthCharKt.zwcUnicodeDecode(string3, string2);
            }
            stringBuilder.append(string);
            return stringBuilder2.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a8\u0006\b"}, d2={"me/leon/ext/crypto/ClassicalCryptoType.Zero1248", "Lme/leon/ext/crypto/ClassicalCryptoType;", "encrypt", "", "raw", "params", "", "decrypt", "app"})
    @SourceDebugExtension(value={"SMAP\nClassicalCryptoType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicalCryptoType.kt\nme/leon/ext/crypto/ClassicalCryptoType$Zero1248\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    static final class Zero1248
    extends ClassicalCryptoType {
        /*
         * WARNING - void declaration
         */
        Zero1248() {
            void var1_1;
        }

        @Override
        @NotNull
        public String encrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String it = string = Zero1248Kt.zero1248(raw);
            boolean bl = false;
            System.out.println((Object)("01248 " + raw + ' ' + params));
            return string;
        }

        @Override
        @NotNull
        public String decrypt(@NotNull String raw, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return Zero1248Kt.zero1248Decode(raw);
        }
    }
}

