/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ext.crypto.GMac;
import me.leon.ext.crypto.GMacKt;
import me.leon.ext.crypto.Poly1305Serial;
import org.bouncycastle.crypto.macs.KGMac;
import org.bouncycastle.crypto.macs.Zuc128Mac;
import org.bouncycastle.crypto.macs.Zuc256Mac;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006J&\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006R9\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lme/leon/ext/crypto/MACs;", "", "<init>", "()V", "algorithm", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "getAlgorithm", "()Ljava/util/LinkedHashMap;", "mac", "", "data", "keyByteArray", "alg", "macWithIv", "ivByteArray", "app"})
public final class MACs {
    @NotNull
    public static final MACs INSTANCE = new MACs();
    @NotNull
    private static final LinkedHashMap<String, List<String>> algorithm;

    private MACs() {
    }

    @NotNull
    public final LinkedHashMap<String, List<String>> getAlgorithm() {
        return algorithm;
    }

    @NotNull
    public final byte[] mac(@NotNull byte[] data, @NotNull byte[] keyByteArray, @NotNull String alg) {
        Mac mac;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)keyByteArray, (String)"keyByteArray");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Mac $this$mac_u24lambda_u240 = mac = Mac.getInstance(alg);
        boolean bl = false;
        $this$mac_u24lambda_u240.init(new SecretKeySpec(keyByteArray, alg));
        $this$mac_u24lambda_u240.update(data);
        byte[] byArray = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] macWithIv(@NotNull byte[] data, @NotNull byte[] keyByteArray, @NotNull byte[] ivByteArray, @NotNull String alg) {
        byte[] byArray;
        block19: {
            org.bouncycastle.crypto.Mac mac;
            block20: {
                block18: {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullParameter((Object)keyByteArray, (String)"keyByteArray");
                    Intrinsics.checkNotNullParameter((Object)ivByteArray, (String)"ivByteArray");
                    Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
                    if (!StringsKt.contains$default((CharSequence)alg, (CharSequence)"POLY1305", (boolean)false, (int)2, null)) break block18;
                    byArray = GMacKt.macWithIv((org.bouncycastle.crypto.Mac)Poly1305Serial.INSTANCE.getInstance(alg), keyByteArray, ivByteArray, data);
                    break block19;
                }
                if (!StringsKt.contains$default((CharSequence)alg, (CharSequence)"GMAC", (boolean)false, (int)2, null)) break block20;
                org.bouncycastle.crypto.Mac $this$macWithIv_u24lambda_u240 = GMac.INSTANCE.getInstance(alg);
                boolean bl = false;
                org.bouncycastle.crypto.Mac mac2 = $this$macWithIv_u24lambda_u240;
                byArray = mac2 instanceof org.bouncycastle.crypto.macs.GMac ? GMacKt.macWithIv($this$macWithIv_u24lambda_u240, keyByteArray, ivByteArray, data) : (mac2 instanceof KGMac ? GMacKt.macWithIv($this$macWithIv_u24lambda_u240, keyByteArray, ivByteArray, data) : new byte[]{});
                break block19;
            }
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            switch (string) {
                case "ZUC-128": {
                    mac = (org.bouncycastle.crypto.Mac)new Zuc128Mac();
                    break;
                }
                case "ZUC-256-32": {
                    mac = (org.bouncycastle.crypto.Mac)new Zuc256Mac(32);
                    break;
                }
                case "ZUC-256-64": {
                    mac = (org.bouncycastle.crypto.Mac)new Zuc256Mac(64);
                    break;
                }
                case "ZUC-256-128": 
                case "ZUC-256": {
                    mac = (org.bouncycastle.crypto.Mac)new Zuc256Mac(128);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported algorithm".toString());
                }
            }
            org.bouncycastle.crypto.Mac mac3 = mac;
            byArray = GMacKt.macWithIv(mac3, keyByteArray, ivByteArray, data);
        }
        return byArray;
    }

    static {
        Pair[] pairArray = new Pair[33];
        pairArray[0] = TuplesKt.to((Object)"HmacMD5", (Object)CollectionsKt.listOf((Object)"128"));
        pairArray[1] = TuplesKt.to((Object)"HmacMD4", (Object)CollectionsKt.listOf((Object)"128"));
        pairArray[2] = TuplesKt.to((Object)"HmacMD2", (Object)CollectionsKt.listOf((Object)"128"));
        pairArray[3] = TuplesKt.to((Object)"HmacSM3", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[4] = TuplesKt.to((Object)"HmacTiger", (Object)CollectionsKt.listOf((Object)"192"));
        pairArray[5] = TuplesKt.to((Object)"HmacWhirlpool", (Object)CollectionsKt.listOf((Object)"512"));
        pairArray[6] = TuplesKt.to((Object)"HmacSHA1", (Object)CollectionsKt.listOf((Object)"160"));
        Object[] objectArray = new String[]{"224", "256", "384", "512", "512/224", "512/256"};
        pairArray[7] = TuplesKt.to((Object)"HmacSHA2", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"224", "256", "384", "512"};
        pairArray[8] = TuplesKt.to((Object)"HmacSHA3", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"128", "160", "256", "320"};
        pairArray[9] = TuplesKt.to((Object)"HmacRIPEMD", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"224", "256", "288", "384", "512"};
        pairArray[10] = TuplesKt.to((Object)"HmacKeccak", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"256", "384", "512"};
        pairArray[11] = TuplesKt.to((Object)"HmacDSTU7564", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"128", "256"};
        pairArray[12] = TuplesKt.to((Object)"KMAC", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"2-4", "4-8"};
        pairArray[13] = TuplesKt.to((Object)"SIPHASH", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"2-4", "4-8"};
        pairArray[14] = TuplesKt.to((Object)"SIPHASH128", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"256", "384", "512"};
        pairArray[15] = TuplesKt.to((Object)"HmacDSTU7564", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"256-128", "256-160", "256-224", "256-256", "512-128", "512-160", "512-224", "512-256", "512-384", "512-512", "1024-384", "1024-512", "1024-1024"};
        pairArray[16] = TuplesKt.to((Object)"HmacSkein", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[17] = TuplesKt.to((Object)"HmacGOST3411", (Object)CollectionsKt.listOf((Object)"256"));
        objectArray = new String[]{"256", "512"};
        pairArray[18] = TuplesKt.to((Object)"HmacGOST3411-2012", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"AES", "ARIA", "CAMELLIA", "CAST6", "NOEKEON", "RC6", "SEED", "SERPENT", "SM4", "Twofish"};
        pairArray[19] = TuplesKt.to((Object)"POLY1305", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"AES", "ARIA", "CAMELLIA", "CAST6", "NOEKEON", "RC6", "SEED", "SERPENT", "SM4", "Twofish"};
        pairArray[20] = TuplesKt.to((Object)"GMAC", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[21] = TuplesKt.to((Object)"AESCMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[22] = TuplesKt.to((Object)"IDEAMAC", (Object)CollectionsKt.listOf((Object)"-"));
        pairArray[23] = TuplesKt.to((Object)"DESCMAC", (Object)CollectionsKt.listOf((Object)"-"));
        pairArray[24] = TuplesKt.to((Object)"BLOWFISHCMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[25] = TuplesKt.to((Object)"DESCMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[26] = TuplesKt.to((Object)"DESEDECMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[27] = TuplesKt.to((Object)"SEED-CMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[28] = TuplesKt.to((Object)"Shacal-2CMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[29] = TuplesKt.to((Object)"SM4-CMAC", (Object)CollectionsKt.listOf((Object)"256"));
        pairArray[30] = TuplesKt.to((Object)"ZUC-128", (Object)CollectionsKt.listOf((Object)"32"));
        objectArray = new String[]{"32", "64", "128"};
        pairArray[31] = TuplesKt.to((Object)"ZUC-256", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"256CMAC", "512CMAC", "1024CMAC"};
        pairArray[32] = TuplesKt.to((Object)"Threefish", (Object)CollectionsKt.listOf((Object[])objectArray));
        algorithm = MapsKt.linkedMapOf((Pair[])pairArray);
    }
}

