/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.BigIntegers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0007\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\rH\u0002\u001a$\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"x9ECParameters", "Lorg/bouncycastle/asn1/x9/X9ECParameters;", "kotlin.jvm.PlatformType", "ecDomainParameters", "Lorg/bouncycastle/crypto/params/ECDomainParameters;", "toECPrivateKeyParams", "Lorg/bouncycastle/crypto/params/AsymmetricKeyParameter;", "", "toECPublicKeyParams", "generatePrivateKeyParameter", "key", "Ljava/security/PrivateKey;", "generatePublicKeyParameter", "Ljava/security/PublicKey;", "sm2", "isEncrypt", "", "params", "Lorg/bouncycastle/crypto/CipherParameters;", "mode", "Lorg/bouncycastle/crypto/engines/SM2Engine$Mode;", "app"})
public final class SMKt {
    private static final X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    @NotNull
    private static final ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());

    @NotNull
    public static final AsymmetricKeyParameter toECPrivateKeyParams(@NotNull byte[] $this$toECPrivateKeyParams) {
        Intrinsics.checkNotNullParameter((Object)$this$toECPrivateKeyParams, (String)"<this>");
        try {
            return (AsymmetricKeyParameter)new ECPrivateKeyParameters(BigIntegers.fromUnsignedByteArray((byte[])$this$toECPrivateKeyParams), ecDomainParameters);
        }
        catch (Exception exception) {
            PrivateKey privateKey;
            try {
                privateKey = KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec($this$toECPrivateKeyParams));
            }
            catch (Exception ignore) {
                privateKey = KeyFactory.getInstance("EC").generatePrivate((KeySpec)new OpenSSHPrivateKeySpec($this$toECPrivateKeyParams));
            }
            PrivateKey privateKey2 = privateKey;
            Intrinsics.checkNotNull((Object)privateKey2);
            return SMKt.generatePrivateKeyParameter(privateKey2);
        }
    }

    @NotNull
    public static final AsymmetricKeyParameter toECPublicKeyParams(@NotNull byte[] $this$toECPublicKeyParams) {
        Intrinsics.checkNotNullParameter((Object)$this$toECPublicKeyParams, (String)"<this>");
        try {
            return (AsymmetricKeyParameter)new ECPublicKeyParameters(ecDomainParameters.getCurve().decodePoint($this$toECPublicKeyParams), ecDomainParameters);
        }
        catch (Exception exception) {
            PublicKey publicKey;
            try {
                publicKey = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec($this$toECPublicKeyParams));
            }
            catch (Exception ignore) {
                publicKey = KeyFactory.getInstance("EC").generatePublic((KeySpec)new OpenSSHPublicKeySpec($this$toECPublicKeyParams));
            }
            PublicKey publicKey2 = publicKey;
            Intrinsics.checkNotNull((Object)publicKey2);
            return SMKt.generatePublicKeyParameter(publicKey2);
        }
    }

    private static final AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        PrivateKey privateKey = key;
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKeyParameters eCPrivateKeyParameters;
            org.bouncycastle.jce.spec.ECParameterSpec s = ((ECPrivateKey)key).getParameters();
            if (s == null) {
                s = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            }
            if (((ECPrivateKey)key).getParameters() instanceof ECNamedCurveParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = ((ECPrivateKey)key).getParameters();
                Intrinsics.checkNotNull((Object)eCParameterSpec, (String)"null cannot be cast to non-null type org.bouncycastle.jce.spec.ECNamedCurveParameterSpec");
                String name = ((ECNamedCurveParameterSpec)eCParameterSpec).getName();
                BigInteger bigInteger = ((ECPrivateKey)key).getD();
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECNamedCurveTable.getOID((String)name);
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = s;
                Intrinsics.checkNotNull((Object)eCParameterSpec2);
                eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, eCParameterSpec2.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
            } else {
                BigInteger bigInteger = ((ECPrivateKey)key).getD();
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = s;
                Intrinsics.checkNotNull((Object)eCParameterSpec);
                eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, new ECDomainParameters(eCParameterSpec.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
            }
            asymmetricKeyParameter = (AsymmetricKeyParameter)eCPrivateKeyParameters;
        } else if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            org.bouncycastle.jce.spec.ECParameterSpec s = EC5Util.convertSpec((ECParameterSpec)((java.security.interfaces.ECPrivateKey)key).getParams());
            asymmetricKeyParameter = (AsymmetricKeyParameter)new ECPrivateKeyParameters(((java.security.interfaces.ECPrivateKey)key).getS(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        } else {
            byte[] bytes = key.getEncoded();
            PrivateKey privateKey2 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)bytes));
            AsymmetricKeyParameter asymmetricKeyParameter2 = ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey2);
            Intrinsics.checkNotNull((Object)asymmetricKeyParameter2);
            asymmetricKeyParameter = asymmetricKeyParameter2;
        }
        return asymmetricKeyParameter;
    }

    private static final AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        PublicKey publicKey = key;
        if (publicKey instanceof org.bouncycastle.jce.interfaces.ECPublicKey) {
            org.bouncycastle.jce.spec.ECParameterSpec s = ((org.bouncycastle.jce.interfaces.ECPublicKey)key).getParameters();
            asymmetricKeyParameter = (AsymmetricKeyParameter)new ECPublicKeyParameters(((org.bouncycastle.jce.interfaces.ECPublicKey)key).getQ(), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        } else if (publicKey instanceof ECPublicKey) {
            org.bouncycastle.jce.spec.ECParameterSpec s = EC5Util.convertSpec((ECParameterSpec)((ECPublicKey)key).getParams());
            asymmetricKeyParameter = (AsymmetricKeyParameter)new ECPublicKeyParameters(EC5Util.convertPoint((ECParameterSpec)((ECPublicKey)key).getParams(), (ECPoint)((ECPublicKey)key).getW()), new ECDomainParameters(s.getCurve(), s.getG(), s.getN(), s.getH(), s.getSeed()));
        } else {
            byte[] bytes = key.getEncoded();
            PublicKey publicKey2 = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)SubjectPublicKeyInfo.getInstance((Object)bytes));
            AsymmetricKeyParameter asymmetricKeyParameter2 = ECUtil.generatePublicKeyParameter((PublicKey)publicKey2);
            Intrinsics.checkNotNull((Object)asymmetricKeyParameter2);
            asymmetricKeyParameter = asymmetricKeyParameter2;
        }
        return asymmetricKeyParameter;
    }

    @NotNull
    public static final byte[] sm2(@NotNull byte[] $this$sm2, boolean isEncrypt, @NotNull CipherParameters params, @NotNull SM2Engine.Mode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$sm2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        SM2Engine $this$sm2_u24lambda_u240 = new SM2Engine(mode);
        boolean bl = false;
        $this$sm2_u24lambda_u240.init(isEncrypt, isEncrypt ? (CipherParameters)new ParametersWithRandom(params, new SecureRandom()) : params);
        byte[] byArray = $this$sm2_u24lambda_u240.processBlock($this$sm2, 0, $this$sm2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"with(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] sm2$default(byte[] byArray, boolean bl, CipherParameters cipherParameters, SM2Engine.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            mode = SM2Engine.Mode.C1C3C2;
        }
        return SMKt.sm2(byArray, bl, cipherParameters, mode);
    }
}

