/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ExceptionKt;
import me.leon.ext.crypto.AsymmetircCryptoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\"\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a*\u0010\u0007\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001\u001a\u0006\u0010\u0012\u001a\u00020\u0013\"\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"properKeyPairAlg", "", "sign", "", "kpAlg", "sigAlg", "pri", "verify", "", "pub", "signed", "ecdsaCurveMap", "", "getEcdsaCurveMap", "()Ljava/util/Map;", "generateEcKeyPair", "Ljava/security/KeyPair;", "jwtAlg", "main", "", "app"})
@SourceDebugExtension(value={"SMAP\nSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signature.kt\nme/leon/ext/crypto/SignatureKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class SignatureKt {
    @NotNull
    private static final Map<String, String> ecdsaCurveMap;

    private static final String properKeyPairAlg(String $this$properKeyPairAlg) {
        String string;
        String it = string = $this$properKeyPairAlg;
        boolean bl = false;
        String string2 = !StringsKt.equals((String)it, (String)"SM2", (boolean)true) ? string : null;
        if (string2 == null) {
            string2 = "EC";
        }
        return string2;
    }

    @NotNull
    public static final byte[] sign(@NotNull byte[] $this$sign, @NotNull String kpAlg, @NotNull String sigAlg, @NotNull String pri) {
        Signature signature;
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kpAlg, (String)"kpAlg");
        Intrinsics.checkNotNullParameter((Object)sigAlg, (String)"sigAlg");
        Intrinsics.checkNotNullParameter((Object)pri, (String)"pri");
        Signature $this$sign_u24lambda_u240 = signature = Signature.getInstance(SignatureKt.properKeyPairAlg(sigAlg));
        boolean bl = false;
        $this$sign_u24lambda_u240.initSign(AsymmetircCryptoKt.toPrivateKey(pri, kpAlg));
        $this$sign_u24lambda_u240.update($this$sign);
        byte[] byArray = signature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public static final boolean verify(@NotNull byte[] $this$verify, @NotNull String kpAlg, @NotNull String sigAlg, @NotNull String pub, @NotNull byte[] signed) {
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kpAlg, (String)"kpAlg");
        Intrinsics.checkNotNullParameter((Object)sigAlg, (String)"sigAlg");
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)signed, (String)"signed");
        return (Boolean)ExceptionKt.catch(SignatureKt::verify$lambda$0, () -> SignatureKt.verify$lambda$1(sigAlg, signed, pub, kpAlg, $this$verify));
    }

    @NotNull
    public static final Map<String, String> getEcdsaCurveMap() {
        return ecdsaCurveMap;
    }

    @Nullable
    public static final KeyPair generateEcKeyPair(@NotNull String jwtAlg) {
        Intrinsics.checkNotNullParameter((Object)jwtAlg, (String)"jwtAlg");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec spec = new ECGenParameterSpec(ecdsaCurveMap.get(jwtAlg));
        kpg.initialize(spec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static /* synthetic */ KeyPair generateEcKeyPair$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "ES256";
        }
        return SignatureKt.generateEcKeyPair(string);
    }

    public static final void main() {
        block0: {
            KeyPair keyPair = SignatureKt.generateEcKeyPair$default(null, 1, null);
            if (keyPair == null) break block0;
            KeyPair it = keyPair;
            boolean bl = false;
            byte[] byArray = it.getPublic().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            System.out.println((Object)Base64Kt.base64$default(byArray, null, false, 3, null));
            byte[] byArray2 = it.getPrivate().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
            System.out.println((Object)Base64Kt.base64$default(byArray2, null, false, 3, null));
        }
    }

    public static /* synthetic */ void main(String[] args) {
        SignatureKt.main();
    }

    private static final boolean verify$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("verify err  " + it));
        return false;
    }

    private static final boolean verify$lambda$1(String $sigAlg, byte[] $signed, String $pub, String $kpAlg, byte[] $this_verify) {
        Signature signature;
        Signature $this$verify_u24lambda_u241_u240 = signature = Signature.getInstance(SignatureKt.properKeyPairAlg($sigAlg));
        boolean bl = false;
        $this$verify_u24lambda_u241_u240.initVerify(AsymmetircCryptoKt.toPublicKey($pub, $kpAlg));
        $this$verify_u24lambda_u241_u240.update($this_verify);
        return signature.verify($signed);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ES256", (Object)"secp256r1"), TuplesKt.to((Object)"ES384", (Object)"secp384r1"), TuplesKt.to((Object)"ES512", (Object)"secp521r1")};
        ecdsaCurveMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

