/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a,\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a,\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a0\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a4\u0010\u0010\u001a\u00020\u0011*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a4\u0010\u0013\u001a\u00020\u0011*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005\u001a \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"AEAD_MODE_REG", "Lkotlin/text/Regex;", "getAEAD_MODE_REG", "()Lkotlin/text/Regex;", "encrypt", "", "key", "iv", "alg", "", "associatedData", "decrypt", "makeCipher", "Ljavax/crypto/Cipher;", "cipherMode", "", "encryptFile", "", "outFileName", "decryptFile", "doStreamCrypto", "cipher", "path", "app"})
@SourceDebugExtension(value={"SMAP\nSymmetricCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymmetricCrypto.kt\nme/leon/ext/crypto/SymmetricCryptoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class SymmetricCryptoKt {
    @NotNull
    private static final Regex AEAD_MODE_REG = new Regex("GCM|EAX|CCM|OCB|ChaCha20-Poly1305");

    @NotNull
    public static final Regex getAEAD_MODE_REG() {
        return AEAD_MODE_REG;
    }

    @NotNull
    public static final byte[] encrypt(@NotNull byte[] $this$encrypt, @NotNull byte[] key, @NotNull byte[] iv, @NotNull String alg, @NotNull byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        byte[] byArray = SymmetricCryptoKt.makeCipher(alg, key, iv, 1, associatedData).doFinal($this$encrypt);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] encrypt$default(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, byte[] byArray4, int n, Object object) {
        if ((n & 8) != 0) {
            byArray4 = new byte[]{};
        }
        return SymmetricCryptoKt.encrypt(byArray, byArray2, byArray3, string, byArray4);
    }

    @NotNull
    public static final byte[] decrypt(@NotNull byte[] $this$decrypt, @NotNull byte[] key, @NotNull byte[] iv, @NotNull String alg, @NotNull byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        byte[] byArray = SymmetricCryptoKt.makeCipher(alg, key, iv, 2, associatedData).doFinal($this$decrypt);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] decrypt$default(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, byte[] byArray4, int n, Object object) {
        if ((n & 8) != 0) {
            byArray4 = new byte[]{};
        }
        return SymmetricCryptoKt.decrypt(byArray, byArray2, byArray3, string, byArray4);
    }

    @NotNull
    public static final Cipher makeCipher(@NotNull String alg, @NotNull byte[] key, @NotNull byte[] iv, int cipherMode, @NotNull byte[] associatedData) {
        Cipher cipher;
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        Cipher $this$makeCipher_u24lambda_u240 = cipher = Cipher.getInstance(alg);
        boolean bl = false;
        SecretKey keySpec = new SecretKeySpec(key, StringsKt.substringBefore$default((String)alg, (String)"/", null, (int)2, null));
        Object object = alg;
        if (new Regex("ECB|RC4").containsMatchIn((CharSequence)object)) {
            $this$makeCipher_u24lambda_u240.init(cipherMode, keySpec);
        } else if (StringsKt.equals((String)alg, (String)"ChaCha20", (boolean)true)) {
            Object object2;
            Object $this$makeCipher_u24lambda_u240_u240;
            object = $this$makeCipher_u24lambda_u240;
            Key key2 = keySpec;
            int n = cipherMode;
            Cipher cipher2 = $this$makeCipher_u24lambda_u240;
            try {
                $this$makeCipher_u24lambda_u240_u240 = object;
                boolean bl2 = false;
                $this$makeCipher_u24lambda_u240_u240 = Result.constructor-impl((Object)new ChaCha20ParameterSpec(iv, 0));
            }
            catch (Throwable bl2) {
                $this$makeCipher_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            Object object3 = $this$makeCipher_u24lambda_u240_u240;
            Cipher cipher3 = cipher2;
            int n2 = n;
            Key key3 = key2;
            object = object3;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                object2 = object;
            } else {
                $this$makeCipher_u24lambda_u240_u240 = throwable;
                key2 = key3;
                n = n2;
                cipher2 = cipher3;
                boolean bl3 = false;
                object3 = (AlgorithmParameterSpec)new AEADParameterSpec(iv, 128);
                cipher3 = cipher2;
                n2 = n;
                key3 = key2;
                object2 = object3;
            }
            cipher3.init(n2, key3, (AlgorithmParameterSpec)object2);
        } else {
            $this$makeCipher_u24lambda_u240.init(cipherMode, (Key)keySpec, new IvParameterSpec(iv));
            Object it = object = Unit.INSTANCE;
            boolean bl4 = false;
            if (AEAD_MODE_REG.containsMatchIn((CharSequence)alg) && !(associatedData.length == 0)) {
                $this$makeCipher_u24lambda_u240.updateAAD(associatedData);
            }
        }
        Cipher cipher4 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher4, (String)"apply(...)");
        return cipher4;
    }

    public static /* synthetic */ Cipher makeCipher$default(String string, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            byArray3 = new byte[]{};
        }
        return SymmetricCryptoKt.makeCipher(string, byArray, byArray2, n, byArray3);
    }

    public static final void encryptFile(@NotNull String $this$encryptFile, @NotNull byte[] key, @NotNull byte[] iv, @NotNull String alg, @NotNull String outFileName, @NotNull byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)$this$encryptFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)outFileName, (String)"outFileName");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        Cipher cipher = SymmetricCryptoKt.makeCipher(alg, key, iv, 1, associatedData);
        SymmetricCryptoKt.doStreamCrypto(outFileName, cipher, $this$encryptFile);
    }

    public static /* synthetic */ void encryptFile$default(String string, byte[] byArray, byte[] byArray2, String string2, String string3, byte[] byArray3, int n, Object object) {
        if ((n & 0x10) != 0) {
            byArray3 = new byte[]{};
        }
        SymmetricCryptoKt.encryptFile(string, byArray, byArray2, string2, string3, byArray3);
    }

    public static final void decryptFile(@NotNull String $this$decryptFile, @NotNull byte[] key, @NotNull byte[] iv, @NotNull String alg, @NotNull String outFileName, @NotNull byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)$this$decryptFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)outFileName, (String)"outFileName");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        Cipher cipher = SymmetricCryptoKt.makeCipher(alg, key, iv, 2, associatedData);
        SymmetricCryptoKt.doStreamCrypto(outFileName, cipher, $this$decryptFile);
    }

    public static /* synthetic */ void decryptFile$default(String string, byte[] byArray, byte[] byArray2, String string2, String string3, byte[] byArray3, int n, Object object) {
        if ((n & 0x10) != 0) {
            byArray3 = new byte[]{};
        }
        SymmetricCryptoKt.decryptFile(string, byArray, byArray2, string2, string3, byArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doStreamCrypto(String outFileName, Cipher cipher, String path) {
        Closeable closeable = new CipherOutputStream(new FileOutputStream(new File(outFileName)), cipher);
        Throwable throwable = null;
        try {
            CipherOutputStream cipherStream = (CipherOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileInputStream(new File(path));
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedInputStream bis = (BufferedInputStream)closeable2;
                boolean bl2 = false;
                byte[] buf = new byte[8192];
                int len = 0;
                while (true) {
                    int n2;
                    int it = n2 = bis.read(buf);
                    boolean bl3 = false;
                    len = it;
                    if (n2 == -1) break;
                    cipherStream.write(buf, 0, len);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

