/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.math;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.leon.ext.math.BigIntegerKt;
import me.leon.ext.math.DivideResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a8\u0006\u0007"}, d2={"crt", "Ljava/math/BigInteger;", "divideResults", "", "Lme/leon/ext/math/DivideResult;", "remainders", "modulusList", "app"})
@SourceDebugExtension(value={"SMAP\nKgcd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kgcd.kt\nme/leon/ext/math/KgcdKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1563#2:63\n1634#2,3:64\n1563#2:67\n1634#2,3:68\n2783#2,7:71\n2783#2,7:78\n1563#2:85\n1634#2,3:86\n1573#2:89\n1604#2,4:90\n1#3:94\n*S KotlinDebug\n*F\n+ 1 Kgcd.kt\nme/leon/ext/math/KgcdKt\n*L\n42#1:63\n42#1:64,3\n43#1:67\n43#1:68,3\n48#1:71,7\n49#1:78,7\n51#1:85\n51#1:86,3\n52#1:89\n52#1:90,4\n*E\n"})
public final class KgcdKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger crt(@NotNull List<DivideResult> divideResults) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(divideResults, (String)"divideResults");
        Iterable $this$map$iv = divideResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DivideResult divideResult = (DivideResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getQuotient());
        }
        List modulusList = (List)destination$iv$iv;
        Iterable $this$map$iv2 = divideResults;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DivideResult bl = (DivideResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getRemainder());
        }
        List remainders = (List)destination$iv$iv2;
        return KgcdKt.crt(remainders, modulusList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger crt(@NotNull List<? extends BigInteger> remainders, @NotNull List<? extends BigInteger> modulusList) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        BigInteger acc;
        Intrinsics.checkNotNullParameter(remainders, (String)"remainders");
        Intrinsics.checkNotNullParameter(modulusList, (String)"modulusList");
        Iterable $this$reduce$iv = modulusList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            BigInteger bigInteger = (BigInteger)iterator$iv.next();
            acc = (BigInteger)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)s), (String)"multiply(...)");
        }
        BigInteger m = (BigInteger)accumulator$iv;
        Iterable $this$reduce$iv2 = modulusList;
        boolean $i$f$reduce2 = false;
        Iterator iterator$iv2 = $this$reduce$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv2 = iterator$iv2.next();
        while (iterator$iv2.hasNext()) {
            void bigInteger;
            acc = (BigInteger)iterator$iv2.next();
            BigInteger acc2 = (BigInteger)accumulator$iv2;
            boolean bl = false;
            accumulator$iv2 = BigIntegerKt.lcm(acc2, (BigInteger)bigInteger);
        }
        BigInteger lcmOfModulus = (BigInteger)accumulator$iv2;
        $this$reduce$iv2 = modulusList;
        boolean $i$f$map = false;
        iterator$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BigInteger bigInteger = (BigInteger)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            BigInteger bigInteger2 = m.divide((BigInteger)it);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"divide(...)");
            object.add(bigInteger2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            BigInteger bigInteger;
            void mi;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BigInteger bigInteger3 = (BigInteger)item$iv$iv;
            int n2 = n;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)remainders.get((int)index).multiply((BigInteger)mi), (String)"multiply(...)");
            BigInteger bigInteger4 = mi.modInverse(modulusList.get((int)index));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"modInverse(...)");
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"multiply(...)");
            object.add(bigInteger5);
        }
        Iterable iterable = (List)destination$iv$iv;
        BigInteger bigInteger = BigInteger.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        BigInteger bigInteger6 = bigInteger;
        for (BigInteger $i$f$mapIndexedTo2 : iterable) {
            void it;
            object = bigInteger6;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((BigInteger)object).add((BigInteger)it), (String)"add(...)");
        }
        BigInteger bigInteger7 = bigInteger6.remainder(lcmOfModulus);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"remainder(...)");
        return bigInteger7;
    }
}

