/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.voice;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.ext.voice.TTSKt;
import me.leon.ext.voice.TTSWebsocket;
import me.leon.ext.voice.Voice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u001a\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J \u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u0005H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lme/leon/ext/voice/TTS;", "", "voice", "Lme/leon/ext/voice/Voice;", "content", "", "<init>", "(Lme/leon/ext/voice/Voice;Ljava/lang/String;)V", "headers", "", "findHeadHook", "", "format", "voicePitch", "voiceRate", "voiceVolume", "cacheable", "saveDir", "_content", "cache", "cacheDir", "dir", "formatMp3", "formatOpus", "fixHeadHook", "trans", "", "cacheFile", "Ljava/io/File;", "mkAudioFormat", "dateStr", "mkssml", "locale", "voiceName", "ssmlHeadersPlusData", "requestId", "timestamp", "ssml", "dateToString", "date", "Ljava/util/Date;", "uuid", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nTTS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TTS.kt\nme/leon/ext/voice/TTS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
public final class TTS {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Voice voice;
    @NotNull
    private final String content;
    @NotNull
    private Map<String, String> headers;
    private boolean findHeadHook;
    @NotNull
    private String format;
    @NotNull
    private String voicePitch;
    @NotNull
    private String voiceRate;
    @NotNull
    private String voiceVolume;
    private boolean cacheable;
    @NotNull
    private String saveDir;
    @NotNull
    private final String _content;
    @NotNull
    private static final String CHROMIUM_FULL_VERSION = "130.0.2849.68";
    @NotNull
    private static final String TRUSTED_CLIENT_TOKEN = "6A5AA1D4EAFF4E9FB37E23D68491D6F4";
    private static final long WINDOWS_FILE_TIME_EPOCH = 11644473600L;
    @NotNull
    public static final String EDGE_UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0";
    @NotNull
    public static final String EDGE_ORIGIN = "chrome-extension://jdiccldimpdaibmpdkjnbmckianbfold";

    public TTS(@Nullable Voice voice, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.voice = voice;
        this.content = content;
        this.headers = new LinkedHashMap();
        this.format = "audio-24khz-48kbitrate-mono-mp3";
        this.voicePitch = "+0Hz";
        this.voiceRate = "+0%";
        this.voiceVolume = "+0%";
        this.saveDir = "./ttsFile";
        this._content = TTSKt.removeUnsupportedChar(((Object)StringsKt.trim((CharSequence)this.content)).toString());
    }

    @NotNull
    public final TTS voicePitch(@NotNull String voicePitch) {
        Intrinsics.checkNotNullParameter((Object)voicePitch, (String)"voicePitch");
        this.voicePitch = voicePitch;
        return this;
    }

    @NotNull
    public final TTS voiceRate(@NotNull String voiceRate) {
        Intrinsics.checkNotNullParameter((Object)voiceRate, (String)"voiceRate");
        this.voiceRate = voiceRate;
        return this;
    }

    @NotNull
    public final TTS cache(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @NotNull
    public final TTS cacheDir(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.saveDir = dir;
        return this;
    }

    @NotNull
    public final TTS voiceVolume(@NotNull String voiceVolume) {
        Intrinsics.checkNotNullParameter((Object)voiceVolume, (String)"voiceVolume");
        this.voiceVolume = voiceVolume;
        return this;
    }

    @NotNull
    public final TTS formatMp3() {
        this.format = "audio-24khz-48kbitrate-mono-mp3";
        return this;
    }

    @NotNull
    public final TTS formatOpus() {
        this.format = "webm-24khz-16bit-mono-opus";
        return this;
    }

    @NotNull
    public final TTS findHeadHook() {
        this.findHeadHook = true;
        return this;
    }

    @NotNull
    public final TTS fixHeadHook() {
        this.findHeadHook = false;
        return this;
    }

    @NotNull
    public final TTS headers(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.headers = headers;
        return this;
    }

    @Nullable
    public final byte[] trans() {
        Object object;
        if (this.voice == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        File ttsMp3 = this.cacheFile();
        if (this.cacheable && ttsMp3.exists()) {
            System.out.println((Object)("cache: " + ttsMp3));
            return FilesKt.readBytes((File)ttsMp3);
        }
        String dateStr = this.dateToString(new Date());
        String reqId = this.uuid();
        String audioFormat = this.mkAudioFormat(dateStr);
        String ssml = this.mkssml(this.voice.getLocale(), this.voice.getName());
        String ssmlHeadersPlusData = this.ssmlHeadersPlusData(reqId, dateStr, ssml);
        this.headers.put("Origin", EDGE_ORIGIN);
        this.headers.put("Pragma", "no-cache");
        this.headers.put("Cache-Control", "no-cache");
        this.headers.put("User-Agent", EDGE_UA);
        String fileName = "audio";
        if (Intrinsics.areEqual((Object)this.format, (Object)"audio-24khz-48kbitrate-mono-mp3")) {
            fileName = fileName + ".mp3";
        } else if (Intrinsics.areEqual((Object)this.format, (Object)"webm-24khz-16bit-mono-opus")) {
            fileName = fileName + ".opus";
        }
        try {
            Object object2;
            Object it = object2 = Companion.getEDGE_URL();
            boolean bl = false;
            System.out.println(it);
            boolean bl2 = this.findHeadHook;
            Map<String, String> map = this.headers;
            String string = object2;
            TTSWebsocket client = new TTSWebsocket(string, map, bl2);
            client.connect();
            while (!client.isOpen()) {
                Thread.sleep(100L);
            }
            client.send(audioFormat);
            client.send(ssmlHeadersPlusData);
            while (client.isOpen()) {
            }
            it = object2 = (Object)CollectionsKt.toByteArray((Collection)client.getByteArrays());
            boolean bl3 = false;
            if (this.cacheable) {
                ttsMp3.getParentFile().mkdirs();
                FilesKt.writeBytes((File)ttsMp3, (byte[])it);
            }
            object = object2;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            object = null;
        }
        return object;
    }

    private final File cacheFile() {
        StringBuilder stringBuilder = new StringBuilder();
        Voice voice = this.voice;
        Intrinsics.checkNotNull((Object)voice);
        File voiceCacheDir = new File(this.saveDir, stringBuilder.append(voice.getShortName()).append('_').append(this.voicePitch).append('_').append(this.voiceRate).append('_').append(this.voiceVolume).toString());
        return new File(voiceCacheDir, DigestsKt.hash$default(this.content, null, 1, null));
    }

    private final String mkAudioFormat(String dateStr) {
        return "X-Timestamp:" + dateStr + "\r\nContent-Type:application/json; charset=utf-8\r\nPath:speech.config\r\n\r\n{\"context\":{\"synthesis\":{\"audio\":{\"metadataoptions\":{\"sentenceBoundaryEnabled\":\"false\",\"wordBoundaryEnabled\":\"true\"},\"outputFormat\":\"" + this.format + "\"}}}}\n";
    }

    private final String mkssml(String locale, String voiceName) {
        return "<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xml:lang='" + locale + "'><voice name='" + voiceName + "'><prosody pitch='" + this.voicePitch + "' rate='" + this.voiceRate + "' volume='" + this.voiceVolume + "'>" + this._content + "</prosody></voice></speak>";
    }

    private final String ssmlHeadersPlusData(String requestId, String timestamp, String ssml) {
        return "X-RequestId:" + requestId + "\r\nContent-Type:application/ssml+xml\r\nX-Timestamp:" + timestamp + "Z\r\nPath:ssml\r\n\r\n" + ssml;
    }

    private final String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)");
        String string = sdf.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String uuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lme/leon/ext/voice/TTS$Companion;", "", "<init>", "()V", "CHROMIUM_FULL_VERSION", "", "TRUSTED_CLIENT_TOKEN", "WINDOWS_FILE_TIME_EPOCH", "", "EDGE_URL", "getEDGE_URL", "()Ljava/lang/String;", "EDGE_UA", "EDGE_ORIGIN", "VOICES_LIST_URL", "getVOICES_LIST_URL", "genSec", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEDGE_URL() {
            return "wss://speech.platform.bing.com/consumer/speech/synthesize/readaloud/edge/v1?TrustedClientToken=6A5AA1D4EAFF4E9FB37E23D68491D6F4&" + this.genSec();
        }

        @NotNull
        public final String getVOICES_LIST_URL() {
            return "https://speech.platform.bing.com/consumer/speech/synthesize/readaloud/voices/list?trustedclienttoken=6A5AA1D4EAFF4E9FB37E23D68491D6F4&" + this.genSec();
        }

        private final String genSec() {
            long nowInSecs = System.currentTimeMillis() / (long)1000;
            long ticks = (nowInSecs + 11644473600L) * 10000000L;
            long roundedTicks = ticks - ticks % 3000000000L;
            String string = DigestsKt.hash(roundedTicks + TTS.TRUSTED_CLIENT_TOKEN, "sha256").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String hash = string;
            return "Sec-MS-GEC=" + hash + "&Sec-MS-GEC-Version=1-130.0.2849.68";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

