/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.image.BufferedImage;

public class CombineTransform {
    private BufferedImage im1;
    private BufferedImage im2;
    private BufferedImage transform;
    private int transNum;
    private final int NUMTRANS = 13;

    CombineTransform(BufferedImage bi, BufferedImage bi2) {
        this.im1 = bi;
        this.im2 = bi2;
        this.transNum = 0;
        this.calcTrans();
    }

    private void calcInterlace() {
        block7: {
            int height;
            int width;
            block6: {
                width = this.im1.getWidth();
                if (this.im2.getWidth() < width) {
                    width = this.im2.getWidth();
                }
                height = this.im1.getHeight();
                if (this.im2.getHeight() < height) {
                    height = this.im2.getHeight();
                }
                if (this.transNum != 11) break block6;
                this.transform = new BufferedImage(width, 2 * height, 1);
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < height; ++j) {
                        this.transform.setRGB(i, j * 2, this.im1.getRGB(i, j));
                        this.transform.setRGB(i, j * 2 + 1, this.im2.getRGB(i, j));
                    }
                }
                break block7;
            }
            if (this.transNum != 12) break block7;
            this.transform = new BufferedImage(2 * width, height, 1);
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    this.transform.setRGB(i * 2, j, this.im1.getRGB(i, j));
                    this.transform.setRGB(i * 2 + 1, j, this.im2.getRGB(i, j));
                }
            }
        }
    }

    private void calcTrans() {
        if (this.transNum == 11 || this.transNum == 12) {
            this.calcInterlace();
            return;
        }
        int width = this.im1.getWidth();
        if (this.im2.getWidth() > width) {
            width = this.im2.getWidth();
        }
        int height = this.im1.getHeight();
        if (this.im2.getHeight() > height) {
            height = this.im2.getHeight();
        }
        this.transform = new BufferedImage(width, height, 1);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int col1 = 0;
                int col2 = 0;
                if (i < this.im1.getWidth() && j < this.im1.getHeight()) {
                    col1 = this.im1.getRGB(i, j);
                }
                if (i < this.im2.getWidth() && j < this.im2.getHeight()) {
                    col2 = this.im2.getRGB(i, j);
                }
                int col = this.comb(col1, col2);
                this.transform.setRGB(i, j, col);
            }
        }
    }

    public void back() {
        --this.transNum;
        if (this.transNum < 0) {
            this.transNum = 12;
        }
        this.calcTrans();
    }

    public void forward() {
        ++this.transNum;
        if (this.transNum >= 13) {
            this.transNum = 0;
        }
        this.calcTrans();
    }

    private int comb(int c1, int c2) {
        switch (this.transNum) {
            case 0: {
                return c1 ^ c2;
            }
            case 1: {
                return c1 | c2;
            }
            case 2: {
                return c1 & c2;
            }
            case 3: {
                return c1 + c2;
            }
            case 4: {
                int r = (c1 & 0xFF0000) + (c2 & 0xFF0000) & 0xFF0000;
                int g = (c1 & 0xFF00) + (c2 & 0xFF00) & 0xFF00;
                int b = (c1 & 0xFF) + (c2 & 0xFF) & 0xFF;
                return r | g | b;
            }
            case 5: {
                return c1 - c2;
            }
            case 6: {
                int r = (c1 & 0xFF0000) - (c2 & 0xFF0000) & 0xFF0000;
                int g = (c1 & 0xFF00) - (c2 & 0xFF00) & 0xFF00;
                int b = (c1 & 0xFF) - (c2 & 0xFF) & 0xFF;
                return r | g | b;
            }
            case 7: {
                return c1 * c2;
            }
            case 8: {
                int r = (((c1 & 0xFF0000) >> 16) * ((c2 & 0xFF0000) >> 16) & 0xFF) << 16;
                int g = (((c1 & 0xFF00) >> 8) * ((c2 & 0xFF00) >> 8) & 0xFF) << 8;
                int b = (c1 & 0xFF) * (c2 & 0xFF) & 0xFF;
                return r | g | b;
            }
            case 9: {
                int r = (c1 & 0xFF0000) > (c2 & 0xFF0000) ? c1 & 0xFF0000 : c2 & 0xFF0000;
                int g = (c1 & 0xFF00) > (c2 & 0xFF00) ? c1 & 0xFF00 : c2 & 0xFF00;
                int b = (c1 & 0xFF) > (c2 & 0xFF) ? c1 & 0xFF : c2 & 0xFF;
                return r | g | b;
            }
            case 10: {
                int r = (c1 & 0xFF0000) < (c2 & 0xFF0000) ? c1 & 0xFF0000 : c2 & 0xFF0000;
                int g = (c1 & 0xFF00) < (c2 & 0xFF00) ? c1 & 0xFF00 : c2 & 0xFF00;
                int b = (c1 & 0xFF) < (c2 & 0xFF) ? c1 & 0xFF : c2 & 0xFF;
                return r | g | b;
            }
        }
        return 0;
    }

    public String getText() {
        switch (this.transNum) {
            case 0: {
                return "XOR";
            }
            case 1: {
                return "OR";
            }
            case 2: {
                return "AND";
            }
            case 3: {
                return "ADD";
            }
            case 4: {
                return "ADD (R,G,B separate)";
            }
            case 5: {
                return "SUB";
            }
            case 6: {
                return "SUB (R,G,B separate)";
            }
            case 7: {
                return "MUL";
            }
            case 8: {
                return "MUL (R,G,B separate)";
            }
            case 9: {
                return "Lightest (R, G, B separate)";
            }
            case 10: {
                return "Darkest (R, G, B separate)";
            }
            case 11: {
                return "Horizontal Interlace";
            }
            case 12: {
                return "Vertical Interlace";
            }
        }
        return "???";
    }

    public BufferedImage getImage() {
        return this.transform;
    }
}

