/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.CRC32;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FileAnalysis
extends JFrame {
    private StringBuilder rep;
    private byte[] f = null;
    private JButton OKButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JEditorPane report;

    public FileAnalysis(File ifile) {
        this.initComponents();
        this.analyse_file(ifile);
    }

    private void analyse_file(File ifile) {
        this.rep = new StringBuilder();
        this.rep.append("<html><center><b>");
        this.rep.append("File format report");
        this.rep.append("</b></center>");
        this.rep.append("<br>File: " + ifile.getName());
        try {
            FileInputStream fis = new FileInputStream(ifile);
            this.f = new byte[(int)ifile.length()];
            fis.read(this.f);
            this.rep.append("<br>Read " + Integer.toHexString(this.f.length) + " bytes");
            this.analyse();
        }
        catch (Exception e) {
            this.rep.append("Error reading file: " + e.toString());
        }
        this.rep.append("</html>");
        this.report.setText(this.rep.toString());
    }

    private void analyse() {
        if (this.f.length < 4) {
            this.rep.append("<br>file too short?");
            return;
        }
        if (this.f[0] == 66 && this.f[1] == 77) {
            this.analyse_bmp();
        } else if (this.f[0] == -119 && this.f[1] == 80 && this.f[2] == 78 && this.f[3] == 71) {
            this.analyse_png();
        } else if (this.f.length >= 6 && this.f[0] == 71 && this.f[1] == 73 && this.f[2] == 70 && this.f[3] == 56 && (this.f[4] == 55 || this.f[4] == 57) && this.f[5] == 97) {
            this.analyse_gif();
        } else if (this.f[0] == -1 && this.f[1] == -40) {
            this.analyse_jpg();
        } else {
            this.rep.append("<br>File format analysis code not done yet!");
        }
    }

    private void analyse_jpg() {
        int cpos = 0;
        if ((cpos = this.analyse_jpg_sections(cpos)) < this.f.length) {
            this.rep.append("<br>Additional bytes at end of file = " + (this.f.length - cpos));
            this.rep.append("<br>Dump of additional bytes:");
            this.fdump(cpos, this.f.length);
        }
    }

    private int analyse_jpg_sections(int pos) {
        if (this.f[pos] == -1 && this.f[pos + 1] == -40) {
            this.rep.append("<br>Start of Image");
            pos += 2;
        } else {
            if (this.f[pos] == -1 && this.f[pos + 1] == -39) {
                this.rep.append("<br><br>End of Image");
                return pos += 2;
            }
            if (this.f[pos] == -1 && (this.f[pos + 1] >= -64 && this.f[pos + 1] <= -61 || this.f[pos + 1] >= -59 && this.f[pos + 1] <= -57 || this.f[pos + 1] >= -55 && this.f[pos + 1] <= -53 || this.f[pos + 1] >= -51 && this.f[pos + 1] <= -49 || this.f[pos + 1] == -34)) {
                if (this.f[pos + 1] == -64) {
                    this.rep.append("<br><br>Start of frame : Baseline DCT");
                } else if (this.f[pos + 1] == -63) {
                    this.rep.append("<br><br>Start of frame : Extended sequential DCT");
                } else if (this.f[pos + 1] == -62) {
                    this.rep.append("<br><br>Start of frame : Progressive DCT");
                } else if (this.f[pos + 1] == -61) {
                    this.rep.append("<br><br>Start of frame : Lossless (sequential)");
                } else if (this.f[pos + 1] == -59) {
                    this.rep.append("<br><br>Start of frame : Differential sequential DCT");
                } else if (this.f[pos + 1] == -58) {
                    this.rep.append("<br><br>Start of frame : Differential progressive DCT");
                } else if (this.f[pos + 1] == -57) {
                    this.rep.append("<br><br>Start of frame : Differential lossless (sequential)");
                } else if (this.f[pos + 1] == -55) {
                    this.rep.append("<br><br>Start of frame : Extended sequential DCT");
                } else if (this.f[pos + 1] == -54) {
                    this.rep.append("<br><br>Start of frame : Progressive DCT");
                } else if (this.f[pos + 1] == -53) {
                    this.rep.append("<br><br>Start of frame : Lossless (sequential)");
                } else if (this.f[pos + 1] == -51) {
                    this.rep.append("<br><br>Start of frame : Differential sequential DCT");
                } else if (this.f[pos + 1] == -50) {
                    this.rep.append("<br><br>Start of frame : Differential progressive DCT");
                } else if (this.f[pos + 1] == -49) {
                    this.rep.append("<br><br>Start of frame : Differential  lossless (sequential)");
                } else if (this.f[pos + 1] == -34) {
                    this.rep.append("<br><br>Start of frame : DHP");
                }
                if (this.f[pos + 1] < -56) {
                    this.rep.append(" (Huffman coding)");
                } else {
                    this.rep.append(" (arithmetic coding)");
                }
                this.rep.append("<br>Header Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append("<br>Precision: " + Integer.toHexString(this.uf(pos + 4)));
                this.rep.append("<br>Image lines: " + Integer.toHexString(this.png_get_word(pos + 5)) + " (" + this.png_get_word(pos + 5) + ")");
                this.rep.append("<br>Samples per line: " + Integer.toHexString(this.png_get_word(pos + 7)) + " (" + this.png_get_word(pos + 7) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -60) {
                this.rep.append("<br><br>Huffman table");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -52) {
                this.rep.append("<br><br>Arithmetic coding conditioning");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] >= -48 && this.f[pos + 1] <= -41) {
                this.rep.append("<br><br>Restart interval");
                pos += 2;
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -38) {
                this.rep.append("<br><br>Start of scan");
                this.rep.append("<br>Header Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                pos += 2 + this.png_get_word(pos + 2);
                int ct = pos;
                while (this.f[ct] != -1 || this.f[ct] == -1 && this.f[ct + 1] == 0 || this.f[ct] == -1 && this.f[ct + 1] >= -48 && this.f[ct + 1] <= -41) {
                    ++ct;
                }
                this.rep.append("<br>Detected " + (ct - pos) + " bytes in scan");
                pos = ct;
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -37) {
                this.rep.append("<br><br>Quantisation table");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -36) {
                this.rep.append("<br><br>Define number of lines");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append(" (Should be 4)");
                this.rep.append("<br>Number: " + Integer.toHexString(this.png_get_word(pos + 4)) + " (" + this.png_get_word(pos + 4) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -35) {
                this.rep.append("<br><br>Define Restart interval");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append(" (Should be 4)");
                this.rep.append("<br>Interval: " + Integer.toHexString(this.png_get_word(pos + 4)) + " (" + this.png_get_word(pos + 4) + ")");
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -33) {
                this.rep.append("<br><br>Expand reference components");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append(" (Should be 3)");
                this.rep.append("<br>Value: " + Integer.toHexString(this.uf(pos + 4)));
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] >= -32 && this.f[pos + 1] <= -17) {
                this.rep.append("<br><br>Application data");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append("<br>Dump of data:");
                this.fdump(pos + 2, pos + 2 + this.png_get_word(pos + 2) - 1);
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -2) {
                this.rep.append("<br><br>Comment data");
                this.rep.append("<br>Length: " + Integer.toHexString(this.png_get_word(pos + 2)) + " (" + this.png_get_word(pos + 2) + ")");
                this.rep.append("<br>Dump of data:");
                this.fdump(pos + 2, pos + 2 + this.png_get_word(pos + 2) - 1);
                pos += 2 + this.png_get_word(pos + 2);
            } else if (this.f[pos] == -1 && this.f[pos + 1] == -1) {
                ++pos;
            } else {
                return pos;
            }
        }
        return this.analyse_jpg_sections(pos);
    }

    private void analyse_gif() {
        if (this.f.length < 13) {
            this.rep.append("<br>file too short?");
            return;
        }
        this.rep.append("<br>Width: " + this.get_hword(6) + " (" + this.get_word(6) + ")");
        this.rep.append("<br>Height: " + this.get_hword(8) + " (" + this.get_word(8) + ")");
        this.rep.append("<br>Flags: " + Integer.toHexString(this.uf(10)));
        int flags = this.uf(10);
        int gctsize = 0;
        if ((flags & 0x80) > 0) {
            this.rep.append(" (Global Colour Table)");
            if ((flags & 0x10) > 0) {
                this.rep.append(" (Sorted GCT)");
            }
            gctsize = 1 << (flags & 7) + 1;
            this.rep.append(" (GCT Size = " + gctsize + ")");
        }
        this.rep.append(" (Color Resolution = " + ((flags >> 3 & 3) + 1) + ")");
        this.rep.append("<br>Background color index: " + this.uf(11));
        this.rep.append("<br>Pixel aspect ratio: " + this.uf(12));
        int cpos = 13;
        if (this.f.length < cpos + gctsize * 3) {
            this.rep.append("<br>file too short?");
            return;
        }
        if (gctsize > 0) {
            this.rep.append("<br><br>Global Colour Table:");
            for (int i = 0; i < gctsize; ++i) {
                int j;
                this.rep.append("<br>");
                for (j = 0; j < 3; ++j) {
                    this.rep.append(this.m2(Integer.toHexString(this.uf(cpos + i * 3 + j))));
                    this.rep.append(" ");
                }
                this.rep.append("   ");
                for (j = 0; j < 3; ++j) {
                    char c = (char)this.uf(cpos + i * 3 + j);
                    if (c < ' ' || c > '\u007f') {
                        c = '.';
                    }
                    this.rep.append("" + c);
                }
            }
            cpos += gctsize * 3;
        }
        if ((cpos = this.check_gif_blocks(cpos)) < this.f.length) {
            this.rep.append("<br>Additional bytes at end of file = " + (this.f.length - cpos));
            this.rep.append("<br>Dump of additional bytes:");
            this.fdump(cpos, this.f.length);
        }
    }

    private int check_gif_blocks(int pos) {
        if (this.f[pos] == 44) {
            if (pos + 10 >= this.f.length) {
                return pos;
            }
            this.rep.append("<br><br>Image Descriptor");
            this.rep.append("<br>Left: " + this.get_hword(pos + 1) + " (" + this.get_word(pos + 1) + ")");
            this.rep.append("<br>Top: " + this.get_hword(pos + 3) + " (" + this.get_word(pos + 3) + ")");
            this.rep.append("<br>Width: " + this.get_hword(pos + 5) + " (" + this.get_word(pos + 5) + ")");
            this.rep.append("<br>Height: " + this.get_hword(pos + 7) + " (" + this.get_word(pos + 7) + ")");
            this.rep.append("<br>Flags: " + Integer.toHexString(this.uf(pos + 9)));
            int flags = this.uf(pos + 9);
            int lctsize = 0;
            if ((flags & 0x80) > 0) {
                this.rep.append(" (Local colour table)");
                lctsize = 1 << (flags & 7) + 1;
                this.rep.append(" (LCT Size = " + lctsize + "");
            }
            if ((flags & 0x40) > 0) {
                this.rep.append(" (Interlace)");
            }
            if ((flags & 0x20) > 0) {
                this.rep.append(" (Sort)");
            }
            if ((flags & 0x18) > 0) {
                this.rep.append(" (**Reserved flags set **)");
            }
            if (this.f.length < (pos += 10) + lctsize * 3) {
                this.rep.append("<br>file too short?");
                return pos;
            }
            if (lctsize > 0) {
                this.rep.append("<br><br>Local Colour Table:");
                for (int i = 0; i < lctsize; ++i) {
                    int j;
                    this.rep.append("<br>");
                    for (j = 0; j < 3; ++j) {
                        this.rep.append(this.m2(Integer.toHexString(this.uf(pos + i * 3 + j))));
                        this.rep.append(" ");
                    }
                    this.rep.append("   ");
                    for (j = 0; j < 3; ++j) {
                        char c = (char)this.uf(pos + i * 3 + j);
                        if (c < ' ' || c > '\u007f') {
                            c = '.';
                        }
                        this.rep.append("" + c);
                    }
                }
                pos += lctsize * 3;
            }
            this.rep.append("<br>LZW size = " + this.uf(pos));
            ++pos;
            while (this.uf(pos) > 0) {
                pos += this.uf(pos) + 1;
            }
            ++pos;
        } else if (this.f[pos] == 33 && this.uf(pos + 1) == 249) {
            if (pos + 8 >= this.f.length) {
                return pos;
            }
            this.rep.append("<br><br>Graphic control extension");
            this.rep.append("<br>Size : " + this.uf(pos + 2) + " (must be 4)");
            this.rep.append("<br>Flags: " + Integer.toHexString(this.uf(pos + 3)));
            int flags = this.uf(pos + 3);
            if ((flags & 0xE0) > 0) {
                this.rep.append(" (**Reserved flags set **)");
            }
            if ((flags & 1) > 0) {
                this.rep.append(" (Transparency flag)");
            }
            this.rep.append("<br>Delay time: " + this.get_word(pos + 4));
            this.rep.append("<br>Transparent color index: " + this.uf(6));
            this.rep.append("<br>Terminator: " + Integer.toHexString(this.uf(pos + 7)));
            pos += 8;
        } else if (this.f[pos] == 33 && this.uf(pos + 1) == 254) {
            if (pos + 3 >= this.f.length) {
                return pos;
            }
            this.rep.append("<br><br>Comment extension");
            this.rep.append("<br>Dump of data:");
            pos += 2;
            while (this.uf(pos) > 0) {
                this.fdump(pos + 1, pos + this.uf(pos));
                pos += this.uf(pos) + 1;
            }
            ++pos;
        } else if (this.f[pos] == 33 && this.uf(pos + 1) == 1) {
            if (pos + 16 >= this.f.length) {
                return pos;
            }
            this.rep.append("<br><br>Plain Text extension");
            this.rep.append("<br>Size : " + this.uf(pos + 2) + " (must be 12)");
            this.rep.append("<br>Left: " + this.get_hword(pos + 3) + " (" + this.get_word(pos + 3) + ")");
            this.rep.append("<br>Top: " + this.get_hword(pos + 5) + " (" + this.get_word(pos + 5) + ")");
            this.rep.append("<br>Width: " + this.get_hword(pos + 7) + " (" + this.get_word(pos + 7) + ")");
            this.rep.append("<br>Height: " + this.get_hword(pos + 9) + " (" + this.get_word(pos + 9) + ")");
            this.rep.append("<br>Cell Width : " + this.uf(pos + 11));
            this.rep.append("<br>Cell Height : " + this.uf(pos + 12));
            this.rep.append("<br>Foreground Color Index : " + this.uf(pos + 13));
            this.rep.append("<br>Background Color Index : " + this.uf(pos + 14));
            this.rep.append("<br>Dump of data:");
            pos += 15;
            while (this.uf(pos) > 0) {
                this.fdump(pos + 1, pos + this.uf(pos));
                pos += this.uf(pos) + 1;
            }
            ++pos;
        } else if (this.f[pos] == 33 && this.uf(pos + 1) == 255) {
            if (pos + 14 >= this.f.length) {
                return pos;
            }
            this.rep.append("<br><br>Application extension");
            this.rep.append("<br>Size : " + this.uf(pos + 2) + " (must be 11)");
            this.rep.append("<br>Identifier:");
            this.fdump(pos + 3, pos + 10);
            this.rep.append("<br>Authentication code:");
            this.fdump(pos + 11, pos + 13);
            this.rep.append("<br>Application data:");
            pos += 14;
            while (this.uf(pos) > 0) {
                this.fdump(pos + 1, pos + this.uf(pos));
                pos += this.uf(pos) + 1;
            }
            ++pos;
        } else {
            if (this.f[pos] == 59) {
                this.rep.append("<br><br>Trailer block");
                return pos + 1;
            }
            return pos;
        }
        return this.check_gif_blocks(pos);
    }

    private void analyse_png() {
        int cpos;
        if (this.f.length < 8) {
            this.rep.append("<br>file too short?");
            return;
        }
        if (this.f[4] != 13 || this.f[5] != 10 || this.f[6] != 26 || this.f[7] != 10) {
            this.rep.append("<br>Error in header, bytes 5-8 should be 0d 0a 1a 0a");
        }
        if ((cpos = this.check_png_chunks(8)) < this.f.length) {
            this.rep.append("<br>Additional bytes at end of file = " + (this.f.length - cpos));
            this.rep.append("<br>Dump of additional bytes:");
            this.fdump(cpos, this.f.length);
        }
    }

    private int check_png_chunks(int start) {
        if (start + 12 > this.f.length) {
            this.rep.append("<br>Premature end to file?");
            return start;
        }
        int length = this.png_get_dword(start);
        this.rep.append("<br><br>Chunk: ");
        if ((this.f[4] & 0x40) > 0) {
            this.rep.append("<br>Ancillary - provides additional information");
        } else {
            this.rep.append("<br>Critical - necessary for display of image MUST BE recognized to proceed");
        }
        if ((this.f[5] & 0x40) > 0) {
            this.rep.append("<br>Private, investigate this!!");
        } else {
            this.rep.append("<br>Public");
        }
        if ((this.f[6] & 0x40) > 0) {
            this.rep.append("<br>Chunk has a reserved flag set, **investigate this**!");
        }
        if ((this.f[7] & 0x40) > 0) {
            this.rep.append("<br>Safe to copy, chunk may propagate to other files");
        } else {
            this.rep.append("<br>Unsafe to copy unless known to software");
        }
        this.fdump(start + 4, start + 7);
        this.rep.append("<br>Data length = " + length + " bytes");
        this.rep.append("<br>CRC = " + this.png_get_hdword(start + 8 + length));
        CRC32 cc = new CRC32();
        cc.reset();
        cc.update(this.f, start + 4, 4 + length);
        if ((int)cc.getValue() != this.png_get_dword(start + 8 + length)) {
            this.rep.append("<br>Calculated CRC = " + Integer.toHexString((int)cc.getValue()));
        }
        if (start + 12 + length > this.f.length) {
            this.rep.append("<br>Not enough room in file for data?");
            return start;
        }
        int typ = this.png_get_dword(start + 4);
        if (typ == 1229278788) {
            return start + 12;
        }
        if (typ == 1229472850) {
            this.rep.append("<br>Width: " + this.png_get_hdword(start + 8) + " (" + this.png_get_dword(start + 8) + ")");
            this.rep.append("<br>Height: " + this.png_get_hdword(start + 12) + " (" + this.png_get_dword(start + 12) + ")");
            this.rep.append("<br>Bit Depth: " + this.f[start + 16]);
            this.rep.append("<br>Color Type: " + this.f[start + 17]);
            if (this.f[start + 17] == 0) {
                this.rep.append(" (Grayscale)");
            }
            if (this.f[start + 17] == 2) {
                this.rep.append(" (RGB Triples)");
            }
            if (this.f[start + 17] == 3) {
                this.rep.append(" (Palette Indexed)");
            }
            if (this.f[start + 17] == 4) {
                this.rep.append(" (Grayscale + Alpha)");
            }
            if (this.f[start + 17] == 6) {
                this.rep.append(" (RGB + Alpha)");
            }
            this.rep.append("<br>Compression Method: " + this.f[start + 18]);
            if (this.f[start + 18] == 0) {
                this.rep.append(" (deflate)");
            } else {
                this.rep.append(" (unknown)");
            }
            this.rep.append("<br>Filter Method: " + this.f[start + 19]);
            if (this.f[start + 19] == 0) {
                this.rep.append(" (adaptive)");
            } else {
                this.rep.append(" (unknown)");
            }
            this.rep.append("<br>Interlace Method: " + this.f[start + 20]);
            if (this.f[start + 20] == 0) {
                this.rep.append(" (none)");
            } else if (this.f[start + 20] == 1) {
                this.rep.append(" (adam7)");
            } else {
                this.rep.append(" (unknown)");
            }
        } else if (typ == 1347179589) {
            this.rep.append("<br>Palette contains " + length / 3 + " RGB entries, NB if colortype is 2 or 6 this could be hiding something.");
            this.rep.append("<br>Dump of palette:");
            for (int i = 0; i < length / 3; ++i) {
                int j;
                this.rep.append("<br>");
                for (j = 0; j < 4; ++j) {
                    this.rep.append(this.m2(Integer.toHexString(this.uf(start + 8 + i * 3 + j))));
                    this.rep.append(" ");
                }
                this.rep.append("   ");
                for (j = 0; j < 3; ++j) {
                    char c = (char)this.uf(start + 8 + i * 3 + j);
                    if (c < ' ' || c > '\u007f') {
                        c = '.';
                    }
                    this.rep.append("" + c);
                }
            }
        } else if (typ == 1229209940) {
            this.rep.append("<br>Image data, compressed");
        } else if (typ == 1649100612) {
            this.rep.append("<br>Background data, optional");
            this.rep.append("<br>NB: should be after PLTE chunk and before first IDAT");
            if (length != 1 && length != 2 && length != 6) {
                this.rep.append("<br>Alert: Length should be 1, 2 or 6 bytes");
            }
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1665684045) {
            this.rep.append("<br>Primary chromaticities and white point");
            this.rep.append("<br>NB data represents 4 points for white,red,green,blue");
            this.rep.append("<br>x coordinates and y coordinates");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1732332865) {
            this.rep.append("<br>Image gamma value");
            this.rep.append("<br>" + this.get_dword(start + 8));
        } else if (typ == 1749635924) {
            this.rep.append("<br>Image histogram");
            this.rep.append("<br>Should be 2 bytes for each entry in PLTE");
            this.rep.append("<br>Contains " + length / 2 + " entries");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1883789683) {
            this.rep.append("<br>Physical pixel dimensions");
            this.rep.append("<br>Should be 9 bytes");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1933723988) {
            this.rep.append("<br>Significant bits");
            this.rep.append("<br>Should be 4 bytes or less");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1950701684) {
            this.rep.append("<br>Text");
            this.rep.append("<br>Consists of keyword and value separated by null byte");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 1950960965) {
            this.rep.append("<br>Last modification time");
            this.rep.append("<br>Year  : " + this.png_get_word(start + 8));
            this.rep.append("<br>Month : " + this.uf(start + 10));
            this.rep.append("<br>Day   : " + this.uf(start + 11));
            this.rep.append("<br>Hour  : " + this.uf(start + 12));
            this.rep.append("<br>Minute: " + this.uf(start + 13));
            this.rep.append("<br>Second: " + this.uf(start + 14));
        } else if (typ == 1951551059) {
            this.rep.append("<br>Transparency");
            this.rep.append("<br>Alpha values, either for palette");
            this.rep.append("<br> or single value for image");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else if (typ == 2052348020) {
            this.rep.append("<br>Text, compressed");
            this.rep.append("<br>Keyword is not compressed, value is compressed");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        } else {
            this.rep.append("<br>Unknown chunk type");
            this.rep.append("<br>dump of data:");
            this.fdump(start + 8, start + 8 + length - 1);
        }
        return this.check_png_chunks(start + 12 + length);
    }

    private void analyse_bmp() {
        int fsz = this.get_dword(2);
        int offbits = this.get_dword(10);
        if (this.f.length < 54) {
            this.rep.append("<br>File is too short to contain headers");
            return;
        }
        this.rep.append("<br>File Header info:");
        this.rep.append("<br>File size: " + Integer.toHexString(fsz));
        this.rep.append("<br>Reserved1: " + this.get_hword(6));
        this.rep.append("<br>Reserved2: " + this.get_hword(8));
        if (this.f.length > fsz) {
            this.rep.append("<br>Additional bytes at end of file = " + (this.f.length - fsz));
            this.rep.append("<br>Dump of additional bytes:");
            this.fdump(fsz, this.f.length - 1);
            this.rep.append("<br>NB: Additional bytes may indicate that the height is set incorrectly in the header, try increasing the height to see if it is hiding image data");
        }
        this.rep.append("<br>Bitmap data starts at: " + Integer.toHexString(offbits));
        this.rep.append("<br>Info Header:");
        int bisize = this.get_dword(14);
        this.rep.append("<br>Info Size: " + Integer.toHexString(bisize));
        this.rep.append("<br>Width: " + this.get_hdword(18) + " (" + this.get_dword(18) + ")");
        this.rep.append("<br>Height: " + this.get_hdword(22) + " (" + this.get_dword(22) + ")");
        this.rep.append("<br>Planes: " + this.get_hword(26) + " (must be 1)");
        this.rep.append("<br>BitCount: " + this.get_hword(28) + " bits per pixel");
        int compress = this.get_dword(30);
        this.rep.append("<br>Compression: " + this.get_hdword(30));
        if (compress == 0 || compress == 843204434) {
            this.rep.append(" (No compression)");
        } else if (compress == 1 || compress == 944065618) {
            this.rep.append(" (RLE for 8bpp RGB)");
        } else if (compress == 2 || compress == 876956754) {
            this.rep.append(" (RLE for 4bpp RGB)");
        } else if (compress == 3) {
            this.rep.append(" (Raw RGB with packing)");
        } else if (compress == 846684531) {
            this.rep.append(" (Raw RGB)");
        } else if (compress == 1094862674) {
            this.rep.append(" (Raw RGB with alpha)");
        } else if (compress == 1413629778) {
            this.rep.append(" (Raw RGB with transparency)");
        }
        this.rep.append("<br>Size Image: " + this.get_hdword(34) + " (can be zero if bitmap is uncompressed)");
        this.rep.append("<br>XPelsPerMeter: " + this.get_hdword(38) + " (pixels per meter for target device)");
        this.rep.append("<br>YPelsPerMeter: " + this.get_hdword(42) + " (pixels per meter for target device)");
        this.rep.append("<br>ClrUsed: " + this.get_hdword(46) + " (color indexes in use, 0=max)");
        this.rep.append("<br>ClrImportant: " + this.get_hdword(50) + "(0 if all colors are important)");
        int ctstart = 14 + bisize;
        this.rep.append("<br>Color table computed start: " + Integer.toHexString(ctstart) + "(normally 0x36, if not then possible hidden data at that point)");
        if (ctstart > 54) {
            this.rep.append("<br>Dump of gap between header and start of color table:");
            this.fdump(54, ctstart - 1);
        }
        if (this.get_word(28) <= 8) {
            this.rep.append("<br>Color Index Table (NB fourth entry of each index should be zero, order is b,g,r,a):");
            int ncols = this.get_dword(46);
            if (ncols == 0) {
                if (this.get_word(28) == 1) {
                    ncols = 2;
                } else if (this.get_word(28) == 4) {
                    ncols = 16;
                } else if (this.get_word(28) == 8) {
                    ncols = 256;
                }
            }
            for (int i = 0; i < ncols; ++i) {
                int j;
                this.rep.append("<br>");
                for (j = 0; j < 4; ++j) {
                    this.rep.append(this.m2(Integer.toHexString(this.uf(ctstart + i * 4 + j))));
                    this.rep.append(" ");
                }
                this.rep.append("   ");
                for (j = 0; j < 4; ++j) {
                    char c = (char)this.uf(ctstart + i * 4 + j);
                    if (c < ' ' || c > '\u007f') {
                        c = '.';
                    }
                    this.rep.append("" + c);
                }
            }
            ctstart += ncols * 4;
        }
        if (ctstart != offbits) {
            this.rep.append("<br>Color table finishes at " + Integer.toHexString(ctstart) + " but data bits start at " + Integer.toHexString(offbits));
        }
        if (ctstart < offbits) {
            this.rep.append("<br>Dump of gap between color table and image:");
            this.fdump(ctstart, offbits - 1);
        }
        if (compress != 0 && compress != 843204434) {
            this.rep.append("<br>Further checking is only done when there is no compression");
            return;
        }
        this.rep.append("<br>Row filler bytes dump:");
        int bitsPerRow = this.get_dword(18) * this.get_word(28);
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int fgap = (bytesPerRow + 3) / 4;
        fgap = fgap * 4 - bytesPerRow;
        ctstart = offbits;
        for (int i = 0; i < this.get_dword(22); ++i) {
            int ctend = (ctstart += bytesPerRow) + fgap;
            if (ctend != ctstart) {
                this.fdump(ctstart, ctend - 1);
            }
            ctstart = ctend;
        }
    }

    private void fdump(int from, int to) {
        int j;
        int i;
        if (from >= this.f.length) {
            return;
        }
        this.rep.append("<br>Hex:");
        for (i = from; i <= to && i < this.f.length; i += 16) {
            this.rep.append("<br>");
            for (j = 0; j < 16 && i + j < this.f.length && i + j <= to; ++j) {
                this.rep.append(this.m2(Integer.toHexString(this.f[i + j] & 0xFF)));
                if (j != 7) continue;
                this.rep.append(' ');
            }
            this.rep.append("  ");
        }
        this.rep.append("<br>Ascii:");
        for (i = from; i <= to && i < this.f.length; i += 16) {
            this.rep.append("<br>");
            for (j = 0; j < 16 && i + j < this.f.length && i + j <= to; ++j) {
                char c = (char)this.f[i + j];
                if (c == '<') {
                    this.rep.append("&lt;");
                } else if (c == '>') {
                    this.rep.append("&gt;");
                } else if (c == '&') {
                    this.rep.append("&amp;");
                } else if (c >= ' ' && c <= '\u0080') {
                    this.rep.append(c);
                } else {
                    this.rep.append('.');
                }
                if (j != 7) continue;
                this.rep.append(' ');
            }
        }
    }

    private String m2(String hx) {
        if (hx.length() < 2) {
            return "0" + hx;
        }
        return hx;
    }

    private String get_hdword(int offs) {
        return Integer.toHexString(this.get_dword(offs));
    }

    private String png_get_hdword(int offs) {
        return Integer.toHexString(this.png_get_dword(offs));
    }

    private String get_hword(int offs) {
        return Integer.toHexString(this.get_word(offs));
    }

    private int uf(int offs) {
        if (offs >= this.f.length) {
            return 0;
        }
        byte r = this.f[offs];
        return r & 0xFF;
    }

    private int get_dword(int offs) {
        if (offs + 3 >= this.f.length) {
            return 0;
        }
        return this.uf(offs) + (this.uf(offs + 1) << 8) + (this.uf(offs + 2) << 16) + (this.uf(offs + 3) << 24);
    }

    private int png_get_dword(int offs) {
        if (offs + 3 >= this.f.length) {
            return 0;
        }
        return this.uf(offs + 3) + (this.uf(offs + 2) << 8) + (this.uf(offs + 1) << 16) + (this.uf(offs) << 24);
    }

    private int get_word(int offs) {
        if (offs + 1 >= this.f.length) {
            return 0;
        }
        return this.uf(offs) + (this.uf(offs + 1) << 8);
    }

    private int png_get_word(int offs) {
        if (offs + 1 >= this.f.length) {
            return 0;
        }
        return this.uf(offs + 1) + (this.uf(offs) << 8);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.report = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.OKButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Format Analysis");
        this.jPanel1.setMinimumSize(new Dimension(400, 300));
        this.jPanel1.setPreferredSize(new Dimension(400, 350));
        this.jScrollPane1.setMinimumSize(new Dimension(400, 260));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 260));
        this.report.setContentType("text/html");
        this.report.setFont(new Font("Courier New", 0, 14));
        this.jScrollPane1.setViewportView(this.report);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 815, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setMinimumSize(new Dimension(400, 35));
        this.jPanel2.setPreferredSize(new Dimension(400, 35));
        this.OKButton.setText("OK");
        this.OKButton.setHorizontalTextPosition(0);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileAnalysis.this.OKButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.OKButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

