/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import stegsolve.AboutFrame;
import stegsolve.Combiner;
import stegsolve.DPanel;
import stegsolve.Extract;
import stegsolve.FileAnalysis;
import stegsolve.FrameBrowser;
import stegsolve.Stereo;
import stegsolve.Transform;
import stegsolve.ZoomSlider;

public class StegSolve
extends JFrame {
    static StegSolve that;
    private JMenuItem about;
    private JMenuItem fileExit;
    private JMenuItem fileSave;
    private JMenuItem fileOpen;
    private JMenuItem analyseFormat;
    private JMenuItem analyseExtract;
    private JMenuItem stereoSolve;
    private JMenuItem frameBrowse;
    private JMenuItem imageCombine;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuAnalyse;
    private JMenu menuHelp;
    private JLabel nowShowing;
    private JPanel buttonPanel;
    private ZoomSlider zoomSlider;
    private JButton forwardButton;
    private JButton backwardButton;
    private DPanel dp;
    private JScrollPane scrollPane;
    private File sfile = null;
    private BufferedImage bi = null;
    private Transform transform = null;
    private Action backButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StegSolve.this.backwardButtonActionPerformed(e);
        }
    };
    private Action forwardButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StegSolve.this.forwardButtonActionPerformed(e);
        }
    };

    private StegSolve() {
        that = this;
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.fileOpen = new JMenuItem();
        this.fileSave = new JMenuItem();
        this.fileExit = new JMenuItem();
        this.menuAnalyse = new JMenu();
        this.analyseFormat = new JMenuItem();
        this.analyseExtract = new JMenuItem();
        this.stereoSolve = new JMenuItem();
        this.frameBrowse = new JMenuItem();
        this.imageCombine = new JMenuItem();
        this.menuHelp = new JMenu();
        this.about = new JMenuItem();
        this.nowShowing = new JLabel();
        this.setDefaultCloseOperation(3);
        this.menuFile.setText("File");
        this.fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 0));
        this.fileOpen.setText("Open");
        this.fileOpen.addActionListener(this::fileOpenActionPerformed);
        this.menuFile.add(this.fileOpen);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        this.fileSave.setText("Save As");
        this.fileSave.addActionListener(this::fileSaveActionPerformed);
        this.menuFile.add(this.fileSave);
        this.fileExit.setAccelerator(KeyStroke.getKeyStroke(88, 0));
        this.fileExit.setText("Exit");
        this.fileExit.addActionListener(this::fileExitActionPerformed);
        this.menuFile.add(this.fileExit);
        this.menuBar.add(this.menuFile);
        this.menuAnalyse.setText("Analyse");
        this.analyseFormat.setText("File Format");
        this.analyseFormat.addActionListener(this::analyseFormatActionPerformed);
        this.menuAnalyse.add(this.analyseFormat);
        this.analyseExtract.setText("Data Extract");
        this.analyseExtract.addActionListener(this::analyseExtractActionPerformed);
        this.menuAnalyse.add(this.analyseExtract);
        this.stereoSolve.setText("Stereogram Solver");
        this.stereoSolve.addActionListener(this::stereoSolveActionPerformed);
        this.menuAnalyse.add(this.stereoSolve);
        this.frameBrowse.setText("Frame Browser");
        this.frameBrowse.addActionListener(this::frameBrowseActionPerformed);
        this.menuAnalyse.add(this.frameBrowse);
        this.imageCombine.setText("Image Combiner");
        this.imageCombine.addActionListener(this::imageCombineActionPerformed);
        this.menuAnalyse.add(this.imageCombine);
        this.menuBar.add(this.menuAnalyse);
        this.menuHelp.setText("Help");
        this.about.setText("About");
        this.about.addActionListener(this::aboutActionPerformed);
        this.menuHelp.add(this.about);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.setLayout(new BorderLayout());
        JPanel textZoom = new JPanel();
        textZoom.setLayout(new BorderLayout());
        textZoom.add((Component)this.nowShowing, "North");
        this.buttonPanel = new JPanel();
        this.backwardButton = new JButton("<");
        this.backwardButton.addActionListener(this::backwardButtonActionPerformed);
        this.forwardButton = new JButton(">");
        this.forwardButton.addActionListener(this::forwardButtonActionPerformed);
        this.buttonPanel.add(this.backwardButton);
        this.buttonPanel.add(this.forwardButton);
        this.add((Component)this.buttonPanel, "South");
        this.zoomSlider = new ZoomSlider(10, 1000, 100);
        this.zoomSlider.addChangeListener(v -> {
            this.dp.apply(v);
            this.dp.revalidate();
        });
        textZoom.add((Component)this.zoomSlider, "South");
        this.add((Component)textZoom, "North");
        this.dp = new DPanel();
        this.scrollPane = new JScrollPane(this.dp);
        final StegSolve frame = this;
        frame.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown()) {
                    frame.addMouseWheelListener(arg01 -> StegSolve.this.scrollPane.getHorizontalScrollBar().setValue(StegSolve.this.scrollPane.getHorizontalScrollBar().getValue() + arg01.getWheelRotation()));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!e.isShiftDown()) {
                    frame.removeMouseWheelListener(frame.getMouseWheelListeners()[0]);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.add((Component)this.scrollPane, "Center");
        this.backwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(37, 0), "back");
        this.backwardButton.getActionMap().put("back", this.backButtonPress);
        this.forwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "forward");
        this.forwardButton.getActionMap().put("forward", this.forwardButtonPress);
        this.setTitle("StegSolve 1.4 by Caesum (Mod by Giotino)");
        this.setMaximumSize(this.getToolkit().getScreenSize());
        this.pack();
        this.setSize(500, 600);
    }

    private void fileExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void backwardButtonActionPerformed(ActionEvent evt) {
        if (this.transform == null) {
            return;
        }
        this.transform.back();
        this.updateImage();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        if (this.bi == null) {
            return;
        }
        this.transform.forward();
        this.updateImage();
    }

    private void aboutActionPerformed(ActionEvent evt) {
        new AboutFrame().setVisible(true);
    }

    private void analyseFormatActionPerformed(ActionEvent evt) {
        new FileAnalysis(this.sfile).setVisible(true);
    }

    private void stereoSolveActionPerformed(ActionEvent evt) {
        new Stereo(this.bi).setVisible(true);
    }

    private void frameBrowseActionPerformed(ActionEvent evt) {
        new FrameBrowser(this.bi, this.sfile).setVisible(true);
    }

    private void imageCombineActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "gif", "bmp", "png");
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle("Select image to combine with");
        int rVal = fileChooser.showOpenDialog(this);
        System.setProperty("user.dir", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (rVal == 0) {
            this.sfile = fileChooser.getSelectedFile();
            try {
                BufferedImage bi2 = null;
                bi2 = ImageIO.read(this.sfile);
                new Combiner(this.bi, bi2).setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to load file: " + e.toString());
            }
        }
    }

    private void analyseExtractActionPerformed(ActionEvent evt) {
        new Extract(this.bi).setVisible(true);
    }

    private void fileSaveActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        fileChooser.setSelectedFile(new File("solved.bmp"));
        int rVal = fileChooser.showSaveDialog(this);
        System.setProperty("user.dir", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (rVal == 0) {
            this.sfile = fileChooser.getSelectedFile();
            try {
                this.bi = this.transform.getImage();
                int rns = this.sfile.getName().lastIndexOf(".") + 1;
                if (rns == 0) {
                    ImageIO.write((RenderedImage)this.bi, "bmp", this.sfile);
                } else {
                    ImageIO.write((RenderedImage)this.bi, this.sfile.getName().substring(rns), this.sfile);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to write file: " + e.toString());
            }
        }
    }

    private void fileOpenActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "gif", "bmp", "png");
        fileChooser.setFileFilter(filter);
        int rVal = fileChooser.showOpenDialog(this);
        System.setProperty("user.dir", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (rVal == 0) {
            this.sfile = fileChooser.getSelectedFile();
            this.loadImage(this.sfile);
        }
    }

    public void loadImage(String path) {
        File sfile = new File(path);
        this.loadImage(sfile);
    }

    void loadImage(File sfile) {
        this.sfile = sfile;
        try {
            this.bi = ImageIO.read(sfile);
            this.transform = new Transform(this.bi);
            this.newImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to load file: " + e.toString());
        }
    }

    private void newImage() {
        this.nowShowing.setText(this.transform.getText());
        this.dp.setImage(this.transform.getImage());
        this.dp.setSize(this.transform.getImage().getWidth(), this.transform.getImage().getHeight());
        this.dp.setPreferredSize(new Dimension(this.transform.getImage().getWidth(), this.transform.getImage().getHeight()));
        this.setMaximumSize(this.getToolkit().getScreenSize());
        this.zoomSlider.setValue(100);
        this.dp.apply(100);
        this.scrollPane.revalidate();
        this.repaint();
    }

    private void updateImage() {
        this.nowShowing.setText(this.transform.getText());
        this.dp.setImage(this.transform.getImage());
        this.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new StegSolve().setVisible(true));
    }
}

