/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.ext.FileKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.RestKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"TIMESTAMP", "", "TIMESTAMP_SECONDS", "UUID", "UUID2", "METHOD", "Lkotlin/text/Regex;", "getMETHOD", "()Lkotlin/text/Regex;", "timeStamp", "", "uuid", "uuid2", "addHttp", "replacePlaceHolders", "methodCall", "args", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "getTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "methodParse", "plugin-apipost"})
@SourceDebugExtension(value={"SMAP\nPlaceHolders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceHolders.kt\nme/leon/toolsfx/plugin/PlaceHoldersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class PlaceHoldersKt {
    @NotNull
    public static final String TIMESTAMP = "{{timestamp}}";
    @NotNull
    public static final String TIMESTAMP_SECONDS = "{{timestamp2}}";
    @NotNull
    public static final String UUID = "{{uuid}}";
    @NotNull
    public static final String UUID2 = "{{uuid2}}";
    @NotNull
    private static final Regex METHOD = new Regex("\\{\\{(\\w+)\\((.*)\\)}}");
    @NotNull
    private static final DateTimeFormatter timeFormatter;

    @NotNull
    public static final Regex getMETHOD() {
        return METHOD;
    }

    public static final long timeStamp() {
        return System.currentTimeMillis();
    }

    @NotNull
    public static final String uuid() {
        String string = java.util.UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String uuid2() {
        return StringsKt.replace$default((String)PlaceHoldersKt.uuid(), (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String addHttp(@NotNull String $this$addHttp) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$addHttp, (String)"<this>");
        String it = string = $this$addHttp;
        boolean bl = false;
        String string2 = StringsKt.startsWith$default((String)it, (String)"https:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"http:", (boolean)false, (int)2, null) ? string : null;
        if (string2 == null) {
            string2 = "http://" + $this$addHttp;
        }
        return string2;
    }

    @NotNull
    public static final String replacePlaceHolders(@NotNull String $this$replacePlaceHolders) {
        Intrinsics.checkNotNullParameter((Object)$this$replacePlaceHolders, (String)"<this>");
        return PlaceHoldersKt.methodParse(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$replacePlaceHolders, (String)UUID, (String)PlaceHoldersKt.uuid(), (boolean)false, (int)4, null), (String)UUID2, (String)PlaceHoldersKt.uuid2(), (boolean)false, (int)4, null), (String)TIMESTAMP_SECONDS, (String)String.valueOf(PlaceHoldersKt.timeStamp() / (long)1000), (boolean)false, (int)4, null), (String)TIMESTAMP, (String)String.valueOf(PlaceHoldersKt.timeStamp()), (boolean)false, (int)4, null));
    }

    @NotNull
    public static final String methodCall(@NotNull String $this$methodCall, @NotNull String args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$methodCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        System.out.println((Object)("methodCall " + $this$methodCall + ' ' + args));
        switch ($this$methodCall) {
            case "md5": {
                string = DigestsKt.hash((String)args, (String)$this$methodCall);
                break;
            }
            case "digest": {
                string = DigestsKt.hash((String)StringsKt.substringAfter$default((String)args, (String)",", null, (int)2, null), (String)StringsKt.substringBefore$default((String)args, (String)",", null, (int)2, null));
                break;
            }
            case "urlencode": {
                string = RestKt.getUrlEncoded((String)args);
                break;
            }
            case "base64": {
                string = Base64Kt.base64$default((String)args, null, null, (boolean)false, (int)7, null);
                break;
            }
            case "base64File": {
                string = Base64Kt.base64$default((byte[])FilesKt.readBytes((File)FileKt.toFile((String)args)), null, (boolean)false, (int)3, null);
                break;
            }
            case "binary": {
                string = ConverterKt.toBinaryString((String)args);
                break;
            }
            case "env": {
                String string2 = System.getenv(args);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(...)");
                break;
            }
            case "uppercase": {
                String string3 = args.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                break;
            }
            case "lowercase": {
                String string4 = args.toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                break;
            }
            case "date2Mills": {
                string = String.valueOf(LocalDateTime.parse(args + " 00:00:00", timeFormatter).toInstant(ZoneOffset.of("+8")).toEpochMilli());
                break;
            }
            case "datetime2Mills": {
                string = String.valueOf(LocalDateTime.parse(args, timeFormatter).toInstant(ZoneOffset.of("+8")).toEpochMilli());
                break;
            }
            default: {
                string = $this$methodCall;
            }
        }
        return string;
    }

    @NotNull
    public static final DateTimeFormatter getTimeFormatter() {
        return timeFormatter;
    }

    @NotNull
    public static final String methodParse(@NotNull String $this$methodParse) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$methodParse, (String)"<this>");
                object = Regex.find$default((Regex)METHOD, (CharSequence)$this$methodParse, (int)0, (int)2, null);
                if (object == null) break block3;
                MatchResult $this$methodParse_u24lambda_u241 = object;
                boolean bl = false;
                System.out.println($this$methodParse_u24lambda_u241.getGroupValues());
                String tmp = (String)$this$methodParse_u24lambda_u241.getGroupValues().get(2);
                while (METHOD.matches((CharSequence)tmp)) {
                    tmp = PlaceHoldersKt.methodParse(tmp);
                }
                String string = StringsKt.replace$default((String)$this$methodParse, (String)((String)CollectionsKt.first((List)$this$methodParse_u24lambda_u241.getGroupValues())), (String)PlaceHoldersKt.methodCall((String)$this$methodParse_u24lambda_u241.getGroupValues().get(1), tmp), (boolean)false, (int)4, null);
                object = string;
                if (string != null) break block4;
            }
            object = $this$methodParse;
        }
        return object;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        timeFormatter = dateTimeFormatter;
    }
}

