/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.leon.toolsfx.plugin.table.CellGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001+B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00070\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007J\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u001d\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00028\u00012\u0006\u0010 \u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010&2\u0006\u0010'\u001a\u00020\nH\u0002J*\u0010(\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030&0)2\u0010\u0010*\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030&H\u0002R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lme/leon/toolsfx/plugin/table/EditingCell;", "S", "T", "Ljavafx/scene/control/TableCell;", "<init>", "()V", "converter", "Ljavafx/util/StringConverter;", "(Ljavafx/util/StringConverter;)V", "isFieldEditable", "", "(Ljavafx/util/StringConverter;Z)V", "textFieldCell", "Ljavafx/scene/control/TextField;", "getTextFieldCell", "()Ljavafx/scene/control/TextField;", "setTextFieldCell", "(Ljavafx/scene/control/TextField;)V", "contextTableView", "Ljavafx/scene/control/TableView;", "getContextTableView", "()Ljavafx/scene/control/TableView;", "Ljavafx/beans/property/ObjectProperty;", "converterProperty", "setConverter", "", "value", "getConverter", "startEdit", "cancelEdit", "updateItem", "item", "empty", "(Ljava/lang/Object;Z)V", "setNextColumn", "event", "Ljavafx/scene/input/KeyEvent;", "getNextColumn", "Ljavafx/scene/control/TableColumn;", "forward", "getLeaves", "Ljavafx/collections/ObservableList;", "column2", "Companion", "plugin-apipost"})
public final class EditingCell<S, T>
extends TableCell<S, T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TextField textFieldCell;
    @NotNull
    private final ObjectProperty<StringConverter<T>> converter = (ObjectProperty)new SimpleObjectProperty((Object)this, "converter");
    private static int currentRow = -1;
    private static int control;

    @NotNull
    public final TextField getTextFieldCell() {
        return this.textFieldCell;
    }

    public final void setTextFieldCell(@NotNull TextField textField) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"<set-?>");
        this.textFieldCell = textField;
    }

    @NotNull
    public final TableView<S> getContextTableView() {
        TableView tableView = this.getTableView();
        Intrinsics.checkNotNullExpressionValue((Object)tableView, (String)"getTableView(...)");
        return tableView;
    }

    public EditingCell() {
        this(null);
        this.textFieldCell = CellGenerator.createTextField((Cell)this, this.getConverter());
    }

    public EditingCell(@Nullable StringConverter<T> converter) {
        this.getStyleClass().add((Object)"text-field-table-cell");
        this.setConverter(converter);
        this.textFieldCell = CellGenerator.createTextField((Cell)this, this.getConverter());
    }

    public EditingCell(@Nullable StringConverter<T> converter, boolean isFieldEditable) {
        this.getStyleClass().add((Object)"text-field-table-cell");
        this.setConverter(converter);
        this.textFieldCell = CellGenerator.createTextField((Cell)this, this.getConverter());
        this.textFieldCell.setEditable(isFieldEditable);
    }

    @NotNull
    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(@Nullable StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    @Nullable
    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            CellGenerator.startEdit((Cell)this, this.getConverter(), null, null, this.textFieldCell);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        CellGenerator.cancelEdit((Cell)this, this.getConverter(), null);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellGenerator.updateItem((Cell)this, this.getConverter(), null, null, this.textFieldCell);
    }

    public final void setNextColumn(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TableColumn<S, ?> nextColumn = this.getNextColumn(!event.isShiftDown());
        if (nextColumn != null) {
            int n;
            int selectedRow = this.getTableRow().getIndex();
            if (currentRow == -1) {
                currentRow = this.getTableRow().getIndex();
            }
            if (currentRow != selectedRow) {
                currentRow = selectedRow;
            }
            int colSize = this.getTableView().getColumns().size();
            int colindex = this.getTableView().getColumns().indexOf(nextColumn);
            if (colindex == colSize - 1) {
                n = control;
                control = n + 1;
            }
            if (control > 0 && colindex == 0) {
                n = currentRow;
                currentRow = n + 1;
            }
            if (this.getTableView().getItems().size() > currentRow) {
                this.getTableView().edit(currentRow, nextColumn);
            } else {
                currentRow = 0;
                this.getTableView().edit(currentRow, nextColumn);
            }
        }
    }

    private final TableColumn<S, ?> getNextColumn(boolean forward) {
        int currentIndex;
        List columns = new ArrayList();
        for (TableColumn column2 : this.getTableView().getColumns()) {
            Intrinsics.checkNotNull((Object)column2);
            columns.addAll((Collection)this.getLeaves(column2));
        }
        if (columns.size() < 2) {
            return null;
        }
        int nextIndex = currentIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
        }
        return (TableColumn)columns.get(nextIndex);
    }

    private final ObservableList<TableColumn<S, ?>> getLeaves(TableColumn<S, ?> column2) {
        ObservableList observableList;
        ObservableList columns = FXCollections.observableArrayList();
        if (column2.getColumns().isEmpty()) {
            if (column2.isEditable()) {
                Object[] objectArray = new TableColumn[]{column2};
                columns.addAll(objectArray);
            }
            ObservableList observableList2 = columns;
            Intrinsics.checkNotNull((Object)observableList2);
            observableList = observableList2;
        } else {
            for (TableColumn column3 : column2.getColumns()) {
                Intrinsics.checkNotNull((Object)column3);
                columns.addAll((Collection)this.getLeaves(column3));
            }
            ObservableList observableList3 = columns;
            Intrinsics.checkNotNull((Object)observableList3);
            observableList = observableList3;
        }
        return observableList;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000b0\f0\b\"\u0004\b\u0002\u0010\nJH\u0010\u0007\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\r0\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\r0\f0\b\"\u0004\b\u0002\u0010\n\"\u0004\b\u0003\u0010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\u000fH\u0002JN\u0010\u0007\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\r0\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\r0\f0\b\"\u0004\b\u0002\u0010\n\"\u0004\b\u0003\u0010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/leon/toolsfx/plugin/table/EditingCell$Companion;", "", "<init>", "()V", "currentRow", "", "control", "forTableColumn", "Ljavafx/util/Callback;", "Ljavafx/scene/control/TableColumn;", "S", "", "Ljavafx/scene/control/TableCell;", "T", "converter", "Ljavafx/util/StringConverter;", "isFieldEditable", "", "plugin-apipost"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
            return this.forTableColumn((StringConverter)new DefaultStringConverter());
        }

        private final <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
            return arg_0 -> Companion.forTableColumn$lambda$0(converter, arg_0);
        }

        @NotNull
        public final <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(@Nullable StringConverter<T> converter, boolean isFieldEditable) {
            return arg_0 -> Companion.forTableColumn$lambda$1(converter, isFieldEditable, arg_0);
        }

        private static final TableCell forTableColumn$lambda$0(StringConverter $converter, TableColumn it) {
            return new EditingCell($converter);
        }

        private static final TableCell forTableColumn$lambda$1(StringConverter $converter, boolean $isFieldEditable, TableColumn it) {
            return new EditingCell($converter, $isFieldEditable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

