struct include_dir {
    char * path;
    struct include_dir * next;
};

struct initializer_list {
    struct token * first_token;
    struct initializer_list_item * head;
    struct initializer_list_item * tail;
    int size;
};

struct defer_statement {
    struct token * first_token;
    struct token * last_token;
    struct secondary_block * secondary_block;
};

struct param_list {
    unsigned char   is_var_args;
    unsigned char   is_void;
    struct param * head;
    struct param * tail;
};

struct type {
    int category;
    int attributes_flags;
    int msvc_declspec_flags;
    int alignment_specifier_flags;
    int type_specifier_flags;
    int type_qualifier_flags;
    int storage_class_specifier_flags;
    char * name_opt;
    struct struct_or_union_specifier * struct_or_union_specifier;
    struct enum_specifier * enum_specifier;
    struct expression * array_num_elements_expression;
    unsigned int num_of_elements;
    unsigned char   has_static_array_size;
    unsigned char   address_of;
    struct param_list  params;
    struct type * next;
};

union _struct_tag_591 {
    unsigned char   bool_value;
    signed char signed_char_value;
    unsigned char unsigned_char_value;
    signed short signed_short_value;
    unsigned short unsigned_short_value;
    signed int signed_int_value;
    unsigned int unsigned_int_value;
    signed long signed_long_value;
    unsigned long unsigned_long_value;
    signed long long signed_long_long_value;
    unsigned long long unsigned_long_long_value;
    float float_value;
    double double_value;
    long double long_double_value;
    void * void_pointer;
};

struct object {
    int state;
    int value_type;
    struct type  type;
    char * debug_name;
    union _struct_tag_591  value;
    struct object * parent;
    struct expression * p_init_expression;
    struct object * members;
    struct object * next;
};

struct attribute_argument_clause {
    struct balanced_token_sequence * p_balanced_token_sequence;
    struct token * token;
};

struct attribute_list {
    int attributes_flags;
    struct attribute * head;
    struct attribute * tail;
};

struct tm {
    int tm_sec;
    int tm_min;
    int tm_hour;
    int tm_mday;
    int tm_mon;
    int tm_year;
    int tm_wday;
    int tm_yday;
    int tm_isdst;
};

struct generic_assoc_list {
    struct generic_association * head;
    struct generic_association * tail;
};

struct braced_initializer {
    struct token * first_token;
    struct token * last_token;
    struct initializer_list * initializer_list;
};

union _struct_tag_5 {
    unsigned int number;
    struct enum_specifier * p_enum_specifier;
    struct enumerator * p_enumerator;
    struct struct_or_union_specifier * p_struct_or_union_specifier;
    struct declarator * p_declarator;
    struct init_declarator * p_init_declarator;
    struct macro * p_macro;
    struct struct_entry * p_struct_entry;
};

struct map_entry {
    struct map_entry * next;
    unsigned int hash;
    char * key;
    int type;
    union _struct_tag_5  data;
};

struct hash_map {
    struct map_entry ** table;
    int capacity;
    int size;
};

struct msvc_declspec {
    int flags;
    struct token * token;
};

struct type_name {
    struct token * first_token;
    struct token * last_token;
    struct specifier_qualifier_list * specifier_qualifier_list;
    struct declarator * abstract_declarator;
    struct type  type;
};

struct function_specifier {
    int flags;
    struct token * token;
};

struct _iobuf {
    void * _Placeholder;
};

struct defer_list_item {
    struct declarator * declarator;
    struct defer_statement * defer_statement;
    struct defer_list_item * next;
};

struct member_declarator_list {
    struct member_declarator * head;
    struct member_declarator * tail;
};

struct _stat64i32 {
    unsigned int st_dev;
    unsigned short st_ino;
    unsigned short st_mode;
    short st_nlink;
    short st_uid;
    short st_gid;
    unsigned int st_rdev;
    long st_size;
    __int64 st_atime;
    __int64 st_mtime;
    __int64 st_ctime;
};

struct typeof_specifier_argument {
    struct expression * expression;
    struct type_name * type_name;
};

struct label {
    struct expression * constant_expression;
    struct expression * constant_expression_end;
    struct token * p_identifier_opt;
    struct token * p_first_token;
    struct label * next;
    int label_id;
};

struct case_label_list {
    struct label * head;
    struct label * tail;
};

struct flow_objects_view {
    struct flow_object ** data;
    int size;
    int capacity;
};

struct flow_object_state {
    char * dbg_name;
    int state_number;
    struct flow_object * pointed;
    int state;
    struct flow_objects_view  alternatives;
    struct flow_object_state * next;
};

struct flow_object {
    unsigned int visit_number;
    struct flow_object * parent;
    struct declarator * p_declarator_origin;
    struct expression * p_expression_origin;
    struct flow_objects_view  members;
    struct flow_object_state  current;
    int id;
    unsigned char   is_temporary;
};

struct break_reference {
    struct selection_statement * p_selection_statement;
    struct iteration_statement * p_iteration_statement;
};

struct attribute_specifier_sequence {
    struct token * first_token;
    struct token * last_token;
    int attributes_flags;
    struct attribute_specifier * head;
    struct attribute_specifier * tail;
};

struct secondary_block {
    struct token * first_token;
    struct token * last_token;
    struct statement * statement;
};

struct stream {
    char * source;
    char * current;
    int line;
    int col;
    int line_continuation_count;
    char * path;
};

struct diagnostic {
    unsigned long long errors;
    unsigned long long warnings;
    unsigned long long notes;
};

struct diagnostic_stack {
    int top_index;
    struct diagnostic stack[10];
};

struct options {
    int input;
    int target;
    struct diagnostic_stack  diagnostic_stack;
    int style;
    unsigned char   show_includes;
    unsigned char   disable_assert;
    unsigned char   flow_analysis;
    unsigned char   test_mode;
    unsigned char   null_checks_enabled;
    unsigned char   ownership_enabled;
    unsigned char   preprocess_only;
    unsigned char   preprocess_def_macro;
    unsigned char   clear_error_at_end;
    unsigned char   sarif_output;
    unsigned char   no_output;
    unsigned char   const_literal;
    unsigned char   visual_studio_ouput_format;
    unsigned char   dump_tokens;
    unsigned char   dump_pptokens;
    unsigned char   auto_config;
    unsigned char   do_static_debug;
    int static_debug_lines;
    char output[200];
    char sarifpath[200];
};

struct scope_list {
    struct scope * head;
    struct scope * tail;
};

struct label_list {
    struct label_list_item * head;
    struct label_list_item * tail;
};

struct token_list {
    struct token * head;
    struct token * tail;
};

struct parser_ctx {
    struct options  options;
    struct scope_list  scopes;
    struct declarator * p_current_function_opt;
    struct scope * p_current_function_scope_opt;
    struct label_list  label_list;
    struct try_statement * p_current_try_statement_opt;
    struct defer_statement * p_current_defer_statement_opt;
    struct selection_statement * p_current_selection_statement;
    struct _iobuf * sarif_file;
    unsigned int sarif_entries;
    struct token_list  input_list;
    struct token * current;
    struct token * previous;
    unsigned char   evaluation_is_disabled;
    unsigned char   inside_generic_association;
    int label_id;
    struct report * p_report;
};

struct HINSTANCE__ {
    int unused;
};

struct block_item_list {
    struct block_item * head;
    struct block_item * tail;
};

struct init_declarator_list {
    struct init_declarator * head;
    struct init_declarator * tail;
};

struct defer_list {
    struct defer_list_item * head;
    struct defer_list_item * tail;
};

struct declaration {
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct static_assert_declaration * static_assert_declaration;
    struct pragma_declaration * pragma_declaration;
    struct declaration_specifiers * declaration_specifiers;
    struct init_declarator_list  init_declarator_list;
    struct compound_statement * function_body;
    struct defer_list  defer_list;
    struct declarator * contract_declarator;
    struct token * first_token;
    struct token * last_token;
    struct declaration * next;
};

struct dirent {
    unsigned short d_ino;
    long d_off;
    unsigned short d_reclen;
    unsigned char d_type;
    char d_name[256];
};

struct TAGDIR {
    void * handle;
    struct dirent  dirent;
};

struct enumerator_list {
    struct enumerator * head;
    struct enumerator * tail;
};

struct initializer_list_item {
    struct designation * designation;
    struct initializer * initializer;
    struct initializer_list_item * next;
};

struct attribute_specifier {
    struct token * first_token;
    struct token * last_token;
    struct attribute_list * attribute_list;
    struct attribute_specifier * next;
};

struct direct_declarator {
    struct token * name_opt;
    struct token * p_calling_convention;
    struct declarator * declarator;
    struct array_declarator * array_declarator;
    struct function_declarator * function_declarator;
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
};

struct hash_item_set {
    unsigned int number;
    struct enum_specifier * p_enum_specifier;
    struct enumerator * p_enumerator;
    struct struct_or_union_specifier * p_struct_or_union_specifier;
    struct declarator * p_declarator;
    struct init_declarator * p_init_declarator;
    struct macro * p_macro;
    struct struct_entry * p_struct_entry;
};

struct pragma_declaration {
    struct token * first_token;
    struct token * last_token;
};

struct objects {
    struct object ** items;
    int size;
    int capacity;
};

struct specifier_qualifier_list {
    int type_specifier_flags;
    int type_qualifier_flags;
    int alignment_specifier_flags;
    struct struct_or_union_specifier * struct_or_union_specifier;
    struct enum_specifier * enum_specifier;
    struct typeof_specifier * typeof_specifier;
    struct declarator * typedef_declarator;
    struct type_specifier_qualifier * head;
    struct type_specifier_qualifier * tail;
    struct token * first_token;
    struct token * last_token;
    struct attribute_specifier_sequence * p_attribute_specifier_sequence;
};

struct macro_argument {
    struct macro_parameter * macro_parameter;
    struct token_list  tokens;
    struct macro_argument * next;
};

struct param {
    struct type  type;
    struct param * next;
};

struct macro_argument_list {
    struct token_list  tokens;
    struct macro_argument * head;
    struct macro_argument * tail;
};

struct member_declarator {
    struct declarator * declarator;
    struct expression * constant_expression;
    struct member_declarator * next;
};

struct marker {
    char * file;
    int line;
    int start_col;
    int end_col;
    struct token * p_token_caret;
    struct token * p_token_begin;
    struct token * p_token_end;
};

struct selection_statement {
    struct init_statement * p_init_statement;
    struct condition * condition;
    struct secondary_block * secondary_block;
    struct secondary_block * else_secondary_block_opt;
    struct token * open_parentesis_token;
    struct token * close_parentesis_token;
    struct case_label_list  label_list;
    struct token * first_token;
    struct token * last_token;
    struct token * else_token_opt;
    struct defer_list  defer_list;
    int label_id;
};

struct defer_defer_scope {
    struct declarator * declarator;
    struct defer_statement * defer_statement;
    struct try_statement * p_try_statement;
    struct selection_statement * p_selection_statement;
    struct iteration_statement * p_iteration_statement;
    struct statement * p_statement;
    struct compound_statement * p_compound_statement;
    struct compound_statement * p_function_body;
    struct secondary_block * p_secondary_block;
    struct primary_block * p_primary_block;
    struct defer_defer_scope * last_child;
    struct defer_defer_scope * previous;
};

struct find_object_result {
    struct object * object;
    struct type  type;
};

struct generic_selection {
    struct expression * expression;
    struct type_name * type_name;
    struct expression * p_view_selected_expression;
    struct generic_assoc_list  generic_assoc_list;
    struct token * first_token;
    struct token * last_token;
};

struct object_name_list {
    char * name;
    struct object_name_list * previous;
};

struct balanced_token_sequence {
    struct balanced_token * head;
    struct balanced_token * tail;
};

struct statement {
    struct labeled_statement * labeled_statement;
    struct unlabeled_statement * unlabeled_statement;
};

struct declarator {
    unsigned char   has_shared_ownership;
    struct token * first_token_opt;
    struct token * last_token_opt;
    struct pointer * pointer;
    struct direct_declarator * direct_declarator;
    struct declaration_specifiers * declaration_specifiers;
    struct specifier_qualifier_list * specifier_qualifier_list;
    struct token * name_opt;
    struct compound_statement * function_body;
    int num_uses;
    struct object  object;
    struct flow_object * p_flow_object;
    struct expression * p_expression_true;
    struct expression * p_expression_false;
    struct expression * p_alias_of_expression;
    struct type  type;
};

struct macro_expanded {
    char * name;
    struct macro_expanded * p_previous;
};

struct static_assert_declaration {
    struct token * first_token;
    struct token * last_token;
    struct expression * constant_expression;
    struct token * string_literal_opt;
};

struct type_qualifier {
    int flags;
    struct token * token;
    struct type_qualifier * next;
};

struct declaration_list {
    struct declaration * head;
    struct declaration * tail;
};

struct primary_block {
    struct compound_statement * compound_statement;
    struct selection_statement * selection_statement;
    struct iteration_statement * iteration_statement;
    struct defer_statement * defer_statement;
    struct try_statement * try_statement;
};

struct storage_class_specifier {
    int flags;
    struct token * token;
};

struct w {
    int w;
    char * name;
};

struct object_visitor {
    int member_index;
    struct type * p_type;
    struct flow_object * p_object;
};

struct _FILETIME {
    unsigned long dwLowDateTime;
    unsigned long dwHighDateTime;
};

struct _WIN32_FIND_DATAA {
    unsigned long dwFileAttributes;
    struct _FILETIME  ftCreationTime;
    struct _FILETIME  ftLastAccessTime;
    struct _FILETIME  ftLastWriteTime;
    unsigned long nFileSizeHigh;
    unsigned long nFileSizeLow;
    unsigned long dwReserved0;
    unsigned long dwReserved1;
    char cFileName[260];
    char cAlternateFileName[14];
};

struct type_qualifier_list {
    int flags;
    struct type_qualifier * head;
    struct type_qualifier * tail;
};

struct init_declarator {
    unsigned char   has_shared_ownership;
    struct declarator * p_declarator;
    struct initializer * initializer;
    struct init_declarator * next;
};

struct token {
    int type;
    char * lexeme;
    char * original;
    int line;
    int col;
    int level;
    int flags;
    struct token * token_origin;
    struct token * next;
    struct token * prev;
};

struct member_declaration_list {
    struct token * first_token;
    struct token * last_token;
    struct member_declaration * head;
    struct member_declaration * tail;
};

struct struct_or_union_specifier {
    unsigned char   has_shared_ownership;
    struct attribute_specifier_sequence * attribute_specifier_sequence_opt;
    struct member_declaration_list  member_declaration_list;
    struct token * first_token;
    struct token * last_token;
    unsigned char   is_owner;
    struct token * tagtoken;
    char tag_name[200];
    unsigned char   has_anonymous_tag;
    unsigned char   show_anonymous_tag;
    int scope_level;
    int visit_moved;
    struct struct_or_union_specifier * complete_struct_or_union_specifier_indirection;
};

struct ast {
    struct token_list  token_list;
    struct declaration_list  declaration_list;
};

struct defer_visit_ctx {
    struct secondary_block * catch_secondary_block_opt;
    struct parser_ctx * ctx;
    struct ast  ast;
    struct defer_defer_scope * tail_block;
    int parameter_list;
};

struct labeled_statement {
    struct label * label;
    struct statement * statement;
};

struct type_specifier {
    int flags;
    struct token * token;
    struct struct_or_union_specifier * struct_or_union_specifier;
    struct typeof_specifier * typeof_specifier;
    struct enum_specifier * enum_specifier;
    struct msvc_declspec * msvc_declspec;
    struct declarator * typedef_declarator;
    struct atomic_type_specifier * atomic_type_specifier;
};

struct attribute_token {
    int attributes_flags;
    struct token * token;
};

struct expression_statement {
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct expression * expression_opt;
};

struct scope {
    int scope_level;
    struct hash_map  tags;
    struct hash_map  variables;
    struct scope * next;
    struct scope * previous;
};

struct function_declarator {
    struct direct_declarator * direct_declarator;
    struct scope  parameters_scope;
    struct parameter_type_list * parameter_type_list_opt;
};

struct flow_objects {
    struct flow_object ** data;
    int size;
    int capacity;
};

struct simple_declaration {
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct declaration_specifiers * p_declaration_specifiers;
    struct init_declarator_list  init_declarator_list;
    struct token * first_token;
    struct token * last_token;
};

struct include_dir_list {
    struct include_dir * head;
    struct include_dir * tail;
};

struct enum_specifier {
    unsigned char   has_shared_ownership;
    struct attribute_specifier_sequence * attribute_specifier_sequence_opt;
    struct specifier_qualifier_list * specifier_qualifier_list;
    char tag_name[200];
    struct enumerator_list  enumerator_list;
    struct token * tag_token;
    struct token * first_token;
    struct enum_specifier * p_complete_enum_specifier;
};

struct iteration_statement {
    struct token * first_token;
    struct token * second_token;
    struct secondary_block * secondary_block;
    struct expression * expression1;
    struct expression * expression2;
    struct expression * expression0;
    struct declaration * declaration;
    struct defer_list  defer_list;
};

struct macro_parameter {
    char * name;
    struct macro_parameter * next;
    struct token_list  expanded_list;
    unsigned char   already_expanded;
};

struct designator_list {
    struct designator * head;
    struct designator * tail;
};

struct stat {
    unsigned int st_dev;
    unsigned short st_ino;
    unsigned short st_mode;
    short st_nlink;
    short st_uid;
    short st_gid;
    unsigned int st_rdev;
    long st_size;
    __int64 st_atime;
    __int64 st_mtime;
    __int64 st_ctime;
};

struct tokenizer_ctx {
    struct options  options;
    int n_warnings;
    int n_errors;
};

struct attribute {
    int attributes_flags;
    struct attribute_token * attribute_token;
    struct attribute_argument_clause * attribute_argument_clause;
    struct attribute * next;
};

struct argument_expression_list {
    struct argument_expression * head;
    struct argument_expression * tail;
};

struct expression {
    int expression_type;
    struct type  type;
    struct object  object;
    struct type_name * type_name;
    struct braced_initializer * braced_initializer;
    struct compound_statement * compound_statement;
    struct generic_selection * generic_selection;
    struct token * first_token;
    struct token * last_token;
    struct declarator * declarator;
    struct init_declarator * p_init_declarator;
    int member_index;
    struct argument_expression_list  argument_expression_list;
    struct expression * condition_expr;
    struct expression * left;
    struct expression * right;
    unsigned char   is_assignment_expression;
};

struct type_specifier_qualifier {
    struct type_specifier * type_specifier;
    struct type_qualifier * type_qualifier;
    struct alignment_specifier * alignment_specifier;
    struct type_specifier_qualifier * next;
};

struct parameter_list {
    struct parameter_declaration * head;
    struct parameter_declaration * tail;
};

struct struct_entry_list {
    struct struct_entry ** data;
    int size;
    int capacity;
};

struct struct_entry {
    unsigned char   done;
    struct struct_or_union_specifier * p_struct_or_union_specifier;
    struct struct_entry_list  dependencies;
    struct struct_entry * next;
};

struct init_statement {
    struct expression_statement * p_expression_statement;
    struct simple_declaration * p_simple_declaration;
};

struct jump_statement {
    struct token * label;
    struct token * first_token;
    struct token * last_token;
    struct expression * expression_opt;
    int label_id;
    struct defer_list  defer_list;
};

struct balanced_token {
    struct token * token;
    struct balanced_token * next;
};

struct array_declarator {
    struct direct_declarator * direct_declarator;
    struct expression * assignment_expression;
    struct expression * expression;
    struct type_qualifier_list * type_qualifier_list_opt;
    struct token * token;
    struct token * static_token_opt;
};

struct condition {
    struct expression * expression;
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct declaration_specifiers * p_declaration_specifiers;
    struct init_declarator * p_init_declarator;
    struct token * first_token;
    struct token * last_token;
};

struct typeof_specifier {
    struct token * first_token;
    struct token * last_token;
    struct typeof_specifier_argument * typeof_specifier_argument;
    struct type  type;
};

struct parameter_type_list {
    unsigned char   is_var_args;
    unsigned char   is_void;
    struct parameter_list * parameter_list;
};

struct osstream {
    char * c_str;
    int size;
    int capacity;
};

struct atomic_type_specifier {
    struct token * token;
    struct type_name * type_name;
};

struct preprocessor_ctx {
    struct options  options;
    int flags;
    struct hash_map  macros;
    struct include_dir_list  include_dir;
    struct hash_map  pragma_once_map;
    struct token * current;
    struct token_list  input_list;
    unsigned int count_macro_value;
    unsigned char   conditional_inclusion;
    int n_warnings;
    int n_errors;
};

struct parameter_declaration {
    struct attribute_specifier_sequence * attribute_specifier_sequence_opt;
    struct declaration_specifiers * declaration_specifiers;
    struct declarator * declarator;
    struct parameter_declaration * next;
};

struct enumerator {
    unsigned char   has_shared_ownership;
    struct token * token;
    struct attribute_specifier_sequence * attribute_specifier_sequence_opt;
    struct expression * constant_expression_opt;
    struct enum_specifier * enum_specifier;
    struct enumerator * next;
    struct object  value;
};

struct compound_statement {
    struct token * first_token;
    struct token * last_token;
    struct block_item_list  block_item_list;
    struct diagnostic  diagnostic_flags;
    struct defer_list  defer_list;
};

struct designator {
    struct expression * constant_expression_opt;
    struct token * token;
    struct designator * next;
};

struct label_list_item {
    struct token * p_last_usage;
    struct token * p_defined;
    struct label_list_item * next;
};

struct initializer {
    struct token * first_token;
    struct braced_initializer * braced_initializer;
    struct expression * assignment_expression;
};

struct label_state {
    char * label_name;
    int state_number;
};

struct __crt_locale_pointers {
    struct __crt_locale_data * locinfo;
    struct __crt_multibyte_data * mbcinfo;
};

struct argument_expression {
    struct expression * expression;
    struct argument_expression * next;
    unsigned char   set_unkown;
};

struct type_list {
    struct type * head;
    struct type * tail;
};

struct d_visit_ctx {
    int indentation;
    int locals_count;
    int extern_count;
    int tag_name_count;
    struct hash_map  tag_names;
    struct hash_map  structs_map;
    struct hash_map  function_map;
    struct hash_map  static_declarators;
    struct osstream  local_declarators;
    struct osstream  add_this_before;
    struct osstream  add_this_before_external_decl;
    unsigned char   is_local;
    struct osstream  data_types;
    struct osstream  function_types;
    unsigned char   zero_mem_used;
    unsigned char   memcpy_used;
    struct declarator * p_current_function_opt;
    struct break_reference  break_reference;
    unsigned char   is__func__predefined_identifier_added;
    struct ast  ast;
};

struct declaration_specifier {
    struct storage_class_specifier * storage_class_specifier;
    struct type_specifier_qualifier * type_specifier_qualifier;
    struct function_specifier * function_specifier;
    struct alignment_specifier * alignment_specifier;
    struct declaration_specifier * next;
};

struct declaration_specifiers {
    int attributes_flags;
    int type_specifier_flags;
    int type_qualifier_flags;
    int storage_class_specifier_flags;
    int function_specifier_flags;
    int msvc_declspec_flags;
    int alignment_specifier_flags;
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct struct_or_union_specifier * struct_or_union_specifier;
    struct enum_specifier * enum_specifier;
    struct declarator * typedef_declarator;
    struct typeof_specifier * typeof_specifier;
    struct token * first_token;
    struct token * last_token;
    struct declaration_specifier * head;
    struct declaration_specifier * tail;
};

struct alignment_specifier {
    int flags;
    struct type_name * type_name;
    struct expression * constant_expression;
    struct token * token;
};

struct designation {
    struct designator_list * designator_list;
    struct token * token;
};

struct pre_expression_ctx {
    long long value;
};

struct pointer {
    struct attribute_specifier_sequence * attribute_specifier_sequence_opt;
    struct type_qualifier_list * type_qualifier_list_opt;
    struct token * calling_convention;
    struct pointer * pointer;
};

struct flow_visit_ctx {
    struct secondary_block * catch_secondary_block_opt;
    struct parser_ctx * ctx;
    struct ast  ast;
    struct type * p_return_type;
    int parameter_list;
    int state_number_generator;
    unsigned char   expression_is_not_evaluated;
    unsigned char   inside_assert;
    unsigned char   inside_contract;
    unsigned char   inside_loop;
    int throw_join_state;
    int break_join_state;
    int initial_state;
    struct flow_objects  arena;
    struct label_state labels[100];
    int labels_size;
};

struct unlabeled_statement {
    struct expression_statement * expression_statement;
    struct primary_block * primary_block;
    struct jump_statement * jump_statement;
};

struct true_false_set_item {
    struct expression * p_expression;
    int true_branch_state;
    int false_branch_state;
};

struct true_false_set {
    struct true_false_set_item * data;
    int size;
    int capacity;
};

struct macro {
    struct token * p_name_token;
    char * name;
    struct token_list  replacement_list;
    struct macro_parameter * parameters;
    unsigned char   is_function;
    int usage;
    unsigned char   expand;
    unsigned char   def_macro;
};

struct member_declaration {
    struct specifier_qualifier_list * specifier_qualifier_list;
    struct member_declarator_list * member_declarator_list_opt;
    struct static_assert_declaration * static_assert_declaration;
    struct pragma_declaration * pragma_declaration;
    struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
    struct member_declaration * next;
};

struct block_item {
    struct token * first_token;
    struct declaration * declaration;
    struct unlabeled_statement * unlabeled_statement;
    struct label * label;
    struct block_item * next;
};

struct generic_association {
    struct type  type;
    struct type_name * p_type_name;
    struct expression * expression;
    struct token * first_token;
    struct token * last_token;
    struct generic_association * next;
};

struct report {
    int no_files;
    double cpu_time_used_sec;
    int error_count;
    int warnings_count;
    int info_count;
    unsigned char   test_mode;
    int test_failed;
    int test_succeeded;
    int last_diagnostics_ids[2];
    int fatal_error_expected;
    unsigned char   ignore_this_report;
};

struct try_statement {
    struct secondary_block * secondary_block;
    struct secondary_block * catch_secondary_block_opt;
    struct token * first_token;
    struct token * last_token;
    struct token * catch_token_opt;
    int catch_label_id;
};


static void _cake_zmem(void *dest, register unsigned int len)
{
  register unsigned char *ptr = (unsigned char*)dest;
  while (len-- > 0) *ptr++ = 0;
}

static void _cake_memcpy(void * dest, const void * src, unsigned int n)
{
  char *csrc = (char *)src;
  char *cdest = (char *)dest;
  unsigned int i; 
  for (i = 0; i < n; i++) cdest[i] = csrc[i]; 
}

unsigned char  token_is_blank(struct token * p);

unsigned char  style_has_space(struct token * token)
{
    return token_is_blank(token->prev);
}

unsigned char  style_has_one_space(struct token * token)
{
    return !!(token->prev && token->prev->type == 143);
}

void token_delete(struct token * p);

void token_list_clear(struct token_list * list)
{
    struct token * p;

    p = list->head;
    while (p)
    {
        struct token * next;

        next = p->next;
        p->next = 0U;
        token_delete(p);
        p = next;
    }
    list->head = 0U;
    list->tail = 0U;
}

void token_range_add_show(struct token * first, struct token * last)
{
    {
        struct token * current;
        current = first;
        for (; current != last->next; current = current->next)
        {
            current->flags = current->flags & -65;
            if (current->next == 0U)
            {
                break;
            }
        }
    }
}

void token_range_remove_flag(struct token * first, struct token * last, int flag)
{
    {
        struct token * current;
        current = first;
        for (; current && current != last->next; current = current->next)
        {
            current->flags = current->flags & ~flag;
        }
    }
}

void token_range_add_flag(struct token * first, struct token * last, int flag)
{
    {
        struct token * current;
        current = first;
        for (; current && current != last->next; current = current->next)
        {
            current->flags |= flag;
        }
    }
}

void token_list_pop_back(struct token_list * list)
{
    if (list->head == 0U)
    {
        return;
    }
    if (list->head == list->tail)
    {
        token_delete(list->head);
        list->head = 0U;
        list->tail = 0U;
    }
    else
    {
        ;
        ;
        list->tail = list->tail->prev;
        token_delete(list->tail->next);
        list->tail->next = 0U;
        if (list->tail == list->head)
        {
            list->tail->prev = 0U;
        }
    }
    ;
}

void token_list_pop_front(struct token_list * list)
{
    struct token * p;

    if (list->head == 0U)
    {
        return;
    }
    p = list->head;
    ;
    if (list->head == list->tail)
    {
        list->head = 0U;
        list->tail = 0U;
    }
    else
    {
        list->head = p->next;
        if (list->head)
        {
            list->head->prev = 0U;
        }
    }
    p->next = 0U;
    p->prev = 0U;
    token_delete(p);
    ;
}

struct token *token_list_pop_front_get(struct token_list * list)
{
    struct token * old_head;

    if (list->head == 0U)
    {
        return 0U;
    }
    old_head = list->head;
    list->head = old_head->next;
    if (list->head != 0U)
    {
        list->head->prev = 0U;
    }
    else
    {
        list->tail = 0U;
    }
    ;
    old_head->prev = 0U;
    old_head->next = 0U;
    return old_head;
}

void token_list_swap(struct token_list * a, struct token_list * b)
{
    struct token_list  temp;

    temp = *a;
    *a = *b;
    *b = temp;
}

void free(void * ptr);

void token_delete(struct token * p)
{
    if (p)
    {
        ;
        free(p->lexeme);
        free(p);
    }
}

void token_list_set_file(struct token_list * list, struct token * filetoken, int line, int col)
{
    struct token * p;

    p = list->head;
    while (p)
    {
        p->token_origin = filetoken;
        p->line = line;
        p->col = col;
        p = p->next;
    }
}

void token_list_destroy(struct token_list * list)
{
    struct token * p;

    p = list->head;
    while (p)
    {
        struct token * next;

        next = p->next;
        p->next = 0U;
        token_delete(p);
        p = next;
    }
}

int ss_fprintf(struct osstream * stream, char * fmt, ...);
void ss_close(struct osstream * stream);

char *token_list_join_tokens(struct token_list * list, unsigned char   bliteral)
{
    struct osstream  ss;
    unsigned char   has_space;
    struct token * current;
    char * cstr;

    _cake_zmem(&ss, 12);
    if (bliteral)
    {
        ss_fprintf(&ss, "\"");
    }
    has_space = 0;
    current = list->head;
    while (current)
    {
        char * p;

        if (token_is_blank(current))
        {
            has_space = 1;
            current = current->next;
            continue;
        }
        if (has_space)
        {
            ss_fprintf(&ss, " ");
        }
        p = current->lexeme;
        while (*p)
        {
            if (*p == 34)
            {
                ss_fprintf(&ss, "\\\"");
            }
            else
            {
                ss_fprintf(&ss, "%c", *p);
            }
            p++;
        }
        current = current->next;
        if (current)
        {
            has_space = !!(current->flags & 4);
        }
    }
    if (bliteral)
    {
        ss_fprintf(&ss, "\"");
    }
    cstr = ss.c_str;
    ss.c_str = 0U;
    ss_close(&ss);
    return cstr;
}

struct token_list tokenizer(struct tokenizer_ctx * ctx, char * text, char * filename_opt, int level, int addflags);
void token_list_insert_after(struct token_list * list, struct token * after, struct token_list * append);

void token_list_paste_string_after(struct token_list * list, struct token * after, char * s)
{
    struct tokenizer_ctx  tctx;
    struct token_list  l;

    _cake_zmem(&tctx, 696);
    l = tokenizer(&tctx, s, 0U, 0, 1);
    token_list_insert_after(list, after, &l);
    token_list_destroy(&l);
}

void token_list_insert_before(struct token_list * token_list, struct token * after, struct token_list * append_list);

void token_list_paste_string_before(struct token_list * list, struct token * before, char * s)
{
    struct tokenizer_ctx  tctx;
    struct token_list  l;

    _cake_zmem(&tctx, 696);
    l = tokenizer(&tctx, s, 0U, 0, 1);
    token_list_insert_before(list, before, &l);
    token_list_destroy(&l);
}

void token_list_insert_after(struct token_list * token_list, struct token * after, struct token_list * append_list)
{
    if (append_list->head == 0U)
    {
        return;
    }
    if (token_list->head == 0U)
    {
        ;
        token_list->head = append_list->head;
        token_list->tail = append_list->tail;
        append_list->head = 0U;
        append_list->tail = 0U;
        return;
    }
    if (after == 0U)
    {
        ;
        ;
        append_list->tail->next = token_list->head;
        token_list->head->prev = append_list->tail;
        token_list->head = append_list->head;
        append_list->head->prev = 0U;
    }
    else
    {
        struct token * follow;

        follow = after->next;
        if (token_list->tail == after)
        {
            token_list->tail = append_list->tail;
        }
        else
        {
            if (token_list->head == after)
            {
            }
        }
        ;
        ;
        append_list->tail->next = follow;
        follow->prev = append_list->tail;
        after->next = append_list->head;
        append_list->head->prev = after;
    }
    append_list->head = 0U;
    append_list->tail = 0U;
    ;
}

void token_list_insert_before(struct token_list * token_list, struct token * after, struct token_list * append_list)
{
    token_list_insert_after(token_list, after->prev, append_list);
}

int __cdecl strcmp(char * _Str1, char * _Str2);

unsigned char  token_list_is_equal(struct token_list * list_a, struct token_list * list_b)
{
    struct token * p_tka;
    struct token * p_tkb;

    p_tka = list_a->head;
    p_tkb = list_b->head;
    while (p_tka && p_tkb)
    {
        if (p_tka->type != p_tkb->type)
        {
            return 0;
        }
        if (strcmp(p_tka->lexeme, p_tkb->lexeme) != 0)
        {
            return 0;
        }
        p_tka = p_tka->next;
        p_tkb = p_tkb->next;
    }
    return !!(p_tka == 0U && p_tkb == 0U);
}

struct token *token_list_add(struct token_list * list, struct token * pnew)
{
    ;
    ;
    if (list->head == 0U)
    {
        pnew->prev = 0U;
        pnew->next = 0U;
        list->head = pnew;
        list->tail = pnew;
    }
    else
    {
        ;
        ;
        pnew->prev = list->tail;
        list->tail->next = pnew;
        list->tail = pnew;
    }
    ;
    ;
    ;
    return list->tail;
}

int is_digit(struct stream * p)
{
    return (p->current[0] >= 48 && p->current[0] <= 57);
}

unsigned char  token_is_identifier_or_keyword(int t)
{
    /*switch*/
    {
        register int _R0 = t;
        if (_R0 == 8996) goto _CKL1; /*case 8996*/
        if (_R0 == 8999) goto _CKL2; /*case 8999*/
        if (_R0 == 9000) goto _CKL3; /*case 9000*/
        if (_R0 == 9001) goto _CKL4; /*case 9001*/
        if (_R0 == 9002) goto _CKL5; /*case 9002*/
        if (_R0 == 9003) goto _CKL6; /*case 9003*/
        if (_R0 == 9004) goto _CKL7; /*case 9004*/
        if (_R0 == 9005) goto _CKL8; /*case 9005*/
        if (_R0 == 9006) goto _CKL9; /*case 9006*/
        if (_R0 == 9007) goto _CKL10; /*case 9007*/
        if (_R0 == 9008) goto _CKL11; /*case 9008*/
        if (_R0 == 9009) goto _CKL12; /*case 9009*/
        if (_R0 == 9010) goto _CKL13; /*case 9010*/
        if (_R0 == 9011) goto _CKL14; /*case 9011*/
        if (_R0 == 9012) goto _CKL15; /*case 9012*/
        if (_R0 == 9013) goto _CKL16; /*case 9013*/
        if (_R0 == 9014) goto _CKL17; /*case 9014*/
        if (_R0 == 9015) goto _CKL18; /*case 9015*/
        if (_R0 == 9016) goto _CKL19; /*case 9016*/
        if (_R0 == 9017) goto _CKL20; /*case 9017*/
        if (_R0 == 9018) goto _CKL21; /*case 9018*/
        if (_R0 == 9019) goto _CKL22; /*case 9019*/
        if (_R0 == 9020) goto _CKL23; /*case 9020*/
        if (_R0 == 9021) goto _CKL24; /*case 9021*/
        if (_R0 == 9022) goto _CKL25; /*case 9022*/
        if (_R0 == 9023) goto _CKL26; /*case 9023*/
        if (_R0 == 9024) goto _CKL27; /*case 9024*/
        if (_R0 == 9025) goto _CKL28; /*case 9025*/
        if (_R0 == 9026) goto _CKL29; /*case 9026*/
        if (_R0 == 9027) goto _CKL30; /*case 9027*/
        if (_R0 == 9028) goto _CKL31; /*case 9028*/
        if (_R0 == 9029) goto _CKL32; /*case 9029*/
        if (_R0 == 9030) goto _CKL33; /*case 9030*/
        if (_R0 == 9032) goto _CKL34; /*case 9032*/
        if (_R0 == 9033) goto _CKL35; /*case 9033*/
        if (_R0 == 9034) goto _CKL36; /*case 9034*/
        if (_R0 == 9035) goto _CKL37; /*case 9035*/
        if (_R0 == 9036) goto _CKL38; /*case 9036*/
        if (_R0 == 9037) goto _CKL39; /*case 9037*/
        if (_R0 == 9038) goto _CKL40; /*case 9038*/
        if (_R0 == 9039) goto _CKL41; /*case 9039*/
        if (_R0 == 9040) goto _CKL42; /*case 9040*/
        if (_R0 == 9041) goto _CKL43; /*case 9041*/
        if (_R0 == 9042) goto _CKL44; /*case 9042*/
        if (_R0 == 9043) goto _CKL45; /*case 9043*/
        if (_R0 == 9044) goto _CKL46; /*case 9044*/
        if (_R0 == 9045) goto _CKL47; /*case 9045*/
        if (_R0 == 9052) goto _CKL48; /*case 9052*/
        if (_R0 == 9053) goto _CKL49; /*case 9053*/
        if (_R0 == 9054) goto _CKL50; /*case 9054*/
        if (_R0 == 9055) goto _CKL51; /*case 9055*/
        if (_R0 == 9056) goto _CKL52; /*case 9056*/
        if (_R0 == 9057) goto _CKL53; /*case 9057*/
        if (_R0 == 9058) goto _CKL54; /*case 9058*/
        if (_R0 == 9059) goto _CKL55; /*case 9059*/
        if (_R0 == 9060) goto _CKL56; /*case 9060*/
        if (_R0 == 9061) goto _CKL57; /*case 9061*/
        if (_R0 == 9062) goto _CKL58; /*case 9062*/
        if (_R0 == 9063) goto _CKL59; /*case 9063*/
        if (_R0 == 9064) goto _CKL60; /*case 9064*/
        if (_R0 == 9065) goto _CKL61; /*case 9065*/
        if (_R0 == 9066) goto _CKL62; /*case 9066*/
        if (_R0 == 9067) goto _CKL63; /*case 9067*/
        if (_R0 == 9068) goto _CKL64; /*case 9068*/
        if (_R0 == 9069) goto _CKL65; /*case 9069*/
        if (_R0 == 9070) goto _CKL66; /*case 9070*/
        if (_R0 == 9071) goto _CKL67; /*case 9071*/
        if (_R0 == 9072) goto _CKL68; /*case 9072*/
        if (_R0 == 9073) goto _CKL69; /*case 9073*/
        if (_R0 == 9074) goto _CKL70; /*case 9074*/
        if (_R0 == 9075) goto _CKL71; /*case 9075*/
        if (_R0 == 9076) goto _CKL72; /*case 9076*/
        if (_R0 == 9077) goto _CKL73; /*case 9077*/
        if (_R0 == 9078) goto _CKL74; /*case 9078*/
        if (_R0 == 9079) goto _CKL75; /*case 9079*/
        if (_R0 == 9080) goto _CKL76; /*case 9080*/
        if (_R0 == 9081) goto _CKL77; /*case 9081*/
        if (_R0 == 9082) goto _CKL78; /*case 9082*/
        if (_R0 == 9083) goto _CKL79; /*case 9083*/
        if (_R0 == 9084) goto _CKL80; /*case 9084*/
        if (_R0 == 9085) goto _CKL81; /*case 9085*/
        if (_R0 == 9086) goto _CKL82; /*case 9086*/
        if (_R0 == 9087) goto _CKL83; /*case 9087*/
        if (_R0 == 9088) goto _CKL84; /*case 9088*/
        goto _CKL85;/*default*/

        {
            _CKL1:/*case 8996*/ 
            return 1;
            _CKL2:/*case 8999*/ 
            _CKL3:/*case 9000*/ 
            _CKL4:/*case 9001*/ 
            _CKL5:/*case 9002*/ 
            _CKL6:/*case 9003*/ 
            _CKL7:/*case 9004*/ 
            _CKL8:/*case 9005*/ 
            _CKL9:/*case 9006*/ 
            _CKL10:/*case 9007*/ 
            _CKL11:/*case 9008*/ 
            _CKL12:/*case 9009*/ 
            _CKL13:/*case 9010*/ 
            _CKL14:/*case 9011*/ 
            _CKL15:/*case 9012*/ 
            _CKL16:/*case 9013*/ 
            _CKL17:/*case 9014*/ 
            _CKL18:/*case 9015*/ 
            _CKL19:/*case 9016*/ 
            _CKL20:/*case 9017*/ 
            _CKL21:/*case 9018*/ 
            _CKL22:/*case 9019*/ 
            _CKL23:/*case 9020*/ 
            _CKL24:/*case 9021*/ 
            _CKL25:/*case 9022*/ 
            _CKL26:/*case 9023*/ 
            _CKL27:/*case 9024*/ 
            _CKL28:/*case 9025*/ 
            _CKL29:/*case 9026*/ 
            _CKL30:/*case 9027*/ 
            _CKL31:/*case 9028*/ 
            _CKL32:/*case 9029*/ 
            _CKL33:/*case 9030*/ 
            _CKL34:/*case 9032*/ 
            _CKL35:/*case 9033*/ 
            _CKL36:/*case 9034*/ 
            _CKL37:/*case 9035*/ 
            _CKL38:/*case 9036*/ 
            _CKL39:/*case 9037*/ 
            _CKL40:/*case 9038*/ 
            _CKL41:/*case 9039*/ 
            _CKL42:/*case 9040*/ 
            _CKL43:/*case 9041*/ 
            _CKL44:/*case 9042*/ 
            _CKL45:/*case 9043*/ 
            _CKL46:/*case 9044*/ 
            _CKL47:/*case 9045*/ 
            _CKL48:/*case 9052*/ 
            _CKL49:/*case 9053*/ 
            _CKL50:/*case 9054*/ 
            _CKL51:/*case 9055*/ 
            _CKL52:/*case 9056*/ 
            _CKL53:/*case 9057*/ 
            _CKL54:/*case 9058*/ 
            _CKL55:/*case 9059*/ 
            _CKL56:/*case 9060*/ 
            _CKL57:/*case 9061*/ 
            _CKL58:/*case 9062*/ 
            _CKL59:/*case 9063*/ 
            _CKL60:/*case 9064*/ 
            _CKL61:/*case 9065*/ 
            _CKL62:/*case 9066*/ 
            _CKL63:/*case 9067*/ 
            _CKL64:/*case 9068*/ 
            _CKL65:/*case 9069*/ 
            _CKL66:/*case 9070*/ 
            _CKL67:/*case 9071*/ 
            _CKL68:/*case 9072*/ 
            _CKL69:/*case 9073*/ 
            _CKL70:/*case 9074*/ 
            _CKL71:/*case 9075*/ 
            _CKL72:/*case 9076*/ 
            _CKL73:/*case 9077*/ 
            _CKL74:/*case 9078*/ 
            _CKL75:/*case 9079*/ 
            _CKL76:/*case 9080*/ 
            _CKL77:/*case 9081*/ 
            _CKL78:/*case 9082*/ 
            _CKL79:/*case 9083*/ 
            _CKL80:/*case 9084*/ 
            _CKL81:/*case 9085*/ 
            _CKL82:/*case 9086*/ 
            _CKL83:/*case 9087*/ 
            _CKL84:/*case 9088*/ 
            return 1;
            _CKL85: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

unsigned char  token_is_blank(struct token * p)
{
    return !!(p->type == 8998 || p->type == 143 || p->type == 132 || p->type == 133);
}

struct token *clone_token(struct token * p);

struct token *token_list_clone_and_add(struct token_list * list, struct token * pnew)
{
    struct token * clone;

    clone = clone_token(pnew);
    if (clone == 0U)
    {
        return 0U;
    }
    return token_list_add(list, clone);
}

void token_list_append_list_at_beginning(struct token_list * dest, struct token_list * source)
{
    if (source->head == 0U)
    {
        return;
    }
    if (dest->head == 0U)
    {
        dest->head = source->head;
        dest->tail = source->tail;
    }
    else
    {
        ;
        ;
        source->tail->next = dest->head;
        dest->head = source->head;
    }
    source->head = 0U;
    source->tail = 0U;
    ;
}

void token_list_append_list(struct token_list * dest, struct token_list * source)
{
    if (source->head == 0U)
    {
        return;
    }
    if (dest->head == 0U)
    {
        dest->head = source->head;
        dest->tail = source->tail;
    }
    else
    {
        ;
        ;
        dest->tail->next = source->head;
        source->head->prev = dest->tail;
        dest->tail = source->tail;
    }
    source->head = 0U;
    source->tail = 0U;
    ;
}

void *calloc(unsigned int nmemb, unsigned int size);
char *strdup(char * src);

struct token *clone_token(struct token * p)
{
    struct token * token;
    char * lexeme;

    token = calloc(1, 40U);
    if (token == 0U)
    {
        return 0U;
    }
    lexeme = strdup(p->lexeme);
    if (lexeme == 0U)
    {
        free(token);
        return 0U;
    }
    *token = *p;
    token->lexeme = lexeme;
    token->next = 0U;
    token->prev = 0U;
    return token;
}

struct token_list token_list_remove_get(struct token_list * list, struct token * first, struct token * last)
{
    struct token_list  r;
    struct token * before_first;
    struct token * after_last;

    _cake_zmem(&r, 8);
    before_first = first->prev;
    after_last = last->next;
    if (before_first)
    {
        before_first->next = after_last;
    }
    else
    {
        list->head = last->next;
    }
    if (after_last)
    {
        after_last->prev = before_first;
    }
    else
    {
        list->tail = 0U;
    }
    last->next = 0U;
    r.head = (struct token *)first;
    first->prev = 0U;
    r.tail = last;
    return r;
}

void token_list_remove(struct token_list * list, struct token * first, struct token * last)
{
    struct token_list  r;

    r = token_list_remove_get(list, first, last);
    token_list_destroy(&r);
}

unsigned char  token_list_is_empty(struct token_list * p)
{
    ;
    return !!(p->head == 0U);
}



int __cdecl __stdio_common_vfprintf(unsigned __int64 _Options, struct _iobuf * _Stream, char * _Format, struct __crt_locale_pointers * _Locale, char * _ArgList);

static unsigned __int64 __ck__OptionsStorage1;
inline unsigned __int64 *__cdecl __local_stdio_printf_options(void)
{
    return &__ck__OptionsStorage1;
}
inline int __cdecl _vfprintf_l(struct _iobuf * _Stream, char * _Format, struct __crt_locale_pointers * _Locale, char * _ArgList)
{
    return __stdio_common_vfprintf((*__local_stdio_printf_options()), _Stream, _Format, _Locale, _ArgList);
}
struct _iobuf *__cdecl __acrt_iob_func(unsigned int _Ix);
inline int __cdecl printf(char * _Format, ...)
{
    int _Result;
    char * _ArgList;

    ((void)(_ArgList = (char *)(&(_Format)) + 4U));
    _Result = _vfprintf_l((__acrt_iob_func(1)), _Format, 0U, _ArgList);
    ((void)(_ArgList = 0U));
    return _Result;
}
void print_literal2(char * s);

void print_list(struct token_list * list)
{
    struct token * current;

    current = list->head;
    while (current)
    {
        if (current != list->head)
        {
            printf("\xcb\xb0");
        }
        print_literal2(current->lexeme);
        printf("\x1b[0m");
        if (current == list->tail)
        {
        }
        current = current->next;
    }
    printf("\n");
}

void print_literal2(char * s)
{
    while (*s)
    {
        /*switch*/
        {
            register char _R1 = *s;
            if (_R1 == 10) goto _CKL1; /*case 10*/
            goto _CKL2;/*default*/

            {
                _CKL1:/*case 10*/ 
                printf("\\n");
                goto _CKL0; /*break*/

                _CKL2: /*default*/ 
                printf("%c", *s);
            }
            _CKL0:;
        }
        s++;
    }
}

int snprintf(char * _Buffer, unsigned int _BufferCount, char * _Format, ...);
char *get_token_name(int tk);
char *__cdecl strcat(char * _Destination, char * _Source);

void print_token(struct token * p_token)
{
    char buffer0[50];
    char buffer[50];

    {
        int i;
        i = 0;
        for (; i < p_token->level; i++)
        {
            printf("  ");
        }
    }
    if (p_token->flags & 1)
    {
        printf("\x1b[92m");
    }
    else
    {
        printf("\x1b[37m");
    }
    _cake_zmem(&buffer0, 50);
    snprintf(buffer0, 50U, "%d:%d", p_token->line, p_token->col);
    printf("%-6s ", buffer0);
    printf("%-20s ", get_token_name(p_token->type));
    if (p_token->flags & 2)
    {
        printf("\x1b[36;1m");
    }
    _cake_zmem(&buffer, 50);
    strcat(buffer, "[");
    if (p_token->flags & 1)
    {
        strcat(buffer, "final ");
    }
    if (p_token->flags & 64)
    {
        strcat(buffer, "hide ");
    }
    if (p_token->flags & 2)
    {
        strcat(buffer, "expanded ");
    }
    if (p_token->flags & 4)
    {
        strcat(buffer, "space ");
    }
    if (p_token->flags & 8)
    {
        strcat(buffer, "newline ");
    }
    strcat(buffer, "]");
    printf("%-20s ", buffer);
    print_literal2(p_token->lexeme);
    printf("\n");
    printf("\x1b[0m");
}

void print_tokens(struct token * p_token)
{
    struct token * current;

    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n""\x1b[0m");
    current = p_token;
    while (current)
    {
        print_token(current);
        current = current->next;
    }
    printf("\n");
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n""\x1b[0m");
    printf("\x1b[0m");
}

void print_token_html(struct token * p_token)
{
    printf("<span class=\"");
    if (!(p_token->flags & 1))
    {
        printf("notfinal ");
    }
    if (p_token->flags & 1)
    {
        printf("final ");
    }
    if (p_token->flags & 64)
    {
        printf("hide ");
    }
    if (p_token->flags & 2)
    {
        printf("expanded ");
    }
    if (p_token->flags & 4)
    {
        printf("space ");
    }
    if (p_token->flags & 8)
    {
        printf("newline ");
    }
    printf("\">");
    print_literal2(p_token->lexeme);
    printf("</span>");
    if (p_token->type == 10 || p_token->type == 8998)
    {
        printf("<br>\n");
    }
}

void print_tokens_html(struct token * p_token)
{
    struct token * current;

    printf("<pre>\n");
    current = p_token;
    while (current)
    {
        print_token_html(current);
        current = current->next;
    }
    printf("\n</pre>");
}

void print_position(char * path, int line, int col, unsigned char   visual_studio_ouput_format)
{
    if (visual_studio_ouput_format)
    {
        printf("%s(%d,%d): ", path ? path : "<>", line, col);
    }
    else
    {
        printf("\x1b[97m""%s:%d:%d: ", path ? path : "<>", line, col);
    }
}

int __cdecl putc(int _Character, struct _iobuf * _Stream);

void print_line_and_token(struct marker * p_marker, unsigned char   visual_studio_ouput_format)
{
    if (1) /*try*/
    {
        struct token * p_token;
        int line;
        char nbuffer[20];
        int n;
        struct token * p_line_begin;
        struct token * p_token_begin;
        struct token * p_token_end;
        unsigned char   expand_macro;
        struct token * p_item;
        unsigned char   complete;
        int start_col;
        int end_col;
        unsigned char   onoff;

        p_token = p_marker->p_token_caret ? p_marker->p_token_caret : p_marker->p_token_begin;
        if (p_token == 0U)
        {
            goto _CKL0;/*throw*/
        }
        line = p_marker->line;
        if (!visual_studio_ouput_format)
        {
            printf("\x1b[0m");
        }
        _cake_zmem(&nbuffer, 20);
        n = snprintf(nbuffer, 20U, "%d", line);
        printf(" %s |", nbuffer);
        p_line_begin = p_token;
        while (p_line_begin->prev && (p_line_begin->prev->type != 10 && p_line_begin->prev->type != 8998))
        {
            p_line_begin = p_line_begin->prev;
        }
        p_token_begin = p_marker->p_token_begin ? p_marker->p_token_begin : p_marker->p_token_caret;
        p_token_end = p_marker->p_token_end ? p_marker->p_token_end : p_marker->p_token_caret;
        if (p_token_begin == 0U)
        {
            goto _CKL0;/*throw*/
        }
        expand_macro = !!(p_token_begin->flags & 2);
        if (!visual_studio_ouput_format)
        {
            printf("\x1b[34;1m");
        }
        p_item = p_line_begin;
        while (p_item)
        {
            if (!visual_studio_ouput_format)
            {
                if (p_item->flags & 2)
                {
                    printf("\x1b[90m");
                }
                else
                {
                    if (p_item->type >= 8999 && p_item->type <= 9088)
                    {
                        printf("\x1b[34m");
                    }
                    else
                    {
                        if (p_item->type == 133 || p_item->type == 132)
                        {
                            printf("\x1b[93m");
                        }
                    }
                }
            }
            if (!(p_item->flags & 2) || expand_macro)
            {
                char * p;

                p = p_item->lexeme;
                while (*p)
                {
                    putc(*p, (__acrt_iob_func(1)));
                    p++;
                }
            }
            if (!visual_studio_ouput_format)
            {
                printf("\x1b[0m");
            }
            if (p_item->type == 10)
            {
                break;
            }
            p_item = p_item->next;
        }
        if (!visual_studio_ouput_format)
        {
            printf("\x1b[0m");
        }
        if (p_item == 0U)
        {
            printf("\n");
        }
        printf(" %*s |", n, " ");
        complete = 0;
        start_col = 1;
        end_col = 1;
        onoff = 0;
        p_item = p_line_begin;
        while (p_item)
        {
            if (p_item == p_token_begin)
            {
                if (!visual_studio_ouput_format)
                {
                    printf("\x1b[92m");
                }
                onoff = 1;
                end_col = start_col;
            }
            if (!(p_item->flags & 2) || expand_macro)
            {
                char * p;

                p = p_item->lexeme;
                while (*p)
                {
                    if (onoff)
                    {
                        putc(126, (__acrt_iob_func(1)));
                        end_col++;
                    }
                    else
                    {
                        putc(32, (__acrt_iob_func(1)));
                        if (!complete)
                        {
                            start_col++;
                        }
                    }
                    p++;
                }
            }
            if (p_item->type == 10)
            {
                break;
            }
            if (p_item == p_token_end)
            {
                complete = 1;
                onoff = 0;
                if (!visual_studio_ouput_format)
                {
                    printf("\x1b[0m");
                }
            }
            p_item = p_item->next;
        }
        if (!visual_studio_ouput_format)
        {
            printf("\x1b[0m");
        }
        printf("\n");
        p_marker->start_col = start_col;
        p_marker->end_col = end_col;
    }
    else _CKL0: /*catch*/ 
    {
    }
}

void stream_match(struct stream * stream);

static void digit_sequence_opt(struct stream * stream)
{
    while (is_digit(stream))
    {
        stream_match(stream);
    }
}

static void binary_exponent_part(struct stream * stream)
{
    stream_match(stream);
    if (stream->current[0] == 43 || stream->current[0] == 45)
    {
        stream_match(stream);
    }
    digit_sequence_opt(stream);
}

static unsigned char  is_hexadecimal_digit(struct stream * stream)
{
    return !!((stream->current[0] >= 48 && stream->current[0] <= 57) || (stream->current[0] >= 97 && stream->current[0] <= 102) || (stream->current[0] >= 65 && stream->current[0] <= 70));
}

static unsigned char  is_octal_digit(struct stream * stream)
{
    return !!(stream->current[0] >= 48 && stream->current[0] <= 55);
}

static void hexadecimal_digit_sequence(struct stream * stream)
{
    stream_match(stream);
    while (stream->current[0] == 39 || is_hexadecimal_digit(stream))
    {
        if (stream->current[0] == 39)
        {
            stream_match(stream);
            if (!is_hexadecimal_digit(stream))
            {
            }
            stream_match(stream);
        }
        else
        {
            stream_match(stream);
        }
    }
}

static void integer_suffix_opt(struct stream * stream, char suffix[4])
{
    if (stream->current[0] == 85 || stream->current[0] == 117)
    {
        suffix[0] = 85;
        stream_match(stream);
        if (stream->current[0] == 108 || stream->current[0] == 76)
        {
            suffix[1] = 76;
            stream_match(stream);
        }
        if (stream->current[0] == 108 || stream->current[0] == 76)
        {
            suffix[2] = 76;
            stream_match(stream);
        }
    }
    else
    {
        if ((stream->current[0] == 108 || stream->current[0] == 76))
        {
            suffix[0] = 76;
            stream_match(stream);
            if ((stream->current[0] == 108 || stream->current[0] == 76))
            {
                suffix[1] = 76;
                stream_match(stream);
            }
            if (stream->current[0] == 85 || stream->current[0] == 117)
            {
                suffix[3] = suffix[2];
                suffix[2] = suffix[1];
                suffix[1] = suffix[0];
                suffix[0] = 85;
                stream_match(stream);
            }
        }
        else
        {
            if (stream->current[0] == 105 && stream->current[1] == 56)
            {
                stream_match(stream);
                stream_match(stream);
                stream_match(stream);
                suffix[0] = 105;
                suffix[1] = 56;
            }
            else
            {
                if (stream->current[0] == 105 && stream->current[1] == 51 && stream->current[2] == 50)
                {
                    stream_match(stream);
                    stream_match(stream);
                    stream_match(stream);
                    suffix[0] = 105;
                    suffix[1] = 51;
                    suffix[2] = 50;
                }
                else
                {
                    if (stream->current[0] == 105 && stream->current[1] == 54 && stream->current[2] == 52)
                    {
                        stream_match(stream);
                        stream_match(stream);
                        stream_match(stream);
                        suffix[0] = 105;
                        suffix[1] = 54;
                        suffix[2] = 52;
                    }
                }
            }
        }
    }
}

static void exponent_part_opt(struct stream * stream)
{
    if (stream->current[0] == 101 || stream->current[0] == 69)
    {
        stream_match(stream);
        if (stream->current[0] == 45 || stream->current[0] == 43)
        {
            stream_match(stream);
        }
        digit_sequence_opt(stream);
    }
}

static void floating_suffix_opt(struct stream * stream, char suffix[4])
{
    if (stream->current[0] == 108 || stream->current[0] == 76)
    {
        suffix[0] = 76;
        stream_match(stream);
    }
    else
    {
        if (stream->current[0] == 102 || stream->current[0] == 70)
        {
            suffix[0] = 70;
            stream_match(stream);
        }
    }
}

static unsigned char  is_binary_digit(struct stream * stream)
{
    return !!(stream->current[0] >= 48 && stream->current[0] <= 49);
}

static unsigned char  is_nonzero_digit(struct stream * stream)
{
    return !!(stream->current[0] >= 49 && stream->current[0] <= 57);
}

int parse_number_core(struct stream * stream, char suffix[4], char errmsg[100])
{
    int type;

    errmsg[0] = 0;
    type = 0;
    if (stream->current[0] == 46)
    {
        type = 140;
        stream_match(stream);
        if (stream->current[0] == 46)
        {
            snprintf(errmsg, 100, "too many decimal points in number");
            return 0;
        }
        digit_sequence_opt(stream);
        exponent_part_opt(stream);
        floating_suffix_opt(stream, suffix);
    }
    else
    {
        if (stream->current[0] == 48 && (stream->current[1] == 120 || stream->current[1] == 88))
        {
            type = 138;
            stream_match(stream);
            stream_match(stream);
            if (is_hexadecimal_digit(stream))
            {
                while (is_hexadecimal_digit(stream))
                {
                    stream_match(stream);
                }
            }
            else
            {
                snprintf(errmsg, 100, "expected hexadecimal digit");
                return 0;
            }
            integer_suffix_opt(stream, suffix);
            if (stream->current[0] == 46)
            {
                type = 141;
                hexadecimal_digit_sequence(stream);
            }
            if (stream->current[0] == 112 || stream->current[0] == 80)
            {
                type = 141;
                binary_exponent_part(stream);
            }
            if (type == 141)
            {
                floating_suffix_opt(stream, suffix);
            }
        }
        else
        {
            if (stream->current[0] == 48 && (stream->current[1] == 98 || stream->current[1] == 66))
            {
                type = 139;
                stream_match(stream);
                stream_match(stream);
                if (is_binary_digit(stream))
                {
                    while (is_binary_digit(stream))
                    {
                        stream_match(stream);
                    }
                }
                else
                {
                    snprintf(errmsg, 100, "expected binary digit");
                    return 0;
                }
                integer_suffix_opt(stream, suffix);
            }
            else
            {
                if (stream->current[0] == 48)
                {
                    type = 137;
                    stream_match(stream);
                    if (stream->current[0] == 79 || stream->current[0] == 111)
                    {
                        stream_match(stream);
                    }
                    while (is_octal_digit(stream))
                    {
                        stream_match(stream);
                    }
                    integer_suffix_opt(stream, suffix);
                    if (stream->current[0] == 46)
                    {
                        type = 140;
                        hexadecimal_digit_sequence(stream);
                        floating_suffix_opt(stream, suffix);
                    }
                }
                else
                {
                    if (is_nonzero_digit(stream))
                    {
                        type = 136;
                        stream_match(stream);
                        while (is_digit(stream))
                        {
                            stream_match(stream);
                        }
                        integer_suffix_opt(stream, suffix);
                        if (stream->current[0] == 101 || stream->current[0] == 69)
                        {
                            exponent_part_opt(stream);
                            floating_suffix_opt(stream, suffix);
                        }
                        else
                        {
                            if (stream->current[0] == 46)
                            {
                                stream_match(stream);
                                type = 140;
                                if (stream->current[0] == 46)
                                {
                                    snprintf(errmsg, 100, "too many decimal points in number");
                                    return 0;
                                }
                                digit_sequence_opt(stream);
                                exponent_part_opt(stream);
                                floating_suffix_opt(stream, suffix);
                            }
                        }
                    }
                }
            }
        }
    }
    return type;
}

int parse_number(char * lexeme, char suffix[4], char errmsg[100])
{
    struct stream  stream;

    stream.source = lexeme;
    stream.current = lexeme;
    stream.line = 1;
    stream.col = 1;
    stream.line_continuation_count = 0;
    stream.path = "";
    return parse_number_core(&stream, suffix, errmsg);
}

unsigned char *utf8_decode(unsigned char * s, unsigned int * c)
{
    unsigned char * next;

    *c = 0;
    if (s[0] == 0)
    {
        *c = 0;
        return 0U;
    }
    next = 0U;
    if (s[0] < 128)
    {
        *c = s[0];
        ;
        next = s + 1;
    }
    else
    {
        if ((s[0] & 224) == 192)
        {
            *c = ((int)(s[0] & 31) << 6) | ((int)(s[1] & 63) << 0);
            ;
            next = s + 2;
        }
        else
        {
            if ((s[0] & 240) == 224)
            {
                *c = ((int)(s[0] & 15) << 12) | ((int)(s[1] & 63) << 6) | ((int)(s[2] & 63) << 0);
                ;
                next = s + 3;
            }
            else
            {
                if ((s[0] & 248) == 240 && (s[0] <= 244))
                {
                    *c = ((int)(s[0] & 7) << 18) | ((int)(s[1] & 63) << 12) | ((int)(s[2] & 63) << 6) | ((int)(s[3] & 63) << 0);
                    ;
                    next = s + 4;
                }
                else
                {
                    *c = 0;
                    next = s + 1;
                }
            }
        }
    }
    if (*c >= 55296 && *c <= 57343)
    {
        *c = 0;
    }
    return next;
}

static unsigned char  is_hex_digit(unsigned char c)
{
    if (c >= 48 && c <= 57)
    {
        return 1;
    }
    else
    {
        if (c >= 97 && c <= 102)
        {
            return 1;
        }
        else
        {
            if (c >= 65 && c <= 70)
            {
                return 1;
            }
        }
    }
    return 0;
}

unsigned char *escape_sequences_decode_opt(unsigned char * p, unsigned int * out_value)
{
    if (*p == 120)
    {
        int result;

        p++;
        result = 0;
        while (is_hex_digit(*p))
        {
            int byte;

            byte = 0;
            if (*p >= 48 && *p <= 57)
            {
                byte = (*p - 48);
            }
            else
            {
                if (*p >= 97 && *p <= 102)
                {
                    byte = (*p - 97) + 10;
                }
                else
                {
                    if (*p >= 65 && *p <= 70)
                    {
                        byte = (*p - 65) + 10;
                    }
                }
            }
            result = (result << 4) | (byte & 15);
            p++;
        }
        *out_value = result;
    }
    else
    {
        if (*p == 117 || *p == 85)
        {
            int num_of_hex_digits;
            unsigned long long result;

            num_of_hex_digits = *p == 85 ? 8 : 4;
            p++;
            result = 0;
            {
                int i;
                i = 0;
                for (; i < num_of_hex_digits; i++)
                {
                    int byte;

                    byte = 0;
                    if (*p >= 48 && *p <= 57)
                    {
                        byte = (*p - 48);
                    }
                    else
                    {
                        if (*p >= 97 && *p <= 102)
                        {
                            byte = (*p - 97) + 10;
                        }
                        else
                        {
                            if (*p >= 65 && *p <= 70)
                            {
                                byte = (*p - 65) + 10;
                            }
                        }
                    }
                    result = (result << 4) | (byte & 15);
                    p++;
                }
            }
            *out_value = (int)result;
        }
        else
        {
            if (*p == 48)
            {
                int result;

                p++;
                result = 0;
                while ((*p >= 48 && *p <= 55))
                {
                    int byte;

                    byte = (*p - 48);
                    result = (result << 4) | (byte & 15);
                    p++;
                }
                *out_value = result;
            }
            else
            {
                /*switch*/
                {
                    register unsigned char _R2 = *p;
                    if (_R2 == 97) goto _CKL10; /*case 97*/
                    if (_R2 == 98) goto _CKL11; /*case 98*/
                    if (_R2 == 102) goto _CKL12; /*case 102*/
                    if (_R2 == 110) goto _CKL13; /*case 110*/
                    if (_R2 == 114) goto _CKL14; /*case 114*/
                    if (_R2 == 116) goto _CKL15; /*case 116*/
                    if (_R2 == 39) goto _CKL16; /*case 39*/
                    if (_R2 == 92) goto _CKL17; /*case 92*/
                    if (_R2 == 34) goto _CKL18; /*case 34*/
                    goto _CKL19;/*default*/

                    {
                        _CKL10:/*case 97*/ 
                        *out_value = 7;
                        goto _CKL9; /*break*/

                        _CKL11:/*case 98*/ 
                        *out_value = 8;
                        goto _CKL9; /*break*/

                        _CKL12:/*case 102*/ 
                        *out_value = 12;
                        goto _CKL9; /*break*/

                        _CKL13:/*case 110*/ 
                        *out_value = 10;
                        goto _CKL9; /*break*/

                        _CKL14:/*case 114*/ 
                        *out_value = 13;
                        goto _CKL9; /*break*/

                        ;
                        _CKL15:/*case 116*/ 
                        *out_value = 9;
                        goto _CKL9; /*break*/

                        _CKL16:/*case 39*/ 
                        *out_value = 39;
                        goto _CKL9; /*break*/

                        _CKL17:/*case 92*/ 
                        *out_value = 92;
                        goto _CKL9; /*break*/

                        _CKL18:/*case 34*/ 
                        *out_value = 34;
                        goto _CKL9; /*break*/

                        _CKL19: /*default*/ 
                        ;
                        return 0U;
                    }
                    _CKL9:;
                }
                p++;
            }
        }
    }
    return p;
}

unsigned int __cdecl strlen(char * _Str);

static unsigned int string_hash(char * key)
{
    unsigned int hash_val;
    unsigned int first;
    unsigned int last;
    unsigned int stride;

    hash_val = 2166136261U;
    first = 0;
    last = (unsigned int)strlen(key);
    stride = 1 + last / 10;
    for (; first < last; first += stride)
    {
        hash_val = 16777619U * hash_val ^ (unsigned int)key[first];
    }
    return (hash_val);
}

void enum_specifier_delete(struct enum_specifier * p);
void struct_or_union_specifier_delete(struct struct_or_union_specifier * p);
void enumerator_delete(struct enumerator * p);
void declarator_delete(struct declarator * p);
void init_declarator_delete(struct init_declarator * p);
void macro_delete(struct macro * p);
void struct_entry_delete(struct struct_entry * p);

void map_entry_delete(struct map_entry * p)
{
    if (p == 0U)
    {
        return;
    }
    /*switch*/
    {
        register int _R3 = p->type;
        if (_R3 == 0) goto _CKL2; /*case 0*/
        if (_R3 == 1) goto _CKL3; /*case 1*/
        if (_R3 == 2) goto _CKL4; /*case 2*/
        if (_R3 == 3) goto _CKL5; /*case 3*/
        if (_R3 == 4) goto _CKL6; /*case 4*/
        if (_R3 == 5) goto _CKL7; /*case 5*/
        if (_R3 == 6) goto _CKL8; /*case 6*/
        if (_R3 == 7) goto _CKL9; /*case 7*/
        goto _CKL1;

        {
            _CKL2:/*case 0*/ 
            goto _CKL1; /*break*/

            _CKL3:/*case 1*/ 
            enum_specifier_delete(p->data.p_enum_specifier);
            goto _CKL1; /*break*/

            _CKL4:/*case 2*/ 
            struct_or_union_specifier_delete(p->data.p_struct_or_union_specifier);
            goto _CKL1; /*break*/

            _CKL5:/*case 3*/ 
            enumerator_delete(p->data.p_enumerator);
            goto _CKL1; /*break*/

            _CKL6:/*case 4*/ 
            declarator_delete(p->data.p_declarator);
            goto _CKL1; /*break*/

            _CKL7:/*case 5*/ 
            init_declarator_delete(p->data.p_init_declarator);
            goto _CKL1; /*break*/

            _CKL8:/*case 6*/ 
            macro_delete(p->data.p_macro);
            goto _CKL1; /*break*/

            _CKL9:/*case 7*/ 
            struct_entry_delete(p->data.p_struct_entry);
            goto _CKL1; /*break*/

        }
        _CKL1:;
    }
    free(p->key);
    free(p);
}

void hashmap_remove_all(struct hash_map * map)
{
    if (map->table != 0U)
    {
        {
            int i;
            i = 0;
            for (; i < map->capacity; i++)
            {
                struct map_entry * pentry;

                pentry = map->table[i];
                while (pentry != 0U)
                {
                    struct map_entry * next;

                    next = pentry->next;
                    map_entry_delete(pentry);
                    pentry = next;
                }
            }
        }
        free(map->table);
        map->table = 0U;
        map->size = 0;
    }
}

void hashmap_destroy(struct hash_map * map)
{
    hashmap_remove_all(map);
    ;
}

struct map_entry *hashmap_find(struct hash_map * map, char * key)
{
    unsigned int hash;
    int index;
    struct map_entry * pentry;

    if (map->table == 0U)
    {
        return 0U;
    }
    hash = string_hash(key);
    index = hash % map->capacity;
    pentry = map->table[index];
    for (; pentry != 0U; pentry = pentry->next)
    {
        if (pentry->hash == hash && strcmp(pentry->key, key) == 0)
        {
            return pentry;
        }
    }
    return 0U;
}

void *hashmap_remove(struct hash_map * map, char * key, int * p_type_opt)
{
    if (map->table != 0U)
    {
        unsigned int hash;
        struct map_entry ** pp_entry;
        struct map_entry * p_entry;

        hash = string_hash(key);
        pp_entry = &map->table[hash % map->capacity];
        p_entry = *pp_entry;
        for (; p_entry != 0U; p_entry = p_entry->next)
        {
            if ((p_entry->hash == hash) && (strcmp(p_entry->key, key) == 0))
            {
                void * p;

                *pp_entry = p_entry->next;
                if (p_type_opt)
                {
                    *p_type_opt = p_entry->type;
                }
                p = p_entry->data.p_declarator;
                free((void *)p_entry->key);
                free((void *)p_entry);
                return p;
            }
            pp_entry = &p_entry->next;
        }
    }
    return 0U;
}

void hash_item_set_destroy(struct hash_item_set * p)
{
    declarator_delete(p->p_declarator);
    enumerator_delete(p->p_enumerator);
    enum_specifier_delete(p->p_enum_specifier);
    init_declarator_delete(p->p_init_declarator);
    struct_or_union_specifier_delete(p->p_struct_or_union_specifier);
    macro_delete(p->p_macro);
}

int hashmap_set(struct hash_map * map, char * key, struct hash_item_set * item)
{
    int result;
    void * p;
    int type;

    result = 0;
    p = 0U;
    type = 0;
    if (item->p_declarator)
    {
        type = 4;
        p = item->p_declarator;
        item->p_declarator = 0U;
    }
    else
    {
        if (item->p_enumerator)
        {
            type = 3;
            p = item->p_enumerator;
            item->p_enumerator = 0U;
        }
        else
        {
            if (item->p_enum_specifier)
            {
                type = 1;
                p = item->p_enum_specifier;
                item->p_enum_specifier = 0U;
            }
            else
            {
                if (item->p_init_declarator)
                {
                    type = 5;
                    p = item->p_init_declarator;
                    item->p_init_declarator = 0U;
                }
                else
                {
                    if (item->p_struct_or_union_specifier)
                    {
                        type = 2;
                        p = item->p_struct_or_union_specifier;
                        item->p_struct_or_union_specifier = 0U;
                    }
                    else
                    {
                        if (item->p_macro)
                        {
                            type = 6;
                            p = item->p_macro;
                            item->p_macro = 0U;
                        }
                        else
                        {
                            if (item->p_struct_entry)
                            {
                                type = 7;
                                p = item->p_struct_entry;
                                item->p_struct_entry = 0U;
                            }
                            else
                            {
                                type = 0;
                                p = (void *)item->number;
                            }
                        }
                    }
                }
            }
        }
    }
    if (1) /*try*/
    {
        if (map->table == 0U)
        {
            if (map->capacity < 1)
            {
                map->capacity = 1000;
            }
            map->table = calloc(map->capacity, 4U);
            if (map->table == 0U)
            {
                goto _CKL7;/*throw*/
            }
        }
        if (map->table != 0U)
        {
            unsigned int hash;
            int index;
            struct map_entry * pentry;

            hash = string_hash(key);
            index = hash % map->capacity;
            pentry = map->table[index];
            for (; pentry != 0U; pentry = pentry->next)
            {
                if (pentry->hash == hash && strcmp(pentry->key, key) == 0)
                {
                    break;
                }
            }
            if (pentry == 0U)
            {
                struct map_entry * p_new_entry;
                char * temp_key;

                p_new_entry = calloc(1, 20U);
                if (p_new_entry == 0U)
                {
                    goto _CKL7;/*throw*/
                }
                p_new_entry->hash = hash;
                p_new_entry->data.p_declarator = (void *)p;
                p_new_entry->type = type;
                temp_key = strdup(key);
                if (temp_key == 0U)
                {
                    map_entry_delete(p_new_entry);
                    goto _CKL7;/*throw*/
                }
                p_new_entry->key = temp_key;
                p_new_entry->next = map->table[index];
                map->table[index] = p_new_entry;
                map->size++;
                result = 0;
            }
            else
            {
                /*switch*/
                {
                    register int _R4 = pentry->type;
                    if (_R4 == 0) goto _CKL17; /*case 0*/
                    if (_R4 == 1) goto _CKL18; /*case 1*/
                    if (_R4 == 2) goto _CKL19; /*case 2*/
                    if (_R4 == 3) goto _CKL20; /*case 3*/
                    if (_R4 == 4) goto _CKL21; /*case 4*/
                    if (_R4 == 5) goto _CKL22; /*case 5*/
                    if (_R4 == 6) goto _CKL23; /*case 6*/
                    if (_R4 == 7) goto _CKL24; /*case 7*/
                    goto _CKL16;

                    {
                        _CKL17:/*case 0*/ 
                        goto _CKL16; /*break*/

                        _CKL18:/*case 1*/ 
                        ;
                        item->p_enum_specifier = pentry->data.p_enum_specifier;
                        goto _CKL16; /*break*/

                        _CKL19:/*case 2*/ 
                        ;
                        item->p_struct_or_union_specifier = pentry->data.p_struct_or_union_specifier;
                        goto _CKL16; /*break*/

                        _CKL20:/*case 3*/ 
                        ;
                        item->p_enumerator = pentry->data.p_enumerator;
                        goto _CKL16; /*break*/

                        _CKL21:/*case 4*/ 
                        ;
                        item->p_declarator = pentry->data.p_declarator;
                        goto _CKL16; /*break*/

                        _CKL22:/*case 5*/ 
                        ;
                        item->p_init_declarator = pentry->data.p_init_declarator;
                        goto _CKL16; /*break*/

                        _CKL23:/*case 6*/ 
                        ;
                        item->p_macro = pentry->data.p_macro;
                        goto _CKL16; /*break*/

                        _CKL24:/*case 7*/ 
                        ;
                        item->p_struct_entry = pentry->data.p_struct_entry;
                        goto _CKL16; /*break*/

                    }
                    _CKL16:;
                }
                result = 1;
                pentry->data.p_declarator = (void *)p;
                pentry->type = type;
            }
        }
    }
    else _CKL7: /*catch*/ 
    {
    }
    return result;
}

void *__stdcall GetStdHandle(unsigned long nStdHandle);
int __stdcall GetConsoleMode(void * hConsoleHandle, unsigned long * lpMode);
int __stdcall SetConsoleMode(void * hConsoleHandle, unsigned long dwMode);
int __stdcall SetConsoleOutputCP(unsigned int wCodePageID);

unsigned char  enable_vt_mode(void)
{
    unsigned long mode;
    void * h_out;

    mode = 0;
    h_out = GetStdHandle(4294967285UL);
    if (h_out != 4294967295U && GetConsoleMode(h_out, &mode) != 0 && SetConsoleMode(h_out, mode |= 4) != 0 && SetConsoleOutputCP(65001) != 0)
    {
        return 1;
    }
    return 0;
}

int __cdecl _kbhit(void);

int c_kbhit(void)
{
    return _kbhit();
}

int __cdecl _getch(void);

int c_getch(void)
{
    return _getch();
}

int __cdecl puts(char * _Buffer);
int __cdecl fflush(struct _iobuf * _Stream);

void c_clrscr()
{
    puts("\x1b[2J\x1b[1;1H");
    puts("\x1b[3J");
    fflush((__acrt_iob_func(1)));
}

void c_gotoxy(int x, int y)
{
    printf("\x1b[%d;%dH", y, x);
    fflush((__acrt_iob_func(1)));
}

void include_dir_list_destroy(struct include_dir_list * list)
{
    struct include_dir * p;

    p = list->head;
    while (p)
    {
        struct include_dir * next;

        next = p->next;
        free((void *)p->path);
        free(p);
        p = next;
    }
}

void preprocessor_ctx_destroy(struct preprocessor_ctx * p)
{
    hashmap_destroy(&p->macros);
    include_dir_list_destroy(&p->include_dir);
    hashmap_destroy(&p->pragma_once_map);
    token_list_destroy(&p->input_list);
}


int __cdecl __stdio_common_vsprintf(unsigned __int64 _Options, char * _Buffer, unsigned int _BufferCount, char * _Format, struct __crt_locale_pointers * _Locale, char * _ArgList);
inline int __cdecl vsnprintf(char * _Buffer, unsigned int _BufferCount, char * _Format, char * _ArgList)
{
    int _Result;

    _Result = __stdio_common_vsprintf((*__local_stdio_printf_options()) | 2ULL, _Buffer, _BufferCount, _Format, 0U, _ArgList);
    return _Result < 0 ? -1 : _Result;
}

static void tokenizer_set_error(struct tokenizer_ctx * ctx, struct stream * stream, char * fmt, ...)
{
    char buffer[200];
    char * args;

    ctx->n_errors++;
    _cake_zmem(&buffer, 200);
    _cake_zmem(&args, 4);
    ((void)(args = (char *)(&(fmt)) + 4U));
    vsnprintf(buffer, 200U, fmt, args);
    ((void)(args = 0U));
    print_position(stream->path, stream->line, stream->col, ctx->options.visual_studio_ouput_format);
    if (ctx->options.visual_studio_ouput_format)
    {
        printf("error: ""%s\n", buffer);
    }
    else
    {
        printf("\x1b[91m""error: ""\x1b[97m""%s\n", buffer);
    }
}

static void tokenizer_set_warning(struct tokenizer_ctx * ctx, struct stream * stream, char * fmt, ...)
{
    char buffer[200];
    char * args;

    ctx->n_warnings++;
    _cake_zmem(&buffer, 200);
    _cake_zmem(&args, 4);
    ((void)(args = (char *)(&(fmt)) + 4U));
    vsnprintf(buffer, 200U, fmt, args);
    ((void)(args = 0U));
    print_position(stream->path, stream->line, stream->col, ctx->options.visual_studio_ouput_format);
    if (ctx->options.visual_studio_ouput_format)
    {
        printf("warning: ""%s\n", buffer);
    }
    else
    {
        printf("\x1b[95m""warning: ""\x1b[97m""%s\n", buffer);
    }
}

unsigned char  preprocessor_diagnostic(int w, struct preprocessor_ctx * ctx, struct token * p_token, char * fmt, ...);

void pre_unexpected_end_of_file(struct token * p_token, struct preprocessor_ctx * ctx)
{
    preprocessor_diagnostic(970, ctx, p_token, "unexpected end of file");
}

unsigned char  preprocessor_diagnostic(int w, struct preprocessor_ctx * ctx, struct token * p_token_opt, char * fmt, ...)
{
    struct marker  marker;
    unsigned char   included_file_location;
    unsigned char   is_error;
    unsigned char   is_warning;
    unsigned char   is_note;
    char buffer[200];
    char * args;

    _cake_zmem(&marker, 28);
    if (p_token_opt == 0U)
    {
        return 0;
    }
    marker.file = p_token_opt->token_origin->lexeme;
    marker.line = p_token_opt->line;
    marker.start_col = p_token_opt->col;
    marker.end_col = p_token_opt->col;
    marker.p_token_caret = p_token_opt;
    included_file_location = !!(p_token_opt->level > 0);
    is_error = 0;
    is_warning = 0;
    is_note = 0;
    if (w > 63)
    {
        is_error = 1;
    }
    else
    {
        is_error = !!((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].errors & (1ULL << w)) != 0);
        is_warning = !!((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings & (1ULL << w)) != 0);
        is_note = !!(((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].notes & (1ULL << w)) != 0));
    }
    if (is_error)
    {
        ctx->n_errors++;
    }
    else
    {
        if (is_warning)
        {
            ctx->n_warnings++;
        }
        else
        {
            if (is_note)
            {
            }
            else
            {
                return 0;
            }
        }
    }
    if (!is_error && included_file_location)
    {
        return 0;
    }
    print_position(marker.file, marker.line, marker.start_col, ctx->options.visual_studio_ouput_format);
    _cake_zmem(&buffer, 200);
    _cake_zmem(&args, 4);
    ((void)(args = (char *)(&(fmt)) + 4U));
    vsnprintf(buffer, 200U, fmt, args);
    ((void)(args = 0U));
    if (ctx->options.visual_studio_ouput_format)
    {
        if (is_warning)
        {
            printf("warning: ""%s\n", buffer);
        }
        else
        {
            if (is_error)
            {
                printf("warning: ""%s\n", buffer);
            }
            else
            {
                if (is_note)
                {
                    printf("note: ""%s\n", buffer);
                }
            }
        }
        print_line_and_token(&marker, ctx->options.visual_studio_ouput_format);
    }
    else
    {
        if (is_error)
        {
            printf("\x1b[91m""error: ""\x1b[97m""%s\n", buffer);
        }
        else
        {
            if (is_warning)
            {
                printf("\x1b[95m""warning: ""\x1b[97m""%s\n", buffer);
            }
            else
            {
                if (is_note)
                {
                    printf("\x1b[36;1m""note: ""\x1b[97m""%s\n", buffer);
                }
            }
        }
        print_line_and_token(&marker, ctx->options.visual_studio_ouput_format);
    }
    return 1;
}

struct include_dir *include_dir_add(struct include_dir_list * list, char * path)
{
    if (1) /*try*/
    {
        struct include_dir * p_new_include_dir;
        int len;

        p_new_include_dir = calloc(1, 8U);
        if (p_new_include_dir == 0U)
        {
            goto _CKL0;/*throw*/
        }
        len = strlen(path);
        if (path[len - 1] == 92)
        {
            char * temp;

            temp = strdup(path);
            if (temp == 0U)
            {
                free(p_new_include_dir);
                goto _CKL0;/*throw*/
            }
            p_new_include_dir->path = temp;
        }
        else
        {
            if (path[len - 1] != 47)
            {
                char * temp;

                temp = calloc(len + 2, 1U);
                if (temp == 0U)
                {
                    free(p_new_include_dir);
                    goto _CKL0;/*throw*/
                }
                p_new_include_dir->path = temp;
                snprintf((char *)p_new_include_dir->path, len + 2, "%s/", path);
            }
            else
            {
                char * temp;

                temp = strdup(path);
                if (temp == 0U)
                {
                    free(p_new_include_dir);
                    goto _CKL0;/*throw*/
                }
                p_new_include_dir->path = temp;
            }
        }
        if (list->head == 0U)
        {
            list->head = p_new_include_dir;
            list->tail = p_new_include_dir;
        }
        else
        {
            ;
            ;
            list->tail->next = p_new_include_dir;
            list->tail = p_new_include_dir;
        }
        return list->tail;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return 0U;
}

static void pragma_once_add(struct preprocessor_ctx * ctx, char * path)
{
    struct hash_item_set  item;

    _cake_zmem(&item, 32);
    item.number = 1;
    hashmap_set(&ctx->pragma_once_map, path, &item);
    hash_item_set_destroy(&item);
}

static unsigned char  pragma_once_already_included(struct preprocessor_ctx * ctx, char * path)
{
    return !!(hashmap_find(&ctx->pragma_once_map, path) != 0U);
}

unsigned char  path_is_absolute(char * path);
void path_normalize(char * path);
char *read_file(char * path, unsigned char   append_newline);
char *realpath(char * path, char * resolved_path);

char *find_and_read_include_file(struct preprocessor_ctx * ctx, char * path, char * current_file_dir, unsigned char   is_angle_bracket_form, unsigned char  * p_already_included, char full_path_out[], int full_path_out_size, unsigned char   include_next)
{
    char newpath[200];
    char * content;
    struct include_dir * current;

    _cake_zmem(&newpath, 200);
    full_path_out[0] = 0;
    if (path_is_absolute(path))
    {
        char * content;

        snprintf(newpath, 200U, "%s", path);
        path_normalize(newpath);
        if (pragma_once_already_included(ctx, newpath))
        {
            *p_already_included = 1;
            return 0U;
        }
        content = read_file(newpath, 1);
        if (content != 0U)
        {
            snprintf(full_path_out, full_path_out_size, "%s", path);
            return content;
        }
        return 0U;
    }
    content = 0U;
    if (!is_angle_bracket_form)
    {
        snprintf(newpath, 200U, "%s/%s", current_file_dir, path);
        if (!realpath(newpath, full_path_out))
        {
            full_path_out[0] = 0;
        }
        path_normalize(full_path_out);
        if (pragma_once_already_included(ctx, full_path_out))
        {
            *p_already_included = 1;
            return 0U;
        }
        if (full_path_out[0] != 0)
        {
            content = read_file(full_path_out, 1);
        }
        if (content != 0U)
        {
            return content;
        }
    }
    current = ctx->include_dir.head;
    while (current)
    {
        int len;

        len = strlen(current->path);
        if (current->path[len - 1] == 47)
        {
            snprintf(full_path_out, full_path_out_size, "%s%s", current->path, path);
        }
        else
        {
            snprintf(full_path_out, full_path_out_size, "%s/%s", current->path, path);
        }
        path_normalize(full_path_out);
        if (pragma_once_already_included(ctx, full_path_out))
        {
            *p_already_included = 1;
            return 0U;
        }
        content = read_file(full_path_out, 1);
        if (content != 0U)
        {
            if (include_next)
            {
                free(content);
                content = 0U;
                include_next = 0;
            }
            else
            {
                return content;
            }
        }
        current = current->next;
    }
    full_path_out[0] = 0;
    return 0U;
}

void add_macro(struct preprocessor_ctx * ctx, char * name)
{
    if (1) /*try*/
    {
        char * name_local;
        struct macro * macro;
        struct hash_item_set  item;

        name_local = strdup(name);
        if (name_local == 0U)
        {
            goto _CKL0;/*throw*/
        }
        macro = calloc(1, 32U);
        if (macro == 0U)
        {
            free(name_local);
            goto _CKL0;/*throw*/
        }
        macro->name = name_local;
        item.number = 0;
        item.p_enum_specifier = 0;
        item.p_enumerator = 0;
        item.p_struct_or_union_specifier = 0;
        item.p_declarator = 0;
        item.p_init_declarator = 0;
        item.p_macro = macro;
        item.p_struct_entry = 0;
        hashmap_set(&ctx->macros, name, &item);
        hash_item_set_destroy(&item);
    }
    else _CKL0: /*catch*/ 
    {
    }
}

void remove_line_continuation(char * s);

struct token_list copy_argument_list_tokens(struct token_list * list)
{
    struct token_list  r;
    struct token * current;
    unsigned char   is_first;

    _cake_zmem(&r, 8);
    current = list->head;
    while (current && (token_is_blank(current) || current->type == 10))
    {
        current = current->next;
    }
    is_first = 1;
    for (; current; )
    {
        struct token * token;

        if (current && (token_is_blank(current) || current->type == 10))
        {
            if (current == list->tail)
            {
                break;
            }
            current = current->next;
            continue;
        }
        token = token_list_clone_and_add(&r, current);
        if (token->flags & 8)
        {
            token->flags = token->flags & -9;
            token->flags |= 4;
        }
        if (is_first)
        {
            token->flags = token->flags & -5;
            token->flags = token->flags & -9;
            is_first = 0;
        }
        remove_line_continuation(token->lexeme);
        if (current == list->tail)
        {
            break;
        }
        current = current->next;
    }
    return r;
}

void macro_argument_delete(struct macro_argument * p)
{
    if (p)
    {
        ;
        token_list_destroy(&p->tokens);
        free(p);
    }
}

struct token_list copy_argument_list(struct macro_argument * p_macro_argument)
{
    struct token_list  empty;

    if (1) /*try*/
    {
        struct token_list  list;

        list = copy_argument_list_tokens(&p_macro_argument->tokens);
        if (list.head == 0U)
        {
            struct token * p_new_token;
            char * temp;

            p_new_token = calloc(1, 40U);
            if (p_new_token == 0U)
            {
                goto _CKL0;/*throw*/
            }
            temp = strdup("");
            if (temp == 0U)
            {
                token_delete(p_new_token);
                goto _CKL0;/*throw*/
            }
            p_new_token->lexeme = temp;
            p_new_token->type = 142;
            token_list_add(&list, p_new_token);
        }
        return list;
    }
    else _CKL0: /*catch*/ 
    {
    }
    _cake_zmem(&empty, 8);
    return empty;
}

void macro_argument_list_destroy(struct macro_argument_list * list)
{
    struct macro_argument * p;

    token_list_destroy(&list->tokens);
    p = list->head;
    while (p)
    {
        struct macro_argument * next;

        next = p->next;
        p->next = 0U;
        macro_argument_delete(p);
        p = next;
    }
}

void print_macro_arguments(struct macro_argument_list * arguments)
{
    struct macro_argument * p_argument;

    p_argument = arguments->head;
    while (p_argument)
    {
        if (p_argument->macro_parameter)
        {
            printf("%s:", p_argument->macro_parameter->name);
        }
        print_list(&p_argument->tokens);
        p_argument = p_argument->next;
    }
}

struct macro_argument *find_macro_argument_by_name(struct macro_argument_list * parameters, char * name)
{
    struct macro_argument * p_macro_argument;

    p_macro_argument = parameters->head;
    while (p_macro_argument)
    {
        if (strcmp(p_macro_argument->macro_parameter->name, name) == 0)
        {
            return p_macro_argument;
        }
        p_macro_argument = p_macro_argument->next;
    }
    return 0U;
}

void argument_list_add(struct macro_argument_list * list, struct macro_argument * pnew)
{
    ;
    if (list->head == 0U)
    {
        list->head = pnew;
        ;
        list->tail = pnew;
    }
    else
    {
        ;
        ;
        list->tail->next = pnew;
        list->tail = pnew;
    }
}

void print_macro(struct macro * macro)
{
    struct macro_parameter * parameter;

    printf("%s", macro->name);
    if (macro->is_function)
    {
        printf("(");
    }
    parameter = macro->parameters;
    while (parameter)
    {
        if (macro->parameters != parameter)
        {
            printf(",");
        }
        printf("%s", parameter->name);
        parameter = parameter->next;
    }
    if (macro->is_function)
    {
        printf(") ");
    }
    print_list(&macro->replacement_list);
}

void macro_parameters_delete(struct macro_parameter * parameters)
{
    struct macro_parameter * p;

    p = parameters;
    while (p)
    {
        struct macro_parameter * p_next;

        p_next = p->next;
        free((void *)p->name);
        free(p);
        p = p_next;
    }
}

unsigned char  macro_is_same(struct macro * macro_a, struct macro * macro_b)
{
    struct macro_parameter * p_a;
    struct macro_parameter * p_b;

    if (macro_a->is_function != macro_b->is_function)
    {
        return 0;
    }
    if (strcmp(macro_a->name, macro_b->name) != 0)
    {
        return 0;
    }
    if (!token_list_is_equal(&macro_a->replacement_list, &macro_b->replacement_list) != 0)
    {
        return 0;
    }
    p_a = macro_a->parameters;
    p_b = macro_b->parameters;
    while (p_a && p_b)
    {
        if (strcmp(p_a->name, p_b->name) != 0)
        {
            return 0;
        }
        p_a = p_a->next;
        p_b = p_b->next;
    }
    return !!(p_a == 0U && p_b == 0U);
}

void macro_delete(struct macro * macro)
{
    if (macro)
    {
        struct macro_parameter * p_macro_parameter;

        token_list_destroy(&macro->replacement_list);
        p_macro_parameter = macro->parameters;
        while (p_macro_parameter)
        {
            struct macro_parameter * p_next;

            p_next = p_macro_parameter->next;
            free((void *)p_macro_parameter->name);
            token_list_destroy(&p_macro_parameter->expanded_list);
            free(p_macro_parameter);
            p_macro_parameter = p_next;
        }
        free((void *)macro->name);
        free(macro);
    }
}

struct macro *find_macro(struct preprocessor_ctx * ctx, char * name)
{
    struct map_entry * p_entry;

    p_entry = hashmap_find(&ctx->macros, name);
    if (p_entry == 0U)
    {
        return 0U;
    }
    return p_entry->data.p_macro;
}

void stream_print_line(struct stream * stream)
{
    char * p;

    p = stream->current;
    while ((p - 1) >= stream->source && *(p - 1) != 10)
    {
        p--;
    }
    while (*p && *(p + 1) != 10)
    {
        printf("%c", *p);
        p++;
    }
    printf("\n");
    {
        int i;
        i = 0;
        for (; i < stream->col - 1; i++)
        printf(" ");
    }
    printf("^\n");
}

void stream_match(struct stream * stream)
{
    if (stream->current[0] == 10)
    {
        stream->line++;
        stream->col = 1;
    }
    else
    {
        stream->col++;
    }
    if (stream->current[0] == 0)
    {
        return;
    }
    stream->current++;
    while (stream->current[0] == 92 && (stream->current[1] == 10 || (stream->current[1] == 13 && stream->current[2] == 10)))
    {
        if (stream->current[1] == 13 && stream->current[2] == 10)
        {
            stream->current++;
            stream->current++;
            stream->current++;
        }
        else
        {
            stream->current++;
            stream->current++;
        }
        stream->line++;
        stream->col = 1;
        stream->line_continuation_count++;
    }
}

void print_line(struct token * p)
{
    struct token * prev;
    struct token * next;

    printf("%s\n", p->token_origin->lexeme);
    prev = p;
    while (prev->prev && prev->prev->type != 10)
    {
        prev = prev->prev;
    }
    next = prev;
    while (next && next->type != 10)
    {
        printf("%s", next->lexeme);
        next = next->next;
    }
    printf("\n");
}

int is_nondigit(struct stream * p)
{
    return (p->current[0] >= 97 && p->current[0] <= 122) || (p->current[0] >= 65 && p->current[0] <= 90) || (p->current[0] == 95);
}

int is_punctuator(struct stream * stream)
{
    int type;

    type = 0;
    /*switch*/
    {
        register char _R5 = stream->current[0];
        if (_R5 == 91) goto _CKL1; /*case 91*/
        if (_R5 == 93) goto _CKL2; /*case 93*/
        if (_R5 == 40) goto _CKL3; /*case 40*/
        if (_R5 == 41) goto _CKL4; /*case 41*/
        if (_R5 == 123) goto _CKL5; /*case 123*/
        if (_R5 == 125) goto _CKL6; /*case 125*/
        if (_R5 == 59) goto _CKL7; /*case 59*/
        if (_R5 == 44) goto _CKL8; /*case 44*/
        if (_R5 == 33) goto _CKL9; /*case 33*/
        if (_R5 == 58) goto _CKL11; /*case 58*/
        if (_R5 == 126) goto _CKL13; /*case 126*/
        if (_R5 == 63) goto _CKL14; /*case 63*/
        if (_R5 == 47) goto _CKL15; /*case 47*/
        if (_R5 == 42) goto _CKL17; /*case 42*/
        if (_R5 == 37) goto _CKL19; /*case 37*/
        if (_R5 == 45) goto _CKL21; /*case 45*/
        if (_R5 == 124) goto _CKL25; /*case 124*/
        if (_R5 == 43) goto _CKL28; /*case 43*/
        if (_R5 == 61) goto _CKL31; /*case 61*/
        if (_R5 == 94) goto _CKL33; /*case 94*/
        if (_R5 == 38) goto _CKL35; /*case 38*/
        if (_R5 == 62) goto _CKL38; /*case 62*/
        if (_R5 == 60) goto _CKL42; /*case 60*/
        if (_R5 == 35) goto _CKL46; /*case 35*/
        if (_R5 == 46) goto _CKL48; /*case 46*/
        goto _CKL0;

        {
            _CKL1:/*case 91*/ 
            type = 91;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL2:/*case 93*/ 
            type = 93;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL3:/*case 40*/ 
            type = 40;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL4:/*case 41*/ 
            type = 41;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL5:/*case 123*/ 
            type = 123;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL6:/*case 125*/ 
            type = 125;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL7:/*case 59*/ 
            type = 59;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL8:/*case 44*/ 
            type = 44;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL9:/*case 33*/ 
            type = 33;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 8509;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL11:/*case 58*/ 
            type = 58;
            stream_match(stream);
            if (stream->current[0] == 58)
            {
                type = 14906;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL13:/*case 126*/ 
            type = 126;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL14:/*case 63*/ 
            type = 63;
            stream_match(stream);
            goto _CKL0; /*break*/

            _CKL15:/*case 47*/ 
            type = 47;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 12093;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL17:/*case 42*/ 
            type = 42;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 10813;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL19:/*case 37*/ 
            type = 37;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 9533;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL21:/*case 45*/ 
            type = 45;
            stream_match(stream);
            if (stream->current[0] == 62)
            {
                type = 11582;
                stream_match(stream);
            }
            else
            {
                if (stream->current[0] == 45)
                {
                    type = 11565;
                    stream_match(stream);
                }
                else
                {
                    if (stream->current[0] == 61)
                    {
                        type = 11581;
                        stream_match(stream);
                    }
                }
            }
            goto _CKL0; /*break*/

            _CKL25:/*case 124*/ 
            type = 124;
            stream_match(stream);
            if (stream->current[0] == 124)
            {
                type = 31868;
                stream_match(stream);
            }
            else
            {
                if (stream->current[0] == 61)
                {
                    type = 31805;
                    stream_match(stream);
                }
            }
            goto _CKL0; /*break*/

            _CKL28:/*case 43*/ 
            type = 43;
            stream_match(stream);
            if (stream->current[0] == 43)
            {
                type = 11051;
                stream_match(stream);
            }
            else
            {
                if (stream->current[0] == 61)
                {
                    type = 11069;
                    stream_match(stream);
                }
            }
            goto _CKL0; /*break*/

            _CKL31:/*case 61*/ 
            type = 61;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 15677;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL33:/*case 94*/ 
            type = 94;
            stream_match(stream);
            if (stream->current[0] == 61)
            {
                type = 24125;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL35:/*case 38*/ 
            type = 38;
            stream_match(stream);
            if (stream->current[0] == 38)
            {
                type = 9766;
                stream_match(stream);
            }
            else
            {
                if (stream->current[0] == 61)
                {
                    type = 9789;
                    stream_match(stream);
                }
            }
            goto _CKL0; /*break*/

            _CKL38:/*case 62*/ 
            type = 62;
            stream_match(stream);
            if (stream->current[0] == 62)
            {
                type = 15934;
                stream_match(stream);
                if (stream->current[0] == 61)
                {
                    type = 4079165;
                    stream_match(stream);
                }
            }
            else
            {
                if (stream->current[0] == 61)
                {
                    type = 15933;
                    stream_match(stream);
                }
            }
            goto _CKL0; /*break*/

            _CKL42:/*case 60*/ 
            type = 60;
            stream_match(stream);
            if (stream->current[0] == 60)
            {
                type = 15420;
                stream_match(stream);
                if (stream->current[0] == 61)
                {
                    type = 3947581;
                    stream_match(stream);
                }
            }
            else
            {
                if (stream->current[0] == 61)
                {
                    type = 15421;
                    stream_match(stream);
                }
            }
            goto _CKL0; /*break*/

            _CKL46:/*case 35*/ 
            type = 35;
            stream_match(stream);
            if (stream->current[0] == 35)
            {
                type = 8995;
                stream_match(stream);
            }
            goto _CKL0; /*break*/

            _CKL48:/*case 46*/ 
            type = 46;
            stream_match(stream);
            if (stream->current[0] == 46 && stream->current[1] == 46)
            {
                type = 3026478;
                stream_match(stream);
                stream_match(stream);
            }
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return type;
}

char *__cdecl strncpy(char * _Destination, char * _Source, unsigned int _Count);

struct token *new_token(char * lexeme_head, char * lexeme_tail, int type)
{
    struct token * p_new_token;

    p_new_token = 0U;
    if (1) /*try*/
    {
        unsigned int sz;
        char * temp;

        p_new_token = calloc(1, 40U);
        if (p_new_token == 0U)
        {
            goto _CKL0;/*throw*/
        }
        sz = lexeme_tail - lexeme_head;
        temp = calloc(sz + 1, 1U);
        if (temp == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_new_token->lexeme = temp;
        p_new_token->type = type;
        strncpy(p_new_token->lexeme, lexeme_head, sz);
    }
    else _CKL0: /*catch*/ 
    {
        token_delete(p_new_token);
        p_new_token = 0U;
    }
    return p_new_token;
}

struct token *identifier(struct stream * stream)
{
    char * start;
    struct token * p_new_token;

    start = stream->current;
    stream_match(stream);
    while (is_nondigit(stream) || is_digit(stream))
    {
        stream_match(stream);
    }
    p_new_token = new_token(start, stream->current, 8996);
    return p_new_token;
}

static unsigned char  first_of_character_constant(struct stream * stream)
{
    return !!(stream->current[0] == 39 || (stream->current[0] == 117 && stream->current[1] == 56 && stream->current[2] == 39) || (stream->current[0] == 117 && stream->current[1] == 39) || (stream->current[0] == 85 && stream->current[1] == 39) || (stream->current[0] == 76 && stream->current[1] == 39));
}

struct token *character_constant(struct tokenizer_ctx * ctx, struct stream * stream)
{
    char * start;
    struct token * p_new_token;

    start = stream->current;
    if (stream->current[0] == 117)
    {
        stream_match(stream);
        if (stream->current[0] == 56)
        {
            stream_match(stream);
        }
    }
    else
    {
        if (stream->current[0] == 85 || stream->current[0] == 76)
        {
            stream_match(stream);
        }
    }
    stream_match(stream);
    while (stream->current[0] != 39)
    {
        if (stream->current[0] == 92)
        {
            stream_match(stream);
            stream_match(stream);
        }
        else
        {
            stream_match(stream);
        }
        if (stream->current[0] == 0 || stream->current[0] == 10)
        {
            tokenizer_set_warning(ctx, stream, "missing terminating ' character");
            break;
        }
    }
    stream_match(stream);
    p_new_token = new_token(start, stream->current, 131);
    return p_new_token;
}

static unsigned char  first_of_string_literal(struct stream * stream)
{
    return !!(stream->current[0] == 34 || (stream->current[0] == 117 && stream->current[1] == 56 && stream->current[2] == 34) || (stream->current[0] == 117 && stream->current[1] == 34) || (stream->current[0] == 85 && stream->current[1] == 34) || (stream->current[0] == 76 && stream->current[1] == 34));
}

struct token *string_literal(struct tokenizer_ctx * ctx, struct stream * stream)
{
    struct token * p_new_token;
    char * start;

    p_new_token = 0U;
    start = stream->current;
    if (1) /*try*/
    {
        if (stream->current[0] == 117)
        {
            stream_match(stream);
            if (stream->current[0] == 56)
            {
                stream_match(stream);
            }
        }
        else
        {
            if (stream->current[0] == 85 || stream->current[0] == 76)
            {
                stream_match(stream);
            }
        }
        stream_match(stream);
        while (stream->current[0] != 34)
        {
            if (stream->current[0] == 0 || stream->current[0] == 10)
            {
                tokenizer_set_error(ctx, stream, "missing terminating \" character");
                goto _CKL0;/*throw*/
            }
            if (stream->current[0] == 92)
            {
                stream_match(stream);
                stream_match(stream);
            }
            else
            {
                stream_match(stream);
            }
        }
        stream_match(stream);
        p_new_token = new_token(start, stream->current, 130);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return p_new_token;
}

int get_char_type(char * s)
{
    if (s[0] == 76)
    {
        return 2;
    }
    return 1;
}

int string_literal_char_byte_size(char * s)
{
    if (s[0] == 117)
    {
    }
    else
    {
        if (s[0] == 85 || s[0] == 76)
        {
            return 2;
        }
    }
    return 1;
}

int string_literal_byte_size_not_zero_included(char * s)
{
    struct stream  stream;
    int size;
    int charsize;

    stream.source = s;
    stream.current = 0;
    stream.line = 0;
    stream.col = 0;
    stream.line_continuation_count = 0;
    stream.path = 0;
    stream.current = s;
    stream.line = 1;
    stream.col = 1;
    stream.path = "";
    size = 0;
    charsize = string_literal_char_byte_size(s);
    if (1) /*try*/
    {
        if (stream.current[0] == 117)
        {
            stream_match(&stream);
            if (stream.current[0] == 56)
            {
                stream_match(&stream);
            }
        }
        else
        {
            if (stream.current[0] == 85 || stream.current[0] == 76)
            {
                stream_match(&stream);
            }
        }
        stream_match(&stream);
        while (stream.current[0] != 34)
        {
            if (stream.current[0] == 0 || stream.current[0] == 10)
            {
                goto _CKL0;/*throw*/
            }
            if (stream.current[0] == 92)
            {
                stream_match(&stream);
                stream_match(&stream);
                size++;
            }
            else
            {
                stream_match(&stream);
                size++;
            }
        }
        stream_match(&stream);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return size * charsize;
}

static struct token *ppnumber(struct stream * stream)
{
    char * start;
    struct token * p_new_token;

    start = stream->current;
    if (is_digit(stream))
    {
        stream_match(stream);
    }
    else
    {
        if (stream->current[0] == 46)
        {
            stream_match(stream);
            stream_match(stream);
        }
        else
        {
            ;
        }
    }
    for (; ; )
    {
        if (stream->current[0] == 39)
        {
            stream_match(stream);
            if (is_digit(stream))
            {
                stream_match(stream);
            }
            else
            {
                if (is_nondigit(stream))
                {
                    stream_match(stream);
                }
                else
                {
                    ;
                    break;
                }
            }
        }
        else
        {
            if ((stream->current[0] == 101 || stream->current[0] == 69 || stream->current[0] == 112 || stream->current[0] == 80) && (stream->current[1] == 43 || stream->current[1] == 45))
            {
                stream_match(stream);
                stream_match(stream);
            }
            else
            {
                if (stream->current[0] == 46)
                {
                    stream_match(stream);
                }
                else
                {
                    if (is_digit(stream) || is_nondigit(stream))
                    {
                        stream_match(stream);
                    }
                    else
                    {
                        break;
                    }
                }
            }
        }
    }
    p_new_token = new_token(start, stream->current, 134);
    return p_new_token;
}

struct _iobuf *fopen(char * _FileName, char * _Mode);
unsigned int fread(void * _Buffer, unsigned int _ElementSize, unsigned int _ElementCount, struct _iobuf * _Stream);
int fclose(struct _iobuf * _Stream);

struct token_list embed_tokenizer(struct preprocessor_ctx * ctx, struct token * position, char * filename_opt, int level, int addflags)
{
    struct token_list  list;
    struct _iobuf * file;
    unsigned char   b_first;
    int line;
    int col;
    int count;

    _cake_zmem(&list, 8);
    file = 0U;
    b_first = 1;
    line = 1;
    col = 1;
    count = 0;
    if (1) /*try*/
    {
        unsigned char ch;
        char newline[2];
        struct token * p_new_token;

        file = (struct _iobuf *)fopen(filename_opt, "rb");
        if (file == 0U)
        {
            preprocessor_diagnostic(1150, ctx, position, "file '%s' not found", filename_opt);
            goto _CKL0;/*throw*/
        }
        ch = 0;
        while (fread(&ch, 1, 1, file))
        {
            char buffer[30];
            int c;
            struct token * p_new_token;

            if (b_first)
            {
                b_first = 0;
            }
            else
            {
                char b[2];
                struct token * p_new_token;

                _cake_memcpy(b, ",", 2);
                p_new_token = new_token(b, &b[1], 44);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = 0U;
                p_new_token->line = line;
                p_new_token->col = col;
                token_list_add(&list, p_new_token);
                if (count > 0 && count % 25 == 0)
                {
                    char newline[2];
                    struct token * p_new3;

                    _cake_memcpy(newline, "\n", 2);
                    p_new3 = new_token(newline, &newline[1], 10);
                    if (p_new3 == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    p_new3->level = level;
                    p_new3->token_origin = 0U;
                    p_new3->line = line;
                    p_new3->col = col;
                    token_list_add(&list, p_new3);
                }
            }
            _cake_zmem(&buffer, 30);
            c = snprintf(buffer, 30U, "%d", (int)ch);
            p_new_token = new_token(buffer, &buffer[c], 134);
            if (p_new_token == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_new_token->flags |= addflags;
            p_new_token->level = level;
            p_new_token->token_origin = 0U;
            p_new_token->line = line;
            p_new_token->col = col;
            token_list_add(&list, p_new_token);
            count++;
        }
        _cake_memcpy(newline, "\n", 2);
        p_new_token = new_token(newline, &newline[1], 10);
        if (p_new_token == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_new_token->level = level;
        p_new_token->token_origin = 0U;
        p_new_token->line = line;
        p_new_token->col = col;
        token_list_add(&list, p_new_token);
        ;
    }
    else _CKL0: /*catch*/ 
    {
    }
    if (file)
    {
        fclose(file);
    }
    return list;
}

static unsigned char  set_sliced_flag(struct stream * stream, struct token * p_new_token)
{
    if (stream->line_continuation_count > 0)
    {
        p_new_token->flags |= 1024;
        if (stream->line_continuation_count == 1)
        {
            int l;

            l = strlen(p_new_token->lexeme);
            if (p_new_token->lexeme[l - 1] == 10)
            {
            }
            else
            {
                p_new_token->flags |= 512;
            }
        }
        else
        {
            p_new_token->flags |= 512;
        }
    }
    return !!(p_new_token->flags & 512);
}

int __cdecl isdigit(int _C);

struct token_list tokenizer(struct tokenizer_ctx * ctx, char * text, char * filename_opt, int level, int addflags)
{
    struct token_list  list;
    struct stream  stream;

    _cake_zmem(&list, 8);
    stream.source = text;
    stream.current = text;
    stream.line = 1;
    stream.col = 1;
    stream.line_continuation_count = 0;
    stream.path = filename_opt ? filename_opt : "";
    if (1) /*try*/
    {
        struct token * p_first;
        unsigned char   new_line;
        unsigned char   has_space;

        p_first = 0U;
        if (filename_opt != 0U)
        {
            char * begin;
            char * end;
            struct token * p_new;

            begin = filename_opt;
            end = filename_opt + strlen(filename_opt);
            p_new = new_token(begin, end, 8998);
            if (p_new == 0U)
            {
                goto _CKL0;/*throw*/
            }
            path_normalize(p_new->lexeme);
            p_new->level = level;
            p_first = token_list_add(&list, p_new);
        }
        new_line = 1;
        has_space = 0;
        while (1)
        {
            int line;
            int col;
            char * start;
            int t;

            line = stream.line;
            col = stream.col;
            stream.line_continuation_count = 0;
            if (stream.current[0] == 0)
            {
                stream_match(&stream);
                break;
            }
            if (is_digit(&stream) || (stream.current[0] == 46 && isdigit(stream.current[0])))
            {
                struct token * p_new_token;

                p_new_token = ppnumber(&stream);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            if (first_of_string_literal(&stream))
            {
                struct token * p_new_token;

                p_new_token = string_literal(ctx, &stream);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            if (first_of_character_constant(&stream))
            {
                struct token * p_new_token;

                p_new_token = character_constant(ctx, &stream);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            if (is_nondigit(&stream))
            {
                struct token * p_new_token;

                p_new_token = identifier(&stream);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                new_line = 0;
                has_space = 0;
                if (set_sliced_flag(&stream, p_new_token))
                {
                    tokenizer_set_warning(ctx, &stream, "token sliced");
                }
                token_list_add(&list, p_new_token);
                continue;
            }
            if (stream.current[0] == 32 || stream.current[0] == 9 || stream.current[0] == 12)
            {
                char * start;
                struct token * p_new_token;

                start = stream.current;
                while (stream.current[0] == 32 || stream.current[0] == 9 || stream.current[0] == 12)
                {
                    stream_match(&stream);
                }
                p_new_token = new_token(start, stream.current, 143);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                has_space = 1;
                continue;
            }
            if (stream.current[0] == 47 && stream.current[1] == 47)
            {
                char * start;
                struct token * p_new_token;

                start = stream.current;
                stream_match(&stream);
                stream_match(&stream);
                while (stream.current[0] != 10)
                {
                    stream_match(&stream);
                    if (stream.current[0] == 0)
                    {
                        break;
                    }
                }
                p_new_token = new_token(start, stream.current, 132);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 1;
                has_space = 0;
                if (stream.current[0] == 0)
                {
                    break;
                }
                continue;
            }
            if (stream.current[0] == 47 && stream.current[1] == 42)
            {
                char * start;
                struct token * p_new_token;

                start = stream.current;
                stream_match(&stream);
                stream_match(&stream);
                for (; ; )
                {
                    if (stream.current[0] == 42 && stream.current[1] == 47)
                    {
                        stream_match(&stream);
                        stream_match(&stream);
                        break;
                    }
                    else
                    {
                        if (stream.current[0] == 0)
                        {
                            tokenizer_set_error(ctx, &stream, "missing end of comment");
                            break;
                        }
                        else
                        {
                            stream_match(&stream);
                        }
                    }
                }
                p_new_token = new_token(start, stream.current, 133);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            if (new_line && stream.current[0] == 35)
            {
                char * start;
                struct token * p_new_token;

                start = stream.current;
                stream_match(&stream);
                p_new_token = new_token(start, stream.current, 35);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                p_new_token->type = 127;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            if (stream.current[0] == 10 || stream.current[0] == 13)
            {
                char newline[2];
                struct token * p_new_token;

                if (stream.current[0] == 13 && stream.current[1] == 10)
                {
                    stream_match(&stream);
                    stream_match(&stream);
                }
                else
                {
                    stream_match(&stream);
                }
                _cake_memcpy(newline, "\n", 2);
                p_new_token = new_token(newline, newline + 1, 10);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 1;
                has_space = 0;
                continue;
            }
            start = stream.current;
            t = is_punctuator(&stream);
            if (t != 0)
            {
                struct token * p_new_token;

                p_new_token = new_token(start, stream.current, t);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            else
            {
                struct token * p_new_token;

                stream_match(&stream);
                p_new_token = new_token(start, stream.current, 135);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->flags |= has_space ? 4 : 0;
                p_new_token->flags |= new_line ? 8 : 0;
                p_new_token->flags |= addflags;
                p_new_token->level = level;
                p_new_token->token_origin = p_first;
                p_new_token->line = 1;
                p_new_token->col = 1;
                set_sliced_flag(&stream, p_new_token);
                token_list_add(&list, p_new_token);
                new_line = 0;
                has_space = 0;
                continue;
            }
            break;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    ;
    return list;
}

int __cdecl feof(struct _iobuf * _Stream);

unsigned char  fread2(void * buffer, unsigned int size, unsigned int count, struct _iobuf * stream, unsigned int * sz)
{
    unsigned char   result;
    unsigned int n;

    *sz = 0;
    result = 0;
    n = fread(buffer, size, count, stream);
    if (n == count)
    {
        *sz = n;
        result = 1;
    }
    else
    {
        if (n < count)
        {
            if (feof(stream))
            {
                *sz = n;
                result = 1;
            }
        }
    }
    return result;
}

unsigned char  preprocessor_token_ahead_is_identifier(struct token * p, char * lexeme);
struct token_list group_part(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level);

struct token_list group_opt(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        if (token_list_is_empty(input_list))
        {
            return r;
        }
        while (!token_list_is_empty(input_list))
        {
            ;
            if (input_list->head->type == 127 && (preprocessor_token_ahead_is_identifier(input_list->head, "endif") || preprocessor_token_ahead_is_identifier(input_list->head, "else") || preprocessor_token_ahead_is_identifier(input_list->head, "elif") || preprocessor_token_ahead_is_identifier(input_list->head, "elifdef") || preprocessor_token_ahead_is_identifier(input_list->head, "elifndef")))
            {
                break;
            }
            else
            {
                struct token_list  r2;

                r2 = group_part(ctx, input_list, is_active, level);
                token_list_append_list(&r, &r2);
                token_list_destroy(&r2);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

unsigned char  is_parser_token(struct token * p)
{
    return !!(p->type != 133 && p->type != 143 && p->type != 132 && p->type != 10);
}

unsigned char  is_never_final(int type)
{
    return !!(type == 8998 || type == 143 || type == 132 || type == 133 || type == 142 || type == 10);
}

struct token *preprocessor_look_ahead_core(struct token * p)
{
    struct token * current;

    current = p->next;
    while (current && (current->type == 143 || current->type == 142 || current->type == 132 || current->type == 133))
    {
        current = current->next;
    }
    return current;
}

unsigned char  preprocessor_token_ahead_is(struct token * p, int t)
{
    struct token * p_token;

    p_token = preprocessor_look_ahead_core(p);
    if (p_token != 0U && p_token->type == t)
    {
        return 1;
    }
    return 0;
}

unsigned char  preprocessor_token_ahead_is_identifier(struct token * p, char * lexeme)
{
    struct token * p_token;

    ;
    p_token = preprocessor_look_ahead_core(p);
    if (p_token != 0U && p_token->type == 8996)
    {
        return !!(strcmp(p_token->lexeme, lexeme) == 0);
    }
    return 0;
}

static void skip_blanks_level(struct preprocessor_ctx * ctx, struct token_list * dest, struct token_list * input_list, int level)
{
    while (input_list->head)
    {
        if (!token_is_blank(input_list->head))
        {
            break;
        }
        if (1)
        {
            struct token * p;

            p = token_list_pop_front_get(input_list);
            ;
            token_list_add(dest, p);
        }
        else
        {
            token_list_pop_front(input_list);
        }
    }
}

static void skip_blanks(struct preprocessor_ctx * ctx, struct token_list * dest, struct token_list * input_list)
{
    while (input_list->head)
    {
        struct token * p;

        if (!token_is_blank(input_list->head))
        {
            break;
        }
        p = token_list_pop_front_get(input_list);
        ;
        token_list_add(dest, p);
    }
}

void prematch_level(struct token_list * dest, struct token_list * input_list, int level)
{
    if (1)
    {
        struct token * p;

        p = token_list_pop_front_get(input_list);
        if (p)
        {
            token_list_add(dest, p);
        }
    }
    else
    {
        token_list_pop_front(input_list);
    }
}

void prematch(struct token_list * dest, struct token_list * input_list)
{
    struct token * p;

    p = token_list_pop_front_get(input_list);
    if (p)
    {
        token_list_add(dest, p);
    }
}

struct token_list process_defined(struct preprocessor_ctx * ctx, struct token_list * input_list)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        while (input_list->head != 0U)
        {
            if (input_list->head->type == 8996 && strcmp(input_list->head->lexeme, "defined") == 0)
            {
                unsigned char   has_parentesis;
                struct macro * macro;
                struct token * p_new_token;
                char * temp;

                token_list_pop_front(input_list);
                skip_blanks(ctx, &r, input_list);
                if (input_list->head == 0U)
                {
                    pre_unexpected_end_of_file(r.tail, ctx);
                    goto _CKL0;/*throw*/
                }
                has_parentesis = 0;
                if (input_list->head->type == 40)
                {
                    token_list_pop_front(input_list);
                    has_parentesis = 1;
                }
                skip_blanks(ctx, &r, input_list);
                if (input_list->head == 0U)
                {
                    pre_unexpected_end_of_file(r.tail, ctx);
                    goto _CKL0;/*throw*/
                }
                macro = find_macro(ctx, input_list->head->lexeme);
                p_new_token = token_list_pop_front_get(input_list);
                if (p_new_token == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_new_token->type = 134;
                temp = 0U;
                if (macro)
                {
                    temp = strdup("1");
                }
                else
                {
                    temp = strdup("0");
                }
                if (temp == 0U)
                {
                    token_delete(p_new_token);
                    goto _CKL0;/*throw*/
                }
                free(p_new_token->lexeme);
                p_new_token->lexeme = temp;
                token_list_add(&r, p_new_token);
                if (has_parentesis)
                {
                    if (input_list->head == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (input_list->head->type != 41)
                    {
                        preprocessor_diagnostic(1160, ctx, input_list->head, "missing )");
                        goto _CKL0;/*throw*/
                    }
                    token_list_pop_front(input_list);
                }
            }
            else
            {
                if (input_list->head->type == 8996 && (strcmp(input_list->head->lexeme, "__has_include") == 0 || strcmp(input_list->head->lexeme, "__has_embed") == 0))
                {
                    char path[100];
                    unsigned char   is_angle_bracket_form;
                    char fullpath[300];
                    char full_path_result[200];
                    unsigned char   already_included;
                    char * s;
                    unsigned char   has_include;
                    struct token * p_new_token;
                    char * temp;

                    token_list_pop_front(input_list);
                    skip_blanks(ctx, &r, input_list);
                    token_list_pop_front(input_list);
                    skip_blanks(ctx, &r, input_list);
                    _cake_zmem(&path, 100);
                    is_angle_bracket_form = 0;
                    if (input_list->head == 0U)
                    {
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                    if (input_list->head->type == 130)
                    {
                        strcat(path, input_list->head->lexeme);
                        token_list_pop_front(input_list);
                    }
                    else
                    {
                        is_angle_bracket_form = 1;
                        token_list_pop_front(input_list);
                        if (input_list->head == 0U)
                        {
                            pre_unexpected_end_of_file(r.tail, ctx);
                            goto _CKL0;/*throw*/
                        }
                        while (input_list->head->type != 62)
                        {
                            strcat(path, input_list->head->lexeme);
                            token_list_pop_front(input_list);
                            if (input_list->head == 0U)
                            {
                                pre_unexpected_end_of_file(r.tail, ctx);
                                goto _CKL0;/*throw*/
                            }
                        }
                        token_list_pop_front(input_list);
                    }
                    _cake_zmem(&fullpath, 300);
                    _cake_zmem(&full_path_result, 200);
                    already_included = 0;
                    s = find_and_read_include_file(ctx, path, fullpath, is_angle_bracket_form, &already_included, full_path_result, 200U, 0);
                    has_include = !!(s != 0U);
                    free((void *)s);
                    p_new_token = calloc(1, 40U);
                    if (p_new_token == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    p_new_token->type = 134;
                    temp = strdup(has_include ? "1" : "0");
                    if (temp == 0U)
                    {
                        token_delete(p_new_token);
                        goto _CKL0;/*throw*/
                    }
                    p_new_token->lexeme = temp;
                    p_new_token->flags |= 1;
                    token_list_add(&r, p_new_token);
                    token_list_pop_front(input_list);
                }
                else
                {
                    if (input_list->head->type == 8996 && strcmp(input_list->head->lexeme, "__has_c_attribute") == 0)
                    {
                        char path[100];
                        unsigned char   has_c_attribute;
                        struct token * p_new_token;
                        char * temp;

                        token_list_pop_front(input_list);
                        skip_blanks(ctx, &r, input_list);
                        token_list_pop_front(input_list);
                        skip_blanks(ctx, &r, input_list);
                        if (input_list->head == 0U)
                        {
                            pre_unexpected_end_of_file(r.tail, ctx);
                            goto _CKL0;/*throw*/
                        }
                        _cake_zmem(&path, 100);
                        while (input_list->head->type != 41)
                        {
                            strcat(path, input_list->head->lexeme);
                            token_list_pop_front(input_list);
                            if (input_list->head == 0U)
                            {
                                pre_unexpected_end_of_file(r.tail, ctx);
                                goto _CKL0;/*throw*/
                            }
                        }
                        token_list_pop_front(input_list);
                        has_c_attribute = 0;
                        p_new_token = calloc(1, 40U);
                        if (p_new_token == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                        p_new_token->type = 134;
                        temp = strdup(has_c_attribute ? "1" : "0");
                        if (temp == 0U)
                        {
                            token_delete(p_new_token);
                            goto _CKL0;/*throw*/
                        }
                        p_new_token->lexeme = temp;
                        p_new_token->flags |= 1;
                        token_list_add(&r, p_new_token);
                        token_list_pop_front(input_list);
                    }
                    else
                    {
                        struct token * tk;

                        tk = token_list_pop_front_get(input_list);
                        if (tk)
                        {
                            token_list_add(&r, tk);
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list process_identifiers(struct preprocessor_ctx * ctx, struct token_list * list)
{
    struct token_list  list2;

    ;
    _cake_zmem(&list2, 8);
    if (1) /*try*/
    {
        while (list->head != 0U)
        {
            if (list->head->type == 8996)
            {
                struct macro * macro;
                struct token * p_new_token;

                macro = find_macro(ctx, list->head->lexeme);
                p_new_token = token_list_pop_front_get(list);
                ;
                p_new_token->type = 134;
                if (macro)
                {
                    char * temp;

                    temp = strdup("1");
                    if (temp == 0U)
                    {
                        token_delete(p_new_token);
                        goto _CKL0;/*throw*/
                    }
                    free(p_new_token->lexeme);
                    p_new_token->lexeme = temp;
                }
                else
                {
                    if (strcmp(p_new_token->lexeme, "true") == 0)
                    {
                        p_new_token->lexeme[0] = 49;
                        p_new_token->lexeme[1] = 0;
                    }
                    else
                    {
                        if (strcmp(p_new_token->lexeme, "false") == 0)
                        {
                            p_new_token->lexeme[0] = 48;
                            p_new_token->lexeme[1] = 0;
                        }
                        else
                        {
                            char * temp;

                            temp = strdup("0");
                            if (temp == 0U)
                            {
                                token_delete(p_new_token);
                                goto _CKL0;/*throw*/
                            }
                            free(p_new_token->lexeme);
                            p_new_token->lexeme = temp;
                        }
                    }
                }
                token_list_add(&list2, p_new_token);
            }
            else
            {
                struct token * ptk;

                ptk = token_list_pop_front_get(list);
                ;
                token_list_add(&list2, ptk);
            }
        }
        ;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return list2;
}

struct token_list ignore_preprocessor_line(struct token_list * input_list)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    while (input_list->head && input_list->head->type != 10)
    {
        struct token * tk;

        tk = token_list_pop_front_get(input_list);
        ;
        token_list_add(&r, tk);
    }
    return r;
}

struct token_list copy_replacement_list(struct preprocessor_ctx * ctx, struct token_list * list);
struct token_list preprocessor(struct preprocessor_ctx * ctx, struct token_list * input_list, int level);
int pre_constant_expression(struct preprocessor_ctx * ctx, long long * pvalue);

long long preprocessor_constant_expression(struct preprocessor_ctx * ctx, struct token_list * output_list, struct token_list * input_list, int level)
{
    struct token * first;
    struct token_list  r;
    struct token_list  list1;
    int flags;
    struct token_list  list2;
    long long value;

    ;
    first = input_list->head;
    ctx->conditional_inclusion = 1;
    _cake_zmem(&r, 8);
    while (input_list->head && input_list->head->type != 10)
    {
        struct token * tk;

        tk = token_list_pop_front_get(input_list);
        ;
        token_list_add(&r, tk);
        ;
        r.tail->flags &= -1025;
    }
    list1 = copy_replacement_list(ctx, &r);
    token_list_swap(output_list, &r);
    flags = ctx->flags;
    ctx->flags |= 1;
    list2 = preprocessor(ctx, &list1, 1);
    ctx->flags = flags;
    value = 0;
    if (list2.head == 0U)
    {
        preprocessor_diagnostic(1170, ctx, first, "empty expression");
    }
    else
    {
        struct token_list  list3;
        struct token_list  list4;
        struct preprocessor_ctx  pre_ctx;

        list3 = process_defined(ctx, &list2);
        list4 = process_identifiers(ctx, &list3);
        ;
        _cake_zmem(&pre_ctx, 752);
        pre_ctx.input_list = list4;
        pre_ctx.current = pre_ctx.input_list.head;
        if (pre_constant_expression(&pre_ctx, &value) != 0)
        {
            preprocessor_diagnostic(1170, ctx, first, "expression error");
        }
        ctx->conditional_inclusion = 0;
        preprocessor_ctx_destroy(&pre_ctx);
    }
    token_list_destroy(&list1);
    token_list_destroy(&r);
    token_list_destroy(&list2);
    return value;
}

void match_level(struct token_list * dest, struct token_list * input_list, int level)
{
    if (1)
    {
        struct token * tk;

        tk = token_list_pop_front_get(input_list);
        if (tk)
        {
            token_list_add(dest, tk);
        }
    }
    else
    {
        token_list_pop_front(input_list);
    }
}

int match_token_level(struct token_list * dest, struct token_list * input_list, int type, int level, struct preprocessor_ctx * ctx)
{
    if (1) /*try*/
    {
        if (input_list->head == 0U || input_list->head->type != type)
        {
            if (type == 10 && input_list->head == 0U)
            {
            }
            else
            {
                if (input_list->head)
                {
                    preprocessor_diagnostic(970, ctx, input_list->head, "expected token %s got %s\n", get_token_name(type), get_token_name(input_list->head->type));
                }
                else
                {
                    preprocessor_diagnostic(970, ctx, dest->tail, "expected EOF \n");
                }
                goto _CKL0;/*throw*/
            }
        }
        if (input_list->head != 0U)
        {
            if (1)
            {
                token_list_add(dest, token_list_pop_front_get(input_list));
            }
            else
            {
                token_list_pop_front(input_list);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return ctx->n_errors > 0;
}

struct token_list if_group(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level, unsigned char  * p_result)
{
    struct token_list  r;

    *p_result = 0;
    ;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct token_list  r2;

        match_token_level(&r, input_list, 127, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        if (input_list->head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        ;
        if (strcmp(input_list->head->lexeme, "ifdef") == 0)
        {
            match_token_level(&r, input_list, 8996, level, ctx);
            skip_blanks_level(ctx, &r, input_list, level);
            if (input_list->head == 0U)
            {
                pre_unexpected_end_of_file(r.tail, ctx);
                goto _CKL0;/*throw*/
            }
            if (is_active)
            {
                struct macro * macro;

                macro = find_macro(ctx, input_list->head->lexeme);
                *p_result = !!((macro != 0U) ? 1 : 0);
            }
            match_token_level(&r, input_list, 8996, level, ctx);
            skip_blanks_level(ctx, &r, input_list, level);
            match_token_level(&r, input_list, 10, level, ctx);
        }
        else
        {
            if (strcmp(input_list->head->lexeme, "ifndef") == 0)
            {
                match_token_level(&r, input_list, 8996, level, ctx);
                skip_blanks_level(ctx, &r, input_list, level);
                if (input_list->head == 0U)
                {
                    pre_unexpected_end_of_file(r.tail, ctx);
                    goto _CKL0;/*throw*/
                }
                if (is_active)
                {
                    struct macro * macro;

                    macro = find_macro(ctx, input_list->head->lexeme);
                    *p_result = !!((macro == 0U) ? 1 : 0);
                }
                match_token_level(&r, input_list, 8996, level, ctx);
                skip_blanks_level(ctx, &r, input_list, level);
                match_token_level(&r, input_list, 10, level, ctx);
            }
            else
            {
                if (strcmp(input_list->head->lexeme, "if") == 0)
                {
                    match_token_level(&r, input_list, 8996, level, ctx);
                    skip_blanks_level(ctx, &r, input_list, level);
                    if (is_active)
                    {
                        struct token_list  r0;

                        _cake_zmem(&r0, 8);
                        *p_result = !!(preprocessor_constant_expression(ctx, &r0, input_list, level));
                        token_list_append_list(&r, &r0);
                        token_list_destroy(&r0);
                    }
                    else
                    {
                        struct token_list  r0;

                        r0 = ignore_preprocessor_line(input_list);
                        token_list_append_list(&r, &r0);
                        token_list_destroy(&r0);
                    }
                    match_token_level(&r, input_list, 10, level, ctx);
                }
                else
                {
                    preprocessor_diagnostic(650, ctx, input_list->head, "unexpected");
                    goto _CKL0;/*throw*/
                }
            }
        }
        r2 = group_opt(ctx, input_list, is_active && *p_result, level);
        token_list_append_list(&r, &r2);
        ;
        ;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list elif_group(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level, unsigned char  * p_elif_result)
{
    struct token_list  r;

    *p_elif_result = 0;
    ;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        unsigned long long result;
        struct token_list  r2;

        match_token_level(&r, input_list, 127, level, ctx);
        skip_blanks(ctx, &r, input_list);
        if (input_list->head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        result = 0;
        if (strcmp(input_list->head->lexeme, "elif") == 0)
        {
            match_token_level(&r, input_list, 8996, level, ctx);
            skip_blanks(ctx, &r, input_list);
            if (is_active)
            {
                struct token_list  r0;

                _cake_zmem(&r0, 8);
                result = preprocessor_constant_expression(ctx, &r0, input_list, level);
                token_list_append_list(&r, &r0);
                token_list_destroy(&r0);
            }
            else
            {
                struct token_list  r0;

                r0 = ignore_preprocessor_line(input_list);
                token_list_append_list(&r, &r0);
                token_list_destroy(&r0);
            }
        }
        else
        {
            if (strcmp(input_list->head->lexeme, "elifdef") == 0)
            {
                match_token_level(&r, input_list, 8996, level, ctx);
                skip_blanks(ctx, &r, input_list);
                if (input_list->head == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (is_active)
                {
                    result = (hashmap_find(&ctx->macros, input_list->head->lexeme) != 0U) ? 1 : 0;
                }
                match_token_level(&r, input_list, 8996, level, ctx);
            }
            else
            {
                if (strcmp(input_list->head->lexeme, "elifndef") == 0)
                {
                    match_token_level(&r, input_list, 8996, level, ctx);
                    skip_blanks(ctx, &r, input_list);
                    if (input_list->head == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (is_active)
                    {
                        result = (hashmap_find(&ctx->macros, input_list->head->lexeme) == 0U) ? 1 : 0;
                    }
                    match_token_level(&r, input_list, 8996, level, ctx);
                }
            }
        }
        *p_elif_result = !!((result != 0));
        skip_blanks(ctx, &r, input_list);
        match_token_level(&r, input_list, 10, level, ctx);
        r2 = group_opt(ctx, input_list, is_active && *p_elif_result, level);
        token_list_append_list(&r, &r2);
        token_list_destroy(&r2);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list elif_groups(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level, unsigned char  * pelif_result)
{
    struct token_list  r;

    ;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        unsigned char   already_found_elif_true;
        unsigned char   elif_result;
        struct token_list  r2;

        already_found_elif_true = 0;
        elif_result = 0;
        r2 = elif_group(ctx, input_list, is_active, level, &elif_result);
        if (input_list->head == 0U)
        {
            token_list_destroy(&r2);
            goto _CKL0;/*throw*/
        }
        token_list_append_list(&r, &r2);
        if (elif_result)
        {
            already_found_elif_true = 1;
        }
        if (input_list->head->type == 127 && (preprocessor_token_ahead_is_identifier(input_list->head, "elif") || preprocessor_token_ahead_is_identifier(input_list->head, "elifdef") || preprocessor_token_ahead_is_identifier(input_list->head, "elifndef")))
        {
            struct token_list  r3;

            r3 = elif_groups(ctx, input_list, is_active && !already_found_elif_true, level, &elif_result);
            token_list_append_list(&r, &r3);
            if (elif_result)
            {
                already_found_elif_true = 1;
            }
            token_list_destroy(&r3);
        }
        *pelif_result = already_found_elif_true;
        token_list_destroy(&r2);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list else_group(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct token_list  r2;

        match_token_level(&r, input_list, 127, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        match_token_level(&r, input_list, 8996, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        match_token_level(&r, input_list, 10, level, ctx);
        r2 = group_opt(ctx, input_list, is_active, level);
        token_list_append_list(&r, &r2);
        token_list_destroy(&r2);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list endif_line(struct preprocessor_ctx * ctx, struct token_list * input_list, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    match_token_level(&r, input_list, 127, level, ctx);
    skip_blanks_level(ctx, &r, input_list, level);
    match_token_level(&r, input_list, 8996, level, ctx);
    skip_blanks_level(ctx, &r, input_list, level);
    match_token_level(&r, input_list, 10, level, ctx);
    return r;
}

static unsigned char  is_builtin_macro(char * name);
struct token_list identifier_list(struct preprocessor_ctx * ctx, struct macro * macro, struct token_list * input_list, int level);
void naming_convention_macro(struct preprocessor_ctx * ctx, struct token * token);

struct token_list def_line(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level, struct macro ** pp_macro)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct macro * macro;
        struct token * macro_name_token;
        char * temp;
        struct hash_item_set  item;

        macro = calloc(1, 32U);
        if (macro == 0U)
        {
            preprocessor_diagnostic(650, ctx, ctx->current, "out of mem");
            goto _CKL0;/*throw*/
        }
        macro->def_macro = 1;
        match_token_level(&r, input_list, 127, level, ctx);
        match_token_level(&r, input_list, 8996, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        if (input_list->head == 0U)
        {
            macro_delete(macro);
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        macro_name_token = input_list->head;
        if (is_builtin_macro(macro_name_token->lexeme))
        {
            preprocessor_diagnostic(55, ctx, input_list->head, "redefining builtin macro");
        }
        if (hashmap_find(&ctx->macros, input_list->head->lexeme) != 0U)
        {
        }
        temp = strdup(input_list->head->lexeme);
        if (temp == 0U)
        {
            macro_delete(macro);
            goto _CKL0;/*throw*/
        }
        ;
        macro->name = temp;
        match_token_level(&r, input_list, 8996, level, ctx);
        if (input_list->head == 0U)
        {
            macro_delete(macro);
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        if (input_list->head->type == 40)
        {
            macro->is_function = 1;
            match_token_level(&r, input_list, 40, level, ctx);
            skip_blanks_level(ctx, &r, input_list, level);
            if (input_list->head == 0U)
            {
                macro_delete(macro);
                pre_unexpected_end_of_file(r.tail, ctx);
                goto _CKL0;/*throw*/
            }
            if (input_list->head->type == 3026478)
            {
                struct macro_parameter * p_macro_parameter;
                char * temp2;

                p_macro_parameter = calloc(1, 20U);
                if (p_macro_parameter == 0U)
                {
                    macro_delete(macro);
                    goto _CKL0;/*throw*/
                }
                temp2 = strdup("__VA_ARGS__");
                if (temp2 == 0U)
                {
                    macro_delete(macro);
                    macro_parameters_delete(p_macro_parameter);
                    goto _CKL0;/*throw*/
                }
                p_macro_parameter->name = temp2;
                macro->parameters = p_macro_parameter;
                match_token_level(&r, input_list, 3026478, level, ctx);
                skip_blanks_level(ctx, &r, input_list, level);
                match_token_level(&r, input_list, 41, level, ctx);
            }
            else
            {
                if (input_list->head->type == 41)
                {
                    match_token_level(&r, input_list, 41, level, ctx);
                    skip_blanks_level(ctx, &r, input_list, level);
                }
                else
                {
                    struct token_list  r3;

                    r3 = identifier_list(ctx, macro, input_list, level);
                    token_list_append_list(&r, &r3);
                    token_list_destroy(&r3);
                    skip_blanks_level(ctx, &r, input_list, level);
                    if (input_list->head == 0U)
                    {
                        macro_delete(macro);
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                    if (input_list->head->type == 3026478)
                    {
                        struct macro_parameter * p_macro_parameter;
                        char * temp3;
                        struct macro_parameter * p_last;

                        p_macro_parameter = calloc(1, 20U);
                        if (p_macro_parameter == 0U)
                        {
                            macro_delete(macro);
                            goto _CKL0;/*throw*/
                        }
                        temp3 = strdup("__VA_ARGS__");
                        if (temp3 == 0U)
                        {
                            macro_delete(macro);
                            macro_parameters_delete(p_macro_parameter);
                            goto _CKL0;/*throw*/
                        }
                        p_macro_parameter->name = temp3;
                        p_last = macro->parameters;
                        ;
                        while (p_last->next)
                        {
                            p_last = p_last->next;
                        }
                        p_last->next = p_macro_parameter;
                        match_token_level(&r, input_list, 3026478, level, ctx);
                    }
                    skip_blanks_level(ctx, &r, input_list, level);
                    match_token_level(&r, input_list, 41, level, ctx);
                }
            }
        }
        else
        {
            macro->is_function = 0;
        }
        skip_blanks_level(ctx, &r, input_list, level);
        if (input_list->head == 0U)
        {
            macro_delete(macro);
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        naming_convention_macro(ctx, macro_name_token);
        _cake_zmem(&item, 32);
        item.p_macro = macro;
        hashmap_set(&ctx->macros, macro->name, &item);
        hash_item_set_destroy(&item);
        *pp_macro = macro;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list replacement_group(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        for (; ; )
        {
            if (input_list->head == 0U)
            {
                preprocessor_diagnostic(650, ctx, r.tail, "missing #enddef");
                goto _CKL0;/*throw*/
            }
            if (input_list->head->type == 127 && (preprocessor_token_ahead_is_identifier(input_list->head, "enddef")))
            {
                break;
            }
            prematch_level(&r, input_list, level);
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list enddef_line(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        if (input_list->head == 0U)
        {
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        match_token_level(&r, input_list, 127, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        match_token_level(&r, input_list, 8996, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        match_token_level(&r, input_list, 10, level, ctx);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list def_section(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct macro * p_macro;
        struct token_list  r2;
        struct token_list  r3;
        struct token_list  copy;
        struct token_list  r4;

        p_macro = 0U;
        r2 = def_line(ctx, input_list, is_active, level, &p_macro);
        token_list_append_list(&r, &r2);
        if (ctx->n_errors > 0 || p_macro == 0U)
        {
            token_list_destroy(&r2);
            goto _CKL0;/*throw*/
        }
        r3 = replacement_group(ctx, input_list, is_active, level);
        if (ctx->n_errors > 0)
        {
            token_list_destroy(&r2);
            token_list_destroy(&r3);
            goto _CKL0;/*throw*/
        }
        copy = copy_replacement_list(ctx, &r3);
        token_list_append_list(&p_macro->replacement_list, &copy);
        token_list_append_list(&r, &r3);
        r4 = enddef_line(ctx, input_list, is_active, level);
        token_list_append_list(&r, &r4);
        token_list_destroy(&r2);
        token_list_destroy(&r3);
        token_list_destroy(&r4);
        token_list_destroy(&copy);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list if_section(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    ;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        unsigned char   if_result;
        struct token_list  r2;
        unsigned char   elif_result;
        struct token_list  r5;

        if_result = 0;
        r2 = if_group(ctx, input_list, is_active, level, &if_result);
        if (ctx->n_errors > 0)
        {
            token_list_destroy(&r2);
            goto _CKL0;/*throw*/
        }
        if (input_list->head == 0U)
        {
            token_list_destroy(&r2);
            goto _CKL0;/*throw*/
        }
        token_list_append_list(&r, &r2);
        elif_result = 0;
        if (input_list->head->type == 127 && (preprocessor_token_ahead_is_identifier(input_list->head, "elif") || preprocessor_token_ahead_is_identifier(input_list->head, "elifdef") || preprocessor_token_ahead_is_identifier(input_list->head, "elifndef")))
        {
            struct token_list  r3;

            r3 = elif_groups(ctx, input_list, is_active && !if_result, level, &elif_result);
            token_list_append_list(&r, &r3);
            token_list_destroy(&r3);
        }
        if (input_list->head == 0U)
        {
            token_list_destroy(&r2);
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        if (input_list->head->type == 127 && preprocessor_token_ahead_is_identifier(input_list->head, "else"))
        {
            struct token_list  r4;

            r4 = else_group(ctx, input_list, is_active && !if_result && !elif_result, level);
            token_list_append_list(&r, &r4);
            token_list_destroy(&r4);
        }
        if (ctx->n_errors > 0)
        {
            token_list_destroy(&r2);
            goto _CKL0;/*throw*/
        }
        r5 = endif_line(ctx, input_list, level);
        token_list_append_list(&r, &r5);
        token_list_destroy(&r5);
        token_list_destroy(&r2);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list identifier_list(struct preprocessor_ctx * ctx, struct macro * macro, struct token_list * input_list, int level)
{
    struct token_list  r;

    ;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct macro_parameter * p_macro_parameter;
        char * temp;
        struct macro_parameter * p_last_parameter;

        skip_blanks(ctx, &r, input_list);
        if (input_list->head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_macro_parameter = calloc(1, 20U);
        if (p_macro_parameter == 0U)
        {
            goto _CKL0;/*throw*/
        }
        temp = strdup(input_list->head->lexeme);
        if (temp == 0U)
        {
            macro_parameters_delete(p_macro_parameter);
            goto _CKL0;/*throw*/
        }
        p_macro_parameter->name = temp;
        ;
        macro->parameters = p_macro_parameter;
        p_last_parameter = macro->parameters;
        match_token_level(&r, input_list, 8996, level, ctx);
        skip_blanks(ctx, &r, input_list);
        if (input_list->head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (input_list->head->type == 44)
        {
            struct macro_parameter * p_new_macro_parameter;
            char * temp2;

            match_token_level(&r, input_list, 44, level, ctx);
            skip_blanks(ctx, &r, input_list);
            if (input_list->head == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (input_list->head->type == 3026478)
            {
                break;
            }
            p_new_macro_parameter = calloc(1, 20U);
            if (p_new_macro_parameter == 0U)
            {
                goto _CKL0;/*throw*/
            }
            temp2 = strdup(input_list->head->lexeme);
            if (temp2 == 0U)
            {
                macro_parameters_delete(p_new_macro_parameter);
                goto _CKL0;/*throw*/
            }
            p_new_macro_parameter->name = temp2;
            ;
            p_last_parameter->next = p_new_macro_parameter;
            p_last_parameter = p_last_parameter->next;
            match_token_level(&r, input_list, 8996, level, ctx);
            skip_blanks(ctx, &r, input_list);
            if (input_list->head == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list replacement_list(struct preprocessor_ctx * ctx, struct macro * macro, struct token_list * input_list, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct token_list  copy;

        if (input_list->head == 0U)
        {
            pre_unexpected_end_of_file(0U, ctx);
            goto _CKL0;/*throw*/
        }
        while (input_list->head->type != 10)
        {
            match_level(&r, input_list, level);
            if (input_list->head == 0U)
            {
                break;
            }
        }
        ;
        copy = copy_replacement_list(ctx, &r);
        token_list_append_list(&macro->replacement_list, &copy);
        token_list_destroy(&copy);
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list pp_tokens_opt(struct preprocessor_ctx * ctx, struct token_list * input_list, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    while (input_list->head && input_list->head->type != 10)
    {
        prematch_level(&r, input_list, level);
    }
    return r;
}

static unsigned char  is_empty_assert(struct token_list * replacement_list)
{
    struct token * token;

    token = replacement_list->head;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, "("))
    {
        return 0;
    }
    token = token->next;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, "("))
    {
        return 0;
    }
    token = token->next;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, "void"))
    {
        return 0;
    }
    token = token->next;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, ")"))
    {
        return 0;
    }
    token = token->next;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, "0"))
    {
        return 0;
    }
    token = token->next;
    if (token == 0U)
    {
        return 0;
    }
    if (strcmp(token->lexeme, ")"))
    {
        return 0;
    }
    token = token->next;
    if (token != 0U)
    {
        return 0;
    }
    return 1;
}

char *dirname(char * path);
unsigned long long get_warning_bit_mask(char * wname);

struct token_list control_line(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        if (!is_active)
        {
            struct token_list  r7;

            r7 = pp_tokens_opt(ctx, input_list, level);
            token_list_append_list(&r, &r7);
            match_token_level(&r, input_list, 10, level, ctx);
            token_list_destroy(&r7);
            return r;
        }
        if (input_list->head == 0U)
        {
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        match_token_level(&r, input_list, 127, level, ctx);
        skip_blanks_level(ctx, &r, input_list, level);
        if (input_list->head == 0U)
        {
            pre_unexpected_end_of_file(r.tail, ctx);
            goto _CKL0;/*throw*/
        }
        if (strcmp(input_list->head->lexeme, "include") == 0 || strcmp(input_list->head->lexeme, "include_next") == 0)
        {
            unsigned char   include_next;
            char path[100];
            unsigned char   is_angle_bracket_form;
            char current_file_dir[300];
            char full_path_result[200];
            unsigned char   already_included;
            char * content;

            include_next = !!(strcmp(input_list->head->lexeme, "include_next") == 0);
            match_token_level(&r, input_list, 8996, level, ctx);
            skip_blanks_level(ctx, &r, input_list, level);
            if (input_list->head == 0U)
            {
                pre_unexpected_end_of_file(r.tail, ctx);
                goto _CKL0;/*throw*/
            }
            _cake_zmem(&path, 100);
            is_angle_bracket_form = 0;
            if (input_list->head->type == 130)
            {
                strcat(path, input_list->head->lexeme);
                prematch_level(&r, input_list, level);
            }
            else
            {
                is_angle_bracket_form = 1;
                while (input_list->head->type != 62)
                {
                    strcat(path, input_list->head->lexeme);
                    prematch_level(&r, input_list, level);
                    if (input_list->head == 0U)
                    {
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                }
                strcat(path, input_list->head->lexeme);
                prematch_level(&r, input_list, level);
            }
            while (input_list->head->type != 10)
            {
                prematch_level(&r, input_list, level);
                if (input_list->head == 0U)
                {
                    pre_unexpected_end_of_file(r.tail, ctx);
                    goto _CKL0;/*throw*/
                }
            }
            match_token_level(&r, input_list, 10, level, ctx);
            path[strlen(path) - 1] = 0;
            _cake_zmem(&current_file_dir, 300);
            snprintf(current_file_dir, 300U, "%s", r.tail->token_origin->lexeme);
            dirname(current_file_dir);
            _cake_zmem(&full_path_result, 200);
            already_included = 0;
            content = find_and_read_include_file(ctx, path + 1, current_file_dir, is_angle_bracket_form, &already_included, full_path_result, 200U, include_next);
            if (content != 0U)
            {
                struct tokenizer_ctx  tctx;
                struct token_list  list;
                struct token_list  list2;

                if (ctx->options.show_includes)
                {
                    {
                        int i;
                        i = 0;
                        for (; i < (level + 1); i++)
                        printf(".");
                    }
                    printf("%s\n", full_path_result);
                }
                _cake_zmem(&tctx, 696);
                list = tokenizer(&tctx, content, full_path_result, level + 1, 0);
                free((void *)content);
                list2 = preprocessor(ctx, &list, level + 1);
                token_list_append_list(&r, &list2);
                token_list_destroy(&list2);
                token_list_destroy(&list);
            }
            else
            {
                if (!already_included)
                {
                    preprocessor_diagnostic(1150, ctx, r.tail, "file %s not found", path + 1);
                    {
                        struct include_dir * p;
                        p = ctx->include_dir.head;
                        for (; p; p = p->next)
                        {
                            preprocessor_diagnostic(63, ctx, r.tail, "dir = '%s'", p->path);
                        }
                    }
                }
                else
                {
                }
            }
        }
        else
        {
            if (strcmp(input_list->head->lexeme, "embed") == 0)
            {
                struct token_list  discard0;
                struct token_list * p_list;
                struct token * p_embed_token;
                char path[100];
                char fullpath[300];
                int nlevel;
                int f;
                struct token_list  list;

                _cake_zmem(&discard0, 8);
                p_list = &r;
                p_embed_token = input_list->head;
                match_token_level(p_list, input_list, 8996, level, ctx);
                skip_blanks_level(ctx, p_list, input_list, level);
                if (input_list->head == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                _cake_zmem(&path, 100);
                if (input_list->head->type == 130)
                {
                    strcat(path, input_list->head->lexeme);
                    prematch_level(p_list, input_list, level);
                }
                else
                {
                    while (input_list->head->type != 62)
                    {
                        strcat(path, input_list->head->lexeme);
                        prematch_level(p_list, input_list, level);
                        if (input_list->head == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                    }
                    strcat(path, input_list->head->lexeme);
                    prematch_level(p_list, input_list, level);
                }
                if (input_list->head)
                {
                    while (input_list->head->type != 10)
                    {
                        prematch_level(p_list, input_list, level);
                        if (input_list->head == 0U)
                        {
                            pre_unexpected_end_of_file(p_list->tail, ctx);
                            goto _CKL0;/*throw*/
                        }
                    }
                }
                match_token_level(p_list, input_list, 10, level, ctx);
                _cake_zmem(&fullpath, 300);
                path[strlen(path) - 1] = 0;
                snprintf(fullpath, 300U, "%s", path + 1);
                nlevel = level;
                f = 0;
                f = 1;
                nlevel = nlevel + 1;
                list = embed_tokenizer(ctx, p_embed_token, fullpath, nlevel, f);
                if (ctx->n_errors > 0)
                {
                    token_list_destroy(&list);
                    goto _CKL0;/*throw*/
                }
                token_list_append_list(&r, &list);
                token_list_destroy(&list);
                token_list_destroy(&discard0);
            }
            else
            {
                if (strcmp(input_list->head->lexeme, "define") == 0)
                {
                    struct macro * macro;
                    struct token * macro_name_token;
                    char * temp;
                    struct token_list  r4;
                    struct macro * existing_macro;
                    struct hash_item_set  item;

                    macro = calloc(1, 32U);
                    if (macro == 0U)
                    {
                        preprocessor_diagnostic(650, ctx, ctx->current, "out of mem");
                        goto _CKL0;/*throw*/
                    }
                    match_token_level(&r, input_list, 8996, level, ctx);
                    skip_blanks_level(ctx, &r, input_list, level);
                    if (input_list->head == 0U)
                    {
                        macro_delete(macro);
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                    macro_name_token = input_list->head;
                    if (is_builtin_macro(macro_name_token->lexeme))
                    {
                        preprocessor_diagnostic(55, ctx, input_list->head, "redefining builtin macro");
                    }
                    macro->p_name_token = macro_name_token;
                    temp = strdup(input_list->head->lexeme);
                    if (temp == 0U)
                    {
                        macro_delete(macro);
                        goto _CKL0;/*throw*/
                    }
                    ;
                    macro->name = temp;
                    match_token_level(&r, input_list, 8996, level, ctx);
                    if (input_list->head == 0U)
                    {
                        macro_delete(macro);
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                    if (input_list->head->type == 40)
                    {
                        macro->is_function = 1;
                        match_token_level(&r, input_list, 40, level, ctx);
                        skip_blanks_level(ctx, &r, input_list, level);
                        if (input_list->head == 0U)
                        {
                            macro_delete(macro);
                            pre_unexpected_end_of_file(r.tail, ctx);
                            goto _CKL0;/*throw*/
                        }
                        if (input_list->head->type == 3026478)
                        {
                            struct macro_parameter * p_macro_parameter;
                            char * temp2;

                            p_macro_parameter = calloc(1, 20U);
                            if (p_macro_parameter == 0U)
                            {
                                macro_delete(macro);
                                goto _CKL0;/*throw*/
                            }
                            temp2 = strdup("__VA_ARGS__");
                            if (temp2 == 0U)
                            {
                                macro_delete(macro);
                                macro_parameters_delete(p_macro_parameter);
                                goto _CKL0;/*throw*/
                            }
                            p_macro_parameter->name = temp2;
                            macro->parameters = p_macro_parameter;
                            match_token_level(&r, input_list, 3026478, level, ctx);
                            skip_blanks_level(ctx, &r, input_list, level);
                            match_token_level(&r, input_list, 41, level, ctx);
                        }
                        else
                        {
                            if (input_list->head->type == 41)
                            {
                                match_token_level(&r, input_list, 41, level, ctx);
                                skip_blanks_level(ctx, &r, input_list, level);
                            }
                            else
                            {
                                struct token_list  r3;

                                r3 = identifier_list(ctx, macro, input_list, level);
                                token_list_append_list(&r, &r3);
                                token_list_destroy(&r3);
                                skip_blanks_level(ctx, &r, input_list, level);
                                if (input_list->head == 0U)
                                {
                                    macro_delete(macro);
                                    pre_unexpected_end_of_file(r.tail, ctx);
                                    goto _CKL0;/*throw*/
                                }
                                if (input_list->head->type == 3026478)
                                {
                                    struct macro_parameter * p_macro_parameter;
                                    char * temp3;
                                    struct macro_parameter * p_last;

                                    p_macro_parameter = calloc(1, 20U);
                                    if (p_macro_parameter == 0U)
                                    {
                                        macro_delete(macro);
                                        goto _CKL0;/*throw*/
                                    }
                                    temp3 = strdup("__VA_ARGS__");
                                    if (temp3 == 0U)
                                    {
                                        macro_delete(macro);
                                        macro_parameters_delete(p_macro_parameter);
                                        goto _CKL0;/*throw*/
                                    }
                                    p_macro_parameter->name = temp3;
                                    p_last = macro->parameters;
                                    ;
                                    while (p_last->next)
                                    {
                                        p_last = p_last->next;
                                    }
                                    p_last->next = p_macro_parameter;
                                    match_token_level(&r, input_list, 3026478, level, ctx);
                                }
                                skip_blanks_level(ctx, &r, input_list, level);
                                match_token_level(&r, input_list, 41, level, ctx);
                            }
                        }
                    }
                    else
                    {
                        macro->is_function = 0;
                    }
                    skip_blanks_level(ctx, &r, input_list, level);
                    if (input_list->head == 0U)
                    {
                        macro_delete(macro);
                        pre_unexpected_end_of_file(r.tail, ctx);
                        goto _CKL0;/*throw*/
                    }
                    r4 = replacement_list(ctx, macro, input_list, level);
                    token_list_append_list(&r, &r4);
                    token_list_destroy(&r4);
                    match_token_level(&r, input_list, 10, level, ctx);
                    if (!ctx->options.disable_assert && strcmp(macro->name, "assert") == 0)
                    {
                        if (!is_empty_assert(&macro->replacement_list))
                        {
                            struct macro_parameter * p_macro_parameter;
                            char * temp2;
                            struct tokenizer_ctx  tctx;

                            macro_parameters_delete(macro->parameters);
                            p_macro_parameter = calloc(1, 20U);
                            if (p_macro_parameter == 0U)
                            {
                                macro_delete(macro);
                                goto _CKL0;/*throw*/
                            }
                            temp2 = strdup("__VA_ARGS__");
                            if (temp2 == 0U)
                            {
                                macro_delete(macro);
                                macro_parameters_delete(p_macro_parameter);
                                goto _CKL0;/*throw*/
                            }
                            p_macro_parameter->name = temp2;
                            macro->parameters = p_macro_parameter;
                            token_list_destroy(&macro->replacement_list);
                            _cake_zmem(&tctx, 696);
                            macro->replacement_list = tokenizer(&tctx, "assert(__VA_ARGS__)", 0U, level, 0);
                        }
                    }
                    naming_convention_macro(ctx, macro_name_token);
                    existing_macro = find_macro(ctx, macro->name);
                    if (existing_macro && !macro_is_same(macro, existing_macro))
                    {
                        preprocessor_diagnostic(1820, ctx, macro->p_name_token, "macro redefinition");
                        preprocessor_diagnostic(63, ctx, existing_macro->p_name_token, "previous definition");
                        macro_delete(macro);
                        goto _CKL0;/*throw*/
                    }
                    _cake_zmem(&item, 32);
                    item.p_macro = macro;
                    hashmap_set(&ctx->macros, macro->name, &item);
                    hash_item_set_destroy(&item);
                }
                else
                {
                    if (strcmp(input_list->head->lexeme, "undef") == 0)
                    {
                        struct macro * macro;

                        match_token_level(&r, input_list, 8996, level, ctx);
                        skip_blanks_level(ctx, &r, input_list, level);
                        if (input_list->head == 0U)
                        {
                            pre_unexpected_end_of_file(r.tail, ctx);
                            goto _CKL0;/*throw*/
                        }
                        macro = (struct macro *)hashmap_remove(&ctx->macros, input_list->head->lexeme, 0U);
                        ;
                        if (macro)
                        {
                            macro_delete(macro);
                            match_token_level(&r, input_list, 8996, level, ctx);
                        }
                        else
                        {
                            match_token_level(&r, input_list, 8996, level, ctx);
                        }
                        skip_blanks_level(ctx, &r, input_list, level);
                        match_token_level(&r, input_list, 10, level, ctx);
                    }
                    else
                    {
                        if (strcmp(input_list->head->lexeme, "line") == 0)
                        {
                            struct token_list  r5;

                            match_token_level(&r, input_list, 8996, level, ctx);
                            r5 = pp_tokens_opt(ctx, input_list, level);
                            token_list_append_list(&r, &r5);
                            token_list_destroy(&r5);
                            match_token_level(&r, input_list, 10, level, ctx);
                        }
                        else
                        {
                            if (strcmp(input_list->head->lexeme, "error") == 0)
                            {
                                struct token_list  r6;

                                ctx->n_warnings++;
                                match_token_level(&r, input_list, 8996, level, ctx);
                                r6 = pp_tokens_opt(ctx, input_list, level);
                                preprocessor_diagnostic(1180, ctx, input_list->head, "#error");
                                token_list_append_list(&r, &r6);
                                token_list_destroy(&r6);
                                match_token_level(&r, input_list, 10, level, ctx);
                            }
                            else
                            {
                                if (strcmp(input_list->head->lexeme, "warning") == 0)
                                {
                                    struct token_list  r6;

                                    ctx->n_warnings++;
                                    match_token_level(&r, input_list, 8996, level, ctx);
                                    r6 = pp_tokens_opt(ctx, input_list, level);
                                    preprocessor_diagnostic(0, ctx, input_list->head, "#warning");
                                    token_list_append_list(&r, &r6);
                                    match_token_level(&r, input_list, 10, level, ctx);
                                    token_list_destroy(&r6);
                                }
                                else
                                {
                                    if (strcmp(input_list->head->lexeme, "pragma") == 0)
                                    {
                                        struct token_list  r7;

                                        match_token_level(&r, input_list, 8996, level, ctx);
                                        if (r.tail)
                                        {
                                            r.tail->type = 128;
                                            r.tail->flags |= 1;
                                        }
                                        skip_blanks_level(ctx, &r, input_list, level);
                                        if (input_list->head == 0U)
                                        {
                                            pre_unexpected_end_of_file(r.tail, ctx);
                                            goto _CKL0;/*throw*/
                                        }
                                        if (input_list->head->type == 8996)
                                        {
                                            if (strcmp(input_list->head->lexeme, "CAKE") == 0)
                                            {
                                                match_token_level(&r, input_list, 8996, level, ctx);
                                                if (r.tail)
                                                {
                                                    r.tail->flags |= 1;
                                                }
                                                skip_blanks_level(ctx, &r, input_list, level);
                                            }
                                            if (input_list->head == 0U)
                                            {
                                                pre_unexpected_end_of_file(r.tail, ctx);
                                                goto _CKL0;/*throw*/
                                            }
                                            if (strcmp(input_list->head->lexeme, "once") == 0)
                                            {
                                                pragma_once_add(ctx, input_list->head->token_origin->lexeme);
                                                match_token_level(&r, input_list, 8996, level, ctx);
                                                if (r.tail)
                                                {
                                                    r.tail->flags |= 1;
                                                }
                                            }
                                            else
                                            {
                                                if (strcmp(input_list->head->lexeme, "dir") == 0)
                                                {
                                                    char path[200];

                                                    match_token_level(&r, input_list, 8996, level, ctx);
                                                    skip_blanks_level(ctx, &r, input_list, level);
                                                    if (input_list->head == 0U)
                                                    {
                                                        pre_unexpected_end_of_file(r.tail, ctx);
                                                        goto _CKL0;/*throw*/
                                                    }
                                                    if (input_list->head->type != 130)
                                                    {
                                                        preprocessor_diagnostic(650, ctx, input_list->head, "expected string");
                                                        goto _CKL0;/*throw*/
                                                    }
                                                    _cake_zmem(&path, 200);
                                                    strncpy(path, input_list->head->lexeme + 1, strlen(input_list->head->lexeme) - 2);
                                                    include_dir_add(&ctx->include_dir, path);
                                                    match_token_level(&r, input_list, 130, level, ctx);
                                                    if (r.tail)
                                                    {
                                                        r.tail->flags |= 1;
                                                    }
                                                }
                                                else
                                                {
                                                    if (strcmp(input_list->head->lexeme, "expand") == 0)
                                                    {
                                                        struct macro * macro;

                                                        match_token_level(&r, input_list, 8996, level, ctx);
                                                        if (r.tail)
                                                        {
                                                            r.tail->flags |= 1;
                                                        }
                                                        skip_blanks_level(ctx, &r, input_list, level);
                                                        if (input_list->head == 0U)
                                                        {
                                                            pre_unexpected_end_of_file(r.tail, ctx);
                                                            goto _CKL0;/*throw*/
                                                        }
                                                        macro = find_macro(ctx, input_list->head->lexeme);
                                                        if (macro)
                                                        {
                                                            macro->expand = 1;
                                                        }
                                                        match_token_level(&r, input_list, 8996, level, ctx);
                                                    }
                                                    else
                                                    {
                                                        if (strcmp(input_list->head->lexeme, "nullchecks") == 0)
                                                        {
                                                            ;
                                                            match_token_level(&r, input_list, 8996, level, ctx);
                                                            ;
                                                            r.tail->flags |= 1;
                                                            skip_blanks_level(ctx, &r, input_list, level);
                                                            ctx->options.null_checks_enabled = 1;
                                                        }
                                                    }
                                                }
                                            }
                                            if (input_list->head == 0U)
                                            {
                                                pre_unexpected_end_of_file(r.tail, ctx);
                                                goto _CKL0;/*throw*/
                                            }
                                            if (strcmp(input_list->head->lexeme, "diagnostic") == 0)
                                            {
                                                match_token_level(&r, input_list, 8996, level, ctx);
                                                ;
                                                r.tail->flags |= 1;
                                                skip_blanks_level(ctx, &r, input_list, level);
                                                if (input_list->head == 0U)
                                                {
                                                    pre_unexpected_end_of_file(r.tail, ctx);
                                                    goto _CKL0;/*throw*/
                                                }
                                                if (strcmp(input_list->head->lexeme, "push") == 0)
                                                {
                                                    match_token_level(&r, input_list, 8996, level, ctx);
                                                    ;
                                                    r.tail->flags |= 1;
                                                    if (ctx->options.diagnostic_stack.top_index < 10U)
                                                    {
                                                        ctx->options.diagnostic_stack.top_index++;
                                                        ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index] = ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index - 1];
                                                    }
                                                }
                                                else
                                                {
                                                    if (strcmp(input_list->head->lexeme, "pop") == 0)
                                                    {
                                                        match_token_level(&r, input_list, 8996, level, ctx);
                                                        ;
                                                        r.tail->flags |= 1;
                                                        if (ctx->options.diagnostic_stack.top_index > 0)
                                                        {
                                                            ctx->options.diagnostic_stack.top_index--;
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if (strcmp(input_list->head->lexeme, "warning") == 0)
                                                        {
                                                            match_token_level(&r, input_list, 8996, level, ctx);
                                                            ;
                                                            r.tail->flags |= 1;
                                                            skip_blanks_level(ctx, &r, input_list, level);
                                                            if (input_list->head && input_list->head->type == 130)
                                                            {
                                                                unsigned long long w;

                                                                match_token_level(&r, input_list, 130, level, ctx);
                                                                ;
                                                                r.tail->flags |= 1;
                                                                w = get_warning_bit_mask(input_list->head->lexeme + 1 + 2);
                                                                ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings |= w;
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if (strcmp(input_list->head->lexeme, "ignore") == 0)
                                                            {
                                                                match_token_level(&r, input_list, 8996, level, ctx);
                                                                ;
                                                                r.tail->flags |= 1;
                                                                skip_blanks_level(ctx, &r, input_list, level);
                                                                if (input_list->head && input_list->head->type == 130)
                                                                {
                                                                    unsigned long long w;

                                                                    w = get_warning_bit_mask(input_list->head->lexeme + 1 + 2);
                                                                    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings &= ~w;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        r7 = pp_tokens_opt(ctx, input_list, level);
                                        token_list_append_list(&r, &r7);
                                        match_token_level(&r, input_list, 10, level, ctx);
                                        ;
                                        r.tail->type = 129;
                                        r.tail->flags |= 1;
                                        token_list_destroy(&r7);
                                    }
                                    else
                                    {
                                        if (input_list->head->type == 10)
                                        {
                                            skip_blanks_level(ctx, &r, input_list, level);
                                            match_token_level(&r, input_list, 10, level, ctx);
                                        }
                                        else
                                        {
                                            preprocessor_diagnostic(970, ctx, input_list->head, "unexpected\n");
                                            goto _CKL0;/*throw*/
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

static struct token_list non_directive(struct preprocessor_ctx * ctx, struct token_list * input_list, int level)
{
    struct token_list  r;

    r = pp_tokens_opt(ctx, input_list, level);
    skip_blanks_level(ctx, &r, input_list, level);
    match_token_level(&r, input_list, 10, level, ctx);
    return r;
}

static struct macro_argument_list collect_macro_arguments(struct preprocessor_ctx * ctx, struct macro * macro, struct token_list * input_list, int level)
{
    struct macro_argument_list  macro_argument_list;

    _cake_zmem(&macro_argument_list, 16);
    if (1) /*try*/
    {
        struct token * macro_name_token;
        int count;
        struct macro_parameter * p_current_parameter;
        struct macro_argument * p_argument;

        if (input_list->head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        ;
        macro_name_token = input_list->head;
        match_token_level(&macro_argument_list.tokens, input_list, 8996, level, ctx);
        if (!macro->is_function)
        {
            return macro_argument_list;
        }
        count = 1;
        skip_blanks(ctx, &macro_argument_list.tokens, input_list);
        match_token_level(&macro_argument_list.tokens, input_list, 40, level, ctx);
        skip_blanks(ctx, &macro_argument_list.tokens, input_list);
        if (input_list->head == 0U)
        {
            pre_unexpected_end_of_file(macro_argument_list.tokens.tail, ctx);
            goto _CKL0;/*throw*/
        }
        if (input_list->head->type == 41)
        {
            if (macro->parameters != 0U)
            {
                struct macro_argument * p_argument;
                struct macro_parameter * p_current_parameter;

                p_argument = calloc(1, 16U);
                if (p_argument == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_current_parameter = macro->parameters;
                p_argument->macro_parameter = p_current_parameter;
                argument_list_add(&macro_argument_list, p_argument);
            }
            match_token_level(&macro_argument_list.tokens, input_list, 41, level, ctx);
            return macro_argument_list;
        }
        if (macro->parameters == 0U)
        {
            preprocessor_diagnostic(1191, ctx, macro_name_token, "too many arguments provided to function-like macro invocation\n");
            goto _CKL0;/*throw*/
        }
        p_current_parameter = macro->parameters;
        p_argument = calloc(1, 16U);
        if (p_argument == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_argument->macro_parameter = p_current_parameter;
        while (input_list->head != 0U)
        {
            if (input_list->head->type == 40)
            {
                count++;
                token_list_clone_and_add(&p_argument->tokens, input_list->head);
                match_token_level(&macro_argument_list.tokens, input_list, 40, level, ctx);
            }
            else
            {
                if (input_list->head->type == 41)
                {
                    count--;
                    if (count == 0)
                    {
                        match_token_level(&macro_argument_list.tokens, input_list, 41, level, ctx);
                        argument_list_add(&macro_argument_list, p_argument);
                        p_argument = 0U;
                        if (p_current_parameter->next != 0U)
                        {
                            p_current_parameter = p_current_parameter->next;
                            if (strcmp(p_current_parameter->name, "__VA_ARGS__") == 0)
                            {
                                p_argument = calloc(1, 16U);
                                if (p_argument == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                                p_argument->macro_parameter = p_current_parameter;
                                argument_list_add(&macro_argument_list, p_argument);
                                p_argument = 0U;
                            }
                            else
                            {
                                preprocessor_diagnostic(1190, ctx, macro_name_token, "too few arguments provided to function-like macro invocation\n");
                                goto _CKL0;/*throw*/
                            }
                        }
                        break;
                    }
                    else
                    {
                        token_list_clone_and_add(&p_argument->tokens, input_list->head);
                        match_token_level(&macro_argument_list.tokens, input_list, 41, level, ctx);
                    }
                }
                else
                {
                    if (count == 1 && input_list->head->type == 44)
                    {
                        if (strcmp(p_current_parameter->name, "__VA_ARGS__") == 0)
                        {
                            token_list_clone_and_add(&p_argument->tokens, input_list->head);
                            match_token_level(&macro_argument_list.tokens, input_list, 44, level, ctx);
                        }
                        else
                        {
                            match_token_level(&macro_argument_list.tokens, input_list, 44, level, ctx);
                            argument_list_add(&macro_argument_list, p_argument);
                            p_argument = 0U;
                            p_argument = calloc(1, 16U);
                            if (p_argument == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (p_current_parameter->next == 0U)
                            {
                                preprocessor_diagnostic(1191, ctx, macro_argument_list.tokens.tail, "too many arguments provided to function-like macro invocation\n");
                                macro_argument_delete(p_argument);
                                p_argument = 0U;
                                goto _CKL0;/*throw*/
                            }
                            p_current_parameter = p_current_parameter->next;
                            p_argument->macro_parameter = p_current_parameter;
                        }
                    }
                    else
                    {
                        token_list_clone_and_add(&p_argument->tokens, input_list->head);
                        prematch_level(&macro_argument_list.tokens, input_list, level);
                    }
                }
            }
        }
        ;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return macro_argument_list;
}

static struct token_list concatenate(struct preprocessor_ctx * ctx, struct token_list * input_list)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        while (input_list->head)
        {
            if (input_list->head->type == 8995)
            {
                struct osstream  ss;
                int level;
                struct tokenizer_ctx  tctx;
                struct token_list  newlist;

                if (r.tail == 0U)
                {
                    preprocessor_diagnostic(1210, ctx, input_list->head, "missing macro argument (should be checked before)");
                    break;
                }
                token_list_pop_front(input_list);
                _cake_zmem(&ss, 12);
                if (r.tail->lexeme[0] != 0)
                {
                    ss_fprintf(&ss, "%s", r.tail->lexeme);
                }
                if (input_list->head && input_list->head->lexeme[0] != 0)
                {
                    ss_fprintf(&ss, "%s", input_list->head->lexeme);
                }
                level = input_list->head ? input_list->head->level : 0;
                token_list_pop_front(input_list);
                _cake_zmem(&tctx, 696);
                _cake_zmem(&newlist, 8);
                if (ss.c_str != 0U)
                {
                    newlist = tokenizer(&tctx, ss.c_str, 0U, level, 0);
                }
                if (newlist.head)
                {
                    newlist.head->flags = r.tail->flags;
                }
                else
                {
                    struct token * p_new_token;
                    char * temp;

                    p_new_token = calloc(1, 40U);
                    if (p_new_token == 0U)
                    {
                        ss_close(&ss);
                        goto _CKL0;/*throw*/
                    }
                    temp = strdup("");
                    if (temp == 0U)
                    {
                        ss_close(&ss);
                        token_delete(p_new_token);
                        goto _CKL0;/*throw*/
                    }
                    p_new_token->lexeme = temp;
                    p_new_token->type = 142;
                    token_list_add(&newlist, p_new_token);
                    ;
                    newlist.head->flags = r.tail->flags;
                }
                token_list_pop_back(&r);
                token_list_append_list(&r, &newlist);
                ss_close(&ss);
                token_list_destroy(&newlist);
                if (input_list->head == 0U)
                {
                    break;
                }
            }
            else
            {
                prematch(&r, input_list);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list replacement_list_reexamination(struct preprocessor_ctx * ctx, struct macro_expanded * p_list, struct token_list * oldlist, int level, struct token * origin);

static unsigned char  has_argument_list_empty_substitution(struct preprocessor_ctx * ctx, struct macro_expanded * p_list, struct macro_argument_list * p_macro_argument_list, struct token * origin)
{
    struct macro_argument * p_va_args_argument;

    if (p_macro_argument_list->head == 0U)
    {
        return 1;
    }
    p_va_args_argument = find_macro_argument_by_name(p_macro_argument_list, "__VA_ARGS__");
    if (p_va_args_argument)
    {
        struct token_list  argumentlist;
        struct token_list  r4;
        unsigned char   results_in_empty_substituition;

        if (p_va_args_argument->tokens.head == 0U)
        {
            return 1;
        }
        argumentlist = copy_argument_list(p_va_args_argument);
        r4 = replacement_list_reexamination(ctx, p_list, &argumentlist, 0, origin);
        results_in_empty_substituition = !!((r4.head == 0U || r4.head->type == 142));
        token_list_destroy(&r4);
        token_list_destroy(&argumentlist);
        return results_in_empty_substituition;
    }
    return 0;
}

static struct token_list replace_macro_arguments(struct preprocessor_ctx * ctx, struct macro_expanded * p_list, struct token_list * input_list, struct macro_argument_list * arguments, struct token * origin)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct macro_argument * p;

        p = arguments->head;
        while (p)
        {
            struct macro_argument * next;

            next = p->next;
            if (p->macro_parameter)
            {
                p->macro_parameter->already_expanded = 0;
                token_list_clear(&p->macro_parameter->expanded_list);
            }
            p = next;
        }
        while (input_list->head)
        {
            struct macro_argument * p_argument;

            ;
            ;
            ;
            p_argument = 0U;
            if (input_list->head->type == 8996)
            {
                if (strcmp(input_list->head->lexeme, "__VA_OPT__") == 0)
                {
                    int parenteses_count;
                    unsigned char   discard_va_opt;

                    token_list_pop_front(input_list);
                    token_list_pop_front(input_list);
                    parenteses_count = 1;
                    discard_va_opt = has_argument_list_empty_substitution(ctx, p_list, arguments, origin);
                    if (discard_va_opt)
                    {
                        while (input_list->head)
                        {
                            if (input_list->head->type == 40)
                            {
                                parenteses_count++;
                            }
                            else
                            {
                                if (input_list->head->type == 41)
                                {
                                    parenteses_count--;
                                }
                            }
                            token_list_pop_front(input_list);
                            if (parenteses_count == 0)
                            {
                                break;
                            }
                        }
                    }
                    else
                    {
                        struct token * p_token;

                        p_token = input_list->head;
                        for (; p_token; p_token = p_token->next)
                        {
                            if (p_token->type == 40)
                            {
                                parenteses_count++;
                            }
                            else
                            {
                                if (p_token->type == 41)
                                {
                                    parenteses_count--;
                                }
                            }
                            if (parenteses_count == 0)
                            {
                                break;
                            }
                        }
                        token_list_remove(input_list, p_token, p_token);
                    }
                    continue;
                }
                p_argument = find_macro_argument_by_name(arguments, input_list->head->lexeme);
            }
            if (p_argument)
            {
                if (r.tail != 0U && r.tail->type == 35)
                {
                    int flags;
                    struct token_list  argumentlist;
                    char * s;
                    struct token * p_new_token;

                    flags = r.tail->flags;
                    token_list_pop_front(input_list);
                    while (token_is_blank(r.tail))
                    {
                        token_list_pop_back(&r);
                    }
                    token_list_pop_back(&r);
                    argumentlist = copy_argument_list(p_argument);
                    s = token_list_join_tokens(&argumentlist, 1);
                    if (s == 0U)
                    {
                        token_list_destroy(&argumentlist);
                        preprocessor_diagnostic(650, ctx, input_list->head, "unexpected");
                        goto _CKL0;/*throw*/
                    }
                    p_new_token = calloc(1, 40U);
                    if (p_new_token == 0U)
                    {
                        free(s);
                        token_list_destroy(&argumentlist);
                        goto _CKL0;/*throw*/
                    }
                    p_new_token->lexeme = s;
                    p_new_token->type = 130;
                    p_new_token->flags = flags;
                    token_list_add(&r, p_new_token);
                    token_list_destroy(&argumentlist);
                    continue;
                }
                else
                {
                    if (r.tail != 0U && r.tail->type == 8995)
                    {
                        struct token_list  argumentlist;

                        token_list_pop_front(input_list);
                        argumentlist = copy_argument_list(p_argument);
                        token_list_append_list(&r, &argumentlist);
                        token_list_destroy(&argumentlist);
                    }
                    else
                    {
                        if (input_list->head->next && input_list->head->next->type == 8995)
                        {
                            int flags;
                            struct token_list  argumentlist;

                            flags = input_list->head->flags;
                            token_list_pop_front(input_list);
                            argumentlist = copy_argument_list(p_argument);
                            if (argumentlist.head != 0U)
                            {
                                argumentlist.head->flags = flags;
                            }
                            token_list_append_list(&r, &argumentlist);
                            prematch(&r, input_list);
                            token_list_destroy(&argumentlist);
                        }
                        else
                        {
                            int flags;
                            struct token_list  copy_list;

                            flags = input_list->head->flags;
                            token_list_pop_front(input_list);
                            if (p_argument->macro_parameter == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (!p_argument->macro_parameter->already_expanded)
                            {
                                struct token_list  copy_list;
                                struct token_list  r4;

                                copy_list = copy_argument_list(p_argument);
                                r4 = replacement_list_reexamination(ctx, p_list, &copy_list, 0, origin);
                                token_list_swap(&p_argument->macro_parameter->expanded_list, &r4);
                                token_list_destroy(&r4);
                                p_argument->macro_parameter->already_expanded = 1;
                            }
                            copy_list = copy_argument_list_tokens(&p_argument->macro_parameter->expanded_list);
                            if (copy_list.head)
                            {
                                copy_list.head->flags = flags;
                            }
                            token_list_append_list(&r, &copy_list);
                            token_list_destroy(&copy_list);
                            if (ctx->n_errors > 0)
                            {
                                goto _CKL0;/*throw*/
                            }
                        }
                    }
                }
            }
            else
            {
                prematch(&r, input_list);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

static unsigned char  macro_already_expanded(struct macro_expanded * p_list, char * name)
{
    struct macro_expanded * p_item;

    p_item = p_list;
    while (p_item)
    {
        if (strcmp(name, p_item->name) == 0)
        {
            return 1;
        }
        p_item = p_item->p_previous;
    }
    return 0;
}

struct token_list expand_macro(struct preprocessor_ctx * ctx, struct macro_expanded * p_list, struct macro * macro, struct macro_argument_list * arguments, int level, struct token * origin);

struct token_list replacement_list_reexamination(struct preprocessor_ctx * ctx, struct macro_expanded * p_list, struct token_list * oldlist, int level, struct token * origin)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct token_list  new_list;

        new_list = concatenate(ctx, oldlist);
        while (new_list.head != 0U)
        {
            struct macro * macro;

            macro = 0U;
            if (new_list.head->type == 8996)
            {
                macro = find_macro(ctx, new_list.head->lexeme);
                if (macro && macro->is_function && !preprocessor_token_ahead_is(new_list.head, 40))
                {
                    macro = 0U;
                }
                if (macro && macro_already_expanded(p_list, new_list.head->lexeme))
                {
                    new_list.head->type = 8997;
                    macro = 0U;
                }
                if (ctx->conditional_inclusion)
                {
                    if (r.tail && r.tail->type == 8996 && strcmp(r.tail->lexeme, "defined") == 0)
                    {
                        macro = 0U;
                    }
                    else
                    {
                        if (r.tail && r.tail->type == 40)
                        {
                            struct token * previous;

                            previous = r.tail->prev;
                            if (previous != 0U && previous->type == 8996 && strcmp(previous->lexeme, "defined") == 0)
                            {
                                macro = 0U;
                            }
                        }
                    }
                }
            }
            if (macro)
            {
                int flags;
                struct macro_argument_list  arguments;
                struct token_list  r3;

                flags = new_list.head->flags;
                arguments = collect_macro_arguments(ctx, macro, &new_list, level);
                if (ctx->n_errors > 0)
                {
                    macro_argument_list_destroy(&arguments);
                    token_list_destroy(&new_list);
                    goto _CKL0;/*throw*/
                }
                r3 = expand_macro(ctx, p_list, macro, &arguments, level, origin);
                if (ctx->n_errors > 0)
                {
                    token_list_destroy(&new_list);
                    token_list_destroy(&r3);
                    macro_argument_list_destroy(&arguments);
                    goto _CKL0;/*throw*/
                }
                if (r3.head)
                {
                    r3.head->flags = flags;
                }
                token_list_append_list_at_beginning(&new_list, &r3);
                macro_argument_list_destroy(&arguments);
                token_list_destroy(&r3);
            }
            else
            {
                new_list.head->level = level;
                new_list.head->flags |= 2;
                prematch(&r, &new_list);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

int lexeme_cmp(char * s1, char * s2)
{
    while (*s1 && *s2)
    {
        while ((s1[0] == 92 && s1[1] == 10))
        {
            s1++;
            s1++;
        }
        while (s2[0] == 92 && s2[1] == 10)
        {
            s2++;
            s2++;
        }
        if (*s1 != *s2)
        {
            break;
        }
        s1++;
        s2++;
    }
    while ((s1[0] == 92 && s1[1] == 10))
    {
        s1++;
        s1++;
    }
    while (s2[0] == 92 && s2[1] == 10)
    {
        s2++;
        s2++;
    }
    return *(unsigned char *)s1 - *(unsigned char *)s2;
}

void remove_line_continuation(char * s)
{
    char * pread;
    char * pwrite;

    pread = s;
    pwrite = s;
    while (*pread)
    {
        if (pread[0] == 92 && (pread[1] == 10 || (pread[1] == 13 && pread[2] == 10)))
        {
            if (pread[1] == 13 && pread[2] == 10)
            {
                pread++;
                pread++;
                pread++;
            }
            else
            {
                pread++;
                pread++;
            }
        }
        else
        {
            *pwrite = *pread;
            pread++;
            pwrite++;
        }
    }
    *pwrite = *pread;
}

struct token_list copy_replacement_list_core(struct preprocessor_ctx * ctx, struct token_list * list, unsigned char   new_line_is_space)
{
    struct token_list  r;
    struct token * current;
    unsigned char   is_first;

    _cake_zmem(&r, 8);
    current = list->head;
    if (!new_line_is_space)
    {
        while (current && token_is_blank(current))
        {
            current = current->next;
        }
    }
    else
    {
        while (current && (token_is_blank(current) || current->type == 10))
        {
            current = current->next;
        }
    }
    is_first = 1;
    for (; current; )
    {
        struct token * token_added;

        if (!new_line_is_space)
        {
            if (current && token_is_blank(current))
            {
                if (current == list->tail)
                {
                    break;
                }
                current = current->next;
                continue;
            }
        }
        else
        {
            if (current && (token_is_blank(current) || current->type == 10))
            {
                if (current == list->tail)
                {
                    break;
                }
                current = current->next;
                continue;
            }
        }
        token_added = token_list_clone_and_add(&r, current);
        if (!ctx->options.preprocess_def_macro && token_added->type == 127)
        {
            token_added->type = 35;
            free(token_added->lexeme);
            token_added->lexeme = strdup("#");
        }
        if (token_added->flags & 8)
        {
            token_added->flags = token_added->flags & -9;
            token_added->flags |= 4;
        }
        if (is_first)
        {
            token_added->flags = token_added->flags & -5;
            token_added->flags = token_added->flags & -9;
            is_first = 0;
        }
        remove_line_continuation(token_added->lexeme);
        if (current == list->tail)
        {
            break;
        }
        current = current->next;
    }
    return r;
}

struct token_list copy_replacement_list(struct preprocessor_ctx * ctx, struct token_list * list)
{
    return copy_replacement_list_core(ctx, list, !ctx->options.preprocess_def_macro);
}

int stringify(char * input, int n, char output[]);

struct token_list macro_copy_replacement_list(struct preprocessor_ctx * ctx, struct macro * macro, struct token * origin)
{
    if (strcmp(macro->name, "__LINE__") == 0)
    {
        struct tokenizer_ctx  tctx;
        char line[50];
        struct token_list  r;

        _cake_zmem(&tctx, 696);
        _cake_zmem(&line, 50);
        ;
        snprintf(line, 50U, "%d", origin->line);
        r = tokenizer(&tctx, line, "", 0, 0);
        token_list_pop_front(&r);
        if (r.head != 0U)
        {
            r.head->flags = 0;
        }
        return r;
    }
    else
    {
        if (strcmp(macro->name, "__FILE__") == 0)
        {
            char buffer[300];
            struct tokenizer_ctx  tctx;
            struct token_list  r;

            _cake_zmem(&buffer, 300);
            if (stringify(origin->token_origin->lexeme, 300U, buffer) < 0)
            {
            }
            _cake_zmem(&tctx, 696);
            r = tokenizer(&tctx, buffer, "", 0, 0);
            token_list_pop_front(&r);
            if (r.head)
            {
                r.head->flags = 0;
            }
            return r;
        }
        else
        {
            if (strcmp(macro->name, "__COUNTER__") == 0)
            {
                char line[50];
                struct tokenizer_ctx  tctx;
                struct token_list  r;

                _cake_zmem(&line, 50);
                snprintf(line, 50U, "%d", ctx->count_macro_value);
                ctx->count_macro_value++;
                _cake_zmem(&tctx, 696);
                r = tokenizer(&tctx, line, "", 0, 0);
                token_list_pop_front(&r);
                if (r.head != 0U)
                {
                    r.head->flags = 0;
                }
                return r;
            }
        }
    }
    return copy_replacement_list(ctx, &macro->replacement_list);
}

char *print_preprocessed_to_string2(struct token * p_token);

struct token_list expand_macro(struct preprocessor_ctx * ctx, struct macro_expanded * p_list_of_macro_expanded_opt, struct macro * macro, struct macro_argument_list * arguments, int level, struct token * origin)
{
    struct token_list  r;

    macro->usage++;
    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        struct macro_expanded  macro_expanded;

        ;
        _cake_zmem(&macro_expanded, 8);
        macro_expanded.name = macro->name;
        macro_expanded.p_previous = p_list_of_macro_expanded_opt;
        if (macro->is_function)
        {
            struct token_list  copy;
            struct token_list  copy2;
            struct token_list  r2;

            copy = macro_copy_replacement_list(ctx, macro, origin);
            copy2 = replace_macro_arguments(ctx, &macro_expanded, &copy, arguments, origin);
            r2 = replacement_list_reexamination(ctx, &macro_expanded, &copy2, level, origin);
            token_list_append_list(&r, &r2);
            token_list_destroy(&copy);
            token_list_destroy(&copy2);
            token_list_destroy(&r2);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            struct token_list  copy;
            struct token_list  r3;

            copy = macro_copy_replacement_list(ctx, macro, origin);
            r3 = replacement_list_reexamination(ctx, &macro_expanded, &copy, level, origin);
            if (ctx->n_errors > 0)
            {
                token_list_destroy(&copy);
                token_list_destroy(&r3);
                goto _CKL0;/*throw*/
            }
            token_list_append_list(&r, &r3);
            token_list_destroy(&copy);
            token_list_destroy(&r3);
        }
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->options.preprocess_def_macro && macro->def_macro)
        {
            struct token_list  r0;
            struct token_list  list2;
            struct tokenizer_ctx  tctx;
            char * result;
            struct token_list  list3;

            _cake_zmem(&r0, 8);
            token_list_append_list(&r0, &r);
            list2 = preprocessor(ctx, &r0, level + 1);
            _cake_zmem(&tctx, 696);
            result = print_preprocessed_to_string2(list2.head);
            token_list_clear(&r);
            r = tokenizer(&tctx, result, "", 0, 2);
            list3 = copy_replacement_list_core(ctx, &r, 1);
            token_list_swap(&list3, &r);
            free((void *)result);
            token_list_destroy(&list2);
            token_list_destroy(&list3);
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

static struct token_list text_line(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    struct token_list  r;

    _cake_zmem(&r, 8);
    if (1) /*try*/
    {
        while (input_list->head && input_list->head->type != 127)
        {
            struct macro * macro;
            struct token * start_token;
            struct token * origin;

            macro = 0U;
            start_token = input_list->head;
            origin = 0U;
            if (is_active && input_list->head->type == 8996)
            {
                origin = input_list->head;
                macro = find_macro(ctx, input_list->head->lexeme);
                if (macro && macro->is_function && !preprocessor_token_ahead_is(input_list->head, 40))
                {
                    macro = 0U;
                }
                if (ctx->conditional_inclusion)
                {
                    if (r.tail && r.tail->type == 8996 && strcmp(r.tail->lexeme, "defined") == 0)
                    {
                        macro = 0U;
                    }
                    else
                    {
                        if (r.tail && r.tail->type == 40)
                        {
                            struct token * previous;

                            previous = r.tail->prev;
                            if (previous != 0U && previous->type == 8996 && strcmp(previous->lexeme, "defined") == 0)
                            {
                                macro = 0U;
                            }
                        }
                    }
                }
            }
            if (macro)
            {
                int flags;
                struct macro_argument_list  arguments;
                struct token_list  start_macro;

                flags = input_list->head->flags;
                arguments = collect_macro_arguments(ctx, macro, input_list, level);
                if (ctx->n_errors > 0)
                {
                    macro_argument_list_destroy(&arguments);
                    goto _CKL0;/*throw*/
                }
                start_macro = expand_macro(ctx, 0U, macro, &arguments, level, origin);
                if (start_macro.head)
                {
                    start_macro.head->flags |= flags;
                }
                if (macro->expand)
                {
                    {
                        struct token * current;
                        current = arguments.tokens.head;
                        for (; current && current != arguments.tokens.tail->next; current = current->next)
                        {
                            current->flags |= 64;
                        }
                    }
                    {
                        struct token * current;
                        current = start_macro.head;
                        for (; current && current != start_macro.tail->next; current = current->next)
                        {
                            current->flags &= -1539;
                        }
                    }
                }
                token_list_set_file(&start_macro, start_token->token_origin, start_token->line, start_token->col);
                token_list_append_list_at_beginning(input_list, &start_macro);
                if (ctx->flags & 1)
                {
                }
                else
                {
                    if (level == 0 || 1)
                    {
                        token_list_append_list(&r, &arguments.tokens);
                    }
                }
                while (macro)
                {
                    macro = 0U;
                    if (input_list->head && input_list->head->type == 8996)
                    {
                        macro = find_macro(ctx, input_list->head->lexeme);
                        if (macro && macro->is_function && !preprocessor_token_ahead_is(input_list->head, 40))
                        {
                            macro = 0U;
                        }
                        if (macro)
                        {
                            int flags2;
                            struct macro_argument_list  arguments2;
                            struct token_list  r3;

                            flags2 = input_list->head->flags;
                            arguments2 = collect_macro_arguments(ctx, macro, input_list, level);
                            if (ctx->n_errors > 0)
                            {
                                macro_argument_list_destroy(&arguments2);
                                macro_argument_list_destroy(&arguments);
                                token_list_destroy(&start_macro);
                                goto _CKL0;/*throw*/
                            }
                            if (ctx->flags & 1)
                            {
                            }
                            else
                            {
                                if (level == 0 || 1)
                                {
                                    token_list_append_list(&r, &arguments2.tokens);
                                }
                            }
                            r3 = expand_macro(ctx, 0U, macro, &arguments2, level, origin);
                            if (ctx->n_errors > 0)
                            {
                                macro_argument_list_destroy(&arguments2);
                                token_list_destroy(&r3);
                                macro_argument_list_destroy(&arguments);
                                token_list_destroy(&start_macro);
                                goto _CKL0;/*throw*/
                            }
                            token_list_set_file(&r3, start_token->token_origin, start_token->line, start_token->col);
                            if (r3.head)
                            {
                                r3.head->flags = flags2;
                            }
                            token_list_append_list_at_beginning(input_list, &r3);
                            macro_argument_list_destroy(&arguments2);
                            token_list_destroy(&r3);
                        }
                    }
                }
                macro_argument_list_destroy(&arguments);
                token_list_destroy(&start_macro);
                continue;
            }
            else
            {
                unsigned char   blanks;
                unsigned char   is_final;

                if (input_list->head->flags & 1024 && !(input_list->head->flags & 2))
                {
                    if (input_list->head->type == 130)
                    {
                        preprocessor_diagnostic(63, ctx, input_list->head, "you can use \"adjacent\" \"strings\"");
                    }
                    else
                    {
                        if (input_list->head->type == 132)
                        {
                            preprocessor_diagnostic(11, ctx, input_list->head, "multi-line //comment");
                        }
                        else
                        {
                            preprocessor_diagnostic(12, ctx, input_list->head, "unnecessary line-slicing");
                        }
                    }
                }
                blanks = !!(token_is_blank(input_list->head) || input_list->head->type == 10);
                is_final = !!(is_active && !is_never_final(input_list->head->type));
                if (ctx->flags & 1)
                {
                    if (is_final)
                    {
                        prematch(&r, input_list);
                        ;
                        r.tail->flags |= 1;
                    }
                    else
                    {
                        token_list_pop_front(input_list);
                    }
                }
                else
                {
                    if (blanks)
                    {
                        if (level == 0 || 1)
                        {
                            prematch(&r, input_list);
                        }
                        else
                        {
                            token_list_pop_front(input_list);
                        }
                    }
                    else
                    {
                        if (level == 0 || 1)
                        {
                            prematch(&r, input_list);
                            if (is_final)
                            {
                                ;
                                r.tail->flags |= 1;
                            }
                        }
                        else
                        {
                            if (is_final)
                            {
                                prematch(&r, input_list);
                                ;
                                r.tail->flags |= 1;
                            }
                            else
                            {
                                token_list_pop_front(input_list);
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return r;
}

struct token_list group_part(struct preprocessor_ctx * ctx, struct token_list * input_list, unsigned char   is_active, int level)
{
    ;
    if (input_list->head->type == 127)
    {
        if (preprocessor_token_ahead_is_identifier(input_list->head, "if") || preprocessor_token_ahead_is_identifier(input_list->head, "ifdef") || preprocessor_token_ahead_is_identifier(input_list->head, "ifndef"))
        {
            return if_section(ctx, input_list, is_active, level);
        }
        else
        {
            if (preprocessor_token_ahead_is_identifier(input_list->head, "def"))
            {
                return def_section(ctx, input_list, is_active, level);
            }
            else
            {
                if (preprocessor_token_ahead_is_identifier(input_list->head, "include") || preprocessor_token_ahead_is_identifier(input_list->head, "include_next") || preprocessor_token_ahead_is_identifier(input_list->head, "embed") || preprocessor_token_ahead_is_identifier(input_list->head, "define") || preprocessor_token_ahead_is_identifier(input_list->head, "undef") || preprocessor_token_ahead_is_identifier(input_list->head, "warning") || preprocessor_token_ahead_is_identifier(input_list->head, "line") || preprocessor_token_ahead_is_identifier(input_list->head, "error") || preprocessor_token_ahead_is_identifier(input_list->head, "pragma") || preprocessor_token_ahead_is(input_list->head, 10))
                {
                    return control_line(ctx, input_list, is_active, level);
                }
                else
                {
                    if (is_active)
                    {
                        struct token * p_token;
                        char * directive_name;

                        p_token = preprocessor_look_ahead_core(input_list->head);
                        directive_name = p_token ? p_token->lexeme : "";
                        preprocessor_diagnostic(1830, ctx, input_list->head, "invalid preprocessor directive '#%s'\n", directive_name);
                    }
                    return non_directive(ctx, input_list, level);
                }
            }
        }
    }
    return text_line(ctx, input_list, is_active, level);
}

struct token_list preprocessor(struct preprocessor_ctx * ctx, struct token_list * input_list, int level)
{
    struct token_list  r;
    struct token_list  g;

    _cake_zmem(&r, 8);
    if (input_list->head == 0U)
    {
        return r;
    }
    if (input_list->head->type == 8998)
    {
        prematch_level(&r, input_list, 1);
    }
    g = group_opt(ctx, input_list, 1, level);
    token_list_append_list(&r, &g);
    token_list_destroy(&g);
    return r;
}

static void mark_macros_as_used(struct hash_map * map)
{
    if (map->table != 0U)
    {
        {
            int i;
            i = 0;
            for (; i < map->capacity; i++)
            {
                struct map_entry * pentry;

                pentry = map->table[i];
                while (pentry != 0U)
                {
                    struct macro * macro;

                    ;
                    macro = pentry->data.p_macro;
                    macro->usage = 1;
                    pentry = pentry->next;
                }
            }
        }
    }
}

void check_unused_macros(struct hash_map * map)
{
    if (map->table != 0U)
    {
        {
            int i;
            i = 0;
            for (; i < map->capacity; i++)
            {
                struct map_entry * pentry;

                pentry = map->table[i];
                while (pentry != 0U)
                {
                    struct macro * macro;

                    ;
                    macro = pentry->data.p_macro;
                    if (macro->usage == 0)
                    {
                        printf("%s not used\n", macro->name);
                    }
                    pentry = pentry->next;
                }
            }
        }
    }
}

int get_self_path(char * buffer, int maxsize);

int include_config_header(struct preprocessor_ctx * ctx, char * file_name)
{
    char local_cakeconfig_path[260];
    char * str;
    int w;
    struct tokenizer_ctx  tctx;
    struct token_list  l;
    struct token_list  l10;

    _cake_zmem(&local_cakeconfig_path, 260);
    snprintf(local_cakeconfig_path, 260U, "%s", file_name);
    dirname(local_cakeconfig_path);
    snprintf(local_cakeconfig_path, 260U, "%s""/cakeconfig.h", local_cakeconfig_path);
    str = read_file(local_cakeconfig_path, 1);
    while (str == 0U)
    {
        dirname(local_cakeconfig_path);
        dirname(local_cakeconfig_path);
        if (local_cakeconfig_path[0] == 0)
        {
            break;
        }
        str = read_file(local_cakeconfig_path, 1);
    }
    if (str == 0U)
    {
        char executable_path[246];
        char root_cakeconfig_path[260];

        _cake_zmem(&executable_path, 246);
        get_self_path(executable_path, 246U);
        dirname(executable_path);
        _cake_zmem(&root_cakeconfig_path, 260);
        snprintf(root_cakeconfig_path, 260U, "%s""/cakeconfig.h", executable_path);
        str = read_file(root_cakeconfig_path, 1);
    }
    if (str == 0U)
    {
        return 2;
    }
    w = ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings;
    _cake_zmem(&tctx, 696);
    l = tokenizer(&tctx, str, "standard macros inclusion", 0, 0);
    l10 = preprocessor(ctx, &l, 0);
    mark_macros_as_used(&ctx->macros);
    token_list_destroy(&l);
    free(str);
    token_list_destroy(&l10);
    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings = w;
    return 0;
}

static unsigned char  is_builtin_macro(char * name)
{
    if (strcmp(name, "__FILE__") == 0)
    {
        return 1;
    }
    if (strcmp(name, "__CAKE__") == 0)
    {
        return 1;
    }
    return 0;
}


__int64 __cdecl _time64(__int64 * _Time);
inline static __int64 __cdecl time(__int64 * _Time)
{
    return _time64(_Time);
}

struct tm *__cdecl _localtime64(__int64 * _Time);
inline static struct tm *__cdecl localtime(__int64 * _Time)
{
    return _localtime64(_Time);
}
static char __ck_mon2[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};


void add_standard_macros(struct preprocessor_ctx * ctx)
{
    struct diagnostic  w;
    struct diagnostic  __cmp_lt_6;
    __int64 now;
    struct tm * tm;
    struct tokenizer_ctx  tctx;
    char datastr[100];
    struct token_list  l1;
    struct token_list  tl1;
    char timestr[100];
    struct token_list  l2;
    struct token_list  tl2;
    char * pre_defined_macros_text;
    struct token_list  l;
    struct token_list  l10;

    w = ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index];
    __cmp_lt_6.errors = 0;
    __cmp_lt_6.warnings = 0;
    __cmp_lt_6.notes = 0;
    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index] = __cmp_lt_6;
    now = time(0U);
    tm = localtime(&now);
    _cake_zmem(&tctx, 696);
    _cake_zmem(&datastr, 100);
    snprintf(datastr, 100U, "#define __DATE__ \"%s %2d %d\"\n", __ck_mon2[tm->tm_mon], tm->tm_mday, tm->tm_year + 1900);
    l1 = tokenizer(&tctx, datastr, "__DATE__ macro inclusion", 0, 0);
    tl1 = preprocessor(ctx, &l1, 0);
    token_list_destroy(&tl1);
    token_list_destroy(&l1);
    _cake_zmem(&timestr, 100);
    snprintf(timestr, 100U, "#define __TIME__ \"%02d:%02d:%02d\"\n", tm->tm_hour, tm->tm_min, tm->tm_sec);
    l2 = tokenizer(&tctx, timestr, "__TIME__ macro inclusion", 0, 0);
    tl2 = preprocessor(ctx, &l2, 0);
    token_list_destroy(&tl2);
    token_list_destroy(&l2);
    pre_defined_macros_text = "#define __CAKE__ 202311L\n""#define __STDC_VERSION__ 202311L\n""#define __FILE__ \"__FILE__\"\n""#define __LINE__ 0\n""#define __COUNTER__ 0\n""#define _CONSOLE\n""#define __STDC_OWNERSHIP__ 1\n""#define __STDC_NO_ATOMICS__ ""1""\n""#define __STDC_NO_COMPLEX__  ""1""\n""#define __STDC_NO_THREADS__   ""__STDC_NO_THREADS__""\n""#define __STDC_NO_VLA__    ""1""\n""#pragma dir \"c:/\"\n""#define _WIN32 ""1""\n""#define _WIN64 ""\n""#define _INTEGRAL_MAX_BITS ""64""\n""#define _MSC_VER ""1944""\n""#define _M_IX86 ""600""\n""#define __pragma(a)\n";
    "\n";
    l = tokenizer(&tctx, pre_defined_macros_text, "standard macros inclusion", 0, 0);
    l10 = preprocessor(ctx, &l, 0);
    mark_macros_as_used(&ctx->macros);
    token_list_destroy(&l);
    token_list_destroy(&l10);
    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index] = w;
}

char *get_token_name(int tk)
{
    /*switch*/
    {
        register int _R7 = tk;
        if (_R7 == 0) goto _CKL1; /*case 0*/
        if (_R7 == 10) goto _CKL2; /*case 10*/
        if (_R7 == 32) goto _CKL3; /*case 32*/
        if (_R7 == 33) goto _CKL4; /*case 33*/
        if (_R7 == 34) goto _CKL5; /*case 34*/
        if (_R7 == 35) goto _CKL6; /*case 35*/
        if (_R7 == 36) goto _CKL7; /*case 36*/
        if (_R7 == 37) goto _CKL8; /*case 37*/
        if (_R7 == 38) goto _CKL9; /*case 38*/
        if (_R7 == 39) goto _CKL10; /*case 39*/
        if (_R7 == 40) goto _CKL11; /*case 40*/
        if (_R7 == 41) goto _CKL12; /*case 41*/
        if (_R7 == 42) goto _CKL13; /*case 42*/
        if (_R7 == 43) goto _CKL14; /*case 43*/
        if (_R7 == 44) goto _CKL15; /*case 44*/
        if (_R7 == 45) goto _CKL16; /*case 45*/
        if (_R7 == 46) goto _CKL17; /*case 46*/
        if (_R7 == 47) goto _CKL18; /*case 47*/
        if (_R7 == 58) goto _CKL19; /*case 58*/
        if (_R7 == 59) goto _CKL20; /*case 59*/
        if (_R7 == 60) goto _CKL21; /*case 60*/
        if (_R7 == 61) goto _CKL22; /*case 61*/
        if (_R7 == 62) goto _CKL23; /*case 62*/
        if (_R7 == 63) goto _CKL24; /*case 63*/
        if (_R7 == 64) goto _CKL25; /*case 64*/
        if (_R7 == 91) goto _CKL26; /*case 91*/
        if (_R7 == 12079) goto _CKL27; /*case 12079*/
        if (_R7 == 93) goto _CKL28; /*case 93*/
        if (_R7 == 94) goto _CKL29; /*case 94*/
        if (_R7 == 95) goto _CKL30; /*case 95*/
        if (_R7 == 96) goto _CKL31; /*case 96*/
        if (_R7 == 123) goto _CKL32; /*case 123*/
        if (_R7 == 124) goto _CKL33; /*case 124*/
        if (_R7 == 125) goto _CKL34; /*case 125*/
        if (_R7 == 126) goto _CKL35; /*case 126*/
        if (_R7 == 127) goto _CKL36; /*case 127*/
        if (_R7 == 128) goto _CKL37; /*case 128*/
        if (_R7 == 130) goto _CKL38; /*case 130*/
        if (_R7 == 131) goto _CKL39; /*case 131*/
        if (_R7 == 132) goto _CKL40; /*case 132*/
        if (_R7 == 133) goto _CKL41; /*case 133*/
        if (_R7 == 134) goto _CKL42; /*case 134*/
        if (_R7 == 135) goto _CKL43; /*case 135*/
        if (_R7 == 136) goto _CKL44; /*case 136*/
        if (_R7 == 137) goto _CKL45; /*case 137*/
        if (_R7 == 138) goto _CKL46; /*case 138*/
        if (_R7 == 139) goto _CKL47; /*case 139*/
        if (_R7 == 140) goto _CKL48; /*case 140*/
        if (_R7 == 141) goto _CKL49; /*case 141*/
        if (_R7 == 142) goto _CKL50; /*case 142*/
        if (_R7 == 143) goto _CKL51; /*case 143*/
        if (_R7 == 11051) goto _CKL52; /*case 11051*/
        if (_R7 == 11565) goto _CKL53; /*case 11565*/
        if (_R7 == 11582) goto _CKL54; /*case 11582*/
        if (_R7 == 15420) goto _CKL55; /*case 15420*/
        if (_R7 == 15934) goto _CKL56; /*case 15934*/
        if (_R7 == 31868) goto _CKL57; /*case 31868*/
        if (_R7 == 9766) goto _CKL58; /*case 9766*/
        if (_R7 == 8995) goto _CKL59; /*case 8995*/
        if (_R7 == 8996) goto _CKL60; /*case 8996*/
        if (_R7 == 8997) goto _CKL61; /*case 8997*/
        if (_R7 == 8998) goto _CKL62; /*case 8998*/
        if (_R7 == 8999) goto _CKL63; /*case 8999*/
        if (_R7 == 9000) goto _CKL64; /*case 9000*/
        if (_R7 == 9001) goto _CKL65; /*case 9001*/
        if (_R7 == 9002) goto _CKL66; /*case 9002*/
        if (_R7 == 9003) goto _CKL67; /*case 9003*/
        if (_R7 == 9004) goto _CKL68; /*case 9004*/
        if (_R7 == 9005) goto _CKL69; /*case 9005*/
        if (_R7 == 9006) goto _CKL70; /*case 9006*/
        if (_R7 == 9007) goto _CKL71; /*case 9007*/
        if (_R7 == 9008) goto _CKL72; /*case 9008*/
        if (_R7 == 9009) goto _CKL73; /*case 9009*/
        if (_R7 == 9010) goto _CKL74; /*case 9010*/
        if (_R7 == 9011) goto _CKL75; /*case 9011*/
        if (_R7 == 9012) goto _CKL76; /*case 9012*/
        if (_R7 == 9013) goto _CKL77; /*case 9013*/
        if (_R7 == 9014) goto _CKL78; /*case 9014*/
        if (_R7 == 9015) goto _CKL79; /*case 9015*/
        if (_R7 == 9016) goto _CKL80; /*case 9016*/
        if (_R7 == 9017) goto _CKL81; /*case 9017*/
        if (_R7 == 9018) goto _CKL82; /*case 9018*/
        if (_R7 == 9019) goto _CKL83; /*case 9019*/
        if (_R7 == 9020) goto _CKL84; /*case 9020*/
        if (_R7 == 9021) goto _CKL85; /*case 9021*/
        if (_R7 == 9022) goto _CKL86; /*case 9022*/
        if (_R7 == 9023) goto _CKL87; /*case 9023*/
        if (_R7 == 9024) goto _CKL88; /*case 9024*/
        if (_R7 == 9025) goto _CKL89; /*case 9025*/
        if (_R7 == 9026) goto _CKL90; /*case 9026*/
        if (_R7 == 9027) goto _CKL91; /*case 9027*/
        if (_R7 == 9028) goto _CKL92; /*case 9028*/
        if (_R7 == 9029) goto _CKL93; /*case 9029*/
        if (_R7 == 9030) goto _CKL94; /*case 9030*/
        if (_R7 == 9032) goto _CKL95; /*case 9032*/
        if (_R7 == 9033) goto _CKL96; /*case 9033*/
        if (_R7 == 9034) goto _CKL97; /*case 9034*/
        if (_R7 == 9035) goto _CKL98; /*case 9035*/
        if (_R7 == 9036) goto _CKL99; /*case 9036*/
        if (_R7 == 9037) goto _CKL100; /*case 9037*/
        if (_R7 == 9038) goto _CKL101; /*case 9038*/
        if (_R7 == 9039) goto _CKL102; /*case 9039*/
        if (_R7 == 9040) goto _CKL103; /*case 9040*/
        if (_R7 == 9041) goto _CKL104; /*case 9041*/
        if (_R7 == 9042) goto _CKL105; /*case 9042*/
        if (_R7 == 9043) goto _CKL106; /*case 9043*/
        if (_R7 == 9044) goto _CKL107; /*case 9044*/
        if (_R7 == 9045) goto _CKL108; /*case 9045*/
        if (_R7 == 9048) goto _CKL109; /*case 9048*/
        if (_R7 == 9049) goto _CKL110; /*case 9049*/
        if (_R7 == 9050) goto _CKL111; /*case 9050*/
        if (_R7 == 9051) goto _CKL112; /*case 9051*/
        if (_R7 == 9052) goto _CKL113; /*case 9052*/
        if (_R7 == 9053) goto _CKL114; /*case 9053*/
        if (_R7 == 9054) goto _CKL115; /*case 9054*/
        if (_R7 == 9055) goto _CKL116; /*case 9055*/
        if (_R7 == 9056) goto _CKL117; /*case 9056*/
        if (_R7 == 9057) goto _CKL118; /*case 9057*/
        if (_R7 == 9058) goto _CKL119; /*case 9058*/
        if (_R7 == 9059) goto _CKL120; /*case 9059*/
        if (_R7 == 9060) goto _CKL121; /*case 9060*/
        if (_R7 == 9061) goto _CKL122; /*case 9061*/
        if (_R7 == 9062) goto _CKL123; /*case 9062*/
        if (_R7 == 9063) goto _CKL124; /*case 9063*/
        if (_R7 == 9064) goto _CKL125; /*case 9064*/
        if (_R7 == 9065) goto _CKL126; /*case 9065*/
        if (_R7 == 9066) goto _CKL127; /*case 9066*/
        if (_R7 == 9067) goto _CKL128; /*case 9067*/
        if (_R7 == 9068) goto _CKL129; /*case 9068*/
        if (_R7 == 9069) goto _CKL130; /*case 9069*/
        if (_R7 == 9070) goto _CKL131; /*case 9070*/
        if (_R7 == 9071) goto _CKL132; /*case 9071*/
        if (_R7 == 9072) goto _CKL133; /*case 9072*/
        if (_R7 == 9073) goto _CKL134; /*case 9073*/
        if (_R7 == 9074) goto _CKL135; /*case 9074*/
        if (_R7 == 9075) goto _CKL136; /*case 9075*/
        if (_R7 == 9076) goto _CKL137; /*case 9076*/
        if (_R7 == 9077) goto _CKL138; /*case 9077*/
        if (_R7 == 9078) goto _CKL139; /*case 9078*/
        if (_R7 == 9079) goto _CKL140; /*case 9079*/
        if (_R7 == 9080) goto _CKL141; /*case 9080*/
        if (_R7 == 9081) goto _CKL142; /*case 9081*/
        if (_R7 == 9082) goto _CKL143; /*case 9082*/
        if (_R7 == 9083) goto _CKL144; /*case 9083*/
        if (_R7 == 9084) goto _CKL145; /*case 9084*/
        if (_R7 == 9085) goto _CKL146; /*case 9085*/
        if (_R7 == 9086) goto _CKL147; /*case 9086*/
        if (_R7 == 9087) goto _CKL148; /*case 9087*/
        if (_R7 == 9088) goto _CKL149; /*case 9088*/
        if (_R7 == 129) goto _CKL150; /*case 129*/
        if (_R7 == 9031) goto _CKL151; /*case 9031*/
        if (_R7 == 11069) goto _CKL152; /*case 11069*/
        if (_R7 == 11581) goto _CKL153; /*case 11581*/
        if (_R7 == 10813) goto _CKL154; /*case 10813*/
        if (_R7 == 12093) goto _CKL155; /*case 12093*/
        if (_R7 == 9533) goto _CKL156; /*case 9533*/
        if (_R7 == 3947581) goto _CKL157; /*case 3947581*/
        if (_R7 == 4079165) goto _CKL158; /*case 4079165*/
        if (_R7 == 9789) goto _CKL159; /*case 9789*/
        if (_R7 == 31805) goto _CKL160; /*case 31805*/
        if (_R7 == 24125) goto _CKL161; /*case 24125*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return "TK_NONE";
            _CKL2:/*case 10*/ 
            return "TK_NEWLINE";
            _CKL3:/*case 32*/ 
            return "TK_WHITE_SPACE";
            _CKL4:/*case 33*/ 
            return "TK_EXCLAMATION_MARK";
            _CKL5:/*case 34*/ 
            return "TK_QUOTATION_MARK";
            _CKL6:/*case 35*/ 
            return "TK_NUMBER_SIGN";
            _CKL7:/*case 36*/ 
            return "TK_DOLLAR_SIGN";
            _CKL8:/*case 37*/ 
            return "TK_PERCENT_SIGN";
            _CKL9:/*case 38*/ 
            return "TK_AMPERSAND";
            _CKL10:/*case 39*/ 
            return "TK_APOSTROPHE";
            _CKL11:/*case 40*/ 
            return "TK_LEFT_PARENTHESIS";
            _CKL12:/*case 41*/ 
            return "TK_RIGHT_PARENTHESIS";
            _CKL13:/*case 42*/ 
            return "TK_ASTERISK";
            _CKL14:/*case 43*/ 
            return "TK_PLUS_SIGN";
            _CKL15:/*case 44*/ 
            return "TK_COMMA";
            _CKL16:/*case 45*/ 
            return "TK_HYPHEN_MINUS";
            _CKL17:/*case 46*/ 
            return "TK_FULL_STOP";
            _CKL18:/*case 47*/ 
            return "TK_SOLIDUS";
            _CKL19:/*case 58*/ 
            return "TK_COLON";
            _CKL20:/*case 59*/ 
            return "TK_SEMICOLON";
            _CKL21:/*case 60*/ 
            return "TK_LESS_THAN_SIGN";
            _CKL22:/*case 61*/ 
            return "TK_EQUALS_SIGN";
            _CKL23:/*case 62*/ 
            return "TK_GREATER_THAN_SIGN";
            _CKL24:/*case 63*/ 
            return "TK_QUESTION_MARK";
            _CKL25:/*case 64*/ 
            return "TK_COMMERCIAL_AT";
            _CKL26:/*case 91*/ 
            return "TK_LEFT_SQUARE_BRACKET";
            _CKL27:/*case 12079*/ 
            return "TK_REVERSE_SOLIDUS";
            _CKL28:/*case 93*/ 
            return "TK_RIGHT_SQUARE_BRACKET";
            _CKL29:/*case 94*/ 
            return "TK_CIRCUMFLEX_ACCENT";
            _CKL30:/*case 95*/ 
            return "TK_FLOW_LINE";
            _CKL31:/*case 96*/ 
            return "TK_GRAVE_ACCENT";
            _CKL32:/*case 123*/ 
            return "TK_LEFT_CURLY_BRACKET";
            _CKL33:/*case 124*/ 
            return "TK_VERTICAL_LINE";
            _CKL34:/*case 125*/ 
            return "TK_RIGHT_CURLY_BRACKET";
            _CKL35:/*case 126*/ 
            return "TK_TILDE";
            _CKL36:/*case 127*/ 
            return "TK_PREPROCESSOR_LINE";
            _CKL37:/*case 128*/ 
            return "TK_PRAGMA";
            _CKL38:/*case 130*/ 
            return "TK_STRING_LITERAL";
            _CKL39:/*case 131*/ 
            return "TK_CHAR_CONSTANT";
            _CKL40:/*case 132*/ 
            return "TK_LINE_COMMENT";
            _CKL41:/*case 133*/ 
            return "TK_COMMENT";
            _CKL42:/*case 134*/ 
            return "TK_PPNUMBER";
            _CKL43:/*case 135*/ 
            return "ANY_OTHER_PP_TOKEN";
            _CKL44:/*case 136*/ 
            return "TK_COMPILER_DECIMAL_CONSTANT";
            _CKL45:/*case 137*/ 
            return "TK_COMPILER_OCTAL_CONSTANT";
            _CKL46:/*case 138*/ 
            return "TK_COMPILER_HEXADECIMAL_CONSTANT";
            _CKL47:/*case 139*/ 
            return "TK_COMPILER_BINARY_CONSTANT";
            _CKL48:/*case 140*/ 
            return "TK_COMPILER_DECIMAL_FLOATING_CONSTANT";
            _CKL49:/*case 141*/ 
            return "TK_COMPILER_HEXADECIMAL_FLOATING_CONSTANT";
            _CKL50:/*case 142*/ 
            return "TK_PLACEMARKER";
            _CKL51:/*case 143*/ 
            return "TK_BLANKS";
            _CKL52:/*case 11051*/ 
            return "TK_PLUSPLUS";
            _CKL53:/*case 11565*/ 
            return "TK_MINUSMINUS";
            _CKL54:/*case 11582*/ 
            return "TK_ARROW";
            _CKL55:/*case 15420*/ 
            return "TK_SHIFTLEFT";
            _CKL56:/*case 15934*/ 
            return "TK_SHIFTRIGHT";
            _CKL57:/*case 31868*/ 
            return "TK_LOGICAL_OPERATOR_OR";
            _CKL58:/*case 9766*/ 
            return "TK_LOGICAL_OPERATOR_AND";
            _CKL59:/*case 8995*/ 
            return "TK_MACRO_CONCATENATE_OPERATOR";
            _CKL60:/*case 8996*/ 
            return "TK_IDENTIFIER";
            _CKL61:/*case 8997*/ 
            return "TK_IDENTIFIER_RECURSIVE_MACRO";
            _CKL62:/*case 8998*/ 
            return "TK_BEGIN_OF_FILE";
            _CKL63:/*case 8999*/ 
            return "TK_KEYWORD_AUTO";
            _CKL64:/*case 9000*/ 
            return "TK_KEYWORD_BREAK";
            _CKL65:/*case 9001*/ 
            return "TK_KEYWORD_CASE";
            _CKL66:/*case 9002*/ 
            return "TK_KEYWORD_CONSTEXPR";
            _CKL67:/*case 9003*/ 
            return "TK_KEYWORD_CHAR";
            _CKL68:/*case 9004*/ 
            return "TK_KEYWORD_CONST";
            _CKL69:/*case 9005*/ 
            return "TK_KEYWORD_CONTINUE";
            _CKL70:/*case 9006*/ 
            return "TK_KEYWORD_CAKE_CATCH";
            _CKL71:/*case 9007*/ 
            return "TK_KEYWORD_DEFAULT";
            _CKL72:/*case 9008*/ 
            return "TK_KEYWORD_DO";
            _CKL73:/*case 9009*/ 
            return "TK_KEYWORD_DEFER";
            _CKL74:/*case 9010*/ 
            return "TK_KEYWORD_DOUBLE";
            _CKL75:/*case 9011*/ 
            return "TK_KEYWORD_ELSE";
            _CKL76:/*case 9012*/ 
            return "TK_KEYWORD_ENUM";
            _CKL77:/*case 9013*/ 
            return "TK_KEYWORD_EXTERN";
            _CKL78:/*case 9014*/ 
            return "TK_KEYWORD_FLOAT";
            _CKL79:/*case 9015*/ 
            return "TK_KEYWORD_FOR";
            _CKL80:/*case 9016*/ 
            return "TK_KEYWORD_GOTO";
            _CKL81:/*case 9017*/ 
            return "TK_KEYWORD_IF";
            _CKL82:/*case 9018*/ 
            return "TK_KEYWORD_INLINE";
            _CKL83:/*case 9019*/ 
            return "TK_KEYWORD_INT";
            _CKL84:/*case 9020*/ 
            return "TK_KEYWORD_LONG";
            _CKL85:/*case 9021*/ 
            return "TK_KEYWORD_MSVC__INT8";
            _CKL86:/*case 9022*/ 
            return "TK_KEYWORD_MSVC__INT16";
            _CKL87:/*case 9023*/ 
            return "TK_KEYWORD_MSVC__INT32";
            _CKL88:/*case 9024*/ 
            return "TK_KEYWORD_MSVC__INT64";
            _CKL89:/*case 9025*/ 
            return "TK_KEYWORD_REGISTER";
            _CKL90:/*case 9026*/ 
            return "TK_KEYWORD_RESTRICT";
            _CKL91:/*case 9027*/ 
            return "TK_KEYWORD_RETURN";
            _CKL92:/*case 9028*/ 
            return "TK_KEYWORD_SHORT";
            _CKL93:/*case 9029*/ 
            return "TK_KEYWORD_SIGNED";
            _CKL94:/*case 9030*/ 
            return "TK_KEYWORD_SIZEOF";
            _CKL95:/*case 9032*/ 
            return "TK_KEYWORD_STATIC";
            _CKL96:/*case 9033*/ 
            return "TK_KEYWORD_STRUCT";
            _CKL97:/*case 9034*/ 
            return "TK_KEYWORD_SWITCH";
            _CKL98:/*case 9035*/ 
            return "TK_KEYWORD_TYPEDEF";
            _CKL99:/*case 9036*/ 
            return "TK_KEYWORD_CAKE_TRY";
            _CKL100:/*case 9037*/ 
            return "TK_KEYWORD_CAKE_THROW";
            _CKL101:/*case 9038*/ 
            return "TK_KEYWORD_UNION";
            _CKL102:/*case 9039*/ 
            return "TK_KEYWORD_UNSIGNED";
            _CKL103:/*case 9040*/ 
            return "TK_KEYWORD_VOID";
            _CKL104:/*case 9041*/ 
            return "TK_KEYWORD_VOLATILE";
            _CKL105:/*case 9042*/ 
            return "TK_KEYWORD_WHILE";
            _CKL106:/*case 9043*/ 
            return "TK_KEYWORD__ALIGNAS";
            _CKL107:/*case 9044*/ 
            return "TK_KEYWORD__ALIGNOF";
            _CKL108:/*case 9045*/ 
            return "TK_KEYWORD__ATOMIC";
            _CKL109:/*case 9048*/ 
            return "TK_KEYWORD_MSVC__FASTCALL";
            _CKL110:/*case 9049*/ 
            return "TK_KEYWORD_MSVC__STDCALL";
            _CKL111:/*case 9050*/ 
            return "TK_KEYWORD_MSVC__CDECL";
            _CKL112:/*case 9051*/ 
            return "TK_KEYWORD_MSVC__DECLSPEC";
            _CKL113:/*case 9052*/ 
            return "TK_KEYWORD__ASM";
            _CKL114:/*case 9053*/ 
            return "TK_KEYWORD__BOOL";
            _CKL115:/*case 9054*/ 
            return "TK_KEYWORD__COMPLEX";
            _CKL116:/*case 9055*/ 
            return "TK_KEYWORD__DECIMAL128";
            _CKL117:/*case 9056*/ 
            return "TK_KEYWORD__DECIMAL32";
            _CKL118:/*case 9057*/ 
            return "TK_KEYWORD__DECIMAL64";
            _CKL119:/*case 9058*/ 
            return "TK_KEYWORD__GENERIC";
            _CKL120:/*case 9059*/ 
            return "TK_KEYWORD__IMAGINARY";
            _CKL121:/*case 9060*/ 
            return "TK_KEYWORD__NORETURN";
            _CKL122:/*case 9061*/ 
            return "TK_KEYWORD__STATIC_ASSERT";
            _CKL123:/*case 9062*/ 
            return "TK_KEYWORD_ASSERT";
            _CKL124:/*case 9063*/ 
            return "TK_KEYWORD__THREAD_LOCAL";
            _CKL125:/*case 9064*/ 
            return "TK_KEYWORD_TYPEOF";
            _CKL126:/*case 9065*/ 
            return "TK_KEYWORD_TRUE";
            _CKL127:/*case 9066*/ 
            return "TK_KEYWORD_FALSE";
            _CKL128:/*case 9067*/ 
            return "TK_KEYWORD_NULLPTR";
            _CKL129:/*case 9068*/ 
            return "TK_KEYWORD_TYPEOF_UNQUAL";
            _CKL130:/*case 9069*/ 
            return "TK_KEYWORD__BITINT";
            _CKL131:/*case 9070*/ 
            return "TK_KEYWORD_CAKE_OWNER";
            _CKL132:/*case 9071*/ 
            return "TK_KEYWORD__OUT";
            _CKL133:/*case 9072*/ 
            return "TK_KEYWORD__OBJ_OWNER";
            _CKL134:/*case 9073*/ 
            return "TK_KEYWORD_CAKE_VIEW";
            _CKL135:/*case 9074*/ 
            return "TK_KEYWORD_CAKE_OPT";
            _CKL136:/*case 9075*/ 
            return "TK_KEYWORD_CAKE_STATIC_DEBUG";
            _CKL137:/*case 9076*/ 
            return "TK_KEYWORD_CAKE_STATIC_DEBUG_EX";
            _CKL138:/*case 9077*/ 
            return "TK_KEYWORD_STATIC_STATE";
            _CKL139:/*case 9078*/ 
            return "TK_KEYWORD_STATIC_SET";
            _CKL140:/*case 9079*/ 
            return "TK_KEYWORD_IS_POINTER";
            _CKL141:/*case 9080*/ 
            return "TK_KEYWORD_IS_LVALUE";
            _CKL142:/*case 9081*/ 
            return "TK_KEYWORD_IS_CONST";
            _CKL143:/*case 9082*/ 
            return "TK_KEYWORD_IS_OWNER";
            _CKL144:/*case 9083*/ 
            return "TK_KEYWORD_IS_ARRAY";
            _CKL145:/*case 9084*/ 
            return "TK_KEYWORD_IS_FUNCTION";
            _CKL146:/*case 9085*/ 
            return "TK_KEYWORD_IS_SCALAR";
            _CKL147:/*case 9086*/ 
            return "TK_KEYWORD_IS_ARITHMETIC";
            _CKL148:/*case 9087*/ 
            return "TK_KEYWORD_IS_FLOATING_POINT";
            _CKL149:/*case 9088*/ 
            return "TK_KEYWORD_IS_INTEGRAL";
            _CKL150:/*case 129*/ 
            return "TK_PRAGMA_END";
            _CKL151:/*case 9031*/ 
            return "TK_KEYWORD__COUNTOF";
            _CKL152:/*case 11069*/ 
            return "TK_PLUS_ASSIGN";
            _CKL153:/*case 11581*/ 
            return "TK_MINUS_ASSIGN";
            _CKL154:/*case 10813*/ 
            return "TK_MULTI_ASSIGN";
            _CKL155:/*case 12093*/ 
            return "TK_DIV_ASSIGN";
            _CKL156:/*case 9533*/ 
            return "TK_MOD_ASSIGN";
            _CKL157:/*case 3947581*/ 
            return "TK_SHIFT_LEFT_ASSIGN";
            _CKL158:/*case 4079165*/ 
            return "TK_SHIFT_RIGHT_ASSIGN";
            _CKL159:/*case 9789*/ 
            return "TK_AND_ASSIGN";
            _CKL160:/*case 31805*/ 
            return "TK_OR_ASSIGN";
            _CKL161:/*case 24125*/ 
            return "TK_NOT_ASSIGN";
        }
        _CKL0:;
    }
    return "TK_X_MISSING_NAME";
}

int stringify(char * input, int n, char output[])
{
    int count;
    char * p;

    count = 0;
    if (count < n)
    {
        output[count++] = 34;
    }
    p = input;
    while (*p)
    {
        if (*p == 34 || *p == 92)
        {
            if (count < n)
            {
                output[count++] = 92;
            }
            if (count < n)
            {
                output[count++] = *p;
            }
            p++;
        }
        else
        {
            if (count < n)
            {
                output[count++] = *p;
            }
            p++;
        }
    }
    if (count < n)
    {
        output[count++] = 34;
    }
    if (count < n)
    {
        output[count++] = 0;
    }
    if (count >= n)
    {
        return -count;
    }
    return count;
}

void print_literal(char * s)
{
    if (s == 0U)
    {
        printf("\"");
        printf("\"");
        return;
    }
    printf("\"");
    while (*s)
    {
        /*switch*/
        {
            register char _R8 = *s;
            if (_R8 == 10) goto _CKL2; /*case 10*/
            goto _CKL3;/*default*/

            {
                _CKL2:/*case 10*/ 
                printf("\\n");
                goto _CKL1; /*break*/

                _CKL3: /*default*/ 
                printf("%c", *s);
            }
            _CKL1:;
        }
        s++;
    }
    printf("\"");
}

char *get_code_as_we_see_plus_macros(struct token_list * list)
{
    struct osstream  ss;
    struct token * current;
    char * cstr;

    _cake_zmem(&ss, 12);
    current = list->head;
    while (current)
    {
        if (current->level == 0 && current->type != 8998)
        {
            if (current->flags & 2)
            {
                ss_fprintf(&ss, "\x1b[36;1m");
            }
            else
            {
                ss_fprintf(&ss, "\x1b[97m");
            }
            ss_fprintf(&ss, "%s", current->lexeme);
            ss_fprintf(&ss, "\x1b[0m");
        }
        current = current->next;
    }
    cstr = ss.c_str;
    ss.c_str = 0U;
    ss_close(&ss);
    return cstr;
}

void print_code_as_we_see(struct token_list * list, unsigned char   remove_comments)
{
    struct token * current;

    if (list->head == 0U || list->tail == 0U)
    {
        return;
    }
    current = list->head;
    while (current && current != list->tail->next)
    {
        if (current->level == 0 && !(current->flags & 2) && !(current->flags & 64) && current->type != 8998)
        {
            if ((current->flags & 4) && (current->prev != 0U && current->prev->type != 143))
            {
                printf(" ");
            }
            if (remove_comments)
            {
                if (current->type == 132)
                {
                    printf("\n");
                }
                else
                {
                    if (current->type == 133)
                    {
                        printf(" ");
                    }
                    else
                    {
                        printf("%s", current->lexeme);
                    }
                }
            }
            else
            {
                printf("%s", current->lexeme);
            }
        }
        current = current->next;
    }
}

char *get_code_as_we_see(struct token_list * list, unsigned char   remove_comments)
{
    struct osstream  ss;
    struct token * current;
    char * cstr;

    if (list->head == 0U || list->tail == 0U)
    {
        return 0U;
    }
    _cake_zmem(&ss, 12);
    current = list->head;
    while (current && current != list->tail->next)
    {
        if (current->level == 0 && !(current->flags & 2) && !(current->flags & 64) && current->type != 8998)
        {
            if ((current->flags & 4) && (current->prev != 0U && current->prev->type != 143))
            {
                ss_fprintf(&ss, " ");
            }
            if (remove_comments)
            {
                if (current->type == 132)
                {
                    ss_fprintf(&ss, "\n");
                }
                else
                {
                    if (current->type == 133)
                    {
                        ss_fprintf(&ss, " ");
                    }
                    else
                    {
                        ss_fprintf(&ss, "%s", current->lexeme);
                    }
                }
            }
            else
            {
                ss_fprintf(&ss, "%s", current->lexeme);
            }
        }
        current = current->next;
    }
    cstr = ss.c_str;
    ss.c_str = 0U;
    ss_close(&ss);
    return cstr;
}

char *get_code_as_compiler_see(struct token_list * list)
{
    struct osstream  ss;
    struct token * current;

    if (list->head == 0U || list->tail == 0U)
    {
        return 0U;
    }
    _cake_zmem(&ss, 12);
    current = list->head;
    while (current && current != list->tail->next)
    {
        if (!(current->flags & 64) && current->type != 8998 && (current->flags & 1))
        {
            if (current->flags & 4)
            {
                ss_fprintf(&ss, " ");
            }
            if (current->flags & 8)
            {
                ss_fprintf(&ss, "\n");
            }
            if (current->type == 132)
            {
                ss_fprintf(&ss, "\n");
            }
            else
            {
                if (current->type == 133)
                {
                    ss_fprintf(&ss, " ");
                }
                else
                {
                    ss_fprintf(&ss, "%s", current->lexeme);
                }
            }
        }
        current = current->next;
    }
    return ss.c_str;
}

char *print_preprocessed_to_string2(struct token * p_token)
{
    struct osstream  ss;
    struct token * current;

    if (p_token == 0U)
    {
        return strdup("(null)");
    }
    _cake_zmem(&ss, 12);
    current = p_token;
    while (current)
    {
        remove_line_continuation(current->lexeme);
        if (current->flags & 1)
        {
            if (current->level > 0)
            {
                if ((current->flags & 8))
                {
                    ss_fprintf(&ss, "\n");
                }
                else
                {
                    if ((current->flags & 4))
                    {
                        ss_fprintf(&ss, " ");
                    }
                }
            }
            else
            {
                if (current->flags & 2)
                {
                    if ((current->flags & 4))
                    {
                        ss_fprintf(&ss, " ");
                    }
                }
            }
            if (current->lexeme[0] != 0)
            {
                ss_fprintf(&ss, "%s", current->lexeme);
            }
            current = current->next;
        }
        else
        {
            if (current->level == 0)
            {
                if (current->type == 143 || current->type == 10)
                {
                    ss_fprintf(&ss, "%s", current->lexeme);
                }
            }
            current = current->next;
        }
    }
    return ss.c_str;
}

char *print_preprocessed_to_string(struct token * p_token)
{
    struct osstream  ss;
    struct token * current;
    unsigned char   first;

    _cake_zmem(&ss, 12);
    current = p_token;
    while (!(current->flags & 1) || current->type == 143 || current->type == 133 || current->type == 132 || current->type == 10 || current->type == 127)
    {
        current = current->next;
        if (current == 0U)
        {
            return ss.c_str;
        }
    }
    first = 1;
    while (current)
    {
        ;
        if (current->flags & 1)
        {
            if (!first && current->flags & 8)
            {
                ss_fprintf(&ss, "\n");
            }
            else
            {
                if (!first && current->flags & 4)
                {
                    ss_fprintf(&ss, " ");
                }
            }
            if (current->lexeme[0] != 0)
            {
                ss_fprintf(&ss, "%s", current->lexeme);
            }
            first = 0;
            current = current->next;
        }
        else
        {
            current = current->next;
        }
    }
    return ss.c_str;
}

void print_preprocessed(struct token * p_token)
{
    char * s;

    s = print_preprocessed_to_string(p_token);
    if (s)
    {
        printf("%s", s);
        free((void *)s);
    }
}

static unsigned char  is_screaming_case(char * text)
{
    unsigned char   screaming_case;

    screaming_case = 0;
    while (*text)
    {
        if ((*text >= 65 && *text <= 90) || (*text >= 48 && *text <= 57) || (*text == 95))
        {
            screaming_case = 1;
        }
        else
        {
            return 0;
        }
        text++;
    }
    return screaming_case;
}

void print_all_macros(struct preprocessor_ctx * prectx)
{
    {
        int i;
        i = 0;
        for (; i < prectx->macros.capacity; i++)
        {
            struct map_entry * entry;
            struct macro * macro;
            struct token * token;

            entry = prectx->macros.table[i];
            if (entry == 0U)
            {
                continue;
            }
            ;
            macro = entry->data.p_macro;
            printf("#define %s", macro->name);
            if (macro->is_function)
            {
                struct macro_parameter * parameter;

                printf("(");
                parameter = macro->parameters;
                while (parameter)
                {
                    printf("%s", parameter->name);
                    if (parameter->next)
                    {
                        printf(",");
                    }
                    parameter = parameter->next;
                }
                printf(")");
            }
            printf(" ");
            token = macro->replacement_list.head;
            while (token)
            {
                printf("%s", token->lexeme);
                if (token == macro->replacement_list.tail)
                {
                    break;
                }
                token = token->next;
            }
            printf("\n");
        }
    }
}

void naming_convention_macro(struct preprocessor_ctx * ctx, struct token * token)
{
    if (!is_screaming_case(token->lexeme))
    {
        preprocessor_diagnostic(63, ctx, token, "use SCREAMING_CASE for macros");
    }
}

void ss_swap(struct osstream * a, struct osstream * b)
{
    struct osstream  r;

    r = *a;
    *a = *b;
    *b = r;
}

void ss_clear(struct osstream * stream)
{
    if (stream->c_str)
    {
        stream->c_str[0] = 0;
    }
    stream->size = 0;
}

void ss_close(struct osstream * stream)
{
    free(stream->c_str);
}

void *realloc(void * ptr, unsigned int size);
int *__cdecl _errno(void);

static int reserve(struct osstream * stream, int size)
{
    int errorcode;

    errorcode = 0;
    if (size > stream->capacity)
    {
        void * pnew;

        pnew = realloc(stream->c_str, (size + 1) * 1U);
        if (pnew)
        {
            stream->c_str = pnew;
            stream->capacity = size;
            stream->c_str[size] = 0;
        }
        else
        {
            (*_errno()) = 12;
            errorcode = 1;
        }
    }
    return errorcode;
}



inline int __cdecl _vsnprintf_l(char * _Buffer, unsigned int _BufferCount, char * _Format, struct __crt_locale_pointers * _Locale, char * _ArgList)
{
    int _Result;

    _Result = __stdio_common_vsprintf((*__local_stdio_printf_options()) | 1ULL, _Buffer, _BufferCount, _Format, _Locale, _ArgList);
    return _Result < 0 ? -1 : _Result;
}
inline int __cdecl vsprintf(char * _Buffer, char * _Format, char * _ArgList)
{
    return _vsnprintf_l(_Buffer, 4294967295U, _Format, 0U, _ArgList);
}

int ss_vafprintf(struct osstream * stream, char * fmt, char * args)
{
    int size;
    char * tmpa;

    ;
    size = 0;
    _cake_zmem(&tmpa, 4);
    ((tmpa) = (args));
    size = vsnprintf(stream->c_str + stream->size, stream->capacity - stream->size, fmt, tmpa);
    ((void)(tmpa = 0U));
    if (size < 0)
    {
        return -1;
    }
    if (reserve(stream, stream->size + size) != 0)
    {
        return -1;
    }
    size = vsprintf(stream->c_str + stream->size, fmt, args);
    if (size > 0)
    {
        stream->size += size;
    }
    return size;
}

int ss_putc(char ch, struct osstream * stream)
{
    if (reserve(stream, stream->size + 1) != 0)
    {
        return -1;
    }
    stream->c_str[stream->size] = ch;
    stream->size++;
    return ch;
}

int ss_fprintf(struct osstream * stream, char * fmt, ...)
{
    char * args;
    int size;

    _cake_zmem(&args, 4);
    ((void)(args = (char *)(&(fmt)) + 4U));
    size = ss_vafprintf(stream, fmt, args);
    ((void)(args = 0U));
    return size;
}

__declspec(selectany) int _Avx2WmemEnabledWeakValue = 0;
int __cdecl tolower(int _C);

unsigned char  path_is_normalized(char * path)
{
    {
        char * p;
        p = path;
        for (; *p; p++)
        {
            int before;
            int after;

            before = *p;
            after = tolower(*p);
            if (before != after)
            {
                return 0;
            }
            if (after == 92)
            {
                return 0;
            }
        }
    }
    return 1;
}

void path_normalize(char * path)
{
    {
        char * p;
        p = path;
        for (; *p; p++)
        {
            *p = (char)tolower(*p);
            if (*p == 92)
            {
                *p = 47;
            }
        }
    }
}

unsigned char  path_is_absolute(char * path)
{
    char ch;

    ch = (char)tolower(path[0]);
    if (ch >= 97 && ch <= 122)
    {
        if (path[1] == 58 && (path[2] == 92 || path[2] == 47))
        {
            return 1;
        }
    }
    if (path[0] == 92 && path[1] == 92)
    {
        return 1;
    }
    return 0;
}

unsigned char  path_is_relative(char * path)
{
    return !!(!path_is_absolute(path));
}

void *__stdcall FindFirstFileA(char * lpFileName, struct _WIN32_FIND_DATAA * lpFindFileData);
int __stdcall FindClose(void * hFindFile);
int windows_error_to_posix(int i);
unsigned long __stdcall GetLastError(void);

struct TAGDIR *opendir(char * name)
{
    struct _WIN32_FIND_DATAA  fdfile;
    char path[260];
    void * handle;

    ;
    _cake_zmem(&fdfile, 320);
    _cake_zmem(&path, 260);
    strcat(path, name);
    strcat(path, "\\*.*");
    handle = FindFirstFileA(path, &fdfile);
    if (handle != 4294967295U)
    {
        struct TAGDIR * p;

        p = calloc(1, 272U);
        if (p)
        {
            p->handle = handle;
            return p;
        }
        else
        {
            FindClose(handle);
        }
    }
    else
    {
        (*_errno()) = windows_error_to_posix(GetLastError());
    }
    return 0U;
}

int closedir(struct TAGDIR * dirp)
{
    FindClose(dirp->handle);
    free(dirp);
    return 0;
}

int __stdcall FindNextFileA(void * hFindFile, struct _WIN32_FIND_DATAA * lpFindFileData);
void *__cdecl memset(void * _Dst, int _Val, unsigned int _Size);

struct dirent *readdir(struct TAGDIR * dirp)
{
    struct _WIN32_FIND_DATAA  fdfile;
    int b;

    _cake_zmem(&fdfile, 320);
    b = FindNextFileA(dirp->handle, &fdfile);
    if (b)
    {
        memset(&dirp->dirent, 0, 268U);
        if (fdfile.dwFileAttributes & 16)
        {
            dirp->dirent.d_type |= 4;
        }
        strncpy(dirp->dirent.d_name, fdfile.cFileName, 255);
        return &dirp->dirent;
    }
    else
    {
        (*_errno()) = windows_error_to_posix(GetLastError());
    }
    return 0U;
}

char *__cdecl _fullpath(char * _Buffer, char * _Path, unsigned int _BufferCount);

char *realpath(char * path, char * resolved_path)
{
    char * p;

    p = _fullpath(resolved_path, path, 260);
    if (p)
    {
        char * p2;

        p2 = resolved_path;
        while (*p2)
        {
            if (*p2 == 92)
            {
                *p2 = 47;
            }
            p2++;
        }
    }
    return p;
}

unsigned int __cdecl fwrite(void * _Buffer, unsigned int _ElementSize, unsigned int _ElementCount, struct _iobuf * _Stream);

int copy_file(char * pathfrom, char * pathto)
{
    struct _iobuf * fd_from;
    struct _iobuf * fd_to;
    char buf[4096];
    unsigned int nread;

    fd_from = fopen(pathfrom, "rb");
    if (fd_from == 0U)
    {
        return -1;
    }
    fd_to = fopen(pathto, "wb");
    if (fd_to == 0U)
    {
        fclose(fd_from);
        return -1;
    }
    _cake_zmem(&buf, 4096);
    while (nread = fread(buf, 1U, 4096U, fd_from), nread > 0)
    {
        char * out_ptr;
        unsigned int nwritten;

        out_ptr = buf;
        do
        {
            nwritten = fwrite(out_ptr, 1U, nread, fd_to);
            nread -= nwritten;
            out_ptr += nwritten;
        }
        while (nread > 0);
    }
    if (nread == 0)
    {
        fclose(fd_to);
        fclose(fd_from);
        return 0;
    }
    fclose(fd_to);
    fclose(fd_from);
    return -1;
}

int __cdecl _mkdir(char * _Path);

int copy_folder(char * from, char * to)
{
    int errcode;
    struct TAGDIR * dir;
    struct dirent * dp;

    errcode = _mkdir(to);
    if (errcode != 0)
    {
        return errcode;
    }
    dir = opendir(from);
    if (dir == 0U)
    {
        return (*_errno());
    }
    while ((dp = readdir(dir)) != 0U)
    {
        char fromlocal[260];
        char tolocal[260];

        if (strcmp(dp->d_name, ".") == 0 || strcmp(dp->d_name, "..") == 0)
        {
            continue;
        }
        _cake_zmem(&fromlocal, 260);
        snprintf(fromlocal, 260, "%s/%s", from, dp->d_name);
        _cake_zmem(&tolocal, 260);
        snprintf(tolocal, 260, "%s/%s", to, dp->d_name);
        if (dp->d_type & 4)
        {
            errcode = copy_folder(fromlocal, tolocal);
        }
        else
        {
            errcode = copy_file(fromlocal, tolocal);
        }
        if (errcode != 0)
        {
            break;
        }
    }
    closedir(dir);
    return errcode;
}

unsigned long __stdcall GetModuleFileNameA(struct HINSTANCE__ * hModule, char * lpFilename, unsigned long nSize);

int get_self_path(char * buffer, int maxsize)
{
    unsigned long r;

    r = GetModuleFileNameA(0U, buffer, maxsize);
    return r;
}

char *strrchr_ex(char * s, int c1, int c2)
{
    char * last;
    char * p;

    last = 0U;
    p = s;
    while (*p)
    {
        if (*p == c1 || *p == c2)
        {
            last = p;
        }
        p++;
    }
    return (char *)last;
}

char *basename(char * filename)
{
    char * p;

    p = strrchr_ex(filename, 47, 92);
    return p ? p + 1 : (char *)filename;
}

char *dirname(char * path)
{
    int last;

    last = -1;
    {
        int i;
        i = 0;
        for (; path[i]; i++)
        {
            if (path[i] == 92 || path[i] == 47)
            {
                last = i;
            }
        }
    }
    if (last != -1)
    {
        path[last] = 0;
    }
    else
    {
        path[0] = 0;
    }
    return path;
}


int __cdecl _stat64i32(char * _FileName, struct _stat64i32 * _Stat);
inline static int __cdecl stat(char * _FileName, struct stat * _Stat)
{
    return _stat64i32(_FileName, (struct _stat64i32 *)_Stat);
}
void *malloc(unsigned int size);

char *read_file(char * path, unsigned char   append_newline)
{
    char * data;
    struct _iobuf * file;
    struct stat  info;
    int mem_size_bytes;
    unsigned int bytes_read;
    unsigned int bytes_read_part2;

    data = 0U;
    file = 0U;
    _cake_zmem(&info, 48);
    if (stat(path, &info) != 0)
    {
        return 0U;
    }
    mem_size_bytes = 1U * info.st_size + 1 + 1;
    if (mem_size_bytes < 4)
    {
        mem_size_bytes = 4;
    }
    data = malloc(mem_size_bytes);
    if (data == 0U)
    {
        return 0U;
    }
    file = fopen(path, "r");
    if (file == 0U)
    {
        free(data);
        return 0U;
    }
    bytes_read = fread(data, 1, 3, file);
    if (bytes_read < 3)
    {
        data[bytes_read] = 0;
        if (feof(file))
        {
            fclose(file);
            return data;
        }
        free(data);
        fclose(file);
        return 0U;
    }
    bytes_read_part2 = 0;
    if ((unsigned char)data[0] == 239 && (unsigned char)data[1] == 187 && (unsigned char)data[2] == 191)
    {
        bytes_read_part2 = fread(&data[0], 1, info.st_size - 3, file);
    }
    else
    {
        bytes_read_part2 = fread(&data[3], 1, info.st_size - 3, file);
        bytes_read_part2 = bytes_read_part2 + 3;
    }
    data[bytes_read_part2] = 0;
    if (append_newline && data[bytes_read_part2 - 1] != 10)
    {
        data[bytes_read_part2] = 10;
        ;
        data[bytes_read_part2 + 1] = 0;
    }
    fclose(file);
    return data;
}

unsigned char  is_diagnostic_note(int id)
{
    if (id == 63 || id == 62)
    {
        return 1;
    }
    return 0;
}

unsigned char  is_diagnostic_warning(int id)
{
    return !!(id > 63 && id <= 640);
}

unsigned char  is_diagnostic_error(int id)
{
    return !!(id >= 640);
}

unsigned char  is_diagnostic_configurable(int id)
{
    return !!(id >= 0 && id < 62);
}

int diagnostic_stack_push_empty(struct diagnostic_stack * diagnostic_stack)
{
    int index;

    index = diagnostic_stack->top_index;
    diagnostic_stack->top_index++;
    diagnostic_stack->stack[diagnostic_stack->top_index].warnings = 0;
    diagnostic_stack->stack[diagnostic_stack->top_index].errors = 0;
    diagnostic_stack->stack[diagnostic_stack->top_index].notes = 0;
    return index;
}

void diagnostic_stack_pop(struct diagnostic_stack * diagnostic_stack)
{
    if (diagnostic_stack->top_index > 0)
    {
        diagnostic_stack->top_index--;
    }
    else
    {
        ;
    }
}

struct diagnostic  default_diagnostic = {0, 9223372015379938269ULL, 0};
static struct w s_warnings[55] = {1, "unused-variable", 56, "unused-function", 2, "deprecated", 3, "enum-conversion", 4, "address", 5, "unused-parameter", 6, "hide-declarator", 7, "typeof-parameter", 8, "attributes", 9, "unused-value", 10, "style", 11, "comment", 12, "line-slicing", 44, "switch", 45, "unusual-null", 14, "discarded-qualifiers", 16, "uninitialized", 17, "return-local-addr", 36, "div-by-zero", 37, "constant-value", 46, "sizeof-array-argument", 13, "string-slicing", 15, "declarator-state", 20, "missing-owner-qualifier", 21, "not-owner", 22, "temp-owner", 23, "non-owner-move", 24, "non-owner-to-owner-move", 25, "discard-owner", 26, "non-owner-move", 35, "flow-div-by-zero", 27, "flow-not-null", 28, "missing-destructor", 31, "using-moved-object", 29, "analyzer-maybe-uninitialized", 32, "analyzer-null-dereference", 33, "analyzer-non-opt-arg", 30, "lifetime-ended", 34, "nullable-to-non-nullable", 18, "must-use-address-of", 38, "null-as-array", 39, "incompatible-enum", 40, "multi-char", 19, "array-indirection", 41, "out-of-bounds", 42, "array-parameter-assignment", 43, "conditional-constant", 47, "const-init", 48, "null-conversion", 49, "implicitly-unsigned-literal", 50, "overflow", 51, "array-size", 52, "empty-statement", 53, "incompatible-types", 54, "unused-label"};
void diagnostic_remove(struct diagnostic * d, int w)
{
    if (!is_diagnostic_configurable(w))
    {
        return;
    }
    if ((d->errors & (1ULL << w)) != 0)
    {
        d->errors &= ~(1ULL << w);
    }
    if ((d->warnings & (1ULL << w)) != 0)
    {
        d->warnings &= ~(1ULL << w);
    }
    if ((d->notes & (1ULL << w)) != 0)
    {
        d->notes &= ~(1ULL << w);
    }
}

int get_diagnostic_type(struct diagnostic * d, int w)
{
    if (is_diagnostic_configurable(w))
    {
        if ((d->errors & (1ULL << w)) != 0)
        {
            return 3;
        }
        if ((d->warnings & (1ULL << w)) != 0)
        {
            return 2;
        }
        if ((d->notes & (1ULL << w)) != 0)
        {
            return 1;
        }
    }
    if (is_diagnostic_note(w))
    {
        return 1;
    }
    if (is_diagnostic_warning(w))
    {
        return 2;
    }
    if (is_diagnostic_error(w))
    {
        return 3;
    }
    return 3;
}

int get_diagnostic_phase(int w)
{
    /*switch*/
    {
        register int _R9 = w;
        if (_R9 == 28) goto _CKL1; /*case 28*/
        if (_R9 == 29) goto _CKL2; /*case 29*/
        if (_R9 == 31) goto _CKL3; /*case 31*/
        if (_R9 == 32) goto _CKL4; /*case 32*/
        if (_R9 == 33) goto _CKL5; /*case 33*/
        if (_R9 == 27) goto _CKL6; /*case 27*/
        if (_R9 == 30) goto _CKL7; /*case 30*/
        if (_R9 == 35) goto _CKL8; /*case 35*/
        goto _CKL9;/*default*/

        {
            _CKL1:/*case 28*/ 
            _CKL2:/*case 29*/ 
            _CKL3:/*case 31*/ 
            _CKL4:/*case 32*/ 
            _CKL5:/*case 33*/ 
            _CKL6:/*case 27*/ 
            _CKL7:/*case 30*/ 
            _CKL8:/*case 35*/ 
            return 2;
            _CKL9: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

int __cdecl strncmp(char * _Str1, char * _Str2, unsigned int _MaxCount);
int __cdecl atoi(char * _String);

int get_warning(char * wname)
{
    if (!(wname[0] == 45 || wname[0] == 69))
    {
        return 0;
    }
    if (wname[0] == 45 && wname[1] == 87)
    {
        {
            int j;
            j = 0;
            for (; j < 55U; j++)
            {
                if (strncmp(s_warnings[j].name, wname + 2, strlen(s_warnings[j].name)) == 0)
                {
                    return s_warnings[j].w;
                }
            }
        }
    }
    else
    {
        if (wname[1] == 69)
        {
            int ec;

            ec = atoi(wname + 2);
            return ec;
        }
    }
    return 0;
}

unsigned long long get_warning_bit_mask(char * wname)
{
    unsigned char   disable_warning;
    char * final_name;

    disable_warning = !!(wname[2] == 110 && wname[3] == 111);
    final_name = disable_warning ? wname + 5 : wname + 2;
    ;
    {
        int j;
        j = 0;
        for (; j < 55U; j++)
        {
            if (strncmp(s_warnings[j].name, final_name, strlen(s_warnings[j].name)) == 0)
            {
                return (1ULL << ((unsigned long long)s_warnings[j].w));
            }
        }
    }
    return 0;
}

int get_warning_name(int w, int n, char buffer[])
{
    if (is_diagnostic_configurable(w))
    {
        {
            int j;
            j = 0;
            for (; j < 55U; j++)
            {
                if (s_warnings[j].w == w)
                {
                    snprintf(buffer, n, "-W%s", s_warnings[j].name);
                    return 0;
                }
            }
        }
    }
    else
    {
        snprintf(buffer, n, "E%d", w);
    }
    return 0;
}

extern struct diagnostic  default_diagnostic;
char *__cdecl strcpy(char * _Destination, char * _Source);

int fill_options(struct options * options, int argc, char ** argv)
{
    options->diagnostic_stack.stack[0] = default_diagnostic;
    options->diagnostic_stack.stack[0].warnings &= 18446744073709550591ULL;
    {
        int i;
        i = 1;
        for (; i < argc; i++)
        {
            if (argv[i][0] != 45)
            {
                continue;
            }
            if (argv[i][1] == 73 || argv[i][1] == 68)
            {
                continue;
            }
            if (strcmp(argv[i], "-no-output") == 0)
            {
                options->no_output = 1;
                continue;
            }
            if (strcmp(argv[i], "-const-literal") == 0)
            {
                options->const_literal = 1;
                continue;
            }
            if (strcmp(argv[i], "-o") == 0)
            {
                if (i + 1 < argc)
                {
                    strcpy(options->output, argv[i + 1]);
                    i++;
                }
                else
                {
                }
                continue;
            }
            if (strcmp(argv[i], "-sarif-path") == 0)
            {
                if (i + 1 < argc)
                {
                    strcpy(options->sarifpath, argv[i + 1]);
                    i++;
                }
                else
                {
                }
                continue;
            }
            if (strcmp(argv[i], "-H") == 0)
            {
                options->show_includes = 1;
                continue;
            }
            if (strcmp(argv[i], "-E") == 0)
            {
                options->preprocess_only = 1;
                continue;
            }
            if (strcmp(argv[i], "-preprocess-def-macro") == 0)
            {
                options->preprocess_def_macro = 1;
                continue;
            }
            if (strcmp(argv[i], "-sarif") == 0)
            {
                options->sarif_output = 1;
                continue;
            }
            if (strcmp(argv[i], "-fanalyzer") == 0)
            {
                options->flow_analysis = 1;
                continue;
            }
            if (strcmp(argv[i], "-nullchecks") == 0)
            {
                options->null_checks_enabled = 1;
                continue;
            }
            if (strcmp(argv[i], "-debug") == 0)
            {
                options->do_static_debug = 1;
                if (i + 1 < argc)
                {
                    i++;
                    options->static_debug_lines = atoi(argv[i]);
                }
                else
                {
                }
                continue;
            }
            if (strcmp(argv[i], "-ownership=enable") == 0)
            {
                options->ownership_enabled = 1;
                continue;
            }
            if (strcmp(argv[i], "-ownership=disable") == 0)
            {
                options->ownership_enabled = 0;
                continue;
            }
            if (strcmp(argv[i], "-test-mode") == 0)
            {
                options->test_mode = 1;
                continue;
            }
            if (strcmp(argv[i], "-msvc-output") == 0 || strcmp(argv[i], "-fdiagnostics-format=msvc") == 0)
            {
                options->visual_studio_ouput_format = 1;
                continue;
            }
            if (strcmp(argv[i], "-style=cake") == 0)
            {
                options->style = 0;
                continue;
            }
            if (strcmp(argv[i], "-style=gnu") == 0)
            {
                options->style = 7;
                continue;
            }
            if (strcmp(argv[i], "-style=microsoft") == 0)
            {
                options->style = 7;
                continue;
            }
            if (strcmp(argv[i], "-nullable=disable") == 0)
            {
                unsigned long long w;

                options->null_checks_enabled = 0;
                w = 21474836480ULL;
                options->diagnostic_stack.stack[0].warnings &= ~w;
                continue;
            }
            if (strcmp(argv[i], "-nullable=enabled") == 0)
            {
                options->null_checks_enabled = 1;
                continue;
            }
            if (strcmp(argv[i], "-autoconfig") == 0 || strcmp(argv[i], "-auto-config") == 0)
            {
                options->auto_config = 1;
                continue;
            }
            if (strcmp(argv[i], "-std=c2x") == 0 || strcmp(argv[i], "-std=c23") == 0)
            {
                options->input = 0;
                continue;
            }
            if (strcmp(argv[i], "-std=cxx") == 0)
            {
                options->input = 2;
                continue;
            }
            if (argv[i][1] == 87)
            {
                unsigned char   disable_warning;
                unsigned long long w;

                if (strcmp(argv[i], "-Wall") == 0)
                {
                    options->diagnostic_stack.stack[0].warnings = 18446744073709551615ULL;
                    continue;
                }
                disable_warning = !!((argv[i][2] == 110 && argv[i][3] == 111));
                w = get_warning_bit_mask(argv[i]);
                if (w == 0)
                {
                    printf("unknown warning '%s'", argv[i]);
                    return 1;
                }
                if (disable_warning)
                {
                    options->diagnostic_stack.stack[0].warnings &= ~w;
                }
                else
                {
                    if (w == 10)
                    {
                        options->diagnostic_stack.stack[0].warnings |= w;
                    }
                    else
                    {
                        options->diagnostic_stack.stack[0].notes |= w;
                    }
                }
                continue;
            }
            if (strcmp(argv[i], "-dump-tokens") == 0)
            {
                options->dump_tokens = 1;
                continue;
            }
            if (strcmp(argv[i], "-dump-pp-tokens") == 0)
            {
                options->dump_pptokens = 1;
                continue;
            }
            if (strcmp(argv[i], "-disable-assert") == 0)
            {
                options->disable_assert = 1;
                continue;
            }
            printf("unknown option '%s'", argv[i]);
            return 1;
        }
    }
    return 0;
}

void print_help()
{
    char * options;

    options = "\x1b[92m""Usage :""\x1b[0m""\x1b[36;1m""cake ""\x1b[0m""\x1b[34;1m""[OPTIONS] source1.c source2.c ...\n""\x1b[0m""\n""\x1b[92m""Samples:\n""\x1b[0m""\n""\x1b[97m""    ""\x1b[36;1m""cake ""\x1b[0m"" source.c\n""\x1b[0m""    Compiles source.c and outputs /out/source.c\n""\n""\x1b[97m""    ""\x1b[36;1m""cake ""\x1b[0m"" file.c -o file.cc && cl file.cc\n""\x1b[0m""    Compiles file.c and outputs file.cc then use cl to compile file.cc\n""\n""\x1b[97m""    ""\x1b[36;1m""cake ""\x1b[0m"" file.c -direct-compilation -o file.cc && cl file.cc\n""\x1b[0m""    Compiles file.c and outputs file.cc for direct compilation then use cl to compile file.cc\n""\n""\x1b[92m""Options:\n""\x1b[0m""\n""\x1b[36;1m""  -I                   ""\x1b[0m"" Adds a directory to the list of directories searched for include files \n""                        (On windows, if you run cake at the visual studio command prompt cake \n""                        uses the same include files used by msvc )\n""\n""\x1b[36;1m""  -auto-config           ""\x1b[0m""Generates cakeconfig.h with include directories\n""\n""\x1b[36;1m""  -no-output            ""\x1b[0m""Cake will not generate output\n""\n""\x1b[36;1m""  -D                    ""\x1b[0m""Defines a preprocessing symbol for a source file \n""\n""\x1b[36;1m""  -E                    ""\x1b[0m""Copies preprocessor output to standard output \n""\n""\x1b[36;1m""  -o name.c             ""\x1b[0m""Defines the output name when compiling one file\n""\n""\x1b[36;1m""  -std=standard         ""\x1b[0m""Assume that the input sources are for standard (c89, c99, c11, c2x, cxx) \n""                        (not implemented yet, input is considered C23)                    \n""\n""\x1b[36;1m""  -no-discard           ""\x1b[0m""Makes [[nodiscard]] default implicitly \n""\n""\x1b[36;1m""  -Wname -Wno-name      ""\x1b[0m""Enables or disable warning\n""\n""\x1b[36;1m""  -fanalyzer            ""\x1b[0m""Runs flow analysis -  required for ownership\n""\n""\x1b[36;1m""  -sarif                ""\x1b[0m""Generates sarif files\n""\n""\x1b[36;1m""  -H                    ""\x1b[0m""Print the name of each header file used\n""\n""\x1b[36;1m""  -sarif-path           ""\x1b[0m""Set sarif output dir\n""\n""\x1b[36;1m""  -msvc-output          ""\x1b[0m""Output is compatible with visual studio\n""\n""\x1b[36;1m""  -dump-tokens          ""\x1b[0m""Output tokens before preprocessor\n""\n""\x1b[36;1m""  -dump-pp-tokens       ""\x1b[0m""Output tokens after preprocessor\n""\n""\x1b[36;1m""  -disable-assert       ""\x1b[0m""disables built-in assert\n""\n""\x1b[36;1m""  -const-literal        ""\x1b[0m""literal string becomes const\n""\n""\x1b[36;1m""  -preprocess-def-macro ""\x1b[0m""preprocess def macros after expansion\n""More details at http://thradams.com/cake/manual.html\n";
    printf("%s", options);
}

unsigned char  unsigned_long_long_sub(unsigned long long * result, unsigned long long a, unsigned long long b)
{
    *result = 0;
    if (a < b)
    {
        return 0;
    }
    *result = a - b;
    return 1;
}

unsigned char  unsigned_long_long_mul(unsigned long long * result, unsigned long long a, unsigned long long b)
{
    *result = 0;
    if (b == 0)
    {
        *result = 0;
        return 1;
    }
    if (a > 18446744073709551615ULL / b)
    {
        return 0;
    }
    *result = a * b;
    return 1;
}

unsigned char  unsigned_long_long_add(unsigned long long * result, unsigned long long a, unsigned long long b)
{
    *result = 0;
    if (a > 18446744073709551615ULL - b)
    {
        return 0;
    }
    *result = a + b;
    return 1;
}

unsigned char  signed_long_long_sub(signed long long * result, signed long long a, signed long long b)
{
    *result = 0;
    if (a >= 0 && b >= 0)
    {
    }
    else
    {
        if (a < 0 && b < 0)
        {
        }
        else
        {
            if (a < 0)
            {
                if (a < -9223372036854775808LL + b)
                {
                    return 0;
                }
            }
            else
            {
                if (b == -9223372036854775808LL)
                {
                    return 0;
                }
                if (a > 9223372036854775807LL - (-b))
                {
                    return 0;
                }
            }
        }
    }
    *result = a - b;
    return 1;
}

unsigned char  signed_long_long_add(signed long long * result, signed long long a, signed long long b)
{
    *result = 0;
    if (a >= 0 && b >= 0)
    {
        if (a > 9223372036854775807LL - b)
        {
            return 0;
        }
    }
    else
    {
        if (a < 0 && b < 0)
        {
            if (a == -9223372036854775808LL || b == -9223372036854775808LL)
            {
                return 0;
            }
            if (a < -9223372036854775808LL - b)
            {
                return 0;
            }
        }
        else
        {
        }
    }
    *result = a + b;
    return 1;
}

unsigned char  signed_long_long_mul(signed long long * result, signed long long a, signed long long b)
{
    *result = 0;
    if (a > 0 && b > 0)
    {
        if (a > 9223372036854775807LL / b)
        {
            return 0;
        }
    }
    else
    {
        if (a < 0 && b < 0)
        {
            if (a == -9223372036854775808LL || b == -9223372036854775808LL)
            {
                return 0;
            }
            if (-a > 9223372036854775807LL / -b)
            {
                return 0;
            }
        }
        else
        {
            if (a == 0 || b == 0)
            {
                *result = 0;
                return 1;
            }
            if (b > 0)
            {
                if (a < -9223372036854775808LL / b)
                {
                    return 0;
                }
            }
            else
            {
                if (b < -9223372036854775808LL / a)
                {
                    return 0;
                }
            }
        }
    }
    *result = a * b;
    return 1;
}

void object_swap(struct object * a, struct object * b)
{
    struct object  temp;

    temp = *a;
    *a = *b;
    *b = temp;
}

void type_destroy(struct type * p_type);
void object_delete(struct object * p);

void object_destroy(struct object * p)
{
    struct object * item;

    ;
    type_destroy(&p->type);
    free((void *)p->debug_name);
    item = p->members;
    while (item)
    {
        struct object * next;

        next = item->next;
        item->next = 0U;
        object_delete(item);
        item = next;
    }
}

void object_delete(struct object * p)
{
    if (p)
    {
        object_destroy(p);
        free(p);
    }
}

struct object *object_get_referenced(struct object * p_object);

unsigned char  object_has_constant_value(struct object * a)
{
    a = object_get_referenced(a);
    return !!(a->state == 2);
}

void object_to_string(struct object * a, char buffer[], int sz)
{
    a = object_get_referenced(a);
    buffer[0] = 0;
    /*switch*/
    {
        register int _R10 = a->value_type;
        if (_R10 == 2) goto _CKL1; /*case 2*/
        if (_R10 == 3) goto _CKL2; /*case 3*/
        if (_R10 == 4) goto _CKL3; /*case 4*/
        if (_R10 == 5) goto _CKL4; /*case 5*/
        if (_R10 == 6) goto _CKL5; /*case 6*/
        if (_R10 == 0) goto _CKL6; /*case 0*/
        if (_R10 == 1) goto _CKL7; /*case 1*/
        if (_R10 == 7) goto _CKL8; /*case 7*/
        if (_R10 == 8) goto _CKL9; /*case 8*/
        if (_R10 == 9) goto _CKL10; /*case 9*/
        if (_R10 == 10) goto _CKL11; /*case 10*/
        if (_R10 == 11) goto _CKL12; /*case 11*/
        if (_R10 == 12) goto _CKL13; /*case 12*/
        if (_R10 == 13) goto _CKL14; /*case 13*/
        if (_R10 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            snprintf(buffer, sz, "%s", a->value.signed_char_value ? "true" : "false");
            goto _CKL0; /*break*/

            _CKL2:/*case 3*/ 
            snprintf(buffer, sz, "%c", a->value.signed_char_value);
            goto _CKL0; /*break*/

            _CKL3:/*case 4*/ 
            snprintf(buffer, sz, "%c", a->value.unsigned_char_value);
            goto _CKL0; /*break*/

            _CKL4:/*case 5*/ 
            snprintf(buffer, sz, "%c", a->value.signed_short_value);
            goto _CKL0; /*break*/

            _CKL5:/*case 6*/ 
            snprintf(buffer, sz, "%c", a->value.signed_short_value);
            goto _CKL0; /*break*/

            _CKL6:/*case 0*/ 
            snprintf(buffer, sz, "%d", a->value.signed_int_value);
            goto _CKL0; /*break*/

            _CKL7:/*case 1*/ 
            snprintf(buffer, sz, "%u", a->value.signed_int_value);
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            snprintf(buffer, sz, "%ld", a->value.signed_long_value);
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            snprintf(buffer, sz, "%lud", a->value.signed_long_value);
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            snprintf(buffer, sz, "%llu", a->value.signed_long_long_value);
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            snprintf(buffer, sz, "%f", a->value.float_value);
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            snprintf(buffer, sz, "%f", a->value.double_value);
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            snprintf(buffer, sz, "%Lf", a->value.long_double_value);
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            if (a->value.void_pointer == 0U)
            {
                snprintf(buffer, sz, "null");
            }
            else
            {
                snprintf(buffer, sz, "%p", a->value.void_pointer);
            }
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
}

struct object object_make_size_t(unsigned int value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 1;
    r.value.unsigned_int_value = value;
    return r;
}

struct object object_make_nullptr()
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 0;
    r.value.signed_short_value = 0;
    return r;
}

struct object object_make_wchar_t(unsigned short value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 5;
    r.value.signed_short_value = value;
    return r;
}

struct object object_make_bool(unsigned char   value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 2;
    r.value.bool_value = value;
    return r;
}

signed long long object_to_signed_long_long(struct object * a);
unsigned long long object_to_unsigned_long_long(struct object * a);
long double object_to_long_double(struct object * a);

int object_to_str(struct object * a, int n, char str[])
{
    str[0] = 0;
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R11 = a->value_type;
        if (_R11 == 2) goto _CKL1; /*case 2*/
        if (_R11 == 3) goto _CKL2; /*case 3*/
        if (_R11 == 5) goto _CKL3; /*case 5*/
        if (_R11 == 0) goto _CKL4; /*case 0*/
        if (_R11 == 7) goto _CKL5; /*case 7*/
        if (_R11 == 9) goto _CKL6; /*case 9*/
        if (_R11 == 4) goto _CKL7; /*case 4*/
        if (_R11 == 6) goto _CKL8; /*case 6*/
        if (_R11 == 1) goto _CKL9; /*case 1*/
        if (_R11 == 8) goto _CKL10; /*case 8*/
        if (_R11 == 10) goto _CKL11; /*case 10*/
        if (_R11 == 11) goto _CKL12; /*case 11*/
        if (_R11 == 12) goto _CKL13; /*case 12*/
        if (_R11 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            _CKL2:/*case 3*/ 
            _CKL3:/*case 5*/ 
            _CKL4:/*case 0*/ 
            _CKL5:/*case 7*/ 
            _CKL6:/*case 9*/ 
            {
                long long v;

                v = object_to_signed_long_long(a);
                snprintf(str, n, "%lld", v);
            }
            goto _CKL0; /*break*/

            _CKL7:/*case 4*/ 
            _CKL8:/*case 6*/ 
            _CKL9:/*case 1*/ 
            _CKL10:/*case 8*/ 
            _CKL11:/*case 10*/ 
            {
                unsigned long long v;

                v = object_to_unsigned_long_long(a);
                snprintf(str, n, "%llu", v);
            }
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            _CKL13:/*case 12*/ 
            _CKL14:/*case 13*/ 
            {
                long double v;

                v = object_to_long_double(a);
                snprintf(str, n, "%Lf", v);
            }
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

struct object *object_get_non_const_referenced(struct object * p_object);

void object_set_signed_int(struct object * a, long long value)
{
    a = object_get_non_const_referenced(a);
    a->state = 4;
    /*switch*/
    {
        register int _R12 = a->value_type;
        if (_R12 == 2) goto _CKL1; /*case 2*/
        if (_R12 == 3) goto _CKL2; /*case 3*/
        if (_R12 == 4) goto _CKL3; /*case 4*/
        if (_R12 == 5) goto _CKL4; /*case 5*/
        if (_R12 == 6) goto _CKL5; /*case 6*/
        if (_R12 == 0) goto _CKL6; /*case 0*/
        if (_R12 == 1) goto _CKL7; /*case 1*/
        if (_R12 == 7) goto _CKL8; /*case 7*/
        if (_R12 == 8) goto _CKL9; /*case 8*/
        if (_R12 == 9) goto _CKL10; /*case 9*/
        if (_R12 == 10) goto _CKL11; /*case 10*/
        if (_R12 == 11) goto _CKL12; /*case 11*/
        if (_R12 == 12) goto _CKL13; /*case 12*/
        if (_R12 == 13) goto _CKL14; /*case 13*/
        if (_R12 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            a->value.bool_value = !!(value);
            goto _CKL0; /*break*/

            _CKL2:/*case 3*/ 
            a->value.signed_char_value = value;
            goto _CKL0; /*break*/

            _CKL3:/*case 4*/ 
            a->value.unsigned_char_value = value;
            goto _CKL0; /*break*/

            _CKL4:/*case 5*/ 
            a->value.signed_short_value = value;
            goto _CKL0; /*break*/

            _CKL5:/*case 6*/ 
            a->value.unsigned_short_value = value;
            goto _CKL0; /*break*/

            _CKL6:/*case 0*/ 
            a->value.signed_int_value = value;
            goto _CKL0; /*break*/

            _CKL7:/*case 1*/ 
            a->value.unsigned_int_value = value;
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            a->value.signed_long_value = value;
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            a->value.unsigned_long_value = value;
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            a->value.signed_long_long_value = value;
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            a->value.unsigned_long_long_value = value;
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            a->value.float_value = value;
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            a->value.double_value = value;
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            a->value.long_double_value = value;
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
}

void object_set_unsigned_int(struct object * a, unsigned long long value)
{
    a = object_get_non_const_referenced(a);
    a->state = 4;
    /*switch*/
    {
        register int _R13 = a->value_type;
        if (_R13 == 2) goto _CKL1; /*case 2*/
        if (_R13 == 3) goto _CKL2; /*case 3*/
        if (_R13 == 4) goto _CKL3; /*case 4*/
        if (_R13 == 5) goto _CKL4; /*case 5*/
        if (_R13 == 6) goto _CKL5; /*case 6*/
        if (_R13 == 0) goto _CKL6; /*case 0*/
        if (_R13 == 1) goto _CKL7; /*case 1*/
        if (_R13 == 7) goto _CKL8; /*case 7*/
        if (_R13 == 8) goto _CKL9; /*case 8*/
        if (_R13 == 9) goto _CKL10; /*case 9*/
        if (_R13 == 10) goto _CKL11; /*case 10*/
        if (_R13 == 11) goto _CKL12; /*case 11*/
        if (_R13 == 12) goto _CKL13; /*case 12*/
        if (_R13 == 13) goto _CKL14; /*case 13*/
        if (_R13 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            a->value.bool_value = !!(value);
            goto _CKL0; /*break*/

            _CKL2:/*case 3*/ 
            a->value.signed_char_value = value;
            goto _CKL0; /*break*/

            _CKL3:/*case 4*/ 
            a->value.unsigned_char_value = value;
            goto _CKL0; /*break*/

            _CKL4:/*case 5*/ 
            a->value.signed_short_value = value;
            goto _CKL0; /*break*/

            _CKL5:/*case 6*/ 
            a->value.unsigned_short_value = value;
            goto _CKL0; /*break*/

            _CKL6:/*case 0*/ 
            a->value.signed_int_value = value;
            goto _CKL0; /*break*/

            _CKL7:/*case 1*/ 
            a->value.unsigned_int_value = value;
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            a->value.signed_long_value = value;
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            a->value.unsigned_long_value = value;
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            a->value.signed_long_long_value = value;
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            a->value.unsigned_long_long_value = value;
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            a->value.float_value = value;
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            a->value.double_value = value;
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            a->value.long_double_value = value;
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
}

unsigned char  object_to_bool(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R14 = a->value_type;
        if (_R14 == 2) goto _CKL1; /*case 2*/
        if (_R14 == 3) goto _CKL2; /*case 3*/
        if (_R14 == 4) goto _CKL3; /*case 4*/
        if (_R14 == 5) goto _CKL4; /*case 5*/
        if (_R14 == 6) goto _CKL5; /*case 6*/
        if (_R14 == 0) goto _CKL6; /*case 0*/
        if (_R14 == 1) goto _CKL7; /*case 1*/
        if (_R14 == 7) goto _CKL8; /*case 7*/
        if (_R14 == 8) goto _CKL9; /*case 8*/
        if (_R14 == 9) goto _CKL10; /*case 9*/
        if (_R14 == 10) goto _CKL11; /*case 10*/
        if (_R14 == 11) goto _CKL12; /*case 11*/
        if (_R14 == 12) goto _CKL13; /*case 12*/
        if (_R14 == 13) goto _CKL14; /*case 13*/
        if (_R14 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return !!(a->value.signed_char_value);
            _CKL3:/*case 4*/ 
            return !!(a->value.unsigned_char_value);
            _CKL4:/*case 5*/ 
            return !!(a->value.signed_short_value);
            _CKL5:/*case 6*/ 
            return !!(a->value.unsigned_short_value);
            _CKL6:/*case 0*/ 
            return !!(a->value.signed_int_value);
            _CKL7:/*case 1*/ 
            return !!(a->value.unsigned_int_value);
            _CKL8:/*case 7*/ 
            return !!(a->value.signed_long_value);
            _CKL9:/*case 8*/ 
            return !!(a->value.unsigned_long_value);
            _CKL10:/*case 9*/ 
            return !!(a->value.signed_long_long_value);
            _CKL11:/*case 10*/ 
            return !!(a->value.unsigned_long_long_value);
            _CKL12:/*case 11*/ 
            return !!(a->value.float_value);
            _CKL13:/*case 12*/ 
            return !!(a->value.double_value);
            _CKL14:/*case 13*/ 
            return !!(a->value.long_double_value);
            _CKL15:/*case 14*/ 
            return !!(a->value.void_pointer != 0);
        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_signed_char(signed char value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 3;
    r.value.signed_char_value = value;
    return r;
}

int object_increment_value(struct object * a)
{
    a = object_get_non_const_referenced(a);
    /*switch*/
    {
        register int _R15 = a->value_type;
        if (_R15 == 2) goto _CKL1; /*case 2*/
        if (_R15 == 3) goto _CKL2; /*case 3*/
        if (_R15 == 4) goto _CKL3; /*case 4*/
        if (_R15 == 5) goto _CKL4; /*case 5*/
        if (_R15 == 6) goto _CKL5; /*case 6*/
        if (_R15 == 0) goto _CKL6; /*case 0*/
        if (_R15 == 1) goto _CKL7; /*case 1*/
        if (_R15 == 7) goto _CKL8; /*case 7*/
        if (_R15 == 8) goto _CKL9; /*case 8*/
        if (_R15 == 9) goto _CKL10; /*case 9*/
        if (_R15 == 10) goto _CKL11; /*case 10*/
        if (_R15 == 11) goto _CKL12; /*case 11*/
        if (_R15 == 12) goto _CKL13; /*case 12*/
        if (_R15 == 13) goto _CKL14; /*case 13*/
        if (_R15 == 14) goto _CKL15; /*case 14*/
        goto _CKL16;/*default*/

        {
            _CKL1:/*case 2*/ 
            a->value.bool_value++;
            goto _CKL0; /*break*/

            _CKL2:/*case 3*/ 
            a->value.signed_char_value++;
            goto _CKL0; /*break*/

            _CKL3:/*case 4*/ 
            a->value.unsigned_char_value++;
            goto _CKL0; /*break*/

            _CKL4:/*case 5*/ 
            a->value.signed_short_value++;
            goto _CKL0; /*break*/

            _CKL5:/*case 6*/ 
            a->value.unsigned_short_value++;
            goto _CKL0; /*break*/

            _CKL6:/*case 0*/ 
            a->value.signed_int_value++;
            goto _CKL0; /*break*/

            _CKL7:/*case 1*/ 
            a->value.unsigned_int_value++;
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            a->value.signed_long_value++;
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            a->value.unsigned_long_value++;
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            a->value.signed_long_long_value++;
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            a->value.unsigned_long_long_value++;
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            a->value.float_value++;
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            a->value.double_value++;
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            a->value.long_double_value++;
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

            _CKL16: /*default*/ 
            return 1;
        }
        _CKL0:;
    }
    return 0;
}

signed char object_to_signed_char(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R16 = a->value_type;
        if (_R16 == 2) goto _CKL1; /*case 2*/
        if (_R16 == 3) goto _CKL2; /*case 3*/
        if (_R16 == 4) goto _CKL3; /*case 4*/
        if (_R16 == 5) goto _CKL4; /*case 5*/
        if (_R16 == 6) goto _CKL5; /*case 6*/
        if (_R16 == 0) goto _CKL6; /*case 0*/
        if (_R16 == 1) goto _CKL7; /*case 1*/
        if (_R16 == 7) goto _CKL8; /*case 7*/
        if (_R16 == 8) goto _CKL9; /*case 8*/
        if (_R16 == 9) goto _CKL10; /*case 9*/
        if (_R16 == 10) goto _CKL11; /*case 10*/
        if (_R16 == 11) goto _CKL12; /*case 11*/
        if (_R16 == 12) goto _CKL13; /*case 12*/
        if (_R16 == 13) goto _CKL14; /*case 13*/
        if (_R16 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            return 0;
        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_unsigned_char(unsigned char value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 4;
    r.value.unsigned_char_value = value;
    return r;
}

unsigned char object_to_unsigned_char(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R17 = a->value_type;
        if (_R17 == 2) goto _CKL1; /*case 2*/
        if (_R17 == 3) goto _CKL2; /*case 3*/
        if (_R17 == 4) goto _CKL3; /*case 4*/
        if (_R17 == 5) goto _CKL4; /*case 5*/
        if (_R17 == 6) goto _CKL5; /*case 6*/
        if (_R17 == 0) goto _CKL6; /*case 0*/
        if (_R17 == 1) goto _CKL7; /*case 1*/
        if (_R17 == 7) goto _CKL8; /*case 7*/
        if (_R17 == 8) goto _CKL9; /*case 8*/
        if (_R17 == 9) goto _CKL10; /*case 9*/
        if (_R17 == 10) goto _CKL11; /*case 10*/
        if (_R17 == 11) goto _CKL12; /*case 11*/
        if (_R17 == 12) goto _CKL13; /*case 12*/
        if (_R17 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_signed_short(signed short value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 5;
    r.value.signed_short_value = value;
    return r;
}

signed short object_to_signed_short(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R18 = a->value_type;
        if (_R18 == 2) goto _CKL1; /*case 2*/
        if (_R18 == 3) goto _CKL2; /*case 3*/
        if (_R18 == 4) goto _CKL3; /*case 4*/
        if (_R18 == 5) goto _CKL4; /*case 5*/
        if (_R18 == 6) goto _CKL5; /*case 6*/
        if (_R18 == 0) goto _CKL6; /*case 0*/
        if (_R18 == 1) goto _CKL7; /*case 1*/
        if (_R18 == 7) goto _CKL8; /*case 7*/
        if (_R18 == 8) goto _CKL9; /*case 8*/
        if (_R18 == 9) goto _CKL10; /*case 9*/
        if (_R18 == 10) goto _CKL11; /*case 10*/
        if (_R18 == 11) goto _CKL12; /*case 11*/
        if (_R18 == 12) goto _CKL13; /*case 12*/
        if (_R18 == 13) goto _CKL14; /*case 13*/
        if (_R18 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_unsigned_short(unsigned short value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 6;
    r.value.unsigned_short_value = value;
    return r;
}

unsigned short object_to_unsigned_short(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R19 = a->value_type;
        if (_R19 == 2) goto _CKL1; /*case 2*/
        if (_R19 == 3) goto _CKL2; /*case 3*/
        if (_R19 == 4) goto _CKL3; /*case 4*/
        if (_R19 == 5) goto _CKL4; /*case 5*/
        if (_R19 == 6) goto _CKL5; /*case 6*/
        if (_R19 == 0) goto _CKL6; /*case 0*/
        if (_R19 == 1) goto _CKL7; /*case 1*/
        if (_R19 == 7) goto _CKL8; /*case 7*/
        if (_R19 == 8) goto _CKL9; /*case 8*/
        if (_R19 == 9) goto _CKL10; /*case 9*/
        if (_R19 == 10) goto _CKL11; /*case 10*/
        if (_R19 == 11) goto _CKL12; /*case 11*/
        if (_R19 == 12) goto _CKL13; /*case 12*/
        if (_R19 == 13) goto _CKL14; /*case 13*/
        if (_R19 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_signed_int(signed int value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 0;
    r.value.signed_int_value = value;
    return r;
}

signed int object_to_signed_int(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R20 = a->value_type;
        if (_R20 == 2) goto _CKL1; /*case 2*/
        if (_R20 == 3) goto _CKL2; /*case 3*/
        if (_R20 == 4) goto _CKL3; /*case 4*/
        if (_R20 == 5) goto _CKL4; /*case 5*/
        if (_R20 == 6) goto _CKL5; /*case 6*/
        if (_R20 == 0) goto _CKL6; /*case 0*/
        if (_R20 == 1) goto _CKL7; /*case 1*/
        if (_R20 == 7) goto _CKL8; /*case 7*/
        if (_R20 == 8) goto _CKL9; /*case 8*/
        if (_R20 == 9) goto _CKL10; /*case 9*/
        if (_R20 == 10) goto _CKL11; /*case 10*/
        if (_R20 == 11) goto _CKL12; /*case 11*/
        if (_R20 == 12) goto _CKL13; /*case 12*/
        if (_R20 == 13) goto _CKL14; /*case 13*/
        if (_R20 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            return (int)a->value.void_pointer;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_unsigned_int(unsigned int value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 1;
    r.value.unsigned_int_value = value;
    return r;
}

unsigned int object_to_unsigned_int(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R21 = a->value_type;
        if (_R21 == 2) goto _CKL1; /*case 2*/
        if (_R21 == 3) goto _CKL2; /*case 3*/
        if (_R21 == 4) goto _CKL3; /*case 4*/
        if (_R21 == 5) goto _CKL4; /*case 5*/
        if (_R21 == 6) goto _CKL5; /*case 6*/
        if (_R21 == 0) goto _CKL6; /*case 0*/
        if (_R21 == 1) goto _CKL7; /*case 1*/
        if (_R21 == 7) goto _CKL8; /*case 7*/
        if (_R21 == 8) goto _CKL9; /*case 8*/
        if (_R21 == 9) goto _CKL10; /*case 9*/
        if (_R21 == 10) goto _CKL11; /*case 10*/
        if (_R21 == 11) goto _CKL12; /*case 11*/
        if (_R21 == 12) goto _CKL13; /*case 12*/
        if (_R21 == 13) goto _CKL14; /*case 13*/
        if (_R21 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            return (int)a->value.void_pointer;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_signed_long(signed long value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 7;
    r.value.signed_long_value = value;
    return r;
}

signed long object_to_signed_long(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R22 = a->value_type;
        if (_R22 == 2) goto _CKL1; /*case 2*/
        if (_R22 == 3) goto _CKL2; /*case 3*/
        if (_R22 == 4) goto _CKL3; /*case 4*/
        if (_R22 == 5) goto _CKL4; /*case 5*/
        if (_R22 == 6) goto _CKL5; /*case 6*/
        if (_R22 == 0) goto _CKL6; /*case 0*/
        if (_R22 == 1) goto _CKL7; /*case 1*/
        if (_R22 == 7) goto _CKL8; /*case 7*/
        if (_R22 == 8) goto _CKL9; /*case 8*/
        if (_R22 == 9) goto _CKL10; /*case 9*/
        if (_R22 == 10) goto _CKL11; /*case 10*/
        if (_R22 == 11) goto _CKL12; /*case 11*/
        if (_R22 == 12) goto _CKL13; /*case 12*/
        if (_R22 == 13) goto _CKL14; /*case 13*/
        if (_R22 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_unsigned_long(unsigned long value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 8;
    r.value.unsigned_long_value = value;
    return r;
}

unsigned long object_to_unsigned_long(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R23 = a->value_type;
        if (_R23 == 2) goto _CKL1; /*case 2*/
        if (_R23 == 3) goto _CKL2; /*case 3*/
        if (_R23 == 4) goto _CKL3; /*case 4*/
        if (_R23 == 5) goto _CKL4; /*case 5*/
        if (_R23 == 6) goto _CKL5; /*case 6*/
        if (_R23 == 0) goto _CKL6; /*case 0*/
        if (_R23 == 1) goto _CKL7; /*case 1*/
        if (_R23 == 7) goto _CKL8; /*case 7*/
        if (_R23 == 8) goto _CKL9; /*case 8*/
        if (_R23 == 9) goto _CKL10; /*case 9*/
        if (_R23 == 10) goto _CKL11; /*case 10*/
        if (_R23 == 11) goto _CKL12; /*case 11*/
        if (_R23 == 12) goto _CKL13; /*case 12*/
        if (_R23 == 13) goto _CKL14; /*case 13*/
        if (_R23 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_signed_long_long(signed long long value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 9;
    r.value.signed_long_long_value = value;
    return r;
}

signed long long object_to_signed_long_long(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R24 = a->value_type;
        if (_R24 == 2) goto _CKL1; /*case 2*/
        if (_R24 == 3) goto _CKL2; /*case 3*/
        if (_R24 == 4) goto _CKL3; /*case 4*/
        if (_R24 == 5) goto _CKL4; /*case 5*/
        if (_R24 == 6) goto _CKL5; /*case 6*/
        if (_R24 == 0) goto _CKL6; /*case 0*/
        if (_R24 == 1) goto _CKL7; /*case 1*/
        if (_R24 == 7) goto _CKL8; /*case 7*/
        if (_R24 == 8) goto _CKL9; /*case 8*/
        if (_R24 == 9) goto _CKL10; /*case 9*/
        if (_R24 == 10) goto _CKL11; /*case 10*/
        if (_R24 == 11) goto _CKL12; /*case 11*/
        if (_R24 == 12) goto _CKL13; /*case 12*/
        if (_R24 == 13) goto _CKL14; /*case 13*/
        if (_R24 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_unsigned_long_long(unsigned long long value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 10;
    r.value.unsigned_long_long_value = value;
    return r;
}

unsigned long long object_to_unsigned_long_long(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R25 = a->value_type;
        if (_R25 == 2) goto _CKL1; /*case 2*/
        if (_R25 == 3) goto _CKL2; /*case 3*/
        if (_R25 == 4) goto _CKL3; /*case 4*/
        if (_R25 == 5) goto _CKL4; /*case 5*/
        if (_R25 == 6) goto _CKL5; /*case 6*/
        if (_R25 == 0) goto _CKL6; /*case 0*/
        if (_R25 == 1) goto _CKL7; /*case 1*/
        if (_R25 == 7) goto _CKL8; /*case 7*/
        if (_R25 == 8) goto _CKL9; /*case 8*/
        if (_R25 == 9) goto _CKL10; /*case 9*/
        if (_R25 == 10) goto _CKL11; /*case 10*/
        if (_R25 == 11) goto _CKL12; /*case 11*/
        if (_R25 == 12) goto _CKL13; /*case 12*/
        if (_R25 == 13) goto _CKL14; /*case 13*/
        if (_R25 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_float(float value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 11;
    r.value.float_value = value;
    return r;
}

float object_to_float(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R26 = a->value_type;
        if (_R26 == 2) goto _CKL1; /*case 2*/
        if (_R26 == 3) goto _CKL2; /*case 3*/
        if (_R26 == 4) goto _CKL3; /*case 4*/
        if (_R26 == 5) goto _CKL4; /*case 5*/
        if (_R26 == 6) goto _CKL5; /*case 6*/
        if (_R26 == 0) goto _CKL6; /*case 0*/
        if (_R26 == 1) goto _CKL7; /*case 1*/
        if (_R26 == 7) goto _CKL8; /*case 7*/
        if (_R26 == 8) goto _CKL9; /*case 8*/
        if (_R26 == 9) goto _CKL10; /*case 9*/
        if (_R26 == 10) goto _CKL11; /*case 10*/
        if (_R26 == 11) goto _CKL12; /*case 11*/
        if (_R26 == 12) goto _CKL13; /*case 12*/
        if (_R26 == 13) goto _CKL14; /*case 13*/
        if (_R26 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_double(double value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 12;
    r.value.double_value = value;
    return r;
}

double object_to_double(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R27 = a->value_type;
        if (_R27 == 2) goto _CKL1; /*case 2*/
        if (_R27 == 3) goto _CKL2; /*case 3*/
        if (_R27 == 4) goto _CKL3; /*case 4*/
        if (_R27 == 5) goto _CKL4; /*case 5*/
        if (_R27 == 6) goto _CKL5; /*case 6*/
        if (_R27 == 0) goto _CKL6; /*case 0*/
        if (_R27 == 1) goto _CKL7; /*case 1*/
        if (_R27 == 7) goto _CKL8; /*case 7*/
        if (_R27 == 8) goto _CKL9; /*case 8*/
        if (_R27 == 9) goto _CKL10; /*case 9*/
        if (_R27 == 10) goto _CKL11; /*case 10*/
        if (_R27 == 11) goto _CKL12; /*case 11*/
        if (_R27 == 12) goto _CKL13; /*case 12*/
        if (_R27 == 13) goto _CKL14; /*case 13*/
        if (_R27 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_make_null_pointer()
{
    struct object  null_object;

    null_object.state = 4;
    null_object.value_type = 14;
    null_object.type.category = 0;
    null_object.type.attributes_flags = 0;
    null_object.type.msvc_declspec_flags = 0;
    null_object.type.alignment_specifier_flags = 0;
    null_object.type.type_specifier_flags = 0;
    null_object.type.type_qualifier_flags = 0;
    null_object.type.storage_class_specifier_flags = 0;
    null_object.type.name_opt = 0;
    null_object.type.struct_or_union_specifier = 0;
    null_object.type.enum_specifier = 0;
    null_object.type.array_num_elements_expression = 0;
    null_object.type.num_of_elements = 0;
    null_object.type.has_static_array_size = 0;
    null_object.type.address_of = 0;
    null_object.type.params.is_var_args = 0;
    null_object.type.params.is_void = 0;
    null_object.type.params.head = 0;
    null_object.type.params.tail = 0;
    null_object.type.next = 0;
    null_object.debug_name = 0;
    null_object.value.bool_value = 0;
    null_object.value.signed_char_value = 0;
    null_object.value.unsigned_char_value = 0;
    null_object.value.signed_short_value = 0;
    null_object.value.unsigned_short_value = 0;
    null_object.value.signed_int_value = 0;
    null_object.value.unsigned_int_value = 0;
    null_object.value.signed_long_value = 0;
    null_object.value.unsigned_long_value = 0;
    null_object.value.signed_long_long_value = 0;
    null_object.value.unsigned_long_long_value = 0;
    null_object.value.float_value = 0;
    null_object.value.double_value = 0;
    null_object.value.long_double_value = 0;
    null_object.value.void_pointer = 0U;
    null_object.parent = 0;
    null_object.p_init_expression = 0;
    null_object.members = 0;
    null_object.next = 0;
    return null_object;
}

struct object object_make_pointer(struct object * object)
{
    struct object  r;

    object = object_get_non_const_referenced(object);
    _cake_zmem(&r, 104);
    r.state = 4;
    r.value_type = 14;
    r.value.void_pointer = object;
    return r;
}

struct object object_make_reference(struct object * object)
{
    struct object  r;

    object = object_get_non_const_referenced(object);
    _cake_zmem(&r, 104);
    r.state = 4;
    r.value_type = 15;
    r.value.void_pointer = object;
    return r;
}

struct object object_make_long_double(long double value)
{
    struct object  r;

    _cake_zmem(&r, 104);
    r.state = 2;
    r.value_type = 13;
    r.value.long_double_value = value;
    return r;
}

long double object_to_long_double(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R28 = a->value_type;
        if (_R28 == 2) goto _CKL1; /*case 2*/
        if (_R28 == 3) goto _CKL2; /*case 3*/
        if (_R28 == 4) goto _CKL3; /*case 4*/
        if (_R28 == 5) goto _CKL4; /*case 5*/
        if (_R28 == 6) goto _CKL5; /*case 6*/
        if (_R28 == 0) goto _CKL6; /*case 0*/
        if (_R28 == 1) goto _CKL7; /*case 1*/
        if (_R28 == 7) goto _CKL8; /*case 7*/
        if (_R28 == 8) goto _CKL9; /*case 8*/
        if (_R28 == 9) goto _CKL10; /*case 9*/
        if (_R28 == 10) goto _CKL11; /*case 10*/
        if (_R28 == 11) goto _CKL12; /*case 11*/
        if (_R28 == 12) goto _CKL13; /*case 12*/
        if (_R28 == 13) goto _CKL14; /*case 13*/
        if (_R28 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            return a->value.bool_value;
            _CKL2:/*case 3*/ 
            return a->value.signed_char_value;
            _CKL3:/*case 4*/ 
            return a->value.unsigned_char_value;
            _CKL4:/*case 5*/ 
            return a->value.signed_short_value;
            _CKL5:/*case 6*/ 
            return a->value.unsigned_short_value;
            _CKL6:/*case 0*/ 
            return a->value.signed_int_value;
            _CKL7:/*case 1*/ 
            return a->value.unsigned_int_value;
            _CKL8:/*case 7*/ 
            return a->value.signed_long_value;
            _CKL9:/*case 8*/ 
            return a->value.unsigned_long_value;
            _CKL10:/*case 9*/ 
            return a->value.signed_long_long_value;
            _CKL11:/*case 10*/ 
            return a->value.unsigned_long_long_value;
            _CKL12:/*case 11*/ 
            return a->value.float_value;
            _CKL13:/*case 12*/ 
            return a->value.double_value;
            _CKL14:/*case 13*/ 
            return a->value.long_double_value;
            _CKL15:/*case 14*/ 
            ;
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    ;
    return 0;
}

struct object object_cast(int t, struct object * v)
{
    struct object  empty;

    v = object_get_referenced(v);
    if (v->value_type == t)
    {
        return *v;
    }
    if (t == 2)
    {
        if (v->value_type == 3)
        {
            return object_make_bool((unsigned char )v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_bool((unsigned char )v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_bool((unsigned char )v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_bool((unsigned char )v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_bool((unsigned char )v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_bool((unsigned char )v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_bool((unsigned char )v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_bool((unsigned char )v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_bool((unsigned char )v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_bool((unsigned char )v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_bool((unsigned char )v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_bool((unsigned char )v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_bool((unsigned char )v->value.long_double_value);
        }
    }
    if (t == 3)
    {
        if (v->value_type == 2)
        {
            return object_make_signed_char((signed char)v->value.bool_value);
        }
        if (v->value_type == 4)
        {
            return object_make_signed_char((signed char)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_signed_char((signed char)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_signed_char((signed char)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_signed_char((signed char)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_signed_char((signed char)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_signed_char((signed char)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_signed_char((signed char)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_signed_char((signed char)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_signed_char((signed char)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_signed_char((signed char)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_signed_char((signed char)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_signed_char((signed char)v->value.long_double_value);
        }
    }
    if (t == 4)
    {
        if (v->value_type == 2)
        {
            return object_make_unsigned_char((unsigned char)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_unsigned_char((unsigned char)v->value.signed_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_unsigned_char((unsigned char)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_unsigned_char((unsigned char)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_unsigned_char((unsigned char)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_unsigned_char((unsigned char)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_unsigned_char((unsigned char)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_unsigned_char((unsigned char)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_unsigned_char((unsigned char)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_unsigned_char((unsigned char)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_unsigned_char((unsigned char)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_unsigned_char((unsigned char)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_unsigned_char((unsigned char)v->value.long_double_value);
        }
    }
    if (t == 5)
    {
        if (v->value_type == 2)
        {
            return object_make_signed_short((signed short)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_signed_short((signed short)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_signed_short((signed short)v->value.unsigned_char_value);
        }
        if (v->value_type == 6)
        {
            return object_make_signed_short((signed short)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_signed_short((signed short)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_signed_short((signed short)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_signed_short((signed short)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_signed_short((signed short)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_signed_short((signed short)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_signed_short((signed short)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_signed_short((signed short)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_signed_short((signed short)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_signed_short((signed short)v->value.long_double_value);
        }
    }
    if (t == 6)
    {
        if (v->value_type == 2)
        {
            return object_make_unsigned_short((unsigned short)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_unsigned_short((unsigned short)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_unsigned_short((unsigned short)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_unsigned_short((unsigned short)v->value.signed_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_unsigned_short((unsigned short)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_unsigned_short((unsigned short)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_unsigned_short((unsigned short)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_unsigned_short((unsigned short)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_unsigned_short((unsigned short)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_unsigned_short((unsigned short)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_unsigned_short((unsigned short)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_unsigned_short((unsigned short)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_unsigned_short((unsigned short)v->value.long_double_value);
        }
    }
    if (t == 0)
    {
        if (v->value_type == 2)
        {
            return object_make_signed_int((signed int)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_signed_int((signed int)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_signed_int((signed int)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_signed_int((signed int)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_signed_int((signed int)v->value.unsigned_short_value);
        }
        if (v->value_type == 1)
        {
            return object_make_signed_int((signed int)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_signed_int((signed int)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_signed_int((signed int)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_signed_int((signed int)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_signed_int((signed int)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_signed_int((signed int)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_signed_int((signed int)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_signed_int((signed int)v->value.long_double_value);
        }
    }
    if (t == 1)
    {
        if (v->value_type == 2)
        {
            return object_make_unsigned_int((unsigned int)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_unsigned_int((unsigned int)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_unsigned_int((unsigned int)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_unsigned_int((unsigned int)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_unsigned_int((unsigned int)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_unsigned_int((unsigned int)v->value.signed_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_unsigned_int((unsigned int)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_unsigned_int((unsigned int)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_unsigned_int((unsigned int)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_unsigned_int((unsigned int)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_unsigned_int((unsigned int)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_unsigned_int((unsigned int)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_unsigned_int((unsigned int)v->value.long_double_value);
        }
    }
    if (t == 7)
    {
        if (v->value_type == 2)
        {
            return object_make_signed_long((signed long)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_signed_long((signed long)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_signed_long((signed long)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_signed_long((signed long)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_signed_long((signed long)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_signed_long((signed long)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_signed_long((signed long)v->value.unsigned_int_value);
        }
        if (v->value_type == 8)
        {
            return object_make_signed_long((signed long)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_signed_long((signed long)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_signed_long((signed long)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_signed_long((signed long)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_signed_long((signed long)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_signed_long((signed long)v->value.long_double_value);
        }
    }
    if (t == 8)
    {
        if (v->value_type == 2)
        {
            return object_make_unsigned_long((unsigned long)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_unsigned_long((unsigned long)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_unsigned_long((unsigned long)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_unsigned_long((unsigned long)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_unsigned_long((unsigned long)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_unsigned_long((unsigned long)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_unsigned_long((unsigned long)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_unsigned_long((unsigned long)v->value.signed_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_unsigned_long((unsigned long)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_unsigned_long((unsigned long)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_unsigned_long((unsigned long)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_unsigned_long((unsigned long)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_unsigned_long((unsigned long)v->value.long_double_value);
        }
    }
    if (t == 9)
    {
        if (v->value_type == 2)
        {
            return object_make_signed_long_long((signed long long)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_signed_long_long((signed long long)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_signed_long_long((signed long long)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_signed_long_long((signed long long)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_signed_long_long((signed long long)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_signed_long_long((signed long long)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_signed_long_long((signed long long)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_signed_long_long((signed long long)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_signed_long_long((signed long long)v->value.unsigned_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_signed_long_long((signed long long)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_signed_long_long((signed long long)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_signed_long_long((signed long long)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_signed_long_long((signed long long)v->value.long_double_value);
        }
    }
    if (t == 10)
    {
        if (v->value_type == 2)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.signed_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_unsigned_long_long((unsigned long long)v->value.long_double_value);
        }
    }
    if (t == 11)
    {
        if (v->value_type == 2)
        {
            return object_make_float((float)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_float((float)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_float((float)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_float((float)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_float((float)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_float((float)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_float((float)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_float((float)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_float((float)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_float((float)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_float((float)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 12)
        {
            return object_make_float((float)v->value.double_value);
        }
        if (v->value_type == 13)
        {
            return object_make_float((float)v->value.long_double_value);
        }
    }
    if (t == 12)
    {
        if (v->value_type == 2)
        {
            return object_make_double((double)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_double((double)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_double((double)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_double((double)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_double((double)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_double((double)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_double((double)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_double((double)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_double((double)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_double((double)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_double((double)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_double((double)v->value.float_value);
        }
        if (v->value_type == 13)
        {
            return object_make_double((double)v->value.long_double_value);
        }
    }
    if (t == 13)
    {
        if (v->value_type == 2)
        {
            return object_make_long_double((long double)v->value.bool_value);
        }
        if (v->value_type == 3)
        {
            return object_make_long_double((long double)v->value.signed_char_value);
        }
        if (v->value_type == 4)
        {
            return object_make_long_double((long double)v->value.unsigned_char_value);
        }
        if (v->value_type == 5)
        {
            return object_make_long_double((long double)v->value.signed_short_value);
        }
        if (v->value_type == 6)
        {
            return object_make_long_double((long double)v->value.unsigned_short_value);
        }
        if (v->value_type == 0)
        {
            return object_make_long_double((long double)v->value.signed_int_value);
        }
        if (v->value_type == 1)
        {
            return object_make_long_double((long double)v->value.unsigned_int_value);
        }
        if (v->value_type == 7)
        {
            return object_make_long_double((long double)v->value.signed_long_value);
        }
        if (v->value_type == 8)
        {
            return object_make_long_double((long double)v->value.unsigned_long_value);
        }
        if (v->value_type == 9)
        {
            return object_make_long_double((long double)v->value.signed_long_long_value);
        }
        if (v->value_type == 10)
        {
            return object_make_long_double((long double)v->value.unsigned_long_long_value);
        }
        if (v->value_type == 11)
        {
            return object_make_long_double((long double)v->value.float_value);
        }
        if (v->value_type == 12)
        {
            return object_make_long_double((long double)v->value.double_value);
        }
    }
    _cake_zmem(&empty, 104);
    return empty;
}

unsigned char  type_is_union(struct type * p_type);

void object_default_initialization(struct object * p_object, unsigned char   is_constant)
{
    if (p_object->members == 0U)
    {
        if (is_constant)
        {
            p_object->state = 2;
        }
        else
        {
            p_object->state = 4;
        }
        p_object->value.unsigned_long_long_value = 0;
    }
    if (type_is_union(&p_object->type))
    {
        struct object * p;

        p = p_object->members;
        if (p)
        {
            object_default_initialization(p, is_constant);
        }
    }
    else
    {
        struct object * p;

        p = p_object->members;
        while (p)
        {
            object_default_initialization(p, is_constant);
            p = p->next;
        }
    }
}

struct object *object_get_non_const_referenced(struct object * p_object)
{
    if (p_object->value_type == 15)
    {
        p_object = p_object->value.void_pointer;
    }
    ;
    return p_object;
}

struct object *object_get_referenced(struct object * p_object)
{
    if (p_object->value_type == 15)
    {
        p_object = p_object->value.void_pointer;
    }
    ;
    return p_object;
}

int get_rank(int t)
{
    if (t == 9 || t == 10)
    {
        return 80;
    }
    else
    {
        if (t == 7 || t == 8)
        {
            return 50;
        }
        else
        {
            if (t == 0 || t == 1)
            {
                return 40;
            }
            else
            {
                if (t == 5 || t == 6)
                {
                    return 30;
                }
                else
                {
                    if (t == 3 || t == 4)
                    {
                        return 20;
                    }
                }
            }
        }
    }
    return 0;
}

int get_size(int t)
{
    if (t == 9 || t == 10)
    {
        return 8U;
    }
    else
    {
        if (t == 7 || t == 8)
        {
            return 4U;
        }
        else
        {
            if (t == 0 || t == 1)
            {
                return 4U;
            }
            else
            {
                if (t == 5 || t == 6)
                {
                    return 2U;
                }
                else
                {
                    if (t == 3 || t == 4)
                    {
                        return 1U;
                    }
                    else
                    {
                        if (t == 14)
                        {
                            return 4U;
                        }
                    }
                }
            }
        }
    }
    return 1;
}

unsigned char  is_signed(int t)
{
    /*switch*/
    {
        register int _R29 = t;
        if (_R29 == 2) goto _CKL1; /*case 2*/
        if (_R29 == 3) goto _CKL2; /*case 3*/
        if (_R29 == 5) goto _CKL3; /*case 5*/
        if (_R29 == 0) goto _CKL4; /*case 0*/
        if (_R29 == 7) goto _CKL5; /*case 7*/
        if (_R29 == 9) goto _CKL6; /*case 9*/
        if (_R29 == 12) goto _CKL7; /*case 12*/
        if (_R29 == 13) goto _CKL8; /*case 13*/
        if (_R29 == 14) goto _CKL9; /*case 14*/
        goto _CKL10;/*default*/

        {
            _CKL1:/*case 2*/ 
            _CKL2:/*case 3*/ 
            _CKL3:/*case 5*/ 
            _CKL4:/*case 0*/ 
            _CKL5:/*case 7*/ 
            _CKL6:/*case 9*/ 
            _CKL7:/*case 12*/ 
            _CKL8:/*case 13*/ 
            return 1;
            _CKL9:/*case 14*/ 
            goto _CKL0; /*break*/

            _CKL10: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

int to_unsigned(int t)
{
    /*switch*/
    {
        register int _R30 = t;
        if (_R30 == 3) goto _CKL1; /*case 3*/
        if (_R30 == 5) goto _CKL2; /*case 5*/
        if (_R30 == 0) goto _CKL3; /*case 0*/
        if (_R30 == 7) goto _CKL4; /*case 7*/
        if (_R30 == 9) goto _CKL5; /*case 9*/
        goto _CKL6;/*default*/

        {
            _CKL1:/*case 3*/ 
            return 4;
            _CKL2:/*case 5*/ 
            return 6;
            _CKL3:/*case 0*/ 
            return 1;
            _CKL4:/*case 7*/ 
            return 8;
            _CKL5:/*case 9*/ 
            return 10;
            _CKL6: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return t;
}

unsigned char  is_unsigned(int t)
{
    /*switch*/
    {
        register int _R31 = t;
        if (_R31 == 2) goto _CKL1; /*case 2*/
        if (_R31 == 4) goto _CKL2; /*case 4*/
        if (_R31 == 6) goto _CKL3; /*case 6*/
        if (_R31 == 1) goto _CKL4; /*case 1*/
        if (_R31 == 8) goto _CKL5; /*case 8*/
        if (_R31 == 10) goto _CKL6; /*case 10*/
        goto _CKL7;/*default*/

        {
            _CKL1:/*case 2*/ 
            _CKL2:/*case 4*/ 
            _CKL3:/*case 6*/ 
            _CKL4:/*case 1*/ 
            _CKL5:/*case 8*/ 
            _CKL6:/*case 10*/ 
            return 1;
            _CKL7: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

void object_set_any(struct object * p_object)
{
    struct object * p;

    p_object = object_get_non_const_referenced(p_object);
    p_object->state = 1;
    p = p_object->members;
    while (p)
    {
        object_set_any(p);
        p = p->next;
    }
}

unsigned char  object_is_signed(struct object * p_object)
{
    p_object = (struct object *)object_get_referenced(p_object);
    return is_signed(p_object->value_type);
}

unsigned char  object_is_derived(struct object * p_object)
{
    if (p_object->value_type == 15)
    {
        return 0;
    }
    return !!(p_object->members != 0U);
}

unsigned char  object_is_reference(struct object * p_object)
{
    return !!(p_object->value_type == 15);
}

static void object_fix_parent(struct object * p_object, struct object * parent)
{
    struct object * it;

    it = p_object->members;
    while (it)
    {
        it->parent = parent;
        it = it->next;
    }
}

struct object *object_get_member(struct object * p_object, int index)
{
    struct object * it;
    int count;

    p_object = (struct object *)object_get_referenced(p_object);
    if (p_object->members == 0U)
    {
        return 0U;
    }
    it = p_object->members;
    count = 0;
    while (it)
    {
        if (index == count)
        {
            return it;
        }
        count++;
        it = it->next;
    }
    return 0U;
}

unsigned char  type_is_pointer_or_array(struct type * p_type);
unsigned char  type_is_function(struct type * p_type);
unsigned char  compiler_diagnostic(int w, struct parser_ctx * ctx, struct token * p_token, struct marker * p_marker, char * fmt, ...);

int object_set(struct parser_ctx * ctx, struct object * to, struct expression * p_init_expression, struct object * from, unsigned char   is_constant, unsigned char   requires_constant_initialization)
{
    if (1) /*try*/
    {
        from = object_get_referenced(from);
        to->p_init_expression = p_init_expression;
        if (object_is_derived(to))
        {
            struct object * it_to;
            struct object * it_from;

            it_to = to->members;
            it_from = from->members;
            while (it_from && it_to)
            {
                object_set(ctx, it_to, 0U, it_from, is_constant, requires_constant_initialization);
                it_to = it_to->next;
                it_from = it_from->next;
            }
            if (it_from != 0U || it_to != 0U)
            {
            }
        }
        else
        {
            ;
            to->state = from->state;
            to->value = object_cast(to->value_type, from).value;
            if (requires_constant_initialization && !object_has_constant_value(from))
            {
                if (!type_is_pointer_or_array(&p_init_expression->type) && !type_is_function(&p_init_expression->type))
                {
                    struct token * tk;

                    tk = p_init_expression ? p_init_expression->first_token : ctx->current;
                    compiler_diagnostic(1860, ctx, tk, 0U, "requires a compile time object");
                    goto _CKL0;/*throw*/
                }
            }
            if (is_constant)
            {
                if (to->state == 2 || to->state == 4)
                {
                    to->state = 2;
                }
            }
            else
            {
                if (to->state == 2)
                {
                    to->state = 4;
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        return 1;
    }
    return 0;
}

struct type type_dup(struct type * p_type);
struct type get_array_item_type(struct type * p_type);
int type_to_object_type(struct type * type);
struct struct_or_union_specifier *get_complete_struct_or_union_specifier(struct struct_or_union_specifier * p_struct_or_union_specifier);

struct object *make_object_ptr_core(struct type * p_type, char * name)
{
    struct object * p_object;

    p_object = 0U;
    if (1) /*try*/
    {
        struct struct_or_union_specifier * p_struct_or_union_specifier;
        struct object * p_last_member_obj;
        struct member_declaration * p_member_declaration;

        if (p_type->category == 1)
        {
            p_object = calloc(1, 104U);
            if (p_object == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_object->debug_name = strdup(name);
            p_object->type = type_dup(p_type);
            return p_object;
        }
        if (p_type->category == 3)
        {
            p_object = calloc(1, 104U);
            if (p_object == 0U)
            {
                goto _CKL0;/*throw*/
            }
            *p_object = object_make_nullptr();
            p_object->state = 0;
            ;
            p_object->debug_name = strdup(name);
            type_destroy(&p_object->type);
            p_object->type = type_dup(p_type);
            return p_object;
        }
        if (p_type->category == 2)
        {
            p_object = calloc(1, 104U);
            if (p_object == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_object->type = type_dup(p_type);
            p_object->debug_name = strdup(name);
            if (p_type->num_of_elements > 0)
            {
                struct type  array_item_type;
                unsigned long long max_elements;
                struct object * p_tail_object;

                array_item_type = get_array_item_type(p_type);
                max_elements = p_type->num_of_elements > 1000 ? 1000 : p_type->num_of_elements;
                p_tail_object = 0U;
                {
                    unsigned long long i;
                    i = 0;
                    for (; i < max_elements; i++)
                    {
                        char buffer[200];
                        struct object * p_member_obj;

                        _cake_zmem(&buffer, 200);
                        snprintf(buffer, 200U, "%s[%llu]", name, i);
                        p_member_obj = make_object_ptr_core(&array_item_type, buffer);
                        if (p_member_obj == 0U)
                        {
                            type_destroy(&array_item_type);
                            goto _CKL0;/*throw*/
                        }
                        p_member_obj->parent = p_object;
                        free(p_member_obj->debug_name);
                        p_member_obj->debug_name = strdup(buffer);
                        if (p_tail_object == 0U)
                        {
                            ;
                            p_object->members = p_member_obj;
                        }
                        else
                        {
                            ;
                            p_tail_object->next = p_member_obj;
                        }
                        p_tail_object = p_member_obj;
                    }
                }
                type_destroy(&array_item_type);
            }
            return p_object;
        }
        if (p_type->struct_or_union_specifier == 0U)
        {
            p_object = calloc(1, 104U);
            if (p_object == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_object->state = 0;
            p_object->value_type = type_to_object_type(p_type);
            p_object->value.signed_long_long_value = -1;
            p_object->debug_name = strdup(name);
            p_object->type = type_dup(p_type);
            return p_object;
        }
        p_struct_or_union_specifier = get_complete_struct_or_union_specifier(p_type->struct_or_union_specifier);
        if (p_struct_or_union_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_object = calloc(1, 104U);
        if (p_object == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_object->debug_name = strdup(name);
        p_object->type = type_dup(p_type);
        p_last_member_obj = 0U;
        p_member_declaration = p_struct_or_union_specifier->member_declaration_list.head;
        while (p_member_declaration)
        {
            if (p_member_declaration->member_declarator_list_opt)
            {
                struct member_declarator * p_member_declarator;

                p_member_declarator = p_member_declaration->member_declarator_list_opt->head;
                while (p_member_declarator)
                {
                    if (p_member_declarator->declarator)
                    {
                        char buffer[200];
                        struct object * p_member_obj;

                        _cake_zmem(&buffer, 200);
                        snprintf(buffer, 200U, "%s.%s", name, p_member_declarator->declarator->name_opt->lexeme);
                        p_member_obj = make_object_ptr_core(&p_member_declarator->declarator->type, buffer);
                        if (p_member_obj == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                        p_member_obj->parent = p_object;
                        free(p_member_obj->debug_name);
                        p_member_obj->debug_name = strdup(buffer);
                        if (p_object->members == 0U)
                        {
                            p_object->members = p_member_obj;
                        }
                        else
                        {
                            p_last_member_obj->next = p_member_obj;
                        }
                        p_last_member_obj = p_member_obj;
                    }
                    p_member_declarator = p_member_declarator->next;
                }
            }
            else
            {
                if (p_member_declaration->specifier_qualifier_list != 0U)
                {
                    if (p_member_declaration->specifier_qualifier_list->struct_or_union_specifier)
                    {
                        struct type  t;
                        char buffer[200];
                        struct object * p_member_obj;

                        _cake_zmem(&t, 68);
                        t.category = 0;
                        t.struct_or_union_specifier = p_member_declaration->specifier_qualifier_list->struct_or_union_specifier;
                        t.type_specifier_flags = 32768;
                        _cake_zmem(&buffer, 200);
                        snprintf(buffer, 200U, ".%s", name);
                        p_member_obj = make_object_ptr_core(&t, buffer);
                        if (p_member_obj == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                        free(p_member_obj->debug_name);
                        p_member_obj->debug_name = strdup(buffer);
                        p_member_obj->parent = p_object;
                        if (p_last_member_obj == 0U)
                        {
                            ;
                            p_object->members = p_member_obj;
                        }
                        else
                        {
                            p_last_member_obj->next = p_member_obj;
                        }
                        p_last_member_obj = p_member_obj;
                        type_destroy(&t);
                    }
                }
            }
            p_member_declaration = p_member_declaration->next;
        }
        return p_object;
    }
    else _CKL0: /*catch*/ 
    {
        object_delete(p_object);
        p_object = 0U;
    }
    return 0U;
}

struct object *make_object_ptr(struct type * p_type)
{
    return make_object_ptr_core(p_type, "");
}

int make_object_with_name(struct type * p_type, struct object * obj, char * name)
{
    struct object * p;

    p = make_object_ptr_core(p_type, name);
    if (p)
    {
        *obj = *p;
        object_fix_parent(obj, obj);
        free(p);
        return 0;
    }
    return 1;
}

struct object object_dup(struct object * src)
{
    struct object  result;

    ;
    result = *src;
    result.type = type_dup(&src->type);
    if (src->debug_name)
    {
        result.debug_name = strdup(src->debug_name);
    }
    result.next = 0U;
    return result;
}

int make_object(struct type * p_type, struct object * obj)
{
    return make_object_with_name(p_type, obj, "");
}

int type_specifier_to_object_type(int type_specifier_flags)
{
    if (type_specifier_flags & 512)
    {
        return 2;
    }
    if (type_specifier_flags & 32)
    {
        return 11;
    }
    if (type_specifier_flags & 64)
    {
        if (type_specifier_flags & 16)
        {
            return 13;
        }
        return 12;
    }
    if (type_specifier_flags & 256)
    {
        if (type_specifier_flags & 2)
        {
            return 4;
        }
        if (type_specifier_flags & 4)
        {
            return 6;
        }
        if (type_specifier_flags & 16)
        {
            return 8;
        }
        if (type_specifier_flags & 8)
        {
            return 1;
        }
        if (type_specifier_flags & 4194304)
        {
            return 10;
        }
    }
    else
    {
        if (type_specifier_flags & 2)
        {
            return 3;
        }
        if (type_specifier_flags & 4)
        {
            return 5;
        }
        if (type_specifier_flags & 16)
        {
            return 7;
        }
        if (type_specifier_flags & 8)
        {
            return 0;
        }
        if (type_specifier_flags & 4194304)
        {
            return 9;
        }
    }
    return 0;
}

unsigned char  type_is_pointer(struct type * p_type);

int type_to_object_type(struct type * type)
{
    if (type_is_pointer(type))
    {
        return 1;
    }
    return type_specifier_to_object_type(type->type_specifier_flags);
}

void object_print_value_debug(struct object * a)
{
    a = object_get_referenced(a);
    /*switch*/
    {
        register int _R32 = a->value_type;
        if (_R32 == 2) goto _CKL1; /*case 2*/
        if (_R32 == 3) goto _CKL2; /*case 3*/
        if (_R32 == 4) goto _CKL3; /*case 4*/
        if (_R32 == 5) goto _CKL4; /*case 5*/
        if (_R32 == 6) goto _CKL5; /*case 6*/
        if (_R32 == 0) goto _CKL6; /*case 0*/
        if (_R32 == 1) goto _CKL7; /*case 1*/
        if (_R32 == 7) goto _CKL8; /*case 7*/
        if (_R32 == 8) goto _CKL9; /*case 8*/
        if (_R32 == 9) goto _CKL10; /*case 9*/
        if (_R32 == 10) goto _CKL11; /*case 10*/
        if (_R32 == 11) goto _CKL12; /*case 11*/
        if (_R32 == 12) goto _CKL13; /*case 12*/
        if (_R32 == 13) goto _CKL14; /*case 13*/
        if (_R32 == 14) goto _CKL15; /*case 14*/
        goto _CKL0;

        {
            _CKL1:/*case 2*/ 
            printf("%s (bool)", a->value.bool_value ? "true" : "false");
            goto _CKL0; /*break*/

            _CKL2:/*case 3*/ 
            printf("%d (signed char)", (int)a->value.signed_char_value);
            goto _CKL0; /*break*/

            _CKL3:/*case 4*/ 
            printf("%d (unsigned char)", (int)a->value.unsigned_char_value);
            goto _CKL0; /*break*/

            _CKL4:/*case 5*/ 
            printf("%d (short)", a->value.signed_short_value);
            goto _CKL0; /*break*/

            _CKL5:/*case 6*/ 
            printf("%d (unsigned short)", a->value.unsigned_short_value);
            goto _CKL0; /*break*/

            _CKL6:/*case 0*/ 
            printf("%d (int)", a->value.signed_int_value);
            goto _CKL0; /*break*/

            _CKL7:/*case 1*/ 
            printf("%du (unsigned int)", a->value.unsigned_int_value);
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            printf("%ld (long)", a->value.signed_long_value);
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            printf("%lu (unsigned long)", a->value.unsigned_long_value);
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            printf("%lld (long long)", a->value.signed_long_long_value);
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            printf("%llu (unsigned long long)", a->value.unsigned_long_long_value);
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            printf("%f (float)", a->value.float_value);
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            printf("%lf (double)", a->value.double_value);
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            printf("%Lf (long double)", a->value.long_double_value);
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            printf("%p (void*)", a->value.void_pointer);
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
}

void type_print(struct type * a);

void object_print_to_debug_core(struct object * object, int n)
{
    if (object_is_reference(object))
    {
        object = object_get_referenced(object);
    }
    {
        int i;
        i = 0;
        for (; i < n; i++)
        printf("  ");
    }
    if (object->debug_name)
    {
        printf("%s ", object->debug_name);
    }
    if (object->members != 0U)
    {
        struct object * member;

        type_print(&object->type);
        printf(" {\n");
        member = object->members;
        while (member)
        {
            object_print_to_debug_core(member, n + 1);
            member = member->next;
        }
        {
            int i;
            i = 0;
            for (; i < n; i++)
            printf("  ");
        }
        printf("}\n");
    }
    else
    {
        type_print(&object->type);
        printf(" = ");
        object_print_value_debug(object);
        /*switch*/
        {
            register int _R33 = object->state;
            if (_R33 == 0) goto _CKL4; /*case 0*/
            if (_R33 == 1) goto _CKL5; /*case 1*/
            if (_R33 == 4) goto _CKL6; /*case 4*/
            if (_R33 == 2) goto _CKL7; /*case 2*/
            goto _CKL3;

            {
                _CKL4:/*case 0*/ 
                printf(" uninitialized ");
                goto _CKL3; /*break*/

                _CKL5:/*case 1*/ 
                printf(" unknown ");
                goto _CKL3; /*break*/

                _CKL6:/*case 4*/ 
                printf(" exact ");
                goto _CKL3; /*break*/

                _CKL7:/*case 2*/ 
                printf(" constant_exact ");
                goto _CKL3; /*break*/

            }
            _CKL3:;
        }
        printf("\n");
    }
}

void object_print_to_debug(struct object * object)
{
    int n;

    n = 0;
    object_print_to_debug_core(object, n);
}

struct object *object_extend_array_to_index(struct type * p_type, struct object * a, unsigned int max_index, unsigned char   is_constant)
{
    struct object * it;

    it = a->members;
    if (1) /*try*/
    {
        int count;

        count = 0;
        while (it)
        {
            count++;
            if (it->next == 0U)
            {
                break;
            }
            it = it->next;
        }
        while (count < (max_index + 1))
        {
            if (it == 0U)
            {
                char name[100];

                ;
                a->members = make_object_ptr(p_type);
                if (a->members == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                _cake_zmem(&name, 100);
                snprintf(name, 100U, "[%d]", count);
                free((void *)a->members->debug_name);
                a->members->debug_name = strdup(name);
                object_default_initialization(a->members, is_constant);
                it = a->members;
                it->parent = a;
                count++;
            }
            else
            {
                struct object * p;
                char name[100];

                p = make_object_ptr(p_type);
                if (p == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                _cake_zmem(&name, 100);
                snprintf(name, 100U, "[%d]", count);
                free((void *)p->debug_name);
                p->debug_name = strdup(name);
                p->parent = a;
                object_default_initialization(p, is_constant);
                ;
                it->next = p;
                it = p;
                count++;
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return it;
}

unsigned char  object_is_promoted(struct object * a)
{
    if ((a->value_type == 2) || (a->value_type == 3) || (a->value_type == 4) || (a->value_type == 5) || a->value_type == 6)
    {
        return 1;
    }
    return 0;
}

int object_common(struct object * a, struct object * b)
{
    int a_type;
    int b_type;
    int signed_promoted;
    int unsigned_promoted;

    a_type = a->value_type;
    b_type = b->value_type;
    if (a_type == 13 || b_type == 13)
    {
        return 13;
    }
    if (a_type == 12 || b_type == 12)
    {
        return 13;
    }
    if (a_type == 11 || b_type == 11)
    {
        return 11;
    }
    if (object_is_promoted(a))
    {
        a_type = 0;
    }
    if (object_is_promoted(b))
    {
        b_type = 0;
    }
    if (a_type == b_type)
    {
        return a_type;
    }
    if (is_signed(a_type) == is_signed(b_type))
    {
        if (get_rank(a_type) > get_rank(b_type))
        {
            return a_type;
        }
        return b_type;
    }
    signed_promoted = is_signed(a_type) ? a_type : b_type;
    unsigned_promoted = is_unsigned(a_type) ? a_type : b_type;
    if (get_rank(unsigned_promoted) >= get_rank(signed_promoted))
    {
        return unsigned_promoted;
    }
    if (get_size(signed_promoted) > get_size(unsigned_promoted))
    {
        return signed_promoted;
    }
    return to_unsigned(signed_promoted);
}

int object_greater_than_or_equal(struct object * a, struct object * b)
{
    int common_type;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R34 = common_type;
        if (_R34 == 0) goto _CKL1; /*case 0*/
        if (_R34 == 1) goto _CKL2; /*case 1*/
        if (_R34 == 2) goto _CKL3; /*case 2*/
        if (_R34 == 3) goto _CKL4; /*case 3*/
        if (_R34 == 4) goto _CKL5; /*case 4*/
        if (_R34 == 5) goto _CKL6; /*case 5*/
        if (_R34 == 6) goto _CKL7; /*case 6*/
        if (_R34 == 7) goto _CKL8; /*case 7*/
        if (_R34 == 8) goto _CKL9; /*case 8*/
        if (_R34 == 9) goto _CKL10; /*case 9*/
        if (_R34 == 10) goto _CKL11; /*case 10*/
        if (_R34 == 11) goto _CKL12; /*case 11*/
        if (_R34 == 12) goto _CKL13; /*case 12*/
        if (_R34 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_to_signed_int(a) >= object_to_signed_int(b);
            _CKL2:/*case 1*/ 
            return object_to_unsigned_int(a) >= object_to_unsigned_int(b);
            _CKL3:/*case 2*/ 
            return object_to_bool(a) >= object_to_bool(b);
            _CKL4:/*case 3*/ 
            return object_to_signed_char(a) >= object_to_signed_char(b);
            goto _CKL0; /*break*/

            _CKL5:/*case 4*/ 
            return object_to_unsigned_char(a) >= object_to_unsigned_char(b);
            _CKL6:/*case 5*/ 
            return object_to_signed_short(a) >= object_to_signed_short(b);
            _CKL7:/*case 6*/ 
            return object_to_unsigned_short(a) >= object_to_unsigned_short(b);
            _CKL8:/*case 7*/ 
            return object_to_signed_long(a) >= object_to_signed_long(b);
            _CKL9:/*case 8*/ 
            return object_to_unsigned_long(a) >= object_to_unsigned_long(b);
            _CKL10:/*case 9*/ 
            return object_to_signed_long_long(a) >= object_to_signed_long_long(b);
            _CKL11:/*case 10*/ 
            return object_to_unsigned_long_long(a) >= object_to_unsigned_long_long(b);
            _CKL12:/*case 11*/ 
            return object_to_float(a) >= object_to_float(b);
            _CKL13:/*case 12*/ 
            return object_to_double(a) >= object_to_double(b);
            _CKL14:/*case 13*/ 
            return object_to_long_double(a) >= object_to_long_double(b);
        }
        _CKL0:;
    }
    ;
    return object_to_unsigned_long_long(a) >= object_to_unsigned_long_long(b);
}

int object_smaller_than_or_equal(struct object * a, struct object * b)
{
    int common_type;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R35 = common_type;
        if (_R35 == 0) goto _CKL1; /*case 0*/
        if (_R35 == 1) goto _CKL2; /*case 1*/
        if (_R35 == 2) goto _CKL3; /*case 2*/
        if (_R35 == 3) goto _CKL4; /*case 3*/
        if (_R35 == 4) goto _CKL5; /*case 4*/
        if (_R35 == 5) goto _CKL6; /*case 5*/
        if (_R35 == 6) goto _CKL7; /*case 6*/
        if (_R35 == 7) goto _CKL8; /*case 7*/
        if (_R35 == 8) goto _CKL9; /*case 8*/
        if (_R35 == 9) goto _CKL10; /*case 9*/
        if (_R35 == 10) goto _CKL11; /*case 10*/
        if (_R35 == 11) goto _CKL12; /*case 11*/
        if (_R35 == 12) goto _CKL13; /*case 12*/
        if (_R35 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_to_signed_int(a) <= object_to_signed_int(b);
            _CKL2:/*case 1*/ 
            return object_to_unsigned_int(a) <= object_to_unsigned_int(b);
            _CKL3:/*case 2*/ 
            return object_to_bool(a) <= object_to_bool(b);
            _CKL4:/*case 3*/ 
            return object_to_signed_char(a) <= object_to_signed_char(b);
            goto _CKL0; /*break*/

            _CKL5:/*case 4*/ 
            return object_to_unsigned_char(a) <= object_to_unsigned_char(b);
            _CKL6:/*case 5*/ 
            return object_to_signed_short(a) <= object_to_signed_short(b);
            _CKL7:/*case 6*/ 
            return object_to_unsigned_short(a) <= object_to_unsigned_short(b);
            _CKL8:/*case 7*/ 
            return object_to_signed_long(a) <= object_to_signed_long(b);
            _CKL9:/*case 8*/ 
            return object_to_unsigned_long(a) <= object_to_unsigned_long(b);
            _CKL10:/*case 9*/ 
            return object_to_signed_long_long(a) <= object_to_signed_long_long(b);
            _CKL11:/*case 10*/ 
            return object_to_unsigned_long_long(a) <= object_to_unsigned_long_long(b);
            _CKL12:/*case 11*/ 
            return object_to_float(a) <= object_to_float(b);
            _CKL13:/*case 12*/ 
            return object_to_double(a) <= object_to_double(b);
            _CKL14:/*case 13*/ 
            return object_to_long_double(a) <= object_to_long_double(b);
        }
        _CKL0:;
    }
    ;
    return object_to_unsigned_long_long(a) <= object_to_unsigned_long_long(b);
}

struct object object_add(struct object * a, struct object * b)
{
    int common_type;
    struct object  o;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R36 = common_type;
        if (_R36 == 0) goto _CKL1; /*case 0*/
        if (_R36 == 1) goto _CKL2; /*case 1*/
        if (_R36 == 2) goto _CKL3; /*case 2*/
        if (_R36 == 7) goto _CKL4; /*case 7*/
        if (_R36 == 8) goto _CKL5; /*case 8*/
        if (_R36 == 9) goto _CKL6; /*case 9*/
        if (_R36 == 10) goto _CKL7; /*case 10*/
        if (_R36 == 11) goto _CKL8; /*case 11*/
        if (_R36 == 12) goto _CKL9; /*case 12*/
        if (_R36 == 13) goto _CKL10; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_make_signed_int(object_to_signed_int(a) + object_to_signed_int(b));
            _CKL2:/*case 1*/ 
            return object_make_unsigned_int(object_to_unsigned_int(a) + object_to_unsigned_int(b));
            _CKL3:/*case 2*/ 
            return object_make_bool(object_to_bool(a) + object_to_bool(b));
            _CKL4:/*case 7*/ 
            return object_make_signed_long(object_to_signed_long(a) + object_to_signed_long(b));
            _CKL5:/*case 8*/ 
            return object_make_unsigned_long(object_to_unsigned_long(a) + object_to_unsigned_long(b));
            _CKL6:/*case 9*/ 
            return object_make_signed_long_long(object_to_signed_long_long(a) + object_to_signed_long_long(b));
            _CKL7:/*case 10*/ 
            return object_make_unsigned_long_long(object_to_unsigned_long_long(a) + object_to_unsigned_long_long(b));
            _CKL8:/*case 11*/ 
            return object_make_float(object_to_float(a) + object_to_float(b));
            _CKL9:/*case 12*/ 
            return object_make_double(object_to_double(a) + object_to_double(b));
            _CKL10:/*case 13*/ 
            return object_make_long_double(object_to_long_double(a) + object_to_long_double(b));
        }
        _CKL0:;
    }
    ;
    _cake_zmem(&o, 104);
    return o;
}

struct object object_sub(struct object * a, struct object * b)
{
    int common_type;
    struct object  o;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R37 = common_type;
        if (_R37 == 0) goto _CKL1; /*case 0*/
        if (_R37 == 1) goto _CKL2; /*case 1*/
        if (_R37 == 2) goto _CKL3; /*case 2*/
        if (_R37 == 7) goto _CKL4; /*case 7*/
        if (_R37 == 8) goto _CKL5; /*case 8*/
        if (_R37 == 9) goto _CKL6; /*case 9*/
        if (_R37 == 10) goto _CKL7; /*case 10*/
        if (_R37 == 11) goto _CKL8; /*case 11*/
        if (_R37 == 12) goto _CKL9; /*case 12*/
        if (_R37 == 13) goto _CKL10; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_make_signed_int(object_to_signed_int(a) - object_to_signed_int(b));
            _CKL2:/*case 1*/ 
            return object_make_unsigned_int(object_to_unsigned_int(a) - object_to_unsigned_int(b));
            _CKL3:/*case 2*/ 
            return object_make_bool(object_to_bool(a) - object_to_bool(b));
            _CKL4:/*case 7*/ 
            return object_make_signed_long(object_to_signed_long(a) - object_to_signed_long(b));
            _CKL5:/*case 8*/ 
            return object_make_unsigned_long(object_to_unsigned_long(a) - object_to_unsigned_long(b));
            _CKL6:/*case 9*/ 
            return object_make_signed_long_long(object_to_signed_long_long(a) - object_to_signed_long_long(b));
            _CKL7:/*case 10*/ 
            return object_make_unsigned_long_long(object_to_unsigned_long_long(a) - object_to_unsigned_long_long(b));
            _CKL8:/*case 11*/ 
            return object_make_float(object_to_float(a) - object_to_float(b));
            _CKL9:/*case 12*/ 
            return object_make_double(object_to_double(a) - object_to_double(b));
            _CKL10:/*case 13*/ 
            return object_make_long_double(object_to_long_double(a) - object_to_long_double(b));
        }
        _CKL0:;
    }
    ;
    _cake_zmem(&o, 104);
    return o;
}

int object_equal(struct object * a, struct object * b)
{
    int common_type;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R38 = common_type;
        if (_R38 == 0) goto _CKL1; /*case 0*/
        if (_R38 == 1) goto _CKL2; /*case 1*/
        if (_R38 == 2) goto _CKL3; /*case 2*/
        if (_R38 == 3) goto _CKL4; /*case 3*/
        if (_R38 == 4) goto _CKL5; /*case 4*/
        if (_R38 == 5) goto _CKL6; /*case 5*/
        if (_R38 == 6) goto _CKL7; /*case 6*/
        if (_R38 == 7) goto _CKL8; /*case 7*/
        if (_R38 == 8) goto _CKL9; /*case 8*/
        if (_R38 == 9) goto _CKL10; /*case 9*/
        if (_R38 == 10) goto _CKL11; /*case 10*/
        if (_R38 == 11) goto _CKL12; /*case 11*/
        if (_R38 == 12) goto _CKL13; /*case 12*/
        if (_R38 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_to_signed_int(a) == object_to_signed_int(b);
            _CKL2:/*case 1*/ 
            return object_to_unsigned_int(a) == object_to_unsigned_int(b);
            _CKL3:/*case 2*/ 
            return object_to_bool(a) == object_to_bool(b);
            _CKL4:/*case 3*/ 
            return object_to_signed_char(a) == object_to_signed_char(b);
            goto _CKL0; /*break*/

            _CKL5:/*case 4*/ 
            return object_to_unsigned_char(a) == object_to_unsigned_char(b);
            _CKL6:/*case 5*/ 
            return object_to_signed_short(a) == object_to_signed_short(b);
            _CKL7:/*case 6*/ 
            return object_to_unsigned_short(a) == object_to_unsigned_short(b);
            _CKL8:/*case 7*/ 
            return object_to_signed_long(a) == object_to_signed_long(b);
            _CKL9:/*case 8*/ 
            return object_to_unsigned_long(a) == object_to_unsigned_long(b);
            _CKL10:/*case 9*/ 
            return object_to_signed_long_long(a) == object_to_signed_long_long(b);
            _CKL11:/*case 10*/ 
            return object_to_unsigned_long_long(a) == object_to_unsigned_long_long(b);
            _CKL12:/*case 11*/ 
            return object_to_float(a) == object_to_float(b);
            _CKL13:/*case 12*/ 
            return object_to_double(a) == object_to_double(b);
            _CKL14:/*case 13*/ 
            return object_to_long_double(a) == object_to_long_double(b);
        }
        _CKL0:;
    }
    ;
    return object_to_unsigned_long_long(a) == object_to_unsigned_long_long(b);
}

int object_not_equal(struct object * a, struct object * b)
{
    int common_type;

    a = object_get_referenced(a);
    b = object_get_referenced(b);
    common_type = object_common(a, b);
    /*switch*/
    {
        register int _R39 = common_type;
        if (_R39 == 0) goto _CKL1; /*case 0*/
        if (_R39 == 1) goto _CKL2; /*case 1*/
        if (_R39 == 2) goto _CKL3; /*case 2*/
        if (_R39 == 3) goto _CKL4; /*case 3*/
        if (_R39 == 4) goto _CKL5; /*case 4*/
        if (_R39 == 5) goto _CKL6; /*case 5*/
        if (_R39 == 6) goto _CKL7; /*case 6*/
        if (_R39 == 7) goto _CKL8; /*case 7*/
        if (_R39 == 8) goto _CKL9; /*case 8*/
        if (_R39 == 9) goto _CKL10; /*case 9*/
        if (_R39 == 10) goto _CKL11; /*case 10*/
        if (_R39 == 11) goto _CKL12; /*case 11*/
        if (_R39 == 12) goto _CKL13; /*case 12*/
        if (_R39 == 13) goto _CKL14; /*case 13*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            return object_to_signed_int(a) != object_to_signed_int(b);
            _CKL2:/*case 1*/ 
            return object_to_unsigned_int(a) != object_to_unsigned_int(b);
            _CKL3:/*case 2*/ 
            return object_to_bool(a) != object_to_bool(b);
            _CKL4:/*case 3*/ 
            return object_to_signed_char(a) != object_to_signed_char(b);
            goto _CKL0; /*break*/

            _CKL5:/*case 4*/ 
            return object_to_unsigned_char(a) != object_to_unsigned_char(b);
            _CKL6:/*case 5*/ 
            return object_to_signed_short(a) != object_to_signed_short(b);
            _CKL7:/*case 6*/ 
            return object_to_unsigned_short(a) != object_to_unsigned_short(b);
            _CKL8:/*case 7*/ 
            return object_to_signed_long(a) != object_to_signed_long(b);
            _CKL9:/*case 8*/ 
            return object_to_unsigned_long(a) != object_to_unsigned_long(b);
            _CKL10:/*case 9*/ 
            return object_to_signed_long_long(a) != object_to_signed_long_long(b);
            _CKL11:/*case 10*/ 
            return object_to_unsigned_long_long(a) != object_to_unsigned_long_long(b);
            _CKL12:/*case 11*/ 
            return object_to_float(a) != object_to_float(b);
            _CKL13:/*case 12*/ 
            return object_to_double(a) != object_to_double(b);
            _CKL14:/*case 13*/ 
            return object_to_long_double(a) != object_to_long_double(b);
        }
        _CKL0:;
    }
    ;
    return object_to_unsigned_long_long(a) != object_to_unsigned_long_long(b);
}

void objects_destroy(struct objects * arr)
{
    free(arr->items);
}

int objects_push(struct objects * arr, struct object * obj)
{
    if (arr->items == 0U)
    {
        arr->items = malloc(32);
        if (!arr->items)
        {
            arr->size = 0;
            arr->capacity = 0;
            return 12;
        }
        arr->size = 0;
        arr->capacity = 8;
    }
    if (arr->size == arr->capacity)
    {
        unsigned int new_capacity;
        struct object ** new_items;

        new_capacity = arr->capacity ? arr->capacity * 2 : 8;
        new_items = realloc(arr->items, new_capacity * 4U);
        if (!new_items)
        {
            return 12;
        }
        arr->items = new_items;
        arr->capacity = new_capacity;
    }
    arr->items[arr->size++] = obj;
    return 0;
}

struct param_list *type_get_func_or_func_ptr_params(struct type * p_type);
unsigned char  type_is_void(struct type * p_type);
void check_assigment(struct parser_ctx * ctx, struct type * left_type, struct expression * right, int assigment_type);

static int compare_function_arguments(struct parser_ctx * ctx, struct type * p_type, struct argument_expression_list * p_argument_expression_list)
{
    if (1) /*try*/
    {
        struct param * p_current_parameter_type;
        struct param_list * p_param_list;
        struct argument_expression * p_current_argument;

        p_current_parameter_type = 0U;
        p_param_list = type_get_func_or_func_ptr_params(p_type);
        if (p_param_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_current_parameter_type = p_param_list->head;
        p_current_argument = p_argument_expression_list->head;
        if (p_current_parameter_type && type_is_void(&p_current_parameter_type->type))
        {
            p_current_parameter_type = 0U;
        }
        while (p_current_argument && p_current_parameter_type)
        {
            check_assigment(ctx, &p_current_parameter_type->type, p_current_argument->expression, 1);
            p_current_argument = p_current_argument->next;
            p_current_parameter_type = p_current_parameter_type->next;
        }
        if (p_current_argument != 0U && !p_param_list->is_var_args)
        {
            compiler_diagnostic(660, ctx, p_current_argument->expression->first_token, 0U, "too many arguments");
            goto _CKL0;/*throw*/
        }
        if (p_current_parameter_type != 0U && !p_param_list->is_void)
        {
            if (p_argument_expression_list->tail)
            {
                compiler_diagnostic(670, ctx, p_argument_expression_list->tail->expression->first_token, 0U, "too few arguments");
            }
            else
            {
                compiler_diagnostic(670, ctx, ctx->current, 0U, "too few arguments");
            }
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        return 1;
    }
    return 0;
}

struct enumerator *find_enumerator(struct parser_ctx * ctx, char * lexeme, struct scope ** ppscope_opt);

unsigned char  is_enumeration_constant(struct parser_ctx * ctx)
{
    unsigned char   is_enumerator;

    if (ctx->current == 0U)
    {
        return 0;
    }
    if (ctx->current->type != 8996)
    {
        return 0;
    }
    if (ctx->current->flags & 128)
    {
        return 1;
    }
    if (ctx->current->flags & 256)
    {
        return 0;
    }
    is_enumerator = !!(find_enumerator(ctx, ctx->current->lexeme, 0U) != 0U);
    if (is_enumerator)
    {
        ctx->current->flags |= 128;
    }
    else
    {
        ctx->current->flags |= 256;
    }
    return is_enumerator;
}

unsigned char  is_first_of_floating_constant(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 140 || ctx->current->type == 141);
}

unsigned char  is_first_of_integer_constant(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 136 || ctx->current->type == 137 || ctx->current->type == 138 || ctx->current->type == 139);
}

unsigned char  is_predefined_constant(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9065 || ctx->current->type == 9066 || ctx->current->type == 9067);
}

unsigned char  is_first_of_constant(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(is_first_of_integer_constant(ctx) || is_first_of_floating_constant(ctx) || is_enumeration_constant(ctx) || (ctx->current->type == 131) || is_predefined_constant(ctx));
}

unsigned char  is_first_of_primary_expression(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 8996 || is_first_of_constant(ctx) || ctx->current->type == 130 || ctx->current->type == 40 || ctx->current->type == 9058);
}

void unexpected_end_of_file(struct parser_ctx * ctx);
void parser_match(struct parser_ctx * ctx);
unsigned char  first_of_type_name(struct parser_ctx * ctx);
struct type_name *type_name(struct parser_ctx * ctx);
struct type make_type_using_declarator(struct parser_ctx * ctx, struct declarator * pdeclarator);
int parser_match_tk(struct parser_ctx * ctx, int type);
struct expression *assignment_expression(struct parser_ctx * ctx);
void generic_association_delete(struct generic_association * p);

struct generic_association *generic_association(struct parser_ctx * ctx)
{
    struct generic_association * p_generic_association;

    p_generic_association = 0U;
    if (1) /*try*/
    {
        struct expression * p_expression_temp;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_generic_association = calloc(1, 88U);
        if (p_generic_association == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_generic_association->first_token = ctx->current;
        if (ctx->current->type == 9007)
        {
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            if (first_of_type_name(ctx))
            {
                unsigned char   old;

                old = ctx->inside_generic_association;
                ctx->inside_generic_association = 1;
                p_generic_association->p_type_name = type_name(ctx);
                if (p_generic_association->p_type_name == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                ;
                ctx->inside_generic_association = old;
                p_generic_association->type = make_type_using_declarator(ctx, p_generic_association->p_type_name->abstract_declarator);
            }
            else
            {
                compiler_diagnostic(650, ctx, ctx->current, 0U, "unexpected");
            }
        }
        if (parser_match_tk(ctx, 58) != 0)
        {
            goto _CKL0;/*throw*/
        }
        p_expression_temp = assignment_expression(ctx);
        if (p_expression_temp == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_generic_association->expression = p_expression_temp;
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_generic_association->last_token = ctx->current;
    }
    else _CKL0: /*catch*/ 
    {
        generic_association_delete(p_generic_association);
        p_generic_association = 0U;
    }
    return p_generic_association;
}

void generic_assoc_list_add(struct generic_assoc_list * p, struct generic_association * item);

struct generic_assoc_list generic_association_list(struct parser_ctx * ctx)
{
    struct generic_assoc_list  list;

    _cake_zmem(&list, 8);
    if (1) /*try*/
    {
        struct generic_association * p_default_generic_association;
        struct generic_association * p_generic_association;

        p_default_generic_association = 0U;
        p_generic_association = generic_association(ctx);
        if (p_generic_association == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (p_generic_association->first_token->type == 9007)
        {
            p_default_generic_association = p_generic_association;
        }
        generic_assoc_list_add(&list, p_generic_association);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        while (ctx->current->type == 44)
        {
            struct generic_association * p_generic_association2;

            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            p_generic_association2 = generic_association(ctx);
            if (p_generic_association2 == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (p_generic_association2->first_token->type == 9007)
            {
                if (p_default_generic_association != 0U)
                {
                    compiler_diagnostic(1570, ctx, p_generic_association2->first_token, 0U, "duplicate default generic association.");
                    compiler_diagnostic(63, ctx, p_default_generic_association->first_token, 0U, "previous default generic association");
                }
                else
                {
                    p_default_generic_association = p_generic_association2;
                }
            }
            generic_assoc_list_add(&list, p_generic_association2);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return list;
}

void type_name_delete(struct type_name * p);
void expression_delete(struct expression * p);

void generic_association_delete(struct generic_association * p)
{
    if (p)
    {
        ;
        type_name_delete(p->p_type_name);
        expression_delete(p->expression);
        type_destroy(&p->type);
        free(p);
    }
}

void generic_assoc_list_add(struct generic_assoc_list * list, struct generic_association * pitem)
{
    if (list->head == 0U)
    {
        list->head = pitem;
    }
    else
    {
        ;
        ;
        list->tail->next = pitem;
    }
    list->tail = pitem;
}

void generic_assoc_list_destroy(struct generic_assoc_list * p)
{
    struct generic_association * item;

    item = p->head;
    while (item)
    {
        struct generic_association * next;

        next = item->next;
        item->next = 0U;
        generic_association_delete(item);
        item = next;
    }
}

void generic_selection_delete(struct generic_selection * p)
{
    if (p)
    {
        expression_delete(p->expression);
        type_name_delete(p->type_name);
        generic_assoc_list_destroy(&p->generic_assoc_list);
        free(p);
    }
}

unsigned char  expression_is_subjected_to_lvalue_conversion(struct expression *);
struct type type_lvalue_conversion(struct type * p_type, unsigned char   nullchecks_enabled);
unsigned char  type_is_same(struct type * a, struct type * b, unsigned char   compare_qualifiers);

struct generic_selection *generic_selection(struct parser_ctx * ctx)
{
    struct generic_selection * p_generic_selection;

    p_generic_selection = 0U;
    if (1) /*try*/
    {
        struct type  lvalue_type;
        struct type * p_type;
        struct generic_association * current;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_generic_selection = calloc(1, 28U);
        if (p_generic_selection == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_generic_selection->first_token = ctx->current;
        if (parser_match_tk(ctx, 9058) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (parser_match_tk(ctx, 40) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (first_of_type_name(ctx))
        {
            p_generic_selection->type_name = type_name(ctx);
            if (p_generic_selection->type_name == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            p_generic_selection->expression = assignment_expression(ctx);
            if (p_generic_selection->expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        if (parser_match_tk(ctx, 44) != 0)
        {
            goto _CKL0;/*throw*/
        }
        p_generic_selection->generic_assoc_list = generic_association_list(ctx);
        if (p_generic_selection->generic_assoc_list.head == 0U)
        {
            goto _CKL0;/*throw*/
        }
        _cake_zmem(&lvalue_type, 68);
        p_type = 0U;
        if (p_generic_selection->expression)
        {
            p_type = &p_generic_selection->expression->type;
            if (expression_is_subjected_to_lvalue_conversion(p_generic_selection->expression))
            {
                lvalue_type = type_lvalue_conversion(&p_generic_selection->expression->type, ctx->options.null_checks_enabled);
                p_type = &lvalue_type;
            }
        }
        else
        {
            if (p_generic_selection->type_name)
            {
                p_type = &p_generic_selection->type_name->abstract_declarator->type;
            }
            else
            {
                goto _CKL0;/*throw*/
            }
        }
        current = p_generic_selection->generic_assoc_list.head;
        while (current)
        {
            if (current->p_type_name)
            {
                if (type_is_same(p_type, &current->type, 1))
                {
                    p_generic_selection->p_view_selected_expression = current->expression;
                    break;
                }
            }
            else
            {
                p_generic_selection->p_view_selected_expression = current->expression;
            }
            current = current->next;
        }
        type_destroy(&lvalue_type);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_generic_selection->last_token = ctx->current;
        if (parser_match_tk(ctx, 41) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        generic_selection_delete(p_generic_selection);
        p_generic_selection = 0U;
    }
    return p_generic_selection;
}

struct expression *character_constant_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        unsigned char * p;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_expression_node = calloc(1, 240U);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_expression_node->expression_type = 5;
        p_expression_node->first_token = ctx->current;
        p_expression_node->last_token = p_expression_node->first_token;
        p_expression_node->type.attributes_flags |= 67108864;
        p_expression_node->type.category = 0;
        p = (unsigned char *)ctx->current->lexeme;
        if (p[0] == 117 && p[1] == 56)
        {
            unsigned int c;

            p++;
            p++;
            p++;
            p_expression_node->type.type_specifier_flags = 258;
            c = 0;
            p = utf8_decode(p, &c);
            if (p == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (c == 92)
            {
                p = escape_sequences_decode_opt(p, &c);
                if (p == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            if (*p != 39)
            {
                compiler_diagnostic(1370, ctx, ctx->current, 0U, "Unicode character literals may not contain multiple characters.");
            }
            if (c > 128)
            {
                compiler_diagnostic(1360, ctx, ctx->current, 0U, "character not encodable in a single code unit.");
            }
            p_expression_node->object = object_make_unsigned_char((unsigned char)c);
        }
        else
        {
            if (p[0] == 117)
            {
                unsigned int c;

                p++;
                p++;
                p_expression_node->type.type_specifier_flags = 260;
                c = 0;
                p = utf8_decode(p, &c);
                if (p == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (c == 92)
                {
                    p = escape_sequences_decode_opt(p, &c);
                    if (p == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                if (*p != 39)
                {
                    compiler_diagnostic(40, ctx, ctx->current, 0U, "Unicode character literals may not contain multiple characters.");
                }
                if (c > 65535)
                {
                    compiler_diagnostic(40, ctx, ctx->current, 0U, "Character too large for enclosing character literal type.");
                }
                p_expression_node->object = object_make_wchar_t((unsigned short)c);
            }
            else
            {
                if (p[0] == 85)
                {
                    unsigned int c;

                    p++;
                    p++;
                    p_expression_node->type.type_specifier_flags = 264;
                    c = 0;
                    p = utf8_decode(p, &c);
                    if (p == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (c == 92)
                    {
                        p = escape_sequences_decode_opt(p, &c);
                        if (p == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                    }
                    if (*p != 39)
                    {
                        compiler_diagnostic(40, ctx, ctx->current, 0U, "Unicode character literals may not contain multiple characters.");
                    }
                    if (c > 4294967295LL)
                    {
                        compiler_diagnostic(40, ctx, ctx->current, 0U, "Character too large for enclosing character literal type.");
                    }
                    p_expression_node->object = object_make_wchar_t((unsigned short)c);
                }
                else
                {
                    if (p[0] == 76)
                    {
                        long long value;

                        p++;
                        p++;
                        p_expression_node->type.type_specifier_flags = 260;
                        value = 0;
                        while (*p != 39)
                        {
                            unsigned int c;

                            c = 0;
                            p = utf8_decode(p, &c);
                            if (p == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (c == 92)
                            {
                                p = escape_sequences_decode_opt(p, &c);
                                if (p == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                            }
                            if (c < 128)
                            {
                                value = value * 256 + c;
                            }
                            else
                            {
                                value = c;
                            }
                            if (value > 65535)
                            {
                                compiler_diagnostic(41, ctx, ctx->current, 0U, "character constant too long for its type", ctx->current->lexeme);
                                break;
                            }
                        }
                        p_expression_node->object = object_make_wchar_t((unsigned short)value);
                    }
                    else
                    {
                        long long value;

                        p++;
                        p_expression_node->type.type_specifier_flags = 8;
                        value = 0;
                        while (*p != 39)
                        {
                            unsigned int c;

                            c = 0;
                            p = utf8_decode(p, &c);
                            if (p == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (c == 92)
                            {
                                p = escape_sequences_decode_opt(p, &c);
                                if (p == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                            }
                            value = value * 256 + c;
                            if (value > 2147483647)
                            {
                                compiler_diagnostic(41, ctx, ctx->current, 0U, "character constant too long for its type", ctx->current->lexeme);
                                break;
                            }
                        }
                        p_expression_node->object = object_make_signed_int((int)value);
                    }
                }
            }
        }
        parser_match(ctx);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

unsigned long long strtoull(char * _String, char ** _EndPtr, int _Radix);
float strtof(char * _String, char ** _EndPtr);
long double strtold(char * _String, char ** _EndPtr);
double strtod(char * _String, char ** _EndPtr);

int convert_to_number(struct parser_ctx * ctx, struct expression * p_expression_node, unsigned char   disabled)
{
    struct token * token;
    int c;
    char buffer[260];
    char * s;
    char errormsg[100];
    char suffix[4];
    int r;

    if (ctx->current == 0U)
    {
        unexpected_end_of_file(ctx);
        return 1;
    }
    token = ctx->current;
    c = 0;
    _cake_zmem(&buffer, 260);
    s = token->lexeme;
    while (*s)
    {
        if (*s != 39)
        {
            buffer[c] = *s;
            c++;
        }
        s++;
    }
    _cake_zmem(&errormsg, 100);
    _cake_zmem(&suffix, 4);
    r = parse_number(buffer, suffix, errormsg);
    if (r == 0)
    {
        compiler_diagnostic(1380, ctx, token, 0U, errormsg);
        return 0;
    }
    /*switch*/
    {
        register int _R40 = token->type;
        if (_R40 == 136) goto _CKL4; /*case 136*/
        if (_R40 == 137) goto _CKL5; /*case 137*/
        if (_R40 == 138) goto _CKL6; /*case 138*/
        if (_R40 == 139) goto _CKL7; /*case 139*/
        if (_R40 == 140) goto _CKL22; /*case 140*/
        if (_R40 == 141) goto _CKL23; /*case 141*/
        goto _CKL29;/*default*/

        {
            _CKL4:/*case 136*/ 
            _CKL5:/*case 137*/ 
            _CKL6:/*case 138*/ 
            _CKL7:/*case 139*/ 
            {
                unsigned long long value;

                value = 0;
                /*switch*/
                {
                    register int _R41 = token->type;
                    if (_R41 == 136) goto _CKL9; /*case 136*/
                    if (_R41 == 137) goto _CKL10; /*case 137*/
                    if (_R41 == 138) goto _CKL12; /*case 138*/
                    if (_R41 == 139) goto _CKL13; /*case 139*/
                    goto _CKL14;/*default*/

                    {
                        _CKL9:/*case 136*/ 
                        value = strtoull(buffer, 0U, 10);
                        goto _CKL8; /*break*/

                        _CKL10:/*case 137*/ 
                        if (buffer[1] == 111 || buffer[1] == 79)
                        {
                            value = strtoull(buffer + 2, 0U, 8);
                        }
                        else
                        {
                            value = strtoull(buffer + 1, 0U, 8);
                        }
                        goto _CKL8; /*break*/

                        _CKL12:/*case 138*/ 
                        value = strtoull(buffer + 2, 0U, 16);
                        goto _CKL8; /*break*/

                        _CKL13:/*case 139*/ 
                        value = strtoull(buffer + 2, 0U, 2);
                        goto _CKL8; /*break*/

                        _CKL14: /*default*/ 
                        goto _CKL8; /*break*/

                    }
                    _CKL8:;
                }
                if (value == 18446744073709551615ULL && (*_errno()) == 34)
                {
                    compiler_diagnostic(1350, ctx, token, 0U, "integer literal is too large to be represented in any integer type");
                }
                if (suffix[0] == 85)
                {
                    if (value <= 4294967295LL && suffix[1] != 76)
                    {
                        p_expression_node->object = object_make_unsigned_int((unsigned int)value);
                        p_expression_node->type.type_specifier_flags = 264;
                    }
                    else
                    {
                        if (value <= 4294967295UL && suffix[2] != 76)
                        {
                            p_expression_node->object = object_make_unsigned_long((unsigned long)value);
                            p_expression_node->type.type_specifier_flags = 272;
                        }
                        else
                        {
                            p_expression_node->object = object_make_unsigned_long_long((unsigned long long)value);
                            p_expression_node->type.type_specifier_flags = 4194560;
                        }
                    }
                }
                else
                {
                    if (value <= 2147483647 && suffix[0] != 76)
                    {
                        p_expression_node->object = object_make_signed_int((int)value);
                        p_expression_node->type.type_specifier_flags = 8;
                    }
                    else
                    {
                        if (value <= 2147483647L && suffix[1] != 76)
                        {
                            p_expression_node->object = object_make_signed_long((long)value);
                            p_expression_node->type.type_specifier_flags = 16;
                        }
                        else
                        {
                            if (value <= 9223372036854775807LL)
                            {
                                p_expression_node->object = object_make_signed_long_long((long long)value);
                                p_expression_node->type.type_specifier_flags = 4194304;
                            }
                            else
                            {
                                compiler_diagnostic(49, ctx, token, 0U, "integer literal is too large to be represented in a signed integer type, interpreting as unsigned");
                                p_expression_node->object = object_make_signed_long_long(value);
                                p_expression_node->type.type_specifier_flags = 4194560;
                            }
                        }
                    }
                }
            }
            goto _CKL3; /*break*/

            _CKL22:/*case 140*/ 
            _CKL23:/*case 141*/ 
            {
                if (suffix[0] == 70)
                {
                    float value;

                    value = strtof(buffer, 0U);
                    if (value == 1.000000f && (*_errno()) == 34)
                    {
                    }
                    p_expression_node->type.type_specifier_flags = 32;
                    p_expression_node->object = object_make_float(value);
                }
                else
                {
                    if (suffix[0] == 76)
                    {
                        long double value;

                        value = strtold(buffer, 0U);
                        if (value == 1.000000L && (*_errno()) == 34)
                        {
                        }
                        p_expression_node->type.type_specifier_flags = 80;
                        p_expression_node->object = object_make_long_double(value);
                    }
                    else
                    {
                        double value;

                        value = strtod(buffer, 0U);
                        if (value == 1.000000 && (*_errno()) == 34)
                        {
                        }
                        p_expression_node->object = object_make_double(value);
                        p_expression_node->type.type_specifier_flags = 64;
                    }
                }
            }
            goto _CKL3; /*break*/

            _CKL29: /*default*/ 
            ;
        }
        _CKL3:;
    }
    return 0;
}

static unsigned char  is_integer_or_floating_constant(int type)
{
    return !!(type == 136 || type == 137 || type == 138 || type == 139 || type == 140 || type == 141);
}

struct map_entry *find_variables(struct parser_ctx * ctx, char * lexeme, struct scope ** ppscope_opt);
struct type type_make_enumerator(struct enum_specifier * enum_specifier);
unsigned char  type_is_deprecated(struct type * p_type);
struct type type_make_literal_string(int size, int chartype, int qualifiers);
struct expression *expression(struct parser_ctx * ctx);

struct expression *primary_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    if (ctx->current == 0U)
    {
        unexpected_end_of_file(ctx);
        return 0U;
    }
    p_expression_node = 0U;
    if (1) /*try*/
    {
        if (ctx->current->type == 8996)
        {
            struct scope * p_scope;
            struct map_entry * p_entry;

            p_expression_node = calloc(1, 240U);
            if (p_expression_node == 0U)
            {
                goto _CKL1;/*throw*/
            }
            p_expression_node->first_token = ctx->current;
            p_expression_node->last_token = ctx->current;
            p_scope = 0U;
            p_entry = find_variables(ctx, ctx->current->lexeme, &p_scope);
            if (p_entry && p_entry->type == 3)
            {
                struct enumerator * p_enumerator;

                ;
                p_enumerator = p_entry->data.p_enumerator;
                p_expression_node->expression_type = 1;
                p_expression_node->object = p_enumerator->value;
                p_expression_node->type = type_make_enumerator(p_enumerator->enum_specifier);
            }
            else
            {
                if (p_entry && (p_entry->type == 4 || p_entry->type == 5))
                {
                    struct declarator * p_declarator;
                    struct init_declarator * p_init_declarator;

                    p_declarator = 0U;
                    p_init_declarator = 0U;
                    if (p_entry->type == 5)
                    {
                        ;
                        p_init_declarator = p_entry->data.p_init_declarator;
                        p_declarator = p_init_declarator->p_declarator;
                    }
                    else
                    {
                        p_declarator = p_entry->data.p_declarator;
                    }
                    ;
                    if (type_is_deprecated(&p_declarator->type))
                    {
                        compiler_diagnostic(2, ctx, ctx->current, 0U, "'%s' is deprecated", ctx->current->lexeme);
                    }
                    if (p_scope->scope_level == 0)
                    {
                    }
                    else
                    {
                        if ((p_declarator->type.storage_class_specifier_flags & 4) || (p_declarator->type.storage_class_specifier_flags & 8))
                        {
                        }
                        else
                        {
                            if (ctx->p_current_function_scope_opt)
                            {
                                unsigned char   b_type_is_function;

                                b_type_is_function = type_is_function(&p_declarator->type);
                                if (!ctx->evaluation_is_disabled && !b_type_is_function)
                                {
                                    unsigned char   inside_current_function_scope;

                                    inside_current_function_scope = 0;
                                    while (p_scope)
                                    {
                                        if (ctx->p_current_function_scope_opt == p_scope)
                                        {
                                            inside_current_function_scope = 1;
                                            break;
                                        }
                                        p_scope = p_scope->previous;
                                    }
                                    if (!inside_current_function_scope)
                                    {
                                        compiler_diagnostic(1870, ctx, ctx->current, 0U, "'%s' cannot be evaluated in this scope", ctx->current->lexeme);
                                    }
                                }
                            }
                        }
                    }
                    p_declarator->num_uses++;
                    p_expression_node->declarator = p_declarator;
                    p_expression_node->p_init_declarator = p_init_declarator;
                    p_expression_node->expression_type = 2;
                    p_expression_node->type = type_dup(&p_declarator->type);
                    p_expression_node->object = object_make_reference(&p_declarator->object);
                }
                else
                {
                    if (ctx->p_current_function_opt && strcmp(ctx->current->lexeme, "__func__") == 0)
                    {
                        char * func_name;

                        func_name = ctx->p_current_function_opt->name_opt ? ctx->p_current_function_opt->name_opt->lexeme : "unnamed";
                        p_expression_node->expression_type = 4;
                        p_expression_node->first_token = ctx->current;
                        p_expression_node->last_token = ctx->current;
                        p_expression_node->type = type_make_literal_string(strlen(func_name) + 1, 2, 1);
                    }
                    else
                    {
                        compiler_diagnostic(680, ctx, ctx->current, 0U, "not found '%s'", ctx->current->lexeme);
                        goto _CKL1;/*throw*/
                    }
                }
            }
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL1;/*throw*/
            }
        }
        else
        {
            if (ctx->current->type == 130)
            {
                int char_type;
                int char_byte_size;
                int number_of_bytes;
                struct object * last;
                int lit_flags;

                p_expression_node = calloc(1, 240U);
                if (p_expression_node == 0U)
                {
                    goto _CKL1;/*throw*/
                }
                p_expression_node->expression_type = 3;
                p_expression_node->first_token = ctx->current;
                p_expression_node->last_token = ctx->current;
                char_type = 2;
                if (get_char_type(ctx->current->lexeme) == 2)
                {
                    char_type = 260;
                }
                char_byte_size = string_literal_char_byte_size(ctx->current->lexeme);
                number_of_bytes = 0;
                last = 0U;
                while (ctx->current->type == 130)
                {
                    unsigned char * it;
                    unsigned int value;
                    struct object * p_new;

                    it = ctx->current->lexeme + 1;
                    value = 0;
                    while (it && *it != 34)
                    {
                        struct object * p_new;

                        if (*it == 92)
                        {
                            it = escape_sequences_decode_opt(it, &value);
                        }
                        else
                        {
                            value = *it;
                            it++;
                        }
                        p_new = calloc(1, 104U);
                        if (p_new == 0U)
                        {
                            goto _CKL1;/*throw*/
                        }
                        p_new->state = 2;
                        p_new->value_type = 3;
                        p_new->value.signed_char_value = value;
                        if (p_expression_node->object.members == 0U)
                        {
                            p_expression_node->object.members = p_new;
                        }
                        else
                        {
                            if (last)
                            {
                                last->next = p_new;
                            }
                        }
                        last = p_new;
                    }
                    p_new = calloc(1, 104U);
                    if (p_new == 0U)
                    {
                        goto _CKL1;/*throw*/
                    }
                    p_new->state = 2;
                    p_new->value_type = 3;
                    p_new->value.signed_char_value = 0;
                    if (last == 0U)
                    {
                        p_expression_node->object.members = p_new;
                    }
                    else
                    {
                        last->next = p_new;
                    }
                    number_of_bytes += string_literal_byte_size_not_zero_included(ctx->current->lexeme);
                    parser_match(ctx);
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL1;/*throw*/
                    }
                }
                lit_flags = ctx->options.const_literal ? 1 : 0;
                p_expression_node->type = type_make_literal_string(number_of_bytes + (1 * char_byte_size), char_type, lit_flags);
            }
            else
            {
                if (ctx->current->type == 131)
                {
                    p_expression_node = character_constant_expression(ctx);
                }
                else
                {
                    if (ctx->current->type == 9065 || ctx->current->type == 9066)
                    {
                        p_expression_node = calloc(1, 240U);
                        if (p_expression_node == 0U)
                        {
                            goto _CKL1;/*throw*/
                        }
                        p_expression_node->expression_type = 6;
                        p_expression_node->first_token = ctx->current;
                        p_expression_node->last_token = ctx->current;
                        p_expression_node->object = object_make_bool(ctx->current->type == 9065);
                        p_expression_node->type.type_specifier_flags = 512;
                        p_expression_node->type.type_qualifier_flags = 0;
                        parser_match(ctx);
                        if (ctx->current == 0U)
                        {
                            unexpected_end_of_file(ctx);
                            goto _CKL1;/*throw*/
                        }
                    }
                    else
                    {
                        if (ctx->current->type == 9067)
                        {
                            p_expression_node = calloc(1, 240U);
                            if (p_expression_node == 0U)
                            {
                                goto _CKL1;/*throw*/
                            }
                            p_expression_node->expression_type = 6;
                            p_expression_node->first_token = ctx->current;
                            p_expression_node->last_token = ctx->current;
                            p_expression_node->object = object_make_nullptr();
                            p_expression_node->type.type_specifier_flags = 16777216;
                            p_expression_node->type.type_qualifier_flags = 0;
                            parser_match(ctx);
                            if (ctx->current == 0U)
                            {
                                unexpected_end_of_file(ctx);
                                goto _CKL1;/*throw*/
                            }
                        }
                        else
                        {
                            if (is_integer_or_floating_constant(ctx->current->type))
                            {
                                p_expression_node = calloc(1, 240U);
                                if (p_expression_node == 0U)
                                {
                                    goto _CKL1;/*throw*/
                                }
                                p_expression_node->first_token = ctx->current;
                                p_expression_node->last_token = ctx->current;
                                p_expression_node->expression_type = 8;
                                convert_to_number(ctx, p_expression_node, 0);
                                parser_match(ctx);
                                if (ctx->current == 0U)
                                {
                                    unexpected_end_of_file(ctx);
                                    goto _CKL1;/*throw*/
                                }
                            }
                            else
                            {
                                if (ctx->current->type == 9058)
                                {
                                    p_expression_node = calloc(1, 240U);
                                    if (p_expression_node == 0U)
                                    {
                                        goto _CKL1;/*throw*/
                                    }
                                    p_expression_node->first_token = ctx->current;
                                    p_expression_node->expression_type = 7;
                                    p_expression_node->generic_selection = generic_selection(ctx);
                                    if (p_expression_node->generic_selection == 0U)
                                    {
                                        goto _CKL1;/*throw*/
                                    }
                                    p_expression_node->last_token = p_expression_node->generic_selection->last_token;
                                    if (p_expression_node->generic_selection->p_view_selected_expression)
                                    {
                                        p_expression_node->type = type_dup(&p_expression_node->generic_selection->p_view_selected_expression->type);
                                        p_expression_node->object = p_expression_node->generic_selection->p_view_selected_expression->object;
                                    }
                                    else
                                    {
                                        compiler_diagnostic(690, ctx, ctx->current, 0U, "no match for generic");
                                    }
                                }
                                else
                                {
                                    if (ctx->current->type == 40)
                                    {
                                        p_expression_node = calloc(1, 240U);
                                        if (p_expression_node == 0U)
                                        {
                                            goto _CKL1;/*throw*/
                                        }
                                        p_expression_node->expression_type = 9;
                                        p_expression_node->first_token = ctx->current;
                                        parser_match(ctx);
                                        if (ctx->current == 0U)
                                        {
                                            unexpected_end_of_file(ctx);
                                            goto _CKL1;/*throw*/
                                        }
                                        p_expression_node->right = expression(ctx);
                                        if (p_expression_node->right == 0U)
                                        {
                                            goto _CKL1;/*throw*/
                                        }
                                        p_expression_node->type = type_dup(&p_expression_node->right->type);
                                        p_expression_node->object = p_expression_node->right->object;
                                        if (ctx->current == 0U)
                                        {
                                            unexpected_end_of_file(ctx);
                                            goto _CKL1;/*throw*/
                                        }
                                        p_expression_node->last_token = ctx->current;
                                        if (parser_match_tk(ctx, 41) != 0)
                                        {
                                            goto _CKL1;/*throw*/
                                        }
                                    }
                                    else
                                    {
                                        compiler_diagnostic(650, ctx, ctx->current, 0U, "unexpected");
                                        goto _CKL1;/*throw*/
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL1: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    ;
    return p_expression_node;
}

void argument_expression_delete(struct argument_expression * p)
{
    if (p)
    {
        expression_delete(p->expression);
        ;
        free(p);
    }
}

void argument_expression_list_push(struct argument_expression_list * list, struct argument_expression * p);

struct argument_expression_list argument_expression_list(struct parser_ctx * ctx)
{
    struct argument_expression_list  list;
    struct argument_expression * p_argument_expression;

    _cake_zmem(&list, 8);
    p_argument_expression = 0U;
    if (1) /*try*/
    {
        struct expression * p_assignment_expression;

        p_argument_expression = calloc(1, 12U);
        if (p_argument_expression == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_assignment_expression = assignment_expression(ctx);
        if (p_assignment_expression == 0U)
        {
            argument_expression_delete(p_argument_expression);
            goto _CKL0;/*throw*/
        }
        p_argument_expression->expression = p_assignment_expression;
        argument_expression_list_push(&list, p_argument_expression);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        while (ctx->current->type == 44)
        {
            struct argument_expression * p_argument_expression_2;
            struct expression * p_assignment_expression_2;

            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            p_argument_expression_2 = calloc(1, 12U);
            if (p_argument_expression_2 == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_assignment_expression_2 = assignment_expression(ctx);
            if (p_assignment_expression_2 == 0U)
            {
                argument_expression_delete(p_argument_expression_2);
                goto _CKL0;/*throw*/
            }
            p_argument_expression_2->expression = p_assignment_expression_2;
            argument_expression_list_push(&list, p_argument_expression_2);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return list;
}

unsigned char  first_of_type_name_ahead(struct parser_ctx * ctx);

unsigned char  first_of_postfix_expression(struct parser_ctx * ctx)
{
    if (first_of_type_name_ahead(ctx))
    {
        return 1;
    }
    return is_first_of_primary_expression(ctx);
}

static void fix_member_type(struct type * p_type, struct type * struct_type, struct type * member_type)
{
    if (struct_type->type_qualifier_flags & 1)
    {
        p_type->type_qualifier_flags |= 1;
    }
    p_type->storage_class_specifier_flags = struct_type->storage_class_specifier_flags;
    if (struct_type->type_qualifier_flags & 32)
    {
        p_type->type_qualifier_flags &= -17;
    }
    if (struct_type->type_qualifier_flags & 64)
    {
        p_type->type_qualifier_flags |= 64;
    }
}

struct type type_remove_pointer(struct type * p_type);

static void fix_arrow_member_type(struct type * p_type, struct type * left, struct type * member_type)
{
    struct type  t;

    t = type_remove_pointer(left);
    if (t.type_qualifier_flags & 1)
    {
        p_type->type_qualifier_flags |= 1;
    }
    if (t.type_qualifier_flags & 64)
    {
        p_type->type_qualifier_flags |= 64;
    }
    if (t.type_qualifier_flags & 32)
    {
        p_type->type_qualifier_flags &= -17;
    }
    type_destroy(&t);
}

unsigned char  type_is_array(struct type * p_type);
unsigned char  type_is_integer(struct type * p_type);
unsigned char  type_is_function_or_function_pointer(struct type * p_type);
struct type get_function_return_type(struct type * p_type);
struct struct_or_union_specifier *find_struct_or_union_specifier(struct parser_ctx * ctx, char * lexeme);
struct member_declarator *find_member_declarator(struct member_declaration_list * list, char * name, int * p_member_index);
struct object *find_object_declarator_by_index(struct object * p_object, struct member_declaration_list * list, int member_index);
unsigned char  type_is_struct_or_union(struct type * p_type);
unsigned char  type_is_owner(struct type * p_type);
unsigned char  expression_is_lvalue(struct expression * expr);
struct token *previous_parser_token(struct token * token);

struct expression *postfix_expression_tail(struct parser_ctx * ctx, struct expression * p_expression_node_param)
{
    struct expression * p_expression_node;

    p_expression_node = p_expression_node_param;
    if (1) /*try*/
    {
        while (ctx->current != 0U)
        {
            if (ctx->current->type == 91)
            {
                struct expression * p_expression_node_new;

                p_expression_node_new = calloc(1, 240U);
                if (p_expression_node_new == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_expression_node->last_token = ctx->current;
                p_expression_node_new->first_token = ctx->current;
                p_expression_node_new->expression_type = 13;
                if (!type_is_pointer_or_array(&p_expression_node->type))
                {
                    compiler_diagnostic(700, ctx, ctx->current, 0U, "subscripted value is neither array nor pointer");
                }
                if (type_is_pointer(&p_expression_node->type))
                {
                    p_expression_node_new->type = type_remove_pointer(&p_expression_node->type);
                }
                else
                {
                    if (type_is_array(&p_expression_node->type))
                    {
                        p_expression_node_new->type = get_array_item_type(&p_expression_node->type);
                    }
                }
                parser_match(ctx);
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    expression_delete(p_expression_node_new);
                    goto _CKL0;/*throw*/
                }
                p_expression_node_new->right = expression(ctx);
                if (p_expression_node_new->right == 0U)
                {
                    expression_delete(p_expression_node_new);
                    goto _CKL0;/*throw*/
                }
                if (!type_is_integer(&p_expression_node_new->right->type))
                {
                    compiler_diagnostic(1560, ctx, p_expression_node_new->right->first_token, 0U, "array subscript is not an integer");
                }
                if (object_has_constant_value(&p_expression_node_new->right->object))
                {
                    unsigned long long index;

                    index = object_to_unsigned_long_long(&p_expression_node_new->right->object);
                    if (type_is_array(&p_expression_node->type))
                    {
                        if (p_expression_node->type.num_of_elements > 0)
                        {
                            struct object * it;

                            if (index >= (unsigned long long)p_expression_node->type.num_of_elements)
                            {
                                compiler_diagnostic(41, ctx, ctx->current, 0U, "index %d is past the end of the array", index);
                            }
                            it = object_get_member(&p_expression_node->object, (int)index);
                            if (it != 0U)
                            {
                                p_expression_node_new->object = object_make_reference(it);
                            }
                        }
                    }
                }
                if (parser_match_tk(ctx, 93) != 0)
                {
                    expression_delete(p_expression_node_new);
                    p_expression_node_new = 0U;
                    goto _CKL0;/*throw*/
                }
                p_expression_node_new->left = p_expression_node;
                p_expression_node = p_expression_node_new;
            }
            else
            {
                if (ctx->current->type == 40)
                {
                    struct expression * p_expression_node_new;

                    p_expression_node_new = calloc(1, 240U);
                    if (p_expression_node_new == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    p_expression_node->last_token = ctx->current;
                    p_expression_node_new->first_token = p_expression_node->first_token;
                    p_expression_node_new->expression_type = 12;
                    if (!type_is_function_or_function_pointer(&p_expression_node->type))
                    {
                        compiler_diagnostic(710, ctx, ctx->current, 0U, "called object is not attr function or function pointer");
                    }
                    p_expression_node_new->type = get_function_return_type(&p_expression_node->type);
                    parser_match(ctx);
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        expression_delete(p_expression_node_new);
                        p_expression_node_new = 0U;
                        goto _CKL0;/*throw*/
                    }
                    if (ctx->current->type != 41)
                    {
                        p_expression_node_new->argument_expression_list = argument_expression_list(ctx);
                    }
                    if (parser_match_tk(ctx, 41) != 0)
                    {
                        expression_delete(p_expression_node_new);
                        p_expression_node_new = 0U;
                        goto _CKL0;/*throw*/
                    }
                    compare_function_arguments(ctx, &p_expression_node->type, &p_expression_node_new->argument_expression_list);
                    if (ctx->previous == 0U)
                    {
                        expression_delete(p_expression_node_new);
                        p_expression_node_new = 0U;
                        goto _CKL0;/*throw*/
                    }
                    make_object(&p_expression_node_new->type, &p_expression_node_new->object);
                    p_expression_node_new->last_token = ctx->previous;
                    p_expression_node_new->left = p_expression_node;
                    p_expression_node = p_expression_node_new;
                }
                else
                {
                    if (ctx->current->type == 46)
                    {
                        struct expression * p_expression_node_new;

                        p_expression_node_new = calloc(1, 240U);
                        if (p_expression_node_new == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                        p_expression_node->last_token = ctx->current;
                        p_expression_node_new->first_token = ctx->current;
                        p_expression_node_new->expression_type = 14;
                        p_expression_node_new->left = p_expression_node;
                        p_expression_node = 0U;
                        p_expression_node_new->declarator = p_expression_node_new->left->declarator;
                        parser_match(ctx);
                        if (ctx->current == 0U)
                        {
                            unexpected_end_of_file(ctx);
                            expression_delete(p_expression_node_new);
                            p_expression_node_new = 0U;
                            goto _CKL0;/*throw*/
                        }
                        if (p_expression_node_new->left->type.type_specifier_flags & 32768)
                        {
                            struct struct_or_union_specifier * p_complete;

                            ;
                            p_complete = find_struct_or_union_specifier(ctx, p_expression_node_new->left->type.struct_or_union_specifier->tag_name);
                            if (p_complete)
                            {
                                p_complete = get_complete_struct_or_union_specifier(p_complete);
                            }
                            if (p_complete)
                            {
                                int member_index;
                                struct member_declarator * p_member_declarator;

                                ;
                                member_index = 0;
                                p_member_declarator = find_member_declarator(&p_complete->member_declaration_list, ctx->current->lexeme, &member_index);
                                if (p_member_declarator)
                                {
                                    struct object * object;

                                    p_expression_node_new->member_index = member_index;
                                    if (p_member_declarator->declarator)
                                    {
                                        p_expression_node_new->type = make_type_using_declarator(ctx, p_member_declarator->declarator);
                                    }
                                    else
                                    {
                                    }
                                    if (p_member_declarator->declarator != 0U)
                                    {
                                        fix_member_type(&p_expression_node_new->type, &p_expression_node_new->left->type, &p_member_declarator->declarator->type);
                                    }
                                    object = find_object_declarator_by_index(&p_expression_node_new->left->object, &p_complete->member_declaration_list, member_index);
                                    if (object)
                                    {
                                        p_expression_node_new->object = object_make_reference(object);
                                    }
                                    else
                                    {
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(720, ctx, ctx->current, 0U, "member '%s' not found in 'struct %s'", ctx->current->lexeme, p_complete->tag_name);
                                }
                            }
                            else
                            {
                                compiler_diagnostic(720, ctx, ctx->current, 0U, "incomplete struct type '%s'", p_expression_node_new->left->type.struct_or_union_specifier->tag_name);
                            }
                            if (parser_match_tk(ctx, 8996) != 0)
                            {
                                expression_delete(p_expression_node_new);
                                p_expression_node_new = 0U;
                                goto _CKL0;/*throw*/
                            }
                        }
                        else
                        {
                            compiler_diagnostic(730, ctx, ctx->current, 0U, "structure or union required");
                        }
                        p_expression_node = p_expression_node_new;
                    }
                    else
                    {
                        if (ctx->current->type == 11582)
                        {
                            struct expression * p_expression_node_new;

                            p_expression_node_new = calloc(1, 240U);
                            if (p_expression_node_new == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            p_expression_node->last_token = ctx->current;
                            p_expression_node_new->first_token = p_expression_node->first_token;
                            p_expression_node_new->last_token = ctx->current;
                            p_expression_node_new->expression_type = 15;
                            parser_match(ctx);
                            if (ctx->current == 0U)
                            {
                                expression_delete(p_expression_node_new);
                                p_expression_node_new = 0U;
                                goto _CKL0;/*throw*/
                            }
                            if (type_is_pointer_or_array(&p_expression_node->type))
                            {
                                struct type  item_type;

                                _cake_zmem(&item_type, 68);
                                if (type_is_array(&p_expression_node->type))
                                {
                                    compiler_diagnostic(19, ctx, ctx->current, 0U, "using indirection '->' in array");
                                    item_type = get_array_item_type(&p_expression_node->type);
                                }
                                else
                                {
                                    item_type = type_remove_pointer(&p_expression_node->type);
                                }
                                if (type_is_struct_or_union(&item_type))
                                {
                                    struct struct_or_union_specifier * p_complete;

                                    ;
                                    ;
                                    p_complete = get_complete_struct_or_union_specifier(p_expression_node->type.next->struct_or_union_specifier);
                                    if (p_complete)
                                    {
                                        int member_index;
                                        struct member_declarator * p_member_declarator;

                                        member_index = 0;
                                        p_member_declarator = find_member_declarator(&p_complete->member_declaration_list, ctx->current->lexeme, &member_index);
                                        if (p_member_declarator)
                                        {
                                            if (p_member_declarator->declarator)
                                            {
                                                p_expression_node_new->member_index = member_index;
                                                p_expression_node_new->type = make_type_using_declarator(ctx, p_member_declarator->declarator);
                                                fix_arrow_member_type(&p_expression_node_new->type, &p_expression_node->type, &p_expression_node_new->type);
                                            }
                                            else
                                            {
                                                ;
                                            }
                                        }
                                        else
                                        {
                                            compiler_diagnostic(720, ctx, ctx->current, 0U, "member '%s' not found in struct '%s'", ctx->current->lexeme, p_expression_node->type.next->struct_or_union_specifier->tag_name);
                                        }
                                    }
                                    else
                                    {
                                        compiler_diagnostic(740, ctx, ctx->current, 0U, "struct '%s' is incomplete.", ctx->current->lexeme);
                                    }
                                    if (parser_match_tk(ctx, 8996) != 0)
                                    {
                                        type_destroy(&item_type);
                                        expression_delete(p_expression_node_new);
                                        p_expression_node_new = 0U;
                                        goto _CKL0;/*throw*/
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(730, ctx, ctx->current, 0U, "structure or union required");
                                }
                                type_destroy(&item_type);
                            }
                            else
                            {
                                compiler_diagnostic(730, ctx, ctx->current, 0U, "structure or union required");
                            }
                            p_expression_node_new->left = p_expression_node;
                            p_expression_node = p_expression_node_new;
                        }
                        else
                        {
                            if (ctx->current->type == 11051)
                            {
                                struct expression * p_expression_node_new;

                                p_expression_node->last_token = ctx->current;
                                if (type_is_owner(&p_expression_node->type))
                                {
                                    compiler_diagnostic(1310, ctx, p_expression_node->first_token, 0U, "operator ++ cannot be used in _Owner pointers");
                                }
                                if (!expression_is_lvalue(p_expression_node))
                                {
                                    compiler_diagnostic(1230, ctx, p_expression_node->first_token, 0U, "lvalue required as increment operand");
                                }
                                p_expression_node_new = calloc(1, 240U);
                                if (p_expression_node_new == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                                p_expression_node->last_token = ctx->current;
                                p_expression_node_new->first_token = ctx->current;
                                p_expression_node_new->expression_type = 16;
                                p_expression_node_new->type = type_dup(&p_expression_node->type);
                                parser_match(ctx);
                                if (ctx->current == 0U)
                                {
                                    unexpected_end_of_file(ctx);
                                    expression_delete(p_expression_node_new);
                                    p_expression_node_new = 0U;
                                    goto _CKL0;/*throw*/
                                }
                                p_expression_node_new->left = p_expression_node;
                                p_expression_node = p_expression_node_new;
                            }
                            else
                            {
                                if (ctx->current->type == 11565)
                                {
                                    struct expression * p_expression_node_new;

                                    p_expression_node->last_token = ctx->current;
                                    if (type_is_owner(&p_expression_node->type))
                                    {
                                        compiler_diagnostic(1320, ctx, p_expression_node->first_token, 0U, "operator -- cannot be used in owner pointers");
                                    }
                                    if (!expression_is_lvalue(p_expression_node))
                                    {
                                        compiler_diagnostic(1230, ctx, p_expression_node->first_token, 0U, "lvalue required as decrement operand");
                                    }
                                    p_expression_node_new = calloc(1, 240U);
                                    if (p_expression_node_new == 0U)
                                    {
                                        goto _CKL0;/*throw*/
                                    }
                                    p_expression_node_new->first_token = ctx->current;
                                    p_expression_node_new->expression_type = 17;
                                    p_expression_node_new->type = type_dup(&p_expression_node->type);
                                    parser_match(ctx);
                                    if (ctx->current == 0U)
                                    {
                                        unexpected_end_of_file(ctx);
                                        expression_delete(p_expression_node_new);
                                        p_expression_node_new = 0U;
                                        goto _CKL0;/*throw*/
                                    }
                                    p_expression_node_new->left = p_expression_node;
                                    p_expression_node = p_expression_node_new;
                                }
                                else
                                {
                                    struct token * p_last;

                                    p_last = previous_parser_token(ctx->current);
                                    if (p_last == 0U)
                                    {
                                        goto _CKL0;/*throw*/
                                    }
                                    p_expression_node->last_token = p_last;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return p_expression_node;
}

void scope_list_push(struct scope_list * list, struct scope * s);
struct compound_statement *function_body(struct parser_ctx * ctx);
void scope_list_pop(struct scope_list * list);
struct braced_initializer *braced_initializer(struct parser_ctx * ctx);
unsigned char  type_is_const(struct type * p_type);
int initializer_init_new(struct parser_ctx * ctx, struct type * p_current_object_type, struct object * p_current_object, struct initializer * braced_initializer, unsigned char   is_constant, unsigned char   requires_constant_initialization);

struct expression *postfix_expression_type_name(struct parser_ctx * ctx, struct type_name * p_type_name_par)
{
    struct type_name * p_type_name;
    struct expression * p_expression_node;

    p_type_name = p_type_name_par;
    p_expression_node = 0U;
    if (1) /*try*/
    {
        struct token * p_previous;

        p_expression_node = calloc(1, 240U);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        ;
        p_previous = previous_parser_token(p_type_name->first_token);
        if (p_previous == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_expression_node->first_token = p_previous;
        ;
        p_expression_node->type_name = p_type_name;
        p_type_name = 0U;
        p_expression_node->type = make_type_using_declarator(ctx, p_expression_node->type_name->abstract_declarator);
        if (type_is_function(&p_expression_node->type_name->abstract_declarator->type))
        {
            struct scope * parameters_scope;
            struct declarator * p_current_function_opt;
            struct scope * p_current_function_scope_opt;

            p_expression_node->expression_type = 10;
            parameters_scope = &p_expression_node->type_name->abstract_declarator->direct_declarator->function_declarator->parameters_scope;
            scope_list_push(&ctx->scopes, parameters_scope);
            p_current_function_opt = ctx->p_current_function_opt;
            ctx->p_current_function_opt = p_expression_node->type_name->abstract_declarator;
            p_current_function_scope_opt = ctx->p_current_function_scope_opt;
            ctx->p_current_function_scope_opt = ctx->scopes.tail;
            p_expression_node->compound_statement = function_body(ctx);
            scope_list_pop(&ctx->scopes);
            ctx->p_current_function_opt = p_current_function_opt;
            ctx->p_current_function_scope_opt = p_current_function_scope_opt;
        }
        else
        {
            unsigned char   is_constant;
            struct initializer  initializer;
            unsigned char   requires_constant_initialization;

            p_expression_node->expression_type = 11;
            p_expression_node->braced_initializer = braced_initializer(ctx);
            p_expression_node->type = type_dup(&p_expression_node->type_name->type);
            if (p_expression_node->type.storage_class_specifier_flags & 1)
            {
            }
            else
            {
                int er;

                er = make_object(&p_expression_node->type, &p_expression_node->object);
                if (er != 0)
                {
                    compiler_diagnostic(740, ctx, p_expression_node->first_token, 0U, "incomplete struct/union type");
                    goto _CKL0;/*throw*/
                }
            }
            is_constant = !!(type_is_const(&p_expression_node->type) || p_expression_node->type.storage_class_specifier_flags & 64);
            object_default_initialization(&p_expression_node->object, is_constant);
            _cake_zmem(&initializer, 12);
            initializer.braced_initializer = p_expression_node->braced_initializer;
            initializer.first_token = p_expression_node->first_token;
            requires_constant_initialization = 0;
            initializer_init_new(ctx, &p_expression_node->type, &p_expression_node->object, &initializer, is_constant, 0);
        }
        if (ctx->previous == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_expression_node->last_token = ctx->previous;
        p_expression_node = postfix_expression_tail(ctx, p_expression_node);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    type_name_delete(p_type_name);
    return p_expression_node;
}

struct compound_statement *compound_statement(struct parser_ctx * ctx);

struct expression *postfix_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        if (first_of_type_name_ahead(ctx))
        {
            ;
            p_expression_node = calloc(1, 240U);
            if (p_expression_node == 0U)
            {
                goto _CKL0;/*throw*/
            }
            ;
            p_expression_node->first_token = ctx->current;
            if (parser_match_tk(ctx, 40) != 0)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node->type_name = type_name(ctx);
            if (p_expression_node->type_name == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node->type = make_type_using_declarator(ctx, p_expression_node->type_name->abstract_declarator);
            if (parser_match_tk(ctx, 41) != 0)
            {
                goto _CKL0;/*throw*/
            }
            if (type_is_function(&p_expression_node->type))
            {
                p_expression_node->expression_type = 10;
                p_expression_node->compound_statement = compound_statement(ctx);
                if (p_expression_node->compound_statement == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_expression_node->last_token = p_expression_node->compound_statement->last_token;
            }
            else
            {
                p_expression_node->expression_type = 11;
                p_expression_node->braced_initializer = braced_initializer(ctx);
                if (p_expression_node->braced_initializer == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    goto _CKL0;/*throw*/
                }
                p_expression_node->last_token = ctx->current;
            }
        }
        else
        {
            p_expression_node = primary_expression(ctx);
            if (p_expression_node == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        p_expression_node = postfix_expression_tail(ctx, p_expression_node);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

unsigned char  is_first_of_compiler_function(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9080 || ctx->current->type == 9082 || ctx->current->type == 9081 || ctx->current->type == 9079 || ctx->current->type == 9083 || ctx->current->type == 9084 || ctx->current->type == 9062 || ctx->current->type == 9085 || ctx->current->type == 9086 || ctx->current->type == 9087 || ctx->current->type == 9088);
}

unsigned char  is_first_of_unary_expression(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(first_of_postfix_expression(ctx) || ctx->current->type == 11051 || ctx->current->type == 11565 || ctx->current->type == 38 || ctx->current->type == 42 || ctx->current->type == 43 || ctx->current->type == 45 || ctx->current->type == 126 || ctx->current->type == 33 || ctx->current->type == 9030 || ctx->current->type == 9031 || ctx->current->type == 9044 || is_first_of_compiler_function(ctx));
}

int type_get_category(struct type * p_type);
unsigned char  type_is_vla(struct type * p_type);

static int check_sizeof_argument(struct parser_ctx * ctx, struct expression * p_expression, struct type * p_type)
{
    int category;

    category = type_get_category(p_type);
    if (category == 1)
    {
    }
    else
    {
        if (category == 0 && p_type->type_specifier_flags & 32768)
        {
            struct struct_or_union_specifier * p_complete;

            ;
            p_complete = get_complete_struct_or_union_specifier(p_type->struct_or_union_specifier);
            if (p_complete == 0U)
            {
                compiler_diagnostic(740, ctx, p_expression->first_token, 0U, "struct is incomplete type");
                return -1;
            }
        }
        else
        {
            if (category == 2)
            {
                if (type_is_vla(p_type))
                {
                    return 0;
                }
                if (p_type->storage_class_specifier_flags & 2048)
                {
                    compiler_diagnostic(46, ctx, p_expression->first_token, 0U, "sizeof applied to array function parameter");
                }
            }
        }
    }
    return 0;
}

struct expression *cast_expression(struct parser_ctx * ctx);
struct type type_make_int_bool_like();
void type_integer_promotion(struct type * a);
struct type type_common(struct type * p_type1, struct type * p_type2);
struct type type_add_pointer(struct type * p_type, unsigned char   null_checks_enabled);
struct type make_size_t_type();
int type_get_sizeof(struct type * p_type, unsigned int * size);
struct type type_make_size_t();
unsigned char  type_is_enum(struct type * p_type);
struct enum_specifier *get_complete_enum_specifier(struct enum_specifier * p_enum_specifier);
unsigned int type_get_alignof(struct type * p_type);
struct type type_make_int();
unsigned char  type_is_arithmetic(struct type * p_type);
unsigned char  type_is_scalar(struct type * p_type);
unsigned char  type_is_floating_point(struct type * p_type);

struct expression *unary_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 11051 || ctx->current->type == 11565)
        {
            struct expression * new_expression;

            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            if (ctx->current->type == 11051)
            {
                new_expression->expression_type = 26;
            }
            else
            {
                new_expression->expression_type = 27;
            }
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->right = unary_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->type = type_dup(&new_expression->right->type);
            p_expression_node = new_expression;
        }
        else
        {
            if (ctx->current->type == 38 || ctx->current->type == 42 || ctx->current->type == 43 || ctx->current->type == 45 || ctx->current->type == 126 || ctx->current->type == 33)
            {
                struct expression * new_expression;
                struct token * op_position;
                int op;

                new_expression = calloc(1, 240U);
                if (new_expression == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                new_expression->first_token = ctx->current;
                op_position = ctx->current;
                op = ctx->current->type;
                parser_match(ctx);
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    expression_delete(new_expression);
                    goto _CKL0;/*throw*/
                }
                new_expression->right = cast_expression(ctx);
                if (new_expression->right == 0U)
                {
                    expression_delete(new_expression);
                    goto _CKL0;/*throw*/
                }
                new_expression->last_token = new_expression->right->last_token;
                if (op == 33)
                {
                    new_expression->expression_type = 28;
                    if (!ctx->evaluation_is_disabled && object_has_constant_value(&new_expression->right->object))
                    {
                        unsigned char   v;

                        v = object_to_bool(&new_expression->right->object);
                        new_expression->object = object_make_signed_int(!v);
                    }
                    new_expression->type = type_make_int_bool_like();
                }
                else
                {
                    if (op == 126)
                    {
                        struct type  promoted;

                        if (!type_is_integer(&new_expression->right->type))
                        {
                            compiler_diagnostic(850, ctx, op_position, 0U, "requires integer type");
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        new_expression->expression_type = 29;
                        promoted = type_dup(&new_expression->right->type);
                        type_integer_promotion(&promoted);
                        new_expression->type = promoted;
                        if (!ctx->evaluation_is_disabled && object_has_constant_value(&new_expression->right->object))
                        {
                            int vt;

                            vt = type_to_object_type(&new_expression->type);
                            /*switch*/
                            {
                                register int _R42 = vt;
                                if (_R42 == 0) goto _CKL17; /*case 0*/
                                if (_R42 == 1) goto _CKL18; /*case 1*/
                                if (_R42 == 7) goto _CKL19; /*case 7*/
                                if (_R42 == 8) goto _CKL20; /*case 8*/
                                if (_R42 == 9) goto _CKL21; /*case 9*/
                                if (_R42 == 10) goto _CKL22; /*case 10*/
                                if (_R42 == 5) goto _CKL23; /*case 5*/
                                if (_R42 == 6) goto _CKL24; /*case 6*/
                                if (_R42 == 3) goto _CKL25; /*case 3*/
                                if (_R42 == 4) goto _CKL26; /*case 4*/
                                if (_R42 == 2) goto _CKL27; /*case 2*/
                                if (_R42 == 11) goto _CKL28; /*case 11*/
                                if (_R42 == 12) goto _CKL29; /*case 12*/
                                if (_R42 == 13) goto _CKL30; /*case 13*/
                                goto _CKL16;

                                {
                                    _CKL17:/*case 0*/ 
                                    {
                                        signed int r;

                                        r = object_to_signed_int(&new_expression->right->object);
                                        new_expression->object = object_make_signed_int(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL18:/*case 1*/ 
                                    {
                                        unsigned int r;

                                        r = object_to_unsigned_int(&new_expression->right->object);
                                        new_expression->object = object_make_unsigned_int(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL19:/*case 7*/ 
                                    {
                                        signed long r;

                                        r = object_to_signed_long(&new_expression->right->object);
                                        new_expression->object = object_make_signed_long(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL20:/*case 8*/ 
                                    {
                                        unsigned long r;

                                        r = object_to_unsigned_long(&new_expression->right->object);
                                        new_expression->object = object_make_unsigned_long(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL21:/*case 9*/ 
                                    {
                                        signed long long r;

                                        r = object_to_signed_long_long(&new_expression->right->object);
                                        new_expression->object = object_make_signed_long_long(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL22:/*case 10*/ 
                                    {
                                        unsigned long long r;

                                        r = object_to_unsigned_long_long(&new_expression->right->object);
                                        new_expression->object = object_make_unsigned_long_long(~r);
                                    }
                                    goto _CKL16; /*break*/

                                    _CKL23:/*case 5*/ 
                                    _CKL24:/*case 6*/ 
                                    _CKL25:/*case 3*/ 
                                    _CKL26:/*case 4*/ 
                                    _CKL27:/*case 2*/ 
                                    _CKL28:/*case 11*/ 
                                    _CKL29:/*case 12*/ 
                                    _CKL30:/*case 13*/ 
                                    goto _CKL16; /*break*/

                                }
                                _CKL16:;
                            }
                            ;
                        }
                    }
                    else
                    {
                        if (op == 45 || op == 43)
                        {
                            if (op == 45)
                            {
                                new_expression->expression_type = 30;
                            }
                            else
                            {
                                new_expression->expression_type = 31;
                            }
                            new_expression->type = type_common(&new_expression->right->type, &new_expression->right->type);
                            if (!ctx->evaluation_is_disabled && object_has_constant_value(&new_expression->right->object))
                            {
                                int vt;

                                vt = type_to_object_type(&new_expression->type);
                                /*switch*/
                                {
                                    register int _R43 = vt;
                                    if (_R43 == 0) goto _CKL35; /*case 0*/
                                    if (_R43 == 1) goto _CKL37; /*case 1*/
                                    if (_R43 == 7) goto _CKL39; /*case 7*/
                                    if (_R43 == 8) goto _CKL41; /*case 8*/
                                    if (_R43 == 9) goto _CKL43; /*case 9*/
                                    if (_R43 == 10) goto _CKL45; /*case 10*/
                                    if (_R43 == 2) goto _CKL47; /*case 2*/
                                    if (_R43 == 3) goto _CKL48; /*case 3*/
                                    if (_R43 == 4) goto _CKL49; /*case 4*/
                                    if (_R43 == 5) goto _CKL50; /*case 5*/
                                    if (_R43 == 6) goto _CKL51; /*case 6*/
                                    if (_R43 == 11) goto _CKL52; /*case 11*/
                                    if (_R43 == 12) goto _CKL54; /*case 12*/
                                    if (_R43 == 13) goto _CKL56; /*case 13*/
                                    goto _CKL34;

                                    {
                                        _CKL35:/*case 0*/ 
                                        {
                                            int a;

                                            a = object_to_signed_int(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_signed_int(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_signed_int(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL37:/*case 1*/ 
                                        {
                                            unsigned int a;

                                            a = object_to_unsigned_int(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_unsigned_int(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_unsigned_int(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL39:/*case 7*/ 
                                        {
                                            signed long a;

                                            a = object_to_signed_long(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_signed_long(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_signed_long(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL41:/*case 8*/ 
                                        {
                                            unsigned long a;

                                            a = object_to_unsigned_long(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_unsigned_long(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_unsigned_long(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL43:/*case 9*/ 
                                        {
                                            signed long long a;

                                            a = object_to_signed_long_long(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_signed_long_long(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_signed_long_long(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL45:/*case 10*/ 
                                        {
                                            unsigned long long a;

                                            a = object_to_unsigned_long_long(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_unsigned_long_long(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_unsigned_long_long(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL47:/*case 2*/ 
                                        _CKL48:/*case 3*/ 
                                        _CKL49:/*case 4*/ 
                                        _CKL50:/*case 5*/ 
                                        _CKL51:/*case 6*/ 
                                        ;
                                        expression_delete(new_expression);
                                        goto _CKL0;/*throw*/
                                        goto _CKL34; /*break*/

                                        _CKL52:/*case 11*/ 
                                        {
                                            float a;

                                            a = object_to_float(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_float(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_float(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL54:/*case 12*/ 
                                        {
                                            double a;

                                            a = object_to_double(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_double(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_double(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                        _CKL56:/*case 13*/ 
                                        {
                                            long double a;

                                            a = object_to_long_double(&new_expression->right->object);
                                            if (op == 45)
                                            {
                                                new_expression->object = object_make_long_double(-a);
                                            }
                                            else
                                            {
                                                new_expression->object = object_make_long_double(+a);
                                            }
                                        }
                                        goto _CKL34; /*break*/

                                    }
                                    _CKL34:;
                                }
                                ;
                            }
                        }
                        else
                        {
                            if (op == 42)
                            {
                                new_expression->expression_type = 32;
                                if (!type_is_pointer_or_array(&new_expression->right->type))
                                {
                                    compiler_diagnostic(780, ctx, op_position, 0U, "indirection requires pointer operand");
                                }
                                if (type_is_pointer(&new_expression->right->type))
                                {
                                    new_expression->type = type_remove_pointer(&new_expression->right->type);
                                }
                                else
                                {
                                    compiler_diagnostic(19, ctx, op_position, 0U, "array indirection");
                                    new_expression->type = get_array_item_type(&new_expression->right->type);
                                }
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    new_expression->expression_type = 33;
                                    if (!expression_is_lvalue(new_expression->right))
                                    {
                                        compiler_diagnostic(1220, ctx, new_expression->right->first_token, 0U, "lvalue required as unary '&' operand");
                                    }
                                    if (new_expression->right->type.storage_class_specifier_flags & 32)
                                    {
                                        char * variable_name;

                                        variable_name = "?";
                                        if (new_expression->right->declarator && new_expression->right->declarator->name_opt)
                                        {
                                            variable_name = new_expression->right->declarator->name_opt->lexeme;
                                        }
                                        compiler_diagnostic(1220, ctx, new_expression->right->first_token, 0U, "address of register variable 'x' requested", variable_name);
                                    }
                                    new_expression->type = type_add_pointer(&new_expression->right->type, ctx->options.null_checks_enabled);
                                    new_expression->type.address_of = 1;
                                }
                                else
                                {
                                    expression_delete(new_expression);
                                    compiler_diagnostic(790, ctx, ctx->current, 0U, "invalid token");
                                    goto _CKL0;/*throw*/
                                }
                            }
                        }
                    }
                }
                p_expression_node = new_expression;
            }
            else
            {
                if (ctx->current->type == 9030)
                {
                    unsigned char   disable_evaluation_copy;
                    struct expression * new_expression;

                    disable_evaluation_copy = ctx->evaluation_is_disabled;
                    ctx->evaluation_is_disabled = 1;
                    parser_match(ctx);
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL0;/*throw*/
                    }
                    new_expression = calloc(1, 240U);
                    if (new_expression == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    new_expression->first_token = ctx->current;
                    if (first_of_type_name_ahead(ctx))
                    {
                        new_expression->expression_type = 19;
                        if (parser_match_tk(ctx, 40) != 0)
                        {
                            expression_delete(new_expression);
                            new_expression = 0U;
                            goto _CKL0;/*throw*/
                        }
                        new_expression->type_name = type_name(ctx);
                        if (new_expression->type_name == 0U)
                        {
                            expression_delete(new_expression);
                            new_expression = 0U;
                            goto _CKL0;/*throw*/
                        }
                        new_expression->type = make_size_t_type();
                        if (ctx->current == 0U)
                        {
                            unexpected_end_of_file(ctx);
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        new_expression->last_token = ctx->current;
                        if (parser_match_tk(ctx, 41) != 0)
                        {
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        if (check_sizeof_argument(ctx, new_expression, &new_expression->type_name->type) != 0)
                        {
                        }
                        else
                        {
                            if (type_is_vla(&new_expression->type_name->abstract_declarator->type))
                            {
                            }
                            else
                            {
                                unsigned int type_sizeof;

                                type_sizeof = 0;
                                if (type_get_sizeof(&new_expression->type_name->abstract_declarator->type, &type_sizeof) != 0)
                                {
                                    goto _CKL0;/*throw*/
                                }
                                new_expression->object = object_make_size_t(type_sizeof);
                            }
                        }
                    }
                    else
                    {
                        new_expression->right = unary_expression(ctx);
                        if (new_expression->right == 0U)
                        {
                            ctx->evaluation_is_disabled = disable_evaluation_copy;
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        new_expression->expression_type = 18;
                        if (check_sizeof_argument(ctx, new_expression->right, &new_expression->right->type) != 0)
                        {
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        if (type_is_vla(&new_expression->right->type))
                        {
                        }
                        else
                        {
                            unsigned int sz;

                            sz = 0;
                            if (type_get_sizeof(&new_expression->right->type, &sz) != 0)
                            {
                                goto _CKL0;/*throw*/
                            }
                            new_expression->object = object_make_size_t(sz);
                        }
                    }
                    type_destroy(&new_expression->type);
                    new_expression->type = type_make_size_t();
                    p_expression_node = new_expression;
                    ctx->evaluation_is_disabled = disable_evaluation_copy;
                }
                else
                {
                    if (ctx->current->type == 9031)
                    {
                        struct expression * new_expression;

                        new_expression = calloc(1, 240U);
                        if (new_expression == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                        new_expression->first_token = ctx->current;
                        parser_match(ctx);
                        if (ctx->current == 0U)
                        {
                            unexpected_end_of_file(ctx);
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                        new_expression->expression_type = 20;
                        if (first_of_type_name_ahead(ctx))
                        {
                            if (parser_match_tk(ctx, 40) != 0)
                            {
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            new_expression->type_name = type_name(ctx);
                            if (new_expression->type_name == 0U)
                            {
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            new_expression->type = make_size_t_type();
                            if (ctx->current == 0U)
                            {
                                unexpected_end_of_file(ctx);
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            new_expression->last_token = ctx->current;
                            if (parser_match_tk(ctx, 41) != 0)
                            {
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            if (type_is_enum(&new_expression->type_name->abstract_declarator->type))
                            {
                                struct enum_specifier * p_enum_specifier;
                                unsigned int nelements;

                                p_enum_specifier = get_complete_enum_specifier(new_expression->type_name->type.enum_specifier);
                                nelements = 0;
                                if (p_enum_specifier)
                                {
                                    struct enumerator * p;

                                    p = p_enum_specifier->enumerator_list.head;
                                    while (p)
                                    {
                                        nelements++;
                                        p = p->next;
                                    }
                                }
                                new_expression->object = object_make_size_t(nelements);
                            }
                            else
                            {
                                if (type_is_array(&new_expression->type_name->abstract_declarator->type))
                                {
                                    unsigned int nelements;

                                    nelements = new_expression->type_name->abstract_declarator->type.num_of_elements;
                                    if (nelements > 0)
                                    {
                                        new_expression->object = object_make_size_t(nelements);
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(1390, ctx, new_expression->type_name->first_token, 0U, "argument of _Countof must be an array");
                                    expression_delete(new_expression);
                                    goto _CKL0;/*throw*/
                                }
                            }
                        }
                        else
                        {
                            unsigned char   disable_evaluation_copy;

                            if (parser_match_tk(ctx, 40) != 0)
                            {
                                expression_delete(new_expression);
                                new_expression = 0U;
                                goto _CKL0;/*throw*/
                            }
                            disable_evaluation_copy = ctx->evaluation_is_disabled;
                            ctx->evaluation_is_disabled = 1;
                            new_expression->right = unary_expression(ctx);
                            ctx->evaluation_is_disabled = disable_evaluation_copy;
                            if (new_expression->right == 0U)
                            {
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            if (ctx->current == 0U)
                            {
                                unexpected_end_of_file(ctx);
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            new_expression->last_token = ctx->current;
                            if (parser_match_tk(ctx, 41) != 0)
                            {
                                expression_delete(new_expression);
                                goto _CKL0;/*throw*/
                            }
                            if (type_is_enum(&new_expression->right->type))
                            {
                                struct enum_specifier * p_enum_specifier;
                                unsigned int nelements;

                                p_enum_specifier = get_complete_enum_specifier(new_expression->right->type.enum_specifier);
                                nelements = 0;
                                if (p_enum_specifier)
                                {
                                    struct enumerator * p;

                                    p = p_enum_specifier->enumerator_list.head;
                                    while (p)
                                    {
                                        nelements++;
                                        p = p->next;
                                    }
                                }
                                new_expression->object = object_make_size_t(nelements);
                            }
                            else
                            {
                                if (type_is_array(&new_expression->right->type))
                                {
                                    unsigned int nelements;

                                    nelements = new_expression->right->type.num_of_elements;
                                    if (nelements > 0)
                                    {
                                        new_expression->object = object_make_size_t(nelements);
                                    }
                                    else
                                    {
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(1390, ctx, new_expression->right->first_token, 0U, "argument of _Countof must be an array");
                                    expression_delete(new_expression);
                                    goto _CKL0;/*throw*/
                                }
                            }
                        }
                        type_destroy(&new_expression->type);
                        new_expression->type = type_make_size_t();
                        p_expression_node = new_expression;
                    }
                    else
                    {
                        if (ctx->current->type == 9062)
                        {
                            struct expression * new_expression;

                            new_expression = calloc(1, 240U);
                            if (new_expression == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            new_expression->expression_type = 25;
                            new_expression->first_token = ctx->current;
                            parser_match(ctx);
                            if (ctx->current == 0U || parser_match_tk(ctx, 40) != 0)
                            {
                                expression_delete(new_expression);
                                new_expression = 0U;
                                goto _CKL0;/*throw*/
                            }
                            new_expression->right = expression(ctx);
                            if (parser_match_tk(ctx, 41) != 0)
                            {
                                expression_delete(new_expression);
                                new_expression = 0U;
                                goto _CKL0;/*throw*/
                            }
                            return new_expression;
                        }
                        else
                        {
                            if (ctx->current->type == 9044)
                            {
                                struct expression * new_expression;

                                new_expression = calloc(1, 240U);
                                if (new_expression == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                                new_expression->expression_type = 24;
                                new_expression->first_token = ctx->current;
                                parser_match(ctx);
                                if (ctx->current == 0U || parser_match_tk(ctx, 40) != 0)
                                {
                                    expression_delete(new_expression);
                                    new_expression = 0U;
                                    goto _CKL0;/*throw*/
                                }
                                new_expression->type_name = type_name(ctx);
                                if (parser_match_tk(ctx, 41) != 0)
                                {
                                    expression_delete(new_expression);
                                    new_expression = 0U;
                                    goto _CKL0;/*throw*/
                                }
                                if (!ctx->evaluation_is_disabled)
                                {
                                    new_expression->object = object_make_size_t(type_get_alignof(&new_expression->type_name->type));
                                }
                                new_expression->type = type_make_int();
                                ;
                                new_expression->last_token = ctx->previous;
                                p_expression_node = new_expression;
                            }
                            else
                            {
                                if (ctx->current->type == 9080 || ctx->current->type == 9082 || ctx->current->type == 9081 || ctx->current->type == 9079 || ctx->current->type == 9083 || ctx->current->type == 9084 || ctx->current->type == 9086 || ctx->current->type == 9085 || ctx->current->type == 9087 || ctx->current->type == 9088)
                                {
                                    unsigned char   disable_evaluation_copy;
                                    struct token * traits_token;
                                    struct expression * new_expression;
                                    struct type * p_type;

                                    disable_evaluation_copy = ctx->evaluation_is_disabled;
                                    ctx->evaluation_is_disabled = 1;
                                    traits_token = ctx->current;
                                    new_expression = calloc(1, 240U);
                                    if (new_expression == 0U)
                                    {
                                        goto _CKL0;/*throw*/
                                    }
                                    new_expression->first_token = ctx->current;
                                    new_expression->expression_type = 21;
                                    parser_match(ctx);
                                    if (ctx->current == 0U)
                                    {
                                        unexpected_end_of_file(ctx);
                                        expression_delete(new_expression);
                                        new_expression = 0U;
                                        goto _CKL0;/*throw*/
                                    }
                                    p_type = 0U;
                                    if (first_of_type_name_ahead(ctx))
                                    {
                                        if (parser_match_tk(ctx, 40) != 0)
                                        {
                                            expression_delete(new_expression);
                                            new_expression = 0U;
                                            goto _CKL0;/*throw*/
                                        }
                                        new_expression->type_name = type_name(ctx);
                                        if (new_expression->type_name == 0U)
                                        {
                                            expression_delete(new_expression);
                                            new_expression = 0U;
                                            goto _CKL0;/*throw*/
                                        }
                                        if (ctx->current == 0U)
                                        {
                                            unexpected_end_of_file(ctx);
                                            expression_delete(new_expression);
                                            new_expression = 0U;
                                            goto _CKL0;/*throw*/
                                        }
                                        new_expression->last_token = ctx->current;
                                        if (parser_match_tk(ctx, 41) != 0)
                                        {
                                            expression_delete(new_expression);
                                            new_expression = 0U;
                                            goto _CKL0;/*throw*/
                                        }
                                        p_type = &new_expression->type_name->abstract_declarator->type;
                                    }
                                    else
                                    {
                                        new_expression->right = unary_expression(ctx);
                                        if (new_expression->right == 0U)
                                        {
                                            ctx->evaluation_is_disabled = disable_evaluation_copy;
                                            expression_delete(new_expression);
                                            goto _CKL0;/*throw*/
                                        }
                                        p_type = &new_expression->right->type;
                                        if (ctx->previous == 0U)
                                        {
                                            expression_delete(new_expression);
                                            new_expression = 0U;
                                            goto _CKL0;/*throw*/
                                        }
                                        new_expression->last_token = ctx->previous;
                                    }
                                    /*switch*/
                                    {
                                        register int _R44 = traits_token->type;
                                        if (_R44 == 9080) goto _CKL120; /*case 9080*/
                                        if (_R44 == 9081) goto _CKL121; /*case 9081*/
                                        if (_R44 == 9082) goto _CKL122; /*case 9082*/
                                        if (_R44 == 9079) goto _CKL123; /*case 9079*/
                                        if (_R44 == 9084) goto _CKL124; /*case 9084*/
                                        if (_R44 == 9083) goto _CKL125; /*case 9083*/
                                        if (_R44 == 9086) goto _CKL126; /*case 9086*/
                                        if (_R44 == 9085) goto _CKL127; /*case 9085*/
                                        if (_R44 == 9087) goto _CKL128; /*case 9087*/
                                        if (_R44 == 9088) goto _CKL129; /*case 9088*/
                                        goto _CKL130;/*default*/

                                        {
                                            _CKL120:/*case 9080*/ 
                                            ;
                                            new_expression->object = object_make_signed_int(expression_is_lvalue(new_expression->right));
                                            goto _CKL119; /*break*/

                                            _CKL121:/*case 9081*/ 
                                            new_expression->object = object_make_signed_int(type_is_const(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL122:/*case 9082*/ 
                                            new_expression->object = object_make_signed_int(type_is_owner(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL123:/*case 9079*/ 
                                            new_expression->object = object_make_signed_int(type_is_pointer(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL124:/*case 9084*/ 
                                            new_expression->object = object_make_signed_int(type_is_function(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL125:/*case 9083*/ 
                                            new_expression->object = object_make_signed_int(type_is_array(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL126:/*case 9086*/ 
                                            new_expression->object = object_make_signed_int(type_is_arithmetic(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL127:/*case 9085*/ 
                                            new_expression->object = object_make_signed_int(type_is_scalar(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL128:/*case 9087*/ 
                                            new_expression->object = object_make_signed_int(type_is_floating_point(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL129:/*case 9088*/ 
                                            new_expression->object = object_make_signed_int(type_is_integer(p_type));
                                            goto _CKL119; /*break*/

                                            _CKL130: /*default*/ 
                                            ;
                                        }
                                        _CKL119:;
                                    }
                                    new_expression->type = type_make_int_bool_like();
                                    p_expression_node = new_expression;
                                    ctx->evaluation_is_disabled = disable_evaluation_copy;
                                }
                                else
                                {
                                    p_expression_node = postfix_expression(ctx);
                                    if (p_expression_node == 0U)
                                    {
                                        goto _CKL0;/*throw*/
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

unsigned char  type_is_nullptr_t(struct type * p_type);
unsigned char  type_is_bool(struct type * p_type);
unsigned char  expression_is_null_pointer_constant(struct expression * expression);

struct expression *cast_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (first_of_type_name_ahead(ctx))
        {
            p_expression_node = calloc(1, 240U);
            if (p_expression_node == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node->first_token = ctx->current;
            p_expression_node->expression_type = 34;
            if (parser_match_tk(ctx, 40) != 0)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node->type_name = type_name(ctx);
            if (p_expression_node->type_name == 0U)
            {
                expression_delete(p_expression_node);
                p_expression_node = 0U;
                goto _CKL0;/*throw*/
            }
            p_expression_node->type = type_dup(&p_expression_node->type_name->type);
            if (parser_match_tk(ctx, 41) != 0)
            {
                goto _CKL0;/*throw*/
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type == 123)
            {
                struct expression * new_expression;

                new_expression = postfix_expression_type_name(ctx, p_expression_node->type_name);
                p_expression_node->type_name = 0U;
                if (new_expression == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                expression_delete(p_expression_node);
                p_expression_node = new_expression;
            }
            else
            {
                if (is_first_of_unary_expression(ctx))
                {
                    p_expression_node->left = cast_expression(ctx);
                    if (p_expression_node->left == 0U)
                    {
                        expression_delete(p_expression_node);
                        p_expression_node = 0U;
                        goto _CKL0;/*throw*/
                    }
                    if (type_is_floating_point(&p_expression_node->type) && type_is_pointer(&p_expression_node->left->type))
                    {
                        compiler_diagnostic(1790, ctx, p_expression_node->first_token, 0U, "pointer type cannot be converted to any floating type");
                    }
                    else
                    {
                        if (type_is_pointer(&p_expression_node->type) && type_is_floating_point(&p_expression_node->left->type))
                        {
                            compiler_diagnostic(1800, ctx, p_expression_node->first_token, 0U, "A floating type cannot be converted to any pointer type");
                        }
                        else
                        {
                            if (type_is_nullptr_t(&p_expression_node->left->type))
                            {
                                if (type_is_void(&p_expression_node->type) || type_is_bool(&p_expression_node->type) || type_is_pointer(&p_expression_node->type))
                                {
                                }
                                else
                                {
                                    compiler_diagnostic(1810, ctx, p_expression_node->first_token, 0U, "cannot cast nullptr_t to this type");
                                }
                            }
                            else
                            {
                                if (type_is_nullptr_t(&p_expression_node->type))
                                {
                                    if (expression_is_null_pointer_constant(p_expression_node->left) || type_is_nullptr_t(&p_expression_node->left->type))
                                    {
                                    }
                                    else
                                    {
                                        compiler_diagnostic(1810, ctx, p_expression_node->left->first_token, 0U, "cannot cast this expression to nullptr_t");
                                    }
                                }
                            }
                        }
                    }
                    if (p_expression_node->left->type.storage_class_specifier_flags & 8192 && type_is_owner(&p_expression_node->left->type))
                    {
                        if (!type_is_owner(&p_expression_node->type))
                        {
                            if (type_is_pointer(&p_expression_node->left->type))
                            {
                                compiler_diagnostic(25, ctx, p_expression_node->first_token, 0U, "discarding _Owner pointer");
                            }
                            else
                            {
                                compiler_diagnostic(25, ctx, p_expression_node->first_token, 0U, "discarding _Owner");
                            }
                        }
                    }
                    type_destroy(&p_expression_node->type);
                    p_expression_node->type = make_type_using_declarator(ctx, p_expression_node->type_name->abstract_declarator);
                    if (!ctx->evaluation_is_disabled && object_has_constant_value(&p_expression_node->left->object))
                    {
                        int vt;

                        vt = type_to_object_type(&p_expression_node->type);
                        p_expression_node->object = object_cast(vt, &p_expression_node->left->object);
                    }
                    p_expression_node->type.storage_class_specifier_flags = p_expression_node->left->type.storage_class_specifier_flags;
                }
                else
                {
                    compiler_diagnostic(650, ctx, ctx->current, 0U, "expected expression");
                }
            }
        }
        else
        {
            if (is_first_of_unary_expression(ctx))
            {
                p_expression_node = unary_expression(ctx);
                if (p_expression_node == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            else
            {
                compiler_diagnostic(650, ctx, ctx->current, 0U, "expected expression");
                ;
                goto _CKL0;/*throw*/
            }
        }
        if (ctx->current == 0U || ctx->previous == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_expression_node->last_token = ctx->previous;
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

int execute_arithmetic(struct parser_ctx * ctx, struct expression * new_expression, int op, struct object * result)
{
    struct type  common_type;
    struct object  empty;

    ;
    _cake_zmem(&common_type, 68);
    if (1) /*try*/
    {
        struct object  value;

        if (new_expression->left == 0U || new_expression->right == 0U)
        {
            ;
            goto _CKL0;/*throw*/
        }
        _cake_zmem(&value, 104);
        /*switch*/
        {
            register int _R45 = op;
            if (_R45 == 43) goto _CKL3; /*case 43*/
            if (_R45 == 45) goto _CKL4; /*case 45*/
            if (_R45 == 42) goto _CKL5; /*case 42*/
            if (_R45 == 47) goto _CKL6; /*case 47*/
            if (_R45 == 37) goto _CKL7; /*case 37*/
            if (_R45 == 62) goto _CKL8; /*case 62*/
            if (_R45 == 60) goto _CKL9; /*case 60*/
            if (_R45 == 15933) goto _CKL10; /*case 15933*/
            if (_R45 == 15421) goto _CKL11; /*case 15421*/
            if (_R45 == 15677) goto _CKL12; /*case 15677*/
            if (_R45 == 8509) goto _CKL13; /*case 8509*/
            goto _CKL14;/*default*/

            {
                _CKL3:/*case 43*/ 
                _CKL4:/*case 45*/ 
                _CKL5:/*case 42*/ 
                _CKL6:/*case 47*/ 
                _CKL7:/*case 37*/ 
                _CKL8:/*case 62*/ 
                _CKL9:/*case 60*/ 
                _CKL10:/*case 15933*/ 
                _CKL11:/*case 15421*/ 
                _CKL12:/*case 15677*/ 
                _CKL13:/*case 8509*/ 
                goto _CKL2; /*break*/

                _CKL14: /*default*/ 
                ;
                goto _CKL0;/*throw*/
            }
            _CKL2:;
        }
        if (!type_is_arithmetic(&new_expression->left->type))
        {
            compiler_diagnostic(840, ctx, ctx->current, 0U, "left type must be an arithmetic type");
            goto _CKL0;/*throw*/
        }
        if (!type_is_arithmetic(&new_expression->right->type))
        {
            compiler_diagnostic(840, ctx, ctx->current, 0U, "right type must be an arithmetic type");
            goto _CKL0;/*throw*/
        }
        if (!ctx->evaluation_is_disabled && object_has_constant_value(&new_expression->left->object) && object_has_constant_value(&new_expression->right->object))
        {
            struct marker  m;
            int vt;

            m.file = 0;
            m.line = 0;
            m.start_col = 0;
            m.end_col = 0;
            m.p_token_caret = 0;
            m.p_token_begin = new_expression->left->first_token;
            m.p_token_end = new_expression->right->last_token;
            common_type = type_common(&new_expression->left->type, &new_expression->right->type);
            vt = type_to_object_type(&common_type);
            /*switch*/
            {
                register int _R46 = vt;
                if (_R46 == 0) goto _CKL19; /*case 0*/
                if (_R46 == 1) goto _CKL40; /*case 1*/
                if (_R46 == 7) goto _CKL60; /*case 7*/
                if (_R46 == 8) goto _CKL81; /*case 8*/
                if (_R46 == 9) goto _CKL101; /*case 9*/
                if (_R46 == 10) goto _CKL119; /*case 10*/
                if (_R46 == 2) goto _CKL136; /*case 2*/
                if (_R46 == 3) goto _CKL137; /*case 3*/
                if (_R46 == 4) goto _CKL138; /*case 4*/
                if (_R46 == 5) goto _CKL139; /*case 5*/
                if (_R46 == 6) goto _CKL140; /*case 6*/
                if (_R46 == 11) goto _CKL141; /*case 11*/
                if (_R46 == 12) goto _CKL154; /*case 12*/
                if (_R46 == 13) goto _CKL167; /*case 13*/
                goto _CKL18;

                {
                    _CKL19:/*case 0*/ 
                    {
                        int a;
                        int b;

                        a = object_to_signed_int(&new_expression->left->object);
                        b = object_to_signed_int(&new_expression->right->object);
                        if (op == 43)
                        {
                            int computed_result;
                            signed long long exact_result;

                            computed_result = a + b;
                            if (signed_long_long_add(&exact_result, a, b))
                            {
                                if (computed_result != exact_result)
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                }
                            }
                            else
                            {
                                ;
                            }
                            value = object_make_signed_int(computed_result);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                int computed_result;
                                signed long long exact_result;

                                computed_result = a - b;
                                if (signed_long_long_sub(&exact_result, a, b))
                                {
                                    if (computed_result != exact_result)
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                    }
                                }
                                else
                                {
                                    ;
                                }
                                value = object_make_signed_int(computed_result);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    int computed_result;
                                    signed long long exact_result;

                                    computed_result = a * b;
                                    if (signed_long_long_mul(&exact_result, a, b))
                                    {
                                        if (computed_result != exact_result)
                                        {
                                            compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                        }
                                    }
                                    else
                                    {
                                        ;
                                    }
                                    value = object_make_signed_int(computed_result);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            if (a == -2147483648 && b == -1)
                                            {
                                                compiler_diagnostic(50, ctx, new_expression->right->first_token, 0U, "integer overflow");
                                                value = object_make_signed_int(-2147483648);
                                            }
                                            else
                                            {
                                                value = object_make_signed_int(a / b);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                            }
                                            else
                                            {
                                                value = object_make_signed_int(a % b);
                                            }
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL40:/*case 1*/ 
                    {
                        unsigned int a;
                        unsigned int b;

                        a = object_to_unsigned_int(&new_expression->left->object);
                        b = object_to_unsigned_int(&new_expression->right->object);
                        if (op == 43)
                        {
                            unsigned int computed_result;
                            unsigned long long exact_result;

                            computed_result = a + b;
                            if (unsigned_long_long_add(&exact_result, a, b))
                            {
                                if (computed_result != exact_result)
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                }
                            }
                            else
                            {
                                ;
                            }
                            value = object_make_signed_int(computed_result);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                unsigned int computed_result;
                                unsigned long long exact_result;

                                computed_result = a - b;
                                if (unsigned_long_long_sub(&exact_result, a, b))
                                {
                                    if (computed_result != exact_result)
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                    }
                                }
                                else
                                {
                                    ;
                                }
                                value = object_make_signed_int(computed_result);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    unsigned int computed_result;
                                    unsigned long long exact_result;

                                    computed_result = a * b;
                                    if (unsigned_long_long_mul(&exact_result, a, b))
                                    {
                                        if (computed_result != exact_result)
                                        {
                                            compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                        }
                                    }
                                    else
                                    {
                                        ;
                                    }
                                    value = object_make_signed_int(computed_result);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            value = object_make_unsigned_int(a / b);
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                                goto _CKL0;/*throw*/
                                            }
                                            value = object_make_unsigned_int(a % b);
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL60:/*case 7*/ 
                    {
                        signed long a;
                        signed long b;

                        a = object_to_signed_long(&new_expression->left->object);
                        b = object_to_signed_long(&new_expression->right->object);
                        if (op == 43)
                        {
                            signed long computed_result;
                            signed long long exact_result;

                            computed_result = a + b;
                            if (signed_long_long_add(&exact_result, a, b))
                            {
                                if (computed_result != exact_result)
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                }
                            }
                            else
                            {
                                compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                            }
                            value = object_make_signed_long(computed_result);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                signed long computed_result;
                                signed long long exact_result;

                                computed_result = a - b;
                                if (signed_long_long_sub(&exact_result, a, b))
                                {
                                    if (computed_result != exact_result)
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                }
                                value = object_make_signed_long(computed_result);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    signed long computed_result;
                                    signed long long exact_result;

                                    computed_result = a * b;
                                    if (signed_long_long_mul(&exact_result, a, b))
                                    {
                                        if (computed_result != exact_result)
                                        {
                                            compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                        }
                                    }
                                    else
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                    }
                                    value = object_make_signed_long(computed_result);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            if (a == -2147483648L && b == -1)
                                            {
                                                compiler_diagnostic(50, ctx, new_expression->right->first_token, 0U, "integer overflow");
                                                value = object_make_signed_long(-2147483648L);
                                            }
                                            else
                                            {
                                                value = object_make_signed_long(a / b);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                            }
                                            else
                                            {
                                                value = object_make_signed_long(a % b);
                                            }
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_long(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_long(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_long(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_long(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_long(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_long(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL81:/*case 8*/ 
                    {
                        unsigned long a;
                        unsigned long b;

                        a = object_to_unsigned_long(&new_expression->left->object);
                        b = object_to_unsigned_long(&new_expression->right->object);
                        if (op == 43)
                        {
                            unsigned long computed_result;
                            unsigned long long exact_result;

                            computed_result = a + b;
                            if (unsigned_long_long_add(&exact_result, a, b))
                            {
                                if (computed_result != exact_result)
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                }
                            }
                            else
                            {
                                compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                            }
                            value = object_make_unsigned_long(computed_result);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                unsigned long computed_result;
                                unsigned long long exact_result;

                                computed_result = a - b;
                                if (unsigned_long_long_sub(&exact_result, a, b))
                                {
                                    if (computed_result != exact_result)
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                    }
                                }
                                else
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                }
                                value = object_make_unsigned_long(computed_result);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    unsigned long computed_result;
                                    unsigned long long exact_result;

                                    computed_result = a * b;
                                    if (unsigned_long_long_mul(&exact_result, a, b))
                                    {
                                        if (computed_result != exact_result)
                                        {
                                            compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%d'. Exactly result is '%lld'.", computed_result, exact_result);
                                        }
                                    }
                                    else
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                    }
                                    value = object_make_unsigned_long(computed_result);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            value = object_make_unsigned_long(a / b);
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                                goto _CKL0;/*throw*/
                                            }
                                            value = object_make_unsigned_long(a % b);
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_unsigned_long(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_unsigned_long(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_unsigned_long(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_unsigned_long(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_unsigned_long(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_unsigned_long(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL101:/*case 9*/ 
                    {
                        long long a;
                        long long b;

                        a = object_to_signed_long_long(&new_expression->left->object);
                        b = object_to_signed_long_long(&new_expression->right->object);
                        if (op == 43)
                        {
                            long long computed_result;
                            signed long long exact_result;

                            computed_result = a + b;
                            if (!signed_long_long_add(&exact_result, a, b))
                            {
                                compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%dll'. ", computed_result);
                            }
                            value = object_make_signed_long_long(computed_result);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                long long computed_result;
                                signed long long exact_result;

                                computed_result = a - b;
                                if (!signed_long_long_sub(&exact_result, a, b))
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%dll'.", computed_result);
                                }
                                value = object_make_signed_long_long(computed_result);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    long long computed_result;
                                    signed long long exact_result;

                                    computed_result = a * b;
                                    if (!signed_long_long_mul(&exact_result, a, b))
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow results in '%dll", computed_result);
                                    }
                                    value = object_make_signed_long_long(computed_result);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            if (a == -9223372036854775808LL && b == -1)
                                            {
                                                compiler_diagnostic(50, ctx, new_expression->right->first_token, 0U, "integer overflow");
                                                value = object_make_signed_long_long(-9223372036854775808LL);
                                            }
                                            else
                                            {
                                                value = object_make_signed_long_long(a / b);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                                goto _CKL0;/*throw*/
                                            }
                                            value = object_make_signed_long_long(a % b);
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL119:/*case 10*/ 
                    {
                        unsigned long long a;
                        unsigned long long b;

                        a = object_to_unsigned_long_long(&new_expression->left->object);
                        b = object_to_unsigned_long_long(&new_expression->right->object);
                        if (op == 43)
                        {
                            unsigned long long exact_result;

                            if (unsigned_long_long_add(&exact_result, a, b))
                            {
                            }
                            else
                            {
                                compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                            }
                            value = object_make_unsigned_long_long(a + b);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                unsigned long long exact_result;

                                if (unsigned_long_long_sub(&exact_result, a, b))
                                {
                                }
                                else
                                {
                                    compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                }
                                value = object_make_unsigned_long_long(a - b);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    unsigned long long exact_result;

                                    if (unsigned_long_long_mul(&exact_result, a, b))
                                    {
                                    }
                                    else
                                    {
                                        compiler_diagnostic(50, ctx, 0U, &m, "integer overflow");
                                    }
                                    value = object_make_unsigned_long_long(a * b);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        value = object_make_unsigned_long_long(a / b);
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            if (b == 0)
                                            {
                                                compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                                goto _CKL0;/*throw*/
                                            }
                                            value = object_make_unsigned_long_long(a % b);
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL136:/*case 2*/ 
                    _CKL137:/*case 3*/ 
                    _CKL138:/*case 4*/ 
                    _CKL139:/*case 5*/ 
                    _CKL140:/*case 6*/ 
                    ;
                    goto _CKL0;/*throw*/
                    goto _CKL18; /*break*/

                    _CKL141:/*case 11*/ 
                    {
                        float a;
                        float b;

                        a = object_to_float(&new_expression->left->object);
                        b = object_to_float(&new_expression->right->object);
                        if (op == 43)
                        {
                            value = object_make_float(a + b);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                value = object_make_float(a - b);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    value = object_make_float(a * b);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        value = object_make_float(a / b);
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "'%': not valid as left operand has type 'float'");
                                            goto _CKL0;/*throw*/
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL154:/*case 12*/ 
                    {
                        double a;
                        double b;

                        a = object_to_double(&new_expression->left->object);
                        b = object_to_double(&new_expression->right->object);
                        if (op == 43)
                        {
                            value = object_make_double(a + b);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                value = object_make_double(a - b);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    value = object_make_double(a * b);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            value = object_make_double(a / b);
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "'%': not valid as left operand has type 'float'");
                                            goto _CKL0;/*throw*/
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                    _CKL167:/*case 13*/ 
                    {
                        long double a;
                        long double b;

                        a = object_to_long_double(&new_expression->left->object);
                        b = object_to_long_double(&new_expression->right->object);
                        if (op == 43)
                        {
                            value = object_make_long_double(a + b);
                        }
                        else
                        {
                            if (op == 45)
                            {
                                value = object_make_long_double(a - b);
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    value = object_make_long_double(a * b);
                                }
                                else
                                {
                                    if (op == 47)
                                    {
                                        if (b == 0)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "division by zero");
                                        }
                                        else
                                        {
                                            value = object_make_long_double(a / b);
                                        }
                                    }
                                    else
                                    {
                                        if (op == 37)
                                        {
                                            compiler_diagnostic(36, ctx, new_expression->right->first_token, 0U, "'%': not valid as left operand has type 'float'");
                                            goto _CKL0;/*throw*/
                                        }
                                        else
                                        {
                                            if (op == 62)
                                            {
                                                value = object_make_signed_int(a > b);
                                            }
                                            else
                                            {
                                                if (op == 60)
                                                {
                                                    value = object_make_signed_int(a < b);
                                                }
                                                else
                                                {
                                                    if (op == 15933)
                                                    {
                                                        value = object_make_signed_int(a >= b);
                                                    }
                                                    else
                                                    {
                                                        if (op == 15421)
                                                        {
                                                            value = object_make_signed_int(a <= b);
                                                        }
                                                        else
                                                        {
                                                            if (op == 15677)
                                                            {
                                                                value = object_make_signed_int(a == b);
                                                            }
                                                            else
                                                            {
                                                                if (op == 8509)
                                                                {
                                                                    value = object_make_signed_int(a != b);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    goto _CKL18; /*break*/

                }
                _CKL18:;
            }
            ;
        }
        type_destroy(&common_type);
        *result = value;
        return 0;
    }
    else _CKL0: /*catch*/ 
    {
    }
    type_destroy(&common_type);
    _cake_zmem(&empty, 104);
    *result = empty;
    return 1;
}

struct expression *multiplicative_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = cast_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 42 || ctx->current->type == 47 || ctx->current->type == 37))
        {
            struct expression * new_expression;
            int op;

            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                expression_delete(p_expression_node);
                p_expression_node = 0U;
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            op = ctx->current->type;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            /*switch*/
            {
                register int _R47 = op;
                if (_R47 == 42) goto _CKL5; /*case 42*/
                if (_R47 == 47) goto _CKL6; /*case 47*/
                if (_R47 == 37) goto _CKL7; /*case 37*/
                goto _CKL8;/*default*/

                {
                    _CKL5:/*case 42*/ 
                    new_expression->expression_type = 35;
                    goto _CKL4; /*break*/

                    _CKL6:/*case 47*/ 
                    new_expression->expression_type = 36;
                    goto _CKL4; /*break*/

                    _CKL7:/*case 37*/ 
                    new_expression->expression_type = 37;
                    goto _CKL4; /*break*/

                    _CKL8: /*default*/ 
                    ;
                    goto _CKL4; /*break*/

                }
                _CKL4:;
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = cast_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (op == 37)
            {
                if (!type_is_integer(&new_expression->left->type))
                {
                    compiler_diagnostic(840, ctx, new_expression->left->first_token, 0U, "left is not an integer type");
                }
                if (!type_is_integer(&new_expression->right->type))
                {
                    compiler_diagnostic(850, ctx, new_expression->right->first_token, 0U, "right is not an integer type");
                }
            }
            else
            {
                if (!type_is_arithmetic(&new_expression->left->type))
                {
                    compiler_diagnostic(820, ctx, new_expression->left->first_token, 0U, "left is not an arithmetic type");
                }
                if (!type_is_arithmetic(&new_expression->right->type))
                {
                    compiler_diagnostic(830, ctx, new_expression->right->first_token, 0U, "right is not an arithmetic type");
                }
            }
            new_expression->type = type_common(&new_expression->left->type, &new_expression->right->type);
            if (!ctx->evaluation_is_disabled && execute_arithmetic(ctx, new_expression, op, &new_expression->object) != 0)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

struct expression *additive_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = multiplicative_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 43 || ctx->current->type == 45))
        {
            struct token * operator_position;
            struct expression * new_expression;
            int op;
            unsigned char   b_left_is_arithmetic;
            unsigned char   b_right_is_arithmetic;
            int left_category;
            int right_category;

            operator_position = ctx->current;
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                compiler_diagnostic(1260, ctx, ctx->current, 0U, "out of mem");
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            op = ctx->current->type;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(new_expression);
                new_expression = 0U;
                goto _CKL0;/*throw*/
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = multiplicative_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                new_expression = 0U;
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (!type_is_scalar(&new_expression->left->type) && !type_is_array(&new_expression->left->type))
            {
                compiler_diagnostic(870, ctx, operator_position, 0U, "left operator is not scalar");
            }
            if (!type_is_scalar(&new_expression->right->type) && !type_is_array(&new_expression->right->type))
            {
                compiler_diagnostic(880, ctx, operator_position, 0U, "right operator is not scalar");
            }
            b_left_is_arithmetic = type_is_arithmetic(&new_expression->left->type);
            b_right_is_arithmetic = type_is_arithmetic(&new_expression->right->type);
            left_category = type_get_category(&new_expression->left->type);
            right_category = type_get_category(&new_expression->right->type);
            if (op == 43)
            {
                new_expression->expression_type = 38;
                if (b_left_is_arithmetic && b_right_is_arithmetic)
                {
                    new_expression->type = type_common(&new_expression->left->type, &new_expression->right->type);
                    if (!ctx->evaluation_is_disabled && execute_arithmetic(ctx, new_expression, op, &new_expression->object) != 0)
                    {
                        expression_delete(new_expression);
                        goto _CKL0;/*throw*/
                    }
                }
                else
                {
                    if (left_category == 3 || left_category == 2)
                    {
                        if (type_is_integer(&new_expression->right->type))
                        {
                            if (left_category == 2)
                            {
                                struct type  t;

                                t = get_array_item_type(&new_expression->left->type);
                                new_expression->type = type_add_pointer(&t, ctx->options.null_checks_enabled);
                                type_destroy(&t);
                            }
                            else
                            {
                                new_expression->type = type_dup(&new_expression->left->type);
                            }
                        }
                        else
                        {
                            compiler_diagnostic(850, ctx, ctx->current, 0U, "expected integer type on right");
                        }
                    }
                    else
                    {
                        if (right_category == 3 || right_category == 2)
                        {
                            if (type_is_integer(&new_expression->left->type))
                            {
                                if (right_category == 2)
                                {
                                    new_expression->type = get_array_item_type(&new_expression->right->type);
                                }
                                else
                                {
                                    new_expression->type = type_dup(&new_expression->right->type);
                                }
                            }
                            else
                            {
                                compiler_diagnostic(840, ctx, ctx->current, 0U, "expected integer type on left");
                            }
                        }
                        else
                        {
                            compiler_diagnostic(860, ctx, ctx->current, 0U, "invalid types additive expression");
                        }
                    }
                }
            }
            else
            {
                if (op == 45)
                {
                    new_expression->expression_type = 39;
                    if (b_left_is_arithmetic && b_right_is_arithmetic)
                    {
                        new_expression->type = type_common(&new_expression->left->type, &new_expression->right->type);
                        if (!ctx->evaluation_is_disabled && execute_arithmetic(ctx, new_expression, op, &new_expression->object) != 0)
                        {
                            expression_delete(new_expression);
                            goto _CKL0;/*throw*/
                        }
                    }
                    else
                    {
                        if (left_category == 3 || left_category == 2)
                        {
                            if (right_category == 3 || right_category == 2)
                            {
                                struct type  t1;
                                struct type  t2;

                                t1 = type_lvalue_conversion(&new_expression->left->type, ctx->options.null_checks_enabled);
                                t2 = type_lvalue_conversion(&new_expression->right->type, ctx->options.null_checks_enabled);
                                if (!type_is_same(&t1, &t2, 0))
                                {
                                    compiler_diagnostic(890, ctx, ctx->current, 0U, "incompatible pointer types");
                                }
                                new_expression->type = type_make_int();
                                type_destroy(&t1);
                                type_destroy(&t2);
                            }
                            else
                            {
                                if (type_is_integer(&new_expression->right->type))
                                {
                                    new_expression->type = type_dup(&new_expression->left->type);
                                }
                                else
                                {
                                    compiler_diagnostic(850, ctx, ctx->current, 0U, "right must be integer type");
                                }
                            }
                        }
                        else
                        {
                            compiler_diagnostic(860, ctx, ctx->current, 0U, "invalid types for operator -");
                        }
                    }
                }
            }
            p_expression_node = new_expression;
            new_expression = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

static int execute_bitwise_operator(struct parser_ctx * ctx, struct expression * new_expression, int op);

struct expression *shift_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = additive_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 15934 || ctx->current->type == 15420))
        {
            struct expression * new_expression;
            int op;

            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            op = ctx->current->type;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(new_expression);
                new_expression = 0U;
                goto _CKL0;/*throw*/
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = multiplicative_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (op == 15934)
            {
                new_expression->expression_type = 40;
            }
            else
            {
                if (op == 15420)
                {
                    new_expression->expression_type = 41;
                }
            }
            if (execute_bitwise_operator(ctx, new_expression, op) != 0)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

void check_comparison(struct parser_ctx * ctx, struct expression * p_a_expression, struct expression * p_b_expression, struct token * op_token);

struct expression *relational_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;
    struct expression * new_expression;

    p_expression_node = 0U;
    new_expression = 0U;
    if (1) /*try*/
    {
        p_expression_node = shift_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 62 || ctx->current->type == 60 || ctx->current->type == 15933 || ctx->current->type == 15421))
        {
            int op;

            ;
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            op = ctx->current->type;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = shift_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                new_expression = 0U;
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(new_expression);
                new_expression = 0U;
                goto _CKL0;/*throw*/
            }
            check_comparison(ctx, new_expression->left, new_expression->right, ctx->current);
            if (op == 62)
            {
                new_expression->expression_type = 42;
            }
            else
            {
                if (op == 60)
                {
                    new_expression->expression_type = 43;
                }
                else
                {
                    if (op == 15933)
                    {
                        new_expression->expression_type = 44;
                    }
                    else
                    {
                        if (op == 15421)
                        {
                            new_expression->expression_type = 45;
                        }
                    }
                }
            }
            if (type_is_arithmetic(&new_expression->left->type) && type_is_arithmetic(&new_expression->right->type))
            {
                new_expression->type = type_common(&new_expression->left->type, &new_expression->right->type);
                if (!ctx->evaluation_is_disabled && execute_arithmetic(ctx, new_expression, op, &new_expression->object) != 0)
                {
                    expression_delete(new_expression);
                    new_expression = 0U;
                    goto _CKL0;/*throw*/
                }
            }
            type_destroy(&new_expression->type);
            new_expression->type = type_make_int_bool_like();
            p_expression_node = new_expression;
            new_expression = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(new_expression);
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

void check_diferent_enuns(struct parser_ctx * ctx, struct token * operator_token, struct expression * left, struct expression * right, char * message)
{
    if (left->type.type_specifier_flags & 65536 && right->type.type_specifier_flags & 65536)
    {
        ;
        ;
        if (get_complete_enum_specifier(left->type.enum_specifier) != get_complete_enum_specifier(right->type.enum_specifier))
        {
            char * lefttag;
            char * righttag;
            char finalmessage[200];

            ;
            ;
            lefttag = "";
            if (left->type.enum_specifier->tag_token)
            {
                lefttag = left->type.enum_specifier->tag_token->lexeme;
            }
            righttag = "";
            if (right->type.enum_specifier->tag_token)
            {
                righttag = right->type.enum_specifier->tag_token->lexeme;
            }
            _cake_zmem(&finalmessage, 200);
            snprintf(finalmessage, 200U, "%s (enum %s, enum %s)", message, lefttag, righttag);
            compiler_diagnostic(3, ctx, operator_token, 0U, finalmessage, lefttag, righttag);
        }
    }
}

void expression_evaluate_equal_not_equal(struct expression * left, struct expression * right, struct expression * result, int op, unsigned char   disabled)
{
    ;
}

struct expression *equality_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;
    struct expression * new_expression;

    p_expression_node = 0U;
    new_expression = 0U;
    if (1) /*try*/
    {
        p_expression_node = relational_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 15677 || ctx->current->type == 8509))
        {
            struct token * operator_token;

            ;
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            operator_token = ctx->current;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (operator_token->type == 15677)
            {
                new_expression->expression_type = 46;
            }
            else
            {
                new_expression->expression_type = 47;
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = relational_expression(ctx);
            if (new_expression->right == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            check_comparison(ctx, new_expression->left, new_expression->right, ctx->current);
            new_expression->last_token = new_expression->right->last_token;
            new_expression->first_token = operator_token;
            if (type_is_arithmetic(&new_expression->left->type) && type_is_arithmetic(&new_expression->right->type))
            {
                if (!ctx->evaluation_is_disabled && execute_arithmetic(ctx, new_expression, operator_token->type, &new_expression->object) != 0)
                {
                    goto _CKL0;/*throw*/
                }
            }
            new_expression->type = type_make_int_bool_like();
            p_expression_node = new_expression;
            new_expression = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    expression_delete(new_expression);
    return p_expression_node;
}

struct expression *and_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;
    struct expression * new_expression;

    p_expression_node = 0U;
    new_expression = 0U;
    if (1) /*try*/
    {
        p_expression_node = equality_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && ctx->current->type == 38)
        {
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            ;
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            new_expression->expression_type = 48;
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = equality_expression(ctx);
            if (new_expression->right == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (execute_bitwise_operator(ctx, new_expression, 38) != 0)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node = new_expression;
            new_expression = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    expression_delete(new_expression);
    return p_expression_node;
}

struct expression *exclusive_or_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;
    struct expression * new_expression;

    p_expression_node = 0U;
    new_expression = 0U;
    if (1) /*try*/
    {
        p_expression_node = and_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 94))
        {
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            ;
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            new_expression->expression_type = 49;
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = and_expression(ctx);
            if (new_expression->right == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (execute_bitwise_operator(ctx, new_expression, 94) != 0)
            {
                goto _CKL0;/*throw*/
            }
            p_expression_node = new_expression;
            new_expression = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    expression_delete(new_expression);
    return p_expression_node;
}

static int execute_bitwise_operator(struct parser_ctx * ctx, struct expression * new_expression, int op)
{
    if (1) /*try*/
    {
        /*switch*/
        {
            register int _R48 = op;
            if (_R48 == 38) goto _CKL2; /*case 38*/
            if (_R48 == 94) goto _CKL3; /*case 94*/
            if (_R48 == 124) goto _CKL4; /*case 124*/
            if (_R48 == 15934) goto _CKL5; /*case 15934*/
            if (_R48 == 15420) goto _CKL6; /*case 15420*/
            goto _CKL7;/*default*/

            {
                _CKL2:/*case 38*/ 
                _CKL3:/*case 94*/ 
                _CKL4:/*case 124*/ 
                _CKL5:/*case 15934*/ 
                _CKL6:/*case 15420*/ 
                goto _CKL1; /*break*/

                _CKL7: /*default*/ 
                ;
                goto _CKL0;/*throw*/
            }
            _CKL1:;
        }
        if (!type_is_integer(&new_expression->left->type))
        {
            compiler_diagnostic(840, ctx, ctx->current, 0U, "left type must be an integer type");
            goto _CKL0;/*throw*/
        }
        if (!type_is_integer(&new_expression->right->type))
        {
            compiler_diagnostic(840, ctx, ctx->current, 0U, "right type must be an integer type");
            goto _CKL0;/*throw*/
        }
        type_destroy(&new_expression->type);
        new_expression->type = type_common(&new_expression->left->type, &new_expression->right->type);
        if (!ctx->evaluation_is_disabled && object_has_constant_value(&new_expression->left->object) && object_has_constant_value(&new_expression->right->object))
        {
            int vt;

            vt = type_to_object_type(&new_expression->type);
            /*switch*/
            {
                register int _R49 = vt;
                if (_R49 == 0) goto _CKL12; /*case 0*/
                if (_R49 == 1) goto _CKL18; /*case 1*/
                if (_R49 == 7) goto _CKL24; /*case 7*/
                if (_R49 == 8) goto _CKL30; /*case 8*/
                if (_R49 == 9) goto _CKL36; /*case 9*/
                if (_R49 == 10) goto _CKL42; /*case 10*/
                if (_R49 == 2) goto _CKL48; /*case 2*/
                if (_R49 == 3) goto _CKL49; /*case 3*/
                if (_R49 == 4) goto _CKL50; /*case 4*/
                if (_R49 == 5) goto _CKL51; /*case 5*/
                if (_R49 == 6) goto _CKL52; /*case 6*/
                if (_R49 == 11) goto _CKL53; /*case 11*/
                if (_R49 == 12) goto _CKL54; /*case 12*/
                if (_R49 == 13) goto _CKL55; /*case 13*/
                goto _CKL11;

                {
                    _CKL12:/*case 0*/ 
                    {
                        int a;
                        int b;
                        int r;

                        a = object_to_signed_int(&new_expression->left->object);
                        b = object_to_signed_int(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_signed_int(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL18:/*case 1*/ 
                    {
                        unsigned int a;
                        unsigned int b;
                        int r;

                        a = object_to_unsigned_int(&new_expression->left->object);
                        b = object_to_unsigned_int(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_unsigned_int(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL24:/*case 7*/ 
                    {
                        signed long a;
                        signed long b;
                        int r;

                        a = object_to_signed_long(&new_expression->left->object);
                        b = object_to_signed_long(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_signed_long(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL30:/*case 8*/ 
                    {
                        unsigned long a;
                        unsigned long b;
                        int r;

                        a = object_to_unsigned_long(&new_expression->left->object);
                        b = object_to_unsigned_long(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_unsigned_long(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL36:/*case 9*/ 
                    {
                        signed long long a;
                        signed long long b;
                        signed long long r;

                        a = object_to_signed_long_long(&new_expression->left->object);
                        b = object_to_signed_long_long(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_signed_long_long(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL42:/*case 10*/ 
                    {
                        unsigned long long a;
                        unsigned long long b;
                        unsigned long long r;

                        a = object_to_unsigned_long_long(&new_expression->left->object);
                        b = object_to_unsigned_long_long(&new_expression->right->object);
                        r = 0;
                        if (op == 124)
                        {
                            r = a | b;
                        }
                        else
                        {
                            if (op == 94)
                            {
                                r = a ^ b;
                            }
                            else
                            {
                                if (op == 38)
                                {
                                    r = a & b;
                                }
                                else
                                {
                                    if (op == 15934)
                                    {
                                        r = a >> b;
                                    }
                                    else
                                    {
                                        if (op == 15420)
                                        {
                                            r = a << b;
                                        }
                                    }
                                }
                            }
                        }
                        object_destroy(&new_expression->object);
                        new_expression->object = object_make_unsigned_long_long(r);
                    }
                    goto _CKL11; /*break*/

                    _CKL48:/*case 2*/ 
                    _CKL49:/*case 3*/ 
                    _CKL50:/*case 4*/ 
                    _CKL51:/*case 5*/ 
                    _CKL52:/*case 6*/ 
                    ;
                    goto _CKL0;/*throw*/
                    goto _CKL11; /*break*/

                    _CKL53:/*case 11*/ 
                    _CKL54:/*case 12*/ 
                    _CKL55:/*case 13*/ 
                    ;
                    goto _CKL0;/*throw*/
                    goto _CKL11; /*break*/

                }
                _CKL11:;
            }
            ;
        }
        return 0;
    }
    else _CKL0: /*catch*/ 
    {
    }
    return 1;
}

struct expression *inclusive_or_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = exclusive_or_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 124))
        {
            struct token * operator_token;
            struct expression * new_expression;

            operator_token = ctx->current;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            new_expression->expression_type = 50;
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            new_expression->right = exclusive_or_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            check_diferent_enuns(ctx, operator_token, new_expression->left, new_expression->right, "operator '|' between enumerations of different types.");
            new_expression->last_token = new_expression->right->last_token;
            if (execute_bitwise_operator(ctx, new_expression, 124) != 0)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

struct expression *logical_and_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = inclusive_or_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 9766))
        {
            struct expression * new_expression;
            unsigned char   right_evaluation_is_disabled;
            unsigned char   old_evaluation_is_disabled;

            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            new_expression->expression_type = 52;
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            right_evaluation_is_disabled = 0;
            if (object_has_constant_value(&new_expression->left->object))
            {
                if (!object_to_bool(&new_expression->left->object))
                {
                    right_evaluation_is_disabled = 1;
                }
            }
            old_evaluation_is_disabled = ctx->evaluation_is_disabled;
            ctx->evaluation_is_disabled = right_evaluation_is_disabled;
            new_expression->right = inclusive_or_expression(ctx);
            ctx->evaluation_is_disabled = old_evaluation_is_disabled;
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (!ctx->evaluation_is_disabled)
            {
                if (object_has_constant_value(&new_expression->left->object))
                {
                    unsigned char   a;

                    a = object_to_bool(&new_expression->left->object);
                    if (a == 0)
                    {
                        new_expression->object = object_make_signed_int(0);
                    }
                    else
                    {
                        if (object_has_constant_value(&new_expression->right->object))
                        {
                            unsigned char   b;

                            b = object_to_bool(&new_expression->right->object);
                            new_expression->object = object_make_signed_int(a && b);
                        }
                    }
                }
            }
            if (!type_is_scalar(&new_expression->left->type))
            {
                expression_delete(new_expression);
                compiler_diagnostic(870, ctx, ctx->current, 0U, "left type is not scalar for or expression");
                goto _CKL0;/*throw*/
            }
            if (!type_is_scalar(&new_expression->right->type))
            {
                expression_delete(new_expression);
                compiler_diagnostic(880, ctx, ctx->current, 0U, "right type is not scalar for or expression");
                goto _CKL0;/*throw*/
            }
            new_expression->type = type_make_int_bool_like();
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

struct expression *logical_or_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = logical_and_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 31868))
        {
            struct expression * new_expression;
            unsigned char   right_evaluation_is_disabled;
            unsigned char   old_evaluation_is_disabled;

            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            new_expression->expression_type = 51;
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            right_evaluation_is_disabled = 0;
            if (object_has_constant_value(&new_expression->left->object))
            {
                if (object_to_bool(&new_expression->left->object))
                {
                    right_evaluation_is_disabled = 1;
                }
            }
            old_evaluation_is_disabled = ctx->evaluation_is_disabled;
            ctx->evaluation_is_disabled = right_evaluation_is_disabled;
            new_expression->right = logical_and_expression(ctx);
            ctx->evaluation_is_disabled = old_evaluation_is_disabled;
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            new_expression->last_token = new_expression->right->last_token;
            if (!ctx->evaluation_is_disabled)
            {
                if (object_has_constant_value(&new_expression->left->object))
                {
                    unsigned char   a;

                    a = object_to_bool(&new_expression->left->object);
                    if (a == 1)
                    {
                        new_expression->object = object_make_signed_int(1);
                    }
                    else
                    {
                        if (object_has_constant_value(&new_expression->right->object))
                        {
                            unsigned char   b;

                            b = object_to_bool(&new_expression->right->object);
                            new_expression->object = object_make_signed_int(a || b);
                        }
                    }
                }
            }
            if (!type_is_scalar(&new_expression->left->type))
            {
                expression_delete(new_expression);
                compiler_diagnostic(870, ctx, ctx->current, 0U, "left type is not scalar for or expression");
                goto _CKL0;/*throw*/
            }
            if (!type_is_scalar(&new_expression->right->type))
            {
                expression_delete(new_expression);
                compiler_diagnostic(880, ctx, ctx->current, 0U, "right type is not scalar for or expression");
                goto _CKL0;/*throw*/
            }
            new_expression->type = type_make_int_bool_like();
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

struct expression *conditional_expression(struct parser_ctx * ctx);

struct expression *assignment_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        p_expression_node = conditional_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        ;
        while (ctx->current != 0U && (ctx->current->type == 61 || ctx->current->type == 10813 || ctx->current->type == 12093 || ctx->current->type == 9533 || ctx->current->type == 11069 || ctx->current->type == 11581 || ctx->current->type == 3947581 || ctx->current->type == 4079165 || ctx->current->type == 9789 || ctx->current->type == 24125 || ctx->current->type == 31805))
        {
            struct token * op_token;
            struct expression * new_expression;
            struct marker  left_operand_marker;

            op_token = ctx->current;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            new_expression = calloc(1, 240U);
            if (new_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            new_expression->first_token = ctx->current;
            /*switch*/
            {
                register int _R50 = op_token->type;
                if (_R50 == 61) goto _CKL5; /*case 61*/
                if (_R50 == 10813) goto _CKL6; /*case 10813*/
                if (_R50 == 12093) goto _CKL7; /*case 12093*/
                if (_R50 == 9533) goto _CKL8; /*case 9533*/
                if (_R50 == 11069) goto _CKL9; /*case 11069*/
                if (_R50 == 11581) goto _CKL10; /*case 11581*/
                if (_R50 == 3947581) goto _CKL11; /*case 3947581*/
                if (_R50 == 4079165) goto _CKL12; /*case 4079165*/
                if (_R50 == 9789) goto _CKL13; /*case 9789*/
                if (_R50 == 24125) goto _CKL14; /*case 24125*/
                if (_R50 == 31805) goto _CKL15; /*case 31805*/
                goto _CKL16;/*default*/

                {
                    _CKL5:/*case 61*/ 
                    new_expression->expression_type = 53;
                    goto _CKL4; /*break*/

                    _CKL6:/*case 10813*/ 
                    new_expression->expression_type = 56;
                    goto _CKL4; /*break*/

                    _CKL7:/*case 12093*/ 
                    new_expression->expression_type = 57;
                    goto _CKL4; /*break*/

                    _CKL8:/*case 9533*/ 
                    new_expression->expression_type = 58;
                    goto _CKL4; /*break*/

                    _CKL9:/*case 11069*/ 
                    new_expression->expression_type = 54;
                    goto _CKL4; /*break*/

                    _CKL10:/*case 11581*/ 
                    new_expression->expression_type = 55;
                    goto _CKL4; /*break*/

                    _CKL11:/*case 3947581*/ 
                    new_expression->expression_type = 59;
                    goto _CKL4; /*break*/

                    _CKL12:/*case 4079165*/ 
                    new_expression->expression_type = 60;
                    goto _CKL4; /*break*/

                    _CKL13:/*case 9789*/ 
                    new_expression->expression_type = 61;
                    goto _CKL4; /*break*/

                    _CKL14:/*case 24125*/ 
                    new_expression->expression_type = 63;
                    goto _CKL4; /*break*/

                    _CKL15:/*case 31805*/ 
                    new_expression->expression_type = 62;
                    goto _CKL4; /*break*/

                    _CKL16: /*default*/ 
                    ;
                    goto _CKL4; /*break*/

                }
                _CKL4:;
            }
            new_expression->left = p_expression_node;
            p_expression_node = 0U;
            left_operand_marker.file = 0;
            left_operand_marker.line = 0;
            left_operand_marker.start_col = 0;
            left_operand_marker.end_col = 0;
            left_operand_marker.p_token_caret = 0;
            left_operand_marker.p_token_begin = new_expression->left->first_token;
            left_operand_marker.p_token_end = new_expression->left->last_token;
            if (type_is_function(&new_expression->left->type))
            {
                compiler_diagnostic(900, ctx, 0U, &left_operand_marker, "assignment of function");
            }
            else
            {
                if (type_is_array(&new_expression->left->type))
                {
                    if (new_expression->left->type.storage_class_specifier_flags & 2048)
                    {
                        compiler_diagnostic(42, ctx, 0U, &left_operand_marker, "assignment to array parameter");
                    }
                    else
                    {
                        compiler_diagnostic(910, ctx, 0U, &left_operand_marker, "assignment to expression with array type");
                    }
                }
            }
            if (type_is_const(&new_expression->left->type))
            {
                compiler_diagnostic(920, ctx, 0U, &left_operand_marker, "assignment of read-only object");
            }
            if (!expression_is_lvalue(new_expression->left))
            {
                compiler_diagnostic(1230, ctx, 0U, &left_operand_marker, "lvalue required as left operand of assignment");
            }
            new_expression->right = assignment_expression(ctx);
            if (new_expression->right == 0U)
            {
                expression_delete(new_expression);
                goto _CKL0;/*throw*/
            }
            if (op_token->type == 61)
            {
                check_assigment(ctx, &new_expression->left->type, new_expression->right, 2);
            }
            new_expression->last_token = new_expression->right->last_token;
            new_expression->type = type_dup(&new_expression->left->type);
            new_expression->type.storage_class_specifier_flags &= -8193;
            new_expression->type.storage_class_specifier_flags &= -16385;
            check_diferent_enuns(ctx, op_token, new_expression->left, new_expression->right, "assignment of different enums.");
            new_expression->left->is_assignment_expression = 1;
            if (new_expression->left->left)
            {
                new_expression->left->left->is_assignment_expression = 1;
            }
            p_expression_node = new_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

void argument_expression_list_push(struct argument_expression_list * list, struct argument_expression * pitem)
{
    if (list->head == 0U)
    {
        list->head = pitem;
    }
    else
    {
        ;
        ;
        list->tail->next = pitem;
    }
    list->tail = pitem;
}

void argument_expression_list_destroy(struct argument_expression_list * p)
{
    struct argument_expression * item;

    item = p->head;
    while (item)
    {
        struct argument_expression * next;

        next = item->next;
        item->next = 0U;
        argument_expression_delete(item);
        item = next;
    }
}

unsigned char  expression_is_malloc(struct expression * p)
{
    if (p->expression_type == 12 && p->left && p->left->declarator && p->left->declarator->name_opt)
    {
        if (strcmp(p->left->declarator->name_opt->lexeme, "malloc") == 0)
        {
            return 1;
        }
    }
    return 0;
}

unsigned char  expression_is_calloc(struct expression * p)
{
    if (p->expression_type == 12 && p->left && p->left->declarator && p->left->declarator->name_opt)
    {
        if (strcmp(p->left->declarator->name_opt->lexeme, "calloc") == 0)
        {
            return 1;
        }
    }
    return 0;
}

void compound_statement_delete(struct compound_statement * p);
void braced_initializer_delete(struct braced_initializer * p);

void expression_delete(struct expression * p)
{
    if (p)
    {
        expression_delete(p->condition_expr);
        compound_statement_delete(p->compound_statement);
        type_name_delete(p->type_name);
        expression_delete(p->right);
        expression_delete(p->left);
        braced_initializer_delete(p->braced_initializer);
        generic_selection_delete(p->generic_selection);
        type_destroy(&p->type);
        argument_expression_list_destroy(&p->argument_expression_list);
        free(p);
    }
}

struct expression *expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;

    p_expression_node = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_expression_node = assignment_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 44)
        {
            while (ctx->current->type == 44)
            {
                struct expression * p_expression_node_new;

                parser_match(ctx);
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    goto _CKL0;/*throw*/
                }
                p_expression_node_new = calloc(1, 240U);
                if (p_expression_node_new == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                p_expression_node_new->first_token = ctx->current;
                p_expression_node_new->expression_type = 64;
                p_expression_node_new->left = p_expression_node;
                p_expression_node = 0U;
                p_expression_node_new->right = expression(ctx);
                if (p_expression_node_new->right == 0U)
                {
                    expression_delete(p_expression_node_new);
                    goto _CKL0;/*throw*/
                }
                p_expression_node_new->left->last_token = p_expression_node_new->right->last_token;
                p_expression_node = p_expression_node_new;
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    goto _CKL0;/*throw*/
                }
            }
            type_destroy(&p_expression_node->type);
            p_expression_node->type = type_dup(&p_expression_node->right->type);
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    return p_expression_node;
}

unsigned char  is_first_of_conditional_expression(struct parser_ctx * ctx)
{
    return !!(is_first_of_unary_expression(ctx) || is_first_of_primary_expression(ctx));
}

unsigned char  expression_is_one(struct expression * expression)
{
    if (expression->expression_type == 8)
    {
        return !!((object_has_constant_value(&expression->object) && object_to_signed_int(&expression->object) == 1));
    }
    return 0;
}

unsigned char  expression_is_zero(struct expression * expression)
{
    if (expression->expression_type == 8)
    {
        return !!((object_has_constant_value(&expression->object) && object_to_signed_int(&expression->object) == 0));
    }
    return 0;
}

unsigned char  type_is_void_ptr(struct type * p_type);

unsigned char  expression_is_null_pointer_constant(struct expression * expression)
{
    if (type_is_integer(&expression->type) && object_has_constant_value(&expression->object) && object_to_signed_int(&expression->object) == 0)
    {
        return 1;
    }
    if (type_is_void_ptr(&expression->type) && object_has_constant_value(&expression->object) && object_to_signed_int(&expression->object) == 0)
    {
        return 1;
    }
    if (type_is_nullptr_t(&expression->type))
    {
        return 1;
    }
    return 0;
}

void type_swap(struct type * a, struct type * b);

struct expression *conditional_expression(struct parser_ctx * ctx)
{
    struct expression * p_expression_node;
    struct type  left_type;
    struct type  right_type;

    p_expression_node = 0U;
    _cake_zmem(&left_type, 68);
    _cake_zmem(&right_type, 68);
    if (1) /*try*/
    {
        p_expression_node = logical_or_expression(ctx);
        if (p_expression_node == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current && ctx->current->type == 63)
        {
            struct expression * p_conditional_expression;
            unsigned char   constant_expression_is_true;
            unsigned char   has_constant_expression;
            unsigned char   old_evaluation_is_disabled;
            struct expression * p_left;
            struct expression * p_right;

            p_conditional_expression = calloc(1, 240U);
            if (p_conditional_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_conditional_expression->first_token = ctx->current;
            p_conditional_expression->expression_type = 65;
            p_conditional_expression->condition_expr = p_expression_node;
            p_expression_node = 0U;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(p_conditional_expression);
                goto _CKL0;/*throw*/
            }
            constant_expression_is_true = 0;
            has_constant_expression = 0;
            if (object_has_constant_value(&p_conditional_expression->condition_expr->object))
            {
                has_constant_expression = 1;
                if (object_to_bool(&p_conditional_expression->condition_expr->object))
                {
                    constant_expression_is_true = 1;
                }
            }
            old_evaluation_is_disabled = ctx->evaluation_is_disabled;
            ctx->evaluation_is_disabled = !!(has_constant_expression && !constant_expression_is_true);
            p_left = expression(ctx);
            ctx->evaluation_is_disabled = old_evaluation_is_disabled;
            if (p_left == 0U)
            {
                expression_delete(p_conditional_expression);
                goto _CKL0;/*throw*/
            }
            p_conditional_expression->left = p_left;
            if (parser_match_tk(ctx, 58) != 0)
            {
                unexpected_end_of_file(ctx);
                expression_delete(p_conditional_expression);
                goto _CKL0;/*throw*/
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                expression_delete(p_conditional_expression);
                goto _CKL0;/*throw*/
            }
            ctx->evaluation_is_disabled = !!(has_constant_expression && constant_expression_is_true);
            p_right = conditional_expression(ctx);
            ctx->evaluation_is_disabled = old_evaluation_is_disabled;
            if (p_right == 0U)
            {
                expression_delete(p_conditional_expression);
                goto _CKL0;/*throw*/
            }
            p_conditional_expression->right = p_right;
            if (object_has_constant_value(&p_conditional_expression->condition_expr->object))
            {
                if (object_to_bool(&p_conditional_expression->condition_expr->object))
                {
                    p_conditional_expression->object = object_make_reference(&p_conditional_expression->left->object);
                }
                else
                {
                    p_conditional_expression->object = object_make_reference(&p_conditional_expression->right->object);
                }
            }
            if (expression_is_subjected_to_lvalue_conversion(p_conditional_expression->left))
            {
                left_type = type_lvalue_conversion(&p_conditional_expression->left->type, ctx->options.null_checks_enabled);
            }
            else
            {
                left_type = type_dup(&p_conditional_expression->left->type);
            }
            if (expression_is_subjected_to_lvalue_conversion(p_conditional_expression->right))
            {
                right_type = type_lvalue_conversion(&p_conditional_expression->right->type, ctx->options.null_checks_enabled);
            }
            else
            {
                right_type = type_dup(&p_conditional_expression->right->type);
            }
            if (!type_is_scalar(&p_conditional_expression->condition_expr->type))
            {
                compiler_diagnostic(940, ctx, ctx->current, 0U, "condition must have scalar type");
            }
            else
            {
                if (type_is_arithmetic(&left_type) && type_is_arithmetic(&right_type))
                {
                    type_destroy(&p_conditional_expression->type);
                    p_conditional_expression->type = type_common(&left_type, &right_type);
                }
                else
                {
                    if (type_is_struct_or_union(&left_type) && type_is_struct_or_union(&right_type))
                    {
                        if (!type_is_same(&left_type, &right_type, 1))
                        {
                            compiler_diagnostic(950, ctx, p_conditional_expression->condition_expr->first_token, 0U, "incompatible types");
                        }
                        type_swap(&p_conditional_expression->type, &right_type);
                    }
                    else
                    {
                        if (type_is_void(&left_type) && type_is_void(&right_type))
                        {
                            type_swap(&p_conditional_expression->type, &right_type);
                        }
                        else
                        {
                            if (type_is_nullptr_t(&left_type) && type_is_nullptr_t(&right_type))
                            {
                                type_swap(&p_conditional_expression->type, &right_type);
                            }
                            else
                            {
                                if (type_is_pointer(&left_type))
                                {
                                    if (expression_is_null_pointer_constant(p_conditional_expression->right) || type_is_nullptr_t(&right_type) || type_is_void_ptr(&right_type))
                                    {
                                        type_swap(&p_conditional_expression->type, &left_type);
                                    }
                                    else
                                    {
                                        if (type_is_pointer(&right_type))
                                        {
                                            if (type_is_nullptr_t(&left_type) || type_is_void_ptr(&left_type))
                                            {
                                                type_swap(&p_conditional_expression->type, &left_type);
                                            }
                                            else
                                            {
                                                if (!type_is_same(&left_type, &right_type, 0))
                                                {
                                                    compiler_diagnostic(950, ctx, ctx->current, 0U, "incompatible types");
                                                }
                                                else
                                                {
                                                    type_swap(&p_conditional_expression->type, &right_type);
                                                }
                                            }
                                        }
                                        else
                                        {
                                            compiler_diagnostic(950, ctx, p_conditional_expression->condition_expr->first_token, 0U, "incompatible types");
                                        }
                                    }
                                }
                                else
                                {
                                    if (type_is_pointer(&right_type))
                                    {
                                        if (expression_is_null_pointer_constant(p_conditional_expression->left) || type_is_nullptr_t(&left_type) || type_is_void_ptr(&left_type))
                                        {
                                            type_swap(&p_conditional_expression->type, &right_type);
                                        }
                                        else
                                        {
                                            if (type_is_pointer(&left_type))
                                            {
                                                if (type_is_nullptr_t(&left_type) || type_is_void_ptr(&left_type))
                                                {
                                                    type_swap(&p_conditional_expression->type, &right_type);
                                                }
                                                else
                                                {
                                                    if (!type_is_same(&left_type, &right_type, 0))
                                                    {
                                                        compiler_diagnostic(950, ctx, p_conditional_expression->condition_expr->first_token, 0U, "incompatible types");
                                                    }
                                                    else
                                                    {
                                                        type_swap(&p_conditional_expression->type, &right_type);
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                compiler_diagnostic(950, ctx, p_conditional_expression->condition_expr->first_token, 0U, "incompatible types");
                                            }
                                        }
                                    }
                                    else
                                    {
                                        compiler_diagnostic(950, ctx, p_conditional_expression->condition_expr->first_token, 0U, "incompatible types??");
                                        ;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            p_expression_node = p_conditional_expression;
        }
    }
    else _CKL0: /*catch*/ 
    {
        expression_delete(p_expression_node);
        p_expression_node = 0U;
    }
    type_destroy(&left_type);
    type_destroy(&right_type);
    return p_expression_node;
}

struct expression *constant_expression(struct parser_ctx * ctx, unsigned char   show_error_if_not_constant)
{
    struct expression * p_expression;

    p_expression = conditional_expression(ctx);
    if (show_error_if_not_constant && p_expression && !object_has_constant_value(&p_expression->object))
    {
        compiler_diagnostic(960, ctx, ctx->current, 0U, "expected constant expression");
    }
    return p_expression;
}

unsigned char  expression_get_variables(struct expression * expr, int n, struct object *variables[])
{
    int count;

    count = 0;
    /*switch*/
    {
        register int _R51 = expr->expression_type;
        if (_R51 == 0) goto _CKL1; /*case 0*/
        if (_R51 == 1) goto _CKL2; /*case 1*/
        if (_R51 == 2) goto _CKL3; /*case 2*/
        if (_R51 == 3) goto _CKL6; /*case 3*/
        if (_R51 == 4) goto _CKL7; /*case 4*/
        if (_R51 == 5) goto _CKL8; /*case 5*/
        if (_R51 == 6) goto _CKL9; /*case 6*/
        if (_R51 == 7) goto _CKL10; /*case 7*/
        if (_R51 == 8) goto _CKL11; /*case 8*/
        if (_R51 == 9) goto _CKL12; /*case 9*/
        if (_R51 == 10) goto _CKL13; /*case 10*/
        if (_R51 == 11) goto _CKL14; /*case 11*/
        if (_R51 == 12) goto _CKL15; /*case 12*/
        if (_R51 == 13) goto _CKL16; /*case 13*/
        if (_R51 == 14) goto _CKL17; /*case 14*/
        if (_R51 == 15) goto _CKL18; /*case 15*/
        if (_R51 == 16) goto _CKL19; /*case 16*/
        if (_R51 == 17) goto _CKL20; /*case 17*/
        if (_R51 == 18) goto _CKL21; /*case 18*/
        if (_R51 == 19) goto _CKL22; /*case 19*/
        if (_R51 == 20) goto _CKL23; /*case 20*/
        if (_R51 == 21) goto _CKL24; /*case 21*/
        if (_R51 == 22) goto _CKL25; /*case 22*/
        if (_R51 == 23) goto _CKL26; /*case 23*/
        if (_R51 == 24) goto _CKL27; /*case 24*/
        if (_R51 == 25) goto _CKL28; /*case 25*/
        if (_R51 == 26) goto _CKL29; /*case 26*/
        if (_R51 == 27) goto _CKL30; /*case 27*/
        if (_R51 == 28) goto _CKL31; /*case 28*/
        if (_R51 == 29) goto _CKL32; /*case 29*/
        if (_R51 == 30) goto _CKL33; /*case 30*/
        if (_R51 == 31) goto _CKL34; /*case 31*/
        if (_R51 == 32) goto _CKL35; /*case 32*/
        if (_R51 == 33) goto _CKL36; /*case 33*/
        if (_R51 == 34) goto _CKL37; /*case 34*/
        if (_R51 == 35) goto _CKL38; /*case 35*/
        if (_R51 == 36) goto _CKL39; /*case 36*/
        if (_R51 == 37) goto _CKL40; /*case 37*/
        if (_R51 == 38) goto _CKL41; /*case 38*/
        if (_R51 == 39) goto _CKL42; /*case 39*/
        if (_R51 == 40) goto _CKL43; /*case 40*/
        if (_R51 == 41) goto _CKL44; /*case 41*/
        if (_R51 == 42) goto _CKL45; /*case 42*/
        if (_R51 == 43) goto _CKL46; /*case 43*/
        if (_R51 == 44) goto _CKL47; /*case 44*/
        if (_R51 == 45) goto _CKL48; /*case 45*/
        if (_R51 == 46) goto _CKL49; /*case 46*/
        if (_R51 == 47) goto _CKL50; /*case 47*/
        if (_R51 == 48) goto _CKL51; /*case 48*/
        if (_R51 == 49) goto _CKL52; /*case 49*/
        if (_R51 == 50) goto _CKL53; /*case 50*/
        if (_R51 == 51) goto _CKL54; /*case 51*/
        if (_R51 == 52) goto _CKL55; /*case 52*/
        if (_R51 == 53) goto _CKL56; /*case 53*/
        if (_R51 == 54) goto _CKL57; /*case 54*/
        if (_R51 == 55) goto _CKL58; /*case 55*/
        if (_R51 == 56) goto _CKL59; /*case 56*/
        if (_R51 == 57) goto _CKL60; /*case 57*/
        if (_R51 == 58) goto _CKL61; /*case 58*/
        if (_R51 == 59) goto _CKL62; /*case 59*/
        if (_R51 == 60) goto _CKL63; /*case 60*/
        if (_R51 == 61) goto _CKL64; /*case 61*/
        if (_R51 == 62) goto _CKL65; /*case 62*/
        if (_R51 == 63) goto _CKL66; /*case 63*/
        if (_R51 == 64) goto _CKL67; /*case 64*/
        if (_R51 == 65) goto _CKL68; /*case 65*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            goto _CKL0; /*break*/

            _CKL2:/*case 1*/ 
            goto _CKL0; /*break*/

            _CKL3:/*case 2*/ 
            if (!object_has_constant_value(&expr->object))
            {
                if (count < n)
                {
                    variables[count] = object_get_non_const_referenced(&expr->object);
                    count++;
                }
            }
            goto _CKL0; /*break*/

            _CKL6:/*case 3*/ 
            goto _CKL0; /*break*/

            _CKL7:/*case 4*/ 
            goto _CKL0; /*break*/

            _CKL8:/*case 5*/ 
            goto _CKL0; /*break*/

            _CKL9:/*case 6*/ 
            goto _CKL0; /*break*/

            _CKL10:/*case 7*/ 
            goto _CKL0; /*break*/

            _CKL11:/*case 8*/ 
            goto _CKL0; /*break*/

            _CKL12:/*case 9*/ 
            count += expression_get_variables(expr->right, n, variables);
            goto _CKL0; /*break*/

            _CKL13:/*case 10*/ 
            goto _CKL0; /*break*/

            _CKL14:/*case 11*/ 
            goto _CKL0; /*break*/

            _CKL15:/*case 12*/ 
            goto _CKL0; /*break*/

            _CKL16:/*case 13*/ 
            goto _CKL0; /*break*/

            _CKL17:/*case 14*/ 
            goto _CKL0; /*break*/

            _CKL18:/*case 15*/ 
            goto _CKL0; /*break*/

            _CKL19:/*case 16*/ 
            goto _CKL0; /*break*/

            _CKL20:/*case 17*/ 
            goto _CKL0; /*break*/

            _CKL21:/*case 18*/ 
            goto _CKL0; /*break*/

            _CKL22:/*case 19*/ 
            goto _CKL0; /*break*/

            _CKL23:/*case 20*/ 
            goto _CKL0; /*break*/

            _CKL24:/*case 21*/ 
            goto _CKL0; /*break*/

            _CKL25:/*case 22*/ 
            goto _CKL0; /*break*/

            _CKL26:/*case 23*/ 
            goto _CKL0; /*break*/

            _CKL27:/*case 24*/ 
            goto _CKL0; /*break*/

            _CKL28:/*case 25*/ 
            goto _CKL0; /*break*/

            _CKL29:/*case 26*/ 
            goto _CKL0; /*break*/

            _CKL30:/*case 27*/ 
            goto _CKL0; /*break*/

            _CKL31:/*case 28*/ 
            goto _CKL0; /*break*/

            _CKL32:/*case 29*/ 
            goto _CKL0; /*break*/

            _CKL33:/*case 30*/ 
            goto _CKL0; /*break*/

            _CKL34:/*case 31*/ 
            goto _CKL0; /*break*/

            _CKL35:/*case 32*/ 
            goto _CKL0; /*break*/

            _CKL36:/*case 33*/ 
            goto _CKL0; /*break*/

            _CKL37:/*case 34*/ 
            goto _CKL0; /*break*/

            _CKL38:/*case 35*/ 
            _CKL39:/*case 36*/ 
            _CKL40:/*case 37*/ 
            count += expression_get_variables(expr->left, n, variables);
            count += expression_get_variables(expr->right, n, variables);
            goto _CKL0; /*break*/

            _CKL41:/*case 38*/ 
            _CKL42:/*case 39*/ 
            count += expression_get_variables(expr->left, n, variables);
            count += expression_get_variables(expr->right, n, variables);
            goto _CKL0; /*break*/

            _CKL43:/*case 40*/ 
            _CKL44:/*case 41*/ 
            _CKL45:/*case 42*/ 
            _CKL46:/*case 43*/ 
            _CKL47:/*case 44*/ 
            _CKL48:/*case 45*/ 
            _CKL49:/*case 46*/ 
            _CKL50:/*case 47*/ 
            count += expression_get_variables(expr->left, n, variables);
            count += expression_get_variables(expr->right, n, variables);
            goto _CKL0; /*break*/

            _CKL51:/*case 48*/ 
            goto _CKL0; /*break*/

            _CKL52:/*case 49*/ 
            goto _CKL0; /*break*/

            _CKL53:/*case 50*/ 
            goto _CKL0; /*break*/

            _CKL54:/*case 51*/ 
            _CKL55:/*case 52*/ 
            count += expression_get_variables(expr->left, n, variables);
            count += expression_get_variables(expr->right, n, variables);
            goto _CKL0; /*break*/

            _CKL56:/*case 53*/ 
            goto _CKL0; /*break*/

            _CKL57:/*case 54*/ 
            goto _CKL0; /*break*/

            _CKL58:/*case 55*/ 
            goto _CKL0; /*break*/

            _CKL59:/*case 56*/ 
            goto _CKL0; /*break*/

            _CKL60:/*case 57*/ 
            goto _CKL0; /*break*/

            _CKL61:/*case 58*/ 
            goto _CKL0; /*break*/

            _CKL62:/*case 59*/ 
            goto _CKL0; /*break*/

            _CKL63:/*case 60*/ 
            goto _CKL0; /*break*/

            _CKL64:/*case 61*/ 
            goto _CKL0; /*break*/

            _CKL65:/*case 62*/ 
            goto _CKL0; /*break*/

            _CKL66:/*case 63*/ 
            goto _CKL0; /*break*/

            _CKL67:/*case 64*/ 
            goto _CKL0; /*break*/

            _CKL68:/*case 65*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return !!(count);
}

unsigned char  expression_is_lvalue(struct expression * expr)
{
    /*switch*/
    {
        register int _R52 = expr->expression_type;
        if (_R52 == 2) goto _CKL1; /*case 2*/
        if (_R52 == 4) goto _CKL2; /*case 4*/
        if (_R52 == 3) goto _CKL3; /*case 3*/
        if (_R52 == 13) goto _CKL4; /*case 13*/
        if (_R52 == 15) goto _CKL5; /*case 15*/
        if (_R52 == 11) goto _CKL6; /*case 11*/
        if (_R52 == 32) goto _CKL7; /*case 32*/
        goto _CKL8;/*default*/

        {
            _CKL1:/*case 2*/ 
            _CKL2:/*case 4*/ 
            _CKL3:/*case 3*/ 
            _CKL4:/*case 13*/ 
            _CKL5:/*case 15*/ 
            _CKL6:/*case 11*/ 
            _CKL7:/*case 32*/ 
            return 1;
            _CKL8: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    if (expr->expression_type == 9 && expr->right)
    {
        return expression_is_lvalue(expr->right);
    }
    else
    {
        if (expr->expression_type == 14 && expr->left)
        {
            return expression_is_lvalue(expr->left);
        }
    }
    return 0;
}

unsigned char  expression_is_subjected_to_lvalue_conversion(struct expression * expression)
{
    /*switch*/
    {
        register int _R53 = expression->expression_type;
        if (_R53 == 33) goto _CKL1; /*case 33*/
        if (_R53 == 26) goto _CKL2; /*case 26*/
        if (_R53 == 27) goto _CKL3; /*case 27*/
        if (_R53 == 16) goto _CKL4; /*case 16*/
        if (_R53 == 17) goto _CKL5; /*case 17*/
        goto _CKL6;/*default*/

        {
            _CKL1:/*case 33*/ 
            _CKL2:/*case 26*/ 
            _CKL3:/*case 27*/ 
            _CKL4:/*case 16*/ 
            _CKL5:/*case 17*/ 
            return 0;
            _CKL6: /*default*/ 
            if (expression->type.storage_class_specifier_flags & 2048)
            {
                return 1;
            }
        }
        _CKL0:;
    }
    return 1;
}

void check_comparison(struct parser_ctx * ctx, struct expression * p_a_expression, struct expression * p_b_expression, struct token * op_token)
{
    struct type * p_a_type;
    struct type * p_b_type;

    p_a_type = &p_a_expression->type;
    p_b_type = &p_b_expression->type;
    if (type_is_pointer(p_a_type) && type_is_integer(p_b_type))
    {
        if (expression_is_zero(p_b_expression))
        {
        }
        else
        {
            compiler_diagnostic(3, ctx, op_token, 0U, "comparison between pointer and integer");
        }
    }
    check_diferent_enuns(ctx, op_token, p_a_expression, p_b_expression, "comparing different enums.");
}

unsigned char  type_is_owner_or_pointer_to_dtor(struct type * p_type);
unsigned char  type_is_pointed_dtor(struct type * p_type);
unsigned char  type_is_opt(struct type * p_type, unsigned char   nullable_enabled);

void check_assigment(struct parser_ctx * ctx, struct type * p_a_type, struct expression * p_b_expression, int assignment_type)
{
    struct type * p_b_type;
    unsigned char   is_null_pointer_constant;
    struct type  b_type_lvalue;

    p_b_type = &p_b_expression->type;
    is_null_pointer_constant = expression_is_null_pointer_constant(p_b_expression);
    if (type_is_pointer(p_a_type))
    {
        if (!type_is_nullptr_t(p_b_type) && !type_is_pointer_or_array(p_b_type) && !type_is_function(p_b_type))
        {
            if (is_null_pointer_constant)
            {
                if (p_b_expression->expression_type == 8)
                {
                    compiler_diagnostic(10, ctx, p_b_expression->first_token, 0U, "use NULL instead of 0");
                }
                else
                {
                    compiler_diagnostic(45, ctx, p_b_expression->first_token, 0U, "unusual expression/type used as null pointer constant");
                }
            }
            else
            {
                compiler_diagnostic(1340, ctx, p_b_expression->first_token, 0U, "non-pointer to pointer");
            }
        }
    }
    if (type_is_bool(p_a_type) && type_is_nullptr_t(p_b_type))
    {
        struct marker  marker;

        marker.file = 0;
        marker.line = 0;
        marker.start_col = 0;
        marker.end_col = 0;
        marker.p_token_caret = 0;
        marker.p_token_begin = p_b_expression->first_token;
        marker.p_token_end = p_b_expression->first_token;
        compiler_diagnostic(48, ctx, 0U, &marker, "implicit conversion of nullptr constant to 'bool'");
    }
    _cake_zmem(&b_type_lvalue, 68);
    if (expression_is_subjected_to_lvalue_conversion(p_b_expression))
    {
        b_type_lvalue = type_lvalue_conversion(p_b_type, ctx->options.null_checks_enabled);
    }
    else
    {
        b_type_lvalue = type_dup(p_b_type);
    }
    if (type_is_owner(p_a_type) && !type_is_owner(&p_b_expression->type))
    {
        if (!is_null_pointer_constant)
        {
            compiler_diagnostic(24, ctx, p_b_expression->first_token, 0U, "cannot assign a non-owner to owner");
            type_destroy(&b_type_lvalue);
            return;
        }
    }
    if (!type_is_owner(p_a_type) && type_is_owner_or_pointer_to_dtor(&p_b_expression->type))
    {
        if (p_b_expression->type.storage_class_specifier_flags & 8192)
        {
            compiler_diagnostic(22, ctx, p_b_expression->first_token, 0U, "cannot assign a temporary owner to non-owner object.");
            type_destroy(&b_type_lvalue);
            return;
        }
    }
    if (assignment_type == 0)
    {
        if (!type_is_owner(p_a_type) && type_is_owner_or_pointer_to_dtor(&p_b_expression->type))
        {
            if (p_b_expression->type.storage_class_specifier_flags & 4096)
            {
                compiler_diagnostic(1280, ctx, p_b_expression->first_token, 0U, "cannot return a automatic storage duration _Owner to non-owner");
                type_destroy(&b_type_lvalue);
                return;
            }
        }
    }
    if (type_is_pointed_dtor(p_a_type) && type_is_pointer(p_a_type))
    {
        if (type_is_owner(p_b_type))
        {
        }
        else
        {
            if (!p_b_type->address_of)
            {
                compiler_diagnostic(18, ctx, p_b_expression->first_token, 0U, "source expression of _Dtor must be addressof");
            }
        }
    }
    if (type_is_pointer(p_a_type) && !type_is_opt(p_a_type, ctx->options.null_checks_enabled) && is_null_pointer_constant)
    {
        compiler_diagnostic(34, ctx, p_b_expression->first_token, 0U, "cannot convert a null pointer constant to non-nullable pointer");
        type_destroy(&b_type_lvalue);
        return;
    }
    if (type_is_enum(p_b_type) && type_is_enum(p_a_type))
    {
        if (!type_is_same(p_b_type, p_a_type, 0))
        {
            compiler_diagnostic(39, ctx, p_b_expression->first_token, 0U, " incompatible types ");
        }
        type_destroy(&b_type_lvalue);
        return;
    }
    if (type_is_arithmetic(p_b_type) && type_is_arithmetic(p_a_type))
    {
        type_destroy(&b_type_lvalue);
        return;
    }
    if (is_null_pointer_constant && type_is_pointer(p_a_type))
    {
        type_destroy(&b_type_lvalue);
        return;
    }
    if (is_null_pointer_constant && type_is_array(p_a_type))
    {
        compiler_diagnostic(27, ctx, p_b_expression->first_token, 0U, " passing null as array");
        type_destroy(&b_type_lvalue);
        return;
    }
    if (type_is_pointer_or_array(p_b_type) && type_is_pointer_or_array(p_a_type))
    {
        struct type  a_type_lvalue;

        if (type_is_void_ptr(p_b_type))
        {
            type_destroy(&b_type_lvalue);
            return;
        }
        if (type_is_void_ptr(p_a_type))
        {
            type_destroy(&b_type_lvalue);
            return;
        }
        _cake_zmem(&a_type_lvalue, 68);
        if (type_is_array(p_a_type))
        {
            if (assignment_type == 1)
            {
                unsigned int parameter_array_size;

                parameter_array_size = p_a_type->num_of_elements;
                if (type_is_array(p_b_type))
                {
                    unsigned int argument_array_size;

                    argument_array_size = p_b_type->num_of_elements;
                    if (parameter_array_size != 0 && argument_array_size < parameter_array_size)
                    {
                        compiler_diagnostic(1130, ctx, p_b_expression->first_token, 0U, " argument of size [%d] is smaller than parameter of size [%d]", argument_array_size, parameter_array_size);
                    }
                }
                else
                {
                    if (is_null_pointer_constant || type_is_nullptr_t(p_b_type))
                    {
                        compiler_diagnostic(38, ctx, p_b_expression->first_token, 0U, " passing null as array");
                    }
                }
            }
            a_type_lvalue = type_lvalue_conversion(p_a_type, ctx->options.null_checks_enabled);
        }
        else
        {
            a_type_lvalue = type_dup(p_a_type);
        }
        if (!type_is_same(&b_type_lvalue, &a_type_lvalue, 0))
        {
            type_print(&b_type_lvalue);
            type_print(&a_type_lvalue);
            compiler_diagnostic(53, ctx, p_b_expression->first_token, 0U, " incompatible types");
        }
        if (assignment_type == 1)
        {
            if (type_is_pointer(&b_type_lvalue) && type_is_pointer(&a_type_lvalue))
            {
                struct type  b_pointed_type_lvalue;
                struct type  a_lvalue_pointed_type;

                b_pointed_type_lvalue = type_remove_pointer(&b_type_lvalue);
                a_lvalue_pointed_type = type_remove_pointer(&a_type_lvalue);
                if (type_is_const(&b_pointed_type_lvalue) && !type_is_const(&a_lvalue_pointed_type))
                {
                    compiler_diagnostic(14, ctx, p_b_expression->first_token, 0U, " discarding const at argument ");
                }
                type_destroy(&b_pointed_type_lvalue);
                type_destroy(&a_lvalue_pointed_type);
            }
        }
        else
        {
            if (type_is_pointer(p_a_type) && type_is_pointer(&b_type_lvalue))
            {
                struct type  b_pointed_type;
                struct type  a_pointed_type;

                b_pointed_type = type_remove_pointer(&b_type_lvalue);
                a_pointed_type = type_remove_pointer(p_a_type);
                if (type_is_const(&b_pointed_type) && !type_is_const(&a_pointed_type))
                {
                    compiler_diagnostic(14, ctx, p_b_expression->first_token, 0U, " discarding const");
                }
                type_destroy(&b_pointed_type);
                type_destroy(&a_pointed_type);
            }
        }
        type_destroy(&a_type_lvalue);
    }
    if (!type_is_same(p_a_type, &b_type_lvalue, 0))
    {
    }
    type_destroy(&b_type_lvalue);
}

struct object expression_eval(struct expression * p_expression)
{
    struct object  result;

    _cake_zmem(&result, 104);
    /*switch*/
    {
        register int _R54 = p_expression->expression_type;
        if (_R54 == 0) goto _CKL1; /*case 0*/
        if (_R54 == 1) goto _CKL2; /*case 1*/
        if (_R54 == 2) goto _CKL3; /*case 2*/
        if (_R54 == 3) goto _CKL4; /*case 3*/
        if (_R54 == 4) goto _CKL5; /*case 4*/
        if (_R54 == 5) goto _CKL6; /*case 5*/
        if (_R54 == 6) goto _CKL7; /*case 6*/
        if (_R54 == 7) goto _CKL8; /*case 7*/
        if (_R54 == 8) goto _CKL9; /*case 8*/
        if (_R54 == 9) goto _CKL10; /*case 9*/
        if (_R54 == 10) goto _CKL11; /*case 10*/
        if (_R54 == 11) goto _CKL12; /*case 11*/
        if (_R54 == 12) goto _CKL13; /*case 12*/
        if (_R54 == 13) goto _CKL14; /*case 13*/
        if (_R54 == 14) goto _CKL15; /*case 14*/
        if (_R54 == 15) goto _CKL16; /*case 15*/
        if (_R54 == 16) goto _CKL17; /*case 16*/
        if (_R54 == 17) goto _CKL18; /*case 17*/
        if (_R54 == 18) goto _CKL19; /*case 18*/
        if (_R54 == 19) goto _CKL20; /*case 19*/
        if (_R54 == 20) goto _CKL21; /*case 20*/
        if (_R54 == 21) goto _CKL22; /*case 21*/
        if (_R54 == 22) goto _CKL23; /*case 22*/
        if (_R54 == 23) goto _CKL24; /*case 23*/
        if (_R54 == 24) goto _CKL25; /*case 24*/
        if (_R54 == 25) goto _CKL26; /*case 25*/
        if (_R54 == 26) goto _CKL27; /*case 26*/
        if (_R54 == 27) goto _CKL28; /*case 27*/
        if (_R54 == 28) goto _CKL29; /*case 28*/
        if (_R54 == 29) goto _CKL30; /*case 29*/
        if (_R54 == 30) goto _CKL31; /*case 30*/
        if (_R54 == 31) goto _CKL32; /*case 31*/
        if (_R54 == 32) goto _CKL33; /*case 32*/
        if (_R54 == 33) goto _CKL34; /*case 33*/
        if (_R54 == 34) goto _CKL35; /*case 34*/
        if (_R54 == 35) goto _CKL36; /*case 35*/
        if (_R54 == 36) goto _CKL37; /*case 36*/
        if (_R54 == 37) goto _CKL38; /*case 37*/
        if (_R54 == 38) goto _CKL39; /*case 38*/
        if (_R54 == 39) goto _CKL42; /*case 39*/
        if (_R54 == 40) goto _CKL45; /*case 40*/
        if (_R54 == 41) goto _CKL46; /*case 41*/
        if (_R54 == 42) goto _CKL47; /*case 42*/
        if (_R54 == 43) goto _CKL48; /*case 43*/
        if (_R54 == 44) goto _CKL49; /*case 44*/
        if (_R54 == 45) goto _CKL50; /*case 45*/
        if (_R54 == 46) goto _CKL51; /*case 46*/
        if (_R54 == 47) goto _CKL53; /*case 47*/
        if (_R54 == 48) goto _CKL55; /*case 48*/
        if (_R54 == 49) goto _CKL56; /*case 49*/
        if (_R54 == 50) goto _CKL57; /*case 50*/
        if (_R54 == 51) goto _CKL58; /*case 51*/
        if (_R54 == 52) goto _CKL63; /*case 52*/
        if (_R54 == 53) goto _CKL64; /*case 53*/
        if (_R54 == 54) goto _CKL65; /*case 54*/
        if (_R54 == 55) goto _CKL66; /*case 55*/
        if (_R54 == 56) goto _CKL67; /*case 56*/
        if (_R54 == 57) goto _CKL68; /*case 57*/
        if (_R54 == 58) goto _CKL69; /*case 58*/
        if (_R54 == 59) goto _CKL70; /*case 59*/
        if (_R54 == 60) goto _CKL71; /*case 60*/
        if (_R54 == 61) goto _CKL72; /*case 61*/
        if (_R54 == 62) goto _CKL73; /*case 62*/
        if (_R54 == 63) goto _CKL74; /*case 63*/
        if (_R54 == 64) goto _CKL75; /*case 64*/
        if (_R54 == 65) goto _CKL76; /*case 65*/
        goto _CKL0;

        {
            _CKL1:/*case 0*/ 
            goto _CKL0; /*break*/

            _CKL2:/*case 1*/ 
            _CKL3:/*case 2*/ 
            result = object_dup(&p_expression->object);
            goto _CKL0; /*break*/

            _CKL4:/*case 3*/ 
            goto _CKL0; /*break*/

            _CKL5:/*case 4*/ 
            goto _CKL0; /*break*/

            _CKL6:/*case 5*/ 
            _CKL7:/*case 6*/ 
            result = object_dup(&p_expression->object);
            goto _CKL0; /*break*/

            _CKL8:/*case 7*/ 
            goto _CKL0; /*break*/

            _CKL9:/*case 8*/ 
            result = object_dup(&p_expression->object);
            goto _CKL0; /*break*/

            _CKL10:/*case 9*/ 
            result = expression_eval(p_expression->right);
            goto _CKL0; /*break*/

            _CKL11:/*case 10*/ 
            goto _CKL0; /*break*/

            _CKL12:/*case 11*/ 
            goto _CKL0; /*break*/

            _CKL13:/*case 12*/ 
            goto _CKL0; /*break*/

            _CKL14:/*case 13*/ 
            goto _CKL0; /*break*/

            _CKL15:/*case 14*/ 
            goto _CKL0; /*break*/

            _CKL16:/*case 15*/ 
            goto _CKL0; /*break*/

            _CKL17:/*case 16*/ 
            goto _CKL0; /*break*/

            _CKL18:/*case 17*/ 
            goto _CKL0; /*break*/

            _CKL19:/*case 18*/ 
            goto _CKL0; /*break*/

            _CKL20:/*case 19*/ 
            goto _CKL0; /*break*/

            _CKL21:/*case 20*/ 
            goto _CKL0; /*break*/

            _CKL22:/*case 21*/ 
            goto _CKL0; /*break*/

            _CKL23:/*case 22*/ 
            goto _CKL0; /*break*/

            _CKL24:/*case 23*/ 
            goto _CKL0; /*break*/

            _CKL25:/*case 24*/ 
            goto _CKL0; /*break*/

            _CKL26:/*case 25*/ 
            goto _CKL0; /*break*/

            _CKL27:/*case 26*/ 
            goto _CKL0; /*break*/

            _CKL28:/*case 27*/ 
            goto _CKL0; /*break*/

            _CKL29:/*case 28*/ 
            goto _CKL0; /*break*/

            _CKL30:/*case 29*/ 
            goto _CKL0; /*break*/

            _CKL31:/*case 30*/ 
            goto _CKL0; /*break*/

            _CKL32:/*case 31*/ 
            goto _CKL0; /*break*/

            _CKL33:/*case 32*/ 
            goto _CKL0; /*break*/

            _CKL34:/*case 33*/ 
            goto _CKL0; /*break*/

            _CKL35:/*case 34*/ 
            goto _CKL0; /*break*/

            _CKL36:/*case 35*/ 
            goto _CKL0; /*break*/

            _CKL37:/*case 36*/ 
            goto _CKL0; /*break*/

            _CKL38:/*case 37*/ 
            goto _CKL0; /*break*/

            _CKL39:/*case 38*/ 
            {
                struct object  a;

                a = expression_eval(p_expression->left);
                if (object_has_constant_value(&a))
                {
                    struct object  b;

                    b = expression_eval(p_expression->right);
                    if (object_has_constant_value(&b))
                    {
                        result = object_add(&a, &b);
                    }
                }
            }
            goto _CKL0; /*break*/

            _CKL42:/*case 39*/ 
            {
                struct object  a;

                a = expression_eval(p_expression->left);
                if (object_has_constant_value(&a))
                {
                    struct object  b;

                    b = expression_eval(p_expression->right);
                    if (object_has_constant_value(&b))
                    {
                        result = object_sub(&a, &b);
                    }
                }
            }
            goto _CKL0; /*break*/

            _CKL45:/*case 40*/ 
            goto _CKL0; /*break*/

            _CKL46:/*case 41*/ 
            goto _CKL0; /*break*/

            _CKL47:/*case 42*/ 
            goto _CKL0; /*break*/

            _CKL48:/*case 43*/ 
            goto _CKL0; /*break*/

            _CKL49:/*case 44*/ 
            goto _CKL0; /*break*/

            _CKL50:/*case 45*/ 
            goto _CKL0; /*break*/

            _CKL51:/*case 46*/ 
            if (object_equal(&p_expression->left->object, &p_expression->right->object))
            {
                result = object_make_signed_int(1);
            }
            else
            {
                result = object_make_signed_int(0);
            }
            goto _CKL0; /*break*/

            _CKL53:/*case 47*/ 
            if (object_not_equal(&p_expression->left->object, &p_expression->right->object))
            {
                result = object_make_signed_int(1);
            }
            else
            {
                result = object_make_signed_int(0);
            }
            goto _CKL0; /*break*/

            _CKL55:/*case 48*/ 
            goto _CKL0; /*break*/

            _CKL56:/*case 49*/ 
            goto _CKL0; /*break*/

            _CKL57:/*case 50*/ 
            goto _CKL0; /*break*/

            _CKL58:/*case 51*/ 
            {
                struct object  a;

                a = expression_eval(p_expression->left);
                if (object_has_constant_value(&a))
                {
                    unsigned char   r1;

                    r1 = object_to_bool(&a);
                    if (r1)
                    {
                        result = object_make_signed_int(1);
                    }
                    else
                    {
                        struct object  b;

                        b = expression_eval(p_expression->right);
                        if (object_has_constant_value(&b))
                        {
                            unsigned char   r2;

                            r2 = object_to_bool(&b);
                            if (r2)
                            {
                                result = object_make_signed_int(r2);
                            }
                        }
                    }
                }
            }
            goto _CKL0; /*break*/

            _CKL63:/*case 52*/ 
            goto _CKL0; /*break*/

            _CKL64:/*case 53*/ 
            goto _CKL0; /*break*/

            _CKL65:/*case 54*/ 
            goto _CKL0; /*break*/

            _CKL66:/*case 55*/ 
            goto _CKL0; /*break*/

            _CKL67:/*case 56*/ 
            goto _CKL0; /*break*/

            _CKL68:/*case 57*/ 
            goto _CKL0; /*break*/

            _CKL69:/*case 58*/ 
            goto _CKL0; /*break*/

            _CKL70:/*case 59*/ 
            goto _CKL0; /*break*/

            _CKL71:/*case 60*/ 
            goto _CKL0; /*break*/

            _CKL72:/*case 61*/ 
            goto _CKL0; /*break*/

            _CKL73:/*case 62*/ 
            goto _CKL0; /*break*/

            _CKL74:/*case 63*/ 
            goto _CKL0; /*break*/

            _CKL75:/*case 64*/ 
            goto _CKL0; /*break*/

            _CKL76:/*case 65*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return result;
}

static int ppnumber_to_longlong(struct preprocessor_ctx * ctx, struct token * token, long long * result)
{
    int c;
    char buffer[260];
    char * s;
    char errormsg[100];
    char suffix[4];
    int type;
    struct object  cv;

    c = 0;
    _cake_zmem(&buffer, 260);
    s = token->lexeme;
    while (*s)
    {
        if (*s != 39)
        {
            buffer[c] = *s;
            c++;
        }
        s++;
    }
    _cake_zmem(&suffix, 4);
    type = parse_number(token->lexeme, suffix, errormsg);
    if (type == 0)
    {
        preprocessor_diagnostic(1380, ctx, token, "%s", errormsg);
        return 0;
    }
    _cake_zmem(&cv, 104);
    /*switch*/
    {
        register int _R55 = type;
        if (_R55 == 136) goto _CKL3; /*case 136*/
        if (_R55 == 137) goto _CKL4; /*case 137*/
        if (_R55 == 138) goto _CKL5; /*case 138*/
        if (_R55 == 139) goto _CKL6; /*case 139*/
        if (_R55 == 140) goto _CKL20; /*case 140*/
        if (_R55 == 141) goto _CKL21; /*case 141*/
        goto _CKL22;/*default*/

        {
            _CKL3:/*case 136*/ 
            _CKL4:/*case 137*/ 
            _CKL5:/*case 138*/ 
            _CKL6:/*case 139*/ 
            {
                unsigned long long value;

                value = 0;
                /*switch*/
                {
                    register int _R56 = type;
                    if (_R56 == 136) goto _CKL8; /*case 136*/
                    if (_R56 == 137) goto _CKL9; /*case 137*/
                    if (_R56 == 138) goto _CKL10; /*case 138*/
                    if (_R56 == 139) goto _CKL11; /*case 139*/
                    goto _CKL12;/*default*/

                    {
                        _CKL8:/*case 136*/ 
                        value = strtoull(buffer, 0U, 10);
                        goto _CKL7; /*break*/

                        _CKL9:/*case 137*/ 
                        value = strtoull(buffer + 1, 0U, 8);
                        goto _CKL7; /*break*/

                        _CKL10:/*case 138*/ 
                        value = strtoull(buffer + 2, 0U, 16);
                        goto _CKL7; /*break*/

                        _CKL11:/*case 139*/ 
                        value = strtoull(buffer + 2, 0U, 2);
                        goto _CKL7; /*break*/

                        _CKL12: /*default*/ 
                        goto _CKL7; /*break*/

                    }
                    _CKL7:;
                }
                if (value == 18446744073709551615ULL && (*_errno()) == 34)
                {
                }
                if (suffix[0] == 85)
                {
                    if (value <= 4294967295LL && suffix[1] != 76)
                    {
                        cv = object_make_unsigned_int((unsigned int)value);
                    }
                    else
                    {
                        if (value <= 4294967295UL && suffix[2] != 76)
                        {
                            cv = object_make_unsigned_long((unsigned long)value);
                        }
                        else
                        {
                            cv = object_make_unsigned_long_long((unsigned long long)value);
                        }
                    }
                }
                else
                {
                    if (value <= 2147483647 && suffix[0] != 76)
                    {
                        cv = object_make_signed_int((int)value);
                    }
                    else
                    {
                        if (value <= 2147483647L && suffix[1] != 76)
                        {
                            cv = object_make_signed_long((long)value);
                        }
                        else
                        {
                            if (value <= 9223372036854775807LL)
                            {
                                cv = object_make_signed_long_long((long long)value);
                            }
                            else
                            {
                                cv = object_make_signed_long_long(value);
                            }
                        }
                    }
                }
            }
            goto _CKL2; /*break*/

            _CKL20:/*case 140*/ 
            _CKL21:/*case 141*/ 
            goto _CKL2; /*break*/

            _CKL22: /*default*/ 
            ;
        }
        _CKL2:;
    }
    *result = object_to_signed_long_long(&cv);
    return 0;
}

static struct token *pre_match(struct preprocessor_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0U;
    }
    ctx->current = ctx->current->next;
    while (ctx->current && token_is_blank(ctx->current))
    {
        ctx->current = ctx->current->next;
    }
    return ctx->current;
}

static struct object char_constant_to_value(char * s, char error_message[], int error_message_sz_bytes)
{
    unsigned char * p;
    struct object  empty;

    error_message[0] = 0;
    p = (unsigned char *)s;
    if (1) /*try*/
    {
        if (p[0] == 117 && p[1] == 56)
        {
            unsigned int c;

            p++;
            p++;
            p++;
            c = 0;
            p = utf8_decode(p, &c);
            if (p == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (c == 92)
            {
                p = escape_sequences_decode_opt(p, &c);
                if (p == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            if (*p != 39)
            {
                snprintf(error_message, error_message_sz_bytes, "Unicode character literals may not contain multiple characters.");
            }
            if (c > 128)
            {
                snprintf(error_message, error_message_sz_bytes, "Character too large for enclosing character literal type.");
            }
            return object_make_wchar_t((unsigned short)c);
        }
        else
        {
            if (p[0] == 117)
            {
                unsigned int c;

                p++;
                p++;
                c = 0;
                p = utf8_decode(p, &c);
                if (p == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (c == 92)
                {
                    p = escape_sequences_decode_opt(p, &c);
                    if (p == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                if (*p != 39)
                {
                    snprintf(error_message, error_message_sz_bytes, "Unicode character literals may not contain multiple characters.");
                }
                if (c > 65535)
                {
                    snprintf(error_message, error_message_sz_bytes, "Character too large for enclosing character literal type.");
                }
                return object_make_wchar_t((unsigned short)c);
            }
            else
            {
                if (p[0] == 85)
                {
                    unsigned int c;

                    p++;
                    p++;
                    c = 0;
                    p = utf8_decode(p, &c);
                    if (p == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (c == 92)
                    {
                        p = escape_sequences_decode_opt(p, &c);
                        if (p == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                    }
                    if (*p != 39)
                    {
                        snprintf(error_message, error_message_sz_bytes, "Unicode character literals may not contain multiple characters.");
                    }
                    if (c > 4294967295LL)
                    {
                        snprintf(error_message, error_message_sz_bytes, "Character too large for enclosing character literal type.");
                    }
                    return object_make_wchar_t((unsigned short)c);
                }
                else
                {
                    if (p[0] == 76)
                    {
                        long long value;

                        p++;
                        p++;
                        value = 0;
                        while (*p != 39)
                        {
                            unsigned int c;

                            c = 0;
                            p = utf8_decode(p, &c);
                            if (p == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (c == 92)
                            {
                                p = escape_sequences_decode_opt(p, &c);
                                if (p == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                            }
                            value = value * 256 + c;
                            if (value > 65535)
                            {
                                snprintf(error_message, error_message_sz_bytes, "character constant too long for its type");
                                break;
                            }
                        }
                        return object_make_wchar_t((unsigned short)value);
                    }
                    else
                    {
                        long long value;

                        p++;
                        value = 0;
                        while (*p != 39)
                        {
                            unsigned int c;

                            c = 0;
                            p = utf8_decode(p, &c);
                            if (p == 0U)
                            {
                                goto _CKL0;/*throw*/
                            }
                            if (c == 92)
                            {
                                p = escape_sequences_decode_opt(p, &c);
                                if (p == 0U)
                                {
                                    goto _CKL0;/*throw*/
                                }
                            }
                            if (c < 128)
                            {
                                value = value * 256 + c;
                            }
                            else
                            {
                                value = c;
                            }
                            if (value > 2147483647)
                            {
                                snprintf(error_message, error_message_sz_bytes, "character constant too long for its type");
                                break;
                            }
                        }
                        return object_make_wchar_t((unsigned short)value);
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    _cake_zmem(&empty, 104);
    return empty;
}

static void pre_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx);

static void pre_primary_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            pre_unexpected_end_of_file(ctx->input_list.tail, ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 131)
        {
            char * p;
            char errmsg[200];
            struct object  v;

            p = ctx->current->lexeme + 1;
            _cake_zmem(&errmsg, 200);
            v = char_constant_to_value(p, errmsg, 200U);
            if (errmsg[0] != 0)
            {
                preprocessor_diagnostic(650, ctx, ctx->current, "%s", errmsg);
            }
            ectx->value = object_to_signed_long_long(&v);
            pre_match(ctx);
            object_destroy(&v);
        }
        else
        {
            if (ctx->current->type == 134)
            {
                ppnumber_to_longlong(ctx, ctx->current, &ectx->value);
                pre_match(ctx);
            }
            else
            {
                if (ctx->current->type == 40)
                {
                    pre_match(ctx);
                    pre_expression(ctx, ectx);
                    if (ctx->n_errors > 0)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (ctx->current && ctx->current->type != 41)
                    {
                        preprocessor_diagnostic(650, ctx, ctx->current, "expected )");
                        goto _CKL0;/*throw*/
                    }
                    pre_match(ctx);
                }
                else
                {
                    preprocessor_diagnostic(1140, ctx, ctx->current, "token '%s' is not valid in preprocessor expressions", ctx->current->lexeme);
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_postfix_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_primary_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_cast_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx);

static void pre_unary_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        if (ctx->current && (ctx->current->type == 11051 || ctx->current->type == 11565))
        {
            preprocessor_diagnostic(1140, ctx, ctx->current, "token '%s' is not valid in preprocessor expressions", ctx->current->lexeme);
            goto _CKL0;/*throw*/
        }
        else
        {
            if (ctx->current != 0U && (ctx->current->type == 38 || ctx->current->type == 42 || ctx->current->type == 43 || ctx->current->type == 45 || ctx->current->type == 126 || ctx->current->type == 33))
            {
                struct token * p_old;
                int op;

                p_old = ctx->current;
                op = ctx->current->type;
                pre_match(ctx);
                pre_cast_expression(ctx, ectx);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
                if (op == 33)
                {
                    ectx->value = !ectx->value;
                }
                else
                {
                    if (op == 126)
                    {
                        ectx->value = ~ectx->value;
                    }
                    else
                    {
                        if (op == 45)
                        {
                            ectx->value = -ectx->value;
                        }
                        else
                        {
                            if (op == 43)
                            {
                                ectx->value = +ectx->value;
                            }
                            else
                            {
                                if (op == 42)
                                {
                                    preprocessor_diagnostic(1140, ctx, p_old, "token '%s' is not valid in preprocessor expressions", p_old->lexeme);
                                }
                                else
                                {
                                    if (op == 38)
                                    {
                                        preprocessor_diagnostic(1140, ctx, p_old, "token '%s' is not valid in preprocessor expressions", p_old->lexeme);
                                    }
                                    else
                                    {
                                        preprocessor_diagnostic(1140, ctx, p_old, "token '%s' is not valid in preprocessor expressions", p_old->lexeme);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                pre_postfix_expression(ctx, ectx);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_cast_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    pre_unary_expression(ctx, ectx);
}

static void pre_multiplicative_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_cast_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 42 || ctx->current->type == 47 || ctx->current->type == 37))
        {
            struct token * op_token;
            int op;
            long long left_value;

            op_token = ctx->current;
            op = ctx->current->type;
            pre_match(ctx);
            left_value = ectx->value;
            pre_cast_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            if (op == 42)
            {
                ectx->value = (left_value * ectx->value);
            }
            else
            {
                if (op == 47)
                {
                    if (ectx->value == 0)
                    {
                        preprocessor_diagnostic(1330, ctx, op_token, "division by zero");
                        goto _CKL0;/*throw*/
                    }
                    else
                    {
                        ectx->value = (left_value / ectx->value);
                    }
                }
                else
                {
                    if (op == 37)
                    {
                        ectx->value = (left_value % ectx->value);
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_additive_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_multiplicative_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 43 || ctx->current->type == 45))
        {
            struct token * p_op_token;
            long long left_value;

            p_op_token = ctx->current;
            pre_match(ctx);
            if (ctx->current == 0U)
            {
                pre_unexpected_end_of_file(ctx->input_list.tail, ctx);
                goto _CKL0;/*throw*/
            }
            left_value = ectx->value;
            pre_multiplicative_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            if (p_op_token->type == 43)
            {
                ectx->value = left_value + ectx->value;
            }
            else
            {
                if (p_op_token->type == 45)
                {
                    ectx->value = left_value - ectx->value;
                }
                else
                {
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_shift_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_additive_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 15934 || ctx->current->type == 15420))
        {
            int op;
            long long left_value;

            op = ctx->current->type;
            pre_match(ctx);
            left_value = ectx->value;
            pre_multiplicative_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            if (op == 15934)
            {
                ectx->value = left_value >> ectx->value;
            }
            else
            {
                if (op == 15420)
                {
                    ectx->value = left_value << ectx->value;
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_relational_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_shift_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 62 || ctx->current->type == 60 || ctx->current->type == 15933 || ctx->current->type == 15421))
        {
            int op;
            long long left_value;

            op = ctx->current->type;
            pre_match(ctx);
            left_value = ectx->value;
            pre_shift_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            if (op == 62)
            {
                ectx->value = left_value > ectx->value;
            }
            else
            {
                if (op == 60)
                {
                    ectx->value = left_value < ectx->value;
                }
                else
                {
                    if (op == 15933)
                    {
                        ectx->value = left_value >= ectx->value;
                    }
                    else
                    {
                        if (op == 15421)
                        {
                            ectx->value = left_value <= ectx->value;
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_equality_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_relational_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 15677 || ctx->current->type == 8509))
        {
            int op;
            long long left_value;

            op = ctx->current->type;
            pre_match(ctx);
            left_value = ectx->value;
            pre_multiplicative_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            if (op == 15677)
            {
                ectx->value = left_value == ectx->value;
            }
            else
            {
                if (op == 8509)
                {
                    ectx->value = left_value != ectx->value;
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_and_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_equality_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 38))
        {
            long long left_value;

            pre_match(ctx);
            left_value = ectx->value;
            pre_equality_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            ectx->value = left_value & ectx->value;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_exclusive_or_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_and_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 94))
        {
            long long left_value;

            pre_match(ctx);
            left_value = ectx->value;
            pre_and_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            ectx->value = left_value ^ ectx->value;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_inclusive_or_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_exclusive_or_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 124))
        {
            long long left_value;

            pre_match(ctx);
            left_value = ectx->value;
            pre_exclusive_or_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            ectx->value = left_value | ectx->value;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_logical_and_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_inclusive_or_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 9766))
        {
            long long left_value;

            pre_match(ctx);
            left_value = ectx->value;
            pre_inclusive_or_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            ectx->value = left_value && ectx->value;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_logical_or_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_logical_and_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 31868))
        {
            long long left_value;

            pre_match(ctx);
            left_value = ectx->value;
            pre_logical_and_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
            ectx->value = left_value || ectx->value;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_conditional_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx);

static void pre_assignment_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_conditional_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current != 0U && (ctx->current->type == 61 || ctx->current->type == 10813 || ctx->current->type == 12093 || ctx->current->type == 11069 || ctx->current->type == 11581 || ctx->current->type == 3947581 || ctx->current->type == 4079165 || ctx->current->type == 9789 || ctx->current->type == 24125 || ctx->current->type == 31805))
        {
            preprocessor_diagnostic(1140, ctx, ctx->current, "token '%s' is not valid in preprocessor expressions", ctx->current->lexeme);
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_assignment_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        while (ctx->current && ctx->current->type == 44)
        {
            pre_match(ctx);
            pre_expression(ctx, ectx);
            if (ctx->n_errors > 0)
            {
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void pre_conditional_expression(struct preprocessor_ctx * ctx, struct pre_expression_ctx * ectx)
{
    if (1) /*try*/
    {
        pre_logical_or_expression(ctx, ectx);
        if (ctx->n_errors > 0)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current && ctx->current->type == 63)
        {
            pre_match(ctx);
            if (ectx->value)
            {
                struct pre_expression_ctx  temp;

                pre_expression(ctx, ectx);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
                pre_match(ctx);
                _cake_zmem(&temp, 8);
                pre_conditional_expression(ctx, &temp);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
            }
            else
            {
                struct pre_expression_ctx  temp;

                _cake_zmem(&temp, 8);
                pre_expression(ctx, &temp);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
                pre_match(ctx);
                pre_conditional_expression(ctx, ectx);
                if (ctx->n_errors > 0)
                {
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

int pre_constant_expression(struct preprocessor_ctx * ctx, long long * pvalue)
{
    struct pre_expression_ctx  ectx;

    _cake_zmem(&ectx, 8);
    pre_conditional_expression(ctx, &ectx);
    *pvalue = ectx.value;
    return ctx->n_errors > 0;
}

void secondary_block_delete(struct secondary_block * p);

void defer_statement_delete(struct defer_statement * p)
{
    if (p)
    {
        secondary_block_delete(p->secondary_block);
        free(p);
    }
}

static int s_anonymous_struct_count = 0;
static unsigned char  parser_is_diagnostic_enabled(struct parser_ctx * ctx, int w)
{
    if (w > 63)
    {
        return 1;
    }
    return !!(((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].errors & w) != 0) || ((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings & w) != 0) || ((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].notes & w) != 0));
}

static void check_open_brace_style(struct parser_ctx * ctx, struct token * token)
{
    if (token->level == 0 && !(token->flags & 2) && token->type == 123 && token->prev && parser_is_diagnostic_enabled(ctx, 10))
    {
        if (ctx->options.style == 0)
        {
            if (token->prev->type == 143 && token->prev->prev && token->prev->prev->type == 10)
            {
            }
            else
            {
                compiler_diagnostic(10, ctx, token, 0U, "not following correct brace style {");
            }
        }
    }
}

static void check_close_brace_style(struct parser_ctx * ctx, struct token * token)
{
    if (token->level == 0 && !(token->flags & 2) && token->type == 125 && token->prev && token->prev->prev && parser_is_diagnostic_enabled(ctx, 10))
    {
        if (ctx->options.style == 0)
        {
            if (token->prev->type == 143 && token->prev->prev->type == 10)
            {
            }
            else
            {
                compiler_diagnostic(10, ctx, token, 0U, "not following correct close brace style }");
            }
        }
    }
}

static void check_func_open_brace_style(struct parser_ctx * ctx, struct token * token)
{
    if (token->level == 0 && !(token->flags & 2) && token->type == 123 && token->prev && parser_is_diagnostic_enabled(ctx, 10))
    {
        if (ctx->options.style == 0)
        {
            if (token->prev->type == 10)
            {
            }
            else
            {
                compiler_diagnostic(10, ctx, token, 0U, "not following correct brace style {");
            }
        }
    }
}

void scope_destroy(struct scope * p)
{
    hashmap_destroy(&p->tags);
    hashmap_destroy(&p->variables);
}

void scope_list_push(struct scope_list * list, struct scope * pnew)
{
    if (list->tail)
    {
        pnew->scope_level = list->tail->scope_level + 1;
    }
    if (list->head == 0U)
    {
        list->head = pnew;
        list->tail = pnew;
    }
    else
    {
        ;
        pnew->previous = list->tail;
        list->tail->next = pnew;
        list->tail = pnew;
    }
}

void scope_list_pop(struct scope_list * list)
{
    struct scope * p;

    if (list->head == 0U)
    {
        return;
    }
    ;
    p = list->tail;
    if (list->head == list->tail)
    {
        list->head = 0U;
        list->tail = 0U;
    }
    else
    {
        list->tail = list->tail->previous;
        if (list->tail == list->head)
        {
            ;
            list->tail->next = 0U;
            list->tail->previous = 0U;
        }
    }
    p->next = 0U;
    p->previous = 0U;
}

void label_list_clear(struct label_list * list);

void parser_ctx_destroy(struct parser_ctx * ctx)
{
    label_list_clear(&ctx->label_list);
    ;
    ;
    if (ctx->sarif_file)
    {
        fclose(ctx->sarif_file);
    }
}

static void stringfy(char * input, char * json_str_message, int output_size)
{
    int k;

    json_str_message[0] = 0;
    k = 0;
    while (*input != 0)
    {
        if (*input == 34)
        {
            if (k < output_size)
            {
                json_str_message[k] = 92;
            }
            k++;
            if (k < output_size)
            {
                json_str_message[k] = 34;
            }
            k++;
            input++;
        }
        else
        {
            if (*input == 10)
            {
                if (k < output_size)
                {
                    json_str_message[k] = 92;
                }
                k++;
                if (k < output_size)
                {
                    json_str_message[k] = 110;
                }
                k++;
                input++;
            }
            else
            {
                if (k < output_size)
                {
                    json_str_message[k] = *input;
                }
                k++;
                input++;
            }
        }
    }
    if (k < output_size)
    {
        json_str_message[k] = 0;
    }
    else
    {
        json_str_message[output_size - 1] = 0;
    }
}


inline int __cdecl fprintf(struct _iobuf * _Stream, char * _Format, ...)
{
    int _Result;
    char * _ArgList;

    ((void)(_ArgList = (char *)(&(_Format)) + 4U));
    _Result = _vfprintf_l(_Stream, _Format, 0U, _ArgList);
    ((void)(_ArgList = 0U));
    return !!(_Result);
}

unsigned char  compiler_diagnostic(int w, struct parser_ctx * ctx, struct token * p_token_opt, struct marker * p_marker_temp, char * fmt, ...)
{
    unsigned char   included_file_location;
    struct marker  marker;
    unsigned char   is_error;
    unsigned char   is_warning;
    unsigned char   is_note;
    char * func_name;
    char buffer[200];
    char diagnostic_name[100];
    char * args;

    included_file_location = 0;
    _cake_zmem(&marker, 28);
    if (p_marker_temp == 0U)
    {
        if (p_token_opt == 0U)
        {
            return 0;
        }
        marker.file = p_token_opt->token_origin->lexeme;
        marker.line = p_token_opt->line;
        marker.start_col = p_token_opt->col;
        marker.end_col = p_token_opt->col;
        marker.p_token_caret = p_token_opt;
        included_file_location = !!(p_token_opt->level > 0);
    }
    else
    {
        marker = *p_marker_temp;
        if (marker.p_token_caret)
        {
            p_token_opt = marker.p_token_caret;
        }
        else
        {
            if (marker.p_token_begin)
            {
                p_token_opt = marker.p_token_begin;
            }
        }
        if (p_token_opt == 0U)
        {
            return 0;
        }
        marker.file = p_token_opt->token_origin->lexeme;
        included_file_location = !!(p_token_opt->level > 0);
        marker.line = p_token_opt->line;
        marker.start_col = p_token_opt->col;
        marker.end_col = p_token_opt->col;
    }
    is_error = 0;
    is_warning = 0;
    is_note = 0;
    if (is_diagnostic_configurable(w))
    {
        is_error = !!((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].errors & (1ULL << w)) != 0);
        is_warning = !!((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings & (1ULL << w)) != 0);
        is_note = !!(((ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].notes & (1ULL << w)) != 0));
    }
    else
    {
        is_note = is_diagnostic_note(w);
        is_error = is_diagnostic_error(w);
        is_warning = is_diagnostic_warning(w);
    }
    if (is_error)
    {
        ctx->p_report->error_count++;
    }
    else
    {
        if (is_warning)
        {
            if (included_file_location)
            {
                return 0;
            }
            ctx->p_report->warnings_count++;
        }
        else
        {
            if (is_note)
            {
                if (included_file_location)
                {
                    return 0;
                }
                if (w != 62)
                {
                    ctx->p_report->info_count++;
                }
            }
            else
            {
                return 0;
            }
        }
    }
    if (w != 62)
    {
        ctx->p_report->last_diagnostics_ids[1] = ctx->p_report->last_diagnostics_ids[0];
        ctx->p_report->last_diagnostics_ids[0] = w;
    }
    func_name = "module";
    if (ctx->p_current_function_opt)
    {
        if (ctx->p_current_function_opt->name_opt)
        {
            func_name = ctx->p_current_function_opt->name_opt->lexeme;
        }
        else
        {
            func_name = "unnamed";
        }
    }
    _cake_zmem(&buffer, 200);
    _cake_zmem(&diagnostic_name, 100);
    get_warning_name(w, 100U, diagnostic_name);
    print_position(marker.file, marker.line, marker.start_col, ctx->options.visual_studio_ouput_format);
    _cake_zmem(&args, 4);
    ((void)(args = (char *)(&(fmt)) + 4U));
    vsnprintf(buffer, 200U, fmt, args);
    ((void)(args = 0U));
    if (ctx->options.visual_studio_ouput_format)
    {
        if (is_error)
        {
            printf("error: ");
        }
        else
        {
            if (is_warning)
            {
                printf("warning: ");
            }
            else
            {
                if (is_note)
                {
                    printf("note: ");
                }
            }
        }
        printf("%s", buffer);
        printf(" [%s]\n", diagnostic_name);
    }
    else
    {
        if (is_error)
        {
            printf("\x1b[91m""error: ""\x1b[97m""%s [""\x1b[91m""%s""\x1b[97m""]\n""\x1b[0m", buffer, diagnostic_name);
        }
        else
        {
            if (is_warning)
            {
                printf("\x1b[95m""warning: ""\x1b[97m""%s [""\x1b[95m""%s""\x1b[97m""]\n""\x1b[0m", buffer, diagnostic_name);
            }
            else
            {
                if (is_note)
                {
                    if (w == 62)
                    {
                        printf("\x1b[36;1m""note: ""\x1b[97m""%s\n""\x1b[0m", buffer);
                    }
                    else
                    {
                        printf("\x1b[36;1m""note: ""\x1b[97m""%s [""\x1b[36;1m""%s""\x1b[97m""]\n""\x1b[0m", buffer, diagnostic_name);
                    }
                }
            }
        }
    }
    print_line_and_token(&marker, ctx->options.visual_studio_ouput_format);
    if (ctx->sarif_file)
    {
        char json_str_message[200];

        _cake_zmem(&json_str_message, 200);
        stringfy(buffer, json_str_message, 200U);
        if (ctx->sarif_entries > 0)
        {
            fprintf(ctx->sarif_file, "   ,\n");
        }
        ((struct parser_ctx *)ctx)->sarif_entries++;
        fprintf(ctx->sarif_file, "   {\n");
        fprintf(ctx->sarif_file, "     \"ruleId\":\"%s\",\n", diagnostic_name);
        if (is_error)
        {
            fprintf(ctx->sarif_file, "     \"level\":\"error\",\n");
        }
        else
        {
            if (is_warning)
            {
                fprintf(ctx->sarif_file, "     \"level\":\"warning\",\n");
            }
            else
            {
                if (is_note)
                {
                    fprintf(ctx->sarif_file, "     \"level\":\"note\",\n");
                }
            }
        }
        fprintf(ctx->sarif_file, "     \"message\": {\n");
        fprintf(ctx->sarif_file, "            \"text\": \"%s\"\n", json_str_message);
        fprintf(ctx->sarif_file, "      },\n");
        fprintf(ctx->sarif_file, "      \"locations\": [\n");
        fprintf(ctx->sarif_file, "       {\n");
        fprintf(ctx->sarif_file, "       \"physicalLocation\": {\n");
        fprintf(ctx->sarif_file, "             \"artifactLocation\": {\n");
        fprintf(ctx->sarif_file, "                 \"uri\": \"file:///%s\"\n", marker.file);
        fprintf(ctx->sarif_file, "              },\n");
        fprintf(ctx->sarif_file, "              \"region\": {\n");
        fprintf(ctx->sarif_file, "                  \"startLine\": %d,\n", marker.line);
        fprintf(ctx->sarif_file, "                  \"startColumn\": %d,\n", marker.start_col);
        fprintf(ctx->sarif_file, "                  \"endLine\": %d,\n", marker.line);
        fprintf(ctx->sarif_file, "                  \"endColumn\": %d\n", marker.end_col);
        fprintf(ctx->sarif_file, "               }\n");
        fprintf(ctx->sarif_file, "         },\n");
        fprintf(ctx->sarif_file, "         \"logicalLocations\": [\n");
        fprintf(ctx->sarif_file, "          {\n");
        fprintf(ctx->sarif_file, "              \"fullyQualifiedName\": \"%s\",\n", func_name);
        fprintf(ctx->sarif_file, "              \"decoratedName\": \"%s\",\n", func_name);
        fprintf(ctx->sarif_file, "              \"kind\": \"%s\"\n", "function");
        fprintf(ctx->sarif_file, "          }\n");
        fprintf(ctx->sarif_file, "         ]\n");
        fprintf(ctx->sarif_file, "       }\n");
        fprintf(ctx->sarif_file, "     ]\n");
        fprintf(ctx->sarif_file, "   }\n");
    }
    return 1;
}

void print_scope(struct scope_list * e)
{
    struct scope * p;
    int level;

    printf("--- begin of scope---\n");
    p = e->head;
    level = 0;
    while (p)
    {
        if (p->variables.table)
        {
            {
                int i;
                i = 0;
                for (; i < p->variables.capacity; i++)
                {
                    if (p->variables.table[i])
                    {
                        {
                            int k;
                            k = 0;
                            for (; k < level; k++)
                            printf(" ");
                        }
                        printf("%s\n", p->variables.table[i]->key);
                    }
                }
            }
            {
                int i;
                i = 0;
                for (; i < p->tags.capacity; i++)
                {
                    if (p->tags.table[i])
                    {
                        {
                            int k;
                            k = 0;
                            for (; k < level; k++)
                            printf(" ");
                        }
                        printf("tag %s\n", p->tags.table[i]->key);
                    }
                }
            }
        }
        level++;
        p = p->next;
    }
    printf("--- end of scope---\n");
}

unsigned char  first_of_function_specifier(struct parser_ctx * ctx)
{
    struct token * token;

    token = ctx->current;
    if (token == 0U)
    {
        return 0;
    }
    return !!(token->type == 9018 || token->type == 9060);
}

unsigned char  first_of_enum_specifier_token(struct token * token)
{
    return !!(token->type == 9012);
}

unsigned char  first_of_enum_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return first_of_enum_specifier_token(ctx->current);
}

unsigned char  first_of_alignment_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9043);
}

struct token *parser_look_ahead(struct parser_ctx * ctx);

unsigned char  first_of_atomic_type_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    if (ctx->current->type == 9045)
    {
        struct token * ahead;

        ahead = parser_look_ahead(ctx);
        if (ahead != 0U)
        {
            return !!(ahead->type == 40);
        }
    }
    return 0;
}

unsigned char  first_of_storage_class_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9035 || ctx->current->type == 9002 || ctx->current->type == 9013 || ctx->current->type == 9032 || ctx->current->type == 9063 || ctx->current->type == 8999 || ctx->current->type == 9025);
}

unsigned char  first_of_struct_or_union_token(struct token * token)
{
    return !!(token->type == 9033 || token->type == 9038);
}

unsigned char  first_of_struct_or_union(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return first_of_struct_or_union_token(ctx->current);
}

unsigned char  first_of_type_qualifier_token(struct token * p_token)
{
    return !!(p_token->type == 9004 || p_token->type == 9026 || p_token->type == 9041 || p_token->type == 9045 || p_token->type == 9046 || p_token->type == 9047 || p_token->type == 9071 || p_token->type == 9070 || p_token->type == 9072 || p_token->type == 9073 || p_token->type == 9074);
}

unsigned char  first_of_type_qualifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return first_of_type_qualifier_token(ctx->current);
}

struct map_entry *find_tag(struct parser_ctx * ctx, char * lexeme)
{
    struct scope * scope;

    scope = ctx->scopes.tail;
    while (scope)
    {
        struct map_entry * p_entry;

        p_entry = hashmap_find(&scope->tags, lexeme);
        if (p_entry)
        {
            return p_entry;
        }
        scope = scope->previous;
    }
    return 0U;
}

struct map_entry *find_variables(struct parser_ctx * ctx, char * lexeme, struct scope ** ppscope_opt)
{
    struct scope * scope;

    if (ppscope_opt != 0U)
    {
        *ppscope_opt = 0U;
    }
    scope = ctx->scopes.tail;
    while (scope)
    {
        struct map_entry * p_entry;

        p_entry = hashmap_find(&scope->variables, lexeme);
        if (p_entry)
        {
            if (ppscope_opt)
            {
                *ppscope_opt = scope;
            }
            return p_entry;
        }
        scope = scope->previous;
    }
    return 0U;
}

struct enum_specifier *find_enum_specifier(struct parser_ctx * ctx, char * lexeme)
{
    struct enum_specifier * best;
    struct scope * scope;

    best = 0U;
    scope = ctx->scopes.tail;
    while (scope)
    {
        struct map_entry * p_entry;

        p_entry = hashmap_find(&scope->tags, lexeme);
        if (p_entry && p_entry->type == 1)
        {
            ;
            best = p_entry->data.p_enum_specifier;
            if (best->enumerator_list.head != 0U)
            {
                return best;
            }
            else
            {
            }
        }
        scope = scope->previous;
    }
    return best;
}

struct struct_or_union_specifier *find_struct_or_union_specifier(struct parser_ctx * ctx, char * lexeme)
{
    struct struct_or_union_specifier * p;
    struct scope * scope;

    p = 0U;
    scope = ctx->scopes.tail;
    while (scope)
    {
        struct map_entry * p_entry;

        p_entry = hashmap_find(&scope->tags, lexeme);
        if (p_entry && p_entry->type == 2)
        {
            ;
            p = p_entry->data.p_struct_or_union_specifier;
            break;
        }
        scope = scope->previous;
    }
    return p;
}

struct declarator *find_declarator(struct parser_ctx * ctx, char * lexeme, struct scope ** ppscope_opt)
{
    struct map_entry * p_entry;

    p_entry = find_variables(ctx, lexeme, ppscope_opt);
    if (p_entry)
    {
        if (p_entry->type == 5)
        {
            struct init_declarator * p_init_declarator;

            ;
            p_init_declarator = p_entry->data.p_init_declarator;
            return (struct declarator *)p_init_declarator->p_declarator;
        }
        else
        {
            if (p_entry->type == 4)
            {
                return p_entry->data.p_declarator;
            }
        }
    }
    return 0U;
}

struct enumerator *find_enumerator(struct parser_ctx * ctx, char * lexeme, struct scope ** ppscope_opt)
{
    struct map_entry * p_entry;

    p_entry = find_variables(ctx, lexeme, ppscope_opt);
    if (p_entry && p_entry->type == 3)
    {
        return p_entry->data.p_enumerator;
    }
    return 0U;
}

unsigned char  first_of_typedef_name(struct parser_ctx * ctx, struct token * p_token)
{
    struct declarator * p_declarator;

    if (p_token->type != 8996)
    {
        return 0;
    }
    if (p_token->flags & 16)
    {
        return 1;
    }
    if (p_token->flags & 32)
    {
        return 0;
    }
    p_declarator = find_declarator(ctx, p_token->lexeme, 0U);
    if (p_declarator && p_declarator->declaration_specifiers && (p_declarator->declaration_specifiers->storage_class_specifier_flags & 1))
    {
        p_declarator->num_uses++;
        p_token->flags |= 16;
        return 1;
    }
    else
    {
        p_token->flags |= 32;
    }
    return 0;
}

unsigned char  first_of_type_specifier_token(struct parser_ctx * ctx, struct token * token);

unsigned char  first_of_type_name_ahead(struct parser_ctx * ctx)
{
    struct token * token_ahead;

    if (ctx->current == 0U)
    {
        return 0;
    }
    if (ctx->current->type != 40)
    {
        return 0;
    }
    token_ahead = parser_look_ahead(ctx);
    if (token_ahead == 0U)
    {
        return 0;
    }
    return !!(first_of_type_specifier_token(ctx, token_ahead) || first_of_type_qualifier_token(token_ahead));
}

unsigned char  first_of_type_specifier(struct parser_ctx * ctx);

unsigned char  first_of_type_name(struct parser_ctx * ctx)
{
    return !!(first_of_type_specifier(ctx) || first_of_type_qualifier(ctx));
}

unsigned char  first_of_type_specifier_token(struct parser_ctx * ctx, struct token * p_token)
{
    return !!(p_token->type == 9040 || p_token->type == 9003 || p_token->type == 9028 || p_token->type == 9019 || p_token->type == 9020 || p_token->type == 9021 || p_token->type == 9022 || p_token->type == 9023 || p_token->type == 9024 || p_token->type == 9051 || p_token->type == 9014 || p_token->type == 9010 || p_token->type == 9029 || p_token->type == 9039 || p_token->type == 9069 || p_token->type == 9053 || p_token->type == 9054 || p_token->type == 9056 || p_token->type == 9057 || p_token->type == 9055 || p_token->type == 9064 || p_token->type == 9068 || first_of_atomic_type_specifier(ctx) || first_of_struct_or_union_token(p_token) || first_of_enum_specifier_token(p_token) || first_of_typedef_name(ctx, p_token));
}

unsigned char  first_of_type_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return first_of_type_specifier_token(ctx, ctx->current);
}

unsigned char  first_of_type_specifier_qualifier(struct parser_ctx * ctx)
{
    return !!(first_of_type_specifier(ctx) || first_of_type_qualifier(ctx) || first_of_alignment_specifier(ctx));
}

unsigned char  first_of_compound_statement(struct parser_ctx * ctx)
{
    return !!(ctx->current != 0U && ctx->current->type == 123);
}

unsigned char  first_of_jump_statement(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9016 || ctx->current->type == 9005 || ctx->current->type == 9000 || ctx->current->type == 9027 || ctx->current->type == 9037);
}

unsigned char  first_of_selection_statement(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9017 || ctx->current->type == 9034);
}

unsigned char  first_of_iteration_statement(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9042 || ctx->current->type == 9008 || ctx->current->type == 9015);
}

unsigned char  first_of_label(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    if (ctx->current->type == 8996)
    {
        struct token * next;

        next = parser_look_ahead(ctx);
        return !!(next && next->type == 58);
    }
    else
    {
        if (ctx->current->type == 9001)
        {
            return 1;
        }
        else
        {
            if (ctx->current->type == 9007)
            {
                return 1;
            }
        }
    }
    return 0;
}

unsigned char  first_of_declaration_specifier(struct parser_ctx * ctx)
{
    return !!(first_of_storage_class_specifier(ctx) || first_of_function_specifier(ctx) || first_of_type_specifier_qualifier(ctx));
}

unsigned char  first_of_pragma_declaration(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 128);
}

unsigned char  first_of_static_assert_declaration(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9061 || ctx->current->type == 9075 || ctx->current->type == 9076 || ctx->current->type == 9077 || ctx->current->type == 9078);
}

unsigned char  first_of_attribute_specifier(struct parser_ctx * ctx)
{
    struct token * p_token;

    if (ctx->current == 0U)
    {
        return 0;
    }
    if (ctx->current->type != 91)
    {
        return 0;
    }
    p_token = parser_look_ahead(ctx);
    return !!(p_token != 0U && p_token->type == 91);
}

unsigned char  first_of_labeled_statement(struct parser_ctx * ctx)
{
    return first_of_label(ctx);
}

unsigned char  first_of_designator(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 91 || ctx->current->type == 46);
}

struct token *previous_parser_token(struct token * token)
{
    struct token * prev;

    if (token->prev == 0U)
    {
        return 0U;
    }
    prev = token->prev;
    while (prev && !(prev->flags & 1))
    {
        prev = prev->prev;
    }
    return prev;
}

int is_keyword(char * text)
{
    /*switch*/
    {
        register char _R57 = text[0];
        if (_R57 == 97) goto _CKL1; /*case 97*/
        if (_R57 == 98) goto _CKL7; /*case 98*/
        if (_R57 == 99) goto _CKL10; /*case 99*/
        if (_R57 == 100) goto _CKL17; /*case 100*/
        if (_R57 == 101) goto _CKL22; /*case 101*/
        if (_R57 == 102) goto _CKL26; /*case 102*/
        if (_R57 == 103) goto _CKL30; /*case 103*/
        if (_R57 == 105) goto _CKL32; /*case 105*/
        if (_R57 == 110) goto _CKL36; /*case 110*/
        if (_R57 == 108) goto _CKL38; /*case 108*/
        if (_R57 == 114) goto _CKL40; /*case 114*/
        if (_R57 == 115) goto _CKL44; /*case 115*/
        if (_R57 == 116) goto _CKL56; /*case 116*/
        if (_R57 == 117) goto _CKL64; /*case 117*/
        if (_R57 == 118) goto _CKL67; /*case 118*/
        if (_R57 == 119) goto _CKL70; /*case 119*/
        if (_R57 == 95) goto _CKL72; /*case 95*/
        goto _CKL119;/*default*/

        {
            _CKL1:/*case 97*/ 
            if (strcmp("alignof", text) == 0)
            {
                return 9044;
            }
            if (strcmp("auto", text) == 0)
            {
                return 8999;
            }
            if (strcmp("alignas", text) == 0)
            {
                return 9043;
            }
            if (strcmp("alignof", text) == 0)
            {
                return 9043;
            }
            if (strcmp("assert", text) == 0)
            {
                return 9062;
            }
            goto _CKL0; /*break*/

            _CKL7:/*case 98*/ 
            if (strcmp("break", text) == 0)
            {
                return 9000;
            }
            if (strcmp("bool", text) == 0)
            {
                return 9053;
            }
            goto _CKL0; /*break*/

            _CKL10:/*case 99*/ 
            if (strcmp("case", text) == 0)
            {
                return 9001;
            }
            if (strcmp("char", text) == 0)
            {
                return 9003;
            }
            if (strcmp("const", text) == 0)
            {
                return 9004;
            }
            if (strcmp("constexpr", text) == 0)
            {
                return 9002;
            }
            if (strcmp("continue", text) == 0)
            {
                return 9005;
            }
            if (strcmp("catch", text) == 0)
            {
                return 9006;
            }
            goto _CKL0; /*break*/

            _CKL17:/*case 100*/ 
            if (strcmp("default", text) == 0)
            {
                return 9007;
            }
            if (strcmp("do", text) == 0)
            {
                return 9008;
            }
            if (strcmp("defer", text) == 0)
            {
                return 9009;
            }
            if (strcmp("double", text) == 0)
            {
                return 9010;
            }
            goto _CKL0; /*break*/

            _CKL22:/*case 101*/ 
            if (strcmp("else", text) == 0)
            {
                return 9011;
            }
            if (strcmp("enum", text) == 0)
            {
                return 9012;
            }
            if (strcmp("extern", text) == 0)
            {
                return 9013;
            }
            goto _CKL0; /*break*/

            _CKL26:/*case 102*/ 
            if (strcmp("float", text) == 0)
            {
                return 9014;
            }
            if (strcmp("for", text) == 0)
            {
                return 9015;
            }
            if (strcmp("false", text) == 0)
            {
                return 9066;
            }
            goto _CKL0; /*break*/

            _CKL30:/*case 103*/ 
            if (strcmp("goto", text) == 0)
            {
                return 9016;
            }
            goto _CKL0; /*break*/

            _CKL32:/*case 105*/ 
            if (strcmp("if", text) == 0)
            {
                return 9017;
            }
            if (strcmp("inline", text) == 0)
            {
                return 9018;
            }
            if (strcmp("int", text) == 0)
            {
                return 9019;
            }
            goto _CKL0; /*break*/

            _CKL36:/*case 110*/ 
            if (strcmp("nullptr", text) == 0)
            {
                return 9067;
            }
            goto _CKL0; /*break*/

            _CKL38:/*case 108*/ 
            if (strcmp("long", text) == 0)
            {
                return 9020;
            }
            goto _CKL0; /*break*/

            _CKL40:/*case 114*/ 
            if (strcmp("register", text) == 0)
            {
                return 9025;
            }
            if (strcmp("restrict", text) == 0)
            {
                return 9026;
            }
            if (strcmp("return", text) == 0)
            {
                return 9027;
            }
            goto _CKL0; /*break*/

            _CKL44:/*case 115*/ 
            if (strcmp("short", text) == 0)
            {
                return 9028;
            }
            if (strcmp("signed", text) == 0)
            {
                return 9029;
            }
            if (strcmp("sizeof", text) == 0)
            {
                return 9030;
            }
            if (strcmp("static", text) == 0)
            {
                return 9032;
            }
            if (strcmp("struct", text) == 0)
            {
                return 9033;
            }
            if (strcmp("switch", text) == 0)
            {
                return 9034;
            }
            if (strcmp("static_assert", text) == 0)
            {
                return 9061;
            }
            if (strcmp("static_debug", text) == 0)
            {
                return 9075;
            }
            if (strcmp("static_debug_ex", text) == 0)
            {
                return 9076;
            }
            if (strcmp("static_state", text) == 0)
            {
                return 9077;
            }
            if (strcmp("static_set", text) == 0)
            {
                return 9078;
            }
            goto _CKL0; /*break*/

            _CKL56:/*case 116*/ 
            if (strcmp("typedef", text) == 0)
            {
                return 9035;
            }
            if (strcmp("typeof", text) == 0)
            {
                return 9064;
            }
            if (strcmp("typeof_unqual", text) == 0)
            {
                return 9068;
            }
            if (strcmp("true", text) == 0)
            {
                return 9065;
            }
            if (strcmp("thread_local", text) == 0)
            {
                return 9063;
            }
            if (strcmp("try", text) == 0)
            {
                return 9036;
            }
            if (strcmp("throw", text) == 0)
            {
                return 9037;
            }
            goto _CKL0; /*break*/

            _CKL64:/*case 117*/ 
            if (strcmp("union", text) == 0)
            {
                return 9038;
            }
            if (strcmp("unsigned", text) == 0)
            {
                return 9039;
            }
            goto _CKL0; /*break*/

            _CKL67:/*case 118*/ 
            if (strcmp("void", text) == 0)
            {
                return 9040;
            }
            if (strcmp("volatile", text) == 0)
            {
                return 9041;
            }
            goto _CKL0; /*break*/

            _CKL70:/*case 119*/ 
            if (strcmp("while", text) == 0)
            {
                return 9042;
            }
            goto _CKL0; /*break*/

            _CKL72:/*case 95*/ 
            if (strcmp("_Ctor", text) == 0)
            {
                return 9071;
            }
            if (strcmp("_Owner", text) == 0)
            {
                return 9070;
            }
            if (strcmp("_Dtor", text) == 0)
            {
                return 9072;
            }
            if (strcmp("_Opt", text) == 0)
            {
                return 9074;
            }
            if (strcmp("_View", text) == 0)
            {
                return 9073;
            }
            if (strcmp("_Countof", text) == 0)
            {
                return 9031;
            }
            if (strcmp("_is_lvalue", text) == 0)
            {
                return 9080;
            }
            if (strcmp("_is_const", text) == 0)
            {
                return 9081;
            }
            if (strcmp("_is_owner", text) == 0)
            {
                return 9082;
            }
            if (strcmp("_is_pointer", text) == 0)
            {
                return 9079;
            }
            if (strcmp("_is_array", text) == 0)
            {
                return 9083;
            }
            if (strcmp("_is_function", text) == 0)
            {
                return 9084;
            }
            if (strcmp("_is_arithmetic", text) == 0)
            {
                return 9086;
            }
            if (strcmp("_is_floating_point", text) == 0)
            {
                return 9087;
            }
            if (strcmp("_is_integral", text) == 0)
            {
                return 9088;
            }
            if (strcmp("_is_scalar", text) == 0)
            {
                return 9085;
            }
            if (strcmp("_Alignof", text) == 0)
            {
                return 9044;
            }
            if (strcmp("_Alignas", text) == 0)
            {
                return 9043;
            }
            if (strcmp("_Atomic", text) == 0)
            {
                return 9045;
            }
            if (strcmp("__ptr32", text) == 0)
            {
                return 9046;
            }
            if (strcmp("__ptr64", text) == 0)
            {
                return 9047;
            }
            if (strcmp("_Bool", text) == 0)
            {
                return 9053;
            }
            if (strcmp("_Complex", text) == 0)
            {
                return 9054;
            }
            if (strcmp("_Decimal32", text) == 0)
            {
                return 9056;
            }
            if (strcmp("_Decimal64", text) == 0)
            {
                return 9057;
            }
            if (strcmp("_Decimal128", text) == 0)
            {
                return 9055;
            }
            if (strcmp("_Generic", text) == 0)
            {
                return 9058;
            }
            if (strcmp("_Imaginary", text) == 0)
            {
                return 9059;
            }
            if (strcmp("_Noreturn", text) == 0)
            {
                return 9060;
            }
            if (strcmp("_Static_assert", text) == 0)
            {
                return 9061;
            }
            if (strcmp("_Thread_local", text) == 0)
            {
                return 9063;
            }
            if (strcmp("_BitInt", text) == 0)
            {
                return 9069;
            }
            if (strcmp("__typeof__", text) == 0)
            {
                return 9064;
            }
            if (strcmp("__int8", text) == 0)
            {
                return 9021;
            }
            if (strcmp("__int16", text) == 0)
            {
                return 9022;
            }
            if (strcmp("__int32", text) == 0)
            {
                return 9023;
            }
            if (strcmp("__int64", text) == 0)
            {
                return 9024;
            }
            if (strcmp("__forceinline", text) == 0)
            {
                return 9018;
            }
            if (strcmp("__inline", text) == 0)
            {
                return 9018;
            }
            if (strcmp("_asm", text) == 0 || strcmp("__asm", text) == 0)
            {
                return 9052;
            }
            if (strcmp("__stdcall", text) == 0 || strcmp("_stdcall", text) == 0)
            {
                return 9049;
            }
            if (strcmp("__cdecl", text) == 0)
            {
                return 9050;
            }
            if (strcmp("__fastcall", text) == 0)
            {
                return 9048;
            }
            if (strcmp("__alignof", text) == 0)
            {
                return 9044;
            }
            if (strcmp("__restrict", text) == 0)
            {
                return 9026;
            }
            if (strcmp("__declspec", text) == 0)
            {
                return 9051;
            }
            goto _CKL0; /*break*/

            _CKL119: /*default*/ 
            goto _CKL0; /*break*/

        }
        _CKL0:;
    }
    return 0;
}

static void token_promote(struct parser_ctx * ctx, struct token * token)
{
    if (token->type == 8997)
    {
        token->type = 8996;
    }
    if (token->type == 8996)
    {
        int t;

        t = is_keyword(token->lexeme);
        if (t != 0)
        {
            token->type = t;
        }
    }
    else
    {
        if (token->type == 134)
        {
            char errormsg[100];
            char suffix[4];

            _cake_zmem(&errormsg, 100);
            _cake_zmem(&suffix, 4);
            token->type = parse_number(token->lexeme, suffix, errormsg);
            if (token->type == 0)
            {
                compiler_diagnostic(1380, ctx, token, 0U, errormsg);
            }
        }
    }
}

struct token *parser_look_ahead(struct parser_ctx * ctx)
{
    struct token * p;

    if (ctx->current == 0U)
    {
        return 0U;
    }
    p = ctx->current->next;
    while (p && !(p->flags & 1))
    {
        p = p->next;
    }
    if (p)
    {
        token_promote(ctx, p);
    }
    return p;
}

static struct token *pragma_match(struct token * p_current)
{
    struct token * p_token;

    p_token = p_current->next;
    while (p_token && p_token->type == 143)
    {
        p_token = p_token->next;
    }
    return p_token;
}

static void pragma_skip_blanks(struct parser_ctx * ctx)
{
    while (ctx->current && ctx->current->type == 143)
    {
        ctx->current = ctx->current->next;
    }
}

static void parse_pragma(struct parser_ctx * ctx, struct token * token)
{
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 128)
        {
            ctx->current = ctx->current->next;
            pragma_skip_blanks(ctx);
            if (ctx->current && (strcmp(ctx->current->lexeme, "CAKE") == 0 || strcmp(ctx->current->lexeme, "cake") == 0))
            {
                ctx->current = ctx->current->next;
                pragma_skip_blanks(ctx);
            }
            if (ctx->current && strcmp(ctx->current->lexeme, "nullchecks") == 0)
            {
                unsigned char   onoff;

                ctx->current = ctx->current->next;
                pragma_skip_blanks(ctx);
                onoff = 0;
                if (ctx->current && strcmp(ctx->current->lexeme, "ON") == 0)
                {
                    onoff = 1;
                }
                else
                {
                    if (ctx->current && strcmp(ctx->current->lexeme, "OFF") == 0)
                    {
                        onoff = 0;
                    }
                    else
                    {
                        compiler_diagnostic(1250, ctx, ctx->current, 0U, "nullchecks pragma needs to use ON OFF");
                    }
                }
                ctx->options.null_checks_enabled = onoff;
            }
            if (ctx->current && strcmp(ctx->current->lexeme, "diagnostic") == 0)
            {
                ctx->current = ctx->current->next;
                pragma_skip_blanks(ctx);
                if (ctx->current && strcmp(ctx->current->lexeme, "push") == 0)
                {
                    if (ctx->options.diagnostic_stack.top_index < 10U)
                    {
                        ctx->options.diagnostic_stack.top_index++;
                        ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index] = ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index - 1];
                    }
                    ctx->current = ctx->current->next;
                    pragma_skip_blanks(ctx);
                }
                else
                {
                    if (ctx->current && strcmp(ctx->current->lexeme, "pop") == 0)
                    {
                        if (ctx->options.diagnostic_stack.top_index > 0)
                        {
                            ctx->options.diagnostic_stack.top_index--;
                        }
                        ctx->current = ctx->current->next;
                        pragma_skip_blanks(ctx);
                    }
                    else
                    {
                        if (ctx->current && (strcmp(ctx->current->lexeme, "error") == 0 || strcmp(ctx->current->lexeme, "warning") == 0 || strcmp(ctx->current->lexeme, "note") == 0 || strcmp(ctx->current->lexeme, "ignored") == 0))
                        {
                            unsigned char   is_error;
                            unsigned char   is_warning;
                            unsigned char   is_note;

                            is_error = !!(strcmp(ctx->current->lexeme, "error") == 0);
                            is_warning = !!(strcmp(ctx->current->lexeme, "warning") == 0);
                            is_note = !!(strcmp(ctx->current->lexeme, "note") == 0);
                            ctx->current = ctx->current->next;
                            pragma_skip_blanks(ctx);
                            if (ctx->current && ctx->current->type == 130)
                            {
                                unsigned long long w;

                                w = get_warning_bit_mask(ctx->current->lexeme + 1);
                                ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].errors &= ~w;
                                ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].notes &= ~w;
                                ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings &= ~w;
                                if (is_error)
                                {
                                    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].errors |= w;
                                }
                                else
                                {
                                    if (is_warning)
                                    {
                                        ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].warnings |= w;
                                    }
                                    else
                                    {
                                        if (is_note)
                                        {
                                            ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index].notes |= w;
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                            if (ctx->current && (strcmp(ctx->current->lexeme, "check") == 0))
                            {
                                ctx->current = ctx->current->next;
                                pragma_skip_blanks(ctx);
                                if (ctx->current && ctx->current->type == 130)
                                {
                                    int id;
                                    unsigned char   found;

                                    id = get_warning(ctx->current->lexeme + 1 + 2);
                                    found = 0;
                                    {
                                        int i;
                                        i = 0;
                                        for (; i < 2; i++)
                                        {
                                            if (ctx->p_report->last_diagnostics_ids[i] == 0)
                                            {
                                                break;
                                            }
                                            if (ctx->p_report->last_diagnostics_ids[i] == id)
                                            {
                                                int t;

                                                found = 1;
                                                t = get_diagnostic_type(&ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index], id);
                                                if (t == 3)
                                                {
                                                    ctx->p_report->error_count--;
                                                }
                                                else
                                                {
                                                    if (t == 2)
                                                    {
                                                        ctx->p_report->warnings_count--;
                                                    }
                                                    else
                                                    {
                                                        if (t == 1)
                                                        {
                                                            ctx->p_report->info_count--;
                                                        }
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                    }
                                    if (!found)
                                    {
                                        compiler_diagnostic(650, ctx, ctx->current, 0U, "pragma check failed");
                                    }
                                }
                            }
                            else
                            {
                                compiler_diagnostic(650, ctx, ctx->current, 0U, "unknown pragma");
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

static void parser_skip_blanks(struct parser_ctx * ctx)
{
    while (ctx->current && !(ctx->current->flags & 1))
    {
        if (ctx->current->type == 128)
        {
            parse_pragma(ctx, ctx->current);
        }
        if (ctx->current)
        {
            ctx->current = ctx->current->next;
        }
    }
    if (ctx->current)
    {
        token_promote(ctx, ctx->current);
    }
}

void parser_match(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return;
    }
    ctx->previous = ctx->current;
    ctx->current = ctx->current->next;
    parser_skip_blanks(ctx);
}

void unexpected_end_of_file(struct parser_ctx * ctx)
{
    compiler_diagnostic(970, ctx, ctx->input_list.tail, 0U, "unexpected end of file");
}

int parser_match_tk(struct parser_ctx * ctx, int type)
{
    int error;

    error = 0;
    if (ctx->current != 0U)
    {
        if (ctx->current->type != type)
        {
            compiler_diagnostic(970, ctx, ctx->current, 0U, "expected %s", get_token_name(type));
            error = 1;
        }
        ctx->previous = ctx->current;
        ctx->current = ctx->current->next;
        parser_skip_blanks(ctx);
    }
    else
    {
        compiler_diagnostic(970, ctx, ctx->input_list.tail, 0U, "unexpected end of file after");
        error = 1;
    }
    return error;
}

void print_type_qualifier_flags(struct osstream * ss, unsigned char  * first, int e_type_qualifier_flags);
void print_item(struct osstream * ss, unsigned char  * first, char * item);
unsigned char  print_type_specifier_flags(struct osstream * ss, unsigned char  * first, int e_type_specifier_flags);

void print_declaration_specifiers(struct osstream * ss, struct declaration_specifiers * p_declaration_specifiers)
{
    unsigned char   first;

    first = 1;
    print_type_qualifier_flags(ss, &first, p_declaration_specifiers->type_qualifier_flags);
    if (p_declaration_specifiers->enum_specifier)
    {
        if (p_declaration_specifiers->enum_specifier->tag_token)
        {
            ss_fprintf(ss, "enum %s", p_declaration_specifiers->enum_specifier->tag_token->lexeme);
        }
        else
        {
            ;
        }
    }
    else
    {
        if (p_declaration_specifiers->struct_or_union_specifier)
        {
            ss_fprintf(ss, "struct %s", p_declaration_specifiers->struct_or_union_specifier->tag_name);
        }
        else
        {
            if (p_declaration_specifiers->typedef_declarator)
            {
                if (p_declaration_specifiers->typedef_declarator->name_opt)
                {
                    print_item(ss, &first, p_declaration_specifiers->typedef_declarator->name_opt->lexeme);
                }
            }
            else
            {
                print_type_specifier_flags(ss, &first, p_declaration_specifiers->type_specifier_flags);
            }
        }
    }
}

unsigned char  type_specifier_is_integer(int flags)
{
    if ((flags & 2) || (flags & 4) || (flags & 8) || (flags & 16) || (flags & 8) || (flags & 262144) || (flags & 524288) || (flags & 1048576) || (flags & 2097152) || (flags & 4194304))
    {
        return 1;
    }
    return 0;
}

int final_specifier(struct parser_ctx * ctx, int * flags)
{
    if (((*flags) & 256) || ((*flags) & 128))
    {
        if (!type_specifier_is_integer(*flags))
        {
            (*flags) |= 8;
        }
    }
    return 0;
}

int add_specifier(struct parser_ctx * ctx, int * flags, int new_flag)
{
    if (new_flag & 16)
    {
        if ((*flags) & 4194304)
        {
            compiler_diagnostic(980, ctx, ctx->current, 0U, "cannot combine with previous 'long long' declaration specifier");
            return 1;
        }
        else
        {
            if ((*flags) & 16)
            {
                (*flags) = (*flags) & -17;
                (*flags) |= 4194304;
            }
            else
            {
                (*flags) = (*flags) & -9;
                (*flags) |= 16;
            }
        }
    }
    else
    {
        (*flags) |= new_flag;
    }
    /*switch*/
    {
        register unsigned int _R58 = (unsigned int)*flags;
        if (_R58 == 0) goto _CKL4; /*case 0*/
        if (_R58 == 1) goto _CKL5; /*case 1*/
        if (_R58 == 2) goto _CKL6; /*case 2*/
        if (_R58 == 130) goto _CKL7; /*case 130*/
        if (_R58 == 258) goto _CKL8; /*case 258*/
        if (_R58 == 4) goto _CKL9; /*case 4*/
        if (_R58 == 132) goto _CKL10; /*case 132*/
        if (_R58 == 12) goto _CKL11; /*case 12*/
        if (_R58 == 140) goto _CKL12; /*case 140*/
        if (_R58 == 260) goto _CKL13; /*case 260*/
        if (_R58 == 268) goto _CKL14; /*case 268*/
        if (_R58 == 8) goto _CKL15; /*case 8*/
        if (_R58 == 128) goto _CKL16; /*case 128*/
        if (_R58 == 136) goto _CKL17; /*case 136*/
        if (_R58 == 256) goto _CKL18; /*case 256*/
        if (_R58 == 264) goto _CKL19; /*case 264*/
        if (_R58 == 16) goto _CKL20; /*case 16*/
        if (_R58 == 144) goto _CKL21; /*case 144*/
        if (_R58 == 24) goto _CKL22; /*case 24*/
        if (_R58 == 152) goto _CKL23; /*case 152*/
        if (_R58 == 272) goto _CKL24; /*case 272*/
        if (_R58 == 280) goto _CKL25; /*case 280*/
        if (_R58 == 4194304) goto _CKL26; /*case 4194304*/
        if (_R58 == 4194432) goto _CKL27; /*case 4194432*/
        if (_R58 == 4194312) goto _CKL28; /*case 4194312*/
        if (_R58 == 4194440) goto _CKL29; /*case 4194440*/
        if (_R58 == 4194560) goto _CKL30; /*case 4194560*/
        if (_R58 == 4194568) goto _CKL31; /*case 4194568*/
        if (_R58 == 32) goto _CKL32; /*case 32*/
        if (_R58 == 64) goto _CKL33; /*case 64*/
        if (_R58 == 80) goto _CKL34; /*case 80*/
        if (_R58 == 2048) goto _CKL35; /*case 2048*/
        if (_R58 == 4096) goto _CKL36; /*case 4096*/
        if (_R58 == 8192) goto _CKL37; /*case 8192*/
        if (_R58 == 512) goto _CKL38; /*case 512*/
        if (_R58 == 1056) goto _CKL39; /*case 1056*/
        if (_R58 == 1088) goto _CKL40; /*case 1088*/
        if (_R58 == 1104) goto _CKL41; /*case 1104*/
        if (_R58 == 16384) goto _CKL42; /*case 16384*/
        if (_R58 == 32768) goto _CKL43; /*case 32768*/
        if (_R58 == 65536) goto _CKL44; /*case 65536*/
        if (_R58 == 8388608) goto _CKL45; /*case 8388608*/
        if (_R58 == 131072) goto _CKL46; /*case 131072*/
        if (_R58 == 262144) goto _CKL47; /*case 262144*/
        if (_R58 == 262400) goto _CKL48; /*case 262400*/
        if (_R58 == 524288) goto _CKL49; /*case 524288*/
        if (_R58 == 524544) goto _CKL50; /*case 524544*/
        if (_R58 == 524416) goto _CKL51; /*case 524416*/
        if (_R58 == 1048576) goto _CKL52; /*case 1048576*/
        if (_R58 == 1048832) goto _CKL53; /*case 1048832*/
        if (_R58 == 1048704) goto _CKL54; /*case 1048704*/
        if (_R58 == 2097152) goto _CKL55; /*case 2097152*/
        if (_R58 == 2097408) goto _CKL56; /*case 2097408*/
        if (_R58 == 2097280) goto _CKL57; /*case 2097280*/
        goto _CKL58;/*default*/

        {
            _CKL4:/*case 0*/ 
            _CKL5:/*case 1*/ 
            _CKL6:/*case 2*/ 
            _CKL7:/*case 130*/ 
            _CKL8:/*case 258*/ 
            _CKL9:/*case 4*/ 
            _CKL10:/*case 132*/ 
            _CKL11:/*case 12*/ 
            _CKL12:/*case 140*/ 
            _CKL13:/*case 260*/ 
            _CKL14:/*case 268*/ 
            _CKL15:/*case 8*/ 
            _CKL16:/*case 128*/ 
            _CKL17:/*case 136*/ 
            _CKL18:/*case 256*/ 
            _CKL19:/*case 264*/ 
            _CKL20:/*case 16*/ 
            _CKL21:/*case 144*/ 
            _CKL22:/*case 24*/ 
            _CKL23:/*case 152*/ 
            _CKL24:/*case 272*/ 
            _CKL25:/*case 280*/ 
            _CKL26:/*case 4194304*/ 
            _CKL27:/*case 4194432*/ 
            _CKL28:/*case 4194312*/ 
            _CKL29:/*case 4194440*/ 
            _CKL30:/*case 4194560*/ 
            _CKL31:/*case 4194568*/ 
            _CKL32:/*case 32*/ 
            _CKL33:/*case 64*/ 
            _CKL34:/*case 80*/ 
            _CKL35:/*case 2048*/ 
            _CKL36:/*case 4096*/ 
            _CKL37:/*case 8192*/ 
            _CKL38:/*case 512*/ 
            _CKL39:/*case 1056*/ 
            _CKL40:/*case 1088*/ 
            _CKL41:/*case 1104*/ 
            _CKL42:/*case 16384*/ 
            _CKL43:/*case 32768*/ 
            _CKL44:/*case 65536*/ 
            _CKL45:/*case 8388608*/ 
            _CKL46:/*case 131072*/ 
            _CKL47:/*case 262144*/ 
            _CKL48:/*case 262400*/ 
            _CKL49:/*case 524288*/ 
            _CKL50:/*case 524544*/ 
            _CKL51:/*case 524416*/ 
            _CKL52:/*case 1048576*/ 
            _CKL53:/*case 1048832*/ 
            _CKL54:/*case 1048704*/ 
            _CKL55:/*case 2097152*/ 
            _CKL56:/*case 2097408*/ 
            _CKL57:/*case 2097280*/ 
            goto _CKL3; /*break*/

            _CKL58: /*default*/ 
            compiler_diagnostic(1300, ctx, ctx->current, 0U, "incompatible specifiers");
            return 1;
        }
        _CKL3:;
    }
    return 0;
}

void attribute_specifier_sequence_delete(struct attribute_specifier_sequence * p);
void declaration_specifier_delete(struct declaration_specifier * p);

void declaration_specifiers_delete(struct declaration_specifiers * p)
{
    if (p)
    {
        struct declaration_specifier * item;

        attribute_specifier_sequence_delete(p->p_attribute_specifier_sequence_opt);
        item = p->head;
        while (item)
        {
            struct declaration_specifier * next;

            next = item->next;
            item->next = 0U;
            declaration_specifier_delete(item);
            item = next;
        }
        free(p);
    }
}

void declaration_specifiers_add(struct declaration_specifiers * list, struct declaration_specifier * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

struct declaration_specifier *declaration_specifier(struct parser_ctx * ctx);
struct attribute_specifier_sequence *attribute_specifier_sequence_opt(struct parser_ctx * ctx);

struct declaration_specifiers *declaration_specifiers(struct parser_ctx * ctx, int default_storage_flag)
{
    struct declaration_specifiers * p_declaration_specifiers;

    if (ctx->current == 0U)
    {
        return 0U;
    }
    p_declaration_specifiers = calloc(1, 64U);
    if (1) /*try*/
    {
        struct token * prev;

        if (p_declaration_specifiers == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_declaration_specifiers->first_token = ctx->current;
        while (first_of_declaration_specifier(ctx))
        {
            struct declaration_specifier * p_declaration_specifier;

            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL1;/*throw*/
            }
            if (ctx->current->flags & 16)
            {
                if (p_declaration_specifiers->type_specifier_flags != 0)
                {
                    break;
                }
            }
            p_declaration_specifier = declaration_specifier(ctx);
            if (p_declaration_specifier == 0U)
            {
                goto _CKL1;/*throw*/
            }
            if (p_declaration_specifier->type_specifier_qualifier)
            {
                if (p_declaration_specifier->type_specifier_qualifier->type_specifier)
                {
                    if (add_specifier(ctx, &p_declaration_specifiers->type_specifier_flags, p_declaration_specifier->type_specifier_qualifier->type_specifier->flags) != 0)
                    {
                    }
                    if (p_declaration_specifier->type_specifier_qualifier->type_specifier->struct_or_union_specifier)
                    {
                        p_declaration_specifiers->struct_or_union_specifier = p_declaration_specifier->type_specifier_qualifier->type_specifier->struct_or_union_specifier;
                    }
                    else
                    {
                        if (p_declaration_specifier->type_specifier_qualifier->type_specifier->enum_specifier)
                        {
                            p_declaration_specifiers->enum_specifier = p_declaration_specifier->type_specifier_qualifier->type_specifier->enum_specifier;
                        }
                        else
                        {
                            if (p_declaration_specifier->type_specifier_qualifier->type_specifier->typeof_specifier)
                            {
                                p_declaration_specifiers->typeof_specifier = p_declaration_specifier->type_specifier_qualifier->type_specifier->typeof_specifier;
                            }
                            else
                            {
                                if (p_declaration_specifier->type_specifier_qualifier->type_specifier->msvc_declspec)
                                {
                                    p_declaration_specifiers->msvc_declspec_flags = p_declaration_specifier->type_specifier_qualifier->type_specifier->msvc_declspec->flags;
                                }
                                else
                                {
                                    if (p_declaration_specifier->type_specifier_qualifier->type_specifier->token->type == 8996)
                                    {
                                        p_declaration_specifiers->typedef_declarator = find_declarator(ctx, p_declaration_specifier->type_specifier_qualifier->type_specifier->token->lexeme, 0U);
                                    }
                                }
                            }
                        }
                    }
                }
                else
                {
                    if (p_declaration_specifier->type_specifier_qualifier->alignment_specifier)
                    {
                        p_declaration_specifiers->alignment_specifier_flags = p_declaration_specifier->type_specifier_qualifier->alignment_specifier->flags;
                    }
                    else
                    {
                        if (p_declaration_specifier->type_specifier_qualifier->type_qualifier)
                        {
                            p_declaration_specifiers->type_qualifier_flags |= p_declaration_specifier->type_specifier_qualifier->type_qualifier->flags;
                        }
                    }
                }
            }
            else
            {
                if (p_declaration_specifier->storage_class_specifier)
                {
                    p_declaration_specifiers->storage_class_specifier_flags |= p_declaration_specifier->storage_class_specifier->flags;
                }
                else
                {
                    if (p_declaration_specifier->function_specifier)
                    {
                        p_declaration_specifiers->function_specifier_flags |= p_declaration_specifier->function_specifier->flags;
                    }
                    else
                    {
                        if (p_declaration_specifier->alignment_specifier)
                        {
                            p_declaration_specifiers->alignment_specifier_flags |= p_declaration_specifier->alignment_specifier->flags;
                        }
                    }
                }
            }
            declaration_specifiers_add(p_declaration_specifiers, p_declaration_specifier);
            ;
            p_declaration_specifiers->p_attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL1;/*throw*/
            }
            if (ctx->current->type == 8996 && p_declaration_specifiers->type_specifier_flags != 0)
            {
                break;
            }
        }
        prev = previous_parser_token(ctx->current);
        if (prev == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_declaration_specifiers->last_token = prev;
        final_specifier(ctx, &p_declaration_specifiers->type_specifier_flags);
        p_declaration_specifiers->storage_class_specifier_flags |= default_storage_flag;
        if (p_declaration_specifiers->storage_class_specifier_flags & 4)
        {
            p_declaration_specifiers->storage_class_specifier_flags &= -4097;
        }
    }
    else _CKL1: /*catch*/ 
    {
        declaration_specifiers_delete(p_declaration_specifiers);
        p_declaration_specifiers = 0U;
    }
    return p_declaration_specifiers;
}

struct static_assert_declaration *static_assert_declaration(struct parser_ctx * ctx);
struct pragma_declaration *pragma_declaration(struct parser_ctx * ctx);
struct init_declarator_list init_declarator_list(struct parser_ctx * ctx, struct declaration_specifiers * p_declaration_specifiers);
void declaration_delete(struct declaration * p);

struct declaration *declaration_core(struct parser_ctx * ctx, struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt, unsigned char   can_be_function_definition, unsigned char  * is_function_definition, int default_storage_class_specifier_flags, unsigned char   without_semicolon)
{
    struct declaration * p_declaration;

    p_declaration = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_declaration = calloc(1, 52U);
        if (p_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_declaration->p_attribute_specifier_sequence_opt = p_attribute_specifier_sequence_opt;
        p_attribute_specifier_sequence_opt = 0U;
        p_declaration->first_token = ctx->current;
        if (ctx->current->type == 59)
        {
            p_declaration->last_token = ctx->current;
            parser_match(ctx);
            return p_declaration;
        }
        if (first_of_static_assert_declaration(ctx))
        {
            p_declaration->static_assert_declaration = static_assert_declaration(ctx);
        }
        else
        {
            if (first_of_pragma_declaration(ctx))
            {
                p_declaration->pragma_declaration = pragma_declaration(ctx);
            }
            else
            {
                if (first_of_declaration_specifier(ctx))
                {
                    p_declaration->declaration_specifiers = declaration_specifiers(ctx, default_storage_class_specifier_flags);
                    if (p_declaration->declaration_specifiers == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    if (p_declaration->p_attribute_specifier_sequence_opt)
                    {
                        p_declaration->declaration_specifiers->attributes_flags = p_declaration->p_attribute_specifier_sequence_opt->attributes_flags;
                    }
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL0;/*throw*/
                    }
                    if (ctx->current->type != 59)
                    {
                        p_declaration->init_declarator_list = init_declarator_list(ctx, p_declaration->declaration_specifiers);
                        if (p_declaration->init_declarator_list.head == 0U)
                        {
                            goto _CKL0;/*throw*/
                        }
                    }
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL0;/*throw*/
                    }
                    p_declaration->last_token = ctx->current;
                    if (ctx->current->type == 123)
                    {
                        if (can_be_function_definition)
                        {
                            *is_function_definition = 1;
                        }
                    }
                    else
                    {
                        if (ctx->current->type == 9065 || ctx->current->type == 9066 || ctx->current->type == 8996)
                        {
                            if (can_be_function_definition)
                            {
                                *is_function_definition = 1;
                            }
                        }
                        else
                        {
                            if (!without_semicolon && parser_match_tk(ctx, 59) != 0)
                            {
                                goto _CKL0;/*throw*/
                            }
                        }
                    }
                }
                else
                {
                    if (ctx->current->type == 8996)
                    {
                        compiler_diagnostic(860, ctx, ctx->current, 0U, "invalid type '%s'", ctx->current->lexeme);
                    }
                    else
                    {
                        compiler_diagnostic(990, ctx, ctx->current, 0U, "expected declaration not '%s'", ctx->current->lexeme);
                    }
                    parser_match(ctx);
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        declaration_delete(p_declaration);
        p_declaration = 0U;
    }
    attribute_specifier_sequence_delete(p_attribute_specifier_sequence_opt);
    return p_declaration;
}

struct declaration *declaration(struct parser_ctx * ctx, struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt, int storage_specifier_flags, unsigned char   extern_declaration);

struct declaration *function_definition_or_declaration(struct parser_ctx * ctx)
{
    return declaration(ctx, 0U, 0, 1);
}

void simple_declaration_delete(struct simple_declaration * p);

struct simple_declaration *simple_declaration(struct parser_ctx * ctx, struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt, unsigned char   ignore_semicolon)
{
    int storage_specifier_flags;
    struct simple_declaration * p_simple_declaration;

    if (ctx->current == 0U)
    {
        unexpected_end_of_file(ctx);
        attribute_specifier_sequence_delete(p_attribute_specifier_sequence_opt);
        return 0U;
    }
    storage_specifier_flags = 4096;
    p_simple_declaration = calloc(1, 24U);
    if (1) /*try*/
    {
        struct declaration_specifiers * ptemp;
        struct token * prev;

        if (p_simple_declaration == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_simple_declaration->first_token = ctx->current;
        p_simple_declaration->p_attribute_specifier_sequence_opt = p_attribute_specifier_sequence_opt;
        p_attribute_specifier_sequence_opt = 0U;
        ptemp = declaration_specifiers(ctx, storage_specifier_flags);
        if (ptemp == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_simple_declaration->p_declaration_specifiers = ptemp;
        if (p_simple_declaration->p_attribute_specifier_sequence_opt)
        {
            p_simple_declaration->p_declaration_specifiers->attributes_flags = p_simple_declaration->p_attribute_specifier_sequence_opt->attributes_flags;
        }
        p_simple_declaration->init_declarator_list = init_declarator_list(ctx, p_simple_declaration->p_declaration_specifiers);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL1;/*throw*/
        }
        prev = previous_parser_token(ctx->current);
        if (prev == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_simple_declaration->last_token = prev;
        if (!ignore_semicolon && parser_match_tk(ctx, 59) != 0)
        {
            goto _CKL1;/*throw*/
        }
    }
    else _CKL1: /*catch*/ 
    {
        simple_declaration_delete(p_simple_declaration);
        p_simple_declaration = 0U;
    }
    attribute_specifier_sequence_delete(p_attribute_specifier_sequence_opt);
    return p_simple_declaration;
}

unsigned char  type_is_maybe_unused(struct type * p_type);

static void check_unused_parameters(struct parser_ctx * ctx, struct parameter_list * parameter_list)
{
    struct parameter_declaration * parameter;

    parameter = 0U;
    parameter = parameter_list->head;
    while (parameter)
    {
        if (!type_is_maybe_unused(&parameter->declarator->type) && parameter->declarator && parameter->declarator->num_uses == 0)
        {
            if (parameter->declarator->name_opt && parameter->declarator->name_opt->level == 0)
            {
                compiler_diagnostic(5, ctx, parameter->declarator->name_opt, 0U, "'%s': unreferenced formal parameter", parameter->declarator->name_opt->lexeme);
            }
        }
        parameter = parameter->next;
    }
}

void defer_start_visit_declaration(struct defer_visit_ctx * ctx, struct declaration * p_declaration);
void defer_visit_ctx_destroy(struct defer_visit_ctx * p);
void flow_start_visit_declaration(struct flow_visit_ctx * ctx, struct declaration * p_declaration);
void flow_visit_ctx_destroy(struct flow_visit_ctx * p);

struct declaration *declaration(struct parser_ctx * ctx, struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt00, int storage_specifier_flags, unsigned char   extern_declaration)
{
    struct declaration * p_declaration;

    p_declaration = 0U;
    if (1) /*try*/
    {
        struct attribute_specifier_sequence * p_attribute_specifier_sequence_opt;
        unsigned char   is_function_definition;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        is_function_definition = 0;
        p_declaration = declaration_core(ctx, p_attribute_specifier_sequence_opt, 1, &is_function_definition, storage_specifier_flags, 0);
        if (p_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (is_function_definition)
        {
            struct declarator * p_declarator;
            struct declarator * inner;
            struct diagnostic  before_function_diagnostics;
            struct declarator * p_current_function_opt;
            struct scope * parameters_scope;
            struct scope * p_current_function_scope_opt;
            struct compound_statement * p_function_body;

            if (p_declaration->init_declarator_list.head == 0U || p_declaration->init_declarator_list.head->p_declarator->direct_declarator == 0U || p_declaration->init_declarator_list.head->p_declarator->direct_declarator->function_declarator == 0U)
            {
                compiler_diagnostic(650, ctx, ctx->current, 0U, "unexpected");
                goto _CKL0;/*throw*/
            }
            p_declarator = p_declaration->init_declarator_list.head->p_declarator;
            ;
            inner = p_declaration->init_declarator_list.head->p_declarator;
            for (; ; )
            {
                if (inner->direct_declarator && inner->direct_declarator->function_declarator && inner->direct_declarator->function_declarator->direct_declarator && inner->direct_declarator->function_declarator->direct_declarator->declarator)
                {
                    inner = inner->direct_declarator->function_declarator->direct_declarator->declarator;
                }
                else
                {
                    break;
                }
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            check_func_open_brace_style(ctx, ctx->current);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            before_function_diagnostics = ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index];
            if (ctx->current->type == 9065 || ctx->current->type == 9066 || ctx->current->type == 8996)
            {
                for (; ; )
                {
                    int type;

                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL0;/*throw*/
                    }
                    type = ctx->current->type;
                    if (type != 9065 && type != 9066 && type != 8996)
                    {
                        goto _CKL0;/*throw*/
                    }
                    parser_match(ctx);
                    parser_match(ctx);
                    if (type != 9066)
                    {
                        ;
                        p_declarator->p_expression_true = expression(ctx);
                    }
                    else
                    {
                        ;
                        p_declarator->p_expression_false = expression(ctx);
                    }
                    parser_match(ctx);
                    if (ctx->current == 0U)
                    {
                        unexpected_end_of_file(ctx);
                        goto _CKL0;/*throw*/
                    }
                    if (ctx->current->type != 44)
                    {
                        break;
                    }
                    parser_match(ctx);
                }
            }
            p_current_function_opt = ctx->p_current_function_opt;
            ctx->p_current_function_opt = p_declarator;
            parameters_scope = &inner->direct_declarator->function_declarator->parameters_scope;
            scope_list_push(&ctx->scopes, parameters_scope);
            p_current_function_scope_opt = ctx->p_current_function_scope_opt;
            ctx->p_current_function_scope_opt = ctx->scopes.tail;
            p_function_body = function_body(ctx);
            ctx->p_current_function_scope_opt = p_current_function_scope_opt;
            ctx->p_current_function_opt = p_current_function_opt;
            scope_list_pop(&ctx->scopes);
            if (p_function_body == 0U)
            {
                goto _CKL0;/*throw*/
            }
            ;
            p_declaration->function_body = p_function_body;
            p_declaration->init_declarator_list.head->p_declarator->function_body = p_declaration->function_body;
            if (p_declaration->init_declarator_list.head && p_declaration->init_declarator_list.head->p_declarator->direct_declarator && p_declaration->init_declarator_list.head->p_declarator->direct_declarator->function_declarator && p_declaration->init_declarator_list.head->p_declarator->direct_declarator->function_declarator->parameter_type_list_opt && p_declaration->init_declarator_list.head->p_declarator->direct_declarator->function_declarator->parameter_type_list_opt->parameter_list)
            {
                check_unused_parameters(ctx, p_declaration->init_declarator_list.head->p_declarator->direct_declarator->function_declarator->parameter_type_list_opt->parameter_list);
            }
            if (extern_declaration)
            {
                struct defer_visit_ctx  ctx2;

                ctx2.catch_secondary_block_opt = 0;
                ctx2.ctx = ctx;
                ctx2.ast.token_list.head = 0;
                ctx2.ast.token_list.tail = 0;
                ctx2.ast.declaration_list.head = 0;
                ctx2.ast.declaration_list.tail = 0;
                ctx2.tail_block = 0;
                ctx2.parameter_list = 0;
                defer_start_visit_declaration(&ctx2, p_declaration);
                defer_visit_ctx_destroy(&ctx2);
                if (ctx->options.flow_analysis)
                {
                    struct flow_visit_ctx  ctx3;

                    ctx->options.diagnostic_stack.stack[ctx->options.diagnostic_stack.top_index] = before_function_diagnostics;
                    _cake_zmem(&ctx3, 868);
                    ctx3.ctx = ctx;
                    flow_start_visit_declaration(&ctx3, p_declaration);
                    flow_visit_ctx_destroy(&ctx3);
                }
            }
        }
        else
        {
            if (ctx->options.flow_analysis && extern_declaration)
            {
                struct flow_visit_ctx  ctx2;

                _cake_zmem(&ctx2, 868);
                ctx2.ctx = ctx;
                flow_start_visit_declaration(&ctx2, p_declaration);
                flow_visit_ctx_destroy(&ctx2);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        declaration_delete(p_declaration);
        p_declaration = 0U;
    }
    return p_declaration;
}

void type_specifier_qualifier_delete(struct type_specifier_qualifier * p);

void declaration_specifier_delete(struct declaration_specifier * p)
{
    if (p)
    {
        free(p->function_specifier);
        type_specifier_qualifier_delete(p->type_specifier_qualifier);
        free(p->storage_class_specifier);
        ;
        free(p);
    }
}

struct storage_class_specifier *storage_class_specifier(struct parser_ctx * ctx);
struct type_specifier_qualifier *type_specifier_qualifier(struct parser_ctx * ctx);
struct function_specifier *function_specifier(struct parser_ctx * ctx);

struct declaration_specifier *declaration_specifier(struct parser_ctx * ctx)
{
    struct declaration_specifier * p_declaration_specifier;

    p_declaration_specifier = 0U;
    if (1) /*try*/
    {
        p_declaration_specifier = calloc(1, 20U);
        if (p_declaration_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (first_of_storage_class_specifier(ctx))
        {
            p_declaration_specifier->storage_class_specifier = storage_class_specifier(ctx);
            if (p_declaration_specifier->storage_class_specifier == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            if (first_of_type_specifier_qualifier(ctx))
            {
                p_declaration_specifier->type_specifier_qualifier = type_specifier_qualifier(ctx);
                if (p_declaration_specifier->type_specifier_qualifier == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            else
            {
                if (first_of_function_specifier(ctx))
                {
                    p_declaration_specifier->function_specifier = function_specifier(ctx);
                    if (p_declaration_specifier->function_specifier == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                else
                {
                    compiler_diagnostic(650, ctx, ctx->current, 0U, "unexpected");
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        declaration_specifier_delete(p_declaration_specifier);
        p_declaration_specifier = 0U;
    }
    return p_declaration_specifier;
}

struct init_declarator *init_declarator_add_ref(struct init_declarator * p)
{
    p->has_shared_ownership = 1;
    return (struct init_declarator *)p;
}

void init_declarator_sink(struct init_declarator * p)
{
}

void initializer_delete(struct initializer * p);

void init_declarator_delete(struct init_declarator * p)
{
    if (p)
    {
        if (p->has_shared_ownership)
        {
            p->has_shared_ownership = 0;
            init_declarator_sink(p);
            return;
        }
        initializer_delete(p->initializer);
        declarator_delete(p->p_declarator);
        ;
        free(p);
    }
}

struct declarator *declarator(struct parser_ctx * ctx, struct specifier_qualifier_list * specifier_qualifier_list, struct declaration_specifiers * declaration_specifiers, unsigned char   abstract_acceptable, struct token ** pptokenname);
void naming_convention_global_var(struct parser_ctx * ctx, struct token * token, struct type * type, int storage);
void print_type_no_names(struct osstream * ss, struct type * p_type);
struct initializer *initializer(struct parser_ctx * ctx);
void type_remove_names(struct type * p_type);
void type_set_qualifiers_using_declarator(struct type * p_type, struct declarator * pdeclarator);
void type_visit_to_mark_anonymous(struct type * p_type);

struct init_declarator *init_declarator(struct parser_ctx * ctx, struct declaration_specifiers * p_declaration_specifiers)
{
    struct init_declarator * p_init_declarator;

    p_init_declarator = 0U;
    if (1) /*try*/
    {
        struct token * tkname;
        char * name;
        struct scope * out_scope;
        struct declarator * previous;

        p_init_declarator = calloc(1, 16U);
        if (p_init_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        tkname = 0U;
        {
            struct declarator * p_temp_declarator;

            p_temp_declarator = declarator(ctx, 0U, p_declaration_specifiers, 0, &tkname);
            if (p_temp_declarator == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_init_declarator->p_declarator = p_temp_declarator;
        }
        if (tkname == 0U)
        {
            compiler_diagnostic(650, ctx, ctx->current, 0U, "init declarator must have a name");
            goto _CKL0;/*throw*/
        }
        p_init_declarator->p_declarator->declaration_specifiers = p_declaration_specifiers;
        p_init_declarator->p_declarator->name_opt = tkname;
        if (p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 16)
        {
        }
        else
        {
            ;
            p_init_declarator->p_declarator->type = make_type_using_declarator(ctx, p_init_declarator->p_declarator);
        }
        ;
        ;
        if (ctx->scopes.tail->scope_level == 0)
        {
            naming_convention_global_var(ctx, tkname, &p_init_declarator->p_declarator->type, p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags);
        }
        name = p_init_declarator->p_declarator->name_opt->lexeme;
        out_scope = 0U;
        previous = find_declarator(ctx, name, &out_scope);
        if (previous)
        {
            ;
            ;
            if (out_scope->scope_level == ctx->scopes.tail->scope_level)
            {
                if (out_scope->scope_level == 0)
                {
                    if (strcmp(name, "__C_ASSERT__") != 0)
                    {
                        if (!type_is_same(&previous->type, &p_init_declarator->p_declarator->type, 0))
                        {
                            struct osstream  ss;

                            _cake_zmem(&ss, 12);
                            print_type_no_names(&ss, &previous->type);
                            compiler_diagnostic(1020, ctx, ctx->current, 0U, "conflicting types for '%s' (%s)", name, ss.c_str);
                            ss_clear(&ss);
                            print_type_no_names(&ss, &p_init_declarator->p_declarator->type);
                            compiler_diagnostic(1020, ctx, previous->name_opt, 0U, "previous declaration (%s)", ss.c_str);
                            ss_close(&ss);
                        }
                    }
                }
                else
                {
                    compiler_diagnostic(1020, ctx, ctx->current, 0U, "redeclaration");
                    compiler_diagnostic(63, ctx, previous->name_opt, 0U, "previous declaration");
                }
            }
            else
            {
                struct hash_item_set  item;

                _cake_zmem(&item, 32);
                item.p_init_declarator = init_declarator_add_ref(p_init_declarator);
                hashmap_set(&ctx->scopes.tail->variables, name, &item);
                hash_item_set_destroy(&item);
                if (out_scope->scope_level != 0)
                {
                    if (compiler_diagnostic(6, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "declaration of '%s' hides previous declaration", name))
                    {
                        compiler_diagnostic(63, ctx, previous->first_token_opt, 0U, "previous declaration is here");
                    }
                }
            }
        }
        else
        {
            struct hash_item_set  item;

            _cake_zmem(&item, 32);
            item.p_init_declarator = init_declarator_add_ref(p_init_declarator);
            hashmap_set(&ctx->scopes.tail->variables, name, &item);
            hash_item_set_destroy(&item);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 61)
        {
            unsigned char   requires_constant_initialization;

            requires_constant_initialization = !!((ctx->p_current_function_opt == 0U) || (p_declaration_specifiers->storage_class_specifier_flags & 4));
            parser_match(ctx);
            ;
            p_init_declarator->initializer = initializer(ctx);
            if (p_init_declarator->initializer == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (p_init_declarator->initializer->braced_initializer)
            {
                int er;
                unsigned char   is_constant;

                if (p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 16)
                {
                    compiler_diagnostic(1290, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "'auto' requires a plain identifier");
                    goto _CKL0;/*throw*/
                }
                er = make_object(&p_init_declarator->p_declarator->type, &p_init_declarator->p_declarator->object);
                if (er != 0)
                {
                    compiler_diagnostic(740, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "incomplete struct/union type");
                    goto _CKL0;/*throw*/
                }
                is_constant = !!(type_is_const(&p_init_declarator->p_declarator->type) || p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 64);
                if (initializer_init_new(ctx, &p_init_declarator->p_declarator->type, &p_init_declarator->p_declarator->object, p_init_declarator->initializer, is_constant, requires_constant_initialization) != 0)
                {
                    goto _CKL0;/*throw*/
                }
                p_init_declarator->p_declarator->object.type.num_of_elements = p_init_declarator->p_declarator->type.num_of_elements;
            }
            else
            {
                if (p_init_declarator->initializer->assignment_expression)
                {
                    char * name2;
                    int er;
                    unsigned char   is_constant;

                    if (type_is_array(&p_init_declarator->p_declarator->type))
                    {
                        unsigned long long array_size_elements;

                        array_size_elements = p_init_declarator->p_declarator->type.num_of_elements;
                        if (array_size_elements == 0)
                        {
                            p_init_declarator->p_declarator->type.num_of_elements = p_init_declarator->initializer->assignment_expression->type.num_of_elements;
                        }
                        else
                        {
                            if (p_init_declarator->initializer->assignment_expression->type.num_of_elements > array_size_elements)
                            {
                                if (p_init_declarator->p_declarator->first_token_opt)
                                {
                                    compiler_diagnostic(51, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "initializer for array is too long");
                                }
                            }
                        }
                    }
                    ;
                    if (p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 16)
                    {
                        struct type  t;

                        if (p_init_declarator->p_declarator->direct_declarator && (p_init_declarator->p_declarator->direct_declarator->array_declarator != 0U || p_init_declarator->p_declarator->direct_declarator->function_declarator != 0U))
                        {
                            compiler_diagnostic(1290, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "'auto' requires a plain identifier");
                            goto _CKL0;/*throw*/
                        }
                        if (p_init_declarator->p_declarator->pointer != 0U)
                        {
                            compiler_diagnostic(1290, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "'auto' requires a plain identifier");
                        }
                        _cake_zmem(&t, 68);
                        if (p_init_declarator->initializer->assignment_expression->expression_type == 33)
                        {
                            t = type_dup(&p_init_declarator->initializer->assignment_expression->type);
                        }
                        else
                        {
                            struct type  t2;

                            t2 = type_lvalue_conversion(&p_init_declarator->initializer->assignment_expression->type, ctx->options.null_checks_enabled);
                            type_swap(&t2, &t);
                            type_destroy(&t2);
                        }
                        type_remove_names(&t);
                        ;
                        t.name_opt = strdup(p_init_declarator->p_declarator->name_opt->lexeme);
                        type_set_qualifiers_using_declarator(&t, p_init_declarator->p_declarator);
                        type_visit_to_mark_anonymous(&t);
                        type_swap(&p_init_declarator->p_declarator->type, &t);
                        type_destroy(&t);
                    }
                    check_assigment(ctx, &p_init_declarator->p_declarator->type, p_init_declarator->initializer->assignment_expression, 3);
                    name2 = p_init_declarator->p_declarator->name_opt ? p_init_declarator->p_declarator->name_opt->lexeme : "";
                    er = make_object_with_name(&p_init_declarator->p_declarator->type, &p_init_declarator->p_declarator->object, name2);
                    if (er != 0)
                    {
                        goto _CKL0;/*throw*/
                    }
                    is_constant = !!(type_is_const(&p_init_declarator->p_declarator->type) || p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 64);
                    if (initializer_init_new(ctx, &p_init_declarator->p_declarator->type, &p_init_declarator->p_declarator->object, p_init_declarator->initializer, is_constant, requires_constant_initialization) != 0)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
            }
        }
        else
        {
            if (p_init_declarator->p_declarator->type.category != 1 && !(p_init_declarator->p_declarator->type.storage_class_specifier_flags & 1))
            {
                char * name2;
                int er;

                name2 = p_init_declarator->p_declarator->name_opt ? p_init_declarator->p_declarator->name_opt->lexeme : "";
                er = make_object_with_name(&p_init_declarator->p_declarator->type, &p_init_declarator->p_declarator->object, name2);
                if (er != 0)
                {
                    if (p_init_declarator->p_declarator->declaration_specifiers->storage_class_specifier_flags & 2)
                    {
                    }
                    else
                    {
                        compiler_diagnostic(740, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "incomplete struct/union type");
                        goto _CKL0;/*throw*/
                    }
                }
                if (type_is_const(&p_init_declarator->p_declarator->type))
                {
                    if (p_declaration_specifiers->storage_class_specifier_flags & 1)
                    {
                    }
                    else
                    {
                        compiler_diagnostic(47, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "const object should be initialized");
                    }
                }
            }
        }
        if (p_init_declarator->p_declarator)
        {
            if (type_is_array(&p_init_declarator->p_declarator->type))
            {
                if (p_init_declarator->p_declarator->type.type_qualifier_flags != 0 || p_init_declarator->p_declarator->type.has_static_array_size)
                {
                    if (p_init_declarator->p_declarator->first_token_opt)
                    {
                        compiler_diagnostic(1000, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "static or type qualifiers are not allowed in non-parameter array declarator");
                    }
                    else
                    {
                        if (p_init_declarator->initializer)
                        {
                            compiler_diagnostic(1000, ctx, p_init_declarator->initializer->first_token, 0U, "static or type qualifiers are not allowed in non-parameter array declarator");
                        }
                    }
                }
            }
            if (!type_is_pointer(&p_init_declarator->p_declarator->type) && p_init_declarator->p_declarator->type.type_qualifier_flags & 128)
            {
                if (p_init_declarator->p_declarator->first_token_opt)
                {
                    compiler_diagnostic(1010, ctx, p_init_declarator->p_declarator->first_token_opt, 0U, "_Dtor qualifier can only be used with pointers");
                }
                else
                {
                    if (p_init_declarator->initializer)
                    {
                        compiler_diagnostic(1010, ctx, p_init_declarator->initializer->first_token, 0U, "_Dtor qualifier can only be used with pointers");
                    }
                }
            }
        }
        if (!(p_init_declarator->p_declarator->type.storage_class_specifier_flags & 1) && !type_is_function(&p_init_declarator->p_declarator->type))
        {
            if (type_is_vla(&p_init_declarator->p_declarator->type))
            {
            }
            else
            {
                if (type_is_function(&p_init_declarator->p_declarator->type))
                {
                    compiler_diagnostic(1270, ctx, p_init_declarator->p_declarator->name_opt, 0U, "invalid application of 'sizeof' to a function type");
                }
                else
                {
                    unsigned int sz;
                    int size_result;

                    sz = 0;
                    size_result = type_get_sizeof(&p_init_declarator->p_declarator->type, &sz);
                    if (size_result == 0)
                    {
                    }
                    else
                    {
                        if (size_result == 3)
                        {
                            if (p_init_declarator->p_declarator->type.storage_class_specifier_flags & 2)
                            {
                            }
                            else
                            {
                                compiler_diagnostic(1270, ctx, p_init_declarator->p_declarator->name_opt, 0U, "storage size of '%s' isn't known", p_init_declarator->p_declarator->name_opt->lexeme);
                            }
                        }
                        else
                        {
                            if (size_result == 1)
                            {
                                compiler_diagnostic(1270, ctx, p_init_declarator->p_declarator->name_opt, 0U, "sizeof '%s' is too large", p_init_declarator->p_declarator->name_opt->lexeme);
                            }
                            else
                            {
                                compiler_diagnostic(1270, ctx, p_init_declarator->p_declarator->name_opt, 0U, "storage size of '%s' isn't known", p_init_declarator->p_declarator->name_opt->lexeme);
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        init_declarator_delete(p_init_declarator);
        p_init_declarator = 0U;
    }
    return p_init_declarator;
}

void init_declarator_list_add(struct init_declarator_list * list, struct init_declarator * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void init_declarator_list_destroy(struct init_declarator_list * p)
{
    struct init_declarator * item;

    item = p->head;
    while (item)
    {
        struct init_declarator * next;

        next = item->next;
        item->next = 0U;
        init_declarator_delete(item);
        item = next;
    }
}

struct init_declarator_list init_declarator_list(struct parser_ctx * ctx, struct declaration_specifiers * p_declaration_specifiers)
{
    struct init_declarator_list  init_declarator_list;
    struct init_declarator * p_init_declarator;

    _cake_zmem(&init_declarator_list, 8);
    p_init_declarator = 0U;
    if (1) /*try*/
    {
        p_init_declarator = init_declarator(ctx, p_declaration_specifiers);
        if (p_init_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        init_declarator_list_add(&init_declarator_list, p_init_declarator);
        p_init_declarator = 0U;
        while (ctx->current != 0U && ctx->current->type == 44)
        {
            parser_match(ctx);
            p_init_declarator = init_declarator(ctx, p_declaration_specifiers);
            if (p_init_declarator == 0U)
            {
                goto _CKL0;/*throw*/
            }
            init_declarator_list_add(&init_declarator_list, p_init_declarator);
            p_init_declarator = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return init_declarator_list;
}

void storage_class_specifier_delete(struct storage_class_specifier * p)
{
    if (p)
    {
        free(p);
    }
}

struct storage_class_specifier *storage_class_specifier(struct parser_ctx * ctx)
{
    struct storage_class_specifier * p_storage_class_specifier;

    p_storage_class_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_storage_class_specifier = calloc(1, 8U);
        if (p_storage_class_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_storage_class_specifier->token = ctx->current;
        /*switch*/
        {
            register int _R59 = ctx->current->type;
            if (_R59 == 9035) goto _CKL4; /*case 9035*/
            if (_R59 == 9013) goto _CKL5; /*case 9013*/
            if (_R59 == 9002) goto _CKL6; /*case 9002*/
            if (_R59 == 9032) goto _CKL8; /*case 9032*/
            if (_R59 == 9063) goto _CKL9; /*case 9063*/
            if (_R59 == 8999) goto _CKL10; /*case 8999*/
            if (_R59 == 9025) goto _CKL11; /*case 9025*/
            goto _CKL12;/*default*/

            {
                _CKL4:/*case 9035*/ 
                p_storage_class_specifier->flags = 1;
                goto _CKL3; /*break*/

                _CKL5:/*case 9013*/ 
                p_storage_class_specifier->flags = 2;
                goto _CKL3; /*break*/

                _CKL6:/*case 9002*/ 
                p_storage_class_specifier->flags = 64;
                if (ctx->scopes.tail && ctx->scopes.tail->scope_level == 0)
                {
                    p_storage_class_specifier->flags |= 128;
                }
                goto _CKL3; /*break*/

                _CKL8:/*case 9032*/ 
                p_storage_class_specifier->flags = 4;
                goto _CKL3; /*break*/

                _CKL9:/*case 9063*/ 
                p_storage_class_specifier->flags = 8;
                goto _CKL3; /*break*/

                _CKL10:/*case 8999*/ 
                p_storage_class_specifier->flags = 16;
                goto _CKL3; /*break*/

                _CKL11:/*case 9025*/ 
                p_storage_class_specifier->flags = 32;
                goto _CKL3; /*break*/

                _CKL12: /*default*/ 
                ;
            }
            _CKL3:;
        }
        parser_match(ctx);
    }
    else _CKL0: /*catch*/ 
    {
        storage_class_specifier_delete(p_storage_class_specifier);
        p_storage_class_specifier = 0U;
    }
    return p_storage_class_specifier;
}

void typeof_specifier_argument_delete(struct typeof_specifier_argument * p);

struct typeof_specifier_argument *typeof_specifier_argument(struct parser_ctx * ctx)
{
    struct typeof_specifier_argument * new_typeof_specifier_argument;

    new_typeof_specifier_argument = 0U;
    if (1) /*try*/
    {
        new_typeof_specifier_argument = calloc(1, 8U);
        if (new_typeof_specifier_argument == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (first_of_type_name(ctx))
        {
            new_typeof_specifier_argument->type_name = type_name(ctx);
        }
        else
        {
            unsigned char   disable_evaluation_copy;

            disable_evaluation_copy = ctx->evaluation_is_disabled;
            ctx->evaluation_is_disabled = 1;
            new_typeof_specifier_argument->expression = expression(ctx);
            ctx->evaluation_is_disabled = disable_evaluation_copy;
            if (new_typeof_specifier_argument->expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        typeof_specifier_argument_delete(new_typeof_specifier_argument);
        new_typeof_specifier_argument = 0U;
    }
    return new_typeof_specifier_argument;
}

unsigned char  first_of_typeof_specifier(struct parser_ctx * ctx)
{
    if (ctx->current == 0U)
    {
        return 0;
    }
    return !!(ctx->current->type == 9064 || ctx->current->type == 9068);
}

struct type type_param_array_to_pointer(struct type * p_type, unsigned char   null_checks_enabled);
void type_remove_qualifiers(struct type * p_type);
void typeof_specifier_delete(struct typeof_specifier * p);

struct typeof_specifier *typeof_specifier(struct parser_ctx * ctx)
{
    struct typeof_specifier * p_typeof_specifier;

    p_typeof_specifier = 0U;
    if (1) /*try*/
    {
        unsigned char   is_typeof_unqual;
        struct typeof_specifier_argument * p_typeof_specifier_argument;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_typeof_specifier = calloc(1, 80U);
        if (p_typeof_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_typeof_specifier->first_token = ctx->current;
        is_typeof_unqual = !!(ctx->current->type == 9068);
        parser_match(ctx);
        if (parser_match_tk(ctx, 40) != 0)
        {
            goto _CKL0;/*throw*/
        }
        p_typeof_specifier_argument = typeof_specifier_argument(ctx);
        if (p_typeof_specifier_argument == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_typeof_specifier->typeof_specifier_argument = p_typeof_specifier_argument;
        if (p_typeof_specifier->typeof_specifier_argument->expression)
        {
            p_typeof_specifier->type = type_dup(&p_typeof_specifier->typeof_specifier_argument->expression->type);
        }
        else
        {
            if (p_typeof_specifier->typeof_specifier_argument->type_name)
            {
                p_typeof_specifier->type = type_dup(&p_typeof_specifier->typeof_specifier_argument->type_name->abstract_declarator->type);
            }
        }
        if (p_typeof_specifier->type.storage_class_specifier_flags & 2048)
        {
            compiler_diagnostic(7, ctx, ctx->current, 0U, "typeof used in array arguments");
            if (type_is_array(&p_typeof_specifier->type))
            {
                struct type  t;

                t = type_param_array_to_pointer(&p_typeof_specifier->type, ctx->options.null_checks_enabled);
                type_swap(&t, &p_typeof_specifier->type);
                type_destroy(&t);
            }
        }
        if (is_typeof_unqual)
        {
            type_remove_qualifiers(&p_typeof_specifier->type);
        }
        type_visit_to_mark_anonymous(&p_typeof_specifier->type);
        free((void *)p_typeof_specifier->type.name_opt);
        p_typeof_specifier->type.name_opt = 0U;
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_typeof_specifier->last_token = ctx->current;
        if (parser_match_tk(ctx, 41) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        typeof_specifier_delete(p_typeof_specifier);
        p_typeof_specifier = 0U;
    }
    return p_typeof_specifier;
}

void typeof_specifier_argument_delete(struct typeof_specifier_argument * p)
{
    if (p)
    {
        expression_delete(p->expression);
        type_name_delete(p->type_name);
        free(p);
    }
}

void typeof_specifier_delete(struct typeof_specifier * p)
{
    if (p)
    {
        typeof_specifier_argument_delete(p->typeof_specifier_argument);
        type_destroy(&p->type);
        free(p);
    }
}

void atomic_type_specifier_delete(struct atomic_type_specifier * p);

void type_specifier_delete(struct type_specifier * p)
{
    if (p)
    {
        struct_or_union_specifier_delete(p->struct_or_union_specifier);
        typeof_specifier_delete(p->typeof_specifier);
        enum_specifier_delete(p->enum_specifier);
        atomic_type_specifier_delete(p->atomic_type_specifier);
        free(p);
    }
}

void msvc_declspec_delete(struct msvc_declspec * p);

struct msvc_declspec *extended_decl_modifier_seq(struct parser_ctx * ctx)
{
    struct msvc_declspec * p_type_specifier;

    p_type_specifier = 0U;
    if (1) /*try*/
    {
        int count;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_type_specifier = calloc(1, 8U);
        if (p_type_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_type_specifier->token = ctx->current;
        parser_match(ctx);
        if (strcmp(p_type_specifier->token->lexeme, "align") == 0)
        {
            int a;

            parser_match(ctx);
            a = atoi(ctx->current->lexeme);
            if (a == 8)
            {
                p_type_specifier->flags = p_type_specifier->flags | 2;
            }
            else
            {
                if (a == 16)
                {
                    p_type_specifier->flags = p_type_specifier->flags | 4;
                }
                else
                {
                    if (a == 32)
                    {
                        p_type_specifier->flags = p_type_specifier->flags | 8;
                    }
                    else
                    {
                        if (a == 64)
                        {
                            p_type_specifier->flags = p_type_specifier->flags | 16;
                        }
                    }
                }
            }
            parser_match(ctx);
            parser_match(ctx);
        }
        else
        {
            if (strcmp(p_type_specifier->token->lexeme, "allocate") == 0)
            {
                p_type_specifier->flags = p_type_specifier->flags | 32;
            }
            else
            {
                if (strcmp(p_type_specifier->token->lexeme, "allocator") == 0)
                {
                    p_type_specifier->flags = p_type_specifier->flags | 64;
                }
                else
                {
                    if (strcmp(p_type_specifier->token->lexeme, "appdomain") == 0)
                    {
                        p_type_specifier->flags = p_type_specifier->flags | 128;
                    }
                    else
                    {
                        if (strcmp(p_type_specifier->token->lexeme, "code_seg") == 0)
                        {
                            p_type_specifier->flags = p_type_specifier->flags | 256;
                        }
                        else
                        {
                            if (strcmp(p_type_specifier->token->lexeme, "deprecated") == 0)
                            {
                                p_type_specifier->flags = p_type_specifier->flags | 512;
                            }
                            else
                            {
                                if (strcmp(p_type_specifier->token->lexeme, "dllimport") == 0)
                                {
                                    p_type_specifier->flags = p_type_specifier->flags | 1024;
                                }
                                else
                                {
                                    if (strcmp(p_type_specifier->token->lexeme, "dllexport") == 0)
                                    {
                                        p_type_specifier->flags = p_type_specifier->flags | 2048;
                                    }
                                    else
                                    {
                                        if (strcmp(p_type_specifier->token->lexeme, "hybrid_patchable") == 0)
                                        {
                                        }
                                        else
                                        {
                                            if (strcmp(p_type_specifier->token->lexeme, "no_init_all") == 0)
                                            {
                                            }
                                            else
                                            {
                                                if (strcmp(p_type_specifier->token->lexeme, "jitintrinsic") == 0)
                                                {
                                                }
                                                else
                                                {
                                                    if (strcmp(p_type_specifier->token->lexeme, "intrin_type") == 0)
                                                    {
                                                    }
                                                    else
                                                    {
                                                        if (strcmp(p_type_specifier->token->lexeme, "naked") == 0)
                                                        {
                                                        }
                                                        else
                                                        {
                                                            if (strcmp(p_type_specifier->token->lexeme, "noalias") == 0)
                                                            {
                                                            }
                                                            else
                                                            {
                                                                if (strcmp(p_type_specifier->token->lexeme, "noinline") == 0)
                                                                {
                                                                }
                                                                else
                                                                {
                                                                    if (strcmp(p_type_specifier->token->lexeme, "noreturn") == 0)
                                                                    {
                                                                    }
                                                                    else
                                                                    {
                                                                        if (strcmp(p_type_specifier->token->lexeme, "nothrow") == 0)
                                                                        {
                                                                        }
                                                                        else
                                                                        {
                                                                            if (strcmp(p_type_specifier->token->lexeme, "novtable") == 0)
                                                                            {
                                                                            }
                                                                            else
                                                                            {
                                                                                if (strcmp(p_type_specifier->token->lexeme, "no_sanitize_address") == 0)
                                                                                {
                                                                                }
                                                                                else
                                                                                {
                                                                                    if (strcmp(p_type_specifier->token->lexeme, "process") == 0)
                                                                                    {
                                                                                    }
                                                                                    else
                                                                                    {
                                                                                        if (strcmp(p_type_specifier->token->lexeme, "property") == 0)
                                                                                        {
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            if (strcmp(p_type_specifier->token->lexeme, "restrict") == 0)
                                                                                            {
                                                                                            }
                                                                                            else
                                                                                            {
                                                                                                if (strcmp(p_type_specifier->token->lexeme, "safebuffers") == 0)
                                                                                                {
                                                                                                }
                                                                                                else
                                                                                                {
                                                                                                    if (strcmp(p_type_specifier->token->lexeme, "selectany") == 0)
                                                                                                    {
                                                                                                        p_type_specifier->flags = p_type_specifier->flags | 67108864;
                                                                                                    }
                                                                                                    else
                                                                                                    {
                                                                                                        if (strcmp(p_type_specifier->token->lexeme, "thread") == 0)
                                                                                                        {
                                                                                                            p_type_specifier->flags = p_type_specifier->flags | 67108864;
                                                                                                        }
                                                                                                        else
                                                                                                        {
                                                                                                            if (strcmp(p_type_specifier->token->lexeme, "uuid") == 0)
                                                                                                            {
                                                                                                                p_type_specifier->flags = p_type_specifier->flags | 536870912;
                                                                                                            }
                                                                                                            else
                                                                                                            {
                                                                                                                compiler_diagnostic(8, ctx, p_type_specifier->token, 0U, "unknown '%s'\n", p_type_specifier->token->lexeme);
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        count = 1;
        while (ctx->current)
        {
            if (ctx->current->type == 40)
            {
                parser_match(ctx);
                count++;
            }
            else
            {
                if (ctx->current->type == 41)
                {
                    if (count == 1)
                    {
                        break;
                    }
                    count--;
                    parser_match(ctx);
                }
                else
                {
                    parser_match(ctx);
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        msvc_declspec_delete(p_type_specifier);
        p_type_specifier = 0U;
    }
    return p_type_specifier;
}

struct msvc_declspec *msvc_declspec(struct parser_ctx * ctx)
{
    struct msvc_declspec * p_decl_specifier;

    p_decl_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current->type != 9051)
        {
            goto _CKL0;/*throw*/
        }
        parser_match_tk(ctx, 9051);
        parser_match_tk(ctx, 40);
        p_decl_specifier = extended_decl_modifier_seq(ctx);
        parser_match_tk(ctx, 41);
    }
    else _CKL0: /*catch*/ 
    {
        msvc_declspec_delete(p_decl_specifier);
        p_decl_specifier = 0U;
    }
    return p_decl_specifier;
}

void msvc_declspec_delete(struct msvc_declspec * p)
{
    if (p == 0U)
    {
        return;
    }
    free(p);
}

void msvc_declspec_sequence_opt(struct parser_ctx * ctx)
{
    if (1) /*try*/
    {
        for (; ; )
        {
            struct msvc_declspec * p;

            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type != 9051)
            {
                return;
            }
            p = msvc_declspec(ctx);
            msvc_declspec_delete(p);
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
}

struct atomic_type_specifier *atomic_type_specifier(struct parser_ctx * ctx);
struct struct_or_union_specifier *struct_or_union_specifier(struct parser_ctx * ctx);
struct enum_specifier *enum_specifier(struct parser_ctx *);

struct type_specifier *type_specifier(struct parser_ctx * ctx)
{
    struct type_specifier * p_type_specifier;

    p_type_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_type_specifier = calloc(1, 32U);
        if (p_type_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        /*switch*/
        {
            register int _R60 = ctx->current->type;
            if (_R60 == 9040) goto _CKL4; /*case 9040*/
            if (_R60 == 9003) goto _CKL5; /*case 9003*/
            if (_R60 == 9028) goto _CKL6; /*case 9028*/
            if (_R60 == 9019) goto _CKL7; /*case 9019*/
            if (_R60 == 9021) goto _CKL8; /*case 9021*/
            if (_R60 == 9022) goto _CKL9; /*case 9022*/
            if (_R60 == 9023) goto _CKL10; /*case 9023*/
            if (_R60 == 9024) goto _CKL11; /*case 9024*/
            if (_R60 == 9051) goto _CKL12; /*case 9051*/
            if (_R60 == 9020) goto _CKL13; /*case 9020*/
            if (_R60 == 9014) goto _CKL14; /*case 9014*/
            if (_R60 == 9010) goto _CKL15; /*case 9010*/
            if (_R60 == 9029) goto _CKL16; /*case 9029*/
            if (_R60 == 9039) goto _CKL17; /*case 9039*/
            if (_R60 == 9053) goto _CKL18; /*case 9053*/
            if (_R60 == 9054) goto _CKL19; /*case 9054*/
            if (_R60 == 9056) goto _CKL20; /*case 9056*/
            if (_R60 == 9057) goto _CKL21; /*case 9057*/
            if (_R60 == 9055) goto _CKL22; /*case 9055*/
            goto _CKL23;/*default*/

            {
                _CKL4:/*case 9040*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 1;
                parser_match(ctx);
                return p_type_specifier;
                _CKL5:/*case 9003*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 2;
                parser_match(ctx);
                return p_type_specifier;
                _CKL6:/*case 9028*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 4;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL7:/*case 9019*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 8;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL8:/*case 9021*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 262144;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL9:/*case 9022*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 524288;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL10:/*case 9023*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 1048576;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL11:/*case 9024*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 2097152;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL12:/*case 9051*/ 
                p_type_specifier->flags = 0;
                p_type_specifier->token = ctx->current;
                p_type_specifier->msvc_declspec = msvc_declspec(ctx);
                return p_type_specifier;
                _CKL13:/*case 9020*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 16;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL14:/*case 9014*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 32;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL15:/*case 9010*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 64;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL16:/*case 9029*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 128;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL17:/*case 9039*/ 
                p_type_specifier->flags = 256;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL18:/*case 9053*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 512;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL19:/*case 9054*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 1024;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL20:/*case 9056*/ 
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 2048;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL21:/*case 9057*/ 
                p_type_specifier->flags = 4096;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL22:/*case 9055*/ 
                p_type_specifier->flags = 8192;
                p_type_specifier->token = ctx->current;
                parser_match(ctx);
                return p_type_specifier;
                _CKL23: /*default*/ 
                goto _CKL3; /*break*/

            }
            _CKL3:;
        }
        if (first_of_typeof_specifier(ctx))
        {
            p_type_specifier->token = ctx->current;
            p_type_specifier->flags = 8388608;
            p_type_specifier->typeof_specifier = typeof_specifier(ctx);
            if (p_type_specifier->typeof_specifier == 0U)
            {
                type_specifier_delete(p_type_specifier);
                return 0U;
            }
        }
        else
        {
            if (first_of_atomic_type_specifier(ctx))
            {
                p_type_specifier->token = ctx->current;
                p_type_specifier->flags = 16384;
                p_type_specifier->atomic_type_specifier = atomic_type_specifier(ctx);
                if (p_type_specifier->atomic_type_specifier == 0U)
                {
                    type_specifier_delete(p_type_specifier);
                    return 0U;
                }
            }
            else
            {
                if (first_of_struct_or_union(ctx))
                {
                    p_type_specifier->token = ctx->current;
                    p_type_specifier->flags = 32768;
                    p_type_specifier->struct_or_union_specifier = struct_or_union_specifier(ctx);
                    if (p_type_specifier->struct_or_union_specifier == 0U)
                    {
                        type_specifier_delete(p_type_specifier);
                        return 0U;
                    }
                }
                else
                {
                    if (first_of_enum_specifier(ctx))
                    {
                        p_type_specifier->token = ctx->current;
                        p_type_specifier->flags = 65536;
                        p_type_specifier->enum_specifier = enum_specifier(ctx);
                        if (p_type_specifier->enum_specifier == 0U)
                        {
                            type_specifier_delete(p_type_specifier);
                            return 0U;
                        }
                    }
                    else
                    {
                        if (ctx->current->type == 9069)
                        {
                            type_specifier_delete(p_type_specifier);
                            return 0U;
                        }
                        else
                        {
                            if (ctx->current->type == 8996)
                            {
                                p_type_specifier->token = ctx->current;
                                p_type_specifier->flags = 131072;
                                p_type_specifier->typedef_declarator = find_declarator(ctx, ctx->current->lexeme, 0U);
                                ;
                                parser_match(ctx);
                            }
                        }
                    }
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        type_specifier_delete(p_type_specifier);
        p_type_specifier = 0U;
    }
    return p_type_specifier;
}

int get_enum_type_specifier_flags(struct enum_specifier * p_enum_specifier)
{
    if (p_enum_specifier->specifier_qualifier_list)
    {
        return p_enum_specifier->specifier_qualifier_list->type_specifier_flags;
    }
    if (p_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->specifier_qualifier_list)
    {
        return p_enum_specifier->p_complete_enum_specifier->specifier_qualifier_list->type_specifier_flags;
    }
    else
    {
        if (p_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier->specifier_qualifier_list)
        {
            return p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier->specifier_qualifier_list->type_specifier_flags;
        }
    }
    return 8;
}

struct enum_specifier *get_complete_enum_specifier(struct enum_specifier * p_enum_specifier)
{
    if (p_enum_specifier->enumerator_list.head)
    {
        return p_enum_specifier;
    }
    else
    {
        if (p_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->enumerator_list.head)
        {
            return p_enum_specifier->p_complete_enum_specifier;
        }
        else
        {
            if (p_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier && p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier->enumerator_list.head)
            {
                return p_enum_specifier->p_complete_enum_specifier->p_complete_enum_specifier;
            }
        }
    }
    return 0U;
}

struct struct_or_union_specifier *get_complete_struct_or_union_specifier(struct struct_or_union_specifier * p_struct_or_union_specifier)
{
    if (p_struct_or_union_specifier->member_declaration_list.head)
    {
        return (struct struct_or_union_specifier *)p_struct_or_union_specifier;
    }
    else
    {
        if (p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection && p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection->member_declaration_list.head)
        {
            return p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection;
        }
        else
        {
            if (p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection && p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection->complete_struct_or_union_specifier_indirection && p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection->complete_struct_or_union_specifier_indirection->member_declaration_list.head)
            {
                return p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection->complete_struct_or_union_specifier_indirection;
            }
        }
    }
    return 0U;
}

unsigned char  struct_or_union_specifier_is_complete(struct struct_or_union_specifier * p_struct_or_union_specifier)
{
    return !!(get_complete_struct_or_union_specifier(p_struct_or_union_specifier) != 0U);
}

struct struct_or_union_specifier *struct_or_union_specifier_add_ref(struct struct_or_union_specifier * p)
{
    p->has_shared_ownership = 1;
    return (struct struct_or_union_specifier *)p;
}

void struct_or_union_specifier_sink(struct struct_or_union_specifier * p)
{
}

unsigned char  struct_or_union_specifier_is_union(struct struct_or_union_specifier * p)
{
    return !!(p->first_token->type == 9038);
}

void member_declaration_list_destroy(struct member_declaration_list * p);

void struct_or_union_specifier_delete(struct struct_or_union_specifier * p)
{
    if (p)
    {
        if (p->has_shared_ownership > 0)
        {
            p->has_shared_ownership = 0;
            struct_or_union_specifier_sink(p);
            return;
        }
        member_declaration_list_destroy(&p->member_declaration_list);
        attribute_specifier_sequence_delete(p->attribute_specifier_sequence_opt);
        free(p);
    }
}

void naming_convention_struct_tag(struct parser_ctx * ctx, struct token * token);
struct member_declaration_list member_declaration_list(struct parser_ctx * ctx, struct struct_or_union_specifier *);

struct struct_or_union_specifier *struct_or_union_specifier(struct parser_ctx * ctx)
{
    struct struct_or_union_specifier * p_struct_or_union_specifier;

    p_struct_or_union_specifier = 0U;
    if (1) /*try*/
    {
        struct struct_or_union_specifier * p_first_tag_in_this_scope;
        struct struct_or_union_specifier * p_complete;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_struct_or_union_specifier = calloc(1, 256U);
        if (p_struct_or_union_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 9033 || ctx->current->type == 9038)
        {
            p_struct_or_union_specifier->first_token = ctx->current;
            parser_match(ctx);
        }
        else
        {
            goto _CKL0;/*throw*/
        }
        msvc_declspec_sequence_opt(ctx);
        p_struct_or_union_specifier->attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        p_first_tag_in_this_scope = 0U;
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 8996)
        {
            struct map_entry * p_entry;

            p_struct_or_union_specifier->tagtoken = ctx->current;
            snprintf(p_struct_or_union_specifier->tag_name, 200U, "%s", ctx->current->lexeme);
            p_entry = hashmap_find(&ctx->scopes.tail->tags, ctx->current->lexeme);
            if (p_entry)
            {
                if (p_entry->type == 2)
                {
                    ;
                    p_first_tag_in_this_scope = p_entry->data.p_struct_or_union_specifier;
                    p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection = p_first_tag_in_this_scope;
                }
                else
                {
                    compiler_diagnostic(1030, ctx, ctx->current, 0U, "use of '%s' with tag type that does not match previous declaration.", ctx->current->lexeme);
                }
            }
            else
            {
                struct struct_or_union_specifier * p_first_tag_previous_scopes;

                p_first_tag_previous_scopes = find_struct_or_union_specifier(ctx, ctx->current->lexeme);
                if (p_first_tag_previous_scopes == 0U)
                {
                    struct hash_item_set  item;

                    p_struct_or_union_specifier->scope_level = ctx->scopes.tail->scope_level;
                    _cake_zmem(&item, 32);
                    item.p_struct_or_union_specifier = struct_or_union_specifier_add_ref(p_struct_or_union_specifier);
                    hashmap_set(&ctx->scopes.tail->tags, ctx->current->lexeme, &item);
                    hash_item_set_destroy(&item);
                }
                else
                {
                    p_struct_or_union_specifier->complete_struct_or_union_specifier_indirection = p_first_tag_previous_scopes;
                }
            }
            parser_match(ctx);
        }
        else
        {
            struct hash_item_set  item;

            snprintf(p_struct_or_union_specifier->tag_name, 200U, "_struct_tag_%d", s_anonymous_struct_count);
            s_anonymous_struct_count++;
            p_struct_or_union_specifier->has_anonymous_tag = 1;
            p_struct_or_union_specifier->scope_level = ctx->scopes.tail->scope_level;
            _cake_zmem(&item, 32);
            item.p_struct_or_union_specifier = struct_or_union_specifier_add_ref(p_struct_or_union_specifier);
            hashmap_set(&ctx->scopes.tail->tags, p_struct_or_union_specifier->tag_name, &item);
            hash_item_set_destroy(&item);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 123)
        {
            struct struct_or_union_specifier * first;
            struct token * firsttoken;

            first = find_struct_or_union_specifier(ctx, p_struct_or_union_specifier->tag_name);
            if (first)
            {
                first->complete_struct_or_union_specifier_indirection = p_struct_or_union_specifier;
            }
            if (p_struct_or_union_specifier->tagtoken)
            {
                naming_convention_struct_tag(ctx, p_struct_or_union_specifier->tagtoken);
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            firsttoken = ctx->current;
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type != 125)
            {
                p_struct_or_union_specifier->member_declaration_list = member_declaration_list(ctx, p_struct_or_union_specifier);
                if (p_struct_or_union_specifier->member_declaration_list.head == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            p_struct_or_union_specifier->member_declaration_list.first_token = firsttoken;
            p_struct_or_union_specifier->last_token = ctx->current;
            p_struct_or_union_specifier->member_declaration_list.last_token = ctx->current;
            if (parser_match_tk(ctx, 125) != 0)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            p_struct_or_union_specifier->last_token = ctx->current;
        }
        p_complete = get_complete_struct_or_union_specifier(p_struct_or_union_specifier);
        if (p_complete)
        {
            if (p_complete->attribute_specifier_sequence_opt && p_complete->attribute_specifier_sequence_opt->attributes_flags & 1)
            {
                if (p_struct_or_union_specifier->tagtoken)
                {
                    compiler_diagnostic(2, ctx, p_struct_or_union_specifier->first_token, 0U, "'%s' is deprecated", p_struct_or_union_specifier->tagtoken->lexeme);
                }
                else
                {
                    compiler_diagnostic(2, ctx, p_struct_or_union_specifier->first_token, 0U, "deprecated");
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        struct_or_union_specifier_delete(p_struct_or_union_specifier);
        p_struct_or_union_specifier = 0U;
    }
    return p_struct_or_union_specifier;
}

void naming_convention_struct_member(struct parser_ctx * ctx, struct token * token, struct type * type);
void member_declarator_delete(struct member_declarator * p);

struct member_declarator *member_declarator(struct parser_ctx * ctx, struct struct_or_union_specifier * p_struct_or_union_specifier, struct specifier_qualifier_list * p_specifier_qualifier_list)
{
    struct member_declarator * p_member_declarator;

    p_member_declarator = 0U;
    if (1) /*try*/
    {
        struct token * p_token_name;

        p_member_declarator = calloc(1, 12U);
        if (p_member_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_token_name = 0U;
        p_member_declarator->declarator = declarator(ctx, p_specifier_qualifier_list, 0U, 0, &p_token_name);
        if (p_member_declarator->declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_member_declarator->declarator->name_opt = p_token_name;
        p_member_declarator->declarator->specifier_qualifier_list = p_specifier_qualifier_list;
        p_member_declarator->declarator->type = make_type_using_declarator(ctx, p_member_declarator->declarator);
        if (type_is_function(&p_member_declarator->declarator->type))
        {
            struct token * p_token;

            p_token = p_member_declarator->declarator->first_token_opt;
            if (p_token == 0U)
            {
                p_token = ctx->current;
            }
            compiler_diagnostic(1840, ctx, p_token, 0U, "members having a function type are not allowed");
            goto _CKL0;/*throw*/
        }
        if (type_is_owner(&p_member_declarator->declarator->type))
        {
            p_struct_or_union_specifier->is_owner = 1;
        }
        if (p_member_declarator->declarator->name_opt)
        {
            naming_convention_struct_member(ctx, p_member_declarator->declarator->name_opt, &p_member_declarator->declarator->type);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 58)
        {
            parser_match(ctx);
            p_member_declarator->constant_expression = constant_expression(ctx, 1);
        }
    }
    else _CKL0: /*catch*/ 
    {
        member_declarator_delete(p_member_declarator);
        p_member_declarator = 0U;
    }
    return p_member_declarator;
}

void member_declarator_delete(struct member_declarator * p)
{
    if (p)
    {
        expression_delete(p->constant_expression);
        ;
        declarator_delete(p->declarator);
        free(p);
    }
}

void member_declarator_list_add(struct member_declarator_list * list, struct member_declarator * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void member_declarator_list_delete(struct member_declarator_list * p)
{
    if (p)
    {
        struct member_declarator * item;

        item = p->head;
        while (item)
        {
            struct member_declarator * next;

            next = item->next;
            item->next = 0U;
            member_declarator_delete(item);
            item = next;
        }
        free(p);
    }
}

struct member_declarator_list *member_declarator_list(struct parser_ctx * ctx, struct struct_or_union_specifier * p_struct_or_union_specifier, struct specifier_qualifier_list * p_specifier_qualifier_list)
{
    struct member_declarator_list * p_member_declarator_list;

    p_member_declarator_list = calloc(1, 8U);
    if (1) /*try*/
    {
        struct member_declarator * p_member_declarator;

        if (p_member_declarator_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_member_declarator = member_declarator(ctx, p_struct_or_union_specifier, p_specifier_qualifier_list);
        if (p_member_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        member_declarator_list_add(p_member_declarator_list, p_member_declarator);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        while (ctx->current->type == 44)
        {
            struct member_declarator * p_member_declarator2;

            parser_match(ctx);
            p_member_declarator2 = member_declarator(ctx, p_struct_or_union_specifier, p_specifier_qualifier_list);
            if (p_member_declarator2 == 0U)
            {
                goto _CKL0;/*throw*/
            }
            member_declarator_list_add(p_member_declarator_list, p_member_declarator2);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        member_declarator_list_delete(p_member_declarator_list);
        p_member_declarator_list = 0U;
    }
    return p_member_declarator_list;
}

void member_declaration_list_add(struct member_declaration_list * list, struct member_declaration * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void member_declaration_delete(struct member_declaration * p);

void member_declaration_list_destroy(struct member_declaration_list * p)
{
    struct member_declaration * item;

    item = p->head;
    while (item)
    {
        struct member_declaration * next;

        next = item->next;
        item->next = 0U;
        member_declaration_delete(item);
        item = next;
    }
}

struct member_declaration *member_declaration(struct parser_ctx * ctx, struct struct_or_union_specifier *);

struct member_declaration_list member_declaration_list(struct parser_ctx * ctx, struct struct_or_union_specifier * p_struct_or_union_specifier)
{
    struct member_declaration_list  list;
    struct member_declaration * p_member_declaration;

    _cake_zmem(&list, 16);
    p_member_declaration = 0U;
    if (1) /*try*/
    {
        p_member_declaration = member_declaration(ctx, p_struct_or_union_specifier);
        if (p_member_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        member_declaration_list_add(&list, p_member_declaration);
        p_member_declaration = 0U;
        while (ctx->current && ctx->current->type != 125)
        {
            p_member_declaration = member_declaration(ctx, p_struct_or_union_specifier);
            if (p_member_declaration == 0U)
            {
                goto _CKL0;/*throw*/
            }
            member_declaration_list_add(&list, p_member_declaration);
            p_member_declaration = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        struct member_declaration_list  __cmp_lt_61;

        member_declaration_list_destroy(&list);
        __cmp_lt_61.first_token = 0;
        __cmp_lt_61.last_token = 0;
        __cmp_lt_61.head = 0;
        __cmp_lt_61.tail = 0;
        list = __cmp_lt_61;
    }
    return list;
}

void specifier_qualifier_list_delete(struct specifier_qualifier_list * p);
void static_assert_declaration_delete(struct static_assert_declaration * p);
void pragma_declaration_delete(struct pragma_declaration * p);

void member_declaration_delete(struct member_declaration * p)
{
    if (p)
    {
        ;
        specifier_qualifier_list_delete(p->specifier_qualifier_list);
        member_declarator_list_delete(p->member_declarator_list_opt);
        attribute_specifier_sequence_delete(p->p_attribute_specifier_sequence_opt);
        static_assert_declaration_delete(p->static_assert_declaration);
        pragma_declaration_delete(p->pragma_declaration);
        free(p);
    }
}

struct specifier_qualifier_list *specifier_qualifier_list(struct parser_ctx * ctx);

struct member_declaration *member_declaration(struct parser_ctx * ctx, struct struct_or_union_specifier * p_struct_or_union_specifier)
{
    struct member_declaration * p_member_declaration;

    p_member_declaration = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_member_declaration = calloc(1, 24U);
        if (p_member_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 9061)
        {
            p_member_declaration->static_assert_declaration = static_assert_declaration(ctx);
        }
        else
        {
            if (ctx->current->type == 128)
            {
                p_member_declaration->pragma_declaration = pragma_declaration(ctx);
            }
            else
            {
                p_member_declaration->p_attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
                p_member_declaration->specifier_qualifier_list = specifier_qualifier_list(ctx);
                if (p_member_declaration->specifier_qualifier_list == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (ctx->current == 0U)
                {
                    unexpected_end_of_file(ctx);
                    goto _CKL0;/*throw*/
                }
                if (ctx->current->type != 59)
                {
                    p_member_declaration->member_declarator_list_opt = member_declarator_list(ctx, p_struct_or_union_specifier, p_member_declaration->specifier_qualifier_list);
                    if (p_member_declaration->member_declarator_list_opt == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                if (parser_match_tk(ctx, 59) != 0)
                {
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        member_declaration_delete(p_member_declaration);
        p_member_declaration = 0U;
    }
    return p_member_declaration;
}

struct member_declarator *find_member_declarator(struct member_declaration_list * list, char * name, int * p_member_index)
{
    struct member_declaration * p_member_declaration;

    if (list->head == 0U)
    {
        return 0U;
    }
    p_member_declaration = list->head;
    while (p_member_declaration)
    {
        struct member_declarator * p_member_declarator;

        p_member_declarator = 0U;
        if (p_member_declaration->member_declarator_list_opt)
        {
            p_member_declarator = p_member_declaration->member_declarator_list_opt->head;
            while (p_member_declarator)
            {
                if (p_member_declarator->declarator)
                {
                    if (p_member_declarator->declarator->name_opt && strcmp(p_member_declarator->declarator->name_opt->lexeme, name) == 0)
                    {
                        return p_member_declarator;
                    }
                }
                (*p_member_index)++;
                p_member_declarator = p_member_declarator->next;
            }
        }
        else
        {
            if (p_member_declaration->specifier_qualifier_list && p_member_declaration->specifier_qualifier_list->struct_or_union_specifier)
            {
                struct struct_or_union_specifier * p_complete;

                p_complete = get_complete_struct_or_union_specifier(p_member_declaration->specifier_qualifier_list->struct_or_union_specifier);
                if (p_complete)
                {
                    p_member_declarator = find_member_declarator(&p_complete->member_declaration_list, name, p_member_index);
                    if (p_member_declarator)
                    {
                        return p_member_declarator;
                    }
                }
            }
        }
        p_member_declaration = p_member_declaration->next;
    }
    return 0U;
}

static struct member_declarator *find_member_declarator_by_index_core(struct member_declaration_list * list, int member_index, int * p_count)
{
    struct member_declaration * p_member_declaration;

    if (list->head == 0U)
    {
        return 0U;
    }
    p_member_declaration = list->head;
    while (p_member_declaration)
    {
        struct member_declarator * p_member_declarator;

        p_member_declarator = 0U;
        if (p_member_declaration->member_declarator_list_opt)
        {
            p_member_declarator = p_member_declaration->member_declarator_list_opt->head;
            while (p_member_declarator)
            {
                if (p_member_declarator->declarator)
                {
                    if (member_index == *p_count)
                    {
                        return p_member_declarator;
                    }
                }
                (*p_count)++;
                p_member_declarator = p_member_declarator->next;
            }
        }
        else
        {
            if (p_member_declaration->specifier_qualifier_list && p_member_declaration->specifier_qualifier_list->struct_or_union_specifier)
            {
                struct member_declaration_list * p_member_declaration_list;

                p_member_declaration_list = &p_member_declaration->specifier_qualifier_list->struct_or_union_specifier->member_declaration_list;
                p_member_declarator = find_member_declarator_by_index_core(p_member_declaration_list, member_index, p_count);
                if (p_member_declarator)
                {
                    return p_member_declarator;
                }
            }
        }
        p_member_declaration = p_member_declaration->next;
    }
    return 0U;
}

struct member_declarator *find_member_declarator_by_index(struct member_declaration_list * list, int member_index)
{
    int count;

    count = 0;
    return find_member_declarator_by_index_core(list, member_index, &count);
}

static struct object *find_object_declarator_by_index_core(struct object * p_object0, struct member_declaration_list * list, int member_index, int * p_count)
{
    struct object * p_object;
    struct object * p_member_object;
    struct member_declaration * p_member_declaration;

    p_object = object_is_reference(p_object0) ? object_get_referenced(p_object0) : p_object0;
    if (list->head == 0U)
    {
        return 0U;
    }
    if (p_object->members == 0U)
    {
        return 0U;
    }
    p_member_object = p_object->members;
    p_member_declaration = list->head;
    while (p_member_declaration)
    {
        struct member_declarator * p_member_declarator;

        p_member_declarator = 0U;
        if (p_member_declaration->member_declarator_list_opt)
        {
            p_member_declarator = p_member_declaration->member_declarator_list_opt->head;
            while (p_member_declarator)
            {
                if (p_member_declarator->declarator)
                {
                    if (member_index == *p_count)
                    {
                        return p_member_object;
                    }
                }
                (*p_count)++;
                p_member_declarator = p_member_declarator->next;
                if (p_member_object == 0U)
                {
                    return 0U;
                }
                p_member_object = p_member_object->next;
            }
        }
        else
        {
            if (p_member_declaration->specifier_qualifier_list)
            {
                if (p_member_declaration->specifier_qualifier_list->struct_or_union_specifier)
                {
                    struct member_declaration_list * p_member_declaration_list;
                    struct object * p_member_object2;

                    p_member_declaration_list = &p_member_declaration->specifier_qualifier_list->struct_or_union_specifier->member_declaration_list;
                    p_member_object2 = find_object_declarator_by_index_core(p_member_object, p_member_declaration_list, member_index, p_count);
                    if (p_member_object2)
                    {
                        return p_member_object2;
                    }
                }
                p_member_object = p_member_object->next;
            }
        }
        p_member_declaration = p_member_declaration->next;
    }
    return 0U;
}

struct object *find_object_declarator_by_index(struct object * p_object, struct member_declaration_list * list, int member_index)
{
    int count;

    count = 0;
    return find_object_declarator_by_index_core(p_object, list, member_index, &count);
}

void print_specifier_qualifier_list(struct osstream * ss, unsigned char  * first, struct specifier_qualifier_list * p_specifier_qualifier_list)
{
    print_type_qualifier_flags(ss, first, p_specifier_qualifier_list->type_qualifier_flags);
    if (p_specifier_qualifier_list->enum_specifier)
    {
        ;
    }
    else
    {
        if (p_specifier_qualifier_list->struct_or_union_specifier)
        {
            ss_fprintf(ss, "struct %s", p_specifier_qualifier_list->struct_or_union_specifier->tag_name);
        }
        else
        {
            if (p_specifier_qualifier_list->typedef_declarator)
            {
                if (p_specifier_qualifier_list->typedef_declarator->name_opt)
                {
                    print_item(ss, first, p_specifier_qualifier_list->typedef_declarator->name_opt->lexeme);
                }
            }
            else
            {
                print_type_specifier_flags(ss, first, p_specifier_qualifier_list->type_specifier_flags);
            }
        }
    }
}

void specifier_qualifier_list_add(struct specifier_qualifier_list * list, struct type_specifier_qualifier * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void specifier_qualifier_list_delete(struct specifier_qualifier_list * p)
{
    if (p)
    {
        struct type_specifier_qualifier * item;

        item = p->head;
        while (item)
        {
            struct type_specifier_qualifier * next;

            next = item->next;
            item->next = 0U;
            type_specifier_qualifier_delete(item);
            item = next;
        }
        attribute_specifier_sequence_delete(p->p_attribute_specifier_sequence);
        free(p);
    }
}

struct specifier_qualifier_list *specifier_qualifier_list(struct parser_ctx * ctx)
{
    struct specifier_qualifier_list * p_specifier_qualifier_list;

    p_specifier_qualifier_list = 0U;
    if (1) /*try*/
    {
        struct token * p_previous_parser_token;

        if (!first_of_type_specifier_qualifier(ctx))
        {
            compiler_diagnostic(1040, ctx, ctx->current, 0U, "type specifier or qualifier expected");
            goto _CKL0;/*throw*/
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_specifier_qualifier_list = calloc(1, 48U);
        if (p_specifier_qualifier_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_specifier_qualifier_list->first_token = ctx->current;
        while (ctx->current != 0U && (first_of_type_specifier_qualifier(ctx)))
        {
            struct type_specifier_qualifier * p_type_specifier_qualifier;

            if (ctx->current->flags & 16)
            {
                if (p_specifier_qualifier_list->type_specifier_flags != 0)
                {
                    break;
                }
            }
            p_type_specifier_qualifier = type_specifier_qualifier(ctx);
            if (p_type_specifier_qualifier == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (p_type_specifier_qualifier->type_specifier)
            {
                if (add_specifier(ctx, &p_specifier_qualifier_list->type_specifier_flags, p_type_specifier_qualifier->type_specifier->flags) != 0)
                {
                    type_specifier_qualifier_delete(p_type_specifier_qualifier);
                    goto _CKL0;/*throw*/
                }
                if (p_type_specifier_qualifier->type_specifier->struct_or_union_specifier)
                {
                    p_specifier_qualifier_list->struct_or_union_specifier = p_type_specifier_qualifier->type_specifier->struct_or_union_specifier;
                }
                else
                {
                    if (p_type_specifier_qualifier->type_specifier->enum_specifier)
                    {
                        p_specifier_qualifier_list->enum_specifier = p_type_specifier_qualifier->type_specifier->enum_specifier;
                    }
                    else
                    {
                        if (p_type_specifier_qualifier->type_specifier->typeof_specifier)
                        {
                            p_specifier_qualifier_list->typeof_specifier = p_type_specifier_qualifier->type_specifier->typeof_specifier;
                        }
                        else
                        {
                            if (p_type_specifier_qualifier->type_specifier->token->type == 8996)
                            {
                                p_specifier_qualifier_list->typedef_declarator = find_declarator(ctx, p_type_specifier_qualifier->type_specifier->token->lexeme, 0U);
                            }
                        }
                    }
                }
            }
            else
            {
                if (p_type_specifier_qualifier->alignment_specifier)
                {
                    p_specifier_qualifier_list->alignment_specifier_flags |= p_type_specifier_qualifier->alignment_specifier->flags;
                }
                else
                {
                    if (p_type_specifier_qualifier->type_qualifier)
                    {
                        p_specifier_qualifier_list->type_qualifier_flags |= p_type_specifier_qualifier->type_qualifier->flags;
                    }
                }
            }
            ;
            p_specifier_qualifier_list->p_attribute_specifier_sequence = attribute_specifier_sequence_opt(ctx);
            specifier_qualifier_list_add(p_specifier_qualifier_list, p_type_specifier_qualifier);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        final_specifier(ctx, &p_specifier_qualifier_list->type_specifier_flags);
        p_previous_parser_token = previous_parser_token(ctx->current);
        if (p_previous_parser_token == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_specifier_qualifier_list->last_token = p_previous_parser_token;
    }
    else _CKL0: /*catch*/ 
    {
        specifier_qualifier_list_delete(p_specifier_qualifier_list);
        p_specifier_qualifier_list = 0U;
    }
    return p_specifier_qualifier_list;
}

void type_qualifier_delete(struct type_qualifier * p)
{
    if (p)
    {
        ;
        free(p);
    }
}

void alignment_specifier_delete(struct alignment_specifier * p);

void type_specifier_qualifier_delete(struct type_specifier_qualifier * p)
{
    if (p)
    {
        ;
        if (p->type_qualifier)
        {
            ;
            free(p->type_qualifier);
        }
        alignment_specifier_delete(p->alignment_specifier);
        type_specifier_delete(p->type_specifier);
        free(p);
    }
}

struct type_qualifier *type_qualifier(struct parser_ctx * ctx);
struct alignment_specifier *alignment_specifier(struct parser_ctx * ctx);

struct type_specifier_qualifier *type_specifier_qualifier(struct parser_ctx * ctx)
{
    struct type_specifier_qualifier * type_specifier_qualifier;

    type_specifier_qualifier = 0U;
    if (1) /*try*/
    {
        type_specifier_qualifier = calloc(1, 16U);
        if (type_specifier_qualifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (first_of_type_specifier(ctx))
        {
            type_specifier_qualifier->type_specifier = type_specifier(ctx);
            if (type_specifier_qualifier->type_specifier == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            if (first_of_type_qualifier(ctx))
            {
                type_specifier_qualifier->type_qualifier = type_qualifier(ctx);
                if (type_specifier_qualifier->type_qualifier == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
            else
            {
                if (first_of_alignment_specifier(ctx))
                {
                    type_specifier_qualifier->alignment_specifier = alignment_specifier(ctx);
                    if (type_specifier_qualifier->alignment_specifier == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                else
                {
                    ;
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        type_specifier_qualifier_delete(type_specifier_qualifier);
        type_specifier_qualifier = 0U;
    }
    return type_specifier_qualifier;
}

struct enumerator *find_enumerator_by_value(struct enum_specifier * p_enum_specifier, struct object * object)
{
    struct enumerator * p;

    if (p_enum_specifier->enumerator_list.head == 0U)
    {
        return 0U;
    }
    p = p_enum_specifier->enumerator_list.head;
    while (p)
    {
        if (object_equal(&p->value, object))
        {
            return p;
        }
        p = p->next;
    }
    return 0U;
}

struct enum_specifier *enum_specifier_add_ref(struct enum_specifier * p)
{
    p->has_shared_ownership = 1;
    return (struct enum_specifier *)p;
}

void enum_specifier_delete_sink(struct enum_specifier * p)
{
}

void enumerator_list_destroy(struct enumerator_list * p_enum_specifier);

void enum_specifier_delete(struct enum_specifier * p)
{
    if (p)
    {
        if (p->has_shared_ownership > 0)
        {
            p->has_shared_ownership = 0;
            enum_specifier_delete_sink(p);
            return;
        }
        specifier_qualifier_list_delete(p->specifier_qualifier_list);
        attribute_specifier_sequence_delete(p->attribute_specifier_sequence_opt);
        enumerator_list_destroy(&p->enumerator_list);
        free(p);
    }
}

unsigned char  enum_specifier_has_fixed_underlying_type(struct enum_specifier * p_enum_specifier)
{
    return !!(p_enum_specifier->specifier_qualifier_list != 0U);
}

struct type make_with_type_specifier_flags(int f);
void naming_convention_enum_tag(struct parser_ctx * ctx, struct token * token);
struct enumerator_list enumerator_list(struct parser_ctx * ctx, struct enum_specifier * p_enum_specifier);

struct enum_specifier *enum_specifier(struct parser_ctx * ctx)
{
    struct enum_specifier * p_enum_specifier;

    p_enum_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_enum_specifier = calloc(1, 232U);
        if (p_enum_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_enum_specifier->first_token = ctx->current;
        if (parser_match_tk(ctx, 9012) != 0)
        {
            goto _CKL0;/*throw*/
        }
        p_enum_specifier->attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 8996)
        {
            snprintf(p_enum_specifier->tag_name, 200U, "%s", ctx->current->lexeme);
            p_enum_specifier->tag_token = ctx->current;
            parser_match(ctx);
        }
        else
        {
            snprintf(p_enum_specifier->tag_name, 200U, "_anonymous_struct_%d", s_anonymous_struct_count);
            s_anonymous_struct_count++;
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 58)
        {
            if (!ctx->inside_generic_association)
            {
                struct type  enum_underline_type;

                parser_match(ctx);
                p_enum_specifier->specifier_qualifier_list = specifier_qualifier_list(ctx);
                if (p_enum_specifier->specifier_qualifier_list == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                enum_underline_type = make_with_type_specifier_flags(p_enum_specifier->specifier_qualifier_list->type_specifier_flags);
                if (!type_is_integer(&enum_underline_type))
                {
                    type_destroy(&enum_underline_type);
                    compiler_diagnostic(1850, ctx, p_enum_specifier->specifier_qualifier_list->first_token, 0U, "expected an integer type");
                    goto _CKL0;/*throw*/
                }
                type_destroy(&enum_underline_type);
            }
            else
            {
            }
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 123)
        {
            struct hash_item_set  item;

            if (p_enum_specifier->tag_token)
            {
                naming_convention_enum_tag(ctx, p_enum_specifier->tag_token);
            }
            p_enum_specifier->p_complete_enum_specifier = p_enum_specifier;
            if (parser_match_tk(ctx, 123) != 0)
            {
                goto _CKL0;/*throw*/
            }
            p_enum_specifier->enumerator_list = enumerator_list(ctx, p_enum_specifier);
            if (p_enum_specifier->enumerator_list.head == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type == 44)
            {
                parser_match(ctx);
            }
            if (parser_match_tk(ctx, 125) != 0)
            {
                goto _CKL0;/*throw*/
            }
            _cake_zmem(&item, 32);
            item.p_enum_specifier = enum_specifier_add_ref(p_enum_specifier);
            hashmap_set(&ctx->scopes.tail->tags, p_enum_specifier->tag_name, &item);
            p_enum_specifier->p_complete_enum_specifier = p_enum_specifier;
            hash_item_set_destroy(&item);
        }
        else
        {
            struct enum_specifier * p_existing_enum_specifier;

            p_existing_enum_specifier = 0U;
            if (p_enum_specifier->tag_token)
            {
                p_existing_enum_specifier = find_enum_specifier(ctx, p_enum_specifier->tag_token->lexeme);
            }
            if (p_existing_enum_specifier)
            {
                p_enum_specifier->p_complete_enum_specifier = p_existing_enum_specifier;
            }
            else
            {
                struct hash_item_set  item;

                _cake_zmem(&item, 32);
                item.p_enum_specifier = enum_specifier_add_ref(p_enum_specifier);
                hashmap_set(&ctx->scopes.tail->tags, p_enum_specifier->tag_name, &item);
                p_enum_specifier->p_complete_enum_specifier = p_enum_specifier;
                hash_item_set_destroy(&item);
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        enum_specifier_delete(p_enum_specifier);
        p_enum_specifier = 0U;
    }
    return p_enum_specifier;
}

void enumerator_list_add(struct enumerator_list * list, struct enumerator * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void enumerator_list_destroy(struct enumerator_list * p)
{
    struct enumerator * item;

    item = p->head;
    while (item)
    {
        struct enumerator * next;

        next = item->next;
        item->next = 0U;
        enumerator_delete(item);
        item = next;
    }
}

struct enumerator *enumerator(struct parser_ctx * ctx, struct enum_specifier * p_enum_specifier, struct object * p_enumerator_value);

struct enumerator_list enumerator_list(struct parser_ctx * ctx, struct enum_specifier * p_enum_specifier)
{
    struct object  next_enumerator_value;
    struct enumerator_list  enumeratorlist;
    struct enumerator * p_enumerator;

    next_enumerator_value = object_make_signed_int(0);
    if (p_enum_specifier->specifier_qualifier_list)
    {
        int vt;

        vt = type_specifier_to_object_type(p_enum_specifier->specifier_qualifier_list->type_specifier_flags);
        next_enumerator_value = object_cast(vt, &next_enumerator_value);
    }
    _cake_zmem(&enumeratorlist, 8);
    p_enumerator = 0U;
    if (1) /*try*/
    {
        p_enumerator = enumerator(ctx, p_enum_specifier, &next_enumerator_value);
        if (p_enumerator == 0U)
        {
            goto _CKL1;/*throw*/
        }
        enumerator_list_add(&enumeratorlist, p_enumerator);
        while (ctx->current != 0U && ctx->current->type == 44)
        {
            parser_match(ctx);
            if (ctx->current && ctx->current->type != 125)
            {
                p_enumerator = enumerator(ctx, p_enum_specifier, &next_enumerator_value);
                if (p_enumerator == 0U)
                {
                    goto _CKL1;/*throw*/
                }
                enumerator_list_add(&enumeratorlist, p_enumerator);
            }
        }
    }
    else _CKL1: /*catch*/ 
    {
        enumerator_list_destroy(&enumeratorlist);
        enumeratorlist.head = 0U;
        enumeratorlist.tail = 0U;
    }
    return enumeratorlist;
}

struct enumerator *enumerator_add_ref(struct enumerator * p)
{
    p->has_shared_ownership = 1;
    return (struct enumerator *)p;
}

void enumerator_sink(struct enumerator * p)
{
}

void enumerator_delete(struct enumerator * p)
{
    if (p)
    {
        if (p->has_shared_ownership > 0)
        {
            p->has_shared_ownership = 0;
            enumerator_sink(p);
            return;
        }
        ;
        attribute_specifier_sequence_delete(p->attribute_specifier_sequence_opt);
        expression_delete(p->constant_expression_opt);
        free(p);
    }
}

void naming_convention_enumerator(struct parser_ctx * ctx, struct token * token);

struct enumerator *enumerator(struct parser_ctx * ctx, struct enum_specifier * p_enum_specifier, struct object * p_next_enumerator_value)
{
    struct enumerator * p_enumerator;

    p_enumerator = 0U;
    if (1) /*try*/
    {
        struct token * name;
        struct hash_item_set  item;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_enumerator = calloc(1, 128U);
        if (p_enumerator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_enumerator->enum_specifier = p_enum_specifier;
        name = ctx->current;
        naming_convention_enumerator(ctx, name);
        if (parser_match_tk(ctx, 8996) != 0)
        {
            goto _CKL0;/*throw*/
        }
        p_enumerator->attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        p_enumerator->token = name;
        _cake_zmem(&item, 32);
        item.p_enumerator = enumerator_add_ref(p_enumerator);
        hashmap_set(&ctx->scopes.tail->variables, p_enumerator->token->lexeme, &item);
        hash_item_set_destroy(&item);
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 61)
        {
            parser_match(ctx);
            ;
            p_enumerator->constant_expression_opt = constant_expression(ctx, 1);
            if (p_enumerator->constant_expression_opt == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (enum_specifier_has_fixed_underlying_type(p_enum_specifier))
            {
            }
            else
            {
            }
            p_enumerator->value = p_enumerator->constant_expression_opt->object;
            *p_next_enumerator_value = *object_get_referenced(&p_enumerator->value);
            if (object_increment_value(p_next_enumerator_value) != 0)
            {
            }
        }
        else
        {
            p_enumerator->value = *p_next_enumerator_value;
            if (object_increment_value(p_next_enumerator_value) != 0)
            {
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
        enumerator_delete(p_enumerator);
        p_enumerator = 0U;
    }
    return p_enumerator;
}

void alignment_specifier_delete(struct alignment_specifier * p)
{
    if (p)
    {
        expression_delete(p->constant_expression);
        type_name_delete(p->type_name);
        free(p);
    }
}

struct alignment_specifier *alignment_specifier(struct parser_ctx * ctx)
{
    struct alignment_specifier * alignment_specifier;

    alignment_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        alignment_specifier = calloc(1, 16U);
        if (alignment_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        alignment_specifier->token = ctx->current;
        if (parser_match_tk(ctx, 9043) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (parser_match_tk(ctx, 40) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (first_of_type_name(ctx))
        {
            alignment_specifier->type_name = type_name(ctx);
            if (alignment_specifier->type_name == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            alignment_specifier->constant_expression = constant_expression(ctx, 1);
            if (alignment_specifier->constant_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (object_has_constant_value(&alignment_specifier->constant_expression->object))
            {
                long a;

                a = object_to_signed_long(&alignment_specifier->constant_expression->object);
                if (a == 8)
                {
                    alignment_specifier->flags |= 1;
                }
                else
                {
                    if (a == 16)
                    {
                        alignment_specifier->flags |= 2;
                    }
                    else
                    {
                        if (a == 32)
                        {
                            alignment_specifier->flags |= 4;
                        }
                        else
                        {
                            if (a == 64)
                            {
                                alignment_specifier->flags |= 8;
                            }
                            else
                            {
                                if (a == 128)
                                {
                                    alignment_specifier->flags |= 16;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (parser_match_tk(ctx, 41) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return alignment_specifier;
}

void atomic_type_specifier_delete(struct atomic_type_specifier * p)
{
    if (p)
    {
        type_name_delete(p->type_name);
        free(p);
    }
}

struct atomic_type_specifier *atomic_type_specifier(struct parser_ctx * ctx)
{
    struct atomic_type_specifier * p_atomic_type_specifier;

    p_atomic_type_specifier = 0U;
    if (1) /*try*/
    {
        struct type_name * ptemp;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_atomic_type_specifier = calloc(1, 8U);
        if (p_atomic_type_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_atomic_type_specifier->token = ctx->current;
        if (parser_match_tk(ctx, 9045) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (parser_match_tk(ctx, 40) != 0)
        {
            goto _CKL0;/*throw*/
        }
        ptemp = type_name(ctx);
        if (ptemp == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_atomic_type_specifier->type_name = ptemp;
        if (parser_match_tk(ctx, 41) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        atomic_type_specifier_delete(p_atomic_type_specifier);
        p_atomic_type_specifier = 0U;
    }
    return p_atomic_type_specifier;
}

struct type_qualifier *type_qualifier(struct parser_ctx * ctx)
{
    struct type_qualifier * p_type_qualifier;

    if (ctx->current == 0U)
    {
        unexpected_end_of_file(ctx);
        return 0U;
    }
    p_type_qualifier = calloc(1, 12U);
    if (p_type_qualifier == 0U)
    {
        return 0U;
    }
    /*switch*/
    {
        register int _R62 = ctx->current->type;
        if (_R62 == 9004) goto _CKL3; /*case 9004*/
        if (_R62 == 9026) goto _CKL4; /*case 9026*/
        if (_R62 == 9041) goto _CKL5; /*case 9041*/
        if (_R62 == 9045) goto _CKL6; /*case 9045*/
        if (_R62 == 9046) goto _CKL7; /*case 9046*/
        if (_R62 == 9047) goto _CKL8; /*case 9047*/
        goto _CKL9;/*default*/

        {
            _CKL3:/*case 9004*/ 
            p_type_qualifier->flags = 1;
            goto _CKL2; /*break*/

            _CKL4:/*case 9026*/ 
            p_type_qualifier->flags = 2;
            goto _CKL2; /*break*/

            _CKL5:/*case 9041*/ 
            p_type_qualifier->flags = 4;
            goto _CKL2; /*break*/

            _CKL6:/*case 9045*/ 
            p_type_qualifier->flags = 8;
            goto _CKL2; /*break*/

            _CKL7:/*case 9046*/ 
            p_type_qualifier->flags = 512;
            goto _CKL2; /*break*/

            _CKL8:/*case 9047*/ 
            p_type_qualifier->flags = 1024;
            goto _CKL2; /*break*/

            _CKL9: /*default*/ 
            goto _CKL2; /*break*/

        }
        _CKL2:;
    }
    if (ctx->options.ownership_enabled)
    {
        /*switch*/
        {
            register int _R63 = ctx->current->type;
            if (_R63 == 9071) goto _CKL12; /*case 9071*/
            if (_R63 == 9072) goto _CKL13; /*case 9072*/
            if (_R63 == 9070) goto _CKL14; /*case 9070*/
            if (_R63 == 9073) goto _CKL15; /*case 9073*/
            goto _CKL16;/*default*/

            {
                _CKL12:/*case 9071*/ 
                p_type_qualifier->flags = 256;
                goto _CKL11; /*break*/

                _CKL13:/*case 9072*/ 
                p_type_qualifier->flags = 128;
                goto _CKL11; /*break*/

                _CKL14:/*case 9070*/ 
                p_type_qualifier->flags = 16;
                goto _CKL11; /*break*/

                _CKL15:/*case 9073*/ 
                p_type_qualifier->flags = 32;
                goto _CKL11; /*break*/

                _CKL16: /*default*/ 
                goto _CKL11; /*break*/

            }
            _CKL11:;
        }
    }
    if (ctx->options.null_checks_enabled)
    {
        /*switch*/
        {
            register int _R64 = ctx->current->type;
            if (_R64 == 9074) goto _CKL19; /*case 9074*/
            goto _CKL20;/*default*/

            {
                _CKL19:/*case 9074*/ 
                p_type_qualifier->flags = 64;
                goto _CKL18; /*break*/

                _CKL20: /*default*/ 
                goto _CKL18; /*break*/

            }
            _CKL18:;
        }
    }
    p_type_qualifier->token = ctx->current;
    parser_match(ctx);
    return p_type_qualifier;
}

struct type_qualifier *type_qualifier_opt(struct parser_ctx * ctx)
{
    if (first_of_type_qualifier(ctx))
    {
        return type_qualifier(ctx);
    }
    return 0U;
}

void function_specifier_delete(struct function_specifier * p)
{
    if (p)
    {
        free(p);
    }
}

struct function_specifier *function_specifier(struct parser_ctx * ctx)
{
    struct function_specifier * p_function_specifier;

    p_function_specifier = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_function_specifier = calloc(1, 8U);
        if (p_function_specifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 9060)
        {
            compiler_diagnostic(10, ctx, ctx->current, 0U, "_Noreturn is deprecated use attributes");
        }
        if (ctx->current->type == 9018)
        {
            p_function_specifier->flags |= 1;
        }
        p_function_specifier->token = ctx->current;
        parser_match(ctx);
    }
    else _CKL0: /*catch*/ 
    {
        function_specifier_delete(p_function_specifier);
        p_function_specifier = 0U;
    }
    return p_function_specifier;
}

struct declarator *declarator_add_ref(struct declarator * p)
{
    p->has_shared_ownership = 1;
    return (struct declarator *)p;
}

void declarator_sink(struct declarator * p)
{
}

void direct_declarator_delete(struct direct_declarator * p);
void pointer_delete(struct pointer * p);

void declarator_delete(struct declarator * p)
{
    if (p)
    {
        if (p->has_shared_ownership > 0)
        {
            p->has_shared_ownership = 0;
            declarator_sink(p);
            return;
        }
        type_destroy(&p->type);
        direct_declarator_delete(p->direct_declarator);
        pointer_delete(p->pointer);
        free(p);
    }
}

struct pointer *pointer_opt(struct parser_ctx * ctx);
struct direct_declarator *direct_declarator(struct parser_ctx * ctx, struct specifier_qualifier_list * specifier_qualifier_list, struct declaration_specifiers * declaration_specifiers, unsigned char   abstract_acceptable, struct token ** pptoken_name);

struct declarator *declarator(struct parser_ctx * ctx, struct specifier_qualifier_list * p_specifier_qualifier_list_opt, struct declaration_specifiers * p_declaration_specifiers_opt, unsigned char   abstract_acceptable, struct token ** pp_token_name_opt)
{
    struct declarator * p_declarator;

    p_declarator = 0U;
    if (1) /*try*/
    {
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_declarator = calloc(1, 232U);
        if (p_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_declarator->first_token_opt = ctx->current;
        p_declarator->pointer = pointer_opt(ctx);
        p_declarator->direct_declarator = direct_declarator(ctx, p_specifier_qualifier_list_opt, p_declaration_specifiers_opt, abstract_acceptable, pp_token_name_opt);
        if (p_declarator->direct_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (pp_token_name_opt && *pp_token_name_opt)
        {
            free((void *)p_declarator->object.debug_name);
            p_declarator->object.debug_name = strdup((*pp_token_name_opt)->lexeme);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current != p_declarator->first_token_opt)
        {
            p_declarator->last_token_opt = previous_parser_token(ctx->current);
        }
        else
        {
            p_declarator->last_token_opt = p_declarator->first_token_opt;
            p_declarator->first_token_opt = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        declarator_delete(p_declarator);
        p_declarator = 0U;
    }
    return p_declarator;
}

char *declarator_get_name(struct declarator * p_declarator)
{
    if (p_declarator->direct_declarator)
    {
        if (p_declarator->direct_declarator->name_opt)
        {
            return p_declarator->direct_declarator->name_opt->lexeme;
        }
    }
    return 0U;
}

unsigned char  declarator_is_function(struct declarator * p_declarator)
{
    return !!((p_declarator->direct_declarator && p_declarator->direct_declarator->function_declarator != 0U));
}

void parameter_type_list_delete(struct parameter_type_list * p);

void function_declarator_delete(struct function_declarator * p)
{
    if (p)
    {
        direct_declarator_delete(p->direct_declarator);
        scope_destroy(&p->parameters_scope);
        parameter_type_list_delete(p->parameter_type_list_opt);
        free(p);
    }
}

void array_declarator_delete(struct array_declarator * p);

void direct_declarator_delete(struct direct_declarator * p)
{
    if (p)
    {
        declarator_delete(p->declarator);
        attribute_specifier_sequence_delete(p->p_attribute_specifier_sequence_opt);
        array_declarator_delete(p->array_declarator);
        function_declarator_delete(p->function_declarator);
        free(p);
    }
}

struct array_declarator *array_declarator(struct direct_declarator * p_direct_declarator, struct parser_ctx * ctx);
struct function_declarator *function_declarator(struct direct_declarator * p_direct_declarator, struct parser_ctx * ctx);

struct direct_declarator *direct_declarator(struct parser_ctx * ctx, struct specifier_qualifier_list * p_specifier_qualifier_list, struct declaration_specifiers * p_declaration_specifiers, unsigned char   abstract_acceptable, struct token ** pp_token_name_opt)
{
    struct direct_declarator * p_direct_declarator;

    p_direct_declarator = 0U;
    if (1) /*try*/
    {
        struct token * p_token_ahead;

        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        p_direct_declarator = calloc(1, 24U);
        if (p_direct_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_token_ahead = parser_look_ahead(ctx);
        if (p_token_ahead == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type == 9049 || ctx->current->type == 9050 || ctx->current->type == 9048)
        {
            p_direct_declarator->p_calling_convention = ctx->current;
            parser_match(ctx);
        }
        if (ctx->current->type == 8996)
        {
            p_direct_declarator->name_opt = ctx->current;
            if (pp_token_name_opt != 0U)
            {
                *pp_token_name_opt = ctx->current;
            }
            parser_match(ctx);
            p_direct_declarator->p_attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        }
        else
        {
            if (ctx->current->type == 40)
            {
                struct token * ahead;

                ahead = parser_look_ahead(ctx);
                if (ahead == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (!first_of_type_specifier_token(ctx, p_token_ahead) && !first_of_type_qualifier_token(p_token_ahead) && ahead->type != 41 && ahead->type != 3026478)
                {
                    struct declarator * p_declarator_temp;

                    parser_match(ctx);
                    p_declarator_temp = declarator(ctx, p_specifier_qualifier_list, p_declaration_specifiers, abstract_acceptable, pp_token_name_opt);
                    if (p_declarator_temp == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                    p_direct_declarator->declarator = p_declarator_temp;
                    parser_match(ctx);
                }
            }
        }
        while (ctx->current != 0U && (ctx->current->type == 91 || ctx->current->type == 40))
        {
            struct direct_declarator * p_direct_declarator2;

            p_direct_declarator2 = calloc(1, 24U);
            if (p_direct_declarator2 == 0U)
            {
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type == 91)
            {
                p_direct_declarator2->array_declarator = array_declarator(p_direct_declarator, ctx);
                p_direct_declarator = 0U;
                if (p_direct_declarator2->array_declarator == 0U)
                {
                    direct_declarator_delete(p_direct_declarator2);
                    goto _CKL0;/*throw*/
                }
            }
            else
            {
                p_direct_declarator2->function_declarator = function_declarator(p_direct_declarator, ctx);
                p_direct_declarator = 0U;
                if (p_direct_declarator2->function_declarator == 0U)
                {
                    direct_declarator_delete(p_direct_declarator2);
                    goto _CKL0;/*throw*/
                }
            }
            p_direct_declarator = p_direct_declarator2;
        }
    }
    else _CKL0: /*catch*/ 
    {
        direct_declarator_delete(p_direct_declarator);
        p_direct_declarator = 0U;
    }
    return p_direct_declarator;
}

void type_qualifier_list_delete(struct type_qualifier_list * p);

void array_declarator_delete(struct array_declarator * p)
{
    if (p)
    {
        expression_delete(p->assignment_expression);
        direct_declarator_delete(p->direct_declarator);
        expression_delete(p->expression);
        type_qualifier_list_delete(p->type_qualifier_list_opt);
        free(p);
    }
}

unsigned int array_declarator_get_size(struct array_declarator * p_array_declarator)
{
    if (p_array_declarator->assignment_expression)
    {
        if (object_has_constant_value(&p_array_declarator->assignment_expression->object))
        {
            return (unsigned int)object_to_unsigned_long_long(&p_array_declarator->assignment_expression->object);
        }
    }
    return 0;
}

struct type_qualifier_list *type_qualifier_list(struct parser_ctx * ctx);

struct array_declarator *array_declarator(struct direct_declarator * p_direct_declarator, struct parser_ctx * ctx)
{
    struct array_declarator * p_array_declarator;

    p_array_declarator = 0U;
    if (1) /*try*/
    {
        unsigned char   has_static;

        p_array_declarator = calloc(1, 24U);
        if (p_array_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_array_declarator->direct_declarator = p_direct_declarator;
        p_direct_declarator = 0U;
        if (parser_match_tk(ctx, 91) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        has_static = 0;
        if (ctx->current->type == 9032)
        {
            p_array_declarator->static_token_opt = ctx->current;
            parser_match(ctx);
            has_static = 1;
        }
        if (first_of_type_qualifier(ctx))
        {
            p_array_declarator->type_qualifier_list_opt = type_qualifier_list(ctx);
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (!has_static)
        {
            if (ctx->current->type == 9032)
            {
                parser_match(ctx);
                has_static = 1;
            }
        }
        if (has_static)
        {
            unsigned char   evaluation_is_disabled;

            evaluation_is_disabled = ctx->evaluation_is_disabled;
            ctx->evaluation_is_disabled = 0;
            p_array_declarator->assignment_expression = assignment_expression(ctx);
            ctx->evaluation_is_disabled = evaluation_is_disabled;
            if (p_array_declarator->assignment_expression == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        else
        {
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type == 42)
            {
                parser_match(ctx);
            }
            else
            {
                if (ctx->current->type != 93)
                {
                    unsigned char   evaluation_is_disabled;

                    evaluation_is_disabled = ctx->evaluation_is_disabled;
                    ctx->evaluation_is_disabled = 0;
                    p_array_declarator->assignment_expression = assignment_expression(ctx);
                    ctx->evaluation_is_disabled = evaluation_is_disabled;
                    if (p_array_declarator->assignment_expression == 0U)
                    {
                        goto _CKL0;/*throw*/
                    }
                }
                else
                {
                }
            }
        }
        if (parser_match_tk(ctx, 93) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        array_declarator_delete(p_array_declarator);
        p_array_declarator = 0U;
    }
    direct_declarator_delete(p_direct_declarator);
    return p_array_declarator;
}

struct parameter_type_list *parameter_type_list(struct parser_ctx * ctx);

struct function_declarator *function_declarator(struct direct_declarator * p_direct_declarator_arg, struct parser_ctx * ctx)
{
    struct direct_declarator * p_direct_declarator;
    struct function_declarator * p_function_declarator;

    p_direct_declarator = p_direct_declarator_arg;
    p_function_declarator = calloc(1, 44U);
    if (1) /*try*/
    {
        if (p_function_declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_function_declarator->direct_declarator = p_direct_declarator;
        p_direct_declarator = 0U;
        p_function_declarator->parameters_scope.scope_level = ctx->scopes.tail->scope_level + 1;
        p_function_declarator->parameters_scope.variables.capacity = 5;
        p_function_declarator->parameters_scope.tags.capacity = 1;
        if (parser_match_tk(ctx, 40) != 0)
        {
            goto _CKL0;/*throw*/
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL0;/*throw*/
        }
        if (ctx->current->type != 41)
        {
            scope_list_push(&ctx->scopes, &p_function_declarator->parameters_scope);
            p_function_declarator->parameter_type_list_opt = parameter_type_list(ctx);
            scope_list_pop(&ctx->scopes);
            if (p_function_declarator->parameter_type_list_opt == 0U)
            {
                goto _CKL0;/*throw*/
            }
        }
        if (parser_match_tk(ctx, 41) != 0)
        {
            goto _CKL0;/*throw*/
        }
    }
    else _CKL0: /*catch*/ 
    {
        function_declarator_delete(p_function_declarator);
        p_function_declarator = 0U;
    }
    direct_declarator_delete(p_direct_declarator);
    return p_function_declarator;
}

void pointer_delete(struct pointer * p)
{
    if (p)
    {
        struct pointer * item;

        attribute_specifier_sequence_delete(p->attribute_specifier_sequence_opt);
        type_qualifier_list_delete(p->type_qualifier_list_opt);
        item = p->pointer;
        while (item)
        {
            struct pointer * next;

            next = item->pointer;
            attribute_specifier_sequence_delete(item->attribute_specifier_sequence_opt);
            type_qualifier_list_delete(item->type_qualifier_list_opt);
            free(item);
            item = next;
        }
        free(p);
    }
}

struct pointer *pointer_opt(struct parser_ctx * ctx)
{
    struct pointer * p;
    struct pointer * p_pointer;

    p = 0U;
    p_pointer = 0U;
    if (1) /*try*/
    {
        struct token * calling_convention;
        struct token * ahead;

        calling_convention = 0U;
        ahead = parser_look_ahead(ctx);
        if (ahead != 0U && ahead->type == 42)
        {
            if (ctx->current->type == 9049 || ctx->current->type == 9050 || ctx->current->type == 9048)
            {
                calling_convention = ctx->current;
                parser_match(ctx);
            }
        }
        while (ctx->current != 0U && ctx->current->type == 42)
        {
            p_pointer = calloc(1, 16U);
            if (p_pointer == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_pointer->calling_convention = calling_convention;
            calling_convention = 0U;
            p = p_pointer;
            parser_match(ctx);
            p_pointer->attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
            if (first_of_type_qualifier(ctx))
            {
                ;
                if (ctx->current->type == 9073)
                {
                    compiler_diagnostic(640, ctx, ctx->current, 0U, "invalid qualifier for pointer");
                }
                else
                {
                    p_pointer->type_qualifier_list_opt = type_qualifier_list(ctx);
                }
            }
            while (ctx->current != 0U && ctx->current->type == 42)
            {
                p_pointer->pointer = pointer_opt(ctx);
                if (p_pointer->pointer == 0U)
                {
                    goto _CKL0;/*throw*/
                }
            }
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return p;
}

void type_qualifier_list_add(struct type_qualifier_list * list, struct type_qualifier * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void type_qualifier_list_delete(struct type_qualifier_list * p)
{
    if (p)
    {
        struct type_qualifier * item;

        item = p->head;
        while (item)
        {
            struct type_qualifier * next;

            next = item->next;
            item->next = 0U;
            free(item);
            item = next;
        }
        free(p);
    }
}

struct type_qualifier_list *type_qualifier_list(struct parser_ctx * ctx)
{
    struct type_qualifier_list * p_type_qualifier_list;
    struct type_qualifier * p_type_qualifier;

    p_type_qualifier_list = 0U;
    p_type_qualifier = 0U;
    if (1) /*try*/
    {
        p_type_qualifier_list = calloc(1, 12U);
        if (p_type_qualifier_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_type_qualifier = type_qualifier(ctx);
        if (p_type_qualifier == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_type_qualifier_list->flags |= p_type_qualifier->flags;
        type_qualifier_list_add(p_type_qualifier_list, p_type_qualifier);
        p_type_qualifier = 0U;
        while (ctx->current != 0U && first_of_type_qualifier(ctx))
        {
            p_type_qualifier = type_qualifier(ctx);
            if (p_type_qualifier == 0U)
            {
                goto _CKL0;/*throw*/
            }
            p_type_qualifier_list->flags |= p_type_qualifier->flags;
            type_qualifier_list_add(p_type_qualifier_list, p_type_qualifier);
            p_type_qualifier = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
    }
    return p_type_qualifier_list;
}

void parameter_list_delete(struct parameter_list * p);

void parameter_type_list_delete(struct parameter_type_list * p)
{
    if (p)
    {
        parameter_list_delete(p->parameter_list);
        free(p);
    }
}

struct parameter_list *parameter_list(struct parser_ctx * ctx);

struct parameter_type_list *parameter_type_list(struct parser_ctx * ctx)
{
    struct parameter_type_list * p_parameter_type_list;

    if (ctx->current == 0U)
    {
        return 0U;
    }
    p_parameter_type_list = calloc(1, 8U);
    if (1) /*try*/
    {
        if (p_parameter_type_list == 0U)
        {
            goto _CKL1;/*throw*/
        }
        p_parameter_type_list->parameter_list = parameter_list(ctx);
        if (p_parameter_type_list->parameter_list == 0U)
        {
            goto _CKL1;/*throw*/
        }
        if (p_parameter_type_list->parameter_list->head == p_parameter_type_list->parameter_list->tail)
        {
            if (type_is_void(&p_parameter_type_list->parameter_list->head->declarator->type))
            {
                p_parameter_type_list->is_void = 1;
            }
        }
        if (ctx->current == 0U)
        {
            unexpected_end_of_file(ctx);
            goto _CKL1;/*throw*/
        }
        if (ctx->current->type == 3026478)
        {
            parser_match(ctx);
            p_parameter_type_list->is_var_args = 1;
        }
    }
    else _CKL1: /*catch*/ 
    {
        parameter_type_list_delete(p_parameter_type_list);
        p_parameter_type_list = 0U;
    }
    return p_parameter_type_list;
}

void parameter_list_add(struct parameter_list * list, struct parameter_declaration * p_item)
{
    if (list->head == 0U)
    {
        list->head = p_item;
    }
    else
    {
        ;
        ;
        list->tail->next = p_item;
    }
    list->tail = p_item;
}

void parameter_declaration_delete(struct parameter_declaration * p);

void parameter_list_delete(struct parameter_list * p)
{
    if (p)
    {
        struct parameter_declaration * item;

        item = p->head;
        while (item)
        {
            struct parameter_declaration * next;

            next = item->next;
            item->next = 0U;
            parameter_declaration_delete(item);
            item = next;
        }
        free(p);
    }
}

struct parameter_declaration *parameter_declaration(struct parser_ctx * ctx);

struct parameter_list *parameter_list(struct parser_ctx * ctx)
{
    struct parameter_list * p_parameter_list;
    struct parameter_declaration * p_parameter_declaration;

    p_parameter_list = 0U;
    p_parameter_declaration = 0U;
    if (1) /*try*/
    {
        p_parameter_list = calloc(1, 8U);
        if (p_parameter_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_parameter_declaration = parameter_declaration(ctx);
        if (p_parameter_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        parameter_list_add(p_parameter_list, p_parameter_declaration);
        p_parameter_declaration = 0U;
        while (ctx->current != 0U && ctx->current->type == 44)
        {
            parser_match(ctx);
            if (ctx->current == 0U)
            {
                unexpected_end_of_file(ctx);
                goto _CKL0;/*throw*/
            }
            if (ctx->current->type == 3026478)
            {
                break;
            }
            p_parameter_declaration = parameter_declaration(ctx);
            if (p_parameter_declaration == 0U)
            {
                goto _CKL0;/*throw*/
            }
            parameter_list_add(p_parameter_list, p_parameter_declaration);
            p_parameter_declaration = 0U;
        }
    }
    else _CKL0: /*catch*/ 
    {
        parameter_list_delete(p_parameter_list);
        p_parameter_list = 0U;
    }
    return p_parameter_list;
}

void parameter_declaration_delete(struct parameter_declaration * p)
{
    if (p)
    {
        attribute_specifier_sequence_delete(p->attribute_specifier_sequence_opt);
        declaration_specifiers_delete(p->declaration_specifiers);
        declarator_delete(p->declarator);
        ;
        free(p);
    }
}

void naming_convention_parameter(struct parser_ctx * ctx, struct token * token, struct type * type);

struct parameter_declaration *parameter_declaration(struct parser_ctx * ctx)
{
    struct parameter_declaration * p_parameter_declaration;

    p_parameter_declaration = calloc(1, 16U);
    if (1) /*try*/
    {
        struct declaration_specifiers * p_declaration_specifiers;
        struct token * p_token_name;

        if (p_parameter_declaration == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_parameter_declaration->attribute_specifier_sequence_opt = attribute_specifier_sequence_opt(ctx);
        p_declaration_specifiers = declaration_specifiers(ctx, 6144);
        if (p_declaration_specifiers == 0U)
        {
            goto _CKL0;/*throw*/
        }
        if (p_parameter_declaration->attribute_specifier_sequence_opt)
        {
            if (p_parameter_declaration->attribute_specifier_sequence_opt->attributes_flags & 128)
            {
                p_declaration_specifiers->type_qualifier_flags |= 256;
            }
            else
            {
                if (p_parameter_declaration->attribute_specifier_sequence_opt->attributes_flags & 256)
                {
                    p_declaration_specifiers->type_qualifier_flags |= 128;
                }
            }
        }
        p_parameter_declaration->declaration_specifiers = p_declaration_specifiers;
        p_token_name = 0U;
        p_parameter_declaration->declarator = declarator(ctx, 0U, p_parameter_declaration->declaration_specifiers, 1, &p_token_name);
        if (p_parameter_declaration->declarator == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_parameter_declaration->declarator->name_opt = p_token_name;
        p_parameter_declaration->declarator->declaration_specifiers = p_parameter_declaration->declaration_specifiers;
        p_parameter_declaration->declarator->type = make_type_using_declarator(ctx, p_parameter_declaration->declarator);
        if (p_parameter_declaration->declarator->type.storage_class_specifier_flags & 1)
        {
        }
        else
        {
            int er;

            er = make_object(&p_parameter_declaration->declarator->type, &p_parameter_declaration->declarator->object);
            if (er != 0)
            {
                goto _CKL0;/*throw*/
            }
        }
        if (p_parameter_declaration->declarator->name_opt)
        {
            free((void *)p_parameter_declaration->declarator->object.debug_name);
            p_parameter_declaration->declarator->object.debug_name = strdup(p_parameter_declaration->declarator->name_opt->lexeme);
        }
        object_set_any(&p_parameter_declaration->declarator->object);
        if (p_parameter_declaration->attribute_specifier_sequence_opt)
        {
            p_parameter_declaration->declarator->type.attributes_flags |= p_parameter_declaration->attribute_specifier_sequence_opt->attributes_flags;
        }
        p_parameter_declaration->declarator->type.storage_class_specifier_flags |= 2048;
        if (p_parameter_declaration->declarator->name_opt)
        {
            naming_convention_parameter(ctx, p_parameter_declaration->declarator->name_opt, &p_parameter_declaration->declarator->type);
        }
        if (p_parameter_declaration->declarator->name_opt)
        {
            struct hash_item_set  item;

            _cake_zmem(&item, 32);
            item.p_declarator = declarator_add_ref(p_parameter_declaration->declarator);
            ;
            hashmap_set(&ctx->scopes.tail->variables, p_parameter_declaration->declarator->name_opt->lexeme, &item);
            hash_item_set_destroy(&item);
        }
    }
    else _CKL0: /*catch*/ 
    {
        parameter_declaration_delete(p_parameter_declaration);
        p_parameter_declaration = 0U;
    }
    return p_parameter_declaration;
}

struct specifier_qualifier_list *copy(struct declaration_specifiers * p_declaration_specifiers)
{
    struct specifier_qualifier_list * p_specifier_qualifier_list;

    p_specifier_qualifier_list = calloc(1, 48U);
    if (1) /*try*/
    {
        struct declaration_specifier * p_declaration_specifier;

        if (p_specifier_qualifier_list == 0U)
        {
            goto _CKL0;/*throw*/
        }
        p_specifier_qualifier_list->type_qualifier_flags = p_declaration_specifiers->type_qualifier_flags;
        p_specifier_qualifier_list->type_specifier_flags = p_declaration_specifiers->type_specifier_flags;
        p_declaration_specifier = p_declaration_specifiers->head;
        while (p_declaration_specifier)
        {
            if (p_declaration_specifier->type_specifier_qualifier)
            {
                struct type_specifier_qualifier * p_specifier_qualifier;

                p_specifier_qualifier = calloc(1, 16U);
                if (p_specifier_qualifier == 0U)
                {
                    goto _CKL0;/*throw*/
                }
                if (p_declaration_specifier->type_specifier_qualifier->type_qualifier)
                {
                    struct type_qualifier * p_type_qualifier;

                    p_type_qualifier = calloc(1, 12U);
                    if (p_type_qualifier == 0U)
                    {
                        type_specifier_qualifier_delete(p_specifier_qualifier);
                        goto _CKL0;/*throw*/
                    }
                    p_type_qualifier->flags = p_declaration_specifier->type_specifier_qualifier->type_qualifier->flags;
                    p_type_qualifier->token = p_declaration_specifier->type_specifier_qualifier->type_qualifier->token;
                    p_specifier_qualifier->type_qualifier = p_type_qualifier;
                }
                else
                {
                    if (p_declaration_specifier->type_specifier_qualifier->type_specifier)
                    {
                        struct type_specifier * p_type_specifier;

                        p_type_specifier = calloc(1, 32U);
                        if (p_type_specifier == 0U)
                        {
                            type_specifier_qualifier_delete(p_specifier_qualifier);
                            goto _CKL0;/*throw*/
                        }
                        p_type_specifier->flags = p_declaration_specifier->type_specifier_qualifier->type_specifier->flags;
                        ;
                        p_type_specifier->token = p_declaration_specifier->type_specifier_qualifier->type_specifier->token;
                        p_specifier_qualifier->type_specifier = p_type_specifier;
                    }
                }
                specifier_qualifier_list_add(p_specifier_qualifier_list, p_specifier_qualifier);
            }
            p_declaration_specifier = p_declaration_specifier->next;
        }
    }
    else _CKL0: /*catch*/ 
