#define TCC_VERSION "f10ab130ecbefc99177f5569c69ebe7f375a3d44"
/*
 *  TCC - Tiny C Compiler
 *
 *  Copyright (c) 2001-2004 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// 19 "tcc.c" 2

// 1 "tcc.h" 1
#ifndef _TCC_H
// 22 "tcc.h"
#define _TCC_H

#define _GNU_SOURCE
#define _DARWIN_C_SOURCE
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
/* gnu headers use to #define __attribute__ to empty for non-gcc compilers */
#ifdef __TINYC__

#undef __attribute__
#endif
#include <string.h>
#include <errno.h>
#include <math.h>
#include <fcntl.h>
#include <setjmp.h>
#include <time.h>

#define WIN32_LEAN_AND_MEAN 1
#include <windows.h>
#include <io.h> /* open, close etc. */
/* open, close etc. */
#include <direct.h> /* getcwd */
/* getcwd */
#include <malloc.h> /* alloca */
/* alloca */
#ifdef __GNUC__

#include <stdint.h>
#endif

#define inline __inline
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#ifndef __GNUC__

#define strtold (long double)strtod
#define strtof (float)strtod
#define strtoll _strtoi64
#define strtoull _strtoui64
#endif
#ifdef LIBTCC_AS_DLL

#define LIBTCCAPI __declspec(dllexport)
#define PUB_FUNC LIBTCCAPI
#endif
#ifndef va_copy
// 90 "tcc.h"
#define va_copy(a,b) a = b
#endif
#ifndef O_BINARY

#define O_BINARY 0
#endif
#ifndef offsetof

#define offsetof(type,field) ((size_t) &((type *)0)->field)
#endif
#ifndef countof

#define countof(tab) (sizeof(tab) / sizeof((tab)[0]))
#endif

#define NORETURN __attribute__((noreturn))
#define ALIGNED(x) __attribute__((aligned(x)))
#define PRINTF_LIKE(x,y) __attribute__ ((format (printf, (x), (y))))

#define IS_DIRSEP(c) (c == '/' || c == '\\')
#define IS_ABSPATH(p) (IS_DIRSEP(p[0]) || (p[0] && p[1] == ':' && IS_DIRSEP(p[2])))
#define PATHCMP stricmp
#define PATHSEP ";"
/* -------------------------------------------- */
/* parser debug */
/* #define PARSE_DEBUG */
/* preprocessor debug */
/* #define PP_DEBUG */
/* include file debug */
/* #define INC_DEBUG */
/* memory leak debug (only for single threaded usage) */
/* #define MEM_DEBUG 1,2,3 */
/* assembler debug */
/* #define ASM_DEBUG */
/* target selection */
/* #define TCC_TARGET_I386   */
/* i386 code generator */
/* #define TCC_TARGET_X86_64 */
/* x86-64 code generator */
/* #define TCC_TARGET_ARM    */
/* ARMv4 code generator */
/* #define TCC_TARGET_ARM64  */
/* ARMv8 code generator */
/* #define TCC_TARGET_C67    */
/* TMS320C67xx code generator */
/* #define TCC_TARGET_RISCV64 */
/* risc-v code generator */
/* default target is I386 */
/* only native compiler supports -run */
// 181 "tcc.h"
#define TCC_IS_NATIVE
#if defined CONFIG_TCC_BACKTRACE && CONFIG_TCC_BACKTRACE==0
#undef CONFIG_TCC_BACKTRACE
#else
/* enable builtin stack backtraces */
// 194 "tcc.h"
#define CONFIG_TCC_BACKTRACE 1
#endif
#if defined CONFIG_TCC_BCHECK && CONFIG_TCC_BCHECK==0
#undef CONFIG_TCC_BCHECK
#else
/* enable bound checking code */

#define CONFIG_TCC_BCHECK 1
#endif
/* enable new macho code */

#define CONFIG_NEW_MACHO 1
/* create elf .o but native executables */
// 219 "tcc.h"
#define ELF_OBJ_ONLY
/* No ten-byte long doubles on window and macos except in
   cross-compilers made by a mingw-GCC */
// 229 "tcc.h"
#define TCC_USING_DOUBLE_FOR_LDOUBLE 1
#ifdef CONFIG_TCC_PIE

#define CONFIG_TCC_PIC 1
#endif
/* support using libtcc from threads */
#ifndef CONFIG_TCC_SEMLOCK
// 238 "tcc.h"
#define CONFIG_TCC_SEMLOCK 1
#endif
/* ------------ path configuration ------------ */
#ifndef CONFIG_SYSROOT

#define CONFIG_SYSROOT ""
#endif
#ifndef CONFIG_LDDIR

#define CONFIG_LDDIR "lib"
#endif
#ifdef CONFIG_TRIPLET

#define USE_TRIPLET(s) s "/" CONFIG_TRIPLET
#define ALSO_TRIPLET(s) USE_TRIPLET(s) ":" s
#else

#define USE_TRIPLET(s) s
#define ALSO_TRIPLET(s) s
#endif
/* path to find crt1.o, crti.o and crtn.o */
#ifndef CONFIG_TCC_CRTPREFIX

#define CONFIG_TCC_CRTPREFIX USE_TRIPLET(CONFIG_SYSROOT "/usr/" CONFIG_LDDIR)
#endif
#ifndef CONFIG_USR_INCLUDE

#define CONFIG_USR_INCLUDE "/usr/include"
#endif
/* Below: {B} is substituted by CONFIG_TCCDIR (rsp. -B option) */
/* system include paths */
#ifndef CONFIG_TCC_SYSINCLUDEPATHS

#define CONFIG_TCC_SYSINCLUDEPATHS "{B}/include"PATHSEP"{B}/include/winapi"
#endif
/* library search paths */
#ifndef CONFIG_TCC_LIBPATHS
// 286 "tcc.h"
#define CONFIG_TCC_LIBPATHS "{B}/lib"
#endif
/* name of ELF interpreter */
#ifndef CONFIG_TCC_ELFINTERP
#if defined __GNU__
#define CONFIG_TCC_ELFINTERP "/lib/ld.so"
#else
// 301 "tcc.h"
#define CONFIG_TCC_ELFINTERP "-"
#endif
#endif
/* var elf_interp dans *-gen.c */
#ifndef DEFAULT_ELFINTERP
// 317 "tcc.h"
#define DEFAULT_ELFINTERP(s) CONFIG_TCC_ELFINTERP
#endif
/* (target specific) libtcc1.a */
#ifndef TCC_LIBTCC1

#define TCC_LIBTCC1 "libtcc1.a"
#endif
/* library to use with CONFIG_USE_LIBGCC instead of libtcc1.a */
#if defined CONFIG_USE_LIBGCC && !defined TCC_LIBGCC
#define TCC_LIBGCC USE_TRIPLET(CONFIG_SYSROOT "/" CONFIG_LDDIR) "/libgcc_s.so.1"
#endif
/* <cross-prefix-to->libtcc1.a */
#ifndef CONFIG_TCC_CROSSPREFIX
// 332 "tcc.h"
#define CONFIG_TCC_CROSSPREFIX ""
#endif
/* -------------------------------------------- */

// 1 "libtcc.h" 1
#ifndef LIBTCC_H

#define LIBTCC_H
#ifndef LIBTCCAPI

#define LIBTCCAPI
#endif
#ifdef __cplusplus

extern "C" {
#endif
/**/
/* set custom allocator for all allocations (optional), NULL for default. */
// 14 "libtcc.h"
typedef void *TCCReallocFunc(void *ptr, unsigned long size);
LIBTCCAPI void tcc_set_realloc(TCCReallocFunc *my_realloc);
/**/

typedef struct TCCState TCCState;
/* create a new TCC compilation context */

LIBTCCAPI TCCState *tcc_new(void);
/* free a TCC compilation context */

LIBTCCAPI void tcc_delete(TCCState *s);
/* set CONFIG_TCCDIR at runtime */

LIBTCCAPI void tcc_set_lib_path(TCCState *s, const char *path);
/* set error/warning callback (optional) */

typedef void TCCErrorFunc(void *opaque, const char *msg);
LIBTCCAPI void tcc_set_error_func(TCCState *s, void *error_opaque,
				  TCCErrorFunc *error_func);
/* set options as from command line (multiple supported) */

LIBTCCAPI int tcc_set_options(TCCState *s, const char *str);
/**/
/* preprocessor */
/* add include path */

LIBTCCAPI int tcc_add_include_path(TCCState *s, const char *pathname);
/* add in system include path */

LIBTCCAPI int tcc_add_sysinclude_path(TCCState *s, const char *pathname);
/* define preprocessor symbol 'sym'. value can be NULL, sym can be "sym=val" */

LIBTCCAPI void tcc_define_symbol(TCCState *s, const char *sym,
				 const char *value);
/* undefine preprocess symbol 'sym' */

LIBTCCAPI void tcc_undefine_symbol(TCCState *s, const char *sym);
/**/
/* compiling */
/* add a file (C file, dll, object, library, ld script). Return -1 if error. */

LIBTCCAPI int tcc_add_file(TCCState *s, const char *filename);
/* compile a string containing a C source. Return -1 if error. */

LIBTCCAPI int tcc_compile_string(TCCState *s, const char *buf);
/* Tip: to have more specific errors/warnings from tcc_compile_string(),
   you can prefix the string with "#line <num> \"<filename>\"\n" */
/**/
/* linking commands */
/* set output type. MUST BE CALLED before any compilation */
// 67 "libtcc.h"
LIBTCCAPI int tcc_set_output_type(TCCState *s, int output_type);
/* output will be run in memory */
#define TCC_OUTPUT_MEMORY 1
/* executable file */
#define TCC_OUTPUT_EXE 2
/* dynamic library */
#define TCC_OUTPUT_DLL 4
/* object file */
#define TCC_OUTPUT_OBJ 3
/* only preprocess */
#define TCC_OUTPUT_PREPROCESS 5
/* equivalent to -Lpath option */

LIBTCCAPI int tcc_add_library_path(TCCState *s, const char *pathname);
/* the library name is the same as the argument of the '-l' option */

LIBTCCAPI int tcc_add_library(TCCState *s, const char *libraryname);
/* add a symbol to the compiled program */

LIBTCCAPI int tcc_add_symbol(TCCState *s, const char *name, const void *val);
/* output an executable, library or object file. DO NOT call
   tcc_relocate() before. */

LIBTCCAPI int tcc_output_file(TCCState *s, const char *filename);
/* link and run main() function and return its value. DO NOT call
   tcc_relocate() before. */

LIBTCCAPI int tcc_run(TCCState *s, int argc, char **argv);
/* do all relocations (needed before using tcc_get_symbol()) */

LIBTCCAPI int tcc_relocate(TCCState *s1);
/* return symbol value or NULL if not found */

LIBTCCAPI void *tcc_get_symbol(TCCState *s, const char *name);
/* list all (global) symbols and their values via 'symbol_cb()' */

LIBTCCAPI void tcc_list_symbols(TCCState *s, void *ctx,
				void (*symbol_cb)(void *ctx, const char *name, const void *val));
/* experimental/advanced section (see libtcc_test_mt.c for an example) */
/* catch runtime exceptions (optionally limit backtraces at top_func),
   when using tcc_set_options("-bt") and when not using tcc_run() */

LIBTCCAPI void *_tcc_setjmp(TCCState *s1, void *jmp_buf, void *top_func,
			    void *longjmp);
#define tcc_setjmp(s1,jb,f) setjmp(_tcc_setjmp(s1, jb, f, longjmp))
/* custom error printer for runtime exceptions. Returning 0 stops backtrace */

typedef int TCCBtFunc(void *udata, void *pc, const char *file, int line,
		      const char* func, const char *msg);
LIBTCCAPI void tcc_set_backtrace_func(TCCState *s1, void* userdata, TCCBtFunc*);
#ifdef __cplusplus

}
#endif
#endif /* LIBTCC_H */
// 338 "tcc.h" 2
// 1 "elf.h" 1
/* This file defines standard ELF types, structures, and macros.
   Copyright (C) 1995-2012 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */
#ifndef _ELF_H
// 20 "elf.h"
#define _ELF_H 1
#ifndef __int8_t_defined

#define __int8_t_defined
typedef signed char int8_t;
typedef short int int16_t;
typedef int int32_t;
typedef long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long int uint64_t;
#endif
/* Standard ELF types.  */
/* Type for a 16-bit quantity.  */

typedef uint16_t Elf32_Half;
typedef uint16_t Elf64_Half;
/* Types for signed and unsigned 32-bit quantities.  */

typedef uint32_t Elf32_Word;
typedef	int32_t Elf32_Sword;
typedef uint32_t Elf64_Word;
typedef	int32_t Elf64_Sword;
/* Types for signed and unsigned 64-bit quantities.  */

typedef uint64_t Elf32_Xword;
typedef	int64_t Elf32_Sxword;
typedef uint64_t Elf64_Xword;
typedef	int64_t Elf64_Sxword;
/* Type of addresses.  */

typedef uint32_t Elf32_Addr;
typedef uint64_t Elf64_Addr;
/* Type of file offsets.  */

typedef uint32_t Elf32_Off;
typedef uint64_t Elf64_Off;
/* Type for section indices, which are 16-bit quantities.  */

typedef uint16_t Elf32_Section;
typedef uint16_t Elf64_Section;
/* Type for version symbol information.  */

typedef Elf32_Half Elf32_Versym;
typedef Elf64_Half Elf64_Versym;
/* The ELF file header.  This appears at the start of every ELF file.  */

#define EI_NIDENT (16)

typedef struct {
	unsigned char	e_ident[EI_NIDENT];/* Magic number and other info */

	Elf32_Half	e_type;/* Object file type */

	Elf32_Half	e_machine;/* Architecture */

	Elf32_Word	e_version;/* Object file version */

	Elf32_Addr	e_entry;/* Entry point virtual address */

	Elf32_Off	e_phoff;/* Program header table file offset */

	Elf32_Off	e_shoff;/* Section header table file offset */

	Elf32_Word	e_flags;/* Processor-specific flags */

	Elf32_Half	e_ehsize;/* ELF header size in bytes */

	Elf32_Half	e_phentsize;/* Program header table entry size */

	Elf32_Half	e_phnum;/* Program header table entry count */

	Elf32_Half	e_shentsize;/* Section header table entry size */

	Elf32_Half	e_shnum;/* Section header table entry count */

	Elf32_Half	e_shstrndx;/* Section header string table index */

} Elf32_Ehdr;

typedef struct {
	unsigned char	e_ident[EI_NIDENT];/* Magic number and other info */

	Elf64_Half	e_type;/* Object file type */

	Elf64_Half	e_machine;/* Architecture */

	Elf64_Word	e_version;/* Object file version */

	Elf64_Addr	e_entry;/* Entry point virtual address */

	Elf64_Off	e_phoff;/* Program header table file offset */

	Elf64_Off	e_shoff;/* Section header table file offset */

	Elf64_Word	e_flags;/* Processor-specific flags */

	Elf64_Half	e_ehsize;/* ELF header size in bytes */

	Elf64_Half	e_phentsize;/* Program header table entry size */

	Elf64_Half	e_phnum;/* Program header table entry count */

	Elf64_Half	e_shentsize;/* Section header table entry size */

	Elf64_Half	e_shnum;/* Section header table entry count */

	Elf64_Half	e_shstrndx;/* Section header string table index */

} Elf64_Ehdr;
/* Fields in the e_ident array.  The EI_* macros are indices into the
   array.  The macros under each EI_* macro are the values the byte
   may have.  */
/* File identification byte 0 index */

#define EI_MAG0 0
/* Magic number byte 0 */
#define ELFMAG0 0x7f
/* File identification byte 1 index */

#define EI_MAG1 1
/* Magic number byte 1 */
#define ELFMAG1 'E'
/* File identification byte 2 index */

#define EI_MAG2 2
/* Magic number byte 2 */
#define ELFMAG2 'L'
/* File identification byte 3 index */

#define EI_MAG3 3
/* Magic number byte 3 */
#define ELFMAG3 'F'
/* Conglomeration of the identification bytes, for easy testing as a word.  */

#define ELFMAG "\177ELF"
#define SELFMAG 4
/* File class byte index */

#define EI_CLASS 4
/* Invalid class */
#define ELFCLASSNONE 0
/* 32-bit objects */
#define ELFCLASS32 1
/* 64-bit objects */
#define ELFCLASS64 2
#define ELFCLASSNUM 3
/* Data encoding byte index */

#define EI_DATA 5
/* Invalid data encoding */
#define ELFDATANONE 0
/* 2's complement, little endian */
#define ELFDATA2LSB 1
/* 2's complement, big endian */
#define ELFDATA2MSB 2
#define ELFDATANUM 3
/* File version byte index */

#define EI_VERSION 6
/* Value must be EV_CURRENT */
/* OS ABI identification */

#define EI_OSABI 7
/* UNIX System V ABI */
#define ELFOSABI_NONE 0
/* Alias.  */
#define ELFOSABI_SYSV 0
/* HP-UX */
#define ELFOSABI_HPUX 1
/* NetBSD.  */
#define ELFOSABI_NETBSD 2
/* Object uses GNU ELF extensions.  */
#define ELFOSABI_GNU 3
/* Compatibility alias.  */
#define ELFOSABI_LINUX ELFOSABI_GNU
/* Sun Solaris.  */
#define ELFOSABI_SOLARIS 6
/* IBM AIX.  */
#define ELFOSABI_AIX 7
/* SGI Irix.  */
#define ELFOSABI_IRIX 8
/* FreeBSD.  */
#define ELFOSABI_FREEBSD 9
/* Compaq TRU64 UNIX.  */
#define ELFOSABI_TRU64 10
/* Novell Modesto.  */
#define ELFOSABI_MODESTO 11
/* OpenBSD.  */
#define ELFOSABI_OPENBSD 12
#define ELFOSABI_OPENVMS 13
/* Hewlett-Packard Non-Stop Kernel.  */
#define ELFOSABI_NSK 14
/* Amiga Research OS.  */
#define ELFOSABI_AROS 15
/* FenixOS.  */
#define ELFOSABI_FENIXOS 16
/* ARM EABI.  */
#define ELFOSABI_ARM_AEABI 64
/* Linux TMS320C6000.  */
#define ELFOSABI_C6000_LINUX 65
/* ARM */
#define ELFOSABI_ARM 97
/* Standalone (embedded) application */
#define ELFOSABI_STANDALONE 255
/* ABI version */

#define EI_ABIVERSION 8
/* Byte index of padding bytes */

#define EI_PAD 9
/* Legal values for e_type (object file type).  */
/* No file type */

#define ET_NONE 0
/* Relocatable file */
#define ET_REL 1
/* Executable file */
#define ET_EXEC 2
/* Shared object file */
#define ET_DYN 3
/* Core file */
#define ET_CORE 4
/* Number of defined types */
#define ET_NUM 5
/* OS-specific range start */
#define ET_LOOS 0xfe00
/* OS-specific range end */
#define ET_HIOS 0xfeff
/* Processor-specific range start */
#define ET_LOPROC 0xff00
/* Processor-specific range end */
#define ET_HIPROC 0xffff
/* Legal values for e_machine (architecture).  */
/* No machine */

#define EM_NONE 0
/* AT&T WE 32100 */
#define EM_M32 1
/* SUN SPARC */
#define EM_SPARC 2
/* Intel 80386 */
#define EM_386 3
/* Motorola m68k family */
#define EM_68K 4
/* Motorola m88k family */
#define EM_88K 5
/* Intel 80860 */
#define EM_860 7
/* MIPS R3000 big-endian */
#define EM_MIPS 8
/* IBM System/370 */
#define EM_S370 9
/* MIPS R3000 little-endian */
#define EM_MIPS_RS3_LE 10
/* HPPA */

#define EM_PARISC 15
/* Fujitsu VPP500 */
#define EM_VPP500 17
/* Sun's "v8plus" */
#define EM_SPARC32PLUS 18
/* Intel 80960 */
#define EM_960 19
/* PowerPC */
#define EM_PPC 20
/* PowerPC 64-bit */
#define EM_PPC64 21
/* IBM S390 */
#define EM_S390 22
/* NEC V800 series */

#define EM_V800 36
/* Fujitsu FR20 */
#define EM_FR20 37
/* TRW RH-32 */
#define EM_RH32 38
/* Motorola RCE */
#define EM_RCE 39
/* ARM */
#define EM_ARM 40
/* Digital Alpha */
#define EM_FAKE_ALPHA 41
/* Hitachi SH */
#define EM_SH 42
/* SPARC v9 64-bit */
#define EM_SPARCV9 43
/* Siemens Tricore */
#define EM_TRICORE 44
/* Argonaut RISC Core */
#define EM_ARC 45
/* Hitachi H8/300 */
#define EM_H8_300 46
/* H\itachi H8/300H */
#define EM_H8_300H 47
/* Hitachi H8S */
#define EM_H8S 48
/* Hitachi H8/500 */
#define EM_H8_500 49
/* Intel Merced */
#define EM_IA_64 50
/* Stanford MIPS-X */
#define EM_MIPS_X 51
/* Motorola Coldfire */
#define EM_COLDFIRE 52
/* Motorola M68HC12 */
#define EM_68HC12 53
/* Fujitsu MMA Multimedia Accelerator*/
#define EM_MMA 54
/* Siemens PCP */
#define EM_PCP 55
/* Sony nCPU embedded RISC */
#define EM_NCPU 56
/* Denso NDR1 microprocessor */
#define EM_NDR1 57
/* Motorola Start*Core processor */
#define EM_STARCORE 58
/* Toyota ME16 processor */
#define EM_ME16 59
/* STMicroelectronic ST100 processor */
#define EM_ST100 60
/* Advanced Logic Corp. Tinyj emb.fam*/
#define EM_TINYJ 61
/* AMD x86-64 architecture */
#define EM_X86_64 62
/* Sony DSP Processor */
#define EM_PDSP 63
/* Siemens FX66 microcontroller */

#define EM_FX66 66
/* STMicroelectronics ST9+ 8/16 mc */
#define EM_ST9PLUS 67
/* STMicroelectronics ST7 8 bit mc */
#define EM_ST7 68
/* Motorola MC68HC16 microcontroller */
#define EM_68HC16 69
/* Motorola MC68HC11 microcontroller */
#define EM_68HC11 70
/* Motorola MC68HC08 microcontroller */
#define EM_68HC08 71
/* Motorola MC68HC05 microcontroller */
#define EM_68HC05 72
/* Silicon Graphics SVx */
#define EM_SVX 73
/* STMicroelectronics ST19 8 bit mc */
#define EM_ST19 74
/* Digital VAX */
#define EM_VAX 75
/* Axis Communications 32-bit embedded processor */
#define EM_CRIS 76
/* Infineon Technologies 32-bit embedded processor */
#define EM_JAVELIN 77
/* Element 14 64-bit DSP Processor */
#define EM_FIREPATH 78
/* LSI Logic 16-bit DSP Processor */
#define EM_ZSP 79
/* Donald Knuth's educational 64-bit processor */
#define EM_MMIX 80
/* Harvard University machine-independent object files */
#define EM_HUANY 81
/* SiTera Prism */
#define EM_PRISM 82
/* Atmel AVR 8-bit microcontroller */
#define EM_AVR 83
/* Fujitsu FR30 */
#define EM_FR30 84
/* Mitsubishi D10V */
#define EM_D10V 85
/* Mitsubishi D30V */
#define EM_D30V 86
/* NEC v850 */
#define EM_V850 87
/* Mitsubishi M32R */
#define EM_M32R 88
/* Matsushita MN10300 */
#define EM_MN10300 89
/* Matsushita MN10200 */
#define EM_MN10200 90
/* picoJava */
#define EM_PJ 91
/* OpenRISC 32-bit embedded processor */
#define EM_OPENRISC 92
/* ARC Cores Tangent-A5 */
#define EM_ARC_A5 93
/* Tensilica Xtensa Architecture */
#define EM_XTENSA 94
/* ARM AARCH64 */
#define EM_AARCH64 183
/* Tilera TILEPro */
#define EM_TILEPRO 188
/* Tilera TILE-Gx */
#define EM_TILEGX 191
/* RISC-V */
#define EM_RISCV 243
#define EM_NUM 253
/* If it is necessary to assign new unofficial EM_* values, please
   pick large random numbers (0x8523, 0xa7f2, etc.) to minimize the
   chances of collision with official or non-GNU unofficial values.  */

#define EM_ALPHA 0x9026
#define EM_C60 0x9c60
/* Legal values for e_version (version).  */
/* Invalid ELF version */

#define EV_NONE 0
/* Current version */
#define EV_CURRENT 1
#define EV_NUM 2
/* Section header.  */

typedef struct {
	Elf32_Word	sh_name;/* Section name (string tbl index) */

	Elf32_Word	sh_type;/* Section type */

	Elf32_Word	sh_flags;/* Section flags */

	Elf32_Addr	sh_addr;/* Section virtual addr at execution */

	Elf32_Off	sh_offset;/* Section file offset */

	Elf32_Word	sh_size;/* Section size in bytes */

	Elf32_Word	sh_link;/* Link to another section */

	Elf32_Word	sh_info;/* Additional section information */

	Elf32_Word	sh_addralign;/* Section alignment */

	Elf32_Word	sh_entsize;/* Entry size if section holds table */

} Elf32_Shdr;

typedef struct {
	Elf64_Word	sh_name;/* Section name (string tbl index) */

	Elf64_Word	sh_type;/* Section type */

	Elf64_Xword	sh_flags;/* Section flags */

	Elf64_Addr	sh_addr;/* Section virtual addr at execution */

	Elf64_Off	sh_offset;/* Section file offset */

	Elf64_Xword	sh_size;/* Section size in bytes */

	Elf64_Word	sh_link;/* Link to another section */

	Elf64_Word	sh_info;/* Additional section information */

	Elf64_Xword	sh_addralign;/* Section alignment */

	Elf64_Xword	sh_entsize;/* Entry size if section holds table */

} Elf64_Shdr;
/* Special section indices.  */
/* Undefined section */

#define SHN_UNDEF 0
/* Start of reserved indices */
#define SHN_LORESERVE 0xff00
/* Start of processor-specific */
#define SHN_LOPROC 0xff00
/* Order section before all others
					   (Solaris).  */

#define SHN_BEFORE 0xff00
/* Order section after all others
					   (Solaris).  */

#define SHN_AFTER 0xff01
/* End of processor-specific */
#define SHN_HIPROC 0xff1f
/* Start of OS-specific */
#define SHN_LOOS 0xff20
/* End of OS-specific */
#define SHN_HIOS 0xff3f
/* Associated symbol is absolute */
#define SHN_ABS 0xfff1
/* Associated symbol is common */
#define SHN_COMMON 0xfff2
/* Index is in extra table.  */
#define SHN_XINDEX 0xffff
/* End of reserved indices */
#define SHN_HIRESERVE 0xffff
/* Legal values for sh_type (section type).  */
/* Section header table entry unused */

#define SHT_NULL 0
/* Program data */
#define SHT_PROGBITS 1
/* Symbol table */
#define SHT_SYMTAB 2
/* String table */
#define SHT_STRTAB 3
/* Relocation entries with addends */
#define SHT_RELA 4
/* Symbol hash table */
#define SHT_HASH 5
/* Dynamic linking information */
#define SHT_DYNAMIC 6
/* Notes */
#define SHT_NOTE 7
/* Program space with no data (bss) */
#define SHT_NOBITS 8
/* Relocation entries, no addends */
#define SHT_REL 9
/* Reserved */
#define SHT_SHLIB 10
/* Dynamic linker symbol table */
#define SHT_DYNSYM 11
/* Array of constructors */
#define SHT_INIT_ARRAY 14
/* Array of destructors */
#define SHT_FINI_ARRAY 15
/* Array of pre-constructors */
#define SHT_PREINIT_ARRAY 16
/* Section group */
#define SHT_GROUP 17
/* Extended section indices */
#define SHT_SYMTAB_SHNDX 18
/* Number of defined types.  */
#define SHT_NUM 19
/* Start OS-specific.  */
#define SHT_LOOS 0x60000000
/* Object attributes.  */
#define SHT_GNU_ATTRIBUTES 0x6ffffff5
/* GNU-style hash table.  */
#define SHT_GNU_HASH 0x6ffffff6
/* Prelink library list */
#define SHT_GNU_LIBLIST 0x6ffffff7
/* Checksum for DSO content.  */
#define SHT_CHECKSUM 0x6ffffff8
/* Sun-specific low bound.  */
#define SHT_LOSUNW 0x6ffffffa
#define SHT_SUNW_move 0x6ffffffa
#define SHT_SUNW_COMDAT 0x6ffffffb
#define SHT_SUNW_syminfo 0x6ffffffc
/* Version definition section.  */
#define SHT_GNU_verdef 0x6ffffffd
/* Version needs section.  */
#define SHT_GNU_verneed 0x6ffffffe
/* Version symbol table.  */
#define SHT_GNU_versym 0x6fffffff
/* Sun-specific high bound.  */
#define SHT_HISUNW 0x6fffffff
/* End OS-specific type */
#define SHT_HIOS 0x6fffffff
/* Start of processor-specific */
#define SHT_LOPROC 0x70000000
/* End of processor-specific */
#define SHT_HIPROC 0x7fffffff
/* Start of application-specific */
#define SHT_LOUSER 0x80000000
/* End of application-specific */
#define SHT_HIUSER 0x8fffffff
/* Legal values for sh_flags (section flags).  */
/* Writable */

#define SHF_WRITE (1 << 0)
/* Occupies memory during execution */
#define SHF_ALLOC (1 << 1)
/* Executable */
#define SHF_EXECINSTR (1 << 2)
/* Might be merged */
#define SHF_MERGE (1 << 4)
/* Contains nul-terminated strings */
#define SHF_STRINGS (1 << 5)
/* `sh_info' contains SHT index */
#define SHF_INFO_LINK (1 << 6)
/* Preserve order after combining */
#define SHF_LINK_ORDER (1 << 7)
/* Non-standard OS specific handling
					   required */

#define SHF_OS_NONCONFORMING (1 << 8)
/* Section is member of a group.  */
#define SHF_GROUP (1 << 9)
/* Section hold thread-local data.  */
#define SHF_TLS (1 << 10)
/* Section with compressed data. */
#define SHF_COMPRESSED (1 << 11)
/* OS-specific.  */
#define SHF_MASKOS 0x0ff00000
/* Processor-specific */
#define SHF_MASKPROC 0xf0000000
/* Special ordering requirement
					   (Solaris).  */

#define SHF_ORDERED (1 << 30)
/* Section is excluded unless
					   referenced or allocated (Solaris).*/

#define SHF_EXCLUDE (1U << 31)
/* Section group handling.  */
/* Mark group as COMDAT.  */

#define GRP_COMDAT 0x1
/* Symbol table entry.  */

typedef struct {
	Elf32_Word	st_name;/* Symbol name (string tbl index) */

	Elf32_Addr	st_value;/* Symbol value */

	Elf32_Word	st_size;/* Symbol size */

	unsigned char	st_info;/* Symbol type and binding */

	unsigned char	st_other;/* Symbol visibility */

	Elf32_Section	st_shndx;/* Section index */

} Elf32_Sym;

typedef struct {
	Elf64_Word	st_name;/* Symbol name (string tbl index) */

	unsigned char	st_info;/* Symbol type and binding */

	unsigned char st_other;/* Symbol visibility */

	Elf64_Section	st_shndx;/* Section index */

	Elf64_Addr	st_value;/* Symbol value */

	Elf64_Xword	st_size;/* Symbol size */

} Elf64_Sym;
/* The syminfo section if available contains additional information about
   every dynamic symbol.  */

typedef struct {
	Elf32_Half si_boundto;/* Direct bindings, symbol bound to */

	Elf32_Half si_flags;/* Per symbol flags */

} Elf32_Syminfo;

typedef struct {
	Elf64_Half si_boundto;/* Direct bindings, symbol bound to */

	Elf64_Half si_flags;/* Per symbol flags */

} Elf64_Syminfo;
/* Possible values for si_boundto.  */
/* Symbol bound to self */

#define SYMINFO_BT_SELF 0xffff
/* Symbol bound to parent */
#define SYMINFO_BT_PARENT 0xfffe
/* Beginning of reserved entries */
#define SYMINFO_BT_LOWRESERVE 0xff00
/* Possible bitmasks for si_flags.  */
/* Direct bound symbol */

#define SYMINFO_FLG_DIRECT 0x0001
/* Pass-thru symbol for translator */
#define SYMINFO_FLG_PASSTHRU 0x0002
/* Symbol is a copy-reloc */
#define SYMINFO_FLG_COPY 0x0004
/* Symbol bound to object to be lazy
					   loaded */

#define SYMINFO_FLG_LAZYLOAD 0x0008
/* Syminfo version values.  */

#define SYMINFO_NONE 0
#define SYMINFO_CURRENT 1
#define SYMINFO_NUM 2
/* How to extract and insert information held in the st_info field.  */

#define ELF32_ST_BIND(val) (((unsigned char) (val)) >> 4)
#define ELF32_ST_TYPE(val) ((val) & 0xf)
#define ELF32_ST_INFO(bind,type) (((bind) << 4) + ((type) & 0xf))
/* Both Elf32_Sym and Elf64_Sym use the same one-byte st_info field.  */

#define ELF64_ST_BIND(val) ELF32_ST_BIND (val)
#define ELF64_ST_TYPE(val) ELF32_ST_TYPE (val)
#define ELF64_ST_INFO(bind,type) ELF32_ST_INFO ((bind), (type))
/* Legal values for ST_BIND subfield of st_info (symbol binding).  */
/* Local symbol */

#define STB_LOCAL 0
/* Global symbol */
#define STB_GLOBAL 1
/* Weak symbol */
#define STB_WEAK 2
/* Number of defined types.  */
#define STB_NUM 3
/* Start of OS-specific */
#define STB_LOOS 10
/* Unique symbol.  */
#define STB_GNU_UNIQUE 10
/* End of OS-specific */
#define STB_HIOS 12
/* Start of processor-specific */
#define STB_LOPROC 13
/* End of processor-specific */
#define STB_HIPROC 15
/* Legal values for ST_TYPE subfield of st_info (symbol type).  */
/* Symbol type is unspecified */

#define STT_NOTYPE 0
/* Symbol is a data object */
#define STT_OBJECT 1
/* Symbol is a code object */
#define STT_FUNC 2
/* Symbol associated with a section */
#define STT_SECTION 3
/* Symbol's name is file name */
#define STT_FILE 4
/* Symbol is a common data object */
#define STT_COMMON 5
/* Symbol is thread-local data object*/
#define STT_TLS 6
/* Number of defined types.  */
#define STT_NUM 7
/* Start of OS-specific */
#define STT_LOOS 10
/* Symbol is indirect code object */
#define STT_GNU_IFUNC 10
/* End of OS-specific */
#define STT_HIOS 12
/* Start of processor-specific */
#define STT_LOPROC 13
/* End of processor-specific */
#define STT_HIPROC 15
/* Symbol table indices are found in the hash buckets and chain table
   of a symbol hash table section.  This special index value indicates
   the end of a chain, meaning no further symbols are found in that bucket.  */
/* End of a chain.  */

#define STN_UNDEF 0
/* How to extract and insert information held in the st_other field.  */

#define ELF32_ST_VISIBILITY(o) ((o) & 0x03)
/* For ELF64 the definitions are the same.  */

#define ELF64_ST_VISIBILITY(o) ELF32_ST_VISIBILITY (o)
/* Symbol visibility specification encoded in the st_other field.  */
/* Default symbol visibility rules */

#define STV_DEFAULT 0
/* Processor specific hidden class */
#define STV_INTERNAL 1
/* Sym unavailable in other modules */
#define STV_HIDDEN 2
/* Not preemptible, not exported */
#define STV_PROTECTED 3
/* Relocation table entry without addend (in section of type SHT_REL).  */

typedef struct {
	Elf32_Addr	r_offset;/* Address */

	Elf32_Word	r_info;/* Relocation type and symbol index */

} Elf32_Rel;
/* I have seen two different definitions of the Elf64_Rel and
   Elf64_Rela structures, so we'll leave them out until Novell (or
   whoever) gets their act together.  */
/* The following, at least, is used on Sparc v9, MIPS, and Alpha.  */

typedef struct {
	Elf64_Addr	r_offset;/* Address */

	Elf64_Xword	r_info;/* Relocation type and symbol index */

} Elf64_Rel;
/* Relocation table entry with addend (in section of type SHT_RELA).  */

typedef struct {
	Elf32_Addr	r_offset;/* Address */

	Elf32_Word	r_info;/* Relocation type and symbol index */

	Elf32_Sword	r_addend;/* Addend */

} Elf32_Rela;

typedef struct {
	Elf64_Addr	r_offset;/* Address */

	Elf64_Xword	r_info;/* Relocation type and symbol index */

	Elf64_Sxword	r_addend;/* Addend */

} Elf64_Rela;
/* How to extract and insert information held in the r_info field.  */

#define ELF32_R_SYM(val) ((val) >> 8)
#define ELF32_R_TYPE(val) ((val) & 0xff)
#define ELF32_R_INFO(sym,type) (((sym) << 8) + ((type) & 0xff))

#define ELF64_R_SYM(i) ((i) >> 32)
#define ELF64_R_TYPE(i) ((i) & 0xffffffff)
#define ELF64_R_INFO(sym,type) ((((Elf64_Xword) (sym)) << 32) + (type))
/* Program segment header.  */

typedef struct {
	Elf32_Word	p_type;/* Segment type */

	Elf32_Off	p_offset;/* Segment file offset */

	Elf32_Addr	p_vaddr;/* Segment virtual address */

	Elf32_Addr	p_paddr;/* Segment physical address */

	Elf32_Word	p_filesz;/* Segment size in file */

	Elf32_Word	p_memsz;/* Segment size in memory */

	Elf32_Word	p_flags;/* Segment flags */

	Elf32_Word	p_align;/* Segment alignment */

} Elf32_Phdr;

typedef struct {
	Elf64_Word	p_type;/* Segment type */

	Elf64_Word	p_flags;/* Segment flags */

	Elf64_Off	p_offset;/* Segment file offset */

	Elf64_Addr	p_vaddr;/* Segment virtual address */

	Elf64_Addr	p_paddr;/* Segment physical address */

	Elf64_Xword	p_filesz;/* Segment size in file */

	Elf64_Xword	p_memsz;/* Segment size in memory */

	Elf64_Xword	p_align;/* Segment alignment */

} Elf64_Phdr;
/* Special value for e_phnum.  This indicates that the real number of
   program headers is too large to fit into e_phnum.  Instead the real
   value is in the field sh_info of section 0.  */

#define PN_XNUM 0xffff
/* Legal values for p_type (segment type).  */
/* Program header table entry unused */

#define PT_NULL 0
/* Loadable program segment */
#define PT_LOAD 1
/* Dynamic linking information */
#define PT_DYNAMIC 2
/* Program interpreter */
#define PT_INTERP 3
/* Auxiliary information */
#define PT_NOTE 4
/* Reserved */
#define PT_SHLIB 5
/* Entry for header table itself */
#define PT_PHDR 6
/* Thread-local storage segment */
#define PT_TLS 7
/* Number of defined types */
#define PT_NUM 8
/* Start of OS-specific */
#define PT_LOOS 0x60000000
/* GCC .eh_frame_hdr segment */
#define PT_GNU_EH_FRAME 0x6474e550
/* Indicates stack executability */
#define PT_GNU_STACK 0x6474e551
/* Read-only after relocation */
#define PT_GNU_RELRO 0x6474e552
#define PT_LOSUNW 0x6ffffffa
/* Sun Specific segment */
#define PT_SUNWBSS 0x6ffffffa
/* Stack segment */
#define PT_SUNWSTACK 0x6ffffffb
#define PT_HISUNW 0x6fffffff
/* End of OS-specific */
#define PT_HIOS 0x6fffffff
/* Start of processor-specific */
#define PT_LOPROC 0x70000000
/* End of processor-specific */
#define PT_HIPROC 0x7fffffff
/* Legal values for p_flags (segment flags).  */
/* Segment is executable */

#define PF_X (1 << 0)
/* Segment is writable */
#define PF_W (1 << 1)
/* Segment is readable */
#define PF_R (1 << 2)
/* OS-specific */
#define PF_MASKOS 0x0ff00000
/* Processor-specific */
#define PF_MASKPROC 0xf0000000
/* Legal values for note segment descriptor types for core files. */
/* Contains copy of prstatus struct */

#define NT_PRSTATUS 1
/* Contains copy of fpregset struct */
#define NT_FPREGSET 2
/* Contains copy of prpsinfo struct */
#define NT_PRPSINFO 3
/* Contains copy of prxregset struct */
#define NT_PRXREG 4
/* Contains copy of task structure */
#define NT_TASKSTRUCT 4
/* String from sysinfo(SI_PLATFORM) */
#define NT_PLATFORM 5
/* Contains copy of auxv array */
#define NT_AUXV 6
/* Contains copy of gwindows struct */
#define NT_GWINDOWS 7
/* Contains copy of asrset struct */
#define NT_ASRS 8
/* Contains copy of pstatus struct */
#define NT_PSTATUS 10
/* Contains copy of psinfo struct */
#define NT_PSINFO 13
/* Contains copy of prcred struct */
#define NT_PRCRED 14
/* Contains copy of utsname struct */
#define NT_UTSNAME 15
/* Contains copy of lwpstatus struct */
#define NT_LWPSTATUS 16
/* Contains copy of lwpinfo struct */
#define NT_LWPSINFO 17
/* Contains copy of fprxregset struct */
#define NT_PRFPXREG 20
/* Contains copy of user_fxsr_struct */
#define NT_PRXFPREG 0x46e62b7f
/* PowerPC Altivec/VMX registers */
#define NT_PPC_VMX 0x100
/* PowerPC SPE/EVR registers */
#define NT_PPC_SPE 0x101
/* PowerPC VSX registers */
#define NT_PPC_VSX 0x102
/* i386 TLS slots (struct user_desc) */
#define NT_386_TLS 0x200
/* x86 io permission bitmap (1=deny) */
#define NT_386_IOPERM 0x201
/* x86 extended state using xsave */
#define NT_X86_XSTATE 0x202
/* s390 upper register halves */
#define NT_S390_HIGH_GPRS 0x300
/* s390 timer register */
#define NT_S390_TIMER 0x301
/* s390 TOD clock comparator register */
#define NT_S390_TODCMP 0x302
/* s390 TOD programmable register */
#define NT_S390_TODPREG 0x303
/* s390 control registers */
#define NT_S390_CTRS 0x304
/* s390 prefix register */
#define NT_S390_PREFIX 0x305
/* s390 breaking event address */
#define NT_S390_LAST_BREAK 0x306
/* s390 system call restart data */
#define NT_S390_SYSTEM_CALL 0x307
/* ARM VFP/NEON registers */
#define NT_ARM_VFP 0x400
/* ARM TLS register */
#define NT_ARM_TLS 0x401
/* ARM hardware breakpoint registers */
#define NT_ARM_HW_BREAK 0x402
/* ARM hardware watchpoint registers */
#define NT_ARM_HW_WATCH 0x403
/* Legal values for the note segment descriptor types for object files.  */
/* Contains a version string.  */

#define NT_VERSION 1
/* Dynamic section entry.  */

typedef struct {
	Elf32_Sword	d_tag;/* Dynamic entry type */

	union {
		Elf32_Word d_val;/* Integer value */

		Elf32_Addr d_ptr;/* Address value */

	} d_un;
} Elf32_Dyn;

typedef struct {
	Elf64_Sxword	d_tag;/* Dynamic entry type */

	union {
		Elf64_Xword d_val;/* Integer value */

		Elf64_Addr d_ptr;/* Address value */

	} d_un;
} Elf64_Dyn;
/* Legal values for d_tag (dynamic entry type).  */
/* Marks end of dynamic section */

#define DT_NULL 0
/* Name of needed library */
#define DT_NEEDED 1
/* Size in bytes of PLT relocs */
#define DT_PLTRELSZ 2
/* Processor defined value */
#define DT_PLTGOT 3
/* Address of symbol hash table */
#define DT_HASH 4
/* Address of string table */
#define DT_STRTAB 5
/* Address of symbol table */
#define DT_SYMTAB 6
/* Address of Rela relocs */
#define DT_RELA 7
/* Total size of Rela relocs */
#define DT_RELASZ 8
/* Size of one Rela reloc */
#define DT_RELAENT 9
/* Size of string table */
#define DT_STRSZ 10
/* Size of one symbol table entry */
#define DT_SYMENT 11
/* Address of init function */
#define DT_INIT 12
/* Address of termination function */
#define DT_FINI 13
/* Name of shared object */
#define DT_SONAME 14
/* Library search path (deprecated) */
#define DT_RPATH 15
/* Start symbol search here */
#define DT_SYMBOLIC 16
/* Address of Rel relocs */
#define DT_REL 17
/* Total size of Rel relocs */
#define DT_RELSZ 18
/* Size of one Rel reloc */
#define DT_RELENT 19
/* Type of reloc in PLT */
#define DT_PLTREL 20
/* For debugging; unspecified */
#define DT_DEBUG 21
/* Reloc might modify .text */
#define DT_TEXTREL 22
/* Address of PLT relocs */
#define DT_JMPREL 23
/* Process relocations of object */
#define DT_BIND_NOW 24
/* Array with addresses of init fct */
#define DT_INIT_ARRAY 25
/* Array with addresses of fini fct */
#define DT_FINI_ARRAY 26
/* Size in bytes of DT_INIT_ARRAY */
#define DT_INIT_ARRAYSZ 27
/* Size in bytes of DT_FINI_ARRAY */
#define DT_FINI_ARRAYSZ 28
/* Library search path */
#define DT_RUNPATH 29
/* Flags for the object being loaded */
#define DT_FLAGS 30
/* Start of encoded range */
#define DT_ENCODING 32
/* Array with addresses of preinit fct*/
#define DT_PREINIT_ARRAY 32
/* size in bytes of DT_PREINIT_ARRAY */
#define DT_PREINIT_ARRAYSZ 33
/* Number used */
#define DT_NUM 34
/* Start of OS-specific */
#define DT_LOOS 0x6000000d
/* End of OS-specific */
#define DT_HIOS 0x6ffff000
/* Start of processor-specific */
#define DT_LOPROC 0x70000000
/* End of processor-specific */
#define DT_HIPROC 0x7fffffff
/* Most used by any processor */
#define DT_PROCNUM DT_MIPS_NUM
/* DT_* entries which fall between DT_VALRNGHI & DT_VALRNGLO use the
   Dyn.d_un.d_val field of the Elf*_Dyn structure.  This follows Sun's
   approach.  */

#define DT_VALRNGLO 0x6ffffd00
/* Prelinking timestamp */
#define DT_GNU_PRELINKED 0x6ffffdf5
/* Size of conflict section */
#define DT_GNU_CONFLICTSZ 0x6ffffdf6
/* Size of library list */
#define DT_GNU_LIBLISTSZ 0x6ffffdf7
#define DT_CHECKSUM 0x6ffffdf8
#define DT_PLTPADSZ 0x6ffffdf9
#define DT_MOVEENT 0x6ffffdfa
#define DT_MOVESZ 0x6ffffdfb
/* Feature selection (DTF_*).  */
#define DT_FEATURE_1 0x6ffffdfc
/* Flags for DT_* entries, effecting
					   the following DT_* entry.  */

#define DT_POSFLAG_1 0x6ffffdfd
/* Size of syminfo table (in bytes) */
#define DT_SYMINSZ 0x6ffffdfe
/* Entry size of syminfo */
#define DT_SYMINENT 0x6ffffdff
#define DT_VALRNGHI 0x6ffffdff
/* Reverse order! */
#define DT_VALTAGIDX(tag) (DT_VALRNGHI - (tag))
#define DT_VALNUM 12
/* DT_* entries which fall between DT_ADDRRNGHI & DT_ADDRRNGLO use the
   Dyn.d_un.d_ptr field of the Elf*_Dyn structure.

   If any adjustment is made to the ELF object after it has been
   built these entries will need to be adjusted.  */

#define DT_ADDRRNGLO 0x6ffffe00
/* GNU-style hash table.  */
#define DT_GNU_HASH 0x6ffffef5
#define DT_TLSDESC_PLT 0x6ffffef6
#define DT_TLSDESC_GOT 0x6ffffef7
/* Start of conflict section */
#define DT_GNU_CONFLICT 0x6ffffef8
/* Library list */
#define DT_GNU_LIBLIST 0x6ffffef9
/* Configuration information.  */
#define DT_CONFIG 0x6ffffefa
/* Dependency auditing.  */
#define DT_DEPAUDIT 0x6ffffefb
/* Object auditing.  */
#define DT_AUDIT 0x6ffffefc
/* PLT padding.  */
#define DT_PLTPAD 0x6ffffefd
/* Move table.  */
#define DT_MOVETAB 0x6ffffefe
/* Syminfo table.  */
#define DT_SYMINFO 0x6ffffeff
#define DT_ADDRRNGHI 0x6ffffeff
/* Reverse order! */
#define DT_ADDRTAGIDX(tag) (DT_ADDRRNGHI - (tag))
#define DT_ADDRNUM 11
/* The versioning entry types.  The next are defined as part of the
   GNU extension.  */

#define DT_VERSYM 0x6ffffff0

#define DT_RELACOUNT 0x6ffffff9
#define DT_RELCOUNT 0x6ffffffa
/* These were chosen by Sun.  */
/* State flags, see DF_1_* below.  */

#define DT_FLAGS_1 0x6ffffffb
/* Address of version definition
					   table */

#define DT_VERDEF 0x6ffffffc
/* Number of version definitions */
#define DT_VERDEFNUM 0x6ffffffd
/* Address of table with needed
					   versions */

#define DT_VERNEED 0x6ffffffe
/* Number of needed versions */
#define DT_VERNEEDNUM 0x6fffffff
/* Reverse order! */
#define DT_VERSIONTAGIDX(tag) (DT_VERNEEDNUM - (tag))
#define DT_VERSIONTAGNUM 16
/* Sun added these machine-independent extensions in the "processor-specific"
   range.  Be compatible.  */
/* Shared object to load before self */

#define DT_AUXILIARY 0x7ffffffd
/* Shared object to get values from */
#define DT_FILTER 0x7fffffff
#define DT_EXTRATAGIDX(tag) ((Elf32_Word)-((Elf32_Sword) (tag) <<1>>1)-1)
#define DT_EXTRANUM 3
/* Values of `d_un.d_val' in the DT_FLAGS entry.  */
/* Object may use DF_ORIGIN */

#define DF_ORIGIN 0x00000001
/* Symbol resolutions starts here */
#define DF_SYMBOLIC 0x00000002
/* Object contains text relocations */
#define DF_TEXTREL 0x00000004
/* No lazy binding for this object */
#define DF_BIND_NOW 0x00000008
/* Module uses the static TLS model */
#define DF_STATIC_TLS 0x00000010
/* State flags selectable in the `d_un.d_val' element of the DT_FLAGS_1
   entry in the dynamic section.  */
/* Set RTLD_NOW for this object.  */

#define DF_1_NOW 0x00000001
/* Set RTLD_GLOBAL for this object.  */
#define DF_1_GLOBAL 0x00000002
/* Set RTLD_GROUP for this object.  */
#define DF_1_GROUP 0x00000004
/* Set RTLD_NODELETE for this object.*/
#define DF_1_NODELETE 0x00000008
/* Trigger filtee loading at runtime.*/
#define DF_1_LOADFLTR 0x00000010
/* Set RTLD_INITFIRST for this object*/
#define DF_1_INITFIRST 0x00000020
/* Set RTLD_NOOPEN for this object.  */
#define DF_1_NOOPEN 0x00000040
/* $ORIGIN must be handled.  */
#define DF_1_ORIGIN 0x00000080
/* Direct binding enabled.  */
#define DF_1_DIRECT 0x00000100
#define DF_1_TRANS 0x00000200
/* Object is used to interpose.  */
#define DF_1_INTERPOSE 0x00000400
/* Ignore default lib search path.  */
#define DF_1_NODEFLIB 0x00000800
/* Object can't be dldump'ed.  */
#define DF_1_NODUMP 0x00001000
/* Configuration alternative created.*/
#define DF_1_CONFALT 0x00002000
/* Filtee terminates filters search. */
#define DF_1_ENDFILTEE 0x00004000
/* Disp reloc applied at build time. */
#define DF_1_DISPRELDNE 0x00008000
/* Disp reloc applied at run-time.  */
#define DF_1_DISPRELPND 0x00010000
/* Object has no-direct binding. */
#define DF_1_NODIRECT 0x00020000
#define DF_1_IGNMULDEF 0x00040000
#define DF_1_NOKSYMS 0x00080000
#define DF_1_NOHDR 0x00100000
/* Object is modified after built.  */
#define DF_1_EDITED 0x00200000
#define DF_1_NORELOC 0x00400000
/* Object has individual interposers.  */
#define DF_1_SYMINTPOSE 0x00800000
/* Global auditing required.  */
#define DF_1_GLOBAUDIT 0x01000000
/* Singleton symbols are used.  */
#define DF_1_SINGLETON 0x02000000
#define DF_1_PIE 0x08000000
/* Flags for the feature selection in DT_FEATURE_1.  */

#define DTF_1_PARINIT 0x00000001
#define DTF_1_CONFEXP 0x00000002
/* Flags in the DT_POSFLAG_1 entry effecting only the next DT_* entry.  */
/* Lazyload following object.  */

#define DF_P1_LAZYLOAD 0x00000001
/* Symbols from next object are not
					   generally available.  */

#define DF_P1_GROUPPERM 0x00000002
/* Version definition sections.  */

typedef struct {
	Elf32_Half	vd_version;/* Version revision */

	Elf32_Half	vd_flags;/* Version information */

	Elf32_Half	vd_ndx;/* Version Index */

	Elf32_Half	vd_cnt;/* Number of associated aux entries */

	Elf32_Word	vd_hash;/* Version name hash value */

	Elf32_Word	vd_aux;/* Offset in bytes to verdaux array */

	Elf32_Word	vd_next;/* Offset in bytes to next verdef
					   entry */

} Elf32_Verdef;

typedef struct {
	Elf64_Half	vd_version;/* Version revision */

	Elf64_Half	vd_flags;/* Version information */

	Elf64_Half	vd_ndx;/* Version Index */

	Elf64_Half	vd_cnt;/* Number of associated aux entries */

	Elf64_Word	vd_hash;/* Version name hash value */

	Elf64_Word	vd_aux;/* Offset in bytes to verdaux array */

	Elf64_Word	vd_next;/* Offset in bytes to next verdef
					   entry */

} Elf64_Verdef;
/* Legal values for vd_version (version revision).  */
/* No version */

#define VER_DEF_NONE 0
/* Current version */
#define VER_DEF_CURRENT 1
/* Given version number */
#define VER_DEF_NUM 2
/* Legal values for vd_flags (version information flags).  */
/* Version definition of file itself */

#define VER_FLG_BASE 0x1
/* Weak version identifier */
#define VER_FLG_WEAK 0x2
/* Versym symbol index values.  */
/* Symbol is local.  */

#define VER_NDX_LOCAL 0
/* Symbol is global.  */
#define VER_NDX_GLOBAL 1
/* Beginning of reserved entries.  */
#define VER_NDX_LORESERVE 0xff00
/* Symbol is to be eliminated.  */
#define VER_NDX_ELIMINATE 0xff01
/* Auxiliary version information.  */

typedef struct {
	Elf32_Word	vda_name;/* Version or dependency names */

	Elf32_Word	vda_next;/* Offset in bytes to next verdaux
					   entry */

} Elf32_Verdaux;

typedef struct {
	Elf64_Word	vda_name;/* Version or dependency names */

	Elf64_Word	vda_next;/* Offset in bytes to next verdaux
					   entry */

} Elf64_Verdaux;
/* Version dependency section.  */

typedef struct {
	Elf32_Half	vn_version;/* Version of structure */

	Elf32_Half	vn_cnt;/* Number of associated aux entries */

	Elf32_Word	vn_file;/* Offset of filename for this
					   dependency */

	Elf32_Word	vn_aux;/* Offset in bytes to vernaux array */

	Elf32_Word	vn_next;/* Offset in bytes to next verneed
					   entry */

} Elf32_Verneed;

typedef struct {
	Elf64_Half	vn_version;/* Version of structure */

	Elf64_Half	vn_cnt;/* Number of associated aux entries */

	Elf64_Word	vn_file;/* Offset of filename for this
					   dependency */

	Elf64_Word	vn_aux;/* Offset in bytes to vernaux array */

	Elf64_Word	vn_next;/* Offset in bytes to next verneed
					   entry */

} Elf64_Verneed;
/* Legal values for vn_version (version revision).  */
/* No version */

#define VER_NEED_NONE 0
/* Current version */
#define VER_NEED_CURRENT 1
/* Given version number */
#define VER_NEED_NUM 2
/* Auxiliary needed version information.  */

typedef struct {
	Elf32_Word	vna_hash;/* Hash value of dependency name */

	Elf32_Half	vna_flags;/* Dependency specific information */

	Elf32_Half	vna_other;/* Unused */

	Elf32_Word	vna_name;/* Dependency name string offset */

	Elf32_Word	vna_next;/* Offset in bytes to next vernaux
					   entry */

} Elf32_Vernaux;

typedef struct {
	Elf64_Word	vna_hash;/* Hash value of dependency name */

	Elf64_Half	vna_flags;/* Dependency specific information */

	Elf64_Half	vna_other;/* Unused */

	Elf64_Word	vna_name;/* Dependency name string offset */

	Elf64_Word	vna_next;/* Offset in bytes to next vernaux
					   entry */

} Elf64_Vernaux;
/* Legal values for vna_flags.  */
/* Weak version identifier */

#define VER_FLG_WEAK 0x2
/* Auxiliary vector.  */
/* This vector is normally only used by the program interpreter.  The
   usual definition in an ABI supplement uses the name auxv_t.  The
   vector is not usually defined in a standard <elf.h> file, but it
   can't hurt.  We rename it to avoid conflicts.  The sizes of these
   types are an arrangement between the exec server and the program
   interpreter, so we don't fully specify them here.  */
// 964 "elf.h"
typedef struct {
	uint32_t a_type;/* Entry type */

	union {
		uint32_t a_val;/* Integer value */

		/* We use to have pointer elements added here.  We cannot do that,
			 though, since it does not work when using 32-bit definitions
			 on 64-bit platforms and vice versa.  */

	} a_un;
} Elf32_auxv_t;

typedef struct {
	uint64_t a_type;/* Entry type */

	union {
		uint64_t a_val;/* Integer value */

		/* We use to have pointer elements added here.  We cannot do that,
			 though, since it does not work when using 32-bit definitions
			 on 64-bit platforms and vice versa.  */

	} a_un;
} Elf64_auxv_t;
/* Legal values for a_type (entry type).  */
/* End of vector */

#define AT_NULL 0
/* Entry should be ignored */
#define AT_IGNORE 1
/* File descriptor of program */
#define AT_EXECFD 2
/* Program headers for program */
#define AT_PHDR 3
/* Size of program header entry */
#define AT_PHENT 4
/* Number of program headers */
#define AT_PHNUM 5
/* System page size */
#define AT_PAGESZ 6
/* Base address of interpreter */
#define AT_BASE 7
/* Flags */
#define AT_FLAGS 8
/* Entry point of program */
#define AT_ENTRY 9
/* Program is not ELF */
#define AT_NOTELF 10
/* Real uid */
#define AT_UID 11
/* Effective uid */
#define AT_EUID 12
/* Real gid */
#define AT_GID 13
/* Effective gid */
#define AT_EGID 14
/* Frequency of times() */
#define AT_CLKTCK 17
/* Some more special a_type values describing the hardware.  */
/* String identifying platform.  */

#define AT_PLATFORM 15
/* Machine dependent hints about
					   processor capabilities.  */

#define AT_HWCAP 16
/* This entry gives some i\nformation about the FPU initialization
   performed by the kernel.  */
/* Used FPU control word.  */

#define AT_FPUCW 18
/* Cache block sizes.  */
/* Data cache block size.  */

#define AT_DCACHEBSIZE 19
/* Instruction cache block size.  */
#define AT_ICACHEBSIZE 20
/* Unified cache block size.  */
#define AT_UCACHEBSIZE 21
/* A special ignored value for PPC, used by the kernel to control the
   interpretation of the AUXV. Must be > 16.  */
/* Entry should be ignored.  */

#define AT_IGNOREPPC 22
/* Boolean, was exec setuid-like?  */

#define AT_SECURE 23
/* String identifying real platforms.*/

#define AT_BASE_PLATFORM 24
/* Address of 16 random bytes.  */

#define AT_RANDOM 25
/* Filename of executable.  */

#define AT_EXECFN 31
/* Pointer to the global system page used for system calls and other
   nice things.  */

#define AT_SYSINFO 32
#define AT_SYSINFO_EHDR 33
/* Shapes of the caches.  Bits 0-3 contains associativity; bits 4-7 contains
   log2 of line size; mask those to get cache size.  */

#define AT_L1I_CACHESHAPE 34
#define AT_L1D_CACHESHAPE 35
#define AT_L2_CACHESHAPE 36
#define AT_L3_CACHESHAPE 37
/* Note section contents.  Each entry in the note section begins with
   a header of a fixed form.  */

typedef struct {
	Elf32_Word n_namesz;/* Length of the note's name.  */

	Elf32_Word n_descsz;/* Length of the note's descriptor.  */

	Elf32_Word n_type;/* Type of the note.  */

} Elf32_Nhdr;

typedef struct {
	Elf64_Word n_namesz;/* Length of the note's name.  */

	Elf64_Word n_descsz;/* Length of the note's descriptor.  */

	Elf64_Word n_type;/* Type of the note.  */

} Elf64_Nhdr;
/* Known names of notes.  */
/* Solaris entries in the note section have this name.  */

#define ELF_NOTE_SOLARIS "SUNW Solaris"
/* Note entries for GNU systems have this name.  */

#define ELF_NOTE_GNU "GNU"
/* Defined types of notes for Solaris.  */
/* Value of descriptor (one word) is desired pagesize for the binary.  */

#define ELF_NOTE_PAGESIZE_HINT 1
/* Defined note types for GNU systems.  */
/* ABI information.  The descriptor consists of words:
   word 0: OS descriptor
   word 1: major version of the ABI
   word 2: minor version of the ABI
   word 3: subminor version of the ABI
*/
// 1085 "elf.h"
#define NT_GNU_ABI_TAG 1
/* Old name.  */
#define ELF_NOTE_ABI NT_GNU_ABI_TAG
/* Known OSes.  These values can appear in word 0 of an
   NT_GNU_ABI_TAG note section entry.  */

#define ELF_NOTE_OS_LINUX 0
#define ELF_NOTE_OS_GNU 1
#define ELF_NOTE_OS_SOLARIS2 2
#define ELF_NOTE_OS_FREEBSD 3
/* Synthetic hwcap information.  The descriptor begins with two words:
   word 0: number of entries
   word 1: bitmask of enabled entries
   Then follow variable-length entries, one byte followed by a
   '\0'-terminated hwcap name string.  The byte gives the bit
   number to test if enabled, (1U << bit) & bitmask.  */

#define NT_GNU_HWCAP 2
/* Build ID bits as generated by ld --build-id.
   The descriptor consists of any nonzero number of bytes.  */

#define NT_GNU_BUILD_ID 3
/* Version note generated by GNU gold containing a version string.  */

#define NT_GNU_GOLD_VERSION 4
/* Move records.  */

typedef struct {
	Elf32_Xword m_value;/* Symbol value.  */

	Elf32_Word m_info;/* Size and index.  */

	Elf32_Word m_poffset;/* Symbol offset.  */

	Elf32_Half m_repeat;/* Repeat count.  */

	Elf32_Half m_stride;/* Stride info.  */

} Elf32_Move;

typedef struct {
	Elf64_Xword m_value;/* Symbol value.  */

	Elf64_Xword m_info;/* Size and index.  */

	Elf64_Xword m_poffset;/* Symbol offset.  */

	Elf64_Half m_repeat;/* Repeat count.  */

	Elf64_Half m_stride;/* Stride info.  */

} Elf64_Move;
/* Macro to construct move records.  */

#define ELF32_M_SYM(info) ((info) >> 8)
#define ELF32_M_SIZE(info) ((unsigned char) (info))
#define ELF32_M_INFO(sym,size) (((sym) << 8) + (unsigned char) (size))

#define ELF64_M_SYM(info) ELF32_M_SYM (info)
#define ELF64_M_SIZE(info) ELF32_M_SIZE (info)
#define ELF64_M_INFO(sym,size) ELF32_M_INFO (sym, size)
/* Motorola 68k specific definitions.  */
/* Values for Elf32_Ehdr.e_flags.  */

#define EF_CPU32 0x00810000
/* m68k relocs.  */
/* No reloc */

#define R_68K_NONE 0
/* Direct 32 bit  */
#define R_68K_32 1
/* Direct 16 bit  */
#define R_68K_16 2
/* Direct 8 bit  */
#define R_68K_8 3
/* PC relative 32 bit */
#define R_68K_PC32 4
/* PC relative 16 bit */
#define R_68K_PC16 5
/* PC relative 8 bit */
#define R_68K_PC8 6
/* 32 bit PC relative GOT entry */
#define R_68K_GOT32 7
/* 16 bit PC relative GOT entry */
#define R_68K_GOT16 8
/* 8 bit PC relative GOT entry */
#define R_68K_GOT8 9
/* 32 bit GOT offset */
#define R_68K_GOT32O 10
/* 16 bit GOT offset */
#define R_68K_GOT16O 11
/* 8 bit GOT offset */
#define R_68K_GOT8O 12
/* 32 bit PC relative PLT address */
#define R_68K_PLT32 13
/* 16 bit PC relative PLT address */
#define R_68K_PLT16 14
/* 8 bit PC relative PLT address */
#define R_68K_PLT8 15
/* 32 bit PLT offset */
#define R_68K_PLT32O 16
/* 16 bit PLT offset */
#define R_68K_PLT16O 17
/* 8 bit PLT offset */
#define R_68K_PLT8O 18
/* Copy symbol at runtime */
#define R_68K_COPY 19
/* Create GOT entry */
#define R_68K_GLOB_DAT 20
/* Create PLT entry */
#define R_68K_JMP_SLOT 21
/* Adjust by program base */
#define R_68K_RELATIVE 22
/* 32 bit GOT offset for GD */
#define R_68K_TLS_GD32 25
/* 16 bit GOT offset for GD */
#define R_68K_TLS_GD16 26
/* 8 bit GOT offset for GD */
#define R_68K_TLS_GD8 27
/* 32 bit GOT offset for LDM */
#define R_68K_TLS_LDM32 28
/* 16 bit GOT offset for LDM */
#define R_68K_TLS_LDM16 29
/* 8 bit GOT offset for LDM */
#define R_68K_TLS_LDM8 30
/* 32 bit module-relative offset */
#define R_68K_TLS_LDO32 31
/* 16 bit module-relative offset */
#define R_68K_TLS_LDO16 32
/* 8 bit module-relative offset */
#define R_68K_TLS_LDO8 33
/* 32 bit GOT offset for IE */
#define R_68K_TLS_IE32 34
/* 16 bit GOT offset for IE */
#define R_68K_TLS_IE16 35
/* 8 bit GOT offset for IE */
#define R_68K_TLS_IE8 36
/* 32 bit offset relative to
					   static TLS block */

#define R_68K_TLS_LE32 37
/* 16 bit offset relative to
					   static TLS block */

#define R_68K_TLS_LE16 38
/* 8 bit offset relative to
					   static TLS block */

#define R_68K_TLS_LE8 39
/* 32 bit module number */
#define R_68K_TLS_DTPMOD32 40
/* 32 bit module-relative offset */
#define R_68K_TLS_DTPREL32 41
/* 32 bit TP-relative offset */
#define R_68K_TLS_TPREL32 42
/* Keep this the last entry.  */

#define R_68K_NUM 43
/* Intel 80386 specific definitions.  */
/* i386 relocs.  */
/* No reloc */

#define R_386_NONE 0
/* Direct 32 bit  */
#define R_386_32 1
/* PC relative 32 bit */
#define R_386_PC32 2
/* 32 bit GOT entry */
#define R_386_GOT32 3
/* 32 bit PLT address */
#define R_386_PLT32 4
/* Copy symbol at runtime */
#define R_386_COPY 5
/* Create GOT entry */
#define R_386_GLOB_DAT 6
/* Create PLT entry */
#define R_386_JMP_SLOT 7
/* Adjust by program base */
#define R_386_RELATIVE 8
/* 32 bit offset to GOT */
#define R_386_GOTOFF 9
/* 32 bit PC relative offset to GOT */
#define R_386_GOTPC 10
#define R_386_32PLT 11
/* Offset in static TLS block */
#define R_386_TLS_TPOFF 14
/* Address of GOT entry for static TLS
					   block offset */

#define R_386_TLS_IE 15
/* GOT entry for static TLS block
					   offset */

#define R_386_TLS_GOTIE 16
/* Offset relative to static TLS
					   block */

#define R_386_TLS_LE 17
/* Direct 32 bit for GNU version of
					   general dynamic thread local data */

#define R_386_TLS_GD 18
/* Direct 32 bit for GNU version of
					   local dynamic thread local data
					   in LE code */

#define R_386_TLS_LDM 19
#define R_386_16 20
#define R_386_PC16 21
#define R_386_8 22
#define R_386_PC8 23
/* Direct 32 bit for general dynamic
					   thread local data */

#define R_386_TLS_GD_32 24
/* Tag for pushl in GD TL\S code */
#define R_386_TLS_GD_PUSH 25
/* Relocation for call to
					   __tls_get_addr() */

#define R_386_TLS_GD_CALL 26
/* Tag for popl in GD TLS code */
#define R_386_TLS_GD_POP 27
/* Direct 32 bit for local dynamic
					   thread local data in LE code */

#define R_386_TLS_LDM_32 28
/* Tag for pushl in LDM TLS code */
#define R_386_TLS_LDM_PUSH 29
/* Relocation for call to
					   __tls_get_addr() in LDM code */

#define R_386_TLS_LDM_CALL 30
/* Tag for popl in LDM TLS code */
#define R_386_TLS_LDM_POP 31
/* Offset relative to TLS block */
#define R_386_TLS_LDO_32 32
/* GOT entry for negated static TLS
					   block offset */

#define R_386_TLS_IE_32 33
/* Negated offset relative to static
					   TLS block */

#define R_386_TLS_LE_32 34
/* ID of module containing symbol */
#define R_386_TLS_DTPMOD32 35
/* Offset in TLS block */
#define R_386_TLS_DTPOFF32 36
/* Negated offset in static TLS block */
#define R_386_TLS_TPOFF32 37
/* 38? */
/* GOT offset for TLS descriptor.  */

#define R_386_TLS_GOTDESC 39
/* Marker of call through TLS
					   descriptor for
					   relaxation.  */

#define R_386_TLS_DESC_CALL 40
/* TLS descriptor containing
					   pointer to code and to
					   argument, returning the TLS
					   offset for the symbol.  */

#define R_386_TLS_DESC 41
/* Adjust indirectly by program base */
#define R_386_IRELATIVE 42
/* 32 bit GOT entry, relaxable */
#define R_386_GOT32X 43
/* Keep this the last entry.  */

#define R_386_NUM 44
/* SUN SPARC specific definitions.  */
/* Legal values for ST_TYPE subfield of st_info (symbol type).  */
/* Global register reserved to app. */

#define STT_SPARC_REGISTER 13
/* Values for Elf64_Ehdr.e_flags.  */

#define EF_SPARCV9_MM 3
#define EF_SPARCV9_TSO 0
#define EF_SPARCV9_PSO 1
#define EF_SPARCV9_RMO 2
/* little endian data */
#define EF_SPARC_LEDATA 0x800000
#define EF_SPARC_EXT_MASK 0xFFFF00
/* generic V8+ features */
#define EF_SPARC_32PLUS 0x000100
/* Sun UltraSPARC1 extensions */
#define EF_SPARC_SUN_US1 0x000200
/* HAL R1 extensions */
#define EF_SPARC_HAL_R1 0x000400
/* Sun UltraSPARCIII extensions */
#define EF_SPARC_SUN_US3 0x000800
/* SPARC relocs.  */
/* No reloc */

#define R_SPARC_NONE 0
/* Direct 8 bit */
#define R_SPARC_8 1
/* Direct 16 bit */
#define R_SPARC_16 2
/* Direct 32 bit */
#define R_SPARC_32 3
/* PC relative 8 bit */
#define R_SPARC_DISP8 4
/* PC relative 16 bit */
#define R_SPARC_DISP16 5
/* PC relative 32 bit */
#define R_SPARC_DISP32 6
/* PC relative 30 bit shifted */
#define R_SPARC_WDISP30 7
/* PC relative 22 bit shifted */
#define R_SPARC_WDISP22 8
/* High 22 bit */
#define R_SPARC_HI22 9
/* Direct 22 bit */
#define R_SPARC_22 10
/* Direct 13 bit */
#define R_SPARC_13 11
/* Truncated 10 bit */
#define R_SPARC_LO10 12
/* Truncated 10 bit GOT entry */
#define R_SPARC_GOT10 13
/* 13 bit GOT entry */
#define R_SPARC_GOT13 14
/* 22 bit GOT entry shifted */
#define R_SPARC_GOT22 15
/* PC relative 10 bit truncated */
#define R_SPARC_PC10 16
/* PC relative 22 bit shifted */
#define R_SPARC_PC22 17
/* 30 bit PC relative PLT address */
#define R_SPARC_WPLT30 18
/* Copy symbol at runtime */
#define R_SPARC_COPY 19
/* Create GOT entry */
#define R_SPARC_GLOB_DAT 20
/* Create PLT entry */
#define R_SPARC_JMP_SLOT 21
/* Adjust by program base */
#define R_SPARC_RELATIVE 22
/* Direct 32 bit unaligned */
#define R_SPARC_UA32 23
/* Additional Sparc64 relocs.  */
/* Direct 32 bit ref to PLT entry */

#define R_SPARC_PLT32 24
/* High 22 bit PLT entry */
#define R_SPARC_HIPLT22 25
/* Truncated 10 bit PLT entry */
#define R_SPARC_LOPLT10 26
/* PC rel 32 bit ref to PLT entry */
#define R_SPARC_PCPLT32 27
/* PC rel high 22 bit PLT entry */
#define R_SPARC_PCPLT22 28
/* PC rel trunc 10 bit PLT entry */
#define R_SPARC_PCPLT10 29
/* Direct 10 bit */
#define R_SPARC_10 30
/* Direct 11 bit */
#define R_SPARC_11 31
/* Direct 64 bit */
#define R_SPARC_64 32
/* 10bit with secondary 13bit addend */
#define R_SPARC_OLO10 33
/* Top 22 bits of direct 64 bit */
#define R_SPARC_HH22 34
/* High middle 10 bits of ... */
#define R_SPARC_HM10 35
/* Low middle 22 bits of ... */
#define R_SPARC_LM22 36
/* Top 22 bits of pc rel 64 bit */
#define R_SPARC_PC_HH22 37
/* High middle 10 bit of ... */
#define R_SPARC_PC_HM10 38
/* Low middle 22 bits of ... */
#define R_SPARC_PC_LM22 39
/* PC relative 16 bit shifted */
#define R_SPARC_WDISP16 40
/* PC relative 19 bit shifted */
#define R_SPARC_WDISP19 41
/* was part of v9 ABI but was removed */
#define R_SPARC_GLOB_JMP 42
/* Direct 7 bit */
#define R_SPARC_7 43
/* Direct 5 bit */
#define R_SPARC_5 44
/* Direct 6 bit */
#define R_SPARC_6 45
/* PC relative 64 bit */
#define R_SPARC_DISP64 46
/* Direct 64 bit ref to PLT entry */
#define R_SPARC_PLT64 47
/* High 22 bit complemented */
#define R_SPARC_HIX22 48
/* Truncated 11 bit complemented */
#define R_SPARC_LOX10 49
/* Direct high 12 of 44 bit */
#define R_SPARC_H44 50
/* Direct mid 22 of 44 bit */
#define R_SPARC_M44 51
/* Direct low 10 of 44 bit */
#define R_SPARC_L44 52
/* Global register usage */
#define R_SPARC_REGISTER 53
/* Direct 64 bit unaligned */
#define R_SPARC_UA64 54
/* Direct 16 bit unaligned */
#define R_SPARC_UA16 55
#define R_SPARC_TLS_GD_HI22 56
#define R_SPARC_TLS_GD_LO10 57
#define R_SPARC_TLS_GD_ADD 58
#define R_SPARC_TLS_GD_CALL 59
#define R_SPARC_TLS_LDM_HI22 60
#define R_SPARC_TLS_LDM_LO10 61
#define R_SPARC_TLS_LDM_ADD 62
#define R_SPARC_TLS_LDM_CALL 63
#define R_SPARC_TLS_LDO_HIX22 64
#define R_SPARC_TLS_LDO_LOX10 65
#define R_SPARC_TLS_LDO_ADD 66
#define R_SPARC_TLS_IE_HI22 67
#define R_SPARC_TLS_IE_LO10 68
#define R_SPARC_TLS_IE_LD 69
#define R_SPARC_TLS_IE_LDX 70
#define R_SPARC_TLS_IE_ADD 71
#define R_SPARC_TLS_LE_HIX22 72
#define R_SPARC_TLS_LE_LOX10 73
#define R_SPARC_TLS_DTPMOD32 74
#define R_SPARC_TLS_DTPMOD64 75
#define R_SPARC_TLS_DTPOFF32 76
#define R_SPARC_TLS_DTPOFF64 77
#define R_SPARC_TLS_TPOFF32 78
#define R_SPARC_TLS_TPOFF64 79
#define R_SPARC_GOTDATA_HIX22 80
#define R_SPARC_GOTDATA_LOX10 81
#define R_SPARC_GOTDATA_OP_HIX22 82
#define R_SPARC_GOTDATA_OP_LOX10 83
#define R_SPARC_GOTDATA_OP 84
#define R_SPARC_H34 85
#define R_SPARC_SIZE32 86
#define R_SPARC_SIZE64 87
#define R_SPARC_WDISP10 88
#define R_SPARC_JMP_IREL 248
#define R_SPARC_IRELATIVE 249
#define R_SPARC_GNU_VTINHERIT 250
#define R_SPARC_GNU_VTENTRY 251
#define R_SPARC_REV32 252
/* Keep this the last entry.  */

#define R_SPARC_NUM 253
/* For Sparc64, legal values for d_tag of Elf64_Dyn.  */

#define DT_SPARC_REGISTER 0x70000001
#define DT_SPARC_NUM 2
/* MIPS R3000 specific definitions.  */
/* Legal values for e_flags field of Elf32_Ehdr.  */
/* A .noreorder directive was used */

#define EF_MIPS_NOREORDER 1
/* Contains PIC code */
#define EF_MIPS_PIC 2
/* Uses PIC calling sequence */
#define EF_MIPS_CPIC 4
#define EF_MIPS_XGOT 8
#define EF_MIPS_64BIT_WHIRL 16
#define EF_MIPS_ABI2 32
#define EF_MIPS_ABI_ON32 64
/* MIPS architecture level */
#define EF_MIPS_ARCH 0xf0000000
/* Legal values for MIPS architecture level.  */
/* -mips1 code.  */

#define EF_MIPS_ARCH_1 0x00000000
/* -mips2 code.  */
#define EF_MIPS_ARCH_2 0x10000000
/* -mips3 code.  */
#define EF_MIPS_ARCH_3 0x20000000
/* -mips4 code.  */
#define EF_MIPS_ARCH_4 0x30000000
/* -mips5 code.  */
#define EF_MIPS_ARCH_5 0x40000000
/* MIPS32 code.  */
#define EF_MIPS_ARCH_32 0x60000000
/* MIPS64 code.  */
#define EF_MIPS_ARCH_64 0x70000000
/* The following are non-official names and should not be used.  */
/* -mips1 code.  */

#define E_MIPS_ARCH_1 0x00000000
/* -mips2 code.  */
#define E_MIPS_ARCH_2 0x10000000
/* -mips3 code.  */
#define E_MIPS_ARCH_3 0x20000000
/* -mips4 code.  */
#define E_MIPS_ARCH_4 0x30000000
/* -mips5 code.  */
#define E_MIPS_ARCH_5 0x40000000
/* MIPS32 code.  */
#define E_MIPS_ARCH_32 0x60000000
/* MIPS64 code.  */
#define E_MIPS_ARCH_64 0x70000000
/* Special section indices.  */
/* Allocated common symbols */

#define SHN_MIPS_ACOMMON 0xff00
/* Allocated test symbols.  */
#define SHN_MIPS_TEXT 0xff01
/* Allocated data symbols. \ */
#define SHN_MIPS_DATA 0xff02
/* Small common symbols */
#define SHN_MIPS_SCOMMON 0xff03
/* Small undefined symbols */
#define SHN_MIPS_SUNDEFINED 0xff04
/* Legal values for sh_type field of Elf32_Shdr.  */
/* Shared objects used in link */

#define SHT_MIPS_LIBLIST 0x70000000
#define SHT_MIPS_MSYM 0x70000001
/* Conflicting symbols */
#define SHT_MIPS_CONFLICT 0x70000002
/* Global data area sizes */
#define SHT_MIPS_GPTAB 0x70000003
/* Reserved for SGI/MIPS compilers */
#define SHT_MIPS_UCODE 0x70000004
/* MIPS ECOFF debugging information*/
#define SHT_MIPS_DEBUG 0x70000005
/* Register usage information */
#define SHT_MIPS_REGINFO 0x70000006
#define SHT_MIPS_PACKAGE 0x70000007
#define SHT_MIPS_PACKSYM 0x70000008
#define SHT_MIPS_RELD 0x70000009
#define SHT_MIPS_IFACE 0x7000000b
#define SHT_MIPS_CONTENT 0x7000000c
/* Miscellaneous options.  */
#define SHT_MIPS_OPTIONS 0x7000000d
#define SHT_MIPS_SHDR 0x70000010
#define SHT_MIPS_FDESC 0x70000011
#define SHT_MIPS_EXTSYM 0x70000012
#define SHT_MIPS_DENSE 0x70000013
#define SHT_MIPS_PDESC 0x70000014
#define SHT_MIPS_LOCSYM 0x70000015
#define SHT_MIPS_AUXSYM 0x70000016
#define SHT_MIPS_OPTSYM 0x70000017
#define SHT_MIPS_LOCSTR 0x70000018
#define SHT_MIPS_LINE 0x70000019
#define SHT_MIPS_RFDESC 0x7000001a
#define SHT_MIPS_DELTASYM 0x7000001b
#define SHT_MIPS_DELTAINST 0x7000001c
#define SHT_MIPS_DELTACLASS 0x7000001d
/* DWARF debugging information.  */
#define SHT_MIPS_DWARF 0x7000001e
#define SHT_MIPS_DELTADECL 0x7000001f
#define SHT_MIPS_SYMBOL_LIB 0x70000020
/* Event section.  */
#define SHT_MIPS_EVENTS 0x70000021
#define SHT_MIPS_TRANSLATE 0x70000022
#define SHT_MIPS_PIXIE 0x70000023
#define SHT_MIPS_XLATE 0x70000024
#define SHT_MIPS_XLATE_DEBUG 0x70000025
#define SHT_MIPS_WHIRL 0x70000026
#define SHT_MIPS_EH_REGION 0x70000027
#define SHT_MIPS_XLATE_OLD 0x70000028
#define SHT_MIPS_PDR_EXCEPTION 0x70000029
/* Legal values for sh_flags field of Elf32_Shdr.  */
/* Must be part of global data area */

#define SHF_MIPS_GPREL 0x10000000
#define SHF_MIPS_MERGE 0x20000000
#define SHF_MIPS_ADDR 0x40000000
#define SHF_MIPS_STRINGS 0x80000000
#define SHF_MIPS_NOSTRIP 0x08000000
#define SHF_MIPS_LOCAL 0x04000000
#define SHF_MIPS_NAMES 0x02000000
#define SHF_MIPS_NODUPE 0x01000000
/* Symbol tables.  */
/* MIPS specific values for `st_other'.  */

#define STO_MIPS_DEFAULT 0x0
#define STO_MIPS_INTERNAL 0x1
#define STO_MIPS_HIDDEN 0x2
#define STO_MIPS_PROTECTED 0x3
#define STO_MIPS_PLT 0x8
#define STO_MIPS_SC_ALIGN_UNUSED 0xff
/* MIPS specific values for `st_info'.  */

#define STB_MIPS_SPLIT_COMMON 13
/* Entries found in sections of type SHT_MIPS_GPTAB.  */

typedef union {
	struct {
		Elf32_Word gt_current_g_value;/* -G value used for compilation */

		Elf32_Word gt_unused;/* Not used */

	} gt_header;/* First entry in section */

	struct {
		Elf32_Word gt_g_value;/* If this value were used for -G */

		Elf32_Word gt_bytes;/* This many bytes would be used */

	} gt_entry;/* Subsequent entries in section */

} Elf32_gptab;
/* Entry found in sections of type SHT_MIPS_REGINFO.  */

typedef struct {
	Elf32_Word	ri_gprmask;/* General registers used */

	Elf32_Word	ri_cprmask[4];/* Coprocessor registers used */

	Elf32_Sword	ri_gp_value;/* $gp register value */

} Elf32_RegInfo;
/* Entries found in sections of type SHT_MIPS_OPTIONS.  */

typedef struct {
	unsigned char kind;/* Determines interpretation of the
				   variable part of descriptor.  */

	unsigned char size;/* Size of descriptor, including header.  */

	Elf32_Section section;/* Section header index of section affected,
				   0 for global options.  */

	Elf32_Word info;/* Kind-specific information.  */

} Elf_Options;
/* Values for `kind' field in Elf_Options.  */
/* Undefined.  */

#define ODK_NULL 0
/* Register usage information.  */
#define ODK_REGINFO 1
/* Exception processing options.  */
#define ODK_EXCEPTIONS 2
/* Section padding options.  */
#define ODK_PAD 3
/* Hardware workarounds performed */
#define ODK_HWPATCH 4
/* record the fill value used by the linker. */
#define ODK_FILL 5
/* reserve space for desktop tools to write. */
#define ODK_TAGS 6
/* HW workarounds.  'AND' bits when merging. */
#define ODK_HWAND 7
/* HW workarounds.  'OR' bits when merging.  */
#define ODK_HWOR 8
/* Values for `info' in Elf_Options for ODK_EXCEPTIONS entries.  */
/* FPE's which MUST be enabled.  */

#define OEX_FPU_MIN 0x1f
/* FPE's which MAY be enabled.  */
#define OEX_FPU_MAX 0x1f00
/* page zero must be mapped.  */
#define OEX_PAGE0 0x10000
/* Force sequential memory mode?  */
#define OEX_SMM 0x20000
/* Force floating point debug mode?  */
#define OEX_FPDBUG 0x40000
#define OEX_PRECISEFP OEX_FPDBUG
/* Dismiss invalid address faults?  */
#define OEX_DISMISS 0x80000

#define OEX_FPU_INVAL 0x10
#define OEX_FPU_DIV0 0x08
#define OEX_FPU_OFLO 0x04
#define OEX_FPU_UFLO 0x02
#define OEX_FPU_INEX 0x01
/* Masks for `info' in Elf_Options for an ODK_HWPATCH entry.  */
/* R4000 end-of-page patch.  */

#define OHW_R4KEOP 0x1
/* may need R8000 prefetch patch.  */
#define OHW_R8KPFETCH 0x2
/* R5000 end-of-page patch.  */
#define OHW_R5KEOP 0x4
/* R5000 cvt.[ds].l bug.  clean=1.  */
#define OHW_R5KCVTL 0x8

#define OPAD_PREFIX 0x1
#define OPAD_POSTFIX 0x2
#define OPAD_SYMBOL 0x4
/* Entry found in `.options' section.  */

typedef struct {
	Elf32_Word hwp_flags1;/* Extra flags.  */

	Elf32_Word hwp_flags2;/* Extra flags.  */

} Elf_Options_Hw;
/* Masks for `info' in ElfOptions for ODK_HWAND and ODK_HWOR entries.  */

#define OHWA0_R4KEOP_CHECKED 0x00000001
#define OHWA1_R4KEOP_CLEAN 0x00000002
/* MIPS relocs.  */
/* No reloc */

#define R_MIPS_NONE 0
/* Direct 16 bit */
#define R_MIPS_16 1
/* Direct 32 bit */
#define R_MIPS_32 2
/* PC relative 32 bit */
#define R_MIPS_REL32 3
/* Direct 26 bit shifted */
#define R_MIPS_26 4
/* High 16 bit */
#define R_MIPS_HI16 5
/* Low 16 bit */
#define R_MIPS_LO16 6
/* GP relative 16 bit */
#define R_MIPS_GPREL16 7
/* 16 bit literal entry */
#define R_MIPS_LITERAL 8
/* 16 bit GOT entry */
#define R_MIPS_GOT16 9
/* PC relative 16 bit */
#define R_MIPS_PC16 10
/* 16 bit GOT entry for function */
#define R_MIPS_CALL16 11
/* GP relative 32 bit */
#define R_MIPS_GPREL32 12

#define R_MIPS_SHIFT5 16
#define R_MIPS_SHIFT6 17
#define R_MIPS_64 18
#define R_MIPS_GOT_DISP 19
#define R_MIPS_GOT_PAGE 20
#define R_MIPS_GOT_OFST 21
#define R_MIPS_GOT_HI16 22
#define R_MIPS_GOT_LO16 23
#define R_MIPS_SUB 24
#define R_MIPS_INSERT_A 25
#define R_MIPS_INSERT_B 26
#define R_MIPS_DELETE 27
#define R_MIPS_HIGHER 28
#define R_MIPS_HIGHEST 29
#define R_MIPS_CALL_HI16 30
#define R_MIPS_CALL_LO16 31
#define R_MIPS_SCN_DISP 32
#define R_MIPS_REL16 33
#define R_MIPS_ADD_IMMEDIATE 34
#define R_MIPS_PJUMP 35
#define R_MIPS_RELGOT 36
#define R_MIPS_JALR 37
/* Module number 32 bit */
#define R_MIPS_TLS_DTPMOD32 38
/* Module-relative offset 32 bit */
#define R_MIPS_TLS_DTPREL32 39
/* Module number 64 bit */
#define R_MIPS_TLS_DTPMOD64 40
/* Module-relative offset 64 bit */
#define R_MIPS_TLS_DTPREL64 41
/* 16 bit GOT offset for GD */
#define R_MIPS_TLS_GD 42
/* 16 bit GOT offset for LDM */
#define R_MIPS_TLS_LDM 43
/* Module-relative offset, high 16 bits */
#define R_MIPS_TLS_DTPREL_HI16 44
/* Module-relative offset, low 16 bits */
#define R_MIPS_TLS_DTPREL_LO16 45
/* 16 bit GOT offset for IE */
#define R_MIPS_TLS_GOTTPREL 46
/* TP-relative offset, 32 bit */
#define R_MIPS_TLS_TPREL32 47
/* TP-relative offset, 64 bit */
#define R_MIPS_TLS_TPREL64 48
/* TP-relative offset, high 16 bits */
#define R_MIPS_TLS_TPREL_HI16 49
/* TP-relative offset, low 16 bits */
#define R_MIPS_TLS_TPREL_LO16 50
#define R_MIPS_GLOB_DAT 51
#define R_MIPS_COPY 126
#define R_MIPS_JUMP_SLOT 127
/* Keep this the last entry.  */

#define R_MIPS_NUM 128
/* Legal values for p_type field of Elf32_Phdr.  */
/* Register usage information\ */

#define PT_MIPS_REGINFO 0x70000000
/* Runtime procedure table. */
#define PT_MIPS_RTPROC 0x70000001
#define PT_MIPS_OPTIONS 0x70000002
/* Special program header types.  */

#define PF_MIPS_LOCAL 0x10000000
/* Legal values for d_tag field of Elf32_Dyn.  */
/* Runtime linker interface version */

#define DT_MIPS_RLD_VERSION 0x70000001
/* Timestamp */
#define DT_MIPS_TIME_STAMP 0x70000002
/* Checksum */
#define DT_MIPS_ICHECKSUM 0x70000003
/* Version string (string tbl index) */
#define DT_MIPS_IVERSION 0x70000004
/* Flags */
#define DT_MIPS_FLAGS 0x70000005
/* Base address */
#define DT_MIPS_BASE_ADDRESS 0x70000006
#define DT_MIPS_MSYM 0x70000007
/* Address of CONFLICT section */
#define DT_MIPS_CONFLICT 0x70000008
/* Address of LIBLIST section */
#define DT_MIPS_LIBLIST 0x70000009
/* Number of local GOT entries */
#define DT_MIPS_LOCAL_GOTNO 0x7000000a
/* Number of CONFLICT entries */
#define DT_MIPS_CONFLICTNO 0x7000000b
/* Number of LIBLIST entries */
#define DT_MIPS_LIBLISTNO 0x70000010
/* Number of DYNSYM entries */
#define DT_MIPS_SYMTABNO 0x70000011
/* First external DYNSYM */
#define DT_MIPS_UNREFEXTNO 0x70000012
/* First GOT entry in DYNSYM */
#define DT_MIPS_GOTSYM 0x70000013
/* Number of GOT page table entries */
#define DT_MIPS_HIPAGENO 0x70000014
/* Address of run time loader map.  */
#define DT_MIPS_RLD_MAP 0x70000016
/* Delta C++ class definition.  */
#define DT_MIPS_DELTA_CLASS 0x70000017
/* Number of entries in
						DT_MIPS_DELTA_CLASS.  */

#define DT_MIPS_DELTA_CLASS_NO 0x70000018
/* Delta C++ class instances.  */
#define DT_MIPS_DELTA_INSTANCE 0x70000019
/* Number of entries in
						DT_MIPS_DELTA_INSTANCE.  */

#define DT_MIPS_DELTA_INSTANCE_NO 0x7000001a
/* Delta relocations.  */
#define DT_MIPS_DELTA_RELOC 0x7000001b
/* Number of entries in
					     DT_MIPS_DELTA_RELOC.  */

#define DT_MIPS_DELTA_RELOC_NO 0x7000001c
/* Delta symbols that Delta
					   relocations refer to.  */

#define DT_MIPS_DELTA_SYM 0x7000001d
/* Number of entries in
					   DT_MIPS_DELTA_SYM.  */

#define DT_MIPS_DELTA_SYM_NO 0x7000001e
/* Delta symbols that hold the
					     class declaration.  */

#define DT_MIPS_DELTA_CLASSSYM 0x70000020
/* Number of entries in
						DT_MIPS_DELTA_CLASSSYM.  */

#define DT_MIPS_DELTA_CLASSSYM_NO 0x70000021
/* Flags indicating for C++ flavor.  */
#define DT_MIPS_CXX_FLAGS 0x70000022
#define DT_MIPS_PIXIE_INIT 0x70000023
#define DT_MIPS_SYMBOL_LIB 0x70000024
#define DT_MIPS_LOCALPAGE_GOTIDX 0x70000025
#define DT_MIPS_LOCAL_GOTIDX 0x70000026
#define DT_MIPS_HIDDEN_GOTIDX 0x70000027
#define DT_MIPS_PROTECTED_GOTIDX 0x70000028
/* Address of .options.  */
#define DT_MIPS_OPTIONS 0x70000029
/* Address of .interface.  */
#define DT_MIPS_INTERFACE 0x7000002a
#define DT_MIPS_DYNSTR_ALIGN 0x7000002b
/* Size of the .interface section. */
#define DT_MIPS_INTERFACE_SIZE 0x7000002c
/* Address of rld_text_rsolve
						    function stored in GOT.  */

#define DT_MIPS_RLD_TEXT_RESOLVE_ADDR 0x7000002d
/* Default suffix of dso to be added
					   by rld on dlopen() calls.  */

#define DT_MIPS_PERF_SUFFIX 0x7000002e
/* (O32)Size of compact rel section. */
#define DT_MIPS_COMPACT_SIZE 0x7000002f
/* GP value for aux GOTs.  */
#define DT_MIPS_GP_VALUE 0x70000030
/* Address of aux .dynamic.  */
#define DT_MIPS_AUX_DYNAMIC 0x70000031
/* The address of .got.plt in an executable using the new non-PIC ABI.  */

#define DT_MIPS_PLTGOT 0x70000032
/* The base of the PLT in an executable using the new non-PIC ABI if that
   PLT is writable.  For a non-writable PLT, this is omitted or has a zero
   value.  */

#define DT_MIPS_RWPLT 0x70000034
#define DT_MIPS_NUM 0x35
/* Legal values for DT_MIPS_FLAGS Elf32_Dyn entry.  */
/* No flags */

#define RHF_NONE 0
/* Use quickstart */
#define RHF_QUICKSTART (1 << 0)
/* Hash size not power of 2 */
#define RHF_NOTPOT (1 << 1)
/* Ignore LD_LIBRARY_PATH */
#define RHF_NO_LIBRARY_REPLACEMENT (1 << 2)
#define RHF_NO_MOVE (1 << 3)
#define RHF_SGI_ONLY (1 << 4)
#define RHF_GUARANTEE_INIT (1 << 5)
#define RHF_DELTA_C_PLUS_PLUS (1 << 6)
#define RHF_GUARANTEE_START_INIT (1 << 7)
#define RHF_PIXIE (1 << 8)
#define RHF_DEFAULT_DELAY_LOAD (1 << 9)
#define RHF_REQUICKSTART (1 << 10)
#define RHF_REQUICKSTARTED (1 << 11)
#define RHF_CORD (1 << 12)
#define RHF_NO_UNRES_UNDEF (1 << 13)
#define RHF_RLD_ORDER_SAFE (1 << 14)
/* Entries found in sections of type SHT_MIPS_LIBLIST.  */

typedef struct {
	Elf32_Word l_name;/* Name (string table index) */

	Elf32_Word l_time_stamp;/* Timestamp */

	Elf32_Word l_checksum;/* Checksum */

	Elf32_Word l_version;/* Interface version */

	Elf32_Word l_flags;/* Flags */

} Elf32_Lib;

typedef struct {
	Elf64_Word l_name;/* Name (string table index) */

	Elf64_Word l_time_stamp;/* Timestamp */

	Elf64_Word l_checksum;/* Checksum */

	Elf64_Word l_version;/* Interface version */

	Elf64_Word l_flags;/* Flags */

} Elf64_Lib;
/* Legal values for l_flags.  */

#define LL_NONE 0
/* Require exact match */
#define LL_EXACT_MATCH (1 << 0)
/* Ignore interface version */
#define LL_IGNORE_INT_VER (1 << 1)
#define LL_REQUIRE_MINOR (1 << 2)
#define LL_EXPORTS (1 << 3)
#define LL_DELAY_LOAD (1 << 4)
#define LL_DELTA (1 << 5)
/* Entries found in sections of type SHT_MIPS_CONFLICT.  */

typedef Elf32_Addr Elf32_Conflict;
/* HPPA specific definitions.  */
/* Legal values for e_flags field of Elf32_Ehdr.  */
/* Trap nil pointer dereference.  */

#define EF_PARISC_TRAPNIL 0x00010000
/* Program uses arch. extensions. */
#define EF_PARISC_EXT 0x00020000
/* Program expects little endian. */
#define EF_PARISC_LSB 0x00040000
/* Program expects wide mode.  */
#define EF_PARISC_WIDE 0x00080000
/* No kernel assisted branch
					      prediction.  */

#define EF_PARISC_NO_KABP 0x00100000
/* Allow lazy swapping.  */
#define EF_PARISC_LAZYSWAP 0x00400000
/* Architecture version.  */
#define EF_PARISC_ARCH 0x0000ffff
/* Defined values for `e_flags & EF_PARISC_ARCH' are:  */
/* PA-RISC 1.0 big-endian.  */

#define EFA_PARISC_1_0 0x020b
/* PA-RISC 1.1 big-endian.  */
#define EFA_PARISC_1_1 0x0210
/* PA-RISC 2.0 big-endian.  */
#define EFA_PARISC_2_0 0x0214
/* Additional section indices.  */
/* Section for tentatively declared
					      symbols in ANSI C.  */

#define SHN_PARISC_ANSI_COMMON 0xff00
/* Common blocks in huge model.  */
#define SHN_PARISC_HUGE_COMMON 0xff01
/* Legal values for sh_type field of Elf32_Shdr.  */
/* Contains product specific ext. */

#define SHT_PARISC_EXT 0x70000000
/* Unwind information.  */
#define SHT_PARISC_UNWIND 0x70000001
/* Debug info for optimized code. */
#define SHT_PARISC_DOC 0x70000002
/* Legal values for sh_flags field of Elf32_Shdr.  */
/* Section with short addressing. */

#define SHF_PARISC_SHORT 0x20000000
/* Section far from gp.  */
#define SHF_PARISC_HUGE 0x40000000
/* Static branch prediction code. */
#define SHF_PARISC_SBP 0x80000000
/* Legal values for ST_TYPE subfield of st_info (symbol type).  */
/* Millicode function entry point.  */

#define STT_PARISC_MILLICODE 13

#define STT_HP_OPAQUE (STT_LOOS + 0x1)
#define STT_HP_STUB (STT_LOOS + 0x2)
/* HPPA relocs.  */
/* No reloc.  */

#define R_PARISC_NONE 0
/* Direct 32-bit reference.  */
#define R_PARISC_DIR32 1
/* Left 21 bits of eff. address.  */
#define R_PARISC_DIR21L 2
/* Right 17 bits of eff. address.  */
#define R_PARISC_DIR17R 3
/* 17 bits of eff. address.  */
#define R_PARISC_DIR17F 4
/* Right 14 bits of eff. address.  */
#define R_PARISC_DIR14R 6
/* 32-bit rel. address.  */
#define R_PARISC_PCREL32 9
/* Left 21 bits of rel. address.  */
#define R_PARISC_PCREL21L 10
/* Right 17 bits of rel. address.  */
#define R_PARISC_PCREL17R 11
/* 17 bits of rel. address.  */
#define R_PARISC_PCREL17F 12
/* Right 14 bits of rel. address.  */
#define R_PARISC_PCREL14R 14
/* Left 21 bits of rel. address.  */
#define R_PARISC_DPREL21L 18
/* Right 14 bits of rel. address.  */
#define R_PARISC_DPREL14R 22
/* GP-relative, left 21 bits.  */
#define R_PARISC_GPREL21L 26
/* GP-relative, right 14 bits.  */
#define R_PARISC_GPREL14R 30
/* LT-relative, left 21 bits.  */
#define R_PARISC_LTOFF21L 34
/* LT-relative, right 14 bits.  */
#define R_PARISC_LTOFF14R 38
/* 32 bits section rel. address.  */
#define R_PARISC_SECREL32 41
/* No relocation, set segment base.  */
#define R_PARISC_SEGBASE 48
/* 32 bits segment rel. address.  */
#define R_PARISC_SEGREL32 49
/* PLT rel. address, left 21 bits.  */
#define R_PARISC_PLTOFF21L 50
/* PLT rel. address, right 14 bits.  */
#define R_PARISC_PLTOFF14R 54
/* 32 bits LT-rel. function pointer. */
#define R_PARISC_LTOFF_FPTR32 57
/* LT-rel. fct ptr, left 21 bits. */
#define R_PARISC_LTOFF_FPTR21L 58
/* LT-rel. fct ptr, right 14 bits. */
#define R_PARISC_LTOFF_FPTR14R 62
/* 64 bits function address.  */
#define R_PARISC_FPTR64 64
/* 32 bits function address.  */
#define R_PARISC_PLABEL32 65
/* Left 21 bits of fdesc address.  */
#define R_PARISC_PLABEL21L 66
/* Right 14 bits of fdesc address.  */
#define R_PARISC_PLABEL14R 70
/* 64 bits PC-rel. address.  */
#define R_PARISC_PCREL64 72
/* 22 bits PC-rel. address.  */
#define R_PARISC_PCREL22F 74
/* PC-rel. address, right 14 bits.  */
#define R_PARISC_PCREL14WR 75
/* PC rel. address, right 14 bits.  */
#define R_PARISC_PCREL14DR 76
/* 16 bits PC-rel. address.  */
#define R_PARISC_PCREL16F 77
/* 16 bits PC-rel. address.  */
#define R_PARISC_PCREL16WF 78
/* 16 bits PC-rel. address.  */
#define R_PARISC_PCREL16DF 79
/* 64 bits of eff. address.  */
#define R_PARISC_DIR64 80
/* 14 bits of eff. address.  */
#define R_PARISC_DIR14WR 83
/* 14 bits of eff. address.  */
#define R_PARISC_DIR14DR 84
/* 16 bits of eff. address.  */
#define R_PARISC_DIR16F 85
/* 16 bits of eff. address.  */
#define R_PARISC_DIR16WF 86
/* 16 bits of eff. address.  */
#define R_PARISC_DIR16DF 87
/* 64 bits of GP-rel. address.  */
#define R_PARISC_GPREL64 88
/* GP-rel. address, right 14 bits.  */
#define R_PARISC_GPREL14WR 91
/* GP-rel. address, right 14 bits.  */
#define R_PARISC_GPREL14DR 92
/* 16 bits GP-rel. address.  */
#define R_PARISC_GPREL16F 93
/* 16 bits GP-rel. address.  */
#define R_PARISC_GPREL16WF 94
/* 16 bits GP-rel. address.  */
#define R_PARISC_GPREL16DF 95
/* 64 bits LT-rel. address.  */
#define R_PARISC_LTOFF64 96
/* LT-rel. address, right 14 bits.  */
#define R_PARISC_LTOFF14WR 99
/* LT-rel. address, right 14 bits.  */
#define R_PARISC_LTOFF14DR 100
/* 16 bits LT-rel. address.  */
#define R_PARISC_LTOFF16F 101
/* 16 bits LT-rel. address.  */
#define R_PARISC_LTOFF16WF 102
/* 16 bits LT-rel. address.  */
#define R_PARISC_LTOFF16DF 103
/* 64 bits section rel. address.  */
#define R_PARISC_SECREL64 104
/* 64 bits segment rel. address.  */
#define R_PARISC_SEGREL64 112
/* PLT-rel. address, right 14 bits.  */
#define R_PARISC_PLTOFF14WR 115
/* PLT-rel. address, right 14 bits.  */
#define R_PARISC_PLTOFF14DR 116
/* 16 bits LT-rel. address.  */
#define R_PARISC_PLTOFF16F 117
/* 16 bits PLT-rel. address.  */
#define R_PARISC_PLTOFF16WF 118
/* 16 bits PLT-rel. address.  */
#define R_PARISC_PLTOFF16DF 119
/* 64 bits LT-rel. function ptr.  */
#define R_PARISC_LTOFF_FPTR64 120
/* LT-rel. fct. ptr., right 14 bits. */
#define R_PARISC_LTOFF_FPTR14WR 123
/* LT-rel. fct. ptr., right 14 bits. */
#define R_PARISC_LTOFF_FPTR14DR 124
/* 16 bits LT-rel. function ptr.  */
#define R_PARISC_LTOFF_FPTR16F 125
/* 16 bits LT-rel. function ptr.  */
#define R_PARISC_LTOFF_FPTR16WF 126
/* 16 bits LT-rel. function ptr.  */
#define R_PARISC_LTOFF_FPTR16DF 127
#define R_PARISC_LORESERVE 128
/* Copy relocation.  */
#define R_PARISC_COPY 128
/* Dynamic reloc, imported PLT */
#define R_PARISC_IPLT 129
/* Dynamic reloc, exported PLT */
#define R_PARISC_EPLT 130
/* 32 bits TP-rel. address.  */
#define R_PARISC_TPREL32 153
/* TP-rel. address, left 21 bits.  */
#define R_PARISC_TPREL21L 154
/* TP-rel. address, right 14 bits.  */
#define R_PARISC_TPREL14R 158
/* LT-TP-rel. address, left 21 bits. */
#define R_PARISC_LTOFF_TP21L 162
/* LT-TP-rel. address, right 14 bits.*/
#define R_PARISC_LTOFF_TP14R 166
/* 14 bits LT-TP-rel. address.  */
#define R_PARISC_LTOFF_TP14F 167
/* 64 bits TP-rel. address.  */
#define R_PARISC_TPREL64 216
/* TP-rel. address, right 14 bits.  */
#define R_PARISC_TPREL14WR 219
/* TP-rel. address, right 14 bits.  */
#define R_PARISC_TPREL14DR 220
/* 16 bits TP-rel. address.  */
#define R_PARISC_TPREL16F 221
/* 16 bits TP-rel. address.  */
#define R_PARISC_TPREL16WF 222
/* 16 bits TP-rel. address.  */
#define R_PARISC_TPREL16DF 223
/* 64 bits LT-TP-rel. address.  */
#define R_PARISC_LTOFF_TP64 224
/* LT-TP-rel. address, right 14 bits.*/
#define R_PARISC_LTOFF_TP14WR 227
/* LT-TP-rel. address, right 14 bits.*/
#define R_PARISC_LTOFF_TP14DR 228
/* 16 bits LT-TP-rel. address.  */
#define R_PARISC_LTOFF_TP16F 229
/* 16 bits LT-TP-rel. address.  */
#define R_PARISC_LTOFF_TP16WF 230
/* 16 bits LT-TP-rel. address.  */
#define R_PARISC_LTOFF_TP16DF 231
#define R_PARISC_GNU_VTENTRY 232
#define R_PARISC_GNU_VTINHERIT 233
/* GD 21-bit left.  */
#define R_PARISC_TLS_GD21L 234
/* GD 14-bit right.  */
#define R_PARISC_TLS_GD14R 235
/* GD call to __t_g_a.  */
#define R_PARISC_TLS_GDCALL 236
/* LD module 21-bit left.  */
#define R_PARISC_TLS_LDM21L 237
/* LD module 14-bit right.  */
#define R_PARISC_TLS_LDM14R 238
/* LD module call to __t_g_a.  */
#define R_PARISC_TLS_LDMCALL 239
/* LD offset 21-bit left.  */
#define R_PARISC_TLS_LDO21L 240
/* LD offset 14-bit right.  */
#define R_PARISC_TLS_LDO14R 241
/* DTP module 32-bit.  */
#define R_PARISC_TLS_DTPMOD32 242
/* DTP module 64-bit.  */
#define R_PARISC_TLS_DTPMOD64 243
/* DTP offset 32-bit.  */
#define R_PARISC_TLS_DTPOFF32 244
/* DTP offset 32-bit.  */
#define R_PARISC_TLS_DTPOFF64 245
#define R_PARISC_TLS_LE21L R_PARISC_TPREL21L
#define R_PARISC_TLS_LE14R R_PARISC_TPREL14R
#define R_PARISC_TLS_IE21L R_PARISC_LTOFF_TP21L
#define R_PARISC_TLS_IE14R R_PARISC_LTOFF_TP14R
#define R_PARISC_TLS_TPREL32 R_PARISC_TPREL32
#define R_PARISC_TLS_TPREL64 R_PARISC_TPREL64
#define R_PARISC_HIRESERVE 255
/* Legal values for p_type field of Elf32_Phdr/Elf64_Phdr.  */

#define PT_HP_TLS (PT_LOOS + 0x0)
#define PT_HP_CORE_NONE (PT_LOOS + 0x1)
#define PT_HP_CORE_VERSION (PT_LOOS + 0x2)
#define PT_HP_CORE_KERNEL (PT_LOOS + 0x3)
#define PT_HP_CORE_COMM (PT_LOOS + 0x4)
#define PT_HP_CORE_PROC (PT_LOOS + 0x5)
#define PT_HP_CORE_LOADABLE (PT_LOOS + 0x6)
#define PT_HP_CORE_STACK (PT_LOOS + 0x7)
#define PT_HP_CORE_SHM (PT_LOOS + 0x8)
#define PT_HP_CORE_MMF (PT_LOOS + 0x9)
#define PT_HP_PARALLEL (PT_LOOS + 0x10)
#define PT_HP_FASTBIND (PT_LOOS + 0x11)
#define PT_HP_OPT_ANNOT (PT_LOOS + 0x12)
#define PT_HP_HSL_ANNOT (PT_LOOS + 0x13)
#define PT_HP_STACK (PT_LOOS + 0x14)

#define PT_PARISC_ARCHEXT 0x70000000
#define PT_PARISC_UNWIND 0x70000001
/* Legal values for p_flags field of Elf32_Phdr/Elf64_Phdr.  */

#define PF_PARISC_SBP 0x08000000

#define PF_HP_PAGE_SIZE 0x00100000
#define PF_HP_FAR_SHARED 0x00200000
#define PF_HP_NEAR_SHARED 0x00400000
#define PF_HP_CODE 0x01000000
#define PF_HP_MODIFY 0x02000000
#define PF_HP_LAZYSWAP 0x04000000
#define PF_HP_SBP 0x08000000
/* Alpha specific definitions.  */
/* Legal values for e_flags field of Elf64_Ehdr.  */
/* All addresses must be < 2GB.  */

#define EF_ALPHA_32BIT 1
/* Relocations for relaxing exist.  */
#define EF_ALPHA_CANRELAX 2
/* Legal values for sh_type field of Elf64_Shdr.  */
/* These two are primarily concerned with ECOFF debugging info.  */

#define SHT_ALPHA_DEBUG 0x70000001
#define SHT_ALPHA_REGINFO 0x70000002
/* Legal values for sh_flags field of Elf64_Shdr.  */

#define SHF_ALPHA_GPREL 0x10000000
/* Legal values for st_other field of Elf64_Sym.  */
/* No PV required.  */

#define STO_ALPHA_NOPV 0x80
/* PV only used for initial ldgp.  */
#define STO_ALPHA_STD_GPLOAD 0x88
/* Alpha relocs.  */
/* No reloc */

#define R_ALPHA_NONE 0
/* Direct 32 bit */
#define R_ALPHA_REFLONG 1
/* Direct 64 bit */
#define R_ALPHA_REFQUAD 2
/* GP relative 32 bit */
#define R_ALPHA_GPREL32 3
/* GP relative 16 bit w/optimization */
#define R_ALPHA_LITERAL 4
/* Optimization hint for LITERAL */
#define R_ALPHA_LITUSE 5
/* Add displacement to GP */
#define R_ALPHA_GPDISP 6
/* PC+4 relative 23 bit shifted */
#define R_ALPHA_BRADDR 7
/* PC+4 relative 16 bit shifted */
#define R_ALPHA_HINT 8
/* PC relative 16 bit */
#define R_ALPHA_SREL16 9
/* PC relative 32 bit */
#define R_ALPHA_SREL32 10
/* PC relative 64 bit */
#define R_ALPHA_SREL64 11
/* GP relative 32 bit, high 16 bits */
#define R_ALPHA_GPRELHIGH 17
/* GP relative 32 bit, low 16 bits */
#define R_ALPHA_GPRELLOW 18
/* GP relative 16 bit */
#define R_ALPHA_GPREL16 19
/* Copy symbol at runtime */
#define R_ALPHA_COPY 24
/* Create GOT entry */
#define R_ALPHA_GLOB_DAT 25
/* Create PLT entry */
#define R_ALPHA_JMP_SLOT 26
/* Adjust by program base */
#define R_ALPHA_RELATIVE 27
#define R_ALPHA_TLS_GD_HI 28
#define R_ALPHA_TLSGD 29
#define R_ALPHA_TLS_LDM 30
#define R_ALPHA_DTPMOD64 31
#define R_ALPHA_GOTDTPREL 32
#define R_ALPHA_DTPREL64 33
#define R_ALPHA_DTPRELHI 34
#define R_ALPHA_DTPRELLO 35
#define R_ALPHA_DTPREL16 36
#define R_ALPHA_GOTTPREL 37
#define R_ALPHA_TPREL64 38
#define R_ALPHA_TPRELHI 39
#define R_ALPHA_TPRELLO 40
#define R_ALPHA_TPREL16 41
/* Keep this the last entry.  */

#define R_ALPHA_NUM 46
/* Magic values of the LITUSE relocation addend.  */

#define LITUSE_ALPHA_ADDR 0
#define LITUSE_ALPHA_BASE 1
#define LITUSE_ALPHA_BYTOFF 2
#define LITUSE_ALPHA_JSR 3
#define LITUSE_ALPHA_TLS_GD 4
#define LITUSE_ALPHA_TLS_LDM 5
/* Legal values for d_tag of Elf64_Dyn.  */

#define DT_ALPHA_PLTRO (DT_LOPROC + 0)
#define DT_ALPHA_NUM 1
/* PowerPC specific declarations */
/* Values for Elf32/64_Ehdr.e_flags.  */
/* PowerPC embedded flag */

#define EF_PPC_EMB 0x80000000
/* Cygnus local bits below */
/* PowerPC -mrelocatable flag*/

#define EF_PPC_RELOCATABLE 0x00010000
/* PowerPC -mrelocatable-lib
						   flag */

#define EF_PPC_RELOCATABLE_LIB 0x00008000
/* PowerPC relocations defined by the ABIs */

#define R_PPC_NONE 0
/* 32bit absolute address */
#define R_PPC_ADDR32 1
/* 26bit address, 2 bits ignored.  */
#define R_PPC_ADDR24 2
/* 16bit absolute address */
#define R_PPC_ADDR16 3
/* lower 16bit of absolute address */
#define R_PPC_ADDR16_LO 4
/* high 16bit of absolute address */
#define R_PPC_ADDR16_HI 5
/* adjusted high 16bit */
#define R_PPC_ADDR16_HA 6
/* 16bit address, 2 bits ignored */
#define R_PPC_ADDR14 7
#define R_PPC_ADDR14_BRTAKEN 8
#define R_PPC_ADDR14_BRNTAKEN 9
/* PC relative 26 bit */
#define R_PPC_REL24 10
/* PC relative 16 bit */
#define R_PPC_REL14 11
#define R_PPC_REL14_BRTAKEN 12
#define R_PPC_REL14_BRNTAKEN 13
#define R_PPC_GOT16 14
#define R_PPC_GOT16_LO 15
#define R_PPC_GOT16_HI 16
#define R_PPC_GOT16_HA 17
#define R_PPC_PLTREL24 18
#define R_PPC_COPY 19
#define R_PPC_GLOB_DAT 20
#define R_PPC_JMP_SLOT 21
#define R_PPC_RELATIVE 22
#define R_PPC_LOCAL24PC 23
#define R_PPC_UADDR32 24
#define R_PPC_UADDR16 25
#define R_PPC_REL32 26
#define R_PPC_PLT32 27
#define R_PPC_PLTREL32 28
#define R_PPC_PLT16_LO 29
#define R_PPC_PLT16_HI 30
#define R_PPC_PLT16_HA 31
#define R_PPC_SDAREL16 32
#define R_PPC_SECTOFF 33
#define R_PPC_SECTOFF_LO 34
#define R_PPC_SECTOFF_HI 35
#define R_PPC_SECTOFF_HA 36
/* PowerPC relocations defined for the TLS access ABI.  */
/* none	(sym+add)@tls */

#define R_PPC_TLS 67
/* word32	(sym+add)@dtpmod */
#define R_PPC_DTPMOD32 68
/* half16*	(sym+add)@tprel */
#define R_PPC_TPREL16 69
/* half16	(sym+add)@tprel@l */
#define R_PPC_TPREL16_LO 70
/* half16	(sym+add)@tprel@h */
#define R_PPC_TPREL16_HI 71
/* half16	(sym+add)@tprel@ha */
#define R_PPC_TPREL16_HA 72
/* word32	(sym+add)@tprel */
#define R_PPC_TPREL32 73
/* half16*	(sym+add)@dtprel */
#define R_PPC_DTPREL16 74
/* half16	(sym+add)@dtprel@l */
#define R_PPC_DTPREL16_LO 75
/* half16	(sym+add)@dtprel@h */
#define R_PPC_DTPREL16_HI 76
/* half16	(sym+add)@dtprel@ha */
#define R_PPC_DTPREL16_HA 77
/* word32	(sym+add)@dtprel */
#define R_PPC_DTPREL32 78
/* half16*	(sym+add)@got@tlsgd */
#define R_PPC_GOT_TLSGD16 79
/* half16	(sym+add)@got@tlsgd@l */
#define R_PPC_GOT_TLSGD16_LO 80
/* half16	(sym+add)@got@tlsgd@h */
#define R_PPC_GOT_TLSGD16_HI 81
/* half16	(sym+add)@got@tlsgd@ha */
#define R_PPC_GOT_TLSGD16_HA 82
/* half16*	(sym+add)@got@tlsld */
#define R_PPC_GOT_TLSLD16 83
/* half16	(sym+add)@got@tlsld@l */
#define R_PPC_GOT_TLSLD16_LO 84
/* half16	(sym+add)@got@tlsld@h */
#define R_PPC_GOT_TLSLD16_HI 85
/* half16	(sym+add)@got@tlsld@ha */
#define R_PPC_GOT_TLSLD16_HA 86
/* half16*	(sym+add)@got@tprel */
#define R_PPC_GOT_TPREL16 87
/* half16	(sym+add)@got@tprel@l */
#define R_PPC_GOT_TPREL16_LO 88
/* half16	(sym+add)@got@tprel@h */
#define R_PPC_GOT_TPREL16_HI 89
/* half16	(sym+add)@got@tprel@ha */
#define R_PPC_GOT_TPREL16_HA 90
/* half16*	(sym+add)@got@dtprel */
#define R_PPC_GOT_DTPREL16 91
/* half16*	(sym+add)@got@dtprel@l */
#define R_PPC_GOT_DTPREL16_LO 92
/* half16*	(sym+add)@got@dtprel@h */
#define R_PPC_GOT_DTPREL16_HI 93
/* half16*	(sym+add)@got@dtprel@ha */
#define R_PPC_GOT_DTPREL16_HA 94
/* The remaining relocs are from the Embedded ELF ABI, and are not
   in the SVR4 ELF ABI.  */

#define R_PPC_EMB_NADDR32 101
#define R_PPC_EMB_NADDR16 102
#define R_PPC_EMB_NADDR16_LO 103
#define R_PPC_EMB_NADDR16_HI 104
#define R_PPC_EMB_NADDR16_HA 105
#define R_PPC_EMB_SDAI16 106
#define R_PPC_EMB_SDA2I16 107
#define R_PPC_EMB_SDA2REL 108
/* 16 bit offset in SDA */
#define R_PPC_EMB_SDA21 109
#define R_PPC_EMB_MRKREF 110
#define R_PPC_EMB_RELSEC16 111
#define R_PPC_EMB_RELST_LO 112
#define R_PPC_EMB_RELST_HI 113
#define R_PPC_EMB_RELST_HA 114
#define R_PPC_EMB_BIT_FLD 115
/* 16 bit relative offset in SDA */
#define R_PPC_EMB_RELSDA 116
/* Diab tool relocations.  */
/* like EMB_SDA21, but lower 16 bit */

#define R_PPC_DIAB_SDA21_LO 180
/* like EMB_SDA21, but high 16 bit */
#define R_PPC_DIAB_SDA21_HI 181
/* like EMB_SDA21, adjusted high 16 */
#define R_PPC_DIAB_SDA21_HA 182
/* like EMB_RELSDA, but lower 16 bit */
#define R_PPC_DIAB_RELSDA_LO 183
/* like EMB_RELSDA, but high 16 bit */
#define R_PPC_DIAB_RELSDA_HI 184
/* like EMB_RELSDA, adjusted high 16 */
#define R_PPC_DIAB_RELSDA_HA 185
/* GNU extension to support local ifunc.  */

#define R_PPC_IRELATIVE 248
/* GNU relocs used in PIC code sequences.  */
/* half16   (sym+add-.) */

#define R_PPC_REL16 249
/* half16   (sym+add-.)@l */
#define R_PPC_REL16_LO 250
/* half16   (sym+add-.)@h */
#define R_PPC_REL16_HI 251
/* half16   (sym+add-.)@ha */
#define R_PPC_REL16_HA 252
/* This is a phony reloc to handle any old fashioned TOC16 references
   that may still be in object files.  */

#define R_PPC_TOC16 255
/* PowerPC specific values for the Dyn d_tag field.  */

#define DT_PPC_GOT (DT_LOPROC + 0)
#define DT_PPC_NUM 1
/* PowerPC64 relocations defined by the ABIs */

#define R_PPC64_NONE R_PPC_NONE
/* 32bit absolute address */
#define R_PPC64_ADDR32 R_PPC_ADDR32
/* 26bit address, word aligned */
#define R_PPC64_ADDR24 R_PPC_ADDR24
/* 16bit absolute address */
#define R_PPC64_ADDR16 R_PPC_ADDR16
/* lower 16bits of address */
#define R_PPC64_ADDR16_LO R_PPC_ADDR16_LO
/* high 16bits of address. */
#define R_PPC64_ADDR16_HI R_PPC_ADDR16_HI
/* adjusted high 16bits.  */
#define R_PPC64_ADDR16_HA R_PPC_ADDR16_HA
/* 16bit address, word aligned */
#define R_PPC64_ADDR14 R_PPC_ADDR14
#define R_PPC64_ADDR14_BRTAKEN R_PPC_ADDR14_BRTAKEN
#define R_PPC64_ADDR14_BRNTAKEN R_PPC_ADDR14_BRNTAKEN
/* PC-rel. 26 bit, word aligned */
#define R_PPC64_REL24 R_PPC_REL24
/* PC relative 16 bit */
#define R_PPC64_REL14 R_PPC_REL14
#define R_PPC64_REL14_BRTAKEN R_PPC_REL14_BRTAKEN
#define R_PPC64_REL14_BRNTAKEN R_PPC_REL14_BRNTAKEN
#define R_PPC64_GOT16 R_PPC_GOT16
#define R_PPC64_GOT16_LO R_PPC_GOT16_LO
#define R_PPC64_GOT16_HI R_PPC_GOT16_HI
#define R_PPC64_GOT16_HA R_PPC_GOT16_HA

#define R_PPC64_COPY R_PPC_COPY
#define R_PPC64_GLOB_DAT R_PPC_GLOB_DAT
#define R_PPC64_JMP_SLOT R_PPC_JMP_SLOT
#define R_PPC64_RELATIVE R_PPC_RELATIVE

#define R_PPC64_UADDR32 R_PPC_UADDR32
#define R_PPC64_UADDR16 R_PPC_UADDR16
#define R_PPC64_REL32 R_PPC_REL32
#define R_PPC64_PLT32 R_PPC_PLT32
#define R_PPC64_PLTREL32 R_PPC_PLTREL32
#define R_PPC64_PLT16_LO R_PPC_PLT16_LO
#define R_PPC64_PLT16_HI R_PPC_PLT16_HI
#define R_PPC64_PLT16_HA R_PPC_PLT16_HA

#define R_PPC64_SECTOFF R_PPC_SECTOFF
#define R_PPC64_SECTOFF_LO R_PPC_SECTOFF_LO
#define R_PPC64_SECTOFF_HI R_PPC_SECTOFF_HI
#define R_PPC64_SECTOFF_HA R_PPC_SECTOFF_HA
/* word30 (S + A - P) >> 2 */
#define R_PPC64_ADDR30 37
/* doubleword64 S + A */
#define R_PPC64_ADDR64 38
/* half16 #higher(S + A) */
#define R_PPC64_ADDR16_HIGHER 39
/* half16 #highera(S + A) */
#define R_PPC64_ADDR16_HIGHERA 40
/* half16 #highest(S + A) */
#define R_PPC64_ADDR16_HIGHEST 41
/* half16 #highesta(S + A) */
#define R_PPC64_ADDR16_HIGHESTA 42
/* doubleword64 S + A */
#define R_PPC64_UADDR64 43
/* doubleword64 S + A - P */
#define R_PPC64_REL64 44
/* doubleword64 L + A */
#define R_PPC64_PLT64 45
/* doubleword64 L + A - P */
#define R_PPC64_PLTREL64 46
/* half16* S + A - .TOC */
#define R_PPC64_TOC16 47
/* half16 #lo(S + A - .TOC.) */
#define R_PPC64_TOC16_LO 48
/* half16 #hi(S + A - .TOC.) */
#define R_PPC64_TOC16_HI 49
/* half16 #ha(S + A - .TOC.) */
#define R_PPC64_TOC16_HA 50
/* doubleword64 .TOC */
#define R_PPC64_TOC 51
/* half16* M + A */
#define R_PPC64_PLTGOT16 52
/* half16 #lo(M + A) */
#define R_PPC64_PLTGOT16_LO 53
/* half16 #hi(M + A) */
#define R_PPC64_PLTGOT16_HI 54
/* half16 #ha(M + A) */
#define R_PPC64_PLTGOT16_HA 55
/* half16ds* (S + A) >> 2 */

#define R_PPC64_ADDR16_DS 56
/* half16ds  #lo(S + A) >> 2 */
#define R_PPC64_ADDR16_LO_DS 57
/* half16ds* (G + A) >> 2 */
#define R_PPC64_GOT16_DS 58
/* half16ds  #lo(G + A) >> 2 */
#define R_PPC64_GOT16_LO_DS 59
/* half16ds  #lo(L + A) >> 2 */
#define R_PPC64_PLT16_LO_DS 60
/* half16ds* (R + A) >> 2 */
#define R_PPC64_SECTOFF_DS 61
/* half16ds  #lo(R + A) >> 2 */
#define R_PPC64_SECTOFF_LO_DS 62
/* half16ds* (S + A - .TOC.) >> 2 */
#define R_PPC64_TOC16_DS 63
/* half16ds  #lo(S + A - .TOC.) >> 2 */
#define R_PPC64_TOC16_LO_DS 64
/* half16ds* (M + A) >> 2 */
#define R_PPC64_PLTGOT16_DS 65
/* half16ds  #lo(M + A) >> 2 */
#define R_PPC64_PLTGOT16_LO_DS 66
/* PowerPC64 relocations defined for the TLS access ABI.  */
/* none	(sym+add)@tls */

#define R_PPC64_TLS 67
/* doubleword64 (sym+add)@dtpmod */
#define R_PPC64_DTPMOD64 68
/* half16*	(sym+add)@tprel */
#define R_PPC64_TPREL16 69
/* half16	(sym+add)@tprel@l */
#define R_PPC64_TPREL16_LO 70
/* half16	(sym+add)@tprel@h */
#define R_PPC64_TPREL16_HI 71
/* half16	(sym+add)@tprel@ha */
#define R_PPC64_TPREL16_HA 72
/* doubleword64 (sym+add)@tprel */
#define R_PPC64_TPREL64 73
/* half16*	(sym+add)@dtprel */
#define R_PPC64_DTPREL16 74
/* half16	(sym+add)@dtprel@l */
#define R_PPC64_DTPREL16_LO 75
/* half16	(sym+add)@dtprel@h */
#define R_PPC64_DTPREL16_HI 76
/* half16	(sym+add)@dtprel@ha */
#define R_PPC64_DTPREL16_HA 77
/* doubleword64 (sym+add)@dtprel */
#define R_PPC64_DTPREL64 78
/* half16*	(sym+add)@got@tlsgd */
#define R_PPC64_GOT_TLSGD16 79
/* half16	(sym+add)@got@tlsgd@l */
#define R_PPC64_GOT_TLSGD16_LO 80
/* half16	(sym+add)@got@tlsgd@h */
#define R_PPC64_GOT_TLSGD16_HI 81
/* half16	(sym+add)@got@tlsgd@ha */
#define R_PPC64_GOT_TLSGD16_HA 82
/* half16*	(sym+add)@got@tlsld */
#define R_PPC64_GOT_TLSLD16 83
/* half16	(sym+add)@got@tlsld@l */
#define R_PPC64_GOT_TLSLD16_LO 84
/* half16	(sym+add)@got@tlsld@h */
#define R_PPC64_GOT_TLSLD16_HI 85
/* half16	(sym+add)@got@tlsld@ha */
#define R_PPC64_GOT_TLSLD16_HA 86
/* half16ds*	(sym+add)@got@tprel */
#define R_PPC64_GOT_TPREL16_DS 87
/* half16ds (sym+add)@got@tprel@l */
#define R_PPC64_GOT_TPREL16_LO_DS 88
/* half16	(sym+add)@got@tprel@h */
#define R_PPC64_GOT_TPREL16_HI 89
/* half16	(sym+add)@got@tprel@ha */
#define R_PPC64_GOT_TPREL16_HA 90
/* half16ds*	(sym+add)@got@dtprel */
#define R_PPC64_GOT_DTPREL16_DS 91
/* half16ds (sym+add)@got@dtprel@l */
#define R_PPC64_GOT_DTPREL16_LO_DS 92
/* half16	(sym+add)@got@dtprel@h */
#define R_PPC64_GOT_DTPREL16_HI 93
/* half16	(sym+add)@got@dtprel@ha */
#define R_PPC64_GOT_DTPREL16_HA 94
/* half16ds*	(sym+add)@tprel */
#define R_PPC64_TPREL16_DS 95
/* half16ds	(sym+add)@tprel@l */
#define R_PPC64_TPREL16_LO_DS 96
/* half16	(sym+add)@tprel@higher */
#define R_PPC64_TPREL16_HIGHER 97
/* half16	(sym+add)@tprel@highera */
#define R_PPC64_TPREL16_HIGHERA 98
/* half16	(sym+add)@tprel@highest */
#define R_PPC64_TPREL16_HIGHEST 99
/* half16	(sym+add)@tprel@highesta */
#define R_PPC64_TPREL16_HIGHESTA 100
/* half16ds* (sym+add)@dtprel */
#define R_PPC64_DTPREL16_DS 101
/* half16ds	(sym+add)@dtprel@l */
#define R_PPC64_DTPREL16_LO_DS 102
/* half16	(sym+add)@dtprel@higher */
#define R_PPC64_DTPREL16_HIGHER 103
/* half16	(sym+add)@dtprel@highera */
#define R_PPC64_DTPREL16_HIGHERA 104
/* half16	(sym+add)@dtprel@highest */
#define R_PPC64_DTPREL16_HIGHEST 105
/* half16	(sym+add)@dtprel@highesta */
#define R_PPC64_DTPREL16_HIGHESTA 106
/* GNU extension to support local ifunc.  */

#define R_PPC64_JMP_IREL 247
#define R_PPC64_IRELATIVE 248
/* half16   (sym+add-.) */
#define R_PPC64_REL16 249
/* half16   (sym+add-.)@l */
#define R_PPC64_REL16_LO 250
/* half16   (sym+add-.)@h */
#define R_PPC64_REL16_HI 251
/* half16   (sym+add-.)@ha */
#define R_PPC64_REL16_HA 252
/* PowerPC64 specific values for the Dyn d_tag field.  */

#define DT_PPC64_GLINK (DT_LOPROC + 0)
#define DT_PPC64_OPD (DT_LOPROC + 1)
#define DT_PPC64_OPDSZ (DT_LOPROC + 2)
#define DT_PPC64_NUM 3
/* ARM specific declarations */
/* Processor specific flags for the ELF header e_flags field.  */

#define EF_ARM_RELEXEC 0x01
#define EF_ARM_HASENTRY 0x02
#define EF_ARM_INTERWORK 0x04
#define EF_ARM_APCS_26 0x08
#define EF_ARM_APCS_FLOAT 0x10
#define EF_ARM_PIC 0x20
/* 8-bit structure alignment is in use */
#define EF_ARM_ALIGN8 0x40
#define EF_ARM_NEW_ABI 0x80
#define EF_ARM_OLD_ABI 0x100
#define EF_ARM_SOFT_FLOAT 0x200
#define EF_ARM_VFP_FLOAT 0x400
#define EF_ARM_MAVERICK_FLOAT 0x800
/* NB conflicts with EF_ARM_SOFT_FLOAT */

#define EF_ARM_ABI_FLOAT_SOFT 0x200
/* NB conflicts with EF_ARM_VFP_FLOAT */
#define EF_ARM_ABI_FLOAT_HARD 0x400
/* Other constants defined in the ARM ELF spec. version B-01.  */
/* NB. These conflict with values defined above.  */

#define EF_ARM_SYMSARESORTED 0x04
#define EF_ARM_DYNSYMSUSESEGIDX 0x08
#define EF_ARM_MAPSYMSFIRST 0x10
#define EF_ARM_EABIMASK 0XFF000000
/* Constants defined in AAELF.  */

#define EF_ARM_BE8 0x00800000
#define EF_ARM_LE8 0x00400000

#define EF_ARM_EABI_VERSION(flags) ((flags) & EF_ARM_EABIMASK)
#define EF_ARM_EABI_UNKNOWN 0x00000000
#define EF_ARM_EABI_VER1 0x01000000
#define EF_ARM_EABI_VER2 0x02000000
#define EF_ARM_EABI_VER3 0x03000000
#define EF_ARM_EABI_VER4 0x04000000
#define EF_ARM_EABI_VER5 0x05000000
/* Additional symbol types for Thumb.  */
/* A Thumb function.  */

#define STT_ARM_TFUNC STT_LOPROC
/* A Thumb label.  */
#define STT_ARM_16BIT STT_HIPROC
/* ARM-specific values for sh_flags */
/* Section contains an entry point */

#define SHF_ARM_ENTRYSECT 0x10000000
/* Section may be multiply defined
					      in the input to a link step.  */

#define SHF_ARM_COMDEF 0x80000000
/* ARM-specific program header flags */
/* Segment contains the location
					      addressed by the static base. */

#define PF_ARM_SB 0x10000000
/* Position-independent segment.  */
#define PF_ARM_PI 0x20000000
/* Absolute segment.  */
#define PF_ARM_ABS 0x40000000
/* Processor specific values for the Phdr p_type field.  */
/* ARM unwind segment.  */

#define PT_ARM_EXIDX (PT_LOPROC + 1)
/* Processor specific values for the Shdr sh_type field.  */
/* ARM unwind section.  */

#define SHT_ARM_EXIDX (SHT_LOPROC + 1)
/* Preemption details.  */
#define SHT_ARM_PREEMPTMAP (SHT_LOPROC + 2)
/* ARM attributes section.  */
#define SHT_ARM_ATTRIBUTES (SHT_LOPROC + 3)
/* AArch64 relocs.  */
/* No relocation.  */

#define R_AARCH64_NONE 0
/* Direct 64 bit. */
#define R_AARCH64_ABS64 257
/* Direct 32 bit.  */
#define R_AARCH64_ABS32 258
/* Direct 16-bit.  */
#define R_AARCH64_ABS16 259
/* PC-relative 64-bit.  */
#define R_AARCH64_PREL64 260
/* PC-relative 32-bit.  */
#define R_AARCH64_PREL32 261
/* PC-relative 16-bit.  */
#define R_AARCH64_PREL16 262
/* Dir. MOVZ imm. from bits 15:0.  */
#define R_AARCH64_MOVW_UABS_G0 263
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_UABS_G0_NC 264
/* Dir. MOVZ imm. from bits 31:16.  */
#define R_AARCH64_MOVW_UABS_G1 265
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_UABS_G1_NC 266
/* Dir. MOVZ imm. from bits 47:32.  */
#define R_AARCH64_MOVW_UABS_G2 267
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_UABS_G2_NC 268
/* Dir. MOV{K,Z} imm. from 63:48.  */
#define R_AARCH64_MOVW_UABS_G3 269
/* Dir. MOV{N,Z} imm. from 15:0.  */
#define R_AARCH64_MOVW_SABS_G0 270
/* Dir. MOV{N,Z} imm. from 31:16.  */
#define R_AARCH64_MOVW_SABS_G1 271
/* Dir. MOV{N,Z} imm. from 47:32.  */
#define R_AARCH64_MOVW_SABS_G2 272
/* PC-rel. LD imm. from bits 20:2.  */
#define R_AARCH64_LD_PREL_LO19 273
/* PC-rel. ADR imm. from bits 20:0.  */
#define R_AARCH64_ADR_PREL_LO21 274
/* Page-rel. ADRP imm. from 32:12.  */
#define R_AARCH64_ADR_PREL_PG_HI21 275
/* Likewise; no overflow check.  */
#define R_AARCH64_ADR_PREL_PG_HI21_NC 276
/* Dir. ADD imm. from bits 11:0.  */
#define R_AARCH64_ADD_ABS_LO12_NC 277
/* Likewise for LD/ST; no check. */
#define R_AARCH64_LDST8_ABS_LO12_NC 278
/* PC-rel. TBZ/TBNZ imm. from 15:2.  */
#define R_AARCH64_TSTBR14 279
/* PC-rel. cond. br. imm. from 20:2. */
#define R_AARCH64_CONDBR19 280
/* PC-rel. B imm. from bits 27:2.  */
#define R_AARCH64_JUMP26 282
/* Likewise for CALL.  */
#define R_AARCH64_CALL26 283
/* Dir. ADD imm. from bits 11:1.  */
#define R_AARCH64_LDST16_ABS_LO12_NC 284
/* Likewise for bits 11:2.  */
#define R_AARCH64_LDST32_ABS_LO12_NC 285
/* Likewise for bits 11:3.  */
#define R_AARCH64_LDST64_ABS_LO12_NC 286
/* PC-rel. MOV{N,Z} imm. from 15:0.  */
#define R_AARCH64_MOVW_PREL_G0 287
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_PREL_G0_NC 288
/* PC-rel. MOV{N,Z} imm. from 31:16. */
#define R_AARCH64_MOVW_PREL_G1 289
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_PREL_G1_NC 290
/* PC-rel. MOV{N,Z} imm. from 47:32. */
#define R_AARCH64_MOVW_PREL_G2 291
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_PREL_G2_NC 292
/* PC-rel. MOV{N,Z} imm. from 63:48. */
#define R_AARCH64_MOVW_PREL_G3 293
/* Dir. ADD imm. from bits 11:4.  */
#define R_AARCH64_LDST128_ABS_LO12_NC 299
/* GOT-rel. off. MOV{N,Z} imm. 15:0. */
#define R_AARCH64_MOVW_GOTOFF_G0 300
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_GOTOFF_G0_NC 301
/* GOT-rel. o. MOV{N,Z} imm. 31:16.  */
#define R_AARCH64_MOVW_GOTOFF_G1 302
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_GOTOFF_G1_NC 303
/* GOT-rel. o. MOV{N,Z} imm. 47:32.  */
#define R_AARCH64_MOVW_GOTOFF_G2 304
/* Likewise for MOVK; no check.  */
#define R_AARCH64_MOVW_GOTOFF_G2_NC 305
/* GOT-rel. o. MOV{N,Z} imm. 63:48.  */
#define R_AARCH64_MOVW_GOTOFF_G3 306
/* GOT-relative 64-bit.  */
#define R_AARCH64_GOTREL64 307
/* GOT-relative 32-bit.  */
#define R_AARCH64_GOTREL32 308
/* PC-rel. GOT off. load imm. 20:2.  */
#define R_AARCH64_GOT_LD_PREL19 309
/* GOT-rel. off. LD/ST imm. 14:3.  */
#define R_AARCH64_LD64_GOTOFF_LO15 310
/* P-page-rel. GOT off. ADRP 32:12.  */
#define R_AARCH64_ADR_GOT_PAGE 311
/* Dir. GOT off. LD/ST imm. 11:3.  */
#define R_AARCH64_LD64_GOT_LO12_NC 312
/* GOT-page-rel. GOT off. LD/ST 14:3 */
#define R_AARCH64_LD64_GOTPAGE_LO15 313
/* PC-relative ADR imm. 20:0.  */
#define R_AARCH64_TLSGD_ADR_PREL21 512
/* page-rel. ADRP imm. 32:12.  */
#define R_AARCH64_TLSGD_ADR_PAGE21 513
/* direct ADD imm. from 11:0.  */
#define R_AARCH64_TLSGD_ADD_LO12_NC 514
/* GOT-rel. MOV{N,Z} 31:16.  */
#define R_AARCH64_TLSGD_MOVW_G1 515
/* GOT-rel. MOVK imm. 15:0.  */
#define R_AARCH64_TLSGD_MOVW_G0_NC 516
/* Like 512; local dynamic model.  */
#define R_AARCH64_TLSLD_ADR_PREL21 517
/* Like 513; local dynamic model.  */
#define R_AARCH64_TLSLD_ADR_PAGE21 518
/* Like 514; local dynamic model.  */
#define R_AARCH64_TLSLD_ADD_LO12_NC 519
/* Like 515; local dynamic model.  */
#define R_AARCH64_TLSLD_MOVW_G1 520
/* Like 516; local dynamic model.  */
#define R_AARCH64_TLSLD_MOVW_G0_NC 521
/* TLS PC-rel. load imm. 20:2.  */
#define R_AARCH64_TLSLD_LD_PREL19 522
/* TLS DTP-rel. MOV{N,Z} 47:32.  */
#define R_AARCH64_TLSLD_MOVW_DTPREL_G2 523
/* TLS DTP-rel. MOV{N,Z} 31:16.  */
#define R_AARCH64_TLSLD_MOVW_DTPREL_G1 524
/* Likewise; MOVK; no check.  */
#define R_AARCH64_TLSLD_MOVW_DTPREL_G1_NC 525
/* TLS DTP-rel. MOV{N,Z} 15:0.  */
#define R_AARCH64_TLSLD_MOVW_DTPREL_G0 526
/* Likewise; MOVK; no check.  */
#define R_AARCH64_TLSLD_MOVW_DTPREL_G0_NC 527
/* DTP-rel. ADD imm. from 23:12. */
#define R_AARCH64_TLSLD_ADD_DTPREL_HI12 528
/* DTP-rel. ADD imm. from 11:0.  */
#define R_AARCH64_TLSLD_ADD_DTPREL_LO12 529
/* Likewise; no ovfl. check.  */
#define R_AARCH64_TLSLD_ADD_DTPREL_LO12_NC 530
/* DTP-rel. LD/ST imm. 11:0.  */
#define R_AARCH64_TLSLD_LDST8_DTPREL_LO12 531
/* Likewise; no check.  */
#define R_AARCH64_TLSLD_LDST8_DTPREL_LO12_NC 532
/* DTP-rel. LD/ST imm. 11:1.  */
#define R_AARCH64_TLSLD_LDST16_DTPREL_LO12 533
/* Likewise; no check.  */
#define R_AARCH64_TLSLD_LDST16_DTPREL_LO12_NC 534
/* DTP-rel. LD/ST imm. 11:2.  */
#define R_AARCH64_TLSLD_LDST32_DTPREL_LO12 535
/* Likewise; no check.  */
#define R_AARCH64_TLSLD_LDST32_DTPREL_LO12_NC 536
/* DTP-rel. LD/ST imm. 11:3.  */
#define R_AARCH64_TLSLD_LDST64_DTPREL_LO12 537
/* Likewise; no check.  */
#define R_AARCH64_TLSLD_LDST64_DTPREL_LO12_NC 538
/* GOT-rel. MOV{N,Z} 31:16.  */
#define R_AARCH64_TLSIE_MOVW_GOTTPREL_G1 539
/* GOT-rel. MOVK 15:0.  */
#define R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC 540
/* Page-rel. ADRP 32:12.  */
#define R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21 541
/* Direct LD off. 11:3.  */
#define R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC 542
/* PC-rel. load imm. 20:2.  */
#define R_AARCH64_TLSIE_LD_GOTTPREL_PREL19 543
/* TLS TP-rel. MOV{N,Z} 47:32.  */
#define R_AARCH64_TLSLE_MOVW_TPREL_G2 544
/* TLS TP-rel. MOV{N,Z} 31:16.  */
#define R_AARCH64_TLSLE_MOVW_TPREL_G1 545
/* Likewise; MOVK; no check.  */
#define R_AARCH64_TLSLE_MOVW_TPREL_G1_NC 546
/* TLS TP-rel. MOV{N,Z} 15:0.  */
#define R_AARCH64_TLSLE_MOVW_TPREL_G0 547
/* Likewise; MOVK; no check.  */
#define R_AARCH64_TLSLE_MOVW_TPREL_G0_NC 548
/* TP-rel. ADD imm. 23:12.  */
#define R_AARCH64_TLSLE_ADD_TPREL_HI12 549
/* TP-rel. ADD imm. 11:0.  */
#define R_AARCH64_TLSLE_ADD_TPREL_LO12 550
/* Likewise; no ovfl. check.  */
#define R_AARCH64_TLSLE_ADD_TPREL_LO12_NC 551
/* TP-rel. LD/ST off. 11:0.  */
#define R_AARCH64_TLSLE_LDST8_TPREL_LO12 552
/* Likewise; no ovfl. check. */
#define R_AARCH64_TLSLE_LDST8_TPREL_LO12_NC 553
/* TP-rel. LD/ST off. 11:1.  */
#define R_AARCH64_TLSLE_LDST16_TPREL_LO12 554
/* Likewise; no check.  */
#define R_AARCH64_TLSLE_LDST16_TPREL_LO12_NC 555
/* TP-rel. LD/ST off. 11:2.  */
#define R_AARCH64_TLSLE_LDST32_TPREL_LO12 556
/* Likewise; no check.  */
#define R_AARCH64_TLSLE_LDST32_TPREL_LO12_NC 557
/* TP-rel. LD/ST off. 11:3.  */
#define R_AARCH64_TLSLE_LDST64_TPREL_LO12 558
/* Likewise; no check.  */
#define R_AARCH64_TLSLE_LDST64_TPREL_LO12_NC 559
/* PC-rel. load immediate 20:2.  */
#define R_AARCH64_TLSDESC_LD_PREL19 560
/* PC-rel. ADR immediate 20:0.  */
#define R_AARCH64_TLSDESC_ADR_PREL21 561
/* Page-rel. ADRP imm. 32:12.  */
#define R_AARCH64_TLSDESC_ADR_PAGE21 562
/* Direct LD off. from 11:3.  */
#define R_AARCH64_TLSDESC_LD64_LO12 563
/* Direct ADD imm. from 11:0.  */
#define R_AARCH64_TLSDESC_ADD_LO12 564
/* GOT-rel. MOV{N,Z} imm. 31:16.  */
#define R_AARCH64_TLSDESC_OFF_G1 565
/* GOT-rel. MOVK imm. 15:0; no ck.  */
#define R_AARCH64_TLSDESC_OFF_G0_NC 566
/* Relax LDR.  */
#define R_AARCH64_TLSDESC_LDR 567
/* Relax ADD.  */
#define R_AARCH64_TLSDESC_ADD 568
/* Relax BLR.  */
#define R_AARCH64_TLSDESC_CALL 569
/* TP-rel. LD/ST off. 11:4.  */
#define R_AARCH64_TLSLE_LDST128_TPREL_LO12 570
/* Likewise; no check.  */
#define R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC 571
/* DTP-rel. LD/ST imm. 11:4. */
#define R_AARCH64_TLSLD_LDST128_DTPREL_LO12 572
/* Likewise; no check.  */
#define R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC 573
/* Copy symbol at runtime.  */
#define R_AARCH64_COPY 1024
/* Create GOT entry.  */
#define R_AARCH64_GLOB_DAT 1025
/* Create PLT entry.  */
#define R_AARCH64_JUMP_SLOT 1026
/* Adjust by program base.  */
#define R_AARCH64_RELATIVE 1027
/* Module number, 64 bit.  */
#define R_AARCH64_TLS_DTPMOD64 1028
/* Module-relative \offset, 64 bit.  */
#define R_AARCH64_TLS_DTPREL64 1029
/* TP-relative offset, 64 bit.  */
#define R_AARCH64_TLS_TPREL64 1030
/* TLS Descriptor.  */
#define R_AARCH64_TLSDESC 1031
/* STT_GNU_IFUNC relocation.  */
#define R_AARCH64_IRELATIVE 1032
/* Keep this the last entry.  */

#define R_AARCH64_NUM 1033
/* ARM relocs.  */
/* No reloc */

#define R_ARM_NONE 0
/* PC relative 26 bit branch */
#define R_ARM_PC24 1
/* Direct 32 bit  */
#define R_ARM_ABS32 2
/* PC relative 32 bit */
#define R_ARM_REL32 3
#define R_ARM_PC13 4
/* Direct 16 bit */
#define R_ARM_ABS16 5
/* Direct 12 bit */
#define R_ARM_ABS12 6
#define R_ARM_THM_ABS5 7
/* Direct 8 bit */
#define R_ARM_ABS8 8
#define R_ARM_SBREL32 9
#define R_ARM_THM_PC22 10
#define R_ARM_THM_PC8 11
#define R_ARM_AMP_VCALL9 12
/* Obsolete static relocation.  */
#define R_ARM_SWI24 13
/* Dynamic relocation.  */
#define R_ARM_TLS_DESC 13
#define R_ARM_THM_SWI8 14
#define R_ARM_XPC25 15
#define R_ARM_THM_XPC22 16
/* ID of module containing symbol */
#define R_ARM_TLS_DTPMOD32 17
/* Offset in TLS block */
#define R_ARM_TLS_DTPOFF32 18
/* Offset in static TLS block */
#define R_ARM_TLS_TPOFF32 19
/* Copy symbol at runtime */
#define R_ARM_COPY 20
/* Create GOT entry */
#define R_ARM_GLOB_DAT 21
/* Create PLT entry */
#define R_ARM_JUMP_SLOT 22
/* Adjust by program base */
#define R_ARM_RELATIVE 23
/* 32 bit offset to GOT */
#define R_ARM_GOTOFF 24
/* 32 bit PC relative offset to GOT */
#define R_ARM_GOTPC 25
/* 32 bit GOT entry */
#define R_ARM_GOT32 26
/* 32 bit PLT address */
#define R_ARM_PLT32 27
#define R_ARM_CALL 28
#define R_ARM_JUMP24 29
#define R_ARM_THM_JUMP24 30
/* Adjust by program base.  */
#define R_ARM_BASE_ABS 31
#define R_ARM_ALU_PCREL_7_0 32
#define R_ARM_ALU_PCREL_15_8 33
#define R_ARM_ALU_PCREL_23_15 34
#define R_ARM_LDR_SBREL_11_0 35
#define R_ARM_ALU_SBREL_19_12 36
#define R_ARM_ALU_SBREL_27_20 37
#define R_ARM_TARGET1 38
/* Program base relative.  */
#define R_ARM_SBREL31 39
#define R_ARM_V4BX 40
#define R_ARM_TARGET2 41
#define R_ARM_PREL31 42
#define R_ARM_MOVW_ABS_NC 43
#define R_ARM_MOVT_ABS 44
/* PC relative 16-bit (MOVW).  */
#define R_ARM_MOVW_PREL_NC 45
/* PC relative (MOVT).  */
#define R_ARM_MOVT_PREL 46
#define R_ARM_THM_MOVW_ABS_NC 47
#define R_ARM_THM_MOVT_ABS 48
/* Values from 49 to 89 are not yet used/handled by tcc. */

#define R_ARM_TLS_GOTDESC 90
#define R_ARM_TLS_CALL 91
#define R_ARM_TLS_DESCSEQ 92
#define R_ARM_THM_TLS_CALL 93
#define R_ARM_GOT_PREL 96
#define R_ARM_GNU_VTENTRY 100
#define R_ARM_GNU_VTINHERIT 101
/* thumb unconditional branch */
#define R_ARM_THM_PC11 102
/* thumb conditional branch */
#define R_ARM_THM_PC9 103
/* PC-rel 32 bit for global dynamic
					   thread local data */

#define R_ARM_TLS_GD32 104
/* PC-rel 32 bit for local dynamic
					   thread local data */

#define R_ARM_TLS_LDM32 105
/* 32 bit offset relative to TLS
					   block */

#define R_ARM_TLS_LDO32 106
/* PC-rel 32 bit for GOT entry of
					   static TLS block offset */

#define R_ARM_TLS_IE32 107
/* 32 bit offset relative to static
					   TLS block */

#define R_ARM_TLS_LE32 108
#define R_ARM_THM_TLS_DESCSEQ 129
#define R_ARM_IRELATIVE 160
#define R_ARM_RXPC25 249
#define R_ARM_RSBREL32 250
#define R_ARM_THM_RPC22 251
#define R_ARM_RREL32 252
#define R_ARM_RABS22 253
#define R_ARM_RPC24 254
#define R_ARM_RBASE 255
/* Keep this the last entry.  */

#define R_ARM_NUM 256
/* TMS320C67xx specific declarations */
/* XXX: no ELF standard yet*/
/* TMS320C67xx relocs. */

#define R_C60_32 1
/* 32 bit GOT entry */
#define R_C60_GOT32 3
/* 32 bit PLT address */
#define R_C60_PLT32 4
/* Copy symbol at runtime */
#define R_C60_COPY 5
/* Create GOT entry */
#define R_C60_GLOB_DAT 6
/* Create PLT entry */
#define R_C60_JMP_SLOT 7
/* Adjust by program base */
#define R_C60_RELATIVE 8
/* 32 bit offset to GOT */
#define R_C60_GOTOFF 9
/* 32 bit PC relative offset to GOT */
#define R_C60_GOTPC 10
/* low 16 bit MVKL embedded */

#define R_C60LO16 0x54
/* high 16 bit MVKH embedded */
#define R_C60HI16 0x55
/* Keep this the last entry.  */

#define R_C60_NUM 0x56
/* IA-64 specific declarations.  */
/* Processor specific flags for the Ehdr e_flags field.  */
/* os-specific flags */

#define EF_IA_64_MASKOS 0x0000000f
/* 64-bit ABI */
#define EF_IA_64_ABI64 0x00000010
/* arch. version mask */
#define EF_IA_64_ARCH 0xff000000
/* Processor specific values for the Phdr p_type field.  */
/* arch extension bits */

#define PT_IA_64_ARCHEXT (PT_LOPROC + 0)
/* ia64 unwind bits */
#define PT_IA_64_UNWIND (PT_LOPROC + 1)
#define PT_IA_64_HP_OPT_ANOT (PT_LOOS + 0x12)
#define PT_IA_64_HP_HSL_ANOT (PT_LOOS + 0x13)
#define PT_IA_64_HP_STACK (PT_LOOS + 0x14)
/* Processor specific flags for the Phdr p_flags field.  */
/* spec insns w/o recovery */

#define PF_IA_64_NORECOV 0x80000000
/* Processor specific values for the Shdr sh_type field.  */
/* extension bits */

#define SHT_IA_64_EXT (SHT_LOPROC + 0)
/* unwind bits */
#define SHT_IA_64_UNWIND (SHT_LOPROC + 1)
/* Processor specific flags for the Shdr sh_flags field.  */
/* section near gp */

#define SHF_IA_64_SHORT 0x10000000
/* spec insns w/o recovery */
#define SHF_IA_64_NORECOV 0x20000000
/* Processor specific values for the Dyn d_tag field.  */

#define DT_IA_64_PLT_RESERVE (DT_LOPROC + 0)
#define DT_IA_64_NUM 1
/* IA-64 relocations.  */
/* none */

#define R_IA64_NONE 0x00
/* symbol + addend, add imm14 */
#define R_IA64_IMM14 0x21
/* symbol + addend, add imm22 */
#define R_IA64_IMM22 0x22
/* symbol + addend, mov imm64 */
#define R_IA64_IMM64 0x23
/* symbol + addend, data4 MSB */
#define R_IA64_DIR32MSB 0x24
/* symbol + addend, data4 LSB */
#define R_IA64_DIR32LSB 0x25
/* symbol + addend, data8 MSB */
#define R_IA64_DIR64MSB 0x26
/* symbol + addend, data8 LSB */
#define R_IA64_DIR64LSB 0x27
/* @gprel(sym + add), add imm22 */
#define R_IA64_GPREL22 0x2a
/* @gprel(sym + add), mov imm64 */
#define R_IA64_GPREL64I 0x2b
/* @gprel(sym + add), data4 MSB */
#define R_IA64_GPREL32MSB 0x2c
/* @gprel(sym + add), data4 LSB */
#define R_IA64_GPREL32LSB 0x2d
/* @gprel(sym + add), data8 MSB */
#define R_IA64_GPREL64MSB 0x2e
/* @gprel(sym + add), data8 LSB */
#define R_IA64_GPREL64LSB 0x2f
/* @ltoff(sym + add), add imm22 */
#define R_IA64_LTOFF22 0x32
/* @ltoff(sym + add), mov imm64 */
#define R_IA64_LTOFF64I 0x33
/* @pltoff(sym + add), add imm22 */
#define R_IA64_PLTOFF22 0x3a
/* @pltoff(sym + add), mov imm64 */
#define R_IA64_PLTOFF64I 0x3b
/* @pltoff(sym + add), data8 MSB */
#define R_IA64_PLTOFF64MSB 0x3e
/* @pltoff(sym + add), data8 LSB */
#define R_IA64_PLTOFF64LSB 0x3f
/* @fptr(sym + add), mov imm64 */
#define R_IA64_FPTR64I 0x43
/* @fptr(sym + add), data4 MSB */
#define R_IA64_FPTR32MSB 0x44
/* @fptr(sym + add), data4 LSB */
#define R_IA64_FPTR32LSB 0x45
/* @fptr(sym + add), data8 MSB */
#define R_IA64_FPTR64MSB 0x46
/* @fptr(sym + add), data8 LSB */
#define R_IA64_FPTR64LSB 0x47
/* @pcrel(sym + add), brl */
#define R_IA64_PCREL60B 0x48
/* @pcrel(sym + add), ptb, call */
#define R_IA64_PCREL21B 0x49
/* @pcrel(sym + add), chk.s */
#define R_IA64_PCREL21M 0x4a
/* @pcrel(sym + add), fchkf */
#define R_IA64_PCREL21F 0x4b
/* @pcrel(sym + add), data4 MSB */
#define R_IA64_PCREL32MSB 0x4c
/* @pcrel(sym + add), data4 LSB */
#define R_IA64_PCREL32LSB 0x4d
/* @pcrel(sym + add), data8 MSB */
#define R_IA64_PCREL64MSB 0x4e
/* @pcrel(sym + add), data8 LSB */
#define R_IA64_PCREL64LSB 0x4f
/* @ltoff(@fptr(s+a)), imm22 */
#define R_IA64_LTOFF_FPTR22 0x52
/* @ltoff(@fptr(s+a)), imm64 */
#define R_IA64_LTOFF_FPTR64I 0x53
/* @ltoff(@fptr(s+a)), data4 MSB */
#define R_IA64_LTOFF_FPTR32MSB 0x54
/* @ltoff(@fptr(s+a)), data4 LSB */
#define R_IA64_LTOFF_FPTR32LSB 0x55
/* @ltoff(@fptr(s+a)), data8 MSB */
#define R_IA64_LTOFF_FPTR64MSB 0x56
/* @ltoff(@fptr(s+a)), data8 LSB */
#define R_IA64_LTOFF_FPTR64LSB 0x57
/* @segrel(sym + add), data4 MSB */
#define R_IA64_SEGREL32MSB 0x5c
/* @segrel(sym + add), data4 LSB */
#define R_IA64_SEGREL32LSB 0x5d
/* @segrel(sym + add), data8 MSB */
#define R_IA64_SEGREL64MSB 0x5e
/* @segrel(sym + add), data8 LSB */
#define R_IA64_SEGREL64LSB 0x5f
/* @secrel(sym + add), data4 MSB */
#define R_IA64_SECREL32MSB 0x64
/* @secrel(sym + add), data4 LSB */
#define R_IA64_SECREL32LSB 0x65
/* @secrel(sym + add), data8 MSB */
#define R_IA64_SECREL64MSB 0x66
/* @secrel(sym + add), data8 LSB */
#define R_IA64_SECREL64LSB 0x67
/* data 4 + REL */
#define R_IA64_REL32MSB 0x6c
/* data 4 + REL */
#define R_IA64_REL32LSB 0x6d
/* data 8 + REL */
#define R_IA64_REL64MSB 0x6e
/* data 8 + REL */
#define R_IA64_REL64LSB 0x6f
/* symbol + addend, data4 MSB */
#define R_IA64_LTV32MSB 0x74
/* symbol + addend, data4 LSB */
#define R_IA64_LTV32LSB 0x75
/* symbol + addend, data8 MSB */
#define R_IA64_LTV64MSB 0x76
/* symbol + addend, data8 LSB */
#define R_IA64_LTV64LSB 0x77
/* @pcrel(sym + add), 21bit inst */
#define R_IA64_PCREL21BI 0x79
/* @pcrel(sym + add), 22bit inst */
#define R_IA64_PCREL22 0x7a
/* @pcrel(sym + add), 64bit inst */
#define R_IA64_PCREL64I 0x7b
/* dynamic reloc, imported PLT, MSB */
#define R_IA64_IPLTMSB 0x80
/* dynamic reloc, imported PLT, LSB */
#define R_IA64_IPLTLSB 0x81
/* copy relocation */
#define R_IA64_COPY 0x84
/* Addend and symbol difference */
#define R_IA64_SUB 0x85
/* LTOFF22, relaxable.  */
#define R_IA64_LTOFF22X 0x86
/* Use of LTOFF22X.  */
#define R_IA64_LDXMOV 0x87
/* @tprel(sym + add), imm14 */
#define R_IA64_TPREL14 0x91
/* @tprel(sym + add), imm22 */
#define R_IA64_TPREL22 0x92
/* @tprel(sym + add), imm64 */
#define R_IA64_TPREL64I 0x93
/* @tprel(sym + add), data8 MSB */
#define R_IA64_TPREL64MSB 0x96
/* @tprel(sym + add), data8 LSB */
#define R_IA64_TPREL64LSB 0x97
/* @ltoff(@tprel(s+a)), imm2 */
#define R_IA64_LTOFF_TPREL22 0x9a
/* @dtpmod(sym + add), data8 MSB */
#define R_IA64_DTPMOD64MSB 0xa6
/* @dtpmod(sym + add), data8 LSB */
#define R_IA64_DTPMOD64LSB 0xa7
/* @ltoff(@dtpmod(sym + add)), imm22 */
#define R_IA64_LTOFF_DTPMOD22 0xaa
/* @dtprel(sym + add), imm14 */
#define R_IA64_DTPREL14 0xb1
/* @dtprel(sym + add), imm22 */
#define R_IA64_DTPREL22 0xb2
/* @dtprel(sym + add), imm64 */
#define R_IA64_DTPREL64I 0xb3
/* @dtprel(sym + add), data4 MSB */
#define R_IA64_DTPREL32MSB 0xb4
/* @dtprel(sym + add), data4 LSB */
#define R_IA64_DTPREL32LSB 0xb5
/* @dtprel(sym + add), data8 MSB */
#define R_IA64_DTPREL64MSB 0xb6
/* @dtprel(sym + add), data8 LSB */
#define R_IA64_DTPREL64LSB 0xb7
/* @ltoff(@dtprel(s+a)), imm22 */
#define R_IA64_LTOFF_DTPREL22 0xba
/* SH specific declarations */
/* Processor specific flags for the ELF header e_flags field.  */

#define EF_SH_MACH_MASK 0x1f
#define EF_SH_UNKNOWN 0x0
#define EF_SH1 0x1
#define EF_SH2 0x2
#define EF_SH3 0x3
#define EF_SH_DSP 0x4
#define EF_SH3_DSP 0x5
#define EF_SH4AL_DSP 0x6
#define EF_SH3E 0x8
#define EF_SH4 0x9
#define EF_SH2E 0xb
#define EF_SH4A 0xc
#define EF_SH2A 0xd
#define EF_SH4_NOFPU 0x10
#define EF_SH4A_NOFPU 0x11
#define EF_SH4_NOMMU_NOFPU 0x12
#define EF_SH2A_NOFPU 0x13
#define EF_SH3_NOMMU 0x14
#define EF_SH2A_SH4_NOFPU 0x15
#define EF_SH2A_SH3_NOFPU 0x16
#define EF_SH2A_SH4 0x17
#define EF_SH2A_SH3E 0x18
/* SH relocs.  */

#define R_SH_NONE 0
#define R_SH_DIR32 1
#define R_SH_REL32 2
#define R_SH_DIR8WPN 3
#define R_SH_IND12W 4
#define R_SH_DIR8WPL 5
#define R_SH_DIR8WPZ 6
#define R_SH_DIR8BP 7
#define R_SH_DIR8W 8
#define R_SH_DIR8L 9
#define R_SH_SWITCH16 25
#define R_SH_SWITCH32 26
#define R_SH_USES 27
#define R_SH_COUNT 28
#define R_SH_ALIGN 29
#define R_SH_CODE 30
#define R_SH_DATA 31
#define R_SH_LABEL 32
#define R_SH_SWITCH8 33
#define R_SH_GNU_VTINHERIT 34
#define R_SH_GNU_VTENTRY 35
#define R_SH_TLS_GD_32 144
#define R_SH_TLS_LD_32 145
#define R_SH_TLS_LDO_32 146
#define R_SH_TLS_IE_32 147
#define R_SH_TLS_LE_32 148
#define R_SH_TLS_DTPMOD32 149
#define R_SH_TLS_DTPOFF32 150
#define R_SH_TLS_TPOFF32 151
#define R_SH_GOT32 160
#define R_SH_PLT32 161
#define R_SH_COPY 162
#define R_SH_GLOB_DAT 163
#define R_SH_JMP_SLOT 164
#define R_SH_RELATIVE 165
#define R_SH_GOTOFF 166
#define R_SH_GOTPC 167
/* Keep this the last entry.  */

#define R_SH_NUM 256
/* S/390 specific definitions.  */
/* Valid values for the e_flags field.  */
/* High GPRs kernel facility needed.  */

#define EF_S390_HIGH_GPRS 0x00000001
/* Additional s390 relocs */
/* No reloc.  */

#define R_390_NONE 0
/* Direct 8 bit.  */
#define R_390_8 1
/* Direct 12 bit.  */
#define R_390_12 2
/* Direct 16 bit.  */
#define R_390_16 3
/* Direct 32 bit.  */
#define R_390_32 4
/* PC relative 32 bit.	*/
#define R_390_PC32 5
/* 12 bit GOT offset.  */
#define R_390_GOT12 6
/* 32 bit GOT offset.  */
#define R_390_GOT32 7
/* 32 bit PC relative PLT address.  */
#define R_390_PLT32 8
/* Copy symbol at runtime.  */
#define R_390_COPY 9
/* Create GOT entry.  */
#define R_390_GLOB_DAT 10
/* Create PLT entry.  */
#define R_390_JMP_SLOT 11
/* Adjust by program base.  */
#define R_390_RELATIVE 12
/* 32 bit offset to GOT.	 */
#define R_390_GOTOFF32 13
/* 32 bit PC relative offset to GOT.  */
#define R_390_GOTPC 14
/* 16 bit GOT offset.  */
#define R_390_GOT16 15
/* PC relative 16 bit.	*/
#define R_390_PC16 16
/* PC relative 16 bit shifted by 1.  */
#define R_390_PC16DBL 17
/* 16 bit PC rel. PLT shifted by 1.  */
#define R_390_PLT16DBL 18
/* PC relative 32 bit shifted by 1.  */
#define R_390_PC32DBL 19
/* 32 bit PC rel. PLT shifted by 1.  */
#define R_390_PLT32DBL 20
/* 32 bit PC rel. GOT shifted by 1.  */
#define R_390_GOTPCDBL 21
/* Direct 64 bit.  */
#define R_390_64 22
/* PC relative 64 bit.	*/
#define R_390_PC64 23
/* 64 bit GOT offset.  */
#define R_390_GOT64 24
/* 64 bit PC relative PLT address.  */
#define R_390_PLT64 25
/* 32 bit PC rel. to GOT entry >> 1. */
#define R_390_GOTENT 26
/* 16 bit offset to GOT. */
#define R_390_GOTOFF16 27
/* 64 bit offset to GOT. */
#define R_390_GOTOFF64 28
/* 12 bit offset to jump slot.	*/
#define R_390_GOTPLT12 29
/* 16 bit offset to jump slot.	*/
#define R_390_GOTPLT16 30
/* 32 bit offset to jump slot.	*/
#define R_390_GOTPLT32 31
/* 64 bit offset to jump slot.	*/
#define R_390_GOTPLT64 32
/* 32 bit rel. offset to jump slot.  */
#define R_390_GOTPLTENT 33
/* 16 bit offset from GOT to PLT. */
#define R_390_PLTOFF16 34
/* 32 bit offset from GOT to PLT. */
#define R_390_PLTOFF32 35
/* 16 bit offset from GOT to PLT. */
#define R_390_PLTOFF64 36
/* Tag for load insn in TLS code.  */
#define R_390_TLS_LOAD 37
/* Tag for function call in general
					   dynamic TLS code. */

#define R_390_TLS_GDCALL 38
/* Tag for function call in local
					   dynamic TLS code. */

#define R_390_TLS_LDCALL 39
/* Direct 32 bit for general dynamic
					   thread local data.  */

#define R_390_TLS_GD32 40
/* Direct 64 bit for general dynamic
					  thread local data.  */

#define R_390_TLS_GD64 41
/* 12 bit GOT offset for static TLS
					   block offset.  */

#define R_390_TLS_GOTIE12 42
/* 32 bit GOT offset for static TLS
					   block offset.  */

#define R_390_TLS_GOTIE32 43
/* 64 bit GOT offset for static TLS
					   block offset. */

#define R_390_TLS_GOTIE64 44
/* Direct 32 bit for local dynamic
					   thread local data in LE code.  */

#define R_390_TLS_LDM32 45
/* Direct 64 bit for local dynamic
					   thread local data in LE code.  */

#define R_390_TLS_LDM64 46
/* 32 bit address of GOT entry for
					   negated static TLS block offset.  */

#define R_390_TLS_IE32 47
/* 64 bit address of GOT entry for
					   negated static TLS block offset.  */

#define R_390_TLS_IE64 48
/* 32 bit rel. offset to GOT entry for
					   negated static TLS block offset.  */

#define R_390_TLS_IEENT 49
/* 32 bit negated offset relative to
					   static TLS block.  */

#define R_390_TLS_LE32 50
/* 64 bit negated offset relative to
					   static TLS block.  */

#define R_390_TLS_LE64 51
/* 32 bit offset relative to TLS
					   block.  */

#define R_390_TLS_LDO32 52
/* 64 bit offset relative to TLS
					   block.  */

#define R_390_TLS_LDO64 53
/* ID of module containing symbol.  */
#define R_390_TLS_DTPMOD 54
/* Offset in TLS block.	 */
#define R_390_TLS_DTPOFF 55
/* Negated offse\t in static TLS
					   block.  */

#define R_390_TLS_TPOFF 56
/* Direct 20 bit.  */
#define R_390_20 57
/* 20 bit GOT offset.  */
#define R_390_GOT20 58
/* 20 bit offset to jump slot.  */
#define R_390_GOTPLT20 59
/* 20 bit GOT offset for static TLS
					   block offset.  */

#define R_390_TLS_GOTIE20 60
/* STT_GNU_IFUNC relocation.  */
#define R_390_IRELATIVE 61
/* Keep this the last entry.  */

#define R_390_NUM 62
/* CRIS relocations.  */

#define R_CRIS_NONE 0
#define R_CRIS_8 1
#define R_CRIS_16 2
#define R_CRIS_32 3
#define R_CRIS_8_PCREL 4
#define R_CRIS_16_PCREL 5
#define R_CRIS_32_PCREL 6
#define R_CRIS_GNU_VTINHERIT 7
#define R_CRIS_GNU_VTENTRY 8
#define R_CRIS_COPY 9
#define R_CRIS_GLOB_DAT 10
#define R_CRIS_JUMP_SLOT 11
#define R_CRIS_RELATIVE 12
#define R_CRIS_16_GOT 13
#define R_CRIS_32_GOT 14
#define R_CRIS_16_GOTPLT 15
#define R_CRIS_32_GOTPLT 16
#define R_CRIS_32_GOTREL 17
#define R_CRIS_32_PLT_GOTREL 18
#define R_CRIS_32_PLT_PCREL 19

#define R_CRIS_NUM 20
/* AMD x86-64 relocations.  */
/* No reloc */

#define R_X86_64_NONE 0
/* Direct 64 bit  */
#define R_X86_64_64 1
/* PC relative 32 bit signed */
#define R_X86_64_PC32 2
/* 32 bit GOT entry */
#define R_X86_64_GOT32 3
/* 32 bit PLT address */
#define R_X86_64_PLT32 4
/* Copy symbol at runtime */
#define R_X86_64_COPY 5
/* Create GOT entry */
#define R_X86_64_GLOB_DAT 6
/* Create PLT entry */
#define R_X86_64_JUMP_SLOT 7
/* Adjust by program base */
#define R_X86_64_RELATIVE 8
/* 32 bit signed PC relative
					   offset to GOT */

#define R_X86_64_GOTPCREL 9
/* Direct 32 bit zero extended */
#define R_X86_64_32 10
/* Direct 32 bit sign extended */
#define R_X86_64_32S 11
/* Direct 16 bit zero extended */
#define R_X86_64_16 12
/* 16 bit sign extended pc relative */
#define R_X86_64_PC16 13
/* Direct 8 bit sign extended  */
#define R_X86_64_8 14
/* 8 bit sign extended pc relative */
#define R_X86_64_PC8 15
/* ID of module containing symbol */
#define R_X86_64_DTPMOD64 16
/* Offset in module's TLS block */
#define R_X86_64_DTPOFF64 17
/* Offset in initial TLS block */
#define R_X86_64_TPOFF64 18
/* 32 bit signed PC relative offset
					   to two GOT entries for GD symbol */

#define R_X86_64_TLSGD 19
/* 32 bit signed PC relative offset
					   to two GOT entries for LD symbol */

#define R_X86_64_TLSLD 20
/* Offset in TLS block */
#define R_X86_64_DTPOFF32 21
/* 32 bit signed PC relative offset
					   to GOT entry for IE symbol */

#define R_X86_64_GOTTPOFF 22
/* Offset in initial TLS block */
#define R_X86_64_TPOFF32 23
/* PC relative 64 bit */
#define R_X86_64_PC64 24
/* 64 bit offset to GOT */
#define R_X86_64_GOTOFF64 25
/* 32 bit signed pc relative
					   offset to GOT */

#define R_X86_64_GOTPC32 26
/* 64-bit GOT entry offset */
#define R_X86_64_GOT64 27
/* 64-bit PC relative offset
					   to GOT entry */

#define R_X86_64_GOTPCREL64 28
/* 64-bit PC relative offset to GOT */
#define R_X86_64_GOTPC64 29
/* like GOT64, says PLT entry needed */
#define R_X86_64_GOTPLT64 30
/* 64-bit GOT relative offset
					   to PLT entry */

#define R_X86_64_PLTOFF64 31
/* Size of symbol plus 32-bit addend */
#define R_X86_64_SIZE32 32
/* Size of symbol plus 64-bit addend */
#define R_X86_64_SIZE64 33
/* GOT offset for TLS descriptor.  */
#define R_X86_64_GOTPC32_TLSDESC 34
/* Marker for call through TLS
					   descriptor.  */

#define R_X86_64_TLSDESC_CALL 35
/* TLS descriptor.  */
#define R_X86_64_TLSDESC 36
/* Adjust indirectly by program base */
#define R_X86_64_IRELATIVE 37
/* 64-bit adjust by program base */
#define R_X86_64_RELATIVE64 38
/* like GOTPCREL, but optionally with
					   linker optimizations */

#define R_X86_64_GOTPCRELX 41
/* like GOTPCRELX, but a REX prefix
					   is present */

#define R_X86_64_REX_GOTPCRELX 42

#define R_X86_64_NUM 43
/* x86-64 sh_type values.  */
/* Unwind information.  */

#define SHT_X86_64_UNWIND 0x70000001
/* AM33 relocations.  */
/* No reloc.  */

#define R_MN10300_NONE 0
/* Direct 32 bit.  */
#define R_MN10300_32 1
/* Direct 16 bit.  */
#define R_MN10300_16 2
/* Direct 8 bit.  */
#define R_MN10300_8 3
/* PC-relative 32-bit.  */
#define R_MN10300_PCREL32 4
/* PC-relative 16-bit signed.  */
#define R_MN10300_PCREL16 5
/* PC-relative 8-bit signed.  */
#define R_MN10300_PCREL8 6
/* Ancient C++ vtable garbage... */
#define R_MN10300_GNU_VTINHERIT 7
/* ... collection annotation.  */
#define R_MN10300_GNU_VTENTRY 8
/* Direct 24 bit.  */
#define R_MN10300_24 9
/* 32-bit PCrel offset to GOT.  */
#define R_MN10300_GOTPC32 10
/* 16-bit PCrel offset to GOT.  */
#define R_MN10300_GOTPC16 11
/* 32-bit offset from GOT.  */
#define R_MN10300_GOTOFF32 12
/* 24-bit offset from GOT.  */
#define R_MN10300_GOTOFF24 13
/* 16-bit offset from GOT.  */
#define R_MN10300_GOTOFF16 14
/* 32-bit PCrel to PLT entry.  */
#define R_MN10300_PLT32 15
/* 16-bit PCrel to PLT entry.  */
#define R_MN10300_PLT16 16
/* 32-bit offset to GOT entry.  */
#define R_MN10300_GOT32 17
/* 24-bit offset to GOT entry.  */
#define R_MN10300_GOT24 18
/* 16-bit offset to GOT entry.  */
#define R_MN10300_GOT16 19
/* Copy symbol at runtime.  */
#define R_MN10300_COPY 20
/* Create GOT entry.  */
#define R_MN10300_GLOB_DAT 21
/* Create PLT entry.  */
#define R_MN10300_JMP_SLOT 22
/* Adjust by program base.  */
#define R_MN10300_RELATIVE 23
/* 32-bit offset for global dynamic.  */
#define R_MN10300_TLS_GD 24
/* 32-bit offset for local dynamic.  */
#define R_MN10300_TLS_LD 25
/* Module-relative offset.  */
#define R_MN10300_TLS_LDO 26
/* GOT offset for static TLS block
					   offset.  */

#define R_MN10300_TLS_GOTIE 27
/* GOT address for static TLS block
					   offset.  */

#define R_MN10300_TLS_IE 28
/* Offset relative to static TLS
					   block.  */

#define R_MN10300_TLS_LE 29
/* ID of module containing symbol.  */
#define R_MN10300_TLS_DTPMOD 30
/* Offset in module TLS block.  */
#define R_MN10300_TLS_DTPOFF 31
/* Offset in static TLS block.  */
#define R_MN10300_TLS_TPOFF 32
/* Adjustment for next reloc as needed
					   by linker relaxation.  */

#define R_MN10300_SYM_DIFF 33
/* Alignment requirement for linker
					   relaxation.  */

#define R_MN10300_ALIGN 34
#define R_MN10300_NUM 35
/* M32R relocs.  */
/* No reloc. */

#define R_M32R_NONE 0
/* Direct 16 bit. */
#define R_M32R_16 1
/* Direct 32 bit. */
#define R_M32R_32 2
/* Direct 24 bit. */
#define R_M32R_24 3
/* PC relative 10 bit shifted. */
#define R_M32R_10_PCREL 4
/* PC relative 18 bit shifted. */
#define R_M32R_18_PCREL 5
/* PC relative 26 bit shifted. */
#define R_M32R_26_PCREL 6
/* High 16 bit with unsigned low. */
#define R_M32R_HI16_ULO 7
/* High 16 bit with signed low. */
#define R_M32R_HI16_SLO 8
/* Low 16 bit. */
#define R_M32R_LO16 9
/* 16 bit offset in SDA. */
#define R_M32R_SDA16 10
#define R_M32R_GNU_VTINHERIT 11
#define R_M32R_GNU_VTENTRY 12
/* M32R relocs use SHT_RELA.  */
/* Direct 16 bit. */

#define R_M32R_16_RELA 33
/* Direct 32 bit. */
#define R_M32R_32_RELA 34
/* Direct 24 bit. */
#define R_M32R_24_RELA 35
/* PC relative 10 bit shifted. */
#define R_M32R_10_PCREL_RELA 36
/* PC relative 18 bit shifted. */
#define R_M32R_18_PCREL_RELA 37
/* PC relative 26 bit shifted. */
#define R_M32R_26_PCREL_RELA 38
/* High 16 bit with unsigned low */
#define R_M32R_HI16_ULO_RELA 39
/* High 16 bit with signed low */
#define R_M32R_HI16_SLO_RELA 40
/* Low 16 bit */
#define R_M32R_LO16_RELA 41
/* 16 bit offset in SDA */
#define R_M32R_SDA16_RELA 42
#define R_M32R_RELA_GNU_VTINHERIT 43
#define R_M32R_RELA_GNU_VTENTRY 44
/* PC relative 32 bit.  */
#define R_M32R_REL32 45
/* 24 bit GOT entry */

#define R_M32R_GOT24 48
/* 26 bit PC relative to PLT shifted */
#define R_M32R_26_PLTREL 49
/* Copy symbol at runtime */
#define R_M32R_COPY 50
/* Create GOT entry */
#define R_M32R_GLOB_DAT 51
/* Create PLT entry */
#define R_M32R_JMP_SLOT 52
/* Adjust by program base */
#define R_M32R_RELATIVE 53
/* 24 bit offset to GOT */
#define R_M32R_GOTOFF 54
/* 24 bit PC relative offset to GOT */
#define R_M32R_GOTPC24 55
/* High 16 bit GOT entry with unsigned
					   low */

#define R_M32R_GOT16_HI_ULO 56
/* High 16 bit GOT entry with signed
				\	   low */

#define R_M32R_GOT16_HI_SLO 57
/* Low 16 bit GOT entry */
#define R_M32R_GOT16_LO 58
/* High 16 bit PC relative offset to
					   GOT with unsigned low */

#define R_M32R_GOTPC_HI_ULO 59
/* High 16 bit PC relative offset to
					   GOT with signed low */

#define R_M32R_GOTPC_HI_SLO 60
/* Low 16 bit PC relative offset to
					   GOT */

#define R_M32R_GOTPC_LO 61
/* High 16 bit offset to GOT
					   with unsigned low */

#define R_M32R_GOTOFF_HI_ULO 62
/* High 16 bit offset to GOT
					   with signed low */

#define R_M32R_GOTOFF_HI_SLO 63
/* Low 16 bit offset to GOT */
#define R_M32R_GOTOFF_LO 64
/* Keep this the last entry. */
#define R_M32R_NUM 256
/* TILEPro relocations.  */
/* No reloc */

#define R_TILEPRO_NONE 0
/* Direct 32 bit */
#define R_TILEPRO_32 1
/* Direct 16 bit */
#define R_TILEPRO_16 2
/* Direct 8 bit */
#define R_TILEPRO_8 3
/* PC relative 32 bit */
#define R_TILEPRO_32_PCREL 4
/* PC relative 16 bit */
#define R_TILEPRO_16_PCREL 5
/* PC relative 8 bit */
#define R_TILEPRO_8_PCREL 6
/* Low 16 bit */
#define R_TILEPRO_LO16 7
/* High 16 bit */
#define R_TILEPRO_HI16 8
/* High 16 bit, adjusted */
#define R_TILEPRO_HA16 9
/* Copy relocation */
#define R_TILEPRO_COPY 10
/* Create GOT entry */
#define R_TILEPRO_GLOB_DAT 11
/* Create PLT entry */
#define R_TILEPRO_JMP_SLOT 12
/* Adjust by program base */
#define R_TILEPRO_RELATIVE 13
/* X1 pipe branch offset */
#define R_TILEPRO_BROFF_X1 14
/* X1 pipe jump offset */
#define R_TILEPRO_JOFFLONG_X1 15
/* X1 pipe jump offset to PLT */
#define R_TILEPRO_JOFFLONG_X1_PLT 16
/* X0 pipe 8-bit */
#define R_TILEPRO_IMM8_X0 17
/* Y0 pipe 8-bit */
#define R_TILEPRO_IMM8_Y0 18
/* X1 pipe 8-bit */
#define R_TILEPRO_IMM8_X1 19
/* Y1 pipe 8-bit */
#define R_TILEPRO_IMM8_Y1 20
/* X1 pipe mtspr */
#define R_TILEPRO_MT_IMM15_X1 21
/* X1 pipe mfspr */
#define R_TILEPRO_MF_IMM15_X1 22
/* X0 pipe 16-bit */
#define R_TILEPRO_IMM16_X0 23
/* X1 pipe 16-bit */
#define R_TILEPRO_IMM16_X1 24
/* X0 pipe low 16-bit */
#define R_TILEPRO_IMM16_X0_LO 25
/* X1 pipe low 16-bit */
#define R_TILEPRO_IMM16_X1_LO 26
/* X0 pipe high 16-bit */
#define R_TILEPRO_IMM16_X0_HI 27
/* X1 pipe high 16-bit */
#define R_TILEPRO_IMM16_X1_HI 28
/* X0 pipe high 16-bit, adjusted */
#define R_TILEPRO_IMM16_X0_HA 29
/* X1 pipe high 16-bit, adjusted */
#define R_TILEPRO_IMM16_X1_HA 30
/* X0 pipe PC relative 16 bit */
#define R_TILEPRO_IMM16_X0_PCREL 31
/* X1 pipe PC relative 16 bit */
#define R_TILEPRO_IMM16_X1_PCREL 32
/* X0 pipe PC relative low 16 bit */
#define R_TILEPRO_IMM16_X0_LO_PCREL 33
/* X1 pipe PC relative low 16 bit */
#define R_TILEPRO_IMM16_X1_LO_PCREL 34
/* X0 pipe PC relative high 16 bit */
#define R_TILEPRO_IMM16_X0_HI_PCREL 35
/* X1 pipe PC relative high 16 bit */
#define R_TILEPRO_IMM16_X1_HI_PCREL 36
/* X0 pipe PC relative ha() 16 bit */
#define R_TILEPRO_IMM16_X0_HA_PCREL 37
/* X1 pipe PC relative ha() 16 bit */
#define R_TILEPRO_IMM16_X1_HA_PCREL 38
/* X0 pipe 16-bit GOT offset */
#define R_TILEPRO_IMM16_X0_GOT 39
/* X1 pipe 16-bit GOT offset */
#define R_TILEPRO_IMM16_X1_GOT 40
/* X0 pipe low 16-bit GOT offset */
#define R_TILEPRO_IMM16_X0_GOT_LO 41
/* X1 pipe low 16-bit GOT offset */
#define R_TILEPRO_IMM16_X1_GOT_LO 42
/* X0 pipe high 16-bit GOT offset */
#define R_TILEPRO_IMM16_X0_GOT_HI 43
/* X1 pipe high 16-bit GOT offset */
#define R_TILEPRO_IMM16_X1_GOT_HI 44
/* X0 pipe ha() 16-bit GOT offset */
#define R_TILEPRO_IMM16_X0_GOT_HA 45
/* X1 pipe ha() 16-bit GOT offset */
#define R_TILEPRO_IMM16_X1_GOT_HA 46
/* X0 pipe mm "start" */
#define R_TILEPRO_MMSTART_X0 47
/* X0 pipe mm "end" */
#define R_TILEPRO_MMEND_X0 48
/* X1 pipe mm "start" */
#define R_TILEPRO_MMSTART_X1 49
/* X1 pipe mm "end" */
#define R_TILEPRO_MMEND_X1 50
/* X0 pipe shift amount */
#define R_TILEPRO_SHAMT_X0 51
/* X1 pipe shift amount */
#define R_TILEPRO_SHAMT_X1 52
/* Y0 pipe shift amount */
#define R_TILEPRO_SHAMT_Y0 53
/* Y1 pipe shift amount */
#define R_TILEPRO_SHAMT_Y1 54
/* X1 pipe destination 8-bit */
#define R_TILEPRO_DEST_IMM8_X1 55
/* Relocs 56-59 are currently not defined.  */
/* "jal" for TLS GD */

#define R_TILEPRO_TLS_GD_CALL 60
/* X0 pipe "addi" for TLS GD */
#define R_TILEPRO_IMM8_X0_TLS_GD_ADD 61
/* X1 pipe "addi" for TLS GD */
#define R_TILEPRO_IMM8_X1_TLS_GD_ADD 62
/* Y0 pipe "addi" for TLS GD */
#define R_TILEPRO_IMM8_Y0_TLS_GD_ADD 63
/* Y1 pipe "addi" for TLS GD */
#define R_TILEPRO_IMM8_Y1_TLS_GD_ADD 64
/* "lw_tls" for TLS IE */
#define R_TILEPRO_TLS_IE_LOAD 65
/* X0 pipe 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X0_TLS_GD 66
/* X1 pipe 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X1_TLS_GD 67
/* X0 pipe low 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X0_TLS_GD_LO 68
/* X1 pipe low 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X1_TLS_GD_LO 69
/* X0 pipe high 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X0_TLS_GD_HI 70
/* X1 pipe high 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X1_TLS_GD_HI 71
/* X0 pipe ha() 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X0_TLS_GD_HA 72
/* X1 pipe ha() 16-bit TLS GD offset */
#define R_TILEPRO_IMM16_X1_TLS_GD_HA 73
/* X0 pipe 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X0_TLS_IE 74
/* X1 pipe 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X1_TLS_IE 75
/* X0 pipe low 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X0_TLS_IE_LO 76
/* X1 pipe low 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X1_TLS_IE_LO 77
/* X0 pipe high 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X0_TLS_IE_HI 78
/* X1 pipe high 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X1_TLS_IE_HI 79
/* X0 pipe ha() 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X0_TLS_IE_HA 80
/* X1 pipe ha() 16-bit TLS IE offset */
#define R_TILEPRO_IMM16_X1_TLS_IE_HA 81
/* ID of module containing symbol */
#define R_TILEPRO_TLS_DTPMOD32 82
/* Offset in TLS block */
#define R_TILEPRO_TLS_DTPOFF32 83
/* Offset in static TLS block */
#define R_TILEPRO_TLS_TPOFF32 84
/* X0 pipe 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X0_TLS_LE 85
/* X1 pipe 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X1_TLS_LE 86
/* X0 pipe low 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X0_TLS_LE_LO 87
/* X1 pipe low 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X1_TLS_LE_LO 88
/* X0 pipe high 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X0_TLS_LE_HI 89
/* X1 pipe high 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X1_TLS_LE_HI 90
/* X0 pipe ha() 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X0_TLS_LE_HA 91
/* X1 pipe ha() 16-bit TLS LE offset */
#define R_TILEPRO_IMM16_X1_TLS_LE_HA 92
/* GNU C++ vtable hierarchy */

#define R_TILEPRO_GNU_VTINHERIT 128
/* GNU C++ vtable member usage */
#define R_TILEPRO_GNU_VTENTRY 129

#define R_TILEPRO_NUM 130
/* TILE-Gx relocations.  */
/* No reloc */

#define R_TILEGX_NONE 0
/* Direct 64 bit */
#define R_TILEGX_64 1
/* Direct 32 bit */
#define R_TILEGX_32 2
/* Direct 16 bit */
#define R_TILEGX_16 3
/* Direct 8 bit */
#define R_TILEGX_8 4
/* PC relative 64 bit */
#define R_TILEGX_64_PCREL 5
/* PC relative 32 bit */
#define R_TILEGX_32_PCREL 6
/* PC relative 16 bit */
#define R_TILEGX_16_PCREL 7
/* PC relative 8 bit */
#define R_TILEGX_8_PCREL 8
/* hword 0 16-bit */
#define R_TILEGX_HW0 9
/* hword 1 16-bit */
#define R_TILEGX_HW1 10
/* hword 2 16-bit */
#define R_TILEGX_HW2 11
/* hword 3 16-bit */
#define R_TILEGX_HW3 12
/* last hword 0 16-bit */
#define R_TILEGX_HW0_LAST 13
/* last hword 1 16-bit */
#define R_TILEGX_HW1_LAST 14
/* last hword 2 16-bit */
#define R_TILEGX_HW2_LAST 15
/* Copy relocation */
#define R_TILEGX_COPY 16
/* Create GOT entry */
#define R_TILEGX_GLOB_DAT 17
/* Create PLT entry */
#define R_TILEGX_JMP_SLOT 18
/* Adjust by program base */
#define R_TILEGX_RELATIVE 19
/* X1 pipe branch offset */
#define R_TILEGX_BROFF_X1 20
/* X1 pipe jump offset */
#define R_TILEGX_JUMPOFF_X1 21
/* X1 pipe jump offset to PLT */
#define R_TILEGX_JUMPOFF_X1_PLT 22
/* X0 pipe 8-bit */
#define R_TILEGX_IMM8_X0 23
/* Y0 pipe 8-bit */
#define R_TILEGX_IMM8_Y0 24
/* X1 pipe 8-bit */
#define R_TILEGX_IMM8_X1 25
/* Y1 pipe 8-bit */
#define R_TILEGX_IMM8_Y1 26
/* X1 pipe destination 8-bit */
#define R_TILEGX_DEST_IMM8_X1 27
/* X1 pipe mtspr */
#define R_TILEGX_MT_IMM14_X1 28
/* X1 pipe mfspr */
#define R_TILEGX_MF_IMM14_X1 29
/* X0 pipe mm "start" */
#define R_TILEGX_MMSTART_X0 30
/* X0 pipe mm "end" */
#define R_TILEGX_MMEND_X0 31
/* X0 pipe shift amount */
#define R_TILEGX_SHAMT_X0 32
/* X1 pipe shift amount */
#define R_TILEGX_SHAMT_X1 33
/* Y0 pipe shift amount */
#define R_TILEGX_SHAMT_Y0 34
/* Y1 pipe shift amount */
#define R_TILEGX_SHAMT_Y1 35
/* X0 pipe hword 0 */
#define R_TILEGX_IMM16_X0_HW0 36
/* X1 pipe hword 0 */
#define R_TILEGX_IMM16_X1_HW0 37
/* X0 pipe hword 1 */
#define R_TILEGX_IMM16_X0_HW1 38
/* X1 pipe hword 1 */
#define R_TILEGX_IMM16_X1_HW1 39
/* X0 pipe hword 2 */
#define R_TILEGX_IMM16_X0_HW2 40
/* X1 pipe hword 2 */
#define R_TILEGX_IMM16_X1_HW2 41
/* X0 pipe hword 3 */
#define R_TILEGX_IMM16_X0_HW3 42
/* X1 pipe hword 3 */
#define R_TILEGX_IMM16_X1_HW3 43
/* X0 pipe last hword 0 */
#define R_TILEGX_IMM16_X0_HW0_LAST 44
/* X1 pipe last hword 0 */
#define R_TILEGX_IMM16_X1_HW0_LAST 45
/* X0 pipe last hword 1 */
#define R_TILEGX_IMM16_X0_HW1_LAST 46
/* X1 pipe last hword 1 */
#define R_TILEGX_IMM16_X1_HW1_LAST 47
/* X0 pipe last hword 2 */
#define R_TILEGX_IMM16_X0_HW2_LAST 48
/* X1 pipe last hword 2 */
#define R_TILEGX_IMM16_X1_HW2_LAST 49
/* X0 pipe PC relative hword 0 */
#define R_TILEGX_IMM16_X0_HW0_PCREL 50
/* X1 pipe PC relative hword 0 */
#define R_TILEGX_IMM16_X1_HW0_PCREL 51
/* X0 pipe PC relative hword 1 */
#define R_TILEGX_IMM16_X0_HW1_PCREL 52
/* X1 pipe PC relative hword 1 */
#define R_TILEGX_IMM16_X1_HW1_PCREL 53
/* X0 pipe PC relative hword 2 */
#define R_TILEGX_IMM16_X0_HW2_PCREL 54
/* X1 pipe PC relative hword 2 */
#define R_TILEGX_IMM16_X1_HW2_PCREL 55
/* X0 pipe PC relative hword 3 */
#define R_TILEGX_IMM16_X0_HW3_PCREL 56
/* X1 pipe PC relative hword 3 */
#define R_TILEGX_IMM16_X1_HW3_PCREL 57
/* X0 pipe PC-rel last hword 0 */
#define R_TILEGX_IMM16_X0_HW0_LAST_PCREL 58
/* X1 pipe PC-rel last hword 0 */
#define R_TILEGX_IMM16_X1_HW0_LAST_PCREL 59
/* X0 pipe PC-rel last hword 1 */
#define R_TILEGX_IMM16_X0_HW1_LAST_PCREL 60
/* X1 pipe PC-rel last hword 1 */
#define R_TILEGX_IMM16_X1_HW1_LAST_PCREL 61
/* X0 pipe PC-rel last hword 2 */
#define R_TILEGX_IMM16_X0_HW2_LAST_PCREL 62
/* X1 pipe PC-rel last hword 2 */
#define R_TILEGX_IMM16_X1_HW2_LAST_PCREL 63
/* X0 pipe hword 0 GOT offset */
#define R_TILEGX_IMM16_X0_HW0_GOT 64
/* X1 pipe hword 0 GOT offset */
#define R_TILEGX_IMM16_X1_HW0_GOT 65
/* X0 pipe PC-rel PLT hword 0 */
#define R_TILEGX_IMM16_X0_HW0_PLT_PCREL 66
/* X1 pipe PC-rel PLT hword 0 */
#define R_TILEGX_IMM16_X1_HW0_PLT_PCREL 67
/* X0 pipe PC-rel PLT hword 1 */
#define R_TILEGX_IMM16_X0_HW1_PLT_PCREL 68
/* X1 pipe PC-rel PLT hword 1 */
#define R_TILEGX_IMM16_X1_HW1_PLT_PCREL 69
/* X0 pipe PC-rel PLT hword 2 */
#define R_TILEGX_IMM16_X0_HW2_PLT_PCREL 70
/* X1 pipe PC-rel PLT hword 2 */
#define R_TILEGX_IMM16_X1_HW2_PLT_PCREL 71
/* X0 pipe last hword 0 GOT offset */
#define R_TILEGX_IMM16_X0_HW0_LAST_GOT 72
/* X1 pipe last hword 0 GOT offset */
#define R_TILEGX_IMM16_X1_HW0_LAST_GOT 73
/* X0 pipe last hword 1 GOT offset */
#define R_TILEGX_IMM16_X0_HW1_LAST_GOT 74
/* X1 pipe last hword 1 GOT offset */
#define R_TILEGX_IMM16_X1_HW1_LAST_GOT 75
/* X0 pipe PC-rel PLT hword 3 */
#define R_TILEGX_IMM16_X0_HW3_PLT_PCREL 76
/* X1 pipe PC-rel PLT hword 3 */
#define R_TILEGX_IMM16_X1_HW3_PLT_PCREL 77
/* X0 pipe hword 0 TLS GD offset */
#define R_TILEGX_IMM16_X0_HW0_TLS_GD 78
/* X1 pipe hword 0 TLS GD offset */
#define R_TILEGX_IMM16_X1_HW0_TLS_GD 79
/* X0 pipe hword 0 TLS LE offset */
#define R_TILEGX_IMM16_X0_HW0_TLS_LE 80
/* X1 pipe hword 0 TLS LE offset */
#define R_TILEGX_IMM16_X1_HW0_TLS_LE 81
/* X0 pipe last hword 0 LE off */
#define R_TILEGX_IMM16_X0_HW0_LAST_TLS_LE 82
/* X1 pipe last hword 0 LE off */
#define R_TILEGX_IMM16_X1_HW0_LAST_TLS_LE 83
/* X0 pipe last hword 1 LE off */
#define R_TILEGX_IMM16_X0_HW1_LAST_TLS_LE 84
/* X1 pipe last hword 1 LE off */
#define R_TILEGX_IMM16_X1_HW1_LAST_TLS_LE 85
/* X0 pipe last hword 0 GD off */
#define R_TILEGX_IMM16_X0_HW0_LAST_TLS_GD 86
/* X1 pipe last hword 0 GD off */
#define R_TILEGX_IMM16_X1_HW0_LAST_TLS_GD 87
/* X0 pipe last hword 1 GD off */
#define R_TILEGX_IMM16_X0_HW1_LAST_TLS_GD 88
/* X1 pipe last hword 1 GD off */
#define R_TILEGX_IMM16_X1_HW1_LAST_TLS_GD 89
/* Relocs 90-91 are currently not defined.  */
/* X0 pipe hword 0 TLS IE offset */

#define R_TILEGX_IMM16_X0_HW0_TLS_IE 92
/* X1 pipe hword 0 TLS IE offset */
#define R_TILEGX_IMM16_X1_HW0_TLS_IE 93
/* X0 pipe PC-rel PLT last hword 0 */
#define R_TILEGX_IMM16_X0_HW0_LAST_PLT_PCREL 94
/* X1 pipe PC-rel PLT last hword 0 */
#define R_TILEGX_IMM16_X1_HW0_LAST_PLT_PCREL 95
/* X0 pipe PC-rel PLT last hword 1 */
#define R_TILEGX_IMM16_X0_HW1_LAST_PLT_PCREL 96
/* X1 pipe PC-rel PLT last hword 1 */
#define R_TILEGX_IMM16_X1_HW1_LAST_PLT_PCREL 97
/* X0 pipe PC-rel PLT last hword 2 */
#define R_TILEGX_IMM16_X0_HW2_LAST_PLT_PCREL 98
/* X1 pipe PC-rel PLT last hword 2 */
#define R_TILEGX_IMM16_X1_HW2_LAST_PLT_PCREL 99
/* X0 pipe last hword 0 IE off */
#define R_TILEGX_IMM16_X0_HW0_LAST_TLS_IE 100
/* X1 pipe last hword 0 IE off */
#define R_TILEGX_IMM16_X1_HW0_LAST_TLS_IE 101
/* X0 pipe last hword 1 IE off */
#define R_TILEGX_IMM16_X0_HW1_LAST_TLS_IE 102
/* X1 pipe last hword 1 IE off */
#define R_TILEGX_IMM16_X1_HW1_LAST_TLS_IE 103
/* Relocs 104-105 are currently not defined.  */
/* 64-bit ID of symbol's module */

#define R_TILEGX_TLS_DTPMOD64 106
/* 64-bit offset in TLS block */
#define R_TILEGX_TLS_DTPOFF64 107
/* 64-bit offset in static TLS block */
#define R_TILEGX_TLS_TPOFF64 108
/* 32-bit ID of symbol's module */
#define R_TILEGX_TLS_DTPMOD32 109
/* 32-bit offset in TLS block */
#define R_TILEGX_TLS_DTPOFF32 110
/* 32-bit offset in static TLS block */
#define R_TILEGX_TLS_TPOFF32 111
/* "jal" for TLS GD */
#define R_TILEGX_TLS_GD_CALL 112
/* X0 pipe "addi" for TLS GD */
#define R_TILEGX_IMM8_X0_TLS_GD_ADD 113
/* X1 pipe "addi" for TLS GD */
#define R_TILEGX_IMM8_X1_TLS_GD_ADD 114
/* Y0 pipe "addi" for TLS GD */
#define R_TILEGX_IMM8_Y0_TLS_GD_ADD 115
/* Y1 pipe "addi" for TLS GD */
#define R_TILEGX_IMM8_Y1_TLS_GD_ADD 116
/* "ld_tls" for TLS IE */
#define R_TILEGX_TLS_IE_LOAD 117
/* X0 pipe "addi" for TLS GD/IE */
#define R_TILEGX_IMM8_X0_TLS_ADD 118
/* X1 pipe "addi" for TLS GD/IE */
#define R_TILEGX_IMM8_X1_TLS_ADD 119
/* Y0 pipe "addi" for TLS GD/IE */
#define R_TILEGX_IMM8_Y0_TLS_ADD 120
/* Y1 pipe "addi" for TLS GD/IE */
#define R_TILEGX_IMM8_Y1_TLS_ADD 121
/* GNU C++ vtable hierarchy */

#define R_TILEGX_GNU_VTINHERIT 128
/* GNU C++ vtable member usage */
#define R_TILEGX_GNU_VTENTRY 129

#define R_TILEGX_NUM 130
/* RISC-V ELF Flags */

#define EF_RISCV_RVC 0x0001
#define EF_RISCV_FLOAT_ABI 0x0006
#define EF_RISCV_FLOAT_ABI_SOFT 0x0000
#define EF_RISCV_FLOAT_ABI_SINGLE 0x0002
#define EF_RISCV_FLOAT_ABI_DOUBLE 0x0004
#define EF_RISCV_FLOAT_ABI_QUAD 0x0006
/* RISC-V relocations.  */

#define R_RISCV_NONE 0
#define R_RISCV_32 1
#define R_RISCV_64 2
#define R_RISCV_RELATIVE 3
#define R_RISCV_COPY 4
#define R_RISCV_JUMP_SLOT 5
#define R_RISCV_TLS_DTPMOD32 6
#define R_RISCV_TLS_DTPMOD64 7
#define R_RISCV_TLS_DTPREL32 8
#define R_RISCV_TLS_DTPREL64 9
#define R_RISCV_TLS_TPREL32 10
#define R_RISCV_TLS_TPREL64 11
#define R_RISCV_BRANCH 16
#define R_RISCV_JAL 17
#define R_RISCV_CALL 18
#define R_RISCV_CALL_PLT 19
#define R_RISCV_GOT_HI20 20
#define R_RISCV_TLS_GOT_HI20 21
#define R_RISCV_TLS_GD_HI20 22
#define R_RISCV_PCREL_HI20 23
#define R_RISCV_PCREL_LO12_I 24
#define R_RISCV_PCREL_LO12_S 25
#define R_RISCV_HI20 26
#define R_RISCV_LO12_I 27
#define R_RISCV_LO12_S 28
#define R_RISCV_TPREL_HI20 29
#define R_RISCV_TPREL_LO12_I 30
#define R_RISCV_TPREL_LO12_S 31
#define R_RISCV_TPREL_ADD 32
#define R_RISCV_ADD8 33
#define R_RISCV_ADD16 34
#define R_RISCV_ADD32 35
#define R_RISCV_ADD64 36
#define R_RISCV_SUB8 37
#define R_RISCV_SUB16 38
#define R_RISCV_SUB32 39
#define R_RISCV_SUB64 40
#define R_RISCV_GNU_VTINHERIT 41
#define R_RISCV_GNU_VTENTRY 42
#define R_RISCV_ALIGN 43
#define R_RISCV_RVC_BRANCH 44
#define R_RISCV_RVC_JUMP 45
#define R_RISCV_RVC_LUI 46
#define R_RISCV_GPREL_I 47
#define R_RISCV_GPREL_S 48
#define R_RISCV_TPREL_I 49
#define R_RISCV_TPREL_S 50
#define R_RISCV_RELAX 51
#define R_RISCV_SUB6 52
#define R_RISCV_SET6 53
#define R_RISCV_SET8 54
#define R_RISCV_SET16 55
#define R_RISCV_SET32 56
#define R_RISCV_32_PCREL 57

#define R_RISCV_NUM 58
/* elf.h */
#endif /* _ELF_H */
// 339 "tcc.h" 2
// 1 "stab.h" 1
#ifndef __GNU_STAB__
/* Indicate the GNU stab.h is in use.  */

#define __GNU_STAB__

#define __define_stab(NAME,CODE,STRING) NAME=CODE,

enum __stab_debug_code {
// 1 "stab.def" 1
	/* Table of DBX symbol codes for the GNU system.
	   Copyright (C) 1988, 1997 Free Software Foundation, Inc.
	   This file is part of the GNU C Library.

	   The GNU C Library is free software; you can redistribute it and/or
	   modify it under the terms of the GNU Library General Public License as
	   published by the Free Software Foundation; either version 2 of the
	   License, or (at your option) any later version.

	   The GNU C Library is distributed in the hope that it will be useful,
	   but WITHOUT ANY WARRANTY; without even the implied warranty of
	   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	   Library General Public License for more details.

	   You should have received a copy of the GNU Library General Public
	   License along with the GNU C Library; see the file COPYING.LIB.  If not,
	   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	   Boston, MA 02111-1307, USA.  */
	/* This contains contribution from Cygnus Support.  */
	/* Global variable.  Only the name is significant.
	   To find the address, look in the corresponding external symbol.  */
// 24 "stab.def"
	__define_stab (N_GSYM, 0x20, "GSYM")
	/* Function name for BSD Fortran.  Only the name is significant.
	   To find the address, look in the corresponding external symbol.  */

	__define_stab (N_FNAME, 0x22, "FNAME")
	/* Function name or text-segment variable for C.  Value is its address.
	   Desc is supposedly starting line number, but GCC doesn't set it
	   and DBX seems not to miss it.  */

	__define_stab (N_FUN, 0x24, "FUN")
	/* Data-segment variable with internal linkage.  Value is its address.
	   "Static Sym".  */

	__define_stab (N_STSYM, 0x26, "STSYM")
	/* BSS-segment variable with internal linkage.  Value is its address.  */

	__define_stab (N_LCSYM, 0x28, "LCSYM")
	/* Name of main routine.  Only the name is significant.
	   This is not used in C.  */

	__define_stab (N_MAIN, 0x2a, "MAIN")
	/* Global symbol in Pascal.
	   Supposedly the value is its line number; I'm skeptical.  */

	__define_stab (N_PC, 0x30, "PC")
	/* Number of symbols:  0, files,,funcs,lines according to Ultrix V4.0. */

	__define_stab (N_NSYMS, 0x32, "NSYMS")
	/* "No DST map for sym: name, ,0,type,ignored"  according to Ultrix V4.0. */

	__define_stab (N_NOMAP, 0x34, "NOMAP")
	/* New stab from Solaris.  I don't know what it means, but it
	   don't seem to contain useful information.  */

	__define_stab (N_OBJ, 0x38, "OBJ")
	/* New stab from Solaris.  I don't know what it means, but it
	   don't seem to contain useful information.  Possibly related to the
	   optimization flags used in this module.  */

	__define_stab (N_OPT, 0x3c, "OPT")
	/* Register variable.  Value is number of register.  */

	__define_stab (N_RSYM, 0x40, "RSYM")
	/* Modula-2 compilation unit.  Can someone say what info it contains?  */

	__define_stab (N_M2C, 0x42, "M2C")
	/* Line number in text segment.  Desc is the line number;
	   value is corresponding address.  */

	__define_stab (N_SLINE, 0x44, "SLINE")
	/* Similar, for data segment.  */

	__define_stab (N_DSLINE, 0x46, "DSLINE")
	/* Similar, for bss segment.  */

	__define_stab (N_BSLINE, 0x48, "BSLINE")
	/* Sun's source-code browser stabs.  ?? Don't know what the fields are.
	   Supposedly the field is "path to associated .cb file".  THIS VALUE
	   OVERLAPS WITH N_BSLINE!  */

	__define_stab (N_BROWS, 0x48, "BROWS")
	/* GNU Modula-2 definition module dependency.  Value is the modification time
	   of the definition file.  Other is non-zero if it is imported with the
	   GNU M2 keyword %INITIALIZE.  Perhaps N_M2C can be used if there
	   are enough empty fields? */

	__define_stab(N_DEFD, 0x4a, "DEFD")
	/* THE FOLLOWING TWO STAB VALUES CONFLICT.  Happily, one is for Modula-2
	   and one is for C++.   Still,... */
	/* GNU C++ exception variable.  Name is variable name.  */

	__define_stab (N_EHDECL, 0x50, "EHDECL")
	/* Modula2 info "for imc":  name,,0,0,0  according to Ultrix V4.0.  */

	__define_stab (N_MOD2, 0x50, "MOD2")
	/* GNU C++ `catch' clause.  Value is its address.  Desc is nonzero if
	   this entry is immediately followed by a CAUGHT stab saying what exception
	   was caught.  Multiple CAUGHT stabs means that multiple exceptions
	   can be caught here.  If Desc is 0, it means all exceptions are caught
	   here.  */

	__define_stab (N_CATCH, 0x54, "CATCH")
	/* Structure or union element.  Value is offset in the structure.  */

	__define_stab (N_SSYM, 0x60, "SSYM")
	/* Name of main source file.
	   Value is starting text address of the compilation.  */

	__define_stab (N_SO, 0x64, "SO")
	/* Automatic variable in the stack.  Value is offset from frame pointer.
	   Also used for type descriptions.  */

	__define_stab (N_LSYM, 0x80, "LSYM")
	/* Beginning of an include file.  Only Sun uses this.
	   In an object file, only the name is significant.
	   The Sun linker puts data into some of the other fields.  */

	__define_stab (N_BINCL, 0x82, "BINCL")
	/* Name of sub-source file (#include file).
	   Value is starting text address of the compilation.  */

	__define_stab (N_SOL, 0x84, "SOL")
	/* Parameter variable.  Value is offset from argument pointer.
	   (On most machines the argument pointer is the same as the frame pointer.  */

	__define_stab (N_PSYM, 0xa0, "PSYM")
	/* End of an include file.  No name.
	   This and N_BINCL act as brackets around the file's output.
	   In an object file, there is no significant data in this entry.
	   The Sun linker puts data into some of the fields.  */

	__define_stab (N_EINCL, 0xa2, "EINCL")
	/* Alternate entry point.  Value is its address.  */

	__define_stab (N_ENTRY, 0xa4, "ENTRY")
	/* Beginning of lexical block.
	   The desc is the nesting level in lexical blocks.
	   The value is the address of the start of the text for the block.
	   The variables declared inside the block *precede* the N_LBRAC symbol.  */

	__define_stab (N_LBRAC, 0xc0, "LBRAC")
	/* Place holder for deleted include file.  Replaces a N_BINCL and everything
	   up to the corresponding N_EINCL.  The Sun linker generates these when
	   it finds multiple identical copies of the symbols from an include file.
	   This appears only in output from the Sun linker.  */

	__define_stab (N_EXCL, 0xc2, "EXCL")
	/* Modula-2 scope information.  Can someone say what info it contains?  */

	__define_stab (N_SCOPE, 0xc4, "SCOPE")
	/* End of a lexical block.  Desc matches the N_LBRAC's desc.
	   The value is the address of the end of the text for the block.  */

	__define_stab (N_RBRAC, 0xe0, "RBRAC")
	/* Begin named common block.  Only the name is significant.  */

	__define_stab (N_BCOMM, 0xe2, "BCOMM")
	/* End named common block.  Only the name is significant
	   (and it should match the N_BCOMM).  */

	__define_stab (N_ECOMM, 0xe4, "ECOMM")
	/* End common (local name): value is address.
	   I'm not sure how this is used.  */

	__define_stab (N_ECOML, 0xe8, "ECOML")
	/* These STAB's are used on Gould systems for Non-Base register symbols
	   or something like that.  FIXME.  I have assigned the values at random
	   since I don't have a Gould here.  Fixups from Gould folk welcome... */

	__define_stab (N_NBTEXT, 0xF0, "NBTEXT")
	__define_stab (N_NBDATA, 0xF2, "NBDATA")
	__define_stab (N_NBBSS, 0xF4, "NBBSS")
	__define_stab (N_NBSTS, 0xF6, "NBSTS")
	__define_stab (N_NBLCS, 0xF8, "NBLCS")
	/* Second symbol entry containing a length-value for the preceding entry.
	   The value is the length.  */

	__define_stab (N_LENG, 0xfe, "LENG")
	/* The above information, in matrix format.

				STAB MATRIX
		_________________________________________________
		| 00 - 1F are not dbx stab symbols		|
		| In most cases, the low bit is the EXTernal bit|

		| 00 UNDEF  | 02 ABS	| 04 TEXT   | 06 DATA	|
		| 01  |EXT  | 03  |EXT	| 05  |EXT  | 07  |EXT	|

		| 08 BSS    | 0A INDR	| 0C FN_SEQ | 0E   	|
		| 09  |EXT  | 0B 	| 0D	    | 0F	|

		| 10 	    | 12 COMM	| 14 SETA   | 16 SETT	|
		| 11	    | 13	| 15 	    | 17	|

		| 18 SETD   | 1A SETB	| 1C SETV   | 1E WARNING|
		| 19	    | 1B	| 1D 	    | 1F FN	|

		|_______________________________________________|
		| Debug entries with bit 01 set are unused.	|
		| 20 GSYM   | 22 FNAME	| 24 FUN    | 26 STSYM	|
		| 28 LCSYM  | 2A MAIN	| 2C	    | 2E	|
		| 30 PC	    | 32 NSYMS	| 34 NOMAP  | 36	|
		| 38 OBJ    | 3A	| 3C OPT    | 3E	|
		| 40 RSYM   | 42 M2C	| 44 SLINE\  | 46 DSLINE |
		| 48 BSLINE*| 4A DEFD	| 4C        | 4E	|
		| 50 EHDECL*| 52	| 54 CATCH  | 56        |
		| 58        | 5A        | 5C        | 5E	|
		| 60 SSYM   | 62	| 64 SO	    | 66 	|
		| 68 	    | 6A	| 6C	    | 6E	|
		| 70	    | 72	| 74	    | 76	|
		| 78	    | 7A	| 7C	    | 7E	|
		| 80 LSYM   | 82 BINCL	| 84 SOL    | 86	|
		| 88	    | 8A	| 8C	    | 8E	|
		| 90	    | 92	| 94	    | 96	|
		| 98	    | 9A	| 9C	    | 9E	|
		| A0 PSYM   | A2 EINCL	| A4 ENTRY  | A6	|
		| A8	    | AA	| AC	    | AE	|
		| B0	    | B2	| B4	    | B6	|
		| B8	    | BA	| BC	    | BE	|
		| C0 LBRAC  | C2 EXCL	| C4 SCOPE  | C6	|
		| C8	    | CA	| CC	    | CE	|
		| D0	    | D2	| D4	    | D6	|
		| D8	    | DA	| DC	    | DE	|
		| E0 RBRAC  | E2 BCOMM	| E4 ECOMM  | E6	|
		| E8 ECOML  | EA	| EC	    | EE	|
		| F0	    | F2	| F4	    | F6	|
		| F8	    | FA	| FC	    | FE LENG	|
		+-----------------------------------------------+
	 * 50 EHDECL is also MOD2.
	 * 48 BSLINE is also BROWS.
	 */
// 12 "stab.h" 2
	LAST_UNUSED_STAB_CODE
};

#undef __define_stab
/* __GNU_STAB_ */
#endif /* __GNU_STAB__ */
// 340 "tcc.h" 2
// 1 "dwarf.h" 1
/* This file defines standard DWARF types, structures, and macros.
   Copyright (C) 2000-2011, 2014, 2016, 2017, 2018 Red Hat, Inc.
   This file is part of elfutils.

   This file is free software; you can redistribute it and/or modify
   it under the terms of either

     * the GNU Lesser General Public License as published by the Free
       Software Foundation; either version 3 of the License, or (at
       your option) any later version

   or

     * the GNU General Public License as published by the Free
       Software Foundation; either version 2 of the License, or (at
       your option) any later version

   or both in parallel, as here.

   elfutils is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received copies of the GNU General Public License and
   the GNU Lesser General Public License along with this program.  If
   not, see <http://www.gnu.org/licenses/>.  */
#ifndef _DWARF_H
// 30 "dwarf.h"
#define _DWARF_H 1
/* DWARF Unit Header Types.  */

enum {
	DW_UT_compile = 0x01,
	DW_UT_type = 0x02,
	DW_UT_partial = 0x03,
	DW_UT_skeleton = 0x04,
	DW_UT_split_compile = 0x05,
	DW_UT_split_type = 0x06,

	DW_UT_lo_user = 0x80,
	DW_UT_hi_user = 0xff
};
/* DWARF tags.  */

enum {
	DW_TAG_array_type = 0x01,
	DW_TAG_class_type = 0x02,
	DW_TAG_entry_point = 0x03,
	DW_TAG_enumeration_type = 0x04,
	DW_TAG_formal_parameter = 0x05,
	/* 0x06 reserved.  */
	/* 0x07 reserved.  */

	DW_TAG_imported_declaration = 0x08,
	/* 0x09 reserved.  */

	DW_TAG_label = 0x0a,
	DW_TAG_lexical_block = 0x0b,
	/* 0x0c reserved.  */

	DW_TAG_member = 0x0d,
	/* 0x0e reserved.  */

	DW_TAG_pointer_type = 0x0f,
	DW_TAG_reference_type = 0x10,
	DW_TAG_compile_unit = 0x11,
	DW_TAG_string_type = 0x12,
	DW_TAG_structure_type = 0x13,
	/* 0x14 reserved.  */

	DW_TAG_subroutine_type = 0x15,
	DW_TAG_typedef = 0x16,
	DW_TAG_union_type = 0x17,
	DW_TAG_unspecified_parameters = 0x18,
	DW_TAG_variant = 0x19,
	DW_TAG_common_block = 0x1a,
	DW_TAG_common_inclusion = 0x1b,
	DW_TAG_inheritance = 0x1c,
	DW_TAG_inlined_subroutine = 0x1d,
	DW_TAG_module = 0x1e,
	DW_TAG_ptr_to_member_type = 0x1f,
	DW_TAG_set_type = 0x20,
	DW_TAG_subrange_type = 0x21,
	DW_TAG_with_stmt = 0x22,
	DW_TAG_access_declaration = 0x23,
	DW_TAG_base_type = 0x24,
	DW_TAG_catch_block = 0x25,
	DW_TAG_const_type = 0x26,
	DW_TAG_constant = 0x27,
	DW_TAG_enumerator = 0x28,
	DW_TAG_file_type = 0x29,
	DW_TAG_friend = 0x2a,
	DW_TAG_namelist = 0x2b,
	DW_TAG_namelist_item = 0x2c,
	DW_TAG_packed_type = 0x2d,
	DW_TAG_subprogram = 0x2e,
	DW_TAG_template_type_parameter = 0x2f,
	DW_TAG_template_value_parameter = 0x30,
	DW_TAG_thrown_type = 0x31,
	DW_TAG_try_block = 0x32,
	DW_TAG_variant_part = 0x33,
	DW_TAG_variable = 0x34,
	DW_TAG_volatile_type = 0x35,
	DW_TAG_dwarf_procedure = 0x36,
	DW_TAG_restrict_type = 0x37,
	DW_TAG_interface_type = 0x38,
	DW_TAG_namespace = 0x39,
	DW_TAG_imported_module = 0x3a,
	DW_TAG_unspecified_type = 0x3b,
	DW_TAG_partial_unit = 0x3c,
	DW_TAG_imported_unit = 0x3d,
	/* 0x3e reserved.  Was DW_TAG_mutable_type.  */

	DW_TAG_condition = 0x3f,
	DW_TAG_shared_type = 0x40,
	DW_TAG_type_unit = 0x41,
	DW_TAG_rvalue_reference_type = 0x42,
	DW_TAG_template_alias = 0x43,
	DW_TAG_coarray_type = 0x44,
	DW_TAG_generic_subrange = 0x45,
	DW_TAG_dynamic_type = 0x46,
	DW_TAG_atomic_type = 0x47,
	DW_TAG_call_site = 0x48,
	DW_TAG_call_site_parameter = 0x49,
	DW_TAG_skeleton_unit = 0x4a,
	DW_TAG_immutable_type = 0x4b,

	DW_TAG_lo_user = 0x4080,

	DW_TAG_MIPS_loop = 0x4081,
	DW_TAG_format_label = 0x4101,
	DW_TAG_function_template = 0x4102,
	DW_TAG_class_template = 0x4103,

	DW_TAG_GNU_BINCL = 0x4104,
	DW_TAG_GNU_EINCL = 0x4105,

	DW_TAG_GNU_template_template_param = 0x4106,
	DW_TAG_GNU_template_parameter_pack = 0x4107,
	DW_TAG_GNU_formal_parameter_pack = 0x4108,
	DW_TAG_GNU_call_site = 0x4109,
	DW_TAG_GNU_call_site_parameter = 0x410a,

	DW_TAG_hi_user = 0xffff
};
/* Children determination encodings.  */

enum {
	DW_CHILDREN_no = 0,
	DW_CHILDREN_yes = 1
};
/* DWARF attributes encodings.  */

enum {
	DW_AT_sibling = 0x01,
	DW_AT_location = 0x02,
	DW_AT_name = 0x03,
	/* 0x04 reserved.  */
	/* 0x05 reserved.  */
	/* 0x06 reserved.  */
	/* 0x07 reserved.  */
	/* 0x08 reserved.  */

	DW_AT_ordering = 0x09,
	/* 0x0a reserved.  */

	DW_AT_byte_size = 0x0b,
	DW_AT_bit_offset = 0x0c,/* Deprecated in DWARF4.  */

	DW_AT_bit_size = 0x0d,
	/* 0x0e reserved.  */
	/* 0x0f reserved.  */

	DW_AT_stmt_list = 0x10,
	DW_AT_low_pc = 0x11,
	DW_AT_high_pc = 0x12,
	DW_AT_language = 0x13,
	/* 0x14 reserved.  */

	DW_AT_discr = 0x15,
	DW_AT_discr_value = 0x16,
	DW_AT_visibility = 0x17,
	DW_AT_import = 0x18,
	DW_AT_string_length = 0x19,
	DW_AT_common_reference = 0x1a,
	DW_AT_comp_dir = 0x1b,
	DW_AT_const_value = 0x1c,
	DW_AT_containing_type = 0x1d,
	DW_AT_default_value = 0x1e,
	/* 0x1f reserved.  */

	DW_AT_inline = 0x20,
	DW_AT_is_optional = 0x21,
	DW_AT_lower_bound = 0x22,
	/* 0x23 reserved.  */
	/* 0x24 reserved.  */

	DW_AT_producer = 0x25,
	/* 0x26 reserved.  */

	DW_AT_prototyped = 0x27,
	/* 0x28 reserved.  */
	/* 0x29 reserved.  */

	DW_AT_return_addr = 0x2a,
	/* 0x2b reserved.  */

	DW_AT_start_scope = 0x2c,
	/* 0x2d reserved.  */

	DW_AT_bit_stride = 0x2e,
	DW_AT_upper_bound = 0x2f,
	/* 0x30 reserved.  */

	DW_AT_abstract_origin = 0x31,
	DW_AT_accessibility = 0x32,
	DW_AT_address_class = 0x33,
	DW_AT_artificial = 0x34,
	DW_AT_base_types = 0x35,
	DW_AT_calling_convention = 0x36,
	DW_AT_count = 0x37,
	DW_AT_data_member_location = 0x38,
	DW_AT_decl_column = 0x39,
	DW_AT_decl_file = 0x3a,
	DW_AT_decl_line = 0x3b,
	DW_AT_declaration = 0x3c,
	DW_AT_discr_list = 0x3d,
	DW_AT_encoding = 0x3e,
	DW_AT_external = 0x3f,
	DW_AT_frame_base = 0x40,
	DW_AT_friend = 0x41,
	DW_AT_identifier_case = 0x42,
	DW_AT_macro_info = 0x43,/* Deprecated in DWARF5.  */

	DW_AT_namelist_item = 0x44,
	DW_AT_priority = 0x45,
	DW_AT_segment = 0x46,
	DW_AT_specification = 0x47,
	DW_AT_static_link = 0x48,
	DW_AT_type = 0x49,
	DW_AT_use_location = 0x4a,
	DW_AT_variable_parameter = 0x4b,
	DW_AT_virtuality = 0x4c,
	DW_AT_vtable_elem_location = 0x4d,
	DW_AT_allocated = 0x4e,
	DW_AT_associated = 0x4f,
	DW_AT_data_location = 0x50,
	DW_AT_byte_stride = 0x51,
	DW_AT_entry_pc = 0x52,
	DW_AT_use_UTF8 = 0x53,
	DW_AT_extension = 0x54,
	DW_AT_ranges = 0x55,
	DW_AT_trampoline = 0x56,
	DW_AT_call_column = 0x57,
	DW_AT_call_file = 0x58,
	DW_AT_call_line = 0x59,
	DW_AT_description = 0x5a,
	DW_AT_binary_scale = 0x5b,
	DW_AT_decimal_scale = 0x5c,
	DW_AT_small = 0x5d,
	DW_AT_decimal_sign = 0x5e,
	DW_AT_digit_count = 0x5f,
	DW_AT_picture_string = 0x60,
	DW_AT_mutable = 0x61,
	DW_AT_threads_scaled = 0x62,
	DW_AT_explicit = 0x63,
	DW_AT_object_pointer = 0x64,
	DW_AT_endianity = 0x65,
	DW_AT_elemental = 0x66,
	DW_AT_pure = 0x67,
	DW_AT_recursive = 0x68,
	DW_AT_signature = 0x69,
	DW_AT_main_subprogram = 0x6a,
	DW_AT_data_bit_offset = 0x6b,
	DW_AT_const_expr = 0x6c,
	DW_AT_enum_class = 0x6d,
	DW_AT_linkage_name = 0x6e,
	DW_AT_string_length_bit_size = 0x6f,
	DW_AT_string_length_byte_size = 0x70,
	DW_AT_rank = 0x71,
	DW_AT_str_offsets_base = 0x72,
	DW_AT_addr_base = 0x73,
	DW_AT_rnglists_base = 0x74,
	/* 0x75 reserved.  */

	DW_AT_dwo_name = 0x76,
	DW_AT_reference = 0x77,
	DW_AT_rvalue_reference = 0x78,
	DW_AT_macros = 0x79,
	DW_AT_call_all_calls = 0x7a,
	DW_AT_call_all_source_calls = 0x7b,
	DW_AT_call_all_tail_calls = 0x7c,
	DW_AT_call_return_pc = 0x7d,
	DW_AT_call_value = 0x7e,
	DW_AT_call_origin = 0x7f,
	DW_AT_call_parameter = 0x80,
	DW_AT_call_pc = 0x81,
	DW_AT_call_tail_call = 0x82,
	DW_AT_call_target = 0x83,
	DW_AT_call_target_clobbered = 0x84,
	DW_AT_call_data_location = 0x85,
	DW_AT_call_data_value = 0x86,
	DW_AT_noreturn = 0x87,
	DW_AT_alignment = 0x88,
	DW_AT_export_symbols = 0x89,
	DW_AT_deleted = 0x8a,
	DW_AT_defaulted = 0x8b,
	DW_AT_loclists_base = 0x8c,

	DW_AT_lo_user = 0x2000,

	DW_AT_MIPS_fde = 0x2001,
	DW_AT_MIPS_loop_begin = 0x2002,
	DW_AT_MIPS_tail_loop_begin = 0x2003,
	DW_AT_MIPS_epilog_begin = 0x2004,
	DW_AT_MIPS_loop_unroll_factor = 0x2005,
	DW_AT_MIPS_software_pipeline_depth = 0x2006,
	DW_AT_MIPS_linkage_name = 0x2007,
	DW_AT_MIPS_stride = 0x2008,
	DW_AT_MIPS_abstract_name = 0x2009,
	DW_AT_MIPS_clone_origin = 0x200a,
	DW_AT_MIPS_has_inlines = 0x200b,
	DW_AT_MIPS_stride_byte = 0x200c,
	DW_AT_MIPS_stride_elem = 0x200d,
	DW_AT_MIPS_ptr_dopetype = 0x200e,
	DW_AT_MIPS_allocatable_dopetype = 0x200f,
	DW_AT_MIPS_assumed_shape_dopetype = 0x2010,
	DW_AT_MIPS_assumed_size = 0x2011,
	/* GNU extensions.  */

	DW_AT_sf_names = 0x2101,
	DW_AT_src_info = 0x2102,
	DW_AT_mac_info = 0x2103,
	DW_AT_src_coords = 0x2104,
	DW_AT_body_begin = 0x2105,
	DW_AT_body_end = 0x2106,
	DW_AT_GNU_vector = 0x2107,
	DW_AT_GNU_guarded_by = 0x2108,
	DW_AT_GNU_pt_guarded_by = 0x2109,
	DW_AT_GNU_guarded = 0x210a,
	DW_AT_GNU_pt_guarded = 0x210b,
	DW_AT_GNU_locks_excluded = 0x210c,
	DW_AT_GNU_exclusive_locks_required = 0x210d,
	DW_AT_GNU_shared_locks_required = 0x210e,
	DW_AT_GNU_odr_signature = 0x210f,
	DW_AT_GNU_template_name = 0x2110,
	DW_AT_GNU_call_site_value = 0x2111,
	DW_AT_GNU_call_site_data_value = 0x2112,
	DW_AT_GNU_call_site_target = 0x2113,
	DW_AT_GNU_call_site_target_clobbered = 0x2114,
	DW_AT_GNU_tail_call = 0x2115,
	DW_AT_GNU_all_tail_call_sites = 0x2116,
	DW_AT_GNU_all_call_sites = 0x2117,
	DW_AT_GNU_all_source_call_sites = 0x2118,
	DW_AT_GNU_locviews = 0x2137,
	DW_AT_GNU_entry_view = 0x2138,
	DW_AT_GNU_macros = 0x2119,
	DW_AT_GNU_deleted = 0x211a,
	/* GNU Debug Fission extensions.  */

	DW_AT_GNU_dwo_name = 0x2130,
	DW_AT_GNU_dwo_id = 0x2131,
	DW_AT_GNU_ranges_base = 0x2132,
	DW_AT_GNU_addr_base = 0x2133,
	DW_AT_GNU_pubnames = 0x2134,
	DW_AT_GNU_pubtypes = 0x2135,
	/* https://gcc.gnu.org/wiki/DW_AT_GNU_numerator_denominator  */

	DW_AT_GNU_numerator = 0x2303,
	DW_AT_GNU_denominator = 0x2304,
	/* https://gcc.gnu.org/wiki/DW_AT_GNU_bias  */

	DW_AT_GNU_bias = 0x2305,

	DW_AT_hi_user = 0x3fff
};
/* Old unofficially attribute names.  Should not be used.
   Will not appear in known-dwarf.h  */
/* DWARF1 array subscripts and element data types.  */

#define DW_AT_subscr_data 0x0a
/* DWARF1 enumeration literals.  */

#define DW_AT_element_list 0x0f
/* DWARF1 reference for variable to member structure, class or union.  */

#define DW_AT_member 0x14
/* DWARF form encodings.  */

enum {
	DW_FORM_addr = 0x01,
	DW_FORM_block2 = 0x03,
	DW_FORM_block4 = 0x04,
	DW_FORM_data2 = 0x05,
	DW_FORM_data4 = 0x06,
	DW_FORM_data8 = 0x07,
	DW_FORM_string = 0x08,
	DW_FORM_block = 0x09,
	DW_FORM_block1 = 0x0a,
	DW_FORM_data1 = 0x0b,
	DW_FORM_flag = 0x0c,
	DW_FORM_sdata = 0x0d,
	DW_FORM_strp = 0x0e,
	DW_FORM_udata = 0x0f,
	DW_FORM_ref_addr = 0x10,
	DW_FORM_ref1 = 0x11,
	DW_FORM_ref2 = 0x12,
	DW_FORM_ref4 = 0x13,
	DW_FORM_ref8 = 0x14,
	DW_FORM_ref_udata = 0x15,
	DW_FORM_indirect = 0x16,
	DW_FORM_sec_offset = 0x17,
	DW_FORM_exprloc = 0x18,
	DW_FORM_flag_present = 0x19,
	DW_FORM_strx = 0x1a,
	DW_FORM_addrx = 0x1b,
	DW_FORM_ref_sup4 = 0x1c,
	DW_FORM_strp_sup = 0x1d,
	DW_FORM_data16 = 0x1e,
	DW_FORM_line_strp = 0x1f,
	DW_FORM_ref_sig8 = 0x20,
	DW_FORM_implicit_const = 0x21,
	DW_FORM_loclistx = 0x22,
	DW_FORM_rnglistx = 0x23,
	DW_FORM_ref_sup8 = 0x24,
	DW_FORM_strx1 = 0x25,
	DW_FORM_strx2 = 0x26,
	DW_FORM_strx3 = 0x27,
	DW_FORM_strx4 = 0x28,
	DW_FORM_addrx1 = 0x29,
	DW_FORM_addrx2 = 0x2a,
	DW_FORM_addrx3 = 0x2b,
	DW_FORM_addrx4 = 0x2c,
	/* GNU Debug Fission extensions.  */

	DW_FORM_GNU_addr_index = 0x1f01,
	DW_FORM_GNU_str_index = 0x1f02,

	DW_FORM_GNU_ref_alt = 0x1f20,/* offset in alternate .debuginfo.  */

	DW_FORM_GNU_strp_alt = 0x1f21/* offset in alternate .debug_str. */

};
/* DWARF location operation encodings.  */

enum {
	DW_OP_addr = 0x03,/* Constant address.  */

	DW_OP_deref = 0x06,
	DW_OP_const1u = 0x08,/* Unsigned 1-byte constant.  */

	DW_OP_const1s = 0x09,/* Signed 1-byte constant.  */

	DW_OP_const2u = 0x0a,/* Unsigned 2-byte constant.  */

	DW_OP_const2s = 0x0b,/* Signed 2-byte constant.  */

	DW_OP_const4u = 0x0c,/* Unsigned 4-byte constant.  */

	DW_OP_const4s = 0x0d,/* Signed 4-byte constant.  */

	DW_OP_const8u = 0x0e,/* Unsigned 8-byte constant.  */

	DW_OP_const8s = 0x0f,/* Signed 8-byte constant.  */

	DW_OP_constu = 0x10,/* Unsigned LEB128 constant.  */

	DW_OP_consts = 0x11,/* Signed LEB128 constant.  */

	DW_OP_dup = 0x12,
	DW_OP_drop = 0x13,
	DW_OP_over = 0x14,
	DW_OP_pick = 0x15,/* 1-byte stack index.  */

	DW_OP_swap = 0x16,
	DW_OP_rot = 0x17,
	DW_OP_xderef = 0x18,
	DW_OP_abs = 0x19,
	DW_OP_and = 0x1a,
	DW_OP_div = 0x1b,
	DW_OP_minus = 0x1c,
	DW_OP_mod = 0x1d,
	DW_OP_mul = 0x1e,
	DW_OP_neg = 0x1f,
	DW_OP_not = 0x20,
	DW_OP_or = 0x21,
	DW_OP_plus = 0x22,
	DW_OP_plus_uconst = 0x23,/* Unsigned LEB128 addend.  */

	DW_OP_shl = 0x24,
	DW_OP_shr = 0x25,
	DW_OP_shra = 0x26,
	DW_OP_xor = 0x27,
	DW_OP_bra = 0x28,/* Signed 2-byte constant.  */

	DW_OP_eq = 0x29,
	DW_OP_ge = 0x2a,
	DW_OP_gt = 0x2b,
	DW_OP_le = 0x2c,
	DW_OP_lt = 0x2d,
	DW_OP_ne = 0x2e,
	DW_OP_skip = 0x2f,/* Signed 2-byte constant.  */

	DW_OP_lit0 = 0x30,/* Literal 0.  */

	DW_OP_lit1 = 0x31,/* Literal 1.  */

	DW_OP_lit2 = 0x32,/* Literal 2.  */

	DW_OP_lit3 = 0x33,/* Literal 3.  */

	DW_OP_lit4 = 0x34,/* Literal 4.  */

	DW_OP_lit5 = 0x35,/* Literal 5.  */

	DW_OP_lit6 = 0x36,/* Literal 6.  */

	DW_OP_lit7 = 0x37,/* Literal 7.  */

	DW_OP_lit8 = 0x38,/* Literal 8.  */

	DW_OP_lit9 = 0x39,/* Literal 9.  */

	DW_OP_lit10 = 0x3a,/* Literal 10.  */

	DW_OP_lit11 = 0x3b,/* Literal 11.  */

	DW_OP_lit12 = 0x3c,/* Literal 12.  */

	DW_OP_lit13 = 0x3d,/* Literal 13.  */

	DW_OP_lit14 = 0x3e,/* Literal 14.  */

	DW_OP_lit15 = 0x3f,/* Literal 15.  */

	DW_OP_lit16 = 0x40,/* Literal 16.  */

	DW_OP_lit17 = 0x41,/* Literal 17.  */

	DW_OP_lit18 = 0x42,/* Literal 18.  */

	DW_OP_lit19 = 0x43,/* Literal 19.  */

	DW_OP_lit20 = 0x44,/* Literal 20.  */

	DW_OP_lit21 = 0x45,/* Literal 21.  */

	DW_OP_lit22 = 0x46,/* Literal 22.  */

	DW_OP_lit23 = 0x47,/* Literal 23.  */

	DW_OP_lit24 = 0x48,/* Literal 24.  */

	DW_OP_lit25 = 0x49,/* Literal 25.  */

	DW_OP_lit26 = 0x4a,/* Literal 26.  */

	DW_OP_lit27 = 0x4b,/* Literal 27.  */

	DW_OP_lit28 = 0x4c,/* Literal 28.  */

	DW_OP_lit29 = 0x4d,/* Literal 29.  */

	DW_OP_lit30 = 0x4e,/* Literal 30.  */

	DW_OP_lit31 = 0x4f,/* Literal 31.  */

	DW_OP_reg0 = 0x50,/* Register 0.  */

	DW_OP_reg1 = 0x51,/* Register 1.  */

	DW_OP_reg2 = 0x52,/* Register 2.  */

	DW_OP_reg3 = 0x53,/* Register 3.  */

	DW_OP_reg4 = 0x54,/* Register 4.  */

	DW_OP_reg5 = 0x55,/* Register 5.  */

	DW_OP_reg6 = 0x56,/* Register 6.  */

	DW_OP_reg7 = 0x57,/* Register 7.  */

	DW_OP_reg8 = 0x58,/* Register 8.  */

	DW_OP_reg9 = 0x59,/* Register 9.  */

	DW_OP_reg10 = 0x5a,/* Register 10.  */

	DW_OP_reg11 = 0x5b,/* Register 11.  */

	DW_OP_reg12 = 0x5c,/* Register 12.  */

	DW_OP_reg13 = 0x5d,/* Register 13.  */

	DW_OP_reg14 = 0x5e,/* Register 14.  */

	DW_OP_reg15 = 0x5f,/* Register 15.  */

	DW_OP_reg16 = 0x60,/* Register 16.  */

	DW_OP_reg17 = 0x61,/* Register 17.  */

	DW_OP_reg18 = 0x62,/* Register 18.  */

	DW_OP_reg19 = 0x63,/* Register 19.  */

	DW_OP_reg20 = 0x64,/* Register 20.  */

	DW_OP_reg21 = 0x65,/* Register 21.  */

	DW_OP_reg22 = 0x66,/* Register 22.  */

	DW_OP_reg23 = 0x67,/* Register 24.  */

	DW_OP_reg24 = 0x68,/* Register 24.  */

	DW_OP_reg25 = 0x69,/* Register 25.  */

	DW_OP_reg26 = 0x6a,/* Register 26.  */

	DW_OP_reg27 = 0x6b,/* Register 27.  */

	DW_OP_reg28 = 0x6c,/* Register 28.  */

	DW_OP_reg29 = 0x6d,/* Register 29.  */

	DW_OP_reg30 = 0x6e,/* Register 30.  */

	DW_OP_reg31 = 0x6f,/* Register 31.  */

	DW_OP_breg0 = 0x70,/* Base register 0.  */

	DW_OP_breg1 = 0x71,/* Base register 1.  */

	DW_OP_breg2 = 0x72,/* Base register 2.  */

	DW_OP_breg3 = 0x73,/* Base register 3.  */

	DW_OP_breg4 = 0x74,/* Base register 4.  */

	DW_OP_breg5 = 0x75,/* Base register 5.  */

	DW_OP_breg6 = 0x76,/* Base register 6.  */

	DW_OP_breg7 = 0x77,/* Base register 7.  */

	DW_OP_breg8 = 0x78,/* Base register 8.  */

	DW_OP_breg9 = 0x79,/* Base register 9.  */

	DW_OP_breg10 = 0x7a,/* Base register 10.  */

	DW_OP_breg11 = 0x7b,/* Base register 11.  */

	DW_OP_breg12 = 0x7c,/* Base register 12.  */

	DW_OP_breg13 = 0x7d,/* Base register 13.  */

	DW_OP_breg14 = 0x7e,/* Base register 14.  */

	DW_OP_breg15 = 0x7f,/* Base register 15.  */

	DW_OP_breg16 = 0x80,/* Base register 16.  */

	DW_OP_breg17 = 0x81,/* Base register 17.  */

	DW_OP_breg18 = 0x82,/* Base register 18.  */

	DW_OP_breg19 = 0x83,/* Base register 19.  */

	DW_OP_breg20 = 0x84,/* Base register 20.  */

	DW_OP_breg21 = 0x85,/* Base register 21.  */

	DW_OP_breg22 = 0x86,/* Base register 22.  */

	DW_OP_breg23 = 0x87,/* Base register 23.  */

	DW_OP_breg24 = 0x88,/* Base register 24.  */

	DW_OP_breg25 = 0x89,/* Base register 25.  */

	DW_OP_breg26 = 0x8a,/* Base register 26.  */

	DW_OP_breg27 = 0x8b,/* Base register 27.  */

	DW_OP_breg28 = 0x8c,/* Base register 28.  */

	DW_OP_breg29 = 0x8d,/* Base register 29.  */

	DW_OP_breg30 = 0x8e,/* Base register 30.  */

	DW_OP_breg31 = 0x8f,/* Base register 31.  */

	DW_OP_regx = 0x90,/* Unsigned LEB128 register.  */

	DW_OP_fbreg = 0x91,/* Signed LEB128 offset.  */

	DW_OP_bregx = 0x92,/* ULEB128 register followed by SLEB128 off. */

	DW_OP_piece = 0x93,/* ULEB128 size of piece addressed. */

	DW_OP_deref_size = 0x94,/* 1-byte size of data retrieved.  */

	DW_OP_xderef_size = 0x95,/* 1-byte size of data retrieved.  */

	DW_OP_nop = 0x96,
	DW_OP_push_object_address = 0x97,
	DW_OP_call2 = 0x98,
	DW_OP_call4 = 0x99,
	DW_OP_call_ref = 0x9a,
	DW_OP_form_tls_address = 0x9b,/* TLS offset to address in current thread */

	DW_OP_call_frame_cfa = 0x9c,/* CFA as determined by CFI.  */

	DW_OP_bit_piece = 0x9d,/* ULEB128 size and ULEB128 offset in bits.  */

	DW_OP_implicit_value = 0x9e,/* DW_FORM_block follows opcode.  */

	DW_OP_stack_value = 0x9f,/* No operands, special like DW_OP_piece.  */

	DW_OP_implicit_pointer = 0xa0,
	DW_OP_addrx = 0xa1,
	DW_OP_constx = 0xa2,
	DW_OP_entry_value = 0xa3,
	DW_OP_const_type = 0xa4,
	DW_OP_regval_type = 0xa5,
	DW_OP_deref_type = 0xa6,
	DW_OP_xderef_type = 0xa7,
	DW_OP_convert = 0xa8,
	DW_OP_reinterpret = 0xa9,
	/* GNU extensions.  */

	DW_OP_GNU_push_tls_address = 0xe0,
	DW_OP_GNU_uninit = 0xf0,
	DW_OP_GNU_encoded_addr = 0xf1,
	DW_OP_GNU_implicit_pointer = 0xf2,
	DW_OP_GNU_entry_value = 0xf3,
	DW_OP_GNU_const_type = 0xf4,
	DW_OP_GNU_regval_type = 0xf5,
	DW_OP_GNU_deref_type = 0xf6,
	DW_OP_GNU_convert = 0xf7,
	DW_OP_GNU_reinterpret = 0xf9,
	DW_OP_GNU_parameter_ref = 0xfa,
	/* GNU Debug Fission extensions.  */

	DW_OP_GNU_addr_index = 0xfb,
	DW_OP_GNU_const_index = 0xfc,

	DW_OP_GNU_variable_value = 0xfd,

	DW_OP_lo_user = 0xe0,/* Implementation-defined range start.  */

	DW_OP_hi_user = 0xff/* Implementation-defined range end.  */

};
/* DWARF base type encodings.  */

enum {
	DW_ATE_void = 0x0,
	DW_ATE_address = 0x1,
	DW_ATE_boolean = 0x2,
	DW_ATE_complex_float = 0x3,
	DW_ATE_float = 0x4,
	DW_ATE_signed = 0x5,
	DW_ATE_signed_char = 0x6,
	DW_ATE_unsigned = 0x7,
	DW_ATE_unsigned_char = 0x8,
	DW_ATE_imaginary_float = 0x9,
	DW_ATE_packed_decimal = 0xa,
	DW_ATE_numeric_string = 0xb,
	DW_ATE_edited = 0xc,
	DW_ATE_signed_fixed = 0xd,
	DW_ATE_unsigned_fixed = 0xe,
	DW_ATE_decimal_float = 0xf,
	DW_ATE_UTF = 0x10,
	DW_ATE_UCS = 0x11,
	DW_ATE_ASCII = 0x12,

	DW_ATE_lo_user = 0x80,
	DW_ATE_hi_user = 0xff
};
/* DWARF decimal sign encodings.  */

enum {
	DW_DS_unsigned = 1,
	DW_DS_leading_overpunch = 2,
	DW_DS_trailing_overpunch = 3,
	DW_DS_leading_separate = 4,
	DW_DS_trailing_separate = 5,
};
/* DWARF endianity encodings.  */

enum {
	DW_END_default = 0,
	DW_END_big = 1,
	DW_END_little = 2,

	DW_END_lo_user = 0x40,
	DW_END_hi_user = 0xff
};
/* DWARF accessibility encodings.  */

enum {
	DW_ACCESS_public = 1,
	DW_ACCESS_protected = 2,
	DW_ACCESS_private = 3
};
/* DWARF visibility encodings.  */

enum {
	DW_VIS_local = 1,
	DW_VIS_exported = 2,
	DW_VIS_qualified = 3
};
/* DWARF virtuality encodings.  */

enum {
	DW_VIRTUALITY_none = 0,
	DW_VIRTUALITY_virtual = 1,
	DW_VIRTUALITY_pure_virtual = 2
};
/* DWARF language encodings.  */

enum {
	DW_LANG_C89 = 0x0001,/* ISO C:1989 */

	DW_LANG_C = 0x0002,/* C */

	DW_LANG_Ada83 = 0x0003,/* ISO Ada:1983 */

	DW_LANG_C_plus_plus	= 0x0004,/* ISO C++:1998 */

	DW_LANG_Cobol74 = 0x0005,/* ISO Cobol:1974 */

	DW_LANG_Cobol85 = 0x0006,/* ISO Cobol:1985 */

	DW_LANG_Fortran77 = 0x0007,/* ISO FORTRAN 77 */

	DW_LANG_Fortran90 = 0x0008,/* ISO Fortran 90 */

	DW_LANG_Pascal83 = 0x0009,/* ISO Pascal:1983 */

	DW_LANG_Modula2 = 0x000a,/* ISO Modula-2:1996 */

	DW_LANG_Java = 0x000b,/* Java */

	DW_LANG_C99 = 0x000c,/* ISO C:1999 */

	DW_LANG_Ada95 = 0x000d,/* ISO Ada:1995 */

	DW_LANG_Fortran95 = 0x000e,/* ISO Fortran 95 */

	DW_LANG_PLI = 0x000f,/* ISO PL/1:1976 */

	DW_LANG_ObjC = 0x0010,/* Objective-C */

	DW_LANG_ObjC_plus_plus = 0x0011,/* Objective-C++ */

	DW_LANG_UPC = 0x0012,/* Unified Parallel C */

	DW_LANG_D = 0x0013,/* D */

	DW_LANG_Python = 0x0014,/* Python */

	DW_LANG_OpenCL = 0x0015,/* OpenCL */

	DW_LANG_Go = 0x0016,/* Go */

	DW_LANG_Modula3 = 0x0017,/* Modula-3 */

	DW_LANG_Haskell = 0x0018,/* Haskell */

	DW_LANG_C_plus_plus_03 = 0x0019,/* ISO C++:2003 */

	DW_LANG_C_plus_plus_11 = 0x001a,/* ISO C++:2011 */

	DW_LANG_OCaml = 0x001b,/* OCaml */

	DW_LANG_Rust = 0x001c,/* Rust */

	DW_LANG_C11 = 0x001d,/* ISO C:2011 */

	DW_LANG_Swift = 0x001e,/* Swift */

	DW_LANG_Julia = 0x001f,/* Julia */

	DW_LANG_Dylan = 0x0020,/* Dylan */

	DW_LANG_C_plus_plus_14 = 0x0021,/* ISO C++:2014 */

	DW_LANG_Fortran03 = 0x0022,/* ISO/IEC 1539-1:2004 */

	DW_LANG_Fortran08 = 0x0023,/* ISO/IEC 1539-1:2010 */

	DW_LANG_RenderScript = 0x0024,/* RenderScript Kernal Language */

	DW_LANG_BLISS = 0x0025,/* BLISS */

	DW_LANG_lo_user = 0x8000,
	DW_LANG_Mips_Assembler = 0x8001,/* Assembler */

	DW_LANG_hi_user = 0xffff
};
/* Old (typo) '1' != 'I'.  */

#define DW_LANG_PL1 DW_LANG_PLI
/* DWARF identifier case encodings.  */

enum {
	DW_ID_case_sensitive = 0,
	DW_ID_up_case = 1,
	DW_ID_down_case = 2,
	DW_ID_case_insensitive = 3
};
/* DWARF calling conventions encodings.
   Used as values of DW_AT_calling_convention for subroutines
   (normal, program or nocall) or structures, unions and class types
   (normal, reference or value).  */

enum {
	DW_CC_normal = 0x1,
	DW_CC_program = 0x2,
	DW_CC_nocall = 0x3,
	DW_CC_pass_by_reference = 0x4,
	DW_CC_pass_by_value = 0x5,
	DW_CC_lo_user = 0x40,
	DW_CC_hi_user = 0xff
};
/* DWARF inline encodings.  */

enum {
	DW_INL_not_inlined = 0,
	DW_INL_inlined = 1,
	DW_INL_declared_not_inlined = 2,
	DW_INL_declared_inlined = 3
};
/* DWARF ordering encodings.  */

enum {
	DW_ORD_row_major = 0,
	DW_ORD_col_major = 1
};
/* DWARF discriminant descriptor encodings.  */

enum {
	DW_DSC_label = 0,
	DW_DSC_range = 1
};
/* DWARF defaulted member function encodings.  */

enum {
	DW_DEFAULTED_no = 0,
	DW_DEFAULTED_in_class = 1,
	DW_DEFAULTED_out_of_class = 2
};
/* DWARF line content descriptions.  */

enum {
	DW_LNCT_path = 0x1,
	DW_LNCT_directory_index = 0x2,
	DW_LNCT_timestamp = 0x3,
	DW_LNCT_size = 0x4,
	DW_LNCT_MD5 = 0x5,
	DW_LNCT_lo_user = 0x2000,
	DW_LNCT_hi_user = 0x3fff
};
/* DWARF standard opcode encodings.  */

enum {
	DW_LNS_copy = 1,
	DW_LNS_advance_pc = 2,
	DW_LNS_advance_line = 3,
	DW_LNS_set_file = 4,
	DW_LNS_set_column = 5,
	DW_LNS_negate_stmt = 6,
	DW_LNS_set_basic_block = 7,
	DW_LNS_const_add_pc = 8,
	DW_LNS_fixed_advance_pc = 9,
	DW_LNS_set_prologue_end = 10,
	DW_LNS_set_epilogue_begin = 11,
	DW_LNS_set_isa = 12
};
/* DWARF extended opcode encodings.  */

enum {
	DW_LNE_end_sequence = 1,
	DW_LNE_set_address = 2,
	DW_LNE_define_file = 3,
	DW_LNE_set_discriminator = 4,

	DW_LNE_lo_user = 128,

	DW_LNE_NVIDIA_inlined_call = 144,
	DW_LNE_NVIDIA_set_function_name = 145,

	DW_LNE_hi_user = 255
};
/* DWARF macinfo type encodings.  */

enum {
	DW_MACINFO_define = 1,
	DW_MACINFO_undef = 2,
	DW_MACINFO_start_file = 3,
	DW_MACINFO_end_file = 4,
	DW_MACINFO_vendor_ext = 255
};
/* DWARF debug_macro type encodings.  */

enum {
	DW_MACRO_define = 0x01,
	DW_MACRO_undef = 0x02,
	DW_MACRO_start_file = 0x03,
	DW_MACRO_end_file = 0x04,
	DW_MACRO_define_strp = 0x05,
	DW_MACRO_undef_strp = 0x06,
	DW_MACRO_import = 0x07,
	DW_MACRO_define_sup = 0x08,
	DW_MACRO_undef_sup = 0x09,
	DW_MACRO_import_sup = 0x0a,
	DW_MACRO_define_strx = 0x0b,
	DW_MACRO_undef_strx = 0x0c,
	DW_MACRO_lo_user = 0xe0,
	DW_MACRO_hi_user = 0xff
};
/* Old GNU extension names for DWARF5 debug_macro type encodings.
   There are no equivalents for the supplementary object file (sup)
   and indirect string references (strx).  */

#define DW_MACRO_GNU_define DW_MACRO_define
#define DW_MACRO_GNU_undef DW_MACRO_undef
#define DW_MACRO_GNU_start_file DW_MACRO_start_file
#define DW_MACRO_GNU_end_file DW_MACRO_end_file
#define DW_MACRO_GNU_define_indirect DW_MACRO_define_strp
#define DW_MACRO_GNU_undef_indirect DW_MACRO_undef_strp
#define DW_MACRO_GNU_transparent_include DW_MACRO_import
#define DW_MACRO_GNU_lo_user DW_MACRO_lo_user
#define DW_MACRO_GNU_hi_user DW_MACRO_hi_user
/* Range list entry encoding.  */

enum {
	DW_RLE_end_of_list = 0x0,
	DW_RLE_base_addressx = 0x1,
	DW_RLE_startx_endx = 0x2,
	DW_RLE_startx_length = 0x3,
	DW_RLE_offset_pair = 0x4,
	DW_RLE_base_address = 0x5,
	DW_RLE_start_end = 0x6,
	DW_RLE_start_length = 0x7
};
/* Location list entry encoding.  */

enum {
	DW_LLE_end_of_list = 0x0,
	DW_LLE_base_addressx = 0x1,
	DW_LLE_startx_endx = 0x2,
	DW_LLE_startx_length = 0x3,
	DW_LLE_offset_pair = 0x4,
	DW_LLE_default_location = 0x5,
	DW_LLE_base_address = 0x6,
	DW_LLE_start_end = 0x7,
	DW_LLE_start_length = 0x8
};
/* GNU DebugFission list entry encodings (.debug_loc.dwo).  */

enum {
	DW_LLE_GNU_end_of_list_entry = 0x0,
	DW_LLE_GNU_base_address_selection_entry = 0x1,
	DW_LLE_GNU_start_end_entry = 0x2,
	DW_LLE_GNU_start_length_entry = 0x3
};
/* DWARF5 package file section identifiers.  */

enum {
	DW_SECT_INFO = 1,
	/* Reserved = 2, */

	DW_SECT_ABBREV = 3,
	DW_SECT_LINE = 4,
	DW_SECT_LOCLISTS = 5,
	DW_SECT_STR_OFFSETS = 6,
	DW_SECT_MACRO = 7,
	DW_SECT_RNGLISTS = 8,
};
/* DWARF call frame instruction encodings.  */

enum {
	DW_CFA_advance_loc = 0x40,
	DW_CFA_offset = 0x80,
	DW_CFA_restore = 0xc0,
	DW_CFA_extended = 0,

	DW_CFA_nop = 0x00,
	DW_CFA_set_loc = 0x01,
	DW_CFA_advance_loc1 = 0x02,
	DW_CFA_advance_loc2 = 0x03,
	DW_CFA_advance_loc4 = 0x04,
	DW_CFA_offset_extended = 0x05,
	DW_CFA_restore_extended = 0x06,
	DW_CFA_undefined = 0x07,
	DW_CFA_same_value = 0x08,
	DW_CFA_register = 0x09,
	DW_CFA_remember_state = 0x0a,
	DW_CFA_restore_state = 0x0b,
	DW_CFA_def_cfa = 0x0c,
	DW_CFA_def_cfa_register = 0x0d,
	DW_CFA_def_cfa_offset = 0x0e,
	DW_CFA_def_cfa_expression = 0x0f,
	DW_CFA_expression = 0x10,
	DW_CFA_offset_extended_sf = 0x11,
	DW_CFA_def_cfa_sf = 0x12,
	DW_CFA_def_cfa_offset_sf = 0x13,
	DW_CFA_val_offset = 0x14,
	DW_CFA_val_offset_sf = 0x15,
	DW_CFA_val_expression = 0x16,

	DW_CFA_low_user = 0x1c,
	DW_CFA_MIPS_advance_loc8 = 0x1d,
	DW_CFA_GNU_window_save = 0x2d,
	DW_CFA_AARCH64_negate_ra_state = 0x2d,
	DW_CFA_GNU_args_size = 0x2e,
	DW_CFA_GNU_negative_offset_extended = 0x2f,
	DW_CFA_high_user = 0x3f
};
/* ID indicating CIE as opposed to FDE in .debug_frame.  */

enum {
	DW_CIE_ID_32 = 0xffffffffU,/* In 32-bit format CIE header.  */

	DW_CIE_ID_64 = 0xffffffffffffffffULL/* In 64-bit format CIE header.  */

};
/* Information for GNU unwind information.  */

enum {
	DW_EH_PE_absptr = 0x00,
	DW_EH_PE_omit = 0xff,
	/* FDE data encoding.  */

	DW_EH_PE_uleb128 = 0x01,
	DW_EH_PE_udata2 = 0x02,
	DW_EH_PE_udata4 = 0x03,
	DW_EH_PE_udata8 = 0x04,
	DW_EH_PE_sleb128 = 0x09,
	DW_EH_PE_sdata2 = 0x0a,
	DW_EH_PE_sdata4 = 0x0b,
	DW_EH_PE_sdata8 = 0x0c,
	DW_EH_PE_signed = 0x08,
	/* FDE flags.  */

	DW_EH_PE_pcrel = 0x10,
	DW_EH_PE_textrel = 0x20,
	DW_EH_PE_datarel = 0x30,
	DW_EH_PE_funcrel = 0x40,
	DW_EH_PE_aligned = 0x50,

	DW_EH_PE_indirect = 0x80
};
/* DWARF XXX.  */

#define DW_ADDR_none 0
/* Section 7.2.2 of the DWARF3 specification defines a range of escape
   codes that can appear in the length field of certain DWARF structures.

   These defines enumerate the minimum and maximum values of this range.
   Currently only the maximum value is used (to indicate that 64-bit
   values are going to be used in the dwarf data that accompanies the
   structure).  The other values are reserved.

   Note: There is a typo in DWARF3 spec (published Dec 20, 2005).  In
   sections 7.4, 7.5.1, 7.19, 7.20 the minimum escape code is referred to
   as 0xffffff00 whereas in fact it should be 0xfffffff0.  */
// 1042 "dwarf.h"
#define DWARF3_LENGTH_MIN_ESCAPE_CODE 0xfffffff0u
#define DWARF3_LENGTH_MAX_ESCAPE_CODE 0xffffffffu
#define DWARF3_LENGTH_64_BIT DWARF3_LENGTH_MAX_ESCAPE_CODE
/* dwarf.h */
#endif /* _DWARF_H */
// 341 "tcc.h" 2
/* -------------------------------------------- */
#ifndef PUB_FUNC
/* functions used by tcc.c but not in libtcc.h */

#define PUB_FUNC
#endif

#define ST_INLN static inline
#define ST_FUNC static
#define ST_DATA static
#ifdef TCC_PROFILE
/* profile all functions */

#define static
#define inline
#endif
/* -------------------------------------------- */
/* include the target specific definitions */
// 370 "tcc.h"
#define TARGET_DEFS_ONLY

// 1 "x86_64-gen.c" 1
/*
 *  x86-64 code generator for TCC
 *
 *  Copyright (c) 2008 Shinichiro Hamaji
 *
 *  Based on i386-gen.c by Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef TARGET_DEFS_ONLY
/* number of available registers */
// 26 "x86_64-gen.c"
#define NB_REGS 25
#define NB_ASM_REGS 16
#define CONFIG_TCC_ASM
/* a register can belong to several classes. The classes must be
   sorted from more general to more precise (see gv2() code which does
   assumptions on it). */
/* generic integer register */

#define RC_INT 0x0001
/* generic float register */
#define RC_FLOAT 0x0002
#define RC_RAX 0x0004
#define RC_RDX 0x0008
#define RC_RCX 0x0010
#define RC_RSI 0x0020
#define RC_RDI 0x0040
/* only for long double */
#define RC_ST0 0x0080
#define RC_R8 0x0100
#define RC_R9 0x0200
#define RC_R10 0x0400
#define RC_R11 0x0800
#define RC_XMM0 0x1000
#define RC_XMM1 0x2000
#define RC_XMM2 0x4000
#define RC_XMM3 0x8000
#define RC_XMM4 0x10000
#define RC_XMM5 0x20000
#define RC_XMM6 0x40000
#define RC_XMM7 0x80000
/* function return: integer register */
#define RC_IRET RC_RAX
/* function return: second integer register */
#define RC_IRE2 RC_RDX
/* function return: float register */
#define RC_FRET RC_XMM0
/* function return: second float register */
#define RC_FRE2 RC_XMM1
/* pretty names for the registers */

enum {
	TREG_RAX = 0,
	TREG_RCX = 1,
	TREG_RDX = 2,
	TREG_RSP = 4,
	TREG_RSI = 6,
	TREG_RDI = 7,

	TREG_R8 = 8,
	TREG_R9 = 9,
	TREG_R10 = 10,
	TREG_R11 = 11,

	TREG_XMM0 = 16,
	TREG_XMM1 = 17,
	TREG_XMM2 = 18,
	TREG_XMM3 = 19,
	TREG_XMM4 = 20,
	TREG_XMM5 = 21,
	TREG_XMM6 = 22,
	TREG_XMM7 = 23,

	TREG_ST0 = 24,

	TREG_MEM = 0x20
};

#define REX_BASE(reg) (((reg) >> 3) & 1)
#define REG_VALUE(reg) ((reg) & 7)
/* return registers for function */
/* single word int return register */

#define REG_IRET TREG_RAX
/* second word return register (for long long) */
#define REG_IRE2 TREG_RDX
/* float return register */
#define REG_FRET TREG_XMM0
/* second float return register */
#define REG_FRE2 TREG_XMM1
/* defined if function parameters must be evaluated in reverse order */

#define INVERT_FUNC_PARAMS
/* pointer size, in bytes */

#define PTR_SIZE 8
/* long double size and alignment, in bytes */

#define LDOUBLE_SIZE 16
#define LDOUBLE_ALIGN 16
/* maximum alignment (for aligned attribute support) */

#define MAX_ALIGN 16
/* define if return values need to be extended explicitely
   at caller side (for interfacing with non-TCC compilers) */

#define PROMOTE_RET

#define TCC_TARGET_NATIVE_STRUCT_COPY
ST_FUNC void gen_struct_copy(int size);
/**/
#else
/* ! TARGET_DEFS_ONLY */

/**/

#define USING_GLOBALS

// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 119 "x86_64-gen.c" 2
#include <assert.h>

ST_DATA const char *const target_machine_defs =
	"__x86_64__\0"
	"__amd64__\0"
	;

ST_DATA const int reg_classes[NB_REGS] = {
	/* eax */
	RC_INT | RC_RAX,
	/* ecx */
	RC_INT | RC_RCX,
	/* edx */
	RC_INT | RC_RDX,
	0,
	0,
	0,
	RC_RSI,
	RC_RDI,
	RC_R8,
	RC_R9,
	RC_R10,
	RC_R11,
	0,
	0,
	0,
	0,
	/* xmm0 */
	RC_FLOAT | RC_XMM0,
	/* xmm1 */
	RC_FLOAT | RC_XMM1,
	/* xmm2 */
	RC_FLOAT | RC_XMM2,
	/* xmm3 */
	RC_FLOAT | RC_XMM3,
	/* xmm4 */
	RC_FLOAT | RC_XMM4,
	/* xmm5 */
	RC_FLOAT | RC_XMM5,
	/* xmm6 an xmm7 are included so gv() can be used on them,
	       but they are not tagged with RC_FLOAT because they are
	       callee saved on Windows */

	RC_XMM6,
	RC_XMM7,
	/* st0 */
	RC_ST0
};

static unsigned long func_sub_sp_offset;
static int func_ret_sub;
#if defined(CONFIG_TCC_BCHECK)

static addr_t func_bound_offset;
static unsigned long func_bound_ind;
ST_DATA int func_bound_add_epilog;
#endif

static int func_scratch, func_alloca;
/* XXX: make it faster ? */

ST_FUNC void g(int c)
{
	int ind1;
	if (nocode_wanted)
		return;
	ind1 = ind + 1;
	if (ind1 > cur_text_section->data_allocated)
		section_realloc(cur_text_section, ind1);
	cur_text_section->data[ind] = c;
	ind = ind1;
}

ST_FUNC void o(unsigned int c)
{
	while (c) {
		g(c);
		c = c >> 8;
	}
}

ST_FUNC void gen_le16(int v)
{
	g(v);
	g(v >> 8);
}

ST_FUNC void gen_le32(int c)
{
	g(c);
	g(c >> 8);
	g(c >> 16);
	g(c >> 24);
}

ST_FUNC void gen_le64(int64_t c)
{
	g(c);
	g(c >> 8);
	g(c >> 16);
	g(c >> 24);
	g(c >> 32);
	g(c >> 40);
	g(c >> 48);
	g(c >> 56);
}

static void orex(int ll, int r, int r2, int b)
{
	if ((r & VT_VALMASK) >= VT_CONST)
		r = 0;
	if ((r2 & VT_VALMASK) >= VT_CONST)
		r2 = 0;
	if (ll || REX_BASE(r) || REX_BASE(r2))
		o(0x40 | REX_BASE(r) | (REX_BASE(r2) << 2) | (ll << 3));
	o(b);
}
/* output a symbol and patch all calls to it */

ST_FUNC void gsym_addr(int t, int a)
{
	while (t) {
		unsigned char *ptr = cur_text_section->data + t;
		uint32_t n = read32le(ptr);/* next value */

		write32le(ptr, a < 0 ? -a : a - t - 4);
		t = n;
	}
}

static int is64_type(int t)
{
	return ((t & VT_BTYPE) == VT_PTR ||
		(t & VT_BTYPE) == VT_FUNC ||
		(t & VT_BTYPE) == VT_LLONG);
}
/* instruction + 4 bytes data. Return the address of the data */

static int oad(int c, int s)
{
	int t;
	if (nocode_wanted)
		return s;
	o(c);
	t = ind;
	gen_le32(s);
	return t;
}
/* generate jmp to a label */

#define gjmp2(instr,lbl) oad(instr,lbl)

ST_FUNC void gen_addr32(int r, Sym *sym, int c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_32S, c), c=0;
	gen_le32(c);
}
/* output constant with relocation if 'r & VT_SYM' is true */

ST_FUNC void gen_addr64(int r, Sym *sym, int64_t c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_64, c), c=0;
	gen_le64(c);
}
/* output constant with relocation if 'r & VT_SYM' is true */

ST_FUNC void gen_addrpc32(int r, Sym *sym, int c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_PC32, c-4), c=4;
	gen_le32(c-4);
}
/* output got address with relocation */

static void gen_gotpcrel(int r, Sym *sym, int c)
{

	tcc_error("internal error: no GOT on PE: %s %x %x | %02x %02x %02x\n",
		  get_tok_str(sym->v, NULL), c, r,
		  cur_text_section->data[ind-3],
		  cur_text_section->data[ind-2],
		  cur_text_section->data[ind-1]
		 );

	greloca(cur_text_section, sym, ind, R_X86_64_GOTPCREL, -4);
	gen_le32(0);
	if (c) {
		/* we use add c, %xxx for displacement */

		orex(1, r, 0, 0x81);
		o(0xc0 + REG_VALUE(r));
		gen_le32(c);
	}
}

static void gen_modrm_impl(int op_reg, int r, Sym *sym, int c, int is_got)
{
	op_reg = REG_VALUE(op_reg) << 3;
	if ((r & VT_VALMASK) == VT_CONST) {
		/* constant memory reference */

		if (!(r & VT_SYM)) {
			/* Absolute memory reference */

			o(0x04 | op_reg);/* [sib] | destreg */

			oad(0x25, c);/* disp32 */

		} else {
			o(0x05 | op_reg);/* (%rip)+disp32 | destreg */

			if (is_got) {
				gen_gotpcrel(r, sym, c);
			} else {
				gen_addrpc32(r, sym, c);
			}
		}
	} else if ((r & VT_VALMASK) == VT_LOCAL) {
		/* currently, we use only ebp as base */

		if (c == (char)c) {
			/* short reference */

			o(0x45 | op_reg);
			g(c);
		} else {
			oad(0x85 | op_reg, c);
		}
	} else if ((r & VT_VALMASK) >= TREG_MEM) {
		if (c) {
			g(0x80 | op_reg | REG_VALUE(r));
			gen_le32(c);
		} else {
			g(0x00 | op_reg | REG_VALUE(r));
		}
	} else {
		g(0x00 | op_reg | REG_VALUE(r));
	}
}
/* generate a modrm reference. 'op_reg' contains the additional 3
   opcode bits */

static void gen_modrm(int op_reg, int r, Sym *sym, int c)
{
	gen_modrm_impl(op_reg, r, sym, c, 0);
}
/* generate a modrm reference. 'op_reg' contains the additional 3
   opcode bits */

static void gen_modrm64(int opcode, int op_reg, int r, Sym *sym, int c)
{
	int is_got;
	is_got = (op_reg & TREG_MEM) && !(sym->type.t & VT_STATIC);
	orex(1, r, op_reg, opcode);
	gen_modrm_impl(op_reg, r, sym, c, is_got);
}
/* load 'r' from value 'sv' */

void load(int r, SValue *sv)
{
	int v, t, ft, fc, fr;
	SValue v1;

	fr = sv->r;
	ft = sv->type.t & ~VT_DEFSIGN;
	fc = sv->c.i;
	if (fc != sv->c.i && (fr & VT_SYM))
		tcc_error("64 bit addend in load");

	ft &= ~(VT_VOLATILE | VT_CONSTANT);
// 392 "x86_64-gen.c"
	v = fr & VT_VALMASK;
	if (fr & VT_LVAL) {
		int b, ll;
		if (v == VT_LLOCAL) {
			v1.type.t = VT_PTR;
			v1.r = VT_LOCAL | VT_LVAL;
			v1.c.i = fc;
			fr = r;
			if (!(reg_classes[fr] & (RC_INT|RC_R11)))
				fr = get_reg(RC_INT);
			load(fr, &v1);
		}
		if (fc != sv->c.i) {
			/* If the addends doesn't fit into a 32bit signed
				       we must use a 64bit move.  We've checked above
				       that this doesn't have a sym associated.  */

			v1.type.t = VT_LLONG;
			v1.r = VT_CONST;
			v1.c.i = sv->c.i;
			fr = r;
			if (!(reg_classes[fr] & (RC_INT|RC_R11)))
				fr = get_reg(RC_INT);
			load(fr, &v1);
			fc = 0;
		}
		ll = 0;
		/* Like GCC we can load from small enough properly sized
			   structs and unions as well.
			   XXX maybe move to generic operand handling, but should
			   occur only with asm, so tccasm.c might also be a better place */

		if ((ft & VT_BTYPE) == VT_STRUCT) {
			int align;
			switch (type_size(&sv->type, &align)) {
			case 1:
				ft = VT_BYTE;
				break;
			case 2:
				ft = VT_SHORT;
				break;
			case 4:
				ft = VT_INT;
				break;
			case 8:
				ft = VT_LLONG;
				break;
			default:
				tcc_error("invalid aggregate type for register load");
				break;
			}
		}
		if ((ft & VT_BTYPE) == VT_FLOAT) {
			b = 0x6e0f66;
			r = REG_VALUE(r);/* movd */

		} else if ((ft & VT_BTYPE) == VT_DOUBLE) {
			b = 0x7e0ff3;/* movq */

			r = REG_VALUE(r);
		} else if ((ft & VT_BTYPE) == VT_LDOUBLE) {
			b = 0xdb, r = 5;/* fldt */

		} else if ((ft & VT_TYPE) == VT_BYTE || (ft & VT_TYPE) == VT_BOOL) {
			b = 0xbe0f;/* movsbl */

		} else if ((ft & VT_TYPE) == (VT_BYTE | VT_UNSIGNED)) {
			b = 0xb60f;/* movzbl */

		} else if ((ft & VT_TYPE) == VT_SHORT) {
			b = 0xbf0f;/* movswl */

		} else if ((ft & VT_TYPE) == (VT_SHORT | VT_UNSIGNED)) {
			b = 0xb70f;/* movzwl */

		} else if ((ft & VT_TYPE) == (VT_VOID)) {
			/* Can happen with zero size structs */

			return;
		} else {
			assert(((ft & VT_BTYPE) == VT_INT)
			       || ((ft & VT_BTYPE) == VT_LLONG)
			       || ((ft & VT_BTYPE) == VT_PTR)
			       || ((ft & VT_BTYPE) == VT_FUNC)
			      );
			ll = is64_type(ft);
			b = 0x8b;
		}
		if (ll) {
			gen_modrm64(b, r, fr, sv->sym, fc);
		} else {
			orex(ll, fr, r, b);
			gen_modrm(r, fr, sv->sym, fc);
		}
	} else {
		if (v == VT_CONST) {
			if (fr & VT_SYM) {

				orex(1,0,r,0x8d);
				o(0x05 + REG_VALUE(r) * 8);/* lea xx(%rip), r */

				gen_addrpc32(fr, sv->sym, fc);
// 486 "x86_64-gen.c"
			} else if (is64_type(ft)) {
				if (sv->c.i >> 32) {
					orex(1,r,0, 0xb8 + REG_VALUE(r));/* movabs $xx, r */

					gen_le64(sv->c.i);
				} else if (sv->c.i > 0) {
					orex(0,r,0, 0xb8 + REG_VALUE(r));/* mov $xx, r */

					gen_le32(sv->c.i);
				} else {
					o(0xc031 + REG_VALUE(r) * 0x900);/* xor r, r */

				}
			} else {
				orex(0,r,0, 0xb8 + REG_VALUE(r));/* mov $xx, r */

				gen_le32(fc);
			}
		} else if (v == VT_LOCAL) {
			orex(1,0,r,0x8d);/* lea xxx(%ebp), r */

			gen_modrm(r, VT_LOCAL, sv->sym, fc);
		} else if (v == VT_CMP) {
			if (fc & 0x100) {
				v = vtop->cmp_r;
				fc &= ~0x100;
				/* This was a float compare.  If the parity bit is
						   set the result was unordered, meaning false for everything
						   except TOK_NE, and true for TOK_NE.  */

				orex(0, r, 0, 0xb0 + REG_VALUE(r));/* mov $0/1,%al */

				g(v ^ fc ^ (v == TOK_NE));
				o(0x037a + (REX_BASE(r) << 8));
			}
			orex(0,r,0, 0x0f);/* setxx %br */

			o(fc);
			o(0xc0 + REG_VALUE(r));
			orex(0,r,0, 0x0f);
			o(0xc0b6 + REG_VALUE(r) * 0x900);/* movzbl %al, %eax */

		} else if (v == VT_JMP || v == VT_JMPI) {
			t = v & 1;
			orex(0,r,0,0);
			oad(0xb8 + REG_VALUE(r), t);/* mov $1, r */

			o(0x05eb + (REX_BASE(r) << 8));/* jmp after */

			gsym(fc);
			orex(0,r,0,0);
			oad(0xb8 + REG_VALUE(r), t ^ 1);/* mov $0, r */

		} else if (v != r) {
			if ((r >= TREG_XMM0) && (r <= TREG_XMM7)) {
				if (v == TREG_ST0) {
					/* gen_cvt_ftof(VT_DOUBLE); */

					o(0xf0245cdd);/* fstpl -0x10(%rsp) */

					/* movsd -0x10(%rsp),%xmmN */

					o(0x100ff2);
					o(0x44 + REG_VALUE(r)*8);/* %xmmN */

					o(0xf024);
				} else {
					assert((v >= TREG_XMM0) && (v <= TREG_XMM7));
					if ((ft & VT_BTYPE) == VT_FLOAT) {
						o(0x100ff3);
					} else {
						assert((ft & VT_BTYPE) == VT_DOUBLE);
						o(0x100ff2);
					}
					o(0xc0 + REG_VALUE(v) + REG_VALUE(r)*8);
				}
			} else if (r == TREG_ST0) {
				assert((v >= TREG_XMM0) && (v <= TREG_XMM7));
				/* gen_cvt_ftof(VT_LDOUBLE); */
				/* movsd %xmmN,-0x10(%rsp) */

				o(0x110ff2);
				o(0x44 + REG_VALUE(r)*8);/* %xmmN */

				o(0xf024);
				o(0xf02444dd);/* fldl -0x10(%rsp) */

			} else {
				orex(is64_type(ft), r, v, 0x89);
				o(0xc0 + REG_VALUE(r) + REG_VALUE(v) * 8);/* mov v, r */

			}
		}
	}
}
/* store register 'r' in lvalue 'v' */

void store(int r, SValue *v)
{
	int fr, bt, ft, fc;
	int op64 = 0;
	/* store the REX prefix in this variable when PIC is enabled */

	int pic = 0;

	fr = v->r & VT_VALMASK;
	ft = v->type.t;
	fc = v->c.i;
	if (fc != v->c.i && (fr & VT_SYM))
		tcc_error("64 bit addend in store");
	ft &= ~(VT_VOLATILE | VT_CONSTANT);
	bt = ft & VT_BTYPE;
	/* XXX: incorrect if float reg to reg */
// 592 "x86_64-gen.c"
	if (bt == VT_FLOAT) {
		o(0x66);
		o(pic);
		o(0x7e0f);/* movd */

		r = REG_VALUE(r);
	} else if (bt == VT_DOUBLE) {
		o(0x66);
		o(pic);
		o(0xd60f);/* movq */

		r = REG_VALUE(r);
	} else if (bt == VT_LDOUBLE) {
		o(0xc0d9);/* fld %st(0) */

		o(pic);
		o(0xdb);/* fstpt */

		r = 7;
	} else {
		if (bt == VT_SHORT)
			o(0x66);
		o(pic);
		if (bt == VT_BYTE || bt == VT_BOOL)
			orex(0, 0, r, 0x88);
		else if (is64_type(bt))
			op64 = 0x89;
		else
			orex(0, 0, r, 0x89);
	}
	if (pic) {
		/* xxx r, (%r11) where xxx is mov, movq, fld, or etc */

		if (op64)
			o(op64);
		o(3 + (r << 3));
	} else if (op64) {
		if (fr == VT_CONST || fr == VT_LOCAL || (v->r & VT_LVAL)) {
			gen_modrm64(op64, r, v->r, v->sym, fc);
		} else if (fr != r) {
			orex(1, fr, r, op64);
			o(0xc0 + fr + r * 8);/* mov r, fr */

		}
	} else {
		if (fr == VT_CONST || fr == VT_LOCAL || (v->r & VT_LVAL)) {
			gen_modrm(r, v->r, v->sym, fc);
		} else if (fr != r) {
			o(0xc0 + fr + r * 8);/* mov r, fr */

		}
	}
}
/* 'is_jmp' is '1' if it is a jump */

static void gcall_or_jmp(int is_jmp)
{
	int r;
	if ((vtop->r & (VT_VALMASK | VT_LVAL)) == VT_CONST &&
	    ((vtop->r & VT_SYM) && (vtop->c.i-4) == (int)(vtop->c.i-4))) {
		/* constant symbolic case -> simple relocation */

		greloca(cur_text_section, vtop->sym, ind + 1, R_X86_64_PLT32,
			(int)(vtop->c.i-4));
		oad(0xe8 + is_jmp, 0);/* call/jmp im */

	} else {
		/* otherwise, indirect call */

		r = TREG_R11;
		load(r, vtop);
		o(0x41);/* REX */

		o(0xff);/* call/jmp *r */

		o(0xd0 + REG_VALUE(r) + (is_jmp << 4));
	}
}
#if defined(CONFIG_TCC_BCHECK)

static void gen_bounds_call(int v)
{
	Sym *sym = external_helper_sym(v);
	oad(0xe8, 0);
	greloca(cur_text_section, sym, ind-4, R_X86_64_PLT32, -4);
}

#define TREG_FASTCALL_1 TREG_RCX

static void gen_bounds_prolog(void)
{
	/* leave some room for bound checking code */

	func_bound_offset = lbounds_section->data_offset;
	func_bound_ind = ind;
	func_bound_add_epilog = 0;
	o(0x0d8d48 + ((TREG_FASTCALL_1 == TREG_RDI) *
		      0x300000));/*lbound section pointer */

	gen_le32 (0);
	oad(0xb8, 0);/* call to function */

}

static void gen_bounds_epilog(void)
{
	addr_t saved_ind;
	addr_t *bounds_ptr;
	Sym *sym_data;
	int offset_modified = func_bound_offset != lbounds_section->data_offset;

	if (!offset_modified && !func_bound_add_epilog)
		return;
	/* add end of table info */

	bounds_ptr = section_ptr_add(lbounds_section, sizeof(addr_t));
	*bounds_ptr = 0;

	sym_data = get_sym_ref(&char_pointer_type, lbounds_section,
			       func_bound_offset, PTR_SIZE);
	/* generate bound local allocation */

	if (offset_modified) {
		saved_ind = ind;
		ind = func_bound_ind;
		greloca(cur_text_section, sym_data, ind + 3, R_X86_64_PC32, -4);
		ind = ind + 7;
		gen_bounds_call(TOK___bound_local_new);
		ind = saved_ind;
	}
	/* generate bound check local freeing */

	o(0x5250);/* save returned value, if any */

	o(0x20ec8348);/* sub $32,%rsp */

	o(0x290f);/* movaps %xmm0,0x10(%rsp) */

	o(0x102444);
	o(0x240c290f);/* movaps %xmm1,(%rsp) */

	greloca(cur_text_section, sym_data, ind + 3, R_X86_64_PC32, -4);
	o(0x0d8d48 + ((TREG_FASTCALL_1 == TREG_RDI) *
		      0x300000));/* lea xxx(%rip), %rcx/rdi */

	gen_le32 (0);
	gen_bounds_call(TOK___bound_local_delete);
	o(0x280f);/* movaps 0x10(%rsp),%xmm0 */

	o(0x102444);
	o(0x240c280f);/* movaps (%rsp),%xmm1 */

	o(0x20c48348);/* add $32,%rsp */

	o(0x585a);/* restore returned value, if any */

}
#endif

#define REGN 4
static const uint8_t arg_regs[REGN] = {
	TREG_RCX, TREG_RDX, TREG_R8, TREG_R9
};
/* Prepare arguments in R10 and R11 rather than RCX and RDX
   because gv() will not ever use these */

static int arg_prepare_reg(int idx)
{
	if (idx == 0 || idx == 1)
		/* idx=0: r10, idx=1: r11 */

		return idx + 10;
	else
		return idx >= 0 && idx < REGN ? arg_regs[idx] : 0;
}
/* Generate function call. The function address is pushed first, then
   all the parameters in call order. This functions pops all the
   parameters and the function address. */

static void gen_offs_sp(int b, int r, int d)
{
	orex(1,0,r & 0x100 ? 0 : r, b);
	if (d == (char)d) {
		o(0x2444 | (REG_VALUE(r) << 3));
		g(d);
	} else {
		o(0x2484 | (REG_VALUE(r) << 3));
		gen_le32(d);
	}
}

static int using_regs(int size)
{
	return !(size > 8 || (size & (size - 1)));
}
/* Return the number of registers needed to return the struct, or 0 if
   returning via struct pointer. */

ST_FUNC int gfunc_sret(CType *vt, int variadic, CType *ret, int *ret_align,
		       int *regsize)
{
	int size, align;
	*ret_align = 1;// Never have to re-align return values for x86-64

	*regsize = 8;
	size = type_size(vt, &align);
	if (!using_regs(size))
		return 0;
	if (size == 8)
		ret->t = VT_LLONG;
	else if (size == 4)
		ret->t = VT_INT;
	else if (size == 2)
		ret->t = VT_SHORT;
	else
		ret->t = VT_BYTE;
	ret->ref = NULL;
	return 1;
}

static int is_sse_float(int t)
{
	int bt;
	bt = t & VT_BTYPE;
	return bt == VT_DOUBLE || bt == VT_FLOAT;
}

static int gfunc_arg_size(CType *type)
{
	int align;
	if (type->t & (VT_ARRAY|VT_BITFIELD))
		return 8;
	return type_size(type, &align);
}

void gfunc_call(int nb_args)
{
	int size, r, args_size, i, d, bt, struct_size;
	int arg;
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gbound_args(nb_args);
#endif

	args_size = (nb_args < REGN ? REGN : nb_args) * PTR_SIZE;
	arg = nb_args;
	/* for struct arguments, we need to call memcpy and the function
	       call breaks register passing arguments we are preparing.
	       So, we process arguments which will be passed by stack first. */

	struct_size = args_size;
	for (i = 0; i < nb_args; i++) {
		SValue *sv;

		--arg;
		sv = &vtop[-i];
		bt = (sv->type.t & VT_BTYPE);
		size = gfunc_arg_size(&sv->type);

		if (using_regs(size))
			continue;/* arguments smaller than 8 bytes passed in registers or on stack */

		if (bt == VT_STRUCT) {
			/* align to stack align size */

			size = (size + 15) & ~15;
			/* generate structure store */

			r = get_reg(RC_INT);
			gen_offs_sp(0x8d, r, struct_size);
			struct_size += size;
			/* generate memcpy call */

			vset(&sv->type, r | VT_LVAL, 0);
			vpushv(sv);
			vstore();
			--vtop;
		} else if (bt == VT_LDOUBLE) {
			gv(RC_ST0);
			gen_offs_sp(0xdb, 0x107, struct_size);
			struct_size += 16;
		}
	}

	if (func_scratch < struct_size)
		func_scratch = struct_size;

	arg = nb_args;
	struct_size = args_size;

	for (i = 0; i < nb_args; i++) {
		--arg;
		bt = (vtop->type.t & VT_BTYPE);

		size = gfunc_arg_size(&vtop->type);
		if (!using_regs(size)) {
			/* align to stack align size */

			size = (size + 15) & ~15;
			if (arg >= REGN) {
				d = get_reg(RC_INT);
				gen_offs_sp(0x8d, d, struct_size);
				gen_offs_sp(0x89, d, arg*8);
			} else {
				d = arg_prepare_reg(arg);
				gen_offs_sp(0x8d, d, struct_size);
			}
			struct_size += size;
		} else {
			if (is_sse_float(vtop->type.t)) {
				if (tcc_state->nosse)
					tcc_error("SSE disabled");
				if (arg >= REGN) {
					gv(RC_XMM0);
					/* movq %xmm0, j*8(%rsp) */

					gen_offs_sp(0xd60f66, 0x100, arg*8);
				} else {
					/* Load directly to xmmN register */

					gv(RC_XMM0 << arg);
					d = arg_prepare_reg(arg);
					/* mov %xmmN, %rxx */

					o(0x66);
					orex(1,d,0, 0x7e0f);
					o(0xc0 + arg*8 + REG_VALUE(d));
				}
			} else {
				if (bt == VT_STRUCT) {
					vtop->type.ref = NULL;
					vtop->type.t = size > 4 ? VT_LLONG : size > 2 ? VT_INT
						       : size > 1 ? VT_SHORT : VT_BYTE;
				}

				r = gv(RC_INT);
				if (arg >= REGN) {
					gen_offs_sp(0x89, r, arg*8);
				} else {
					d = arg_prepare_reg(arg);
					orex(1,d,r,0x89);/* mov */

					o(0xc0 + REG_VALUE(r) * 8 + REG_VALUE(d));
				}
			}
		}
		vtop--;
	}
	save_regs(0);
	/* Copy R10 and R11 into RCX and RDX, respectively */

	if (nb_args > 0) {
		o(0xd1894c);/* mov %r10, %rcx */

		if (nb_args > 1) {
			o(0xda894c);/* mov %r11, %rdx */

		}
	}

	gcall_or_jmp(0);

	if ((vtop->r & VT_SYM) && vtop->sym->v == TOK_alloca) {
		/* need to add the "func_scratch" area after alloca */

		o(0x48);
		func_alloca = oad(0x05, func_alloca);/* add $NN, %rax */

#ifdef CONFIG_TCC_BCHECK

		if (tcc_state->do_bounds_check)
			gen_bounds_call(TOK___bound_alloca_nr);/* new region */

#endif

	}
	vtop--;
}

#define FUNC_PROLOG_SIZE 11
/* generate function prolog of type 't' */

void gfunc_prolog(Sym *func_sym)
{
	CType *func_type = &func_sym->type;
	int addr, reg_param_index, bt, size;
	Sym *sym;
	CType *type;

	func_ret_sub = 0;
	func_scratch = 32;
	func_alloca = 0;
	loc = 0;

	addr = PTR_SIZE * 2;
	ind += FUNC_PROLOG_SIZE;
	func_sub_sp_offset = ind;
	reg_param_index = 0;

	sym = func_type->ref;
	/* if the function returns a structure, then add an
	       implicit pointer parameter */

	size = gfunc_arg_size(&func_vt);
	if (!using_regs(size)) {
		gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
		func_vc = addr;
		reg_param_index++;
		addr += 8;
	}
	/* define parameters */

	while ((sym = sym->next) != NULL) {
		type = &sym->type;
		bt = type->t & VT_BTYPE;
		size = gfunc_arg_size(type);
		if (!using_regs(size)) {
			if (reg_param_index < REGN) {
				gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
			}
			sym_push(sym->v & ~SYM_FIELD, type,
				 VT_LLOCAL | VT_LVAL, addr);
		} else {
			if (reg_param_index < REGN) {
				/* save arguments passed by register */

				if ((bt == VT_FLOAT) || (bt == VT_DOUBLE)) {
					if (tcc_state->nosse)
						tcc_error("SSE disabled");
					o(0xd60f66);/* movq */

					gen_modrm(reg_param_index, VT_LOCAL, NULL, addr);
				} else {
					gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
				}
			}
			sym_push(sym->v & ~SYM_FIELD, type,
				 VT_LOCAL | VT_LVAL, addr);
		}
		addr += 8;
		reg_param_index++;
	}

	while (reg_param_index < REGN) {
		if (func_var) {
			gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
			addr += 8;
		}
		reg_param_index++;
	}
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gen_bounds_prolog();
#endif

}
/* generate function epilog */

void gfunc_epilog(void)
{
	int v, start;
	/* align local size to word & save local variables */

	func_scratch = (func_scratch + 15) & -16;
	loc = (loc & -16) - func_scratch;
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gen_bounds_epilog();
#endif

	o(0xc9);/* leave */

	if (func_ret_sub == 0) {
		o(0xc3);/* ret */

	} else {
		o(0xc2);/* ret n */

		g(func_ret_sub);
		g(func_ret_sub >> 8);
	}

	v = -loc;
	start = func_sub_sp_offset - FUNC_PROLOG_SIZE;
	cur_text_section->data_offset = ind;
	pe_add_unwind_data(start, ind, v);

	ind = start;
	if (v >= 4096) {
		Sym *sym = external_helper_sym(TOK___chkstk);
		oad(0xb8, v);/* mov stacksize, %eax */

		oad(0xe8, 0);/* call __chkstk, (does the stackframe too) */

		greloca(cur_text_section, sym, ind-4, R_X86_64_PLT32, -4);
		o(0x90);/* fill for FUNC_PROLOG_SIZE = 11 bytes */

	} else {
		o(0xe5894855);/* push %rbp, mov %rsp, %rbp */

		o(0xec8148);/* sub rsp, stacksize */

		gen_le32(v);
	}
	ind = cur_text_section->data_offset;
	/* add the "func_scratch" area after each alloca seen */

	gsym_addr(func_alloca, -func_scratch);
}
/* not PE */
// 1631 "x86_64-gen.c"
ST_FUNC void gen_fill_nops(int bytes)
{
	while (bytes--)
		g(0x90);
}
/* generate a jump to a label */

int gjmp(int t)
{
	return gjmp2(0xe9, t);
}
/* generate a jump to a fixed address */

void gjmp_addr(int a)
{
	int r;
	r = a - ind - 2;
	if (r == (char)r) {
		g(0xeb);
		g(r);
	} else {
		oad(0xe9, a - ind - 5);
	}
}

ST_FUNC int gjmp_append(int n, int t)
{
	void *p;
	/* insert vtop->c jump list in t */

	if (n) {
		uint32_t n1 = n, n2;
		while ((n2 = read32le(p = cur_text_section->data + n1)))
			n1 = n2;
		write32le(p, t);
		t = n;
	}
	return t;
}

ST_FUNC int gjmp_cond(int op, int t)
{
	if (op & 0x100) {
		/* This was a float compare.  If the parity flag is set
			       the result was unordered.  For anything except != this
			       means false and we don't jump (anding both conditions).
			       For != this means true (oring both).
			       Take care about inverting the test.  We need to jump
			       to our target if the result was unordered and test wasn't NE,
			       otherwise if unordered we don't want to jump.  */

		int v = vtop->cmp_r;
		op &= ~0x100;
		if (op ^ v ^ (v != TOK_NE))
			o(0x067a);/* jp +6 */

		else {
			g(0x0f);
			t = gjmp2(0x8a, t);/* jp t */

		}
	}
	g(0x0f);
	t = gjmp2(op - 16, t);
	return t;
}
/* generate an integer binary operation */

void gen_opi(int op)
{
	int r, fr, opc, c;
	int ll, uu, cc;

	ll = is64_type(vtop[-1].type.t);
	uu = (vtop[-1].type.t & VT_UNSIGNED) != 0;
	cc = (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;

	switch (op) {
	case '+':
	case TOK_ADDC1:/* add with carry generation */

		opc = 0;
gen_op8:
		if (cc && (!ll || (int)vtop->c.i == vtop->c.i)) {
			/* constant case */

			vswap();
			r = gv(RC_INT);
			vswap();
			c = vtop->c.i;
			if (c == (char)c) {
				/* XXX: generate inc and dec for smaller code ? */

				orex(ll, r, 0, 0x83);
				o(0xc0 | (opc << 3) | REG_VALUE(r));
				g(c);
			} else {
				orex(ll, r, 0, 0x81);
				oad(0xc0 | (opc << 3) | REG_VALUE(r), c);
			}
		} else {
			gv2(RC_INT, RC_INT);
			r = vtop[-1].r;
			fr = vtop[0].r;
			orex(ll, r, fr, (opc << 3) | 0x01);
			o(0xc0 + REG_VALUE(r) + REG_VALUE(fr) * 8);
		}
		vtop--;
		if (op >= TOK_ULT && op <= TOK_GT)
			vset_VT_CMP(op);
		break;
	case '-':
	case TOK_SUBC1:/* sub with carry generation */

		opc = 5;
		goto gen_op8;
	case TOK_ADDC2:/* add with carry use */

		opc = 2;
		goto gen_op8;
	case TOK_SUBC2:/* sub with carry use */

		opc = 3;
		goto gen_op8;
	case '&':
		opc = 4;
		goto gen_op8;
	case '^':
		opc = 6;
		goto gen_op8;
	case '|':
		opc = 1;
		goto gen_op8;
	case '*':
		gv2(RC_INT, RC_INT);
		r = vtop[-1].r;
		fr = vtop[0].r;
		orex(ll, fr, r, 0xaf0f);/* imul fr, r */

		o(0xc0 + REG_VALUE(fr) + REG_VALUE(r) * 8);
		vtop--;
		break;
	case TOK_SHL:
		opc = 4;
		goto gen_shift;
	case TOK_SHR:
		opc = 5;
		goto gen_shift;
	case TOK_SAR:
		opc = 7;
gen_shift:
		opc = 0xc0 | (opc << 3);
		if (cc) {
			/* constant case */

			vswap();
			r = gv(RC_INT);
			vswap();
			orex(ll, r, 0, 0xc1);/* shl/shr/sar $xxx, r */

			o(opc | REG_VALUE(r));
			g(vtop->c.i & (ll ? 63 : 31));
		} else {
			/* we generate the shift in ecx */

			gv2(RC_INT, RC_RCX);
			r = vtop[-1].r;
			orex(ll, r, 0, 0xd3);/* shl/shr/sar %cl, r */

			o(opc | REG_VALUE(r));
		}
		vtop--;
		break;
	case TOK_UDIV:
	case TOK_UMOD:
		uu = 1;
		goto divmod;
	case '/':
	case '%':
	case TOK_PDIV:
		uu = 0;
divmod:
		/* first operand must be in eax */
		/* XXX: need better constraint for second operand */

		gv2(RC_RAX, RC_RCX);
		r = vtop[-1].r;
		fr = vtop[0].r;
		vtop--;
		save_reg(TREG_RDX);
		orex(ll, 0, 0, uu ? 0xd231 : 0x99);/* xor %edx,%edx : cqto */

		orex(ll, fr, 0, 0xf7);/* div fr, %eax */

		o((uu ? 0xf0 : 0xf8) + REG_VALUE(fr));
		if (op == '%' || op == TOK_UMOD)
			r = TREG_RDX;
		else
			r = TREG_RAX;
		vtop->r = r;
		break;
	default:
		opc = 7;
		goto gen_op8;
	}
}

void gen_opl(int op)
{
	gen_opi(op);
}
/* generate a floating point operation 'v = t1 op t2' instruction. The
   two operands are guaranteed to have the same floating point type */
/* XXX: need to use ST1 too */

void gen_opf(int op)
{
	int a, ft, fc, swapped, r;
	int bt = vtop->type.t & VT_BTYPE;
	int float_type = bt == VT_LDOUBLE ? RC_ST0 : RC_FLOAT;

	if (op == TOK_NEG) {/* unary minus */

		gv(float_type);
		if (float_type == RC_ST0) {
			o(0xe0d9);/* fchs */

		} else {
			save_reg(vtop->r);
			o(0x80);/* xor $0x80, $n(rbp) */

			gen_modrm(6, vtop->r, NULL, vtop->c.i + (bt == VT_DOUBLE ? 7 : 3));
			o(0x80);
		}
		return;
	}
	/* convert constants to memory references */

	if ((vtop[-1].r & (VT_VALMASK | VT_LVAL)) == VT_CONST) {
		vswap();
		gv(float_type);
		vswap();
	}
	if ((vtop[0].r & (VT_VALMASK | VT_LVAL)) == VT_CONST)
		gv(float_type);
	/* must put at least one value in the floating point register */

	if ((vtop[-1].r & VT_LVAL) &&
	    (vtop[0].r & VT_LVAL)) {
		vswap();
		gv(float_type);
		vswap();
	}
	swapped = 0;
	/* swap the stack if needed so that t1 is the register and t2 is
	       the memory reference */

	if (vtop[-1].r & VT_LVAL) {
		vswap();
		swapped = 1;
	}
	if ((vtop->type.t & VT_BTYPE) == VT_LDOUBLE) {
		if (op >= TOK_ULT && op <= TOK_GT) {
			/* load on stack second operand */

			load(TREG_ST0, vtop);
			save_reg(TREG_RAX);/* eax is used by FP comparison code */

			if (op == TOK_GE || op == TOK_GT)
				swapped = !swapped;
			else if (op == TOK_EQ || op == TOK_NE)
				swapped = 0;
			if (swapped)
				o(0xc9d9);/* fxch %st(1) */

			if (op == TOK_EQ || op == TOK_NE)
				o(0xe9da);/* fucompp */

			else
				o(0xd9de);/* fcompp */

			o(0xe0df);/* fnstsw %ax */

			if (op == TOK_EQ) {
				o(0x45e480);/* and $0x45, %ah */

				o(0x40fC80);/* cmp $0x40, %ah */

			} else if (op == TOK_NE) {
				o(0x45e480);/* and $0x45, %ah */

				o(0x40f480);/* xor $0x40, %ah */

				op = TOK_NE;
			} else if (op == TOK_GE || op == TOK_LE) {
				o(0x05c4f6);/* test $0x05, %ah */

				op = TOK_EQ;
			} else {
				o(0x45c4f6);/* test $0x45, %ah */

				op = TOK_EQ;
			}
			vtop--;
			vset_VT_CMP(op);
		} else {
			/* no memory reference possible for long double operations */

			load(TREG_ST0, vtop);
			swapped = !swapped;

			switch (op) {
			default:
			case '+':
				a = 0;
				break;
			case '-':
				a = 4;
				if (swapped)
					a++;
				break;
			case '*':
				a = 1;
				break;
			case '/':
				a = 6;
				if (swapped)
					a++;
				break;
			}
			ft = vtop->type.t;
			fc = vtop->c.i;
			o(0xde);/* fxxxp %st, %st(1) */

			o(0xc1 + (a << 3));
			vtop--;
		}
	} else {
		if (op >= TOK_ULT && op <= TOK_GT) {
			/* if saved lvalue, then we must reload it */

			r = vtop->r;
			fc = vtop->c.i;
			if ((r & VT_VALMASK) == VT_LLOCAL) {
				SValue v1;
				r = get_reg(RC_INT);
				v1.type.t = VT_PTR;
				v1.r = VT_LOCAL | VT_LVAL;
				v1.c.i = fc;
				load(r, &v1);
				fc = 0;
				vtop->r = r = r | VT_LVAL;
			}

			if (op == TOK_EQ || op == TOK_NE) {
				swapped = 0;
			} else {
				if (op == TOK_LE || op == TOK_LT)
					swapped = !swapped;
				if (op == TOK_LE || op == TOK_GE) {
					op = 0x93;/* setae */

				} else {
					op = 0x97;/* seta */

				}
			}

			if (swapped) {
				gv(RC_FLOAT);
				vswap();
			}
			assert(!(vtop[-1].r & VT_LVAL));

			if ((vtop->type.t & VT_BTYPE) == VT_DOUBLE)
				o(0x66);
			if (op == TOK_EQ || op == TOK_NE)
				o(0x2e0f);/* ucomisd */

			else
				o(0x2f0f);/* comisd */

			if (vtop->r & VT_LVAL) {
				gen_modrm(vtop[-1].r, r, vtop->sym, fc);
			} else {
				o(0xc0 + REG_VALUE(vtop[0].r) + REG_VALUE(vtop[-1].r)*8);
			}

			vtop--;
			vset_VT_CMP(op | 0x100);
			vtop->cmp_r = op;
		} else {
			assert((vtop->type.t & VT_BTYPE) != VT_LDOUBLE);
			switch (op) {
			default:
			case '+':
				a = 0;
				break;
			case '-':
				a = 4;
				break;
			case '*':
				a = 1;
				break;
			case '/':
				a = 6;
				break;
			}
			ft = vtop->type.t;
			fc = vtop->c.i;
			assert((ft & VT_BTYPE) != VT_LDOUBLE);

			r = vtop->r;
			/* if saved lvalue, then we must reload it */

			if ((vtop->r & VT_VALMASK) == VT_LLOCAL) {
				SValue v1;
				r = get_reg(RC_INT);
				v1.type.t = VT_PTR;
				v1.r = VT_LOCAL | VT_LVAL;
				v1.c.i = fc;
				load(r, &v1);
				fc = 0;
				vtop->r = r = r | VT_LVAL;
			}

			assert(!(vtop[-1].r & VT_LVAL));
			if (swapped) {
				assert(vtop->r & VT_LVAL);
				gv(RC_FLOAT);
				vswap();
				fc = vtop->c.i;/* bcheck may have saved previous vtop[-1] */

			}

			if ((ft & VT_BTYPE) == VT_DOUBLE) {
				o(0xf2);
			} else {
				o(0xf3);
			}
			o(0x0f);
			o(0x58 + a);

			if (vtop->r & VT_LVAL) {
				gen_modrm(vtop[-1].r, r, vtop->sym, fc);
			} else {
				o(0xc0 + REG_VALUE(vtop[0].r) + REG_VALUE(vtop[-1].r)*8);
			}

			vtop--;
		}
	}
}
/* convert integers to fp 't' type. Must handle 'int', 'unsigned int'
   and 'long long' cases. */

void gen_cvt_itof(int t)
{
	if ((t & VT_BTYPE) == VT_LDOUBLE) {
		save_reg(TREG_ST0);
		gv(RC_INT);
		if ((vtop->type.t & VT_BTYPE) == VT_LLONG) {
			/* signed long long to float/double/long double (unsigned case
			               is handled generically) */

			o(0x50 + (vtop->r & VT_VALMASK));/* push r */

			o(0x242cdf);/* fildll (%rsp) */

			o(0x08c48348);/* add $8, %rsp */

		} else if ((vtop->type.t & (VT_BTYPE | VT_UNSIGNED)) ==
			   (VT_INT | VT_UNSIGNED)) {
			/* unsigned int to float/double/long double */

			o(0x6a);/* push $0 */

			g(0x00);
			o(0x50 + (vtop->r & VT_VALMASK));/* push r */

			o(0x242cdf);/* fildll (%rsp) */

			o(0x10c48348);/* add $16, %rsp */

		} else {
			/* int to float/double/long double */

			o(0x50 + (vtop->r & VT_VALMASK));/* push r */

			o(0x2404db);/* fildl (%rsp) */

			o(0x08c48348);/* add $8, %rsp */

		}
		vtop->r = TREG_ST0;
	} else {
		int r = get_reg(RC_FLOAT);
		gv(RC_INT);
		o(0xf2 + ((t & VT_BTYPE) == VT_FLOAT?1:0));
		if ((vtop->type.t & (VT_BTYPE | VT_UNSIGNED)) ==
		    (VT_INT | VT_UNSIGNED) ||
		    (vtop->type.t & VT_BTYPE) == VT_LLONG) {
			o(0x48);/* REX */

		}
		o(0x2a0f);
		o(0xc0 + (vtop->r & VT_VALMASK) + REG_VALUE(r)*8);/* cvtsi2sd */

		vtop->r = r;
	}
}
/* convert from one floating point type to another */

void gen_cvt_ftof(int t)
{
	int ft, bt, tbt;

	ft = vtop->type.t;
	bt = ft & VT_BTYPE;
	tbt = t & VT_BTYPE;

	if (bt == VT_FLOAT) {
		gv(RC_FLOAT);
		if (tbt == VT_DOUBLE) {
			o(0x140f);/* unpcklps */

			o(0xc0 + REG_VALUE(vtop->r)*9);
			o(0x5a0f);/* cvtps2pd */

			o(0xc0 + REG_VALUE(vtop->r)*9);
		} else if (tbt == VT_LDOUBLE) {
			save_reg(RC_ST0);
			/* movss %xmm0,-0x10(%rsp) */

			o(0x110ff3);
			o(0x44 + REG_VALUE(vtop->r)*8);
			o(0xf024);
			o(0xf02444d9);/* flds -0x10(%rsp) */

			vtop->r = TREG_ST0;
		}
	} else if (bt == VT_DOUBLE) {
		gv(RC_FLOAT);
		if (tbt == VT_FLOAT) {
			o(0x140f66);/* unpcklpd */

			o(0xc0 + REG_VALUE(vtop->r)*9);
			o(0x5a0f66);/* cvtpd2ps */

			o(0xc0 + REG_VALUE(vtop->r)*9);
		} else if (tbt == VT_LDOUBLE) {
			save_reg(RC_ST0);
			/* movsd %xmm0,-0x10(%rsp) */

			o(0x110ff2);
			o(0x44 + REG_VALUE(vtop->r)*8);
			o(0xf024);
			o(0xf02444dd);/* fldl -0x10(%rsp) */

			vtop->r = TREG_ST0;
		}
	} else {
		int r;
		gv(RC_ST0);
		r = get_reg(RC_FLOAT);
		if (tbt == VT_DOUBLE) {
			o(0xf0245cdd);/* fstpl -0x10(%rsp) */

			/* movsd -0x10(%rsp),%xmm0 */

			o(0x100ff2);
			o(0x44 + REG_VALUE(r)*8);
			o(0xf024);
			vtop->r = r;
		} else if (tbt == VT_FLOAT) {
			o(0xf0245cd9);/* fstps -0x10(%rsp) */

			/* movss -0x10(%rsp),%xmm0 */

			o(0x100ff3);
			o(0x44 + REG_VALUE(r)*8);
			o(0xf024);
			vtop->r = r;
		}
	}
}
/* convert fp to int 't' type */

void gen_cvt_ftoi(int t)
{
	int ft, bt, size, r;
	ft = vtop->type.t;
	bt = ft & VT_BTYPE;
	if (bt == VT_LDOUBLE) {
		gen_cvt_ftof(VT_DOUBLE);
		bt = VT_DOUBLE;
	}

	gv(RC_FLOAT);
	if (t != VT_INT)
		size = 8;
	else
		size = 4;

	r = get_reg(RC_INT);
	if (bt == VT_FLOAT) {
		o(0xf3);
	} else if (bt == VT_DOUBLE) {
		o(0xf2);
	} else {
		assert(0);
	}
	orex(size == 8, r, 0, 0x2c0f);/* cvttss2si or cvttsd2si */

	o(0xc0 + REG_VALUE(vtop->r) + REG_VALUE(r)*8);
	vtop->r = r;
}
// Generate sign extension from 32 to 64 bits:

ST_FUNC void gen_cvt_sxtw(void)
{
	int r = gv(RC_INT);
	/* x86_64 specific: movslq */

	o(0x6348);
	o(0xc0 + (REG_VALUE(r) << 3) + REG_VALUE(r));
}
/* char/short to int conversion */

ST_FUNC void gen_cvt_csti(int t)
{
	int r, sz, xl, ll;
	r = gv(RC_INT);
	sz = !(t & VT_UNSIGNED);
	xl = (t & VT_BTYPE) == VT_SHORT;
	ll = (vtop->type.t & VT_BTYPE) == VT_LLONG;
	orex(ll, r, 0, 0xc0b60f/* mov[sz] %a[xl], %eax */

	     | (sz << 3 | xl) << 8
	     | (REG_VALUE(r) << 3 | REG_VALUE(r)) << 16
	    );
}
/* increment tcov counter */

ST_FUNC void gen_increment_tcov (SValue *sv)
{
	o(0x058348);/* addq $1, xxx(%rip) */

	greloca(cur_text_section, sv->sym, ind, R_X86_64_PC32, -5);
	gen_le32(0);
	o(1);
}
/* computed goto support */

ST_FUNC void ggoto(void)
{
	gcall_or_jmp(1);
	vtop--;
}
/* Save the stack pointer onto the stack and return the location of its address */

ST_FUNC void gen_vla_sp_save(int addr)
{
	/* mov %rsp,addr(%rbp)*/

	gen_modrm64(0x89, TREG_RSP, VT_LOCAL, NULL, addr);
}
/* Restore the SP from a location on the stack */

ST_FUNC void gen_vla_sp_restore(int addr)
{
	gen_modrm64(0x8b, TREG_RSP, VT_LOCAL, NULL, addr);
}
/* Save result of gen_vla_alloc onto the stack */

ST_FUNC void gen_vla_result(int addr)
{
	/* mov %rax,addr(%rbp)*/

	gen_modrm64(0x89, TREG_RAX, VT_LOCAL, NULL, addr);
}
/* Subtract from the stack pointer, and push the resulting value onto the stack */

ST_FUNC void gen_vla_alloc(CType *type, int align)
{
	int use_call = 0;
#if defined(CONFIG_TCC_BCHECK)

	use_call = tcc_state->do_bounds_check;
#endif
	/* alloca does more than just adjust %rsp on Windows */

	use_call = 1;

	if (use_call) {
		vpush_helper_func(TOK_alloca);
		vswap();/* Move alloca ref past allocation size */

		gfunc_call(1);
	} else {
		int r;
		r = gv(RC_INT);/* allocation size */

		/* sub r,%rsp */

		o(0x2b48);
		o(0xe0 | REG_VALUE(r));
		/* We align to 16 bytes rather than align */
		/* and ~15, %rsp */

		o(0xf0e48348);
		vpop();
	}
}
/*
 * Assmuing the top part of the stack looks like below,
 *  src dest src
 */

ST_FUNC void gen_struct_copy(int size)
{
	int n = size / PTR_SIZE;

	o(0x5756);/* push rsi, rdi */

	gv2(RC_RDI, RC_RSI);
	if (n <= 4) {
		while (n)
			o(0xa548), --n;
	} else {
		vpushi(n);
		gv(RC_RCX);
		o(0xa548f3);
		vpop();
	}
	if (size & 0x04)
		o(0xa5);
	if (size & 0x02)
		o(0xa566);
	if (size & 0x01)
		o(0xa4);

	o(0x5e5f);/* pop rdi, rsi */

	vpop();
	vpop();
}
/* end of x86-64 code generator */
/**/
#endif
/* ! TARGET_DEFS_ONLY */
/**/
// 376 "tcc.h" 2
// 1 "x86_64-link.c" 1
#ifdef TARGET_DEFS_ONLY

#define EM_TCC_TARGET EM_X86_64
/* relocation type for 32 bit data relocation */

#define R_DATA_32 R_X86_64_32S
#define R_DATA_PTR R_X86_64_64
#define R_JMP_SLOT R_X86_64_JUMP_SLOT
#define R_GLOB_DAT R_X86_64_GLOB_DAT
#define R_COPY R_X86_64_COPY
#define R_RELATIVE R_X86_64_RELATIVE

#define R_NUM R_X86_64_NUM

#define ELF_START_ADDR 0x400000
#define ELF_PAGE_SIZE 0x200000

#define PCRELATIVE_DLLPLT 1
#define RELOCATE_DLLPLT 1
#else
/* !TARGET_DEFS_ONLY */

// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 24 "x86_64-link.c" 2
#ifdef NEED_RELOC_TYPE

/* Returns 1 for a code relocation, 0 for a data relocation. For unknown
   relocations, returns -1. */

ST_FUNC int code_reloc (int reloc_type)
{
	switch (reloc_type) {
	case R_X86_64_32:
	case R_X86_64_32S:
	case R_X86_64_64:
	case R_X86_64_GOTPC32:
	case R_X86_64_GOTPC64:
	case R_X86_64_GOTPCREL:
	case R_X86_64_GOTPCRELX:
	case R_X86_64_REX_GOTPCRELX:
	case R_X86_64_GOTTPOFF:
	case R_X86_64_GOT32:
	case R_X86_64_GOT64:
	case R_X86_64_GLOB_DAT:
	case R_X86_64_COPY:
	case R_X86_64_RELATIVE:
	case R_X86_64_GOTOFF64:
	case R_X86_64_TLSGD:
	case R_X86_64_TLSLD:
	case R_X86_64_DTPOFF32:
	case R_X86_64_TPOFF32:
	case R_X86_64_DTPOFF64:
	case R_X86_64_TPOFF64:
		return 0;

	case R_X86_64_PC32:
	case R_X86_64_PC64:
	case R_X86_64_PLT32:
	case R_X86_64_PLTOFF64:
	case R_X86_64_JUMP_SLOT:
		return 1;
	}
	return -1;
}

/* Returns an enumerator to describe whether and when the relocation needs a
   GOT and/or PLT entry to be created. See tcc.h for a description of the
   different values. */

ST_FUNC int gotplt_entry_type (int reloc_type)
{
	switch (reloc_type) {
	case R_X86_64_GLOB_DAT:
	case R_X86_64_JUMP_SLOT:
	case R_X86_64_COPY:
	case R_X86_64_RELATIVE:
		return NO_GOTPLT_ENTRY;

	/* The following relocs wouldn't normally need GOT or PLT
	   slots, but we need them for simplicity in the link
	   editor part.  See our caller for comments.  */

	case R_X86_64_32:
	case R_X86_64_32S:
	case R_X86_64_64:
	case R_X86_64_PC32:
	case R_X86_64_PC64:
		return AUTO_GOTPLT_ENTRY;

	case R_X86_64_GOTTPOFF:
		return BUILD_GOT_ONLY;

	case R_X86_64_GOT32:
	case R_X86_64_GOT64:
	case R_X86_64_GOTPC32:
	case R_X86_64_GOTPC64:
	case R_X86_64_GOTOFF64:
	case R_X86_64_GOTPCREL:
	case R_X86_64_GOTPCRELX:
	case R_X86_64_TLSGD:
	case R_X86_64_TLSLD:
	case R_X86_64_DTPOFF32:
	case R_X86_64_TPOFF32:
	case R_X86_64_DTPOFF64:
	case R_X86_64_TPOFF64:
	case R_X86_64_REX_GOTPCRELX:
	case R_X86_64_PLT32:
	case R_X86_64_PLTOFF64:
		return ALWAYS_GOTPLT_ENTRY;
	}

	return -1;
}

#ifdef NEED_BUILD_GOT
ST_FUNC unsigned create_plt_entry(TCCState *s1, unsigned got_offset,
				  struct sym_attr *attr)
{
	Section *plt = s1->plt;
	uint8_t *p;
	int modrm;
	unsigned plt_offset, relofs;

	modrm = 0x25;

	/* empty PLT: create PLT0 entry that pushes the library identifier
	   (GOT + PTR_SIZE) and jumps to ld.so resolution routine
	   (GOT + 2 * PTR_SIZE) */

	if (plt->data_offset == 0) {
		p = section_ptr_add(plt, 16);
		p[0] = 0xff; /* pushl got + PTR_SIZE */

		p[1] = modrm + 0x10;
		write32le(p + 2, PTR_SIZE);
		p[6] = 0xff; /* jmp *(got + PTR_SIZE * 2) */

		p[7] = modrm;
		write32le(p + 8, PTR_SIZE * 2);
	}
	plt_offset = plt->data_offset;

	/* The PLT slot refers to the relocation entry it needs via offset.
	   The reloc entry is created below, so its offset is the current
	   data_offset */

	relofs = s1->plt->reloc ? s1->plt->reloc->data_offset : 0;

	/* Jump to GOT entry where ld.so initially put the address of ip + 4 */

	p = section_ptr_add(plt, 16);
	p[0] = 0xff; /* jmp *(got + x) */

	p[1] = modrm;
	write32le(p + 2, got_offset);
	p[6] = 0x68; /* push $xxx */

	/* On x86-64, the relocation is referred to by _index_ */

	write32le(p + 7, relofs sizeof (ElfW_Rel) - 1);
	p[11] = 0xe9; /* jmp plt_start */

	write32le(p + 12, -(plt->data_offset));
	return plt_offset;
}

/* relocate the PLT: compute addresses and offsets in the PLT now that final
   address for PLT and GOT are known (see fill_program_header) */

ST_FUNC void relocate_plt(TCCState *s1)
{
	uint8_t *p, *p_end;

	if (!s1->plt)
		return;

	p = s1->plt->data;
	p_end = p + s1->plt->data_offset;

	if (p < p_end) {
		int x = s1->got->sh_addr - s1->plt->sh_addr - 6;
		add32le(p + 2, x);
		add32le(p + 8, x - 6);
		p += 16;
		while (p < p_end) {
			add32le(p + 2, x + (s1->plt->data - p));
			p += 16;
		}
	}

	if (s1->plt->reloc) {
		ElfW_Rel *rel;
		int x = s1->plt->sh_addr + 16 + 6;
		p = s1->got->data;
		for_each_elem(s1->plt->reloc, 0, rel, ElfW_Rel) {
			write64le(p + rel->r_offset, x);
			x += 16;
		}
	}
}
#endif
#endif
// 189 "x86_64-link.c"
ST_FUNC void relocate(TCCState *s1, ElfW_Rel *rel, int type, unsigned char *ptr,
		      addr_t addr, addr_t val)
{
	int sym_index, esym_index;

	sym_index = ELFW(R_SYM)(rel->r_info);

	switch (type) {
	case R_X86_64_64:
		if (s1->output_type & TCC_OUTPUT_DYN) {
			esym_index = get_sym_attr(s1, sym_index, 0)->dyn_index;
			qrel->r_offset = rel->r_offset;
			if (esym_index) {
				qrel->r_info = ELFW(R_INFO)(esym_index, R_X86_64_64);
				qrel->r_addend = rel->r_addend;
				qrel++;
				break;
			} else {
				qrel->r_info = ELFW(R_INFO)(0, R_X86_64_RELATIVE);
				qrel->r_addend = read64le(ptr) + val;
				qrel++;
			}
		}
		add64le(ptr, val);
		break;
	case R_X86_64_32:
	case R_X86_64_32S:
		if (s1->output_type & TCC_OUTPUT_DYN) {
			/* XXX: this logic may depend on TCC's codegen
			                   now TCC uses R_X86_64_32 even for a 64bit pointer */

			qrel->r_offset = rel->r_offset;
			qrel->r_info = ELFW(R_INFO)(0, R_X86_64_RELATIVE);
			/* Use sign extension! */

			qrel->r_addend = (int)read32le(ptr) + val;
			qrel++;
		}
		add32le(ptr, val);
		break;

	case R_X86_64_PC32:
		if (s1->output_type == TCC_OUTPUT_DLL) {
			/* DLL relocation */

			esym_index = get_sym_attr(s1, sym_index, 0)->dyn_index;
			if (esym_index) {
				qrel->r_offset = rel->r_offset;
				qrel->r_info = ELFW(R_INFO)(esym_index, R_X86_64_PC32);
				/* Use sign extension! */

				qrel->r_addend = (int)read32le(ptr) + rel->r_addend;
				qrel++;
				break;
			}
		}
		goto plt32pc32;

	case R_X86_64_PLT32:
		/* fallthrough: val already holds the PLT slot address */

plt32pc32: {
			long long diff;
			diff = (long long)val - addr;
			if (diff < -2147483648LL || diff > 2147483647LL) {
				/* ignore overflow with undefined weak symbols */

				if (((ElfW(Sym)*)symtab_section->data)[sym_index].st_shndx != SHN_UNDEF)

					tcc_error_noabort("internal error: relocation failed");
			}
			add32le(ptr, diff);
		}
		break;

	case R_X86_64_COPY:
		break;

	case R_X86_64_PLTOFF64:
		add64le(ptr, val - s1->got->sh_addr + rel->r_addend);
		break;

	case R_X86_64_PC64:
		if (s1->output_type == TCC_OUTPUT_DLL) {
			/* DLL relocation */

			esym_index = get_sym_attr(s1, sym_index, 0)->dyn_index;
			if (esym_index) {
				qrel->r_offset = rel->r_offset;
				qrel->r_info = ELFW(R_INFO)(esym_index, R_X86_64_PC64);
				qrel->r_addend = read64le(ptr) + rel->r_addend;
				qrel++;
				break;
			}
		}
		add64le(ptr, val - addr);
		break;

	case R_X86_64_GLOB_DAT:
	case R_X86_64_JUMP_SLOT:
		/* They don't need addend */

		write64le(ptr, val - rel->r_addend);
		break;
	case R_X86_64_GOTPCREL:
	case R_X86_64_GOTPCRELX:
	case R_X86_64_REX_GOTPCRELX:
		add32le(ptr, s1->got->sh_addr - addr +
			get_sym_attr(s1, sym_index, 0)->got_offset - 4);
		break;
	case R_X86_64_GOTPC32:
		add32le(ptr, s1->got->sh_addr - addr + rel->r_addend);
		break;
	case R_X86_64_GOTPC64:
		add64le(ptr, s1->got->sh_addr - addr + rel->r_addend);
		break;
	case R_X86_64_GOTTPOFF:
		add32le(ptr, val - s1->got->sh_addr);
		break;
	case R_X86_64_GOT32:
		/* we load the got offset */

		add32le(ptr, get_sym_attr(s1, sym_index, 0)->got_offset);
		break;
	case R_X86_64_GOT64:
		/* we load the got offset */

		add64le(ptr, get_sym_attr(s1, sym_index, 0)->got_offset);
		break;
	case R_X86_64_GOTOFF64:
		add64le(ptr, val - s1->got->sh_addr);
		break;
	case R_X86_64_TLSGD: {
		static const unsigned char expect[] = {
			/* .byte 0x66; lea 0(%rip),%rdi */

			0x66, 0x48, 0x8d, 0x3d, 0x00, 0x00, 0x00, 0x00,
			/* .word 0x6666; rex64; call __tls_get_addr@PLT */

			0x66, 0x66, 0x48, 0xe8, 0x00, 0x00, 0x00, 0x00
		};
		static const unsigned char replace[] = {
			/* mov %fs:0,%rax */

			0x64, 0x48, 0x8b, 0x04, 0x25, 0x00, 0x00, 0x00, 0x00,
			/* lea -4(%rax),%rax */

			0x48, 0x8d, 0x80, 0x00, 0x00, 0x00, 0x00
		};

		if (memcmp (ptr-4, expect, sizeof(expect)) == 0) {
			ElfW(Sym) *sym;
			Section *sec;
			int32_t x;

			memcpy(ptr-4, replace, sizeof(replace));
			rel[1].r_info = ELFW(R_INFO)(0, R_X86_64_NONE);
			sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];
			sec = s1->sections[sym->st_shndx];
			x = sym->st_value - sec->sh_addr - sec->data_offset;
			add32le(ptr + 8, x);
		} else
			tcc_error_noabort("unexpected R_X86_64_TLSGD pattern");
	}
	break;
	case R_X86_64_TLSLD: {
		static const unsigned char expect[] = {
			/* lea 0(%rip),%rdi */

			0x48, 0x8d, 0x3d, 0x00, 0x00, 0x00, 0x00,
			/* call __tls_get_addr@PLT */

			0xe8, 0x00, 0x00, 0x00, 0x00
		};
		static const unsigned char replace[] = {
			/* data16 data16 data16 mov %fs:0,%rax */

			0x66, 0x66, 0x66, 0x64, 0x48, 0x8b, 0x04, 0x25,
			0x00, 0x00, 0x00, 0x00
		};

		if (memcmp (ptr-3, expect, sizeof(expect)) == 0) {
			memcpy(ptr-3, replace, sizeof(replace));
			rel[1].r_info = ELFW(R_INFO)(0, R_X86_64_NONE);
		} else
			tcc_error_noabort("unexpected R_X86_64_TLSLD pattern");
	}
	break;
	case R_X86_64_DTPOFF32:
	case R_X86_64_TPOFF32: {
		ElfW(Sym) *sym;
		Section *sec;
		int32_t x;

		sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];
		sec = s1->sections[sym->st_shndx];
		x = val - sec->sh_addr - sec->data_offset;
		add32le(ptr, x);
	}
	break;
	case R_X86_64_DTPOFF64:
	case R_X86_64_TPOFF64: {
		ElfW(Sym) *sym;
		Section *sec;
		int32_t x;

		sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];
		sec = s1->sections[sym->st_shndx];
		x = val - sec->sh_addr - sec->data_offset;
		add64le(ptr, x);
	}
	break;
	case R_X86_64_NONE:
		break;
	case R_X86_64_RELATIVE:

		add32le(ptr, val - s1->pe_imagebase);
		/* do nothing */

		break;
	default:
		fprintf(stderr,"FIXME: handle reloc type %d at %x [%p] to %x\n",
			type, (unsigned)addr, ptr, (unsigned)val);
		break;
	}
}
#endif
/* !TARGET_DEFS_ONLY */
// 377 "tcc.h" 2

#undef TARGET_DEFS_ONLY
/* -------------------------------------------- */
#if PTR_SIZE == 8

#define ELFCLASSW ELFCLASS64
#define ElfW(type) Elf ## 64 ## _ ## type
#define ELFW(type) ELF ## 64 ## _ ## type
#define ElfW_Rel ElfW(Rela)
#define SHT_RELX SHT_RELA
#define REL_SECTION_FMT ".rela%s"
#else

#define ELFCLASSW ELFCLASS32
#define ElfW(type) Elf##32##_##type
#define ELFW(type) ELF##32##_##type
#define ElfW_Rel ElfW(Rel)
#define SHT_RELX SHT_REL
#define REL_SECTION_FMT ".rel%s"
#endif
/* target address type */
// 417 "tcc.h"
#define addr_t ElfW(Addr)
#define ElfSym ElfW(Sym)

#define LONG_SIZE 4
/* -------------------------------------------- */

#define INCLUDE_STACK_SIZE 32
#define IFDEF_STACK_SIZE 64
#define VSTACK_SIZE 512
#define STRING_MAX_SIZE 1024
#define TOKSTR_MAX_SIZE 256
#define PACK_STACK_SIZE 8
/* must be a power of two */

#define TOK_HASH_SIZE 16384
/* must be a power of two */
#define TOK_ALLOC_INCR 512
/* token max size in int unit when stored in string */
#define TOK_MAX_SIZE 4
/* token symbol management */

typedef struct TokenSym {
	struct TokenSym *hash_next;
	struct Sym *sym_define;/* direct pointer to define */

	struct Sym *sym_label;/* direct pointer to label */

	struct Sym *sym_struct;/* direct pointer to structure */

	struct Sym *sym_identifier;/* direct pointer to identifier */

	int tok;/* token number */

	int len;
	char str[1];
} TokenSym;

typedef unsigned short nwchar_t;

typedef struct CString {
	int size;/* size in bytes */

	int size_allocated;
	char *data;/* nwchar_t* in cases */

} CString;
/* type definition */

typedef struct CType {
	int t;
	struct Sym *ref;
} CType;
/* constant value */

typedef union CValue {
	long double ld;
	double d;
	float f;
	uint64_t i;
	struct {
		char *data;
		int size;
	} str;
	int tab[LDOUBLE_SIZE/4];
} CValue;
/* value on stack */

typedef struct SValue {
	CType type;/* type */

	unsigned short r;/* register + flags */

	unsigned short r2;/* second register, used for 'long long'
                              type. If not used, set to VT_CONST */

	union {
		struct {
			int jtrue, jfalse;
		};/* forward jmps */

		CValue c;/* constant, if VT_CONST */

	};
	union {
		struct {
			unsigned short cmp_op, cmp_r;
		};/* VT_CMP operation */

		struct Sym *sym;/* symbol, if (VT_SYM | VT_CONST), or if */

	};/* result of unary() for an identifier. */

} SValue;
/* symbol attributes */

struct SymAttr {
	unsigned short
	aligned : 5,/* alignment as log2+1 (0 == unspecified) */

		    packed : 1,
		    weak : 1,
		    visibility : 2,
		    dllexport : 1,
		    nodecorate : 1,
		    dllimport : 1,
		    addrtaken : 1,
		    nodebug : 1,
		    xxxx : 2;/* not used */

};
/* function attributes or temporary attributes for parsing */

struct FuncAttr {
	unsigned
	func_call : 3,/* calling convention (0..5), see below */

		    func_type : 2,/* FUNC_OLD/NEW/ELLIPSIS */

		    func_noreturn : 1,/* attribute((noreturn)) */

		    func_ctor : 1,/* attribute((constructor)) */

		    func_dtor : 1,/* attribute((destructor)) */

		    func_args : 8,/* PE __stdcall args */

		    func_alwinl : 1,/* always_inline */

		    xxxx : 15;
};
/* symbol management */

typedef struct Sym {
	int v;/* symbol token */

	unsigned short r;/* associated register or VT_CONST/VT_LOCAL and LVAL type */

	struct SymAttr a;/* symbol attributes */

	union {
		struct {
			int c;/* associated number or Elf symbol index */

			union {
				int sym_scope;/* scope level for locals */

				int jnext;/* next jump label */

				int jind;/* label position */

				struct FuncAttr f;/* function attributes */

				int auxtype;/* bitfield access type */

			};
		};
		long long enum_val;/* enum constant if IS_ENUM_VAL */

		int *d;/* define token stream */

		struct Sym *cleanup_func;
	};

	CType type;/* associated type */

	union {
		struct Sym *next;/* next related symbol (for fields and anoms) */

		int *e;/* expanded token stream */

		int asm_label;/* associated asm label */

		struct Sym *cleanupstate;/* in defined labels */

		int *vla_array_str;/* vla array code */

	};
	struct Sym *prev;/* prev symbol in stack */

	struct Sym *prev_tok;/* previous symbol for this token */

} Sym;
/* section definition */

typedef struct Section {
	unsigned long data_offset;/* current data offset */

	unsigned char *data;/* section data */

	unsigned long data_allocated;/* used for realloc() handling */

	TCCState *s1;
	int sh_name;/* elf section name (only used during output) */

	int sh_num;/* elf section number */

	int sh_type;/* elf section type */

	int sh_flags;/* elf section flags */

	int sh_info;/* elf section info */

	int sh_addralign;/* elf section alignment */

	int sh_entsize;/* elf entry size */

	unsigned long sh_size;/* section size (only used during output) */

	addr_t sh_addr;/* address at which the section is relocated */

	unsigned long sh_offset;/* file offset */

	int nb_hashed_syms;/* used to resize the hash table */

	struct Section *link;/* link to another section */

	struct Section *reloc;/* corresponding section for relocation, if any */

	struct Section *hash;/* hash table for symbols */

	struct Section *prev;/* previous section on section stack */

	char name[1];/* section name */

} Section;

typedef struct DLLReference {
	int level;
	void *handle;
	unsigned char found, index;
	char name[1];
} DLLReference;
/* -------------------------------------------------- */
/* struct/union/enum symbol space */

#define SYM_STRUCT 0x40000000
/* struct/union field symbol space */
#define SYM_FIELD 0x20000000
/* first anonymous sym */
#define SYM_FIRST_ANOM 0x10000000
/* stored in 'Sym->f.func_type' field */
/* ansi function prototype */

#define FUNC_NEW 1
/* old function prototype */
#define FUNC_OLD 2
/* ansi function prototype with ... */
#define FUNC_ELLIPSIS 3
/* stored in 'Sym->f.func_call' field */
/* standard c call */

#define FUNC_CDECL 0
/* pascal c call */
#define FUNC_STDCALL 1
/* first param in %eax */
#define FUNC_FASTCALL1 2
/* first parameters in %eax, %edx */
#define FUNC_FASTCALL2 3
/* first parameter in %eax, %edx, %ecx */
#define FUNC_FASTCALL3 4
/* first parameter in %ecx, %edx */
#define FUNC_FASTCALLW 5
/* first param in %ecx */
#define FUNC_THISCALL 6
/* field 'Sym.t' for macros */
/* object like macro */

#define MACRO_OBJ 0
/* function like macro */
#define MACRO_FUNC 1
/* macro uses ## */
#define MACRO_JOIN 2
/* field 'Sym.r' for C labels */
/* label is defined */

#define LABEL_DEFINED 0
/* label is forward defined */
#define LABEL_FORWARD 1
/* label is declared but never used */
#define LABEL_DECLARED 2
/* label isn't in scope, but not yet popped
                            from local_label_stack (stmt exprs) */

#define LABEL_GONE 3
/* type_decl() types */
/* type without variable */

#define TYPE_ABSTRACT 1
/* type with variable */
#define TYPE_DIRECT 2
/* type declares function parameter */
#define TYPE_PARAM 4
/* nested call to post_type */
#define TYPE_NEST 8

#define IO_BUF_SIZE 8192

typedef struct BufferedFile {
	uint8_t *buf_ptr;
	uint8_t *buf_end;
	int fd;
	struct BufferedFile *prev;
	int line_num;/* current line number - here to simplify code */

	int line_ref;/* tcc -E: last printed line */

	int ifndef_macro;/* #ifndef macro / #endif search */

	int ifndef_macro_saved;/* saved ifndef_macro */

	int *ifdef_stack_ptr;/* ifdef_stack value at the start of the file */

	int include_next_index;/* next search path */

	int prev_tok_flags;/* saved tok_flags */

	char filename[1024];/* filename */

	char *true_filename;/* filename not modified by # line directive */

	unsigned char unget[4];
	unsigned char buffer[1];/* extra size for CH_EOB char */

} BufferedFile;
/* end of buffer or '\0' char in file */

#define CH_EOB '\\'
/* end of file */
#define CH_EOF (-1)
/* used to record tokens */

typedef struct TokenString {
	int *str;
	int len;
	int need_spc;
	int allocated_len;
	int last_line_num;
	int save_line_num;
	/* used to chain token-strings with begin/end_macro() */

	struct TokenString *prev;
	const int *prev_ptr;
	char alloc;
} TokenString;
/* GNUC attribute definition */

typedef struct AttributeDef {
	struct SymAttr a;
	struct FuncAttr f;
	struct Section *section;
	Sym *cleanup_func;
	int alias_target;/* token */

	int asm_label;/* associated asm label */

	char attr_mode;/* __attribute__((__mode__(...))) */

} AttributeDef;
/* inline functions */

typedef struct InlineFunc {
	TokenString *func_str;
	Sym *sym;
	char filename[1];
} InlineFunc;
/* include file cache, used to find files faster and also to eliminate
   inclusion if the include file is protected by #ifndef ... #endif */

typedef struct CachedInclude {
	int ifndef_macro;
	int once;
	int hash_next;/* -1 if none */

	char filename[1];/* path specified in #include */

} CachedInclude;

#define CACHED_INCLUDES_HASH_SIZE 32
#ifdef CONFIG_TCC_ASM

typedef struct ExprValue {
	uint64_t v;
	Sym *sym;
	int pcrel;
} ExprValue;

#define MAX_ASM_OPERANDS 30
typedef struct ASMOperand {
	int id;/* GCC 3 optional identifier (0 if number only supported) */

	char constraint[16];
	char asm_str[16];/* computed asm string for operand */

	SValue *vt;/* C value of the expression */

	int ref_index;/* if >= 0, gives reference to a output constraint */

	int input_index;/* if >= 0, gives reference to an input constraint */

	int priority;/* priority, used to assign registers */

	int reg;/* if >= 0, register number used for this operand */

	int is_llong;/* true if double register value */

	int is_memory;/* true if memory operand */

	int is_rw;/* for '+' modifier */

	int is_label;/* for asm goto */

} ASMOperand;
#endif
/* extra symbol attributes (not in symbol table) */

struct sym_attr {
	unsigned got_offset;
	unsigned plt_offset;
	int plt_sym;
	int dyn_index;

};

struct TCCState {
	unsigned char verbose;/* if true, display some information during compilation */

	unsigned char nostdinc;/* if true, no standard headers are added */

	unsigned char nostdlib;/* if true, no standard libraries are added */

	unsigned char
	nostdlib_paths;/* if true, the default paths are not searched for libraries */

	unsigned char nocommon;/* if true, do not use common symbols for .bss data */

	unsigned char static_link;/* if true, static linking is performed */

	unsigned char rdynamic;/* if true, all symbols are exported */

	unsigned char
	symbolic;/* if true, resolve symbols in the current module first */

	unsigned char filetype;/* file type for compilation (NONE,C,ASM) */

	unsigned char optimize;/* only to #define __OPTIMIZE__ */

	unsigned char option_pthread;/* -pthread option */

	unsigned char enable_new_dtags;/* -Wl,--enable-new-dtags */

	unsigned int
	cversion;/* supported C ISO version, 199901 (the default), 201112, ... */

	/* C language options */

	unsigned char char_is_unsigned;
	unsigned char leading_underscore;
	unsigned char
	ms_extensions;/* allow nested named struct w/o identifier behave like unnamed */

	unsigned char dollars_in_identifiers;/* allows '$' char in identifiers */

	unsigned char
	ms_bitfields;/* if true, emulate MS algorithm for aligning bitfields */

	unsigned char reverse_funcargs;/* if true, evaluate last function arg first */

	unsigned char gnu89_inline;/* treat 'extern inline' like 'static inline' */

	unsigned char unwind_tables;/* create eh_frame section */

	/* warning switches */

	unsigned char warn_none;
	unsigned char warn_all;
	unsigned char warn_error;
	unsigned char warn_write_strings;
	unsigned char warn_unsupported;
	unsigned char warn_implicit_function_declaration;
	unsigned char warn_discarded_qualifiers;
	/* warning is on (-Woption) */
#define WARN_ON 1
	unsigned char warn_num;/* temp var for tcc_warning_c() */

	unsigned char option_r;/* option -r */

	unsigned char do_bench;/* option -bench */

	unsigned char just_deps;/* option -M  */

	unsigned char gen_deps;/* option -MD  */

	unsigned char include_sys_deps;/* option -MD  */

	unsigned char gen_phony_deps;/* option -MP */

	/* compile with debug symbol (and use them if error during execution) */

	unsigned char do_debug;
	unsigned char dwarf;
	unsigned char do_backtrace;
#ifdef CONFIG_TCC_BCHECK

	/* compile with built-in memory and bounds checker */

	unsigned char do_bounds_check;
#endif

	unsigned char test_coverage;/* generate test coverage code */

	/* use GNU C extensions */

	unsigned char gnu_ext;
	/* use TinyCC extensions */

	unsigned char tcc_ext;

	unsigned char dflag;/* -dX value */

	unsigned char Pflag;/* -P switch (LINE_MACRO_OUTPUT_FORM\AT) */

	unsigned char nosse;/* For -mno-sse support. */

	unsigned char has_text_addr;
	addr_t text_addr;/* address of text section */

	unsigned section_align;/* section alignment */

	char *tcc_lib_path;/* CONFIG_TCCDIR or -B option */

	char *soname;/* as specified on the command line (-soname) */

	char *rpath;/* as specified on the command line (-Wl,-rpath=) */

	char *elfint;/* -Wl,-I... on command line */

	char *elf_entryname;/* "_start" unless set */

	char *init_symbol;/* symbols to call at load-time (not used currently) */

	char *fini_symbol;/* symbols to call at unload-time (not used currently) */

	char *mapfile;/* create a mapfile (not used currently) */

	/* output type, see TCC_OUTPUT_XXX */

	int output_type;
	/* output format, see TCC_OUTPUT_FORMAT_xxx */

	int output_format;
	/* nth test to run with -dt -run */

	int run_test;
	/* array of all loaded dlls (including those referenced by loaded dlls) */

	DLLReference **loaded_dlls;
	int nb_loaded_dlls;
	/* include paths */

	char **include_paths;
	int nb_include_paths;

	char **sysinclude_paths;
	int nb_sysinclude_paths;
	/* library paths */

	char **library_paths;
	int nb_library_paths;
	/* crt?.o object path */

	char **crt_paths;
	int nb_crt_paths;
	/* -D / -U options */

	CString cmdline_defs;
	/* -include options */

	CString cmdline_incl;
	/* error handling */

	void *error_opaque;
	void (*error_func)(void *opaque, const char *msg);
	int error_set_jmp_enabled;
	jmp_buf error_jmp_buf;
	int nb_errors;
	/* output file for preprocessing (-E) */

	FILE *ppfp;
	/* for -MD/-MF: collected dependencies for this compilation */

	char **target_deps;
	int nb_target_deps;
	/* compilation */

	BufferedFile *include_stack[INCLUDE_STACK_SIZE];
	BufferedFile **include_stack_ptr;

	int ifdef_stack[IFDEF_STACK_SIZE];
	int *ifdef_stack_ptr;
	/* included files enclosed with #ifndef MACRO */

	int cached_includes_hash[CACHED_INCLUDES_HASH_SIZE];
	CachedInclude **cached_includes;
	int nb_cached_includes;
	/* #pragma pack stack */

	int pack_stack[PACK_STACK_SIZE];
	int *pack_stack_ptr;
	char **pragma_libs;
	int nb_pragma_libs;
	/* inline functions are stored as token lists and compiled last
	       only if referenced */

	struct InlineFunc **inline_fns;
	int nb_inline_fns;
	/* sections */

	Section **sections;
	int nb_sections;/* number of sections, including first dummy section */

	Section **priv_sections;
	int nb_priv_sections;/* number of private sections */

	/* predefined sections */

	Section *text_section, *data_section, *rodata_section, *bss_section;
	Section *common_section;
	Section *cur_text_section;/* current section where function code is generated */

#ifdef CONFIG_TCC_BCHECK

	/* bound check related sections */

	Section *bounds_section; /* contains global data bound description */

	Section *lbounds_section; /* contains local data bound description */

#endif
	/* symbol section */

	union {
		Section *symtab_section, *symtab;
	};/* historical alias */

	/* temporary dynamic symbol sections (for dll loading) */

	Section *dynsymtab_section;
	/* exported dynamic symbol section */

	Section *dynsym;
	/* got & plt handling */

	Section *got, *plt;
	/* exception handling */

	Section *eh_frame_section;
	Section *eh_frame_hdr_section;
	unsigned long eh_start;
	/* debug sections */

	Section *stab_section;
	Section *dwarf_info_section;
	Section *dwarf_abbrev_section;
	Section *dwarf_line_section;
	Section *dwarf_aranges_section;
	Section *dwarf_str_section;
	Section *dwarf_line_str_section;
	int dwlo, dwhi;/* dwarf section range */

	/* test coverage */

	Section *tcov_section;
	/* debug state */

	struct _tccdbg *dState;
	/* extra attributes (eg. GOT/PLT value) for symtab symbols */

	struct sym_attr *sym_attrs;
	int nb_sym_attrs;
	/* ptr to next reloc entry reused */

	ElfW_Rel *qrel;
#define qrel s1->qrel
	/* PE info */
// 938 "tcc.h"
	int pe_subsystem;
	unsigned pe_characteristics;
	unsigned pe_file_align;
	unsigned pe_stack_size;
	addr_t pe_imagebase;

	Section *uw_pdata;
	int uw_sym;
	unsigned uw_offs;
#ifndef ELF_OBJ_ONLY

	int nb_sym_versions;
	struct sym_version *sym_versions;
	int nb_sym_to_version;
	int *sym_to_version;
	int dt_verneednum;
	Section *versym_section;
	Section *verneed_section;
#endif
// 967 "tcc.h"
	const char *run_main;/* entry for tcc_run() */

	void *run_ptr;/* runtime_memory */

	unsigned run_size;/* size of runtime_memory  */

	void *run_function_table;/* unwind data */

	struct TCCState *next;
	struct rt_context *rc;/* pointer to backtrace info block */

	void *run_lj, *run_jb;/* sj/lj for tcc_setjmp()/tcc_run() */

	TCCBtFunc *bt_func;
	void *bt_data;
#ifdef CONFIG_TCC_BACKTRACE

	int rt_num_callers;
#endif
	/* benchmark info */

	int total_idents;
	int total_lines;
	unsigned int total_bytes;
	unsigned int total_output[4];
	/* used by tcc_load_ldscript */

	unsigned char *ld_p;/* text pointer */

	/* for warnings/errors for object files */

	const char *current_filename;
	/* used by main and tcc_parse_args only */

	struct filespec **files;/* files seen on command line */

	int nb_files;/* number thereof */

	int nb_libraries;/* number of libs thereof */

	char *outfile;/* output filename */

	char *deps_outfile;/* option -MF */

	int argc;
	char **argv;
	/* -Wl options */

	char **link_argv;
	int link_argc, link_optind;
};

struct filespec {
	char type;
	char name[1];
};
/* The current value can be: */
/* mask for value location, register or: */

#define VT_VALMASK 0x003f
/* constant in vc (must be first non register value) */
#define VT_CONST 0x0030
/* lvalue, offset on stack */
#define VT_LLOCAL 0x0031
/* offset on stack */
#define VT_LOCAL 0x0032
/* the value is stored in processor flags (in vc) */
#define VT_CMP 0x0033
/* value is the consequence of jmp true (even) */
#define VT_JMP 0x0034
/* value is the consequence of jmp false (odd) */
#define VT_JMPI 0x0035
/* var is an lvalue */
#define VT_LVAL 0x0100
/* a symbol value is added */
#define VT_SYM 0x0200
/* value must be casted to be correct (used for
                                char/short stored in integer registers) */

#define VT_MUSTCAST 0x0C00
/* VT_CONST, but not an (C standard) integer
                                constant expression */

#define VT_NONCONST 0x1000
/* bound checking must be done before
                                dereferencing value */

#define VT_MUSTBOUND 0x4000
/* value is bounded. The address of the
                                bounding function call point is in vc */

#define VT_BOUNDED 0x8000
/* types */
/* mask for basic type */

#define VT_BTYPE 0x000f
/* void type */
#define VT_VOID 0
/* signed byte type */
#define VT_BYTE 1
/* short type */
#define VT_SHORT 2
/* integer type */
#define VT_INT 3
/* 64 bit integer */
#define VT_LLONG 4
/* pointer */
#define VT_PTR 5
/* function type */
#define VT_FUNC 6
/* struct/union definition */
#define VT_STRUCT 7
/* IEEE float */
#define VT_FLOAT 8
/* IEEE double */
#define VT_DOUBLE 9
/* IEEE long double */
#define VT_LDOUBLE 10
/* ISOC99 boolean type */
#define VT_BOOL 11
/* 128-bit integer. Only used for x86-64 ABI */
#define VT_QLONG 13
/* 128-bit float. Only used for x86-64 ABI */
#define VT_QFLOAT 14
/* unsigned type */

#define VT_UNSIGNED 0x0010
/* explicitly signed or unsigned */
#define VT_DEFSIGN 0x0020
/* array type (also has VT_PTR) */
#define VT_ARRAY 0x0040
/* bitfield modifier */
#define VT_BITFIELD 0x0080
/* const modifier */
#define VT_CONSTANT 0x0100
/* volatile modifier */
#define VT_VOLATILE 0x0200
/* VLA type (also has VT_PTR and VT_ARRAY) */
#define VT_VLA 0x0400
/* long type (also has VT_INT rsp. VT_LLONG) */
#define VT_LONG 0x0800
/* storage */
/* extern definition */

#define VT_EXTERN 0x00001000
/* static variable */
#define VT_STATIC 0x00002000
/* typedef definition */
#define VT_TYPEDEF 0x00004000
/* inline definition */
#define VT_INLINE 0x00008000
/* currently unused: 0x000[1248]0000  */
/* shift for bitfield shift values (32 - 2*6) */

#define VT_STRUCT_SHIFT 20
#define VT_STRUCT_MASK (((1U << (6+6)) - 1) << VT_STRUCT_SHIFT | VT_BITFIELD)
#define BIT_POS(t) (((t) >> VT_STRUCT_SHIFT) & 0x3f)
#define BIT_SIZE(t) (((t) >> (VT_STRUCT_SHIFT + 6)) & 0x3f)

#define VT_UNION (1 << VT_STRUCT_SHIFT | VT_STRUCT)
/* integral type is an enum really */
#define VT_ENUM (2 << VT_STRUCT_SHIFT)
/* integral type is an enum constant really */
#define VT_ENUM_VAL (3 << VT_STRUCT_SHIFT)

#define IS_ENUM(t) ((t & VT_STRUCT_MASK) == VT_ENUM)
#define IS_ENUM_VAL(t) ((t & VT_STRUCT_MASK) == VT_ENUM_VAL)
#define IS_UNION(t) ((t & (VT_STRUCT_MASK|VT_BTYPE)) == VT_UNION)

#define VT_ATOMIC VT_VOLATILE
/* type mask (except storage) */

#define VT_STORAGE (VT_EXTERN | VT_STATIC | VT_TYPEDEF | VT_INLINE)
#define VT_TYPE (~(VT_STORAGE|VT_STRUCT_MASK))
/* symbol was created by tccasm.c first */

#define VT_ASM (VT_VOID | 1 << VT_STRUCT_SHIFT)
#define VT_ASM_FUNC (VT_ASM | 2 << VT_STRUCT_SHIFT)
#define IS_ASM_SYM(sym) (((sym)->type.t & (VT_BTYPE | VT_ASM)) == VT_ASM)
/* general: set/get the pseudo-bitfield value for bit-mask M */

#define BFVAL(M,N) ((unsigned)((M) & ~((M) << 1)) * (N))
#define BFGET(X,M) (((X) & (M)) / BFVAL(M,1))
#define BFSET(X,M,N) ((X) = ((X) & ~(M)) | BFVAL(M,N))
/* token values */
/* conditional ops */

#define TOK_LAND 0x90
#define TOK_LOR 0x91
/* warning: the following compare tokens depend on i386 asm code */

#define TOK_ULT 0x92
#define TOK_UGE 0x93
#define TOK_EQ 0x94
#define TOK_NE 0x95
#define TOK_ULE 0x96
#define TOK_UGT 0x97
#define TOK_Nset 0x98
#define TOK_Nclear 0x99
#define TOK_LT 0x9c
#define TOK_GE 0x9d
#define TOK_LE 0x9e
#define TOK_GT 0x9f

#define TOK_ISCOND(t) (t >= TOK_LAND && t <= TOK_GT)
/* -- */

#define TOK_DEC 0x80
/* inc/dec, to void constant */
#define TOK_MID 0x81
/* ++ */
#define TOK_INC 0x82
/* unsigned division */
#define TOK_UDIV 0x83
/* unsigned modulo */
#define TOK_UMOD 0x84
/* fast division with undefined rounding for pointers */
#define TOK_PDIV 0x85
/* unsigned 32x32 -> 64 mul */
#define TOK_UMULL 0x86
/* add with carry generation */
#define TOK_ADDC1 0x87
/* add with carry use */
#define TOK_ADDC2 0x88
/* add with carry generation */
#define TOK_SUBC1 0x89
/* add with carry use */
#define TOK_SUBC2 0x8a
/* shift left */
#define TOK_SHL '<'
/* signed shift right */
#define TOK_SAR '>'
/* unsigned shift right */
#define TOK_SHR 0x8b
/* unary minus operation (for floats) */
#define TOK_NEG TOK_MID
/* -> */

#define TOK_ARROW 0xa0
/* three dots */
#define TOK_DOTS 0xa1
/* C++ token ? */
#define TOK_TWODOTS 0xa2
/* ## preprocessing token */
#define TOK_TWOSHARPS 0xa3
/* placeholder token as defined in C99 */
#define TOK_PLCHLDR 0xa4
/* A '##' in a macro to mean pasting */
#define TOK_PPJOIN (TOK_TWOSHARPS | SYM_FIELD)
/* alias of '(' for parsing sizeof (type) */
#define TOK_SOTYPE 0xa7
/* assignment operators */

#define TOK_A_ADD 0xb0
#define TOK_A_SUB 0xb1
#define TOK_A_MUL 0xb2
#define TOK_A_DIV 0xb3
#define TOK_A_MOD 0xb4
#define TOK_A_AND 0xb5
#define TOK_A_OR 0xb6
#define TOK_A_XOR 0xb7
#define TOK_A_SHL 0xb8
#define TOK_A_SAR 0xb9

#define TOK_ASSIGN(t) (t >= TOK_A_ADD && t <= TOK_A_SAR)
#define TOK_ASSIGN_OP(t) ("+-*/%&|^<>"[t - TOK_A_ADD])
/* tokens that carry values (in additional token string space / tokc) --> */
/* char constant in tokc */

#define TOK_CCHAR 0xc0
#define TOK_LCHAR 0xc1
/* number in tokc */
#define TOK_CINT 0xc2
/* unsigned int constant */
#define TOK_CUINT 0xc3
/* long long constant */
#define TOK_CLLONG 0xc4
/* unsigned long long constant */
#define TOK_CULLONG 0xc5
/* long constant */
#define TOK_CLONG 0xc6
/* unsigned long constant */
#define TOK_CULONG 0xc7
/* pointer to string in tokc */
#define TOK_STR 0xc8
#define TOK_LSTR 0xc9
/* float constant */
#define TOK_CFLOAT 0xca
/* double constant */
#define TOK_CDOUBLE 0xcb
/* long double constant */
#define TOK_CLDOUBLE 0xcc
/* preprocessor number */
#define TOK_PPNUM 0xcd
/* preprocessor string */
#define TOK_PPSTR 0xce
/* line number info */
#define TOK_LINENUM 0xcf

#define TOK_HAS_VALUE(t) (t >= TOK_CCHAR && t <= TOK_LINENUM)
/* end of file */

#define TOK_EOF (-1)
/* line feed */
#define TOK_LINEFEED 10
/* all identifiers and strings have token above that */

#define TOK_IDENT 256

enum tcc_token {
	TOK_LAST = TOK_IDENT - 1
#define DEF(id,str) ,id
// 1 "tcctok.h" 1
		   /**/
		   /* keywords */

		   DEF(TOK_IF, "if")
		   DEF(TOK_ELSE, "else")
		   DEF(TOK_WHILE, "while")
		   DEF(TOK_FOR, "for")
		   DEF(TOK_DO, "do")
		   DEF(TOK_CONTINUE, "continue")
		   DEF(TOK_BREAK, "break")
		   DEF(TOK_RETURN, "return")
		   DEF(TOK_GOTO, "goto")
		   DEF(TOK_SWITCH, "switch")
		   DEF(TOK_CASE, "case")
		   DEF(TOK_DEFAULT, "default")
		   DEF(TOK_ASM1, "asm")
		   DEF(TOK_ASM2, "__asm")
		   DEF(TOK_ASM3, "__asm__")

		   DEF(TOK_EXTERN, "extern")
		   DEF(TOK_STATIC, "static")
		   DEF(TOK_UNSIGNED, "unsigned")
		   DEF(TOK__Atomic, "_Atomic")
		   DEF(TOK_CONST1, "const")
		   DEF(TOK_CONST2, "__const")/* gcc keyword */

		   DEF(TOK_CONST3, "__const__")/* gcc keyword */

		   DEF(TOK_VOLATILE1, "volatile")
		   DEF(TOK_VOLATILE2, "__volatile")/* gcc keyword */

		   DEF(TOK_VOLATILE3, "__volatile__")/* gcc keyword */

		   DEF(TOK_REGISTER, "register")
		   DEF(TOK_SIGNED1, "signed")
		   DEF(TOK_SIGNED2, "__signed")/* gcc keyword */

		   DEF(TOK_SIGNED3, "__signed__")/* gcc keyword */

		   DEF(TOK_AUTO, "auto")
		   DEF(TOK_INLINE1, "inline")
		   DEF(TOK_INLINE2, "__inline")/* gcc keyword */

		   DEF(TOK_INLINE3, "__inline__")/* gcc keyword */

		   DEF(TOK_RESTRICT1, "restrict")
		   DEF(TOK_RESTRICT2, "__restrict")
		   DEF(TOK_RESTRICT3, "__restrict__")
		   DEF(TOK_EXTENSION, "__extension__")/* gcc keyword */

		   DEF(TOK_THREAD_LOCAL, "_Thread_local")/* C11 thread-local storage */

		   DEF(TOK_GENERIC, "_Generic")
		   DEF(TOK_STATIC_ASSERT, "_Static_assert")

		   DEF(TOK_VOID, "void")
		   DEF(TOK_CHAR, "char")
		   DEF(TOK_INT, "int")
		   DEF(TOK_FLOAT, "float")
		   DEF(TOK_DOUBLE, "double")
		   DEF(TOK_BOOL, "_Bool")
		   DEF(TOK_COMPLEX, "_Complex")
		   DEF(TOK_SHORT, "short")
		   DEF(TOK_LONG, "long")
		   DEF(TOK_STRUCT, "struct")
		   DEF(TOK_UNION, "union")
		   DEF(TOK_TYPEDEF, "typedef")
		   DEF(TOK_ENUM, "enum")
		   DEF(TOK_SIZEOF, "sizeof")
		   DEF(TOK_ATTRIBUTE1, "__attribute")
		   DEF(TOK_ATTRIBUTE2, "__attribute__")
		   DEF(TOK_ALIGNOF1, "__alignof")
		   DEF(TOK_ALIGNOF2, "__alignof__")
		   DEF(TOK_ALIGNOF3, "_Alignof")
		   DEF(TOK_ALIGNAS, "_Alignas")
		   DEF(TOK_TYPEOF1, "typeof")
		   DEF(TOK_TYPEOF2, "__typeof")
		   DEF(TOK_TYPEOF3, "__typeof__")
		   DEF(TOK_LABEL, "__label__")
		   /**/
		   /* the following are not keywords. They are included to ease parsing */
		   /* preprocessor only */

		   DEF(TOK_DEFINE, "define")
		   DEF(TOK_INCLUDE, "include")
		   DEF(TOK_INCLUDE_NEXT, "include_next")
		   DEF(TOK_IFDEF, "ifdef")
		   DEF(TOK_IFNDEF, "ifndef")
		   DEF(TOK_ELIF, "elif")
		   DEF(TOK_ENDIF, "endif")
		   DEF(TOK_DEFINED, "defined")
		   DEF(TOK_UNDEF, "undef")
		   DEF(TOK_ERROR, "error")
		   DEF(TOK_WARNING, "warning")
		   DEF(TOK_LINE, "line")
		   DEF(TOK_PRAGMA, "pragma")
		   DEF(TOK___LINE__, "__LINE__")
		   DEF(TOK___FILE__, "__FILE__")
		   DEF(TOK___DATE__, "__DATE__")
		   DEF(TOK___TIME__, "__TIME__")
		   DEF(TOK___FUNCTION__, "__FUNCTION__")
		   DEF(TOK___VA_ARGS__, "__VA_ARGS__")
		   DEF(TOK___COUNTER__, "__COUNTER__")
		   DEF(TOK___HAS_INCLUDE, "__has_include")
		   DEF(TOK___HAS_INCLUDE_NEXT, "__has_include_next")
		   /* special identifiers */

		   DEF(TOK___FUNC__, "__func__")
		   /* special floating point values */

		   DEF(TOK___NAN__, "__nan__")
		   DEF(TOK___SNAN__, "__snan__")
		   DEF(TOK___INF__, "__inf__")
		   /* attribute identifiers */
		   /* XXX: handle all tokens generically since speed is not critical */

		   DEF(TOK_SECTION1, "section")
		   DEF(TOK_SECTION2, "__section__")
		   DEF(TOK_ALIGNED1, "aligned")
		   DEF(TOK_ALIGNED2, "__aligned__")
		   DEF(TOK_PACKED1, "packed")
		   DEF(TOK_PACKED2, "__packed__")
		   DEF(TOK_WEAK1, "weak")
		   DEF(TOK_WEAK2, "__weak__")
		   DEF(TOK_ALIAS1, "alias")
		   DEF(TOK_ALIAS2, "__alias__")
		   DEF(TOK_UNUSED1, "unused")
		   DEF(TOK_UNUSED2, "__unused__")
		   DEF(TOK_NODEBUG1, "nodebug")
		   DEF(TOK_NODEBUG2, "__nodebug__")
		   DEF(TOK_CDECL1, "cdecl")
		   DEF(TOK_CDECL2, "__cdecl")
		   DEF(TOK_CDECL3, "__cdecl__")
		   DEF(TOK_STDCALL1, "stdcall")
		   DEF(TOK_STDCALL2, "__stdcall")
		   DEF(TOK_STDCALL3, "__stdcall__")
		   DEF(TOK_FASTCALL1, "fastcall")
		   DEF(TOK_FASTCALL2, "__fastcall")
		   DEF(TOK_FASTCALL3, "__fastcall__")
		   DEF(TOK_THISCALL1, "thiscall")
		   DEF(TOK_THISCALL2, "__thiscall")
		   DEF(TOK_THISCALL3, "__thiscall__")
		   DEF(TOK_REGPARM1, "regparm")
		   DEF(TOK_REGPARM2, "__regparm__")
		   DEF(TOK_CLEANUP1, "cleanup")
		   DEF(TOK_CLEANUP2, "__cleanup__")
		   DEF(TOK_CONSTRUCTOR1, "constructor")
		   DEF(TOK_CONSTRUCTOR2, "__constructor__")
		   DEF(TOK_DESTRUCTOR1, "destructor")
		   DEF(TOK_DESTRUCTOR2, "__destructor__")
		   DEF(TOK_ALWAYS_INLINE1, "always_inline")
		   DEF(TOK_ALWAYS_INLINE2, "__always_inline__")

		   DEF(TOK_MODE, "__mode__")
		   DEF(TOK_MODE_QI, "__QI__")
		   DEF(TOK_MODE_DI, "__DI__")
		   DEF(TOK_MODE_HI, "__HI__")
		   DEF(TOK_MODE_SI, "__SI__")
		   DEF(TOK_MODE_word, "__word__")

		   DEF(TOK_DLLEXPORT, "dllexport")
		   DEF(TOK_DLLIMPORT, "dllimport")
		   DEF(TOK_NODECORATE, "nodecorate")
		   DEF(TOK_NORETURN1, "noreturn")
		   DEF(TOK_NORETURN2, "__noreturn__")
		   DEF(TOK_NORETURN3, "_Noreturn")
		   DEF(TOK_VISIBILITY1, "visibility")
		   DEF(TOK_VISIBILITY2, "__visibility__")

		   DEF(TOK_builtin_types_compatible_p, "__builtin_types_compatible_p")
		   DEF(TOK_builtin_choose_expr, "__builtin_choose_expr")
		   DEF(TOK_builtin_constant_p, "__builtin_constant_p")
		   DEF(TOK_builtin_frame_address, "__builtin_frame_address")
		   DEF(TOK_builtin_return_address, "__builtin_return_address")
		   DEF(TOK_builtin_expect, "__builtin_expect")
		   DEF(TOK_builtin_unreachable, "__builtin_unreachable")
		   /*DEF(TOK_builtin_va_list, "__builtin_va_list")*/

		   DEF(TOK_builtin_va_start, "__builtin_va_start")
		   /* atomic operations */
// 180 "tcctok.h"
#define DEF_ATOMIC(ID) DEF(TOK_ ## __ ## ID, "__"#ID)
		   DEF_ATOMIC(atomic_store)
		   DEF_ATOMIC(atomic_load)
		   DEF_ATOMIC(atomic_exchange)
		   DEF_ATOMIC(atomic_compare_exchange)
		   DEF_ATOMIC(atomic_fetch_add)
		   DEF_ATOMIC(atomic_fetch_sub)
		   DEF_ATOMIC(atomic_fetch_or)
		   DEF_ATOMIC(atomic_fetch_xor)
		   DEF_ATOMIC(atomic_fetch_and)
		   DEF_ATOMIC(atomic_fetch_nand)
		   DEF_ATOMIC(atomic_add_fetch)
		   DEF_ATOMIC(atomic_sub_fetch)
		   DEF_ATOMIC(atomic_or_fetch)
		   DEF_ATOMIC(atomic_xor_fetch)
		   DEF_ATOMIC(atomic_and_fetch)
		   DEF_ATOMIC(atomic_nand_fetch)
		   /* pragma */

		   DEF(TOK_pack, "pack")

		   DEF(TOK_comment, "comment")
		   DEF(TOK_lib, "lib")
		   DEF(TOK_push_macro, "push_macro")
		   DEF(TOK_pop_macro, "pop_macro")
		   DEF(TOK_once, "once")
		   DEF(TOK_option, "option")
		   /* builtin functions or variables */

		   DEF(TOK_memcpy, "memcpy")
		   DEF(TOK_memmove, "memmove")
		   DEF(TOK_memset, "memset")
		   DEF(TOK___divdi3, "__divdi3")
		   DEF(TOK___moddi3, "__moddi3")
		   DEF(TOK___udivdi3, "__udivdi3")
		   DEF(TOK___umoddi3, "__umoddi3")
		   DEF(TOK___ashrdi3, "__ashrdi3")
		   DEF(TOK___lshrdi3, "__lshrdi3")
		   DEF(TOK___ashldi3, "__ashldi3")
		   DEF(TOK___floatundisf, "__floatundisf")
		   DEF(TOK___floatundidf, "__floatundidf")

		   DEF(TOK___floatundixf, "__floatundixf")
		   DEF(TOK___fixunsxfdi, "__fixunsxfdi")

		   DEF(TOK___fixunssfdi, "__fixunssfdi")
		   DEF(TOK___fixunsdfdi, "__fixunsdfdi")
// 295 "tcctok.h"
		   DEF(TOK_alloca, "alloca")

		   DEF(TOK___chkstk, "__chkstk")
		   /* bound checking symbols */
#ifdef CONFIG_TCC_BCHECK

		   DEF(TOK___bound_ptr_add, "__bound_ptr_add")
		   DEF(TOK___bound_ptr_indir1, "__bound_ptr_indir1")
		   DEF(TOK___bound_ptr_indir2, "__bound_ptr_indir2")
		   DEF(TOK___bound_ptr_indir4, "__bound_ptr_indir4")
		   DEF(TOK___bound_ptr_indir8, "__bound_ptr_indir8")
		   DEF(TOK___bound_ptr_indir12, "__bound_ptr_indir12")
		   DEF(TOK___bound_ptr_indir16, "__bound_ptr_indir16")
		   DEF(TOK___bound_main_arg, "__bound_main_arg")
		   DEF(TOK___bound_local_new, "__bound_local_new")
		   DEF(TOK___bound_local_delete, "__bound_local_delete")
		   DEF(TOK___bound_setjmp, "__bound_setjmp")
		   DEF(TOK___bound_longjmp, "__bound_longjmp")
		   DEF(TOK___bound_new_region, "__bound_new_region")
		   DEF(TOK___bound_alloca_nr, "__bound_alloca_nr")
		   DEF(TOK_setjmp, "setjmp")
		   DEF(TOK__setjmp, "_setjmp")
		   DEF(TOK_longjmp, "longjmp")
#endif
		   /**/
		   /* Tiny Assembler */
// 359 "tcctok.h"
#define DEF_ASM(x) DEF(TOK_ASM_ ## x, #x)
#define DEF_ASMDIR(x) DEF(TOK_ASMDIR_ ## x, "." #x)
#define TOK_ASM_int TOK_INT

#define TOK_ASMDIR_FIRST TOK_ASMDIR_byte
#define TOK_ASMDIR_LAST TOK_ASMDIR_section

		   DEF_ASMDIR(byte)/* must be first directive */

		   DEF_ASMDIR(word)
		   DEF_ASMDIR(align)
		   DEF_ASMDIR(balign)
		   DEF_ASMDIR(p2align)
		   DEF_ASMDIR(set)
		   DEF_ASMDIR(skip)
		   DEF_ASMDIR(space)
		   DEF_ASMDIR(string)
		   DEF_ASMDIR(asciz)
		   DEF_ASMDIR(ascii)
		   DEF_ASMDIR(file)
		   DEF_ASMDIR(globl)
		   DEF_ASMDIR(global)
		   DEF_ASMDIR(weak)
		   DEF_ASMDIR(hidden)
		   DEF_ASMDIR(ident)
		   DEF_ASMDIR(size)
		   DEF_ASMDIR(type)
		   DEF_ASMDIR(text)
		   DEF_ASMDIR(data)
		   DEF_ASMDIR(bss)
		   DEF_ASMDIR(previous)
		   DEF_ASMDIR(pushsection)
		   DEF_ASMDIR(popsection)
		   DEF_ASMDIR(fill)
		   DEF_ASMDIR(rept)
		   DEF_ASMDIR(endr)
		   DEF_ASMDIR(org)
		   DEF_ASMDIR(quad)

		   DEF_ASMDIR(code64)

		   DEF_ASMDIR(short)
		   DEF_ASMDIR(long)
		   DEF_ASMDIR(int)
		   DEF_ASMDIR(symver)
		   DEF_ASMDIR(section)/* must be last directive */

// 1 "i386-tok.h" 1
		   /* ------------------------------------------------------------------ */
		   /* WARNING: relative order of tokens is important. */

#define DEF_BWL(x) DEF(TOK_ASM_ ## x ## b, #x "b") DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x, #x)

#define DEF_WL(x) DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x, #x)

#define DEF_BWLQ(x) DEF(TOK_ASM_ ## x ## b, #x "b") DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x ## q, #x "q") DEF(TOK_ASM_ ## x, #x)

#define DEF_WLQ(x) DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x ## q, #x "q") DEF(TOK_ASM_ ## x, #x)
#define DEF_BWLX DEF_BWLQ
#define DEF_WLX DEF_WLQ
		   /* number of sizes + 1 */

#define NBWLX 5
// 40 "i386-tok.h"
#define DEF_FP1(x) DEF(TOK_ASM_ ## f ## x ## s, "f" #x "s") DEF(TOK_ASM_ ## fi ## x ## l, "fi" #x "l") DEF(TOK_ASM_ ## f ## x ## l, "f" #x "l") DEF(TOK_ASM_ ## fi ## x ## s, "fi" #x "s")

#define DEF_FP(x) DEF(TOK_ASM_ ## f ## x, "f" #x ) DEF(TOK_ASM_ ## f ## x ## p, "f" #x "p") DEF_FP1(x)
// 77 "i386-tok.h"
#define DEF_ASMTEST(x,suffix) DEF_ASM(x ## o ## suffix) DEF_ASM(x ## no ## suffix) DEF_ASM(x ## b ## suffix) DEF_ASM(x ## c ## suffix) DEF_ASM(x ## nae ## suffix) DEF_ASM(x ## nb ## suffix) DEF_ASM(x ## nc ## suffix) DEF_ASM(x ## ae ## suffix) DEF_ASM(x ## e ## suffix) DEF_ASM(x ## z ## suffix) DEF_ASM(x ## ne ## suffix) DEF_ASM(x ## nz ## suffix) DEF_ASM(x ## be ## suffix) DEF_ASM(x ## na ## suffix) DEF_ASM(x ## nbe ## suffix) DEF_ASM(x ## a ## suffix) DEF_ASM(x ## s ## suffix) DEF_ASM(x ## ns ## suffix) DEF_ASM(x ## p ## suffix) DEF_ASM(x ## pe ## suffix) DEF_ASM(x ## np ## suffix) DEF_ASM(x ## po ## suffix) DEF_ASM(x ## l ## suffix) DEF_ASM(x ## nge ## suffix) DEF_ASM(x ## nl ## suffix) DEF_ASM(x ## ge ## suffix) DEF_ASM(x ## le ## suffix) DEF_ASM(x ## ng ## suffix) DEF_ASM(x ## nle ## suffix) DEF_ASM(x ## g ## suffix)
		   /* ------------------------------------------------------------------ */
		   /* register */

		   DEF_ASM(al)
		   DEF_ASM(cl)
		   DEF_ASM(dl)
		   DEF_ASM(bl)
		   DEF_ASM(ah)
		   DEF_ASM(ch)
		   DEF_ASM(dh)
		   DEF_ASM(bh)
		   DEF_ASM(ax)
		   DEF_ASM(cx)
		   DEF_ASM(dx)
		   DEF_ASM(bx)
		   DEF_ASM(sp)
		   DEF_ASM(bp)
		   DEF_ASM(si)
		   DEF_ASM(di)
		   DEF_ASM(eax)
		   DEF_ASM(ecx)
		   DEF_ASM(edx)
		   DEF_ASM(ebx)
		   DEF_ASM(esp)
		   DEF_ASM(ebp)
		   DEF_ASM(esi)
		   DEF_ASM(edi)

		   DEF_ASM(rax)
		   DEF_ASM(rcx)
		   DEF_ASM(rdx)
		   DEF_ASM(rbx)
		   DEF_ASM(rsp)
		   DEF_ASM(rbp)
		   DEF_ASM(rsi)
		   DEF_ASM(rdi)

		   DEF_ASM(mm0)
		   DEF_ASM(mm1)
		   DEF_ASM(mm2)
		   DEF_ASM(mm3)
		   DEF_ASM(mm4)
		   DEF_ASM(mm5)
		   DEF_ASM(mm6)
		   DEF_ASM(mm7)
		   DEF_ASM(xmm0)
		   DEF_ASM(xmm1)
		   DEF_ASM(xmm2)
		   DEF_ASM(xmm3)
		   DEF_ASM(xmm4)
		   DEF_ASM(xmm5)
		   DEF_ASM(xmm6)
		   DEF_ASM(xmm7)
		   DEF_ASM(cr0)
		   DEF_ASM(cr1)
		   DEF_ASM(cr2)
		   DEF_ASM(cr3)
		   DEF_ASM(cr4)
		   DEF_ASM(cr5)
		   DEF_ASM(cr6)
		   DEF_ASM(cr7)
		   DEF_ASM(tr0)
		   DEF_ASM(tr1)
		   DEF_ASM(tr2)
		   DEF_ASM(tr3)
		   DEF_ASM(tr4)
		   DEF_ASM(tr5)
		   DEF_ASM(tr6)
		   DEF_ASM(tr7)
		   DEF_ASM(db0)
		   DEF_ASM(db1)
		   DEF_ASM(db2)
		   DEF_ASM(db3)
		   DEF_ASM(db4)
		   DEF_ASM(db5)
		   DEF_ASM(db6)
		   DEF_ASM(db7)
		   DEF_ASM(dr0)
		   DEF_ASM(dr1)
		   DEF_ASM(dr2)
		   DEF_ASM(dr3)
		   DEF_ASM(dr4)
		   DEF_ASM(dr5)
		   DEF_ASM(dr6)
		   DEF_ASM(dr7)
		   DEF_ASM(es)
		   DEF_ASM(cs)
		   DEF_ASM(ss)
		   DEF_ASM(ds)
		   DEF_ASM(fs)
		   DEF_ASM(gs)
		   DEF_ASM(st)
		   DEF_ASM(rip)
		   /* The four low parts of sp/bp/si/di that exist only on
		       x86-64 (encoding aliased to ah,ch,dh,dh when not using REX). */

		   DEF_ASM(spl)
		   DEF_ASM(bpl)
		   DEF_ASM(sil)
		   DEF_ASM(dil)
		   /* generic two operands */

		   DEF_BWLX(mov)

		   DEF_BWLX(add)
		   DEF_BWLX(or)
		   DEF_BWLX(adc)
		   DEF_BWLX(sbb)
		   DEF_BWLX(and)
		   DEF_BWLX(sub)
		   DEF_BWLX(xor)
		   DEF_BWLX(cmp)
		   /* unary ops */

		   DEF_BWLX(inc)
		   DEF_BWLX(dec)
		   DEF_BWLX(not)
		   DEF_BWLX(neg)
		   DEF_BWLX(mul)
		   DEF_BWLX(imul)
		   DEF_BWLX(div)
		   DEF_BWLX(idiv)

		   DEF_BWLX(xchg)
		   DEF_BWLX(test)
		   /* shifts */

		   DEF_BWLX(rol)
		   DEF_BWLX(ror)
		   DEF_BWLX(rcl)
		   DEF_BWLX(rcr)
		   DEF_BWLX(shl)
		   DEF_BWLX(shr)
		   DEF_BWLX(sar)

		   DEF_WLX(shld)
		   DEF_WLX(shrd)

		   DEF_ASM(pushw)
		   DEF_ASM(pushl)

		   DEF_ASM(pushq)

		   DEF_ASM(push)

		   DEF_ASM(popw)
		   DEF_ASM(popl)

		   DEF_ASM(popq)

		   DEF_ASM(pop)

		   DEF_BWL(in)
		   DEF_BWL(out)

		   DEF_WLX(movzb)
		   DEF_ASM(movzwl)
		   DEF_ASM(movsbw)
		   DEF_ASM(movsbl)
		   DEF_ASM(movswl)

		   DEF_ASM(movsbq)
		   DEF_ASM(movswq)
		   DEF_ASM(movzwq)
		   DEF_ASM(movslq)

		   DEF_WLX(lea)

		   DEF_ASM(les)
		   DEF_ASM(lds)
		   DEF_ASM(lss)
		   DEF_ASM(lfs)
		   DEF_ASM(lgs)

		   DEF_ASM(call)
		   DEF_ASM(jmp)
		   DEF_ASM(lcall)
		   DEF_ASM(ljmp)

		   DEF_ASMTEST(j,)

		   DEF_ASMTEST(set,)
		   DEF_ASMTEST(set,b)
		   DEF_ASMTEST(cmov,)

		   DEF_WLX(bsf)
		   DEF_WLX(bsr)
		   DEF_WLX(bt)
		   DEF_WLX(bts)
		   DEF_WLX(btr)
		   DEF_WLX(btc)
		   DEF_WLX(popcnt)
		   DEF_WLX(tzcnt)
		   DEF_WLX(lzcnt)

		   DEF_WLX(lar)
		   DEF_WLX(lsl)
		   /* generic FP ops */

		   DEF_FP(add)
		   DEF_FP(mul)

		   DEF_ASM(fcom)
		   DEF_ASM(fcom_1)/* non existent op, just to have a regular table */

		   DEF_FP1(com)

		   DEF_FP(comp)
		   DEF_FP(sub)
		   DEF_FP(subr)
		   DEF_FP(div)
		   DEF_FP(divr)

		   DEF_BWLX(xadd)
		   DEF_BWLX(cmpxchg)
		   /* string ops */

		   DEF_BWLX(cmps)
		   DEF_BWLX(scmp)
		   DEF_BWL(ins)
		   DEF_BWL(outs)
		   DEF_BWLX(lods)
		   DEF_BWLX(slod)
		   DEF_BWLX(movs)
		   DEF_BWLX(smov)
		   DEF_BWLX(scas)
		   DEF_BWLX(ssca)
		   DEF_BWLX(stos)
		   DEF_BWLX(ssto)
		   /* generic asm ops */

#define ALT(x)
#define DEF_ASM_OP0(name,opcode) DEF_ASM(name)
#define DEF_ASM_OP0L(name,opcode,group,instr_type)
#define DEF_ASM_OP1(name,opcode,group,instr_type,op0)
#define DEF_ASM_OP2(name,opcode,group,instr_type,op0,op1)
#define DEF_ASM_OP3(name,opcode,group,instr_type,op0,op1,op2)

// 1 "x86_64-asm.h" 1
		   DEF_ASM_OP0(clc, 0xf8)/* must be first OP0 */

		   DEF_ASM_OP0(cld, 0xfc)
		   DEF_ASM_OP0(cli, 0xfa)
		   DEF_ASM_OP0(clts, 0x0f06)
		   DEF_ASM_OP0(cmc, 0xf5)
		   DEF_ASM_OP0(lahf, 0x9f)
		   DEF_ASM_OP0(sahf, 0x9e)
		   DEF_ASM_OP0(pushfq, 0x9c)
		   DEF_ASM_OP0(popfq, 0x9d)
		   DEF_ASM_OP0(pushf, 0x9c)
		   DEF_ASM_OP0(popf, 0x9d)
		   DEF_ASM_OP0(stc, 0xf9)
		   DEF_ASM_OP0(std, 0xfd)
		   DEF_ASM_OP0(sti, 0xfb)
		   DEF_ASM_OP0(aaa, 0x37)
		   DEF_ASM_OP0(aas, 0x3f)
		   DEF_ASM_OP0(daa, 0x27)
		   DEF_ASM_OP0(das, 0x2f)
		   DEF_ASM_OP0(aad, 0xd50a)
		   DEF_ASM_OP0(aam, 0xd40a)
		   DEF_ASM_OP0(cbw, 0x6698)
		   DEF_ASM_OP0(cwd, 0x6699)
		   DEF_ASM_OP0(cwde, 0x98)
		   DEF_ASM_OP0(cdq, 0x99)
		   DEF_ASM_OP0(cbtw, 0x6698)
		   DEF_ASM_OP0(cwtl, 0x98)
		   DEF_ASM_OP0(cwtd, 0x6699)
		   DEF_ASM_OP0(cltd, 0x99)
		   DEF_ASM_OP0(cqto, 0x4899)
		   DEF_ASM_OP0(int3, 0xcc)
		   DEF_ASM_OP0(into, 0xce)
		   DEF_ASM_OP0(iret, 0xcf)
		   DEF_ASM_OP0(iretw, 0x66cf)
		   DEF_ASM_OP0(iretl, 0xcf)
		   DEF_ASM_OP0(iretq, 0x48cf)
		   DEF_ASM_OP0(rsm, 0x0faa)
		   DEF_ASM_OP0(hlt, 0xf4)
		   DEF_ASM_OP0(wait, 0x9b)
		   DEF_ASM_OP0(nop, 0x90)
		   DEF_ASM_OP0(pause, 0xf390)
		   DEF_ASM_OP0(xlat, 0xd7)

		   DEF_ASM_OP0L(vmcall, 0xc1, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmlaunch, 0xc2, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmresume, 0xc3, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmxoff, 0xc4, 0, OPC_0F01)
		   /* strings */

		   ALT(DEF_ASM_OP0L(cmpsb, 0xa6, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(scmpb, 0xa6, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(insb, 0x6c, 0, OPC_BWL))
		   ALT(DEF_ASM_OP0L(outsb, 0x6e, 0, OPC_BWL))

		   ALT(DEF_ASM_OP0L(lodsb, 0xac, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(slodb, 0xac, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(movsb, 0xa4, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(smovb, 0xa4, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(scasb, 0xae, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(sscab, 0xae, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(stosb, 0xaa, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(sstob, 0xaa, 0, OPC_BWLX))
		   /* bits */

		   ALT(DEF_ASM_OP2(bsfw, 0x0fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(bsrw, 0x0fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   ALT(DEF_ASM_OP2(btw, 0x0fa3, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btw, 0x0fba, 4, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btsw, 0x0fab, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btsw, 0x0fba, 5, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btrw, 0x0fb3, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btrw, 0x0fba, 6, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btcw, 0x0fbb, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btcw, 0x0fba, 7, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(popcntw, 0xf30fb8, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   ALT(DEF_ASM_OP2(tzcntw, 0xf30fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(lzcntw, 0xf30fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   /* prefixes */

		   DEF_ASM_OP0(lock, 0xf0)
		   DEF_ASM_OP0(rep, 0xf3)
		   DEF_ASM_OP0(repe, 0xf3)
		   DEF_ASM_OP0(repz, 0xf3)
		   DEF_ASM_OP0(repne, 0xf2)
		   DEF_ASM_OP0(repnz, 0xf2)

		   DEF_ASM_OP0(invd, 0x0f08)
		   DEF_ASM_OP0(wbinvd, 0x0f09)
		   DEF_ASM_OP0(cpuid, 0x0fa2)
		   DEF_ASM_OP0(wrmsr, 0x0f30)
		   DEF_ASM_OP0(rdtsc, 0x0f31)
		   DEF_ASM_OP0(rdmsr, 0x0f32)
		   DEF_ASM_OP0(rdpmc, 0x0f33)

		   DEF_ASM_OP0(syscall, 0x0f05)
		   DEF_ASM_OP0(sysret, 0x0f07)
		   DEF_ASM_OP0L(sysretq, 0x480f07, 0, 0)
		   DEF_ASM_OP0(ud2, 0x0f0b)
		   /* NOTE: we took the same order as gas opcode definition order */
		   /* Right now we can't express the fact that 0xa1/0xa3 can't use $eax and a
		      32 bit moffset as operands.
		   ALT(DEF_ASM_OP2(movb, 0xa0, 0, OPC_BWLX, OPT_ADDR, OPT_EAX))
		   ALT(DEF_ASM_OP2(movb, 0xa2, 0, OPC_BWLX, OPT_EAX, OPT_ADDR)) */

		   ALT(DEF_ASM_OP2(movb, 0x88, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(movb, 0x8a, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   /* The moves are special: the 0xb8 form supports IM64 (the only insn that
		      does) with REG64.  It doesn't support IM32 with REG64, it would use
		      the full movabs form (64bit immediate).  For IM32->REG64 we prefer
		      the 0xc7 opcode.  So disallow all 64bit forms and code the rest by hand. */

		   ALT(DEF_ASM_OP2(movb, 0xb0, 0, OPC_REG | OPC_BWLX, OPT_IM, OPT_REG))
		   ALT(DEF_ASM_OP2(mov, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
		   ALT(DEF_ASM_OP2(movq, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
		   ALT(DEF_ASM_OP2(movb, 0xc6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP2(movw, 0x8c, 0, OPC_MODRM | OPC_WLX, OPT_SEG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(movw, 0x8e, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_SEG))

		   ALT(DEF_ASM_OP2(movw, 0x0f20, 0, OPC_MODRM | OPC_WLX, OPT_CR, OPT_REG64))
		   ALT(DEF_ASM_OP2(movw, 0x0f21, 0, OPC_MODRM | OPC_WLX, OPT_DB, OPT_REG64))
		   ALT(DEF_ASM_OP2(movw, 0x0f22, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_CR))
		   ALT(DEF_ASM_OP2(movw, 0x0f23, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_DB))

		   ALT(DEF_ASM_OP2(movsbw, 0x660fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG16))
		   ALT(DEF_ASM_OP2(movsbl, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movsbq, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(movswl, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movswq, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP2(movslq, 0x63, 0, OPC_MODRM, OPT_REG32 | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP2(movzbw, 0x0fb6, 0, OPC_MODRM | OPC_WLX, OPT_REG8 | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(movzwl, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movzwq, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))

		   ALT(DEF_ASM_OP1(pushq, 0x6a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(push, 0x6a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(pushw, 0x666a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG64))
		   ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG16))
		   ALT(DEF_ASM_OP1(pushw, 0xff, 6, OPC_MODRM | OPC_WLX, OPT_REG64 | OPT_EA))
		   ALT(DEF_ASM_OP1(pushw, 0x6668, 0, 0, OPT_IM16))
		   ALT(DEF_ASM_OP1(pushw, 0x68, 0, OPC_WLX, OPT_IM32))
		   ALT(DEF_ASM_OP1(pushw, 0x06, 0, OPC_WLX, OPT_SEG))

		   ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG64))
		   ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG16))
		   ALT(DEF_ASM_OP1(popw, 0x8f, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP1(popw, 0x07, 0, OPC_WLX, OPT_SEG))

		   ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_REGW, OPT_EAX))
		   ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_EAX, OPT_REGW))
		   ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))

		   ALT(DEF_ASM_OP2(inb, 0xe4, 0, OPC_BWL, OPT_IM8, OPT_EAX))
		   ALT(DEF_ASM_OP1(inb, 0xe4, 0, OPC_BWL, OPT_IM8))
		   ALT(DEF_ASM_OP2(inb, 0xec, 0, OPC_BWL, OPT_DX, OPT_EAX))
		   ALT(DEF_ASM_OP1(inb, 0xec, 0, OPC_BWL, OPT_DX))

		   ALT(DEF_ASM_OP2(outb, 0xe6, 0, OPC_BWL, OPT_EAX, OPT_IM8))
		   ALT(DEF_ASM_OP1(outb, 0xe6, 0, OPC_BWL, OPT_IM8))
		   ALT(DEF_ASM_OP2(outb, 0xee, 0, OPC_BWL, OPT_EAX, OPT_DX))
		   ALT(DEF_ASM_OP1(outb, 0xee, 0, OPC_BWL, OPT_DX))

		   ALT(DEF_ASM_OP2(leaw, 0x8d, 0, OPC_MODRM | OPC_WLX, OPT_EA, OPT_REG))

		   ALT(DEF_ASM_OP2(les, 0xc4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lds, 0xc5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lss, 0x0fb2, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lfs, 0x0fb4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lgs, 0x0fb5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   /* arith */

		   ALT(DEF_ASM_OP2(addb, 0x00, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))/* XXX: use D bit ? */

		   ALT(DEF_ASM_OP2(addb, 0x02, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   ALT(DEF_ASM_OP2(addb, 0x04, 0, OPC_ARITH | OPC_BWLX, OPT_IM, OPT_EAX))
		   ALT(DEF_ASM_OP2(addw, 0x83, 0, OPC_ARITH | OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(addb, 0x80, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   ALT(DEF_ASM_OP2(testb, 0xa8, 0, OPC_BWLX, OPT_IM, OPT_EAX))
		   ALT(DEF_ASM_OP2(testb, 0xf6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP1(incb, 0xfe, 0, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(decb, 0xfe, 1, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP1(notb, 0xf6, 2, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(negb, 0xf6, 3, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP1(mulb, 0xf6, 4, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(imulb, 0xf6, 5, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP2(imulw, 0x0faf, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP3(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW))
		   ALT(DEF_ASM_OP3(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW))

		   ALT(DEF_ASM_OP1(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP2(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
		   ALT(DEF_ASM_OP1(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP2(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
		   /* shifts */

		   ALT(DEF_ASM_OP2(rolb, 0xc0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_IM8, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(rolb, 0xd2, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_CL, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP1(rolb, 0xd0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP3(shldw, 0x0fa4, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shrdw, 0x0fac, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_EA | OPT_REGW))

		   ALT(DEF_ASM_OP1(call, 0xff, 2, OPC_MODRM, OPT_INDIR))
		   ALT(DEF_ASM_OP1(call, 0xe8, 0, 0, OPT_DISP))
		   DEF_ASM_OP1(callq, 0xff, 2, OPC_MODRM, OPT_INDIR)
		   ALT(DEF_ASM_OP1(callq, 0xe8, 0, 0, OPT_DISP))
		   ALT(DEF_ASM_OP1(jmp, 0xff, 4, OPC_MODRM, OPT_INDIR))
		   ALT(DEF_ASM_OP1(jmp, 0xeb, 0, 0, OPT_DISP8))

		   ALT(DEF_ASM_OP1(lcall, 0xff, 3, OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(ljmp, 0xff, 5, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(ljmpw, 0x66ff, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(ljmpl, 0xff, 5, OPC_MODRM, OPT_EA)

		   ALT(DEF_ASM_OP1(int, 0xcd, 0, 0, OPT_IM8))
		   ALT(DEF_ASM_OP1(seto, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
		   ALT(DEF_ASM_OP1(setob, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
		   DEF_ASM_OP2(enter, 0xc8, 0, 0, OPT_IM16, OPT_IM8)
		   DEF_ASM_OP0(leave, 0xc9)
		   DEF_ASM_OP0(ret, 0xc3)
		   DEF_ASM_OP0(retq, 0xc3)
		   ALT(DEF_ASM_OP1(retq, 0xc2, 0, 0, OPT_IM16))
		   ALT(DEF_ASM_OP1(ret, 0xc2, 0, 0, OPT_IM16))
		   DEF_ASM_OP0(lret, 0xcb)
		   ALT(DEF_ASM_OP1(lret, 0xca, 0, 0, OPT_IM16))

		   ALT(DEF_ASM_OP1(jo, 0x70, 0, OPC_TEST, OPT_DISP8))
		   DEF_ASM_OP1(loopne, 0xe0, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loopnz, 0xe0, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loope, 0xe1, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loopz, 0xe1, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loop, 0xe2, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(jecxz, 0x67e3, 0, 0, OPT_DISP8)
		   /* float */
		   /* specific fcomp handling */

		   ALT(DEF_ASM_OP0L(fcomp, 0xd8d9, 0, 0))

		   ALT(DEF_ASM_OP1(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST))
		   ALT(DEF_ASM_OP2(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
		   ALT(DEF_ASM_OP2(fadd, 0xdcc0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP2(fmul, 0xdcc8, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP0L(fadd, 0xdec1, 0, OPC_FARITH))
		   ALT(DEF_ASM_OP1(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST))
		   ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
		   ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP0L(faddp, 0xdec1, 0, OPC_FARITH))
		   ALT(DEF_ASM_OP1(fadds, 0xd8, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(fiaddl, 0xda, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(faddl, 0xdc, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(fiadds, 0xde, 0, OPC_FARITH | OPC_MODRM, OPT_EA))

		   DEF_ASM_OP0(fucompp, 0xdae9)
		   DEF_ASM_OP0(ftst, 0xd9e4)
		   DEF_ASM_OP0(fxam, 0xd9e5)
		   DEF_ASM_OP0(fld1, 0xd9e8)
		   DEF_ASM_OP0(fldl2t, 0xd9e9)
		   DEF_ASM_OP0(fldl2e, 0xd9ea)
		   DEF_ASM_OP0(fldpi, 0xd9eb)
		   DEF_ASM_OP0(fldlg2, 0xd9ec)
		   DEF_ASM_OP0(fldln2, 0xd9ed)
		   DEF_ASM_OP0(fldz, 0xd9ee)

		   DEF_ASM_OP0(f2xm1, 0xd9f0)
		   DEF_ASM_OP0(fyl2x, 0xd9f1)
		   DEF_ASM_OP0(fptan, 0xd9f2)
		   DEF_ASM_OP0(fpatan, 0xd9f3)
		   DEF_ASM_OP0(fxtract, 0xd9f4)
		   DEF_ASM_OP0(fprem1, 0xd9f5)
		   DEF_ASM_OP0(fdecstp, 0xd9f6)
		   DEF_ASM_OP0(fincstp, 0xd9f7)
		   DEF_ASM_OP0(fprem, 0xd9f8)
		   DEF_ASM_OP0(fyl2xp1, 0xd9f9)
		   DEF_ASM_OP0(fsqrt, 0xd9fa)
		   DEF_ASM_OP0(fsincos, 0xd9fb)
		   DEF_ASM_OP0(frndint, 0xd9fc)
		   DEF_ASM_OP0(fscale, 0xd9fd)
		   DEF_ASM_OP0(fsin, 0xd9fe)
		   DEF_ASM_OP0(fcos, 0xd9ff)
		   DEF_ASM_OP0(fchs, 0xd9e0)
		   DEF_ASM_OP0(fabs, 0xd9e1)
		   DEF_ASM_OP0(fninit, 0xdbe3)
		   DEF_ASM_OP0(fnclex, 0xdbe2)
		   DEF_ASM_OP0(fnop, 0xd9d0)
		   DEF_ASM_OP0(fwait, 0x9b)
		   /* fp load */

		   DEF_ASM_OP1(fld, 0xd9c0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fldl, 0xd9c0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(flds, 0xd9, 0, OPC_MODRM, OPT_EA)
		   ALT(DEF_ASM_OP1(fldl, 0xdd, 0, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(fildl, 0xdb, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fildq, 0xdf, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fildll, 0xdf, 5, OPC_MODRM,OPT_EA)
		   DEF_ASM_OP1(fldt, 0xdb, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fbld, 0xdf, 4, OPC_MODRM, OPT_EA)
		   /* fp store */

		   DEF_ASM_OP1(fst, 0xddd0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fstl, 0xddd0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fsts, 0xd9, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fstps, 0xd9, 3, OPC_MODRM, OPT_EA)
		   ALT(DEF_ASM_OP1(fstl, 0xdd, 2, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(fstpl, 0xdd, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fist, 0xdf, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistp, 0xdf, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistl, 0xdb, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistpl, 0xdb, 3, OPC_MODRM, OPT_EA)

		   DEF_ASM_OP1(fstp, 0xddd8, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fistpq, 0xdf, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistpll, 0xdf, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fstpt, 0xdb, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fbstp, 0xdf, 6, OPC_MODRM, OPT_EA)
		   /* exchange */

		   DEF_ASM_OP0(fxch, 0xd9c9)
		   ALT(DEF_ASM_OP1(fxch, 0xd9c8, 0, OPC_REG, OPT_ST))
		   /* misc FPU */

		   DEF_ASM_OP1(fucom, 0xdde0, 0, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(fucomp, 0xdde8, 0, OPC_REG, OPT_ST )

		   DEF_ASM_OP0L(finit, 0xdbe3, 0, OPC_FWAIT)
		   DEF_ASM_OP1(fldcw, 0xd9, 5, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fnstcw, 0xd9, 7, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fstcw, 0xd9, 7, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP0(fnstsw, 0xdfe0)
		   ALT(DEF_ASM_OP1(fnstsw, 0xdfe0, 0, 0, OPT_EAX ))
		   ALT(DEF_ASM_OP1(fnstsw, 0xdd, 7, OPC_MODRM, OPT_EA ))
		   DEF_ASM_OP1(fstsw, 0xdfe0, 0, OPC_FWAIT, OPT_EAX )
		   ALT(DEF_ASM_OP0L(fstsw, 0xdfe0, 0, OPC_FWAIT))
		   ALT(DEF_ASM_OP1(fstsw, 0xdd, 7, OPC_MODRM | OPC_FWAIT, OPT_EA ))
		   DEF_ASM_OP0L(fclex, 0xdbe2, 0, OPC_FWAIT)
		   DEF_ASM_OP1(fnstenv, 0xd9, 6, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fstenv, 0xd9, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP1(fldenv, 0xd9, 4, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fnsave, 0xdd, 6, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fsave, 0xdd, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP1(frstor, 0xdd, 4, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(ffree, 0xddc0, 4, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(ffreep, 0xdfc0, 4, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(fxsave, 0x0fae, 0, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fxrstor, 0x0fae, 1, OPC_MODRM, OPT_EA )
		   /* The *q forms of fxrstor/fxsave use a REX prefix.
		          If the operand would use extended registers we would have to modify
		          it instead of generating a second one.  Currently that's no
		          problem with TCC, we don't use extended registers.  */

		   DEF_ASM_OP1(fxsaveq, 0x0fae, 0, OPC_MODRM | OPC_48, OPT_EA )
		   DEF_ASM_OP1(fxrstorq, 0x0fae, 1, OPC_MODRM | OPC_48, OPT_EA )
		   /* segments */

		   DEF_ASM_OP2(arpl, 0x63, 0, OPC_MODRM, OPT_REG16, OPT_REG16 | OPT_EA)
		   ALT(DEF_ASM_OP2(larw, 0x0f02, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA, OPT_REG))
		   DEF_ASM_OP1(lgdt, 0x0f01, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lgdtq, 0x0f01, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lidt, 0x0f01, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lidtq, 0x0f01, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lldt, 0x0f00, 2, OPC_MODRM, OPT_EA | OPT_REG)
		   DEF_ASM_OP1(lmsw, 0x0f01, 6, OPC_MODRM, OPT_EA | OPT_REG)
		   ALT(DEF_ASM_OP2(lslw, 0x0f03, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_REG))
		   DEF_ASM_OP1(ltr, 0x0f00, 3, OPC_MODRM, OPT_EA | OPT_REG16)
		   DEF_ASM_OP1(sgdt, 0x0f01, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sgdtq, 0x0f01, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sidt, 0x0f01, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sidtq, 0x0f01, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sldt, 0x0f00, 0, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(smsw, 0x0f01, 4, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM, OPT_REG32 | OPT_EA)
		   ALT(DEF_ASM_OP1(str, 0x660f00, 1, OPC_MODRM, OPT_REG16))
		   ALT(DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM | OPC_48, OPT_REG64))
		   DEF_ASM_OP1(verr, 0x0f00, 4, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(verw, 0x0f00, 5, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP0L(swapgs, 0x0f01, 7, OPC_MODRM)
		   /* 486 */
		   /* bswap can't be applied to 16bit regs */

		   DEF_ASM_OP1(bswap, 0x0fc8, 0, OPC_REG, OPT_REG32 )
		   DEF_ASM_OP1(bswapl, 0x0fc8, 0, OPC_REG, OPT_REG32 )
		   DEF_ASM_OP1(bswapq, 0x0fc8, 0, OPC_REG | OPC_48, OPT_REG64 )

		   ALT(DEF_ASM_OP2(xaddb, 0x0fc0, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_REG | OPT_EA ))
		   ALT(DEF_ASM_OP2(cmpxchgb, 0x0fb0, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_REG | OPT_EA ))
		   DEF_ASM_OP1(invlpg, 0x0f01, 7, OPC_MODRM, OPT_EA )
		   /* pentium */

		   DEF_ASM_OP1(cmpxchg8b, 0x0fc7, 1, OPC_MODRM, OPT_EA )
		   /* AMD 64 */

		   DEF_ASM_OP1(cmpxchg16b, 0x0fc7, 1, OPC_MODRM | OPC_48, OPT_EA )
		   /* pentium pro */

		   ALT(DEF_ASM_OP2(cmovo, 0x0f40, 0, OPC_MODRM | OPC_TEST | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   DEF_ASM_OP2(fcmovb, 0xdac0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmove, 0xdac8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovbe, 0xdad0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovu, 0xdad8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnb, 0xdbc0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovne, 0xdbc8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnbe, 0xdbd0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnu, 0xdbd8, 0, OPC_REG, OPT_ST, OPT_ST0 )

		   DEF_ASM_OP2(fucomi, 0xdbe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcomi, 0xdbf0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fucomip, 0xdfe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcomip, 0xdff0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   /* mmx */

		   DEF_ASM_OP0(emms, 0x0f77)/* must be last OP0 */

		   DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_MMXSSE )
		   /* movd shouldn't accept REG64, but AMD64 spec uses it for 32 and 64 bit
		          moves, so let's be compatible. */

		   ALT(DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG64, OPT_MMXSSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f6e, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_MMXSSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f6f, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_MMX ))
		   ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG32 ))
		   ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))
		   ALT(DEF_ASM_OP2(movq, 0x0f7f, 0, OPC_MODRM, OPT_MMX, OPT_EA | OPT_MMX ))
		   ALT(DEF_ASM_OP2(movq, 0x660fd6, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_SSE ))
		   ALT(DEF_ASM_OP2(movq, 0xf30f7e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))

		   DEF_ASM_OP2(packssdw, 0x0f6b, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(packsswb, 0x0f63, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(packuswb, 0x0f67, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddb, 0x0ffc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddw, 0x0ffd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddd, 0x0ffe, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddsb, 0x0fec, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddsw, 0x0fed, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddusb, 0x0fdc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddusw, 0x0fdd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pand, 0x0fdb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pandn, 0x0fdf, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqb, 0x0f74, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqw, 0x0f75, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqd, 0x0f76, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtb, 0x0f64, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtw, 0x0f65, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtd, 0x0f66, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmaddwd, 0x0ff5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmulhw, 0x0fe5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmullw, 0x0fd5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(por, 0x0feb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psllw, 0x0ff1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psllw, 0x0f71, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(pslld, 0x0ff2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(pslld, 0x0f72, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psllq, 0x0ff3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psllq, 0x0f73, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psraw, 0x0fe1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psraw, 0x0f71, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrad, 0x0fe2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrad, 0x0f72, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrlw, 0x0fd1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrlw, 0x0f71, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrld, 0x0fd2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrld, 0x0f72, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrlq, 0x0fd3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrlq, 0x0f73, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psubb, 0x0ff8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubw, 0x0ff9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubd, 0x0ffa, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubsb, 0x0fe8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubsw, 0x0fe9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubusb, 0x0fd8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubusw, 0x0fd9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhbw, 0x0f68, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhwd, 0x0f69, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhdq, 0x0f6a, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpcklbw, 0x0f60, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpcklwd, 0x0f61, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckldq, 0x0f62, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pxor, 0x0fef, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   /* sse */

		   DEF_ASM_OP1(ldmxcsr, 0x0fae, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(stmxcsr, 0x0fae, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP2(movups, 0x0f10, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movups, 0x0f11, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(movaps, 0x0f28, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movaps, 0x0f29, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(movhps, 0x0f16, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movhps, 0x0f17, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(addps, 0x0f58, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(cvtpi2ps, 0x0f2a, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_SSE )
		   DEF_ASM_OP2(cvtps2pi, 0x0f2d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
		   DEF_ASM_OP2(cvttps2pi, 0x0f2c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
		   DEF_ASM_OP2(divps, 0x0f5e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(maxps, 0x0f5f, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(minps, 0x0f5d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(mulps, 0x0f59, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pavgb, 0x0fe0, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pavgw, 0x0fe3, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pmaxsw, 0x0fee, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmaxub, 0x0fde, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pminsw, 0x0fea, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pminub, 0x0fda, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(rcpss, 0x0f53, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(rsqrtps, 0x0f52, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(sqrtps, 0x0f51, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(subps, 0x0f5c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   /* movnti should only accept REG32 and REG64, we accept more */

		   DEF_ASM_OP2(movnti, 0x0fc3, 0, OPC_MODRM, OPT_REG, OPT_EA)
		   DEF_ASM_OP2(movntil, 0x0fc3, 0, OPC_MODRM, OPT_REG32, OPT_EA)
		   DEF_ASM_OP2(movntiq, 0x0fc3, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_EA)
		   DEF_ASM_OP1(prefetchnta, 0x0f18, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht0, 0x0f18, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht1, 0x0f18, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht2, 0x0f18, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetchw, 0x0f0d, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP0L(lfence, 0x0fae, 5, OPC_MODRM)
		   DEF_ASM_OP0L(mfence, 0x0fae, 6, OPC_MODRM)
		   DEF_ASM_OP0L(sfence, 0x0fae, 7, OPC_MODRM)
		   DEF_ASM_OP1(clflush, 0x0fae, 7, OPC_MODRM, OPT_EA)
		   /* Control-Flow Enforcement */

		   DEF_ASM_OP0L(endbr64, 0xf30f1e, 7, OPC_MODRM)
#undef ALT
#undef DEF_ASM_OP0
#undef DEF_ASM_OP0L
#undef DEF_ASM_OP1
#undef DEF_ASM_OP2
#undef DEF_ASM_OP3
// 318 "i386-tok.h" 2

#define ALT(x)
#define DEF_ASM_OP0(name,opcode)
#define DEF_ASM_OP0L(name,opcode,group,instr_type) DEF_ASM(name)
#define DEF_ASM_OP1(name,opcode,group,instr_type,op0) DEF_ASM(name)
#define DEF_ASM_OP2(name,opcode,group,instr_type,op0,op1) DEF_ASM(name)
#define DEF_ASM_OP3(name,opcode,group,instr_type,op0,op1,op2) DEF_ASM(name)

// 1 "x86_64-asm.h" 1
		   DEF_ASM_OP0(clc, 0xf8)/* must be first OP0 */

		   DEF_ASM_OP0(cld, 0xfc)
		   DEF_ASM_OP0(cli, 0xfa)
		   DEF_ASM_OP0(clts, 0x0f06)
		   DEF_ASM_OP0(cmc, 0xf5)
		   DEF_ASM_OP0(lahf, 0x9f)
		   DEF_ASM_OP0(sahf, 0x9e)
		   DEF_ASM_OP0(pushfq, 0x9c)
		   DEF_ASM_OP0(popfq, 0x9d)
		   DEF_ASM_OP0(pushf, 0x9c)
		   DEF_ASM_OP0(popf, 0x9d)
		   DEF_ASM_OP0(stc, 0xf9)
		   DEF_ASM_OP0(std, 0xfd)
		   DEF_ASM_OP0(sti, 0xfb)
		   DEF_ASM_OP0(aaa, 0x37)
		   DEF_ASM_OP0(aas, 0x3f)
		   DEF_ASM_OP0(daa, 0x27)
		   DEF_ASM_OP0(das, 0x2f)
		   DEF_ASM_OP0(aad, 0xd50a)
		   DEF_ASM_OP0(aam, 0xd40a)
		   DEF_ASM_OP0(cbw, 0x6698)
		   DEF_ASM_OP0(cwd, 0x6699)
		   DEF_ASM_OP0(cwde, 0x98)
		   DEF_ASM_OP0(cdq, 0x99)
		   DEF_ASM_OP0(cbtw, 0x6698)
		   DEF_ASM_OP0(cwtl, 0x98)
		   DEF_ASM_OP0(cwtd, 0x6699)
		   DEF_ASM_OP0(cltd, 0x99)
		   DEF_ASM_OP0(cqto, 0x4899)
		   DEF_ASM_OP0(int3, 0xcc)
		   DEF_ASM_OP0(into, 0xce)
		   DEF_ASM_OP0(iret, 0xcf)
		   DEF_ASM_OP0(iretw, 0x66cf)
		   DEF_ASM_OP0(iretl, 0xcf)
		   DEF_ASM_OP0(iretq, 0x48cf)
		   DEF_ASM_OP0(rsm, 0x0faa)
		   DEF_ASM_OP0(hlt, 0xf4)
		   DEF_ASM_OP0(wait, 0x9b)
		   DEF_ASM_OP0(nop, 0x90)
		   DEF_ASM_OP0(pause, 0xf390)
		   DEF_ASM_OP0(xlat, 0xd7)

		   DEF_ASM_OP0L(vmcall, 0xc1, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmlaunch, 0xc2, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmresume, 0xc3, 0, OPC_0F01)
		   DEF_ASM_OP0L(vmxoff, 0xc4, 0, OPC_0F01)
		   /* strings */

		   ALT(DEF_ASM_OP0L(cmpsb, 0xa6, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(scmpb, 0xa6, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(insb, 0x6c, 0, OPC_BWL))
		   ALT(DEF_ASM_OP0L(outsb, 0x6e, 0, OPC_BWL))

		   ALT(DEF_ASM_OP0L(lodsb, 0xac, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(slodb, 0xac, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(movsb, 0xa4, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(smovb, 0xa4, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(scasb, 0xae, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(sscab, 0xae, 0, OPC_BWLX))

		   ALT(DEF_ASM_OP0L(stosb, 0xaa, 0, OPC_BWLX))
		   ALT(DEF_ASM_OP0L(sstob, 0xaa, 0, OPC_BWLX))
		   /* bits */

		   ALT(DEF_ASM_OP2(bsfw, 0x0fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(bsrw, 0x0fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   ALT(DEF_ASM_OP2(btw, 0x0fa3, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btw, 0x0fba, 4, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btsw, 0x0fab, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btsw, 0x0fba, 5, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btrw, 0x0fb3, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btrw, 0x0fba, 6, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(btcw, 0x0fbb, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP2(btcw, 0x0fba, 7, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW | OPT_EA))

		   ALT(DEF_ASM_OP2(popcntw, 0xf30fb8, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   ALT(DEF_ASM_OP2(tzcntw, 0xf30fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(lzcntw, 0xf30fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))
		   /* prefixes */

		   DEF_ASM_OP0(lock, 0xf0)
		   DEF_ASM_OP0(rep, 0xf3)
		   DEF_ASM_OP0(repe, 0xf3)
		   DEF_ASM_OP0(repz, 0xf3)
		   DEF_ASM_OP0(repne, 0xf2)
		   DEF_ASM_OP0(repnz, 0xf2)

		   DEF_ASM_OP0(invd, 0x0f08)
		   DEF_ASM_OP0(wbinvd, 0x0f09)
		   DEF_ASM_OP0(cpuid, 0x0fa2)
		   DEF_ASM_OP0(wrmsr, 0x0f30)
		   DEF_ASM_OP0(rdtsc, 0x0f31)
		   DEF_ASM_OP0(rdmsr, 0x0f32)
		   DEF_ASM_OP0(rdpmc, 0x0f33)

		   DEF_ASM_OP0(syscall, 0x0f05)
		   DEF_ASM_OP0(sysret, 0x0f07)
		   DEF_ASM_OP0L(sysretq, 0x480f07, 0, 0)
		   DEF_ASM_OP0(ud2, 0x0f0b)
		   /* NOTE: we took the same order as gas opcode definition order */
		   /* Right now we can't express the fact that 0xa1/0xa3 can't use $eax and a
		      32 bit moffset as operands.
		   ALT(DEF_ASM_OP2(movb, 0xa0, 0, OPC_BWLX, OPT_ADDR, OPT_EAX))
		   ALT(DEF_ASM_OP2(movb, 0xa2, 0, OPC_BWLX, OPT_EAX, OPT_ADDR)) */

		   ALT(DEF_ASM_OP2(movb, 0x88, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(movb, 0x8a, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   /* The moves are special: the 0xb8 form supports IM64 (the only insn that
		      does) with REG64.  It doesn't support IM32 with REG64, it would use
		      the full movabs form (64bit immediate).  For IM32->REG64 we prefer
		      the 0xc7 opcode.  So disallow all 64bit forms and code the rest by hand. */

		   ALT(DEF_ASM_OP2(movb, 0xb0, 0, OPC_REG | OPC_BWLX, OPT_IM, OPT_REG))
		   ALT(DEF_ASM_OP2(mov, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
		   ALT(DEF_ASM_OP2(movq, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
		   ALT(DEF_ASM_OP2(movb, 0xc6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP2(movw, 0x8c, 0, OPC_MODRM | OPC_WLX, OPT_SEG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(movw, 0x8e, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_SEG))

		   ALT(DEF_ASM_OP2(movw, 0x0f20, 0, OPC_MODRM | OPC_WLX, OPT_CR, OPT_REG64))
		   ALT(DEF_ASM_OP2(movw, 0x0f21, 0, OPC_MODRM | OPC_WLX, OPT_DB, OPT_REG64))
		   ALT(DEF_ASM_OP2(movw, 0x0f22, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_CR))
		   ALT(DEF_ASM_OP2(movw, 0x0f23, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_DB))

		   ALT(DEF_ASM_OP2(movsbw, 0x660fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG16))
		   ALT(DEF_ASM_OP2(movsbl, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movsbq, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(movswl, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movswq, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP2(movslq, 0x63, 0, OPC_MODRM, OPT_REG32 | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP2(movzbw, 0x0fb6, 0, OPC_MODRM | OPC_WLX, OPT_REG8 | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(movzwl, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(movzwq, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))

		   ALT(DEF_ASM_OP1(pushq, 0x6a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(push, 0x6a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(pushw, 0x666a, 0, 0, OPT_IM8S))
		   ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG64))
		   ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG16))
		   ALT(DEF_ASM_OP1(pushw, 0xff, 6, OPC_MODRM | OPC_WLX, OPT_REG64 | OPT_EA))
		   ALT(DEF_ASM_OP1(pushw, 0x6668, 0, 0, OPT_IM16))
		   ALT(DEF_ASM_OP1(pushw, 0x68, 0, OPC_WLX, OPT_IM32))
		   ALT(DEF_ASM_OP1(pushw, 0x06, 0, OPC_WLX, OPT_SEG))

		   ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG64))
		   ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG16))
		   ALT(DEF_ASM_OP1(popw, 0x8f, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA))
		   ALT(DEF_ASM_OP1(popw, 0x07, 0, OPC_WLX, OPT_SEG))

		   ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_REGW, OPT_EAX))
		   ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_EAX, OPT_REGW))
		   ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))

		   ALT(DEF_ASM_OP2(inb, 0xe4, 0, OPC_BWL, OPT_IM8, OPT_EAX))
		   ALT(DEF_ASM_OP1(inb, 0xe4, 0, OPC_BWL, OPT_IM8))
		   ALT(DEF_ASM_OP2(inb, 0xec, 0, OPC_BWL, OPT_DX, OPT_EAX))
		   ALT(DEF_ASM_OP1(inb, 0xec, 0, OPC_BWL, OPT_DX))

		   ALT(DEF_ASM_OP2(outb, 0xe6, 0, OPC_BWL, OPT_EAX, OPT_IM8))
		   ALT(DEF_ASM_OP1(outb, 0xe6, 0, OPC_BWL, OPT_IM8))
		   ALT(DEF_ASM_OP2(outb, 0xee, 0, OPC_BWL, OPT_EAX, OPT_DX))
		   ALT(DEF_ASM_OP1(outb, 0xee, 0, OPC_BWL, OPT_DX))

		   ALT(DEF_ASM_OP2(leaw, 0x8d, 0, OPC_MODRM | OPC_WLX, OPT_EA, OPT_REG))

		   ALT(DEF_ASM_OP2(les, 0xc4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lds, 0xc5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lss, 0x0fb2, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lfs, 0x0fb4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   ALT(DEF_ASM_OP2(lgs, 0x0fb5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
		   /* arith */

		   ALT(DEF_ASM_OP2(addb, 0x00, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))/* XXX: use D bit ? */

		   ALT(DEF_ASM_OP2(addb, 0x02, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   ALT(DEF_ASM_OP2(addb, 0x04, 0, OPC_ARITH | OPC_BWLX, OPT_IM, OPT_EAX))
		   ALT(DEF_ASM_OP2(addw, 0x83, 0, OPC_ARITH | OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(addb, 0x80, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
		   ALT(DEF_ASM_OP2(testb, 0xa8, 0, OPC_BWLX, OPT_IM, OPT_EAX))
		   ALT(DEF_ASM_OP2(testb, 0xf6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP1(incb, 0xfe, 0, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(decb, 0xfe, 1, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP1(notb, 0xf6, 2, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(negb, 0xf6, 3, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP1(mulb, 0xf6, 4, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP1(imulb, 0xf6, 5, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

		   ALT(DEF_ASM_OP2(imulw, 0x0faf, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA, OPT_REG))
		   ALT(DEF_ASM_OP3(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW))
		   ALT(DEF_ASM_OP3(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW | OPT_EA, OPT_REGW))
		   ALT(DEF_ASM_OP2(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW))

		   ALT(DEF_ASM_OP1(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP2(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
		   ALT(DEF_ASM_OP1(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
		   ALT(DEF_ASM_OP2(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
		   /* shifts */

		   ALT(DEF_ASM_OP2(rolb, 0xc0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_IM8, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP2(rolb, 0xd2, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_CL, OPT_EA | OPT_REG))
		   ALT(DEF_ASM_OP1(rolb, 0xd0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_EA | OPT_REG))

		   ALT(DEF_ASM_OP3(shldw, 0x0fa4, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shrdw, 0x0fac, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP3(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW, OPT_EA | OPT_REGW))
		   ALT(DEF_ASM_OP2(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_REGW, OPT_EA | OPT_REGW))

		   ALT(DEF_ASM_OP1(call, 0xff, 2, OPC_MODRM, OPT_INDIR))
		   ALT(DEF_ASM_OP1(call, 0xe8, 0, 0, OPT_DISP))
		   DEF_ASM_OP1(callq, 0xff, 2, OPC_MODRM, OPT_INDIR)
		   ALT(DEF_ASM_OP1(callq, 0xe8, 0, 0, OPT_DISP))
		   ALT(DEF_ASM_OP1(jmp, 0xff, 4, OPC_MODRM, OPT_INDIR))
		   ALT(DEF_ASM_OP1(jmp, 0xeb, 0, 0, OPT_DISP8))

		   ALT(DEF_ASM_OP1(lcall, 0xff, 3, OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(ljmp, 0xff, 5, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(ljmpw, 0x66ff, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(ljmpl, 0xff, 5, OPC_MODRM, OPT_EA)

		   ALT(DEF_ASM_OP1(int, 0xcd, 0, 0, OPT_IM8))
		   ALT(DEF_ASM_OP1(seto, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
		   ALT(DEF_ASM_OP1(setob, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
		   DEF_ASM_OP2(enter, 0xc8, 0, 0, OPT_IM16, OPT_IM8)
		   DEF_ASM_OP0(leave, 0xc9)
		   DEF_ASM_OP0(ret, 0xc3)
		   DEF_ASM_OP0(retq, 0xc3)
		   ALT(DEF_ASM_OP1(retq, 0xc2, 0, 0, OPT_IM16))
		   ALT(DEF_ASM_OP1(ret, 0xc2, 0, 0, OPT_IM16))
		   DEF_ASM_OP0(lret, 0xcb)
		   ALT(DEF_ASM_OP1(lret, 0xca, 0, 0, OPT_IM16))

		   ALT(DEF_ASM_OP1(jo, 0x70, 0, OPC_TEST, OPT_DISP8))
		   DEF_ASM_OP1(loopne, 0xe0, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loopnz, 0xe0, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loope, 0xe1, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loopz, 0xe1, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(loop, 0xe2, 0, 0, OPT_DISP8)
		   DEF_ASM_OP1(jecxz, 0x67e3, 0, 0, OPT_DISP8)
		   /* float */
		   /* specific fcomp handling */

		   ALT(DEF_ASM_OP0L(fcomp, 0xd8d9, 0, 0))

		   ALT(DEF_ASM_OP1(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST))
		   ALT(DEF_ASM_OP2(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
		   ALT(DEF_ASM_OP2(fadd, 0xdcc0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP2(fmul, 0xdcc8, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP0L(fadd, 0xdec1, 0, OPC_FARITH))
		   ALT(DEF_ASM_OP1(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST))
		   ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
		   ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
		   ALT(DEF_ASM_OP0L(faddp, 0xdec1, 0, OPC_FARITH))
		   ALT(DEF_ASM_OP1(fadds, 0xd8, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(fiaddl, 0xda, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(faddl, 0xdc, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
		   ALT(DEF_ASM_OP1(fiadds, 0xde, 0, OPC_FARITH | OPC_MODRM, OPT_EA))

		   DEF_ASM_OP0(fucompp, 0xdae9)
		   DEF_ASM_OP0(ftst, 0xd9e4)
		   DEF_ASM_OP0(fxam, 0xd9e5)
		   DEF_ASM_OP0(fld1, 0xd9e8)
		   DEF_ASM_OP0(fldl2t, 0xd9e9)
		   DEF_ASM_OP0(fldl2e, 0xd9ea)
		   DEF_ASM_OP0(fldpi, 0xd9eb)
		   DEF_ASM_OP0(fldlg2, 0xd9ec)
		   DEF_ASM_OP0(fldln2, 0xd9ed)
		   DEF_ASM_OP0(fldz, 0xd9ee)

		   DEF_ASM_OP0(f2xm1, 0xd9f0)
		   DEF_ASM_OP0(fyl2x, 0xd9f1)
		   DEF_ASM_OP0(fptan, 0xd9f2)
		   DEF_ASM_OP0(fpatan, 0xd9f3)
		   DEF_ASM_OP0(fxtract, 0xd9f4)
		   DEF_ASM_OP0(fprem1, 0xd9f5)
		   DEF_ASM_OP0(fdecstp, 0xd9f6)
		   DEF_ASM_OP0(fincstp, 0xd9f7)
		   DEF_ASM_OP0(fprem, 0xd9f8)
		   DEF_ASM_OP0(fyl2xp1, 0xd9f9)
		   DEF_ASM_OP0(fsqrt, 0xd9fa)
		   DEF_ASM_OP0(fsincos, 0xd9fb)
		   DEF_ASM_OP0(frndint, 0xd9fc)
		   DEF_ASM_OP0(fscale, 0xd9fd)
		   DEF_ASM_OP0(fsin, 0xd9fe)
		   DEF_ASM_OP0(fcos, 0xd9ff)
		   DEF_ASM_OP0(fchs, 0xd9e0)
		   DEF_ASM_OP0(fabs, 0xd9e1)
		   DEF_ASM_OP0(fninit, 0xdbe3)
		   DEF_ASM_OP0(fnclex, 0xdbe2)
		   DEF_ASM_OP0(fnop, 0xd9d0)
		   DEF_ASM_OP0(fwait, 0x9b)
		   /* fp load */

		   DEF_ASM_OP1(fld, 0xd9c0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fldl, 0xd9c0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(flds, 0xd9, 0, OPC_MODRM, OPT_EA)
		   ALT(DEF_ASM_OP1(fldl, 0xdd, 0, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(fildl, 0xdb, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fildq, 0xdf, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fildll, 0xdf, 5, OPC_MODRM,OPT_EA)
		   DEF_ASM_OP1(fldt, 0xdb, 5, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fbld, 0xdf, 4, OPC_MODRM, OPT_EA)
		   /* fp store */

		   DEF_ASM_OP1(fst, 0xddd0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fstl, 0xddd0, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fsts, 0xd9, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fstps, 0xd9, 3, OPC_MODRM, OPT_EA)
		   ALT(DEF_ASM_OP1(fstl, 0xdd, 2, OPC_MODRM, OPT_EA))
		   DEF_ASM_OP1(fstpl, 0xdd, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fist, 0xdf, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistp, 0xdf, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistl, 0xdb, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistpl, 0xdb, 3, OPC_MODRM, OPT_EA)

		   DEF_ASM_OP1(fstp, 0xddd8, 0, OPC_REG, OPT_ST)
		   DEF_ASM_OP1(fistpq, 0xdf, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fistpll, 0xdf, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fstpt, 0xdb, 7, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(fbstp, 0xdf, 6, OPC_MODRM, OPT_EA)
		   /* exchange */

		   DEF_ASM_OP0(fxch, 0xd9c9)
		   ALT(DEF_ASM_OP1(fxch, 0xd9c8, 0, OPC_REG, OPT_ST))
		   /* misc FPU */

		   DEF_ASM_OP1(fucom, 0xdde0, 0, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(fucomp, 0xdde8, 0, OPC_REG, OPT_ST )

		   DEF_ASM_OP0L(finit, 0xdbe3, 0, OPC_FWAIT)
		   DEF_ASM_OP1(fldcw, 0xd9, 5, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fnstcw, 0xd9, 7, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fstcw, 0xd9, 7, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP0(fnstsw, 0xdfe0)
		   ALT(DEF_ASM_OP1(fnstsw, 0xdfe0, 0, 0, OPT_EAX ))
		   ALT(DEF_ASM_OP1(fnstsw, 0xdd, 7, OPC_MODRM, OPT_EA ))
		   DEF_ASM_OP1(fstsw, 0xdfe0, 0, OPC_FWAIT, OPT_EAX )
		   ALT(DEF_ASM_OP0L(fstsw, 0xdfe0, 0, OPC_FWAIT))
		   ALT(DEF_ASM_OP1(fstsw, 0xdd, 7, OPC_MODRM | OPC_FWAIT, OPT_EA ))
		   DEF_ASM_OP0L(fclex, 0xdbe2, 0, OPC_FWAIT)
		   DEF_ASM_OP1(fnstenv, 0xd9, 6, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fstenv, 0xd9, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP1(fldenv, 0xd9, 4, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fnsave, 0xdd, 6, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fsave, 0xdd, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
		   DEF_ASM_OP1(frstor, 0xdd, 4, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(ffree, 0xddc0, 4, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(ffreep, 0xdfc0, 4, OPC_REG, OPT_ST )
		   DEF_ASM_OP1(fxsave, 0x0fae, 0, OPC_MODRM, OPT_EA )
		   DEF_ASM_OP1(fxrstor, 0x0fae, 1, OPC_MODRM, OPT_EA )
		   /* The *q forms of fxrstor/fxsave use a REX prefix.
		          If the operand would use extended registers we would have to modify
		          it instead of generating a second one.  Currently that's no
		          problem with TCC, we don't use extended registers.  */

		   DEF_ASM_OP1(fxsaveq, 0x0fae, 0, OPC_MODRM | OPC_48, OPT_EA )
		   DEF_ASM_OP1(fxrstorq, 0x0fae, 1, OPC_MODRM | OPC_48, OPT_EA )
		   /* segments */

		   DEF_ASM_OP2(arpl, 0x63, 0, OPC_MODRM, OPT_REG16, OPT_REG16 | OPT_EA)
		   ALT(DEF_ASM_OP2(larw, 0x0f02, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA, OPT_REG))
		   DEF_ASM_OP1(lgdt, 0x0f01, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lgdtq, 0x0f01, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lidt, 0x0f01, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lidtq, 0x0f01, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(lldt, 0x0f00, 2, OPC_MODRM, OPT_EA | OPT_REG)
		   DEF_ASM_OP1(lmsw, 0x0f01, 6, OPC_MODRM, OPT_EA | OPT_REG)
		   ALT(DEF_ASM_OP2(lslw, 0x0f03, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_REG))
		   DEF_ASM_OP1(ltr, 0x0f00, 3, OPC_MODRM, OPT_EA | OPT_REG16)
		   DEF_ASM_OP1(sgdt, 0x0f01, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sgdtq, 0x0f01, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sidt, 0x0f01, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sidtq, 0x0f01, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(sldt, 0x0f00, 0, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(smsw, 0x0f01, 4, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM, OPT_REG32 | OPT_EA)
		   ALT(DEF_ASM_OP1(str, 0x660f00, 1, OPC_MODRM, OPT_REG16))
		   ALT(DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM | OPC_48, OPT_REG64))
		   DEF_ASM_OP1(verr, 0x0f00, 4, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP1(verw, 0x0f00, 5, OPC_MODRM, OPT_REG | OPT_EA)
		   DEF_ASM_OP0L(swapgs, 0x0f01, 7, OPC_MODRM)
		   /* 486 */
		   /* bswap can't be applied to 16bit regs */

		   DEF_ASM_OP1(bswap, 0x0fc8, 0, OPC_REG, OPT_REG32 )
		   DEF_ASM_OP1(bswapl, 0x0fc8, 0, OPC_REG, OPT_REG32 )
		   DEF_ASM_OP1(bswapq, 0x0fc8, 0, OPC_REG | OPC_48, OPT_REG64 )

		   ALT(DEF_ASM_OP2(xaddb, 0x0fc0, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_REG | OPT_EA ))
		   ALT(DEF_ASM_OP2(cmpxchgb, 0x0fb0, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_REG | OPT_EA ))
		   DEF_ASM_OP1(invlpg, 0x0f01, 7, OPC_MODRM, OPT_EA )
		   /* pentium */

		   DEF_ASM_OP1(cmpxchg8b, 0x0fc7, 1, OPC_MODRM, OPT_EA )
		   /* AMD 64 */

		   DEF_ASM_OP1(cmpxchg16b, 0x0fc7, 1, OPC_MODRM | OPC_48, OPT_EA )
		   /* pentium pro */

		   ALT(DEF_ASM_OP2(cmovo, 0x0f40, 0, OPC_MODRM | OPC_TEST | OPC_WLX, OPT_REGW | OPT_EA, OPT_REGW))

		   DEF_ASM_OP2(fcmovb, 0xdac0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmove, 0xdac8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovbe, 0xdad0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovu, 0xdad8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnb, 0xdbc0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovne, 0xdbc8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnbe, 0xdbd0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcmovnu, 0xdbd8, 0, OPC_REG, OPT_ST, OPT_ST0 )

		   DEF_ASM_OP2(fucomi, 0xdbe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcomi, 0xdbf0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fucomip, 0xdfe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   DEF_ASM_OP2(fcomip, 0xdff0, 0, OPC_REG, OPT_ST, OPT_ST0 )
		   /* mmx */

		   DEF_ASM_OP0(emms, 0x0f77)/* must be last OP0 */

		   DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_MMXSSE )
		   /* movd shouldn't accept REG64, but AMD64 spec uses it for 32 and 64 bit
		          moves, so let's be compatible. */

		   ALT(DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG64, OPT_MMXSSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f6e, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_MMXSSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f6f, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_MMX ))
		   ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG32 ))
		   ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))
		   ALT(DEF_ASM_OP2(movq, 0x0f7f, 0, OPC_MODRM, OPT_MMX, OPT_EA | OPT_MMX ))
		   ALT(DEF_ASM_OP2(movq, 0x660fd6, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_SSE ))
		   ALT(DEF_ASM_OP2(movq, 0xf30f7e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE ))
		   ALT(DEF_ASM_OP2(movq, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))

		   DEF_ASM_OP2(packssdw, 0x0f6b, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(packsswb, 0x0f63, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(packuswb, 0x0f67, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddb, 0x0ffc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddw, 0x0ffd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddd, 0x0ffe, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddsb, 0x0fec, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddsw, 0x0fed, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddusb, 0x0fdc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(paddusw, 0x0fdd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pand, 0x0fdb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pandn, 0x0fdf, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqb, 0x0f74, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqw, 0x0f75, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpeqd, 0x0f76, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtb, 0x0f64, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtw, 0x0f65, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pcmpgtd, 0x0f66, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmaddwd, 0x0ff5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmulhw, 0x0fe5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmullw, 0x0fd5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(por, 0x0feb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psllw, 0x0ff1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psllw, 0x0f71, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(pslld, 0x0ff2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(pslld, 0x0f72, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psllq, 0x0ff3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psllq, 0x0f73, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psraw, 0x0fe1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psraw, 0x0f71, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrad, 0x0fe2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrad, 0x0f72, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrlw, 0x0fd1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrlw, 0x0f71, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrld, 0x0fd2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrld, 0x0f72, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psrlq, 0x0fd3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   ALT(DEF_ASM_OP2(psrlq, 0x0f73, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
		   DEF_ASM_OP2(psubb, 0x0ff8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubw, 0x0ff9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubd, 0x0ffa, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubsb, 0x0fe8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubsw, 0x0fe9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubusb, 0x0fd8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(psubusw, 0x0fd9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhbw, 0x0f68, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhwd, 0x0f69, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckhdq, 0x0f6a, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpcklbw, 0x0f60, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpcklwd, 0x0f61, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(punpckldq, 0x0f62, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pxor, 0x0fef, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   /* sse */

		   DEF_ASM_OP1(ldmxcsr, 0x0fae, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(stmxcsr, 0x0fae, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP2(movups, 0x0f10, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movups, 0x0f11, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(movaps, 0x0f28, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movaps, 0x0f29, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(movhps, 0x0f16, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
		   ALT(DEF_ASM_OP2(movhps, 0x0f17, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
		   DEF_ASM_OP2(addps, 0x0f58, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(cvtpi2ps, 0x0f2a, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_SSE )
		   DEF_ASM_OP2(cvtps2pi, 0x0f2d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
		   DEF_ASM_OP2(cvttps2pi, 0x0f2c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
		   DEF_ASM_OP2(divps, 0x0f5e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(maxps, 0x0f5f, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(minps, 0x0f5d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(mulps, 0x0f59, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pavgb, 0x0fe0, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pavgw, 0x0fe3, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(pmaxsw, 0x0fee, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pmaxub, 0x0fde, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pminsw, 0x0fea, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(pminub, 0x0fda, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
		   DEF_ASM_OP2(rcpss, 0x0f53, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(rsqrtps, 0x0f52, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(sqrtps, 0x0f51, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   DEF_ASM_OP2(subps, 0x0f5c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
		   /* movnti should only accept REG32 and REG64, we accept more */

		   DEF_ASM_OP2(movnti, 0x0fc3, 0, OPC_MODRM, OPT_REG, OPT_EA)
		   DEF_ASM_OP2(movntil, 0x0fc3, 0, OPC_MODRM, OPT_REG32, OPT_EA)
		   DEF_ASM_OP2(movntiq, 0x0fc3, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_EA)
		   DEF_ASM_OP1(prefetchnta, 0x0f18, 0, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht0, 0x0f18, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht1, 0x0f18, 2, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetcht2, 0x0f18, 3, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP1(prefetchw, 0x0f0d, 1, OPC_MODRM, OPT_EA)
		   DEF_ASM_OP0L(lfence, 0x0fae, 5, OPC_MODRM)
		   DEF_ASM_OP0L(mfence, 0x0fae, 6, OPC_MODRM)
		   DEF_ASM_OP0L(sfence, 0x0fae, 7, OPC_MODRM)
		   DEF_ASM_OP1(clflush, 0x0fae, 7, OPC_MODRM, OPT_EA)
		   /* Control-Flow Enforcement */

		   DEF_ASM_OP0L(endbr64, 0xf30f1e, 7, OPC_MODRM)
#undef ALT
#undef DEF_ASM_OP0
#undef DEF_ASM_OP0L
#undef DEF_ASM_OP1
#undef DEF_ASM_OP2
#undef DEF_ASM_OP3
// 330 "i386-tok.h" 2
// 412 "tcctok.h" 2
// 1184 "tcc.h" 2
#undef DEF
};
/* keywords: tok >= TOK_IDENT && tok < TOK_UIDENT */

#define TOK_UIDENT TOK_DEFINE
/* ------------ libtcc.c ------------ */

ST_DATA struct TCCState *tcc_state;
ST_DATA void **stk_data;
ST_DATA int nb_stk_data;
ST_DATA int g_debug;
/* public functions currently used by the tcc main function */

ST_FUNC char *pstrcpy(char *buf, size_t buf_size, const char *s);
ST_FUNC char *pstrcat(char *buf, size_t buf_size, const char *s);
ST_FUNC char *pstrncpy(char *out, size_t buf_size, const char *s, size_t num);
PUB_FUNC char *tcc_basename(const char *name);
PUB_FUNC char *tcc_fileextension (const char *name);
/* all allocations - even MEM_DEBUG - use these */

PUB_FUNC void tcc_free(void *ptr);
PUB_FUNC void *tcc_malloc(unsigned long size);
PUB_FUNC void *tcc_mallocz(unsigned long size);
PUB_FUNC void *tcc_realloc(void *ptr, unsigned long size);
PUB_FUNC char *tcc_strdup(const char *str);
#ifdef MEM_DEBUG

#define tcc_free(ptr)           tcc_free_debug(ptr)
#define tcc_malloc(size)        tcc_malloc_debug(size, __FILE__, __LINE__)
#define tcc_mallocz(size)       tcc_mallocz_debug(size, __FILE__, __LINE__)
#define tcc_realloc(ptr,size)   tcc_realloc_debug(ptr, size, __FILE__, __LINE__)
#define tcc_strdup(str)         tcc_strdup_debug(str, __FILE__, __LINE__)
PUB_FUNC void tcc_free_debug(void *ptr);
PUB_FUNC void *tcc_malloc_debug(unsigned long size, const char *file, int line);
PUB_FUNC void *tcc_mallocz_debug(unsigned long size, const char *file,
				 int line);
PUB_FUNC void *tcc_realloc_debug(void *ptr, unsigned long size,
				 const char *file, int line);
PUB_FUNC char *tcc_strdup_debug(const char *str, const char *file, int line);
#endif
// 1224 "tcc.h"
ST_FUNC void libc_free(void *ptr);
#define free(p) use_tcc_free(p)
#define malloc(s) use_tcc_malloc(s)
#define realloc(p,s) use_tcc_realloc(p, s)
#undef strdup
#define strdup(s) use_tcc_strdup(s)
PUB_FUNC int _tcc_error_noabort(const char *fmt, ...) PRINTF_LIKE(1,2);
PUB_FUNC NORETURN void _tcc_error(const char *fmt, ...) PRINTF_LIKE(1,2);
PUB_FUNC void _tcc_warning(const char *fmt, ...) PRINTF_LIKE(1,2);

#define tcc_internal_error(msg) tcc_error("internal compiler error in %s:%d: %s", __FUNCTION__,__LINE__,msg)
/* other utilities */

ST_FUNC void dynarray_add(void *ptab, int *nb_ptr, void *data);
ST_FUNC void dynarray_reset(void *pp, int *n);
ST_INLN void cstr_ccat(CString *cstr, int ch);
ST_FUNC void cstr_cat(CString *cstr, const char *str, int len);
ST_FUNC void cstr_wccat(CString *cstr, int ch);
ST_FUNC void cstr_new(CString *cstr);
ST_FUNC void cstr_free(CString *cstr);
ST_FUNC int cstr_printf(CString *cs, const char *fmt, ...) PRINTF_LIKE(2,3);
ST_FUNC int cstr_vprintf(CString *cstr, const char *fmt, va_list ap);
ST_FUNC void cstr_reset(CString *cstr);
ST_FUNC void tcc_open_bf(TCCState *s1, const char *filename, int initlen);
ST_FUNC int tcc_open(TCCState *s1, const char *filename);
ST_FUNC void tcc_close(void);
/* mark a memory pointer on stack for cleanup after errors */

#define stk_push(p) dynarray_add(&stk_data, &nb_stk_data, p)
#define stk_pop() (--nb_stk_data)
/* mark CString on stack for cleanup errors */

#define cstr_new_s(cstr) (cstr_new(cstr), stk_push(&(cstr)->data))
#define cstr_free_s(cstr) (cstr_free(cstr), stk_pop())

ST_FUNC int tcc_add_file_internal(TCCState *s1, const char *filename,
				  int flags);
/* flags: */
/* print error if file not found */

#define AFF_PRINT_ERROR 0x10
/* load a referenced dll from another dll */
#define AFF_REFERENCED_DLL 0x20
/* file to add is binary */
#define AFF_TYPE_BIN 0x40
/* load all objects from archive */
#define AFF_WHOLE_ARCHIVE 0x80
/* s->filetype: */

#define AFF_TYPE_NONE 0
#define AFF_TYPE_C 1
#define AFF_TYPE_ASM 2
#define AFF_TYPE_ASMPP 4
#define AFF_TYPE_LIB 8
#define AFF_TYPE_MASK (7 | AFF_TYPE_BIN)
/* values from tcc_object_type(...) */

#define AFF_BINTYPE_REL 1
#define AFF_BINTYPE_DYN 2
#define AFF_BINTYPE_AR 3
#define AFF_BINTYPE_C67 4
/* return value of tcc_add_file_internal(): 0, -1, or FILE_NOT_FOUND */

#define FILE_NOT_FOUND -2
/* unrecognized file type */
#define FILE_NOT_RECOGNIZED -3
#ifndef ELF_OBJ_ONLY

ST_FUNC int tcc_add_crt(TCCState *s, const char *filename);
#endif

ST_FUNC int tcc_add_dll(TCCState *s, const char *filename, int flags);
ST_FUNC int tcc_add_support(TCCState *s1, const char *filename);
#ifdef CONFIG_TCC_BCHECK

ST_FUNC void tcc_add_bcheck(TCCState *s1);
#endif
#ifdef CONFIG_TCC_BACKTRACE

ST_FUNC void tcc_add_btstub(TCCState *s1);
#endif

ST_FUNC void tcc_add_pragma_libs(TCCState *s1);
PUB_FUNC int tcc_add_library_err(TCCState *s, const char *f);
PUB_FUNC void tcc_print_stats(TCCState *s, unsigned total_time);
PUB_FUNC int tcc_parse_args(TCCState *s, int *argc, char ***argv);

ST_FUNC char *normalize_slashes(char *path);

ST_FUNC DLLReference *tcc_add_dllref(TCCState *s1, const char *dllname,
				     int level);
ST_FUNC char *tcc_load_text(int fd);
/* for #pragma once */

ST_FUNC int normalized_PATHCMP(const char *f1, const char *f2);
/* tcc_parse_args return codes: */

#define OPT_HELP 1
#define OPT_HELP2 2
#define OPT_V 3
#define OPT_PRINT_DIRS 4
#define OPT_AR 5
#define OPT_IMPDEF 6
#define OPT_M32 32
#define OPT_M64 64
/* ------------ tccpp.c ------------ */

ST_DATA struct BufferedFile *file;
ST_DATA int tok;
ST_DATA CValue tokc;
ST_DATA const int *macro_ptr;
ST_DATA int parse_flags;
ST_DATA int tok_flags;
ST_DATA CString tokcstr;/* current parsed string, if any */

/* display benchmark infos */

ST_DATA int tok_ident;
ST_DATA TokenSym **table_ident;
ST_DATA int pp_expr;
/* beginning of line before */

#define TOK_FLAG_BOL 0x0001
/* beginning of file before */
#define TOK_FLAG_BOF 0x0002
/* a endif was found matching starting #ifdef */
#define TOK_FLAG_ENDIF 0x0004
/* activate preprocessing */

#define PARSE_FLAG_PREPROCESS 0x0001
/* return numbers instead of TOK_PPNUM */
#define PARSE_FLAG_TOK_NUM 0x0002
/* line feed is returned as a
                                        token. line feed is also
                                        returned at eof */

#define PARSE_FLAG_LINEFEED 0x0004
/* we processing an asm file: '#' can be used for line comment, etc. */
#define PARSE_FLAG_ASM_FILE 0x0008
/* next() returns space tokens (for -E) */
#define PARSE_FLAG_SPACES 0x0010
/* next() returns '\\' token */
#define PARSE_FLAG_ACCEPT_STRAYS 0x0020
/* return parsed strings instead of TOK_PPSTR */
#define PARSE_FLAG_TOK_STR 0x0040
/* isidnum_table flags: */

#define IS_SPC 1
#define IS_ID 2
#define IS_NUM 4

enum line_macro_output_format {
	LINE_MACRO_OUTPUT_FORMAT_GCC,
	LINE_MACRO_OUTPUT_FORMAT_NONE,
	LINE_MACRO_OUTPUT_FORMAT_STD,
	LINE_MACRO_OUTPUT_FORMAT_P10 = 11
};

ST_FUNC TokenSym *tok_alloc(const char *str, int len);
ST_FUNC int tok_alloc_const(const char *str);
ST_FUNC const char *get_tok_str(int v, CValue *cv);
ST_FUNC void begin_macro(TokenString *str, int alloc);
ST_FUNC void end_macro(void);
ST_FUNC int set_idnum(int c, int val);
ST_INLN void tok_str_new(TokenString *s);
ST_FUNC TokenString *tok_str_alloc(void);
ST_FUNC void tok_str_free(TokenString *s);
ST_FUNC void tok_str_free_str(int *str);
ST_FUNC void tok_str_add(TokenString *s, int t);
ST_FUNC void tok_str_add_tok(TokenString *s);
ST_INLN void define_push(int v, int macro_type, int *str, Sym *first_arg);
ST_FUNC void define_undef(Sym *s);
ST_INLN Sym *define_find(int v);
ST_FUNC void free_defines(Sym *b);
ST_FUNC void parse_define(void);
ST_FUNC void skip_to_eol(int warn);
ST_FUNC void preprocess(int is_bof);
ST_FUNC void next(void);
ST_INLN void unget_tok(int last_tok);
ST_FUNC void preprocess_start(TCCState *s1, int filetype);
ST_FUNC void preprocess_end(TCCState *s1);
ST_FUNC void tccpp_new(TCCState *s);
ST_FUNC void tccpp_delete(TCCState *s);
ST_FUNC void tccpp_putfile(const char *filename);
ST_FUNC int tcc_preprocess(TCCState *s1);
ST_FUNC void skip(int c);
ST_FUNC NORETURN void expect(const char *msg);
ST_FUNC void pp_error(CString *cs);
/* space excluding newline */

static inline int is_space(int ch)
{
	return ch == ' ' || ch == '\t' || ch == '\v' || ch == '\f' || ch == '\r';
}
static inline int isid(int c)
{
	return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || c == '_';
}
static inline int isnum(int c)
{
	return c >= '0' && c <= '9';
}
static inline int isoct(int c)
{
	return c >= '0' && c <= '7';
}
static inline int toup(int c)
{
	return (c >= 'a' && c <= 'z') ? c - 'a' + 'A' : c;
}
/* ------------ tccgen.c ------------ */

#define SYM_POOL_NB (8192 / sizeof(Sym))

ST_DATA Sym *global_stack;
ST_DATA Sym *local_stack;
ST_DATA Sym *local_label_stack;
ST_DATA Sym *global_label_stack;
ST_DATA Sym *define_stack;
ST_DATA CType int_type, func_old_type, char_pointer_type;
ST_DATA SValue *vtop;
ST_DATA int rsym, anon_sym, ind, loc;
ST_DATA char debug_modes;

ST_DATA int
nocode_wanted;/* true if no code generation wanted for an expression */

ST_DATA int
global_expr;/* true if compound literals must be allocated globally (used during initializers parsing */

ST_DATA CType
func_vt;/* current function return type (used by return instruction) */

ST_DATA int func_var;/* true if current function is variadic */

ST_DATA int func_vc;
ST_DATA int func_ind;
ST_DATA const char *funcname;

ST_FUNC void tccgen_init(TCCState *s1);
ST_FUNC int tccgen_compile(TCCState *s1);
ST_FUNC void tccgen_finish(TCCState *s1);
ST_FUNC void check_vstack(void);

ST_INLN int is_float(int t);
ST_FUNC int ieee_finite(double d);
ST_FUNC int exact_log2p1(int i);
ST_FUNC void test_lvalue(void);

ST_FUNC ElfSym *elfsym(Sym *);
ST_FUNC void update_storage(Sym *sym);
ST_FUNC void put_extern_sym2(Sym *sym, int sh_num, addr_t value,
			     unsigned long size, int can_add_underscore);
ST_FUNC void put_extern_sym(Sym *sym, Section *section, addr_t value,
			    unsigned long size);
#if PTR_SIZE == 4
ST_FUNC void greloc(Section *s, Sym *sym, unsigned long offset, int type);
#endif

ST_FUNC void greloca(Section *s, Sym *sym, unsigned long offset, int type,
		     addr_t addend);

ST_INLN void sym_free(Sym *sym);
ST_FUNC Sym *sym_push(int v, CType *type, int r, int c);
ST_FUNC void sym_pop(Sym **ptop, Sym *b, int keep);
ST_FUNC Sym *sym_push2(Sym **ps, int v, int t, int c);
ST_FUNC Sym *sym_find2(Sym *s, int v);
ST_INLN Sym *sym_find(int v);
ST_FUNC Sym *label_find(int v);
ST_FUNC Sym *label_push(Sym **ptop, int v, int flags);
ST_FUNC void label_pop(Sym **ptop, Sym *slast, int keep);
ST_INLN Sym *struct_find(int v);

ST_FUNC Sym *global_identifier_push(int v, int t, int c);
ST_FUNC Sym *external_global_sym(int v, CType *type);
ST_FUNC Sym *external_helper_sym(int v);
ST_FUNC void vpush_helper_func(int v);
ST_FUNC void vset(CType *type, int r, int v);
ST_FUNC void vset_VT_CMP(int op);
ST_FUNC void vpushi(int v);
ST_FUNC void vpushv(SValue *v);
ST_FUNC void vpushsym(CType *type, Sym *sym);
ST_FUNC void vswap(void);
ST_FUNC void vrott(int n);
ST_FUNC void vrotb(int n);
ST_FUNC void vrev(int n);
ST_FUNC void vpop(void);
#if PTR_SIZE == 4
ST_FUNC void lexpand(void);
#endif

ST_FUNC void save_reg(int r);
ST_FUNC void save_reg_upstack(int r, int n);
ST_FUNC int get_reg(int rc);
ST_FUNC void save_regs(int n);
ST_FUNC void gaddrof(void);
ST_FUNC int gv(int rc);
ST_FUNC void gv2(int rc1, int rc2);
ST_FUNC void gen_op(int op);
ST_FUNC int type_size(CType *type, int *a);
ST_FUNC void mk_pointer(CType *type);
ST_FUNC void vstore(void);
ST_FUNC void inc(int post, int c);
ST_FUNC CString *parse_mult_str(const char *msg);
ST_FUNC CString *parse_asm_str(void);
ST_FUNC void indir(void);
ST_FUNC void unary(void);
ST_FUNC void gexpr(void);
ST_FUNC int expr_const(void);
#if defined CONFIG_TCC_BCHECK || defined TCC_TARGET_C67
ST_FUNC Sym *get_sym_ref(CType *type, Section *sec, unsigned long offset,
			 unsigned long size);
#endif
#ifdef CONFIG_TCC_BCHECK

ST_FUNC void gbound_args(int nb_args);
ST_DATA int func_bound_add_epilog;
#endif
/* ------------ tccelf.c ------------ */
/* default output format: ELF */
// 1507 "tcc.h"
#define TCC_OUTPUT_FORMAT_ELF 0
/* binary image output */
#define TCC_OUTPUT_FORMAT_BINARY 1
/* COFF */
#define TCC_OUTPUT_FORMAT_COFF 2
#define TCC_OUTPUT_DYN TCC_OUTPUT_DLL
/* For COFF and a.out archives */

#define ARMAG "!<arch>\n"

typedef struct {
	unsigned int n_strx;/* index into string table of name */

	unsigned char n_type;/* type of symbol */

	unsigned char n_other;/* misc info (usually empty) */

	unsigned short n_desc;/* description field */

	unsigned int n_value;/* value of symbol */

} Stab_Sym;

ST_FUNC void tccelf_new(TCCState *s);
ST_FUNC void tccelf_delete(TCCState *s);
ST_FUNC void tccelf_begin_file(TCCState *s1);
ST_FUNC void tccelf_end_file(TCCState *s1);
ST_FUNC Section *new_section(TCCState *s1, const char *name, int sh_type,
			     int sh_flags);
ST_FUNC void section_realloc(Section *sec, unsigned long new_size);
ST_FUNC size_t section_add(Section *sec, addr_t size, int align);
ST_FUNC void *section_ptr_add(Section *sec, addr_t size);
ST_FUNC Section *find_section(TCCState *s1, const char *name);
ST_FUNC void free_section(Section *s);
ST_FUNC Section *new_symtab(TCCState *s1, const char *symtab_name, int sh_type,
			    int sh_flags, const char *strtab_name, const char *hash_name,
			    int hash_sh_flags);
ST_FUNC void init_symtab(Section *s);

ST_FUNC int put_elf_str(Section *s, const char *sym);
ST_FUNC int put_elf_sym(Section *s, addr_t value, unsigned long size, int info,
			int other, int shndx, const char *name);
ST_FUNC int set_elf_sym(Section *s, addr_t value, unsigned long size, int info,
			int other, int shndx, const char *name);
ST_FUNC int find_elf_sym(Section *s, const char *name);
ST_FUNC void put_elf_reloc(Section *symtab, Section *s, unsigned long offset,
			   int type, int symbol);
ST_FUNC void put_elf_reloca(Section *symtab, Section *s, unsigned long offset,
			    int type, int symbol, addr_t addend);

ST_FUNC void resolve_common_syms(TCCState *s1);
ST_FUNC void relocate_syms(TCCState *s1, Section *symtab, int do_resolve);
ST_FUNC void relocate_sections(TCCState *s1);

ST_FUNC ssize_t full_read(int fd, void *buf, size_t count);
ST_FUNC void *load_data(int fd, unsigned long file_offset, unsigned long size);
ST_FUNC int tcc_object_type(int fd, ElfW(Ehdr) *h);
ST_FUNC int tcc_load_object_file(TCCState *s1, int fd,
				 unsigned long file_offset);
ST_FUNC int tcc_load_archive(TCCState *s1, int fd, int alacarte);
ST_FUNC void add_array(TCCState *s1, const char *sec, int c);

ST_FUNC struct sym_attr *get_sym_attr(TCCState *s1, int index, int alloc);
ST_FUNC addr_t get_sym_addr(TCCState *s, const char *name, int err, int forc);
ST_FUNC void list_elf_symbols(TCCState *s, void *ctx,
			      void (*symbol_cb)(void *ctx, const char *name, const void *val));
ST_FUNC int set_global_sym(TCCState *s1, const char *name, Section *sec,
			   addr_t offs);
/* Browse each elem of type <type> in section <sec> starting at elem <startoff>
   using variable <elem> */

#define for_each_elem(sec,startoff,elem,type) for (elem = (type *) sec->data + startoff; elem < (type *) (sec->data + sec->data_offset); elem++)
#ifndef ELF_OBJ_ONLY

ST_FUNC int tcc_load_dll(TCCState *s1, int fd, const char *filename, int level);
ST_FUNC int tcc_load_ldscript(TCCState *s1, int fd);
ST_FUNC void tccelf_add_crtbegin(TCCState *s1);
ST_FUNC void tccelf_add_crtend(TCCState *s1);
#endif
/* ------------ xxx-link.c ------------ */
// 1597 "tcc.h"
ST_FUNC void relocate(TCCState *s1, ElfW_Rel *rel, int type, unsigned char *ptr,
		      addr_t addr, addr_t val);
/* ------------ xxx-gen.c ------------ */

ST_DATA const char *const target_machine_defs;
ST_DATA const int reg_classes[NB_REGS];

ST_FUNC void gsym_addr(int t, int a);
ST_FUNC void gsym(int t);
ST_FUNC void load(int r, SValue *sv);
ST_FUNC void store(int r, SValue *v);
ST_FUNC int gfunc_sret(CType *vt, int variadic, CType *ret, int *align,
		       int *regsize);
ST_FUNC void gfunc_call(int nb_args);
ST_FUNC void gfunc_prolog(Sym *func_sym);
ST_FUNC void gfunc_epilog(void);
ST_FUNC void gen_fill_nops(int);
ST_FUNC int gjmp(int t);
ST_FUNC void gjmp_addr(int a);
ST_FUNC int gjmp_cond(int op, int t);
ST_FUNC int gjmp_append(int n, int t);
ST_FUNC void gen_opi(int op);
ST_FUNC void gen_opf(int op);
ST_FUNC void gen_cvt_ftoi(int t);
ST_FUNC void gen_cvt_itof(int t);
ST_FUNC void gen_cvt_ftof(int t);
ST_FUNC void ggoto(void);

ST_FUNC void o(unsigned int c);

ST_FUNC void gen_vla_sp_save(int addr);
ST_FUNC void gen_vla_sp_restore(int addr);
ST_FUNC void gen_vla_alloc(CType *type, int align);

static inline uint16_t read16le(unsigned char *p)
{
	return p[0] | (uint16_t)p[1] << 8;
}
static inline void write16le(unsigned char *p, uint16_t x)
{
	p[0] = x & 255;
	p[1] = x >> 8 & 255;
}
static inline uint32_t read32le(unsigned char *p)
{
	return read16le(p) | (uint32_t)read16le(p + 2) << 16;
}
static inline void write32le(unsigned char *p, uint32_t x)
{
	write16le(p, x);
	write16le(p + 2, x >> 16);
}
static inline void add32le(unsigned char *p, int32_t x)
{
	write32le(p, read32le(p) + x);
}
static inline uint64_t read64le(unsigned char *p)
{
	return read32le(p) | (uint64_t)read32le(p + 4) << 32;
}
static inline void write64le(unsigned char *p, uint64_t x)
{
	write32le(p, x);
	write32le(p + 4, x >> 32);
}
static inline void add64le(unsigned char *p, int64_t x)
{
	write64le(p, read64le(p) + x);
}
#define DWARF_MAX_128 ((8 * sizeof (int64_t) + 6) / 7)

#define dwarf_read_1(ln,end) ((ln) < (end) ? *(ln)++ : 0)

#define dwarf_read_2(ln,end) ((ln) + 1 < (end) ? (ln) += 2, read16le((ln) - 2) : 0)

#define dwarf_read_4(ln,end) ((ln) + 3 < (end) ? (ln) += 4, read32le((ln) - 4) : 0)

#define dwarf_read_8(ln,end) ((ln) + 7 < (end) ? (ln) += 8, read64le((ln) - 8) : 0)
static inline uint64_t
dwarf_read_uleb128(unsigned char **ln, unsigned char *end)
{
	unsigned char *cp = *ln;
	uint64_t retval = 0;
	int i;

	for (i = 0; i < DWARF_MAX_128; i++) {
		uint64_t byte = dwarf_read_1(cp, end);

		retval |= (byte & 0x7f) << (i * 7);
		if ((byte & 0x80) == 0)
			break;
	}
	*ln = cp;
	return retval;
}
static inline int64_t
dwarf_read_sleb128(unsigned char **ln, unsigned char *end)
{
	unsigned char *cp = *ln;
	int64_t retval = 0;
	int i;

	for (i = 0; i < DWARF_MAX_128; i++) {
		uint64_t byte = dwarf_read_1(cp, end);

		retval |= (byte & 0x7f) << (i * 7);
		if ((byte & 0x80) == 0) {
			if ((byte & 0x40) && (i + 1) * 7 < 64)
				retval |= -1LL << ((i + 1) * 7);
			break;
		}
	}
	*ln = cp;
	return retval;
}
/* ------------ i386-gen.c ------------ */

ST_FUNC void g(int c);
ST_FUNC void gen_le16(int c);
ST_FUNC void gen_le32(int c);

ST_FUNC void gen_addr32(int r, Sym *sym, int c);
ST_FUNC void gen_addrpc32(int r, Sym *sym, int c);
ST_FUNC void gen_cvt_csti(int t);
ST_FUNC void gen_increment_tcov (SValue *sv);
/* ------------ x86_64-gen.c ------------ */

ST_FUNC void gen_addr64(int r, Sym *sym, int64_t c);
ST_FUNC void gen_opl(int op);

ST_FUNC void gen_vla_result(int addr);

ST_FUNC void gen_cvt_sxtw(void);
ST_FUNC void gen_cvt_csti(int t);
/* ------------ arm-gen.c ------------ */
/* ------------ arm64-gen.c ------------ */
/* ------------ riscv64-gen.c ------------ */
/* ------------ c67-gen.c ------------ */
/* ------------ tcccoff.c ------------ */
/* ------------ tccasm.c ------------ */
// 1767 "tcc.h"
ST_FUNC void asm_instr(void);
ST_FUNC void asm_global_instr(void);
ST_FUNC int tcc_assemble(TCCState *s1, int do_preprocess);
#ifdef CONFIG_TCC_ASM

ST_FUNC int find_constraint(ASMOperand *operands, int nb_operands,
			    const char *name, const char **pp);
ST_FUNC Sym *get_asm_sym(int name, Sym *csym);
ST_FUNC void asm_expr(TCCState *s1, ExprValue *pe);
ST_FUNC int asm_int_expr(TCCState *s1);
/* ------------ i386-asm.c ------------ */

ST_FUNC void gen_expr32(ExprValue *pe);

ST_FUNC void gen_expr64(ExprValue *pe);

ST_FUNC void asm_opcode(TCCState *s1, int opcode);
ST_FUNC int asm_parse_regvar(int t);
ST_FUNC void asm_compute_constraints(ASMOperand *operands, int nb_operands,
				     int nb_outputs, const uint8_t *clobber_regs, int *pout_reg);
ST_FUNC void subst_asm_operand(CString *add_str, SValue *sv, int modifier);
ST_FUNC void asm_gen_code(ASMOperand *operands, int nb_operands, int nb_outputs,
			  int is_output, uint8_t *clobber_regs, int out_reg);
ST_FUNC void asm_clobber(uint8_t *clobber_regs, const char *str);
#endif
/* ------------ tccpe.c -------------- */

ST_FUNC int pe_load_file(struct TCCState *s1, int fd, const char *filename);
ST_FUNC int pe_output_file(TCCState * s1, const char *filename);
ST_FUNC int pe_putimport(TCCState *s1, int dllindex, const char *name,
			 addr_t value);

ST_FUNC void pe_add_unwind_data(unsigned start, unsigned end, unsigned stack);

PUB_FUNC int tcc_get_dllexports(const char *filename, char **pp);
/* symbol properties stored in Elf32_Sym->st_other */

#define ST_PE_EXPORT 0x10
#define ST_PE_IMPORT 0x20
#define ST_PE_STDCALL 0x40

#define ST_ASM_SET 0x04
/* ------------ tccmacho.c ----------------- */
/* ------------ tccrun.c ----------------- */
#ifdef CONFIG_TCC_STATIC

#define RTLD_LAZY       0x001
#define RTLD_NOW        0x002
#define RTLD_GLOBAL     0x100
#define RTLD_DEFAULT    NULL
/* dummy function for profiling */

ST_FUNC void *dlopen(const char *filename, int flag);
ST_FUNC void dlclose(void *p);
ST_FUNC const char *dlerror(void);
ST_FUNC void *dlsym(void *handle, const char *symbol);
#endif
// 1829 "tcc.h"
ST_FUNC void tcc_run_free(TCCState *s1);
/* ------------ tcctools.c ----------------- */
/* ------------ tccdbg.c ------------ */
// 1844 "tcc.h"
ST_FUNC void tcc_debug_new(TCCState *s);

ST_FUNC void tcc_debug_start(TCCState *s1);
ST_FUNC void tcc_debug_end(TCCState *s1);
ST_FUNC void tcc_debug_bincl(TCCState *s1);
ST_FUNC void tcc_debug_eincl(TCCState *s1);
ST_FUNC void tcc_debug_newfile(TCCState *s1);

ST_FUNC void tcc_debug_line(TCCState *s1);
ST_FUNC void tcc_add_debug_info(TCCState *s1, int param, Sym *s, Sym *e);
ST_FUNC void tcc_debug_funcstart(TCCState *s1, Sym *sym);
ST_FUNC void tcc_debug_prolog_epilog(TCCState *s1, int value);
ST_FUNC void tcc_debug_funcend(TCCState *s1, int size);
ST_FUNC void tcc_debug_extern_sym(TCCState *s1, Sym *sym, int sh_num,
				  int sym_bind, int sym_type);
ST_FUNC void tcc_debug_typedef(TCCState *s1, Sym *sym);
ST_FUNC void tcc_debug_stabn(TCCState *s1, int type, int value);
ST_FUNC void tcc_debug_fix_anon(TCCState *s1, CType *t);
#if !(defined ELF_OBJ_ONLY || defined TCC_TARGET_ARM || defined TARGETOS_BSD)
ST_FUNC void tcc_eh_frame_start(TCCState *s1);
ST_FUNC void tcc_eh_frame_end(TCCState *s1);
ST_FUNC void tcc_eh_frame_hdr(TCCState *s1, int final);
#define TCC_EH_FRAME 1
#endif
// 1869 "tcc.h"
ST_FUNC void tcc_tcov_start(TCCState *s1);
ST_FUNC void tcc_tcov_end(TCCState *s1);
ST_FUNC void tcc_tcov_check_line(TCCState *s1, int start);
ST_FUNC void tcc_tcov_block_end(TCCState *s1, int line);
ST_FUNC void tcc_tcov_block_begin(TCCState *s1);
ST_FUNC void tcc_tcov_reset_ind(TCCState *s1);

#define stab_section s1->stab_section
#define stabstr_section stab_section->link
#define tcov_section s1->tcov_section
#define eh_frame_section s1->eh_frame_section
#define eh_frame_hdr_section s1->eh_frame_hdr_section
#define dwarf_info_section s1->dwarf_info_section
#define dwarf_abbrev_section s1->dwarf_abbrev_section
#define dwarf_line_section s1->dwarf_line_section
#define dwarf_aranges_section s1->dwarf_aranges_section
#define dwarf_str_section s1->dwarf_str_section
#define dwarf_line_str_section s1->dwarf_line_str_section
/* default dwarf version for "-gdwarf" */

#define DEFAULT_DWARF_VERSION 5
/* default dwarf version for "-g". use 0 to emit stab debug infos */
#ifndef CONFIG_DWARF_VERSION

#define CONFIG_DWARF_VERSION 0
#endif
/* fake code to avoid DLL relocs */

#define R_DATA_32DW 'Z'
/**/
#if CONFIG_TCC_SEMLOCK
// 1911 "tcc.h"
typedef struct {
	int init;
	CRITICAL_SECTION cs;
} TCCSem;
static inline void wait_sem(TCCSem *p)
{
	if (!p->init)
		InitializeCriticalSection(&p->cs), p->init = 1;
	EnterCriticalSection(&p->cs);
}
static inline void post_sem(TCCSem *p)
{
	LeaveCriticalSection(&p->cs);
}

#define TCC_SEM(s) TCCSem s
#define WAIT_SEM wait_sem
#define POST_SEM post_sem
#else

#define TCC_SEM(s)
#define WAIT_SEM(p)
#define POST_SEM(p)
#endif
/**/

#undef ST_DATA

#define ST_DATA static
/**/

#define text_section TCC_STATE_VAR(text_section)
#define data_section TCC_STATE_VAR(data_section)
#define rodata_section TCC_STATE_VAR(rodata_section)
#define bss_section TCC_STATE_VAR(bss_section)
#define common_section TCC_STATE_VAR(common_section)
#define cur_text_section TCC_STATE_VAR(cur_text_section)
#define bounds_section TCC_STATE_VAR(bounds_section)
#define lbounds_section TCC_STATE_VAR(lbounds_section)
#define symtab_section TCC_STATE_VAR(symtab_section)
#define gnu_ext TCC_STATE_VAR(gnu_ext)
#define tcc_error_noabort TCC_SET_STATE(_tcc_error_noabort)
#define tcc_error TCC_SET_STATE(_tcc_error)
#define tcc_warning TCC_SET_STATE(_tcc_warning)

#define total_idents TCC_STATE_VAR(total_idents)
#define total_lines TCC_STATE_VAR(total_lines)
#define total_bytes TCC_STATE_VAR(total_bytes)

PUB_FUNC void tcc_enter_state(TCCState *s1);
PUB_FUNC void tcc_exit_state(TCCState *s1);
/* conditional warning depending on switch */

#define tcc_warning_c(sw) TCC_SET_STATE(( tcc_state->warn_num = offsetof(TCCState, sw) - offsetof(TCCState, warn_none), _tcc_warning))
/**/
/* _TCC_H */
#endif /* _TCC_H */

#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 26 "tcc.c" 2

// 1 "libtcc.c" 1
// 26 "libtcc.c"
// 1 "tccpp.c" 1
// 21 "tccpp.c"
#define USING_GLOBALS
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 23 "tccpp.c" 2
/* #define to 1 to enable (see parse_pp_string()) */

#define ACCEPT_LF_IN_STRINGS 0
/**/
/* global variables */

ST_DATA int tok_flags;
ST_DATA int parse_flags;

ST_DATA struct BufferedFile *file;
ST_DATA int tok;
ST_DATA CValue tokc;
ST_DATA const int *macro_ptr;
ST_DATA CString tokcstr;/* current parsed string, if any */

/* display benchmark infos */

ST_DATA int tok_ident;
ST_DATA TokenSym **table_ident;
ST_DATA int pp_expr;
/* ------------------------------------------------------------------------- */

static TokenSym *hash_ident[TOK_HASH_SIZE];
static char token_buf[STRING_MAX_SIZE + 1];
static CString cstr_buf;
static TokenString tokstr_buf;
static TokenString unget_buf;
static unsigned char isidnum_table[256 - CH_EOF];
static int pp_debug_tok, pp_debug_symv;
static int pp_counter;
static void tok_print(const int *str, const char *msg, ...);
static void next_nomacro(void);
static void parse_number(const char *p);
static void parse_string(const char *p, int len);

static struct TinyAlloc *toksym_alloc;
static struct TinyAlloc *tokstr_alloc;

static TokenString *macro_stack;

static const char tcc_keywords[] =
#define DEF(id,str) str "\0"
// 1 "tcctok.h" 1
	/**/
	/* keywords */

	DEF(TOK_IF, "if")
	DEF(TOK_ELSE, "else")
	DEF(TOK_WHILE, "while")
	DEF(TOK_FOR, "for")
	DEF(TOK_DO, "do")
	DEF(TOK_CONTINUE, "continue")
	DEF(TOK_BREAK, "break")
	DEF(TOK_RETURN, "return")
	DEF(TOK_GOTO, "goto")
	DEF(TOK_SWITCH, "switch")
	DEF(TOK_CASE, "case")
	DEF(TOK_DEFAULT, "default")
	DEF(TOK_ASM1, "asm")
	DEF(TOK_ASM2, "__asm")
	DEF(TOK_ASM3, "__asm__")

	DEF(TOK_EXTERN, "extern")
	DEF(TOK_STATIC, "static")
	DEF(TOK_UNSIGNED, "unsigned")
	DEF(TOK__Atomic, "_Atomic")
	DEF(TOK_CONST1, "const")
	DEF(TOK_CONST2, "__const")/* gcc keyword */

	DEF(TOK_CONST3, "__const__")/* gcc keyword */

	DEF(TOK_VOLATILE1, "volatile")
	DEF(TOK_VOLATILE2, "__volatile")/* gcc keyword */

	DEF(TOK_VOLATILE3, "__volatile__")/* gcc keyword */

	DEF(TOK_REGISTER, "register")
	DEF(TOK_SIGNED1, "signed")
	DEF(TOK_SIGNED2, "__signed")/* gcc keyword */

	DEF(TOK_SIGNED3, "__signed__")/* gcc keyword */

	DEF(TOK_AUTO, "auto")
	DEF(TOK_INLINE1, "inline")
	DEF(TOK_INLINE2, "__inline")/* gcc keyword */

	DEF(TOK_INLINE3, "__inline__")/* gcc keyword */

	DEF(TOK_RESTRICT1, "restrict")
	DEF(TOK_RESTRICT2, "__restrict")
	DEF(TOK_RESTRICT3, "__restrict__")
	DEF(TOK_EXTENSION, "__extension__")/* gcc keyword */

	DEF(TOK_THREAD_LOCAL, "_Thread_local")/* C11 thread-local storage */

	DEF(TOK_GENERIC, "_Generic")
	DEF(TOK_STATIC_ASSERT, "_Static_assert")

	DEF(TOK_VOID, "void")
	DEF(TOK_CHAR, "char")
	DEF(TOK_INT, "int")
	DEF(TOK_FLOAT, "float")
	DEF(TOK_DOUBLE, "double")
	DEF(TOK_BOOL, "_Bool")
	DEF(TOK_COMPLEX, "_Complex")
	DEF(TOK_SHORT, "short")
	DEF(TOK_LONG, "long")
	DEF(TOK_STRUCT, "struct")
	DEF(TOK_UNION, "union")
	DEF(TOK_TYPEDEF, "typedef")
	DEF(TOK_ENUM, "enum")
	DEF(TOK_SIZEOF, "sizeof")
	DEF(TOK_ATTRIBUTE1, "__attribute")
	DEF(TOK_ATTRIBUTE2, "__attribute__")
	DEF(TOK_ALIGNOF1, "__alignof")
	DEF(TOK_ALIGNOF2, "__alignof__")
	DEF(TOK_ALIGNOF3, "_Alignof")
	DEF(TOK_ALIGNAS, "_Alignas")
	DEF(TOK_TYPEOF1, "typeof")
	DEF(TOK_TYPEOF2, "__typeof")
	DEF(TOK_TYPEOF3, "__typeof__")
	DEF(TOK_LABEL, "__label__")
	/**/
	/* the following are not keywords. They are included to ease parsing */
	/* preprocessor only */

	DEF(TOK_DEFINE, "define")
	DEF(TOK_INCLUDE, "include")
	DEF(TOK_INCLUDE_NEXT, "include_next")
	DEF(TOK_IFDEF, "ifdef")
	DEF(TOK_IFNDEF, "ifndef")
	DEF(TOK_ELIF, "elif")
	DEF(TOK_ENDIF, "endif")
	DEF(TOK_DEFINED, "defined")
	DEF(TOK_UNDEF, "undef")
	DEF(TOK_ERROR, "error")
	DEF(TOK_WARNING, "warning")
	DEF(TOK_LINE, "line")
	DEF(TOK_PRAGMA, "pragma")
	DEF(TOK___LINE__, "__LINE__")
	DEF(TOK___FILE__, "__FILE__")
	DEF(TOK___DATE__, "__DATE__")
	DEF(TOK___TIME__, "__TIME__")
	DEF(TOK___FUNCTION__, "__FUNCTION__")
	DEF(TOK___VA_ARGS__, "__VA_ARGS__")
	DEF(TOK___COUNTER__, "__COUNTER__")
	DEF(TOK___HAS_INCLUDE, "__has_include")
	DEF(TOK___HAS_INCLUDE_NEXT, "__has_include_next")
	/* special identifiers */

	DEF(TOK___FUNC__, "__func__")
	/* special floating point values */

	DEF(TOK___NAN__, "__nan__")
	DEF(TOK___SNAN__, "__snan__")
	DEF(TOK___INF__, "__inf__")
	/* attribute identifiers */
	/* XXX: handle all tokens generically since speed is not critical */

	DEF(TOK_SECTION1, "section")
	DEF(TOK_SECTION2, "__section__")
	DEF(TOK_ALIGNED1, "aligned")
	DEF(TOK_ALIGNED2, "__aligned__")
	DEF(TOK_PACKED1, "packed")
	DEF(TOK_PACKED2, "__packed__")
	DEF(TOK_WEAK1, "weak")
	DEF(TOK_WEAK2, "__weak__")
	DEF(TOK_ALIAS1, "alias")
	DEF(TOK_ALIAS2, "__alias__")
	DEF(TOK_UNUSED1, "unused")
	DEF(TOK_UNUSED2, "__unused__")
	DEF(TOK_NODEBUG1, "nodebug")
	DEF(TOK_NODEBUG2, "__nodebug__")
	DEF(TOK_CDECL1, "cdecl")
	DEF(TOK_CDECL2, "__cdecl")
	DEF(TOK_CDECL3, "__cdecl__")
	DEF(TOK_STDCALL1, "stdcall")
	DEF(TOK_STDCALL2, "__stdcall")
	DEF(TOK_STDCALL3, "__stdcall__")
	DEF(TOK_FASTCALL1, "fastcall")
	DEF(TOK_FASTCALL2, "__fastcall")
	DEF(TOK_FASTCALL3, "__fastcall__")
	DEF(TOK_THISCALL1, "thiscall")
	DEF(TOK_THISCALL2, "__thiscall")
	DEF(TOK_THISCALL3, "__thiscall__")
	DEF(TOK_REGPARM1, "regparm")
	DEF(TOK_REGPARM2, "__regparm__")
	DEF(TOK_CLEANUP1, "cleanup")
	DEF(TOK_CLEANUP2, "__cleanup__")
	DEF(TOK_CONSTRUCTOR1, "constructor")
	DEF(TOK_CONSTRUCTOR2, "__constructor__")
	DEF(TOK_DESTRUCTOR1, "destructor")
	DEF(TOK_DESTRUCTOR2, "__destructor__")
	DEF(TOK_ALWAYS_INLINE1, "always_inline")
	DEF(TOK_ALWAYS_INLINE2, "__always_inline__")

	DEF(TOK_MODE, "__mode__")
	DEF(TOK_MODE_QI, "__QI__")
	DEF(TOK_MODE_DI, "__DI__")
	DEF(TOK_MODE_HI, "__HI__")
	DEF(TOK_MODE_SI, "__SI__")
	DEF(TOK_MODE_word, "__word__")

	DEF(TOK_DLLEXPORT, "dllexport")
	DEF(TOK_DLLIMPORT, "dllimport")
	DEF(TOK_NODECORATE, "nodecorate")
	DEF(TOK_NORETURN1, "noreturn")
	DEF(TOK_NORETURN2, "__noreturn__")
	DEF(TOK_NORETURN3, "_Noreturn")
	DEF(TOK_VISIBILITY1, "visibility")
	DEF(TOK_VISIBILITY2, "__visibility__")

	DEF(TOK_builtin_types_compatible_p, "__builtin_types_compatible_p")
	DEF(TOK_builtin_choose_expr, "__builtin_choose_expr")
	DEF(TOK_builtin_constant_p, "__builtin_constant_p")
	DEF(TOK_builtin_frame_address, "__builtin_frame_address")
	DEF(TOK_builtin_return_address, "__builtin_return_address")
	DEF(TOK_builtin_expect, "__builtin_expect")
	DEF(TOK_builtin_unreachable, "__builtin_unreachable")
	/*DEF(TOK_builtin_va_list, "__builtin_va_list")*/

	DEF(TOK_builtin_va_start, "__builtin_va_start")
	/* atomic operations */
// 180 "tcctok.h"
#define DEF_ATOMIC(ID) DEF(TOK_ ## __ ## ID, "__"#ID)
	DEF_ATOMIC(atomic_store)
	DEF_ATOMIC(atomic_load)
	DEF_ATOMIC(atomic_exchange)
	DEF_ATOMIC(atomic_compare_exchange)
	DEF_ATOMIC(atomic_fetch_add)
	DEF_ATOMIC(atomic_fetch_sub)
	DEF_ATOMIC(atomic_fetch_or)
	DEF_ATOMIC(atomic_fetch_xor)
	DEF_ATOMIC(atomic_fetch_and)
	DEF_ATOMIC(atomic_fetch_nand)
	DEF_ATOMIC(atomic_add_fetch)
	DEF_ATOMIC(atomic_sub_fetch)
	DEF_ATOMIC(atomic_or_fetch)
	DEF_ATOMIC(atomic_xor_fetch)
	DEF_ATOMIC(atomic_and_fetch)
	DEF_ATOMIC(atomic_nand_fetch)
	/* pragma */

	DEF(TOK_pack, "pack")

	DEF(TOK_comment, "comment")
	DEF(TOK_lib, "lib")
	DEF(TOK_push_macro, "push_macro")
	DEF(TOK_pop_macro, "pop_macro")
	DEF(TOK_once, "once")
	DEF(TOK_option, "option")
	/* builtin functions or variables */

	DEF(TOK_memcpy, "memcpy")
	DEF(TOK_memmove, "memmove")
	DEF(TOK_memset, "memset")
	DEF(TOK___divdi3, "__divdi3")
	DEF(TOK___moddi3, "__moddi3")
	DEF(TOK___udivdi3, "__udivdi3")
	DEF(TOK___umoddi3, "__umoddi3")
	DEF(TOK___ashrdi3, "__ashrdi3")
	DEF(TOK___lshrdi3, "__lshrdi3")
	DEF(TOK___ashldi3, "__ashldi3")
	DEF(TOK___floatundisf, "__floatundisf")
	DEF(TOK___floatundidf, "__floatundidf")

	DEF(TOK___floatundixf, "__floatundixf")
	DEF(TOK___fixunsxfdi, "__fixunsxfdi")

	DEF(TOK___fixunssfdi, "__fixunssfdi")
	DEF(TOK___fixunsdfdi, "__fixunsdfdi")
// 295 "tcctok.h"
	DEF(TOK_alloca, "alloca")

	DEF(TOK___chkstk, "__chkstk")
	/* bound checking symbols */
#ifdef CONFIG_TCC_BCHECK

	DEF(TOK___bound_ptr_add, "__bound_ptr_add")
	DEF(TOK___bound_ptr_indir1, "__bound_ptr_indir1")
	DEF(TOK___bound_ptr_indir2, "__bound_ptr_indir2")
	DEF(TOK___bound_ptr_indir4, "__bound_ptr_indir4")
	DEF(TOK___bound_ptr_indir8, "__bound_ptr_indir8")
	DEF(TOK___bound_ptr_indir12, "__bound_ptr_indir12")
	DEF(TOK___bound_ptr_indir16, "__bound_ptr_indir16")
	DEF(TOK___bound_main_arg, "__bound_main_arg")
	DEF(TOK___bound_local_new, "__bound_local_new")
	DEF(TOK___bound_local_delete, "__bound_local_delete")
	DEF(TOK___bound_setjmp, "__bound_setjmp")
	DEF(TOK___bound_longjmp, "__bound_longjmp")
	DEF(TOK___bound_new_region, "__bound_new_region")
	DEF(TOK___bound_alloca_nr, "__bound_alloca_nr")
	DEF(TOK_setjmp, "setjmp")
	DEF(TOK__setjmp, "_setjmp")
	DEF(TOK_longjmp, "longjmp")
#endif
	/**/
	/* Tiny Assembler */
// 359 "tcctok.h"
#define DEF_ASM(x) DEF(TOK_ASM_ ## x, #x)
#define DEF_ASMDIR(x) DEF(TOK_ASMDIR_ ## x, "." #x)
#define TOK_ASM_int TOK_INT

#define TOK_ASMDIR_FIRST TOK_ASMDIR_byte
#define TOK_ASMDIR_LAST TOK_ASMDIR_section

	DEF_ASMDIR(byte)/* must be first directive */

	DEF_ASMDIR(word)
	DEF_ASMDIR(align)
	DEF_ASMDIR(balign)
	DEF_ASMDIR(p2align)
	DEF_ASMDIR(set)
	DEF_ASMDIR(skip)
	DEF_ASMDIR(space)
	DEF_ASMDIR(string)
	DEF_ASMDIR(asciz)
	DEF_ASMDIR(ascii)
	DEF_ASMDIR(file)
	DEF_ASMDIR(globl)
	DEF_ASMDIR(global)
	DEF_ASMDIR(weak)
	DEF_ASMDIR(hidden)
	DEF_ASMDIR(ident)
	DEF_ASMDIR(size)
	DEF_ASMDIR(type)
	DEF_ASMDIR(text)
	DEF_ASMDIR(data)
	DEF_ASMDIR(bss)
	DEF_ASMDIR(previous)
	DEF_ASMDIR(pushsection)
	DEF_ASMDIR(popsection)
	DEF_ASMDIR(fill)
	DEF_ASMDIR(rept)
	DEF_ASMDIR(endr)
	DEF_ASMDIR(org)
	DEF_ASMDIR(quad)

	DEF_ASMDIR(code64)

	DEF_ASMDIR(short)
	DEF_ASMDIR(long)
	DEF_ASMDIR(int)
	DEF_ASMDIR(symver)
	DEF_ASMDIR(section)/* must be last directive */

// 1 "i386-tok.h" 1
	/* ------------------------------------------------------------------ */
	/* WARNING: relative order of tokens is important. */

#define DEF_BWL(x) DEF(TOK_ASM_ ## x ## b, #x "b") DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x, #x)

#define DEF_WL(x) DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x, #x)

#define DEF_BWLQ(x) DEF(TOK_ASM_ ## x ## b, #x "b") DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x ## q, #x "q") DEF(TOK_ASM_ ## x, #x)

#define DEF_WLQ(x) DEF(TOK_ASM_ ## x ## w, #x "w") DEF(TOK_ASM_ ## x ## l, #x "l") DEF(TOK_ASM_ ## x ## q, #x "q") DEF(TOK_ASM_ ## x, #x)
#define DEF_BWLX DEF_BWLQ
#define DEF_WLX DEF_WLQ
	/* number of sizes + 1 */

#define NBWLX 5
// 40 "i386-tok.h"
#define DEF_FP1(x) DEF(TOK_ASM_ ## f ## x ## s, "f" #x "s") DEF(TOK_ASM_ ## fi ## x ## l, "fi" #x "l") DEF(TOK_ASM_ ## f ## x ## l, "f" #x "l") DEF(TOK_ASM_ ## fi ## x ## s, "fi" #x "s")

#define DEF_FP(x) DEF(TOK_ASM_ ## f ## x, "f" #x ) DEF(TOK_ASM_ ## f ## x ## p, "f" #x "p") DEF_FP1(x)
// 77 "i386-tok.h"
#define DEF_ASMTEST(x,suffix) DEF_ASM(x ## o ## suffix) DEF_ASM(x ## no ## suffix) DEF_ASM(x ## b ## suffix) DEF_ASM(x ## c ## suffix) DEF_ASM(x ## nae ## suffix) DEF_ASM(x ## nb ## suffix) DEF_ASM(x ## nc ## suffix) DEF_ASM(x ## ae ## suffix) DEF_ASM(x ## e ## suffix) DEF_ASM(x ## z ## suffix) DEF_ASM(x ## ne ## suffix) DEF_ASM(x ## nz ## suffix) DEF_ASM(x ## be ## suffix) DEF_ASM(x ## na ## suffix) DEF_ASM(x ## nbe ## suffix) DEF_ASM(x ## a ## suffix) DEF_ASM(x ## s ## suffix) DEF_ASM(x ## ns ## suffix) DEF_ASM(x ## p ## suffix) DEF_ASM(x ## pe ## suffix) DEF_ASM(x ## np ## suffix) DEF_ASM(x ## po ## suffix) DEF_ASM(x ## l ## suffix) DEF_ASM(x ## nge ## suffix) DEF_ASM(x ## nl ## suffix) DEF_ASM(x ## ge ## suffix) DEF_ASM(x ## le ## suffix) DEF_ASM(x ## ng ## suffix) DEF_ASM(x ## nle ## suffix) DEF_ASM(x ## g ## suffix)
	/* ------------------------------------------------------------------ */
	/* register */

	DEF_ASM(al)
	DEF_ASM(cl)
	DEF_ASM(dl)
	DEF_ASM(bl)
	DEF_ASM(ah)
	DEF_ASM(ch)
	DEF_ASM(dh)
	DEF_ASM(bh)
	DEF_ASM(ax)
	DEF_ASM(cx)
	DEF_ASM(dx)
	DEF_ASM(bx)
	DEF_ASM(sp)
	DEF_ASM(bp)
	DEF_ASM(si)
	DEF_ASM(di)
	DEF_ASM(eax)
	DEF_ASM(ecx)
	DEF_ASM(edx)
	DEF_ASM(ebx)
	DEF_ASM(esp)
	DEF_ASM(ebp)
	DEF_ASM(esi)
	DEF_ASM(edi)

	DEF_ASM(rax)
	DEF_ASM(rcx)
	DEF_ASM(rdx)
	DEF_ASM(rbx)
	DEF_ASM(rsp)
	DEF_ASM(rbp)
	DEF_ASM(rsi)
	DEF_ASM(rdi)

	DEF_ASM(mm0)
	DEF_ASM(mm1)
	DEF_ASM(mm2)
	DEF_ASM(mm3)
	DEF_ASM(mm4)
	DEF_ASM(mm5)
	DEF_ASM(mm6)
	DEF_ASM(mm7)
	DEF_ASM(xmm0)
	DEF_ASM(xmm1)
	DEF_ASM(xmm2)
	DEF_ASM(xmm3)
	DEF_ASM(xmm4)
	DEF_ASM(xmm5)
	DEF_ASM(xmm6)
	DEF_ASM(xmm7)
	DEF_ASM(cr0)
	DEF_ASM(cr1)
	DEF_ASM(cr2)
	DEF_ASM(cr3)
	DEF_ASM(cr4)
	DEF_ASM(cr5)
	DEF_ASM(cr6)
	DEF_ASM(cr7)
	DEF_ASM(tr0)
	DEF_ASM(tr1)
	DEF_ASM(tr2)
	DEF_ASM(tr3)
	DEF_ASM(tr4)
	DEF_ASM(tr5)
	DEF_ASM(tr6)
	DEF_ASM(tr7)
	DEF_ASM(db0)
	DEF_ASM(db1)
	DEF_ASM(db2)
	DEF_ASM(db3)
	DEF_ASM(db4)
	DEF_ASM(db5)
	DEF_ASM(db6)
	DEF_ASM(db7)
	DEF_ASM(dr0)
	DEF_ASM(dr1)
	DEF_ASM(dr2)
	DEF_ASM(dr3)
	DEF_ASM(dr4)
	DEF_ASM(dr5)
	DEF_ASM(dr6)
	DEF_ASM(dr7)
	DEF_ASM(es)
	DEF_ASM(cs)
	DEF_ASM(ss)
	DEF_ASM(ds)
	DEF_ASM(fs)
	DEF_ASM(gs)
	DEF_ASM(st)
	DEF_ASM(rip)
	/* The four low parts of sp/bp/si/di that exist only on
	    x86-64 (encoding aliased to ah,ch,dh,dh when not using REX). */

	DEF_ASM(spl)
	DEF_ASM(bpl)
	DEF_ASM(sil)
	DEF_ASM(dil)
	/* generic two operands */

	DEF_BWLX(mov)

	DEF_BWLX(add)
	DEF_BWLX(or)
	DEF_BWLX(adc)
	DEF_BWLX(sbb)
	DEF_BWLX(and)
	DEF_BWLX(sub)
	DEF_BWLX(xor)
	DEF_BWLX(cmp)
	/* unary ops */

	DEF_BWLX(inc)
	DEF_BWLX(dec)
	DEF_BWLX(not)
	DEF_BWLX(neg)
	DEF_BWLX(mul)
	DEF_BWLX(imul)
	DEF_BWLX(div)
	DEF_BWLX(idiv)

	DEF_BWLX(xchg)
	DEF_BWLX(test)
	/* shifts */

	DEF_BWLX(rol)
	DEF_BWLX(ror)
	DEF_BWLX(rcl)
	DEF_BWLX(rcr)
	DEF_BWLX(shl)
	DEF_BWLX(shr)
	DEF_BWLX(sar)

	DEF_WLX(shld)
	DEF_WLX(shrd)

	DEF_ASM(pushw)
	DEF_ASM(pushl)

	DEF_ASM(pushq)

	DEF_ASM(push)

	DEF_ASM(popw)
	DEF_ASM(popl)

	DEF_ASM(popq)

	DEF_ASM(pop)

	DEF_BWL(in)
	DEF_BWL(out)

	DEF_WLX(movzb)
	DEF_ASM(movzwl)
	DEF_ASM(movsbw)
	DEF_ASM(movsbl)
	DEF_ASM(movswl)

	DEF_ASM(movsbq)
	DEF_ASM(movswq)
	DEF_ASM(movzwq)
	DEF_ASM(movslq)

	DEF_WLX(lea)

	DEF_ASM(les)
	DEF_ASM(lds)
	DEF_ASM(lss)
	DEF_ASM(lfs)
	DEF_ASM(lgs)

	DEF_ASM(call)
	DEF_ASM(jmp)
	DEF_ASM(lcall)
	DEF_ASM(ljmp)

	DEF_ASMTEST(j,)

	DEF_ASMTEST(set,)
	DEF_ASMTEST(set,b)
	DEF_ASMTEST(cmov,)

	DEF_WLX(bsf)
	DEF_WLX(bsr)
	DEF_WLX(bt)
	DEF_WLX(bts)
	DEF_WLX(btr)
	DEF_WLX(btc)
	DEF_WLX(popcnt)
	DEF_WLX(tzcnt)
	DEF_WLX(lzcnt)

	DEF_WLX(lar)
	DEF_WLX(lsl)
	/* generic FP ops */

	DEF_FP(add)
	DEF_FP(mul)

	DEF_ASM(fcom)
	DEF_ASM(fcom_1)/* non existent op, just to have a regular table */

	DEF_FP1(com)

	DEF_FP(comp)
	DEF_FP(sub)
	DEF_FP(subr)
	DEF_FP(div)
	DEF_FP(divr)

	DEF_BWLX(xadd)
	DEF_BWLX(cmpxchg)
	/* string ops */

	DEF_BWLX(cmps)
	DEF_BWLX(scmp)
	DEF_BWL(ins)
	DEF_BWL(outs)
	DEF_BWLX(lods)
	DEF_BWLX(slod)
	DEF_BWLX(movs)
	DEF_BWLX(smov)
	DEF_BWLX(scas)
	DEF_BWLX(ssca)
	DEF_BWLX(stos)
	DEF_BWLX(ssto)
	/* generic asm ops */

#define ALT(x)
#define DEF_ASM_OP0(name,opcode) DEF_ASM(name)
#define DEF_ASM_OP0L(name,opcode,group,instr_type)
#define DEF_ASM_OP1(name,opcode,group,instr_type,op0)
#define DEF_ASM_OP2(name,opcode,group,instr_type,op0,op1)
#define DEF_ASM_OP3(name,opcode,group,instr_type,op0,op1,op2)

// 1 "x86_64-asm.h" 1
	DEF_ASM_OP0(clc, 0xf8)/* must be first OP0 */

	DEF_ASM_OP0(cld, 0xfc)
	DEF_ASM_OP0(cli, 0xfa)
	DEF_ASM_OP0(clts, 0x0f06)
	DEF_ASM_OP0(cmc, 0xf5)
	DEF_ASM_OP0(lahf, 0x9f)
	DEF_ASM_OP0(sahf, 0x9e)
	DEF_ASM_OP0(pushfq, 0x9c)
	DEF_ASM_OP0(popfq, 0x9d)
	DEF_ASM_OP0(pushf, 0x9c)
	DEF_ASM_OP0(popf, 0x9d)
	DEF_ASM_OP0(stc, 0xf9)
	DEF_ASM_OP0(std, 0xfd)
	DEF_ASM_OP0(sti, 0xfb)
	DEF_ASM_OP0(aaa, 0x37)
	DEF_ASM_OP0(aas, 0x3f)
	DEF_ASM_OP0(daa, 0x27)
	DEF_ASM_OP0(das, 0x2f)
	DEF_ASM_OP0(aad, 0xd50a)
	DEF_ASM_OP0(aam, 0xd40a)
	DEF_ASM_OP0(cbw, 0x6698)
	DEF_ASM_OP0(cwd, 0x6699)
	DEF_ASM_OP0(cwde, 0x98)
	DEF_ASM_OP0(cdq, 0x99)
	DEF_ASM_OP0(cbtw, 0x6698)
	DEF_ASM_OP0(cwtl, 0x98)
	DEF_ASM_OP0(cwtd, 0x6699)
	DEF_ASM_OP0(cltd, 0x99)
	DEF_ASM_OP0(cqto, 0x4899)
	DEF_ASM_OP0(int3, 0xcc)
	DEF_ASM_OP0(into, 0xce)
	DEF_ASM_OP0(iret, 0xcf)
	DEF_ASM_OP0(iretw, 0x66cf)
	DEF_ASM_OP0(iretl, 0xcf)
	DEF_ASM_OP0(iretq, 0x48cf)
	DEF_ASM_OP0(rsm, 0x0faa)
	DEF_ASM_OP0(hlt, 0xf4)
	DEF_ASM_OP0(wait, 0x9b)
	DEF_ASM_OP0(nop, 0x90)
	DEF_ASM_OP0(pause, 0xf390)
	DEF_ASM_OP0(xlat, 0xd7)

	DEF_ASM_OP0L(vmcall, 0xc1, 0, OPC_0F01)
	DEF_ASM_OP0L(vmlaunch, 0xc2, 0, OPC_0F01)
	DEF_ASM_OP0L(vmresume, 0xc3, 0, OPC_0F01)
	DEF_ASM_OP0L(vmxoff, 0xc4, 0, OPC_0F01)
	/* strings */

	ALT(DEF_ASM_OP0L(cmpsb, 0xa6, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(scmpb, 0xa6, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(insb, 0x6c, 0, OPC_BWL))
	ALT(DEF_ASM_OP0L(outsb, 0x6e, 0, OPC_BWL))

	ALT(DEF_ASM_OP0L(lodsb, 0xac, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(slodb, 0xac, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(movsb, 0xa4, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(smovb, 0xa4, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(scasb, 0xae, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(sscab, 0xae, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(stosb, 0xaa, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(sstob, 0xaa, 0, OPC_BWLX))
	/* bits */

	ALT(DEF_ASM_OP2(bsfw, 0x0fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(bsrw, 0x0fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))

	ALT(DEF_ASM_OP2(btw, 0x0fa3, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btw, 0x0fba, 4, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btsw, 0x0fab, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btsw, 0x0fba, 5, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btrw, 0x0fb3, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btrw, 0x0fba, 6, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btcw, 0x0fbb, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btcw, 0x0fba, 7, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(popcntw, 0xf30fb8, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))

	ALT(DEF_ASM_OP2(tzcntw, 0xf30fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(lzcntw, 0xf30fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	/* prefixes */

	DEF_ASM_OP0(lock, 0xf0)
	DEF_ASM_OP0(rep, 0xf3)
	DEF_ASM_OP0(repe, 0xf3)
	DEF_ASM_OP0(repz, 0xf3)
	DEF_ASM_OP0(repne, 0xf2)
	DEF_ASM_OP0(repnz, 0xf2)

	DEF_ASM_OP0(invd, 0x0f08)
	DEF_ASM_OP0(wbinvd, 0x0f09)
	DEF_ASM_OP0(cpuid, 0x0fa2)
	DEF_ASM_OP0(wrmsr, 0x0f30)
	DEF_ASM_OP0(rdtsc, 0x0f31)
	DEF_ASM_OP0(rdmsr, 0x0f32)
	DEF_ASM_OP0(rdpmc, 0x0f33)

	DEF_ASM_OP0(syscall, 0x0f05)
	DEF_ASM_OP0(sysret, 0x0f07)
	DEF_ASM_OP0L(sysretq, 0x480f07, 0, 0)
	DEF_ASM_OP0(ud2, 0x0f0b)
	/* NOTE: we took the same order as gas opcode definition order */
	/* Right now we can't express the fact that 0xa1/0xa3 can't use $eax and a
	   32 bit moffset as operands.
	ALT(DEF_ASM_OP2(movb, 0xa0, 0, OPC_BWLX, OPT_ADDR, OPT_EAX))
	ALT(DEF_ASM_OP2(movb, 0xa2, 0, OPC_BWLX, OPT_EAX, OPT_ADDR)) */

	ALT(DEF_ASM_OP2(movb, 0x88, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(movb, 0x8a, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
	/* The moves are special: the 0xb8 form supports IM64 (the only insn that
	   does) with REG64.  It doesn't support IM32 with REG64, it would use
	   the full movabs form (64bit immediate).  For IM32->REG64 we prefer
	   the 0xc7 opcode.  So disallow all 64bit forms and code the rest by hand. */

	ALT(DEF_ASM_OP2(movb, 0xb0, 0, OPC_REG | OPC_BWLX, OPT_IM, OPT_REG))
	ALT(DEF_ASM_OP2(mov, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
	ALT(DEF_ASM_OP2(movq, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
	ALT(DEF_ASM_OP2(movb, 0xc6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP2(movw, 0x8c, 0, OPC_MODRM | OPC_WLX, OPT_SEG, OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(movw, 0x8e, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_SEG))

	ALT(DEF_ASM_OP2(movw, 0x0f20, 0, OPC_MODRM | OPC_WLX, OPT_CR, OPT_REG64))
	ALT(DEF_ASM_OP2(movw, 0x0f21, 0, OPC_MODRM | OPC_WLX, OPT_DB, OPT_REG64))
	ALT(DEF_ASM_OP2(movw, 0x0f22, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_CR))
	ALT(DEF_ASM_OP2(movw, 0x0f23, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_DB))

	ALT(DEF_ASM_OP2(movsbw, 0x660fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG16))
	ALT(DEF_ASM_OP2(movsbl, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movsbq, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REGW))
	ALT(DEF_ASM_OP2(movswl, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movswq, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))
	ALT(DEF_ASM_OP2(movslq, 0x63, 0, OPC_MODRM, OPT_REG32 | OPT_EA, OPT_REG))
	ALT(DEF_ASM_OP2(movzbw, 0x0fb6, 0, OPC_MODRM | OPC_WLX, OPT_REG8 | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(movzwl, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movzwq, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))

	ALT(DEF_ASM_OP1(pushq, 0x6a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(push, 0x6a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(pushw, 0x666a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG64))
	ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG16))
	ALT(DEF_ASM_OP1(pushw, 0xff, 6, OPC_MODRM | OPC_WLX, OPT_REG64 | OPT_EA))
	ALT(DEF_ASM_OP1(pushw, 0x6668, 0, 0, OPT_IM16))
	ALT(DEF_ASM_OP1(pushw, 0x68, 0, OPC_WLX, OPT_IM32))
	ALT(DEF_ASM_OP1(pushw, 0x06, 0, OPC_WLX, OPT_SEG))

	ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG64))
	ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG16))
	ALT(DEF_ASM_OP1(popw, 0x8f, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP1(popw, 0x07, 0, OPC_WLX, OPT_SEG))

	ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_REGW, OPT_EAX))
	ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_EAX, OPT_REGW))
	ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG,
			OPT_REG))

	ALT(DEF_ASM_OP2(inb, 0xe4, 0, OPC_BWL, OPT_IM8, OPT_EAX))
	ALT(DEF_ASM_OP1(inb, 0xe4, 0, OPC_BWL, OPT_IM8))
	ALT(DEF_ASM_OP2(inb, 0xec, 0, OPC_BWL, OPT_DX, OPT_EAX))
	ALT(DEF_ASM_OP1(inb, 0xec, 0, OPC_BWL, OPT_DX))

	ALT(DEF_ASM_OP2(outb, 0xe6, 0, OPC_BWL, OPT_EAX, OPT_IM8))
	ALT(DEF_ASM_OP1(outb, 0xe6, 0, OPC_BWL, OPT_IM8))
	ALT(DEF_ASM_OP2(outb, 0xee, 0, OPC_BWL, OPT_EAX, OPT_DX))
	ALT(DEF_ASM_OP1(outb, 0xee, 0, OPC_BWL, OPT_DX))

	ALT(DEF_ASM_OP2(leaw, 0x8d, 0, OPC_MODRM | OPC_WLX, OPT_EA, OPT_REG))

	ALT(DEF_ASM_OP2(les, 0xc4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lds, 0xc5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lss, 0x0fb2, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lfs, 0x0fb4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lgs, 0x0fb5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	/* arith */

	ALT(DEF_ASM_OP2(addb, 0x00, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))/* XXX: use D bit ? */

	ALT(DEF_ASM_OP2(addb, 0x02, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX,
			OPT_EA | OPT_REG, OPT_REG))
	ALT(DEF_ASM_OP2(addb, 0x04, 0, OPC_ARITH | OPC_BWLX, OPT_IM, OPT_EAX))
	ALT(DEF_ASM_OP2(addw, 0x83, 0, OPC_ARITH | OPC_MODRM | OPC_WLX, OPT_IM8S,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(addb, 0x80, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_IM,
			OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG,
			OPT_REG))
	ALT(DEF_ASM_OP2(testb, 0xa8, 0, OPC_BWLX, OPT_IM, OPT_EAX))
	ALT(DEF_ASM_OP2(testb, 0xf6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP1(incb, 0xfe, 0, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(decb, 0xfe, 1, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP1(notb, 0xf6, 2, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(negb, 0xf6, 3, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP1(mulb, 0xf6, 4, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(imulb, 0xf6, 5, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP2(imulw, 0x0faf, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA,
			OPT_REG))
	ALT(DEF_ASM_OP3(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S,
			OPT_REGW | OPT_EA, OPT_REGW))
	ALT(DEF_ASM_OP2(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW))
	ALT(DEF_ASM_OP3(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW))

	ALT(DEF_ASM_OP1(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP2(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
	ALT(DEF_ASM_OP1(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP2(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA,
			OPT_EAX))
	/* shifts */

	ALT(DEF_ASM_OP2(rolb, 0xc0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_IM8,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(rolb, 0xd2, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_CL,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP1(rolb, 0xd0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT,
			OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP3(shldw, 0x0fa4, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shrdw, 0x0fac, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_EA | OPT_REGW))

	ALT(DEF_ASM_OP1(call, 0xff, 2, OPC_MODRM, OPT_INDIR))
	ALT(DEF_ASM_OP1(call, 0xe8, 0, 0, OPT_DISP))
	DEF_ASM_OP1(callq, 0xff, 2, OPC_MODRM, OPT_INDIR)
	ALT(DEF_ASM_OP1(callq, 0xe8, 0, 0, OPT_DISP))
	ALT(DEF_ASM_OP1(jmp, 0xff, 4, OPC_MODRM, OPT_INDIR))
	ALT(DEF_ASM_OP1(jmp, 0xeb, 0, 0, OPT_DISP8))

	ALT(DEF_ASM_OP1(lcall, 0xff, 3, OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(ljmp, 0xff, 5, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(ljmpw, 0x66ff, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(ljmpl, 0xff, 5, OPC_MODRM, OPT_EA)

	ALT(DEF_ASM_OP1(int, 0xcd, 0, 0, OPT_IM8))
	ALT(DEF_ASM_OP1(seto, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
	ALT(DEF_ASM_OP1(setob, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
	DEF_ASM_OP2(enter, 0xc8, 0, 0, OPT_IM16, OPT_IM8)
	DEF_ASM_OP0(leave, 0xc9)
	DEF_ASM_OP0(ret, 0xc3)
	DEF_ASM_OP0(retq, 0xc3)
	ALT(DEF_ASM_OP1(retq, 0xc2, 0, 0, OPT_IM16))
	ALT(DEF_ASM_OP1(ret, 0xc2, 0, 0, OPT_IM16))
	DEF_ASM_OP0(lret, 0xcb)
	ALT(DEF_ASM_OP1(lret, 0xca, 0, 0, OPT_IM16))

	ALT(DEF_ASM_OP1(jo, 0x70, 0, OPC_TEST, OPT_DISP8))
	DEF_ASM_OP1(loopne, 0xe0, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loopnz, 0xe0, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loope, 0xe1, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loopz, 0xe1, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loop, 0xe2, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(jecxz, 0x67e3, 0, 0, OPT_DISP8)
	/* float */
	/* specific fcomp handling */

	ALT(DEF_ASM_OP0L(fcomp, 0xd8d9, 0, 0))

	ALT(DEF_ASM_OP1(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST))
	ALT(DEF_ASM_OP2(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
	ALT(DEF_ASM_OP2(fadd, 0xdcc0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP2(fmul, 0xdcc8, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP0L(fadd, 0xdec1, 0, OPC_FARITH))
	ALT(DEF_ASM_OP1(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST))
	ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
	ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP0L(faddp, 0xdec1, 0, OPC_FARITH))
	ALT(DEF_ASM_OP1(fadds, 0xd8, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(fiaddl, 0xda, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(faddl, 0xdc, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(fiadds, 0xde, 0, OPC_FARITH | OPC_MODRM, OPT_EA))

	DEF_ASM_OP0(fucompp, 0xdae9)
	DEF_ASM_OP0(ftst, 0xd9e4)
	DEF_ASM_OP0(fxam, 0xd9e5)
	DEF_ASM_OP0(fld1, 0xd9e8)
	DEF_ASM_OP0(fldl2t, 0xd9e9)
	DEF_ASM_OP0(fldl2e, 0xd9ea)
	DEF_ASM_OP0(fldpi, 0xd9eb)
	DEF_ASM_OP0(fldlg2, 0xd9ec)
	DEF_ASM_OP0(fldln2, 0xd9ed)
	DEF_ASM_OP0(fldz, 0xd9ee)

	DEF_ASM_OP0(f2xm1, 0xd9f0)
	DEF_ASM_OP0(fyl2x, 0xd9f1)
	DEF_ASM_OP0(fptan, 0xd9f2)
	DEF_ASM_OP0(fpatan, 0xd9f3)
	DEF_ASM_OP0(fxtract, 0xd9f4)
	DEF_ASM_OP0(fprem1, 0xd9f5)
	DEF_ASM_OP0(fdecstp, 0xd9f6)
	DEF_ASM_OP0(fincstp, 0xd9f7)
	DEF_ASM_OP0(fprem, 0xd9f8)
	DEF_ASM_OP0(fyl2xp1, 0xd9f9)
	DEF_ASM_OP0(fsqrt, 0xd9fa)
	DEF_ASM_OP0(fsincos, 0xd9fb)
	DEF_ASM_OP0(frndint, 0xd9fc)
	DEF_ASM_OP0(fscale, 0xd9fd)
	DEF_ASM_OP0(fsin, 0xd9fe)
	DEF_ASM_OP0(fcos, 0xd9ff)
	DEF_ASM_OP0(fchs, 0xd9e0)
	DEF_ASM_OP0(fabs, 0xd9e1)
	DEF_ASM_OP0(fninit, 0xdbe3)
	DEF_ASM_OP0(fnclex, 0xdbe2)
	DEF_ASM_OP0(fnop, 0xd9d0)
	DEF_ASM_OP0(fwait, 0x9b)
	/* fp load */

	DEF_ASM_OP1(fld, 0xd9c0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fldl, 0xd9c0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(flds, 0xd9, 0, OPC_MODRM, OPT_EA)
	ALT(DEF_ASM_OP1(fldl, 0xdd, 0, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(fildl, 0xdb, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fildq, 0xdf, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fildll, 0xdf, 5, OPC_MODRM,OPT_EA)
	DEF_ASM_OP1(fldt, 0xdb, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fbld, 0xdf, 4, OPC_MODRM, OPT_EA)
	/* fp store */

	DEF_ASM_OP1(fst, 0xddd0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fstl, 0xddd0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fsts, 0xd9, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fstps, 0xd9, 3, OPC_MODRM, OPT_EA)
	ALT(DEF_ASM_OP1(fstl, 0xdd, 2, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(fstpl, 0xdd, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fist, 0xdf, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistp, 0xdf, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistl, 0xdb, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistpl, 0xdb, 3, OPC_MODRM, OPT_EA)

	DEF_ASM_OP1(fstp, 0xddd8, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fistpq, 0xdf, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistpll, 0xdf, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fstpt, 0xdb, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fbstp, 0xdf, 6, OPC_MODRM, OPT_EA)
	/* exchange */

	DEF_ASM_OP0(fxch, 0xd9c9)
	ALT(DEF_ASM_OP1(fxch, 0xd9c8, 0, OPC_REG, OPT_ST))
	/* misc FPU */

	DEF_ASM_OP1(fucom, 0xdde0, 0, OPC_REG, OPT_ST )
	DEF_ASM_OP1(fucomp, 0xdde8, 0, OPC_REG, OPT_ST )

	DEF_ASM_OP0L(finit, 0xdbe3, 0, OPC_FWAIT)
	DEF_ASM_OP1(fldcw, 0xd9, 5, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fnstcw, 0xd9, 7, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fstcw, 0xd9, 7, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP0(fnstsw, 0xdfe0)
	ALT(DEF_ASM_OP1(fnstsw, 0xdfe0, 0, 0, OPT_EAX ))
	ALT(DEF_ASM_OP1(fnstsw, 0xdd, 7, OPC_MODRM, OPT_EA ))
	DEF_ASM_OP1(fstsw, 0xdfe0, 0, OPC_FWAIT, OPT_EAX )
	ALT(DEF_ASM_OP0L(fstsw, 0xdfe0, 0, OPC_FWAIT))
	ALT(DEF_ASM_OP1(fstsw, 0xdd, 7, OPC_MODRM | OPC_FWAIT, OPT_EA ))
	DEF_ASM_OP0L(fclex, 0xdbe2, 0, OPC_FWAIT)
	DEF_ASM_OP1(fnstenv, 0xd9, 6, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fstenv, 0xd9, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP1(fldenv, 0xd9, 4, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fnsave, 0xdd, 6, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fsave, 0xdd, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP1(frstor, 0xdd, 4, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(ffree, 0xddc0, 4, OPC_REG, OPT_ST )
	DEF_ASM_OP1(ffreep, 0xdfc0, 4, OPC_REG, OPT_ST )
	DEF_ASM_OP1(fxsave, 0x0fae, 0, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fxrstor, 0x0fae, 1, OPC_MODRM, OPT_EA )
	/* The *q forms of fxrstor/fxsave use a REX prefix.
	       If the operand would use extended registers we would have to modify
	       it instead of generating a second one.  Currently that's no
	       problem with TCC, we don't use extended registers.  */

	DEF_ASM_OP1(fxsaveq, 0x0fae, 0, OPC_MODRM | OPC_48, OPT_EA )
	DEF_ASM_OP1(fxrstorq, 0x0fae, 1, OPC_MODRM | OPC_48, OPT_EA )
	/* segments */

	DEF_ASM_OP2(arpl, 0x63, 0, OPC_MODRM, OPT_REG16, OPT_REG16 | OPT_EA)
	ALT(DEF_ASM_OP2(larw, 0x0f02, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA,
			OPT_REG))
	DEF_ASM_OP1(lgdt, 0x0f01, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lgdtq, 0x0f01, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lidt, 0x0f01, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lidtq, 0x0f01, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lldt, 0x0f00, 2, OPC_MODRM, OPT_EA | OPT_REG)
	DEF_ASM_OP1(lmsw, 0x0f01, 6, OPC_MODRM, OPT_EA | OPT_REG)
	ALT(DEF_ASM_OP2(lslw, 0x0f03, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG,
			OPT_REG))
	DEF_ASM_OP1(ltr, 0x0f00, 3, OPC_MODRM, OPT_EA | OPT_REG16)
	DEF_ASM_OP1(sgdt, 0x0f01, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sgdtq, 0x0f01, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sidt, 0x0f01, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sidtq, 0x0f01, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sldt, 0x0f00, 0, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(smsw, 0x0f01, 4, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM, OPT_REG32 | OPT_EA)
	ALT(DEF_ASM_OP1(str, 0x660f00, 1, OPC_MODRM, OPT_REG16))
	ALT(DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM | OPC_48, OPT_REG64))
	DEF_ASM_OP1(verr, 0x0f00, 4, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(verw, 0x0f00, 5, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP0L(swapgs, 0x0f01, 7, OPC_MODRM)
	/* 486 */
	/* bswap can't be applied to 16bit regs */

	DEF_ASM_OP1(bswap, 0x0fc8, 0, OPC_REG, OPT_REG32 )
	DEF_ASM_OP1(bswapl, 0x0fc8, 0, OPC_REG, OPT_REG32 )
	DEF_ASM_OP1(bswapq, 0x0fc8, 0, OPC_REG | OPC_48, OPT_REG64 )

	ALT(DEF_ASM_OP2(xaddb, 0x0fc0, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_REG | OPT_EA ))
	ALT(DEF_ASM_OP2(cmpxchgb, 0x0fb0, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_REG | OPT_EA ))
	DEF_ASM_OP1(invlpg, 0x0f01, 7, OPC_MODRM, OPT_EA )
	/* pentium */

	DEF_ASM_OP1(cmpxchg8b, 0x0fc7, 1, OPC_MODRM, OPT_EA )
	/* AMD 64 */

	DEF_ASM_OP1(cmpxchg16b, 0x0fc7, 1, OPC_MODRM | OPC_48, OPT_EA )
	/* pentium pro */

	ALT(DEF_ASM_OP2(cmovo, 0x0f40, 0, OPC_MODRM | OPC_TEST | OPC_WLX,
			OPT_REGW | OPT_EA, OPT_REGW))

	DEF_ASM_OP2(fcmovb, 0xdac0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmove, 0xdac8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovbe, 0xdad0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovu, 0xdad8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnb, 0xdbc0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovne, 0xdbc8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnbe, 0xdbd0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnu, 0xdbd8, 0, OPC_REG, OPT_ST, OPT_ST0 )

	DEF_ASM_OP2(fucomi, 0xdbe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcomi, 0xdbf0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fucomip, 0xdfe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcomip, 0xdff0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	/* mmx */

	DEF_ASM_OP0(emms, 0x0f77)/* must be last OP0 */

	DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_MMXSSE )
	/* movd shouldn't accept REG64, but AMD64 spec uses it for 32 and 64 bit
	       moves, so let's be compatible. */

	ALT(DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG64, OPT_MMXSSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f6e, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_MMXSSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f6f, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_MMX ))
	ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG32 ))
	ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))
	ALT(DEF_ASM_OP2(movq, 0x0f7f, 0, OPC_MODRM, OPT_MMX, OPT_EA | OPT_MMX ))
	ALT(DEF_ASM_OP2(movq, 0x660fd6, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_SSE ))
	ALT(DEF_ASM_OP2(movq, 0xf30f7e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))

	DEF_ASM_OP2(packssdw, 0x0f6b, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(packsswb, 0x0f63, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(packuswb, 0x0f67, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddb, 0x0ffc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddw, 0x0ffd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddd, 0x0ffe, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddsb, 0x0fec, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddsw, 0x0fed, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddusb, 0x0fdc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddusw, 0x0fdd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pand, 0x0fdb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pandn, 0x0fdf, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqb, 0x0f74, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqw, 0x0f75, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqd, 0x0f76, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtb, 0x0f64, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtw, 0x0f65, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtd, 0x0f66, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmaddwd, 0x0ff5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmulhw, 0x0fe5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmullw, 0x0fd5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(por, 0x0feb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psllw, 0x0ff1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psllw, 0x0f71, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(pslld, 0x0ff2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(pslld, 0x0f72, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psllq, 0x0ff3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psllq, 0x0f73, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psraw, 0x0fe1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psraw, 0x0f71, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrad, 0x0fe2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrad, 0x0f72, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrlw, 0x0fd1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrlw, 0x0f71, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrld, 0x0fd2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrld, 0x0f72, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrlq, 0x0fd3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrlq, 0x0f73, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psubb, 0x0ff8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubw, 0x0ff9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubd, 0x0ffa, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubsb, 0x0fe8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubsw, 0x0fe9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubusb, 0x0fd8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubusw, 0x0fd9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhbw, 0x0f68, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhwd, 0x0f69, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhdq, 0x0f6a, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpcklbw, 0x0f60, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpcklwd, 0x0f61, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckldq, 0x0f62, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pxor, 0x0fef, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	/* sse */

	DEF_ASM_OP1(ldmxcsr, 0x0fae, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(stmxcsr, 0x0fae, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP2(movups, 0x0f10, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movups, 0x0f11, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(movaps, 0x0f28, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movaps, 0x0f29, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(movhps, 0x0f16, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movhps, 0x0f17, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(addps, 0x0f58, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(cvtpi2ps, 0x0f2a, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_SSE )
	DEF_ASM_OP2(cvtps2pi, 0x0f2d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
	DEF_ASM_OP2(cvttps2pi, 0x0f2c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
	DEF_ASM_OP2(divps, 0x0f5e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(maxps, 0x0f5f, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(minps, 0x0f5d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(mulps, 0x0f59, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pavgb, 0x0fe0, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pavgw, 0x0fe3, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pmaxsw, 0x0fee, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmaxub, 0x0fde, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pminsw, 0x0fea, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pminub, 0x0fda, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(rcpss, 0x0f53, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(rsqrtps, 0x0f52, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(sqrtps, 0x0f51, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(subps, 0x0f5c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	/* movnti should only accept REG32 and REG64, we accept more */

	DEF_ASM_OP2(movnti, 0x0fc3, 0, OPC_MODRM, OPT_REG, OPT_EA)
	DEF_ASM_OP2(movntil, 0x0fc3, 0, OPC_MODRM, OPT_REG32, OPT_EA)
	DEF_ASM_OP2(movntiq, 0x0fc3, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_EA)
	DEF_ASM_OP1(prefetchnta, 0x0f18, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht0, 0x0f18, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht1, 0x0f18, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht2, 0x0f18, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetchw, 0x0f0d, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP0L(lfence, 0x0fae, 5, OPC_MODRM)
	DEF_ASM_OP0L(mfence, 0x0fae, 6, OPC_MODRM)
	DEF_ASM_OP0L(sfence, 0x0fae, 7, OPC_MODRM)
	DEF_ASM_OP1(clflush, 0x0fae, 7, OPC_MODRM, OPT_EA)
	/* Control-Flow Enforcement */

	DEF_ASM_OP0L(endbr64, 0xf30f1e, 7, OPC_MODRM)
#undef ALT
#undef DEF_ASM_OP0
#undef DEF_ASM_OP0L
#undef DEF_ASM_OP1
#undef DEF_ASM_OP2
#undef DEF_ASM_OP3
// 318 "i386-tok.h" 2

#define ALT(x)
#define DEF_ASM_OP0(name,opcode)
#define DEF_ASM_OP0L(name,opcode,group,instr_type) DEF_ASM(name)
#define DEF_ASM_OP1(name,opcode,group,instr_type,op0) DEF_ASM(name)
#define DEF_ASM_OP2(name,opcode,group,instr_type,op0,op1) DEF_ASM(name)
#define DEF_ASM_OP3(name,opcode,group,instr_type,op0,op1,op2) DEF_ASM(name)

// 1 "x86_64-asm.h" 1
	DEF_ASM_OP0(clc, 0xf8)/* must be first OP0 */

	DEF_ASM_OP0(cld, 0xfc)
	DEF_ASM_OP0(cli, 0xfa)
	DEF_ASM_OP0(clts, 0x0f06)
	DEF_ASM_OP0(cmc, 0xf5)
	DEF_ASM_OP0(lahf, 0x9f)
	DEF_ASM_OP0(sahf, 0x9e)
	DEF_ASM_OP0(pushfq, 0x9c)
	DEF_ASM_OP0(popfq, 0x9d)
	DEF_ASM_OP0(pushf, 0x9c)
	DEF_ASM_OP0(popf, 0x9d)
	DEF_ASM_OP0(stc, 0xf9)
	DEF_ASM_OP0(std, 0xfd)
	DEF_ASM_OP0(sti, 0xfb)
	DEF_ASM_OP0(aaa, 0x37)
	DEF_ASM_OP0(aas, 0x3f)
	DEF_ASM_OP0(daa, 0x27)
	DEF_ASM_OP0(das, 0x2f)
	DEF_ASM_OP0(aad, 0xd50a)
	DEF_ASM_OP0(aam, 0xd40a)
	DEF_ASM_OP0(cbw, 0x6698)
	DEF_ASM_OP0(cwd, 0x6699)
	DEF_ASM_OP0(cwde, 0x98)
	DEF_ASM_OP0(cdq, 0x99)
	DEF_ASM_OP0(cbtw, 0x6698)
	DEF_ASM_OP0(cwtl, 0x98)
	DEF_ASM_OP0(cwtd, 0x6699)
	DEF_ASM_OP0(cltd, 0x99)
	DEF_ASM_OP0(cqto, 0x4899)
	DEF_ASM_OP0(int3, 0xcc)
	DEF_ASM_OP0(into, 0xce)
	DEF_ASM_OP0(iret, 0xcf)
	DEF_ASM_OP0(iretw, 0x66cf)
	DEF_ASM_OP0(iretl, 0xcf)
	DEF_ASM_OP0(iretq, 0x48cf)
	DEF_ASM_OP0(rsm, 0x0faa)
	DEF_ASM_OP0(hlt, 0xf4)
	DEF_ASM_OP0(wait, 0x9b)
	DEF_ASM_OP0(nop, 0x90)
	DEF_ASM_OP0(pause, 0xf390)
	DEF_ASM_OP0(xlat, 0xd7)

	DEF_ASM_OP0L(vmcall, 0xc1, 0, OPC_0F01)
	DEF_ASM_OP0L(vmlaunch, 0xc2, 0, OPC_0F01)
	DEF_ASM_OP0L(vmresume, 0xc3, 0, OPC_0F01)
	DEF_ASM_OP0L(vmxoff, 0xc4, 0, OPC_0F01)
	/* strings */

	ALT(DEF_ASM_OP0L(cmpsb, 0xa6, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(scmpb, 0xa6, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(insb, 0x6c, 0, OPC_BWL))
	ALT(DEF_ASM_OP0L(outsb, 0x6e, 0, OPC_BWL))

	ALT(DEF_ASM_OP0L(lodsb, 0xac, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(slodb, 0xac, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(movsb, 0xa4, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(smovb, 0xa4, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(scasb, 0xae, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(sscab, 0xae, 0, OPC_BWLX))

	ALT(DEF_ASM_OP0L(stosb, 0xaa, 0, OPC_BWLX))
	ALT(DEF_ASM_OP0L(sstob, 0xaa, 0, OPC_BWLX))
	/* bits */

	ALT(DEF_ASM_OP2(bsfw, 0x0fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(bsrw, 0x0fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))

	ALT(DEF_ASM_OP2(btw, 0x0fa3, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btw, 0x0fba, 4, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btsw, 0x0fab, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btsw, 0x0fba, 5, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btrw, 0x0fb3, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btrw, 0x0fba, 6, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(btcw, 0x0fbb, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP2(btcw, 0x0fba, 7, OPC_MODRM | OPC_WLX, OPT_IM8,
			OPT_REGW | OPT_EA))

	ALT(DEF_ASM_OP2(popcntw, 0xf30fb8, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))

	ALT(DEF_ASM_OP2(tzcntw, 0xf30fbc, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(lzcntw, 0xf30fbd, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA,
			OPT_REGW))
	/* prefixes */

	DEF_ASM_OP0(lock, 0xf0)
	DEF_ASM_OP0(rep, 0xf3)
	DEF_ASM_OP0(repe, 0xf3)
	DEF_ASM_OP0(repz, 0xf3)
	DEF_ASM_OP0(repne, 0xf2)
	DEF_ASM_OP0(repnz, 0xf2)

	DEF_ASM_OP0(invd, 0x0f08)
	DEF_ASM_OP0(wbinvd, 0x0f09)
	DEF_ASM_OP0(cpuid, 0x0fa2)
	DEF_ASM_OP0(wrmsr, 0x0f30)
	DEF_ASM_OP0(rdtsc, 0x0f31)
	DEF_ASM_OP0(rdmsr, 0x0f32)
	DEF_ASM_OP0(rdpmc, 0x0f33)

	DEF_ASM_OP0(syscall, 0x0f05)
	DEF_ASM_OP0(sysret, 0x0f07)
	DEF_ASM_OP0L(sysretq, 0x480f07, 0, 0)
	DEF_ASM_OP0(ud2, 0x0f0b)
	/* NOTE: we took the same order as gas opcode definition order */
	/* Right now we can't express the fact that 0xa1/0xa3 can't use $eax and a
	   32 bit moffset as operands.
	ALT(DEF_ASM_OP2(movb, 0xa0, 0, OPC_BWLX, OPT_ADDR, OPT_EAX))
	ALT(DEF_ASM_OP2(movb, 0xa2, 0, OPC_BWLX, OPT_EAX, OPT_ADDR)) */

	ALT(DEF_ASM_OP2(movb, 0x88, 0, OPC_MODRM | OPC_BWLX, OPT_REG, OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(movb, 0x8a, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG, OPT_REG))
	/* The moves are special: the 0xb8 form supports IM64 (the only insn that
	   does) with REG64.  It doesn't support IM32 with REG64, it would use
	   the full movabs form (64bit immediate).  For IM32->REG64 we prefer
	   the 0xc7 opcode.  So disallow all 64bit forms and code the rest by hand. */

	ALT(DEF_ASM_OP2(movb, 0xb0, 0, OPC_REG | OPC_BWLX, OPT_IM, OPT_REG))
	ALT(DEF_ASM_OP2(mov, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
	ALT(DEF_ASM_OP2(movq, 0xb8, 0, OPC_REG, OPT_IM64, OPT_REG64))
	ALT(DEF_ASM_OP2(movb, 0xc6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP2(movw, 0x8c, 0, OPC_MODRM | OPC_WLX, OPT_SEG, OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(movw, 0x8e, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG, OPT_SEG))

	ALT(DEF_ASM_OP2(movw, 0x0f20, 0, OPC_MODRM | OPC_WLX, OPT_CR, OPT_REG64))
	ALT(DEF_ASM_OP2(movw, 0x0f21, 0, OPC_MODRM | OPC_WLX, OPT_DB, OPT_REG64))
	ALT(DEF_ASM_OP2(movw, 0x0f22, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_CR))
	ALT(DEF_ASM_OP2(movw, 0x0f23, 0, OPC_MODRM | OPC_WLX, OPT_REG64, OPT_DB))

	ALT(DEF_ASM_OP2(movsbw, 0x660fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG16))
	ALT(DEF_ASM_OP2(movsbl, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movsbq, 0x0fbe, 0, OPC_MODRM, OPT_REG8 | OPT_EA, OPT_REGW))
	ALT(DEF_ASM_OP2(movswl, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movswq, 0x0fbf, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))
	ALT(DEF_ASM_OP2(movslq, 0x63, 0, OPC_MODRM, OPT_REG32 | OPT_EA, OPT_REG))
	ALT(DEF_ASM_OP2(movzbw, 0x0fb6, 0, OPC_MODRM | OPC_WLX, OPT_REG8 | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(movzwl, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(movzwq, 0x0fb7, 0, OPC_MODRM, OPT_REG16 | OPT_EA, OPT_REG))

	ALT(DEF_ASM_OP1(pushq, 0x6a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(push, 0x6a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(pushw, 0x666a, 0, 0, OPT_IM8S))
	ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG64))
	ALT(DEF_ASM_OP1(pushw, 0x50, 0, OPC_REG | OPC_WLX, OPT_REG16))
	ALT(DEF_ASM_OP1(pushw, 0xff, 6, OPC_MODRM | OPC_WLX, OPT_REG64 | OPT_EA))
	ALT(DEF_ASM_OP1(pushw, 0x6668, 0, 0, OPT_IM16))
	ALT(DEF_ASM_OP1(pushw, 0x68, 0, OPC_WLX, OPT_IM32))
	ALT(DEF_ASM_OP1(pushw, 0x06, 0, OPC_WLX, OPT_SEG))

	ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG64))
	ALT(DEF_ASM_OP1(popw, 0x58, 0, OPC_REG | OPC_WLX, OPT_REG16))
	ALT(DEF_ASM_OP1(popw, 0x8f, 0, OPC_MODRM | OPC_WLX, OPT_REGW | OPT_EA))
	ALT(DEF_ASM_OP1(popw, 0x07, 0, OPC_WLX, OPT_SEG))

	ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_REGW, OPT_EAX))
	ALT(DEF_ASM_OP2(xchgw, 0x90, 0, OPC_REG | OPC_WLX, OPT_EAX, OPT_REGW))
	ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(xchgb, 0x86, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG,
			OPT_REG))

	ALT(DEF_ASM_OP2(inb, 0xe4, 0, OPC_BWL, OPT_IM8, OPT_EAX))
	ALT(DEF_ASM_OP1(inb, 0xe4, 0, OPC_BWL, OPT_IM8))
	ALT(DEF_ASM_OP2(inb, 0xec, 0, OPC_BWL, OPT_DX, OPT_EAX))
	ALT(DEF_ASM_OP1(inb, 0xec, 0, OPC_BWL, OPT_DX))

	ALT(DEF_ASM_OP2(outb, 0xe6, 0, OPC_BWL, OPT_EAX, OPT_IM8))
	ALT(DEF_ASM_OP1(outb, 0xe6, 0, OPC_BWL, OPT_IM8))
	ALT(DEF_ASM_OP2(outb, 0xee, 0, OPC_BWL, OPT_EAX, OPT_DX))
	ALT(DEF_ASM_OP1(outb, 0xee, 0, OPC_BWL, OPT_DX))

	ALT(DEF_ASM_OP2(leaw, 0x8d, 0, OPC_MODRM | OPC_WLX, OPT_EA, OPT_REG))

	ALT(DEF_ASM_OP2(les, 0xc4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lds, 0xc5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lss, 0x0fb2, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lfs, 0x0fb4, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	ALT(DEF_ASM_OP2(lgs, 0x0fb5, 0, OPC_MODRM, OPT_EA, OPT_REG32))
	/* arith */

	ALT(DEF_ASM_OP2(addb, 0x00, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))/* XXX: use D bit ? */

	ALT(DEF_ASM_OP2(addb, 0x02, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX,
			OPT_EA | OPT_REG, OPT_REG))
	ALT(DEF_ASM_OP2(addb, 0x04, 0, OPC_ARITH | OPC_BWLX, OPT_IM, OPT_EAX))
	ALT(DEF_ASM_OP2(addw, 0x83, 0, OPC_ARITH | OPC_MODRM | OPC_WLX, OPT_IM8S,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(addb, 0x80, 0, OPC_ARITH | OPC_MODRM | OPC_BWLX, OPT_IM,
			OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(testb, 0x84, 0, OPC_MODRM | OPC_BWLX, OPT_EA | OPT_REG,
			OPT_REG))
	ALT(DEF_ASM_OP2(testb, 0xa8, 0, OPC_BWLX, OPT_IM, OPT_EAX))
	ALT(DEF_ASM_OP2(testb, 0xf6, 0, OPC_MODRM | OPC_BWLX, OPT_IM, OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP1(incb, 0xfe, 0, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(decb, 0xfe, 1, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP1(notb, 0xf6, 2, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(negb, 0xf6, 3, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP1(mulb, 0xf6, 4, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP1(imulb, 0xf6, 5, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))

	ALT(DEF_ASM_OP2(imulw, 0x0faf, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA,
			OPT_REG))
	ALT(DEF_ASM_OP3(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S,
			OPT_REGW | OPT_EA, OPT_REGW))
	ALT(DEF_ASM_OP2(imulw, 0x6b, 0, OPC_MODRM | OPC_WLX, OPT_IM8S, OPT_REGW))
	ALT(DEF_ASM_OP3(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW | OPT_EA,
			OPT_REGW))
	ALT(DEF_ASM_OP2(imulw, 0x69, 0, OPC_MODRM | OPC_WLX, OPT_IMW, OPT_REGW))

	ALT(DEF_ASM_OP1(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP2(divb, 0xf6, 6, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA, OPT_EAX))
	ALT(DEF_ASM_OP1(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA))
	ALT(DEF_ASM_OP2(idivb, 0xf6, 7, OPC_MODRM | OPC_BWLX, OPT_REG | OPT_EA,
			OPT_EAX))
	/* shifts */

	ALT(DEF_ASM_OP2(rolb, 0xc0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_IM8,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP2(rolb, 0xd2, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT, OPT_CL,
			OPT_EA | OPT_REG))
	ALT(DEF_ASM_OP1(rolb, 0xd0, 0, OPC_MODRM | OPC_BWLX | OPC_SHIFT,
			OPT_EA | OPT_REG))

	ALT(DEF_ASM_OP3(shldw, 0x0fa4, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(shldw, 0x0fa5, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shrdw, 0x0fac, 0, OPC_MODRM | OPC_WLX, OPT_IM8, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP3(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_CL, OPT_REGW,
			OPT_EA | OPT_REGW))
	ALT(DEF_ASM_OP2(shrdw, 0x0fad, 0, OPC_MODRM | OPC_WLX, OPT_REGW,
			OPT_EA | OPT_REGW))

	ALT(DEF_ASM_OP1(call, 0xff, 2, OPC_MODRM, OPT_INDIR))
	ALT(DEF_ASM_OP1(call, 0xe8, 0, 0, OPT_DISP))
	DEF_ASM_OP1(callq, 0xff, 2, OPC_MODRM, OPT_INDIR)
	ALT(DEF_ASM_OP1(callq, 0xe8, 0, 0, OPT_DISP))
	ALT(DEF_ASM_OP1(jmp, 0xff, 4, OPC_MODRM, OPT_INDIR))
	ALT(DEF_ASM_OP1(jmp, 0xeb, 0, 0, OPT_DISP8))

	ALT(DEF_ASM_OP1(lcall, 0xff, 3, OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(ljmp, 0xff, 5, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(ljmpw, 0x66ff, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(ljmpl, 0xff, 5, OPC_MODRM, OPT_EA)

	ALT(DEF_ASM_OP1(int, 0xcd, 0, 0, OPT_IM8))
	ALT(DEF_ASM_OP1(seto, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
	ALT(DEF_ASM_OP1(setob, 0x0f90, 0, OPC_MODRM | OPC_TEST, OPT_REG8 | OPT_EA))
	DEF_ASM_OP2(enter, 0xc8, 0, 0, OPT_IM16, OPT_IM8)
	DEF_ASM_OP0(leave, 0xc9)
	DEF_ASM_OP0(ret, 0xc3)
	DEF_ASM_OP0(retq, 0xc3)
	ALT(DEF_ASM_OP1(retq, 0xc2, 0, 0, OPT_IM16))
	ALT(DEF_ASM_OP1(ret, 0xc2, 0, 0, OPT_IM16))
	DEF_ASM_OP0(lret, 0xcb)
	ALT(DEF_ASM_OP1(lret, 0xca, 0, 0, OPT_IM16))

	ALT(DEF_ASM_OP1(jo, 0x70, 0, OPC_TEST, OPT_DISP8))
	DEF_ASM_OP1(loopne, 0xe0, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loopnz, 0xe0, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loope, 0xe1, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loopz, 0xe1, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(loop, 0xe2, 0, 0, OPT_DISP8)
	DEF_ASM_OP1(jecxz, 0x67e3, 0, 0, OPT_DISP8)
	/* float */
	/* specific fcomp handling */

	ALT(DEF_ASM_OP0L(fcomp, 0xd8d9, 0, 0))

	ALT(DEF_ASM_OP1(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST))
	ALT(DEF_ASM_OP2(fadd, 0xd8c0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
	ALT(DEF_ASM_OP2(fadd, 0xdcc0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP2(fmul, 0xdcc8, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP0L(fadd, 0xdec1, 0, OPC_FARITH))
	ALT(DEF_ASM_OP1(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST))
	ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST, OPT_ST0))
	ALT(DEF_ASM_OP2(faddp, 0xdec0, 0, OPC_FARITH | OPC_REG, OPT_ST0, OPT_ST))
	ALT(DEF_ASM_OP0L(faddp, 0xdec1, 0, OPC_FARITH))
	ALT(DEF_ASM_OP1(fadds, 0xd8, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(fiaddl, 0xda, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(faddl, 0xdc, 0, OPC_FARITH | OPC_MODRM, OPT_EA))
	ALT(DEF_ASM_OP1(fiadds, 0xde, 0, OPC_FARITH | OPC_MODRM, OPT_EA))

	DEF_ASM_OP0(fucompp, 0xdae9)
	DEF_ASM_OP0(ftst, 0xd9e4)
	DEF_ASM_OP0(fxam, 0xd9e5)
	DEF_ASM_OP0(fld1, 0xd9e8)
	DEF_ASM_OP0(fldl2t, 0xd9e9)
	DEF_ASM_OP0(fldl2e, 0xd9ea)
	DEF_ASM_OP0(fldpi, 0xd9eb)
	DEF_ASM_OP0(fldlg2, 0xd9ec)
	DEF_ASM_OP0(fldln2, 0xd9ed)
	DEF_ASM_OP0(fldz, 0xd9ee)

	DEF_ASM_OP0(f2xm1, 0xd9f0)
	DEF_ASM_OP0(fyl2x, 0xd9f1)
	DEF_ASM_OP0(fptan, 0xd9f2)
	DEF_ASM_OP0(fpatan, 0xd9f3)
	DEF_ASM_OP0(fxtract, 0xd9f4)
	DEF_ASM_OP0(fprem1, 0xd9f5)
	DEF_ASM_OP0(fdecstp, 0xd9f6)
	DEF_ASM_OP0(fincstp, 0xd9f7)
	DEF_ASM_OP0(fprem, 0xd9f8)
	DEF_ASM_OP0(fyl2xp1, 0xd9f9)
	DEF_ASM_OP0(fsqrt, 0xd9fa)
	DEF_ASM_OP0(fsincos, 0xd9fb)
	DEF_ASM_OP0(frndint, 0xd9fc)
	DEF_ASM_OP0(fscale, 0xd9fd)
	DEF_ASM_OP0(fsin, 0xd9fe)
	DEF_ASM_OP0(fcos, 0xd9ff)
	DEF_ASM_OP0(fchs, 0xd9e0)
	DEF_ASM_OP0(fabs, 0xd9e1)
	DEF_ASM_OP0(fninit, 0xdbe3)
	DEF_ASM_OP0(fnclex, 0xdbe2)
	DEF_ASM_OP0(fnop, 0xd9d0)
	DEF_ASM_OP0(fwait, 0x9b)
	/* fp load */

	DEF_ASM_OP1(fld, 0xd9c0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fldl, 0xd9c0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(flds, 0xd9, 0, OPC_MODRM, OPT_EA)
	ALT(DEF_ASM_OP1(fldl, 0xdd, 0, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(fildl, 0xdb, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fildq, 0xdf, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fildll, 0xdf, 5, OPC_MODRM,OPT_EA)
	DEF_ASM_OP1(fldt, 0xdb, 5, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fbld, 0xdf, 4, OPC_MODRM, OPT_EA)
	/* fp store */

	DEF_ASM_OP1(fst, 0xddd0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fstl, 0xddd0, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fsts, 0xd9, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fstps, 0xd9, 3, OPC_MODRM, OPT_EA)
	ALT(DEF_ASM_OP1(fstl, 0xdd, 2, OPC_MODRM, OPT_EA))
	DEF_ASM_OP1(fstpl, 0xdd, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fist, 0xdf, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistp, 0xdf, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistl, 0xdb, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistpl, 0xdb, 3, OPC_MODRM, OPT_EA)

	DEF_ASM_OP1(fstp, 0xddd8, 0, OPC_REG, OPT_ST)
	DEF_ASM_OP1(fistpq, 0xdf, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fistpll, 0xdf, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fstpt, 0xdb, 7, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(fbstp, 0xdf, 6, OPC_MODRM, OPT_EA)
	/* exchange */

	DEF_ASM_OP0(fxch, 0xd9c9)
	ALT(DEF_ASM_OP1(fxch, 0xd9c8, 0, OPC_REG, OPT_ST))
	/* misc FPU */

	DEF_ASM_OP1(fucom, 0xdde0, 0, OPC_REG, OPT_ST )
	DEF_ASM_OP1(fucomp, 0xdde8, 0, OPC_REG, OPT_ST )

	DEF_ASM_OP0L(finit, 0xdbe3, 0, OPC_FWAIT)
	DEF_ASM_OP1(fldcw, 0xd9, 5, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fnstcw, 0xd9, 7, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fstcw, 0xd9, 7, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP0(fnstsw, 0xdfe0)
	ALT(DEF_ASM_OP1(fnstsw, 0xdfe0, 0, 0, OPT_EAX ))
	ALT(DEF_ASM_OP1(fnstsw, 0xdd, 7, OPC_MODRM, OPT_EA ))
	DEF_ASM_OP1(fstsw, 0xdfe0, 0, OPC_FWAIT, OPT_EAX )
	ALT(DEF_ASM_OP0L(fstsw, 0xdfe0, 0, OPC_FWAIT))
	ALT(DEF_ASM_OP1(fstsw, 0xdd, 7, OPC_MODRM | OPC_FWAIT, OPT_EA ))
	DEF_ASM_OP0L(fclex, 0xdbe2, 0, OPC_FWAIT)
	DEF_ASM_OP1(fnstenv, 0xd9, 6, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fstenv, 0xd9, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP1(fldenv, 0xd9, 4, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fnsave, 0xdd, 6, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fsave, 0xdd, 6, OPC_MODRM | OPC_FWAIT, OPT_EA )
	DEF_ASM_OP1(frstor, 0xdd, 4, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(ffree, 0xddc0, 4, OPC_REG, OPT_ST )
	DEF_ASM_OP1(ffreep, 0xdfc0, 4, OPC_REG, OPT_ST )
	DEF_ASM_OP1(fxsave, 0x0fae, 0, OPC_MODRM, OPT_EA )
	DEF_ASM_OP1(fxrstor, 0x0fae, 1, OPC_MODRM, OPT_EA )
	/* The *q forms of fxrstor/fxsave use a REX prefix.
	       If the operand would use extended registers we would have to modify
	       it instead of generating a second one.  Currently that's no
	       problem with TCC, we don't use extended registers.  */

	DEF_ASM_OP1(fxsaveq, 0x0fae, 0, OPC_MODRM | OPC_48, OPT_EA )
	DEF_ASM_OP1(fxrstorq, 0x0fae, 1, OPC_MODRM | OPC_48, OPT_EA )
	/* segments */

	DEF_ASM_OP2(arpl, 0x63, 0, OPC_MODRM, OPT_REG16, OPT_REG16 | OPT_EA)
	ALT(DEF_ASM_OP2(larw, 0x0f02, 0, OPC_MODRM | OPC_WLX, OPT_REG | OPT_EA,
			OPT_REG))
	DEF_ASM_OP1(lgdt, 0x0f01, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lgdtq, 0x0f01, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lidt, 0x0f01, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lidtq, 0x0f01, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(lldt, 0x0f00, 2, OPC_MODRM, OPT_EA | OPT_REG)
	DEF_ASM_OP1(lmsw, 0x0f01, 6, OPC_MODRM, OPT_EA | OPT_REG)
	ALT(DEF_ASM_OP2(lslw, 0x0f03, 0, OPC_MODRM | OPC_WLX, OPT_EA | OPT_REG,
			OPT_REG))
	DEF_ASM_OP1(ltr, 0x0f00, 3, OPC_MODRM, OPT_EA | OPT_REG16)
	DEF_ASM_OP1(sgdt, 0x0f01, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sgdtq, 0x0f01, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sidt, 0x0f01, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sidtq, 0x0f01, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(sldt, 0x0f00, 0, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(smsw, 0x0f01, 4, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM, OPT_REG32 | OPT_EA)
	ALT(DEF_ASM_OP1(str, 0x660f00, 1, OPC_MODRM, OPT_REG16))
	ALT(DEF_ASM_OP1(str, 0x0f00, 1, OPC_MODRM | OPC_48, OPT_REG64))
	DEF_ASM_OP1(verr, 0x0f00, 4, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP1(verw, 0x0f00, 5, OPC_MODRM, OPT_REG | OPT_EA)
	DEF_ASM_OP0L(swapgs, 0x0f01, 7, OPC_MODRM)
	/* 486 */
	/* bswap can't be applied to 16bit regs */

	DEF_ASM_OP1(bswap, 0x0fc8, 0, OPC_REG, OPT_REG32 )
	DEF_ASM_OP1(bswapl, 0x0fc8, 0, OPC_REG, OPT_REG32 )
	DEF_ASM_OP1(bswapq, 0x0fc8, 0, OPC_REG | OPC_48, OPT_REG64 )

	ALT(DEF_ASM_OP2(xaddb, 0x0fc0, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_REG | OPT_EA ))
	ALT(DEF_ASM_OP2(cmpxchgb, 0x0fb0, 0, OPC_MODRM | OPC_BWLX, OPT_REG,
			OPT_REG | OPT_EA ))
	DEF_ASM_OP1(invlpg, 0x0f01, 7, OPC_MODRM, OPT_EA )
	/* pentium */

	DEF_ASM_OP1(cmpxchg8b, 0x0fc7, 1, OPC_MODRM, OPT_EA )
	/* AMD 64 */

	DEF_ASM_OP1(cmpxchg16b, 0x0fc7, 1, OPC_MODRM | OPC_48, OPT_EA )
	/* pentium pro */

	ALT(DEF_ASM_OP2(cmovo, 0x0f40, 0, OPC_MODRM | OPC_TEST | OPC_WLX,
			OPT_REGW | OPT_EA, OPT_REGW))

	DEF_ASM_OP2(fcmovb, 0xdac0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmove, 0xdac8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovbe, 0xdad0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovu, 0xdad8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnb, 0xdbc0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovne, 0xdbc8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnbe, 0xdbd0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcmovnu, 0xdbd8, 0, OPC_REG, OPT_ST, OPT_ST0 )

	DEF_ASM_OP2(fucomi, 0xdbe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcomi, 0xdbf0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fucomip, 0xdfe8, 0, OPC_REG, OPT_ST, OPT_ST0 )
	DEF_ASM_OP2(fcomip, 0xdff0, 0, OPC_REG, OPT_ST, OPT_ST0 )
	/* mmx */

	DEF_ASM_OP0(emms, 0x0f77)/* must be last OP0 */

	DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_MMXSSE )
	/* movd shouldn't accept REG64, but AMD64 spec uses it for 32 and 64 bit
	       moves, so let's be compatible. */

	ALT(DEF_ASM_OP2(movd, 0x0f6e, 0, OPC_MODRM, OPT_EA | OPT_REG64, OPT_MMXSSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f6e, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_MMXSSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f6f, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_MMX ))
	ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG32 ))
	ALT(DEF_ASM_OP2(movd, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))
	ALT(DEF_ASM_OP2(movq, 0x0f7f, 0, OPC_MODRM, OPT_MMX, OPT_EA | OPT_MMX ))
	ALT(DEF_ASM_OP2(movq, 0x660fd6, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_SSE ))
	ALT(DEF_ASM_OP2(movq, 0xf30f7e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE ))
	ALT(DEF_ASM_OP2(movq, 0x0f7e, 0, OPC_MODRM, OPT_MMXSSE, OPT_EA | OPT_REG64 ))

	DEF_ASM_OP2(packssdw, 0x0f6b, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(packsswb, 0x0f63, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(packuswb, 0x0f67, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddb, 0x0ffc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddw, 0x0ffd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddd, 0x0ffe, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddsb, 0x0fec, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddsw, 0x0fed, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddusb, 0x0fdc, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(paddusw, 0x0fdd, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pand, 0x0fdb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pandn, 0x0fdf, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqb, 0x0f74, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqw, 0x0f75, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpeqd, 0x0f76, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtb, 0x0f64, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtw, 0x0f65, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pcmpgtd, 0x0f66, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmaddwd, 0x0ff5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmulhw, 0x0fe5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmullw, 0x0fd5, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(por, 0x0feb, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psllw, 0x0ff1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psllw, 0x0f71, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(pslld, 0x0ff2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(pslld, 0x0f72, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psllq, 0x0ff3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psllq, 0x0f73, 6, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psraw, 0x0fe1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psraw, 0x0f71, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrad, 0x0fe2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrad, 0x0f72, 4, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrlw, 0x0fd1, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrlw, 0x0f71, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrld, 0x0fd2, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrld, 0x0f72, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psrlq, 0x0fd3, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	ALT(DEF_ASM_OP2(psrlq, 0x0f73, 2, OPC_MODRM, OPT_IM8, OPT_MMXSSE ))
	DEF_ASM_OP2(psubb, 0x0ff8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubw, 0x0ff9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubd, 0x0ffa, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubsb, 0x0fe8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubsw, 0x0fe9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubusb, 0x0fd8, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(psubusw, 0x0fd9, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhbw, 0x0f68, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhwd, 0x0f69, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckhdq, 0x0f6a, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpcklbw, 0x0f60, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpcklwd, 0x0f61, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(punpckldq, 0x0f62, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pxor, 0x0fef, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	/* sse */

	DEF_ASM_OP1(ldmxcsr, 0x0fae, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(stmxcsr, 0x0fae, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP2(movups, 0x0f10, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movups, 0x0f11, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(movaps, 0x0f28, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movaps, 0x0f29, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(movhps, 0x0f16, 0, OPC_MODRM, OPT_EA | OPT_REG32, OPT_SSE )
	ALT(DEF_ASM_OP2(movhps, 0x0f17, 0, OPC_MODRM, OPT_SSE, OPT_EA | OPT_REG32 ))
	DEF_ASM_OP2(addps, 0x0f58, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(cvtpi2ps, 0x0f2a, 0, OPC_MODRM, OPT_EA | OPT_MMX, OPT_SSE )
	DEF_ASM_OP2(cvtps2pi, 0x0f2d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
	DEF_ASM_OP2(cvttps2pi, 0x0f2c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_MMX )
	DEF_ASM_OP2(divps, 0x0f5e, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(maxps, 0x0f5f, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(minps, 0x0f5d, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(mulps, 0x0f59, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pavgb, 0x0fe0, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pavgw, 0x0fe3, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(pmaxsw, 0x0fee, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pmaxub, 0x0fde, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pminsw, 0x0fea, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(pminub, 0x0fda, 0, OPC_MODRM, OPT_EA | OPT_MMXSSE, OPT_MMXSSE )
	DEF_ASM_OP2(rcpss, 0x0f53, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(rsqrtps, 0x0f52, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(sqrtps, 0x0f51, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	DEF_ASM_OP2(subps, 0x0f5c, 0, OPC_MODRM, OPT_EA | OPT_SSE, OPT_SSE )
	/* movnti should only accept REG32 and REG64, we accept more */

	DEF_ASM_OP2(movnti, 0x0fc3, 0, OPC_MODRM, OPT_REG, OPT_EA)
	DEF_ASM_OP2(movntil, 0x0fc3, 0, OPC_MODRM, OPT_REG32, OPT_EA)
	DEF_ASM_OP2(movntiq, 0x0fc3, 0, OPC_MODRM | OPC_48, OPT_REG64, OPT_EA)
	DEF_ASM_OP1(prefetchnta, 0x0f18, 0, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht0, 0x0f18, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht1, 0x0f18, 2, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetcht2, 0x0f18, 3, OPC_MODRM, OPT_EA)
	DEF_ASM_OP1(prefetchw, 0x0f0d, 1, OPC_MODRM, OPT_EA)
	DEF_ASM_OP0L(lfence, 0x0fae, 5, OPC_MODRM)
	DEF_ASM_OP0L(mfence, 0x0fae, 6, OPC_MODRM)
	DEF_ASM_OP0L(sfence, 0x0fae, 7, OPC_MODRM)
	DEF_ASM_OP1(clflush, 0x0fae, 7, OPC_MODRM, OPT_EA)
	/* Control-Flow Enforcement */

	DEF_ASM_OP0L(endbr64, 0xf30f1e, 7, OPC_MODRM)
#undef ALT
#undef DEF_ASM_OP0
#undef DEF_ASM_OP0L
#undef DEF_ASM_OP1
#undef DEF_ASM_OP2
#undef DEF_ASM_OP3
// 330 "i386-tok.h" 2
// 412 "tcctok.h" 2
// 67 "tccpp.c" 2
#undef DEF
	;
/* WARNING: the content of this string encodes token numbers */

static const unsigned char tok_two_chars[] =
	/* outdated -- gr
	    "<=\236>=\235!=\225&&\240||\241++\244--\242==\224<<\1>>\2+=\253"
	    "-=\255*=\252/=\257%=\245&=\246^=\336|=\374->\313..\250##\266";
	*/

{
	'<','=', TOK_LE,
	'>','=', TOK_GE,
	'!','=', TOK_NE,
	'&','&', TOK_LAND,
	'|','|', TOK_LOR,
	'+','+', TOK_INC,
	'-','-', TOK_DEC,
	'=','=', TOK_EQ,
	'<','<', TOK_SHL,
	'>','>', TOK_SAR,
	'+','=', TOK_A_ADD,
	'-','=', TOK_A_SUB,
	'*','=', TOK_A_MUL,
	'/','=', TOK_A_DIV,
	'%','=', TOK_A_MOD,
	'&','=', TOK_A_AND,
	'^','=', TOK_A_XOR,
	'|','=', TOK_A_OR,
	'-','>', TOK_ARROW,
	'.','.', TOK_TWODOTS,
	'#','#', TOK_TWOSHARPS,
	0
};

ST_FUNC void skip(int c)
{
	if (tok != c) {
		char tmp[40];
		pstrcpy(tmp, sizeof tmp, get_tok_str(c, &tokc));
		tcc_error("'%s' expected (got \"%s\")", tmp, get_tok_str(tok, &tokc));
	}
	next();
}

ST_FUNC void expect(const char *msg)
{
	tcc_error("%s expected", msg);
}
/* ------------------------------------------------------------------------- */
/* Custom allocator for tiny objects */

#define USE_TAL
#ifndef USE_TAL

#define tal_free(al, p) tcc_free(p)
#define tal_realloc(al, p, size) tcc_realloc(p, size)
#define tal_new(a,b,c)
#define tal_delete(a)
#else
#if !defined(MEM_DEBUG)
// 127 "tccpp.c"
#define tal_free(al,p) tal_free_impl(al, p)
#define tal_realloc(al,p,size) tal_realloc_impl(&al, p, size)
#define TAL_DEBUG_PARAMS
#else

#define TAL_DEBUG MEM_DEBUG
//#define TAL_INFO 1 /* collect and dump allocators stats */

#define tal_free(al, p) tal_free_impl(al, p, __FILE__, __LINE__)
#define tal_realloc(al, p, size) tal_realloc_impl(&al, p, size, __FILE__, __LINE__)
#define TAL_DEBUG_PARAMS , const char *file, int line
#define TAL_DEBUG_FILE_LEN 40
#endif
/* allocator for tiny TokenSym in table_ident */
// 139 "tccpp.c"
#define TOKSYM_TAL_SIZE (768 * 1024)
/* allocator for tiny TokenString instances */
#define TOKSTR_TAL_SIZE (768 * 1024)
/* prefer unique limits to distinguish allocators debug msgs */
#define TOKSYM_TAL_LIMIT 256
/* 256 * sizeof(int) */
#define TOKSTR_TAL_LIMIT 1024

typedef struct TinyAlloc {
	unsigned limit;
	unsigned size;
	uint8_t *buffer;
	uint8_t *p;
	unsigned nb_allocs;
	struct TinyAlloc *next, *top;
#ifdef TAL_INFO

	unsigned nb_peak;
	unsigned nb_total;
	unsigned nb_missed;
	uint8_t *peak_p;
#endif

} TinyAlloc;

typedef struct tal_header_t {
	unsigned size;
#ifdef TAL_DEBUG

	int line_num; /* negative line_num used for double free check */

	char file_name[TAL_DEBUG_FILE_LEN + 1];
#endif

} tal_header_t;
/* ------------------------------------------------------------------------- */

static TinyAlloc *tal_new(TinyAlloc **pal, unsigned limit, unsigned size)
{
	TinyAlloc *al = tcc_mallocz(sizeof(TinyAlloc));
	al->p = al->buffer = tcc_malloc(size);
	al->limit = limit;
	al->size = size;
	if (pal) *pal = al;
	return al;
}

static void tal_delete(TinyAlloc *al)
{
	TinyAlloc *next;

tail_call:
	if (!al)
		return;
#ifdef TAL_INFO

	fprintf(stderr,
		"limit %4d  size %7d  nb_peak %5d  nb_total %7d  nb_missed %5d  usage %5.1f%%\n",
		al->limit, al->size, al->nb_peak, al->nb_total, al->nb_missed,
		(al->peak_p - al->buffer) * 100.0 al->size);
#endif
#if TAL_DEBUG && TAL_DEBUG != 3 /* do not check TAL leaks with -DMEM_DEBUG=3 */
	/* do not check TAL leaks with -DMEM_DEBUG=3 */
	if (al->nb_allocs > 0) {
		uint8_t *p;
		fprintf(stderr, "TAL_DEBUG: memory leak %d chunk(s) (limit= %d)\n",
			al->nb_allocs, al->limit);
		p = al->buffer;
		while (p < al->p) {
			tal_header_t *header = (tal_header_t *)p;
			if (header->line_num > 0) {
				fprintf(stderr, "%s:%d: chunk of %d bytes leaked\n",
					header->file_name, header->line_num, header->size);
			}
			p += header->size + sizeof(tal_header_t);
		}
#if TAL_DEBUG == 2
		exit(2);
#endif
	}
#endif
// 210 "tccpp.c"
	next = al->next;
	tcc_free(al->buffer);
	tcc_free(al);
	al = next;
	goto tail_call;
}

static void tal_free_impl(TinyAlloc *al, void *p TAL_DEBUG_PARAMS)
{
	if (!p)
		return;
tail_call:
	if (al->buffer <= (uint8_t *)p && (uint8_t *)p < al->buffer + al->size) {
#ifdef TAL_DEBUG

		tal_header_t *header = (((tal_header_t *)p) - 1);
		if (header->line_num < 0) {
			fprintf(stderr, "%s:%d: TAL_DEBUG: double frees chunk from\n",
				file, line);
			fprintf(stderr, "%s:%d: %d bytes\n",
				header->file_name, (int)-header->line_num, (int)header->size);
		} else
			header->line_num = -header->line_num;
#endif
// 233 "tccpp.c"
		al->nb_allocs--;
		if (!al->nb_allocs)
			al->p = al->buffer;
	} else if (al->next) {
		al = al->next;
		goto tail_call;
	} else
		tcc_free(p);
}

static void *tal_realloc_impl(TinyAlloc **pal, void *p,
			      unsigned size TAL_DEBUG_PARAMS)
{
	tal_header_t *header;
	void *ret;
	int is_own;
	unsigned adj_size = (size + 3) & -4;
	TinyAlloc *al = *pal;

tail_call:
	is_own = (al->buffer <= (uint8_t *)p && (uint8_t *)p < al->buffer + al->size);
	if ((!p || is_own) && size <= al->limit) {
		if (al->p - al->buffer + adj_size + sizeof(tal_header_t) < al->size) {
			header = (tal_header_t *)al->p;
			header->size = adj_size;
#ifdef TAL_DEBUG

			{
				int ofs = strlen(file) - TAL_DEBUG_FILE_LEN;
				strncpy(header->file_name, file + (ofs > 0 ? ofs : 0), TAL_DEBUG_FILE_LEN);
				header->file_name[TAL_DEBUG_FILE_LEN] = 0;
				header->line_num = line;
			}
#endif

			ret = al->p + sizeof(tal_header_t);
			al->p += adj_size + sizeof(tal_header_t);
			if (is_own) {
				header = (((tal_header_t *)p) - 1);
				if (p) memcpy(ret, p, header->size);
#ifdef TAL_DEBUG

				header->line_num = -header->line_num;
#endif

			} else {
				al->nb_allocs++;
			}
#ifdef TAL_INFO

			if (al->nb_peak < al->nb_allocs)
				al->nb_peak = al->nb_allocs;
			if (al->peak_p < al->p)
				al->peak_p = al->p;
			al->nb_total++;
#endif

			return ret;
		} else if (is_own) {
			al->nb_allocs--;
			ret = tal_realloc(*pal, 0, size);
			header = (((tal_header_t *)p) - 1);
			if (p) memcpy(ret, p, header->size);
#ifdef TAL_DEBUG

			header->line_num = -header->line_num;
#endif

			return ret;
		}
		if (al->next) {
			al = al->next;
		} else {
			TinyAlloc *bottom = al, *next = al->top ? al->top : al;

			al = tal_new(pal, next->limit, next->size * 2);
			al->next = next;
			bottom->top = al;
		}
		goto tail_call;
	}
	if (is_own) {
		al->nb_allocs--;
		ret = tcc_malloc(size);
		header = (((tal_header_t *)p) - 1);
		if (p) memcpy(ret, p, header->size);
#ifdef TAL_DEBUG

		header->line_num = -header->line_num;
#endif

	} else if (al->next) {
		al = al->next;
		goto tail_call;
	} else
		ret = tcc_realloc(p, size);
#ifdef TAL_INFO

	al->nb_missed++;
#endif

	return ret;
}
#endif
/* USE_TAL */
/* ------------------------------------------------------------------------- */
/* CString handling */

static void cstr_realloc(CString *cstr, int new_size)
{
	int size;

	size = cstr->size_allocated;
	if (size < 8)
		size = 8;/* no need to allocate a too small first string */

	while (size < new_size)
		size = size * 2;
	cstr->data = tcc_realloc(cstr->data, size);
	cstr->size_allocated = size;
}
/* add a byte */

ST_INLN void cstr_ccat(CString *cstr, int ch)
{
	int size;
	size = cstr->size + 1;
	if (size > cstr->size_allocated)
		cstr_realloc(cstr, size);
	cstr->data[size - 1] = ch;
	cstr->size = size;
}

ST_INLN char *unicode_to_utf8 (char *b, uint32_t Uc)
{
	if (Uc<0x80) *b++=Uc;
	else if (Uc<0x800) *b++=192+Uc/64, *b++=128+Uc%64;
	else if (Uc-0xd800u<0x800) goto error;
	else if (Uc<0x10000) *b++=224+Uc/4096, *b++=128+Uc/64%64, *b++=128+Uc%64;
	else if (Uc<0x110000) *b++=240+Uc/262144, *b++=128+Uc/4096%64,
		*b++=128+Uc/64%64, *b++=128+Uc%64;
else error: tcc_error("0x%x is not a valid universal character", Uc);
	return b;
}
/* add a unicode character expanded into utf8 */

ST_INLN void cstr_u8cat(CString *cstr, int ch)
{
	char buf[4], *e;
	e = unicode_to_utf8(buf, (uint32_t)ch);
	cstr_cat(cstr, buf, e - buf);
}
/* add string of 'len', or of its len/len+1 when 'len' == -1/0 */

ST_FUNC void cstr_cat(CString *cstr, const char *str, int len)
{
	int size;
	if (len <= 0)
		len = strlen(str) + 1 + len;
	size = cstr->size + len;
	if (size > cstr->size_allocated)
		cstr_realloc(cstr, size);
	memmove(cstr->data + cstr->size, str, len);
	cstr->size = size;
}
/* add a wide char */

ST_FUNC void cstr_wccat(CString *cstr, int ch)
{
	int size;
	size = cstr->size + sizeof(nwchar_t);
	if (size > cstr->size_allocated)
		cstr_realloc(cstr, size);
	*(nwchar_t *)(cstr->data + size - sizeof(nwchar_t)) = ch;
	cstr->size = size;
}

ST_FUNC void cstr_new(CString *cstr)
{
	memset(cstr, 0, sizeof(CString));
}
/* free string and reset it to NULL */

ST_FUNC void cstr_free(CString *cstr)
{
	tcc_free(cstr->data);
}
/* reset string to empty */

ST_FUNC void cstr_reset(CString *cstr)
{
	cstr->size = 0;
}

ST_FUNC int cstr_vprintf(CString *cstr, const char *fmt, va_list ap)
{
	va_list v;
	int len, size = 80;
	for (;;) {
		size += cstr->size;
		if (size > cstr->size_allocated)
			cstr_realloc(cstr, size);
		size = cstr->size_allocated - cstr->size;
		va_copy(v, ap);
		len = vsnprintf(cstr->data + cstr->size, size, fmt, v);
		va_end(v);
		if (len >= 0 && len < size)
			break;
		size *= 2;
	}
	cstr->size += len;
	return len;
}

ST_FUNC int cstr_printf(CString *cstr, const char *fmt, ...)
{
	va_list ap;
	int len;
	va_start(ap, fmt);
	len = cstr_vprintf(cstr, fmt, ap);
	va_end(ap);
	return len;
}
/* XXX: unicode ? */

static void add_char(CString *cstr, int c)
{
	if (c == '\'' || c == '\"' || c == '\\') {
		/* XXX: could be more precise if char or string */

		cstr_ccat(cstr, '\\');
	}
	if (c >= 32 && c <= 126) {
		cstr_ccat(cstr, c);
	} else {
		cstr_ccat(cstr, '\\');
		if (c == '\n') {
			cstr_ccat(cstr, 'n');
		} else {
			cstr_ccat(cstr, '0' + ((c >> 6) & 7));
			cstr_ccat(cstr, '0' + ((c >> 3) & 7));
			cstr_ccat(cstr, '0' + (c & 7));
		}
	}
}
/* ------------------------------------------------------------------------- */
/* allocate a new token */

static TokenSym *tok_alloc_new(TokenSym **pts, const char *str, int len)
{
	TokenSym *ts, **ptable;
	int i;

	if (tok_ident >= SYM_FIRST_ANOM)
		tcc_error("memory full (symbols)");
	/* expand token table if needed */

	i = tok_ident - TOK_IDENT;
	if ((i % TOK_ALLOC_INCR) == 0) {
		ptable = tcc_realloc(table_ident, (i + TOK_ALLOC_INCR) * sizeof(TokenSym *));
		table_ident = ptable;
	}

	ts = tal_realloc(toksym_alloc, 0, sizeof(TokenSym) + len);
	table_ident[i] = ts;
	ts->tok = tok_ident++;
	ts->sym_define = NULL;
	ts->sym_label = NULL;
	ts->sym_struct = NULL;
	ts->sym_identifier = NULL;
	ts->len = len;
	ts->hash_next = NULL;
	memcpy(ts->str, str, len);
	ts->str[len] = '\0';
	*pts = ts;
	return ts;
}

#define TOK_HASH_INIT 1
#define TOK_HASH_FUNC(h,c) ((h) + ((h) << 5) + ((h) >> 27) + (c))
/* find a token and add it if not found */

ST_FUNC TokenSym *tok_alloc(const char *str, int len)
{
	TokenSym *ts, **pts;
	int i;
	unsigned int h;

	h = TOK_HASH_INIT;
	for (i=0; i<len; i++)
		h = TOK_HASH_FUNC(h, ((unsigned char *)str)[i]);
	h &= (TOK_HASH_SIZE - 1);

	pts = &hash_ident[h];
	for (;;) {
		ts = *pts;
		if (!ts)
			break;
		if (ts->len == len && !memcmp(ts->str, str, len))
			return ts;
		pts = &(ts->hash_next);
	}
	return tok_alloc_new(pts, str, len);
}

ST_FUNC int tok_alloc_const(const char *str)
{
	return tok_alloc(str, strlen(str))->tok;
}
/* XXX: buffer overflow */
/* XXX: float tokens */

ST_FUNC const char *get_tok_str(int v, CValue *cv)
{
	char *p;
	int i, len;

	cstr_reset(&cstr_buf);
	p = cstr_buf.data;

	switch (v) {
	case TOK_CINT:
	case TOK_CUINT:
	case TOK_CLONG:
	case TOK_CULONG:
	case TOK_CLLONG:
	case TOK_CULLONG:
		/* XXX: not quite exact, but only useful for testing  */

		sprintf(p, "%llu", (unsigned long long)cv->i);
		break;
	case TOK_LCHAR:
		cstr_ccat(&cstr_buf, 'L');
	case TOK_CCHAR:
		cstr_ccat(&cstr_buf, '\'');
		add_char(&cstr_buf, cv->i);
		cstr_ccat(&cstr_buf, '\'');
		cstr_ccat(&cstr_buf, '\0');
		break;
	case TOK_PPNUM:
	case TOK_PPSTR:
		return (char*)cv->str.data;
	case TOK_LSTR:
		cstr_ccat(&cstr_buf, 'L');
	case TOK_STR:
		cstr_ccat(&cstr_buf, '\"');
		if (v == TOK_STR) {
			len = cv->str.size - 1;
			for (i=0; i<len; i++)
				add_char(&cstr_buf, ((unsigned char *)cv->str.data)[i]);
		} else {
			len = (cv->str.size / sizeof(nwchar_t)) - 1;
			for (i=0; i<len; i++)
				add_char(&cstr_buf, ((nwchar_t *)cv->str.data)[i]);
		}
		cstr_ccat(&cstr_buf, '\"');
		cstr_ccat(&cstr_buf, '\0');
		break;

	case TOK_CFLOAT:
		return strcpy(p, "<float>");
	case TOK_CDOUBLE:
		return strcpy(p, "<double>");
	case TOK_CLDOUBLE:
		return strcpy(p, "<long double>");
	case TOK_LINENUM:
		return strcpy(p, "<linenumber>");
	/* above tokens have value, the ones below don't */

	case TOK_LT:
		v = '<';
		goto addv;
	case TOK_GT:
		v = '>';
		goto addv;
	case TOK_DOTS:
		return strcpy(p, "...");
	case TOK_A_SHL:
		return strcpy(p, "<<=");
	case TOK_A_SAR:
		return strcpy(p, ">>=");
	case TOK_EOF:
		return strcpy(p, "<eof>");
	case 0:/* anonymous nameless symbols */

		return strcpy(p, "<no name>");
	default:
		v &= ~(SYM_FIELD | SYM_STRUCT);
		if (v < TOK_IDENT) {
			/* search in two bytes table */

			const unsigned char *q = tok_two_chars;
			while (*q) {
				if (q[2] == v) {
					*p++ = q[0];
					*p++ = q[1];
					*p = '\0';
					return cstr_buf.data;
				}
				q += 3;
			}
			if (v >= 127 || (v < 32 && !is_space(v) && v != '\n')) {
				sprintf(p, "<\\x%02x>", v);
				break;
			}
addv:
			*p++ = v;
			*p = '\0';
		} else if (v < tok_ident) {
			return table_ident[v - TOK_IDENT]->str;
		} else if (v >= SYM_FIRST_ANOM) {
			/* special name for anonymous symbol */

			sprintf(p, "L.%u", v - SYM_FIRST_ANOM);
		} else {
			/* should never happen */

			return NULL;
		}
		break;
	}
	return cstr_buf.data;
}
/* return the current character, handling end of block if necessary
   (but not stray) */

static int handle_eob(void)
{
	BufferedFile *bf = file;
	int len;
	/* only tries to read if really end of buffer */

	if (bf->buf_ptr >= bf->buf_end) {
		if (bf->fd >= 0) {
#if defined(PARSE_DEBUG)
			len = 1;
#else

			len = IO_BUF_SIZE;
#endif

			len = read(bf->fd, bf->buffer, len);
			if (len < 0)
				len = 0;
		} else {
			len = 0;
		}
		total_bytes += len;
		bf->buf_ptr = bf->buffer;
		bf->buf_end = bf->buffer + len;
		*bf->buf_end = CH_EOB;
	}
	if (bf->buf_ptr < bf->buf_end) {
		return bf->buf_ptr[0];
	} else {
		bf->buf_ptr = bf->buf_end;
		return CH_EOF;
	}
}
/* read next char from current input file and handle end of input buffer */

static int next_c(void)
{
	int ch = *++file->buf_ptr;
	/* end of buffer/file handling */

	if (ch == CH_EOB && file->buf_ptr >= file->buf_end)
		ch = handle_eob();
	return ch;
}
/* input with '\[\r]\n' handling. */

static int handle_stray_noerror(int err)
{
	int ch;
	while ((ch = next_c()) == '\\') {
		ch = next_c();
		if (ch == '\n') {
newl:
			file->line_num++;
		} else {
			if (ch == '\r') {
				ch = next_c();
				if (ch == '\n')
					goto newl;
				*--file->buf_ptr = '\r';
			}
			if (err)
				tcc_error("stray '\\' in program");
			/* may take advantage of 'BufferedFile.unget[4}' */

			return *--file->buf_ptr = '\\';
		}
	}
	return ch;
}

#define ninp() handle_stray_noerror(0)
/* handle '\\' in strings, comments and skipped regions */

static int handle_bs(uint8_t **p)
{
	int c;
	file->buf_ptr = *p - 1;
	c = ninp();
	*p = file->buf_ptr;
	return c;
}
/* skip the stray and handle the \\n case. Output an error if
   incorrect char after the stray */

static int handle_stray(uint8_t **p)
{
	int c;
	file->buf_ptr = *p - 1;
	c = handle_stray_noerror(!(parse_flags & PARSE_FLAG_ACCEPT_STRAYS));
	*p = file->buf_ptr;
	return c;
}
/* handle the complicated stray case */

#define PEEKC(c,p) { c = *++p; if (c == '\\') c = handle_stray(&p); }

static int skip_spaces(void)
{
	int ch;
	--file->buf_ptr;
	do {
		ch = ninp();
	} while (isidnum_table[ch - CH_EOF] & IS_SPC);
	return ch;
}
/* single line C++ comments */

static uint8_t *parse_line_comment(uint8_t *p)
{
	int c;
	for (;;) {
		for (;;) {
			c = *++p;
redo:
			if (c == '\n' || c == '\\')
				break;
			c = *++p;
			if (c == '\n' || c == '\\')
				break;
		}
		if (c == '\n')
			break;
		c = handle_bs(&p);
		if (c == CH_EOF)
			break;
		if (c != '\\')
			goto redo;
	}
	return p;
}
/* C comments */

static uint8_t *parse_comment(uint8_t *p)
{
	int c;
	for (;;) {
		/* fast skip loop */

		for (;;) {
			c = *++p;
redo:
			if (c == '\n' || c == '*' || c == '\\')
				break;
			c = *++p;
			if (c == '\n' || c == '*' || c == '\\')
				break;
		}
		/* now we can handle all the cases */

		if (c == '\n') {
			file->line_num++;
		} else if (c == '*') {
			do {
				c = *++p;
			} while (c == '*');
			if (c == '\\')
				c = handle_bs(&p);
			if (c == '/')
				break;
			goto check_eof;
		} else {
			c = handle_bs(&p);
check_eof:
			if (c == CH_EOF)
				tcc_error("unexpected end of file in comment");
			if (c != '\\')
				goto redo;
		}
	}
	return p + 1;
}
/* parse a string without interpreting escapes */

static uint8_t *parse_pp_string(uint8_t *p, int sep, CString *str)
{
	int c;
	for (;;) {
		c = *++p;
redo:
		if (c == sep) {
			break;
		} else if (c == '\\') {
			c = handle_bs(&p);
			if (c == CH_EOF) {
unterminated_string:
				/* XXX: indicate line number of start of string */

				tok_flags &= ~TOK_FLAG_BOL;
				tcc_error("missing terminating %c character", sep);
			} else if (c == '\\') {
				if (str)
					cstr_ccat(str, c);
				c = *++p;
				/* add char after '\\' unconditionally */

				if (c == '\\') {
					c = handle_bs(&p);
					if (c == CH_EOF)
						goto unterminated_string;
				}
				goto add_char;
			} else {
				goto redo;
			}
		} else if (c == '\n') {
add_lf:
			if (ACCEPT_LF_IN_STRINGS) {
				file->line_num++;
				goto add_char;
			} else if (str) {/* not skipping */

				goto unterminated_string;
			} else {
//tcc_warning("missing terminating %c character", sep);

				return p;
			}
		} else if (c == '\r') {
			c = *++p;
			if (c == '\\')
				c = handle_bs(&p);
			if (c == '\n')
				goto add_lf;
			if (c == CH_EOF)
				goto unterminated_string;
			if (str)
				cstr_ccat(str, '\r');
			goto redo;
		} else {
add_char:
			if (str)
				cstr_ccat(str, c);
		}
	}
	p++;
	return p;
}
/* skip block of text until #else, #elif or #endif. skip also pairs of
   #if/#endif */

static void preprocess_skip(void)
{
	int a, start_of_line, c, in_warn_or_error;
	uint8_t *p;

	p = file->buf_ptr;
	a = 0;
redo_start:
	start_of_line = 1;
	in_warn_or_error = 0;
	for (;;) {
		c = *p;
		switch (c) {
		case ' ':
		case '\t':
		case '\f':
		case '\v':
		case '\r':
			p++;
			continue;
		case '\n':
			file->line_num++;
			p++;
			goto redo_start;
		case '\\':
			c = handle_bs(&p);
			if (c == CH_EOF)
				expect("#endif");
			if (c == '\\')
				++p;
			continue;
		/* skip strings */

		case '\"':
		case '\'':
			if (in_warn_or_error)
				goto _default;
			tok_flags &= ~TOK_FLAG_BOL;
			p = parse_pp_string(p, c, NULL);
			break;
		/* skip comments */

		case '/':
			if (in_warn_or_error)
				goto _default;
			++p;
			c = handle_bs(&p);
			if (c == '*') {
				p = parse_comment(p);
			} else if (c == '/') {
				p = parse_line_comment(p);
			}
			continue;
		case '#':
			p++;
			if (start_of_line) {
				file->buf_ptr = p;
				next_nomacro();
				p = file->buf_ptr;
				if (a == 0 &&
				    (tok == TOK_ELSE || tok == TOK_ELIF || tok == TOK_ENDIF))
					goto the_end;
				if (tok == TOK_IF || tok == TOK_IFDEF || tok == TOK_IFNDEF)
					a++;
				else if (tok == TOK_ENDIF)
					a--;
				else if ( tok == TOK_ERROR || tok == TOK_WARNING)
					in_warn_or_error = 1;
				else if (tok == TOK_LINEFEED)
					goto redo_start;
				else if (parse_flags & PARSE_FLAG_ASM_FILE)
					p = parse_line_comment(p - 1);
			}

			else if (parse_flags & PARSE_FLAG_ASM_FILE)
				p = parse_line_comment(p - 1);

			break;
_default:
		default:
			p++;
			break;
		}
		start_of_line = 0;
	}
the_end: ;
	file->buf_ptr = p;
}
/* token string handling */
// 1002 "tccpp.c"
ST_INLN void tok_str_new(TokenString *s)
{
	s->str = NULL;
	s->len = s->need_spc = 0;
	s->allocated_len = 0;
	s->last_line_num = -1;
}

ST_FUNC TokenString *tok_str_alloc(void)
{
	TokenString *str = tal_realloc(tokstr_alloc, 0, sizeof *str);
	tok_str_new(str);
	return str;
}

ST_FUNC void tok_str_free_str(int *str)
{
	tal_free(tokstr_alloc, str);
}

ST_FUNC void tok_str_free(TokenString *str)
{
	tok_str_free_str(str->str);
	tal_free(tokstr_alloc, str);
}

ST_FUNC int *tok_str_realloc(TokenString *s, int new_size)
{
	int *str, size;

	size = s->allocated_len;
	if (size < 16)
		size = 16;
	while (size < new_size)
		size = size * 2;
	if (size > s->allocated_len) {
		str = tal_realloc(tokstr_alloc, s->str, size * sizeof(int));
		s->allocated_len = size;
		s->str = str;
	}
	return s->str;
}

ST_FUNC void tok_str_add(TokenString *s, int t)
{
	int len, *str;

	len = s->len;
	str = s->str;
	if (len >= s->allocated_len)
		str = tok_str_realloc(s, len + 1);
	str[len++] = t;
	s->len = len;
}

ST_FUNC void begin_macro(TokenString *str, int alloc)
{
	str->alloc = alloc;
	str->prev = macro_stack;
	str->prev_ptr = macro_ptr;
	str->save_line_num = file->line_num;
	macro_ptr = str->str;
	macro_stack = str;
}

ST_FUNC void end_macro(void)
{
	TokenString *str = macro_stack;
	macro_stack = str->prev;
	macro_ptr = str->prev_ptr;
	file->line_num = str->save_line_num;
	if (str->alloc == 0) {
		/* matters if str not alloced, may be tokstr_buf */

		str->len = str->need_spc = 0;
	} else {
		if (str->alloc == 2)
			str->str = NULL;/* don't free */

		tok_str_free(str);
	}
}

static void tok_str_add2(TokenString *s, int t, CValue *cv)
{
	int len, *str;

	len = s->len;
	str = s->str;
	/* allocate space for worst case */

	if (len + TOK_MAX_SIZE >= s->allocated_len)
		str = tok_str_realloc(s, len + TOK_MAX_SIZE + 1);
	str[len++] = t;
	switch (t) {
	case TOK_CINT:
	case TOK_CUINT:
	case TOK_CCHAR:
	case TOK_LCHAR:
	case TOK_CFLOAT:
	case TOK_LINENUM:
#if LONG_SIZE == 4

	case TOK_CLONG:
	case TOK_CULONG:
#endif

		str[len++] = cv->tab[0];
		break;
	case TOK_PPNUM:
	case TOK_PPSTR:
	case TOK_STR:
	case TOK_LSTR: {
		/* Insert the string into the int array. */

		size_t nb_words =
			1 + (cv->str.size + sizeof(int) - 1) / sizeof(int);
		if (len + nb_words >= s->allocated_len)
			str = tok_str_realloc(s, len + nb_words + 1);
		str[len] = cv->str.size;
		memcpy(&str[len + 1], cv->str.data, cv->str.size);
		len += nb_words;
	}
	break;
	case TOK_CDOUBLE:
	case TOK_CLLONG:
	case TOK_CULLONG:
#if LONG_SIZE == 8
	case TOK_CLONG:
	case TOK_CULONG:
#endif

		str[len++] = cv->tab[0];
		str[len++] = cv->tab[1];
		break;
	case TOK_CLDOUBLE:
#if LDOUBLE_SIZE == 8 || defined TCC_USING_DOUBLE_FOR_LDOUBLE

		str[len++] = cv->tab[0];
		str[len++] = cv->tab[1];
#elif LDOUBLE_SIZE == 12

		str[len++] = cv->tab[0];
		str[len++] = cv->tab[1];
		str[len++] = cv->tab[2];
#elif LDOUBLE_SIZE == 16

		str[len++] = cv->tab[0];
		str[len++] = cv->tab[1];
		str[len++] = cv->tab[2];
		str[len++] = cv->tab[3];
#else

#error add long double size support
#endif
// 1148 "tccpp.c"
		break;
	default:
		break;
	}
	s->len = len;
}
/* add the current parse token in token string 's' */

ST_FUNC void tok_str_add_tok(TokenString *s)
{
	CValue cval;
	/* save line number info */

	if (file->line_num != s->last_line_num) {
		s->last_line_num = file->line_num;
		cval.i = s->last_line_num;
		tok_str_add2(s, TOK_LINENUM, &cval);
	}
	tok_str_add2(s, tok, &tokc);
}
/* like tok_str_add2(), add a space if needed */

static void tok_str_add2_spc(TokenString *s, int t, CValue *cv)
{
	if (s->need_spc == 3)
		tok_str_add(s, ' ');
	s->need_spc = 2;
	tok_str_add2(s, t, cv);
}
/* get a token from an integer array and increment pointer. */

static inline void tok_get(int *t, const int **pp, CValue *cv)
{
	const int *p = *pp;
	int n, *tab;

	tab = cv->tab;
	switch (*t = *p++) {
#if LONG_SIZE == 4

	case TOK_CLONG:
#endif

	case TOK_CINT:
	case TOK_CCHAR:
	case TOK_LCHAR:
	case TOK_LINENUM:
		cv->i = *p++;
		break;
#if LONG_SIZE == 4

	case TOK_CULONG:
#endif

	case TOK_CUINT:
		cv->i = (unsigned)*p++;
		break;
	case TOK_CFLOAT:
		tab[0] = *p++;
		break;
	case TOK_STR:
	case TOK_LSTR:
	case TOK_PPNUM:
	case TOK_PPSTR:
		cv->str.size = *p++;
		cv->str.data = (char*)p;
		p += (cv->str.size + sizeof(int) - 1) / sizeof(int);
		break;
	case TOK_CDOUBLE:
	case TOK_CLLONG:
	case TOK_CULLONG:
#if LONG_SIZE == 8
	case TOK_CLONG:
	case TOK_CULONG:
#endif

		n = 2;
		goto copy;
	case TOK_CLDOUBLE:
#if LDOUBLE_SIZE == 8 || defined TCC_USING_DOUBLE_FOR_LDOUBLE

		n = 2;
#elif LDOUBLE_SIZE == 12

		n = 3;
#elif LDOUBLE_SIZE == 16

		n = 4;
#else

#error add long double size support
#endif

copy:
		do
			*tab++ = *p++;
		while (--n);
		break;
	default:
		break;
	}
	*pp = p;
}
// 1251 "tccpp.c"
#define TOK_GET(t,p,c) do { int _t = **(p); if (TOK_HAS_VALUE(_t)) tok_get(t, p, c); else *(t) = _t, ++*(p); } while (0)

static int macro_is_equal(const int *a, const int *b)
{
	CValue cv;
	int t;

	if (!a || !b)
		return 1;

	while (*a && *b) {
		cstr_reset(&tokcstr);
		TOK_GET(&t, &a, &cv);
		cstr_cat(&tokcstr, get_tok_str(t, &cv), 0);
		TOK_GET(&t, &b, &cv);
		if (strcmp(tokcstr.data, get_tok_str(t, &cv)))
			return 0;
	}
	return !(*a || *b);
}
/* defines handling */

ST_INLN void define_push(int v, int macro_type, int *str, Sym *first_arg)
{
	Sym *s, *o;

	o = define_find(v);
	s = sym_push2(&define_stack, v, macro_type, 0);
	s->d = str;
	s->next = first_arg;
	table_ident[v - TOK_IDENT]->sym_define = s;

	if (o && !macro_is_equal(o->d, s->d))
		tcc_warning("%s redefined", get_tok_str(v, NULL));
}
/* undefined a define symbol. Its name is just set to zero */

ST_FUNC void define_undef(Sym *s)
{
	int v = s->v;
	if (v >= TOK_IDENT && v < tok_ident)
		table_ident[v - TOK_IDENT]->sym_define = NULL;
}

ST_INLN Sym *define_find(int v)
{
	v -= TOK_IDENT;
	if ((unsigned)v >= (unsigned)(tok_ident - TOK_IDENT))
		return NULL;
	return table_ident[v]->sym_define;
}
/* free define stack until top reaches 'b' */

ST_FUNC void free_defines(Sym *b)
{
	while (define_stack != b) {
		Sym *top = define_stack;
		define_stack = top->prev;
		tok_str_free_str(top->d);
		define_undef(top);
		sym_free(top);
	}
}
/* fake the nth "#if defined test_..." for tcc -dt -run */

static void maybe_run_test(TCCState *s)
{
	const char *p;
	if (s->include_stack_ptr != s->include_stack)
		return;
	p = get_tok_str(tok, NULL);
	if (0 != memcmp(p, "test_", 5))
		return;
	if (0 != --s->run_test)
		return;
	fprintf(s->ppfp, &"\n[%s]\n"[!(s->dflag & 32)], p), fflush(s->ppfp);
	define_push(tok, MACRO_OBJ, NULL, NULL);
}

ST_FUNC void skip_to_eol(int warn)
{
	if (tok == TOK_LINEFEED)
		return;
	if (warn)
		tcc_warning("extra tokens after directive");
	while (macro_stack)
		end_macro();
	file->buf_ptr = parse_line_comment(file->buf_ptr - 1);
	next_nomacro();
}

static CachedInclude *
search_cached_include(TCCState *s1, const char *filename, int add);

static int parse_include(TCCState *s1, int do_next, int test)
{
	int c, i;
	char name[1024], buf[1024], *p;
	CachedInclude *e;

	c = skip_spaces();
	if (c == '<' || c == '\"') {
		cstr_reset(&tokcstr);
		file->buf_ptr = parse_pp_string(file->buf_ptr, c == '<' ? '>' : c, &tokcstr);
		i = tokcstr.size;
		pstrncpy(name, sizeof name, tokcstr.data, i);
		next_nomacro();
	} else {
		/* computed #include : concatenate tokens until result is one of
		           the two accepted forms.  Don't convert pp-tokens to tokens here. */

		parse_flags = PARSE_FLAG_PREPROCESS
			      | PARSE_FLAG_LINEFEED
			      | (parse_flags & PARSE_FLAG_ASM_FILE);
		name[0] = 0;
		for (;;) {
			next();
			p = name, i = strlen(p) - 1;
			if (i > 0
			    && ((p[0] == '"' && p[i] == '"')
				|| (p[0] == '<' && p[i] == '>')))
				break;
			if (tok == TOK_LINEFEED)
				tcc_error("'#include' expects \"FILENAME\" or <FILENAME>");
			pstrcat(name, sizeof name, get_tok_str(tok, &tokc));
		}
		c = p[0];
		/* remove '<>|""' */

		memmove(p, p + 1, i - 1), p[i - 1] = 0;
	}

	if (!test)
		skip_to_eol(1);

	i = do_next ? file->include_next_index : -1;
	for (;;) {
		++i;
		if (i == 0) {
			/* check absolute include path */

			if (!IS_ABSPATH(name))
				continue;
			buf[0] = '\0';
		} else if (i == 1) {
			/* search in file's dir if "header.h" */

			if (c != '\"')
				continue;
			p = file->true_filename;
			pstrncpy(buf, sizeof buf, p, tcc_basename(p) - p);
		} else {
			int j = i - 2, k = j - s1->nb_include_paths;
			if (k < 0)
				p = s1->include_paths[j];
			else if (k < s1->nb_sysinclude_paths)
				p = s1->sysinclude_paths[k];
			else if (test)
				return 0;
			else
				tcc_error("include file '%s' not found", name);
			pstrcpy(buf, sizeof buf, p);
			pstrcat(buf, sizeof buf, "/");
		}
		pstrcat(buf, sizeof buf, name);
		e = search_cached_include(s1, buf, 0);
		if (e && (define_find(e->ifndef_macro) || e->once)) {
			/* no need to parse the include because the 'ifndef macro'
			               is defined (or had #pragma once) */
#ifdef INC_DEBUG

			printf("%s: skipping cached %s\n", file->filename, buf);
#endif

			return 1;
		}
		if (tcc_open(s1, buf) >= 0)
			break;
	}

	if (test) {
		tcc_close();
	} else {
		if (s1->include_stack_ptr >= s1->include_stack + INCLUDE_STACK_SIZE)
			tcc_error("#include recursion too deep");
		/* push previous file on stack */

		*s1->include_stack_ptr++ = file->prev;
		file->include_next_index = i;
#ifdef INC_DEBUG

		printf("%s: including %s\n", file->prev->filename, file->filename);
#endif
		/* update target deps */

		if (s1->gen_deps) {
			BufferedFile *bf = file;
			while (i == 1 && (bf = bf->prev))
				i = bf->include_next_index;
			/* skip system include files */

			if (s1->include_sys_deps || i - 2 < s1->nb_include_paths)
				dynarray_add(&s1->target_deps, &s1->nb_target_deps,
					     tcc_strdup(buf));
		}
		/* add include file debug info */

		tcc_debug_bincl(s1);
	}
	return 1;
}
/* eval an expression for #if/#elif */

static int expr_preprocess(TCCState *s1)
{
	int c, t;
	int t0 = tok;
	TokenString *str;

	str = tok_str_alloc();
	pp_expr = 1;
	while (1) {
		next();/* do macro subst */

		t = tok;
		if (tok < TOK_IDENT) {
			if (tok == TOK_LINEFEED || tok == TOK_EOF)
				break;
			if (tok >= TOK_STR && tok <= TOK_CLDOUBLE)
				tcc_error("invalid constant in preprocessor expression");

		} else if (tok == TOK_DEFINED) {
			parse_flags &= ~PARSE_FLAG_PREPROCESS;/* no macro subst */

			next();
			t = tok;
			if (t == '(')
				next();
			parse_flags |= PARSE_FLAG_PREPROCESS;
			if (tok < TOK_IDENT)
				expect("identifier after 'defined'");
			if (s1->run_test)
				maybe_run_test(s1);
			c = 0;
			if (define_find(tok)
			    || tok == TOK___HAS_INCLUDE
			    || tok == TOK___HAS_INCLUDE_NEXT)
				c = 1;
			if (t == '(') {
				next();
				if (tok != ')')
					expect("')'");
			}
			goto c_number;
		} else if (tok == TOK___HAS_INCLUDE ||
			   tok == TOK___HAS_INCLUDE_NEXT) {
			t = tok;
			next();
			if (tok != '(')
				expect("'('");
			c = parse_include(s1, t - TOK___HAS_INCLUDE, 1);
			if (tok != ')')
				expect("')'");
			goto c_number;
		} else {
			/* if undefined macro, replace with zero */

			c = 0;
c_number:
			tok = TOK_CLLONG;/* type intmax_t */

			tokc.i = c;
		}
		tok_str_add_tok(str);
	}
	if (0 == str->len)
		tcc_error("#%s with no expression", get_tok_str(t0, 0));
	tok_str_add(str, TOK_EOF);/* simulate end of file */

	pp_expr = t0;/* redirect pre-processor expression error messages */

	t = tok;
	/* now evaluate C constant expression */

	begin_macro(str, 1);
	next();
	c = expr_const();
	if (tok != TOK_EOF)
		tcc_error("...");
	pp_expr = 0;
	end_macro();
	tok = t;/* restore LF or EOF */

	return c != 0;
}

ST_FUNC void pp_error(CString *cs)
{
	cstr_printf(cs, "bad preprocessor expression: #%s", get_tok_str(pp_expr, 0));
	macro_ptr = macro_stack->str;
	while (next(), tok != TOK_EOF)
		cstr_printf(cs, " %s", get_tok_str(tok, &tokc));
}
/* parse after #define */

ST_FUNC void parse_define(void)
{
	Sym *s, *first, **ps;
	int v, t, varg, is_vaargs, t0;
	int saved_parse_flags = parse_flags;
	TokenString str;

	v = tok;
	if (v < TOK_IDENT || v == TOK_DEFINED)
		tcc_error("invalid macro name '%s'", get_tok_str(tok, &tokc));
	first = NULL;
	t = MACRO_OBJ;
	/* We have to parse the whole define as if not in asm mode, in particular
	       no line comment with '#' must be ignored.  Also for function
	       macros the argument list must be parsed without '.' being an ID
	       character.  */

	parse_flags = ((parse_flags & ~PARSE_FLAG_ASM_FILE) | PARSE_FLAG_SPACES);
	/* '(' must be just after macro definition for MACRO_FUNC */

	next_nomacro();
	parse_flags &= ~PARSE_FLAG_SPACES;
	is_vaargs = 0;
	if (tok == '(') {
		int dotid = set_idnum('.', 0);
		next_nomacro();
		ps = &first;
		if (tok != ')') for (;;) {
				varg = tok;
				next_nomacro();
				is_vaargs = 0;
				if (varg == TOK_DOTS) {
					varg = TOK___VA_ARGS__;
					is_vaargs = 1;
				} else if (tok == TOK_DOTS && gnu_ext) {
					is_vaargs = 1;
					next_nomacro();
				}
				if (varg < TOK_IDENT)
bad_list:
					tcc_error("bad macro parameter list");
				s = sym_push2(&define_stack, varg | SYM_FIELD, is_vaargs, 0);
				*ps = s;
				ps = &s->next;
				if (tok == ')')
					break;
				if (tok != ',' || is_vaargs)
					goto bad_list;
				next_nomacro();
			}
		parse_flags |= PARSE_FLAG_SPACES;
		next_nomacro();
		t = MACRO_FUNC;
		set_idnum('.', dotid);
	}
	/* The body of a macro definition should be parsed such that identifiers
	       are parsed like the file mode determines (i.e. with '.' being an
	       ID character in asm mode).  But '#' should be retained instead of
	       regarded as line comment leader, so still don't set ASM_FILE
	       in parse_flags. */

	parse_flags |= PARSE_FLAG_ACCEPT_STRAYS | PARSE_FLAG_SPACES |
		       PARSE_FLAG_LINEFEED;
	tok_str_new(&str);
	t0 = 0;
	while (tok != TOK_LINEFEED && tok != TOK_EOF) {
		if (is_space(tok)) {
			str.need_spc |= 1;
		} else {
			if (TOK_TWOSHARPS == tok) {
				if (0 == t0)
					goto bad_twosharp;
				tok = TOK_PPJOIN;
				t |= MACRO_JOIN;
			}
			tok_str_add2_spc(&str, tok, &tokc);
			t0 = tok;
		}
		next_nomacro();
	}
	parse_flags = saved_parse_flags;
	tok_str_add(&str, 0);
	if (t0 == TOK_PPJOIN)
bad_twosharp:
		tcc_error("'##' cannot appear at either end of macro");
	define_push(v, t, str.str, first);
//tok_print(str.str, "#define (%d) %s %d:", t | is_vaargs * 4, get_tok_str(v, 0));

}

static CachedInclude *search_cached_include(TCCState *s1, const char *filename,
		int add)
{
	const char *s, *basename;
	unsigned int h;
	CachedInclude *e;
	int c, i, len;

	s = basename = tcc_basename(filename);
	h = TOK_HASH_INIT;
	while ((c = (unsigned char)*s) != 0) {

		h = TOK_HASH_FUNC(h, toup(c));

		s++;
	}
	h &= (CACHED_INCLUDES_HASH_SIZE - 1);

	i = s1->cached_includes_hash[h];
	for (;;) {
		if (i == 0)
			break;
		e = s1->cached_includes[i - 1];
		if (0 == PATHCMP(filename, e->filename))
			return e;
		if (e->once
		    && 0 == PATHCMP(basename, tcc_basename(e->filename))
		    && 0 == normalized_PATHCMP(filename, e->filename)
		   )
			return e;
		i = e->hash_next;
	}
	if (!add)
		return NULL;

	e = tcc_malloc(sizeof(CachedInclude) + (len = strlen(filename)));
	memcpy(e->filename, filename, len + 1);
	e->ifndef_macro = e->once = 0;
	dynarray_add(&s1->cached_includes, &s1->nb_cached_includes, e);
	/* add in hash table */

	e->hash_next = s1->cached_includes_hash[h];
	s1->cached_includes_hash[h] = s1->nb_cached_includes;
#ifdef INC_DEBUG

	printf("adding cached '%s'\n", filename);
#endif

	return e;
}

static int pragma_parse(TCCState *s1)
{
	next_nomacro();
	if (tok == TOK_push_macro || tok == TOK_pop_macro) {
		int t = tok, v;
		Sym *s;

		if (next(), tok != '(')
			goto pragma_err;
		if (next(), tok != TOK_STR)
			goto pragma_err;
		v = tok_alloc(tokc.str.data, tokc.str.size - 1)->tok;
		if (next(), tok != ')')
			goto pragma_err;
		if (t == TOK_push_macro) {
			while (NULL == (s = define_find(v)))
				define_push(v, 0, NULL, NULL);
			s->type.ref = s;/* set push boundary */

		} else {
			for (s = define_stack; s; s = s->prev)
				if (s->v == v && s->type.ref == s) {
					s->type.ref = NULL;
					break;
				}
		}
		if (s)
			table_ident[v - TOK_IDENT]->sym_define = s->d ? s : NULL;
		else
			tcc_warning("unbalanced #pragma pop_macro");
		pp_debug_tok = t, pp_debug_symv = v;

	} else if (tok == TOK_once) {
		search_cached_include(s1, file->true_filename, 1)->once = 1;

	} else if (s1->output_type == TCC_OUTPUT_PREPROCESS) {
		/* tcc -E: keep pragmas below unchanged */

		unget_tok(' ');
		unget_tok(TOK_PRAGMA);
		unget_tok('#');
		unget_tok(TOK_LINEFEED);
		return 1;

	} else if (tok == TOK_pack) {
		/* This may be:
		           #pragma pack(1) // set
		           #pragma pack() // reset to default
		           #pragma pack(push) // push current
		           #pragma pack(push,1) // push & set
		           #pragma pack(pop) // restore previous */

		next();
		skip('(');
		if (tok == TOK_ASM_pop) {
			next();
			if (s1->pack_stack_ptr <= s1->pack_stack) {
stk_error:
				tcc_error("out of pack stack");
			}
			s1->pack_stack_ptr--;
		} else {
			int val = 0;
			if (tok != ')') {
				if (tok == TOK_ASM_push) {
					next();
					if (s1->pack_stack_ptr >= s1->pack_stack + PACK_STACK_SIZE - 1)
						goto stk_error;
					val = *s1->pack_stack_ptr++;
					if (tok != ',')
						goto pack_set;
					next();
				}
				if (tok != TOK_CINT)
					goto pragma_err;
				val = tokc.i;
				if (val < 1 || val > 16 || (val & (val - 1)) != 0)
					goto pragma_err;
				next();
			}
pack_set:
			*s1->pack_stack_ptr = val;
		}
		if (tok != ')')
			goto pragma_err;

	} else if (tok == TOK_comment) {
		char *p;
		int t;
		next();
		skip('(');
		t = tok;
		next();
		skip(',');
		if (tok != TOK_STR)
			goto pragma_err;
		p = tcc_strdup(tokc.str.data);
		next();
		if (tok != ')')
			goto pragma_err;
		if (t == TOK_lib) {
			dynarray_add(&s1->pragma_libs, &s1->nb_pragma_libs, p);
		} else {
			if (t == TOK_option)
				tcc_set_options(s1, p);
			tcc_free(p);
		}

	} else {
		tcc_warning_c(warn_all)("#pragma %s ignored", get_tok_str(tok, &tokc));
		return 0;
	}
	next();
	return 1;
pragma_err:
	tcc_error("malformed #pragma directive");
}
/* put alternative filename */

ST_FUNC void tccpp_putfile(const char *filename)
{
	char buf[1024];
	buf[0] = 0;
	if (!IS_ABSPATH(filename)) {
		/* prepend directory from real file */

		pstrcpy(buf, sizeof buf, file->true_filename);
		*tcc_basename(buf) = 0;
	}
	pstrcat(buf, sizeof buf, filename);

	normalize_slashes(buf);

	if (0 == strcmp(file->filename, buf))
		return;
//printf("new file '%s'\n", buf);

	if (file->true_filename == file->filename)
		file->true_filename = tcc_strdup(file->filename);
	pstrcpy(file->filename, sizeof file->filename, buf);
	tcc_debug_newfile(tcc_state);
}
/* is_bof is true if first non space token at beginning of file */

ST_FUNC void preprocess(int is_bof)
{
	TCCState *s1 = tcc_state;
	int c, n, saved_parse_flags;
	char buf[1024], *q;
	Sym *s;

	saved_parse_flags = parse_flags;
	parse_flags = PARSE_FLAG_PREPROCESS
		      | PARSE_FLAG_TOK_NUM
		      | PARSE_FLAG_TOK_STR
		      | PARSE_FLAG_LINEFEED
		      | (parse_flags & PARSE_FLAG_ASM_FILE)
		      ;

	next_nomacro();
redo:
	switch (tok) {
	case TOK_DEFINE:
		pp_debug_tok = tok;
		next_nomacro();
		pp_debug_symv = tok;
		parse_define();
		break;
	case TOK_UNDEF:
		pp_debug_tok = tok;
		next_nomacro();
		pp_debug_symv = tok;
		s = define_find(tok);
		/* undefine symbol by putting an invalid name */

		if (s)
			define_undef(s);
		next_nomacro();
		break;
	case TOK_INCLUDE:
	case TOK_INCLUDE_NEXT:
		parse_include(s1, tok - TOK_INCLUDE, 0);
		goto the_end;
	case TOK_IFNDEF:
		c = 1;
		goto do_ifdef;
	case TOK_IF:
		c = expr_preprocess(s1);
		goto do_if;
	case TOK_IFDEF:
		c = 0;
do_ifdef:
		next_nomacro();
		if (tok < TOK_IDENT)
			tcc_error("invalid argument for '#if%sdef'", c ? "n" : "");
		if (is_bof) {
			if (c) {
#ifdef INC_DEBUG

				printf("#ifndef %s\n", get_tok_str(tok, NULL));
#endif

				file->ifndef_macro = tok;
			}
		}
		if (define_find(tok)
		    || tok == TOK___HAS_INCLUDE
		    || tok == TOK___HAS_INCLUDE_NEXT)
			c ^= 1;
		next_nomacro();
do_if:
		if (s1->ifdef_stack_ptr >= s1->ifdef_stack + IFDEF_STACK_SIZE)
			tcc_error("memory full (ifdef)");
		*s1->ifdef_stack_ptr++ = c;
		goto test_skip;
	case TOK_ELSE:
		next_nomacro();
		if (s1->ifdef_stack_ptr == s1->ifdef_stack)
			tcc_error("#else without matching #if");
		if (s1->ifdef_stack_ptr[-1] & 2)
			tcc_error("#else after #else");
		c = (s1->ifdef_stack_ptr[-1] ^= 3);
		goto test_else;
	case TOK_ELIF:
		if (s1->ifdef_stack_ptr == s1->ifdef_stack)
			tcc_error("#elif without matching #if");
		c = s1->ifdef_stack_ptr[-1];
		if (c > 1)
			tcc_error("#elif after #else");
		/* last #if/#elif expression was true: we skip */

		if (c == 1) {
			skip_to_eol(0);
			c = 0;
		} else {
			c = expr_preprocess(s1);
			s1->ifdef_stack_ptr[-1] = c;
		}
test_else:
		if (s1->ifdef_stack_ptr == file->ifdef_stack_ptr + 1)
			file->ifndef_macro = 0;
test_skip:
		if (!(c & 1)) {
			skip_to_eol(1);
			preprocess_skip();
			is_bof = 0;
			goto redo;
		}
		break;
	case TOK_ENDIF:
		next_nomacro();
		if (s1->ifdef_stack_ptr <= file->ifdef_stack_ptr)
			tcc_error("#endif without matching #if");
		s1->ifdef_stack_ptr--;
		/* '#ifndef macro' was at the start of file. Now we check if
		           an '#endif' is exactly at the end of file */

		if (file->ifndef_macro &&
		    s1->ifdef_stack_ptr == file->ifdef_stack_ptr) {
			file->ifndef_macro_saved = file->ifndef_macro;
			/* need to set to zero to avoid false matches if another
			               #ifndef at middle of file */

			file->ifndef_macro = 0;
			tok_flags |= TOK_FLAG_ENDIF;
		}
		break;

	case TOK_LINE:
		parse_flags &= ~PARSE_FLAG_TOK_NUM;
		next();
		if (tok != TOK_PPNUM) {
_line_err:
			tcc_error("wrong #line format");
		}
		c = 1;
		goto _line_num;
	case TOK_PPNUM:
		if (parse_flags & PARSE_FLAG_ASM_FILE)
			goto ignore;
		c = 0;/* no error with extra tokens */

_line_num:
		for (n = 0, q = tokc.str.data; *q; ++q) {
			if (!isnum(*q))
				goto _line_err;
			n = n * 10 + *q - '0';
		}
		parse_flags &= ~PARSE_FLAG_TOK_STR;/* don't parse escape sequences */

		next();
		if (tok != TOK_LINEFEED) {
			if (tok != TOK_PPSTR || tokc.str.data[0] != '"')
				goto _line_err;
			tokc.str.data[tokc.str.size - 2] = 0;
			tccpp_putfile(tokc.str.data + 1);
			next();
			/* skip optional level number & advance to next line */

			skip_to_eol(c);
		}
		if (file->fd > 0)
			total_lines += file->line_num - n;
		file->line_num = n;
		break;

	case TOK_ERROR:
	case TOK_WARNING: {
		q = buf;
		c = skip_spaces();
		while (c != '\n' && c != CH_EOF) {
			if ((q - buf) < sizeof(buf) - 1)
				*q++ = c;
			c = ninp();
		}
		*q = '\0';
		if (tok == TOK_ERROR)
			tcc_error("#error %s", buf);
		else
			tcc_warning("#warning %s", buf);
		next_nomacro();
		break;
	}
	case TOK_PRAGMA:
		if (!pragma_parse(s1))
			goto ignore;
		break;
	case TOK_LINEFEED:
		goto the_end;
	default:
		/* ignore gas line comment in an 'S' file. */

		if (saved_parse_flags & PARSE_FLAG_ASM_FILE)
			goto ignore;
		if (tok == '!' && is_bof)
			/* '#!' is ignored at beginning to allow C scripts. */

			goto ignore;
		tcc_warning("Ignoring unknown preprocessing directive #%s", get_tok_str(tok,
				&tokc));
ignore:
		skip_to_eol(0);
		goto the_end;
	}
	skip_to_eol(1);
the_end:
	parse_flags = saved_parse_flags;
}
/* evaluate escape codes in a string. */

static void parse_escape_string(CString *outstr, const uint8_t *buf,
				int is_long)
{
	int c, n, i;
	const uint8_t *p;

	p = buf;
	for (;;) {
		c = *p;
		if (c == '\0')
			break;
		if (c == '\\') {
			p++;
			/* escape */

			c = *p;
			switch (c) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				/* at most three octal digits */

				n = c - '0';
				p++;
				c = *p;
				if (isoct(c)) {
					n = n * 8 + c - '0';
					p++;
					c = *p;
					if (isoct(c)) {
						n = n * 8 + c - '0';
						p++;
					}
				}
				c = n;
				goto add_char_nonext;
			case 'x':
				i = 0;
				goto parse_hex_or_ucn;
			case 'u':
				i = 4;
				goto parse_hex_or_ucn;
			case 'U':
				i = 8;
				goto parse_hex_or_ucn;
parse_hex_or_ucn:
				p++;
				n = 0;
				do {
					c = *p;
					if (c >= 'a' && c <= 'f')
						c = c - 'a' + 10;
					else if (c >= 'A' && c <= 'F')
						c = c - 'A' + 10;
					else if (isnum(c))
						c = c - '0';
					else if (i >= 0)
						expect("more hex digits in universal-character-name");
					else
						goto add_hex_or_ucn;
					n = n * 16 + c;
					p++;
				} while (--i);
				if (is_long) {
add_hex_or_ucn:
					c = n;
					goto add_char_nonext;
				}
				cstr_u8cat(outstr, n);
				continue;
			case 'a':
				c = '\a';
				break;
			case 'b':
				c = '\b';
				break;
			case 'f':
				c = '\f';
				break;
			case 'n':
				c = '\n';
				break;
			case 'r':
				c = '\r';
				break;
			case 't':
				c = '\t';
				break;
			case 'v':
				c = '\v';
				break;
			case 'e':
				if (!gnu_ext)
					goto invalid_escape;
				c = 27;
				break;
			case '\'':
			case '\"':
			case '\\':
			case '?':
				break;
			default:
invalid_escape:
				if (c >= '!' && c <= '~')
					tcc_warning("unknown escape sequence: \'\\%c\'", c);
				else
					tcc_warning("unknown escape sequence: \'\\x%x\'", c);
				break;
			}
		} else if (is_long && c >= 0x80) {
			/* assume we are processing UTF-8 sequence */
			/* reference: The Unicode Standard, Version 10.0, ch3.9 */

			int cont;/* count of continuation bytes */

			int skip;/* how many bytes should skip when error occurred */

			int i;
			/* decode leading byte */

			if (c < 0xC2) {
				skip = 1;
				goto invalid_utf8_sequence;
			} else if (c <= 0xDF) {
				cont = 1;
				n = c & 0x1f;
			} else if (c <= 0xEF) {
				cont = 2;
				n = c & 0xf;
			} else if (c <= 0xF4) {
				cont = 3;
				n = c & 0x7;
			} else {
				skip = 1;
				goto invalid_utf8_sequence;
			}
			/* decode continuation bytes */

			for (i = 1; i <= cont; i++) {
				int l = 0x80, h = 0xBF;
				/* adjust limit for second byte */

				if (i == 1) {
					switch (c) {
					case 0xE0:
						l = 0xA0;
						break;
					case 0xED:
						h = 0x9F;
						break;
					case 0xF0:
						l = 0x90;
						break;
					case 0xF4:
						h = 0x8F;
						break;
					}
				}

				if (p[i] < l || p[i] > h) {
					skip = i;
					goto invalid_utf8_sequence;
				}

				n = (n << 6) | (p[i] & 0x3f);
			}
			/* advance pointer */

			p += 1 + cont;
			c = n;
			goto add_char_nonext;
			/* error handling */

invalid_utf8_sequence:
			tcc_warning("ill-formed UTF-8 subsequence starting with: \'\\x%x\'", c);
			c = 0xFFFD;
			p += skip;
			goto add_char_nonext;

		}
		p++;
add_char_nonext:
		if (!is_long)
			cstr_ccat(outstr, c);
		else {
			/* store as UTF-16 */

			if (c < 0x10000) {
				cstr_wccat(outstr, c);
			} else {
				c -= 0x10000;
				cstr_wccat(outstr, (c >> 10) + 0xD800);
				cstr_wccat(outstr, (c & 0x3FF) + 0xDC00);
			}

		}
	}
	/* add a trailing '\0' */

	if (!is_long)
		cstr_ccat(outstr, '\0');
	else
		cstr_wccat(outstr, '\0');
}

static void parse_string(const char *s, int len)
{
	uint8_t buf[1000], *p = buf;
	int is_long, sep;

	if ((is_long = *s == 'L'))
		++s, --len;
	sep = *s++;
	len -= 2;
	if (len >= sizeof buf)
		p = tcc_malloc(len + 1);
	memcpy(p, s, len);
	p[len] = 0;

	cstr_reset(&tokcstr);
	parse_escape_string(&tokcstr, p, is_long);
	if (p != buf)
		tcc_free(p);

	if (sep == '\'') {
		int char_size, i, n, c;
		/* XXX: make it portable */

		if (!is_long)
			tok = TOK_CCHAR, char_size = 1;
		else
			tok = TOK_LCHAR, char_size = sizeof(nwchar_t);
		n = tokcstr.size / char_size - 1;
		if (n < 1)
			tcc_error("empty character constant");
		if (n > 1)
			tcc_warning_c(warn_all)("multi-character character constant");
		for (c = i = 0; i < n; ++i) {
			if (is_long)
				c = ((nwchar_t *)tokcstr.data)[i];
			else
				c = (c << 8) | ((char *)tokcstr.data)[i];
		}
		tokc.i = c;
	} else {
		tokc.str.size = tokcstr.size;
		tokc.str.data = tokcstr.data;
		if (!is_long)
			tok = TOK_STR;
		else
			tok = TOK_LSTR;
	}
}
/* we use 64 bit numbers */

#define BN_SIZE 2
/* bn = (bn << shift) | or_val */

static void bn_lshift(unsigned int *bn, int shift, int or_val)
{
	int i;
	unsigned int v;
	for (i=0; i<BN_SIZE; i++) {
		v = bn[i];
		bn[i] = (v << shift) | or_val;
		or_val = v >> (32 - shift);
	}
}

static void bn_zero(unsigned int *bn)
{
	int i;
	for (i=0; i<BN_SIZE; i++) {
		bn[i] = 0;
	}
}
/* parse number in null terminated string 'p' and return it in the
   current token */

static void parse_number(const char *p)
{
	int b, t, shift, frac_bits, s, exp_val, ch;
	char *q;
	unsigned int bn[BN_SIZE];
	double d;
	/* number */

	q = token_buf;
	ch = *p++;
	t = ch;
	ch = *p++;
	*q++ = t;
	b = 10;
	if (t == '.') {
		goto float_frac_parse;
	} else if (t == '0') {
		if (ch == 'x' || ch == 'X') {
			q--;
			ch = *p++;
			b = 16;
		} else if (tcc_state->tcc_ext && (ch == 'b' || ch == 'B')) {
			q--;
			ch = *p++;
			b = 2;
		}
	}
	/* parse all digits. cannot check octal numbers at this stage
	       because of floating point constants */

	while (1) {
		if (ch >= 'a' && ch <= 'f')
			t = ch - 'a' + 10;
		else if (ch >= 'A' && ch <= 'F')
			t = ch - 'A' + 10;
		else if (isnum(ch))
			t = ch - '0';
		else
			break;
		if (t >= b)
			break;
		if (q >= token_buf + STRING_MAX_SIZE) {
num_too_long:
			tcc_error("number too long");
		}
		*q++ = ch;
		ch = *p++;
	}
	if (ch == '.' ||
	    ((ch == 'e' || ch == 'E') && b == 10) ||
	    ((ch == 'p' || ch == 'P') && (b == 16 || b == 2))) {
		if (b != 10) {
			/* NOTE: strtox should support that for hexa numbers, but
			               non ISOC99 libcs do not support it, so we prefer to do
			               it by hand */
			/* hexadecimal or binary floats */
			/* XXX: handle overflows */

			*q = '\0';
			if (b == 16)
				shift = 4;
			else
				shift = 1;
			bn_zero(bn);
			q = token_buf;
			while (1) {
				t = *q++;
				if (t == '\0') {
					break;
				} else if (t >= 'a') {
					t = t - 'a' + 10;
				} else if (t >= 'A') {
					t = t - 'A' + 10;
				} else {
					t = t - '0';
				}
				bn_lshift(bn, shift, t);
			}
			frac_bits = 0;
			if (ch == '.') {
				ch = *p++;
				while (1) {
					t = ch;
					if (t >= 'a' && t <= 'f') {
						t = t - 'a' + 10;
					} else if (t >= 'A' && t <= 'F') {
						t = t - 'A' + 10;
					} else if (t >= '0' && t <= '9') {
						t = t - '0';
					} else {
						break;
					}
					if (t >= b)
						tcc_error("invalid digit");
					bn_lshift(bn, shift, t);
					frac_bits += shift;
					ch = *p++;
				}
			}
			if (ch != 'p' && ch != 'P')
				expect("exponent");
			ch = *p++;
			s = 1;
			exp_val = 0;
			if (ch == '+') {
				ch = *p++;
			} else if (ch == '-') {
				s = -1;
				ch = *p++;
			}
			if (ch < '0' || ch > '9')
				expect("exponent digits");
			while (ch >= '0' && ch <= '9') {
				exp_val = exp_val * 10 + ch - '0';
				ch = *p++;
			}
			exp_val = exp_val * s;
			/* now we can generate the number */
			/* XXX: should patch directly float number */

			d = (double)bn[1] * 4294967296.0 + (double)bn[0];
			d = ldexp(d, exp_val - frac_bits);
			t = toup(ch);
			if (t == 'F') {
				ch = *p++;
				tok = TOK_CFLOAT;
				/* float : should handle overflow */

				tokc.f = (float)d;
			} else if (t == 'L') {
				ch = *p++;
				tok = TOK_CLDOUBLE;
#ifdef TCC_USING_DOUBLE_FOR_LDOUBLE

				tokc.d = d;
#else

				/* XXX: not large enough */

				tokc.ld = (long double)d;
#endif

			} else {
				tok = TOK_CDOUBLE;
				tokc.d = d;
			}
		} else {
			/* decimal floats */

			if (ch == '.') {
				if (q >= token_buf + STRING_MAX_SIZE)
					goto num_too_long;
				*q++ = ch;
				ch = *p++;
float_frac_parse:
				while (ch >= '0' && ch <= '9') {
					if (q >= token_buf + STRING_MAX_SIZE)
						goto num_too_long;
					*q++ = ch;
					ch = *p++;
				}
			}
			if (ch == 'e' || ch == 'E') {
				if (q >= token_buf + STRING_MAX_SIZE)
					goto num_too_long;
				*q++ = ch;
				ch = *p++;
				if (ch == '-' || ch == '+') {
					if (q >= token_buf + STRING_MAX_SIZE)
						goto num_too_long;
					*q++ = ch;
					ch = *p++;
				}
				if (ch < '0' || ch > '9')
					expect("exponent digits");
				while (ch >= '0' && ch <= '9') {
					if (q >= token_buf + STRING_MAX_SIZE)
						goto num_too_long;
					*q++ = ch;
					ch = *p++;
				}
			}
			*q = '\0';
			t = toup(ch);
			errno = 0;
			if (t == 'F') {
				ch = *p++;
				tok = TOK_CFLOAT;
				tokc.f = strtof(token_buf, NULL);
			} else if (t == 'L') {
				ch = *p++;
				tok = TOK_CLDOUBLE;
#ifdef TCC_USING_DOUBLE_FOR_LDOUBLE

				tokc.d = strtod(token_buf, NULL);
#else

				tokc.ld = strtold(token_buf, NULL);
#endif

			} else {
				tok = TOK_CDOUBLE;
				tokc.d = strtod(token_buf, NULL);
			}
		}
	} else {
		unsigned long long n, n1;
		int lcount, ucount, ov = 0;
		const char *p1;
		/* integer number */

		*q = '\0';
		q = token_buf;
		if (b == 10 && *q == '0') {
			b = 8;
			q++;
		}
		n = 0;
		while (1) {
			t = *q++;
			/* no need for checks except for base 10 / 8 errors */

			if (t == '\0')
				break;
			else if (t >= 'a')
				t = t - 'a' + 10;
			else if (t >= 'A')
				t = t - 'A' + 10;
			else
				t = t - '0';
			if (t >= b)
				tcc_error("invalid digit");
			n1 = n;
			n = n * b + t;
			/* detect overflow */

			if (n1 >= 0x1000000000000000ULL && n / b != n1)
				ov = 1;
		}
		/* Determine the characteristics (unsigned and/or 64bit) the type of
		           the constant must have according to the constant suffix(es) */

		lcount = ucount = 0;
		p1 = p;
		for (;;) {
			t = toup(ch);
			if (t == 'L') {
				if (lcount >= 2)
					tcc_error("three 'l's in integer constant");
				if (lcount && *(p - 1) != ch)
					tcc_error("incorrect integer suffix: %s", p1);
				lcount++;
				ch = *p++;
			} else if (t == 'U') {
				if (ucount >= 1)
					tcc_error("two 'u's in integer constant");
				ucount++;
				ch = *p++;
			} else {
				break;
			}
		}
		/* in #if/#elif expressions, all numbers have type (u)intmax_t anyway */

		if (pp_expr)
			lcount = 2;
		/* Determine if it needs 64 bits and/or unsigned in order to fit */

		if (ucount == 0 && b == 10) {
			if (lcount <= (LONG_SIZE == 4)) {
				if (n >= 0x80000000U)
					lcount = (LONG_SIZE == 4) + 1;
			}
			if (n >= 0x8000000000000000ULL)
				ov = 1, ucount = 1;
		} else {
			if (lcount <= (LONG_SIZE == 4)) {
				if (n >= 0x100000000ULL)
					lcount = (LONG_SIZE == 4) + 1;
				else if (n >= 0x80000000U)
					ucount = 1;
			}
			if (n >= 0x8000000000000000ULL)
				ucount = 1;
		}

		if (ov)
			tcc_warning("integer constant overflow");

		tok = TOK_CINT;
		if (lcount) {
			tok = TOK_CLONG;
			if (lcount == 2)
				tok = TOK_CLLONG;
		}
		if (ucount)
			++tok;/* TOK_CU... */

		tokc.i = n;
	}
	if (ch)
		tcc_error("invalid number");
}
// 2559 "tccpp.c"
#define PARSE2(c1,tok1,c2,tok2) case c1: PEEKC(c, p); if (c == c2) { p++; tok = tok2; } else { tok = tok1; } break;
/* return next token without macro substitution */

static void next_nomacro(void)
{
	int t, c, is_long, len;
	TokenSym *ts;
	uint8_t *p, *p1;
	unsigned int h;

	p = file->buf_ptr;
redo_no_start:
	c = *p;
	switch (c) {
	case ' ':
	case '\t':
		tok = c;
		p++;
maybe_space:
		if (parse_flags & PARSE_FLAG_SPACES)
			goto keep_tok_flags;
		while (isidnum_table[*p - CH_EOF] & IS_SPC)
			++p;
		goto redo_no_start;
	case '\f':
	case '\v':
	case '\r':
		p++;
		goto redo_no_start;
	case '\\':
		/* first look if it is in fact an end of buffer */

		c = handle_stray(&p);
		if (c == '\\')
			goto parse_simple;
		if (c == CH_EOF) {
			TCCState *s1 = tcc_state;
			if (!(tok_flags & TOK_FLAG_BOL)) {
				/* add implicit newline */

				goto maybe_newline;
			} else if (!(parse_flags & PARSE_FLAG_PREPROCESS)) {
				tok = TOK_EOF;
			} else if (s1->ifdef_stack_ptr != file->ifdef_stack_ptr) {
				tcc_error("missing #endif");
			} else if (s1->include_stack_ptr == s1->include_stack) {
				/* no include left : end of file. */

				tok = TOK_EOF;
			} else {
				/* pop include file */
				/* test if previous '#endif' was after a #ifdef at
				                   start of file */

				if (tok_flags & TOK_FLAG_ENDIF) {
#ifdef INC_DEBUG

					printf("#endif %s\n", get_tok_str(file->ifndef_macro_saved, NULL));
#endif

					search_cached_include(s1, file->true_filename, 1)
					->ifndef_macro = file->ifndef_macro_saved;
					tok_flags &= ~TOK_FLAG_ENDIF;
				}
				/* add end of include file debug info */

				tcc_debug_eincl(tcc_state);
				/* pop include stack */

				tcc_close();
				s1->include_stack_ptr--;
				p = file->buf_ptr;
				goto maybe_newline;
			}
		} else {
			goto redo_no_start;
		}
		break;

	case '\n':
		file->line_num++;
		p++;
maybe_newline:
		tok_flags |= TOK_FLAG_BOL;
		if (0 == (parse_flags & PARSE_FLAG_LINEFEED))
			goto redo_no_start;
		tok = TOK_LINEFEED;
		goto keep_tok_flags;

	case '#':
		/* XXX: simplify */

		PEEKC(c, p);
		if ((tok_flags & TOK_FLAG_BOL) &&
		    (parse_flags & PARSE_FLAG_PREPROCESS)) {
			tok_flags &= ~TOK_FLAG_BOL;
			file->buf_ptr = p;
			preprocess(tok_flags & TOK_FLAG_BOF);
			p = file->buf_ptr;
			goto maybe_newline;
		} else {
			if (c == '#') {
				p++;
				tok = TOK_TWOSHARPS;
			} else {

				if (parse_flags & PARSE_FLAG_ASM_FILE) {
					p = parse_line_comment(p - 1);
					goto redo_no_start;
				} else

				{
					tok = '#';
				}
			}
		}
		break;
	/* dollar is allowed to start identifiers when not parsing asm */

	case '$':
		if (!(isidnum_table['$' - CH_EOF] & IS_ID)
		    || (parse_flags & PARSE_FLAG_ASM_FILE))
			goto parse_simple;

	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
parse_ident_fast:
		p1 = p;
		h = TOK_HASH_INIT;
		h = TOK_HASH_FUNC(h, c);
		while (c = *++p, isidnum_table[c - CH_EOF] & (IS_ID|IS_NUM))
			h = TOK_HASH_FUNC(h, c);
		len = p - p1;
		if (c != '\\') {
			TokenSym **pts;
			/* fast case : no stray found, so we have the full token
			               and we have already hashed it */

			h &= (TOK_HASH_SIZE - 1);
			pts = &hash_ident[h];
			for (;;) {
				ts = *pts;
				if (!ts)
					break;
				if (ts->len == len && !memcmp(ts->str, p1, len))
					goto token_found;
				pts = &(ts->hash_next);
			}
			ts = tok_alloc_new(pts, (char *) p1, len);
token_found: ;
		} else {
			/* slower case */

			cstr_reset(&tokcstr);
			cstr_cat(&tokcstr, (char *) p1, len);
			p--;
			PEEKC(c, p);
parse_ident_slow:
			while (isidnum_table[c - CH_EOF] & (IS_ID|IS_NUM)) {
				cstr_ccat(&tokcstr, c);
				PEEKC(c, p);
			}
			ts = tok_alloc(tokcstr.data, tokcstr.size);
		}
		tok = ts->tok;
		break;
	case 'L':
		t = p[1];
		if (t != '\\' && t != '\'' && t != '\"') {
			/* fast case */

			goto parse_ident_fast;
		} else {
			PEEKC(c, p);
			if (c == '\'' || c == '\"') {
				is_long = 1;
				goto str_const;
			} else {
				cstr_reset(&tokcstr);
				cstr_ccat(&tokcstr, 'L');
				goto parse_ident_slow;
			}
		}
		break;

	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		t = c;
		PEEKC(c, p);
		/* after the first digit, accept digits, alpha, '.' or sign if
		           prefixed by 'eEpP' */

parse_num:
		cstr_reset(&tokcstr);
		for (;;) {
			cstr_ccat(&tokcstr, t);
			if (!((isidnum_table[c - CH_EOF] & (IS_ID|IS_NUM))
			      || c == '.'
			      || ((c == '+' || c == '-')
				  && (((t == 'e' || t == 'E')
				       && !(parse_flags & PARSE_FLAG_ASM_FILE
					    /* 0xe+1 is 3 tokens in asm */

					    && ((char*)tokcstr.data)[0] == '0'
					    && toup(((char*)tokcstr.data)[1]) == 'X'))
				      || t == 'p' || t == 'P'))))
				break;
			t = c;
			PEEKC(c, p);
		}
		/* We add a trailing '\0' to ease parsing */

		cstr_ccat(&tokcstr, '\0');
		tokc.str.size = tokcstr.size;
		tokc.str.data = tokcstr.data;
		tok = TOK_PPNUM;
		break;

	case '.':
		/* special dot handling because it can also start a number */

		PEEKC(c, p);
		if (isnum(c)) {
			t = '.';
			goto parse_num;
		} else if ((isidnum_table['.' - CH_EOF] & IS_ID)
			   && (isidnum_table[c - CH_EOF] & (IS_ID|IS_NUM))) {
			*--p = c = '.';
			goto parse_ident_fast;
		} else if (c == '.') {
			PEEKC(c, p);
			if (c == '.') {
				p++;
				tok = TOK_DOTS;
			} else {
				*--p = '.';/* may underflow into file->unget[] */

				tok = '.';
			}
		} else {
			tok = '.';
		}
		break;
	case '\'':
	case '\"':
		is_long = 0;
str_const:
		cstr_reset(&tokcstr);
		if (is_long)
			cstr_ccat(&tokcstr, 'L');
		cstr_ccat(&tokcstr, c);
		p = parse_pp_string(p, c, &tokcstr);
		cstr_ccat(&tokcstr, c);
		cstr_ccat(&tokcstr, '\0');
		tokc.str.size = tokcstr.size;
		tokc.str.data = tokcstr.data;
		tok = TOK_PPSTR;
		break;

	case '<':
		PEEKC(c, p);
		if (c == '=') {
			p++;
			tok = TOK_LE;
		} else if (c == '<') {
			PEEKC(c, p);
			if (c == '=') {
				p++;
				tok = TOK_A_SHL;
			} else {
				tok = TOK_SHL;
			}
		} else {
			tok = TOK_LT;
		}
		break;
	case '>':
		PEEKC(c, p);
		if (c == '=') {
			p++;
			tok = TOK_GE;
		} else if (c == '>') {
			PEEKC(c, p);
			if (c == '=') {
				p++;
				tok = TOK_A_SAR;
			} else {
				tok = TOK_SAR;
			}
		} else {
			tok = TOK_GT;
		}
		break;

	case '&':
		PEEKC(c, p);
		if (c == '&') {
			p++;
			tok = TOK_LAND;
		} else if (c == '=') {
			p++;
			tok = TOK_A_AND;
		} else {
			tok = '&';
		}
		break;

	case '|':
		PEEKC(c, p);
		if (c == '|') {
			p++;
			tok = TOK_LOR;
		} else if (c == '=') {
			p++;
			tok = TOK_A_OR;
		} else {
			tok = '|';
		}
		break;

	case '+':
		PEEKC(c, p);
		if (c == '+') {
			p++;
			tok = TOK_INC;
		} else if (c == '=') {
			p++;
			tok = TOK_A_ADD;
		} else {
			tok = '+';
		}
		break;

	case '-':
		PEEKC(c, p);
		if (c == '-') {
			p++;
			tok = TOK_DEC;
		} else if (c == '=') {
			p++;
			tok = TOK_A_SUB;
		} else if (c == '>') {
			p++;
			tok = TOK_ARROW;
		} else {
			tok = '-';
		}
		break;

		PARSE2('!', '!', '=', TOK_NE)
		PARSE2('=', '=', '=', TOK_EQ)
		PARSE2('*', '*', '=', TOK_A_MUL)
		PARSE2('%', '%', '=', TOK_A_MOD)
		PARSE2('^', '^', '=', TOK_A_XOR)
	/* comments or operator */

	case '/':
		PEEKC(c, p);
		if (c == '*') {
			p = parse_comment(p);
			/* comments replaced by a blank */

			tok = ' ';
			goto maybe_space;
		} else if (c == '/') {
			p = parse_line_comment(p);
			tok = ' ';
			goto maybe_space;
		} else if (c == '=') {
			p++;
			tok = TOK_A_DIV;
		} else {
			tok = '/';
		}
		break;
	/* simple tokens */

	case '@':/* only used in assembler */

	case '(':
	case ')':
	case '[':
	case ']':
	case '{':
	case '}':
	case ',':
	case ';':
	case ':':
	case '?':
	case '~':
parse_simple:
		tok = c;
		p++;
		break;
	default:
		if (c >= 0x80 && c <= 0xFF)/* utf8 identifiers */

			goto parse_ident_fast;
		if (parse_flags & PARSE_FLAG_ASM_FILE)
			goto parse_simple;
		tcc_error("unrecognized character \\x%02x", c);
		break;
	}
	tok_flags = 0;
keep_tok_flags:
	file->buf_ptr = p;
#if defined(PARSE_DEBUG)
	printf("token = %d %s\n", tok, get_tok_str(tok, &tokc));
#endif

}
#ifdef PP_DEBUG

static int indent;
static void define_print(TCCState *s1, int v);
static void pp_print(const char *msg, int v, const int *str)
{
	FILE *fp = tcc_state->ppfp;

	if (msg[0] == '#' && indent == 0)
		fprintf(fp, "\n");
	else if (msg[0] == '+')
		++indent, ++msg;
	else if (msg[0] == '-')
		--indent, ++msg;

	fprintf(fp, "%*s", indent, "");
	if (msg[0] == '#') {
		define_print(tcc_state, v);
	} else {
		tok_print(str, v ? "%s %s" : "%s", msg, get_tok_str(v, 0));
	}
}
#define PP_PRINT(x) pp_print x
#else
// 2997 "tccpp.c"
#define PP_PRINT(x)
#endif

static int macro_subst(
	TokenString *tok_str,
	Sym **nested_list,
	const int *macro_str
);
/* substitute arguments in replacement lists in macro_str by the values in
   args (field d) and return allocated string */

static int *macro_arg_subst(Sym **nested_list, const int *macro_str, Sym *args)
{
	int t, t0, t1, t2, n;
	const int *st;
	Sym *s;
	CValue cval;
	TokenString str;
#ifdef PP_DEBUG

	PP_PRINT(("asubst:", 0, macro_str));
	for (s = args, n = 0; s; s = s->prev, ++n);
	while (n--) {
		for (s = args, t = 0; t < n; s = s->prev, ++t);
		tok_print(s->d, "%*s - arg: %s:", indent, "", get_tok_str(s->v, 0));
	}
#endif
// 3025 "tccpp.c"
	tok_str_new(&str);
	t0 = t1 = 0;
	while (1) {
		TOK_GET(&t, &macro_str, &cval);
		if (!t)
			break;
		if (t == '#') {
			/* stringize */

			do t = *macro_str++;
			while (t == ' ');
			s = sym_find2(args, t);
			if (s) {
				cstr_reset(&tokcstr);
				cstr_ccat(&tokcstr, '\"');
				st = s->d;
				while (*st != TOK_EOF) {
					const char *s;
					TOK_GET(&t, &st, &cval);
					s = get_tok_str(t, &cval);
					while (*s) {
						if (t == TOK_PPSTR && *s != '\'')
							add_char(&tokcstr, *s);
						else
							cstr_ccat(&tokcstr, *s);
						++s;
					}
				}
				cstr_ccat(&tokcstr, '\"');
				cstr_ccat(&tokcstr, '\0');
//printf("\nstringize: <%s>\n", (char *)tokcstr.data);
				/* add string */

				cval.str.size = tokcstr.size;
				cval.str.data = tokcstr.data;
				tok_str_add2(&str, TOK_PPSTR, &cval);
			} else {
				expect("macro parameter after '#'");
			}
		} else if (t >= TOK_IDENT) {
			s = sym_find2(args, t);
			if (s) {
				st = s->d;
				n = 0;
				while ((t2 = macro_str[n]) == ' ')
					++n;
				/* if '##' is present before or after, no arg substitution */

				if (t2 == TOK_PPJOIN || t1 == TOK_PPJOIN) {
					/* special case for var arg macros : ## eats the ','
					                       if empty VA_ARGS variable. */

					if (t1 == TOK_PPJOIN && t0 == ',' && gnu_ext && s->type.t) {
						int c = str.str[str.len - 1];
						while (str.str[--str.len] != ',')
							;
						if (*st == TOK_EOF) {
							/* suppress ',' '##' */

						} else {
							/* suppress '##' and add variable */

							str.len++;
							if (c == ' ')
								str.str[str.len++] = c;
							goto add_var;
						}
					} else {
						if (*st == TOK_EOF)
							tok_str_add(&str, TOK_PLCHLDR);
					}
				} else {
add_var:
					if (!s->e) {
						/* Expand arguments tokens and store them.  In most
									   cases we could also re-expand each argument if
									   used multiple times, but not if the argument
									   contains the __COUNTER__ macro.  */

						TokenString str2;
						tok_str_new(&str2);
						macro_subst(&str2, nested_list, st);
						tok_str_add(&str2, TOK_EOF);
						s->e = str2.str;
					}
					st = s->e;
				}
				while (*st != TOK_EOF) {
					TOK_GET(&t2, &st, &cval);
					tok_str_add2(&str, t2, &cval);
				}
			} else {
				tok_str_add(&str, t);
			}
		} else {
			tok_str_add2(&str, t, &cval);
		}
		if (t != ' ')
			t0 = t1, t1 = t;
	}
	tok_str_add(&str, 0);
	PP_PRINT(("areslt:", 0, str.str));
	return str.str;
}
/* handle the '##' operator. return the resulting string (which must be freed). */

static inline int *macro_twosharps(const int *ptr0)
{
	int t1, t2, n, l;
	CValue cv1, cv2;
	TokenString macro_str1;
	const int *ptr;

	tok_str_new(&macro_str1);
	cstr_reset(&tokcstr);
	for (ptr = ptr0;;) {
		TOK_GET(&t1, &ptr, &cv1);
		if (t1 == 0)
			break;
		for (;;) {
			n = 0;
			while ((t2 = ptr[n]) == ' ')
				++n;
			if (t2 != TOK_PPJOIN)
				break;
			ptr += n;
			while ((t2 = *++ptr) == ' ' || t2 == TOK_PPJOIN)
				;
			TOK_GET(&t2, &ptr, &cv2);
			if (t2 == TOK_PLCHLDR)
				continue;
			if (t1 != TOK_PLCHLDR) {
				cstr_cat(&tokcstr, get_tok_str(t1, &cv1), -1);
				t1 = TOK_PLCHLDR;
			}
			cstr_cat(&tokcstr, get_tok_str(t2, &cv2), -1);
		}
		if (tokcstr.size) {
			cstr_ccat(&tokcstr, 0);
			tcc_open_bf(tcc_state, ":paste:", tokcstr.size);
			memcpy(file->buffer, tokcstr.data, tokcstr.size);
			tok_flags = 0;/* don't interpret '#' */

			for (n = 0;; n = l) {
				next_nomacro();
				tok_str_add2(&macro_str1, tok, &tokc);
				if (*file->buf_ptr == 0)
					break;
				tok_str_add(&macro_str1, ' ');
				l = file->buf_ptr - file->buffer;
				tcc_warning("pasting \"%.*s\" and \"%s\" does not give a valid"
					    " preprocessing token", l - n, file->buffer + n, file->buf_ptr);
			}
			tcc_close();
			cstr_reset(&tokcstr);
		}
		if (t1 != TOK_PLCHLDR)
			tok_str_add2(&macro_str1, t1, &cv1);
	}
	tok_str_add(&macro_str1, 0);
	PP_PRINT(("pasted:", 0, macro_str1.str));
	return macro_str1.str;
}

static int peek_file (TokenString *ws_str)
{
	uint8_t *p = file->buf_ptr - 1;
	int c;
	for (;;) {
		PEEKC(c, p);
		switch (c) {
		case '/':
			PEEKC(c, p);
			if (c == '*')
				p = parse_comment(p);
			else if (c == '/')
				p = parse_line_comment(p);
			else {
				c = *--p = '/';
				goto leave;
			}
			--p, c = ' ';
			break;
		case ' ':
		case '\t':
			break;
		case '\f':
		case '\v':
		case '\r':
			continue;
		case '\n':
			file->line_num++, tok_flags |= TOK_FLAG_BOL;
			break;
		default:
leave:
			file->buf_ptr = p;
			return c;
		}
		if (ws_str)
			tok_str_add(ws_str, c);
	}
}
/* peek or read [ws_str == NULL] next t\oken from function macro call,
   walking up macro levels up to the file if necessary */

static int next_argstream(Sym **nested_list, TokenString *ws_str)
{
	int t;
	Sym *sa;

	while (macro_ptr) {
		const int *m = macro_ptr;
		while ((t = *m) != 0) {
			if (ws_str) {
				if (t != ' ')
					return t;
				++m;
			} else {
				TOK_GET(&tok, &macro_ptr, &tokc);
				return tok;
			}
		}
		end_macro();
		/* also, end of scope for nested defined symbol */

		sa = *nested_list;
		if (sa)
			*nested_list = sa->prev, sym_free(sa);
	}
	if (ws_str) {
		return peek_file(ws_str);
	} else {
		next_nomacro();
		if (tok == '\t' || tok == TOK_LINEFEED)
			tok = ' ';
		return tok;
	}
}
/* do macro substitution of current token with macro 's' and add
   result to (tok_str,tok_len). 'nested_list' is the list of all
   macros we got inside to avoid recursing. Return non zero if no
   substitution needs to be done */

static int macro_subst_tok(
	TokenString *tok_str,
	Sym **nested_list,
	Sym *s)
{
	int t;
	int v = s->v;

	PP_PRINT(("#", v, s->d));
	if (s->d) {
		int *mstr = s->d;
		int *jstr;
		Sym *sa;
		int ret;

		if (s->type.t & MACRO_FUNC) {
			int saved_parse_flags = parse_flags;
			TokenString str;
			int parlevel, i;
			Sym *sa1, *args;

			parse_flags |= PARSE_FLAG_SPACES | PARSE_FLAG_LINEFEED
				       | PARSE_FLAG_ACCEPT_STRAYS;

			tok_str_new(&str);
			/* peek next token from argument stream */

			t = next_argstream(nested_list, &str);
			if (t != '(') {
				/* not a macro substitution after all, restore the
				                 * macro token plus all whitespace we've read.
				                 * whitespace is intentionally not merged to preserve
				                 * newlines. */

				parse_flags = saved_parse_flags;
				tok_str_add2_spc(tok_str, v, 0);
				if (parse_flags & PARSE_FLAG_SPACES)
					for (i = 0; i < str.len; i++)
						tok_str_add(tok_str, str.str[i]);
				tok_str_free_str(str.str);
				return 0;
			} else {
				tok_str_free_str(str.str);
			}
			/* argument macro */

			args = NULL;
			sa = s->next;
			/* NOTE: empty args are allowed, except if no args */

			i = 2;/* eat '(' */

			for (;;) {
				do {
					t = next_argstream(nested_list, NULL);
				} while (t == ' ' || --i);

				if (!sa) {
					if (t == ')')/* handle '()' case */

						break;
					tcc_error("macro '%s' used with too many args",
						  get_tok_str(v, 0));
				}
empty_arg:
				tok_str_new(&str);
				parlevel = 0;
				/* NOTE: non zero sa->type.t indicates VA_ARGS */

				while (parlevel > 0
				       || (t != ')' && (t != ',' || sa->type.t))) {
					if (t == TOK_EOF)
						tcc_error("EOF in invocation of macro '%s'",
							  get_tok_str(v, 0));
					if (t == '(')
						parlevel++;
					if (t == ')')
						parlevel--;
					if (t == ' ')
						str.need_spc |= 1;
					else
						tok_str_add2_spc(&str, t, &tokc);
					t = next_argstream(nested_list, NULL);
				}
				tok_str_add(&str, TOK_EOF);
				sa1 = sym_push2(&args, sa->v & ~SYM_FIELD, sa->type.t, 0);
				sa1->d = str.str;
				sa = sa->next;
				if (t == ')') {
					if (!sa)
						break;
					/* special case for gcc var args: add an empty
					                       var arg argument if it is omitted */

					if (sa->type.t && gnu_ext)
						goto empty_arg;
					tcc_error("macro '%s' used with too few args",
						  get_tok_str(v, 0));
				}
				i = 1;
			}
			/* now subst each arg */

			mstr = macro_arg_subst(nested_list, mstr, args);
			/* free memory */

			sa = args;
			while (sa) {
				sa1 = sa->prev;
				tok_str_free_str(sa->d);
				tok_str_free_str(sa->e);
				sym_free(sa);
				sa = sa1;
			}
			parse_flags = saved_parse_flags;
		}
		/* process '##'s (if present) */

		jstr = mstr;
		if (s->type.t & MACRO_JOIN)
			jstr = macro_twosharps(mstr);

		sa = sym_push2(nested_list, v, 0, 0);
		ret = macro_subst(tok_str, nested_list, jstr);
		/* pop nested defined symbol */

		if (sa == *nested_list)
			*nested_list = sa->prev, sym_free(sa);

		if (jstr != mstr)
			tok_str_free_str(jstr);
		if (mstr != s->d)
			tok_str_free_str(mstr);
		return ret;

	} else {
		CValue cval;
		char buf[32], *cstrval = buf;
		/* special macros */

		if (v == TOK___LINE__ || v == TOK___COUNTER__) {
			t = v == TOK___LINE__ ? file->line_num : pp_counter++;
			snprintf(buf, sizeof(buf), "%d", t);
			t = TOK_PPNUM;
			goto add_cstr1;

		} else if (v == TOK___FILE__) {
			cstrval = file->filename;
			goto add_cstr;

		} else if (v == TOK___DATE__ || v == TOK___TIME__) {
			time_t ti;
			struct tm *tm;
			time(&ti);
			tm = localtime(&ti);
			if (v == TOK___DATE__) {
				static char const ab_month_name[12][4] = {
					"Jan", "Feb", "Mar", "Apr", "May", "Jun",
					"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
				};
				snprintf(buf, sizeof(buf), "%s %2d %d",
					 ab_month_name[tm->tm_mon], tm->tm_mday, tm->tm_year + 1900);
			} else {
				snprintf(buf, sizeof(buf), "%02d:%02d:%02d",
					 tm->tm_hour, tm->tm_min, tm->tm_sec);
			}
add_cstr:
			t = TOK_STR;
add_cstr1:
			cval.str.size = strlen(cstrval) + 1;
			cval.str.data = cstrval;
			tok_str_add2_spc(tok_str, t, &cval);
		}
		return 0;
	}
}
/* do macro substitution of macro_str and add result to
   (tok_str,tok_len). 'nested_list' is the list of all macros we got
   inside to avoid recursing. */

static int macro_subst(
	TokenString *tok_str,
	Sym **nested_list,
	const int *macro_str
)
{
	Sym *s;
	int t, nosubst = 0;
	CValue cval;
	TokenString *str;
#ifdef PP_DEBUG

	int tlen = tok_str->len;
	PP_PRINT(("+expand:", 0, macro_str));
#endif

	while (1) {
		TOK_GET(&t, &macro_str, &cval);
		if (t == 0 || t == TOK_EOF)
			break;
		if (t >= TOK_IDENT) {
			s = define_find(t);
			if (s == NULL || nosubst)
				goto no_subst;
			/* if nested substitution, do nothing */

			if (sym_find2(*nested_list, t)) {
				/* and mark so it doesn't get subst'd again */

				t |= SYM_FIELD;
				goto no_subst;
			}
			str = tok_str_alloc();
			str->str = (int*)macro_str;/* setup stream for possible arguments */

			begin_macro(str, 2);
			nosubst = macro_subst_tok(tok_str, nested_list, s);
			if (macro_stack != str) {
				/* already finished by reading function macro arguments */

				break;
			}
			macro_str = macro_ptr;
			end_macro ();
		} else if (t == ' ') {
			if (parse_flags & PARSE_FLAG_SPACES)
				tok_str->need_spc |= 1;
		} else {
no_subst:
			tok_str_add2_spc(tok_str, t, &cval);
			if (nosubst && t != '(')
				nosubst = 0;
			/* GCC supports 'defined' as result of a macro substitution */

			if (t == TOK_DEFINED && pp_expr)
				nosubst = 1;
		}
	}
#ifdef PP_DEBUG

	tok_str_add(tok_str, 0), --tok_str->len;
	PP_PRINT(("-result:", 0, tok_str->str + tlen));
#endif

	return nosubst;
}
/* return next token with macro substitution */

ST_FUNC void next(void)
{
	int t;
	while (macro_ptr) {
redo:
		t = *macro_ptr;
		if (TOK_HAS_VALUE(t)) {
			tok_get(&tok, &macro_ptr, &tokc);
			if (t == TOK_LINENUM) {
				file->line_num = tokc.i;
				goto redo;
			}
			goto convert;
		} else if (t == 0) {
			/* end of macro or unget token string */

			end_macro();
			continue;
		} else if (t == TOK_EOF) {
			/* do nothing */

		} else {
			++macro_ptr;
			t &= ~SYM_FIELD;/* remove 'nosubst' marker */

			if (t == '\\') {
				if (!(parse_flags & PARSE_FLAG_ACCEPT_STRAYS))
					tcc_error("stray '\\' in program");
			}
		}
		tok = t;
		return;
	}

	next_nomacro();
	t = tok;
	if (t >= TOK_IDENT && (parse_flags & PARSE_FLAG_PREPROCESS)) {
		/* if reading from file, try to substitute macros */

		Sym *s = define_find(t);
		if (s) {
			Sym *nested_list = NULL;
			macro_subst_tok(&tokstr_buf, &nested_list, s);
			tok_str_add(&tokstr_buf, 0);
			begin_macro(&tokstr_buf, 0);
			goto redo;
		}
		return;
	}

convert:
	/* convert preprocessor tokens into C tokens */

	if (t == TOK_PPNUM) {
		if (parse_flags & PARSE_FLAG_TOK_NUM)
			parse_number(tokc.str.data);
	} else if (t == TOK_PPSTR) {
		if (parse_flags & PARSE_FLAG_TOK_STR)
			parse_string(tokc.str.data, tokc.str.size - 1);
	}
}
/* push back current token and set current token to 'last_tok'. Only
   identifier case handled for labels. */

ST_INLN void unget_tok(int last_tok)
{
	TokenString *str = &unget_buf;
	int alloc = 0;
	if (str->len)/* use static buffer except if already in use */

		str = tok_str_alloc(), alloc = 1;
	if (tok != TOK_EOF)
		tok_str_add2(str, tok, &tokc);
	tok_str_add(str, 0);
	begin_macro(str, alloc);
	tok = last_tok;
}
/* ------------------------------------------------------------------------- */
/* init preprocessor */

static const char *const target_os_defs =

	"_WIN32\0"
#if PTR_SIZE == 8

	"_WIN64\0"
#endif
// 3589 "tccpp.c"
	;

static void putdef(CString *cs, const char *p)
{
	cstr_printf(cs, "#define %s%s\n", p, &" 1"[!!strchr(p, ' ')*2]);
}

static void putdefs(CString *cs, const char *p)
{
	while (*p)
		putdef(cs, p), p = strchr(p, 0) + 1;
}

static void tcc_predefs(TCCState *s1, CString *cs, int is_asm)
{
	cstr_printf(cs, "#define __TINYC__ 9%.2s\n", * &TCC_VERSION + 4);
	putdefs(cs, target_machine_defs);
	putdefs(cs, target_os_defs);

	if (is_asm)
		putdef(cs, "__ASSEMBLER__");
	if (s1->output_type == TCC_OUTPUT_PREPROCESS)
		putdef(cs, "__TCC_PP__");
	if (s1->output_type == TCC_OUTPUT_MEMORY)
		putdef(cs, "__TCC_RUN__");
#ifdef CONFIG_TCC_BACKTRACE

	if (s1->do_backtrace)
		putdef(cs, "__TCC_BACKTRACE__");
#endif
#ifdef CONFIG_TCC_BCHECK

	if (s1->do_bounds_check)
		putdef(cs, "__TCC_BCHECK__");
#endif

	if (s1->char_is_unsigned)
		putdef(cs, "__CHAR_UNSIGNED__");
	if (s1->optimize > 0)
		putdef(cs, "__OPTIMIZE__");
	if (s1->option_pthread)
		putdef(cs, "_REENTRANT");
	if (s1->leading_underscore)
		putdef(cs, "__leading_underscore");
	cstr_printf(cs, "#define __SIZEOF_POINTER__ %d\n", PTR_SIZE);
	cstr_printf(cs, "#define __SIZEOF_LONG__ %d\n", LONG_SIZE);
	if (!is_asm) {
		putdef(cs, "__STDC__");
		cstr_printf(cs, "#define __STDC_VERSION__ %dL\n", s1->cversion);
		cstr_cat(cs,
			 /* load more predefs and __builtins */
#if CONFIG_TCC_PREDEFS
			 /* include as strings */
#else

			 "#include <tccdefs.h>\n"/* load at runtime */

#endif

			 , -1);
	}
	cstr_printf(cs, "#define __BASE_FILE__ \"%s\"\n", file->filename);
}

ST_FUNC void preprocess_start(TCCState *s1, int filetype)
{
	int is_asm = !!(filetype & (AFF_TYPE_ASM|AFF_TYPE_ASMPP));

	tccpp_new(s1);

	s1->include_stack_ptr = s1->include_stack;
	s1->ifdef_stack_ptr = s1->ifdef_stack;
	file->ifdef_stack_ptr = s1->ifdef_stack_ptr;
	pp_expr = 0;
	pp_counter = 0;
	pp_debug_tok = pp_debug_symv = 0;
	s1->pack_stack[0] = 0;
	s1->pack_stack_ptr = s1->pack_stack;

	set_idnum('$', !is_asm && s1->dollars_in_identifiers ? IS_ID : 0);
	set_idnum('.', is_asm ? IS_ID : 0);

	if (!(filetype & AFF_TYPE_ASM)) {
		CString cstr;
		cstr_new(&cstr);
		tcc_predefs(s1, &cstr, is_asm);
		if (s1->cmdline_defs.size)
			cstr_cat(&cstr, s1->cmdline_defs.data, s1->cmdline_defs.size);
		if (s1->cmdline_incl.size)
			cstr_cat(&cstr, s1->cmdline_incl.data, s1->cmdline_incl.size);
//printf("%.*s\n", cstr.size, (char*)cstr.data);

		*s1->include_stack_ptr++ = file;
		tcc_open_bf(s1, "<command line>", cstr.size);
		memcpy(file->buffer, cstr.data, cstr.size);
		cstr_free(&cstr);
	}
	parse_flags = is_asm ? PARSE_FLAG_ASM_FILE : 0;
}
/* cleanup from error/setjmp */

ST_FUNC void preprocess_end(TCCState *s1)
{
	while (macro_stack)
		end_macro();
	macro_ptr = NULL;
	while (file)
		tcc_close();
	tccpp_delete(s1);
}

ST_FUNC int set_idnum(int c, int val)
{
	int prev = isidnum_table[c - CH_EOF];
	isidnum_table[c - CH_EOF] = val;
	return prev;
}

ST_FUNC void tccpp_new(TCCState *s)
{
	int i, c;
	const char *p, *r;
	/* init isid table */

	for (i = CH_EOF; i<128; i++)
		set_idnum(i,
			  is_space(i) ? IS_SPC
			  : isid(i) ? IS_ID
			  : isnum(i) ? IS_NUM
			  : 0);

	for (i = 128; i<256; i++)
		set_idnum(i, IS_ID);
	/* init allocators */

	tal_new(&toksym_alloc, TOKSYM_TAL_LIMIT, TOKSYM_TAL_SIZE);
	tal_new(&tokstr_alloc, TOKSTR_TAL_LIMIT, TOKSTR_TAL_SIZE);

	memset(hash_ident, 0, TOK_HASH_SIZE * sizeof(TokenSym *));
	memset(s->cached_includes_hash, 0, sizeof s->cached_includes_hash);

	cstr_new(&tokcstr);
	cstr_new(&cstr_buf);
	cstr_realloc(&cstr_buf, STRING_MAX_SIZE);
	tok_str_new(&tokstr_buf);
	tok_str_realloc(&tokstr_buf, TOKSTR_MAX_SIZE);
	tok_str_new(&unget_buf);

	tok_ident = TOK_IDENT;
	p = tcc_keywords;
	while (*p) {
		r = p;
		for (;;) {
			c = *r++;
			if (c == '\0')
				break;
		}
		tok_alloc(p, r - p - 1);
		p = r;
	}
	/* we add dummy defines for some special macros to speed up tests
	       and to have working defined() */

	define_push(TOK___LINE__, MACRO_OBJ, NULL, NULL);
	define_push(TOK___FILE__, MACRO_OBJ, NULL, NULL);
	define_push(TOK___DATE__, MACRO_OBJ, NULL, NULL);
	define_push(TOK___TIME__, MACRO_OBJ, NULL, NULL);
	define_push(TOK___COUNTER__, MACRO_OBJ, NULL, NULL);
}

ST_FUNC void tccpp_delete(TCCState *s)
{
	int i, n;

	dynarray_reset(&s->cached_includes, &s->nb_cached_includes);
	/* free tokens */

	n = tok_ident - TOK_IDENT;
	if (n > total_idents)
		total_idents = n;
	for (i = 0; i < n; i++)
		tal_free(toksym_alloc, table_ident[i]);
	tcc_free(table_ident);
	table_ident = NULL;
	/* free static buffers */

	cstr_free(&tokcstr);
	cstr_free(&cstr_buf);
	tok_str_free_str(tokstr_buf.str);
	tok_str_free_str(unget_buf.str);
	/* free allocators */

	tal_delete(toksym_alloc);
	toksym_alloc = NULL;
	tal_delete(tokstr_alloc);
	tokstr_alloc = NULL;
}
/* ------------------------------------------------------------------------- */
/* tcc -E [-P[1]] [-dD} support */

static int pp_need_space(int a, int b);

static void tok_print(const int *str, const char *msg, ...)
{
	FILE *fp = tcc_state->ppfp;
	va_list ap;
	int t, t0, s;
	CValue cval;

	va_start(ap, msg);
	vfprintf(fp, msg, ap);
	va_end(ap);

	s = t0 = 0;
	while (str) {
		TOK_GET(&t, &str, &cval);
		if (t == 0 || t == TOK_EOF)
			break;
		if (pp_need_space(t0, t))
			s = 0;
		fprintf(fp, &" %s"[s], t == TOK_PLCHLDR ? "<>" : get_tok_str(t, &cval));
		s = 1, t0 = t;
	}
	fprintf(fp, "\n");
}

static void pp_line(TCCState *s1, BufferedFile *f, int level)
{
	int d = f->line_num - f->line_ref;

	if (s1->dflag & 4)
		return;

	if (s1->Pflag == LINE_MACRO_OUTPUT_FORMAT_NONE) {
		;
	} else if (level == 0 && f->line_ref && d < 8) {
		while (d > 0)
			fputs("\n", s1->ppfp), --d;
	} else if (s1->Pflag == LINE_MACRO_OUTPUT_FORMAT_STD) {
		fprintf(s1->ppfp, "#line %d \"%s\"\n", f->line_num, f->filename);
	} else {
		fprintf(s1->ppfp, "# %d \"%s\"%s\n", f->line_num, f->filename,
			level > 0 ? " 1" : level < 0 ? " 2" : "");
	}
	f->line_ref = f->line_num;
}

static void define_print(TCCState *s1, int v)
{
	FILE *fp;
	Sym *s;

	s = define_find(v);
	if (NULL == s || NULL == s->d)
		return;

	fp = s1->ppfp;
	fprintf(fp, "#define %s", get_tok_str(v, NULL));
	if (s->type.t & MACRO_FUNC) {
		Sym *a = s->next;
		fprintf(fp,"(");
		if (a)
			for (;;) {
				fprintf(fp,"%s", get_tok_str(a->v, NULL));
				if (!(a = a->next))
					break;
				fprintf(fp,",");
			}
		fprintf(fp,")");
	}
	tok_print(s->d, "");
}

static void pp_debug_defines(TCCState *s1)
{
	int v, t;
	const char *vs;
	FILE *fp;

	t = pp_debug_tok;
	if (t == 0)
		return;

	file->line_num--;
	pp_line(s1, file, 0);
	file->line_ref = ++file->line_num;

	fp = s1->ppfp;
	v = pp_debug_symv;
	vs = get_tok_str(v, NULL);
	if (t == TOK_DEFINE) {
		define_print(s1, v);
	} else if (t == TOK_UNDEF) {
		fprintf(fp, "#undef %s\n", vs);
	} else if (t == TOK_push_macro) {
		fprintf(fp, "#pragma push_macro(\"%s\")\n", vs);
	} else if (t == TOK_pop_macro) {
		fprintf(fp, "#pragma pop_macro(\"%s\")\n", vs);
	}
	pp_debug_tok = 0;
}
/* Add a space between tokens a and b to avoid unwanted textual pasting */

static int pp_need_space(int a, int b)
{
	return 'E' == a ? '+' == b || '-' == b
	       : '+' == a ? TOK_INC == b || '+' == b
	       : '-' == a ? TOK_DEC == b || '-' == b
	       : a >= TOK_IDENT || a == TOK_PPNUM ? b >= TOK_IDENT || b == TOK_PPNUM
	       : 0;
}
/* maybe hex like 0x1e */

static int pp_check_he0xE(int t, const char *p)
{
	if (t == TOK_PPNUM && toup(strchr(p, 0)[-1]) == 'E')
		return 'E';
	return t;
}
/* Preprocess the current file */

ST_FUNC int tcc_preprocess(TCCState *s1)
{
	BufferedFile **iptr;
	int token_seen, spcs, level;
	const char *p;
	char white[400];

	parse_flags = PARSE_FLAG_PREPROCESS
		      | (parse_flags & PARSE_FLAG_ASM_FILE)
		      | PARSE_FLAG_LINEFEED
		      | PARSE_FLAG_SPACES
		      | PARSE_FLAG_ACCEPT_STRAYS
		      ;
	/* Credits to Fabrice Bellard's initial revision to demonstrate its
	       capability to compile and run itself, provided all numbers are
	       given as decimals. tcc -E -P10 will do. */

	if (s1->Pflag == LINE_MACRO_OUTPUT_FORMAT_P10)
		parse_flags |= PARSE_FLAG_TOK_NUM, s1->Pflag = 1;

	if (s1->do_bench) {
		/* for PP benchmarks */

		do next();
		while (tok != TOK_EOF);
		return 0;
	}

	token_seen = TOK_LINEFEED, spcs = 0, level = 0;
	if (file->prev)
		pp_line(s1, file->prev, level++);
	pp_line(s1, file, level);

	for (;;) {
		iptr = s1->include_stack_ptr;
		next();
		if (tok == TOK_EOF)
			break;

		level = s1->include_stack_ptr - iptr;
		if (level) {
			if (level > 0)
				pp_line(s1, *iptr, 0);
			pp_line(s1, file, level);
		}
		if (s1->dflag & 7) {
			pp_debug_defines(s1);
			if (s1->dflag & 4)
				continue;
		}

		if (is_space(tok)) {
			if (spcs < sizeof white - 1)
				white[spcs++] = tok;
			continue;
		} else if (tok == TOK_LINEFEED) {
			spcs = 0;
			if (token_seen == TOK_LINEFEED)
				continue;
			++file->line_ref;
		} else if (token_seen == TOK_LINEFEED) {
			pp_line(s1, file, 0);
		} else if (spcs == 0 && pp_need_space(token_seen, tok)) {
			white[spcs++] = ' ';
		}

		white[spcs] = 0, fputs(white, s1->ppfp), spcs = 0;
		fputs(p = get_tok_str(tok, &tokc), s1->ppfp);
		token_seen = pp_check_he0xE(tok, p);
	}
	return 0;
}
/* ------------------------------------------------------------------------- */
// 27 "libtcc.c" 2
// 1 "tccgen.c" 1
// 21 "tccgen.c"
#define USING_GLOBALS
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 23 "tccgen.c" 2
/**/
/* global variables */
/* loc : local variable index
   ind : output code index
   rsym: return symbol
   anon_sym: anonymous symbol index
*/
// 32 "tccgen.c"
ST_DATA int rsym, anon_sym, ind, loc;

ST_DATA Sym *global_stack;
ST_DATA Sym *local_stack;
ST_DATA Sym *define_stack;
ST_DATA Sym *global_label_stack;
ST_DATA Sym *local_label_stack;

static Sym *sym_free_first;
static void **sym_pools;
static int nb_sym_pools;

static Sym *all_cleanups, *pending_gotos;
static int local_scope;
ST_DATA char debug_modes;

ST_DATA SValue *vtop;
static SValue _vstack[1 + VSTACK_SIZE];
#define vstack (_vstack + 1)

ST_DATA int nocode_wanted;/* no code generation wanted */

/* no static data output wanted either */
#define NODATA_WANTED (nocode_wanted > 0)
/* ON outside of functions and for static initializers */
#define DATA_ONLY_WANTED 0x80000000
/* no code output after unconditional jumps such as with if (0) ... */

#define CODE_OFF_BIT 0x20000000
#define CODE_OFF() if(!nocode_wanted)(nocode_wanted |= CODE_OFF_BIT)
#define CODE_ON() (nocode_wanted &= ~CODE_OFF_BIT)
/* no code output when parsing sizeof()/typeof() etc. (using nocode_wanted++/--) */

#define NOEVAL_MASK 0x0000FFFF
#define NOEVAL_WANTED (nocode_wanted & NOEVAL_MASK)
/* no code output when parsing constant expressions */

#define CONST_WANTED_BIT 0x00010000
#define CONST_WANTED_MASK 0x0FFF0000
#define CONST_WANTED (nocode_wanted & CONST_WANTED_MASK)

ST_DATA int
global_expr;/* true if compound literals must be allocated globally (used during initializers parsing */

ST_DATA CType
func_vt;/* current function return type (used by return instruction) */

ST_DATA int
func_var;/* true if current function is variadic (used by return instruction) */

ST_DATA int func_vc;
ST_DATA int func_ind;
ST_DATA const char *funcname;
ST_DATA CType int_type, func_old_type, char_type, char_pointer_type;
static CString initstr;
#if PTR_SIZE == 4
#define VT_SIZE_T (VT_INT | VT_UNSIGNED)
#define VT_PTRDIFF_T VT_INT
#elif LONG_SIZE == 4

#define VT_SIZE_T (VT_LLONG | VT_UNSIGNED)
#define VT_PTRDIFF_T VT_LLONG
#else

#define VT_SIZE_T (VT_LONG | VT_LLONG | VT_UNSIGNED)
#define VT_PTRDIFF_T (VT_LONG | VT_LLONG)
#endif

static struct switch_t {
	struct case_t {
		int64_t v1, v2;
		int ind, line;
	} **p;
	int n;/* list of case ranges */

	int def_sym;/* default symbol */

	int nocode_wanted;
	int *bsym;
	struct scope *scope;
	struct switch_t *prev;
	SValue sv;
} *cur_switch;/* current switch */

#define MAX_TEMP_LOCAL_VARIABLE_NUMBER 8
/*list of temporary local variables on the stack in current function. */

static struct temp_local_variable {
	int location;//offset on stack. Svalue.c.i

	short size;
	short align;
} arr_temp_local_vars[MAX_TEMP_LOCAL_VARIABLE_NUMBER];
static int nb_temp_local_vars;

static struct scope {
	struct scope *prev;
	struct {
		int loc, locorig, num;
	} vla;
	struct {
		Sym *s;
		int n;
	} cl;
	int *bsym, *csym;
	Sym *lstk, *llstk;
} *cur_scope, *loop_scope, *root_scope;

typedef struct {
	Section *sec;
	int local_offset;
	Sym *flex_array_ref;
} init_params;

#define precedence_parser
static void init_prec(void);

static void block(int flags);
#define STMT_EXPR 1
#define STMT_COMPOUND 2

static void gen_cast(CType *type);
static void gen_cast_s(int t);
static inline CType *pointed_type(CType *type);
static int is_compatible_types(CType *type1, CType *type2);
static int parse_btype(CType *type, AttributeDef *ad, int ignore_label);
static CType *type_decl(CType *type, AttributeDef *ad, int *v, int td);
static void parse_expr_type(CType *type);
static void init_putv(init_params *p, CType *type, unsigned long c);
static void decl_initializer(init_params *p, CType *type, unsigned long c,
			     int flags);
static void decl_initializer_alloc(CType *type, AttributeDef *ad, int r,
				   int has_init, int v, int scope);
static int decl(int l);
static void expr_eq(void);
static void vpush_type_size(CType *type, int *a);
static int is_compatible_unqualified_types(CType *type1, CType *type2);
static inline int64_t expr_const64(void);
static void vpush64(int ty, unsigned long long v);
static void vpush(CType *type);
static int gvtst(int inv, int t);
static void gen_inline_functions(TCCState *s);
static void free_inline_functions(TCCState *s);
static void skip_or_save_block(TokenString **str);
static void gv_dup(void);
static int get_temp_local_var(int size,int align,int *r2);
static void cast_error(CType *st, CType *dt);
static void end_switch(void);
static void do_Static_assert(void);
/* ------------------------------------------------------------------------- */
/* Automagical code suppression */
/* Clear 'nocode_wanted' at forward label if it was used */

ST_FUNC void gsym(int t)
{
	if (t) {
		gsym_addr(t, ind);
		CODE_ON();
	}
}
/* Clear 'nocode_wanted' if current pc is a label */

static int gind()
{
	int t = ind;
	CODE_ON();
	if (debug_modes)
		tcc_tcov_block_begin(tcc_state);
	return t;
}
/* Set 'nocode_wanted' after unconditional (backwards) jump */

static void gjmp_addr_acs(int t)
{
	gjmp_addr(t);
	CODE_OFF();
}
/* Set 'nocode_wanted' after unconditional (forwards) jump */

static int gjmp_acs(int t)
{
	t = gjmp(t);
	CODE_OFF();
	return t;
}
/* These are #undef'd at the end of this file */

#define gjmp_addr gjmp_addr_acs
#define gjmp gjmp_acs
/* ------------------------------------------------------------------------- */

ST_INLN int is_float(int t)
{
	int bt = t & VT_BTYPE;
	return bt == VT_LDOUBLE
	       || bt == VT_DOUBLE
	       || bt == VT_FLOAT
	       || bt == VT_QFLOAT;
}

static inline int is_integer_btype(int bt)
{
	return bt == VT_BYTE
	       || bt == VT_BOOL
	       || bt == VT_SHORT
	       || bt == VT_INT
	       || bt == VT_LLONG;
}

static int btype_size(int bt)
{
	return bt == VT_BYTE || bt == VT_BOOL ? 1 :
	       bt == VT_SHORT ? 2 :
	       bt == VT_INT ? 4 :
	       bt == VT_LLONG ? 8 :
	       bt == VT_PTR ? PTR_SIZE : 0;
}
/* returns function return register from type */

static int R_RET(int t)
{
	if (!is_float(t))
		return REG_IRET;

	if ((t & VT_BTYPE) == VT_LDOUBLE)
		return TREG_ST0;

	return REG_FRET;
}
/* returns 2nd function return register, if any */

static int R2_RET(int t)
{
	t &= VT_BTYPE;
#if PTR_SIZE == 4
	if (t == VT_LLONG)
		return REG_IRE2;
#else

	if (t == VT_QLONG)
		return REG_IRE2;
	if (t == VT_QFLOAT)
		return REG_FRE2;
#endif

	return VT_CONST;
}
/* returns true for two-word types */

#define USING_TWO_WORDS(t) (R2_RET(t) != VT_CONST)
/* put function return registers to stack value */

static void PUT_R_RET(SValue *sv, int t)
{
	sv->r = R_RET(t), sv->r2 = R2_RET(t);
}
/* returns function return register class for type t */

static int RC_RET(int t)
{
	return reg_classes[R_RET(t)] & ~(RC_FLOAT | RC_INT);
}
/* returns generic register class for type t */

static int RC_TYPE(int t)
{
	if (!is_float(t))
		return RC_INT;

	if ((t & VT_BTYPE) == VT_LDOUBLE)
		return RC_ST0;
	if ((t & VT_BTYPE) == VT_QFLOAT)
		return RC_FRET;

	return RC_FLOAT;
}
/* returns 2nd register class corresponding to t and rc */

static int RC2_TYPE(int t, int rc)
{
	if (!USING_TWO_WORDS(t))
		return 0;
#ifdef RC_IRE2

	if (rc == RC_IRET)
		return RC_IRE2;
#endif
#ifdef RC_FRE2

	if (rc == RC_FRET)
		return RC_FRE2;
#endif

	if (rc & RC_FLOAT)
		return RC_FLOAT;
	return RC_INT;
}
/* we use our own 'finite' function to avoid potential problems with
   non standard math libs */
/* XXX: endianness dependent */

ST_FUNC int ieee_finite(double d)
{
	int p[4];
	memcpy(p, &d, sizeof(double));
	return ((unsigned)((p[1] | 0x800fffff) + 1)) >> 31;
}
/* compiling intel long double natively */

#define TCC_IS_NATIVE_387

ST_FUNC void test_lvalue(void)
{
	if (!(vtop->r & VT_LVAL))
		expect("lvalue");
}

ST_FUNC void check_vstack(void)
{
	if (vtop != vstack - 1)
		tcc_error("internal compiler error: vstack leak (%d)",
			  (int)(vtop - vstack + 1));
}
/* vstack debugging aid */
/* ------------------------------------------------------------------------- */
/* initialize vstack and types.  This must be done also for tcc -E */
// 359 "tccgen.c"
ST_FUNC void tccgen_init(TCCState *s1)
{
	vtop = vstack - 1;
	memset(vtop, 0, sizeof *vtop);
	/* define some often used types */

	int_type.t = VT_INT;

	char_type.t = VT_BYTE;
	if (s1->char_is_unsigned)
		char_type.t |= VT_UNSIGNED;
	char_pointer_type = char_type;
	mk_pointer(&char_pointer_type);

	func_old_type.t = VT_FUNC;
	func_old_type.ref = sym_push(SYM_FIELD, &int_type, 0, 0);
	func_old_type.ref->f.func_call = FUNC_CDECL;
	func_old_type.ref->f.func_type = FUNC_OLD;
#ifdef precedence_parser

	init_prec();
#endif

	cstr_new(&initstr);
}

ST_FUNC int tccgen_compile(TCCState *s1)
{
	funcname = "";
	func_ind = -1;
	anon_sym = SYM_FIRST_ANOM;
	nocode_wanted = DATA_ONLY_WANTED;/* no code outside of functions */

	debug_modes = (s1->do_debug ? 1 : 0) | s1->test_coverage << 1;

	tcc_debug_start(s1);
	tcc_tcov_start (s1);
#ifdef INC_DEBUG

	printf("%s: **** new file\n", file->filename);
#endif

	parse_flags = PARSE_FLAG_PREPROCESS | PARSE_FLAG_TOK_NUM | PARSE_FLAG_TOK_STR;
	next();
	decl(VT_CONST);
	gen_inline_functions(s1);
	check_vstack();
	/* end of translation unit info */
#if TCC_EH_FRAME
	tcc_eh_frame_end(s1);
#endif

	tcc_debug_end(s1);
	tcc_tcov_end(s1);
	return 0;
}

ST_FUNC void tccgen_finish(TCCState *s1)
{
	tcc_debug_end(s1);/* just in case of errors: free memory */

	free_inline_functions(s1);
	sym_pop(&global_stack, NULL, 0);
	sym_pop(&local_stack, NULL, 0);
	/* free preprocessor macros */

	free_defines(NULL);
	/* free sym_pools */

	dynarray_reset(&sym_pools, &nb_sym_pools);
	cstr_free(&initstr);
	dynarray_reset(&stk_data, &nb_stk_data);
	while (cur_switch)
		end_switch();
	local_scope = 0;
	loop_scope = NULL;
	all_cleanups = NULL;
	pending_gotos = NULL;
	nb_temp_local_vars = 0;
	global_label_stack = NULL;
	local_label_stack = NULL;
	cur_text_section = NULL;
	sym_free_first = NULL;
}
/* ------------------------------------------------------------------------- */

ST_FUNC ElfSym *elfsym(Sym *s)
{
	if (!s || !s->c)
		return NULL;
	return &((ElfSym *)symtab_section->data)[s->c];
}
/* apply storage attributes to Elf symbol */

ST_FUNC void update_storage(Sym *sym)
{
	ElfSym *esym;
	int sym_bind, old_sym_bind;

	esym = elfsym(sym);
	if (!esym)
		return;

	if (sym->a.visibility)
		esym->st_other = (esym->st_other & ~ELFW(ST_VISIBILITY)(-1))
				 | sym->a.visibility;

	if (sym->type.t & (VT_STATIC | VT_INLINE))
		sym_bind = STB_LOCAL;
	else if (sym->a.weak)
		sym_bind = STB_WEAK;
	else
		sym_bind = STB_GLOBAL;
	old_sym_bind = ELFW(ST_BIND)(esym->st_info);
	if (sym_bind != old_sym_bind) {
		esym->st_info = ELFW(ST_INFO)(sym_bind, ELFW(ST_TYPE)(esym->st_info));
	}

	if (sym->a.dllimport)
		esym->st_other |= ST_PE_IMPORT;
	if (sym->a.dllexport)
		esym->st_other |= ST_PE_EXPORT;
// 487 "tccgen.c"
}
/* ------------------------------------------------------------------------- */
/* update sym->c so that it points to an external symbol in section
   'section' with value 'value' */

ST_FUNC void put_extern_sym2(Sym *sym, int sh_num,
			     addr_t value, unsigned long size,
			     int can_add_underscore)
{
	int sym_type, sym_bind, info, other, t;
	ElfSym *esym;
	const char *name;
	char buf1[256];

	if (!sym->c) {
		name = get_tok_str(sym->v, NULL);
		t = sym->type.t;
		if ((t & VT_BTYPE) == VT_FUNC) {
			sym_type = STT_FUNC;
		} else if ((t & VT_BTYPE) == VT_VOID) {
			sym_type = STT_NOTYPE;
			if ((t & (VT_BTYPE|VT_ASM_FUNC)) == VT_ASM_FUNC)
				sym_type = STT_FUNC;
		} else {
			sym_type = STT_OBJECT;
		}
		if (t & (VT_STATIC | VT_INLINE))
			sym_bind = STB_LOCAL;
		else
			sym_bind = STB_GLOBAL;
		other = 0;

		if (sym_type == STT_FUNC && sym->type.ref) {
			Sym *ref = sym->type.ref;
			if (ref->a.nodecorate) {
				can_add_underscore = 0;
			}
			if (ref->f.func_call == FUNC_STDCALL && can_add_underscore) {
				sprintf(buf1, "_%s@%d", name, ref->f.func_args * PTR_SIZE);
				name = buf1;
				other |= ST_PE_STDCALL;
				can_add_underscore = 0;
			}
		}

		if (sym->asm_label) {
			name = get_tok_str(sym->asm_label, NULL);
			can_add_underscore = 0;
		}

		if (tcc_state->leading_underscore && can_add_underscore) {
			buf1[0] = '_';
			pstrcpy(buf1 + 1, sizeof(buf1) - 1, name);
			name = buf1;
		}

		info = ELFW(ST_INFO)(sym_bind, sym_type);
		sym->c = put_elf_sym(symtab_section, value, size, info, other, sh_num, name);

		if (debug_modes)
			tcc_debug_extern_sym(tcc_state, sym, sh_num, sym_bind, sym_type);

	} else {
		esym = elfsym(sym);
		esym->st_value = value;
		esym->st_size = size;
		esym->st_shndx = sh_num;
	}
	update_storage(sym);
}

ST_FUNC void put_extern_sym(Sym *sym, Section *s, addr_t value,
			    unsigned long size)
{
	if (nocode_wanted && (NODATA_WANTED || (s && s == cur_text_section)))
		return;
	put_extern_sym2(sym, s ? s->sh_num : SHN_UNDEF, value, size, 1);
}
/* add a new relocation entry to symbol 'sym' in section 's' */

ST_FUNC void greloca(Section *s, Sym *sym, unsigned long offset, int type,
		     addr_t addend)
{
	int c = 0;

	if (nocode_wanted && s == cur_text_section)
		return;

	if (sym) {
		if (0 == sym->c)
			put_extern_sym(sym, NULL, 0, 0);
		c = sym->c;
	}
	/* now we can add ELF relocation info */

	put_elf_reloca(symtab_section, s, offset, type, c, addend);
}
#if PTR_SIZE == 4
ST_FUNC void greloc(Section *s, Sym *sym, unsigned long offset, int type)
{
	greloca(s, sym, offset, type, 0);
}
#endif
/* -------------------------------\------------------------------------------ */
/* symbol allocator */
// 596 "tccgen.c"
static Sym *__sym_malloc(void)
{
	Sym *sym_pool, *sym, *last_sym;
	int i;

	sym_pool = tcc_malloc(SYM_POOL_NB * sizeof(Sym));
	dynarray_add(&sym_pools, &nb_sym_pools, sym_pool);

	last_sym = sym_free_first;
	sym = sym_pool;
	for (i = 0; i < SYM_POOL_NB; i++) {
		sym->next = last_sym;
		last_sym = sym;
		sym++;
	}
	sym_free_first = last_sym;
	return last_sym;
}

static inline Sym *sym_malloc(void)
{
	Sym *sym;
#ifndef SYM_DEBUG

	sym = sym_free_first;
	if (!sym)
		sym = __sym_malloc();
	sym_free_first = sym->next;
	return sym;
#else

	sym = tcc_malloc(sizeof(Sym));
	return sym;
#endif

}

ST_INLN void sym_free(Sym *sym)
{
#ifndef SYM_DEBUG

	sym->next = sym_free_first;
	sym_free_first = sym;
#else

	tcc_free(sym);
#endif

}
/* push, without hashing */

ST_FUNC Sym *sym_push2(Sym **ps, int v, int t, int c)
{
	Sym *s;

	s = sym_malloc();
	memset(s, 0, sizeof *s);
	s->v = v;
	s->type.t = t;
	s->c = c;
	/* add in stack */

	s->prev = *ps;
	*ps = s;
	return s;
}
/* find a symbol and return its associated structure. 's' is the top
   of the symbol stack */

ST_FUNC Sym *sym_find2(Sym *s, int v)
{
	while (s) {
		if (s->v == v)
			return s;
		s = s->prev;
	}
	return NULL;
}
/* structure lookup */

ST_INLN Sym *struct_find(int v)
{
	v -= TOK_IDENT;
	if ((unsigned)v >= (unsigned)(tok_ident - TOK_IDENT))
		return NULL;
	return table_ident[v]->sym_struct;
}
/* find an identifier */

ST_INLN Sym *sym_find(int v)
{
	v -= TOK_IDENT;
	if ((unsigned)v >= (unsigned)(tok_ident - TOK_IDENT))
		return NULL;
	return table_ident[v]->sym_identifier;
}

static int sym_scope(Sym *s)
{
	if (IS_ENUM_VAL (s->type.t))
		return s->type.ref->sym_scope;
	else
		return s->sym_scope;
}
/* push a given symbol on the symbol stack */

ST_FUNC Sym *sym_push(int v, CType *type, int r, int c)
{
	Sym *s, **ps;
	TokenSym *ts;

	if (local_stack)
		ps = &local_stack;
	else
		ps = &global_stack;
	s = sym_push2(ps, v, type->t, c);
	s->type.ref = type->ref;
	s->r = r;
	/* don't record fields or anonymous symbols */
	/* XXX: simplify */

	if (!(v & SYM_FIELD) && (v & ~SYM_STRUCT) < SYM_FIRST_ANOM) {
		/* record symbol in token array */

		ts = table_ident[(v & ~SYM_STRUCT) - TOK_IDENT];
		if (v & SYM_STRUCT)
			ps = &ts->sym_struct;
		else
			ps = &ts->sym_identifier;
		s->prev_tok = *ps;
		*ps = s;
		s->sym_scope = local_scope;
		if (s->prev_tok && sym_scope(s->prev_tok) == s->sym_scope)
			tcc_error("redeclaration of '%s'",
				  get_tok_str(v & ~SYM_STRUCT, NULL));
	}
	return s;
}
/* push a global identifier */

ST_FUNC Sym *global_identifier_push(int v, int t, int c)
{
	Sym *s, **ps;
	s = sym_push2(&global_stack, v, t, c);
	s->r = VT_CONST | VT_SYM;
	/* don't record anonymous symbol */

	if (v < SYM_FIRST_ANOM) {
		ps = &table_ident[v - TOK_IDENT]->sym_identifier;
		/* modify the top most local identifier, so that sym_identifier will
		           point to 's' when popped; happens when called from inline asm */

		while (*ps != NULL && (*ps)->sym_scope)
			ps = &(*ps)->prev_tok;
		s->prev_tok = *ps;
		*ps = s;
	}
	return s;
}
/* pop symbols until top reaches 'b'.  If KEEP is non-zero don't really
   pop them yet from the list, but do remove them from the token array.  */

ST_FUNC void sym_pop(Sym **ptop, Sym *b, int keep)
{
	Sym *s, *ss, **ps;
	TokenSym *ts;
	int v;

	s = *ptop;
	while (s != b) {
		ss = s->prev;
		v = s->v;
		/* remove symbol in token array */
		/* XXX: simplify */

		if (!(v & SYM_FIELD) && (v & ~SYM_STRUCT) < SYM_FIRST_ANOM) {
			ts = table_ident[(v & ~SYM_STRUCT) - TOK_IDENT];
			if (v & SYM_STRUCT)
				ps = &ts->sym_struct;
			else
				ps = &ts->sym_identifier;
			*ps = s->prev_tok;
		}
		if (!keep)
			sym_free(s);
		s = ss;
	}
	if (!keep)
		*ptop = b;
}
/* label lookup */

ST_FUNC Sym *label_find(int v)
{
	v -= TOK_IDENT;
	if ((unsigned)v >= (unsigned)(tok_ident - TOK_IDENT))
		return NULL;
	return table_ident[v]->sym_label;
}

ST_FUNC Sym *label_push(Sym **ptop, int v, int flags)
{
	Sym *s, **ps;
	s = sym_push2(ptop, v, VT_STATIC, 0);
	s->r = flags;
	ps = &table_ident[v - TOK_IDENT]->sym_label;
	if (ptop == &global_label_stack) {
		/* modify the top most local identifier, so that
		           sym_identifier will point to 's' when popped */

		while (*ps != NULL)
			ps = &(*ps)->prev_tok;
	}
	s->prev_tok = *ps;
	*ps = s;
	return s;
}
/* pop labels until element last is reached. Look if any labels are
   undefined. Define symbols if '&&label' was used. */

ST_FUNC void label_pop(Sym **ptop, Sym *slast, int keep)
{
	Sym *s, *s1;
	for (s = *ptop; s != slast; s = s1) {
		s1 = s->prev;
		if (s->r == LABEL_DECLARED) {
			tcc_warning_c(warn_all)("label '%s' declared but not used", get_tok_str(s->v,
						NULL));
		} else if (s->r == LABEL_FORWARD) {
			tcc_error("label '%s' used but not defined",
				  get_tok_str(s->v, NULL));
		} else {
			if (s->c) {
				/* define corresponding symbol. A size of
				                   1 is put. */

				put_extern_sym(s, cur_text_section, s->jnext, 1);
			}
		}
		/* remove label */

		if (s->r != LABEL_GONE)
			table_ident[s->v - TOK_IDENT]->sym_label = s->prev_tok;
		if (!keep)
			sym_free(s);
		else
			s->r = LABEL_GONE;
	}
	if (!keep)
		*ptop = slast;
}
/* ------------------------------------------------------------------------- */

static void vcheck_cmp(void)
{
	/* cannot let cpu flags if other instruction are generated. Also
	       avoid leaving VT_JMP anywhere except on the top of the stack
	       because it would complicate the code generator.

	       Don't do this when nocode_wanted.  vtop might come from
	       !nocode_wanted regions (see 88_codeopt.c) and transforming
	       it to a register without actually generating code is wrong
	       as their value might still be used for real.  All values
	       we push under nocode_wanted will eventually be popped
	       again, so that the VT_CMP/VT_JMP value will be in vtop
	       when code is unsuppressed again. */
	/* However if it's just automatic suppression via CODE_OFF/ON()
	       then it seems that we better let things work undisturbed.
	       How can it work at all under nocode_wanted?  Well, gv() will
	       actually clear it at the gsym() in load()/VT_JMP in the
	       generator backends */
// 853 "tccgen.c"
	if (vtop->r == VT_CMP && 0 == (nocode_wanted & ~CODE_OFF_BIT))
		gv(RC_INT);
}

static void vsetc(CType *type, int r, CValue *vc)
{
	if (vtop >= vstack + (VSTACK_SIZE - 1))
		tcc_error("memory full (vstack)");
	vcheck_cmp();
	vtop++;
	vtop->type = *type;
	vtop->r = r;
	vtop->r2 = VT_CONST;
	vtop->c = *vc;
	vtop->sym = NULL;
}

ST_FUNC void vswap(void)
{
	SValue tmp;

	vcheck_cmp();
	tmp = vtop[0];
	vtop[0] = vtop[-1];
	vtop[-1] = tmp;
}
/* pop stack value */

ST_FUNC void vpop(void)
{
	int v;
	v = vtop->r & VT_VALMASK;
	/* for x86, we need to pop the FP stack */

	if (v == TREG_ST0) {
		o(0xd8dd);/* fstp %st(0) */

	} else

		if (v == VT_CMP) {
			/* need to put correct jump if && or || without test */

			gsym(vtop->jtrue);
			gsym(vtop->jfalse);
		}
	vtop--;
}
/* push constant of type "type" with useless value */

static void vpush(CType *type)
{
	vset(type, VT_CONST, 0);
}
/* push arbitrary 64bit constant */

static void vpush64(int ty, unsigned long long v)
{
	CValue cval;
	CType ctype;
	ctype.t = ty;
	ctype.ref = NULL;
	cval.i = v;
	vsetc(&ctype, VT_CONST, &cval);
}
/* push integer constant */

ST_FUNC void vpushi(int v)
{
	vpush64(VT_INT, v);
}
/* push a pointer sized constant */

static void vpushs(addr_t v)
{
	vpush64(VT_SIZE_T, v);
}
/* push long long constant */

static inline void vpushll(long long v)
{
	vpush64(VT_LLONG, v);
}

ST_FUNC void vset(CType *type, int r, int v)
{
	CValue cval;
	cval.i = v;
	vsetc(type, r, &cval);
}

static void vseti(int r, int v)
{
	CType type;
	type.t = VT_INT;
	type.ref = NULL;
	vset(&type, r, v);
}

ST_FUNC void vpushv(SValue *v)
{
	if (vtop >= vstack + (VSTACK_SIZE - 1))
		tcc_error("memory full (vstack)");
	vtop++;
	*vtop = *v;
}

static void vdup(void)
{
	vpushv(vtop);
}
/* rotate the stack element at position n-1 to the top */

ST_FUNC void vrotb(int n)
{
	SValue tmp;
	if (--n < 1)
		return;
	vcheck_cmp();
	tmp = vtop[-n];
	memmove(vtop - n, vtop - n + 1, sizeof *vtop * n);
	vtop[0] = tmp;
}
/* rotate the top stack element into position n-1 */

ST_FUNC void vrott(int n)
{
	SValue tmp;
	if (--n < 1)
		return;
	vcheck_cmp();
	tmp = vtop[0];
	memmove(vtop - n + 1, vtop - n, sizeof *vtop * n);
	vtop[-n] = tmp;
}
/* reverse order of the the first n stack elements */

ST_FUNC void vrev(int n)
{
	int i;
	SValue tmp;
	vcheck_cmp();
	for (i = 0, n = -n; i > ++n; --i)
		tmp = vtop[i], vtop[i] = vtop[n], vtop[n] = tmp;
}
/* ------------------------------------------------------------------------- */
/* vtop->r = VT_CMP means CPU-flags have been set from comparison or test. */
/* called from generators to set the result from relational ops  */

ST_FUNC void vset_VT_CMP(int op)
{
	vtop->r = VT_CMP;
	vtop->cmp_op = op;
	vtop->jfalse = 0;
	vtop->jtrue = 0;
}
/* called once before asking generators to load VT_CMP to a register */

static void vset_VT_JMP(void)
{
	int op = vtop->cmp_op;

	if (vtop->jtrue || vtop->jfalse) {
		int origt = vtop->type.t;
		/* we need to jump to 'mov $0,%R' or 'mov $1,%R' */

		int inv = op & (op < 2);/* small optimization */

		vseti(VT_JMP+inv, gvtst(inv, 0));
		vtop->type.t |= origt & (VT_UNSIGNED | VT_DEFSIGN);
	} else {
		/* otherwise convert flags (rsp. 0/1) to register */

		vtop->c.i = op;
		if (op < 2)/* doesn't seem to happen */

			vtop->r = VT_CONST;
	}
}
/* Set CPU Flags, doesn't yet jump */

static void gvtst_set(int inv, int t)
{
	int *p;

	if (vtop->r != VT_CMP) {
		vpushi(0);
		gen_op(TOK_NE);
		if (vtop->r != VT_CMP)/* must be VT_CONST then */

			vset_VT_CMP(vtop->c.i != 0);
	}

	p = inv ? &vtop->jfalse : &vtop->jtrue;
	*p = gjmp_append(*p, t);
}
/* Generate value test
 *
 * Generate a test for any value (jump, comparison and integers) */

static int gvtst(int inv, int t)
{
	int op, x, u;

	gvtst_set(inv, t);
	t = vtop->jtrue, u = vtop->jfalse;
	if (inv)
		x = u, u = t, t = x;
	op = vtop->cmp_op;
	/* jump to the wanted target */

	if (op > 1)
		t = gjmp_cond(op ^ inv, t);
	else if (op != inv)
		t = gjmp(t);
	/* resolve complementary jumps to here */

	gsym(u);

	vtop--;
	return t;
}
/* generate a zero or nozero test */

static void gen_test_zero(int op)
{
	if (vtop->r == VT_CMP) {
		int j;
		if (op == TOK_EQ) {
			j = vtop->jfalse;
			vtop->jfalse = vtop->jtrue;
			vtop->jtrue = j;
			vtop->cmp_op ^= 1;
		}
	} else {
		vpushi(0);
		gen_op(op);
	}
}
/* ------------------------------------------------------------------------- */
/* push a symbol value of TYPE */

ST_FUNC void vpushsym(CType *type, Sym *sym)
{
	CValue cval;
	cval.i = 0;
	vsetc(type, VT_CONST | VT_SYM, &cval);
	vtop->sym = sym;
}
/* Return a static symbol pointing to a section */

ST_FUNC Sym *get_sym_ref(CType *type, Section *sec, unsigned long offset,
			 unsigned long size)
{
	int v;
	Sym *sym;

	v = anon_sym++;
	sym = sym_push(v, type, VT_CONST | VT_SYM, 0);
	sym->type.t |= VT_STATIC;
	put_extern_sym(sym, sec, offset, size);
	return sym;
}
/* push a reference to a section offset by adding a dummy symbol */

static void vpush_ref(CType *type, Section *sec, unsigned long offset,
		      unsigned long size)
{
	vpushsym(type, get_sym_ref(type, sec, offset, size));
}
/* define a new external reference to a symbol 'v' of type 'u' */

ST_FUNC Sym *external_global_sym(int v, CType *type)
{
	Sym *s;

	s = sym_find(v);
	if (!s) {
		/* push forward reference */

		s = global_identifier_push(v, type->t | VT_EXTERN, 0);
		s->type.ref = type->ref;
	} else if (IS_ASM_SYM(s)) {
		s->type.t = type->t | (s->type.t & VT_EXTERN);
		s->type.ref = type->ref;
		update_storage(s);
	}
	return s;
}
/* create an external reference with no specific type similar to asm labels.
   This avoids type conflicts if the symbol is used from C too */

ST_FUNC Sym *external_helper_sym(int v)
{
	CType ct = { VT_ASM_FUNC, NULL };
	return external_global_sym(v, &ct);
}
/* push a reference to an helper function (such as memmove) */

ST_FUNC void vpush_helper_func(int v)
{
	vpushsym(&func_old_type, external_helper_sym(v));
}
/* Merge symbol attributes.  */

static void merge_symattr(struct SymAttr *sa, struct SymAttr *sa1)
{
	if (sa1->aligned && !sa->aligned)
		sa->aligned = sa1->aligned;
	sa->packed |= sa1->packed;
	sa->weak |= sa1->weak;
	sa->nodebug |= sa1->nodebug;
	if (sa1->visibility != STV_DEFAULT) {
		int vis = sa->visibility;
		if (vis == STV_DEFAULT
		    || vis > sa1->visibility)
			vis = sa1->visibility;
		sa->visibility = vis;
	}
	sa->dllexport |= sa1->dllexport;
	sa->nodecorate |= sa1->nodecorate;
	sa->dllimport |= sa1->dllimport;
}
/* Merge function attributes.  */

static void merge_funcattr(struct FuncAttr *fa, struct FuncAttr *fa1)
{
	if (fa1->func_call && !fa->func_call)
		fa->func_call = fa1->func_call;
	if (fa1->func_type && !fa->func_type)
		fa->func_type = fa1->func_type;
	if (fa1->func_args && !fa->func_args)
		fa->func_args = fa1->func_args;
	if (fa1->func_noreturn)
		fa->func_noreturn = 1;
	if (fa1->func_ctor)
		fa->func_ctor = 1;
	if (fa1->func_dtor)
		fa->func_dtor = 1;
}
/* Merge attributes.  */

static void merge_attr(AttributeDef *ad, AttributeDef *ad1)
{
	merge_symattr(&ad->a, &ad1->a);
	merge_funcattr(&ad->f, &ad1->f);

	if (ad1->section)
		ad->section = ad1->section;
	if (ad1->alias_target)
		ad->alias_target = ad1->alias_target;
	if (ad1->asm_label)
		ad->asm_label = ad1->asm_label;
	if (ad1->attr_mode)
		ad->attr_mode = ad1->attr_mode;
}
/* Merge some type attributes.  */

static void patch_type(Sym *sym, CType *type)
{
	if (!(type->t & VT_EXTERN) || IS_ENUM_VAL(sym->type.t)) {
		if (!(sym->type.t & VT_EXTERN))
			tcc_error("redefinition of '%s'", get_tok_str(sym->v, NULL));
		sym->type.t &= ~VT_EXTERN;
	}

	if (IS_ASM_SYM(sym)) {
		/* stay static if both are static */

		sym->type.t = type->t & (sym->type.t | ~VT_STATIC);
		sym->type.ref = type->ref;
		if ((type->t & VT_BTYPE) != VT_FUNC && !(type->t & VT_ARRAY))
			sym->r |= VT_LVAL;
	}

	if (!is_compatible_types(&sym->type, type)) {
		tcc_error("incompatible types for redefinition of '%s'",
			  get_tok_str(sym->v, NULL));

	} else if ((sym->type.t & VT_BTYPE) == VT_FUNC) {
		int static_proto = sym->type.t & VT_STATIC;
		/* warn if static follows non-static function declaration */

		if ((type->t & VT_STATIC) && !static_proto
		    /* XXX this test for inline shouldn't be here.  Until we
		                   implement gnu-inline mode again it silences a warning for
		                   mingw caused by our workarounds.  */

		    && !((type->t | sym->type.t) & VT_INLINE))
			tcc_warning("static storage ignored for redefinition of '%s'",
				    get_tok_str(sym->v, NULL));
		/* set 'inline' if both agree or if\ one has static */

		if ((type->t | sym->type.t) & VT_INLINE) {
			if (!((type->t ^ sym->type.t) & VT_INLINE)
			    || ((type->t | sym->type.t) & VT_STATIC))
				static_proto |= VT_INLINE;
		}

		if (0 == (type->t & VT_EXTERN)) {
			struct FuncAttr f = sym->type.ref->f;
			/* put complete type, use static from prototype */

			sym->type.t = (type->t & ~(VT_STATIC|VT_INLINE)) | static_proto;
			sym->type.ref = type->ref;
			merge_funcattr(&sym->type.ref->f, &f);
		} else {
			sym->type.t &= ~VT_INLINE | static_proto;
		}

		if (sym->type.ref->f.func_type == FUNC_OLD
		    && type->ref->f.func_type != FUNC_OLD) {
			sym->type.ref = type->ref;
		}

	} else {
		if ((sym->type.t & VT_ARRAY) && type->ref->c >= 0) {
			/* set array size if it was omitted in extern declaration */

			sym->type.ref->c = type->ref->c;
		}
		if ((type->t ^ sym->type.t) & VT_STATIC)
			tcc_warning("storage mismatch for redefinition of '%s'",
				    get_tok_str(sym->v, NULL));
	}
}
/* Merge some storage attributes.  */

static void patch_storage(Sym *sym, AttributeDef *ad, CType *type)
{
	if (type)
		patch_type(sym, type);

	if (sym->a.dllimport != ad->a.dllimport)
		tcc_error("incompatible dll linkage for redefinition of '%s'",
			  get_tok_str(sym->v, NULL));

	merge_symattr(&sym->a, &ad->a);
	if (ad->asm_label)
		sym->asm_label = ad->asm_label;
	update_storage(sym);
}
/* copy sym to other stack */

static Sym *sym_copy(Sym *s0, Sym **ps)
{
	Sym *s;
	s = sym_malloc(), *s = *s0;
	s->prev = *ps, *ps = s;
	if (s->v < SYM_FIRST_ANOM) {
		ps = &table_ident[s->v - TOK_IDENT]->sym_identifier;
		s->prev_tok = *ps, *ps = s;
	}
	return s;
}
/* copy s->type.ref to stack 'ps' for VT_FUNC and VT_PTR */

static void sym_copy_ref(Sym *s, Sym **ps)
{
	int bt = s->type.t & VT_BTYPE;
	if (bt == VT_FUNC || bt == VT_PTR || (bt == VT_STRUCT && s->sym_scope)) {
		Sym **sp = &s->type.ref;
		for (s = *sp, *sp = NULL; s; s = s->next) {
			Sym *s2 = sym_copy(s, ps);
			sp = &(*sp = s2)->next;
			sym_copy_ref(s2, ps);
		}
	}
}
/* define a new external reference to a symbol 'v' */

static Sym *external_sym(int v, CType *type, int r, AttributeDef *ad)
{
	Sym *s;
	/* look for global symbol */

	s = sym_find(v);
	while (s && s->sym_scope)
		s = s->prev_tok;

	if (!s) {
		/* push forward reference */

		s = global_identifier_push(v, type->t, 0);
		s->r |= r;
		s->a = ad->a;
		s->asm_label = ad->asm_label;
		s->type.ref = type->ref;
		/* copy type to the global stack */

		if (local_stack)
			sym_copy_ref(s, &global_stack);
	} else {
		patch_storage(s, ad, type);
	}
	/* push variables on local_stack if any */

	if (local_stack && (s->type.t & VT_BTYPE) != VT_FUNC)
		s = sym_copy(s, &local_stack);
	return s;
}
/* save registers up to (vtop - n) stack entry */

ST_FUNC void save_regs(int n)
{
	SValue *p, *p1;
	for (p = vstack, p1 = vtop - n; p <= p1; p++)
		save_reg(p->r);
}
/* save r to the memory stack, and mark it as being free */

ST_FUNC void save_reg(int r)
{
	save_reg_upstack(r, 0);
}
/* save r to the memory stack, and mark it as being free,
   if seen up to (vtop - n) stack entry */

ST_FUNC void save_reg_upstack(int r, int n)
{
	int l, size, align, bt, r2;
	SValue *p, *p1, sv;

	if ((r &= VT_VALMASK) >= VT_CONST)
		return;
	if (nocode_wanted)
		return;
	l = r2 = 0;
	for (p = vstack, p1 = vtop - n; p <= p1; p++) {
		if ((p->r & VT_VALMASK) == r || p->r2 == r) {
			/* must save value on stack if not already done */

			if (!l) {
				bt = p->type.t & VT_BTYPE;
				if (bt == VT_VOID)
					continue;
				if ((p->r & VT_LVAL) || bt == VT_FUNC)
					bt = VT_PTR;
				sv.type.t = bt;
				size = type_size(&sv.type, &align);
				l = get_temp_local_var(size, align, &r2);
				sv.r = VT_LOCAL | VT_LVAL;
				sv.c.i = l;
				store(p->r & VT_VALMASK, &sv);
				/* x86 specific: need to pop fp register ST0 if saved */

				if (r == TREG_ST0) {
					o(0xd8dd);/* fstp %st(0) */

				}
				/* special long long case */

				if (p->r2 < VT_CONST && USING_TWO_WORDS(bt)) {
					sv.c.i += PTR_SIZE;
					store(p->r2, &sv);
				}
			}
			/* mark that stack entry as being saved on the stack */

			if (p->r & VT_LVAL) {
				/* also clear the bounded flag because the
				                   relocation address of the function was stored in
				                   p->c.i */

				p->r = (p->r & ~(VT_VALMASK | VT_BOUNDED)) | VT_LLOCAL;
			} else {
				p->r = VT_LVAL | VT_LOCAL;
				p->type.t &= ~VT_ARRAY;/* cannot combine VT_LVAL with VT_ARRAY */

			}
			p->sym = NULL;
			p->r2 = r2;
			p->c.i = l;
		}
	}
}
/* find a free register of class 'rc'. If none, save one register */
// 1433 "tccgen.c"
ST_FUNC int get_reg(int rc)
{
	int r;
	SValue *p;
	/* find a free register */

	for (r=0; r<NB_REGS; r++) {
		if (reg_classes[r] & rc) {
			if (nocode_wanted)
				return r;
			for (p=vstack; p<=vtop; p++) {
				if ((p->r & VT_VALMASK) == r ||
				    p->r2 == r)
					goto notfound;
			}
			return r;
		}
notfound: ;
	}
	/* no register left : free the first one on the stack (VERY
	       IMPORTANT to start from the bottom to ensure that we don't
	       spill registers used in gen_opi()) */

	for (p=vstack; p<=vtop; p++) {
		/* look at second register (if long long) */

		r = p->r2;
		if (r < VT_CONST && (reg_classes[r] & rc))
			goto save_found;
		r = p->r & VT_VALMASK;
		if (r < VT_CONST && (reg_classes[r] & rc)) {
save_found:
			save_reg(r);
			return r;
		}
	}
	/* Should never comes here */

	return -1;
}
/* find a free temporary local variable (return the offset on stack) match
   size and align. If none, add new temporary stack variable */

static int get_temp_local_var(int size,int align, int *r2)
{
	int i;
	struct temp_local_variable *temp_var;
	SValue *p;
	int r;
	unsigned used = 0;
	/* mark locations that are still in use */

	for (p = vstack; p <= vtop; p++) {
		r = p->r & VT_VALMASK;
		if (r == VT_LOCAL || r == VT_LLOCAL) {
			r = p->r2 - (VT_CONST + 1);
			if (r >= 0 && r < MAX_TEMP_LOCAL_VARIABLE_NUMBER)
				used |= 1<<r;
		}
	}
	for (i=0; i<nb_temp_local_vars; i++) {
		temp_var=&arr_temp_local_vars[i];
		if (!(used & 1<<i)
		    && temp_var->size>=size
		    && temp_var->align>=align) {
ret_tmp:
			*r2 = (VT_CONST + 1) + i;
			return temp_var->location;
		}
	}
	loc = (loc - size) & -align;
	if (nb_temp_local_vars<MAX_TEMP_LOCAL_VARIABLE_NUMBER) {
		temp_var=&arr_temp_local_vars[i];
		temp_var->location=loc;
		temp_var->size=size;
		temp_var->align=align;
		nb_temp_local_vars++;
		goto ret_tmp;
	}
	*r2 = VT_CONST;
	return loc;
}
/* move register 's' (of type 't') to 'r', and flush previous value of r to memory
   if needed */

static void move_reg(int r, int s, int t)
{
	SValue sv;

	if (r != s) {
		save_reg(r);
		sv.type.t = t;
		sv.type.ref = NULL;
		sv.r = s;
		sv.c.i = 0;
		load(r, &sv);
	}
}
/* get address of vtop (vtop MUST BE an lvalue) */

ST_FUNC void gaddrof(void)
{
	vtop->r &= ~VT_LVAL;
	/* tricky: if saved lvalue, then we can go back to lvalue */

	if ((vtop->r & VT_VALMASK) == VT_LLOCAL)
		vtop->r = (vtop->r & ~VT_VALMASK) | VT_LOCAL | VT_LVAL;
}
#ifdef CONFIG_TCC_BCHECK

/* generate a bounded pointer addition */

static void gen_bounded_ptr_add(void)
{
	int save = (vtop[-1].r & VT_VALMASK) == VT_LOCAL;
	if (save) {
		vpushv(&vtop[-1]);
		vrott(3);
	}
	vpush_helper_func(TOK___bound_ptr_add);
	vrott(3);
	gfunc_call(2);
	vtop -= save;
	vpushi(0);
	/* returned pointer is in REG_IRET */

	vtop->r = REG_IRET | VT_BOUNDED;
	if (nocode_wanted)
		return;
	/* relocation offset of the bounding function call point */

	vtop->c.i = (cur_text_section->reloc->data_offset - sizeof(ElfW_Rel));
}

/* patch pointer addition in vtop so that pointer dereferencing is
   also tested */

static void gen_bounded_ptr_deref(void)
{
	addr_t func;
	int size, align;
	ElfW_Rel *rel;
	Sym *sym;

	if (nocode_wanted)
		return;

	size = type_size(&vtop->type, &align);
	switch (size) {
	case 1:
		func = TOK___bound_ptr_indir1;
		break;
	case 2:
		func = TOK___bound_ptr_indir2;
		break;
	case 4:
		func = TOK___bound_ptr_indir4;
		break;
	case 8:
		func = TOK___bound_ptr_indir8;
		break;
	case 12:
		func = TOK___bound_ptr_indir12;
		break;
	case 16:
		func = TOK___bound_ptr_indir16;
		break;
	default:
		/* may happen with struct member access */

		return;
	}
	sym = external_helper_sym(func);
	if (!sym->c)
		put_extern_sym(sym, NULL, 0, 0);
	/* patch relocation */

	/* XXX: find a better solution ? */

	rel = (ElfW_Rel *)(cur_text_section->reloc->data + vtop->c.i);
	rel->r_info = ELFW(R_INFO)(sym->c, ELFW(R_TYPE)(rel->r_info));
}

/* generate lvalue bound code */

static void gbound(void)
{
	CType type1;

	vtop->r &= ~VT_MUSTBOUND;
	/* if lvalue, then use checking code before dereferencing */

	if (vtop->r & VT_LVAL) {
		/* if not VT_BOUNDED value, then make one */

		if (!(vtop->r & VT_BOUNDED)) {
			/* must save type because we must set it to int to get pointer */

			type1 = vtop->type;
			vtop->type.t = VT_PTR;
			gaddrof();
			vpushi(0);
			gen_bounded_ptr_add();
			vtop->r |= VT_LVAL;
			vtop->type = type1;
		}
		/* then check for dereferencing */

		gen_bounded_ptr_deref();
	}
}

/* we need to call __bound_ptr_add before we start to load function
   args into registers */

ST_FUNC void gbound_args(int nb_args)
{
	int i, v;
	SValue *sv;

	for (i = 1; i <= nb_args; ++i)
		if (vtop[1 - i].r & VT_MUSTBOUND) {
			vrotb(i);
			gbound();
			vrott(i);
		}

	sv = vtop - nb_args;
	if (sv->r & VT_SYM) {
		v = sv->sym->v;
		if (v == TOK_setjmp
		    || v == TOK__setjmp
		   ) {
			vpush_helper_func(TOK___bound_setjmp);
			vpushv(sv + 1);
			gfunc_call(1);
			func_bound_add_epilog = 1;
		}
		if (v == TOK_alloca)
			func_bound_add_epilog = 1;
	}
}

/* Add bounds for local symbols from S to E (via ->prev) */

static void add_local_bounds(Sym *s, Sym *e)
{
	for (; s != e; s = s->prev) {
		if (!s->v || (s->r & VT_VALMASK) != VT_LOCAL)
			continue;
		/* Add arrays/structs/unions because we always take address */

		if ((s->type.t & VT_ARRAY)
		    || (s->type.t & VT_BTYPE) == VT_STRUCT
		    || s->a.addrtaken) {
			/* add local bound info */

			int align, size = type_size(&s->type, &align);
			addr_t *bounds_ptr = section_ptr_add(lbounds_section,
							     2 * sizeof(addr_t));
			bounds_ptr[0] = s->c;
			bounds_ptr[1] = size;
		}
	}
}
#endif
/* Wrapper around sym_pop, that potentially also registers local bounds.  */
// 1680 "tccgen.c"
static void pop_local_syms(Sym *b, int keep)
{
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check && !keep && (local_scope || !func_var))
		add_local_bounds(local_stack, b);
#endif

	if (debug_modes)
		tcc_add_debug_info (tcc_state, !local_scope, local_stack, b);
	sym_pop(&local_stack, b, keep);
}
/* increment an lvalue pointer */

static void incr_offset(int offset)
{
	int t = vtop->type.t;
	gaddrof();/* remove VT_LVAL */

	vtop->type.t = VT_PTRDIFF_T;/* set scalar type */

	vpushs(offset);
	gen_op('+');
	vtop->r |= VT_LVAL;
	vtop->type.t = t;
}

static void incr_bf_adr(int o)
{
	vtop->type.t = VT_BYTE | VT_UNSIGNED;
	incr_offset(o);
}
/* single-byte load mode for packed or otherwise unaligned bitfields */

static void load_packed_bf(CType *type, int bit_pos, int bit_size)
{
	int n, o, bits;
	save_reg_upstack(vtop->r, 1);
	vpush64(type->t & VT_BTYPE, 0);// B X

	bits = 0, o = bit_pos >> 3, bit_pos &= 7;
	do {
		vswap();// X B

		incr_bf_adr(o);
		vdup();// X B B

		n = 8 - bit_pos;
		if (n > bit_size)
			n = bit_size;
		if (bit_pos)
			vpushi(bit_pos), gen_op(TOK_SHR), bit_pos = 0;// X B Y

		if (n < 8)
			vpushi((1 << n) - 1), gen_op('&');
		gen_cast(type);
		if (bits)
			vpushi(bits), gen_op(TOK_SHL);
		vrotb(3);// B Y X

		gen_op('|');// B X

		bits += n, bit_size -= n, o = 1;
	} while (bit_size);
	vswap(), vpop();
	if (!(type->t & VT_UNSIGNED)) {
		n = ((type->t & VT_BTYPE) == VT_LLONG ? 64 : 32) - bits;
		vpushi(n), gen_op(TOK_SHL);
		vpushi(n), gen_op(TOK_SAR);
	}
}
/* single-byte store mode for packed or otherwise unaligned bitfields */

static void store_packed_bf(int bit_pos, int bit_size)
{
	int bits, n, o, m, c;
	c = (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;
	vswap();// X B

	save_reg_upstack(vtop->r, 1);
	bits = 0, o = bit_pos >> 3, bit_pos &= 7;
	do {
		incr_bf_adr(o);// X B

		vswap();//B X

		c ? vdup() : gv_dup();// B V X

		vrott(3);// X B V

		if (bits)
			vpushi(bits), gen_op(TOK_SHR);
		if (bit_pos)
			vpushi(bit_pos), gen_op(TOK_SHL);
		n = 8 - bit_pos;
		if (n > bit_size)
			n = bit_size;
		if (n < 8) {
			m = ((1 << n) - 1) << bit_pos;
			vpushi(m), gen_op('&');// X B V1

			vpushv(vtop-1);// X B V1 B

			vpushi(m & 0x80 ? ~m & 0x7f : ~m);
			gen_op('&');// X B V1 B1

			gen_op('|');// X B V2

		}
		vdup(), vtop[-1] = vtop[-2];// X B B V2

		vstore(), vpop();// X B

		bits += n, bit_size -= n, bit_pos = 0, o = 1;
	} while (bit_size);
	vpop(), vpop();
}

static int adjust_bf(SValue *sv, int bit_pos, int bit_size)
{
	int t;
	if (0 == sv->type.ref)
		return 0;
	t = sv->type.ref->auxtype;
	if (t != -1 && t != VT_STRUCT) {
		sv->type.t = (sv->type.t & ~(VT_BTYPE | VT_LONG)) | t;
		sv->r |= VT_LVAL;
	}
	return t;
}
/* store vtop a register belonging to class 'rc'. lvalues are
   converted to values. Cannot be used if cannot be converted to
   register value (such as structures). */

ST_FUNC int gv(int rc)
{
	int r, r2, r_ok, r2_ok, rc2, bt;
	int bit_pos, bit_size, size, align;
	/* NOTE: get_reg can modify vstack[] */

	if (vtop->type.t & VT_BITFIELD) {
		CType type;

		bit_pos = BIT_POS(vtop->type.t);
		bit_size = BIT_SIZE(vtop->type.t);
		/* remove bit field info to avoid loops */

		vtop->type.t &= ~VT_STRUCT_MASK;

		type.ref = NULL;
		type.t = vtop->type.t & VT_UNSIGNED;
		if ((vtop->type.t & VT_BTYPE) == VT_BOOL)
			type.t |= VT_UNSIGNED;

		r = adjust_bf(vtop, bit_pos, bit_size);

		if ((vtop->type.t & VT_BTYPE) == VT_LLONG)
			type.t |= VT_LLONG;
		else
			type.t |= VT_INT;

		if (r == VT_STRUCT) {
			load_packed_bf(&type, bit_pos, bit_size);
		} else {
			int bits = (type.t & VT_BTYPE) == VT_LLONG ? 64 : 32;
			/* cast to int to propagate signedness in following ops */

			gen_cast(&type);
			/* generate shifts */

			vpushi(bits - (bit_pos + bit_size));
			gen_op(TOK_SHL);
			vpushi(bits - bit_size);
			/* NOTE: transformed to SHR if unsigned */

			gen_op(TOK_SAR);
		}
		r = gv(rc);
	} else {
		if (is_float(vtop->type.t) &&
		    (vtop->r & (VT_VALMASK | VT_LVAL)) == VT_CONST) {
			/* CPUs usually cannot use float constants, so we store them
			               generically in data segment */

			init_params p = { rodata_section };
			unsigned long offset;
			size = type_size(&vtop->type, &align);
			if (NODATA_WANTED)
				size = 0, align = 1;
			offset = section_add(p.sec, size, align);
			vpush_ref(&vtop->type, p.sec, offset, size);
			vswap();
			init_putv(&p, &vtop->type, offset);
			vtop->r |= VT_LVAL;
		}
#ifdef CONFIG_TCC_BCHECK

		if (vtop->r & VT_MUSTBOUND)
			gbound();
#endif

		bt = vtop->type.t & VT_BTYPE;

		rc2 = RC2_TYPE(bt, rc);
		/* need to reload if:
		           - constant
		           - lvalue (need to dereference pointer)
		           - already a register, but not in the right class */

		r = vtop->r & VT_VALMASK;
		r_ok = !(vtop->r & VT_LVAL) && (r < VT_CONST) && (reg_classes[r] & rc);
		r2_ok = !rc2 || ((vtop->r2 < VT_CONST) && (reg_classes[vtop->r2] & rc2));

		if (!r_ok || !r2_ok) {

			if (!r_ok) {
				if (1/* we can 'mov (r),r' in cases */

				    && r < VT_CONST
				    && (reg_classes[r] & rc)
				    && !rc2
				   )
					save_reg_upstack(r, 1);
				else
					r = get_reg(rc);
			}

			if (rc2) {
				int load_type = (bt == VT_QFLOAT) ? VT_DOUBLE : VT_PTRDIFF_T;
				int original_type = vtop->type.t;
				/* two register type load :
				                   expand to two words temporarily */

				if ((vtop->r & (VT_VALMASK | VT_LVAL)) == VT_CONST) {
					/* load constant */

					unsigned long long ll = vtop->c.i;
					vtop->c.i = ll;/* first word */

					load(r, vtop);
					vtop->r = r;/* save register value */

					vpushi(ll >> 32);/* second word */

				} else if (vtop->r & VT_LVAL) {
					/* We do not want to modifier the long long pointer here.
					                       So we save any other instances down the stack */

					save_reg_upstack(vtop->r, 1);
					/* load from memory */

					vtop->type.t = load_type;
					load(r, vtop);
					vdup();
					vtop[-1].r = r;/* save register value */

					/* increment pointer to get second word */

					incr_offset(PTR_SIZE);
				} else {
					/* move registers */

					if (!r_ok)
						load(r, vtop);
					if (r2_ok && vtop->r2 < VT_CONST)
						goto done;
					vdup();
					vtop[-1].r = r;/* save register value */

					vtop->r = vtop[-1].r2;
				}
				/* Allocate second register. Here we rely on the fact that
				                   get_reg() tries first to free r2 of an SValue. */

				r2 = get_reg(rc2);
				load(r2, vtop);
				vpop();
				/* write second register */

				vtop->r2 = r2;
done:
				vtop->type.t = original_type;
			} else {
				if (vtop->r == VT_CMP)
					vset_VT_JMP();
				/* one register type load */

				load(r, vtop);
			}
		}
		vtop->r = r;

	}
	return r;
}
/* generate vtop[-1] and vtop[0] in resp. classes rc1 and rc2 */

ST_FUNC void gv2(int rc1, int rc2)
{
	/* generate more generic register first. But VT_JMP or VT_CMP
	       values must be generated first in all cases to avoid possible
	       reload errors */

	if (vtop->r != VT_CMP && rc1 <= rc2) {
		vswap();
		gv(rc1);
		vswap();
		gv(rc2);
		/* test if reload is needed for first register */

		if ((vtop[-1].r & VT_VALMASK) >= VT_CONST) {
			vswap();
			gv(rc1);
			vswap();
		}
	} else {
		gv(rc2);
		vswap();
		gv(rc1);
		vswap();
		/* test if reload is needed for first register */

		if ((vtop[0].r & VT_VALMASK) >= VT_CONST) {
			gv(rc2);
		}
	}
}
#if PTR_SIZE == 4
/* expand 64bit on stack in two ints */

ST_FUNC void lexpand(void)
{
	int u, v;
	u = vtop->type.t & (VT_DEFSIGN | VT_UNSIGNED);
	v = vtop->r & (VT_VALMASK | VT_LVAL);
	if (v == VT_CONST) {
		vdup();
		vtop[0].c.i >>= 32;
	} else if (v == (VT_LVAL|VT_CONST) || v == (VT_LVAL|VT_LOCAL)) {
		vdup();
		vtop[0].c.i += 4;
	} else {
		gv(RC_INT);
		vdup();
		vtop[0].r = vtop[-1].r2;
		vtop[0].r2 = vtop[-1].r2 = VT_CONST;
	}
	vtop[0].type.t = vtop[-1].type.t = VT_INT | u;
}
#endif
#if PTR_SIZE == 4
/* build a long long from two ints */

static void lbuild(int t)
{
	gv2(RC_INT, RC_INT);
	vtop[-1].r2 = vtop[0].r;
	vtop[-1].type.t = t;
	vpop();
}
#endif
/* convert stack entry to register and duplicate its value in another
   register */
// 2009 "tccgen.c"
static void gv_dup(void)
{
	int t, rc, r;

	t = vtop->type.t;
#if PTR_SIZE == 4
	if ((t & VT_BTYPE) == VT_LLONG) {
		if (t & VT_BITFIELD) {
			gv(RC_INT);
			t = vtop->type.t;
		}
		lexpand();
		gv_dup();
		vswap();
		vrotb(3);
		gv_dup();
		vrotb(4);
		/* stack: H L L1 H1 */

		lbuild(t);
		vrotb(3);
		vrotb(3);
		vswap();
		lbuild(t);
		vswap();
		return;
	}
#endif
	/* duplicate value */
// 2037 "tccgen.c"
	rc = RC_TYPE(t);
	gv(rc);
	r = get_reg(rc);
	vdup();
	load(r, vtop);
	vtop->r = r;
}
#if PTR_SIZE == 4
/* generate CPU independent (unsigned) long long operations */

static void gen_opl(int op)
{
	int t, a, b, op1, c, i;
	int func;
	unsigned short reg_iret = REG_IRET;
	unsigned short reg_lret = REG_IRE2;
	SValue tmp;

	switch (op) {
	case '/':
	case TOK_PDIV:
		func = TOK___divdi3;
		goto gen_func;
	case TOK_UDIV:
		func = TOK___udivdi3;
		goto gen_func;
	case '%':
		func = TOK___moddi3;
		goto gen_mod_func;
	case TOK_UMOD:
		func = TOK___umoddi3;
gen_mod_func:
gen_func:
		/* call generic long long function */

		vpush_helper_func(func);
		vrott(3);
		gfunc_call(2);
		vpushi(0);
		vtop->r = reg_iret;
		vtop->r2 = reg_lret;
		break;
	case '^':
	case '&':
	case '|':
	case '*':
	case '+':
	case '-':
		//pv("gen_opl A",0,2);

		t = vtop->type.t;
		vswap();
		lexpand();
		vrotb(3);
		lexpand();
		/* stack: L1 H1 L2 H2 */

		tmp = vtop[0];
		vtop[0] = vtop[-3];
		vtop[-3] = tmp;
		tmp = vtop[-2];
		vtop[-2] = vtop[-3];
		vtop[-3] = tmp;
		vswap();
		/* stack: H1 H2 L1 L2 */

		//pv("gen_opl B",0,4);

		if (op == '*') {
			vpushv(vtop - 1);
			vpushv(vtop - 1);
			gen_op(TOK_UMULL);
			lexpand();
			/* stack: H1 H2 L1 L2 ML MH */

			for (i=0; i<4; i++)
				vrotb(6);
			/* stack: ML MH H1 H2 L1 L2 */

			tmp = vtop[0];
			vtop[0] = vtop[-2];
			vtop[-2] = tmp;
			/* stack: ML MH H1 L2 H2 L1 */

			gen_op('*');
			vrotb(3);
			vrotb(3);
			gen_op('*');
			/* stack: ML MH M1 M2 */

			gen_op('+');
			gen_op('+');
		} else if (op == '+' || op == '-') {
			/* XXX: add non carry method too (for MIPS or alpha) */

			if (op == '+')
				op1 = TOK_ADDC1;
			else
				op1 = TOK_SUBC1;
			gen_op(op1);
			/* stack: H1 H2 (L1 op L2) */

			vrotb(3);
			vrotb(3);
			gen_op(op1 + 1); /* TOK_xxxC2 */

		} else {
			gen_op(op);
			/* stack: H1 H2 (L1 op L2) */

			vrotb(3);
			vrotb(3);
			/* stack: (L1 op L2) H1 H2 */

			gen_op(op);
			/* stack: (L1 op L2) (H1 op H2) */

		}
		/* stack: L H */

		lbuild(t);
		break;
	case TOK_SAR:
	case TOK_SHR:
	case TOK_SHL:
		if ((vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST) {
			t = vtop[-1].type.t;
			vswap();
			lexpand();
			vrotb(3);
			/* stack: L H shift */

			c = (int)vtop->c.i;
			/* constant: simpler */

			/* NOTE: all comments are for SHL. the other cases are
			   done by swapping words */

			vpop();
			if (op != TOK_SHL)
				vswap();
			if (c >= 32) {
				/* stack: L H */

				vpop();
				if (c > 32) {
					vpushi(c - 32);
					gen_op(op);
				}
				if (op != TOK_SAR) {
					vpushi(0);
				} else {
					gv_dup();
					vpushi(31);
					gen_op(TOK_SAR);
				}
				vswap();
			} else {
				vswap();
				gv_dup();
				/* stack: H L L */

				vpushi(c);
				gen_op(op);
				vswap();
				vpushi(32 - c);
				if (op == TOK_SHL)
					gen_op(TOK_SHR);
				else
					gen_op(TOK_SHL);
				vrotb(3);
				/* stack: L L H */

				vpushi(c);
				if (op == TOK_SHL)
					gen_op(TOK_SHL);
				else
					gen_op(TOK_SHR);
				gen_op('|');
			}
			if (op != TOK_SHL)
				vswap();
			lbuild(t);
		} else {
			/* XXX: should provide a faster fallback on x86 ? */

			switch (op) {
			case TOK_SAR:
				func = TOK___ashrdi3;
				goto gen_func;
			case TOK_SHR:
				func = TOK___lshrdi3;
				goto gen_func;
			case TOK_SHL:
				func = TOK___ashldi3;
				goto gen_func;
			}
		}
		break;
	default:
		/* compare operations */

		t = vtop->type.t;
		vswap();
		lexpand();
		vrotb(3);
		lexpand();
		/* stack: L1 H1 L2 H2 */

		tmp = vtop[-1];
		vtop[-1] = vtop[-2];
		vtop[-2] = tmp;
		/* stack: L1 L2 H1 H2 */

		if (!cur_switch || cur_switch->bsym) {
			/* avoid differnt registers being saved in branches.
			   This is not needed when comparing switch cases */

			save_regs(4);
		}
		/* compare high */

		op1 = op;
		/* when values are equal, we need to compare low words. since
		   the jump is inverted, we invert the test too. */

		if (op1 == TOK_LT)
			op1 = TOK_LE;
		else if (op1 == TOK_GT)
			op1 = TOK_GE;
		else if (op1 == TOK_ULT)
			op1 = TOK_ULE;
		else if (op1 == TOK_UGT)
			op1 = TOK_UGE;
		a = 0;
		b = 0;
		gen_op(op1);
		if (op == TOK_NE) {
			b = gvtst(0, 0);
		} else {
			a = gvtst(1, 0);
			if (op != TOK_EQ) {
				/* generate non equal test */

				vpushi(0);
				vset_VT_CMP(TOK_NE);
				b = gvtst(0, 0);
			}
		}
		/* compare low. Always unsigned */

		op1 = op;
		if (op1 == TOK_LT)
			op1 = TOK_ULT;
		else if (op1 == TOK_LE)
			op1 = TOK_ULE;
		else if (op1 == TOK_GT)
			op1 = TOK_UGT;
		else if (op1 == TOK_GE)
			op1 = TOK_UGE;
		gen_op(op1);
		gvtst_set(1, a);
		gvtst_set(0, b);
		break;
	}
}
#endif
/* normalize values */
// 2283 "tccgen.c"
static uint64_t value64(uint64_t l1, int t)
{
	if ((t & VT_BTYPE) == VT_LLONG
	    || (PTR_SIZE == 8 && (t & VT_BTYPE) == VT_PTR))
		return l1;
	else if (t & VT_UNSIGNED)
		return (uint32_t)l1;
	else
		return (uint32_t)l1 | -(l1 & 0x80000000);
}

static uint64_t gen_opic_sdiv(uint64_t a, uint64_t b)
{
	uint64_t x = (a >> 63 ? -a : a) / (b >> 63 ? -b : b);
	return (a ^ b) >> 63 ? -x : x;
}

static int gen_opic_lt(uint64_t a, uint64_t b)
{
	return (a ^ (uint64_t)1 << 63) < (b ^ (uint64_t)1 << 63);
}
/* handle integer constant optimizations and various machine
   independent opt */

static void gen_opic(int op)
{
	SValue *v1 = vtop - 1;
	SValue *v2 = vtop;
	int t1 = v1->type.t & VT_BTYPE;
	int t2 = v2->type.t & VT_BTYPE;
	int c1 = (v1->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;
	int c2 = (v2->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;
	uint64_t l1 = c1 ? value64(v1->c.i, v1->type.t) : 0;
	uint64_t l2 = c2 ? value64(v2->c.i, v2->type.t) : 0;
	int shm = (t1 == VT_LLONG) ? 63 : 31;
	int r;

	if (c1 && c2) {
		switch (op) {
		case '+':
			l1 += l2;
			break;
		case '-':
			l1 -= l2;
			break;
		case '&':
			l1 &= l2;
			break;
		case '^':
			l1 ^= l2;
			break;
		case '|':
			l1 |= l2;
			break;
		case '*':
			l1 *= l2;
			break;

		case TOK_PDIV:
		case '/':
		case '%':
		case TOK_UDIV:
		case TOK_UMOD:
			/* if division by zero, generate explicit division */

			if (l2 == 0) {
				if (CONST_WANTED && !NOEVAL_WANTED)
					tcc_error("division by zero in constant");
				goto general_case;
			}
			switch (op) {
			default:
				l1 = gen_opic_sdiv(l1, l2);
				break;
			case '%':
				l1 = l1 - l2 * gen_opic_sdiv(l1, l2);
				break;
			case TOK_UDIV:
				l1 = l1 / l2;
				break;
			case TOK_UMOD:
				l1 = l1 % l2;
				break;
			}
			break;
		case TOK_SHL:
			l1 <<= (l2 & shm);
			break;
		case TOK_SHR:
			l1 >>= (l2 & shm);
			break;
		case TOK_SAR:
			l1 = (l1 >> 63) ? ~(~l1 >> (l2 & shm)) : l1 >> (l2 & shm);
			break;
		/* tests */

		case TOK_ULT:
			l1 = l1 < l2;
			break;
		case TOK_UGE:
			l1 = l1 >= l2;
			break;
		case TOK_EQ:
			l1 = l1 == l2;
			break;
		case TOK_NE:
			l1 = l1 != l2;
			break;
		case TOK_ULE:
			l1 = l1 <= l2;
			break;
		case TOK_UGT:
			l1 = l1 > l2;
			break;
		case TOK_LT:
			l1 = gen_opic_lt(l1, l2);
			break;
		case TOK_GE:
			l1 = !gen_opic_lt(l1, l2);
			break;
		case TOK_LE:
			l1 = !gen_opic_lt(l2, l1);
			break;
		case TOK_GT:
			l1 = gen_opic_lt(l2, l1);
			break;
		/* logical */

		case TOK_LAND:
			l1 = l1 && l2;
			break;
		case TOK_LOR:
			l1 = l1 || l2;
			break;
		default:
			goto general_case;
		}
		v1->c.i = value64(l1, v1->type.t);
		v1->r |= v2->r & VT_NONCONST;
		vtop--;
	} else {
		/* if commutative ops, put c2 as constant */

		if (c1 && (op == '+' || op == '&' || op == '^' ||
			   op == '|' || op == '*' || op == TOK_EQ || op == TOK_NE)) {
			vswap();
			c2 = c1;//c = c1, c1 = c2, c2 = c;

			l2 = l1;//l = l1, l1 = l2, l2 = l;

		}
		if (c1 && ((l1 == 0 &&
			    (op == TOK_SHL || op == TOK_SHR || op == TOK_SAR)) ||
			   (l1 == -1 && op == TOK_SAR))) {
			/* treat (0 << x), (0 >> x) and (-1 >> x) as constant */

			vpop();
		} else if (c2 && ((l2 == 0 && (op == '&' || op == '*')) ||
				  (op == '|' &&
				   (l2 == -1 || (l2 == 0xFFFFFFFF && t2 != VT_LLONG))) ||
				  (l2 == 1 && (op == '%' || op == TOK_UMOD)))) {
			/* treat (x & 0), (x * 0), (x | -1) and (x % 1) as constant */

			if (l2 == 1)
				vtop->c.i = 0;
			vswap();
			vtop--;
		} else if (c2 && (((op == '*' || op == '/' || op == TOK_UDIV ||
				    op == TOK_PDIV) &&
				   l2 == 1) ||
				  ((op == '+' || op == '-' || op == '|' || op == '^' ||
				    op == TOK_SHL || op == TOK_SHR || op == TOK_SAR) &&
				   l2 == 0) ||
				  (op == '&' &&
				   (l2 == -1 || (l2 == 0xFFFFFFFF && t2 != VT_LLONG))))) {
			/* filter out NOP operations like x*1, x-0, x&-1... */

			vtop--;
		} else if (c2 && (op == '*' || op == TOK_PDIV || op == TOK_UDIV
				  || op == TOK_UMOD)) {
			/* try to use shifts instead of muls or divs */

			if (l2 > 0 && (l2 & (l2 - 1)) == 0) {
				int n = -1;
				if (op == TOK_UMOD) {
					vtop->c.i = l2 - 1;
					op = '&';
					goto general_case;
				}
				while (l2) {
					l2 >>= 1;
					n++;
				}
				vtop->c.i = n;
				if (op == '*')
					op = TOK_SHL;
				else if (op == TOK_PDIV)
					op = TOK_SAR;
				else
					op = TOK_SHR;
			}
			goto general_case;
		} else if (c2 && (op == '+' || op == '-') &&
			   (r = vtop[-1].r & (VT_VALMASK | VT_LVAL | VT_SYM),
			    r == (VT_CONST | VT_SYM) || r == VT_LOCAL)) {
			/* symbol + constant case */

			if (op == '-')
				l2 = -l2;
			l2 += vtop[-1].c.i;
			/* The backends can't always deal with addends to symbols
				       larger than +-1<<31.  Don't construct such.  */

			if ((int)l2 != l2)
				goto general_case;
			vtop--;
			vtop->c.i = l2;
		} else {
general_case:
			/* call low level op generator */

			if (t1 == VT_LLONG || t2 == VT_LLONG ||
			    (PTR_SIZE == 8 && (t1 == VT_PTR || t2 == VT_PTR)))
				gen_opl(op);
			else
				gen_opi(op);
		}
		if (vtop->r == VT_CONST)
			vtop->r |= VT_NONCONST;/* is const, but only by optimization */

	}
}

#define gen_negf gen_opf
/* generate a floating point operation with constant propagation */
// 2487 "tccgen.c"
static void gen_opif(int op)
{
	int c1, c2, i, bt;
	SValue *v1, *v2;

	long double f1, f2;

	v1 = vtop - 1;
	v2 = vtop;
	if (op == TOK_NEG)
		v1 = v2;
	bt = v1->type.t & VT_BTYPE;
	/* currently, we cannot do computations with forward symbols */

	c1 = (v1->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;
	c2 = (v2->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;
	if (c1 && c2) {
		if (bt == VT_FLOAT) {
			f1 = v1->c.f;
			f2 = v2->c.f;
		} else if (bt == VT_DOUBLE) {
			f1 = v1->c.d;
			f2 = v2->c.d;
		} else {
			f1 = v1->c.ld;
			f2 = v2->c.ld;
		}
		/* NOTE: we only do constant propagation if finite number (not
		           NaN or infinity) (ANSI spec) */

		if (!(ieee_finite(f1) || !ieee_finite(f2)) && !CONST_WANTED)
			goto general_case;
		switch (op) {
		case '+':
			f1 += f2;
			break;
		case '-':
			f1 -= f2;
			break;
		case '*':
			f1 *= f2;
			break;
		case '/':
			if (f2 == 0.0) {
				union {
					float f;
					unsigned u;
				} x1, x2, y;
				/* If not in initializer we need to potentially generate
						   FP exceptions at runtime, otherwise we want to fold.  */

				if (!CONST_WANTED)
					goto general_case;
				/* the run-time result of 0.0/0.0 on x87, also of other compilers
				                   when used to compile the f1 /= f2 below, would be -nan */

				x1.f = f1, x2.f = f2;
				if (f1 == 0.0)
					y.u = 0x7fc00000;/* nan */

				else
					y.u = 0x7f800000;/* infinity */

				y.u |= (x1.u ^ x2.u) & 0x80000000;/* set sign */

				f1 = y.f;
				break;
			}
			f1 /= f2;
			break;
		case TOK_NEG:
			f1 = -f1;
			goto unary_result;
		case TOK_EQ:
			i = f1 == f2;
make_int:
			vtop -= 2;
			vpushi(i);
			return;
		case TOK_NE:
			i = f1 != f2;
			goto make_int;
		case TOK_LT:
			i = f1 < f2;
			goto make_int;
		case TOK_GE:
			i = f1 >= f2;
			goto make_int;
		case TOK_LE:
			i = f1 <= f2;
			goto make_int;
		case TOK_GT:
			i = f1 > f2;
			goto make_int;
		default:
			goto general_case;
		}
		vtop--;
unary_result:
		/* XXX: overflow test ? */

		if (bt == VT_FLOAT) {
			v1->c.f = f1;
		} else if (bt == VT_DOUBLE) {
			v1->c.d = f1;
		} else {
			v1->c.ld = f1;
		}
	} else {
general_case:
		if (op == TOK_NEG) {
			gen_negf(op);
		} else {
			gen_opf(op);
		}
	}
}
/* print a type. If 'varstr' is not NULL, then the variable is also
   printed in the type */
/* XXX: union */
/* XXX: add array and function pointers */

static void type_to_str(char *buf, int buf_size,
			CType *type, const char *varstr)
{
	int bt, v, t;
	Sym *s, *sa;
	char buf1[256];
	const char *tstr;

	t = type->t;
	bt = t & VT_BTYPE;
	buf[0] = '\0';

	if (t & VT_EXTERN)
		pstrcat(buf, buf_size, "extern ");
	if (t & VT_STATIC)
		pstrcat(buf, buf_size, "static ");
	if (t & VT_TYPEDEF)
		pstrcat(buf, buf_size, "typedef ");
	if (t & VT_INLINE)
		pstrcat(buf, buf_size, "inline ");
	if (bt != VT_PTR) {
		if (t & VT_VOLATILE)
			pstrcat(buf, buf_size, "volatile ");
		if (t & VT_CONSTANT)
			pstrcat(buf, buf_size, "const ");
	}
	if (((t & VT_DEFSIGN) && bt == VT_BYTE)
	    || ((t & VT_UNSIGNED)
		&& (bt == VT_SHORT || bt == VT_INT || bt == VT_LLONG)
		&& !IS_ENUM(t)
	       ))
		pstrcat(buf, buf_size, (t & VT_UNSIGNED) ? "unsigned " : "signed ");

	buf_size -= strlen(buf);
	buf += strlen(buf);

	switch (bt) {
	case VT_VOID:
		tstr = "void";
		goto add_tstr;
	case VT_BOOL:
		tstr = "_Bool";
		goto add_tstr;
	case VT_BYTE:
		tstr = "char";
		goto add_tstr;
	case VT_SHORT:
		tstr = "short";
		goto add_tstr;
	case VT_INT:
		tstr = "int";
		goto maybe_long;
	case VT_LLONG:
		tstr = "long long";
maybe_long:
		if (t & VT_LONG)
			tstr = "long";
		if (!IS_ENUM(t))
			goto add_tstr;
		tstr = "enum ";
		goto tstruct;
	case VT_FLOAT:
		tstr = "float";
		goto add_tstr;
	case VT_DOUBLE:
		tstr = "double";
		if (!(t & VT_LONG))
			goto add_tstr;
	case VT_LDOUBLE:
		tstr = "long double";
add_tstr:
		pstrcat(buf, buf_size, tstr);
		break;
	case VT_STRUCT:
		tstr = "struct ";
		if (IS_UNION(t))
			tstr = "union ";
tstruct:
		pstrcat(buf, buf_size, tstr);
		v = type->ref->v & ~SYM_STRUCT;
		if (v >= SYM_FIRST_ANOM)
			pstrcat(buf, buf_size, "<anonymous>");
		else
			pstrcat(buf, buf_size, get_tok_str(v, NULL));
		break;
	case VT_FUNC:
		s = type->ref;
		buf1[0]=0;
		if (varstr && '*' == *varstr) {
			pstrcat(buf1, sizeof(buf1), "(");
			pstrcat(buf1, sizeof(buf1), varstr);
			pstrcat(buf1, sizeof(buf1), ")");
		}
		pstrcat(buf1, buf_size, "(");
		sa = s->next;
		while (sa != NULL) {
			char buf2[256];
			type_to_str(buf2, sizeof(buf2), &sa->type, NULL);
			pstrcat(buf1, sizeof(buf1), buf2);
			sa = sa->next;
			if (sa)
				pstrcat(buf1, sizeof(buf1), ", ");
		}
		if (s->f.func_type == FUNC_ELLIPSIS)
			pstrcat(buf1, sizeof(buf1), ", ...");
		pstrcat(buf1, sizeof(buf1), ")");
		type_to_str(buf, buf_size, &s->type, buf1);
		goto no_var;
	case VT_PTR:
		s = type->ref;
		if (t & (VT_ARRAY|VT_VLA)) {
			if (varstr && '*' == *varstr)
				snprintf(buf1, sizeof(buf1), "(%s)[%d]", varstr, s->c);
			else
				snprintf(buf1, sizeof(buf1), "%s[%d]", varstr ? varstr : "", s->c);
			type_to_str(buf, buf_size, &s->type, buf1);
			goto no_var;
		}
		pstrcpy(buf1, sizeof(buf1), "*");
		if (t & VT_CONSTANT)
			pstrcat(buf1, buf_size, "const ");
		if (t & VT_VOLATILE)
			pstrcat(buf1, buf_size, "volatile ");
		if (varstr)
			pstrcat(buf1, sizeof(buf1), varstr);
		type_to_str(buf, buf_size, &s->type, buf1);
		goto no_var;
	}
	if (varstr) {
		pstrcat(buf, buf_size, " ");
		pstrcat(buf, buf_size, varstr);
	}
no_var: ;
}

static void type_incompatibility_error(CType* st, CType* dt, const char* fmt)
{
	char buf1[256], buf2[256];
	type_to_str(buf1, sizeof(buf1), st, NULL);
	type_to_str(buf2, sizeof(buf2), dt, NULL);
	tcc_error(fmt, buf1, buf2);
}

static void type_incompatibility_warning(CType* st, CType* dt, const char* fmt)
{
	char buf1[256], buf2[256];
	type_to_str(buf1, sizeof(buf1), st, NULL);
	type_to_str(buf2, sizeof(buf2), dt, NULL);
	tcc_warning(fmt, buf1, buf2);
}

static int pointed_size(CType *type)
{
	int align;
	return type_size(pointed_type(type), &align);
}

static inline int is_null_pointer(SValue *p)
{
	if ((p->r & (VT_VALMASK | VT_LVAL | VT_SYM | VT_NONCONST)) != VT_CONST)
		return 0;
	return ((p->type.t & VT_BTYPE) == VT_INT && (uint32_t)p->c.i == 0) ||
	       ((p->type.t & VT_BTYPE) == VT_LLONG && p->c.i == 0) ||
	       ((p->type.t & VT_BTYPE) == VT_PTR &&
		(PTR_SIZE == 4 ? (uint32_t)p->c.i == 0 : p->c.i == 0) &&
		((pointed_type(&p->type)->t & VT_BTYPE) == VT_VOID) &&
		0 == (pointed_type(&p->type)->t & (VT_CONSTANT | VT_VOLATILE))
	       );
}
/* compare function types. OLD functions match any new functions */

static int is_compatible_func(CType *type1, CType *type2)
{
	Sym *s1, *s2;

	s1 = type1->ref;
	s2 = type2->ref;
	if (s1->f.func_call != s2->f.func_call)
		return 0;
	if (s1->f.func_type != s2->f.func_type
	    && s1->f.func_type != FUNC_OLD
	    && s2->f.func_type != FUNC_OLD)
		return 0;
	for (;;) {
		if (!is_compatible_unqualified_types(&s1->type, &s2->type))
			return 0;
		if (s1->f.func_type == FUNC_OLD || s2->f.func_type == FUNC_OLD )
			return 1;
		s1 = s1->next;
		s2 = s2->next;
		if (!s1)
			return !s2;
		if (!s2)
			return 0;
	}
}
/* return true if type1 and type2 are the same.  If unqualified is
   true, qualifiers on the types are ignored.
 */

static int compare_types(CType *type1, CType *type2, int unqualified)
{
	int bt1, t1, t2;

	if (IS_ENUM(type1->t)) {
		if (IS_ENUM(type2->t))
			return type1->ref == type2->ref;
		type1 = &type1->ref->type;
	} else if (IS_ENUM(type2->t))
		type2 = &type2->ref->type;

	t1 = type1->t & VT_TYPE;
	t2 = type2->t & VT_TYPE;
	if (unqualified) {
		/* strip qualifiers before comparing */

		t1 &= ~(VT_CONSTANT | VT_VOLATILE);
		t2 &= ~(VT_CONSTANT | VT_VOLATILE);
	}
	/* Default Vs explicit signedness only matters for char */

	if ((t1 & VT_BTYPE) != VT_BYTE) {
		t1 &= ~VT_DEFSIGN;
		t2 &= ~VT_DEFSIGN;
	}
	/* XXX: bitfields ? */

	if (t1 != t2)
		return 0;

	if ((t1 & VT_ARRAY)
	    && !(type1->ref->c < 0
		 || type2->ref->c < 0
		 || type1->ref->c == type2->ref->c))
		return 0;
	/* test more complicated cases */

	bt1 = t1 & VT_BTYPE;
	if (bt1 == VT_PTR) {
		type1 = pointed_type(type1);
		type2 = pointed_type(type2);
		return is_compatible_types(type1, type2);
	} else if (bt1 == VT_STRUCT) {
		return (type1->ref == type2->ref);
	} else if (bt1 == VT_FUNC) {
		return is_compatible_func(type1, type2);
	} else {
		return 1;
	}
}

#define CMP_OP 'C'
#define SHIFT_OP 'S'
/* Check if OP1 and OP2 can be "combined" with operation OP, the combined
   type is stored in DEST if non-null (except for pointer plus/minus) . */

static int combine_types(CType *dest, SValue *op1, SValue *op2, int op)
{
	CType *type1, *type2, type;
	int t1, t2, bt1, bt2;
	int ret = 1;
	/* for shifts, 'combine' only left operand */

	if (op == SHIFT_OP)
		op2 = op1;

	type1 = &op1->type, type2 = &op2->type;
	t1 = type1->t, t2 = type2->t;
	bt1 = t1 & VT_BTYPE, bt2 = t2 & VT_BTYPE;

	type.t = VT_VOID;
	type.ref = NULL;

	if (bt1 == VT_VOID || bt2 == VT_VOID) {
		ret = op == '?' ? 1 : 0;
		/* NOTE: as an extension, we accept void on only one side */

		type.t = VT_VOID;
	} else if (bt1 == VT_PTR || bt2 == VT_PTR) {
		if (op == '+') {
			if (!is_integer_btype(bt1 == VT_PTR ? bt2 : bt1))
				ret = 0;
		}
		/* http://port70.net/~nsz/c/c99/n1256.html#6.5.15p6 */
		/* If one is a null ptr constant the result type is the other.  */

		else if (is_null_pointer (op2)) type = *type1;
		else if (is_null_pointer (op1)) type = *type2;
		else if (bt1 != bt2) {
			/* accept comparison or cond-expr between pointer and integer
			               with a warning */

			if ((op == '?' || op == CMP_OP)
			    && (is_integer_btype(bt1) || is_integer_btype(bt2)))
				tcc_warning("pointer/integer mismatch in %s",
					    op == '?' ? "conditional expression" : "comparison");
			else if (op != '-' || !is_integer_btype(bt2))
				ret = 0;
			type = *(bt1 == VT_PTR ? type1 : type2);
		} else {
			CType *pt1 = pointed_type(type1);
			CType *pt2 = pointed_type(type2);
			int pbt1 = pt1->t & VT_BTYPE;
			int pbt2 = pt2->t & VT_BTYPE;
			int newquals, copied = 0;
			if (pbt1 != VT_VOID && pbt2 != VT_VOID
			    && !compare_types(pt1, pt2, 1/*unqualif*/
					     )) {
				if (op != '?' && op != CMP_OP)
					ret = 0;
				else
					type_incompatibility_warning(type1, type2,
								     op == '?'
								     ? "pointer type mismatch in conditional expression ('%s' and '%s')"
								     : "pointer type mismatch in comparison('%s' and '%s')");
			}
			if (op == '?') {
				/* pointers to void get preferred, otherwise the
				                   pointed to types minus qualifs should be compatible */

				type = *((pbt1 == VT_VOID) ? type1 : type2);
				/* combine qualifs */

				newquals = ((pt1->t | pt2->t) & (VT_CONSTANT | VT_VOLATILE));
				if ((~pointed_type(&type)->t & (VT_CONSTANT | VT_VOLATILE))
				    & newquals) {
					/* copy the pointer target symbol */

					type.ref = sym_push(SYM_FIELD, &type.ref->type,
							    0, type.ref->c);
					copied = 1;
					pointed_type(&type)->t |= newquals;
				}
				/* pointers to incomplete arrays get converted to
				                   pointers to completed ones if possible */

				if (pt1->t & VT_ARRAY
				    && pt2->t & VT_ARRAY
				    && pointed_type(&type)->ref->c < 0
				    && (pt1->ref->c > 0 || pt2->ref->c > 0)) {
					if (!copied)
						type.ref = sym_push(SYM_FIELD, &type.ref->type,
								    0, type.ref->c);
					pointed_type(&type)->ref =
						sym_push(SYM_FIELD, &pointed_type(&type)->ref->type,
							 0, pointed_type(&type)->ref->c);
					pointed_type(&type)->ref->c =
						0 < pt1->ref->c ? pt1->ref->c : pt2->ref->c;
				}
			}
		}
		if (op == CMP_OP)
			type.t = VT_SIZE_T;
	} else if (bt1 == VT_STRUCT || bt2 == VT_STRUCT) {
		if (op != '?' || !compare_types(type1, type2, 1))
			ret = 0;
		type = *type1;
	} else if (is_float(bt1) || is_float(bt2)) {
		if (bt1 == VT_LDOUBLE || bt2 == VT_LDOUBLE) {
			type.t = VT_LDOUBLE;
		} else if (bt1 == VT_DOUBLE || bt2 == VT_DOUBLE) {
			type.t = VT_DOUBLE;
		} else {
			type.t = VT_FLOAT;
		}
	} else if (bt1 == VT_LLONG || bt2 == VT_LLONG) {
		/* cast to biggest op */

		type.t = VT_LLONG | VT_LONG;
		if (bt1 == VT_LLONG)
			type.t &= t1;
		if (bt2 == VT_LLONG)
			type.t &= t2;
		/* convert to unsigned if it does not fit in a long long */

		if ((t1 & (VT_BTYPE | VT_UNSIGNED | VT_BITFIELD)) == (VT_LLONG | VT_UNSIGNED) ||
		    (t2 & (VT_BTYPE | VT_UNSIGNED | VT_BITFIELD)) == (VT_LLONG | VT_UNSIGNED))
			type.t |= VT_UNSIGNED;
	} else {
		/* integer operations */

		type.t = VT_INT | (VT_LONG & (t1 | t2));
		/* convert to unsigned if it does not fit in an integer */

		if ((t1 & (VT_BTYPE | VT_UNSIGNED | VT_BITFIELD)) == (VT_INT | VT_UNSIGNED) ||
		    (t2 & (VT_BTYPE | VT_UNSIGNED | VT_BITFIELD)) == (VT_INT | VT_UNSIGNED))
			type.t |= VT_UNSIGNED;
	}
	if (dest)
		*dest = type;
	return ret;
}
/* generic gen_op: handles types problems */

ST_FUNC void gen_op(int op)
{
	int t1, t2, bt1, bt2, t;
	CType type1, combtype;
	int op_class = op;

	if (op == TOK_SHR || op == TOK_SAR || op == TOK_SHL)
		op_class = SHIFT_OP;
	else if (TOK_ISCOND(op))/* == != > ... */

		op_class = CMP_OP;

redo:
	t1 = vtop[-1].type.t;
	t2 = vtop[0].type.t;
	bt1 = t1 & VT_BTYPE;
	bt2 = t2 & VT_BTYPE;

	if (bt1 == VT_FUNC || bt2 == VT_FUNC) {
		if (bt2 == VT_FUNC) {
			mk_pointer(&vtop->type);
			gaddrof();
		}
		if (bt1 == VT_FUNC) {
			vswap();
			mk_pointer(&vtop->type);
			gaddrof();
			vswap();
		}
		goto redo;
	} else if (!combine_types(&combtype, vtop - 1, vtop, op_class)) {
op_err:
		tcc_error("invalid operand types for binary operation");
	} else if (bt1 == VT_PTR || bt2 == VT_PTR) {
		/* at least one operand is a pointer */
		/* relational op: must be both pointers */

		int align;
		if (op_class == CMP_OP)
			goto std_op;
		/* if both pointers, then it must be the '-' op */

		if (bt1 == VT_PTR && bt2 == VT_PTR) {
			if (op != '-')
				goto op_err;
			vpush_type_size(pointed_type(&vtop[-1].type), &align);
			vtop->type.t &= ~VT_UNSIGNED;
			vrott(3);
			gen_opic(op);
			vtop->type.t = VT_PTRDIFF_T;
			vswap();
			gen_op(TOK_PDIV);
		} else {
			/* exactly one pointer : must be '+' or '-'. */

			if (op != '-' && op != '+')
				goto op_err;
			/* Put pointer as first operand */

			if (bt2 == VT_PTR) {
				vswap();
				t = t1, t1 = t2, t2 = t;
				bt2 = bt1;
			}
#if PTR_SIZE == 4
			if (bt2 == VT_LLONG)
				/* XXX: truncate here because gen_opl can't handle ptr + long long */

				gen_cast_s(VT_INT);
#endif

			type1 = vtop[-1].type;
			vpush_type_size(pointed_type(&vtop[-1].type), &align);
			gen_op('*');
#ifdef CONFIG_TCC_BCHECK

			if (tcc_state->do_bounds_check && !CONST_WANTED) {
				/* if bounded pointers, we generate a special code to
				   test bounds */

				if (op == '-') {
					vpushi(0);
					vswap();
					gen_op('-');
				}
				gen_bounded_ptr_add();
			} else
#endif
// 3057 "tccgen.c"
			{
				gen_opic(op);
			}
			type1.t &= ~(VT_ARRAY|VT_VLA);
			/* put again type if gen_opic() swaped operands */

			vtop->type = type1;
		}
	} else {
		/* floats can only be used for a few operations */

		if (is_float(combtype.t)
		    && op != '+' && op != '-' && op != '*' && op != '/'
		    && op_class != CMP_OP) {
			goto op_err;
		}
std_op:
		t = t2 = combtype.t;
		/* special case for shifts and long long: we keep the shift as
		           an integer */

		if (op_class == SHIFT_OP)
			t2 = VT_INT;
		/* XXX: currently, some unsigned operations are explicit, so
		           we modify them here */

		if (t & VT_UNSIGNED) {
			if (op == TOK_SAR)
				op = TOK_SHR;
			else if (op == '/')
				op = TOK_UDIV;
			else if (op == '%')
				op = TOK_UMOD;
			else if (op == TOK_LT)
				op = TOK_ULT;
			else if (op == TOK_GT)
				op = TOK_UGT;
			else if (op == TOK_LE)
				op = TOK_ULE;
			else if (op == TOK_GE)
				op = TOK_UGE;
		}
		vswap();
		gen_cast_s(t);
		vswap();
		gen_cast_s(t2);
		if (is_float(t))
			gen_opif(op);
		else
			gen_opic(op);
		if (op_class == CMP_OP) {
			/* relational op: the result is an int */

			vtop->type.t = VT_INT;
		} else {
			vtop->type.t = t;
		}
	}
// Make sure that we have converted to an rvalue:

	if (vtop->r & VT_LVAL)
		gv(is_float(vtop->type.t & VT_BTYPE) ? RC_FLOAT : RC_INT);
}
/* generic itof for unsigned long long case */

static void gen_cvt_itof1(int t)
{
	if ((vtop->type.t & (VT_BTYPE | VT_UNSIGNED)) ==
	    (VT_LLONG | VT_UNSIGNED)) {

		if (t == VT_FLOAT)
			vpush_helper_func(TOK___floatundisf);
#if LDOUBLE_SIZE != 8

		else if (t == VT_LDOUBLE)
			vpush_helper_func(TOK___floatundixf);
#endif

		else
			vpush_helper_func(TOK___floatundidf);
		vrott(2);
		gfunc_call(1);
		vpushi(0);
		PUT_R_RET(vtop, t);
	} else {
		gen_cvt_itof(t);
	}
}
/* generic ftoi for unsigned long long case */

static void gen_cvt_ftoi1(int t)
{
	int st;
	if (t == (VT_LLONG | VT_UNSIGNED)) {
		/* not handled natively */

		st = vtop->type.t & VT_BTYPE;
		if (st == VT_FLOAT)
			vpush_helper_func(TOK___fixunssfdi);
#if LDOUBLE_SIZE != 8

		else if (st == VT_LDOUBLE)
			vpush_helper_func(TOK___fixunsxfdi);
#endif

		else
			vpush_helper_func(TOK___fixunsdfdi);
		vrott(2);
		gfunc_call(1);
		vpushi(0);
		PUT_R_RET(vtop, t);
	} else {
		gen_cvt_ftoi(t);
	}
}
/* special delayed cast for char/short */

static void force_charshort_cast(void)
{
	int sbt = BFGET(vtop->r, VT_MUSTCAST) == 2 ? VT_LLONG : VT_INT;
	int dbt = vtop->type.t;
	vtop->r &= ~VT_MUSTCAST;
	vtop->type.t = sbt;
	gen_cast_s(dbt == VT_BOOL ? VT_BYTE|VT_UNSIGNED : dbt);
	vtop->type.t = dbt;
}

static void gen_cast_s(int t)
{
	CType type;
	type.t = t;
	type.ref = NULL;
	gen_cast(&type);
}
/* cast 'vtop' to 'type'. Casting to bitfields is forbidden. */

static void gen_cast(CType *type)
{
	int sbt, dbt, sf, df, c;
	int dbt_bt, sbt_bt, ds, ss, bits, trunc;
	/* special delayed cast for char/short */

	if (vtop->r & VT_MUSTCAST)
		force_charshort_cast();
	/* bitfields first get cast to ints */

	if (vtop->type.t & VT_BITFIELD)
		gv(RC_INT);

	if (IS_ENUM(type->t) && type->ref->c < 0)
		tcc_error("cast to incomplete type");

	dbt = type->t & (VT_BTYPE | VT_UNSIGNED);
	sbt = vtop->type.t & (VT_BTYPE | VT_UNSIGNED);
	if (sbt == VT_FUNC)
		sbt = VT_PTR;

again:
	if (sbt != dbt) {
		sf = is_float(sbt);
		df = is_float(dbt);
		dbt_bt = dbt & VT_BTYPE;
		sbt_bt = sbt & VT_BTYPE;
		if (dbt_bt == VT_VOID)
			goto done;
		if (sbt_bt == VT_VOID) {
error:
			cast_error(&vtop->type, type);
		}

		c = (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;

		if (c) {
			/* constant case: we can do it now */
			/* XXX: in ISOC, cannot do it if error in convert */

			if (sbt == VT_FLOAT)
				vtop->c.ld = vtop->c.f;
			else if (sbt == VT_DOUBLE)
				vtop->c.ld = vtop->c.d;

			if (df) {
				if (sbt_bt == VT_LLONG) {
					if ((sbt & VT_UNSIGNED) || !(vtop->c.i >> 63))
						vtop->c.ld = vtop->c.i;
					else
						vtop->c.ld = -(long double)-vtop->c.i;
				} else if (!sf) {
					if ((sbt & VT_UNSIGNED) || !(vtop->c.i >> 31))
						vtop->c.ld = (uint32_t)vtop->c.i;
					else
						vtop->c.ld = -(long double)-(uint32_t)vtop->c.i;
				}

				if (dbt == VT_FLOAT)
					vtop->c.f = (float)vtop->c.ld;
				else if (dbt == VT_DOUBLE)
					vtop->c.d = (double)vtop->c.ld;
			} else if (sf && dbt == VT_BOOL) {
				vtop->c.i = (vtop->c.ld != 0);
			} else {
				if (sf) {
					if (dbt & VT_UNSIGNED)
						vtop->c.i = (uint64_t)vtop->c.ld;
					else
						vtop->c.i = (int64_t)vtop->c.ld;
				} else if (sbt_bt == VT_LLONG || (PTR_SIZE == 8 && sbt == VT_PTR))
					;
				else if (sbt & VT_UNSIGNED)
					vtop->c.i = (uint32_t)vtop->c.i;
				else
					vtop->c.i = ((uint32_t)vtop->c.i | -(vtop->c.i & 0x80000000));

				if (dbt_bt == VT_LLONG || (PTR_SIZE == 8 && dbt == VT_PTR))
					;
				else if (dbt == VT_BOOL)
					vtop->c.i = (vtop->c.i != 0);
				else {
					uint32_t m = dbt_bt == VT_BYTE ? 0xff :
						     dbt_bt == VT_SHORT ? 0xffff :
						     0xffffffff;
					vtop->c.i &= m;
					if (!(dbt & VT_UNSIGNED))
						vtop->c.i |= -(vtop->c.i & ((m >> 1) + 1));
				}
			}
			goto done;

		} else if (dbt == VT_BOOL
			   && (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM))
			   == (VT_CONST | VT_SYM)) {
			/* addresses are considered non-zero (see tcctest.c:sinit23) */

			vtop->r = VT_CONST;
			vtop->c.i = 1;
			goto done;
		}
		/* cannot generate code for global or static initializers */

		if (nocode_wanted & DATA_ONLY_WANTED)
			goto done;
		/* non constant case: generate code */

		if (dbt == VT_BOOL) {
			gen_test_zero(TOK_NE);
			goto done;
		}

		if (sf || df) {
			if (sf && df) {
				/* convert from fp to fp */

				gen_cvt_ftof(dbt);
			} else if (df) {
				/* convert int to fp */

				gen_cvt_itof1(dbt);
			} else {
				/* convert fp to int */

				sbt = dbt;
				if (dbt_bt != VT_LLONG && dbt_bt != VT_INT)
					sbt = VT_INT;
				gen_cvt_ftoi1(sbt);
				goto again;/* may need char/short cast */

			}
			goto done;
		}

		ds = btype_size(dbt_bt);
		ss = btype_size(sbt_bt);
		if (ds == 0 || ss == 0)
			goto error;
		/* same size and no sign conversion needed */

		if (ds == ss && ds >= 4)
			goto done;
		if (dbt_bt == VT_PTR || sbt_bt == VT_PTR) {
			tcc_warning("cast between pointer and integer of different size");
			if (sbt_bt == VT_PTR) {
				/* put integer type to allow logical operations below */

				vtop->type.t = (PTR_SIZE == 8 ? VT_LLONG : VT_INT);
			}
		}
		/* processor allows { int a = 0, b = *(char*)&a; }
		           That means that if we cast to less width, we can just
		           change the type and read it still later. */

#define ALLOW_SUBTYPE_ACCESS 1

		if (ALLOW_SUBTYPE_ACCESS && (vtop->r & VT_LVAL)) {
			/* value still in memory */

			if (ds <= ss)
				goto done;
			/* ss <= 4 here */

			if (ds <= 4 && !(dbt == (VT_SHORT | VT_UNSIGNED) && sbt == VT_BYTE)) {
				gv(RC_INT);
				goto done;/* no 64bit envolved */

			}
		}
		gv(RC_INT);

		trunc = 0;
#if PTR_SIZE == 4
		if (ds == 8) {
			/* generate high word */

			if (sbt & VT_UNSIGNED) {
				vpushi(0);
				gv(RC_INT);
			} else {
				gv_dup();
				vpushi(31);
				gen_op(TOK_SAR);
			}
			lbuild(dbt);
		} else if (ss == 8) {
			/* from long long: just take low order word */

			lexpand();
			vpop();
		}
		ss = 4;

#elif PTR_SIZE == 8
// 3378 "tccgen.c"
		if (ds == 8) {
			/* need to convert from 32bit to 64bit */

			if (sbt & VT_UNSIGNED) {

				goto done;

			} else {
				gen_cvt_sxtw();
				goto done;
			}
			ss = ds, ds = 4, dbt = sbt;
		} else if (ss == 8) {
			/* RISC-V keeps 32bit vals in registers sign-extended.
			               So here we need a sign-extension for signed types and
			               zero-extension. for unsigned types. */

			trunc = 32;/* zero upper 32 bits for non RISC-V targets */

		} else {
			ss = 4;
		}
#endif

		if (ds >= ss)
			goto done;

		if (ss == 4) {
			gen_cvt_csti(dbt);
			goto done;
		}

		bits = (ss - ds) * 8;
		/* for unsigned, gen_op will convert SAR to SHR */

		vtop->type.t = (ss == 8 ? VT_LLONG : VT_INT) | (dbt & VT_UNSIGNED);
		vpushi(bits);
		gen_op(TOK_SHL);
		vpushi(bits - trunc);
		gen_op(TOK_SAR);
		vpushi(trunc);
		gen_op(TOK_SHR);
	}
done:
	vtop->type = *type;
	vtop->type.t &= ~ ( VT_CONSTANT | VT_VOLATILE | VT_ARRAY );
}
/* return type size as known at compile time. Put alignment at 'a' */

ST_FUNC int type_size(CType *type, int *a)
{
	Sym *s;
	int bt;

	bt = type->t & VT_BTYPE;
	if (bt == VT_STRUCT) {
		/* struct/union */

		s = type->ref;
		*a = s->r;
		return s->c;
	} else if (bt == VT_PTR) {
		if (type->t & VT_ARRAY) {
			int ts;
			s = type->ref;
			ts = type_size(&s->type, a);
			if (ts < 0 && s->c < 0)
				ts = -ts;
			return ts * s->c;
		} else {
			*a = PTR_SIZE;
			return PTR_SIZE;
		}
	} else if (IS_ENUM(type->t) && type->ref->c < 0) {
		*a = 0;
		return -1;/* incomplete enum */

	} else if (bt == VT_LDOUBLE) {
		*a = LDOUBLE_ALIGN;
		return LDOUBLE_SIZE;
	} else if (bt == VT_DOUBLE || bt == VT_LLONG) {

		*a = 8;

		return 8;
	} else if (bt == VT_INT || bt == VT_FLOAT) {
		*a = 4;
		return 4;
	} else if (bt == VT_SHORT) {
		*a = 2;
		return 2;
	} else if (bt == VT_QLONG || bt == VT_QFLOAT) {
		*a = 8;
		return 16;
	} else {
		/* char, void, function, _Bool */

		*a = 1;
		return 1;
	}
}
/* push type size as known at runtime time on top of value stack. Put
   alignment at 'a' */

static void vpush_type_size(CType *type, int *a)
{
	if (type->t & VT_VLA) {
		type_size(&type->ref->type, a);
		vset(&int_type, VT_LOCAL|VT_LVAL, type->ref->c);
	} else {
		int size = type_size(type, a);
		if (size < 0)
			tcc_error("unknown type size");
		vpushs(size);
	}
}
/* return the pointed type of t */

static inline CType *pointed_type(CType *type)
{
	return &type->ref->type;
}
/* modify type so that its it is a pointer to type. */

ST_FUNC void mk_pointer(CType *type)
{
	Sym *s;
	s = sym_push(SYM_FIELD, type, 0, -1);
	type->t = VT_PTR | (type->t & VT_STORAGE);
	type->ref = s;
}
/* return true if type1 and type2 are exactly the same (including
   qualifiers).
*/

static int is_compatible_types(CType *type1, CType *type2)
{
	return compare_types(type1,type2,0);
}
/* return true if type1 and type2 are the same (ignoring qualifiers).
*/

static int is_compatible_unqualified_types(CType *type1, CType *type2)
{
	return compare_types(type1,type2,1);
}

static void cast_error(CType *st, CType *dt)
{
	type_incompatibility_error(st, dt, "cannot convert '%s' to '%s'");
}
/* verify type compatibility to store vtop in 'dt' type */

static void verify_assign_cast(CType *dt)
{
	CType *st, *type1, *type2;
	int dbt, sbt, qualwarn, lvl;

	st = &vtop->type;/* source type */

	dbt = dt->t & VT_BTYPE;
	sbt = st->t & VT_BTYPE;
	if (dt->t & VT_CONSTANT)
		tcc_warning("assignment of read-only location");
	switch (dbt) {
	case VT_VOID:
		if (sbt != dbt)
			tcc_error("assignment to void expression");
		break;
	case VT_PTR:
		/* special cases for pointers */
		/* '0' can also be a pointer */

		if (is_null_pointer(vtop))
			break;
		/* accept implicit pointer to integer cast with warning */

		if (is_integer_btype(sbt)) {
			tcc_warning("assignment makes pointer from integer without a cast");
			break;
		}
		type1 = pointed_type(dt);
		if (sbt == VT_PTR)
			type2 = pointed_type(st);
		else if (sbt == VT_FUNC)
			type2 = st;/* a function is implicitly a function pointer */

		else
			goto error;
		if (is_compatible_types(type1, type2))
			break;
		for (qualwarn = lvl = 0;; ++lvl) {
			if (((type2->t & VT_CONSTANT) && !(type1->t & VT_CONSTANT)) ||
			    ((type2->t & VT_VOLATILE) && !(type1->t & VT_VOLATILE)))
				qualwarn = 1;
			dbt = type1->t & (VT_BTYPE|VT_LONG);
			sbt = type2->t & (VT_BTYPE|VT_LONG);
			if (dbt != VT_PTR || sbt != VT_PTR)
				break;
			type1 = pointed_type(type1);
			type2 = pointed_type(type2);
		}
		if (!is_compatible_unqualified_types(type1, type2)) {
			if ((dbt == VT_VOID || sbt == VT_VOID) && lvl == 0) {
				/* void * can match anything */

			} else if (dbt == sbt
				   && is_integer_btype(sbt & VT_BTYPE)
				   && IS_ENUM(type1->t) + IS_ENUM(type2->t)
				   + !!((type1->t ^ type2->t) & VT_UNSIGNED) < 2) {
				/* Like GCC don't warn by default for merely changes
						   in pointer target signedness.  Do warn for different
						   base types, though, in particular for unsigned enums
						   and signed int targets.  */

			} else {
				tcc_warning("assignment from incompatible pointer type");
				break;
			}
		}
		if (qualwarn)
			tcc_warning_c(warn_discarded_qualifiers)
			("assignment discards qualifiers from pointer target type");
		break;
	case VT_BYTE:
	case VT_SHORT:
	case VT_INT:
	case VT_LLONG:
		if (sbt == VT_PTR || sbt == VT_FUNC) {
			tcc_warning("assignment makes integer from pointer without a cast");
		} else if (sbt == VT_STRUCT) {
			goto case_VT_STRUCT;
		}
		/* XXX: more tests */

		break;
	case VT_STRUCT:
case_VT_STRUCT:
		if (!is_compatible_unqualified_types(dt, st)) {
error:
			cast_error(st, dt);
		}
		break;
	}
}

static void gen_assign_cast(CType *dt)
{
	verify_assign_cast(dt);
	gen_cast(dt);
}
/* store vtop in lvalue pushed on stack */

ST_FUNC void vstore(void)
{
	int sbt, dbt, ft, r, size, align, bit_size, bit_pos, delayed_cast;

	ft = vtop[-1].type.t;
	sbt = vtop->type.t & VT_BTYPE;
	dbt = ft & VT_BTYPE;
	verify_assign_cast(&vtop[-1].type);

	if (sbt == VT_STRUCT) {
		/* if structure, only generate pointer */
		/* structure assignment : generate memcpy */

		size = type_size(&vtop->type, &align);
		/* destination, keep on stack() as result */

		vpushv(vtop - 1);
#ifdef CONFIG_TCC_BCHECK

		if (vtop->r & VT_MUSTBOUND)
			gbound(); /* check would be wrong after gaddrof() */

#endif

		vtop->type.t = VT_PTR;
		gaddrof();
		/* source */

		vswap();
#ifdef CONFIG_TCC_BCHECK

		if (vtop->r & VT_MUSTBOUND)
			gbound();
#endif

		vtop->type.t = VT_PTR;
		gaddrof();
#ifdef TCC_TARGET_NATIVE_STRUCT_COPY

		if (1
#ifdef CONFIG_TCC_BCHECK

		    && !tcc_state->do_bounds_check
#endif

		   ) {
			gen_struct_copy(size);
		} else
#endif

		{
			/* type size */

			vpushi(size);
			/* Use memmove, rather than memcpy, as dest and src may be same: */
// 3675 "tccgen.c"
			vpush_helper_func(TOK_memmove);
			vrott(4);
			gfunc_call(3);
		}

	} else if (ft & VT_BITFIELD) {
		/* bitfield store handling */
		/* save lvalue as expression result (example: s.b = s.a = n;) */

		vdup(), vtop[-1] = vtop[-2];

		bit_pos = BIT_POS(ft);
		bit_size = BIT_SIZE(ft);
		/* remove bit field info to avoid loops */

		vtop[-1].type.t = ft & ~VT_STRUCT_MASK;

		if (dbt == VT_BOOL) {
			gen_cast(&vtop[-1].type);
			vtop[-1].type.t = (vtop[-1].type.t & ~VT_BTYPE) | (VT_BYTE | VT_UNSIGNED);
		}
		r = adjust_bf(vtop - 1, bit_pos, bit_size);
		if (dbt != VT_BOOL) {
			gen_cast(&vtop[-1].type);
			dbt = vtop[-1].type.t & VT_BTYPE;
		}
		if (r == VT_STRUCT) {
			store_packed_bf(bit_pos, bit_size);
		} else {
			unsigned long long mask = (1ULL << bit_size) - 1;
			if (dbt != VT_BOOL) {
				/* mask source */

				if (dbt == VT_LLONG)
					vpushll(mask);
				else
					vpushi((unsigned)mask);
				gen_op('&');
			}
			/* shift source */

			vpushi(bit_pos);
			gen_op(TOK_SHL);
			vswap();
			/* duplicate destination */

			vdup();
			vrott(3);
			/* load destination, mask and or with source */

			if (dbt == VT_LLONG)
				vpushll(~(mask << bit_pos));
			else
				vpushi(~((unsigned)mask << bit_pos));
			gen_op('&');
			gen_op('|');
			/* store result */

			vstore();
			/* ... and discard */

			vpop();
		}
	} else if (dbt == VT_VOID) {
		--vtop;
	} else {
		/* optimize char/short casts */

		delayed_cast = 0;
		if ((dbt == VT_BYTE || dbt == VT_SHORT)
		    && is_integer_btype(sbt)
		   ) {
			if ((vtop->r & VT_MUSTCAST)
			    && btype_size(dbt) > btype_size(sbt)
			   )
				force_charshort_cast();
			delayed_cast = 1;
		} else {
			gen_cast(&vtop[-1].type);
		}
#ifdef CONFIG_TCC_BCHECK

		/* bound check case */

		if (vtop[-1].r & VT_MUSTBOUND) {
			vswap();
			gbound();
			vswap();
		}
#endif
// 3756 "tccgen.c"
		gv(RC_TYPE(dbt));/* generate value */

		if (delayed_cast) {
			vtop->r |= BFVAL(VT_MUSTCAST, (sbt == VT_LLONG) + 1);
//tcc_warning("deley cast %x -> %x", sbt, dbt);

			vtop->type.t = ft & VT_TYPE;
		}
		/* if lvalue was saved on stack, must read it */

		if ((vtop[-1].r & VT_VALMASK) == VT_LLOCAL) {
			SValue sv;
			r = get_reg(RC_INT);
			sv.type.t = VT_PTRDIFF_T;
			sv.r = VT_LOCAL | VT_LVAL;
			sv.c.i = vtop[-1].c.i;
			load(r, &sv);
			vtop[-1].r = r | VT_LVAL;
		}

		r = vtop->r & VT_VALMASK;
		/* two word case handling :
		               store second register at word + 4 (or +8 for x86-64)  */

		if (USING_TWO_WORDS(dbt)) {
			int load_type = (dbt == VT_QFLOAT) ? VT_DOUBLE : VT_PTRDIFF_T;
			vtop[-1].type.t = load_type;
			store(r, vtop - 1);
			vswap();
			incr_offset(PTR_SIZE);
			vswap();
			/* XXX: it works because r2 is spilled last ! */

			store(vtop->r2, vtop - 1);
		} else {
			/* single word */

			store(r, vtop - 1);
		}
		vswap();
		vtop--;/* NOT vpop() because on x86 it would flush the fp stack */

	}
}
/* post defines POST/PRE add. c is the token ++ or -- */

ST_FUNC void inc(int post, int c)
{
	test_lvalue();
	vdup();/* save lvalue */

	if (post) {
		gv_dup();/* duplicate value */

		vrotb(3);
		vrotb(3);
	}
	/* add constant */

	vpushi(c - TOK_MID);
	gen_op('+');
	vstore();/* store value */

	if (post)
		vpop();/* if post op, return saved value */

}

ST_FUNC CString *parse_mult_str (const char *msg)
{
	/* read the string */

	if (tok != TOK_STR)
		expect(msg);
	cstr_reset(&initstr);
	while (tok == TOK_STR) {
		/* XXX: add \0 handling too ? */

		cstr_cat(&initstr, tokc.str.data, -1);
		next();
	}
	cstr_ccat(&initstr, '\0');
	return &initstr;
}
/* If I is >= 1 and a power of two, returns log2(i)+1.
   If I is 0 returns 0.  */

ST_FUNC int exact_log2p1(int i)
{
	int ret;
	if (!i)
		return 0;
	for (ret = 1; i >= 1 << 8; ret += 8)
		i >>= 8;
	if (i >= 1 << 4)
		ret += 4, i >>= 4;
	if (i >= 1 << 2)
		ret += 2, i >>= 2;
	if (i >= 1 << 1)
		ret++;
	return ret;
}
/* Parse __attribute__((...)) GNUC extension. */

static void parse_attribute(AttributeDef *ad)
{
	int t, n;
	char *astr;

redo:
	if (tok != TOK_ATTRIBUTE1 && tok != TOK_ATTRIBUTE2)
		return;
	next();
	skip('(');
	skip('(');
	while (tok != ')') {
		if (tok < TOK_IDENT)
			expect("attribute name");
		t = tok;
		next();
		switch (t) {
		case TOK_CLEANUP1:
		case TOK_CLEANUP2: {
			Sym *s;

			skip('(');
			s = sym_find(tok);
			if (!s) {
				tcc_warning_c(warn_implicit_function_declaration)(
					"implicit declaration of function '%s'", get_tok_str(tok, &tokc));
				s = external_global_sym(tok, &func_old_type);
			} else if ((s->type.t & VT_BTYPE) != VT_FUNC)
				tcc_error("'%s' is not declared as function", get_tok_str(tok, &tokc));
			ad->cleanup_func = s;
			next();
			skip(')');
			break;
		}
		case TOK_CONSTRUCTOR1:
		case TOK_CONSTRUCTOR2:
			ad->f.func_ctor = 1;
			break;
		case TOK_DESTRUCTOR1:
		case TOK_DESTRUCTOR2:
			ad->f.func_dtor = 1;
			break;
		case TOK_ALWAYS_INLINE1:
		case TOK_ALWAYS_INLINE2:
			ad->f.func_alwinl = 1;
			break;
		case TOK_SECTION1:
		case TOK_SECTION2:
			skip('(');
			astr = parse_mult_str("section name")->data;
			ad->section = find_section(tcc_state, astr);
			skip(')');
			break;
		case TOK_ALIAS1:
		case TOK_ALIAS2:
			skip('(');
			astr = parse_mult_str("alias(\"target\")")->data;
			/* save string as token, for later */

			ad->alias_target = tok_alloc_const(astr);
			skip(')');
			break;
		case TOK_VISIBILITY1:
		case TOK_VISIBILITY2:
			skip('(');
			astr = parse_mult_str("visibility(\"default|hidden|internal|protected\")")->data;
			if (!strcmp (astr, "default"))
				ad->a.visibility = STV_DEFAULT;
			else if (!strcmp (astr, "hidden"))
				ad->a.visibility = STV_HIDDEN;
			else if (!strcmp (astr, "internal"))
				ad->a.visibility = STV_INTERNAL;
			else if (!strcmp (astr, "protected"))
				ad->a.visibility = STV_PROTECTED;
			else
				expect("visibility(\"default|hidden|internal|protected\")");
			skip(')');
			break;
		case TOK_ALIGNED1:
		case TOK_ALIGNED2:
			if (tok == '(') {
				next();
				n = expr_const();
				if (n <= 0 || (n & (n - 1)) != 0)
					tcc_error("alignment must be a positive power of two");
				skip(')');
			} else {
				n = MAX_ALIGN;
			}
			ad->a.aligned = exact_log2p1(n);
			if (n != 1 << (ad->a.aligned - 1))
				tcc_error("alignment of %d is larger than implemented", n);
			break;
		case TOK_PACKED1:
		case TOK_PACKED2:
			ad->a.packed = 1;
			break;
		case TOK_WEAK1:
		case TOK_WEAK2:
			ad->a.weak = 1;
			break;
		case TOK_NODEBUG1:
		case TOK_NODEBUG2:
			ad->a.nodebug = 1;
			break;
		case TOK_UNUSED1:
		case TOK_UNUSED2:
			/* currently, no need to handle it because tcc does not
			               track unused objects */

			break;
		case TOK_NORETURN1:
		case TOK_NORETURN2:
			ad->f.func_noreturn = 1;
			break;
		case TOK_CDECL1:
		case TOK_CDECL2:
		case TOK_CDECL3:
			ad->f.func_call = FUNC_CDECL;
			break;
		case TOK_STDCALL1:
		case TOK_STDCALL2:
		case TOK_STDCALL3:
			ad->f.func_call = FUNC_STDCALL;
			break;
// 3996 "tccgen.c"
		case TOK_MODE:
			skip('(');
			switch (tok) {
			case TOK_MODE_DI:
				ad->attr_mode = VT_LLONG + 1;
				break;
			case TOK_MODE_QI:
				ad->attr_mode = VT_BYTE + 1;
				break;
			case TOK_MODE_HI:
				ad->attr_mode = VT_SHORT + 1;
				break;
			case TOK_MODE_SI:
			case TOK_MODE_word:
				ad->attr_mode = VT_INT + 1;
				break;
			default:
				tcc_warning("__mode__(%s) not supported\n", get_tok_str(tok, NULL));
				break;
			}
			next();
			skip(')');
			break;
		case TOK_DLLEXPORT:
			ad->a.dllexport = 1;
			break;
		case TOK_NODECORATE:
			ad->a.nodecorate = 1;
			break;
		case TOK_DLLIMPORT:
			ad->a.dllimport = 1;
			break;
		default:
			tcc_warning_c(warn_unsupported)("'%s' attribute ignored", get_tok_str(t, NULL));
			/* skip parameters */

			if (tok == '(') {
				int parenthesis = 0;
				do {
					if (tok == '(')
						parenthesis++;
					else if (tok == ')')
						parenthesis--;
					next();
				} while (parenthesis && tok != -1);
			}
			break;
		}
		if (tok != ',')
			break;
		next();
	}
	skip(')');
	skip(')');
	goto redo;
}

static Sym *find_field (CType *type, int v, int *cumofs)
{
	Sym *s = type->ref;
	int v1 = v | SYM_FIELD;
	if (!(v & SYM_FIELD)) {/* top-level call */

		if ((type->t & VT_BTYPE) != VT_STRUCT)
			expect("struct or union");
		if (v < TOK_UIDENT)
			expect("field name");
		if (s->c < 0)
			tcc_error("dereferencing incomplete type '%s'",
				  get_tok_str(s->v & ~SYM_STRUCT, 0));
	}
	while ((s = s->next) != NULL) {
		if (s->v == v1) {
			*cumofs = s->c;
			return s;
		}
		if ((s->type.t & VT_BTYPE) == VT_STRUCT
		    && s->v >= (SYM_FIRST_ANOM | SYM_FIELD)) {
			/* try to find field in anonymous sub-struct/union */

			Sym *ret = find_field (&s->type, v1, cumofs);
			if (ret) {
				*cumofs += s->c;
				return ret;
			}
		}
	}
	if (!(v & SYM_FIELD))
		tcc_error("field not found: %s", get_tok_str(v, NULL));
	return s;
}

static void check_fields (CType *type, int check)
{
	Sym *s = type->ref;

	while ((s = s->next) != NULL) {
		int v = s->v & ~SYM_FIELD;
		if (v < SYM_FIRST_ANOM) {
			TokenSym *ts = table_ident[v - TOK_IDENT];
			if (check && (ts->tok & SYM_FIELD))
				tcc_error("duplicate member '%s'", get_tok_str(v, NULL));
			ts->tok ^= SYM_FIELD;
		} else if ((s->type.t & VT_BTYPE) == VT_STRUCT)
			check_fields (&s->type, check);
	}
}

static void struct_layout(CType *type, AttributeDef *ad)
{
	int size, align, maxalign, offset, c, bit_pos, bit_size;
	int packed, a, bt, prevbt, prev_bit_size;
	int pcc = !tcc_state->ms_bitfields;
	int pragma_pack = *tcc_state->pack_stack_ptr;
	Sym *f;

	maxalign = 1;
	offset = 0;
	c = 0;
	bit_pos = 0;
	prevbt = VT_STRUCT;/* make it never match */

	prev_bit_size = 0;
//#define BF_DEBUG

	for (f = type->ref->next; f; f = f->next) {
		if (f->type.t & VT_BITFIELD)
			bit_size = BIT_SIZE(f->type.t);
		else
			bit_size = -1;
		size = type_size(&f->type, &align);
		a = f->a.aligned ? 1 << (f->a.aligned - 1) : 0;
		packed = 0;

		if (pcc && bit_size == 0) {
			/* in pcc mode, packing does not affect zero-width bitfields */

		} else {
			/* in pcc mode, attribute packed overrides if set. */

			if (pcc && (f->a.packed || ad->a.packed))
				align = packed = 1;
			/* pragma pack overrides align if lesser and packs bitfields always */

			if (pragma_pack) {
				packed = 1;
				if (pragma_pack < align)
					align = pragma_pack;
				/* in pcc mode pragma pack also overrides individual align */

				if (pcc && pragma_pack < a)
					a = 0;
			}
		}
		/* some individual align was specified */

		if (a)
			align = a;

		if (type->ref->type.t == VT_UNION) {
			if (pcc && bit_size >= 0)
				size = (bit_size + 7) >> 3;
			offset = 0;
			if (size > c)
				c = size;

		} else if (bit_size < 0) {
			if (pcc)
				c += (bit_pos + 7) >> 3;
			c = (c + align - 1) & -align;
			offset = c;
			if (size > 0)
				c += size;
			bit_pos = 0;
			prevbt = VT_STRUCT;
			prev_bit_size = 0;

		} else {
			/* A bit-field.  Layout is more complicated.  There are two
				       options: PCC (GCC) compatible and MS compatible */

			if (pcc) {
				/* In PCC layout a bit-field is placed adjacent to the
				                   preceding bit-fields, except if:
				                   - it has zero-width
				                   - an individual alignment was given
				                   - it would overflow its base type container and
				                     there is no packing */

				if (bit_size == 0) {
new_field:
					c = (c + ((bit_pos + 7) >> 3) + align - 1) & -align;
					bit_pos = 0;
				} else if (f->a.aligned) {
					goto new_field;
				} else if (!packed) {
					int a8 = align * 8;
					int ofs = ((c * 8 + bit_pos) % a8 + bit_size + a8 - 1) / a8;
					if (ofs > size / align)
						goto new_field;
				}
				/* in pcc mode, long long bitfields have type int if they fit */

				if (size == 8 && bit_size <= 32)
					f->type.t = (f->type.t & ~VT_BTYPE) | VT_INT, size = 4;

				while (bit_pos >= align * 8)
					c += align, bit_pos -= align * 8;
				offset = c;
				/* In PCC layout named bit-fields influence the alignment
						   of the containing struct using the base types alignment,
						   except for packed fields (which here have correct align).  \*/

				if (f->v & SYM_FIRST_ANOM
// && bit_size // ??? gcc on ARM/rpi does that

				   )
					align = 1;

			} else {
				bt = f->type.t & VT_BTYPE;
				if ((bit_pos + bit_size > size * 8)
				    || (bit_size > 0) == (bt != prevbt)
				   ) {
					c = (c + align - 1) & -align;
					offset = c;
					bit_pos = 0;
					/* In MS bitfield mode a bit-field run always uses
							       at least as many bits as the underlying type.
							       To start a new run it's also required that this
							       or the last bit-field had non-zero width.  */

					if (bit_size || prev_bit_size)
						c += size;
				}
				/* In MS layout the records alignment is normally
						   influenced by the field, except for a zero-width
						   field at the start of a run (but by further zero-width
						   fields it is again).  */

				if (bit_size == 0 && prevbt != bt)
					align = 1;
				prevbt = bt;
				prev_bit_size = bit_size;
			}

			f->type.t = (f->type.t & ~(0x3f << VT_STRUCT_SHIFT))
				    | (bit_pos << VT_STRUCT_SHIFT);
			bit_pos += bit_size;
		}
		if (align > maxalign)
			maxalign = align;
#ifdef BF_DEBUG

		printf("set field %s offset %-2d size %-2d align %-2d",
		       get_tok_str(f->v & ~SYM_FIELD, NULL), offset, size, align);
		if (f->type.t & VT_BITFIELD) {
			printf(" pos %-2d bits %-2d",
			       BIT_POS(f->type.t),
			       BIT_SIZE(f->type.t)
			      );
		}
		printf("\n");
#endif
// 4250 "tccgen.c"
		f->c = offset;
		f->r = 0;
	}

	if (pcc)
		c += (bit_pos + 7) >> 3;
	/* store size and alignment */

	a = bt = ad->a.aligned ? 1 << (ad->a.aligned - 1) : 1;
	if (a < maxalign)
		a = maxalign;
	type->ref->r = a;
	if (pragma_pack && pragma_pack < maxalign && 0 == pcc) {
		/* can happen if individual align for some member was given.  In
		           this case MSVC ignores maxalign when aligning the size */

		a = pragma_pack;
		if (a < bt)
			a = bt;
	}
	c = (c + a - 1) & -a;
	type->ref->c = c;
#ifdef BF_DEBUG

	printf("struct size %-2d align %-2d\n\n", c, a), fflush(stdout);
#endif
	/* check whether we can access bitfields by their type */

	for (f = type->ref->next; f; f = f->next) {
		int s, px, cx, c0;
		CType t;

		if (0 == (f->type.t & VT_BITFIELD))
			continue;
		f->type.ref = f;
		f->auxtype = -1;
		bit_size = BIT_SIZE(f->type.t);
		if (bit_size == 0)
			continue;
		bit_pos = BIT_POS(f->type.t);
		size = type_size(&f->type, &align);

		if (bit_pos + bit_size <= size * 8 && f->c + size <= c

		   )
			continue;
		/* try to access the field using a different type */

		c0 = -1, s = align = 1;
		t.t = VT_BYTE;
		for (;;) {
			px = f->c * 8 + bit_pos;
			cx = (px >> 3) & -align;
			px = px - (cx << 3);
			if (c0 == cx)
				break;
			s = (px + bit_size + 7) >> 3;
			if (s > 4) {
				t.t = VT_LLONG;
			} else if (s > 2) {
				t.t = VT_INT;
			} else if (s > 1) {
				t.t = VT_SHORT;
			} else {
				t.t = VT_BYTE;
			}
			s = type_size(&t, &align);
			c0 = cx;
		}

		if (px + bit_size <= s * 8 && cx + s <= c

		   ) {
			/* update offset and bit position */

			f->c = cx;
			bit_pos = px;
			f->type.t = (f->type.t & ~(0x3f << VT_STRUCT_SHIFT))
				    | (bit_pos << VT_STRUCT_SHIFT);
			if (s != size)
				f->auxtype = t.t;
#ifdef BF_DEBUG

			printf("FIX field %s offset %-2d size %-2d align %-2d "
			       "pos %-2d bits %-2d\n",
			       get_tok_str(f->v & ~SYM_FIELD, NULL),
			       cx, s, align, px, bit_size);
#endif

		} else {
			/* fall back to load/store single-byte wise */

			f->auxtype = VT_STRUCT;
#ifdef BF_DEBUG

			printf("FIX field %s : load byte-wise\n",
			       get_tok_str(f->v & ~SYM_FIELD, NULL));
#endif

		}
	}
}
/* enum/struct/union declaration. u is VT_ENUM/VT_STRUCT/VT_UNION */

static void struct_decl(CType *type, int u)
{
	int v, c, size, align, flexible;
	int bit_size, bsize, bt, ut;
	Sym *s, *ss, **ps;
	AttributeDef ad, ad1;
	CType type1, btype;

	memset(&ad, 0, sizeof ad);
	next();
	parse_attribute(&ad);

	v = 0;
	if (tok >= TOK_IDENT)/* struct/enum tag */

		v = tok, next();

	bt = ut = 0;
	if (u == VT_ENUM) {
		ut = VT_INT;
		if (tok == ':') {/* C2x enum : <type> ... */

			next();
			if (!parse_btype(&btype, &ad1, 0)
			    || !is_integer_btype(btype.t & VT_BTYPE))
				expect("enum type");
			bt = ut = btype.t & (VT_BTYPE|VT_LONG|VT_UNSIGNED|VT_DEFSIGN);
		}
	}

	if (v) {
		/* struct already defined ? return it */

		s = struct_find(v);
		if (s && (s->sym_scope == local_scope || (tok != '{' && tok != ';'))) {
			if (u == s->type.t)
				goto do_decl;
			if (u == VT_ENUM && IS_ENUM(s->type.t))/* XXX: check integral types */

				goto do_decl;
			tcc_error("redeclaration of '%s'", get_tok_str(v, NULL));
		}
	} else {
		if (tok != '{')
			expect("struct/union/enum name");
		v = anon_sym++;
	}
	/* Record the original enum/struct/union token.  */

	type1.t = u | ut;
	type1.ref = NULL;
	/* we put an undefined size for struct/union */

	s = sym_push(v | SYM_STRUCT, &type1, 0, bt ? 0 : -1);
	s->r = 0;/* default alignment is zero as gcc */

do_decl:
	type->t = s->type.t;
	type->ref = s;

	if (tok == '{') {
		next();
		if (s->c != -1
		    && !(u == VT_ENUM && s->c == 0))/* not yet defined typed enum */

			tcc_error("struct/union/enum already defined");
		s->c = -2;
		/* cannot be empty */
		/* non empty enums are not allowed */

		ps = &s->next;
		if (u == VT_ENUM) {
			long long ll = 0, pl = 0, nl = 0;
			CType t;
			t.ref = s;
			/* enum symbols have static storage */

			t.t = VT_INT|VT_STATIC|VT_ENUM_VAL;
			if (bt)
				t.t = bt|VT_STATIC|VT_ENUM_VAL;
			for (;;) {
				v = tok;
				if (v < TOK_UIDENT)
					expect("identifier");
				ss = sym_find(v);
				if (ss && !local_stack)
					tcc_error("redefinition of enumerator '%s'",
						  get_tok_str(v, NULL));
				next();
				if (tok == '=') {
					next();
					ll = expr_const64();
				}
				ss = sym_push(v, &t, VT_CONST, 0);
				ss->enum_val = ll;
				*ps = ss, ps = &ss->next;
				if (ll < nl)
					nl = ll;
				if (ll > pl)
					pl = ll;
				if (tok != ',')
					break;
				next();
				ll++;
				/* NOTE: we accept a trailing comma */

				if (tok == '}')
					break;
			}
			skip('}');

			if (bt) {
				t.t = bt;
				s->c = 2;
				goto enum_done;
			}
			/* set integral type of the enum */

			t.t = VT_INT;
			if (nl >= 0) {
				if (pl != (unsigned)pl)
					t.t = (LONG_SIZE==8 ? VT_LLONG|VT_LONG : VT_LLONG);
				t.t |= VT_UNSIGNED;
			} else if (pl != (int)pl || nl != (int)nl)
				t.t = (LONG_SIZE==8 ? VT_LLONG|VT_LONG : VT_LLONG);
			/* set type for enum members */

			for (ss = s->next; ss; ss = ss->next) {
				ll = ss->enum_val;
				if (ll == (int)ll)/* default is int if it fits */

					continue;
				if (t.t & VT_UNSIGNED) {
					ss->type.t |= VT_UNSIGNED;
					if (ll == (unsigned)ll)
						continue;
				}
				ss->type.t = (ss->type.t & ~VT_BTYPE)
					     | (LONG_SIZE==8 ? VT_LLONG|VT_LONG : VT_LLONG);
			}
			s->c = 1;
enum_done:
			s->type.t = type->t = t.t | VT_ENUM;

		} else {
			c = 0;
			flexible = 0;
			while (tok != '}') {
				if (!parse_btype(&btype, &ad1, 0)) {
					if (tok == TOK_STATIC_ASSERT) {
						do_Static_assert();
						continue;
					}
					skip(';');
					continue;
				}
				while (1) {
					if (flexible)
						tcc_error("flexible array member '%s' not at the end of struct",
							  get_tok_str(v, NULL));
					bit_size = -1;
					v = 0;
					type1 = btype;
					if (tok != ':') {
						if (tok != ';')
							type_decl(&type1, &ad1, &v, TYPE_DIRECT);
						if (v == 0) {
							if ((type1.t & VT_BTYPE) != VT_STRUCT)
								expect("identifier");
							else {
								int v = btype.ref->v;
								if (!(v & SYM_FIELD) && (v & ~SYM_STRUCT) < SYM_FIRST_ANOM) {
									if (tcc_state->ms_extensions == 0)
										expect("identifier");
								}
							}
						}
						if (type_size(&type1, &align) < 0) {
							if ((u == VT_STRUCT) && (type1.t & VT_ARRAY) && c)
								flexible = 1;
							else
								tcc_error("field '%s' has incomplete type",
									  get_tok_str(v, NULL));
						}
						if ((type1.t & VT_BTYPE) == VT_FUNC ||
						    (type1.t & VT_BTYPE) == VT_VOID ||
						    (type1.t & VT_STORAGE))
							tcc_error("invalid type for '%s'",
								  get_tok_str(v, NULL));
					}
					if (tok == ':') {
						next();
						bit_size = expr_const();
						/* XXX: handle v = 0 case for messages */

						if (bit_size < 0)
							tcc_error("negative width in bit-field '%s'",
								  get_tok_str(v, NULL));
						if (v && bit_size == 0)
							tcc_error("zero width for bit-field '%s'",
								  get_tok_str(v, NULL));
						parse_attribute(&ad1);
					}
					size = type_size(&type1, &align);
					if (bit_size >= 0) {
						bt = type1.t & VT_BTYPE;
						if (bt != VT_INT &&
						    bt != VT_BYTE &&
						    bt != VT_SHORT &&
						    bt != VT_BOOL &&
						    bt != VT_LLONG)
							tcc_error("bitfields must have scalar type");
						bsize = size * 8;
						if (bit_size > bsize) {
							tcc_error("width of '%s' exceeds its type",
								  get_tok_str(v, NULL));
						} else if (bit_size == bsize
							   && !ad.a.packed && !ad1.a.packed) {
							/* no need for bit fields */

							;
						} else if (bit_size == 64) {
							tcc_error("field width 64 not implemented");
						} else {
							type1.t = (type1.t & ~VT_STRUCT_MASK)
								  | VT_BITFIELD
								  | (bit_size << (VT_STRUCT_SHIFT + 6));
						}
					}
					if (v != 0 || (type1.t & VT_BTYPE) == VT_STRUCT) {
						/* Remember we've seen a real field to check
									   for placement of flexible array member. */

						c = 1;
					}
					/* If member is a struct or bit-field, enforce
							       placing into the struct (as anonymous).  */

					if (v == 0 &&
					    ((type1.t & VT_BTYPE) == VT_STRUCT ||
					     bit_size >= 0)) {
						v = anon_sym++;
					}
					if (v) {
						ss = sym_push(v | SYM_FIELD, &type1, 0, 0);
						ss->a = ad1.a;
						*ps = ss;
						ps = &ss->next;
					}
					if (tok == ';' || tok == TOK_EOF)
						break;
					skip(',');
				}
				skip(';');
			}
			skip('}');
			parse_attribute(&ad);
			if (ad.cleanup_func) {
				tcc_warning("attribute '__cleanup__' ignored on type");
			}
			check_fields(type, 1);
			check_fields(type, 0);
			struct_layout(type, &ad);
			if (debug_modes)
				tcc_debug_fix_anon(tcc_state, type);
		}
	}
}

static void sym_to_attr(AttributeDef *ad, Sym *s)
{
	merge_symattr(&ad->a, &s->a);
	merge_funcattr(&ad->f, &s->f);
}
/* Add type qualifiers to a type. If the type is an array then the qualifiers
   are added to the element type, copied because it could be a typedef. */

static void parse_btype_qualify(CType *type, int qualifiers)
{
	while (type->t & VT_ARRAY) {
		type->ref = sym_push(SYM_FIELD, &type->ref->type, 0, type->ref->c);
		type = &type->ref->type;
	}
	type->t |= qualifiers;
}
/* return 0 if no type declaration. otherwise, return the basic type
   and skip it.
 */

static int parse_btype(CType *type, AttributeDef *ad, int ignore_label)
{
	int t, u, bt, st, type_found, typespec_found, g, n;
	Sym *s;
	CType type1;

	memset(ad, 0, sizeof(AttributeDef));
	type_found = 0;
	typespec_found = 0;
	t = VT_INT;
	bt = st = -1;
	type->ref = NULL;

	while (1) {
		switch (tok) {
		case TOK_EXTENSION:
			/* currently, we really ignore extension */

			next();
			continue;
		/* basic types */

		case TOK_CHAR:
			u = VT_BYTE;
basic_type:
			next();
basic_type1:
			if (u == VT_SHORT || u == VT_LONG) {
				if (st != -1 || (bt != -1 && bt != VT_INT))
tmbt: tcc_error("too many basic types");
				st = u;
			} else {
				if (bt != -1 || (st != -1 && u != VT_INT))
					goto tmbt;
				bt = u;
			}
			if (u != VT_INT)
				t = (t & ~(VT_BTYPE|VT_LONG)) | u;
			typespec_found = 1;
			break;
		case TOK_VOID:
			u = VT_VOID;
			goto basic_type;
		case TOK_SHORT:
			u = VT_SHORT;
			goto basic_type;
		case TOK_INT:
			u = VT_INT;
			goto basic_type;
		case TOK_ALIGNAS: {
			int n;
			AttributeDef ad1;
			next();
			skip('(');
			memset(&ad1, 0, sizeof(AttributeDef));
			if (parse_btype(&type1, &ad1, 0)) {
				type_decl(&type1, &ad1, &n, TYPE_ABSTRACT);
				if (ad1.a.aligned)
					n = 1 << (ad1.a.aligned - 1);
				else
					type_size(&type1, &n);
			} else {
				n = expr_const();
				if (n < 0 || (n & (n - 1)) != 0)
					tcc_error("alignment must be a positive power of two");
			}
			skip(')');
			ad->a.aligned = exact_log2p1(n);
		}
		continue;
		case TOK_LONG:
			if ((t & VT_BTYPE) == VT_DOUBLE) {
				t = (t & ~(VT_BTYPE|VT_LONG)) | VT_LDOUBLE;
			} else if ((t & (VT_BTYPE|VT_LONG)) == VT_LONG) {
				t = (t & ~(VT_BTYPE|VT_LONG)) | VT_LLONG;
			} else {
				u = VT_LONG;
				goto basic_type;
			}
			next();
			break;
		case TOK_BOOL:
			u = VT_BOOL;
			goto basic_type;
		case TOK_COMPLEX:
			tcc_error("_Complex is not yet supported");
		case TOK_FLOAT:
			u = VT_FLOAT;
			goto basic_type;
		case TOK_DOUBLE:
			if ((t & (VT_BTYPE|VT_LONG)) == VT_LONG) {
				t = (t & ~(VT_BTYPE|VT_LONG)) | VT_LDOUBLE;
			} else {
				u = VT_DOUBLE;
				goto basic_type;
			}
			next();
			break;
		case TOK_ENUM:
			struct_decl(&type1, VT_ENUM);
basic_type2:
			u = type1.t;
			type->ref = type1.ref;
			goto basic_type1;
		case TOK_STRUCT:
			struct_decl(&type1, VT_STRUCT);
			goto basic_type2;
		case TOK_UNION:
			struct_decl(&type1, VT_UNION);
			goto basic_type2;
		/* type modifiers */

		case TOK__Atomic:
			next();
			type->t = t;
			parse_btype_qualify(type, VT_ATOMIC);
			t = type->t;
			if (tok == '(') {
				parse_expr_type(&type1);
				/* remove all storage modifiers except typedef */

				type1.t &= ~(VT_STORAGE&~VT_TYPEDEF);
				if (type1.ref)
					sym_to_attr(ad, type1.ref);
				goto basic_type2;
			}
			break;
		case TOK_CONST1:
		case TOK_CONST2:
		case TOK_CONST3:
			type->t = t;
			parse_btype_qualify(type, VT_CONSTANT);
			t = type->t;
			next();
			break;
		case TOK_VOLATILE1:
		case TOK_VOLATILE2:
		case TOK_VOLATILE3:
			type->t = t;
			parse_btype_qualify(type, VT_VOLATILE);
			t = type->t;
			next();
			break;
		case TOK_SIGNED1:
		case TOK_SIGNED2:
		case TOK_SIGNED3:
			if ((t & (VT_DEFSIGN|VT_UNSIGNED)) == (VT_DEFSIGN|VT_UNSIGNED))
				tcc_error("signed and unsigned modifier");
			t |= VT_DEFSIGN;
			next();
			typespec_found = 1;
			break;
		case TOK_REGISTER:
		case TOK_AUTO:
		case TOK_RESTRICT1:
		case TOK_RESTRICT2:
		case TOK_RESTRICT3:
			next();
			break;
		case TOK_UNSIGNED:
			if ((t & (VT_DEFSIGN|VT_UNSIGNED)) == VT_DEFSIGN)
				tcc_error("signed and unsigned modifier");
			t |= VT_DEFSIGN | VT_UNSIGNED;
			next();
			typespec_found = 1;
			break;
		/* storage */

		case TOK_EXTERN:
			g = VT_EXTERN;
			goto storage;
		case TOK_STATIC:
			g = VT_STATIC;
			goto storage;
		case TOK_TYPEDEF:
			g = VT_TYPEDEF;
			goto storage;
storage:
			if (t & (VT_EXTERN|VT_STATIC|VT_TYPEDEF) & ~g)
				tcc_error("multiple storage classes");
			t |= g;
			next();
			break;
		case TOK_INLINE1:
		case TOK_INLINE2:
		case TOK_INLINE3:
			t |= VT_INLINE;
			next();
			break;
		case TOK_NORETURN3:
			next();
			ad->f.func_noreturn = 1;
			break;
		/* GNUC attribute */

		case TOK_ATTRIBUTE1:
		case TOK_ATTRIBUTE2:
			parse_attribute(ad);
			if (ad->attr_mode) {
				u = ad->attr_mode -1;
				t = (t & ~(VT_BTYPE|VT_LONG)) | u;
			}
			continue;
		/* GNUC typeof */

		case TOK_TYPEOF1:
		case TOK_TYPEOF2:
		case TOK_TYPEOF3:
			next();
			parse_expr_type(&type1);
			/* remove all storage modifiers except typedef */

			type1.t &= ~(VT_STORAGE&~VT_TYPEDEF);
			if (type1.ref)
				sym_to_attr(ad, type1.ref);
			goto basic_type2;
		case TOK_THREAD_LOCAL:
			tcc_error("_Thread_local is not implemented");
		default:
			if (typespec_found)
				goto the_end;
			s = sym_find(tok);
			if (!s || !(s->type.t & VT_TYPEDEF))
				goto the_end;

			n = tok, next();
			if (tok == ':' && ignore_label) {
				/* ignore if it's a label */

				unget_tok(n);
				goto the_end;
			}

			t &= ~(VT_BTYPE|VT_LONG);
			u = t & ~(VT_CONSTANT | VT_VOLATILE), t ^= u;
			type->t = (s->type.t & ~VT_TYPEDEF) | u;
			type->ref = s->type.ref;
			if (t)
				parse_btype_qualify(type, t);
			t = type->t;
			/* get attributes from typedef */

			sym_to_attr(ad, s);
			typespec_found = 1;
			st = bt = -2;
			break;
		}
		type_found = 1;
	}
the_end:
	if (tcc_state->char_is_unsigned) {
		if ((t & (VT_DEFSIGN|VT_BTYPE)) == VT_BYTE)
			t |= VT_UNSIGNED;
	}
	/* VT_LONG is used just as a modifier for VT_INT / VT_LLONG */

	bt = t & (VT_BTYPE|VT_LONG);
	if (bt == VT_LONG)
		t |= LONG_SIZE == 8 ? VT_LLONG : VT_INT;
#ifdef TCC_USING_DOUBLE_FOR_LDOUBLE

	if (bt == VT_LDOUBLE)
		t = (t & ~(VT_BTYPE|VT_LONG)) | (VT_DOUBLE|VT_LONG);
#endif

	type->t = t;
	return type_found;
}
/* convert a function parameter type (array to pointer and function to
   function pointer) */

static inline void convert_parameter_type(CType *pt)
{
	/* remove const and volatile qualifiers (XXX: const could be used
	       to indicate a const function parameter */

	pt->t &= ~(VT_CONSTANT | VT_VOLATILE);
	/* array must be transformed to pointer according to ANSI C */

	pt->t &= ~(VT_ARRAY | VT_VLA);
	if ((pt->t & VT_BTYPE) == VT_FUNC) {
		mk_pointer(pt);
	}
}

ST_FUNC CString *parse_asm_str(void)
{
	skip('(');
	return parse_mult_str("string constant");
}
/* Parse an asm label and return the token */

static int asm_label_instr(void)
{
	int v;
	char *astr;

	next();
	astr = parse_asm_str()->data;
	skip(')');
#ifdef ASM_DEBUG

	printf("asm_alias: \"%s\"\n", astr);
#endif

	v = tok_alloc_const(astr);
	return v;
}

static int post_type(CType *type, AttributeDef *ad, int storage, int td)
{
	int n, l, t1, arg_size, align;
	Sym **plast, *s, *first;
	AttributeDef ad1;
	CType pt;
	TokenString *vla_array_tok = NULL;
	int *vla_array_str = NULL;

	if (tok == '(') {
		/* function type, or recursive declarator (return if so) */

		next();
		if (TYPE_DIRECT == (td & (TYPE_DIRECT|TYPE_ABSTRACT)))
			return 0;
		if (tok == ')')
			l = 0;
		else if (parse_btype(&pt, &ad1, 0))
			l = FUNC_NEW;
		else if (td & (TYPE_DIRECT|TYPE_ABSTRACT)) {
			merge_attr (ad, &ad1);
			return 0;
		} else
			l = FUNC_OLD;

		first = NULL;
		plast = &first;
		arg_size = 0;
		++local_scope;
		if (l) {
			for (;;) {
				/* read param name and compute offset */

				if (l != FUNC_OLD) {
					if ((pt.t & VT_BTYPE) == VT_VOID && tok == ')')
						break;
					type_decl(&pt, &ad1, &n, TYPE_DIRECT | TYPE_ABSTRACT | TYPE_PARAM);
					if ((pt.t & VT_BTYPE) == VT_VOID)
						tcc_error("parameter declared as void");
					if (n == 0)
						n = SYM_FIELD;
				} else {
					n = tok;
					pt.t = VT_VOID;/* invalid type */

					pt.ref = NULL;
					next();
				}
				if (n < TOK_UIDENT)
					expect("identifier");
				convert_parameter_type(&pt);
				arg_size += (type_size(&pt, &align) + PTR_SIZE - 1) / PTR_SIZE;
				/* these symbols may be evaluated for VLArrays (see below, under
				                   nocode_wanted) which is why we push them here as normal symbols
				                   temporarily.  Example: int func(int a, int b[++a])\; */

				s = sym_push(n, &pt, VT_LOCAL|VT_LVAL, 0);
				*plast = s;
				plast = &s->next;
				if (tok == ')')
					break;
				skip(',');
				if (l == FUNC_NEW && tok == TOK_DOTS) {
					l = FUNC_ELLIPSIS;
					next();
					break;
				}
				if (l == FUNC_NEW && !parse_btype(&pt, &ad1, 0))
					tcc_error("invalid type");
			}
		} else
			/* if no parameters, then old type prototype */

			l = FUNC_OLD;
		skip(')');
		/* remove parameter symbols from token table, keep on stack */

		if (first) {
			sym_pop(local_stack ? &local_stack : &global_stack, first->prev, 1);
			for (s = first; s; s = s->next)
				s->v |= SYM_FIELD;
		}
		--local_scope;
		/* NOTE: const is ignored in returned type as it has a special
		           meaning in gcc / C++ */

		type->t &= ~VT_CONSTANT;
		/* some ancient pre-K&R C allows a function to return an array
		           and the array brackets to be put after the arguments, such
		           that "int c()[]" means something like "int[] c()" */

		if (tok == '[') {
			next();
			skip(']');/* only handle simple "[]" */

			mk_pointer(type);
		}
		/* we push a anonymous symbol which will contain the function prototype */

		ad->f.func_args = arg_size;
		ad->f.func_type = l;
		s = sym_push(SYM_FIELD, type, 0, 0);
		s->a = ad->a;
		s->f = ad->f;
		s->next = first;
		type->t = VT_FUNC;
		type->ref = s;
	} else if (tok == '[') {
		int saved_nocode_wanted = nocode_wanted;
		/* array definition */

		next();
		n = -1;
		t1 = 0;
		if (td & TYPE_PARAM) while (1) {
				/* XXX The optional type-quals and static should only be accepted
					       in parameter decls.  The '*' as well, and then even only
					       in prototypes (not function defs).  */

				switch (tok) {
				case TOK_RESTRICT1:
				case TOK_RESTRICT2:
				case TOK_RESTRICT3:
				case TOK_CONST1:
				case TOK_VOLATILE1:
				case TOK_STATIC:
				case '*':
					next();
					continue;
				default:
					break;
				}
				if (tok != ']') {
					/* Code generation is not done now but has to be done
							   at start of function. Save code here for later use. */

					nocode_wanted = 1;
					skip_or_save_block(&vla_array_tok);
					unget_tok(0);
					vla_array_str = vla_array_tok->str;
					begin_macro(vla_array_tok, 2);
					next();
					gexpr();
					end_macro();
					next();
					goto check;
				}
				break;

			} else if (tok != ']') {
			if (!local_stack || (storage & VT_STATIC))
				vpushi(expr_const());
			else {
				/* VLAs (which can only happen with local_stack && !VT_STATIC)
						   length must always be evaluated, even under nocode_wanted,
						   so that its size slot is initialized (e.g. under sizeof
						   or typeof).  */

				nocode_wanted = 0;
				gexpr();
			}
check:
			if ((vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST) {
				n = vtop->c.i;
				if (n < 0)
					tcc_error("invalid array size");
			} else {
				if (!is_integer_btype(vtop->type.t & VT_BTYPE))
					tcc_error("size of variable length array should be an integer");
				n = 0;
				t1 = VT_VLA;
			}
		}
		skip(']');
		/* parse next post type */

		post_type(type, ad, storage, (td & ~(TYPE_DIRECT|TYPE_ABSTRACT)) | TYPE_NEST);

		if ((type->t & VT_BTYPE) == VT_FUNC)
			tcc_error("declaration of an array of functions");
		if ((type->t & VT_BTYPE) == VT_VOID
		    || type_size(type, &align) < 0)
			tcc_error("declaration of an array of incomplete type elements");

		t1 |= type->t & VT_VLA;

		if (t1 & VT_VLA) {
			if (n < 0) {
				if (td & TYPE_NEST)
					tcc_error("need explicit inner array size in VLAs");
			} else {
				loc -= type_size(&int_type, &align);
				loc &= -align;
				n = loc;

				vpush_type_size(type, &align);
				gen_op('*');
				vset(&int_type, VT_LOCAL|VT_LVAL, n);
				vswap();
				vstore();
			}
		}
		if (n != -1)
			vpop();
		nocode_wanted = saved_nocode_wanted;
		/* we push an anonymous symbol which will contain the array
		           element type */

		s = sym_push(SYM_FIELD, type, 0, n);
		type->t = (t1 ? VT_VLA : VT_ARRAY) | VT_PTR;
		type->ref = s;

		if (vla_array_str) {
			/* for function args, the top dimension is converted to pointer */

			if ((t1 & VT_VLA) && (td & TYPE_NEST))
				s->vla_array_str = vla_array_str;
			else
				tok_str_free_str(vla_array_str);
		}
	}
	return 1;
}
/* Parse a type declarator (except basic type), and return the type
   in 'type'. 'td' is a bitmask indicating which kind of type decl is
   expected. 'type' should contain the basic type. 'ad' is the
   attribute definition of the basic type. It can be modified by
   type_decl().  If this (possibly abstract) declarator is a pointer chain
   it returns the innermost pointed to type (equals *type, but is a different
   pointer), otherwise returns type itself, that's used for recursive calls.  */
// 5133 "tccgen.c"
static CType *type_decl(CType *type, AttributeDef *ad, int *v, int td)
{
	CType *post, *ret;
	int qualifiers, storage;
	/* recursive type, remove storage bits first, apply them later again */

	storage = type->t & VT_STORAGE;
	type->t &= ~VT_STORAGE;
	post = ret = type;

	while (tok == '*') {
		qualifiers = 0;
redo:
		next();
		switch (tok) {
		case TOK__Atomic:
			qualifiers |= VT_ATOMIC;
			goto redo;
		case TOK_CONST1:
		case TOK_CONST2:
		case TOK_CONST3:
			qualifiers |= VT_CONSTANT;
			goto redo;
		case TOK_VOLATILE1:
		case TOK_VOLATILE2:
		case TOK_VOLATILE3:
			qualifiers |= VT_VOLATILE;
			goto redo;
		case TOK_RESTRICT1:
		case TOK_RESTRICT2:
		case TOK_RESTRICT3:
			goto redo;
		/* XXX: clarify attribute handling */

		case TOK_ATTRIBUTE1:
		case TOK_ATTRIBUTE2:
			parse_attribute(ad);
			break;
		}
		mk_pointer(type);
		type->t |= qualifiers;
		if (ret == type)
			/* innermost pointed to type is the one for the first derivation */

			ret = pointed_type(type);
	}

	if (tok == '(') {
		/* This is possibly a parameter type list for abstract declarators
			   ('int ()'), use post_type for testing this.  */

		if (!post_type(type, ad, 0, td)) {
			/* It's not, so it's a nested declarator, and the post operations
				       apply to the innermost pointed to type (if any).  */
			/* XXX: this is not correct to modify 'ad' at this point, but
				       the syntax is not clear */

			parse_attribute(ad);
			post = type_decl(type, ad, v, td);
			skip(')');
		} else
			goto abstract;
	} else if (tok >= TOK_IDENT && (td & TYPE_DIRECT)) {
		/* type identifier */

		*v = tok;
		next();
	} else {
abstract:
		if (!(td & TYPE_ABSTRACT))
			expect("identifier");
		*v = 0;
	}
	post_type(post, ad, post != ret ? 0 : storage,
		  td & ~(TYPE_DIRECT|TYPE_ABSTRACT));
	parse_attribute(ad);
	type->t |= storage;
	return ret;
}
/* indirection with full error checking and bound check */

ST_FUNC void indir(void)
{
	if ((vtop->type.t & VT_BTYPE) != VT_PTR) {
		if ((vtop->type.t & VT_BTYPE) == VT_FUNC)
			return;
		expect("pointer");
	}
	if (vtop->r & VT_LVAL)
		gv(RC_INT);
	vtop->type = *pointed_type(&vtop->type);
	/* Arrays and functions are never lvalues */

	if (!(vtop->type.t & (VT_ARRAY | VT_VLA))
	    && (vtop->type.t & VT_BTYPE) != VT_FUNC) {
		vtop->r |= VT_LVAL;
		/* if bound checking, the referenced pointer must be checked */
#ifdef CONFIG_TCC_BCHECK

		if (tcc_state->do_bounds_check)
			vtop->r |= VT_MUSTBOUND;
#endif

	}
}
/* pass a parameter to a function and do type checking and casting */

static void gfunc_param_typed(Sym *func, Sym *arg)
{
	int func_type;
	CType type;

	func_type = func->f.func_type;
	if (func_type == FUNC_OLD ||
	    (func_type == FUNC_ELLIPSIS && arg == NULL)) {
		/* default casting : only need to convert float to double */

		if ((vtop->type.t & VT_BTYPE) == VT_FLOAT) {
			gen_cast_s(VT_DOUBLE);
		} else if (vtop->type.t & VT_BITFIELD) {
			type.t = vtop->type.t & (VT_BTYPE | VT_UNSIGNED);
			type.ref = vtop->type.ref;
			gen_cast(&type);
		} else if (vtop->r & VT_MUSTCAST) {
			force_charshort_cast();
		}
	} else if (arg == NULL) {
		tcc_error("too many arguments to function");
	} else {
		type = arg->type;
		type.t &= ~VT_CONSTANT;/* need to do that to avoid false warning */

		gen_assign_cast(&type);
	}
}
/* parse an expression and return its type without any side effect. */

static void expr_type(CType *type, void (*expr_fn)(void))
{
	nocode_wanted++;
	expr_fn();
	*type = vtop->type;
	vpop();
	nocode_wanted--;
}
/* parse an expression of the form '(type)' or '(expr)' and return its
   type */

static void parse_expr_type(CType *type)
{
	int n;
	AttributeDef ad;

	skip('(');
	if (parse_btype(type, &ad, 0)) {
		type_decl(type, &ad, &n, TYPE_ABSTRACT);
	} else {
		expr_type(type, gexpr);
	}
	skip(')');
}

static void parse_type(CType *type)
{
	AttributeDef ad;
	int n;

	if (!parse_btype(type, &ad, 0)) {
		expect("type");
	}
	type_decl(type, &ad, &n, TYPE_ABSTRACT);
}

static void parse_builtin_params(int nc, const char *args)
{
	char c, sep = '(';
	CType type;
	if (nc)
		nocode_wanted++;
	next();
	if (*args == 0)
		skip(sep);
	while ((c = *args++)) {
		skip(sep);
		sep = ',';
		if (c == 't') {
			parse_type(&type);
			vpush(&type);
			continue;
		}
		expr_eq();
		type.ref = NULL;
		type.t = 0;
		switch (c) {
		case 'e':
			continue;
		case 'V':
			type.t = VT_CONSTANT;
		case 'v':
			type.t |= VT_VOID;
			mk_pointer (&type);
			break;
		case 'S':
			type.t = VT_CONSTANT;
		case 's':
			type.t |= char_type.t;
			mk_pointer (&type);
			break;
		case 'i':
			type.t = VT_INT;
			break;
		case 'l':
			type.t = VT_SIZE_T;
			break;
		default:
			break;
		}
		gen_assign_cast(&type);
	}
	skip(')');
	if (nc)
		nocode_wanted--;
}

static void parse_atomic(int atok)
{
	int size, align, arg, t, save = 0;
	CType *atom, *atom_ptr, ct = {0};
	SValue store;
	char buf[40];
	static const char *const templates[] = {
		/*
		         * Each entry consists of callback and function template.
		         * The template represents argument types and return type.
		         *
		         * ? void (return-only)
		         * b bool
		         * a atomic
		         * A read-only atomic
		         * p pointer to memory
		         * v value
		         * l load pointer
		         * s save pointer
		         * m memory model
		         */
		/* keep in order of appearance in tcctok.h: */
		/* __atomic_store */
// 5370 "tccgen.c"
		"alm.?",
		/* __atomic_load */
		"Asm.v",
		/* __atomic_exchange */
		"alsm.v",
		/* __atomic_compare_exchange */
		"aplbmm.b",
		/* __atomic_fetch_add */
		"avm.v",
		/* __atomic_fetch_sub */
		"avm.v",
		/* __atomic_fetch_or */
		"avm.v",
		/* __atomic_fetch_xor */
		"avm.v",
		/* __atomic_fetch_and */
		"avm.v",
		/* __atomic_fetch_nand */
		"avm.v",
		/* __atomic_and_fetch */
		"avm.v",
		/* __atomic_sub_fetch */
		"avm.v",
		/* __atomic_or_fetch */
		"avm.v",
		/* __atomic_xor_fetch */
		"avm.v",
		/* __atomic_and_fetch */
		"avm.v",
		/* __atomic_nand_fetch */
		"avm.v"
	};
	const char *template = templates[(atok - TOK___atomic_store)];

	atom = atom_ptr = NULL;
	size = 0;/* pacify compiler */

	next();
	skip('(');
	for (arg = 0;;) {
		expr_eq();
		switch (template[arg]) {
		case 'a':
		case 'A':
			atom_ptr = &vtop->type;
			if ((atom_ptr->t & VT_BTYPE) != VT_PTR)
				expect("pointer");
			atom = pointed_type(atom_ptr);
			size = type_size(atom, &align);
			if (size > 8
			    || (size & (size - 1))
			    || (atok > TOK___atomic_compare_exchange
				&& (0 == btype_size(atom->t & VT_BTYPE)
				    || (atom->t & VT_BTYPE) == VT_PTR)))
				expect("integral or integer-sized pointer target type");
			/* GCC does not care either: */
			/* if (!(atom->t & VT_ATOMIC))
			                tcc_warning("pointer target declaration is missing '_Atomic'"); */

			break;

		case 'p':
			if ((vtop->type.t & VT_BTYPE) != VT_PTR
			    || type_size(pointed_type(&vtop->type), &align) != size)
				tcc_error("pointer target type mismatch in argument %d", arg + 1);
			gen_assign_cast(atom_ptr);
			break;
		case 'v':
			gen_assign_cast(atom);
			break;
		case 'l':
			indir();
			gen_assign_cast(atom);
			break;
		case 's':
			save = 1;
			indir();
			store = *vtop;
			vpop();
			break;
		case 'm':
			gen_assign_cast(&int_type);
			break;
		case 'b':
			ct.t = VT_BOOL;
			gen_assign_cast(&ct);
			break;
		}
		if ('.' == template[++arg])
			break;
		skip(',');
	}
	skip(')');

	ct.t = VT_VOID;
	switch (template[arg + 1]) {
	case 'b':
		ct.t = VT_BOOL;
		break;
	case 'v':
		ct = *atom;
		break;
	}

	sprintf(buf, "%s_%d", get_tok_str(atok, 0), size);
	vpush_helper_func(tok_alloc_const(buf));
	vrott(arg - save + 1);
	gfunc_call(arg - save);

	vpush(&ct);
	PUT_R_RET(vtop, ct.t);
	t = ct.t & VT_BTYPE;
	if (t == VT_BYTE || t == VT_SHORT || t == VT_BOOL) {
#ifdef PROMOTE_RET

		vtop->r |= BFVAL(VT_MUSTCAST, 1);
#else

		vtop->type.t = VT_INT;
#endif

	}
	gen_cast(&ct);
	if (save) {
		vpush(&ct);
		*vtop = store;
		vswap();
		vstore();
	}
}

ST_FUNC void unary(void)
{
	int n, t, align, size, r;
	CType type;
	Sym *s;
	AttributeDef ad;
	/* generate line number info */

	if (debug_modes)
		tcc_debug_line(tcc_state), tcc_tcov_check_line (tcc_state, 1);

	type.ref = NULL;
	/* XXX: GCC 2.95.3 does not generate a table although it should be
	       better here */

tok_next:
	switch (tok) {
	case TOK_EXTENSION:
		next();
		goto tok_next;
	case TOK_LCHAR:

		t = VT_SHORT|VT_UNSIGNED;
		goto push_tokc;

	case TOK_CINT:
	case TOK_CCHAR:
		t = VT_INT;
push_tokc:
		type.t = t;
		vsetc(&type, VT_CONST, &tokc);
		next();
		break;
	case TOK_CUINT:
		t = VT_INT | VT_UNSIGNED;
		goto push_tokc;
	case TOK_CLLONG:
		t = VT_LLONG;
		goto push_tokc;
	case TOK_CULLONG:
		t = VT_LLONG | VT_UNSIGNED;
		goto push_tokc;
	case TOK_CFLOAT:
		t = VT_FLOAT;
		goto push_tokc;
	case TOK_CDOUBLE:
		t = VT_DOUBLE;
		goto push_tokc;
	case TOK_CLDOUBLE:
#ifdef TCC_USING_DOUBLE_FOR_LDOUBLE

		t = VT_DOUBLE | VT_LONG;
#else

		t = VT_LDOUBLE;
#endif

		goto push_tokc;
	case TOK_CLONG:
		t = (LONG_SIZE == 8 ? VT_LLONG : VT_INT) | VT_LONG;
		goto push_tokc;
	case TOK_CULONG:
		t = (LONG_SIZE == 8 ? VT_LLONG : VT_INT) | VT_LONG | VT_UNSIGNED;
		goto push_tokc;
	case TOK___FUNCTION__:
		if (!gnu_ext)
			goto tok_identifier;
	/* fall thru */

	case TOK___FUNC__:
		tok = TOK_STR;
		cstr_reset(&tokcstr);
		cstr_cat(&tokcstr, funcname, 0);
		tokc.str.size = tokcstr.size;
		tokc.str.data = tokcstr.data;
		goto case_TOK_STR;
	case TOK_LSTR:

		t = VT_SHORT | VT_UNSIGNED;

		goto str_init;
	case TOK_STR:
case_TOK_STR:
		/* string parsing */

		t = char_type.t;
str_init:
		if (tcc_state->warn_write_strings & WARN_ON)
			t |= VT_CONSTANT;
		type.t = t;
		mk_pointer(&type);
		type.t |= VT_ARRAY;
		memset(&ad, 0, sizeof(AttributeDef));
		ad.section = rodata_section;
		decl_initializer_alloc(&type, &ad, VT_CONST, 2, 0, 0);
		break;
	case TOK_SOTYPE:
	case '(':
		t = tok;
		next();
		/* cast ? */

		if (parse_btype(&type, &ad, 0)) {
			type_decl(&type, &ad, &n, TYPE_ABSTRACT);
			skip(')');
			/* check ISOC99 compound literal */

			if (tok == '{') {
				/* data is allocated locally by default */

				if (global_expr)
					r = VT_CONST;
				else
					r = VT_LOCAL;
				/* all except arrays are lvalues */

				if (!(type.t & VT_ARRAY))
					r |= VT_LVAL;
				memset(&ad, 0, sizeof(AttributeDef));
				decl_initializer_alloc(&type, &ad, r, 1, 0, 0);
			} else if (t == TOK_SOTYPE) {/* from sizeof/alignof (...) */

				vpush(&type);
				return;
			} else {
				unary();
				gen_cast(&type);
			}
		} else if (tok == '{') {
			int saved_nocode_wanted = nocode_wanted;
			if (CONST_WANTED && !NOEVAL_WANTED)
				expect("constant");
			if (0 == local_scope)
				tcc_error("statement expression outside of function");
			/* save all registers */

			save_regs(0);
			/* statement expression : we do not accept break/continue
			               inside as GCC does.  We do retain the nocode_wanted state,
				       as statement expressions can't ever be entered from the
				       outside, so any reactivation of code emission (from labels
				       or loop heads) can be disabled again after the end of it. */

			block(STMT_EXPR);
			/* If the statement expr can be entered, then we retain the current
			               nocode_wanted state (from e.g. a 'return 0;' in the stmt-expr).
			               If it can't be entered then the state is that from before the
			               statement expression.  */

			if (saved_nocode_wanted)
				nocode_wanted = saved_nocode_wanted;
			skip(')');
		} else {
			gexpr();
			skip(')');
		}
		break;
	case '*':
		next();
		unary();
		indir();
		break;
	case '&':
		next();
		unary();
		/* functions names must be treated as function pointers,
		           except for unary '&' and sizeof. Since we consider that
		           functions are not lvalues, we only have to handle it
		           there and in function calls. */
		/* arrays can also be used although they are not lvalues */

		if ((vtop->type.t & VT_BTYPE) != VT_FUNC &&
		    !(vtop->type.t & (VT_ARRAY | VT_VLA)))
			test_lvalue();
		if (vtop->sym)
			vtop->sym->a.addrtaken = 1;
		mk_pointer(&vtop->type);
		gaddrof();
		break;
	case '!':
		next();
		unary();
		gen_test_zero(TOK_EQ);
		break;
	case '~':
		next();
		unary();
		vpushi(-1);
		gen_op('^');
		break;
	case '+':
		next();
		unary();
		if ((vtop->type.t & VT_BTYPE) == VT_PTR)
			tcc_error("pointer not accepted for unary plus");
		/* In order to force cast, we add zero, except for floating point
			   where we really need an noop (otherwise -0.0 will be transformed
			   into +0.0).  */

		if (!is_float(vtop->type.t)) {
			vpushi(0);
			gen_op('+');
		}
		break;
	case TOK_SIZEOF:
	case TOK_ALIGNOF1:
	case TOK_ALIGNOF2:
	case TOK_ALIGNOF3:
		t = tok;
		next();
		if (tok == '(')
			tok = TOK_SOTYPE;
		expr_type(&type, unary);
		if (t == TOK_SIZEOF) {
			vpush_type_size(&type, &align);
			gen_cast_s(VT_SIZE_T);
		} else {
			type_size(&type, &align);
			s = NULL;
			if (vtop[1].r & VT_SYM)
				s = vtop[1].sym;/* hack: accessing previous vtop */

			if (s && s->a.aligned)
				align = 1 << (s->a.aligned - 1);
			vpushs(align);
		}
		break;

	case TOK_builtin_expect:
		/* __builtin_expect is a no-op for now */

		parse_builtin_params(0, "ee");
		vpop();
		break;
	case TOK_builtin_types_compatible_p:
		parse_builtin_params(0, "tt");
		vtop[-1].type.t &= ~(VT_CONSTANT | VT_VOLATILE);
		vtop[0].type.t &= ~(VT_CONSTANT | VT_VOLATILE);
		n = is_compatible_types(&vtop[-1].type, &vtop[0].type);
		vtop -= 2;
		vpushi(n);
		break;
	case TOK_builtin_choose_expr: {
		int64_t c;
		next();
		skip('(');
		c = expr_const64();
		skip(',');
		if (!c) {
			nocode_wanted++;
		}
		expr_eq();
		if (!c) {
			vpop();
			nocode_wanted--;
		}
		skip(',');
		if (c) {
			nocode_wanted++;
		}
		expr_eq();
		if (c) {
			vpop();
			nocode_wanted--;
		}
		skip(')');
	}
	break;
	case TOK_builtin_constant_p:
		parse_builtin_params(1, "e");
		n = 1;
		if ((vtop->r & (VT_VALMASK | VT_LVAL)) != VT_CONST
		    || ((vtop->r & VT_SYM) && vtop->sym->a.addrtaken)
		   )
			n = 0;
		vtop--;
		vpushi(n);
		break;
	case TOK_builtin_unreachable:
		parse_builtin_params(0, "");/* just skip '()' */

		type.t = VT_VOID;
		vpush(&type);
		CODE_OFF();
		break;
	case TOK_builtin_frame_address:
	case TOK_builtin_return_address: {
		int tok1 = tok;
		int level;
		next();
		skip('(');
		level = expr_const();
		if (level < 0)
			tcc_error("%s only takes positive integers", get_tok_str(tok1, 0));
		skip(')');
		type.t = VT_VOID;
		mk_pointer(&type);
		vset(&type, VT_LOCAL, 0);/* local frame */

		while (level--) {

			mk_pointer(&vtop->type);
			indir();/* -> parent frame */

		}
		if (tok1 == TOK_builtin_return_address) {
// assume return address is just above frame pointer on stack
// 5781 "tccgen.c"
			vpushi(PTR_SIZE);
			gen_op('+');

			mk_pointer(&vtop->type);
			indir();
		}
	}
	break;
// 5803 "tccgen.c"
	case TOK_builtin_va_start:
		parse_builtin_params(0, "ee");
		r = vtop->r & VT_VALMASK;
		if (r == VT_LLOCAL)
			r = VT_LOCAL;
		if (r != VT_LOCAL)
			tcc_error("__builtin_va_start expects a local variable");
		vtop->r = r;
		vtop->type = char_pointer_type;
		vtop->c.i += 8;
		vstore();
		break;
	/* atomic operations */
// 5853 "tccgen.c"
	case TOK___atomic_store:
	case TOK___atomic_load:
	case TOK___atomic_exchange:
	case TOK___atomic_compare_exchange:
	case TOK___atomic_fetch_add:
	case TOK___atomic_fetch_sub:
	case TOK___atomic_fetch_or:
	case TOK___atomic_fetch_xor:
	case TOK___atomic_fetch_and:
	case TOK___atomic_fetch_nand:
	case TOK___atomic_add_fetch:
	case TOK___atomic_sub_fetch:
	case TOK___atomic_or_fetch:
	case TOK___atomic_xor_fetch:
	case TOK___atomic_and_fetch:
	case TOK___atomic_nand_fetch:
		parse_atomic(tok);
		break;
	/* pre operations */

	case TOK_INC:
	case TOK_DEC:
		t = tok;
		next();
		unary();
		inc(0, t);
		break;
	case '-':
		next();
		unary();
		if (is_float(vtop->type.t)) {
			gen_opif(TOK_NEG);
		} else {
			vpushi(0);
			vswap();
			gen_op('-');
		}
		break;
	case TOK_LAND:
		if (!gnu_ext)
			goto tok_identifier;
		next();
		/* allow to take the address of a label */

		if (tok < TOK_UIDENT)
			expect("label identifier");
		s = label_find(tok);
		if (!s) {
			s = label_push(&global_label_stack, tok, LABEL_FORWARD);
		} else {
			if (s->r == LABEL_DECLARED)
				s->r = LABEL_FORWARD;
		}
		if ((s->type.t & VT_BTYPE) != VT_PTR) {
			s->type.t = VT_VOID;
			mk_pointer(&s->type);
			s->type.t |= VT_STATIC;
		}
		vpushsym(&s->type, s);
		next();
		break;

	case TOK_GENERIC: {
		CType controlling_type;
		int has_default = 0;
		int has_match = 0;
		int learn = 0;
		TokenString *str = NULL;
		int saved_nocode_wanted = nocode_wanted;
		nocode_wanted &= ~CONST_WANTED_MASK;

		next();
		skip('(');
		expr_type(&controlling_type, expr_eq);
		convert_parameter_type (&controlling_type);

		nocode_wanted = saved_nocode_wanted;

		for (;;) {
			learn = 0;
			skip(',');
			if (tok == TOK_DEFAULT) {
				if (has_default)
					tcc_error("too many 'default'");
				has_default = 1;
				if (!has_match)
					learn = 1;
				next();
			} else {
				AttributeDef ad_tmp;
				int itmp;
				CType cur_type;

				parse_btype(&cur_type, &ad_tmp, 0);
				type_decl(&cur_type, &ad_tmp, &itmp, TYPE_ABSTRACT);
				if (compare_types(&controlling_type, &cur_type, 0)) {
					if (has_match) {
						tcc_error("type match twice");
					}
					has_match = 1;
					learn = 1;
				}
			}
			skip(':');
			if (learn) {
				if (str)
					tok_str_free(str);
				skip_or_save_block(&str);
			} else {
				skip_or_save_block(NULL);
			}
			if (tok == ')')
				break;
		}
		if (!str) {
			char buf[60];
			type_to_str(buf, sizeof buf, &controlling_type, NULL);
			tcc_error("type '%s' does not match any association", buf);
		}
		begin_macro(str, 1);
		next();
		expr_eq();
		if (tok != TOK_EOF)
			expect(",");
		end_macro();
		next();
		break;
	}
// special qnan , snan and infinity values

	case TOK___NAN__:
		n = 0x7fc00000;
special_math_val:
		vpushi(n);
		vtop->type.t = VT_FLOAT;
		next();
		break;
	case TOK___SNAN__:
		n = 0x7f800001;
		goto special_math_val;
	case TOK___INF__:
		n = 0x7f800000;
		goto special_math_val;

	default:
tok_identifier:
		if (tok < TOK_UIDENT)
			tcc_error("expression expected before '%s'", get_tok_str(tok, &tokc));
		t = tok;
		next();
		s = sym_find(t);
		if (!s || IS_ASM_SYM(s)) {
			const char *name = get_tok_str(t, NULL);
			if (tok != '(')
				tcc_error("'%s' undeclared", name);
			/* for simple function calls, we tolerate undeclared
			               external reference to int() function */

			tcc_warning_c(warn_implicit_function_declaration)(
				"implicit declaration of function '%s'", name);
			s = external_global_sym(t, &func_old_type);
		}

		r = s->r;
		/* A symbol that has a register is a local register variable,
		           which starts out as VT_LOCAL value.  */

		if ((r & VT_VALMASK) < VT_CONST)
			r = (r & ~VT_VALMASK) | VT_LOCAL;

		vset(&s->type, r, s->c);
		/* Point to s as backpointer (even without r&VT_SYM).
			   Will be used by at least the x86 inline asm parser for
			   regvars.  */

		vtop->sym = s;

		if (r & VT_SYM) {
			vtop->c.i = 0;

			if (s->a.dllimport) {
				mk_pointer(&vtop->type);
				vtop->r |= VT_LVAL;
				indir();
			}

		} else if (r == VT_CONST && IS_ENUM_VAL(s->type.t)) {
			vtop->c.i = s->enum_val;
		}
		break;
	}
	/* post operations */

	while (1) {
		if (tok == TOK_INC || tok == TOK_DEC) {
			inc(1, tok);
			next();
		} else if (tok == '.' || tok == TOK_ARROW) {
			int qualifiers, cumofs;
			/* field */

			if (tok == TOK_ARROW)
				indir();
			qualifiers = vtop->type.t & (VT_CONSTANT | VT_VOLATILE);
			test_lvalue();
			/* expect pointer on structure */

			next();
			s = find_field(&vtop->type, tok, &cumofs);
			/* add field offset to pointer */

			gaddrof();
			vtop->type = char_pointer_type;/* change type to 'char *' */

			vpushi(cumofs);
			gen_op('+');
			/* change type to field type, and set to lvalue */

			vtop->type = s->type;
			vtop->type.t |= qualifiers;
			/* an array is never an lvalue */

			if (!(vtop->type.t & VT_ARRAY)) {
				vtop->r |= VT_LVAL;
#ifdef CONFIG_TCC_BCHECK

				/* if bound checking, the referenced pointer must be checked */

				if (tcc_state->do_bounds_check)
					vtop->r |= VT_MUSTBOUND;
#endif

			}
			next();
		} else if (tok == '[') {
			next();
			gexpr();
			gen_op('+');
			indir();
			skip(']');
		} else if (tok == '(') {
			SValue ret;
			Sym *sa;
			int nb_args, ret_nregs, ret_align, regsize, variadic;
			TokenString *p, *p2;
			/* function call  */

			if ((vtop->type.t & VT_BTYPE) != VT_FUNC) {
				/* pointer test (no array accepted) */

				if ((vtop->type.t & (VT_BTYPE | VT_ARRAY)) == VT_PTR) {
					vtop->type = *pointed_type(&vtop->type);
					if ((vtop->type.t & VT_BTYPE) != VT_FUNC)
						goto error_func;
				} else {
error_func:
					expect("function pointer");
				}
			} else {
				vtop->r &= ~VT_LVAL;/* no lvalue */

			}
			/* get return type */

			s = vtop->type.ref;
			next();
			sa = s->next;/* first parameter */

			nb_args = regsize = 0;
			ret.r2 = VT_CONST;
			/* compute first implicit argument if a structure is returned */

			if ((s->type.t & VT_BTYPE) == VT_STRUCT) {
				variadic = (s->f.func_type == FUNC_ELLIPSIS);
				ret_nregs = gfunc_sret(&s->type, variadic, &ret.type,
						       &ret_align, &regsize);
				if (ret_nregs <= 0) {
					/* get some space for the returned structure */

					size = type_size(&s->type, &align);
// 6123 "tccgen.c"
					loc = (loc - size) & -align;
					ret.type = s->type;
					ret.r = VT_LOCAL | VT_LVAL;
					/* pass it as 'int' to avoid structure arg passing
					                       problems */

					vseti(VT_LOCAL, loc);
#ifdef CONFIG_TCC_BCHECK

					if (tcc_state->do_bounds_check)
						--loc;
#endif

					ret.c = vtop->c;
					if (ret_nregs < 0)
						vtop--;
					else
						nb_args++;
				}
			} else {
				ret_nregs = 1;
				ret.type = s->type;
			}

			if (ret_nregs > 0) {
				/* return in register */

				ret.c.i = 0;
				PUT_R_RET(&ret, ret.type.t);
			}

			p = NULL;
			if (tok != ')') {
				r = tcc_state->reverse_funcargs;
				for (;;) {
					if (r) {
						skip_or_save_block(&p2);
						p2->prev = p, p = p2;
					} else {
						expr_eq();
						gfunc_param_typed(s, sa);
					}
					nb_args++;
					if (sa)
						sa = sa->next;
					if (tok == ')')
						break;
					skip(',');
				}
			}
			if (sa)
				tcc_error("too few arguments to function");

			if (p) {/* with reverse_funcargs */

				for (n = 0; p; p = p2, ++n) {
					p2 = p, sa = s;
					do {
						sa = sa->next, p2 = p2->prev;
					} while (p2 && sa);
					p2 = p->prev;
					begin_macro(p, 1), next();
					expr_eq();
					gfunc_param_typed(s, sa);
					end_macro();
				}
				vrev(n);
			}

			next();
			vcheck_cmp();/* the generators don't like VT_CMP on vtop */

			gfunc_call(nb_args);

			if (ret_nregs < 0) {
				vsetc(&ret.type, ret.r, &ret.c);

			} else {
				/* return value */

				n = ret_nregs;
				while (n > 1) {
					int rc = reg_classes[ret.r] & ~(RC_INT | RC_FLOAT);
					/* We assume that when a structure is returned in multiple
					                       registers, their classes are consecutive values of the
					                       suite s(n) = 2^n */

					rc <<= --n;
					for (r = 0; r < NB_REGS; ++r)
						if (reg_classes[r] & rc)
							break;
					vsetc(&ret.type, r, &ret.c);
				}
				vsetc(&ret.type, ret.r, &ret.c);
				vtop->r2 = ret.r2;
				/* handle packed struct return */

				if (((s->type.t & VT_BTYPE) == VT_STRUCT) && ret_nregs) {
					int addr, offset;

					size = type_size(&s->type, &align);
					/* We're writing whole regs often, make sure there's enough
					                       space.  Assume register size is power of 2.  */

					size = (size + regsize - 1) & -regsize;
					if (ret_align > align)
						align = ret_align;
					loc = (loc - size) & -align;
					addr = loc;
					offset = 0;
					for (;;) {
						vset(&ret.type, VT_LOCAL | VT_LVAL, addr + offset);
						vswap();
						vstore();
						vtop--;
						if (--ret_nregs == 0)
							break;
						offset += regsize;
					}
					vset(&s->type, VT_LOCAL | VT_LVAL, addr);
				}
				/* Promote char/short return values. This is matters only
				                   for calling function that were not compiled by TCC and
				                   only on some architectures.  For those where it doesn't
				                   matter we expect things to be already promoted to int,
				                   but not larger.  */

				t = s->type.t & VT_BTYPE;
				if (t == VT_BYTE || t == VT_SHORT || t == VT_BOOL) {
#ifdef PROMOTE_RET

					vtop->r |= BFVAL(VT_MUSTCAST, 1);
#else

					vtop->type.t = VT_INT;
#endif

				}
			}
			if (s->f.func_noreturn) {
				if (debug_modes)
					tcc_tcov_block_end(tcc_state, -1);
				CODE_OFF();
			}
		} else {
			break;
		}
	}
}
#ifndef precedence_parser
/* original top-down parser */

static void expr_prod(void)
{
	int t;

	unary();
	while ((t = tok) == '*' || t == '/' || t == '%') {
		next();
		unary();
		gen_op(t);
	}
}

static void expr_sum(void)
{
	int t;

	expr_prod();
	while ((t = tok) == '+' || t == '-') {
		next();
		expr_prod();
		gen_op(t);
	}
}

static void expr_shift(void)
{
	int t;

	expr_sum();
	while ((t = tok) == TOK_SHL || t == TOK_SAR) {
		next();
		expr_sum();
		gen_op(t);
	}
}

static void expr_cmp(void)
{
	int t;

	expr_shift();
	while (((t = tok) >= TOK_ULE && t <= TOK_GT) ||
	       t == TOK_ULT || t == TOK_UGE) {
		next();
		expr_shift();
		gen_op(t);
	}
}

static void expr_cmpeq(void)
{
	int t;

	expr_cmp();
	while ((t = tok) == TOK_EQ || t == TOK_NE) {
		next();
		expr_cmp();
		gen_op(t);
	}
}

static void expr_and(void)
{
	expr_cmpeq();
	while (tok == '&') {
		next();
		expr_cmpeq();
		gen_op('&');
	}
}

static void expr_xor(void)
{
	expr_and();
	while (tok == '^') {
		next();
		expr_and();
		gen_op('^');
	}
}

static void expr_or(void)
{
	expr_xor();
	while (tok == '|') {
		next();
		expr_xor();
		gen_op('|');
	}
}

static void expr_landor(int op);

static void expr_land(void)
{
	expr_or();
	if (tok == TOK_LAND)
		expr_landor(tok);
}

static void expr_lor(void)
{
	expr_land();
	if (tok == TOK_LOR)
		expr_landor(tok);
}

#define expr_landor_next(op) op == TOK_LAND ? expr_or() : expr_land()
#else
/* defined precedence_parser */
// 6374 "tccgen.c"
#define expr_landor_next(op) unary(), expr_infix(precedence(op) + 1)
#define expr_lor() unary(), expr_infix(1)

static int precedence(int tok)
{
	switch (tok) {
	case TOK_LOR:
		return 1;
	case TOK_LAND:
		return 2;
	case '|':
		return 3;
	case '^':
		return 4;
	case '&':
		return 5;
	case TOK_EQ:
	case TOK_NE:
		return 6;
relat:
	case TOK_ULT:
	case TOK_UGE:
		return 7;
	case TOK_SHL:
	case TOK_SAR:
		return 8;
	case '+':
	case '-':
		return 9;
	case '*':
	case '/':
	case '%':
		return 10;
	default:
		if (tok >= TOK_ULE && tok <= TOK_GT)
			goto relat;
		return 0;
	}
}
static unsigned char prec[256];
static void init_prec(void)
{
	int i;
	for (i = 0; i < 256; i++)
		prec[i] = precedence(i);
}
#define precedence(i) ((unsigned)i < 256 ? prec[i] : 0)

static void expr_landor(int op);

static void expr_infix(int p)
{
	int t = tok, p2;
	while ((p2 = precedence(t)) >= p) {
		if (t == TOK_LOR || t == TOK_LAND) {
			expr_landor(t);
		} else {
			next();
			unary();
			if (precedence(tok) > p2)
				expr_infix(p2 + 1);
			gen_op(t);
		}
		t = tok;
	}
}
#endif
/* Assuming vtop is a value used in a conditional context
   (i.e. compared with zero) return 0 if it's false, 1 if
   true and -1 if it can't be statically determined.  */

static int condition_3way(void)
{
	int c = -1;
	if ((vtop->r & (VT_VALMASK | VT_LVAL)) == VT_CONST &&
	    (!(vtop->r & VT_SYM) || !vtop->sym->a.weak)) {
		vdup();
		gen_cast_s(VT_BOOL);
		c = vtop->c.i;
		vpop();
	}
	return c;
}

static void expr_landor(int op)
{
	int t = 0, cc = 1, f = 0, i = op == TOK_LAND, c;
	for (;;) {
		c = f ? i : condition_3way();
		if (c < 0)
			save_regs(1), cc = 0;
		else if (c != i)
			nocode_wanted++, f = 1;
		if (tok != op)
			break;
		if (c < 0)
			t = gvtst(i, t);
		else
			vpop();
		next();
		expr_landor_next(op);
	}
	if (cc || f) {
		vpop();
		vpushi(i ^ f);
		gsym(t);
		nocode_wanted -= f;
	} else {
		gvtst_set(i, t);
	}
}

static int is_cond_bool(SValue *sv)
{
	if ((sv->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST
	    && (sv->type.t & VT_BTYPE) == VT_INT)
		return (unsigned)sv->c.i < 2;
	if (sv->r == VT_CMP)
		return 1;
	return 0;
}

static void expr_cond(void)
{
	int tt, u, r1, r2, rc, t1, t2, islv, c, g;
	SValue sv;
	CType type;

	expr_lor();
	if (tok == '?') {
		next();
		c = condition_3way();
		g = (tok == ':' && gnu_ext);
		tt = 0;
		if (!g) {
			if (c < 0) {
				save_regs(1);
				tt = gvtst(1, 0);
			} else {
				vpop();
			}
		} else if (c < 0) {
			/* needed to avoid having different registers saved in
			               each branch */

			save_regs(1);
			gv_dup();
			tt = gvtst(0, 0);
		}

		if (c == 0)
			nocode_wanted++;
		if (!g)
			gexpr();

		if ((vtop->type.t & VT_BTYPE) == VT_FUNC)
			mk_pointer(&vtop->type);
		sv = *vtop;/* save value to handle it later */

		vtop--;/* no vpop so that FP stack is not flushed */

		if (g) {
			u = tt;
		} else if (c < 0) {
			u = gjmp(0);
			gsym(tt);
		} else
			u = 0;

		if (c == 0)
			nocode_wanted--;
		if (c == 1)
			nocode_wanted++;
		skip(':');
		expr_cond();

		if ((vtop->type.t & VT_BTYPE) == VT_FUNC)
			mk_pointer(&vtop->type);
		/* cast operands to correct type according to ISOC rules */

		if (!combine_types(&type, &sv, vtop, '?'))
			type_incompatibility_error(&sv.type, &vtop->type,
						   "type mismatch in conditional expression (have '%s' and '%s')");

		if (c < 0 && is_cond_bool(vtop) && is_cond_bool(&sv)) {
			/* optimize "if (f ? a > b : c || d) ..." for example, where normally
			               "a < b" and "c || d" would be forced to "(int)0/1" first, whereas
			               this code jumps directly to the if's then/else branches. */

			t1 = gvtst(0, 0);
			t2 = gjmp(0);
			gsym(u);
			vpushv(&sv);
			/* combine jump targets of 2nd op with VT_CMP of 1st op */

			gvtst_set(0, t1);
			gvtst_set(1, t2);
			gen_cast(&type);
// tcc_warning("two conditions expr_cond");

			return;
		}
		/* keep structs lvalue by transforming `(expr ? a : b)` to `*(expr ? &a : &b)` so
		           that `(expr ? a : b).mem` does not error  with "lvalue expected" */

		islv = (vtop->r & VT_LVAL) && (sv.r & VT_LVAL)
		       && VT_STRUCT == (type.t & VT_BTYPE);
		/* now we convert second operand */

		if (c != 1) {
			gen_cast(&type);
			if (islv) {
				mk_pointer(&vtop->type);
				gaddrof();
			} else if (VT_STRUCT == (vtop->type.t & VT_BTYPE))
				gaddrof();
		}

		rc = RC_TYPE(type.t);
		/* for long longs, we use fixed registers to avoid having
		           to handle a complicated move */

		if (USING_TWO_WORDS(type.t))
			rc = RC_RET(type.t);

		tt = r2 = 0;
		if (c < 0) {
			r2 = gv(rc);
			tt = gjmp(0);
		}
		gsym(u);
		if (c == 1)
			nocode_wanted--;
		/* this is horrible, but we must also convert first
		           operand */

		if (c != 0) {
			*vtop = sv;
			gen_cast(&type);
			if (islv) {
				mk_pointer(&vtop->type);
				gaddrof();
			} else if (VT_STRUCT == (vtop->type.t & VT_BTYPE))
				gaddrof();
		}

		if (c < 0) {
			r1 = gv(rc);
			move_reg(r2, r1, islv ? VT_PTR : type.t);
			vtop->r = r2;
			gsym(tt);
		}

		if (islv)
			indir();
	}
}

static void expr_eq(void)
{
	int t;

	expr_cond();
	if ((t = tok) == '=' || TOK_ASSIGN(t)) {
		test_lvalue();
		next();
		if (t == '=') {
			expr_eq();
		} else {
			vdup();
			expr_eq();
			gen_op(TOK_ASSIGN_OP(t));
		}
		vstore();
	}
}

ST_FUNC void gexpr(void)
{
	expr_eq();
	if (tok == ',') {
		do {
			vpop();
			next();
			expr_eq();
		} while (tok == ',');
		/* convert array & function to pointer */

		convert_parameter_type(&vtop->type);
		/* make builtin_constant_p((1,2)) return 0 (like on gcc) */

		if ((vtop->r & VT_VALMASK) == VT_CONST && nocode_wanted && !CONST_WANTED)
			gv(RC_TYPE(vtop->type.t));
	}
}
/* parse a constant expression and return value in vtop.  */

static void expr_const1(void)
{
	nocode_wanted += CONST_WANTED_BIT;
	expr_cond();
	nocode_wanted -= CONST_WANTED_BIT;
}
/* parse an integer constant and return its value. */

static inline int64_t expr_const64(void)
{
	int64_t c;
	expr_const1();
	if ((vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM | VT_NONCONST)) != VT_CONST)
		expect("constant expression");
	c = vtop->c.i;
	vpop();
	return c;
}
/* parse an integer constant and return its value.
   Complain if it doesn't fit 32bit (signed or unsigned).  */

ST_FUNC int expr_const(void)
{
	int c;
	int64_t wc = expr_const64();
	c = wc;
	if (c != wc && (unsigned)c != wc)
		tcc_error("constant exceeds 32 bit");
	return c;
}
/* ------------------------------------------------------------------------- */
/* return from function */

static void gfunc_return(CType *func_type)
{
	if ((func_type->t & VT_BTYPE) == VT_STRUCT) {
		CType type, ret_type;
		int ret_align, ret_nregs, regsize;
		ret_nregs = gfunc_sret(func_type, func_var, &ret_type,
				       &ret_align, &regsize);
		if (ret_nregs < 0) {

		} else if (0 == ret_nregs) {
			/* if returning structure, must copy it to implicit
			               first pointer arg location */

			type = *func_type;
			mk_pointer(&type);
			vset(&type, VT_LOCAL | VT_LVAL, func_vc);
			indir();
			vswap();
			/* copy structure value to pointer */

			vstore();
		} else {
			/* returning structure packed into registers */

			int size, addr, align, rc, n;
			size = type_size(func_type,&align);
			if ((align & (ret_align - 1))
			    && ((vtop->r & VT_VALMASK) < VT_CONST/* pointer to struct */

				|| (vtop->c.i & (ret_align - 1))
			       )) {
				loc = (loc - size) & -ret_align;
				addr = loc;
				type = *func_type;
				vset(&type, VT_LOCAL | VT_LVAL, addr);
				vswap();
				vstore();
				vpop();
				vset(&ret_type, VT_LOCAL | VT_LVAL, addr);
			}
			vtop->type = ret_type;
			rc = RC_RET(ret_type.t);
//printf("struct return: n:%d t:%02x rc:%02x\n", ret_nreg\, ret_type.t, rc);

			for (n = ret_nregs; --n > 0;) {
				vdup();
				gv(rc);
				vswap();
				incr_offset(regsize);
				/* We assume that when a structure is returned in multiple
				                   registers, their classes are consecutive values of the
				                   suite s(n) = 2^n */

				rc <<= 1;
			}
			gv(rc);
			vtop -= ret_nregs - 1;
		}
	} else {
		gv(RC_RET(func_type->t));
	}
	vtop--;/* NOT vpop() because on x86 it would flush the fp stack */

}

static void check_func_return(void)
{
	if ((func_vt.t & VT_BTYPE) == VT_VOID)
		return;
	if (!strcmp (funcname, "main")
	    && (func_vt.t & VT_BTYPE) == VT_INT) {
		/* main returns 0 by default */

		vpushi(0);
		gen_assign_cast(&func_vt);
		gfunc_return(&func_vt);
	} else {
		tcc_warning("function might return no value: '%s'", funcname);
	}
}
/* ------------------------------------------------------------------------- */
/* switch/case */

static int case_cmp(uint64_t a, uint64_t b)
{
	if (cur_switch->sv.type.t & VT_UNSIGNED)
		return a < b ? -1 : a > b;
	else
		return (int64_t)a < (int64_t)b ? -1 : (int64_t)a > (int64_t)b;
}

static int case_cmp_qs(const void *pa, const void *pb)
{
	return case_cmp((*(struct case_t**)pa)->v1, (*(struct case_t**)pb)->v1);
}

static void case_sort(struct switch_t *sw)
{
	struct case_t **p;
	if (sw->n < 2)
		return;
	qsort(sw->p, sw->n, sizeof *sw->p, case_cmp_qs);
	p = sw->p;
	while (p < sw->p + sw->n - 1) {
		if (case_cmp(p[0]->v2, p[1]->v1) >= 0) {
			int l1 = p[0]->line, l2 = p[1]->line;
			/* using special format "%i:..." to show specific line */

			tcc_error("%i:duplicate case value", l1 > l2 ? l1 : l2);
		} else if (p[0]->v2 + 1 == p[1]->v1 && p[0]->ind == p[1]->ind) {
			/* treat "case 1: case 2: case 3:" like "case 1 ... 3: */

			p[1]->v1 = p[0]->v1;
			tcc_free(p[0]);
			memmove(p, p + 1, (--sw->n - (p - sw->p)) * sizeof *p);
		} else
			++p;
	}
}

static int gcase(struct case_t **base, int len, int dsym)
{
	struct case_t *p;
	int t, l2, e;

	t = vtop->type.t & VT_BTYPE;
	if (t != VT_LLONG)
		t = VT_INT;
	while (len) {
		/* binary search while len > 8, else linear */

		l2 = len > 8 ? len/2 : 0;
		p = base[l2];
		vdup(), vpush64(t, p->v2);
		if (l2 == 0 && p->v1 == p->v2) {
			gen_op(TOK_EQ);/* jmp to case when equal */

			gsym_addr(gvtst(0, 0), p->ind);
		} else {
			/* case v1 ... v2 */

			gen_op(TOK_GT);/* jmp over when > V2 */

			if (len == 1)/* last case test jumps to default when false */

				dsym = gvtst(0, dsym), e = 0;
			else
				e = gvtst(0, 0);
			vdup(), vpush64(t, p->v1);
			gen_op(TOK_GE);/* jmp to case when >= V1 */

			gsym_addr(gvtst(0, 0), p->ind);
			dsym = gcase(base, l2, dsym);
			gsym(e);
		}
		++l2, base += l2, len -= l2;
	}
	/* jump automagically will suppress more jumps */

	return gjmp(dsym);
}

static void end_switch(void)
{
	struct switch_t *sw = cur_switch;
	dynarray_reset(&sw->p, &sw->n);
	cur_switch = sw->prev;
	tcc_free(sw);
}
/* ------------------------------------------------------------------------- */
/* __attribute__((cleanup(fn))) */

static void try_call_scope_cleanup(Sym *stop)
{
	Sym *cls = cur_scope->cl.s;

	for (; cls != stop; cls = cls->next) {
		Sym *fs = cls->cleanup_func;
		Sym *vs = cls->prev_tok;

		vpushsym(&fs->type, fs);
		vset(&vs->type, vs->r, vs->c);
		vtop->sym = vs;
		mk_pointer(&vtop->type);
		gaddrof();
		gfunc_call(1);
	}
}

static void try_call_cleanup_goto(Sym *cleanupstate)
{
	Sym *oc, *cc;
	int ocd, ccd;

	if (!cur_scope->cl.s)
		return;
	/* search NCA of both cleanup chains given parents and initial depth */

	ocd = cleanupstate ? cleanupstate->v & ~SYM_FIELD : 0;
	for (ccd = cur_scope->cl.n, oc = cleanupstate; ocd > ccd; --ocd, oc = oc->next)
		;
	for (cc = cur_scope->cl.s; ccd > ocd; --ccd, cc = cc->next)
		;
	for (; cc != oc; cc = cc->next, oc = oc->next, --ccd)
		;

	try_call_scope_cleanup(cc);
}
/* call 'func' for each __attribute__((cleanup(func))) */

static void block_cleanup(struct scope *o)
{
	int jmp = 0;
	Sym *g, **pg;
	for (pg = &pending_gotos; (g = *pg) && g->c > o->cl.n;) {
		if (g->prev_tok->r & LABEL_FORWARD) {
			Sym *pcl = g->next;
			if (!jmp)
				jmp = gjmp(0);
			gsym(pcl->jnext);
			try_call_scope_cleanup(o->cl.s);
			pcl->jnext = gjmp(0);
			if (!o->cl.n)
				goto remove_pending;
			g->c = o->cl.n;
			pg = &g->prev;
		} else {
remove_pending:
			*pg = g->prev;
			sym_free(g);
		}
	}
	gsym(jmp);
	try_call_scope_cleanup(o->cl.s);
}
/* ------------------------------------------------------------------------- */
/* VLA */

static void vla_restore(int loc)
{
	if (loc)
		gen_vla_sp_restore(loc);
}

static void vla_leave(struct scope *o)
{
	struct scope *c = cur_scope, *v = NULL;
	for (; c != o && c; c = c->prev)
		if (c->vla.num)
			v = c;
	if (v)
		vla_restore(v->vla.locorig);
}
/* ------------------------------------------------------------------------- */
/* local scopes */

static void new_scope(struct scope *o)
{
	/* copy and link previous scope */

	*o = *cur_scope;
	o->prev = cur_scope;
	cur_scope = o;
	cur_scope->vla.num = 0;
	/* record local declaration stack position */

	o->lstk = local_stack;
	o->llstk = local_label_stack;
	++local_scope;
}

static void prev_scope(struct scope *o, int is_expr)
{
	vla_leave(o->prev);

	if (o->cl.s != o->prev->cl.s)
		block_cleanup(o->prev);
	/* pop locally defined labels */

	label_pop(&local_label_stack, o->llstk, is_expr);
	/* In the is_expr case (a statement expression is finished here),
	       vtop might refer to symbols on the local_stack.  Either via the
	       type or via vtop->sym.  We can't pop those nor any that in turn
	       might be referred to.  To make it easier we don't roll back
	       any symbols in that case; some upper level call to block() will
	       do that.  We do have to remove such symbols from the lookup
	       tables, though.  sym_pop will do that.  */
	/* pop locally defined symbols */
// 6961 "tccgen.c"
	pop_local_syms(o->lstk, is_expr);
	cur_scope = o->prev;
	--local_scope;
}
/* leave a scope via break/continue(/goto) */

static void leave_scope(struct scope *o)
{
	if (!o)
		return;
	try_call_scope_cleanup(o->cl.s);
	vla_leave(o);
}
/* short versiona for scopes with 'if/do/while/switch' which can
   declare only types (of struct/union/enum) */

static void new_scope_s(struct scope *o)
{
	o->lstk = local_stack;
	++local_scope;
}

static void prev_scope_s(struct scope *o)
{
	sym_pop(&local_stack, o->lstk, 0);
	--local_scope;
}
/* ------------------------------------------------------------------------- */
/* call block from 'for do while' loops */

static void lblock(int *bsym, int *csym)
{
	struct scope *lo = loop_scope, *co = cur_scope;
	int *b = co->bsym, *c = co->csym;
	if (csym) {
		co->csym = csym;
		loop_scope = co;
	}
	co->bsym = bsym;
	block(0);
	co->bsym = b;
	if (csym) {
		co->csym = c;
		loop_scope = lo;
	}
}

static void block(int flags)
{
	int a, b, c, d, e, t;
	struct scope o;
	Sym *s;

	if (flags & STMT_EXPR) {
		/* default return value is (void) */

		vpushi(0);
		vtop->type.t = VT_VOID;
	}

again:
	t = tok;
	/* If the token carries a value, next() might destroy it. Only with
	       invalid code such as f(){"123"4;} */

	if (TOK_HAS_VALUE(t))
		goto expr;
	next();

	if (debug_modes)
		tcc_tcov_check_line (tcc_state, 0), tcc_tcov_block_begin (tcc_state);

	if (t == TOK_IF) {
		new_scope_s(&o);
		skip('(');
		gexpr();
		skip(')');
		a = gvtst(1, 0);
		block(0);
		if (tok == TOK_ELSE) {
			d = gjmp(0);
			gsym(a);
			next();
			block(0);
			gsym(d);/* patch else jmp */

		} else {
			gsym(a);
		}
		prev_scope_s(&o);

	} else if (t == TOK_WHILE) {
		new_scope_s(&o);
		d = gind();
		skip('(');
		gexpr();
		skip(')');
		a = gvtst(1, 0);
		b = 0;
		lblock(&a, &b);
		gjmp_addr(d);
		gsym_addr(b, d);
		gsym(a);
		prev_scope_s(&o);

	} else if (t == '{') {
		if (debug_modes)
			tcc_debug_stabn(tcc_state, N_LBRAC, ind - func_ind);
		new_scope(&o);
		/* handle local labels declarations */

		while (tok == TOK_LABEL) {
			do {
				next();
				if (tok < TOK_UIDENT)
					expect("label identifier");
				label_push(&local_label_stack, tok, LABEL_DECLARED);
				next();
			} while (tok == ',');
			skip(';');
		}

		while (tok != '}') {
			decl(VT_LOCAL);
			if (tok != '}') {
				if (flags & STMT_EXPR)
					vpop();
				block(flags | STMT_COMPOUND);
			}
		}

		prev_scope(&o, flags & STMT_EXPR);
		if (debug_modes)
			tcc_debug_stabn(tcc_state, N_RBRAC, ind - func_ind);
		if (local_scope)
			next();
		else if (!nocode_wanted)
			check_func_return();

	} else if (t == TOK_RETURN) {
		b = (func_vt.t & VT_BTYPE) != VT_VOID;
		if (tok != ';') {
			gexpr();
			if (b) {
				gen_assign_cast(&func_vt);
			} else {
				if (vtop->type.t != VT_VOID)
					tcc_warning("void function returns a value");
				vtop--;
			}
		} else if (b) {
			tcc_warning("'return' with no value");
			b = 0;
		}
		leave_scope(root_scope);
		if (b)
			gfunc_return(&func_vt);
		skip(';');
		/* jump unless last stmt in top-level block */

		if (tok != '}' || local_scope != 1)
			rsym = gjmp(rsym);
		if (debug_modes)
			tcc_tcov_block_end (tcc_state, -1);
		CODE_OFF();

	} else if (t == TOK_BREAK) {
		/* compute jump */

		if (!cur_scope->bsym)
			tcc_error("cannot break");
		if (cur_switch && cur_scope->bsym == cur_switch->bsym)
			leave_scope(cur_switch->scope);
		else
			leave_scope(loop_scope);
		*cur_scope->bsym = gjmp(*cur_scope->bsym);
		skip(';');

	} else if (t == TOK_CONTINUE) {
		/* compute jump */

		if (!cur_scope->csym)
			tcc_error("cannot continue");
		leave_scope(loop_scope);
		*cur_scope->csym = gjmp(*cur_scope->csym);
		skip(';');

	} else if (t == TOK_FOR) {
		new_scope(&o);

		skip('(');
		if (tok != ';') {
			/* c99 for-loop init decl? */

			if (!decl(VT_JMP)) {
				/* no, regular for-loop init expr */

				gexpr();
				vpop();
			}
		}
		skip(';');
		a = b = 0;
		c = d = gind();
		if (tok != ';') {
			gexpr();
			a = gvtst(1, 0);
		}
		skip(';');
		if (tok != ')') {
			e = gjmp(0);
			d = gind();
			gexpr();
			vpop();
			gjmp_addr(c);
			gsym(e);
		}
		skip(')');
		lblock(&a, &b);
		gjmp_addr(d);
		gsym_addr(b, d);
		gsym(a);
		prev_scope(&o, 0);

	} else if (t == TOK_DO) {
		new_scope_s(&o);
		a = b = 0;
		d = gind();
		lblock(&a, &b);
		gsym(b);
		skip(TOK_WHILE);
		skip('(');
		gexpr();
		skip(')');
		skip(';');
		c = gvtst(0, 0);
		gsym_addr(c, d);
		gsym(a);
		prev_scope_s(&o);

	} else if (t == TOK_SWITCH) {
		struct switch_t *sw;

		sw = tcc_mallocz(sizeof *sw);
		sw->bsym = &a;
		sw->scope = cur_scope;
		sw->prev = cur_switch;
		sw->nocode_wanted = nocode_wanted;
		cur_switch = sw;

		new_scope_s(&o);
		skip('(');
		gexpr();
		skip(')');
		if (!is_integer_btype(vtop->type.t & VT_BTYPE))
			tcc_error("switch value not an integer");
		sw->sv = *vtop--;/* save switch value */

		a = 0;
		b = gjmp(0);/* jump to first case */

		lblock(&a, NULL);
		a = gjmp(a);/* add implicit break */

		/* case lookup */

		gsym(b);
		prev_scope_s(&o);
		if (sw->nocode_wanted)
			goto skip_switch;
		case_sort(sw);
		sw->bsym = NULL;/* marker for 32bit:gen_opl() */

		vpushv(&sw->sv);
		gv(RC_INT);
		d = gcase(sw->p, sw->n, 0);
		vpop();
		if (sw->def_sym)
			gsym_addr(d, sw->def_sym);
		else
			gsym(d);
skip_switch:
		/* break label */

		gsym(a);
		end_switch();

	} else if (t == TOK_CASE) {
		struct case_t *cr;
		if (!cur_switch)
			expect("switch");
		cr = tcc_malloc(sizeof(struct case_t));
		dynarray_add(&cur_switch->p, &cur_switch->n, cr);
		t = cur_switch->sv.type.t;
		cr->v1 = cr->v2 = value64(expr_const64(), t);
		if (tok == TOK_DOTS && gnu_ext) {
			next();
			cr->v2 = value64(expr_const64(), t);
			if (case_cmp(cr->v2, cr->v1) < 0)
				tcc_warning("empty case range");
		}
		/* case and default are unreachable from a switch under nocode_wanted */

		if (!cur_switch->nocode_wanted)
			cr->ind = gind();
		cr->line = file->line_num;
		skip(':');
		goto block_after_label;

	} else if (t == TOK_DEFAULT) {
		if (!cur_switch)
			expect("switch");
		if (cur_switch->def_sym)
			tcc_error("too many 'default'");
		cur_switch->def_sym = cur_switch->nocode_wanted ? -1 : gind();
		skip(':');
		goto block_after_label;

	} else if (t == TOK_GOTO) {
		vla_restore(cur_scope->vla.locorig);
		if (tok == '*' && gnu_ext) {
			/* computed goto */

			next();
			gexpr();
			if ((vtop->type.t & VT_BTYPE) != VT_PTR)
				expect("pointer");
			ggoto();

		} else if (tok >= TOK_UIDENT) {
			s = label_find(tok);
			/* put forward definition if needed */

			if (!s)
				s = label_push(&global_label_stack, tok, LABEL_FORWARD);
			else if (s->r == LABEL_DECLARED)
				s->r = LABEL_FORWARD;

			if (s->r & LABEL_FORWARD) {
				/* start new goto chain for cleanups, linked via label->next */

				if (cur_scope->cl.s && !nocode_wanted) {
					sym_push2(&pending_gotos, SYM_FIELD, 0, cur_scope->cl.n);
					pending_gotos->prev_tok = s;
					s = sym_push2(&s->next, SYM_FIELD, 0, 0);
					pending_gotos->next = s;
				}
				s->jnext = gjmp(s->jnext);
			} else {
				try_call_cleanup_goto(s->cleanupstate);
				gjmp_addr(s->jind);
			}
			next();

		} else {
			expect("label identifier");
		}
		skip(';');

	} else if (t == TOK_ASM1 || t == TOK_ASM2 || t == TOK_ASM3) {
		asm_instr();

	} else {
		if (tok == ':' && t >= TOK_UIDENT) {
			/* label case */

			next();
			s = label_find(t);
			if (s) {
				if (s->r == LABEL_DEFINED)
					tcc_error("duplicate label '%s'", get_tok_str(s->v, NULL));
				s->r = LABEL_DEFINED;
				if (s->next) {
					Sym *pcl;/* pending cleanup goto */

					for (pcl = s->next; pcl; pcl = pcl->prev)
						gsym(pcl->jnext);
					sym_pop(&s->next, NULL, 0);
				} else
					gsym(s->jnext);
			} else {
				s = label_push(&global_label_stack, t, LABEL_DEFINED);
			}
			s->jind = gind();
			s->cleanupstate = cur_scope->cl.s;

block_after_label: {
				/* Accept attributes after labels (e.g. 'unused') */

				AttributeDef ad_tmp;
				parse_attribute(&ad_tmp);
			}
			if (debug_modes)
				tcc_tcov_reset_ind(tcc_state);
			vla_restore(cur_scope->vla.loc);

			if (tok != '}') {
				if (0 == (flags & STMT_COMPOUND))
					goto again;
				/* C23: insert implicit null-statement whithin compound statement */

			} else {
				/* we accept this, but it is a mistake */

				tcc_warning_c(warn_all)("deprecated use of label at end of compound statement");
			}
		} else {
			/* expression case */

			if (t != ';') {
				unget_tok(t);
expr:
				if (flags & STMT_EXPR) {
					vpop();
					gexpr();
				} else {
					gexpr();
					vpop();
				}
				skip(';');
			}
		}
	}

	if (debug_modes)
		tcc_tcov_check_line (tcc_state, 0), tcc_tcov_block_end (tcc_state, 0);
}
/* This skips over a stream of tokens containing balanced {} and ()
   pairs, stopping at outer ',' ';' and '}' (or matching '}' if we started
   with a '{').  If STR then allocates and stores the skipped tokens
   in *STR.  This doesn't check if () and {} are nested correctly,
   i.e. "({)}" is accepted.  */

static void skip_or_save_block(TokenString **str)
{
	int braces = tok == '{';
	int level = 0;
	if (str)
		*str = tok_str_alloc();

	while (1) {
		int t = tok;
		if (level == 0
		    && (t == ','
			|| t == ';'
			|| t == '}'
			|| t == ')'
			|| t == ']'))
			break;
		if (t == TOK_EOF) {
			if (str || level > 0)
				tcc_error("unexpected end of file");
			else
				break;
		}
		if (str)
			tok_str_add_tok(*str);
		next();
		if (t == '{' || t == '(' || t == '[') {
			level++;
		} else if (t == '}' || t == ')' || t == ']') {
			level--;
			if (level == 0 && braces && t == '}')
				break;
		}
	}
	if (str)
		tok_str_add(*str, TOK_EOF);
}

#define EXPR_CONST 1
#define EXPR_ANY 2

static void parse_init_elem(int expr_type)
{
	int saved_global_expr;
	switch (expr_type) {
	case EXPR_CONST:
		/* compound literals must be allocated globally in this case */

		saved_global_expr = global_expr;
		global_expr = 1;
		expr_const1();
		global_expr = saved_global_expr;
		/* NOTE: symbols are accepted, as well as lvalue for anon symbols
			   (compound literals).  */

		if (((vtop->r & (VT_VALMASK | VT_LVAL)) != VT_CONST
		     && ((vtop->r & (VT_SYM|VT_LVAL)) != (VT_SYM|VT_LVAL)
			 || vtop->sym->v < SYM_FIRST_ANOM))

		    || ((vtop->r & VT_SYM) && vtop->sym->a.dllimport)

		   )
			tcc_error("initializer element is not constant");
		break;
	case EXPR_ANY:
		expr_eq();
		break;
	}
}

static void init_assert(init_params *p, int offset)
{
	if (p->sec ? !NODATA_WANTED && offset > p->sec->data_offset
	    : !nocode_wanted && offset > p->local_offset)
		tcc_internal_error("initializer overflow");
}
/* put zeros for variable based init */

static void init_putz(init_params *p, unsigned long c, int size)
{
	init_assert(p, c + size);
	if (p->sec) {
		/* nothing to do because globals are already set to zero */

	} else {
		vpush_helper_func(TOK_memset);
		vseti(VT_LOCAL, c);
		vpushi(0);
		vpushs(size);

		gfunc_call(3);
	}
}

#define DIF_FIRST 1
#define DIF_SIZE_ONLY 2
#define DIF_HAVE_ELEM 4
#define DIF_CLEAR 8
/* delete relocations for specified range c ... c + size. Unfortunatly
   in very special cases, relocations may occur unordered */

static void decl_design_delrels(Section *sec, int c, int size)
{
	ElfW_Rel *rel, *rel2, *rel_end;
	if (!sec || !sec->reloc)
		return;
	rel = rel2 = (ElfW_Rel*)sec->reloc->data;
	rel_end = (ElfW_Rel*)(sec->reloc->data + sec->reloc->data_offset);
	while (rel < rel_end) {
		if (rel->r_offset >= c && rel->r_offset < c + size) {
			sec->reloc->data_offset -= sizeof *rel;
		} else {
			if (rel2 != rel)
				memcpy(rel2, rel, sizeof *rel);
			++rel2;
		}
		++rel;
	}
}

static void decl_design_flex(init_params *p, Sym *ref, int index)
{
	if (ref == p->flex_array_ref) {
		if (index >= ref->c)
			ref->c = index + 1;
	} else if (ref->c < 0)
		tcc_error("flexible array has zero size in this context");
}
/* t is the array or struct type. c is the array or struct
   address. cur_field is the pointer to the current
   field, for arrays the 'c' member contains the current start
   index.  'flags' is as in decl_initializer.
   'al' contains the already initialized length of the
   current container (starting at c).  This returns the new length of that.  */

static int decl_designator(init_params *p, CType *type, unsigned long c,
			   Sym **cur_field, int flags, int al)
{
	Sym *s, *f;
	int index, index_last, align, l, nb_elems, elem_size;
	unsigned long corig = c;

	elem_size = 0;
	nb_elems = 1;

	if (flags & DIF_HAVE_ELEM)
		goto no_designator;

	if (gnu_ext && tok >= TOK_UIDENT) {
		l = tok, next();
		if (tok == ':')
			goto struct_field;
		unget_tok(l);
	}
	/* NOTE: we only support ranges for last designator */

	while (nb_elems == 1 && (tok == '[' || tok == '.')) {
		if (tok == '[') {
			if (!(type->t & VT_ARRAY))
				expect("array type");
			next();
			index = index_last = expr_const();
			if (tok == TOK_DOTS && gnu_ext) {
				next();
				index_last = expr_const();
			}
			skip(']');
			s = type->ref;
			decl_design_flex(p, s, index_last);
			if (index < 0 || index_last >= s->c || index_last < index)
				tcc_error("index exceeds array bounds or range is empty");
			if (cur_field)
				(*cur_field)->c = index_last;
			type = pointed_type(type);
			elem_size = type_size(type, &align);
			c += index * elem_size;
			nb_elems = index_last - index + 1;
		} else {
			int cumofs;
			next();
			l = tok;
struct_field:
			next();
			f = find_field(type, l, &cumofs);
			if (cur_field)
				*cur_field = f;
			type = &f->type;
			c += cumofs;
		}
		cur_field = NULL;
	}
	if (!cur_field) {
		if (tok == '=') {
			next();
		} else if (!gnu_ext) {
			expect("=");
		}
	} else {
no_designator:
		if (type->t & VT_ARRAY) {
			index = (*cur_field)->c;
			s = type->ref;
			decl_design_flex(p, s, index);
			if (index >= s->c)
				tcc_error("too many initializers");
			type = pointed_type(type);
			elem_size = type_size(type, &align);
			c += index * elem_size;
		} else {
			f = *cur_field;
			/* Skip bitfield padding. Also with size 32 and 64. */

			while (f && (f->v & SYM_FIRST_ANOM) &&
			       is_integer_btype(f->type.t & VT_BTYPE))
				*cur_field = f = f->next;
			if (!f)
				tcc_error("too many initializers");
			type = &f->type;
			c += f->c;
		}
	}

	if (!elem_size)/* for structs */

		elem_size = type_size(type, &align);
	/* Using designators the same element can be initialized more
	       than once.  In that case we need to delete possibly already
	       existing relocations. */

	if (!(flags & DIF_SIZE_ONLY) && c - corig < al) {
		decl_design_delrels(p->sec, c, elem_size * nb_elems);
		flags &= ~DIF_CLEAR;/* mark stack dirty too */

	}

	decl_initializer(p, type, c, flags & ~DIF_FIRST);

	if (!(flags & DIF_SIZE_ONLY) && nb_elems > 1) {
		Sym aref = {0};
		CType t1;
		int i;
		if (p->sec || (type->t & VT_ARRAY)) {
			/* make init_putv/vstore believe it were a struct */

			aref.c = elem_size;
			t1.t = VT_STRUCT, t1.ref = &aref;
			type = &t1;
		}
		if (p->sec)
			vpush_ref(type, p->sec, c, elem_size);
		else
			vset(type, VT_LOCAL|VT_LVAL, c);
		for (i = 1; i < nb_elems; i++) {
			vdup();
			init_putv(p, type, c + elem_size * i);
		}
		vpop();
	}

	c += nb_elems * elem_size;
	if (c - corig > al)
		al = c - corig;
	return al;
}
/* store a value or an expression directly in global data or in local array */

static void init_putv(init_params *p, CType *type, unsigned long c)
{
	int bt;
	void *ptr;
	CType dtype;
	int size, align;
	Section *sec = p->sec;
	uint64_t val;

	dtype = *type;
	dtype.t &= ~VT_CONSTANT;/* need to do that to avoid false warning */

	size = type_size(type, &align);
	if (type->t & VT_BITFIELD)
		size = (BIT_POS(type->t) + BIT_SIZE(type->t) + 7) / 8;
	init_assert(p, c + size);

	if (sec) {
		/* XXX: not portable */
		/* XXX: generate error if incorrect relocation */

		gen_assign_cast(&dtype);
		bt = type->t & VT_BTYPE;

		if ((vtop->r & VT_SYM)
		    && bt != VT_PTR
		    && (bt != (PTR_SIZE == 8 ? VT_LLONG : VT_INT)
			|| (type->t & VT_BITFIELD))
		    && !((vtop->r & VT_CONST) && vtop->sym->v >= SYM_FIRST_ANOM)
		   )
			tcc_error("initializer element is not computable at load time");

		if (NODATA_WANTED) {
			vtop--;
			return;
		}

		ptr = sec->data + c;
		val = vtop->c.i;
		/* XXX: make code faster ? */

		if ((vtop->r & (VT_SYM|VT_CONST)) == (VT_SYM|VT_CONST) &&
		    vtop->sym->v >= SYM_FIRST_ANOM &&
		    /* XXX This rejects compound literals like
		    	       '(void *){ptr}'.  The problem is that '&sym' is
		    	       represented the same way, which would be ruled out
		    	       by the SYM_FIRST_ANOM check above, but also '"string"'
		    	       in 'char *p = "string"' is represented the same
		    	       with the type being VT_PTR and the symbol being an
		    	       anonymous one.  That is, there's no difference in vtop
		    	       between '(void *){x}' and '&(void *){x}'.  Ignore
		    	       pointer typed entities here.  Hopefully no real code
		    	       will ever use compound literals with scalar type.  */
// 7688 "tccgen.c"
		    (vtop->type.t & VT_BTYPE) != VT_PTR) {
			/* These come from compound literals, memcpy stuff over.  */

			Section *ssec;
			ElfSym *esym;
			ElfW_Rel *rel;
			esym = elfsym(vtop->sym);
			ssec = tcc_state->sections[esym->st_shndx];
			memmove (ptr, ssec->data + esym->st_value + (int)vtop->c.i, size);
			if (ssec->reloc) {
				/* We need to copy over all memory contents, and that
						   includes relocations.  Use the fact that relocs are
						   created it order, so look from the end of relocs
						   until we hit one before the copied region.  */

				unsigned long relofs = ssec->reloc->data_offset;
				while (relofs >= sizeof(*rel)) {
					relofs -= sizeof(*rel);
					rel = (ElfW_Rel*)(ssec->reloc->data + relofs);
					if (rel->r_offset >= esym->st_value + size)
						continue;
					if (rel->r_offset < esym->st_value)
						break;
					put_elf_reloca(symtab_section, sec,
						       c + rel->r_offset - esym->st_value,
						       ELFW(R_TYPE)(rel->r_info),
						       ELFW(R_SYM)(rel->r_info),
#if PTR_SIZE == 8

						       rel->r_addend
#else

						       0
#endif

						      );
				}
			}
		} else {
			if (type->t & VT_BITFIELD) {
				int bit_pos, bit_size, bits, n;
				unsigned char *p, v, m;
				bit_pos = BIT_POS(vtop->type.t);
				bit_size = BIT_SIZE(vtop->type.t);
				p = (unsigned char*)ptr + (bit_pos >> 3);
				bit_pos &= 7, bits = 0;
				while (bit_size) {
					n = 8 - bit_pos;
					if (n > bit_size)
						n = bit_size;
					v = val >> bits << bit_pos;
					m = ((1 << n) - 1) << bit_pos;
					*p = (*p & ~m) | (v & m);
					bits += n, bit_size -= n, bit_pos = 0, ++p;
				}
			} else
				switch (bt) {
				case VT_BOOL:
					*(char *)ptr = val != 0;
					break;
				case VT_BYTE:
					*(char *)ptr = val;
					break;
				case VT_SHORT:
					write16le(ptr, val);
					break;
				case VT_FLOAT:
					write32le(ptr, val);
					break;
				case VT_DOUBLE:
					write64le(ptr, val);
					break;
				case VT_LDOUBLE:
#if defined TCC_IS_NATIVE_387
					/* Host and target platform may be different but both have x87.
					                   On windows, tcc does not use VT_LDOUBLE, except when it is a
					                   cross compiler.  In this case a mingw gcc as host compiler
					                   comes here with 10-byte long doubles, while msvc or tcc won't.
					                   tcc itself can still translate by asm.
					                   In any case we avoid possibly random bytes 11 and 12.
					                */
// 7764 "tccgen.c"
					if (sizeof (long double) >= 10)
						memcpy(ptr, &vtop->c.ld, 10);
#ifdef __TINYC__

					else if (sizeof (long double) == sizeof (double))
						__asm__("fldl %1\nfstpt %0\n" : "=m" (*ptr) : "m" (vtop->c.ld));
#endif

					else
#endif
						/* For other platforms it should work natively, but may not work
						                   for cross compilers */

						if (sizeof(long double) == LDOUBLE_SIZE)
							memcpy(ptr, &vtop->c.ld, LDOUBLE_SIZE);
						else if (sizeof(double) == LDOUBLE_SIZE)
							*(double*)ptr = (double)vtop->c.ld;
						else if (0 == memcmp(ptr, &vtop->c.ld, LDOUBLE_SIZE))
							;/* nothing to do for 0.0 */

#ifndef TCC_CROSS_TEST

						else
							tcc_error("can't cross compile long double constants");
#endif

					break;
#if PTR_SIZE == 8
				/* intptr_t may need a reloc too, see tcctest.c:relocation_test() */

				case VT_LLONG:
				case VT_PTR:
					if (vtop->r & VT_SYM)
						greloca(sec, vtop->sym, c, R_DATA_PTR, val);
					else
						write64le(ptr, val);
					break;
				case VT_INT:
					write32le(ptr, val);
					break;
#else

				case VT_LLONG:
					write64le(ptr, val);
					break;
				case VT_PTR:
				case VT_INT:
					if (vtop->r & VT_SYM)
						greloc(sec, vtop->sym, c, R_DATA_PTR);
					write32le(ptr, val);
					break;
#endif
// 7809 "tccgen.c"
				default:
//tcc_internal_error("unexpected type");

					break;
				}
		}
		vtop--;
	} else {
		vset(&dtype, VT_LOCAL|VT_LVAL, c);
		vswap();
		vstore();
		vpop();
	}
}
/* 't' contains the type and storage info. 'c' is the offset of the
   object in section 'sec'. If 'sec' is NULL, it means stack based
   allocation. 'flags & DIF_FIRST' is true if array '{' must be read (multi
   dimension implicit array init handling). 'flags & DIF_SIZE_ONLY' is true if
   size only evaluation is wanted (only for arrays). */

static void decl_initializer(init_params *p, CType *type, unsigned long c,
			     int flags)
{
	int len, n, no_oblock, i;
	int size1, align1;
	Sym *s, *f;
	Sym indexsym;
	CType *t1;
	/* generate line number info */

	if (debug_modes && !(flags & DIF_SIZE_ONLY) && !p->sec)
		tcc_debug_line(tcc_state), tcc_tcov_check_line (tcc_state, 1);

	if (!(flags & DIF_HAVE_ELEM) && tok != '{' &&
	    /* In case of strings we have special handling for arrays, so
	    	   don't consume them as initializer value (which would commit them
	    \	   to some anonymous symbol).  */

	    tok != TOK_LSTR && tok != TOK_STR &&
	    (!(flags & DIF_SIZE_ONLY)
	     /* a struct may be initialized from a struct of same type, as in
	                         struct {int x,y;} a = {1,2}, b = {3,4}, c[] = {a,b};
	                    In that case we need to parse the element in order to check
	                    it for compatibility below */

	     || (type->t & VT_BTYPE) == VT_STRUCT)
	   ) {
		int ncw_prev = nocode_wanted;
		if ((flags & DIF_SIZE_ONLY) && !p->sec)
			++nocode_wanted;
		parse_init_elem(!p->sec ? EXPR_ANY : EXPR_CONST);
		nocode_wanted = ncw_prev;
		flags |= DIF_HAVE_ELEM;
	}

	if (type->t & VT_ARRAY) {
		no_oblock = 1;
		if (((flags & DIF_FIRST) && tok != TOK_LSTR && tok != TOK_STR) ||
		    tok == '{') {
			skip('{');
			no_oblock = 0;
		}

		s = type->ref;
		n = s->c;
		t1 = pointed_type(type);
		size1 = type_size(t1, &align1);
		/* only parse strings here if correct type (otherwise: handle
		           them as ((w)char *) expressions */

		if ((tok == TOK_LSTR &&

		     (t1->t & VT_BTYPE) == VT_SHORT && (t1->t & VT_UNSIGNED)

		    ) || (tok == TOK_STR && (t1->t & VT_BTYPE) == VT_BYTE)) {
			len = 0;
			cstr_reset(&initstr);
			if (size1 != (tok == TOK_STR ? 1 : sizeof(nwchar_t)))
				tcc_error("unhandled string literal merging");
			while (tok == TOK_STR || tok == TOK_LSTR) {
				if (initstr.size)
					initstr.size -= size1;
				if (tok == TOK_STR)
					len += tokc.str.size;
				else
					len += tokc.str.size / sizeof(nwchar_t);
				len--;
				cstr_cat(&initstr, tokc.str.data, tokc.str.size);
				next();
			}
			if (tok != ')' && tok != '}' && tok != ',' && tok != ';'
			    && tok != TOK_EOF) {
				/* Not a lone literal but part of a bigger expression.  */

				unget_tok(size1 == 1 ? TOK_STR : TOK_LSTR);
				tokc.str.size = initstr.size;
				tokc.str.data = initstr.data;
				goto do_init_array;
			}

			decl_design_flex(p, s, len);
			if (!(flags & DIF_SIZE_ONLY)) {
				int nb = n, ch;
				if (len < nb)
					nb = len;
				if (len > nb)
					tcc_warning("initializer-string for array is too long");
				/* in order to go faster for common case (char
				                   string in global variable, we handle it
				                   specifically */

				if (p->sec && size1 == 1) {
					init_assert(p, c + nb);
					if (!NODATA_WANTED)
						memcpy(p->sec->data + c, initstr.data, nb);
				} else {
					for (i=0; i<n; i++) {
						if (i >= nb) {
							/* only add trailing zero if enough storage (no
							                             warning in this case since it is standard) */

							if (flags & DIF_CLEAR)
								break;
							if (n - i >= 4) {
								init_putz(p, c + i * size1, (n - i) * size1);
								break;
							}
							ch = 0;
						} else if (size1 == 1)
							ch = ((unsigned char *)initstr.data)[i];
						else
							ch = ((nwchar_t *)initstr.data)[i];
						vpushi(ch);
						init_putv(p, t1, c + i * size1);
					}
				}
			}
		} else {

do_init_array:
			indexsym.c = 0;
			f = &indexsym;

do_init_list:
			/* zero memory once in advance */

			if (!(flags & (DIF_CLEAR | DIF_SIZE_ONLY))) {
				init_putz(p, c, n*size1);
				flags |= DIF_CLEAR;
			}

			len = 0;
			/* GNU extension: if the initializer is empty for a flex array,
			               it's size is zero.  We won't enter the loop, so set the size
			               now.  */

			decl_design_flex(p, s, len);
			while (tok != '}' || (flags & DIF_HAVE_ELEM)) {
				len = decl_designator(p, type, c, &f, flags, len);
				flags &= ~DIF_HAVE_ELEM;
				if (type->t & VT_ARRAY) {
					++indexsym.c;
					/* special test for multi dimensional arrays (may not
							       be strictly correct if designators are used at the
							       same time) */

					if (no_oblock && len >= n*size1)
						break;
				} else {
					if (s->type.t == VT_UNION)
						f = NULL;
					else
						f = f->next;
					if (no_oblock && f == NULL)
						break;
				}

				if (tok == '}')
					break;
				skip(',');
			}
		}
		if (!no_oblock)
			skip('}');

	} else if ((flags & DIF_HAVE_ELEM)
		   /* Use i_c_parameter_t, to strip toplevel qualifiers.
		              The source type might have VT_CONSTANT set, which is
		              of course assignable to non-const elements.  */

		   && is_compatible_unqualified_types(type, &vtop->type)) {
		goto one_elem;

	} else if ((type->t & VT_BTYPE) == VT_STRUCT) {
		no_oblock = 1;
		if ((flags & DIF_FIRST) || tok == '{') {
			skip('{');
			no_oblock = 0;
		}
		s = type->ref;
		f = s->next;
		n = s->c;
		size1 = 1;
		goto do_init_list;

	} else if (tok == '{') {
		if (flags & DIF_HAVE_ELEM)
			skip(';');
		next();
		decl_initializer(p, type, c, flags & ~DIF_HAVE_ELEM);
		skip('}');

} else one_elem:
		if ((flags & DIF_SIZE_ONLY)) {
			/* If we supported only ISO C we wouldn't have to accept calling
				   this on anything than an array if DIF_SIZE_ONLY (and even then
				   only on the outermost level, so no recursion would be needed),
				   because initializing a flex array member isn't supported.
				   But GNU C supports it, so we need to recurse even into
				   subfields of structs and arrays when DIF_SIZE_ONLY is set.  */
			/* just skip expression */

			if (flags & DIF_HAVE_ELEM)
				vpop();
			else
				skip_or_save_block(NULL);

		} else {
			if (!(flags & DIF_HAVE_ELEM)) {
				/* This should happen only when we haven't parsed
					       the init element above for fear of committing a
					       string constant to memory too early.  */

				if (tok != TOK_STR && tok != TOK_LSTR)
					expect("string constant");
				parse_init_elem(!p->sec ? EXPR_ANY : EXPR_CONST);
			}
			if (!p->sec && (flags & DIF_CLEAR)/* container was already zero'd */

			    && (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST
			    && vtop->c.i == 0
			    && btype_size(type->t & VT_BTYPE)/* not for fp constants */

			   )
				vpop();
			else
				init_putv(p, type, c);
		}
}
/* parse an initializer for type 't' if 'has_init' is non zero, and
   allocate space in local or global data space ('r' is either
   VT_LOCAL or VT_CONST). If 'v' is non zero, then an associated
   variable 'v' of scope 'scope' is declared before initializers
   are parsed. If 'v' is zero, then a reference to the new object
   is put in the value stack. If 'has_init' is 2, a special parsing
   is done to handle string constants. */
// 8052 "tccgen.c"
static void decl_initializer_alloc(CType *type, AttributeDef *ad, int r,
				   int has_init, int v, int global)
{
	int size, align, addr;
	TokenString *init_str = NULL;

	Section *sec;
	Sym *flexible_array;
	Sym *sym;
	int saved_nocode_wanted = nocode_wanted;
#ifdef CONFIG_TCC_BCHECK

	int bcheck = tcc_state->do_bounds_check && !NODATA_WANTED;
#endif

	init_params p = {0};
	/* Always allocate static or global variables */

	if (v && (r & VT_VALMASK) == VT_CONST)
		nocode_wanted |= DATA_ONLY_WANTED;

	flexible_array = NULL;
	size = type_size(type, &align);
	/* exactly o\ne flexible array may be initialized, either the
	       toplevel array or the last member of the toplevel struct */

	if (size < 0) {
// error out except for top-level incomplete arrays
// (arrays of incomplete types are handled in array parsing)

		if (!(type->t & VT_ARRAY))
			tcc_error("initialization of incomplete type");
		/* If the base type itself was an array type of unspecified size
		           (like in 'typedef int arr[]; arr x = {1};') then we will
		           overwrite the unknown size by the real one for this decl.
		           We need to unshare the ref symbol holding that size. */

		type->ref = sym_push(SYM_FIELD, &type->ref->type, 0, type->ref->c);
		p.flex_array_ref = type->ref;

	} else if (has_init && (type->t & VT_BTYPE) == VT_STRUCT) {
		Sym *field = type->ref->next;
		if (field) {
			while (field->next)
				field = field->next;
			if (field->type.t & VT_ARRAY && field->type.ref->c < 0) {
				flexible_array = field;
				p.flex_array_ref = field->type.ref;
				size = -1;
			}
		}
	}

	if (size < 0) {
		/* If unknown size, do a dry-run 1st pass */

		if (!has_init)
			tcc_error("unknown type size");
		if (has_init == 2) {
			/* only get strings */

			init_str = tok_str_alloc();
			while (tok == TOK_STR || tok == TOK_LSTR) {
				tok_str_add_tok(init_str);
				next();
			}
			tok_str_add(init_str, TOK_EOF);
		} else
			skip_or_save_block(&init_str);
		unget_tok(0);
		/* compute size */

		begin_macro(init_str, 1);
		next();
		decl_initializer(&p, type, 0, DIF_FIRST | DIF_SIZE_ONLY);
		/* prepare second initializer parsing */

		macro_ptr = init_str->str;
		next();
		/* if still unknown size, error */

		size = type_size(type, &align);
		if (size < 0)
			tcc_error("unknown type size");
		/* If there's a flex member and it was used in the initializer
		           adjust size.  */

		if (flexible_array && flexible_array->type.ref->c > 0)
			size += flexible_array->type.ref->c
				* pointed_size(&flexible_array->type);
	}
	/* take into account specified alignment if bigger */

	if (ad->a.aligned) {
		int speca = 1 << (ad->a.aligned - 1);
		if (speca > align)
			align = speca;
	} else if (ad->a.packed) {
		align = 1;
	}

	if (!v && NODATA_WANTED)
		size = 0, align = 1;

	if ((r & VT_VALMASK) == VT_LOCAL) {
		sec = NULL;
#ifdef CONFIG_TCC_BCHECK

		if (bcheck && v) {
			/* add padding between stack variables for bound checking */

			loc -= align;
		}
#endif

		loc = (loc - size) & -align;
		addr = loc;
		p.local_offset = addr + size;
#ifdef CONFIG_TCC_BCHECK

		if (bcheck && v) {
			/* add padding between stack variables for bound checking */

			loc -= align;
		}
#endif

		if (v) {
			/* local variable */
#ifdef CONFIG_TCC_ASM

			if (ad->asm_label) {
				int reg = asm_parse_regvar(ad->asm_label);
				if (reg >= 0)
					r = (r & ~VT_VALMASK) | reg;
			}
#endif

			sym = sym_push(v, type, r, addr);
			if (ad->cleanup_func) {
				Sym *cls = sym_push2(&all_cleanups,
						     SYM_FIELD | ++cur_scope->cl.n, 0, 0);
				cls->prev_tok = sym;
				cls->cleanup_func = ad->cleanup_func;
				cls->next = cur_scope->cl.s;
				cur_scope->cl.s = cls;
			}

			sym->a = ad->a;
		} else {
			/* push local reference */

			vset(type, r, addr);
		}
	} else {
		sym = NULL;
		if (v && global) {
			/* see if the symbol was already defined */

			sym = sym_find(v);
			if (sym) {
				if (p.flex_array_ref && (sym->type.t & type->t & VT_ARRAY)
				    && sym->type.ref->c > type->ref->c) {
					/* flex array was already declared with explicit size
					                            extern int arr[10];
					                            int arr[] = { 1,2,3 }; */

					type->ref->c = sym->type.ref->c;
					size = type_size(type, &align);
				}
				patch_storage(sym, ad, type);
				/* we accept several definitions of the same global variable. */

				if (!has_init && sym->c && elfsym(sym)->st_shndx != SHN_UNDEF)
					goto no_alloc;
			}
		}
		/* allocate symbol in corresponding section */

		sec = ad->section;
		if (!sec) {
			CType *tp = type;
			while ((tp->t & (VT_BTYPE|VT_ARRAY)) == (VT_PTR|VT_ARRAY))
				tp = &tp->ref->type;
			if (tp->t & VT_CONSTANT) {
				sec = rodata_section;
			} else if (has_init) {
				sec = data_section;
				/*if (g_debug & 4)
				                    tcc_warning("rw data: %s", get_tok_str(v, 0));*/

			} else if (tcc_state->nocommon)
				sec = bss_section;
		}

		if (sec) {
			addr = section_add(sec, size, align);
#ifdef CONFIG_TCC_BCHECK

			/* add padding if bound check */

			if (bcheck)
				section_add(sec, 1, 1);
#endif

		} else {
			addr = align;/* SHN_COMMON is special, symbol value is align */

			sec = common_section;
		}

		if (v) {
			if (!sym) {
				sym = sym_push(v, type, r | VT_SYM, 0);
				patch_storage(sym, ad, NULL);
			}
			/* update symbol definition */

			put_extern_sym(sym, sec, addr, size);
		} else {
			/* push global reference */

			vpush_ref(type, sec, addr, size);
			sym = vtop->sym;
			vtop->r |= r;
		}
#ifdef CONFIG_TCC_BCHECK

		/* handles bounds now because the symbol must be defined
		   before for the relocation */

		if (bcheck) {
			addr_t *bounds_ptr;

			greloca(bounds_section, sym, bounds_section->data_offset, R_DATA_PTR, 0);
			/* then add global bound info */

			bounds_ptr = section_ptr_add(bounds_section, 2 * sizeof(addr_t));
			bounds_ptr[0] = 0; /* relocated */

			bounds_ptr[1] = size;
		}
#endif
// 8268 "tccgen.c"
	}

	if (type->t & VT_VLA) {
		int a;

		if (NODATA_WANTED)
			goto no_alloc;
		/* save before-VLA stack pointer if needed */

		if (cur_scope->vla.num == 0) {
			if (cur_scope->prev && cur_scope->prev->vla.num) {
				cur_scope->vla.locorig = cur_scope->prev->vla.loc;
			} else {
				gen_vla_sp_save(loc -= PTR_SIZE);
				cur_scope->vla.locorig = loc;
			}
		}

		vpush_type_size(type, &a);
		gen_vla_alloc(type, a);
		/* on _WIN64, because of the function args scratch area, the
		           result of alloca differs from RSP and is returned in RAX.  */

		gen_vla_result(addr), addr = (loc -= PTR_SIZE);

		gen_vla_sp_save(addr);
		cur_scope->vla.loc = addr;
		cur_scope->vla.num++;
	} else if (has_init) {
		p.sec = sec;
		decl_initializer(&p, type, addr, DIF_FIRST);
		/* patch flexible array member size back to -1, */
		/* for possible subsequent similar declarations */

		if (flexible_array)
			flexible_array->type.ref->c = -1;
	}

no_alloc:
	/* restore parse state if needed */

	if (init_str) {
		end_macro();
		next();
	}

	nocode_wanted = saved_nocode_wanted;
}
/* generate vla code saved in post_type() */

static void func_vla_arg_code(Sym *arg)
{
	int align;
	TokenString *vla_array_tok = NULL;

	if (arg->type.ref)
		func_vla_arg_code(arg->type.ref);

	if ((arg->type.t & VT_VLA) && arg->type.ref->vla_array_str) {
		loc -= type_size(&int_type, &align);
		loc &= -align;
		arg->type.ref->c = loc;

		unget_tok(0);
		vla_array_tok = tok_str_alloc();
		vla_array_tok->str = arg->type.ref->vla_array_str;
		begin_macro(vla_array_tok, 1);
		next();
		gexpr();
		end_macro();
		next();
		vpush_type_size(&arg->type.ref->type, &align);
		gen_op('*');
		vset(&int_type, VT_LOCAL|VT_LVAL, arg->type.ref->c);
		vswap();
		vstore();
		vpop();
	}
}

static void func_vla_arg(Sym *sym)
{
	Sym *arg;

	for (arg = sym->type.ref->next; arg; arg = arg->next)
		if ((arg->type.t & VT_BTYPE) == VT_PTR && (arg->type.ref->type.t & VT_VLA))
			func_vla_arg_code(arg->type.ref);
}
/* parse a function defined by symbol 'sym' and generate its code in
   'cur_text_section' */

static void gen_function(Sym *sym)
{
	struct scope f = { 0 };
	cur_scope = root_scope = &f;
	nocode_wanted = 0;

	ind = cur_text_section->data_offset;
	if (sym->a.aligned) {
		size_t newoff = section_add(cur_text_section, 0,
					    1 << (sym->a.aligned - 1));
		gen_fill_nops(newoff - ind);
	}

	funcname = get_tok_str(sym->v, NULL);
	func_ind = ind;
	func_vt = sym->type.ref->type;
	func_var = sym->type.ref->f.func_type == FUNC_ELLIPSIS;
	/* NOTE: we patch the symbol size later */

	put_extern_sym(sym, cur_text_section, ind, 0);

	if (sym->type.ref->f.func_ctor)
		add_array (tcc_state, ".init_array", sym->c);
	if (sym->type.ref->f.func_dtor)
		add_array (tcc_state, ".fini_array", sym->c);
	/* put debug symbol */

	tcc_debug_funcstart(tcc_state, sym);
	/* push a dummy symbol to enable local sym storage */

	sym_push2(&local_stack, SYM_FIELD, 0, 0);
	local_scope = 1;/* for function parameters */

	nb_temp_local_vars = 0;
	gfunc_prolog(sym);
	tcc_debug_prolog_epilog(tcc_state, 0);

	local_scope = 0;
	rsym = 0;
	func_vla_arg(sym);
	block(0);
	gsym(rsym);

	nocode_wanted = 0;
	/* reset local stack */

	pop_local_syms(NULL, 0);
	tcc_debug_prolog_epilog(tcc_state, 1);
	gfunc_epilog();
	/* end of function */

	tcc_debug_funcend(tcc_state, ind - func_ind);
	/* patch symbol size */

	elfsym(sym)->st_size = ind - func_ind;

	cur_text_section->data_offset = ind;
	local_scope = 0;
	label_pop(&global_label_stack, NULL, 0);
	sym_pop(&all_cleanups, NULL, 0);
	/* It's better to crash than to generate wrong code */

	cur_text_section = NULL;
	funcname = "";/* for safety */

	func_vt.t = VT_VOID;/* for safety */

	func_var = 0;/* for safety */

	ind = 0;/* for safety */

	func_ind = -1;
	nocode_wanted = DATA_ONLY_WANTED;
	check_vstack();
	/* do this after funcend debug info */

	next();
}

static void gen_inline_functions(TCCState *s)
{
	Sym *sym;
	int inline_generated, i;
	struct InlineFunc *fn;

	tcc_open_bf(s, ":inline:", 0);
	/* iterate while inline function are referenced */

	do {
		inline_generated = 0;
		for (i = 0; i < s->nb_inline_fns; ++i) {
			fn = s->inline_fns[i];
			sym = fn->sym;
			if (sym && (sym->c || !(sym->type.t & VT_INLINE))) {
				/* the function was used or forced (and then not internal):
				                   generate its code and convert it to a normal function */

				fn->sym = NULL;
				tccpp_putfile(fn->filename);
				begin_macro(fn->func_str, 1);
				next();
				cur_text_section = text_section;
				gen_function(sym);
				end_macro();

				inline_generated = 1;
			}
		}
	} while (inline_generated);
	tcc_close();
}

static void free_inline_functions(TCCState *s)
{
	int i;
	/* free tokens of unused inline functions */

	for (i = 0; i < s->nb_inline_fns; ++i) {
		struct InlineFunc *fn = s->inline_fns[i];
		if (fn->sym)
			tok_str_free(fn->func_str);
	}
	dynarray_reset(&s->inline_fns, &s->nb_inline_fns);
}

static void do_Static_assert(void)
{
	int c;
	const char *msg;

	next();
	skip('(');
	c = expr_const();
	msg = "_Static_assert fail";
	if (tok == ',') {
		next();
		msg = parse_mult_str("string constant")->data;
	}
	skip(')');
	if (c == 0)
		tcc_error("%s", msg);
	skip(';');
}
/* 'l' is VT_LOCAL or VT_CONST to define default storage type
   or VT_CMP if parsing old style parameter list
   or VT_JMP if parsing c99 for decl: for (int i = 0, ...) */

static int decl(int l)
{
	int v, has_init, r, oldint;
	CType type, btype;
	Sym *sym;
	AttributeDef ad, adbase;
	ElfSym *esym;

	while (1) {

		oldint = 0;
		if (!parse_btype(&btype, &adbase, l == VT_LOCAL)) {
			if (l == VT_JMP)
				return 0;
			/* skip redundant ';' if not in old parameter decl scope */

			if (tok == ';' && l != VT_CMP) {
				next();
				continue;
			}
			if (tok == TOK_STATIC_ASSERT) {
				do_Static_assert();
				continue;
			}
			if (l != VT_CONST)
				break;
			if (tok == TOK_ASM1 || tok == TOK_ASM2 || tok == TOK_ASM3) {
				/* global asm block */

				asm_global_instr();
				continue;
			}
			if (tok >= TOK_UIDENT) {
				/* special test for old K&R protos without explicit int
				                  type. Only accepted when defining global data */

				btype.t = VT_INT;
				oldint = 1;
			} else {
				if (tok != TOK_EOF)
					expect("declaration");
				break;
			}
		}

		if (tok == ';') {
			if ((btype.t & VT_BTYPE) == VT_STRUCT) {
				v = btype.ref->v;
				if (!(v & SYM_FIELD) && (v & ~SYM_STRUCT) >= SYM_FIRST_ANOM)
					tcc_warning("unnamed struct/union that defines no instances");
				next();
				continue;
			}
			if (IS_ENUM(btype.t)) {
				next();
				continue;
			}
		}

		while (1) {/* iterate thru each declaration */

			type = btype;
			ad = adbase;
			type_decl(&type, &ad, &v, TYPE_DIRECT);

			if ((type.t & VT_BTYPE) == VT_FUNC) {
				if ((type.t & VT_STATIC) && (l != VT_CONST))
					tcc_error("function without file scope cannot be static");
				/* if old style function prototype, we accept a
				                   declaration list */

				sym = type.ref;
				if (sym->f.func_type == FUNC_OLD && l == VT_CONST) {
					func_vt = type;
					decl(VT_CMP);
				}

				if ((type.t & (VT_EXTERN|VT_INLINE)) == (VT_EXTERN|VT_INLINE)) {
					/* always_inline functions must be handled as if they
					                       don't generate multiple global defs, even if extern
					                       inline, i.e. GNU inline semantics for those.  Rewrite
					                       them into static inline.  */

					if (tcc_state->gnu89_inline || sym->f.func_alwinl)
						type.t = (type.t & ~VT_EXTERN) | VT_STATIC;
					else
						type.t &= ~VT_INLINE;/* always compile otherwise */

				}

			} else if (oldint) {
				tcc_warning("type defaults to int");
			}

			if (gnu_ext && (tok == TOK_ASM1 || tok == TOK_ASM2 || tok == TOK_ASM3)) {
				ad.asm_label = asm_label_instr();
				/* parse one last attribute list, after asm label */

				parse_attribute(&ad);

			}

			if (ad.a.dllimport || ad.a.dllexport) {
				if (type.t & VT_STATIC)
					tcc_error("cannot have dll linkage with static");
				if (type.t & VT_TYPEDEF) {
					tcc_warning("'%s' attribute ignored for typedef",
						    ad.a.dllimport ? (ad.a.dllimport = 0, "dllimport") :
						    (ad.a.dllexport = 0, "dllexport"));
				} else if (ad.a.dllimport) {
					if ((type.t & VT_BTYPE) == VT_FUNC)
						ad.a.dllimport = 0;
					else
						type.t |= VT_EXTERN;
				}
			}

			if (tok == '{') {
				if (l != VT_CONST)
					tcc_error("cannot use local functions");
				if ((type.t & VT_BTYPE) != VT_FUNC)
					expect("function definition");
				/* reject abstract declarators in function definition
				                   make old style params without decl have int type */

				sym = type.ref;
				while ((sym = sym->next) != NULL) {
					if (!(sym->v & ~SYM_FIELD))
						expect("identifier");
					if (sym->type.t == VT_VOID)
						sym->type = int_type;
				}
				/* apply post-declaraton attributes */

				merge_funcattr(&type.ref->f, &ad.f);
				/* put function symbol */

				type.t &= ~VT_EXTERN;
				sym = external_sym(v, &type, 0, &ad);
				/* static inline functions are just recorded as a kind
				                   of macro. Their code will be emitted at the end of
				                   the compilation unit only if they are used */

				if (sym->type.t & VT_INLINE) {
					struct InlineFunc *fn;
					fn = tcc_malloc(sizeof *fn + strlen(file->filename));
					strcpy(fn->filename, file->filename);
					fn->sym = sym;
					dynarray_add(&tcc_state->inline_fns,
						     &tcc_state->nb_inline_fns, fn);
					skip_or_save_block(&fn->func_str);
				} else {
					/* compute text section */

					cur_text_section = ad.section;
					if (!cur_text_section)
						cur_text_section = text_section;
					else if (cur_text_section->sh_num > bss_section->sh_num)
						cur_text_section->sh_flags = text_section->sh_flags;
					gen_function(sym);
				}
				break;
			} else {
				if (l == VT_CMP) {
					/* find parameter in function parameter list */

					for (sym = func_vt.ref->next; sym; sym = sym->next)
						if ((sym->v & ~SYM_FIELD) == v)
							goto found;
					tcc_error("declaration for parameter '%s' but no such parameter",
						  get_tok_str(v, NULL));
found:
					if (type.t & VT_STORAGE)/* 'register' is okay */

						tcc_error("storage class specified for '%s'",
							  get_tok_str(v, NULL));
					if (sym->type.t != VT_VOID)
						tcc_error("redefinition of parameter '%s'",
							  get_tok_str(v, NULL));
					convert_parameter_type(&type);
					sym->type = type;
				} else if (type.t & VT_TYPEDEF) {
					/* save typedefed type  */
					/* XXX: test storage specifiers ? */

					sym = sym_find(v);
					if (sym && sym->sym_scope == local_scope) {
						if (!is_compatible_types(&sym->type, &type)
						    || !(sym->type.t & VT_TYPEDEF))
							tcc_error("incompatible redefinition of '%s'",
								  get_tok_str(v, NULL));
						sym->type = type;
					} else {
						sym = sym_push(v, &type, 0, 0);
					}
					sym->a = ad.a;
					if ((type.t & VT_BTYPE) == VT_FUNC)
						merge_funcattr(&sym->type.ref->f, &ad.f);
					if (debug_modes)
						tcc_debug_typedef (tcc_state, sym);
				} else if ((type.t & VT_BTYPE) == VT_VOID
					   && !(type.t & VT_EXTERN)) {
					tcc_error("declaration of void object");
				} else {
					r = 0;
					if ((type.t & VT_BTYPE) == VT_FUNC) {
						/* external function definition */
						/* specific case for func_call attribute */

						merge_funcattr(&type.ref->f, &ad.f);
					} else if (!(type.t & VT_ARRAY)) {
						/* not lvalue if array */

						r |= VT_LVAL;
					}
					has_init = (tok == '=');
					if (has_init && (type.t & VT_VLA))
						tcc_error("variable length array cannot be initialized");

					if (((type.t & VT_EXTERN) && (!has_init || l != VT_CONST))
					    || (type.t & VT_BTYPE) == VT_FUNC
					    /* as with GCC, uninitialized global arrays with no size
					                               are considered extern: */

					    || ((type.t & VT_ARRAY) && !has_init
						&& l == VT_CONST && type.ref->c < 0)
					   ) {
						/* external variable or function */

						type.t |= VT_EXTERN;
						external_sym(v, &type, r, &ad);
					} else {
						if (l == VT_CONST || (type.t & VT_STATIC))
							r |= VT_CONST;
						else
							r |= VT_LOCAL;
						if (has_init)
							next();
						else if (l == VT_CONST)
							/* uninitialized global variables may be overridden */

							type.t |= VT_EXTERN;
						decl_initializer_alloc(&type, &ad, r, has_init, v, l == VT_CONST);
					}

					if (ad.alias_target && l == VT_CONST) {
						/* Aliases need to be emitted when their target symbol
						                           is emitted, even if perhaps unreferenced.
						                           We only support the case where the base is already
						                           defined, otherwise we would need deferring to emit
						                           the aliases until the end of the compile unit.  */

						esym = elfsym(sym_find(ad.alias_target));
						if (!esym)
							tcc_error("unsupported forward __alias__ attribute");
						put_extern_sym2(sym_find(v), esym->st_shndx,
								esym->st_value, esym->st_size, 1);
					}
				}
				if (tok != ',') {
					if (l == VT_JMP)
						return 1;
					skip(';');
					break;
				}
				next();
			}
		}
	}
	return 0;
}
/* ------------------------------------------------------------------------- */

#undef gjmp_addr
#undef gjmp
/* ------------------------------------------------------------------------- */
// 28 "libtcc.c" 2
// 1 "tccdbg.c" 1
// 21 "tccdbg.c"
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 22 "tccdbg.c" 2
/* stab debug support */

static const struct {
	int type;
	int size;
	int encoding;
	const char *name;
} default_debug[] = {
	{ VT_INT, 4, DW_ATE_signed, "int:t1=r1;-2147483648;2147483647;" },
	{ VT_BYTE, 1, DW_ATE_signed_char, "char:t2=r2;0;127;" },
#if LONG_SIZE == 4

	{ VT_LONG | VT_INT, 4, DW_ATE_signed, "long int:t3=r3;-2147483648;2147483647;" },
#else

	{ VT_LLONG | VT_LONG, 8, DW_ATE_signed, "long int:t3=r3;-9223372036854775808;9223372036854775807;" },
#endif

	{ VT_INT | VT_UNSIGNED, 4, DW_ATE_unsigned, "unsigned int:t4=r4;0;037777777777;" },
#if LONG_SIZE == 4

	{ VT_LONG | VT_INT | VT_UNSIGNED, 4, DW_ATE_unsigned, "long unsigned int:t5=r5;0;037777777777;" },
#else

	/* use octal instead of -1 so size_t works (-gstabs+ in gcc) */

	{ VT_LLONG | VT_LONG | VT_UNSIGNED, 8, DW_ATE_unsigned, "long unsigned int:t5=r5;0;01777777777777777777777;" },
#endif

	{ VT_QLONG, 16, DW_ATE_signed, "__int128:t6=r6;0;-1;" },
	{ VT_QLONG | VT_UNSIGNED, 16, DW_ATE_unsigned, "__int128 unsigned:t7=r7;0;-1;" },
	{ VT_LLONG, 8, DW_ATE_signed, "long long int:t8=r8;-9223372036854775808;9223372036854775807;" },
	{ VT_LLONG | VT_UNSIGNED, 8, DW_ATE_unsigned, "long long unsigned int:t9=r9;0;01777777777777777777777;" },
	{ VT_SHORT, 2, DW_ATE_signed, "short int:t10=r10;-32768;32767;" },
	{ VT_SHORT | VT_UNSIGNED, 2, DW_ATE_unsigned, "short unsigned int:t11=r11;0;65535;" },
	{ VT_BYTE | VT_DEFSIGN, 1, DW_ATE_signed_char, "signed char:t12=r12;-128;127;" },
	{ VT_BYTE | VT_DEFSIGN | VT_UNSIGNED, 1, DW_ATE_unsigned_char, "unsigned char:t13=r13;0;255;" },
	{ VT_FLOAT, 4, DW_ATE_float, "float:t14=r1;4;0;" },
	{ VT_DOUBLE, 8, DW_ATE_float, "double:t15=r1;8;0;" },
#ifdef TCC_USING_DOUBLE_FOR_LDOUBLE

	{ VT_DOUBLE | VT_LONG, 8, DW_ATE_float, "long double:t16=r1;8;0;" },
#else

	{ VT_LDOUBLE, 16, DW_ATE_float, "long double:t16=r1;16;0;" },
#endif

	{ -1, -1, -1, "_Float32:t17=r1;4;0;" },
	{ -1, -1, -1, "_Float64:t18=r1;8;0;" },
	{ -1, -1, -1, "_Float128:t19=r1;16;0;" },
	{ -1, -1, -1, "_Float32x:t20=r1;8;0;" },
	{ -1, -1, -1, "_Float64x:t21=r1;16;0;" },
	{ -1, -1, -1, "_Decimal32:t22=r1;4;0;" },
	{ -1, -1, -1, "_Decimal64:t23=r1;8;0;" },
	{ -1, -1, -1, "_Decimal128:t24=r1;16;0;" },
	/* if default char is unsigned */

	{ VT_BYTE | VT_UNSIGNED, 1, DW_ATE_unsigned_char, "unsigned char:t25=r25;0;255;" },
	/* boolean type */

	{ VT_BOOL, 1, DW_ATE_boolean, "bool:t26=r26;0;255;" },
#if LONG_SIZE == 4

	{ VT_VOID, 1, DW_ATE_unsigned_char, "void:t27=27" },
#else

	/* bitfields use these */

	{ VT_LONG | VT_INT, 8, DW_ATE_signed, "long int:t27=r27;-9223372036854775808;9223372036854775807;" },
	{ VT_LONG | VT_INT | VT_UNSIGNED, 8, DW_ATE_unsigned, "long unsigned int:t28=r28;0;01777777777777777777777;" },
	{ VT_VOID, 1, DW_ATE_unsigned_char, "void:t29=29" },
#endif

};

#define N_DEFAULT_DEBUG (sizeof (default_debug) / sizeof (default_debug[0]))
/* dwarf debug */

#define DWARF_LINE_BASE -5
#define DWARF_LINE_RANGE 14
#define DWARF_OPCODE_BASE 13

#define DWARF_MIN_INSTR_LEN 1

#define DWARF_ABBREV_COMPILE_UNIT 1
#define DWARF_ABBREV_BASE_TYPE 2
#define DWARF_ABBREV_VARIABLE_EXTERNAL 3
#define DWARF_ABBREV_VARIABLE_STATIC 4
#define DWARF_ABBREV_VARIABLE_LOCAL 5
#define DWARF_ABBREV_FORMAL_PARAMETER 6
#define DWARF_ABBREV_POINTER 7
#define DWARF_ABBREV_ARRAY_TYPE 8
#define DWARF_ABBREV_SUBRANGE_TYPE 9
#define DWARF_ABBREV_TYPEDEF 10
#define DWARF_ABBREV_ENUMERATOR_SIGNED 11
#define DWARF_ABBREV_ENUMERATOR_UNSIGNED 12
#define DWARF_ABBREV_ENUMERATION_TYPE 13
#define DWARF_ABBREV_MEMBER 14
#define DWARF_ABBREV_MEMBER_BF 15
#define DWARF_ABBREV_STRUCTURE_TYPE 16
#define DWARF_ABBREV_STRUCTURE_EMPTY_TYPE 17
#define DWARF_ABBREV_UNION_TYPE 18
#define DWARF_ABBREV_UNION_EMPTY_TYPE 19
#define DWARF_ABBREV_SUBPROGRAM_EXTERNAL 20
#define DWARF_ABBREV_SUBPROGRAM_STATIC 21
#define DWARF_ABBREV_LEXICAL_BLOCK 22
#define DWARF_ABBREV_LEXICAL_EMPTY_BLOCK 23
#define DWARF_ABBREV_SUBROUTINE_TYPE 24
#define DWARF_ABBREV_SUBROUTINE_EMPTY_TYPE 25
#define DWARF_ABBREV_FORMAL_PARAMETER2 26
/* all entries should have been generated with dwarf_uleb128 except
   has_children. All values are currently below 128 so this currently
   works.  */

static const unsigned char dwarf_abbrev_init[] = {
	DWARF_ABBREV_COMPILE_UNIT, DW_TAG_compile_unit, 1,
	DW_AT_producer, DW_FORM_strp,
	DW_AT_language, DW_FORM_data1,
	DW_AT_name, DW_FORM_line_strp,
	DW_AT_comp_dir, DW_FORM_line_strp,
	DW_AT_low_pc, DW_FORM_addr,
#if PTR_SIZE == 4
	DW_AT_high_pc, DW_FORM_data4,
#else

	DW_AT_high_pc, DW_FORM_data8,
#endif

	DW_AT_stmt_list, DW_FORM_sec_offset,
	0, 0,
	DWARF_ABBREV_BASE_TYPE, DW_TAG_base_type, 0,
	DW_AT_byte_size, DW_FORM_udata,
	DW_AT_encoding, DW_FORM_data1,
	DW_AT_name, DW_FORM_strp,
	0, 0,
	DWARF_ABBREV_VARIABLE_EXTERNAL, DW_TAG_variable, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_external, DW_FORM_flag,
	DW_AT_location, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_VARIABLE_STATIC, DW_TAG_variable, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_location, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_VARIABLE_LOCAL, DW_TAG_variable, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_location, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_FORMAL_PARAMETER, DW_TAG_formal_parameter, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_location, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_POINTER, DW_TAG_pointer_type, 0,
	DW_AT_byte_size, DW_FORM_data1,
	DW_AT_type, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_ARRAY_TYPE, DW_TAG_array_type, 1,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_sibling, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_SUBRANGE_TYPE, DW_TAG_subrange_type, 0,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_upper_bound, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_TYPEDEF, DW_TAG_typedef, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_ENUMERATOR_SIGNED, DW_TAG_enumerator, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_const_value, DW_FORM_sdata,
	0, 0,
	DWARF_ABBREV_ENUMERATOR_UNSIGNED, DW_TAG_enumerator, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_const_value, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_ENUMERATION_TYPE, DW_TAG_enumeration_type, 1,
	DW_AT_name, DW_FORM_strp,
	DW_AT_encoding, DW_FORM_data1,
	DW_AT_byte_size, DW_FORM_data1,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_sibling, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_MEMBER, DW_TAG_member, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_data_member_location, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_MEMBER_BF, DW_TAG_member, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_bit_size, DW_FORM_udata,
	DW_AT_data_bit_offset, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_STRUCTURE_TYPE, DW_TAG_structure_type, 1,
	DW_AT_name, DW_FORM_strp,
	DW_AT_byte_size, DW_FORM_udata,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_sibling, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_STRUCTURE_EMPTY_TYPE, DW_TAG_structure_type, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_byte_size, DW_FORM_udata,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_UNION_TYPE, DW_TAG_union_type, 1,
	DW_AT_name, DW_FORM_strp,
	DW_AT_byte_size, DW_FORM_udata,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_sibling, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_UNION_EMPTY_TYPE, DW_TAG_union_type, 0,
	DW_AT_name, DW_FORM_strp,
	DW_AT_byte_size, DW_FORM_udata,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	0, 0,
	DWARF_ABBREV_SUBPROGRAM_EXTERNAL, DW_TAG_subprogram, 1,
	DW_AT_external, DW_FORM_flag,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_low_pc, DW_FORM_addr,
#if PTR_SIZE == 4
	DW_AT_high_pc, DW_FORM_data4,
#else

	DW_AT_high_pc, DW_FORM_data8,
#endif

	DW_AT_sibling, DW_FORM_ref4,
	DW_AT_frame_base, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_SUBPROGRAM_STATIC, DW_TAG_subprogram, 1,
	DW_AT_name, DW_FORM_strp,
	DW_AT_decl_file, DW_FORM_udata,
	DW_AT_decl_line, DW_FORM_udata,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_low_pc, DW_FORM_addr,
#if PTR_SIZE == 4
	DW_AT_high_pc, DW_FORM_data4,
#else

	DW_AT_high_pc, DW_FORM_data8,
#endif

	DW_AT_sibling, DW_FORM_ref4,
	DW_AT_frame_base, DW_FORM_exprloc,
	0, 0,
	DWARF_ABBREV_LEXICAL_BLOCK, DW_TAG_lexical_block, 1,
	DW_AT_low_pc, DW_FORM_addr,
#if PTR_SIZE == 4
	DW_AT_high_pc, DW_FORM_data4,
#else

	DW_AT_high_pc, DW_FORM_data8,
#endif

	0, 0,
	DWARF_ABBREV_LEXICAL_EMPTY_BLOCK, DW_TAG_lexical_block, 0,
	DW_AT_low_pc, DW_FORM_addr,
#if PTR_SIZE == 4
	DW_AT_high_pc, DW_FORM_data4,
#else

	DW_AT_high_pc, DW_FORM_data8,
#endif

	0, 0,
	DWARF_ABBREV_SUBROUTINE_TYPE, DW_TAG_subroutine_type, 1,
	DW_AT_type, DW_FORM_ref4,
	DW_AT_sibling, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_SUBROUTINE_EMPTY_TYPE, DW_TAG_subroutine_type, 0,
	DW_AT_type, DW_FORM_ref4,
	0, 0,
	DWARF_ABBREV_FORMAL_PARAMETER2, DW_TAG_formal_parameter, 0,
	DW_AT_type, DW_FORM_ref4,
	0, 0,
	0
};

static const unsigned char dwarf_line_opcodes[] = {
	0,1,1,1,1,0,0,0,1,0,0,1
};
/* ------------------------------------------------------------------------- */
/* debug state */

struct _tccdbg {

	int last_line_num, new_file;
	int section_sym;

	int debug_next_type;

	struct _debug_hash {
		int debug_type;
		Sym *type;
	} *debug_hash;

	struct _debug_anon_hash {
		Sym *type;
		int n_debug_type;
		int *debug_type;
	} *debug_anon_hash;

	int n_debug_hash;
	int n_debug_anon_hash;

	struct _debug_info {
		int start;
		int end;
		int n_sym;
		struct debug_sym {
			int type;
			unsigned long value;
			char *str;
			Section *sec;
			int sym_index;
			int info;
			int file;
			int line;
		} *sym;
		struct _debug_info *child, *next, *last, *parent;
	} *debug_info, *debug_info_root;

	struct {
		int info;
		int abbrev;
		int line;
		int str;
		int line_str;
	} dwarf_sym;

	struct {
		int start;
		int dir_size;
		char **dir_table;
		int filename_size;
		struct dwarf_filename_struct {
			int dir_entry;
			char *name;
		} *filename_table;
		int line_size;
		int line_max_size;
		unsigned char *line_data;
		int cur_file;
		int last_file;
		int last_pc;
		int last_line;
	} dwarf_line;

	struct {
		int start;
		Sym *func;
		int line;
		int base_type_used[N_DEFAULT_DEBUG];
	} dwarf_info;
	/* test coverage */

	struct {
		unsigned long offset;
		unsigned long last_file_name;
		unsigned long last_func_name;
		int ind;
		int line;
	} tcov_data;

};

#define last_line_num s1->dState->last_line_num
#define new_file s1->dState->new_file
#define section_sym s1->dState->section_sym
#define debug_next_type s1->dState->debug_next_type
#define debug_hash s1->dState->debug_hash
#define debug_anon_hash s1->dState->debug_anon_hash
#define n_debug_hash s1->dState->n_debug_hash
#define n_debug_anon_hash s1->dState->n_debug_anon_hash
#define debug_info s1->dState->debug_info
#define debug_info_root s1->dState->debug_info_root
#define dwarf_sym s1->dState->dwarf_sym
#define dwarf_line s1->dState->dwarf_line
#define dwarf_info s1->dState->dwarf_info
#define tcov_data s1->dState->tcov_data

#define FDE_ENCODING (DW_EH_PE_udata4 | DW_EH_PE_signed | DW_EH_PE_pcrel)
/* ------------------------------------------------------------------------- */

static void put_stabs(TCCState *s1, const char *str, int type, int other,
		      int desc, unsigned long value);

ST_FUNC void tcc_debug_new(TCCState *s1)
{
	int shf = 0;
	if (!s1->dState)
		s1->dState = tcc_mallocz(sizeof *s1->dState);
#ifdef CONFIG_TCC_BACKTRACE
	/* include stab info with standalone backtrace support */

	if (s1->do_debug && s1->output_type == TCC_OUTPUT_MEMORY)
		s1->do_backtrace = 1;
	if (s1->do_backtrace)
		shf = SHF_ALLOC;/* have debug data available at runtime */

#endif

	if (s1->dwarf) {
		s1->dwlo = s1->nb_sections;
		dwarf_info_section =
			new_section(s1, ".debug_info", SHT_PROGBITS, shf);
		dwarf_abbrev_section =
			new_section(s1, ".debug_abbrev", SHT_PROGBITS, shf);
		dwarf_line_section =
			new_section(s1, ".debug_line", SHT_PROGBITS, shf);
		dwarf_aranges_section =
			new_section(s1, ".debug_aranges", SHT_PROGBITS, shf);
		shf |= SHF_MERGE | SHF_STRINGS;
		dwarf_str_section =
			new_section(s1, ".debug_str", SHT_PROGBITS, shf);
		dwarf_str_section->sh_entsize = 1;
		dwarf_info_section->sh_addralign =
			dwarf_abbrev_section->sh_addralign =
				dwarf_line_section->sh_addralign =
					dwarf_aranges_section->sh_addralign =
						dwarf_str_section->sh_addralign = 1;
		if (s1->dwarf >= 5) {
			dwarf_line_str_section =
				new_section(s1, ".debug_line_str", SHT_PROGBITS, shf);
			dwarf_line_str_section->sh_entsize = 1;
			dwarf_line_str_section->sh_addralign = 1;
		}
		s1->dwhi = s1->nb_sections;
	} else {
		stab_section = new_section(s1, ".stab", SHT_PROGBITS, shf);
		stab_section->sh_entsize = sizeof(Stab_Sym);
		stab_section->sh_addralign = sizeof ((Stab_Sym*)0)->n_value;
		stab_section->link = new_section(s1, ".stabstr", SHT_STRTAB, shf);
		/* put first entry */

		put_stabs(s1, "", 0, 0, 0, 0);
	}
}
/* put stab debug information */

static void put_stabs(TCCState *s1, const char *str, int type, int other,
		      int desc,
		      unsigned long value)
{
	Stab_Sym *sym;

	unsigned offset;
	if (type == N_SLINE
	    && (offset = stab_section->data_offset)
	    && (sym = (Stab_Sym*)(stab_section->data + offset) - 1)
	    && sym->n_type == type
	    && sym->n_value == value) {
		/* just update line_number in previous entry */

		sym->n_desc = desc;
		return;
	}

	sym = section_ptr_add(stab_section, sizeof(Stab_Sym));
	if (str) {
		sym->n_strx = put_elf_str(stab_section->link, str);
	} else {
		sym->n_strx = 0;
	}
	sym->n_type = type;
	sym->n_other = other;
	sym->n_desc = desc;
	sym->n_value = value;
}

static void put_stabs_r(TCCState *s1, const char *str, int type, int other,
			int desc,
			unsigned long value, Section *sec, int sym_index)
{
	put_elf_reloc(symtab_section, stab_section,
		      stab_section->data_offset + 8,
		      sizeof ((Stab_Sym*)0)->n_value == PTR_SIZE ? R_DATA_PTR : R_DATA_32,
		      sym_index);
	put_stabs(s1, str, type, other, desc, value);
}

static void put_stabn(TCCState *s1, int type, int other, int desc, int value)
{
	put_stabs(s1, NULL, type, other, desc, value);
}
/* ------------------------------------------------------------------------- */

#define dwarf_data1(s,data) (*(uint8_t*)section_ptr_add((s), 1) = (data))

#define dwarf_data2(s,data) write16le(section_ptr_add((s), 2), (data))

#define dwarf_data4(s,data) write32le(section_ptr_add((s), 4), (data))

#define dwarf_data8(s,data) write64le(section_ptr_add((s), 8), (data))

static int dwarf_get_section_sym(Section *s)
{
	TCCState *s1 = s->s1;
	return put_elf_sym(symtab_section, 0, 0,
			   ELFW(ST_INFO)(STB_LOCAL, STT_SECTION), 0,
			   s->sh_num, NULL);
}

static void dwarf_reloc(Section *s, int sym, int rel)
{
	TCCState *s1 = s->s1;
	put_elf_reloca(symtab_section, s, s->data_offset, rel, sym, 0);
}

static void dwarf_string(Section *s, Section *dw, int sym, const char *str)
{
	TCCState *s1 = s->s1;
	int offset, len;
	char *ptr;

	len = strlen(str) + 1;
	offset = dw->data_offset;
	ptr = section_ptr_add(dw, len);
	memmove(ptr, str, len);
	put_elf_reloca(symtab_section, s, s->data_offset, R_DATA_32DW, sym,
		       PTR_SIZE == 4 ? 0 : offset);
	dwarf_data4(s, PTR_SIZE == 4 ? offset : 0);
}

static void dwarf_strp(Section *s, const char *str)
{
	TCCState *s1 = s->s1;
	dwarf_string(s, dwarf_str_section, dwarf_sym.str, str);
}

static void dwarf_line_strp(Section *s, const char *str)
{
	TCCState *s1 = s->s1;
	dwarf_string(s, dwarf_line_str_section, dwarf_sym.line_str, str);
}

static void dwarf_line_op(TCCState *s1, unsigned char op)
{
	if (dwarf_line.line_size >= dwarf_line.line_max_size) {
		dwarf_line.line_max_size += 1024;
		dwarf_line.line_data =
			(unsigned char *)tcc_realloc(dwarf_line.line_data,
						     dwarf_line.line_max_size);
	}
	dwarf_line.line_data[dwarf_line.line_size++] = op;
}

static void dwarf_file(TCCState *s1)
{
	int i, j;
	char *filename;
	int index_offset = s1->dwarf < 5;

	if (!strcmp(file->filename, "<command line>")) {
		dwarf_line.cur_file = 1;
		return;
	}
	filename = strrchr(file->filename, '/');
	if (filename == NULL) {
		for (i = 1; i < dwarf_line.filename_size; i++)
			if (dwarf_line.filename_table[i].dir_entry == 0 &&
			    strcmp(dwarf_line.filename_table[i].name,
				   file->filename) == 0) {
				dwarf_line.cur_file = i + index_offset;
				return;
			}
		i = -index_offset;
		filename = file->filename;
	} else {
		char *undo = filename;
		char *dir = file->filename;

		*filename++ = '\0';
		for (i = 0; i < dwarf_line.dir_size; i++)
			if (strcmp(dwarf_line.dir_table[i], dir) == 0) {
				for (j = 1; j < dwarf_line.filename_size; j++)
					if (dwarf_line.filename_table[j].dir_entry - index_offset
					    == i &&
					    strcmp(dwarf_line.filename_table[j].name,
						   filename) == 0) {
						*undo = '/';
						dwarf_line.cur_file = j + index_offset;
						return;
					}
				break;
			}
		if (i == dwarf_line.dir_size) {
			dwarf_line.dir_size++;
			dwarf_line.dir_table =
				(char **) tcc_realloc(dwarf_line.dir_table,
						      dwarf_line.dir_size *
						      sizeof (char *));
			dwarf_line.dir_table[i] = tcc_strdup(dir);
		}
		*undo = '/';
	}
	dwarf_line.filename_table =
		(struct dwarf_filename_struct *)
		tcc_realloc(dwarf_line.filename_table,
			    (dwarf_line.filename_size + 1) *
			    sizeof (struct dwarf_filename_struct));
	dwarf_line.filename_table[dwarf_line.filename_size].dir_entry =
		i + index_offset;
	dwarf_line.filename_table[dwarf_line.filename_size].name =
		tcc_strdup(filename);
	dwarf_line.cur_file = dwarf_line.filename_size++ + index_offset;
	return;
}
// 650 "tccdbg.c"
static int dwarf_sleb128_size (long long value)
{
	int size = 0;
	long long end = value >> 63;
	unsigned char last = end & 0x40;
	unsigned char byte;

	do {
		byte = value & 0x7f;
		value >>= 7;
		size++;
	} while (value != end || (byte & 0x40) != last);
	return size;
}

static void dwarf_uleb128 (Section *s, unsigned long long value)
{
	do {
		unsigned char byte = value & 0x7f;

		value >>= 7;
		dwarf_data1(s, byte | (value ? 0x80 : 0));
	} while (value != 0);
}

static void dwarf_sleb128 (Section *s, long long value)
{
	int more;
	long long end = value >> 63;
	unsigned char last = end & 0x40;

	do {
		unsigned char byte = value & 0x7f;

		value >>= 7;
		more = value != end || (byte & 0x40) != last;
		dwarf_data1(s, byte | (0x80 * more));
	} while (more);
}

static void dwarf_uleb128_op (TCCState *s1, unsigned long long value)
{
	do {
		unsigned char byte = value & 0x7f;

		value >>= 7;
		dwarf_line_op(s1, byte | (value ? 0x80 : 0));
	} while (value != 0);
}

static void dwarf_sleb128_op (TCCState *s1, long long value)
{
	int more;
	long long end = value >> 63;
	unsigned char last = end & 0x40;

	do {
		unsigned char byte = value & 0x7f;

		value >>= 7;
		more = value != end || (byte & 0x40) != last;
		dwarf_line_op(s1, byte | (0x80 * more));
	} while (more);
}
#if TCC_EH_FRAME
ST_FUNC void tcc_eh_frame_start(TCCState *s1)
{
	if (!s1->unwind_tables)
		return;
	eh_frame_section = new_section(s1, ".eh_frame", SHT_PROGBITS, SHF_ALLOC);

	s1->eh_start = eh_frame_section->data_offset;
	dwarf_data4(eh_frame_section, 0); // length

	dwarf_data4(eh_frame_section, 0); // CIE ID

	dwarf_data1(eh_frame_section, 1); // Version

	dwarf_data1(eh_frame_section, 'z'); // Augmentation String

	dwarf_data1(eh_frame_section, 'R');
	dwarf_data1(eh_frame_section, 0);
	dwarf_uleb128(eh_frame_section, 1); // code_alignment_factor

	dwarf_sleb128(eh_frame_section, -8); // data_alignment_factor

	dwarf_uleb128(eh_frame_section, 16); // return address column

	dwarf_uleb128(eh_frame_section, 1); // Augmentation len

	dwarf_data1(eh_frame_section, FDE_ENCODING);
	dwarf_data1(eh_frame_section, DW_CFA_def_cfa);
	dwarf_uleb128(eh_frame_section, 7); // r7 (rsp)

	dwarf_uleb128(eh_frame_section, 8); // ofs 8

	dwarf_data1(eh_frame_section, DW_CFA_offset + 16); // r16 (rip)

	dwarf_uleb128(eh_frame_section, 1); // cfa-8

	while ((eh_frame_section->data_offset - s1->eh_start) & 3)
		dwarf_data1(eh_frame_section, DW_CFA_nop);
	write32le(eh_frame_section->data + s1->eh_start, // length

		  eh_frame_section->data_offset - s1->eh_start - 4);
}

static void tcc_debug_frame_end(TCCState *s1, int size)
{
	int eh_section_sym;
	unsigned long fde_start;

	if (!eh_frame_section)
		return;
	eh_section_sym = dwarf_get_section_sym(text_section);
	fde_start = eh_frame_section->data_offset;
	dwarf_data4(eh_frame_section, 0); // length

	dwarf_data4(eh_frame_section,
		    fde_start - s1->eh_start + 4); // CIE Pointer

	dwarf_reloc(eh_frame_section, eh_section_sym, R_X86_64_PC32);
	dwarf_data4(eh_frame_section, func_ind); // PC Begin

	dwarf_data4(eh_frame_section, size); // PC Range

	dwarf_data1(eh_frame_section, 0); // Augmentation Length

	dwarf_data1(eh_frame_section, DW_CFA_advance_loc + 1);
	dwarf_data1(eh_frame_section, DW_CFA_def_cfa_offset);
	dwarf_uleb128(eh_frame_section, 16);
	dwarf_data1(eh_frame_section, DW_CFA_offset + 6); // r6 (rbp)

	dwarf_uleb128(eh_frame_section, 2); // cfa-16

	dwarf_data1(eh_frame_section, DW_CFA_advance_loc + 3);
	dwarf_data1(eh_frame_section, DW_CFA_def_cfa_register);
	dwarf_uleb128(eh_frame_section, 6); // r6 (rbp)

	dwarf_data1(eh_frame_section, DW_CFA_advance_loc4);
	dwarf_data4(eh_frame_section, size - 5);
	dwarf_data1(eh_frame_section, DW_CFA_def_cfa);
	dwarf_uleb128(eh_frame_section, 7); // r7 (rsp)

	dwarf_uleb128(eh_frame_section, 8); // ofs 8

	while ((eh_frame_section->data_offset - fde_start) & 3)
		dwarf_data1(eh_frame_section, DW_CFA_nop);
	write32le(eh_frame_section->data + fde_start, // length

		  eh_frame_section->data_offset - fde_start - 4);
}

ST_FUNC void tcc_eh_frame_end(TCCState *s1)
{
	if (!eh_frame_section)
		return;
	dwarf_data4(eh_frame_section, 0);
}

struct eh_search_table {
	uint32_t pc_offset;
	uint32_t fde_offset;
};

static int sort_eh_table(const void *a, const void *b)
{
	uint32_t pc1 = ((const struct eh_search_table *)a)->pc_offset;
	uint32_t pc2 = ((const struct eh_search_table *)b)->pc_offset;

	return pc1 < pc2 ? -1 : pc1 > pc2 ? 1 : 0;
}

ST_FUNC void tcc_eh_frame_hdr(TCCState *s1, int final)
{
	int count = 0, offset;
	unsigned long count_offset, tab_offset;
	unsigned char *ln, *end;
	unsigned int last_cie_offset = 0xffffffff;

	if (!eh_frame_section || !eh_frame_section->data_offset)
		return;
	if (final && !eh_frame_hdr_section)
		return;
	if (final == 0)
		eh_frame_hdr_section =
			new_section(s1, ".eh_frame_hdr", SHT_PROGBITS, SHF_ALLOC);
	eh_frame_hdr_section->data_offset = 0;
	dwarf_data1(eh_frame_hdr_section, 1); // Version

	// Pointer Encoding Format

	dwarf_data1(eh_frame_hdr_section, DW_EH_PE_sdata4 | DW_EH_PE_pcrel);
	// Count Encoding Format

	dwarf_data1(eh_frame_hdr_section, DW_EH_PE_udata4 | DW_EH_PE_absptr);
	// Table Encoding Format

	dwarf_data1(eh_frame_hdr_section, DW_EH_PE_sdata4 | DW_EH_PE_datarel);
	offset = eh_frame_section->sh_addr -
		 eh_frame_hdr_section->sh_addr -
		 eh_frame_hdr_section->data_offset;
	dwarf_data4(eh_frame_hdr_section, offset); // eh_frame_ptr

	// Count

	count_offset = eh_frame_hdr_section->data_offset;
	dwarf_data4(eh_frame_hdr_section, 0);
	tab_offset = eh_frame_hdr_section->data_offset;
	ln = eh_frame_section->data;
	end = eh_frame_section->data + eh_frame_section->data_offset;
	while (ln < end) {
		unsigned char *fde = ln, *rd = ln;
		unsigned int cie_offset, version, length = dwarf_read_4(rd, end);
		unsigned int pc_offset, fde_offset;

		if (length == 0)
			goto next;
		cie_offset = dwarf_read_4(rd, end);
		if (cie_offset == 0)
			goto next;
		if (cie_offset != last_cie_offset) {
			unsigned char *cie = rd - cie_offset + 4;

			if (cie < eh_frame_section->data)
				goto next;
			version = dwarf_read_1(cie, end);
			if ((version == 1 || version == 3) &&
			    dwarf_read_1(cie, end) == 'z' && // Augmentation String

			    dwarf_read_1(cie, end) == 'R' &&
			    dwarf_read_1(cie, end) == 0) {
				dwarf_read_uleb128(&cie, end); // code_alignment_factor

				dwarf_read_sleb128(&cie, end); // data_alignment_factor

				dwarf_read_1(cie, end); // return address column

				if (dwarf_read_uleb128(&cie, end) == 1 &&
				    dwarf_read_1(cie, end) == FDE_ENCODING) {
					last_cie_offset = cie_offset;
				} else
					goto next;
			} else
				goto next;
		}
		count++;
		fde_offset = eh_frame_section->sh_addr +
			     (fde - eh_frame_section->data) -
			     eh_frame_hdr_section->sh_addr;
		pc_offset = dwarf_read_4(rd, end) + fde_offset + 8;
		dwarf_data4(eh_frame_hdr_section, pc_offset);
		dwarf_data4(eh_frame_hdr_section, fde_offset);
next:
		ln += length + 4;
	}
	add32le(eh_frame_hdr_section->data + count_offset, count);
	qsort(eh_frame_hdr_section->data + tab_offset, count,
	      sizeof(struct eh_search_table), sort_eh_table);
}
#endif
/* start of translation unit info */
// 1010 "tccdbg.c"
ST_FUNC void tcc_debug_start(TCCState *s1)
{
	int i;
	char buf[512];
	char *filename;
	/* we might currently #include the <command-line> */

	filename = file->prev ? file->prev->filename : file->filename;
	/* an elf symbol of type STT_FILE must be put so that STB_LOCAL
	       symbols can be safely used */

	put_elf_sym(symtab_section, 0, 0,
		    ELFW(ST_INFO)(STB_LOCAL, STT_FILE), 0,
		    SHN_ABS, filename);

	if (s1->do_debug) {
		/* put a "mapping symbol" '$a' for llvm-objdump etc. tools needed
		           to make them disassemble again when crt1.o had a '$d' before */

		put_elf_sym(symtab_section, text_section->data_offset, 0,
			    ELFW(ST_INFO)(STB_LOCAL, STT_NOTYPE), 0,
			    text_section->sh_num, "$a");

		new_file = last_line_num = 0;
		debug_next_type = N_DEFAULT_DEBUG;
		debug_hash = NULL;
		debug_anon_hash = NULL;
		n_debug_hash = 0;
		n_debug_anon_hash = 0;

		getcwd(buf, sizeof(buf));

		normalize_slashes(buf);

		if (s1->dwarf) {
			int start_abbrev;
			unsigned char *ptr;
			char *undo;
			/* dwarf_abbrev */

			start_abbrev = dwarf_abbrev_section->data_offset;
			ptr = section_ptr_add(dwarf_abbrev_section, sizeof(dwarf_abbrev_init));
			memcpy(ptr, dwarf_abbrev_init, sizeof(dwarf_abbrev_init));

			if (s1->dwarf < 5) {
				while (*ptr) {
					ptr += 3;
					while (*ptr) {
						if (ptr[1] == DW_FORM_line_strp)
							ptr[1] = DW_FORM_strp;
						if (s1->dwarf < 4) {
							/* These are compatable for DW_TAG_compile_unit
										       DW_AT_stmt_list. */

							if (ptr[1] == DW_FORM_sec_offset)
								ptr[1] = DW_FORM_data4;
							/* This code uses only size < 0x80 so these are
										       compatible. */

							if (ptr[1] == DW_FORM_exprloc)
								ptr[1] = DW_FORM_block1;
						}
						ptr += 2;
					}
					ptr += 2;
				}
			}

			dwarf_sym.info = dwarf_get_section_sym(dwarf_info_section);
			dwarf_sym.abbrev = dwarf_get_section_sym(dwarf_abbrev_section);
			dwarf_sym.line = dwarf_get_section_sym(dwarf_line_section);
			dwarf_sym.str = dwarf_get_section_sym(dwarf_str_section);
			if (tcc_state->dwarf >= 5)
				dwarf_sym.line_str = dwarf_get_section_sym(dwarf_line_str_section);
			else {
				dwarf_line_str_section = dwarf_str_section;
				dwarf_sym.line_str = dwarf_sym.str;
			}
			section_sym = dwarf_get_section_sym(text_section);
			/* dwarf_info */

			dwarf_info.start = dwarf_info_section->data_offset;
			dwarf_data4(dwarf_info_section, 0);// size

			dwarf_data2(dwarf_info_section, s1->dwarf);// version

			if (s1->dwarf >= 5) {
				dwarf_data1(dwarf_info_section, DW_UT_compile);// unit type

				dwarf_data1(dwarf_info_section, PTR_SIZE);
				dwarf_reloc(dwarf_info_section, dwarf_sym.abbrev, R_DATA_32DW);
				dwarf_data4(dwarf_info_section, start_abbrev);
			} else {
				dwarf_reloc(dwarf_info_section, dwarf_sym.abbrev, R_DATA_32DW);
				dwarf_data4(dwarf_info_section, start_abbrev);
				dwarf_data1(dwarf_info_section, PTR_SIZE);
			}

			dwarf_data1(dwarf_info_section, DWARF_ABBREV_COMPILE_UNIT);
			dwarf_strp(dwarf_info_section, "tcc " TCC_VERSION);
			dwarf_data1(dwarf_info_section,
				    s1->cversion == 201112 ? DW_LANG_C11 : DW_LANG_C99);
			dwarf_line_strp(dwarf_info_section, filename);
			dwarf_line_strp(dwarf_info_section, buf);
			dwarf_reloc(dwarf_info_section, section_sym, R_DATA_PTR);
#if PTR_SIZE == 4
			dwarf_data4(dwarf_info_section, ind); // low pc

			dwarf_data4(dwarf_info_section, 0); // high pc

#else

			dwarf_data8(dwarf_info_section, ind);// low pc

			dwarf_data8(dwarf_info_section, 0);// high pc

#endif

			dwarf_reloc(dwarf_info_section, dwarf_sym.line, R_DATA_32DW);
			dwarf_data4(dwarf_info_section, dwarf_line_section->data_offset);// stmt_list

			/* dwarf_line */

			dwarf_line.start = dwarf_line_section->data_offset;
			dwarf_data4(dwarf_line_section, 0);// length

			dwarf_data2(dwarf_line_section, s1->dwarf);// version

			if (s1->dwarf >= 5) {
				dwarf_data1(dwarf_line_section, PTR_SIZE);// address size

				dwarf_data1(dwarf_line_section, 0);// segment selector

			}
			dwarf_data4(dwarf_line_section, 0);// prologue Length

			dwarf_data1(dwarf_line_section, DWARF_MIN_INSTR_LEN);
			if (s1->dwarf >= 4)
				dwarf_data1(dwarf_line_section, 1);// maximum ops per instruction

			dwarf_data1(dwarf_line_section, 1);// Initial value of 'is_stmt'

			dwarf_data1(dwarf_line_section, DWARF_LINE_BASE);
			dwarf_data1(dwarf_line_section, DWARF_LINE_RANGE);
			dwarf_data1(dwarf_line_section, DWARF_OPCODE_BASE);
			ptr = section_ptr_add(dwarf_line_section, sizeof(dwarf_line_opcodes));
			memcpy(ptr, dwarf_line_opcodes, sizeof(dwarf_line_opcodes));
			undo = strrchr(filename, '/');
			if (undo)
				*undo = 0;
			dwarf_line.dir_size = 1 + (undo != NULL);
			dwarf_line.dir_table = (char **) tcc_malloc(sizeof (char *) *
					       dwarf_line.dir_size);
			dwarf_line.dir_table[0] = tcc_strdup(buf);
			if (undo)
				dwarf_line.dir_table[1] = tcc_strdup(filename);
			dwarf_line.filename_size = 2;
			dwarf_line.filename_table =
				(struct dwarf_filename_struct *)
				tcc_malloc(2*sizeof (struct dwarf_filename_struct));
			dwarf_line.filename_table[0].dir_entry = 0;
			if (undo) {
				dwarf_line.filename_table[0].name = tcc_strdup(undo + 1);
				dwarf_line.filename_table[1].dir_entry = 1;
				dwarf_line.filename_table[1].name = tcc_strdup(undo + 1);
				*undo = '/';
			} else {
				dwarf_line.filename_table[0].name = tcc_strdup(filename);
				dwarf_line.filename_table[1].dir_entry = 0;
				dwarf_line.filename_table[1].name = tcc_strdup(filename);
			}
			dwarf_line.line_size = dwarf_line.line_max_size = 0;
			dwarf_line.line_data = NULL;
			dwarf_line.cur_file = 1;
			dwarf_line.last_file = 0;
			dwarf_line.last_pc = 0;
			dwarf_line.last_line = 1;
			dwarf_line_op(s1, 0);// extended

			dwarf_uleb128_op(s1, 1 + PTR_SIZE);// extended size

			dwarf_line_op(s1, DW_LNE_set_address);
			for (i = 0; i < PTR_SIZE; i++)
				dwarf_line_op(s1, 0);
			memset(&dwarf_info.base_type_used, 0, sizeof(dwarf_info.base_type_used));
		} else {
			/* file info: full path + filename */

			pstrcat(buf, sizeof(buf), "/");
			section_sym = put_elf_sym(symtab_section, 0, 0,
						  ELFW(ST_INFO)(STB_LOCAL, STT_SECTION), 0,
						  text_section->sh_num, NULL);
			put_stabs_r(s1, buf, N_SO, 0, 0,
				    text_section->data_offset, text_section, section_sym);
			put_stabs_r(s1, filename, N_SO, 0, 0,
				    text_section->data_offset, text_section, section_sym);
			for (i = 0; i < N_DEFAULT_DEBUG; i++)
				put_stabs(s1, default_debug[i].name, N_LSYM, 0, 0, 0);
		}
		/* we're currently 'including' the <command line> */

		tcc_debug_bincl(s1);
	}
}
/* put end of translation unit info */

ST_FUNC void tcc_debug_end(TCCState *s1)
{
	if (!s1->do_debug || debug_next_type == 0)
		return;

	if (debug_info_root)
		tcc_debug_funcend(s1, 0);/* free stuff in case of errors */

	if (s1->dwarf) {
		int i, j;
		int start_aranges;
		unsigned char *ptr;
		int text_size = text_section->data_offset;
		/* dwarf_info */

		for (i = 0; i < n_debug_anon_hash; i++) {
			Sym *t = debug_anon_hash[i].type;
			int pos = dwarf_info_section->data_offset;

			dwarf_data1(dwarf_info_section,
				    IS_UNION (t->type.t) ? DWARF_ABBREV_UNION_EMPTY_TYPE
				    : DWARF_ABBREV_STRUCTURE_EMPTY_TYPE);
			dwarf_strp(dwarf_info_section,
				   (t->v & ~SYM_STRUCT) >= SYM_FIRST_ANOM
				   ? "" : get_tok_str(t->v, NULL));
			dwarf_uleb128(dwarf_info_section, 0);
			dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
			dwarf_uleb128(dwarf_info_section, file->line_num);
			for (j = 0; j < debug_anon_hash[i].n_debug_type; j++)
				write32le(dwarf_info_section->data +
					  debug_anon_hash[i].debug_type[j],
					  pos - dwarf_info.start);
			tcc_free (debug_anon_hash[i].debug_type);
		}
		tcc_free (debug_anon_hash);
		dwarf_data1(dwarf_info_section, 0);
		ptr = dwarf_info_section->data + dwarf_info.start;
		write32le(ptr, dwarf_info_section->data_offset - dwarf_info.start - 4);
		write32le(ptr + 25 + (s1->dwarf >= 5) + PTR_SIZE, text_size);
		/* dwarf_aranges */

		start_aranges = dwarf_aranges_section->data_offset;
		dwarf_data4(dwarf_aranges_section, 0);// size

		dwarf_data2(dwarf_aranges_section, 2);// version

		dwarf_reloc(dwarf_aranges_section, dwarf_sym.info, R_DATA_32DW);
		dwarf_data4(dwarf_aranges_section, 0);// dwarf_info

#if PTR_SIZE == 4
		dwarf_data1(dwarf_aranges_section, 4); // address size

#else

		dwarf_data1(dwarf_aranges_section, 8);// address size

#endif

		dwarf_data1(dwarf_aranges_section, 0);// segment selector size

		dwarf_data4(dwarf_aranges_section, 0);// padding

		dwarf_reloc(dwarf_aranges_section, section_sym, R_DATA_PTR);
#if PTR_SIZE == 4
		dwarf_data4(dwarf_aranges_section, 0); // Begin

		dwarf_data4(dwarf_aranges_section, text_size); // End

		dwarf_data4(dwarf_aranges_section, 0); // End list

		dwarf_data4(dwarf_aranges_section, 0); // End list

#else

		dwarf_data8(dwarf_aranges_section, 0);// Begin

		dwarf_data8(dwarf_aranges_section, text_size);// End

		dwarf_data8(dwarf_aranges_section, 0);// End list

		dwarf_data8(dwarf_aranges_section, 0);// End list

#endif

		ptr = dwarf_aranges_section->data + start_aranges;
		write32le(ptr, dwarf_aranges_section->data_offset - start_aranges - 4);
		/* dwarf_line */

		if (s1->dwarf >= 5) {
			dwarf_data1(dwarf_line_section, 1);/* col */

			dwarf_uleb128(dwarf_line_section, DW_LNCT_path);
			dwarf_uleb128(dwarf_line_section, DW_FORM_line_strp);
			dwarf_uleb128(dwarf_line_section, dwarf_line.dir_size);
			for (i = 0; i < dwarf_line.dir_size; i++)
				dwarf_line_strp(dwarf_line_section, dwarf_line.dir_table[i]);
			dwarf_data1(dwarf_line_section, 2);/* col */

			dwarf_uleb128(dwarf_line_section, DW_LNCT_path);
			dwarf_uleb128(dwarf_line_section, DW_FORM_line_strp);
			dwarf_uleb128(dwarf_line_section, DW_LNCT_directory_index);
			dwarf_uleb128(dwarf_line_section, DW_FORM_udata);
			dwarf_uleb128(dwarf_line_section, dwarf_line.filename_size);
			for (i = 0; i < dwarf_line.filename_size; i++) {
				dwarf_line_strp(dwarf_line_section,
						dwarf_line.filename_table[i].name);
				dwarf_uleb128(dwarf_line_section,
					      dwarf_line.filename_table[i].dir_entry);
			}
		} else {
			int len;

			for (i = 0; i < dwarf_line.dir_size; i++) {
				len = strlen(dwarf_line.dir_table[i]) + 1;
				ptr = section_ptr_add(dwarf_line_section, len);
				memmove(ptr, dwarf_line.dir_table[i], len);
			}
			dwarf_data1(dwarf_line_section, 0);/* end dir */

			for (i = 0; i < dwarf_line.filename_size; i++) {
				len = strlen(dwarf_line.filename_table[i].name) + 1;
				ptr = section_ptr_add(dwarf_line_section, len);
				memmove(ptr, dwarf_line.filename_table[i].name, len);
				dwarf_uleb128(dwarf_line_section,
					      dwarf_line.filename_table[i].dir_entry);
				dwarf_uleb128(dwarf_line_section, 0);/* time */

				dwarf_uleb128(dwarf_line_section, 0);/* size */

			}
			dwarf_data1(dwarf_line_section, 0);/* end file */

		}
		for (i = 0; i < dwarf_line.dir_size; i++)
			tcc_free(dwarf_line.dir_table[i]);
		tcc_free(dwarf_line.dir_table);
		for (i = 0; i < dwarf_line.filename_size; i++)
			tcc_free(dwarf_line.filename_table[i].name);
		tcc_free(dwarf_line.filename_table);

		dwarf_line_op(s1, 0);// extended

		dwarf_uleb128_op(s1, 1);// extended size

		dwarf_line_op(s1, DW_LNE_end_sequence);
		i = (s1->dwarf >= 5) * 2;
		write32le(&dwarf_line_section->data[dwarf_line.start + 6 + i],
			  dwarf_line_section->data_offset - dwarf_line.start - (10 + i));
		section_ptr_add(dwarf_line_section, 3);
		dwarf_reloc(dwarf_line_section, section_sym, R_DATA_PTR);
		ptr = section_ptr_add(dwarf_line_section, dwarf_line.line_size - 3);
		memmove(ptr - 3, dwarf_line.line_data, dwarf_line.line_size);
		tcc_free(dwarf_line.line_data);
		write32le(dwarf_line_section->data + dwarf_line.start,
			  dwarf_line_section->data_offset - dwarf_line.start - 4);
	} else {
		put_stabs_r(s1, NULL, N_SO, 0, 0,
			    text_section->data_offset, text_section, section_sym);
	}
	tcc_free(debug_hash);
	debug_next_type = 0;
}

static BufferedFile *put_new_file(TCCState *s1)
{
	BufferedFile *f = file;
	/* use upper file if from inline ":asm:" */

	if (f->filename[0] == ':')
		f = f->prev;
	if (f && new_file) {
		new_file = last_line_num = 0;
		if (s1->dwarf)
			dwarf_file(s1);
		else
			put_stabs_r(s1, f->filename, N_SOL, 0, 0, ind, text_section, section_sym);
	}
	return f;
}
/* put alternative filename */

ST_FUNC void tcc_debug_newfile(TCCState *s1)
{
	if (!s1->do_debug)
		return;
	if (s1->dwarf)
		dwarf_file(s1);
	new_file = 1;
}
/* begin of #include */

ST_FUNC void tcc_debug_bincl(TCCState *s1)
{
	if (!s1->do_debug)
		return;
	if (s1->dwarf)
		dwarf_file(s1);
	else
		put_stabs(s1, file->filename, N_BINCL, 0, 0, 0);
	new_file = 1;
}
/* end of #include */

ST_FUNC void tcc_debug_eincl(TCCState *s1)
{
	if (!s1->do_debug)
		return;
	if (s1->dwarf)
		dwarf_file(s1);
	else
		put_stabn(s1, N_EINCL, 0, 0, 0);
	new_file = 1;
}
/* generate line number info */

ST_FUNC void tcc_debug_line(TCCState *s1)
{
	BufferedFile *f;

	if (!s1->do_debug)
		return;
	if (cur_text_section != text_section || nocode_wanted)
		return;
	f = put_new_file(s1);
	if (!f)
		return;
	if (last_line_num == f->line_num)
		return;
	last_line_num = f->line_num;

	if (s1->dwarf) {
		int len_pc = (ind - dwarf_line.last_pc) / DWARF_MIN_INSTR_LEN;
		int len_line = f->line_num - dwarf_line.last_line;
		int n = len_pc * DWARF_LINE_RANGE + len_line + DWARF_OPCODE_BASE -
			DWARF_LINE_BASE;

		if (dwarf_line.cur_file != dwarf_line.last_file) {
			dwarf_line.last_file = dwarf_line.cur_file;
			dwarf_line_op(s1, DW_LNS_set_file);
			dwarf_uleb128_op(s1, dwarf_line.cur_file);
		}
		if (len_pc &&
		    len_line >= DWARF_LINE_BASE
		    && len_line <= (DWARF_OPCODE_BASE + DWARF_LINE_BASE) &&
		    n >= DWARF_OPCODE_BASE && n <= 255)
			dwarf_line_op(s1, n);
		else {
			if (len_pc) {
				n = len_pc * DWARF_LINE_RANGE + 0 + DWARF_OPCODE_BASE - DWARF_LINE_BASE;
				if (n >= DWARF_OPCODE_BASE && n <= 255)
					dwarf_line_op(s1, n);
				else {
					dwarf_line_op(s1, DW_LNS_advance_pc);
					dwarf_uleb128_op(s1, len_pc);
				}
			}
			if (len_line) {
				n = 0 * DWARF_LINE_RANGE + len_line + DWARF_OPCODE_BASE - DWARF_LINE_BASE;
				if (len_line >= DWARF_LINE_BASE
				    && len_line <= (DWARF_OPCODE_BASE + DWARF_LINE_BASE) &&
				    n >= DWARF_OPCODE_BASE && n <= 255)
					dwarf_line_op(s1, n);
				else {
					dwarf_line_op(s1, DW_LNS_advance_line);
					dwarf_sleb128_op(s1, len_line);
				}
			}
		}
		dwarf_line.last_pc = ind;
		dwarf_line.last_line = f->line_num;
	} else {
		if (func_ind != -1) {
			put_stabn(s1, N_SLINE, 0, f->line_num, ind - func_ind);
		} else {
			/* from tcc_assemble */

			put_stabs_r(s1, NULL, N_SLINE, 0, f->line_num, ind, text_section, section_sym);
		}
	}
}

static void tcc_debug_stabs (TCCState *s1, const char *str, int type,
			     unsigned long value,
			     Section *sec, int sym_index, int info)
{
	struct debug_sym *s;

	if (debug_info) {
		debug_info->sym =
			(struct debug_sym *)tcc_realloc (debug_info->sym,
				sizeof(struct debug_sym) *
				(debug_info->n_sym + 1));
		s = debug_info->sym + debug_info->n_sym++;
		s->type = type;
		s->value = value;
		s->str = tcc_strdup(str);
		s->sec = sec;
		s->sym_index = sym_index;
		s->info = info;
		s->file = dwarf_line.cur_file;
		s->line = file->line_num;
	} else if (sec)
		put_stabs_r (s1, str, type, 0, 0, value, sec, sym_index);
	else
		put_stabs (s1, str, type, 0, 0, value);
}

ST_FUNC void tcc_debug_stabn(TCCState *s1, int type, int value)
{
	if (!s1->do_debug)
		return;
	if (type == N_LBRAC) {
		struct _debug_info *info =
			(struct _debug_info *) tcc_mallocz(sizeof (*info));

		info->start = value;
		info->parent = debug_info;
		if (debug_info) {
			if (debug_info->child) {
				if (debug_info->child->last)
					debug_info->child->last->next = info;
				else
					debug_info->child->next = info;
				debug_info->child->last = info;
			} else
				debug_info->child = info;
		} else
			debug_info_root = info;
		debug_info = info;
	} else {
		debug_info->end = value;
		debug_info = debug_info->parent;
	}
}

static int tcc_debug_find(TCCState *s1, Sym *t, int dwarf)
{
	int i;

	if (!debug_info && dwarf &&
	    (t->type.t & VT_BTYPE) == VT_STRUCT && t->c == -1) {
		for (i = 0; i < n_debug_anon_hash; i++)
			if (t == debug_anon_hash[i].type)
				return 0;
		debug_anon_hash = (struct _debug_anon_hash *)
				  tcc_realloc (debug_anon_hash,
					       (n_debug_anon_hash + 1) * sizeof(*debug_anon_hash));
		debug_anon_hash[n_debug_anon_hash].n_debug_type = 0;
		debug_anon_hash[n_debug_anon_hash].debug_type = NULL;
		debug_anon_hash[n_debug_anon_hash++].type = t;
		return 0;
	}
	for (i = 0; i < n_debug_hash; i++)
		if (t == debug_hash[i].type)
			return debug_hash[i].debug_type;
	return -1;
}

static int tcc_get_dwarf_info(TCCState *s1, Sym *s);

static void tcc_debug_check_anon(TCCState *s1, Sym *t, int debug_type)
{
	int i;

	if (!debug_info && (t->type.t & VT_BTYPE) == VT_STRUCT && t->type.ref->c == -1)
		for (i = 0; i < n_debug_anon_hash; i++)
			if (t->type.ref == debug_anon_hash[i].type) {
				debug_anon_hash[i].debug_type =
					tcc_realloc(debug_anon_hash[i].debug_type,
						    (debug_anon_hash[i].n_debug_type + 1) * sizeof(int));
				debug_anon_hash[i].debug_type[debug_anon_hash[i].n_debug_type++] =
					debug_type;
			}
}

ST_FUNC void tcc_debug_fix_anon(TCCState *s1, CType *t)
{
	int i, j, debug_type;

	if (!(s1->do_debug & 2) || !s1->dwarf || debug_info)
		return;

	if ((t->t & VT_BTYPE) == VT_STRUCT && t->ref->c != -1)
		for (i = 0; i < n_debug_anon_hash; i++)
			if (t->ref == debug_anon_hash[i].type) {
				Sym sym = {0};
				sym .type = *t ;
				/* Trick to not hash this struct */

				debug_info = (struct _debug_info *) t;
				debug_type = tcc_get_dwarf_info(s1, &sym);
				debug_info = NULL;
				for (j = 0; j < debug_anon_hash[i].n_debug_type; j++)
					write32le(dwarf_info_section->data +
						  debug_anon_hash[i].debug_type[j],
						  debug_type - dwarf_info.start);
				tcc_free(debug_anon_hash[i].debug_type);
				n_debug_anon_hash--;
				for (; i < n_debug_anon_hash; i++)
					debug_anon_hash[i] = debug_anon_hash[i + 1];
			}
}

static int tcc_debug_add(TCCState *s1, Sym *t, int dwarf)
{
	int offset = dwarf ? dwarf_info_section->data_offset : ++debug_next_type;
	debug_hash = (struct _debug_hash *)
		     tcc_realloc (debug_hash,
				  (n_debug_hash + 1) * sizeof(*debug_hash));
	debug_hash[n_debug_hash].debug_type = offset;
	debug_hash[n_debug_hash++].type = t;
	return offset;
}

static void tcc_debug_remove(TCCState *s1, Sym *t)
{
	int i;

	for (i = 0; i < n_debug_hash; i++)
		if (t == debug_hash[i].type) {
			n_debug_hash--;
			for (; i < n_debug_hash; i++)
				debug_hash[i] = debug_hash[i+1];
		}
}
// 1604 "tccdbg.c"
#define STRUCT_NODEBUG(s) (s->a.nodebug || ((s->v & ~SYM_FIELD) >= SYM_FIRST_ANOM && ((s->type.t & VT_BTYPE) == VT_BYTE || (s->type.t & VT_BTYPE) == VT_BOOL || (s->type.t & VT_BTYPE) == VT_SHORT || (s->type.t & VT_BTYPE) == VT_INT || (s->type.t & VT_BTYPE) == VT_LLONG)))

static void tcc_get_debug_info(TCCState *s1, Sym *s, CString *result)
{
	int type;
	int n = 0;
	int debug_type = -1;
	Sym *t = s;
	CString str;

	for (;;) {
		type = t->type.t & ~(VT_STORAGE | VT_CONSTANT | VT_VOLATILE | VT_VLA);
		if ((type & VT_BTYPE) != VT_BYTE)
			type &= ~VT_DEFSIGN;
		if (type == VT_PTR || type == (VT_PTR | VT_ARRAY))
			n++, t = t->type.ref;
		else
			break;
	}
	if ((type & VT_BTYPE) == VT_STRUCT) {
		Sym *e = t;

		t = t->type.ref;
		debug_type = tcc_debug_find(s1, t, 0);
		if (debug_type == -1) {
			debug_type = tcc_debug_add(s1, t, 0);
			cstr_new (&str);
			cstr_printf (&str, "%s:T%d=%c%d",
				     (t->v & ~SYM_STRUCT) >= SYM_FIRST_ANOM
				     ? "" : get_tok_str(t->v, NULL),
				     debug_type,
				     IS_UNION (t->type.t) ? 'u' : 's',
				     t->c);
			while (t->next) {
				int pos, size, align;

				t = t->next;
				if (STRUCT_NODEBUG(t))
					continue;
				cstr_printf (&str, "%s:",
					     get_tok_str(t->v, NULL));
				tcc_get_debug_info (s1, t, &str);
				if (t->type.t & VT_BITFIELD) {
					pos = t->c * 8 + BIT_POS(t->type.t);
					size = BIT_SIZE(t->type.t);
				} else {
					pos = t->c * 8;
					size = type_size(&t->type, &align) * 8;
				}
				cstr_printf (&str, ",%d,%d;", pos, size);
			}
			cstr_printf (&str, ";");
			tcc_debug_stabs(s1, str.data, N_LSYM, 0, NULL, 0, 0);
			cstr_free (&str);
			if (debug_info)
				tcc_debug_remove(s1, e);
		}
	} else if (IS_ENUM(type)) {
		Sym *e = t = t->type.ref;

		debug_type = tcc_debug_find(s1, t, 0);
		if (debug_type == -1) {
			debug_type = tcc_debug_add(s1, t, 0);
			cstr_new (&str);
			cstr_printf (&str, "%s:T%d=e",
				     (t->v & ~SYM_STRUCT) >= SYM_FIRST_ANOM
				     ? "" : get_tok_str(t->v, NULL),
				     debug_type);
			while (t->next) {
				t = t->next;
				cstr_printf (&str, "%s:",
					     (t->v & ~SYM_FIELD) >= SYM_FIRST_ANOM
					     ? "" : get_tok_str(t->v, NULL));
				cstr_printf (&str, e->type.t & VT_UNSIGNED ? "%u," : "%d,",
					     (int)t->enum_val);
			}
			cstr_printf (&str, ";");
			tcc_debug_stabs(s1, str.data, N_LSYM, 0, NULL, 0, 0);
			cstr_free (&str);
			if (debug_info)
				tcc_debug_remove(s1, e);
		}
	} else if ((type & VT_BTYPE) != VT_FUNC) {
		type &= ~VT_STRUCT_MASK;
		for (debug_type = 1; debug_type <= N_DEFAULT_DEBUG; debug_type++)
			if (default_debug[debug_type - 1].type == type)
				break;
		if (debug_type > N_DEFAULT_DEBUG)
			return;
	}
	if (n > 0)
		cstr_printf (result, "%d=", ++debug_next_type);
	t = s;
	for (;;) {
		type = t->type.t & ~(VT_STORAGE | VT_CONSTANT | VT_VOLATILE | VT_VLA);
		if ((type & VT_BTYPE) != VT_BYTE)
			type &= ~VT_DEFSIGN;
		if (type == VT_PTR)
			cstr_printf (result, "%d=*", ++debug_next_type);
		else if (type == (VT_PTR | VT_ARRAY))
			cstr_printf (result, "%d=ar1;0;%d;",
				     ++debug_next_type, t->type.ref->c - 1);
		else if (type == VT_FUNC) {
			cstr_printf (result, "%d=f", ++debug_next_type);
			tcc_get_debug_info (s1, t->type.ref, result);
			return;
		} else
			break;
		t = t->type.ref;
	}
	cstr_printf (result, "%d", debug_type);
}

static int tcc_get_dwarf_info(TCCState *s1, Sym *s)
{
	int type;
	int debug_type = -1;
	Sym *e, *t = s;
	int i;
	int last_pos = -1;
	int retval;

	if (new_file)
		put_new_file(s1);
	for (;;) {
		type = t->type.t & ~(VT_STORAGE | VT_CONSTANT | VT_VOLATILE | VT_VLA);
		if ((type & VT_BTYPE) != VT_BYTE)
			type &= ~VT_DEFSIGN;
		if (type == VT_PTR || type == (VT_PTR | VT_ARRAY))
			t = t->type.ref;
		else
			break;
	}
	if ((type & VT_BTYPE) == VT_STRUCT) {
		t = t->type.ref;
		debug_type = tcc_debug_find(s1, t, 1);
		if (debug_type == -1) {
			int pos_sib = 0, i, *pos_type;

			debug_type = tcc_debug_add(s1, t, 1);
			e = t;
			i = 0;
			while (e->next) {
				e = e->next;
				if (STRUCT_NODEBUG(e))
					continue;
				i++;
			}
			pos_type = (int *) tcc_malloc(i * sizeof(int));
			dwarf_data1(dwarf_info_section,
				    IS_UNION (t->type.t)
				    ? t->next ? DWARF_ABBREV_UNION_TYPE
				    : DWARF_ABBREV_UNION_EMPTY_TYPE
				    : t->next ? DWARF_ABBREV_STRUCTURE_TYPE
				    : DWARF_ABBREV_STRUCTURE_EMPTY_TYPE);
			dwarf_strp(dwarf_info_section,
				   (t->v & ~SYM_STRUCT) >= SYM_FIRST_ANOM
				   ? "" : get_tok_str(t->v, NULL));
			dwarf_uleb128(dwarf_info_section, t->c);
			dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
			dwarf_uleb128(dwarf_info_section, file->line_num);
			if (t->next) {
				pos_sib = dwarf_info_section->data_offset;
				dwarf_data4(dwarf_info_section, 0);
			}
			e = t;
			i = 0;
			while (e->next) {
				e = e->next;
				if (STRUCT_NODEBUG(e))
					continue;
				dwarf_data1(dwarf_info_section,
					    e->type.t & VT_BITFIELD ? DWARF_ABBREV_MEMBER_BF
					    : DWARF_ABBREV_MEMBER);
				dwarf_strp(dwarf_info_section,
					   get_tok_str(e->v, NULL));
				dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
				dwarf_uleb128(dwarf_info_section, file->line_num);
				pos_type[i++] = dwarf_info_section->data_offset;
				dwarf_data4(dwarf_info_section, 0);
				if (e->type.t & VT_BITFIELD) {
					int pos = e->c * 8 + BIT_POS(e->type.t);
					int size = BIT_SIZE(e->type.t);

					dwarf_uleb128(dwarf_info_section, size);
					dwarf_uleb128(dwarf_info_section, pos);
				} else
					dwarf_uleb128(dwarf_info_section, e->c);
			}
			if (t->next) {
				dwarf_data1(dwarf_info_section, 0);
				write32le(dwarf_info_section->data + pos_sib,
					  dwarf_info_section->data_offset - dwarf_info.start);
			}
			e = t;
			i = 0;
			while (e->next) {
				e = e->next;
				if (STRUCT_NODEBUG(e))
					continue;
				type = tcc_get_dwarf_info(s1, e);
				tcc_debug_check_anon(s1, e, pos_type[i]);
				write32le(dwarf_info_section->data + pos_type[i++],
					  type - dwarf_info.start);
			}
			tcc_free(pos_type);
			if (debug_info)
				tcc_debug_remove(s1, t);
		}
	} else if (IS_ENUM(type)) {
		t = t->type.ref;
		debug_type = tcc_debug_find(s1, t, 1);
		if (debug_type == -1) {
			int pos_sib, pos_type;
			Sym sym = {0};
			sym.type.t = VT_INT | (type & VT_UNSIGNED);

			pos_type = tcc_get_dwarf_info(s1, &sym);
			debug_type = tcc_debug_add(s1, t, 1);
			dwarf_data1(dwarf_info_section, DWARF_ABBREV_ENUMERATION_TYPE);
			dwarf_strp(dwarf_info_section,
				   (t->v & ~SYM_STRUCT) >= SYM_FIRST_ANOM
				   ? "" : get_tok_str(t->v, NULL));
			dwarf_data1(dwarf_info_section,
				    type & VT_UNSIGNED ? DW_ATE_unsigned : DW_ATE_signed );
			dwarf_data1(dwarf_info_section, 4);
			dwarf_data4(dwarf_info_section, pos_type - dwarf_info.start);
			dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
			dwarf_uleb128(dwarf_info_section, file->line_num);
			pos_sib = dwarf_info_section->data_offset;
			dwarf_data4(dwarf_info_section, 0);
			e = t;
			while (e->next) {
				e = e->next;
				dwarf_data1(dwarf_info_section,
					    type & VT_UNSIGNED ? DWARF_ABBREV_ENUMERATOR_UNSIGNED
					    : DWARF_ABBREV_ENUMERATOR_SIGNED);
				dwarf_strp(dwarf_info_section,
					   (e->v & ~SYM_FIELD) >= SYM_FIRST_ANOM
					   ? "" : get_tok_str(e->v, NULL));
				if (type & VT_UNSIGNED)
					dwarf_uleb128(dwarf_info_section, e->enum_val);
				else
					dwarf_sleb128(dwarf_info_section, e->enum_val);
			}
			dwarf_data1(dwarf_info_section, 0);
			write32le(dwarf_info_section->data + pos_sib,
				  dwarf_info_section->data_offset - dwarf_info.start);
			if (debug_info)
				tcc_debug_remove(s1, t);
		}
	} else if ((type & VT_BTYPE) != VT_FUNC) {
		type &= ~VT_STRUCT_MASK;
		for (i = 1; i <= N_DEFAULT_DEBUG; i++)
			if (default_debug[i - 1].type == type)
				break;
		if (i > N_DEFAULT_DEBUG)
			return 0;
		debug_type = dwarf_info.base_type_used[i - 1];
		if (debug_type == 0) {
			char name[100];

			debug_type = dwarf_info_section->data_offset;
			dwarf_data1(dwarf_info_section, DWARF_ABBREV_BASE_TYPE);
			dwarf_uleb128(dwarf_info_section, default_debug[i - 1].size);
			dwarf_data1(dwarf_info_section, default_debug[i - 1].encoding);
			strncpy(name, default_debug[i - 1].name, sizeof(name) -1);
			*strchr(name, ':') = 0;
			dwarf_strp(dwarf_info_section, name);
			dwarf_info.base_type_used[i - 1] = debug_type;
		}
	}
	retval = debug_type;
	e = NULL;
	t = s;
	for (;;) {
		type = t->type.t & ~(VT_STORAGE | VT_CONSTANT | VT_VOLATILE | VT_VLA);
		if ((type & VT_BTYPE) != VT_BYTE)
			type &= ~VT_DEFSIGN;
		if (type == VT_PTR) {
			i = dwarf_info_section->data_offset;
			if (retval == debug_type)
				retval = i;
			dwarf_data1(dwarf_info_section, DWARF_ABBREV_POINTER);
			dwarf_data1(dwarf_info_section, PTR_SIZE);
			if (last_pos != -1) {
				tcc_debug_check_anon(s1, e, last_pos);
				write32le(dwarf_info_section->data + last_pos,
					  i - dwarf_info.start);
			}
			last_pos = dwarf_info_section->data_offset;
			e = t->type.ref;
			dwarf_data4(dwarf_info_section, 0);
		} else if (type == (VT_PTR | VT_ARRAY)) {
			int sib_pos, sub_type;
#if LONG_SIZE == 4

			Sym sym = {0};
			sym.type.t = VT_LONG | VT_INT | VT_UNSIGNED;
#else

			Sym sym = {0};
			sym.type.t = VT_LLONG | VT_LONG | VT_UNSIGNED;
#endif

			sub_type = tcc_get_dwarf_info(s1, &sym);
			i = dwarf_info_section->data_offset;
			if (retval == debug_type)
				retval = i;
			dwarf_data1(dwarf_info_section, DWARF_ABBREV_ARRAY_TYPE);
			if (last_pos != -1) {
				tcc_debug_check_anon(s1, e, last_pos);
				write32le(dwarf_info_section->data + last_pos,
					  i - dwarf_info.start);
			}
			last_pos = dwarf_info_section->data_offset;
			e = t->type.ref;
			dwarf_data4(dwarf_info_section, 0);
			sib_pos = dwarf_info_section->data_offset;
			dwarf_data4(dwarf_info_section, 0);
			for (;;) {
				dwarf_data1(dwarf_info_section, DWARF_ABBREV_SUBRANGE_TYPE);
				dwarf_data4(dwarf_info_section, sub_type - dwarf_info.start);
				dwarf_uleb128(dwarf_info_section, t->type.ref->c - 1);
				s = t->type.ref;
				type = s->type.t & ~(VT_STORAGE | VT_CONSTANT | VT_VOLATILE);
				if (type != (VT_PTR | VT_ARRAY))
					break;
				t = s;
			}
			dwarf_data1(dwarf_info_section, 0);
			write32le(dwarf_info_section->data + sib_pos,
				  dwarf_info_section->data_offset - dwarf_info.start);
		} else if (type == VT_FUNC) {
			int sib_pos = 0, *pos_type;
			Sym *f;

			i = dwarf_info_section->data_offset;
			debug_type = tcc_get_dwarf_info(s1, t->type.ref);
			if (retval == debug_type)
				retval = i;
			dwarf_data1(dwarf_info_section,
				    t->type.ref->next ? DWARF_ABBREV_SUBROUTINE_TYPE
				    : DWARF_ABBREV_SUBROUTINE_EMPTY_TYPE);
			if (last_pos != -1) {
				tcc_debug_check_anon(s1, e, last_pos);
				write32le(dwarf_info_section->data + last_pos,
					  i - dwarf_info.start);
			}
			last_pos = dwarf_info_section->data_offset;
			e = t->type.ref;
			dwarf_data4(dwarf_info_section, 0);
			if (t->type.ref->next) {
				sib_pos = dwarf_info_section->data_offset;
				dwarf_data4(dwarf_info_section, 0);
			}
			f = t->type.ref;
			i = 0;
			while (f->next) {
				f = f->next;
				i++;
			}
			pos_type = (int *) tcc_malloc(i * sizeof(int));
			f = t->type.ref;
			i = 0;
			while (f->next) {
				f = f->next;
				dwarf_data1(dwarf_info_section, DWARF_ABBREV_FORMAL_PARAMETER2);
				pos_type[i++] = dwarf_info_section->data_offset;
				dwarf_data4(dwarf_info_section, 0);
			}
			if (t->type.ref->next) {
				dwarf_data1(dwarf_info_section, 0);
				write32le(dwarf_info_section->data + sib_pos,
					  dwarf_info_section->data_offset - dwarf_info.start);
			}
			f = t->type.ref;
			i = 0;
			while (f->next) {
				f = f->next;
				type = tcc_get_dwarf_info(s1, f);
				tcc_debug_check_anon(s1, f, pos_type[i]);
				write32le(dwarf_info_section->data + pos_type[i++],
					  type - dwarf_info.start);
			}
			tcc_free(pos_type);
		} else {
			if (last_pos != -1) {
				tcc_debug_check_anon(s1, e, last_pos);
				write32le(dwarf_info_section->data + last_pos,
					  debug_type - dwarf_info.start);
			}
			break;
		}
		t = t->type.ref;
	}
	return retval;
}

static void tcc_debug_finish (TCCState *s1, struct _debug_info *cur)
{
	while (cur) {
		struct _debug_info *next = cur->next;
		int i;

		if (s1->dwarf) {

			for (i = cur->n_sym - 1; i >= 0; i--) {
				struct debug_sym *s = &cur->sym[i];

				dwarf_data1(dwarf_info_section,
					    s->type == N_PSYM
					    ? DWARF_ABBREV_FORMAL_PARAMETER
					    : s->type == N_GSYM
					    ? DWARF_ABBREV_VARIABLE_EXTERNAL
					    : s->type == N_STSYM
					    ? DWARF_ABBREV_VARIABLE_STATIC
					    : DWARF_ABBREV_VARIABLE_LOCAL);
				dwarf_strp(dwarf_info_section, s->str);
				if (s->type == N_GSYM || s->type == N_STSYM) {
					dwarf_uleb128(dwarf_info_section, s->file);
					dwarf_uleb128(dwarf_info_section, s->line);
				}
				dwarf_data4(dwarf_info_section, s->info - dwarf_info.start);
				if (s->type == N_GSYM || s->type == N_STSYM) {
					/* global/static */

					if (s->type == N_GSYM)
						dwarf_data1(dwarf_info_section, 1);
					dwarf_data1(dwarf_info_section, PTR_SIZE + 1);
					dwarf_data1(dwarf_info_section, DW_OP_addr);
					if (s->type == N_STSYM)
						dwarf_reloc(dwarf_info_section, section_sym, R_DATA_PTR);
#if PTR_SIZE == 4
					dwarf_data4(dwarf_info_section, s->value);
#else

					dwarf_data8(dwarf_info_section, s->value);
#endif

				} else {
					/* param/local */

					dwarf_data1(dwarf_info_section, dwarf_sleb128_size(s->value) + 1);
					dwarf_data1(dwarf_info_section, DW_OP_fbreg);
					dwarf_sleb128(dwarf_info_section, s->value);
				}
				tcc_free (s->str);
			}
			tcc_free (cur->sym);
			dwarf_data1(dwarf_info_section,
				    cur->child ? DWARF_ABBREV_LEXICAL_BLOCK
				    : DWARF_ABBREV_LEXICAL_EMPTY_BLOCK);
			dwarf_reloc(dwarf_info_section, section_sym, R_DATA_PTR);
#if PTR_SIZE == 4
			dwarf_data4(dwarf_info_section, func_ind + cur->start);
			dwarf_data4(dwarf_info_section, cur->end - cur->start);
#else

			dwarf_data8(dwarf_info_section, func_ind + cur->start);
			dwarf_data8(dwarf_info_section, cur->end - cur->start);
#endif

			tcc_debug_finish (s1, cur->child);
			if (cur->child)
				dwarf_data1(dwarf_info_section, 0);
		} else {
			for (i = 0; i < cur->n_sym; i++) {
				struct debug_sym *s = &cur->sym[i];

				if (s->sec)
					put_stabs_r(s1, s->str, s->type, 0, 0, s->value,
						    s->sec, s->sym_index);
				else
					put_stabs(s1, s->str, s->type, 0, 0, s->value);
				tcc_free (s->str);
			}
			tcc_free (cur->sym);
			put_stabn(s1, N_LBRAC, 0, 0, cur->start);
			tcc_debug_finish (s1, cur->child);
			put_stabn(s1, N_RBRAC, 0, 0, cur->end);
		}
		tcc_free (cur);
		cur = next;
	}
}

ST_FUNC void tcc_add_debug_info(TCCState *s1, int param, Sym *s, Sym *e)
{
	CString debug_str;

	if (!(s1->do_debug & 2))
		return;

	cstr_new (&debug_str);
	for (; s != e; s = s->prev) {
		if (!s->v || (s->r & VT_VALMASK) != VT_LOCAL)
			continue;
		if (s1->dwarf) {
			tcc_debug_stabs(s1, get_tok_str(s->v, NULL),
					param ? N_PSYM : N_LSYM, s->c, NULL, 0,
					tcc_get_dwarf_info(s1, s));
		} else {
			cstr_reset (&debug_str);
			cstr_printf (&debug_str, "%s:%s", get_tok_str(s->v, NULL),
				     param ? "p" : "");
			tcc_get_debug_info(s1, s, &debug_str);
			tcc_debug_stabs(s1, debug_str.data, param ? N_PSYM : N_LSYM,
					s->c, NULL, 0, 0);
		}
	}
	cstr_free (&debug_str);
}
/* put function symbol */

ST_FUNC void tcc_debug_funcstart(TCCState *s1, Sym *sym)
{
	CString debug_str;
	BufferedFile *f;

	if (!s1->do_debug)
		return;
	debug_info_root = NULL;
	debug_info = NULL;
	tcc_debug_stabn(s1, N_LBRAC, ind - func_ind);
	f = put_new_file(s1);
	if (!f)
		return;

	if (s1->dwarf) {
		tcc_debug_line(s1);
		dwarf_info.func = sym;
		dwarf_info.line = file->line_num;
		if (s1->do_backtrace) {
			int i, len;

			dwarf_line_op(s1, 0);// extended

			dwarf_uleb128_op(s1, strlen(funcname) + 2);
			dwarf_line_op(s1, DW_LNE_hi_user - 1);
			len = strlen(funcname) + 1;
			for (i = 0; i < len; i++)
				dwarf_line_op(s1, funcname[i]);
		}
	} else {
		cstr_new (&debug_str);
		cstr_printf(&debug_str, "%s:%c", funcname, sym->type.t & VT_STATIC ? 'f' : 'F');
		tcc_get_debug_info(s1, sym->type.ref, &debug_str);
		put_stabs_r(s1, debug_str.data, N_FUN, 0, f->line_num, 0, cur_text_section,
			    sym->c);
		cstr_free (&debug_str);
		tcc_debug_line(s1);
	}
}

ST_FUNC void tcc_debug_prolog_epilog(TCCState *s1, int value)
{
	if (!s1->do_debug)
		return;
	if (s1->dwarf) {
		dwarf_line_op(s1, value == 0 ? DW_LNS_set_prologue_end
			      : DW_LNS_set_epilogue_begin);
	}
}
/* put function size */

ST_FUNC void tcc_debug_funcend(TCCState *s1, int size)
{
	/* lldb does not like function end and next function start at same pc */

	int min_instr_len;
#if TCC_EH_FRAME
	tcc_debug_frame_end(s1, size);
#endif

	if (!s1->do_debug)
		return;
	min_instr_len = dwarf_line.last_pc == ind ? 0 : DWARF_MIN_INSTR_LEN;
	ind -= min_instr_len;
	tcc_debug_line(s1);
	ind += min_instr_len;
	tcc_debug_stabn(s1, N_RBRAC, size);
	if (s1->dwarf) {
		int func_sib = 0;
		Sym *sym = dwarf_info.func;
		int n_debug_info = tcc_get_dwarf_info(s1, sym->type.ref);

		dwarf_data1(dwarf_info_section,
			    sym->type.t & VT_STATIC ? DWARF_ABBREV_SUBPROGRAM_STATIC
			    : DWARF_ABBREV_SUBPROGRAM_EXTERNAL);
		if ((sym->type.t & VT_STATIC) == 0)
			dwarf_data1(dwarf_info_section, 1);
		dwarf_strp(dwarf_info_section, funcname);
		dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
		dwarf_uleb128(dwarf_info_section, dwarf_info.line);
		tcc_debug_check_anon(s1, sym->type.ref, dwarf_info_section->data_offset);
		dwarf_data4(dwarf_info_section, n_debug_info - dwarf_info.start);
		dwarf_reloc(dwarf_info_section, section_sym, R_DATA_PTR);
#if PTR_SIZE == 4
		dwarf_data4(dwarf_info_section, func_ind); // low_pc

		dwarf_data4(dwarf_info_section, size); // high_pc

#else

		dwarf_data8(dwarf_info_section, func_ind);// low_pc

		dwarf_data8(dwarf_info_section, size);// high_pc

#endif

		func_sib = dwarf_info_section->data_offset;
		dwarf_data4(dwarf_info_section, 0);// sibling

		dwarf_data1(dwarf_info_section, 1);

		dwarf_data1(dwarf_info_section, DW_OP_reg6);// rbp

// 2228 "tccdbg.c"
		tcc_debug_finish (s1, debug_info_root);
		dwarf_data1(dwarf_info_section, 0);
		write32le(dwarf_info_section->data + func_sib,
			  dwarf_info_section->data_offset - dwarf_info.start);
	} else {
		tcc_debug_finish (s1, debug_info_root);
	}
	debug_info_root = 0;
}

ST_FUNC void tcc_debug_extern_sym(TCCState *s1, Sym *sym, int sh_num,
				  int sym_bind, int sym_type)
{
	if (!(s1->do_debug & 2))
		return;

	if (sym_type == STT_FUNC || sym->v >= SYM_FIRST_ANOM)
		return;
	if (s1->dwarf) {
		int debug_type;

		debug_type = tcc_get_dwarf_info(s1, sym);
		dwarf_data1(dwarf_info_section,
			    sym_bind == STB_GLOBAL
			    ? DWARF_ABBREV_VARIABLE_EXTERNAL
			    : DWARF_ABBREV_VARIABLE_STATIC);
		dwarf_strp(dwarf_info_section, get_tok_str(sym->v, NULL));
		dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
		dwarf_uleb128(dwarf_info_section, file->line_num);
		tcc_debug_check_anon(s1, sym, dwarf_info_section->data_offset);
		dwarf_data4(dwarf_info_section, debug_type - dwarf_info.start);
		if (sym_bind == STB_GLOBAL)
			dwarf_data1(dwarf_info_section, 1);
		dwarf_data1(dwarf_info_section, PTR_SIZE + 1);
		dwarf_data1(dwarf_info_section, DW_OP_addr);
		greloca(dwarf_info_section, sym, dwarf_info_section->data_offset,
			R_DATA_PTR, 0);
#if PTR_SIZE == 4
		dwarf_data4(dwarf_info_section, 0);
#else

		dwarf_data8(dwarf_info_section, 0);
#endif

	} else {
		Section *s = sh_num == SHN_COMMON ? common_section
			     : s1->sections[sh_num];
		CString str;

		cstr_new (&str);
		cstr_printf (&str, "%s:%c",
			     get_tok_str(sym->v, NULL),
			     sym_bind == STB_GLOBAL ? 'G' : func_ind != -1 ? 'V' : 'S'
			    );
		tcc_get_debug_info(s1, sym, &str);
		if (sym_bind == STB_GLOBAL)
			tcc_debug_stabs(s1, str.data, N_GSYM, 0, NULL, 0, 0);
		else
			tcc_debug_stabs(s1, str.data,
					(sym->type.t & VT_STATIC) && data_section == s
					? N_STSYM : N_LCSYM, 0, s, sym->c, 0);
		cstr_free (&str);
	}
}

ST_FUNC void tcc_debug_typedef(TCCState *s1, Sym *sym)
{
	if (!(s1->do_debug & 2))
		return;

	if (s1->dwarf) {
		int debug_type;

		debug_type = tcc_get_dwarf_info(s1, sym);
		if (debug_type != -1) {
			dwarf_data1(dwarf_info_section, DWARF_ABBREV_TYPEDEF);
			dwarf_strp(dwarf_info_section, get_tok_str(sym->v, NULL));
			dwarf_uleb128(dwarf_info_section, dwarf_line.cur_file);
			dwarf_uleb128(dwarf_info_section, file->line_num);
			tcc_debug_check_anon(s1, sym, dwarf_info_section->data_offset);
			dwarf_data4(dwarf_info_section, debug_type - dwarf_info.start);
		}
	} else {
		CString str;
		cstr_new (&str);
		cstr_printf (&str, "%s:t",
			     (sym->v & ~SYM_FIELD) >= SYM_FIRST_ANOM
			     ? "" : get_tok_str(sym->v, NULL));
		tcc_get_debug_info(s1, sym, &str);
		tcc_debug_stabs(s1, str.data, N_LSYM, 0, NULL, 0, 0);
		cstr_free (&str);
	}
}
/* ------------------------------------------------------------------------- */
/* for section layout see lib/tcov.c */

ST_FUNC void tcc_tcov_block_end(TCCState *s1, int line);

ST_FUNC void tcc_tcov_block_begin(TCCState *s1)
{
	SValue sv;
	void *ptr;
	unsigned long last_offset = tcov_data.offset;

	tcc_tcov_block_end (tcc_state, 0);
	if (s1->test_coverage == 0 || nocode_wanted)
		return;

	if (tcov_data.last_file_name == 0 ||
	    strcmp ((const char *)(tcov_section->data + tcov_data.last_file_name),
		    file->true_filename) != 0) {
		char wd[1024];
		CString cstr;

		if (tcov_data.last_func_name)
			section_ptr_add(tcov_section, 1);
		if (tcov_data.last_file_name)
			section_ptr_add(tcov_section, 1);
		tcov_data.last_func_name = 0;
		cstr_new (&cstr);
		if (file->true_filename[0] == '/') {
			tcov_data.last_file_name = tcov_section->data_offset;
			cstr_printf (&cstr, "%s", file->true_filename);
		} else {
			getcwd (wd, sizeof(wd));
			tcov_data.last_file_name = tcov_section->data_offset + strlen(wd) + 1;
			cstr_printf (&cstr, "%s/%s", wd, file->true_filename);
		}
		ptr = section_ptr_add(tcov_section, cstr.size + 1);
		strcpy((char *)ptr, cstr.data);

		normalize_slashes((char *)ptr);

		cstr_free (&cstr);
	}
	if (tcov_data.last_func_name == 0 ||
	    strcmp ((const char *)(tcov_section->data + tcov_data.last_func_name),
		    funcname) != 0) {
		size_t len;

		if (tcov_data.last_func_name)
			section_ptr_add(tcov_section, 1);
		tcov_data.last_func_name = tcov_section->data_offset;
		len = strlen (funcname);
		ptr = section_ptr_add(tcov_section, len + 1);
		strcpy((char *)ptr, funcname);
		section_ptr_add(tcov_section, -tcov_section->data_offset & 7);
		ptr = section_ptr_add(tcov_section, 8);
		write64le (ptr, file->line_num);
	}
	if (ind == tcov_data.ind && tcov_data.line == file->line_num)
		tcov_data.offset = last_offset;
	else {
		Sym label = {0};
		label.type.t = VT_LLONG | VT_STATIC;

		ptr = section_ptr_add(tcov_section, 16);
		tcov_data.line = file->line_num;
		write64le (ptr, (tcov_data.line << 8) | 0xff);
		put_extern_sym(&label, tcov_section,
			       ((unsigned char *)ptr - tcov_section->data) + 8, 0);
		sv.type = label.type;
		sv.r = VT_SYM | VT_LVAL | VT_CONST;
		sv.r2 = VT_CONST;
		sv.c.i = 0;
		sv.sym = &label;

		gen_increment_tcov (&sv);

		tcov_data.offset = (unsigned char *)ptr - tcov_section->data;
		tcov_data.ind = ind;
	}
}

ST_FUNC void tcc_tcov_block_end(TCCState *s1, int line)
{
	if (s1->test_coverage == 0)
		return;
	if (line == -1)
		line = tcov_data.line;
	if (tcov_data.offset) {
		void *ptr = tcov_section->data + tcov_data.offset;
		unsigned long long nline = line ? line : file->line_num;

		write64le (ptr, (read64le (ptr) & 0xfffffffffull) | (nline << 36));
		tcov_data.offset = 0;
	}
}

ST_FUNC void tcc_tcov_check_line(TCCState *s1, int start)
{
	if (s1->test_coverage == 0)
		return;
	if (tcov_data.line != file->line_num) {
		if ((tcov_data.line + 1) != file->line_num) {
			tcc_tcov_block_end (s1, -1);
			if (start)
				tcc_tcov_block_begin (s1);
		} else
			tcov_data.line = file->line_num;
	}
}

ST_FUNC void tcc_tcov_start(TCCState *s1)
{
	if (s1->test_coverage == 0)
		return;
	if (!s1->dState)
		s1->dState = tcc_mallocz(sizeof *s1->dState);
	memset (&tcov_data, 0, sizeof (tcov_data));
	if (tcov_section == NULL) {
		tcov_section = new_section(tcc_state, ".tcov", SHT_PROGBITS,
					   SHF_ALLOC | SHF_WRITE);
		section_ptr_add(tcov_section, 4);// pointer to executable name

	}
}

ST_FUNC void tcc_tcov_end(TCCState *s1)
{
	if (s1->test_coverage == 0)
		return;
	if (tcov_data.last_func_name)
		section_ptr_add(tcov_section, 1);
	if (tcov_data.last_file_name)
		section_ptr_add(tcov_section, 1);
}

ST_FUNC void tcc_tcov_reset_ind(TCCState *s1)
{
	tcov_data.ind = 0;
}
/* ------------------------------------------------------------------------- */

#undef last_line_num
#undef new_file
#undef section_sym
#undef debug_next_type
#undef debug_hash
#undef n_debug_hash
#undef debug_anon_hash
#undef n_debug_anon_hash
#undef debug_info
#undef debug_info_root
#undef dwarf_sym
#undef dwarf_line
#undef dwarf_info
#undef tcov_data
// 29 "libtcc.c" 2
// 1 "tccasm.c" 1
/*
 *  GAS like assembler for TCC
 *
 *  Copyright (c) 2001-2004 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// 21 "tccasm.c"
#define USING_GLOBALS
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 23 "tccasm.c" 2
#ifdef CONFIG_TCC_ASM

static Section *last_text_section;/* to handle .previous asm directive */

static int asmgoto_n;

static int asm_get_prefix_name(TCCState *s1, const char *prefix, unsigned int n)
{
	char buf[64];
	snprintf(buf, sizeof(buf), "%s%u", prefix, n);
	return tok_alloc_const(buf);
}

ST_FUNC int asm_get_local_label_name(TCCState *s1, unsigned int n)
{
	return asm_get_prefix_name(s1, "L..", n);
}

static int tcc_assemble_internal(TCCState *s1, int do_preprocess, int global);
static Sym *asm_new_label(TCCState *s1, int label, int is_local);
static Sym *asm_new_label1(TCCState *s1, int label, int is_local, int sh_num,
			   int value);
/* If a C name has an _ prepended then only asm labels that start
   with _ are representable in C, by removing the first _.  ASM names
   without _ at the beginning don't correspond to C names, but we use
   the global C symbol table to track ASM names as well, so we need to
   transform those into ones that don't conflict with a C name,
   so prepend a '.' for them, but force the ELF asm name to be set.  */

static int asm2cname(int v, int *addeddot)
{
	const char *name;
	*addeddot = 0;
	if (!tcc_state->leading_underscore)
		return v;
	name = get_tok_str(v, NULL);
	if (!name)
		return v;
	if (name[0] == '_') {
		v = tok_alloc_const(name + 1);
	} else if (!strchr(name, '.')) {
		char newname[256];
		snprintf(newname, sizeof newname, ".%s", name);
		v = tok_alloc_const(newname);
		*addeddot = 1;
	}
	return v;
}

static Sym *asm_label_find(int v)
{
	Sym *sym;
	int addeddot;
	v = asm2cname(v, &addeddot);
	sym = sym_find(v);
	while (sym && sym->sym_scope && !(sym->type.t & VT_STATIC))
		sym = sym->prev_tok;
	return sym;
}

static Sym *asm_label_push(int v)
{
	int addeddot, v2 = asm2cname(v, &addeddot);
	/* We always add VT_EXTERN, for sym definition that's tentative
	       (for .set, removed for real defs), for mere references it's correct
	       as is.  */

	Sym *sym = global_identifier_push(v2, VT_ASM | VT_EXTERN | VT_STATIC, 0);
	if (addeddot)
		sym->asm_label = v;
	return sym;
}
/* Return a symbol we can use inside the assembler, having name NAME.
   Symbols from asm and C source share a namespace.  If we generate
   an asm symbol it's also a (file-global) C symbol, but it's
   either not accessible by name (like "L.123"), or its type information
   is such that it's not usable without a proper C declaration.

   Sometimes we need symbols accessible by name from asm, which
   are anonymous in C, in this case CSYM can be used to transfer
   all information from that symbol to the (possibly newly created)
   asm symbol.  */
// 103 "tccasm.c"
ST_FUNC Sym *get_asm_sym(int name, Sym *csym)
{
	Sym *sym = asm_label_find(name);
	if (!sym) {
		sym = asm_label_push(name);
		if (csym)
			sym->c = csym->c;
	}
	return sym;
}

static Sym *asm_section_sym(TCCState *s1, Section *sec)
{
	char buf[100];
	int label;
	Sym *sym;
	snprintf(buf, sizeof buf, "L.%s", sec->name);
	label = tok_alloc_const(buf);
	sym = asm_label_find(label);
	return sym ? sym : asm_new_label1(s1, label, 1, sec->sh_num, 0);
}
/* We do not use the C expression parser to handle symbols. Maybe the
   C expression parser could be tweaked to do so. */

static void asm_expr_unary(TCCState *s1, ExprValue *pe)
{
	Sym *sym;
	int op, label;
	uint64_t n;
	const char *p;

	switch (tok) {
	case TOK_PPNUM:
		p = tokc.str.data;
		n = strtoull(p, (char **)&p, 0);
		if (*p == 'b' || *p == 'f') {
			/* backward or forward label */

			label = asm_get_local_label_name(s1, n);
			sym = asm_label_find(label);
			if (*p == 'b') {
				/* backward : find the last corresponding defined label */

				if (sym && (!sym->c || elfsym(sym)->st_shndx == SHN_UNDEF))
					sym = sym->prev_tok;
				if (!sym)
					tcc_error("local label '%d' not found backward", (int)n);
			} else {
				/* forward */

				if (!sym || (sym->c && elfsym(sym)->st_shndx != SHN_UNDEF)) {
					/* if the last label is defined, then define a new one */

					sym = asm_label_push(label);
				}
			}
			pe->v = 0;
			pe->sym = sym;
			pe->pcrel = 0;
		} else if (*p == '\0') {
			pe->v = n;
			pe->sym = NULL;
			pe->pcrel = 0;
		} else {
			tcc_error("invalid number syntax");
		}
		next();
		break;
	case '+':
		next();
		asm_expr_unary(s1, pe);
		break;
	case '-':
	case '~':
		op = tok;
		next();
		asm_expr_unary(s1, pe);
		if (pe->sym)
			tcc_error("invalid operation with label");
		if (op == '-')
			pe->v = -pe->v;
		else
			pe->v = ~pe->v;
		break;
	case TOK_CCHAR:
	case TOK_LCHAR:
		pe->v = tokc.i;
		pe->sym = NULL;
		pe->pcrel = 0;
		next();
		break;
	case '(':
		next();
		asm_expr(s1, pe);
		skip(')');
		break;
	case '.':
		pe->v = ind;
		pe->sym = asm_section_sym(s1, cur_text_section);
		pe->pcrel = 0;
		next();
		break;
	default:
		if (tok >= TOK_IDENT) {
			ElfSym *esym;
			/* label case : if the label was not found, add one */

			sym = get_asm_sym(tok, NULL);
			esym = elfsym(sym);
			if (esym && esym->st_shndx == SHN_ABS) {
				/* if absolute symbol, no need to put a symbol value */

				pe->v = esym->st_value;
				pe->sym = NULL;
				pe->pcrel = 0;
			} else {
				pe->v = 0;
				pe->sym = sym;
				pe->pcrel = 0;
			}
			next();
		} else {
			tcc_error("bad expression syntax [%s]", get_tok_str(tok, &tokc));
		}
		break;
	}
}

static void asm_expr_prod(TCCState *s1, ExprValue *pe)
{
	int op;
	ExprValue e2;

	asm_expr_unary(s1, pe);
	for (;;) {
		op = tok;
		if (op != '*' && op != '/' && op != '%' &&
		    op != TOK_SHL && op != TOK_SAR)
			break;
		next();
		asm_expr_unary(s1, &e2);
		if (pe->sym || e2.sym)
			tcc_error("invalid operation with label");
		switch (op) {
		case '*':
			pe->v *= e2.v;
			break;
		case '/':
			if (e2.v == 0) {
div_error:
				tcc_error("division by zero");
			}
			pe->v /= e2.v;
			break;
		case '%':
			if (e2.v == 0)
				goto div_error;
			pe->v %= e2.v;
			break;
		case TOK_SHL:
			pe->v <<= e2.v;
			break;
		default:
		case TOK_SAR:
			pe->v >>= e2.v;
			break;
		}
	}
}

static void asm_expr_logic(TCCState *s1, ExprValue *pe)
{
	int op;
	ExprValue e2;

	asm_expr_prod(s1, pe);
	for (;;) {
		op = tok;
		if (op != '&' && op != '|' && op != '^')
			break;
		next();
		asm_expr_prod(s1, &e2);
		if (pe->sym || e2.sym)
			tcc_error("invalid operation with label");
		switch (op) {
		case '&':
			pe->v &= e2.v;
			break;
		case '|':
			pe->v |= e2.v;
			break;
		default:
		case '^':
			pe->v ^= e2.v;
			break;
		}
	}
}

static inline void asm_expr_sum(TCCState *s1, ExprValue *pe)
{
	int op;
	ExprValue e2;

	asm_expr_logic(s1, pe);
	for (;;) {
		op = tok;
		if (op != '+' && op != '-')
			break;
		next();
		asm_expr_logic(s1, &e2);
		if (op == '+') {
			if (pe->sym != NULL && e2.sym != NULL)
				goto cannot_relocate;
			pe->v += e2.v;
			if (pe->sym == NULL && e2.sym != NULL)
				pe->sym = e2.sym;
		} else {
			pe->v -= e2.v;
			/* NOTE: we are less powerful than gas in that case
			               because we store only one symbol in the expression */

			if (!e2.sym) {
				/* OK */

			} else if (pe->sym == e2.sym) {
				/* OK */

				pe->sym = NULL;/* same symbols can be subtracted to NULL */

			} else {
				ElfSym *esym1, *esym2;
				esym1 = elfsym(pe->sym);
				esym2 = elfsym(e2.sym);
				if (!esym2)
					goto cannot_relocate;
				if (esym1 && esym1->st_shndx == esym2->st_shndx
				    && esym1->st_shndx != SHN_UNDEF) {
					/* we also accept defined symbols in the same section */

					pe->v += esym1->st_value - esym2->st_value;
					pe->sym = NULL;
				} else if (esym2->st_shndx == cur_text_section->sh_num) {
					/* When subtracting a defined symbol in current section
							       this actually makes the value PC-relative.  */

					pe->v += 0 - esym2->st_value;
					pe->pcrel = 1;
					e2.sym = NULL;
				} else {
cannot_relocate:
					tcc_error("invalid operation with label");
				}
			}
		}
	}
}

static inline void asm_expr_cmp(TCCState *s1, ExprValue *pe)
{
	int op;
	ExprValue e2;

	asm_expr_sum(s1, pe);
	for (;;) {
		op = tok;
		if (op != TOK_EQ && op != TOK_NE
		    && (op > TOK_GT || op < TOK_ULE))
			break;
		next();
		asm_expr_sum(s1, &e2);
		if (pe->sym || e2.sym)
			tcc_error("invalid operation with label");
		switch (op) {
		case TOK_EQ:
			pe->v = pe->v == e2.v;
			break;
		case TOK_NE:
			pe->v = pe->v != e2.v;
			break;
		case TOK_LT:
			pe->v = (int64_t)pe->v < (int64_t)e2.v;
			break;
		case TOK_GE:
			pe->v = (int64_t)pe->v >= (int64_t)e2.v;
			break;
		case TOK_LE:
			pe->v = (int64_t)pe->v <= (int64_t)e2.v;
			break;
		case TOK_GT:
			pe->v = (int64_t)pe->v > (int64_t)e2.v;
			break;
		default:
			break;
		}
		/* GAS compare results are -1/0 not 1/0.  */

		pe->v = -(int64_t)pe->v;
	}
}

ST_FUNC void asm_expr(TCCState *s1, ExprValue *pe)
{
	asm_expr_cmp(s1, pe);
}

ST_FUNC int asm_int_expr(TCCState *s1)
{
	ExprValue e;
	asm_expr(s1, &e);
	if (e.sym)
		expect("constant");
	return e.v;
}

static Sym *asm_new_label1(TCCState *s1, int label, int is_local,
			   int sh_num, int value)
{
	Sym *sym;
	ElfSym *esym;

	sym = asm_label_find(label);
	if (sym) {
		esym = elfsym(sym);
		/* A VT_EXTERN symbol, even if it has a section is considered
			   overridable.  This is how we "define" .set targets.  Real
			   definitions won't have VT_EXTERN set.  */

		if (esym && esym->st_shndx != SHN_UNDEF) {
			/* the label is already defined */

			if (IS_ASM_SYM(sym)
			    && (is_local == 1 || (sym->type.t & VT_EXTERN)))
				goto new_label;
			if (!(sym->type.t & VT_EXTERN))
				tcc_error("assembler label '%s' already defined",
					  get_tok_str(label, NULL));
		}
	} else {
new_label:
		sym = asm_label_push(label);
	}
	if (!sym->c)
		put_extern_sym2(sym, SHN_UNDEF, 0, 0, 1);
	esym = elfsym(sym);
	esym->st_shndx = sh_num;
	esym->st_value = value;
	if (is_local != 2)
		sym->type.t &= ~VT_EXTERN;
	return sym;
}

static Sym *asm_new_label(TCCState *s1, int label, int is_local)
{
	return asm_new_label1(s1, label, is_local, cur_text_section->sh_num, ind);
}
/* Set the value of LABEL to that of some expression (possibly
   involving other symbols).  LABEL can be overwritten later still.  */

static Sym *set_symbol(TCCState *s1, int label)
{
	long n;
	ExprValue e;
	Sym *sym;
	ElfSym *esym;
	next();
	asm_expr(s1, &e);
	n = e.v;
	esym = elfsym(e.sym);
	if (esym)
		n += esym->st_value;
	sym = asm_new_label1(s1, label, 2, esym ? esym->st_shndx : SHN_ABS, n);
	elfsym(sym)->st_other |= ST_ASM_SET;
	return sym;
}

static void use_section1(TCCState *s1, Section *sec)
{
	cur_text_section->data_offset = ind;
	cur_text_section = sec;
	ind = cur_text_section->data_offset;
}

static void use_section(TCCState *s1, const char *name)
{
	Section *sec;
	sec = find_section(s1, name);
	use_section1(s1, sec);
}

static void push_section(TCCState *s1, const char *name)
{
	Section *sec = find_section(s1, name);
	sec->prev = cur_text_section;
	use_section1(s1, sec);
}

static void pop_section(TCCState *s1)
{
	Section *prev = cur_text_section->prev;
	if (!prev)
		tcc_error(".popsection without .pushsection");
	cur_text_section->prev = NULL;
	use_section1(s1, prev);
}

static void asm_parse_directive(TCCState *s1, int global)
{
	int n, offset, v, size, tok1;
	Section *sec;
	uint8_t *ptr;
	/* assembler directive */

	sec = cur_text_section;
	switch (tok) {
	case TOK_ASMDIR_align:
	case TOK_ASMDIR_balign:
	case TOK_ASMDIR_p2align:
	case TOK_ASMDIR_skip:
	case TOK_ASMDIR_space:
		tok1 = tok;
		next();
		n = asm_int_expr(s1);
		if (tok1 == TOK_ASMDIR_p2align) {
			if (n < 0 || n > 30)
				tcc_error("invalid p2align, must be between 0 and 30");
			n = 1 << n;
			tok1 = TOK_ASMDIR_align;
		}
		if (tok1 == TOK_ASMDIR_align || tok1 == TOK_ASMDIR_balign) {
			if (n < 0 || (n & (n-1)) != 0)
				tcc_error("alignment must be a positive power of two");
			offset = (ind + n - 1) & -n;
			size = offset - ind;
			/* the section must have a compatible alignment */

			if (sec->sh_addralign < n)
				sec->sh_addralign = n;
		} else {
			if (n < 0)
				n = 0;
			size = n;
		}
		v = 0;
		if (tok == ',') {
			next();
			v = asm_int_expr(s1);
		}
zero_pad:
		if (sec->sh_type != SHT_NOBITS) {
			sec->data_offset = ind;
			ptr = section_ptr_add(sec, size);
			memset(ptr, v, size);
		}
		ind += size;
		break;
	case TOK_ASMDIR_quad:

		size = 8;
		goto asm_data;
// 575 "tccasm.c"
	case TOK_ASMDIR_byte:
		size = 1;
		goto asm_data;
	case TOK_ASMDIR_word:
	case TOK_ASMDIR_short:
		size = 2;
		goto asm_data;
	case TOK_ASMDIR_long:
	case TOK_ASMDIR_int:
		size = 4;
asm_data:
		next();
		for (;;) {
			ExprValue e;
			asm_expr(s1, &e);
			if (sec->sh_type != SHT_NOBITS) {
				if (size == 4) {
					gen_expr32(&e);

				} else if (size == 8) {
					gen_expr64(&e);

				} else {
					if (e.sym)
						expect("constant");
					if (size == 1)
						g(e.v);
					else
						gen_le16(e.v);
				}
			} else {
				ind += size;
			}
			if (tok != ',')
				break;
			next();
		}
		break;
	case TOK_ASMDIR_fill: {
		int repeat, size, val, i, j;
		uint8_t repeat_buf[8];
		next();
		repeat = asm_int_expr(s1);
		if (repeat < 0) {
			tcc_error("repeat < 0; .fill ignored");
			break;
		}
		size = 1;
		val = 0;
		if (tok == ',') {
			next();
			size = asm_int_expr(s1);
			if (size < 0) {
				tcc_error("size < 0; .fill ignored");
				break;
			}
			if (size > 8)
				size = 8;
			if (tok == ',') {
				next();
				val = asm_int_expr(s1);
			}
		}
		/* XXX: endianness */

		repeat_buf[0] = val;
		repeat_buf[1] = val >> 8;
		repeat_buf[2] = val >> 16;
		repeat_buf[3] = val >> 24;
		repeat_buf[4] = 0;
		repeat_buf[5] = 0;
		repeat_buf[6] = 0;
		repeat_buf[7] = 0;
		for (i = 0; i < repeat; i++) {
			for (j = 0; j < size; j++) {
				g(repeat_buf[j]);
			}
		}
	}
	break;
	case TOK_ASMDIR_rept: {
		int repeat;
		TokenString *init_str;
		next();
		repeat = asm_int_expr(s1);
		init_str = tok_str_alloc();
		while (next(), tok != TOK_ASMDIR_endr) {
			if (tok == CH_EOF)
				tcc_error("we at end of file, .endr not found");
			tok_str_add_tok(init_str);
		}
		tok_str_add(init_str, TOK_EOF);
		begin_macro(init_str, 1);
		while (repeat-- > 0) {
			tcc_assemble_internal(s1, (parse_flags & PARSE_FLAG_PREPROCESS),
					      global);
			macro_ptr = init_str->str;
		}
		end_macro();
		next();
		break;
	}
	case TOK_ASMDIR_org: {
		unsigned long n;
		ExprValue e;
		ElfSym *esym;
		next();
		asm_expr(s1, &e);
		n = e.v;
		esym = elfsym(e.sym);
		if (esym) {
			if (esym->st_shndx != cur_text_section->sh_num)
				expect("constant or same-section symbol");
			n += esym->st_value;
		}
		if (n < ind)
			tcc_error("attempt to .org backwards");
		v = 0;
		size = n - ind;
		goto zero_pad;
	}
	break;
	case TOK_ASMDIR_set:
		next();
		tok1 = tok;
		next();
		/* Also accept '.set stuff', but don't do anything with this.
			   It's used in GAS to set various features like '.set mips16'.  */

		if (tok == ',')
			set_symbol(s1, tok1);
		break;
	case TOK_ASMDIR_globl:
	case TOK_ASMDIR_global:
	case TOK_ASMDIR_weak:
	case TOK_ASMDIR_hidden:
		tok1 = tok;
		do {
			Sym *sym;
			next();
			sym = get_asm_sym(tok, NULL);
			if (tok1 != TOK_ASMDIR_hidden)
				sym->type.t &= ~VT_STATIC;
			if (tok1 == TOK_ASMDIR_weak)
				sym->a.weak = 1;
			else if (tok1 == TOK_ASMDIR_hidden)
				sym->a.visibility = STV_HIDDEN;
			update_storage(sym);
			next();
		} while (tok == ',');
		break;
	case TOK_ASMDIR_string:
	case TOK_ASMDIR_ascii:
	case TOK_ASMDIR_asciz: {
		const char *p;
		int i, size, t;

		t = tok;
		next();
		for (;;) {
			if (tok != TOK_STR)
				expect("string constant");
			p = tokc.str.data;
			size = tokc.str.size;
			if (t == TOK_ASMDIR_ascii && size > 0)
				size--;
			for (i = 0; i < size; i++)
				g(p[i]);
			next();
			if (tok == ',') {
				next();
			} else if (tok != TOK_STR) {
				break;
			}
		}
	}
	break;
	case TOK_ASMDIR_text:
	case TOK_ASMDIR_data:
	case TOK_ASMDIR_bss: {
		char sname[64];
		tok1 = tok;
		n = 0;
		next();
		if (tok != ';' && tok != TOK_LINEFEED) {
			n = asm_int_expr(s1);
			next();
		}
		if (n)
			sprintf(sname, "%s%d", get_tok_str(tok1, NULL), n);
		else
			sprintf(sname, "%s", get_tok_str(tok1, NULL));
		use_section(s1, sname);
	}
	break;
	case TOK_ASMDIR_file: {
		const char *p;
		parse_flags &= ~PARSE_FLAG_TOK_STR;
		next();
		if (tok == TOK_PPNUM)
			next();
		if (tok == TOK_PPSTR && tokc.str.data[0] == '"') {
			tokc.str.data[tokc.str.size - 2] = 0;
			p = tokc.str.data + 1;
		} else if (tok >= TOK_IDENT) {
			p = get_tok_str(tok, &tokc);
		} else {
			skip_to_eol(0);
			break;
		}
		tccpp_putfile(p);
		next();
	}
	break;
	case TOK_ASMDIR_ident: {
		char ident[256];

		ident[0] = '\0';
		next();
		if (tok == TOK_STR)
			pstrcat(ident, sizeof(ident), tokc.str.data);
		else
			pstrcat(ident, sizeof(ident), get_tok_str(tok, NULL));
		tcc_warning_c(warn_unsupported)("ignoring .ident %s", ident);
		next();
	}
	break;
	case TOK_ASMDIR_size: {
		Sym *sym;

		next();
		sym = asm_label_find(tok);
		if (!sym) {
			tcc_error("label not found: %s", get_tok_str(tok, NULL));
		}
		/* XXX .size name,label2-label1 */

		tcc_warning_c(warn_unsupported)("ignoring .size %s,*", get_tok_str(tok, NULL));
		next();
		skip(',');
		while (tok != TOK_LINEFEED && tok != ';' && tok != CH_EOF) {
			next();
		}
	}
	break;
	case TOK_ASMDIR_type: {
		Sym *sym;
		const char *newtype;
		int st_type;

		next();
		sym = get_asm_sym(tok, NULL);
		next();
		skip(',');
		if (tok == TOK_STR) {
			newtype = tokc.str.data;
		} else {
			if (tok == '@' || tok == '%')
				next();
			newtype = get_tok_str(tok, NULL);
		}

		if (!strcmp(newtype, "function") || !strcmp(newtype, "STT_FUNC")) {
			if (IS_ASM_SYM(sym))
				sym->type.t = (sym->type.t & ~VT_ASM) | VT_ASM_FUNC;
			st_type = STT_FUNC;
set_st_type:
			if (sym->c) {
				ElfSym *esym = elfsym(sym);
				esym->st_info = ELFW(ST_INFO)(ELFW(ST_BIND)(esym->st_info), st_type);
			}
		} else if (!strcmp(newtype, "object") || !strcmp(newtype, "STT_OBJECT")) {
			st_type = STT_OBJECT;
			goto set_st_type;
		} else
			tcc_warning_c(warn_unsupported)("change type of '%s' from 0x%x to '%s' ignored",
							get_tok_str(sym->v, NULL), sym->type.t, newtype);

		next();
	}
	break;
	case TOK_ASMDIR_pushsection:
	case TOK_ASMDIR_section: {
		char sname[256];
		int old_nb_section = s1->nb_sections;
		int flags = SHF_ALLOC;

		tok1 = tok;
		/* XXX: support more options */

		next();
		sname[0] = '\0';
		while (tok != ';' && tok != TOK_LINEFEED && tok != ',') {
			if (tok == TOK_STR)
				pstrcat(sname, sizeof(sname), tokc.str.data);
			else
				pstrcat(sname, sizeof(sname), get_tok_str(tok, NULL));
			next();
		}
		if (tok == ',') {
			const char *p;
			/* skip section options */

			next();
			if (tok != TOK_STR)
				expect("string constant");
			for (p = tokc.str.data; *p; ++p) {
				if (*p == 'w')
					flags |= SHF_WRITE;
				if (*p == 'x')
					flags |= SHF_EXECINSTR;
			}
			next();
			if (tok == ',') {
				next();
				if (tok == '@' || tok == '%')
					next();
				next();
			}
		}
		last_text_section = cur_text_section;
		if (tok1 == TOK_ASMDIR_section)
			use_section(s1, sname);
		else
			push_section(s1, sname);
		/* If we just allocated a new section reset its alignment to
			       1.  new_section normally acts for GCC compatibility and
			       sets alignment to PTR_SIZE.  The assembler behaves different. */

		if (old_nb_section != s1->nb_sections) {
			cur_text_section->sh_addralign = 1;
			cur_text_section->sh_flags = flags;
		}
	}
	break;
	case TOK_ASMDIR_previous: {
		Section *sec;
		next();
		if (!last_text_section)
			tcc_error("no previous section referenced");
		sec = cur_text_section;
		use_section1(s1, last_text_section);
		last_text_section = sec;
	}
	break;
	case TOK_ASMDIR_popsection:
		next();
		pop_section(s1);
		break;
	/* added for compatibility with GAS */
// 945 "tccasm.c"
	case TOK_ASMDIR_code64:
		next();
		break;
	/* TODO: Implement symvar support. FreeBSD >= 14 needs this */
// 975 "tccasm.c"
	case TOK_ASMDIR_symver:
		next();
		next();
		skip(',');
		next();
		skip('@');
		next();
		break;
	default:
		tcc_error("unknown assembler directive '.%s'", get_tok_str(tok, NULL));
		break;
	}
}
/* assemble a file */

static int tcc_assemble_internal(TCCState *s1, int do_preprocess, int global)
{
	int opcode;
	int saved_parse_flags = parse_flags;

	parse_flags = PARSE_FLAG_ASM_FILE | PARSE_FLAG_TOK_STR;
	if (do_preprocess)
		parse_flags |= PARSE_FLAG_PREPROCESS;
	for (;;) {
		next();
		if (tok == TOK_EOF)
			break;
		tcc_debug_line(s1);
		parse_flags |= PARSE_FLAG_LINEFEED;/* XXX: suppress that hack */

redo:
		if (tok == '#') {
			/* horrible gas comment */

			while (tok != TOK_LINEFEED)
				next();
		} else if (tok >= TOK_ASMDIR_FIRST && tok <= TOK_ASMDIR_LAST) {
			asm_parse_directive(s1, global);
		} else if (tok == TOK_PPNUM) {
			const char *p;
			int n;
			p = tokc.str.data;
			n = strtoul(p, (char **)&p, 10);
			if (*p != '\0')
				expect("':'");
			/* new local label */

			asm_new_label(s1, asm_get_local_label_name(s1, n), 1);
			next();
			skip(':');
			goto redo;
		} else if (tok >= TOK_IDENT) {
			/* instruction or label */

			opcode = tok;
			next();
			if (tok == ':') {
				/* new label */

				asm_new_label(s1, opcode, 0);
				next();
				goto redo;
			} else if (tok == '=') {
				set_symbol(s1, opcode);
				goto redo;
			} else {
				asm_opcode(s1, opcode);
			}
		}
		/* end of line */

		if (tok != ';' && tok != TOK_LINEFEED)
			expect("end of line");
		parse_flags &= ~PARSE_FLAG_LINEFEED;/* XXX: suppress that hack */

	}

	parse_flags = saved_parse_flags;
	return 0;
}
/* Assemble the current file */

ST_FUNC int tcc_assemble(TCCState *s1, int do_preprocess)
{
	int ret;
	tcc_debug_start(s1);
	/* default section is text */

	cur_text_section = text_section;
	ind = cur_text_section->data_offset;
	nocode_wanted = 0;
	ret = tcc_assemble_internal(s1, do_preprocess, 1);
	cur_text_section->data_offset = ind;
	tcc_debug_end(s1);
	return ret;
}
/**/
/* GCC inline asm support */
/* assemble the string 'str' in the current C compilation unit without
   C preprocessing. */

static void tcc_assemble_inline(TCCState *s1, const char *str, int len,
				int global)
{
	const int *saved_macro_ptr = macro_ptr;
	int dotid = set_idnum('.', IS_ID);

	int dolid = set_idnum('$', 0);

	tcc_open_bf(s1, ":asm:", len);
	memcpy(file->buffer, str, len);
	macro_ptr = NULL;
	tcc_assemble_internal(s1, 0, global);
	tcc_close();

	set_idnum('$', dolid);

	set_idnum('.', dotid);
	macro_ptr = saved_macro_ptr;
}
/* find a constraint by its number or id (gcc 3 extended
   syntax). return -1 if not found. Return in *pp in char after the
   constraint */

ST_FUNC int find_constraint(ASMOperand *operands, int nb_operands,
			    const char *name, const char **pp)
{
	int index;
	TokenSym *ts;
	const char *p;

	if (isnum(*name)) {
		index = 0;
		while (isnum(*name)) {
			index = (index * 10) + (*name) - '0';
			name++;
		}
		if ((unsigned)index >= nb_operands)
			index = -1;
	} else if (*name == '[') {
		name++;
		p = strchr(name, ']');
		if (p) {
			ts = tok_alloc(name, p - name);
			for (index = 0; index < nb_operands; index++) {
				if (operands[index].id == ts->tok)
					goto found;
			}
			index = -1;
found:
			name = p + 1;
		} else {
			index = -1;
		}
	} else {
		index = -1;
	}
	if (pp)
		*pp = name;
	return index;
}

static void subst_asm_operands(ASMOperand *operands, int nb_operands,
			       CString *out_str, const char *str)
{
	int c, index, modifier;
	ASMOperand *op;
	SValue sv;

	for (;;) {
		c = *str++;
		if (c == '%') {
			if (*str == '%') {
				str++;
				goto add_char;
			}
			modifier = 0;
			if (*str == 'c' || *str == 'n' ||
			    *str == 'b' || *str == 'w' || *str == 'h' || *str == 'k' ||
			    *str == 'q' || *str == 'l' ||
			    /* P in GCC would add "@PLT" to symbol refs in PIC mode,
			    		   and make literal operands not be decorated with '$'.  */

			    *str == 'P')
				modifier = *str++;
			index = find_constraint(operands, nb_operands, str, &str);
			if (index < 0)
				tcc_error("invalid operand reference after %%");
			op = &operands[index];
			if (modifier == 'l') {
				cstr_cat(out_str, get_tok_str(op->is_label, NULL), -1);
			} else {
				sv = *op->vt;
				if (op->reg >= 0) {
					sv.r = op->reg;
					if ((op->vt->r & VT_VALMASK) == VT_LLOCAL && op->is_memory)
						sv.r |= VT_LVAL;
				}
				subst_asm_operand(out_str, &sv, modifier);
			}
		} else {
add_char:
			cstr_ccat(out_str, c);
			if (c == '\0')
				break;
		}
	}
}

static void parse_asm_operands(ASMOperand *operands, int *nb_operands_ptr,
			       int is_output)
{
	ASMOperand *op;
	int nb_operands;
	char *astr;

	if (tok != ':') {
		nb_operands = *nb_operands_ptr;
		for (;;) {
			if (nb_operands >= MAX_ASM_OPERANDS)
				tcc_error("too many asm operands");
			op = &operands[nb_operands++];
			op->id = 0;
			if (tok == '[') {
				next();
				if (tok < TOK_IDENT)
					expect("identifier");
				op->id = tok;
				next();
				skip(']');
			}
			astr = parse_mult_str("string constant")->data;
			pstrcpy(op->constraint, sizeof op->constraint, astr);
			skip('(');
			gexpr();
			if (is_output) {
				if (!(vtop->type.t & VT_ARRAY))
					test_lvalue();
			} else {
				/* we want to avoid LLOCAL case, except when the 'm'
				                   constraint is used. Note that it may come from
				                   register storage, so we need to convert (reg)
				                   case */

				if ((vtop->r & VT_LVAL) &&
				    ((vtop->r & VT_VALMASK) == VT_LLOCAL ||
				     (vtop->r & VT_VALMASK) < VT_CONST) &&
				    !strchr(op->constraint, 'm')) {
					gv(RC_INT);
				}
			}
			op->vt = vtop;
			skip(')');
			if (tok == ',') {
				next();
			} else {
				break;
			}
		}
		*nb_operands_ptr = nb_operands;
	}
}
/* parse the GCC asm() instruction */

ST_FUNC void asm_instr(void)
{
	CString astr, *astr1;

	ASMOperand operands[MAX_ASM_OPERANDS];
	int nb_outputs, nb_operands, i, must_subst, out_reg, nb_labels;
	uint8_t clobber_regs[NB_ASM_REGS];
	Section *sec;
	/* since we always generate the asm() instruction, we can ignore
	       volatile */

	while (tok == TOK_VOLATILE1 || tok == TOK_VOLATILE2 || tok == TOK_VOLATILE3
	       || tok == TOK_GOTO) {
		next();
	}

	astr1 = parse_asm_str();
	cstr_new_s(&astr);
	cstr_cat(&astr, astr1->data, astr1->size);

	nb_operands = 0;
	nb_outputs = 0;
	nb_labels = 0;
	must_subst = 0;
	memset(clobber_regs, 0, sizeof(clobber_regs));
	if (tok == ':') {
		next();
		must_subst = 1;
		/* output args */

		parse_asm_operands(operands, &nb_operands, 1);
		nb_outputs = nb_operands;
		if (tok == ':') {
			next();
			if (tok != ')') {
				/* input args */

				parse_asm_operands(operands, &nb_operands, 0);
				if (tok == ':') {
					/* clobber list */
					/* XXX: handle registers */

					next();
					for (;;) {
						if (tok == ':')
							break;
						if (tok != TOK_STR)
							expect("string constant");
						asm_clobber(clobber_regs, tokc.str.data);
						next();
						if (tok == ',') {
							next();
						} else {
							break;
						}
					}
				}
				if (tok == ':') {
					/* goto labels */

					next();
					for (;;) {
						Sym *csym;
						int asmname;
						if (nb_operands + nb_labels >= MAX_ASM_OPERANDS)
							tcc_error("too many asm operands");
						if (tok < TOK_UIDENT)
							expect("label identifier");
						operands[nb_operands + nb_labels++].id = tok;

						csym = label_find(tok);
						if (!csym) {
							csym = label_push(&global_label_stack, tok,
									  LABEL_FORWARD);
						} else {
							if (csym->r == LABEL_DECLARED)
								csym->r = LABEL_FORWARD;
						}
						next();
						asmname = asm_get_prefix_name(tcc_state, "LG.",
									      ++asmgoto_n);
						if (!csym->c)
							put_extern_sym2(csym, SHN_UNDEF, 0, 0, 1);
						get_asm_sym(asmname, csym);
						operands[nb_operands + nb_labels - 1].is_label = asmname;

						if (tok != ',')
							break;
						next();
					}
				}
			}
		}
	}
	skip(')');
	/* NOTE: we do not eat the ';' so that we can restore the current
	       token after the assembler parsing */

	if (tok != ';')
		expect("';'");
	/* save all values in the memory */

	save_regs(0);
	/* compute constraints */

	asm_compute_constraints(operands, nb_operands, nb_outputs,
				clobber_regs, &out_reg);
	/* substitute the operands in the asm string. No substitution is
	       done if no operands (GCC behaviour) */
#ifdef ASM_DEBUG

	printf("asm: \"%s\"\n", (char *)astr.data);
#endif

	if (must_subst) {
		cstr_reset(astr1);
		cstr_cat(astr1, astr.data, astr.size);
		cstr_reset(&astr);
		subst_asm_operands(operands, nb_operands + nb_labels, &astr, astr1->data);
	}
#ifdef ASM_DEBUG

	printf("subst_asm: \"%s\"\n", (char *)astr.data);
#endif
	/* generate loads */

	asm_gen_code(operands, nb_operands, nb_outputs, 0,
		     clobber_regs, out_reg);
	/* We don't allow switching section within inline asm to
	       bleed out to surrounding code.  */

	sec = cur_text_section;
	/* assemble the string with tcc internal assembler */

	tcc_assemble_inline(tcc_state, astr.data, astr.size - 1, 0);
	cstr_free_s(&astr);
	if (sec != cur_text_section) {
		tcc_warning("inline asm tries to change current section");
		use_section1(tcc_state, sec);
	}
	/* restore the current C token */

	next();
	/* store the output values if needed */

	asm_gen_code(operands, nb_operands, nb_outputs, 1,
		     clobber_regs, out_reg);
	/* free everything */

	for (i=0; i<nb_operands; i++) {
		vpop();
	}

}

ST_FUNC void asm_global_instr(void)
{
	CString *astr;
	int saved_nocode_wanted = nocode_wanted;
	/* Global asm blocks are always emitted.  */

	nocode_wanted = 0;
	next();
	astr = parse_asm_str();
	skip(')');
	/* NOTE: we do not eat the ';' so that we can restore the current
	       token after the assembler parsing */

	if (tok != ';')
		expect("';'");
#ifdef ASM_DEBUG

	printf("asm_global: \"%s\"\n", (char *)astr->data);
#endif

	cur_text_section = text_section;
	ind = cur_text_section->data_offset;
	/* assemble the string with tcc internal assembler */

	tcc_assemble_inline(tcc_state, astr->data, astr->size - 1, 1);

	cur_text_section->data_offset = ind;
	/* restore the current C token */

	next();

	nocode_wanted = saved_nocode_wanted;
}
/**/
#else

ST_FUNC int tcc_assemble(TCCState *s1, int do_preprocess)
{
	tcc_error("asm not supported");
}

ST_FUNC void asm_instr(void)
{
	tcc_error("inline asm() not supported");
}

ST_FUNC void asm_global_instr(void)
{
	tcc_error("inline asm() not supported");
}
#endif
/* CONFIG_TCC_ASM */
// 30 "libtcc.c" 2
// 1 "tccelf.c" 1
/*
 *  ELF file handling for TCC
 *
 *  Copyright (c) 2001-2004 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// 21 "tccelf.c"
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 22 "tccelf.c" 2
/* Define this to get some debug output during relocation processing.  */

#undef DEBUG_RELOC
/**/
/* global variables */
/* elf version information */

struct sym_version {
	char *lib;
	char *version;
	int out_index;
	int prev_same_lib;
};

#define nb_sym_versions s1->nb_sym_versions
#define sym_versions s1->sym_versions
#define nb_sym_to_version s1->nb_sym_to_version
#define sym_to_version s1->sym_to_version
#define dt_verneednum s1->dt_verneednum
#define versym_section s1->versym_section
#define verneed_section s1->verneed_section
/* special flag to indicate that the section should not be linked to the other ones */

#define SHF_PRIVATE 0x80000000
/* section is dynsymtab_section */

#define SHF_DYNSYM 0x40000000

#define shf_RELRO SHF_ALLOC
static const char rdata[] = ".rdata";
/* ------------------------------------------------------------------------- */

ST_FUNC void tccelf_new(TCCState *s)
{
	TCCState *s1 = s;
	/* no section zero */

	dynarray_add(&s->sections, &s->nb_sections, NULL);
	/* create standard sections */

	text_section = new_section(s, ".text", SHT_PROGBITS, SHF_ALLOC | SHF_EXECINSTR);
	data_section = new_section(s, ".data", SHT_PROGBITS, SHF_ALLOC | SHF_WRITE);
	/* create ro data section (make ro after relocation done with GNU_RELRO) */

	rodata_section = new_section(s, rdata, SHT_PROGBITS, shf_RELRO);
	bss_section = new_section(s, ".bss", SHT_NOBITS, SHF_ALLOC | SHF_WRITE);
	common_section = new_section(s, ".common", SHT_NOBITS, SHF_PRIVATE);
	common_section->sh_num = SHN_COMMON;
	/* symbols are always generated for linking stage */

	symtab_section = new_symtab(s, ".symtab", SHT_SYMTAB, 0,
				    ".strtab",
				    ".hashtab", SHF_PRIVATE);
	/* private symbol table for dynamic symbols */

	s->dynsymtab_section = new_symtab(s, ".dynsymtab", SHT_SYMTAB,
					  SHF_PRIVATE|SHF_DYNSYM,
					  ".dynstrtab",
					  ".dynhashtab", SHF_PRIVATE);
	get_sym_attr(s, 0, 1);

	if (s->do_debug) {
		/* add debug sections */

		tcc_debug_new(s);
	}
#if TCC_EH_FRAME
	if (s->output_format != TCC_OUTPUT_FORMAT_ELF)
		s->unwind_tables = 0;
	tcc_eh_frame_start(s);
#endif
#ifdef CONFIG_TCC_BCHECK

	if (s->do_bounds_check) {
		/* if bound checking, then add corresponding sections */

		/* (make ro after relocation done with GNU_RELRO) */

		bounds_section = new_section(s, ".bounds", SHT_PROGBITS, shf_RELRO);
		lbounds_section = new_section(s, ".lbounds", SHT_PROGBITS, shf_RELRO);
	}
#endif
	/* to make sure that -ltcc1 -Wl,-e,_start will grab the startup code
	       from libtcc1.a (unless _start defined) */
// 110 "tccelf.c"
	if (s->elf_entryname)
		set_global_sym(s, s->elf_entryname, NULL, 0);/* SHN_UNDEF */

}

ST_FUNC void free_section(Section *s)
{
	if (!s)
		return;
	tcc_free(s->data);
	s->data = NULL;
	s->data_allocated = s->data_offset = 0;
}

ST_FUNC void tccelf_delete(TCCState *s1)
{
	int i;
#ifndef ELF_OBJ_ONLY

	/* free symbol versions */

	for (i = 0; i < nb_sym_versions; i++) {
		tcc_free(sym_versions[i].version);
		tcc_free(sym_versions[i].lib);
	}
	tcc_free(sym_versions);
	tcc_free(sym_to_version);
#endif
	/* free all sections */
// 139 "tccelf.c"
	for (i = 1; i < s1->nb_sections; i++)
		free_section(s1->sections[i]);
	dynarray_reset(&s1->sections, &s1->nb_sections);

	for (i = 0; i < s1->nb_priv_sections; i++)
		free_section(s1->priv_sections[i]);
	dynarray_reset(&s1->priv_sections, &s1->nb_priv_sections);

	tcc_free(s1->sym_attrs);
	symtab_section = NULL;/* for tccrun.c:rt_printline() */

}
/* save section data state */

ST_FUNC void tccelf_begin_file(TCCState *s1)
{
	Section *s;
	int i;
	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		s->sh_offset = s->data_offset;
	}
	/* disable symbol hashing during compilation */

	s = s1->symtab, s->reloc = s->hash, s->hash = NULL;

	s1->uw_sym = 0;
	s1->uw_offs = 0;

}

static void update_relocs(TCCState *s1, Section *s, int *old_to_new_syms,
			  int first_sym);
/* At the end of compilation, convert any UNDEF syms to global, and merge
   with previously existing symbols */

ST_FUNC void tccelf_end_file(TCCState *s1)
{
	Section *s = s1->symtab;
	int first_sym, nb_syms, *tr, i;

	first_sym = s->sh_offset / sizeof (ElfSym);
	nb_syms = s->data_offset / sizeof (ElfSym) - first_sym;
	s->data_offset = s->sh_offset;
	s->link->data_offset = s->link->sh_offset;
	s->hash = s->reloc, s->reloc = NULL;
	tr = tcc_mallocz(nb_syms * sizeof *tr);

	for (i = 0; i < nb_syms; ++i) {
		ElfSym *sym = (ElfSym*)s->data + first_sym + i;
		if (sym->st_shndx == SHN_UNDEF) {
			int sym_bind = ELFW(ST_BIND)(sym->st_info);
			int sym_type = ELFW(ST_TYPE)(sym->st_info);
			if (sym_bind == STB_LOCAL)
				sym_bind = STB_GLOBAL;

			sym->st_info = ELFW(ST_INFO)(sym_bind, sym_type);
		}
		tr[i] = set_elf_sym(s, sym->st_value, sym->st_size, sym->st_info,
				    sym->st_other, sym->st_shndx, (char*)s->link->data + sym->st_name);
	}
	/* now update relocations */

	update_relocs(s1, s, tr, first_sym);
	tcc_free(tr);
	/* record text/data/bss output for -bench info */

	for (i = 0; i < 4; ++i) {
		s = s1->sections[i + 1];
		s1->total_output[i] += s->data_offset - s->sh_offset;
	}
}

ST_FUNC Section *new_section(TCCState *s1, const char *name, int sh_type,
			     int sh_flags)
{
	Section *sec;

	sec = tcc_mallocz(sizeof(Section) + strlen(name));
	sec->s1 = s1;
	strcpy(sec->name, name);
	sec->sh_type = sh_type;
	sec->sh_flags = sh_flags;
	switch (sh_type) {
	case SHT_GNU_versym:
		sec->sh_addralign = 2;
		break;
	case SHT_HASH:
	case SHT_GNU_HASH:
	case SHT_REL:
	case SHT_RELA:
	case SHT_DYNSYM:
	case SHT_SYMTAB:
	case SHT_DYNAMIC:
	case SHT_GNU_verneed:
	case SHT_GNU_verdef:
		sec->sh_addralign = PTR_SIZE;
		break;
	case SHT_STRTAB:
		sec->sh_addralign = 1;
		break;
	default:
		sec->sh_addralign = PTR_SIZE;/* gcc/pcc default alignment */

		break;
	}

	if (sh_flags & SHF_PRIVATE) {
		dynarray_add(&s1->priv_sections, &s1->nb_priv_sections, sec);
	} else {
		sec->sh_num = s1->nb_sections;
		dynarray_add(&s1->sections, &s1->nb_sections, sec);
	}

	return sec;
}

ST_FUNC void init_symtab(Section *s)
{
	int *ptr, nb_buckets = 1;
	put_elf_str(s->link, "");
	section_ptr_add(s, sizeof (ElfW(Sym)));
	ptr = section_ptr_add(s->hash, (2 + nb_buckets + 1) * sizeof(int));
	ptr[0] = nb_buckets;
	ptr[1] = 1;
	memset(ptr + 2, 0, (nb_buckets + 1) * sizeof(int));
}

ST_FUNC Section *new_symtab(TCCState *s1,
			    const char *symtab_name, int sh_type, int sh_flags,
			    const char *strtab_name,
			    const char *hash_name, int hash_sh_flags)
{
	Section *symtab, *strtab, *hash;
	symtab = new_section(s1, symtab_name, sh_type, sh_flags);
	symtab->sh_entsize = sizeof(ElfW(Sym));
	strtab = new_section(s1, strtab_name, SHT_STRTAB, sh_flags);
	symtab->link = strtab;
	hash = new_section(s1, hash_name, SHT_HASH, hash_sh_flags);
	hash->sh_entsize = sizeof(int);
	symtab->hash = hash;
	hash->link = symtab;
	init_symtab(symtab);
	return symtab;
}
/* realloc section and set its content to zero */

ST_FUNC void section_realloc(Section *sec, unsigned long new_size)
{
	unsigned long size;
	unsigned char *data;

	size = sec->data_allocated;
	if (size == 0)
		size = 1;
	while (size < new_size)
		size = size * 2;
	data = tcc_realloc(sec->data, size);
	memset(data + sec->data_allocated, 0, size - sec->data_allocated);
	sec->data = data;
	sec->data_allocated = size;
}
/* reserve at least 'size' bytes aligned per 'align' in section
   'sec' from current offset, and return the aligned offset */

ST_FUNC size_t section_add(Section *sec, addr_t size, int align)
{
	size_t offset, offset1;

	offset = (sec->data_offset + align - 1) & -align;
	offset1 = offset + size;
	if (sec->sh_type != SHT_NOBITS && offset1 > sec->data_allocated)
		section_realloc(sec, offset1);
	sec->data_offset = offset1;
	if (align > sec->sh_addralign)
		sec->sh_addralign = align;
	return offset;
}
/* reserve at least 'size' bytes in section 'sec' from
   sec->data_offset. */

ST_FUNC void *section_ptr_add(Section *sec, addr_t size)
{
	size_t offset = section_add(sec, size, 1);
	return sec->data + offset;
}
#ifndef ELF_OBJ_ONLY

/* reserve at least 'size' bytes from section start */

static void section_reserve(Section *sec, unsigned long size)
{
	if (size > sec->data_allocated)
		section_realloc(sec, size);
	if (size > sec->data_offset)
		sec->data_offset = size;
}
#endif
// 335 "tccelf.c"
static Section *have_section(TCCState *s1, const char *name)
{
	Section *sec;
	int i;
	for (i = 1; i < s1->nb_sections; i++) {
		sec = s1->sections[i];
		if (!strcmp(name, sec->name))
			return sec;
	}
	return NULL;
}
/* return a reference to a section, and create it if it does not
   exists */

ST_FUNC Section *find_section(TCCState *s1, const char *name)
{
	Section *sec = have_section(s1, name);
	if (sec)
		return sec;
	/* sections are created as PROGBITS */

	return new_section(s1, name, SHT_PROGBITS, SHF_ALLOC);
}
/* ------------------------------------------------------------------------- */

ST_FUNC int put_elf_str(Section *s, const char *sym)
{
	int offset, len;
	char *ptr;

	len = strlen(sym) + 1;
	offset = s->data_offset;
	ptr = section_ptr_add(s, len);
	memmove(ptr, sym, len);
	return offset;
}
/* elf symbol hashing function */

static ElfW(Word) elf_hash(const unsigned char *name)
{
	ElfW(Word) h = 0, g;

	while (*name) {
		h = (h << 4) + *name++;
		g = h & 0xf0000000;
		if (g)
			h ^= g >> 24;
		h &= ~g;
	}
	return h;
}
/* rebuild hash table of section s */
/* NOTE: we do factorize the hash table code to go faster */

static void rebuild_hash(Section *s, unsigned int nb_buckets)
{
	ElfW(Sym) *sym;
	int *ptr, *hash, nb_syms, sym_index, h;
	unsigned char *strtab;

	strtab = s->link->data;
	nb_syms = s->data_offset / sizeof(ElfW(Sym));

	if (!nb_buckets)
		nb_buckets = ((int*)s->hash->data)[0];

	s->hash->data_offset = 0;
	ptr = section_ptr_add(s->hash, (2 + nb_buckets + nb_syms) * sizeof(int));
	ptr[0] = nb_buckets;
	ptr[1] = nb_syms;
	ptr += 2;
	hash = ptr;
	memset(hash, 0, (nb_buckets + 1) * sizeof(int));
	ptr += nb_buckets + 1;

	sym = (ElfW(Sym) *)s->data + 1;
	for (sym_index = 1; sym_index < nb_syms; sym_index++) {
		if (ELFW(ST_BIND)(sym->st_info) != STB_LOCAL) {
			h = elf_hash(strtab + sym->st_name) % nb_buckets;
			*ptr = hash[h];
			hash[h] = sym_index;
		} else {
			*ptr = 0;
		}
		ptr++;
		sym++;
	}
}
/* return the symbol number */

ST_FUNC int put_elf_sym(Section *s, addr_t value, unsigned long size,
			int info, int other, int shndx, const char *name)
{
	int name_offset, sym_index;
	int nbuckets, h;
	ElfW(Sym) *sym;
	Section *hs;

	sym = section_ptr_add(s, sizeof(ElfW(Sym)));
	if (name && name[0])
		name_offset = put_elf_str(s->link, name);
	else
		name_offset = 0;
	/* XXX: endianness */

	sym->st_name = name_offset;
	sym->st_value = value;
	sym->st_size = size;
	sym->st_info = info;
	sym->st_other = other;
	sym->st_shndx = shndx;
	sym_index = sym - (ElfW(Sym) *)s->data;
	hs = s->hash;
	if (hs) {
		int *ptr, *base;
		ptr = section_ptr_add(hs, sizeof(int));
		base = (int *)hs->data;
		/* only add global or weak symbols. */

		if (ELFW(ST_BIND)(info) != STB_LOCAL) {
			/* add another hashing entry */

			nbuckets = base[0];
			h = elf_hash((unsigned char *)s->link->data + name_offset) % nbuckets;
			*ptr = base[2 + h];
			base[2 + h] = sym_index;
			base[1]++;
			/* we resize the hash table */

			hs->nb_hashed_syms++;
			if (hs->nb_hashed_syms > 2 * nbuckets) {
				rebuild_hash(s, 2 * nbuckets);
			}
		} else {
			*ptr = 0;
			base[1]++;
		}
	}
	return sym_index;
}

ST_FUNC int find_elf_sym(Section *s, const char *name)
{
	ElfW(Sym) *sym;
	Section *hs;
	int nbuckets, sym_index, h;
	const char *name1;

	hs = s->hash;
	if (!hs)
		return 0;
	nbuckets = ((int *)hs->data)[0];
	h = elf_hash((unsigned char *) name) % nbuckets;
	sym_index = ((int *)hs->data)[2 + h];
	while (sym_index != 0) {
		sym = &((ElfW(Sym) *)s->data)[sym_index];
		name1 = (char *) s->link->data + sym->st_name;
		if (!strcmp(name, name1))
			return sym_index;
		sym_index = ((int *)hs->data)[2 + nbuckets + sym_index];
	}
	return 0;
}
/* return elf symbol value, signal error if 'err' is nonzero, decorate
   name if FORC */

ST_FUNC addr_t get_sym_addr(TCCState *s1, const char *name, int err, int forc)
{
	int sym_index;
	ElfW(Sym) *sym;
	char buf[256];
	if (forc && s1->leading_underscore
	    /* win32-32bit stdcall symbols always have _ already */

	    && !strchr(name, '@')

	   ) {
		buf[0] = '_';
		pstrcpy(buf + 1, sizeof(buf) - 1, name);
		name = buf;
	}
	sym_index = find_elf_sym(s1->symtab, name);
	sym = &((ElfW(Sym) *)s1->symtab->data)[sym_index];
	if (!sym_index || sym->st_shndx == SHN_UNDEF) {
		if (err)
			tcc_error_noabort("%s not defined", name);
		return (addr_t)-1;
	}
	return sym->st_value;
}
/* return elf symbol value */

LIBTCCAPI void *tcc_get_symbol(TCCState *s, const char *name)
{
	addr_t addr = get_sym_addr(s, name, 0, 1);
	return addr == -1 ? NULL : (void*)(uintptr_t)addr;
}

LIBTCCAPI int tcc_add_symbol(TCCState *s1, const char *name, const void *val)
{
	/* On x86_64 'val' might not be reachable with a 32bit offset.
	       So it is handled here as if it were in a DLL. */

	pe_putimport(s1, 0, name, (uintptr_t)val);
// 544 "tccelf.c"
	return 0;
}
/* list elf symbol names and values */

ST_FUNC void list_elf_symbols(TCCState *s, void *ctx,
			      void (*symbol_cb)(void *ctx, const char *name, const void *val))
{
	ElfW(Sym) *sym;
	Section *symtab;
	int sym_index, end_sym;
	const char *name;
	unsigned char sym_vis, sym_bind;

	symtab = s->symtab;
	end_sym = symtab->data_offset / sizeof (ElfSym);
	for (sym_index = 0; sym_index < end_sym; ++sym_index) {
		sym = &((ElfW(Sym) *)symtab->data)[sym_index];
		if (sym->st_value) {
			name = (char *) symtab->link->data + sym->st_name;
			sym_bind = ELFW(ST_BIND)(sym->st_info);
			sym_vis = ELFW(ST_VISIBILITY)(sym->st_other);
			if (sym_bind == STB_GLOBAL && sym_vis == STV_DEFAULT)
				symbol_cb(ctx, name, (void*)(uintptr_t)sym->st_value);
		}
	}
}
/* list elf symbol names and values */

LIBTCCAPI void tcc_list_symbols(TCCState *s, void *ctx,
				void (*symbol_cb)(void *ctx, const char *name, const void *val))
{
	list_elf_symbols(s, ctx, symbol_cb);
}
#ifndef ELF_OBJ_ONLY

static void
version_add (TCCState *s1)
{
	int i;
	ElfW(Sym) *sym;
	ElfW(Verneed) *vn = NULL;
	Section *symtab;
	int sym_index, end_sym, nb_versions = 2, nb_entries = 0;
	ElfW(Half) *versym;
	const char *name;

	if (0 == nb_sym_versions)
		return;
	versym_section = new_section(s1, ".gnu.version", SHT_GNU_versym, SHF_ALLOC);
	versym_section->sh_entsize = sizeof(ElfW(Half));
	versym_section->link = s1->dynsym;

	/* add needed symbols */

	symtab = s1->dynsym;
	end_sym = symtab->data_offset sizeof (ElfSym);
	versym = section_ptr_add(versym_section, end_sym * sizeof(ElfW(Half)));
	for (sym_index = 1; sym_index < end_sym; ++sym_index) {
		int dllindex, verndx;
		sym = &((ElfW(Sym) *)symtab->data)[sym_index];
		name = (char *) symtab->link->data + sym->st_name;
		dllindex = find_elf_sym(s1->dynsymtab_section, name);
		verndx = (dllindex && dllindex < nb_sym_to_version)
			 ? sym_to_version[dllindex] : -1;
		if (verndx >= 0
		    /* XXX: on android, clang refuses to link with a libtcc.so made by tcc
		       when defined symbols have a version > 1 or when the version is '0'.
		       Whereas version '1' for example for 'signal' in an exe defeats
		       bcheck's signal_redir. */

		    && (sym->st_shndx == SHN_UNDEF || (s1->output_type & TCC_OUTPUT_EXE))
		   ) {
			if (!sym_versions[verndx].out_index)
				sym_versions[verndx].out_index = nb_versions++;
			versym[sym_index] = sym_versions[verndx].out_index;
		} else {
			versym[sym_index] = 1; /* (*global*) */

		}
		//printf("SYM %d %s\n", versym[sym_index], name);

	}
	/* generate verneed section, but not when it will be empty.  Some
	   dynamic linkers look at their contents even when DTVERNEEDNUM and
	   section size is zero.  */

	if (nb_versions > 2) {
		verneed_section = new_section(s1, ".gnu.version_r",
					      SHT_GNU_verneed, SHF_ALLOC);
		verneed_section->link = s1->dynsym->link;
		for (i = nb_sym_versions; i-- > 0;) {
			struct sym_version *sv = &sym_versions[i];
			int n_same_libs = 0, prev;
			size_t vnofs;
			ElfW(Vernaux) *vna = 0;
			if (sv->out_index < 1)
				continue;

			/* make sure that a DT_NEEDED tag is put */

			/* abitest-tcc fails on older i386-linux with "ld-linux.so.2" DT_NEEDED
			   ret_int_test... Inconsistency detected by ld.so: dl-minimal.c: 148:
			   realloc: Assertion `ptr == alloc_last_block' failed! */

			if (strcmp(sv->lib, "ld-linux.so.2"))
				tcc_add_dllref(s1, sv->lib, 0);

			vnofs = section_add(verneed_section, sizeof(*vn), 1);
			vn = (ElfW(Verneed)*)(verneed_section->data + vnofs);
			vn->vn_version = 1;
			vn->vn_file = put_elf_str(verneed_section->link, sv->lib);
			vn->vn_aux = sizeof (*vn);
			do {
				prev = sv->prev_same_lib;
				if (sv->out_index > 0) {
					vna = section_ptr_add(verneed_section, sizeof(*vna));
					vna->vna_hash = elf_hash ((const unsigned char *)sv->version);
					vna->vna_flags = 0;
					vna->vna_other = sv->out_index;
					sv->out_index = -2;
					vna->vna_name = put_elf_str(verneed_section->link, sv->version);
					vna->vna_next = sizeof (*vna);
					//printf("LIB %d %s %s\n", vna->vna_other, sv->lib, verneed_section->link->data + vna->vna_name);

					n_same_libs++;
				}
				if (prev >= 0)
					sv = &sym_versions[prev];
			} while (prev >= 0);
			vna->vna_next = 0;
			vn = (ElfW(Verneed)*)(verneed_section->data + vnofs);
			vn->vn_cnt = n_same_libs;
			vn->vn_next = sizeof(*vn) + n_same_libs * sizeof(*vna);
			nb_entries++;
		}
		if (vn)
			vn->vn_next = 0;
		verneed_section->sh_info = nb_entries;
	}
	dt_verneednum = nb_entries;
}
#endif
/* ndef ELF_OBJ_ONLY */
/* add an elf symbol : check if it is already defined and patch
   it. Return symbol index. NOTE that sh_num can be SHN_UNDEF. */
// 681 "tccelf.c"
ST_FUNC int set_elf_sym(Section *s, addr_t value, unsigned long size,
			int info, int other, int shndx, const char *name)
{
	TCCState *s1 = s->s1;
	ElfW(Sym) *esym;
	int sym_bind, sym_index, sym_type, esym_bind;
	unsigned char sym_vis, esym_vis, new_vis;

	sym_bind = ELFW(ST_BIND)(info);
	sym_type = ELFW(ST_TYPE)(info);
	sym_vis = ELFW(ST_VISIBILITY)(other);

	if (sym_bind != STB_LOCAL) {
		/* we search global or weak symbols */

		sym_index = find_elf_sym(s, name);
		if (!sym_index)
			goto do_def;
		esym = &((ElfW(Sym) *)s->data)[sym_index];
		if (esym->st_value == value && esym->st_size == size && esym->st_info == info
		    && esym->st_other == other && esym->st_shndx == shndx)
			return sym_index;
		if (esym->st_shndx != SHN_UNDEF) {
			esym_bind = ELFW(ST_BIND)(esym->st_info);
			/* propagate the most constraining visibility */
			/* STV_DEFAULT(0)<STV_PROTECTED(3)<STV_HIDDEN(2)<STV_INTERNAL(1) */

			esym_vis = ELFW(ST_VISIBILITY)(esym->st_other);
			if (esym_vis == STV_DEFAULT) {
				new_vis = sym_vis;
			} else if (sym_vis == STV_DEFAULT) {
				new_vis = esym_vis;
			} else {
				new_vis = (esym_vis < sym_vis) ? esym_vis : sym_vis;
			}
			esym->st_other = (esym->st_other & ~ELFW(ST_VISIBILITY)(-1))
					 | new_vis;
			if (shndx == SHN_UNDEF) {
				/* ignore adding of undefined symbol if the
				                   corresponding symbol is already defined */

			} else if (sym_bind == STB_GLOBAL && esym_bind == STB_WEAK) {
				/* global overrides weak, so patch */

				goto do_patch;
			} else if (sym_bind == STB_WEAK && esym_bind == STB_GLOBAL) {
				/* weak is ignored if already global */

			} else if (sym_bind == STB_WEAK && esym_bind == STB_WEAK) {
				/* keep first-found weak definition, ignore subsequents */

			} else if (sym_vis == STV_HIDDEN || sym_vis == STV_INTERNAL) {
				/* ignore hidden symbols after */

			} else if ((esym->st_shndx == SHN_COMMON
				    || esym->st_shndx == bss_section->sh_num)
				   && (shndx < SHN_LORESERVE
				       && shndx != bss_section->sh_num)) {
				/* data symbol gets precedence over common/bss */

				goto do_patch;
			} else if (shndx == SHN_COMMON || shndx == bss_section->sh_num) {
				/* data symbol keeps precedence over common/bss */

			} else if (s->sh_flags & SHF_DYNSYM) {
				/* we accept that two DLL define the same symbol */

			} else if (esym->st_other & ST_ASM_SET) {
				/* If the existing symbol came from an asm .set
						   we can override.  */

				goto do_patch;
			} else {

				tcc_error_noabort("'%s' defined twice", name);
			}
		} else {
			esym->st_other = other;
do_patch:
			esym->st_info = ELFW(ST_INFO)(sym_bind, sym_type);
			esym->st_shndx = shndx;
			esym->st_value = value;
			esym->st_size = size;
		}
	} else {
do_def:
		sym_index = put_elf_sym(s, value, size,
					ELFW(ST_INFO)(sym_bind, sym_type), other,
					shndx, name);
	}
	return sym_index;
}
/* put relocation */

ST_FUNC void put_elf_reloca(Section *symtab, Section *s, unsigned long offset,
			    int type, int symbol, addr_t addend)
{
	TCCState *s1 = s->s1;
	char buf[256];
	Section *sr;
	ElfW_Rel *rel;

	sr = s->reloc;
	if (!sr) {
		/* if no relocation section, create it */

		snprintf(buf, sizeof(buf), REL_SECTION_FMT, s->name);
		/* if the symtab is allocated, then we consider the relocation
		           are also */

		sr = new_section(s->s1, buf, SHT_RELX, symtab->sh_flags);
		sr->sh_entsize = sizeof(ElfW_Rel);
		sr->link = symtab;
		sr->sh_info = s->sh_num;
		s->reloc = sr;
	}
	rel = section_ptr_add(sr, sizeof(ElfW_Rel));
	rel->r_offset = offset;
	rel->r_info = ELFW(R_INFO)(symbol, type);
#if SHT_RELX == SHT_RELA

	rel->r_addend = addend;
#endif

	if (SHT_RELX != SHT_RELA && addend)
		tcc_error_noabort("non-zero addend on REL architecture");
}

ST_FUNC void put_elf_reloc(Section *symtab, Section *s, unsigned long offset,
			   int type, int symbol)
{
	put_elf_reloca(symtab, s, offset, type, symbol, 0);
}

ST_FUNC struct sym_attr *get_sym_attr(TCCState *s1, int index, int alloc)
{
	int n;
	struct sym_attr *tab;

	if (index >= s1->nb_sym_attrs) {
		if (!alloc)
			return s1->sym_attrs;
		/* find immediately bigger power of 2 and reallocate array */

		n = 1;
		while (index >= n)
			n *= 2;
		tab = tcc_realloc(s1->sym_attrs, n * sizeof(*s1->sym_attrs));
		s1->sym_attrs = tab;
		memset(s1->sym_attrs + s1->nb_sym_attrs, 0,
		       (n - s1->nb_sym_attrs) * sizeof(*s1->sym_attrs));
		s1->nb_sym_attrs = n;
	}
	return &s1->sym_attrs[index];
}

static void update_relocs(TCCState *s1, Section *s, int *old_to_new_syms,
			  int first_sym)
{
	int i, type, sym_index;
	Section *sr;
	ElfW_Rel *rel;

	for (i = 1; i < s1->nb_sections; i++) {
		sr = s1->sections[i];
		if (sr->sh_type == SHT_RELX && sr->link == s) {
			for_each_elem(sr, 0, rel, ElfW_Rel) {
				sym_index = ELFW(R_SYM)(rel->r_info);
				type = ELFW(R_TYPE)(rel->r_info);
				if ((sym_index -= first_sym) < 0)
					continue;/* zero sym_index in reloc (can happen with asm) */

				sym_index = old_to_new_syms[sym_index];
				rel->r_info = ELFW(R_INFO)(sym_index, type);
			}
		}
	}
}
/* In an ELF file symbol table, the local symbols must appear below
   the global and weak ones. Since TCC cannot sort it while generating
   the code, we must do it after. All the relocation tables are also
   modified to take into account the symbol table sorting */

static void sort_syms(TCCState *s1, Section *s)
{
	int *old_to_new_syms;
	ElfW(Sym) *new_syms;
	int nb_syms, i;
	ElfW(Sym) *p, *q;

	nb_syms = s->data_offset / sizeof(ElfW(Sym));
	new_syms = tcc_malloc(nb_syms * sizeof(ElfW(Sym)));
	old_to_new_syms = tcc_malloc(nb_syms * sizeof(int));
	/* first pass for local symbols */

	p = (ElfW(Sym) *)s->data;
	q = new_syms;
	for (i = 0; i < nb_syms; i++) {
		if (ELFW(ST_BIND)(p->st_info) == STB_LOCAL) {
			old_to_new_syms[i] = q - new_syms;
			*q++ = *p;
		}
		p++;
	}
	/* save the number of local symbols in section header */

	if ( s->sh_size ) /* this 'if' makes IDA happy */

		s->sh_info = q - new_syms;
	/* then second pass for non local symbols */

	p = (ElfW(Sym) *)s->data;
	for (i = 0; i < nb_syms; i++) {
		if (ELFW(ST_BIND)(p->st_info) != STB_LOCAL) {
			old_to_new_syms[i] = q - new_syms;
			*q++ = *p;
		}
		p++;
	}
	/* we copy the new symbols to the old */

	memcpy(s->data, new_syms, nb_syms * sizeof(ElfW(Sym)));
	tcc_free(new_syms);

	update_relocs(s1, s, old_to_new_syms, 0);
	tcc_free(old_to_new_syms);
}
#ifndef ELF_OBJ_ONLY

/* See: https://flapenguin.me/elf-dt-gnu-hash */

#define	ELFCLASS_BITS (PTR_SIZE * 8)

static Section *create_gnu_hash(TCCState *s1)
{
	int nb_syms, i, ndef, nbuckets, symoffset, bloom_size, bloom_shift;
	ElfW(Sym) *p;
	Section *gnu_hash;
	Section *dynsym = s1->dynsym;
	Elf32_Word *ptr;

	gnu_hash = new_section(s1, ".gnu.hash", SHT_GNU_HASH, SHF_ALLOC);
	gnu_hash->link = dynsym->hash->link;

	nb_syms = dynsym->data_offset sizeof(ElfW(Sym));

	/* count def symbols */

	ndef = 0;
	p = (ElfW(Sym) *)dynsym->data;
	for (i = 0; i < nb_syms; i++, p++)
		ndef += p->st_shndx != SHN_UNDEF;

	/* calculate gnu hash sizes and fill header */

	nbuckets = ndef 4 + 1;
	symoffset = nb_syms - ndef;
	bloom_shift = PTR_SIZE == 8 ? 6 : 5;
	bloom_size = 1; /* must be power of two */

	while (ndef >= bloom_size * (1 << (bloom_shift - 3)))
		bloom_size *= 2;
	ptr = section_ptr_add(gnu_hash, 4 * 4 +
			      PTR_SIZE * bloom_size +
			      nbuckets * 4 +
			      ndef * 4);
	ptr[0] = nbuckets;
	ptr[1] = symoffset;
	ptr[2] = bloom_size;
	ptr[3] = bloom_shift;
	return gnu_hash;
}

static Elf32_Word elf_gnu_hash (const unsigned char *name)
{
	Elf32_Word h = 5381;
	unsigned char c;

	while ((c = *name++))
		h = h * 33 + c;
	return h;
}

static void update_gnu_hash(TCCState *s1, Section *gnu_hash)
{
	int *old_to_new_syms;
	ElfW(Sym) *new_syms;
	int nb_syms, i, nbuckets, bloom_size, bloom_shift;
	ElfW(Sym) *p, *q;
	Section *vs;
	Section *dynsym = s1->dynsym;
	Elf32_Word *ptr, *buckets, *chain, *hash;
	unsigned int *nextbuck;
	addr_t *bloom;
	unsigned char *strtab;
	struct {
		int first, last;
	} *buck;

	strtab = dynsym->link->data;
	nb_syms = dynsym->data_offset sizeof(ElfW(Sym));
	new_syms = tcc_malloc(nb_syms * sizeof(ElfW(Sym)));
	old_to_new_syms = tcc_malloc(nb_syms * sizeof(int));
	hash = tcc_malloc(nb_syms * sizeof(Elf32_Word));
	nextbuck = tcc_malloc(nb_syms * sizeof(int));

	/* calculate hashes and copy undefs */

	p = (ElfW(Sym) *)dynsym->data;
	q = new_syms;
	for (i = 0; i < nb_syms; i++, p++) {
		if (p->st_shndx == SHN_UNDEF) {
			old_to_new_syms[i] = q - new_syms;
			*q++ = *p;
		} else
			hash[i] = elf_gnu_hash(strtab + p->st_name);
	}

	ptr = (Elf32_Word *) gnu_hash->data;
	nbuckets = ptr[0];
	bloom_size = ptr[2];
	bloom_shift = ptr[3];
	bloom = (addr_t *) (void *) &ptr[4];
	buckets = (Elf32_Word*) (void *) &bloom[bloom_size];
	chain = &buckets[nbuckets];
	buck = tcc_malloc(nbuckets * sizeof(*buck));

	if (gnu_hash->data_offset != 4 * 4 +
	    PTR_SIZE * bloom_size +
	    nbuckets * 4 +
	    (nb_syms - (q - new_syms)) * 4)
		tcc_error_noabort ("gnu_hash size incorrect");

	/* find buckets */

	for (i = 0; i < nbuckets; i++)
		buck[i].first = -1;

	p = (ElfW(Sym) *)dynsym->data;
	for (i = 0; i < nb_syms; i++, p++)
		if (p->st_shndx != SHN_UNDEF) {
			int bucket = hash[i] % nbuckets;

			if (buck[bucket].first == -1)
				buck[bucket].first = buck[bucket].last = i;
			else {
				nextbuck[buck[bucket].last] = i;
				buck[bucket].last = i;
			}
		}

	/* fill buckets/chains/bloom and sort symbols */

	p = (ElfW(Sym) *)dynsym->data;
	for (i = 0; i < nbuckets; i++) {
		int cur = buck[i].first;

		if (cur != -1) {
			buckets[i] = q - new_syms;
			for (;;) {
				old_to_new_syms[cur] = q - new_syms;
				*q++ = p[cur];
				*chain++ = hash[cur] & ~1;
				bloom[(hash[cur] ELFCLASS_BITS) % bloom_size] |=
					(addr_t)1 << (hash[cur] % ELFCLASS_BITS) |
					(addr_t)1 << ((hash[cur] >> bloom_shift) % ELFCLASS_BITS);
				if (cur == buck[i].last)
					break;
				cur = nextbuck[cur];
			}
			chain[-1] |= 1;
		}
	}

	memcpy(dynsym->data, new_syms, nb_syms * sizeof(ElfW(Sym)));
	tcc_free(new_syms);
	tcc_free(hash);
	tcc_free(buck);
	tcc_free(nextbuck);

	update_relocs(s1, dynsym, old_to_new_syms, 0);

	/* modify the versions */

	vs = versym_section;
	if (vs) {
		ElfW(Half) *newver, *versym = (ElfW(Half) *)vs->data;

		if (1/*versym*/
		   ) {
			newver = tcc_malloc(nb_syms * sizeof(*newver));
			for (i = 0; i < nb_syms; i++)
				newver[old_to_new_syms[i]] = versym[i];
			memcpy(vs->data, newver, nb_syms * sizeof(*newver));
			tcc_free(newver);
		}
	}

	tcc_free(old_to_new_syms);

	/* rebuild hash */

	ptr = (Elf32_Word *) dynsym->hash->data;
	rebuild_hash(dynsym, ptr[0]);
}
#endif
/* ELF_OBJ_ONLY */
/* relocate symbol table, resolve undefined symbols if do_resolve is
   true and output error if undefined symbol. */
// 1062 "tccelf.c"
ST_FUNC void relocate_syms(TCCState *s1, Section *symtab, int do_resolve)
{
	ElfW(Sym) *sym;
	int sym_bind, sh_num;
	const char *name;

	for_each_elem(symtab, 1, sym, ElfW(Sym)) {
		sh_num = sym->st_shndx;
		if (sh_num == SHN_UNDEF) {
			if (do_resolve == 2)/* relocating dynsym */

				continue;
			name = (char *) s1->symtab->link->data + sym->st_name;
			/* Use ld.so to resolve symbol for us (for tcc -run) */

			if (do_resolve) {
				/* if dynamic symbol exist, it will be used in relocate_section */
// 1097 "tccelf.c"
			} else if (s1->dynsym && find_elf_sym(s1->dynsym, name))
				goto found;
			/* XXX: _fp_hw seems to be part of the ABI, so we ignore
			               it */

			if (!strcmp(name, "_fp_hw"))
				goto found;
			/* only weak symbols are accepted to be undefined. Their
			               value is zero */

			sym_bind = ELFW(ST_BIND)(sym->st_info);
			if (sym_bind == STB_WEAK)
				sym->st_value = 0;
			else
				tcc_error_noabort("undefined symbol '%s'", name);

		} else if (sh_num < SHN_LORESERVE) {
			/* add section base */

			sym->st_value += s1->sections[sym->st_shndx]->sh_addr;
		}
found: ;
	}
}
/* relocate a given section (CPU dependent) by applying the relocations
   in the associated relocation section */

static void relocate_section(TCCState *s1, Section *s, Section *sr)
{
	ElfW_Rel *rel;
	ElfW(Sym) *sym;
	int type, sym_index;
	unsigned char *ptr;
	addr_t tgt, addr;
	int is_dwarf = s->sh_num >= s1->dwlo && s->sh_num < s1->dwhi;

	qrel = (ElfW_Rel *)sr->data;
	for_each_elem(sr, 0, rel, ElfW_Rel) {
		ptr = s->data + rel->r_offset;
		sym_index = ELFW(R_SYM)(rel->r_info);
		sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];
		type = ELFW(R_TYPE)(rel->r_info);
		tgt = sym->st_value;
#if SHT_RELX == SHT_RELA

		tgt += rel->r_addend;
#endif

		if (is_dwarf && type == R_DATA_32DW
		    && sym->st_shndx >= s1->dwlo && sym->st_shndx < s1->dwhi) {
			/* dwarf section relocation to each other */

			add32le(ptr, tgt - s1->sections[sym->st_shndx]->sh_addr);
			continue;
		}
		addr = s->sh_addr + rel->r_offset;
		relocate(s1, rel, type, ptr, addr, tgt);
	}
#ifndef ELF_OBJ_ONLY

	/* if the relocation is allocated, we change its symbol table */

	if (sr->sh_flags & SHF_ALLOC) {
		sr->link = s1->dynsym;
		if (s1->output_type & TCC_OUTPUT_DYN) {
			size_t r = (uint8_t*)qrel - sr->data;
			if (sizeof ((Stab_Sym*)0)->n_value < PTR_SIZE
			    && 0 == strcmp(s->name, ".stab"))
				r = 0; /* cannot apply 64bit relocation to 32bit value */

			sr->data_offset = sr->sh_size = r;
#ifdef CONFIG_TCC_PIE
			if (r && (s->sh_flags & SHF_EXECINSTR))
				tcc_warning("%d relocations to %s", (unsigned)(r sizeof *qrel), s->name);
#endif
		}
	}
#endif
// 1166 "tccelf.c"
}
/* relocate all sections */

ST_FUNC void relocate_sections(TCCState *s1)
{
	int i;
	Section *s, *sr;

	for (i = 1; i < s1->nb_sections; ++i) {
		sr = s1->sections[i];
		if (sr->sh_type != SHT_RELX)
			continue;
		s = s1->sections[sr->sh_info];

		if (s != s1->got
		    || s1->static_link
		    || s1->output_type == TCC_OUTPUT_MEMORY)

		{
			relocate_section(s1, s, sr);
		}
#ifndef ELF_OBJ_ONLY

		if (sr->sh_flags & SHF_ALLOC) {
			ElfW_Rel *rel;
			/* relocate relocation table in 'sr' */

			for_each_elem(sr, 0, rel, ElfW_Rel)
			rel->r_offset += s->sh_addr;
		}
#endif
// 1195 "tccelf.c"
	}
}
#ifndef ELF_OBJ_ONLY

/* count the number of dynamic relocations so that we can reserve
   their space */

static int prepare_dynamic_rel(TCCState *s1, Section *sr)
{
	int count = 0;
	ElfW_Rel *rel;
	for_each_elem(sr, 0, rel, ElfW_Rel) {
		int sym_index = ELFW(R_SYM)(rel->r_info);
		int type = ELFW(R_TYPE)(rel->r_info);
		switch (type) {
		case R_X86_64_32:
		case R_X86_64_32S:
		case R_X86_64_64:
			count++;
			break;
		case R_X86_64_PC32: {
			ElfW(Sym) *sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];
			/* Hidden defined symbols can and must be resolved locally.
			   We're misusing a PLT32 reloc for this, as that's always
			   resolved to its address even in shared libs.  */

			if (sym->st_shndx != SHN_UNDEF &&
			    ELFW(ST_VISIBILITY)(sym->st_other) == STV_HIDDEN) {
				rel->r_info = ELFW(R_INFO)(sym_index, R_X86_64_PLT32);
				break;
			}
		}
		if (s1->output_type != TCC_OUTPUT_DLL)
			break;
		if (get_sym_attr(s1, sym_index, 0)->dyn_index)
			count++;
		break;
		default:
			break;
		}
	}
	return count;
}
#endif
#ifdef NEED_BUILD_GOT

static int build_got(TCCState *s1)
{
	/* if no got, then create it */

	s1->got = new_section(s1, ".got", SHT_PROGBITS, SHF_ALLOC | SHF_WRITE);
	s1->got->sh_entsize = 4;
	/* keep space for _DYNAMIC pointer and two dummy got entries */

	section_ptr_add(s1->got, 3 * PTR_SIZE);
	return set_elf_sym(symtab_section, 0, 0, ELFW(ST_INFO)(STB_GLOBAL, STT_OBJECT),
			   0, s1->got->sh_num, "_GLOBAL_OFFSET_TABLE_");
}

/* Create a GOT and (for function call) a PLT entry corresponding to a symbol
   in s1->symtab. When creating the dynamic symbol table entry for the GOT
   relocation, use 'size' and 'info' for the corresponding symbol metadata.
   Returns the offset of the GOT or (if any) PLT entry. */

static struct sym_attr *put_got_entry(TCCState *s1, int dyn_reloc_type,
				      int sym_index)
{
	int need_plt_entry;
	const char *name;
	ElfW(Sym) *sym;
	struct sym_attr *attr;
	unsigned got_offset;
	char plt_name[200];
	int len;
	Section *s_rel;

	need_plt_entry = (dyn_reloc_type == R_JMP_SLOT);
	attr = get_sym_attr(s1, sym_index, 1);

	/* In case a function is both called and its address taken 2 GOT entries
	   are created, one for taking the address (GOT) and the other for the PLT
	   entry (PLTGOT).  */

	if (need_plt_entry ? attr->plt_offset : attr->got_offset)
		return attr;

	s_rel = s1->got;
	if (need_plt_entry) {
		if (!s1->plt) {
			s1->plt = new_section(s1, ".plt", SHT_PROGBITS, SHF_ALLOC | SHF_EXECINSTR);
			s1->plt->sh_entsize = 4;
		}
		s_rel = s1->plt;
	}

	/* create the GOT entry */

	got_offset = s1->got->data_offset;
	section_ptr_add(s1->got, PTR_SIZE);

	/* Create the GOT relocation that will insert the address of the object or
	   function of interest in the GOT entry. This is a static relocation for
	   memory output (dlsym will give us the address of symbols) and dynamic
	   relocation otherwise (executable and DLLs). The relocation should be
	   done lazily for GOT entry with *_JUMP_SLOT relocation type (the one
	   associated to a PLT entry) but is currently done at load time for an
	   unknown reason. */

	sym = &((ElfW(Sym) *) symtab_section->data)[sym_index];
	name = (char *) symtab_section->link->data + sym->st_name;
	//printf("sym %d %s\n", need_plt_entry, name);

	if (s1->dynsym) {
		if (ELFW(ST_BIND)(sym->st_info) == STB_LOCAL) {
			/* Hack alarm.  We don't want to emit dynamic symbols
			   and symbol based relocs for STB_LOCAL symbols, but rather
			   want to resolve them directly.  At this point the symbol
			   values aren't final yet, so we must defer this.  We will later
			   have to create a RELATIVE reloc anyway, so we misuse the
			   relocation slot to smuggle the symbol reference until
			   fill_local_got_entries.  Not that the sym_index is
			   relative to symtab_section, not s1->dynsym!  Nevertheless
			   we use s1->dyn_sym so that if this is the first call
			   that got->reloc is correctly created.  Also note that
			   RELATIVE relocs are not normally created for the .got,
			   so the types serves as a marker for later (and is retained
			   also for the final output, which is okay because then the
			   got is just normal data).  */

			put_elf_reloc(s1->dynsym, s1->got, got_offset, R_RELATIVE,
				      sym_index);
		} else {
			if (0 == attr->dyn_index)
				attr->dyn_index = set_elf_sym(s1->dynsym, sym->st_value,
							      sym->st_size, sym->st_info, 0,
							      sym->st_shndx, name);
			put_elf_reloc(s1->dynsym, s_rel, got_offset, dyn_reloc_type,
				      attr->dyn_index);
		}
	} else {
		put_elf_reloc(symtab_section, s1->got, got_offset, dyn_reloc_type,
			      sym_index);
	}

	if (need_plt_entry) {
		attr->plt_offset = create_plt_entry(s1, got_offset, attr);

		/* create a symbol 'sym@plt' for the PLT jump vector */

		len = strlen(name);
		if (len > sizeof plt_name - 5)
			len = sizeof plt_name - 5;
		memcpy(plt_name, name, len);
		strcpy(plt_name + len, "@plt");
		attr->plt_sym = put_elf_sym(s1->symtab, attr->plt_offset, 0,
					    ELFW(ST_INFO)(STB_GLOBAL, STT_FUNC), 0, s1->plt->sh_num, plt_name);
	} else {
		attr->got_offset = got_offset;
	}

	return attr;
}

/* build GOT and PLT entries */

/* Two passes because R_JMP_SLOT should become first. Some targets
   (arm, arm64) do not allow mixing R_JMP_SLOT and R_GLOB_DAT. */

ST_FUNC void build_got_entries(TCCState *s1, int got_sym)
{
	Section *s;
	ElfW_Rel *rel;
	ElfW(Sym) *sym;
	int i, type, gotplt_entry, reloc_type, sym_index;
	struct sym_attr *attr;
	int pass = 0;
redo:
	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type != SHT_RELX)
			continue;
		/* no need to handle got relocations */

		if (s->link != symtab_section)
			continue;
		for_each_elem(s, 0, rel, ElfW_Rel) {
			type = ELFW(R_TYPE)(rel->r_info);
			gotplt_entry = gotplt_entry_type(type);
			if (gotplt_entry == -1) {
				tcc_error_noabort ("Unknown relocation type for got: %d", type);
				continue;
			}
			sym_index = ELFW(R_SYM)(rel->r_info);
			sym = &((ElfW(Sym) *)symtab_section->data)[sym_index];

			if (gotplt_entry == NO_GOTPLT_ENTRY) {
				continue;
			}

			/* Automatically create PLT/GOT [entry] if it is an undefined
			   reference (resolved at runtime), or the symbol is absolute,
			   probably created by tcc_add_symbol, and thus on 64-bit
			   targets might be too far from application code.  */

			if (gotplt_entry == AUTO_GOTPLT_ENTRY) {
				if (sym->st_shndx == SHN_UNDEF) {
					ElfW(Sym) *esym;
					int dynindex;
					if (!PCRELATIVE_DLLPLT
					    && (s1->output_type & TCC_OUTPUT_DYN))
						continue;
					/* Relocations for UNDEF symbols would normally need
					   to be transferred into the executable or shared object.
					   If that were done AUTO_GOTPLT_ENTRY wouldn't exist.
					   But TCC doesn't do that (at least for exes), so we
					   need to resolve all such relocs locally.  And that
					   means PLT slots for functions in DLLs and COPY relocs for
					   data symbols.  COPY relocs were generated in
					   bind_exe_dynsyms (and the symbol adjusted to be defined),
					   and for functions we were generated a dynamic symbol
					   of function type.  */

					if (s1->dynsym) {
						/* dynsym isn't set for -run :-/  */

						dynindex = get_sym_attr(s1, sym_index, 0)->dyn_index;
						esym = (ElfW(Sym) *)s1->dynsym->data + dynindex;
						if (dynindex
						    && (ELFW(ST_TYPE)(esym->st_info) == STT_FUNC
							|| (ELFW(ST_TYPE)(esym->st_info) == STT_NOTYPE
							    && ELFW(ST_TYPE)(sym->st_info) == STT_FUNC)))
							goto jmp_slot;
					}
				} else if (sym->st_shndx == SHN_ABS) {
					if (sym->st_value == 0) /* from tcc_add_btstub() */

						continue;
					if (PTR_SIZE != 8)
						continue;
					/* from tcc_add_symbol(): on 64 bit platforms these
					   need to go through .got */

				} else
					continue;
			}

			if ((type == R_X86_64_PLT32 || type == R_X86_64_PC32) &&
			    sym->st_shndx != SHN_UNDEF &&
			    (ELFW(ST_VISIBILITY)(sym->st_other) != STV_DEFAULT ||
			     ELFW(ST_BIND)(sym->st_info) == STB_LOCAL ||
			     s1->output_type & TCC_OUTPUT_EXE)) {
				if (pass != 0)
					continue;
				rel->r_info = ELFW(R_INFO)(sym_index, R_X86_64_PC32);
				continue;
			}
			reloc_type = code_reloc(type);
			if (reloc_type == -1) {
				tcc_error_noabort ("Unknown relocation type: %d", type);
				continue;
			}

			if (reloc_type != 0) {
jmp_slot:
				if (pass != 0)
					continue;
				reloc_type = R_JMP_SLOT;
			} else {
				if (pass != 1)
					continue;
				reloc_type = R_GLOB_DAT;
			}

			if (!s1->got)
				got_sym = build_got(s1);

			if (gotplt_entry == BUILD_GOT_ONLY)
				continue;

			attr = put_got_entry(s1, reloc_type, sym_index);

			if (reloc_type == R_JMP_SLOT)
				rel->r_info = ELFW(R_INFO)(attr->plt_sym, type);
		}
	}
	if (++pass < 2)
		goto redo;
	/* .rel.plt refers to .got actually */

	if (s1->plt && s1->plt->reloc)
		s1->plt->reloc->sh_info = s1->got->sh_num;
	if (got_sym) /* set size */

		((ElfW(Sym)*)symtab_section->data)[got_sym].st_size = s1->got->data_offset;
}
#endif
/* def NEED_BUILD_GOT */
// 1507 "tccelf.c"
ST_FUNC int set_global_sym(TCCState *s1, const char *name, Section *sec,
			   addr_t offs)
{
	int shn = sec ? sec->sh_num : offs || !name ? SHN_ABS : SHN_UNDEF;
	if (sec && offs == -1)
		offs = sec->data_offset;
	return set_elf_sym(symtab_section, offs, 0,
			   ELFW(ST_INFO)(name ? STB_GLOBAL : STB_LOCAL, STT_NOTYPE), 0, shn, name);
}

static void add_init_array_defines(TCCState *s1, const char *section_name)
{
	Section *s;
	addr_t end_offset;
	char buf[1024];
	s = have_section(s1, section_name);
	if (!s || !(s->sh_flags & SHF_ALLOC)) {
		end_offset = 0;
		s = text_section;
	} else {
		end_offset = s->data_offset;
	}
	snprintf(buf, sizeof(buf), "__%s_start", section_name + 1);
	set_global_sym(s1, buf, s, 0);
	snprintf(buf, sizeof(buf), "__%s_end", section_name + 1);
	set_global_sym(s1, buf, s, end_offset);
}

ST_FUNC void add_array (TCCState *s1, const char *sec, int c)
{
	Section *s;
	s = find_section(s1, sec);
	s->sh_flags = shf_RELRO;
	s->sh_type = sec[1] == 'i' ? SHT_INIT_ARRAY : SHT_FINI_ARRAY;
	put_elf_reloc (s1->symtab, s, s->data_offset, R_DATA_PTR, c);
	section_ptr_add(s, PTR_SIZE);
}
#ifdef CONFIG_TCC_BCHECK

ST_FUNC void tcc_add_bcheck(TCCState *s1)
{
	if (0 == s1->do_bounds_check)
		return;
	section_ptr_add(bounds_section, sizeof(addr_t));
}
#endif
/* set symbol to STB_LOCAL and resolve. The point is to not export it as
   a dynamic symbol to allow so's to have one each with a different value. */
// 1555 "tccelf.c"
static void set_local_sym(TCCState *s1, const char *name, Section *s,
			  int offset)
{
	int c = find_elf_sym(s1->symtab, name);
	if (c) {
		ElfW(Sym) *esym = (ElfW(Sym)*)s1->symtab->data + c;
		esym->st_info = ELFW(ST_INFO)(STB_LOCAL, STT_NOTYPE);
		esym->st_value = offset;
		esym->st_shndx = s->sh_num;
	}
}
/* avoid generating debug/test_coverage code for stub functions */

static void tcc_compile_string_no_debug(TCCState *s, const char *str)
{
	int save_do_debug = s->do_debug;
	int save_test_coverage = s->test_coverage;

	s->do_debug = 0;
	s->test_coverage = 0;
	tcc_compile_string(s, str);
	s->do_debug = save_do_debug;
	s->test_coverage = save_test_coverage;
}
#ifdef CONFIG_TCC_BACKTRACE

static void put_ptr(TCCState *s1, Section *s, int offs)
{
	int c;
	c = set_global_sym(s1, NULL, s, offs);
	s = data_section;
	put_elf_reloc (s1->symtab, s, s->data_offset, R_DATA_PTR, c);
	section_ptr_add(s, PTR_SIZE);
}

ST_FUNC void tcc_add_btstub(TCCState *s1)
{
	Section *s;
	int n, o, *p;
	CString cstr;
	const char *__rt_info = &"___rt_info"[!s1->leading_underscore];

	s = data_section;
	/* Align to PTR_SIZE */

	section_ptr_add(s, -s->data_offset & (PTR_SIZE - 1));
	o = s->data_offset;
	/* create a struct rt_context (see tccrun.c) */

	if (s1->dwarf) {
		put_ptr(s1, dwarf_line_section, 0);
		put_ptr(s1, dwarf_line_section, -1);
		if (s1->dwarf >= 5)
			put_ptr(s1, dwarf_line_str_section, 0);
		else
			put_ptr(s1, dwarf_str_section, 0);
	} else {
		put_ptr(s1, stab_section, 0);
		put_ptr(s1, stab_section, -1);
		put_ptr(s1, stab_section->link, 0);
	}
	/* skip esym_start/esym_end/elf_str (not loaded) */

	section_ptr_add(s, 3 * PTR_SIZE);

	if (s1->output_type == TCC_OUTPUT_MEMORY && 0 == s1->dwarf) {
		put_ptr(s1, text_section, 0);
	} else {
		/* prog_base : local nameless symbol with offset 0 at SHN_ABS */

		put_ptr(s1, NULL, 0);

	}
	n = 3 * PTR_SIZE;
#ifdef CONFIG_TCC_BCHECK

	if (s1->do_bounds_check) {
		put_ptr(s1, bounds_section, 0);
		n -= PTR_SIZE;
	}
#endif

	section_ptr_add(s, n);
	p = section_ptr_add(s, 2 * sizeof (int));
	p[0] = s1->rt_num_callers;
	p[1] = s1->dwarf;
// if (s->data_offset - o != 10*PTR_SIZE + 2*sizeof (int)) exit(99);

	if (s1->output_type == TCC_OUTPUT_MEMORY) {
		set_global_sym(s1, __rt_info, s, o);
		return;
	}

	cstr_new(&cstr);
	cstr_printf(&cstr,
		    "extern void __bt_init(),__bt_exit(),__bt_init_dll();"
		    "static void *__rt_info[];"
		    "__attribute__((constructor)) static void __bt_init_rt(){");

	if (s1->output_type == TCC_OUTPUT_DLL)
#ifdef CONFIG_TCC_BCHECK

		cstr_printf(&cstr, "__bt_init_dll(%d);", s1->do_bounds_check);
#else

		cstr_printf(&cstr, "__bt_init_dll(0);");
#endif

	cstr_printf(&cstr, "__bt_init(__rt_info,%d);}",
		    s1->output_type != TCC_OUTPUT_DLL);
	/* In case dlcose is called by application */

	cstr_printf(&cstr,
		    "__attribute__((destructor)) static void __bt_exit_rt(){"
		    "__bt_exit(__rt_info);}");
	tcc_compile_string_no_debug(s1, cstr.data);
	cstr_free(&cstr);
	set_local_sym(s1, __rt_info, s, o);
}
#endif
/* def CONFIG_TCC_BACKTRACE */

static void tcc_tcov_add_file(TCCState *s1, const char *filename)
{
	CString cstr;
	void *ptr;
	char wd[1024];

	if (tcov_section == NULL)
		return;
	section_ptr_add(tcov_section, 1);
	write32le (tcov_section->data, tcov_section->data_offset);

	cstr_new (&cstr);
	if (filename[0] == '/')
		cstr_printf (&cstr, "%s.tcov", filename);
	else {
		getcwd (wd, sizeof(wd));
		cstr_printf (&cstr, "%s/%s.tcov", wd, filename);
	}
	ptr = section_ptr_add(tcov_section, cstr.size + 1);
	strcpy((char *)ptr, cstr.data);
	unlink((char *)ptr);

	normalize_slashes((char *)ptr);

	cstr_free (&cstr);

	cstr_new(&cstr);
	cstr_printf(&cstr,
		    "extern char *__tcov_data[];"
		    "extern void __store_test_coverage ();"
		    "__attribute__((destructor)) static void __tcov_exit() {"
		    "__store_test_coverage(__tcov_data);"
		    "}");
	tcc_compile_string_no_debug(s1, cstr.data);
	cstr_free(&cstr);
	set_local_sym(s1, &"___tcov_data"[!s1->leading_underscore], tcov_section, 0);
}
/* TCC_TARGET_UNIX */
/* ndef TCC_TARGET_PE */
/* add various standard linker symbols (must be done after the
   sections are filled (for example after allocating common
   symbols)) */
// 1834 "tccelf.c"
static void tcc_add_linker_symbols(TCCState *s1)
{
	char buf[1024];
	int i;
	Section *s;

	set_global_sym(s1, "_etext", text_section, -1);
	set_global_sym(s1, "_edata", data_section, -1);
	set_global_sym(s1, "_end", bss_section, -1);
	/* horrible new standard ldscript defines */
// 1851 "tccelf.c"
	add_init_array_defines(s1, ".preinit_array");
	add_init_array_defines(s1, ".init_array");
	add_init_array_defines(s1, ".fini_array");
	/* add start and stop symbols for sections whose name can be
	       expressed in C */

	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if ((s->sh_flags & SHF_ALLOC)
		    && (s->sh_type == SHT_PROGBITS || s->sh_type == SHT_NOBITS
			|| s->sh_type == SHT_STRTAB)) {
			/* check if section name can be expressed in C */

			const char *p0, *p;
			p0 = s->name;
			if (*p0 == '.')
				++p0;
			p = p0;
			for (;;) {
				int c = *p;
				if (!c)
					break;
				if (!isid(c) && !isnum(c))
					goto next_sec;
				p++;
			}
			snprintf(buf, sizeof(buf), "__start_%s", p0);
			set_global_sym(s1, buf, s, 0);
			snprintf(buf, sizeof(buf), "__stop_%s", p0);
			set_global_sym(s1, buf, s, -1);
		}
next_sec: ;
	}
}

ST_FUNC void resolve_common_syms(TCCState *s1)
{
	ElfW(Sym) *sym;
	/* Allocate common symbols in BSS.  */

	for_each_elem(symtab_section, 1, sym, ElfW(Sym)) {
		if (sym->st_shndx == SHN_COMMON) {
			/* symbol alignment is in st_value for SHN_COMMONs */

			sym->st_value = section_add(bss_section, sym->st_size,
						    sym->st_value);
			sym->st_shndx = bss_section->sh_num;
		}
	}
	/* Now assign linker provided symbols their value.  */

	tcc_add_linker_symbols(s1);
}
#ifndef ELF_OBJ_ONLY

ST_FUNC void fill_got_entry(TCCState *s1, ElfW_Rel *rel)
{
	int sym_index = ELFW(R_SYM) (rel->r_info);
	ElfW(Sym) *sym = &((ElfW(Sym) *) symtab_section->data)[sym_index];
	struct sym_attr *attr = get_sym_attr(s1, sym_index, 0);
	unsigned offset = attr->got_offset;

	if (0 == offset)
		return;
	section_reserve(s1->got, offset + PTR_SIZE);
#if PTR_SIZE == 8
	write64le(s1->got->data + offset, sym->st_value);
#else
	write32le(s1->got->data + offset, sym->st_value);
#endif
}

/* Perform relocation to GOT or PLT entries */

ST_FUNC void fill_got(TCCState *s1)
{
	Section *s;
	ElfW_Rel *rel;
	int i;

	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type != SHT_RELX)
			continue;
		/* no need to handle got relocations */

		if (s->link != symtab_section)
			continue;
		for_each_elem(s, 0, rel, ElfW_Rel) {
			switch (ELFW(R_TYPE) (rel->r_info)) {
			case R_X86_64_GOT32:
			case R_X86_64_GOTPCREL:
			case R_X86_64_GOTPCRELX:
			case R_X86_64_REX_GOTPCRELX:
			case R_X86_64_PLT32:
				fill_got_entry(s1, rel);
				break;
			}
		}
	}
}

/* See put_got_entry for a description.  This is the second stage
   where GOT references to local defined symbols are rewritten.  */

static void fill_local_got_entries(TCCState *s1)
{
	ElfW_Rel *rel;
	if (!s1->got->reloc)
		return;
	for_each_elem(s1->got->reloc, 0, rel, ElfW_Rel) {
		if (ELFW(R_TYPE)(rel->r_info) == R_RELATIVE) {
			int sym_index = ELFW(R_SYM) (rel->r_info);
			ElfW(Sym) *sym = &((ElfW(Sym) *) symtab_section->data)[sym_index];
			struct sym_attr *attr = get_sym_attr(s1, sym_index, 0);
			unsigned offset = attr->got_offset;
			if (offset != rel->r_offset - s1->got->sh_addr)
				tcc_error_noabort("fill_local_got_entries: huh?");
			rel->r_info = ELFW(R_INFO)(0, R_RELATIVE);
#if SHT_RELX == SHT_RELA
			rel->r_addend = sym->st_value;
#else
			/* All our REL architectures also happen to be 32bit LE.  */

			write32le(s1->got->data + offset, sym->st_value);
#endif
		}
	}
}

/* Bind symbols of executable: resolve undefined symbols from exported symbols
   in shared libraries */

static void bind_exe_dynsyms(TCCState *s1, int is_PIE)
{
	const char *name;
	int sym_index, index;
	ElfW(Sym) *sym, *esym;
	int type;

	/* Resolve undefined symbols from dynamic symbols. When there is a match:
	   - if STT_FUNC or STT_GNU_IFUNC symbol -> add it in PLT
	   - if STT_OBJECT symbol -> add it in .bss section with suitable reloc */

	for_each_elem(symtab_section, 1, sym, ElfW(Sym)) {
		if (sym->st_shndx == SHN_UNDEF) {
			name = (char *) symtab_section->link->data + sym->st_name;
			sym_index = find_elf_sym(s1->dynsymtab_section, name);
			if (sym_index) {
				if (is_PIE)
					continue;
				esym = &((ElfW(Sym) *)s1->dynsymtab_section->data)[sym_index];
				type = ELFW(ST_TYPE)(esym->st_info);
				if ((type == STT_FUNC) || (type == STT_GNU_IFUNC)) {
					/* Indirect functions shall have STT_FUNC type in executable
					 * dynsym section. Indeed, a dlsym call following a lazy
					 * resolution would pick the symbol value from the
					 * executable dynsym entry which would contain the address
					 * of the function wanted by the caller of dlsym instead of
					 * the address \of the function that would return that
					 * address */

					int dynindex
						= put_elf_sym(s1->dynsym, 0, esym->st_size,
							      ELFW(ST_INFO)(STB_GLOBAL,STT_FUNC), 0, 0,
							      name);
					int index = sym - (ElfW(Sym) *) symtab_section->data;
					get_sym_attr(s1, index, 1)->dyn_index = dynindex;
				} else if (type == STT_OBJECT) {
					unsigned long offset;
					ElfW(Sym) *dynsym;
					offset = bss_section->data_offset;
					/* XXX: which alignment ? */

					offset = (offset + 16 - 1) & -16;
					set_elf_sym (s1->symtab, offset, esym->st_size,
						     esym->st_info, 0, bss_section->sh_num, name);
					index = put_elf_sym(s1->dynsym, offset, esym->st_size,
							    esym->st_info, 0, bss_section->sh_num,
							    name);

					/* Ensure R_COPY works for weak symbol aliases */

					if (ELFW(ST_BIND)(esym->st_info) == STB_WEAK) {
						for_each_elem(s1->dynsymtab_section, 1, dynsym, ElfW(Sym)) {
							if ((dynsym->st_value == esym->st_value)
							    && (ELFW(ST_BIND)(dynsym->st_info) == STB_GLOBAL)) {
								char *dynname = (char *) s1->dynsymtab_section->link->data
										+ dynsym->st_name;
								put_elf_sym(s1->dynsym, offset, dynsym->st_size,
									    dynsym->st_info, 0,
									    bss_section->sh_num, dynname);
								break;
							}
						}
					}

					put_elf_reloc(s1->dynsym, bss_section,
						      offset, R_COPY, index);
					offset += esym->st_size;
					bss_section->data_offset = offset;
				}
			} else {
				/* STB_WEAK undefined symbols are accepted */

				/* XXX: _fp_hw seems to be part of the ABI, so we ignore it */

				if (ELFW(ST_BIND)(sym->st_info) == STB_WEAK ||
				    !strcmp(name, "_fp_hw")) {
				} else {
					tcc_error_noabort("undefined symbol '%s'", name);
				}
			}
		}
	}
}

/* Bind symbols of libraries: export all non local symbols of executable that
   are referenced by shared libraries. The reason is that the dynamic loader
   search symbol first in executable and then in libraries. Therefore a
   reference to a symbol already defined by a library can still be resolved by
   a symbol in the executable.   With -rdynamic, export all defined symbols */

static void bind_libs_dynsyms(TCCState *s1)
{
	const char *name;
	int dynsym_index;
	ElfW(Sym) *sym, *esym;

	for_each_elem(symtab_section, 1, sym, ElfW(Sym)) {
		name = (char *)symtab_section->link->data + sym->st_name;
		dynsym_index = find_elf_sym(s1->dynsymtab_section, name);
		if (sym->st_shndx != SHN_UNDEF) {
			if (ELFW(ST_BIND)(sym->st_info) != STB_LOCAL
			    && (dynsym_index || s1->rdynamic))
				set_elf_sym(s1->dynsym, sym->st_value, sym->st_size,
					    sym->st_info, 0, sym->st_shndx, name);
		} else if (dynsym_index) {
			esym = (ElfW(Sym) *)s1->dynsymtab_section->data + dynsym_index;
			if (esym->st_shndx == SHN_UNDEF) {
				/* weak symbols can stay undefined */

				if (ELFW(ST_BIND)(esym->st_info) != STB_WEAK)
					tcc_warning("undefined dynamic symbol '%s'", name);
			}
		}
	}
}

/* Export all non local symbols. This is used by shared libraries so that the
   non local symbols they define can resolve a reference in another shared
   library or in the executable. Correspondingly, it allows undefined local
   symbols to be resolved by other shared libraries or by the executable. */

static void export_global_syms(TCCState *s1)
{
	int dynindex, index;
	const char *name;
	ElfW(Sym) *sym;
	for_each_elem(symtab_section, 1, sym, ElfW(Sym)) {
		if (ELFW(ST_BIND)(sym->st_info) != STB_LOCAL) {
			name = (char *) symtab_section->link->data + sym->st_name;
			dynindex = set_elf_sym(s1->dynsym, sym->st_value, sym->st_size,
					       sym->st_info, 0, sym->st_shndx, name);
			index = sym - (ElfW(Sym) *) symtab_section->data;
			get_sym_attr(s1, index, 1)->dyn_index = dynindex;
		}
	}
}

/* decide if an unallocated section should be output. */

static int set_sec_sizes(TCCState *s1)
{
	int i;
	Section *s;
	int textrel = 0;
	int file_type = s1->output_type;

	/* Allocate strings for section names */

	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type == SHT_RELX && !(s->sh_flags & SHF_ALLOC)) {
			/* when generating a DLL, we include relocations but
			   we may patch them */

			if ((file_type & TCC_OUTPUT_DYN)
			    && (s1->sections[s->sh_info]->sh_flags & SHF_ALLOC)) {
				int count = prepare_dynamic_rel(s1, s);
				if (count) {
					/* allocate the section */

					s->sh_flags |= SHF_ALLOC;
					s->sh_size = count * sizeof(ElfW_Rel);
					if (s1->sections[s->sh_info]->sh_flags & SHF_EXECINSTR)
						textrel += count;
				}
			}
		} else if ((s->sh_flags & SHF_ALLOC)
			   || s1->do_debug) {
			s->sh_size = s->data_offset;
		}
	}
	return textrel;
}

/* various data used under elf_output_file() */

struct dyn_inf {
	Section *dynamic;
	Section *dynstr;
	struct {
		/* Info to be copied in dynamic section */

		unsigned long data_offset;
		addr_t rel_addr;
		addr_t rel_size;
	};

	ElfW(Phdr) *phdr;
	int phnum;
	int shnum;
	Section *interp;
	Section *note;
	Section *gnu_hash;

	/* read only segment mapping for GNU_RELRO */

	Section _roinf, *roinf;
};

/* Decide the layout of sections loaded in memory. This must be done before
   program headers are filled since they contain info about the layout.
   We do the following ordering: interp, symbol tables, relocations, progbits,
   nobits */

static int sort_sections(TCCState *s1, int *sec_order, struct dyn_inf *d)
{
	Section *s;
	int i, j, k, f, f0, n;
	int nb_sections = s1->nb_sections;
	int *sec_cls = sec_order + nb_sections;

	for (i = 1; i < nb_sections; i++) {
		s = s1->sections[i];
		if (0 == s->sh_name) {
			j = 0x900; /* no sh_name: won't go to file */

		} else if (s->sh_flags & SHF_ALLOC) {
			j = 0x100;
			if (s->sh_flags & SHF_WRITE)
				j = 0x200;
			if (s->sh_flags & SHF_TLS)
				j += 0x200;
		} else {
			j = 0x700;
		}
		if (j >= 0x700 && s1->output_format != TCC_OUTPUT_FORMAT_ELF)
			s->sh_size = 0, j = 0x900;

		if (s->sh_type == SHT_SYMTAB || s->sh_type == SHT_DYNSYM) {
			k = 0x10;
		} else if (s->sh_type == SHT_STRTAB && strcmp(s->name, ".stabstr")) {
			k = 0x11;
			if (i == nb_sections - 1) /* ".shstrtab" assumed to stay last */

				k = 0xff;
		} else if (s->sh_type == SHT_HASH || s->sh_type == SHT_GNU_HASH) {
			k = 0x12;
		} else if (s->sh_type == SHT_GNU_verdef
			   || s->sh_type == SHT_GNU_verneed
			   || s->sh_type == SHT_GNU_versym) {
			k = 0x13;
		} else if (s->sh_type == SHT_RELX) {
			k = 0x20;
			if (s1->plt && s == s1->plt->reloc)
				k = 0x21;
		} else if (s->sh_flags & SHF_EXECINSTR) {
			k = 0x30;
			/* RELRO sections --> */

		} else if (s->sh_type == SHT_PREINIT_ARRAY) {
			k = 0x41;
		} else if (s->sh_type == SHT_INIT_ARRAY) {
			k = 0x42;
		} else if (s->sh_type == SHT_FINI_ARRAY) {
			k = 0x43;
		} else if (s->sh_type == SHT_DYNAMIC) {
			k = 0x46;
		} else if (s == s1->got) {
			k = 0x47; /* .got as RELRO needs BIND_NOW in DT_FLAGS */

		} else if (s->reloc && (s->reloc->sh_flags & SHF_ALLOC) && j == 0x100) {
			k = 0x44;
			/* <-- */

		} else if (s->sh_type == SHT_NOTE) {
			k = 0x60;
		} else if (s->sh_type == SHT_NOBITS) {
			k = 0x70; /* bss */

		} else if (s == d->interp) {
			k = 0x00;
		} else {
			k = 0x50; /* data */

		}
		k += j;

		if ((k & 0xfff0) == 0x140) {
			/* make RELRO section writable */

			k += 0x100, s->sh_flags |= SHF_WRITE;
		}
		for (n = i; n > 1 && k < (f = sec_cls[n - 1]); --n)
			sec_cls[n] = f, sec_order[n] = sec_order[n - 1];
		sec_cls[n] = k, sec_order[n] = i;
	}
	sec_order[0] = 0;
	d->shnum = 1;

	/* count PT_LOAD headers needed */

	n = f0 = 0;
	for (i = 1; i < nb_sections; i++) {
		s = s1->sections[sec_order[i]];
		k = sec_cls[i];
		f = 0;
		if (k < 0x900)
			++d->shnum;
		if (k < 0x700) {
			f = s->sh_flags & (SHF_ALLOC|SHF_WRITE|SHF_EXECINSTR|SHF_TLS);
			if ((k & 0xfff0) == 0x240) /* RELRO sections */

				f |= 1<<4;
			/* start new header when flags changed or relro, but avoid zero memsz */

			if (f != f0 && s->sh_size)
				f0 = f, ++n, f |= 1<<8;
		}
		sec_cls[i] = f;
		//printf("ph %d sec %02d : %3X %3X  %8.2X  %04X  %s\n", (f>0) * n, i, f, k, s->sh_type, (int)s->sh_size, s->name);

	}
	return n;
}

static ElfW(Phdr) *fill_phdr(ElfW(Phdr) *ph, int type, Section *s)
{
	if (s) {
		ph->p_offset = s->sh_offset;
		ph->p_vaddr = s->sh_addr;
		ph->p_filesz = s->sh_size;
		ph->p_align = s->sh_addralign;
	}
	ph->p_type = type;
	ph->p_flags = PF_R;
	ph->p_paddr = ph->p_vaddr;
	ph->p_memsz = ph->p_filesz;
	return ph;
}

/* Assign sections to segments and decide how are sections laid out when loaded
   in memory. This function also fills corresponding program headers. */

static int layout_sections(TCCState *s1, int *sec_order, struct dyn_inf *d)
{
	Section *s;
	addr_t addr, tmp, align, s_align, base;
	ElfW(Phdr) *ph = NULL;
	int i, f, n, phnum, phfill;
	int file_offset;

	/* compute number of program headers */

	phnum = sort_sections(s1, sec_order, d);
	phfill = 0; /* set to 1 to have dll's with a PT_PHDR */

	if (d->interp)
		phfill = 2;
	phnum += phfill;
	if (d->note)
		++phnum;
	if (d->dynamic)
		++phnum;
	if (eh_frame_hdr_section)
		++phnum;
	if (d->roinf)
		++phnum;
	d->phnum = phnum;
	d->phdr = tcc_mallocz(phnum * sizeof(ElfW(Phdr)));

	file_offset = 0;
	if (s1->output_format == TCC_OUTPUT_FORMAT_ELF) {
		file_offset = (sizeof(ElfW(Ehdr)) + phnum * sizeof(ElfW(Phdr)) + 3) & -4;
		file_offset += d->shnum * sizeof (ElfW(Shdr));
	}

	s_align = ELF_PAGE_SIZE;
	if (s1->section_align)
		s_align = s1->section_align;

	addr = ELF_START_ADDR;
	if (s1->output_type & TCC_OUTPUT_DYN)
		addr = 0;

	if (s1->has_text_addr) {
		addr = s1->text_addr;
		if (0) {
			int a_offset, p_offset;
			/* we ensure that (addr % ELF_PAGE_SIZE) == file_offset %
			   ELF_PAGE_SIZE */

			a_offset = (int) (addr & (s_align - 1));
			p_offset = file_offset & (s_align - 1);
			if (a_offset < p_offset)
				a_offset += s_align;
			file_offset += (a_offset - p_offset);
		}
	}
	base = addr;
	/* compute address after headers */

	addr += file_offset;

	n = 0;
	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[sec_order[i]];
		f = sec_order[i + s1->nb_sections];
		align = s->sh_addralign - 1;

		if (f == 0) { /* no alloc */

			file_offset = (file_offset + align) & ~align;
			s->sh_offset = file_offset;
			if (s->sh_type != SHT_NOBITS)
				file_offset += s->sh_size;
			continue;
		}

		if ((f & 1<<8) && n) {
			/* different rwx section flags */

			if (s1->output_format == TCC_OUTPUT_FORMAT_ELF) {
				/* if in the middle of a page, w e duplicate the page in
				   memory so that one copy is RX and the other is RW */

				if ((addr & (s_align - 1)) != 0)
					addr += s_align;
			} else {
				align = s_align - 1;
			}
		}

		tmp = addr;
		addr = (addr + align) & ~align;
		file_offset += (int)(addr - tmp);
		s->sh_offset = file_offset;
		s->sh_addr = addr;

		if (f & 1<<8) {
			/* set new program header */

			ph = &d->phdr[phfill + n];
			ph->p_type = PT_LOAD;
			ph->p_align = s_align;
			ph->p_flags = PF_R;
			if (f & SHF_WRITE)
				ph->p_flags |= PF_W;
			if (f & SHF_EXECINSTR)
				ph->p_flags |= PF_X;
			if (f & SHF_TLS) {
				ph->p_type = PT_TLS;
				ph->p_align = align + 1;
			}

			ph->p_offset = file_offset;
			ph->p_vaddr = addr;
			if (n == 0) {
				/* Make the first PT_LOAD segment include the program
				   headers itself (and the ELF header as well), it'll
				   come out with same memory use but will make various
				   tools like binutils strip work better.  */

				ph->p_offset = 0;
				ph->p_vaddr = base;
			}
			ph->p_paddr = ph->p_vaddr;
			++n;
		}

		if (f & 1<<4) {
			Section *roinf = &d->_roinf;
			if (roinf->sh_size == 0) {
				roinf->sh_offset = s->sh_offset;
				roinf->sh_addr = s->sh_addr;
				roinf->sh_addralign = 1;
			}
			roinf->sh_size = (addr - roinf->sh_addr) + s->sh_size;
		}

		addr += s->sh_size;
		if (s->sh_type != SHT_NOBITS)
			file_offset += s->sh_size;

		ph->p_filesz = file_offset - ph->p_offset;
		ph->p_memsz = addr - ph->p_vaddr;
	}

	/* Fill other headers */

	if (d->note)
		fill_phdr(++ph, PT_NOTE, d->note);
	if (d->dynamic)
		fill_phdr(++ph, PT_DYNAMIC, d->dynamic)->p_flags |= PF_W;
	if (eh_frame_hdr_section)
		fill_phdr(++ph, PT_GNU_EH_FRAME, eh_frame_hdr_section);
	if (d->roinf)
		fill_phdr(++ph, PT_GNU_RELRO, d->roinf)->p_flags |= PF_W;
	if (d->interp)
		fill_phdr(&d->phdr[1], PT_INTERP, d->interp);
	if (phfill) {
		ph = &d->phdr[0];
		ph->p_offset = sizeof(ElfW(Ehdr));
		ph->p_vaddr = base + ph->p_offset;
		ph->p_filesz = phnum * sizeof(ElfW(Phdr));
		ph->p_align = 4;
		fill_phdr(ph, PT_PHDR, NULL);
	}
	return 0;
}

/* put dynamic tag */

static void put_dt(Section *dynamic, int dt, addr_t val)
{
	ElfW(Dyn) *dyn;
	dyn = section_ptr_add(dynamic, sizeof(ElfW(Dyn)));
	dyn->d_tag = dt;
	dyn->d_un.d_val = val;
}

/* Fill the dynamic section with tags describing the address and size of
   sections */

static void fill_dynamic(TCCState *s1, struct dyn_inf *dyninf)
{
	Section *dynamic = dyninf->dynamic;
	Section *s;

	/* put dynamic section entries */

	put_dt(dynamic, DT_HASH, s1->dynsym->hash->sh_addr);
	put_dt(dynamic, DT_GNU_HASH, dyninf->gnu_hash->sh_addr);
	put_dt(dynamic, DT_STRTAB, dyninf->dynstr->sh_addr);
	put_dt(dynamic, DT_SYMTAB, s1->dynsym->sh_addr);
	put_dt(dynamic, DT_STRSZ, dyninf->dynstr->data_offset);
	put_dt(dynamic, DT_SYMENT, sizeof(ElfW(Sym)));
#if PTR_SIZE == 8
	put_dt(dynamic, DT_RELA, dyninf->rel_addr);
	put_dt(dynamic, DT_RELASZ, dyninf->rel_size);
	put_dt(dynamic, DT_RELAENT, sizeof(ElfW_Rel));
	if (s1->plt && s1->plt->reloc) {
		put_dt(dynamic, DT_PLTGOT, s1->got->sh_addr);
		put_dt(dynamic, DT_PLTRELSZ, s1->plt->reloc->data_offset);
		put_dt(dynamic, DT_JMPREL, s1->plt->reloc->sh_addr);
		put_dt(dynamic, DT_PLTREL, DT_RELA);
	}
	put_dt(dynamic, DT_RELACOUNT, 0);
#else
	put_dt(dynamic, DT_REL, dyninf->rel_addr);
	put_dt(dynamic, DT_RELSZ, dyninf->rel_size);
	put_dt(dynamic, DT_RELENT, sizeof(ElfW_Rel));
	if (s1->plt && s1->plt->reloc) {
		put_dt(dynamic, DT_PLTGOT, s1->got->sh_addr);
		put_dt(dynamic, DT_PLTRELSZ, s1->plt->reloc->data_offset);
		put_dt(dynamic, DT_JMPREL, s1->plt->reloc->sh_addr);
		put_dt(dynamic, DT_PLTREL, DT_REL);
	}
	put_dt(dynamic, DT_RELCOUNT, 0);
#endif
	if (versym_section && verneed_section) {
		/* The dynamic linker can not handle VERSYM without VERNEED */

		put_dt(dynamic, DT_VERSYM, versym_section->sh_addr);
		put_dt(dynamic, DT_VERNEED, verneed_section->sh_addr);
		put_dt(dynamic, DT_VERNEEDNUM, dt_verneednum);
	}
	s = have_section(s1, ".preinit_array");
	if (s && s->data_offset) {
		put_dt(dynamic, DT_PREINIT_ARRAY, s->sh_addr);
		put_dt(dynamic, DT_PREINIT_ARRAYSZ, s->data_offset);
	}
	s = have_section(s1, ".init_array");
	if (s && s->data_offset) {
		put_dt(dynamic, DT_INIT_ARRAY, s->sh_addr);
		put_dt(dynamic, DT_INIT_ARRAYSZ, s->data_offset);
	}
	s = have_section(s1, ".fini_array");
	if (s && s->data_offset) {
		put_dt(dynamic, DT_FINI_ARRAY, s->sh_addr);
		put_dt(dynamic, DT_FINI_ARRAYSZ, s->data_offset);
	}
	s = have_section(s1, ".init");
	if (s && s->data_offset) {
		put_dt(dynamic, DT_INIT, s->sh_addr);
	}
	s = have_section(s1, ".fini");
	if (s && s->data_offset) {
		put_dt(dynamic, DT_FINI, s->sh_addr);
	}
	if (s1->do_debug)
		put_dt(dynamic, DT_DEBUG, 0);
	put_dt(dynamic, DT_NULL, 0);
}

/* Remove gaps between RELX sections.
   These gaps are a result of final_sections_reloc. Here some relocs are removed.
   The gaps are then filled with 0 in tcc_output_elf. The 0 is intepreted as
   R_...NONE reloc. This does work on most targets but on OpenBSD/arm64 this
   is illegal. OpenBSD/arm64 does not support R_...NONE reloc. */

static void update_reloc_sections(TCCState *s1, struct dyn_inf *dyninf)
{
	int i;
	unsigned long file_offset = 0;
	Section *s;
	Section *relocplt = s1->plt ? s1->plt->reloc : NULL;

	/* dynamic relocation table information, for .dynamic section */

	dyninf->rel_addr = dyninf->rel_size = 0;

	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type == SHT_RELX && s != relocplt) {
			if (dyninf->rel_size == 0) {
				dyninf->rel_addr = s->sh_addr;
				file_offset = s->sh_offset;
			} else {
				s->sh_addr = dyninf->rel_addr + dyninf->rel_size;
				s->sh_offset = file_offset + dyninf->rel_size;
			}
			dyninf->rel_size += s->sh_size;
		}
	}
}
#endif
/* ndef ELF_OBJ_ONLY */
/* Create an ELF file on disk.
   This function handle ELF specific layout requirements */
// 2560 "tccelf.c"
static int tcc_output_elf(TCCState *s1, FILE *f, int phnum, ElfW(Phdr) *phdr)
{
	int i, shnum, offset, size, file_type;
	Section *s;
	ElfW(Ehdr) ehdr;
	ElfW(Shdr) shdr, *sh;

	file_type = s1->output_type;
	shnum = s1->nb_sections;

	memset(&ehdr, 0, sizeof(ehdr));
	if (phnum > 0) {
		ehdr.e_phentsize = sizeof(ElfW(Phdr));
		ehdr.e_phnum = phnum;
		ehdr.e_phoff = sizeof(ElfW(Ehdr));
	}
	/* fill header */

	ehdr.e_ident[0] = ELFMAG0;
	ehdr.e_ident[1] = ELFMAG1;
	ehdr.e_ident[2] = ELFMAG2;
	ehdr.e_ident[3] = ELFMAG3;
	ehdr.e_ident[4] = ELFCLASSW;
	ehdr.e_ident[5] = ELFDATA2LSB;
	ehdr.e_ident[6] = EV_CURRENT;
// 2599 "tccelf.c"
	if (file_type == TCC_OUTPUT_OBJ) {
		ehdr.e_type = ET_REL;
	} else {
		if (file_type & TCC_OUTPUT_DYN)
			ehdr.e_type = ET_DYN;
		else
			ehdr.e_type = ET_EXEC;
		if (s1->elf_entryname)
			ehdr.e_entry = get_sym_addr(s1, s1->elf_entryname, 1, 0);
		else
			ehdr.e_entry = get_sym_addr(s1, "_start", !!(file_type & TCC_OUTPUT_EXE), 0);
		if (ehdr.e_entry == (addr_t)-1)
			ehdr.e_entry = text_section->sh_addr;
		if (s1->nb_errors)
			return -1;
	}

	sort_syms(s1, s1->symtab);

	ehdr.e_machine = EM_TCC_TARGET;
	ehdr.e_version = EV_CURRENT;
	ehdr.e_shoff = (sizeof(ElfW(Ehdr)) + phnum * sizeof(ElfW(Phdr)) + 3) & -4;
	ehdr.e_ehsize = sizeof(ElfW(Ehdr));
	ehdr.e_shentsize = sizeof(ElfW(Shdr));
	ehdr.e_shnum = shnum;
	ehdr.e_shstrndx = shnum - 1;

	offset = fwrite(&ehdr, 1, sizeof(ElfW(Ehdr)), f);
	if (phdr)
		offset += fwrite(phdr, 1, phnum * sizeof(ElfW(Phdr)), f);
	/* output section headers */

	while (offset < ehdr.e_shoff) {
		fputc(0, f);
		offset++;
	}

	for (i = 0; i < shnum; i++) {
		sh = &shdr;
		memset(sh, 0, sizeof(ElfW(Shdr)));
		if (i) {
			s = s1->sections[i];
			sh->sh_name = s->sh_name;
			sh->sh_type = s->sh_type;
			sh->sh_flags = s->sh_flags;
			sh->sh_entsize = s->sh_entsize;
			sh->sh_info = s->sh_info;
			if (s->link)
				sh->sh_link = s->link->sh_num;
			sh->sh_addralign = s->sh_addralign;
			sh->sh_addr = s->sh_addr;
			sh->sh_offset = s->sh_offset;
			sh->sh_size = s->sh_size;
		}
		offset += fwrite(sh, 1, sizeof(ElfW(Shdr)), f);
	}
	/* output sections */

	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type != SHT_NOBITS) {
			while (offset < s->sh_offset) {
				fputc(0, f);
				offset++;
			}
			size = s->sh_size;
			if (size)
				offset += fwrite(s->data, 1, size, f);
		}
	}
	return 0;
}

static int tcc_output_binary(TCCState *s1, FILE *f)
{
	Section *s;
	int i, offset, size;

	offset = 0;
	for (i=1; i<s1->nb_sections; i++) {
		s = s1->sections[i];
		if (s->sh_type != SHT_NOBITS &&
		    (s->sh_flags & SHF_ALLOC)) {
			while (offset < s->sh_offset) {
				fputc(0, f);
				offset++;
			}
			size = s->sh_size;
			fwrite(s->data, 1, size, f);
			offset += size;
		}
	}
	return 0;
}
/* Write an elf, coff or "binary" file */

static int tcc_write_elf_file(TCCState *s1, const char *filename, int phnum,
			      ElfW(Phdr) *phdr)
{
	int fd, mode, file_type, ret;
	FILE *f;

	file_type = s1->output_type;
	if (file_type == TCC_OUTPUT_OBJ)
		mode = 0666;
	else
		mode = 0777;
	unlink(filename);
	fd = open(filename, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, mode);
	if (fd < 0 || (f = fdopen(fd, "wb")) == NULL)
		return tcc_error_noabort("could not write '%s: %s'", filename, strerror(errno));
	if (s1->verbose)
		printf("<- %s\n", filename);

	if (s1->output_format == TCC_OUTPUT_FORMAT_ELF)
		ret = tcc_output_elf(s1, f, phnum, phdr);
	else
		ret = tcc_output_binary(s1, f);
	fclose(f);

	return ret;
}
#ifndef ELF_OBJ_ONLY

/* order sections according to sec_order, remove sections
   that we aren't going to output. \ */

static void reorder_sections(TCCState *s1, int *sec_order)
{
	int i, nnew, k, *backmap;
	Section **snew, *s;
	ElfW(Sym) *sym;

	backmap = tcc_malloc(s1->nb_sections * sizeof(backmap[0]));
	for (i = 0, nnew = 0, snew = NULL; i < s1->nb_sections; i++) {
		k = sec_order[i];
		s = s1->sections[k];
		if (!i || s->sh_name) {
			backmap[k] = nnew;
			dynarray_add(&snew, &nnew, s);
		} else {
			backmap[k] = 0;
			/* just remember to free them later */

			dynarray_add(&s1->priv_sections, &s1->nb_priv_sections, s);
		}
	}
	for (i = 1; i < nnew; i++) {
		s = snew[i];
		s->sh_num = i;
		if (s->sh_type == SHT_RELX)
			s->sh_info = backmap[s->sh_info];
		else if (s->sh_type == SHT_SYMTAB || s->sh_type == SHT_DYNSYM)
			for_each_elem(s, 1, sym, ElfW(Sym))
			if (sym->st_shndx < s1->nb_sections)
				sym->st_shndx = backmap[sym->st_shndx];
	}
	tcc_free(s1->sections);
	s1->sections = snew;
	s1->nb_sections = nnew;
	tcc_free(backmap);
}

static void alloc_sec_names(TCCState *s1, int is_obj);

/* Output an elf, coff or binary file */

/* XXX: suppress unneeded sections */

static int elf_output_file(TCCState *s1, const char *filename)
{
	int i, ret, file_type, *sec_order;
	struct dyn_inf dyninf = {0};
	Section *interp, *dynstr, *dynamic;
	int textrel, got_sym, dt_flags_1;

	file_type = s1->output_type;
	s1->nb_errors = 0;
	ret = -1;
	interp = dynstr = dynamic = NULL;
	sec_order = NULL;
	dyninf.roinf = &dyninf._roinf;

	/* if linking, also link in runtime libraries (libc, libgcc, etc.) */

	tcc_add_runtime(s1);
	resolve_common_syms(s1);

	if (!s1->static_link) {
		if (file_type & TCC_OUTPUT_EXE) {
			char *ptr;
			/* allow override the dynamic loader */

			const char *elfint = s1->elfint;
			if (elfint == NULL)
				elfint = getenv("LD_SO");
			if (elfint == NULL)
				elfint = DEFAULT_ELFINTERP(s1);
			/* add interpreter section only if executable */

			interp = new_section(s1, ".interp", SHT_PROGBITS, SHF_ALLOC);
			interp->sh_addralign = 1;
			ptr = section_ptr_add(interp, 1 + strlen(elfint));
			strcpy(ptr, elfint);
			dyninf.interp = interp;
		}

		/* add dynamic symbol table */

		s1->dynsym = new_symtab(s1, ".dynsym", SHT_DYNSYM, SHF_ALLOC,
					".dynstr",
					".hash", SHF_ALLOC);
		/* Number of local symbols (readelf complains if not set) */

		s1->dynsym->sh_info = 1;
		dynstr = s1->dynsym->link;
		/* add dynamic section */

		dynamic = new_section(s1, ".dynamic", SHT_DYNAMIC,
				      SHF_ALLOC | SHF_WRITE);
		dynamic->link = dynstr;
		dynamic->sh_entsize = sizeof(ElfW(Dyn));

		got_sym = build_got(s1);
		if (file_type & TCC_OUTPUT_EXE) {
			bind_exe_dynsyms(s1, file_type & TCC_OUTPUT_DYN);
			if (s1->nb_errors)
				goto the_end;
		}
		build_got_entries(s1, got_sym);
		if (file_type & TCC_OUTPUT_EXE) {
			bind_libs_dynsyms(s1);
		} else {
			/* shared library case: simply export all global symbols */

			export_global_syms(s1);
		}
#if TCC_EH_FRAME
		/* fill with initial data */

		tcc_eh_frame_hdr(s1, 0);
#endif
		dyninf.gnu_hash = create_gnu_hash(s1);
	} else {
		build_got_entries(s1, 0);
	}
	version_add (s1);

	textrel = set_sec_sizes(s1);

	if (!s1->static_link) {
		/* add a list of needed dlls */

		for (i = 0; i < s1->nb_loaded_dlls; i++) {
			DLLReference *dllref = s1->loaded_dlls[i];
			if (dllref->level == 0)
				put_dt(dynamic, DT_NEEDED, put_elf_str(dynstr, dllref->name));
		}

		if (s1->rpath)
			put_dt(dynamic, s1->enable_new_dtags ? DT_RUNPATH : DT_RPATH,
			       put_elf_str(dynstr, s1->rpath));

		dt_flags_1 = DF_1_NOW;
		if (file_type & TCC_OUTPUT_DYN) {
			if (s1->soname)
				put_dt(dynamic, DT_SONAME, put_elf_str(dynstr, s1->soname));
			/* XXX: currently, since we do not handle PIC code, we
			   must relocate the readonly segments */

			if (textrel)
				put_dt(dynamic, DT_TEXTREL, 0);
			if (file_type & TCC_OUTPUT_EXE)
				dt_flags_1 = DF_1_NOW | DF_1_PIE;
		}
		put_dt(dynamic, DT_FLAGS, DF_BIND_NOW);
		put_dt(dynamic, DT_FLAGS_1, dt_flags_1);
		if (s1->symbolic)
			put_dt(dynamic, DT_SYMBOLIC, 0);

		dyninf.dynamic = dynamic;
		dyninf.dynstr = dynstr;
		/* remember offset and reserve space for 2nd call below */

		dyninf.data_offset = dynamic->data_offset;
		fill_dynamic(s1, &dyninf);
		dynamic->sh_size = dynamic->data_offset;
		dynstr->sh_size = dynstr->data_offset;
	}

	/* create and fill .shstrtab section */

	alloc_sec_names(s1, 0);
	/* this array is used to reorder sections in the output file */

	sec_order = tcc_malloc(sizeof(int) * 2 * s1->nb_sections);
	/* compute section to program header mapping */

	layout_sections(s1, sec_order, &dyninf);

	if (dynamic) {
		/* put in GOT the dynamic section address and relocate PLT */

		write32le(s1->got->data, dynamic->sh_addr);
		if (file_type == TCC_OUTPUT_EXE
		    || (RELOCATE_DLLPLT && (file_type & TCC_OUTPUT_DYN)))
			relocate_plt(s1);
		/* relocate symbols in .dynsym now that final addresses are known */

		relocate_syms(s1, s1->dynsym, 2);
	}

	/* if building executable or DLL, then relocate each section
	   except the GOT which is already relocated */

	relocate_syms(s1, s1->symtab, 0);
	if (s1->nb_errors != 0)
		goto the_end;
	relocate_sections(s1);
	if (dynamic) {
		update_reloc_sections (s1, &dyninf);
		dynamic->data_offset = dyninf.data_offset;
		fill_dynamic(s1, &dyninf);
	}
	/* Perform relocation to GOT or PLT entries */

	if (file_type == TCC_OUTPUT_EXE && s1->static_link)
		fill_got(s1);
	else if (s1->got)
		fill_local_got_entries(s1);

	if (dyninf.gnu_hash)
		update_gnu_hash(s1, dyninf.gnu_hash);

	reorder_sections(s1, sec_order);
#if TCC_EH_FRAME
	/* fill with final data */

	tcc_eh_frame_hdr(s1, 1);
#endif
	/* Create the ELF file with name 'filename' */

	ret = tcc_write_elf_file(s1, filename, dyninf.phnum, dyninf.phdr);
the_end:
	tcc_free(sec_order);
	tcc_free(dyninf.phdr);
	return ret;
}
#endif
/* ndef ELF_OBJ_ONLY */
/* Allocate strings for section names */
// 3006 "tccelf.c"
static void alloc_sec_names(TCCState *s1, int is_obj)
{
	int i;
	Section *s, *strsec;

	strsec = new_section(s1, ".shstrtab", SHT_STRTAB, 0);
	put_elf_str(strsec, "");
	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		if (is_obj)
			s->sh_size = s->data_offset;
		if (s->sh_size || s == strsec || (s->sh_flags & SHF_ALLOC) || is_obj)
			s->sh_name = put_elf_str(strsec, s->name);
	}
	strsec->sh_size = strsec->data_offset;
}
/* Output an elf .o file */

static int elf_output_obj(TCCState *s1, const char *filename)
{
	Section *s;
	int i, ret, file_offset;
	s1->nb_errors = 0;
	/* Allocate strings for section names */

	alloc_sec_names(s1, 1);
	file_offset = (sizeof (ElfW(Ehdr)) + 3) & -4;
	file_offset += s1->nb_sections * sizeof(ElfW(Shdr));
	for (i = 1; i < s1->nb_sections; i++) {
		s = s1->sections[i];
		file_offset = (file_offset + 15) & -16;
		s->sh_offset = file_offset;
		if (s->sh_type != SHT_NOBITS)
			file_offset += s->sh_size;
	}
	/* Create the ELF file with name 'filename' */

	ret = tcc_write_elf_file(s1, filename, 0, NULL);
	return ret;
}

LIBTCCAPI int tcc_output_file(TCCState *s, const char *filename)
{
	if (s->test_coverage)
		tcc_tcov_add_file(s, filename);
	if (s->output_type == TCC_OUTPUT_OBJ)
		return elf_output_obj(s, filename);

	return pe_output_file(s, filename);

}

ST_FUNC ssize_t full_read(int fd, void *buf, size_t count)
{
	char *cbuf = buf;
	size_t rnum = 0;
	while (1) {
		ssize_t num = read(fd, cbuf, count-rnum);
		if (num < 0) return num;
		if (num == 0) return rnum;
		rnum += num;
		cbuf += num;
	}
}

ST_FUNC void *load_data(int fd, unsigned long file_offset, unsigned long size)
{
	void *data;

	data = tcc_malloc(size);
	lseek(fd, file_offset, SEEK_SET);
	full_read(fd, data, size);
	return data;
}

typedef struct SectionMergeInfo {
	Section *s;/* corresponding existing section */

	unsigned long offset;/* offset of the new section in the existing section */

	uint8_t new_section;/* true if section 's' was added */

	uint8_t link_once;/* true if link once section */

} SectionMergeInfo;

ST_FUNC int tcc_object_type(int fd, ElfW(Ehdr) *h)
{
	int size = full_read(fd, h, sizeof *h);
	if (size == sizeof *h && 0 == memcmp(h, ELFMAG, 4)) {
		if (h->e_type == ET_REL)
			return AFF_BINTYPE_REL;
		if (h->e_type == ET_DYN)
			return AFF_BINTYPE_DYN;
	} else if (size >= 8) {
		if (0 == memcmp(h, ARMAG, 8))
			return AFF_BINTYPE_AR;

	}
	return 0;
}
/* load an object file and merge it with current files */
/* XXX: handle correctly stab (debug) info */

ST_FUNC int tcc_load_object_file(TCCState *s1,
				 int fd, unsigned long file_offset)
{
	ElfW(Ehdr) ehdr;
	ElfW(Shdr) *shdr, *sh;
	unsigned long size, offset, offseti;
	int i, j, nb_syms, sym_index, ret, seencompressed;
	char *strsec, *strtab;
	int stab_index, stabstr_index;
	int *old_to_new_syms;
	char *sh_name, *name;
	SectionMergeInfo *sm_table, *sm;
	ElfW(Sym) *sym, *symtab;
	ElfW_Rel *rel;
	Section *s;

	lseek(fd, file_offset, SEEK_SET);
	if (tcc_object_type(fd, &ehdr) != AFF_BINTYPE_REL)
		goto invalid;
	/* test CPU specific stuff */

	if (ehdr.e_ident[5] != ELFDATA2LSB ||
	    ehdr.e_machine != EM_TCC_TARGET) {
invalid:
		return tcc_error_noabort("invalid object file");
	}
	/* read sections */

	shdr = load_data(fd, file_offset + ehdr.e_shoff,
			 sizeof(ElfW(Shdr)) * ehdr.e_shnum);
	sm_table = tcc_mallocz(sizeof(SectionMergeInfo) * ehdr.e_shnum);
	/* load section names */

	sh = &shdr[ehdr.e_shstrndx];
	strsec = load_data(fd, file_offset + sh->sh_offset, sh->sh_size);
	/* load symtab and strtab */

	old_to_new_syms = NULL;
	symtab = NULL;
	strtab = NULL;
	nb_syms = 0;
	seencompressed = 0;
	stab_index = stabstr_index = 0;
	ret = -1;

	for (i = 1; i < ehdr.e_shnum; i++) {
		sh = &shdr[i];
		if (sh->sh_type == SHT_SYMTAB) {
			if (symtab) {
				tcc_error_noabort("object must contain only one symtab");
				goto the_end;
			}
			nb_syms = sh->sh_size / sizeof(ElfW(Sym));
			symtab = load_data(fd, file_offset + sh->sh_offset, sh->sh_size);
			sm_table[i].s = symtab_section;
			/* now load strtab */

			sh = &shdr[sh->sh_link];
			strtab = load_data(fd, file_offset + sh->sh_offset, sh->sh_size);
		}
		if (sh->sh_flags & SHF_COMPRESSED)
			seencompressed = 1;
	}
	/* now examine each section and try to merge its content with the
	       ones in memory */

	for (i = 1; i < ehdr.e_shnum; i++) {
		/* no need to examine section name strtab */

		if (i == ehdr.e_shstrndx)
			continue;
		sh = &shdr[i];
		if (sh->sh_type == SHT_RELX)
			sh = &shdr[sh->sh_info];
		/* ignore sections types we do not handle (plus relocs to those) */

		sh_name = strsec + sh->sh_name;
		if (0 == strncmp(sh_name, ".debug_", 7)
		    || 0 == strncmp(sh_name, ".stab", 5)) {
			if (!s1->do_debug || seencompressed)
				continue;

		} else if (0 == strncmp(sh_name, ".eh_frame", 9)) {
			if (NULL == eh_frame_section)
				continue;

		} else if (sh->sh_type != SHT_PROGBITS &&
			   sh->sh_type != SHT_NOTE &&
			   sh->sh_type != SHT_NOBITS &&
			   sh->sh_type != SHT_PREINIT_ARRAY &&
			   sh->sh_type != SHT_INIT_ARRAY &&
			   sh->sh_type != SHT_FINI_ARRAY
// 3210 "tccelf.c"
			  )
			continue;

		sh = &shdr[i];
		sh_name = strsec + sh->sh_name;
		if (sh->sh_addralign < 1)
			sh->sh_addralign = 1;
		/* find corresponding section, if any */

		for (j = 1; j < s1->nb_sections; j++) {
			s = s1->sections[j];
			if (strcmp(s->name, sh_name))
				continue;
			if (sh->sh_type != s->sh_type
			    && strcmp (s->name, ".eh_frame")
			   ) {
				tcc_error_noabort("section type conflict: %s %02x <> %02x", s->name,
						  sh->sh_type, s->sh_type);
				goto the_end;
			}
			if (!strncmp(sh_name, ".gnu.linkonce", 13)) {
				/* if a 'linkonce' section is already present, we
				                   do not add it again. It is a little tricky as
				                   symbols can still be defined in
				                   it. */

				sm_table[i].link_once = 1;
				goto next;
			}
			if (stab_section) {
				if (s == stab_section)
					stab_index = i;
				if (s == stab_section->link)
					stabstr_index = i;
			}
			goto found;
		}
		/* not found: create new section */

		s = new_section(s1, sh_name, sh->sh_type, sh->sh_flags & ~SHF_GROUP);
		/* take as much info as possible from the section. sh_link and
		           sh_info will be updated later */

		s->sh_addralign = sh->sh_addralign;
		s->sh_entsize = sh->sh_entsize;
		sm_table[i].new_section = 1;
found:
		/* align start of section */

		s->data_offset += -s->data_offset & (sh->sh_addralign - 1);
		if (sh->sh_addralign > s->sh_addralign)
			s->sh_addralign = sh->sh_addralign;
		sm_table[i].offset = s->data_offset;
		sm_table[i].s = s;
		/* concatenate sections */

		size = sh->sh_size;
		if (sh->sh_type != SHT_NOBITS) {
			unsigned char *ptr;
			lseek(fd, file_offset + sh->sh_offset, SEEK_SET);
			ptr = section_ptr_add(s, size);
			full_read(fd, ptr, size);
		} else {
			s->data_offset += size;
		}

next: ;
	}
	/* gr relocate stab strings */

	if (stab_index && stabstr_index) {
		Stab_Sym *a, *b;
		unsigned o;
		s = sm_table[stab_index].s;
		a = (Stab_Sym *)(s->data + sm_table[stab_index].offset);
		b = (Stab_Sym *)(s->data + s->data_offset);
		o = sm_table[stabstr_index].offset;
		while (a < b) {
			if (a->n_strx)
				a->n_strx += o;
			a++;
		}
	}
	/* second short pass to update sh_link and sh_info fields of new
	       sections */

	for (i = 1; i < ehdr.e_shnum; i++) {
		s = sm_table[i].s;
		if (!s || !sm_table[i].new_section)
			continue;
		sh = &shdr[i];
		if (sh->sh_link > 0)
			s->link = sm_table[sh->sh_link].s;
		if (sh->sh_type == SHT_RELX) {
			s->sh_info = sm_table[sh->sh_info].s->sh_num;
			/* update backward link */

			s1->sections[s->sh_info]->reloc = s;
		}
	}
	/* resolve symbols */

	old_to_new_syms = tcc_mallocz(nb_syms * sizeof(int));

	sym = symtab + 1;
	for (i = 1; i < nb_syms; i++, sym++) {
		if (sym->st_shndx != SHN_UNDEF &&
		    sym->st_shndx < SHN_LORESERVE) {
			sm = &sm_table[sym->st_shndx];
			if (sm->link_once) {
				/* if a symbol is in a link once section, we use the
				                   already defined symbol. It is very important to get
				                   correct relocations */

				if (ELFW(ST_BIND)(sym->st_info) != STB_LOCAL) {
					name = strtab + sym->st_name;
					sym_index = find_elf_sym(symtab_section, name);
					if (sym_index)
						old_to_new_syms[i] = sym_index;
				}
				continue;
			}
			/* if no corresponding section added, no need to add symbol */

			if (!sm->s)
				continue;
			/* convert section number */

			sym->st_shndx = sm->s->sh_num;
			/* offset value */

			sym->st_value += sm->offset;
		}
		/* add symbol */

		name = strtab + sym->st_name;
		sym_index = set_elf_sym(symtab_section, sym->st_value, sym->st_size,
					sym->st_info, sym->st_other,
					sym->st_shndx, name);
		old_to_new_syms[i] = sym_index;
	}
	/* third pass to patch relocation entries */

	for (i = 1; i < ehdr.e_shnum; i++) {
		s = sm_table[i].s;
		if (!s)
			continue;
		sh = &shdr[i];
		offset = sm_table[i].offset;
		size = sh->sh_size;
		switch (s->sh_type) {
		case SHT_RELX:
			/* take relocation offset information */

			offseti = sm_table[sh->sh_info].offset;
			for (rel = (ElfW_Rel *) s->data + (offset / sizeof(*rel));
			     rel < (ElfW_Rel *) s->data + ((offset + size) / sizeof(*rel));
			     rel++) {
				int type;
				unsigned sym_index;
				/* convert symbol index */

				type = ELFW(R_TYPE)(rel->r_info);
				sym_index = ELFW(R_SYM)(rel->r_info);
				/* NOTE: only one symtab assumed */

				if (sym_index >= nb_syms)
					goto invalid_reloc;
				sym_index = old_to_new_syms[sym_index];
				/* ignore link_once in rel section. */

				if (!sym_index && !sm_table[sh->sh_info].link_once

				   ) {
invalid_reloc:
					tcc_error_noabort("Invalid relocation entry [%2d] '%s' @ %.8x",
							  i, strsec + sh->sh_name, (int)rel->r_offset);
					goto the_end;
				}
				rel->r_info = ELFW(R_INFO)(sym_index, type);
				/* offset the relocation offset */

				rel->r_offset += offseti;
// 3397 "tccelf.c"
			}
			break;
		default:
			break;
		}
	}

	ret = 0;
the_end:
	tcc_free(symtab);
	tcc_free(strtab);
	tcc_free(old_to_new_syms);
	tcc_free(sm_table);
	tcc_free(strsec);
	tcc_free(shdr);
	return ret;
}

typedef struct ArchiveHeader {
	char ar_name[16];/* name of this member */

	char ar_date[12];/* file mtime */

	char ar_uid[6];/* owner uid; printed as decimal */

	char ar_gid[6];/* owner gid; printed as decimal */

	char ar_mode[8];/* file mode, printed as octal   */

	char ar_size[10];/* file size, printed as decimal */

	char ar_fmag[2];/* should contain ARFMAG */

} ArchiveHeader;

#define ARFMAG "`\n"

static unsigned long long get_be(const uint8_t *b, int n)
{
	unsigned long long ret = 0;
	while (n)
		ret = (ret << 8) | *b++, --n;
	return ret;
}

static int read_ar_header(int fd, int offset, ArchiveHeader *hdr)
{
	char *p, *e;
	int len;
	lseek(fd, offset, SEEK_SET);
	len = full_read(fd, hdr, sizeof(ArchiveHeader));
	if (len != sizeof(ArchiveHeader))
		return len ? -1 : 0;
	if (memcmp(hdr->ar_fmag, ARFMAG, sizeof hdr->ar_fmag))
		return -1;
	p = hdr->ar_name;
	for (e = p + sizeof hdr->ar_name; e > p && e[-1] == ' ';)
		--e;
	*e = '\0';
	hdr->ar_size[sizeof hdr->ar_size-1] = 0;
	return len;
}
/* load only the objects which resolve undefined symbols */

static int tcc_load_alacarte(TCCState *s1, int fd, int size, int entrysize)
{
	int i, bound, nsyms, sym_index, len, ret = -1;
	unsigned long long off;
	uint8_t *data;
	const char *ar_names, *p;
	const uint8_t *ar_index;
	ElfW(Sym) *sym;
	ArchiveHeader hdr;

	data = tcc_malloc(size);
	if (full_read(fd, data, size) != size)
		goto invalid;
	nsyms = get_be(data, entrysize);
	ar_index = data + entrysize;
	ar_names = (char *) ar_index + nsyms * entrysize;

	do {
		bound = 0;
		for (p = ar_names, i = 0; i < nsyms; i++, p += strlen(p)+1) {
			Section *s = symtab_section;
			sym_index = find_elf_sym(s, p);
			if (!sym_index)
				continue;
			sym = &((ElfW(Sym) *)s->data)[sym_index];
			if (sym->st_shndx != SHN_UNDEF)
				continue;
			off = get_be(ar_index + i * entrysize, entrysize);
			len = read_ar_header(fd, off, &hdr);
			if (len <= 0 || memcmp(hdr.ar_fmag, ARFMAG, 2)) {
invalid:
				tcc_error_noabort("invalid archive");
				goto the_end;
			}
			off += len;
			if (s1->verbose == 2)
				printf("   -> %s\n", hdr.ar_name);
			if (tcc_load_object_file(s1, fd, off) < 0)
				goto the_end;
			++bound;
		}
	} while (bound);
	ret = 0;
the_end:
	tcc_free(data);
	return ret;
}
/* load a '.a' file */

ST_FUNC int tcc_load_archive(TCCState *s1, int fd, int alacarte)
{
	ArchiveHeader hdr;
	/* char magic[8]; */

	int size, len;
	unsigned long file_offset;
	ElfW(Ehdr) ehdr;
	/* skip magic which was already checked */
	/* full_read(fd, magic, sizeof(magic)); */

	file_offset = sizeof ARMAG - 1;

	for (;;) {
		len = read_ar_header(fd, file_offset, &hdr);
		if (len == 0)
			return 0;
		if (len < 0)
			return tcc_error_noabort("invalid archive");
		file_offset += len;
		size = strtol(hdr.ar_size, NULL, 0);
		if (alacarte) {
			/* coff symbol table : we handle it */

			if (!strcmp(hdr.ar_name, "/"))
				return tcc_load_alacarte(s1, fd, size, 4);
			if (!strcmp(hdr.ar_name, "/SYM64/"))
				return tcc_load_alacarte(s1, fd, size, 8);
		} else if (tcc_object_type(fd, &ehdr) == AFF_BINTYPE_REL) {
			if (s1->verbose == 2)
				printf("   -> %s\n", hdr.ar_name);
			if (tcc_load_object_file(s1, fd, file_offset) < 0)
				return -1;
		}
		/* align to even */

		file_offset = (file_offset + size + 1) & ~1;
	}
}
#ifndef ELF_OBJ_ONLY

/* Set LV[I] to the global index of sym-version (LIB,VERSION).  Maybe resizes
   LV, maybe create a new entry for (LIB,VERSION).  */

static void set_ver_to_ver(TCCState *s1, int *n, int **lv, int i, char *lib,
			   char *version)
{
	while (i >= *n) {
		*lv = tcc_realloc(*lv, (*n + 1) * sizeof(**lv));
		(*lv)[(*n)++] = -1;
	}
	if ((*lv)[i] == -1) {
		int v, prev_same_lib = -1;
		for (v = 0; v < nb_sym_versions; v++) {
			if (strcmp(sym_versions[v].lib, lib))
				continue;
			prev_same_lib = v;
			if (!strcmp(sym_versions[v].version, version))
				break;
		}
		if (v == nb_sym_versions) {
			sym_versions = tcc_realloc (sym_versions,
						    (v + 1) * sizeof(*sym_versions));
			sym_versions[v].lib = tcc_strdup(lib);
			sym_versions[v].version = tcc_strdup(version);
			sym_versions[v].out_index = 0;
			sym_versions[v].prev_same_lib = prev_same_lib;
			nb_sym_versions++;
		}
		(*lv)[i] = v;
	}
}

/* Associates symbol SYM_INDEX (in dynsymtab) with sym-version index
   VERNDX.  */

static void
set_sym_version(TCCState *s1, int sym_index, int verndx)
{
	if (sym_index >= nb_sym_to_version) {
		int newelems = sym_index ? sym_index * 2 : 1;
		sym_to_version = tcc_realloc(sym_to_version,
					     newelems * sizeof(*sym_to_version));
		memset(sym_to_version + nb_sym_to_version, -1,
		       (newelems - nb_sym_to_version) * sizeof(*sym_to_version));
		nb_sym_to_version = newelems;
	}
	if (sym_to_version[sym_index] < 0)
		sym_to_version[sym_index] = verndx;
}

struct versym_info {
	int nb_versyms;
	ElfW(Verdef) *verdef;
	ElfW(Verneed) *verneed;
	ElfW(Half) *versym;
	int nb_local_ver, *local_ver;
};

static void store_version(TCCState *s1, struct versym_info *v, char *dynstr)
{
	char *lib, *version;
	uint32_t next;
	int i;

#define	DEBUG_VERSION 0

	if (v->versym && v->verdef) {
		ElfW(Verdef) *vdef = v->verdef;
		lib = NULL;
		do {
			ElfW(Verdaux) *verdaux =
				(ElfW(Verdaux) *) (((char *) vdef) + vdef->vd_aux);

#if DEBUG_VERSION
			printf ("verdef: version:%u flags:%u index:%u, hash:%u\n",
				vdef->vd_version, vdef->vd_flags, vdef->vd_ndx,
				vdef->vd_hash);
#endif
			if (vdef->vd_cnt) {
				version = dynstr + verdaux->vda_name;

				if (lib == NULL)
					lib = version;
				else
					set_ver_to_ver(s1, &v->nb_local_ver, &v->local_ver, vdef->vd_ndx,
						       lib, version);
#if DEBUG_VERSION
				printf ("  verdaux(%u): %s\n", vdef->vd_ndx, version);
#endif
			}
			next = vdef->vd_next;
			vdef = (ElfW(Verdef) *) (((char *) vdef) + next);
		} while (next);
	}
	if (v->versym && v->verneed) {
		ElfW(Verneed) *vneed = v->verneed;
		do {
			ElfW(Vernaux) *vernaux =
				(ElfW(Vernaux) *) (((char *) vneed) + vneed->vn_aux);

			lib = dynstr + vneed->vn_file;
#if DEBUG_VERSION
			printf ("verneed: %u %s\n", vneed->vn_version, lib);
#endif
			for (i = 0; i < vneed->vn_cnt; i++) {
				if ((vernaux->vna_other & 0x8000) == 0) { /* hidden */

					version = dynstr + vernaux->vna_name;
					set_ver_to_ver(s1, &v->nb_local_ver, &v->local_ver, vernaux->vna_other,
						       lib, version);
#if DEBUG_VERSION
					printf ("  vernaux(%u): %u %u %s\n",
						vernaux->vna_other, vernaux->vna_hash,
						vernaux->vna_flags, version);
#endif
				}
				vernaux = (ElfW(Vernaux) *) (((char *) vernaux) + vernaux->vna_next);
			}
			next = vneed->vn_next;
			vneed = (ElfW(Verneed) *) (((char *) vneed) + next);
		} while (next);
	}

#if DEBUG_VERSION
	for (i = 0; i < v->nb_local_ver; i++) {
		if (v->local_ver[i] > 0) {
			printf ("%d: lib: %s, version %s\n",
				i, sym_versions[v->local_ver[i]].lib,
				sym_versions[v->local_ver[i]].version);
		}
	}
#endif
}

/* load a library / DLL
   'level = 0' means that the DLL is referenced by the user
   (so it should be added as DT_NEEDED in the generated ELF file) */

ST_FUNC int tcc_load_dll(TCCState *s1, int fd, const char *filename, int level)
{
	ElfW(Ehdr) ehdr;
	ElfW(Shdr) *shdr, *sh, *sh1;
	int i, nb_syms, nb_dts, sym_bind, ret = -1;
	ElfW(Sym) *sym, *dynsym;
	ElfW(Dyn) *dt, *dynamic;

	char *dynstr;
	int sym_index;
	const char *name, *soname;
	struct versym_info v;

	full_read(fd, &ehdr, sizeof(ehdr));

	/* test CPU specific stuff */

	if (ehdr.e_ident[5] != ELFDATA2LSB ||
	    ehdr.e_machine != EM_TCC_TARGET) {
		return tcc_error_noabort("bad architecture");
	}

	/* read sections */

	shdr = load_data(fd, ehdr.e_shoff, sizeof(ElfW(Shdr)) * ehdr.e_shnum);

	/* load dynamic section a\nd dynamic symbols */

	nb_syms = 0;
	nb_dts = 0;
	dynamic = NULL;
	dynsym = NULL; /* avoid warning */

	dynstr = NULL; /* avoid warning */

	memset(&v, 0, sizeof v);

	for (i = 0, sh = shdr; i < ehdr.e_shnum; i++, sh++) {
		switch (sh->sh_type) {
		case SHT_DYNAMIC:
			nb_dts = sh->sh_size sizeof(ElfW(Dyn));
			dynamic = load_data(fd, sh->sh_offset, sh->sh_size);
			break;
		case SHT_DYNSYM:
			nb_syms = sh->sh_size sizeof(ElfW(Sym));
			dynsym = load_data(fd, sh->sh_offset, sh->sh_size);
			sh1 = &shdr[sh->sh_link];
			dynstr = load_data(fd, sh1->sh_offset, sh1->sh_size);
			break;
		case SHT_GNU_verdef:
			v.verdef = load_data(fd, sh->sh_offset, sh->sh_size);
			break;
		case SHT_GNU_verneed:
			v.verneed = load_data(fd, sh->sh_offset, sh->sh_size);
			break;
		case SHT_GNU_versym:
			v.nb_versyms = sh->sh_size sizeof(ElfW(Half));
			v.versym = load_data(fd, sh->sh_offset, sh->sh_size);
			break;
		default:
			break;
		}
	}

	if (!dynamic)
		goto the_end;

	/* compute the real library name */

	soname = tcc_basename(filename);
	for (i = 0, dt = dynamic; i < nb_dts; i++, dt++)
		if (dt->d_tag == DT_SONAME)
			soname = dynstr + dt->d_un.d_val;

	/* if the dll is already loaded, do not load it */

	if (tcc_add_dllref(s1, soname, level)->found)
		goto ret_success;

	if (v.nb_versyms != nb_syms)
		tcc_free (v.versym), v.versym = NULL;
	else
		store_version(s1, &v, dynstr);

	/* add dynamic symbols in dynsym_section */

	for (i = 1, sym = dynsym + 1; i < nb_syms; i++, sym++) {
		sym_bind = ELFW(ST_BIND)(sym->st_info);
		if (sym_bind == STB_LOCAL)
			continue;
		name = dynstr + sym->st_name;
		sym_index = set_elf_sym(s1->dynsymtab_section, sym->st_value, sym->st_size,
					sym->st_info, sym->st_other, sym->st_shndx, name);
		if (v.versym) {
			ElfW(Half) vsym = v.versym[i];
			if ((vsym & 0x8000) == 0 && vsym > 0 && vsym < v.nb_local_ver)
				set_sym_version(s1, sym_index, v.local_ver[vsym]);
		}
	}

	/* do not load all referenced libraries
	   (recursive loading can break linking of libraries) */

	/* following DT_NEEDED is needed for the dynamic loader (libdl.so),
	   but it is no longer needed, when linking a library or a program.
	   When tcc output mode is OUTPUT_MEM,
	   tcc calls dlopen, which handles DT_NEEDED for us */

ret_success:
	ret = 0;
the_end:
	tcc_free(dynstr);
	tcc_free(dynsym);
	tcc_free(dynamic);
	tcc_free(shdr);
	tcc_free(v.local_ver);
	tcc_free(v.verdef);
	tcc_free(v.verneed);
	tcc_free(v.versym);
	return ret;
}

#define LD_TOK_NAME 256
#define LD_TOK_EOF  (-1)
static int ld_inp(TCCState *s1)
{
	int c = *s1->ld_p;
	if (c == 0)
		return CH_EOF;
	++s1->ld_p;
	return c;
}
#define ld_unget(s1, ch) if (ch != CH_EOF) --s1->ld_p

/* return next ld script token */

static int ld_next(TCCState *s1, char *name, int name_size)
{
	int c, d, ch;
	char *q;

redo:
	ch = ld_inp(s1);
	q = name, *q++ = ch;
	switch (ch) {
	case ' ':
	case '\t':
	case '\f':
	case '\v':
	case '\r':
	case '\n':
		goto redo;
	case '/':
		ch = ld_inp(s1);
		if (ch == '*') { /* comment */

			for (d = 0;; d = ch) {
				ch = ld_inp(s1);
				if (ch == CH_EOF || (ch == '/' && d == '*'))
					break;
			}
			goto redo;
		} else {
			goto parse_name;
		}
		break;
	case '\\':
	/* case 'a' ... 'z': */

	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	/* case 'A' ... 'z': */

	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '-':
	case '_':
	case '.':
	case '$':
	case '~':
		for (;;) {
			ch = ld_inp(s1);
parse_name:
			if (!((ch >= 'a' && ch <= 'z') ||
			      (ch >= 'A' && ch <= 'Z') ||
			      (ch >= '0' && ch <= '9') ||
			      strchr("/.-_+=$:\\,~", ch)))
				break;
			if ((q - name) < name_size - 1) {
				*q++ = ch;
			}
		}
		ld_unget(s1, ch);
		c = LD_TOK_NAME;
		break;
	case CH_EOF:
		c = LD_TOK_EOF;
		break;
	default:
		c = ch;
		break;
	}
	*q = '\0';
	return c;
}

static int ld_add_file(TCCState *s1, const char filename[])
{
	if (filename[0] == '-' && filename[1] == 'l')
		return tcc_add_library(s1, filename + 2);
	if (CONFIG_SYSROOT[0] != '\0') {
		/* lookup via library paths */

		int ret = tcc_add_dll(s1, tcc_basename(filename), 0);
		if (ret != FILE_NOT_FOUND)
			return ret;
	}
	return tcc_add_file_internal(s1, filename, AFF_PRINT_ERROR);
}

/* did static libraries add new undefined symbols? */

static int new_undef_sym(TCCState *s1, int sym_offset)
{
	while (sym_offset < s1->symtab->data_offset) {
		ElfW(Sym) *esym = (void*)(s1->symtab->data + sym_offset);
		if (esym->st_shndx == SHN_UNDEF)
			return 1;
		sym_offset += sizeof (ElfW(Sym));
	}
	return 0;
}

static int ld_add_file_list(TCCState *s1, const char *cmd)
{
	char filename[1024];
	int t, c, sym_offset, ret = 0;
	unsigned char *pos = s1->ld_p;

repeat:
	s1->ld_p = pos;
	sym_offset = s1->symtab->data_offset;
	c = cmd[0];

	t = ld_next(s1, filename, sizeof(filename));
	if (t != '(')
		return tcc_error_noabort("expected '(' after %s", cmd);
	t = ld_next(s1, filename, sizeof(filename));
	for (;;) {
		if (t == LD_TOK_EOF) {
			return tcc_error_noabort("unexpected end of file");
		} else if (t == ')') {
			break;
		} else if (t != LD_TOK_NAME) {
			return tcc_error_noabort("unexpected token '%c'", t);
		} else if (!strcmp(filename, "AS_NEEDED")) {
			ret = ld_add_file_list(s1, filename);
		} else if (c == 'I' || c == 'G' || c == 'A') {
			ret = ld_add_file(s1, filename);
		}
		if (ret)
			return -1;
		t = ld_next(s1, filename, sizeof(filename));
		if (t == ',')
			t = ld_next(s1, filename, sizeof(filename));
	}
	if (c == 'G' && new_undef_sym(s1, sym_offset))
		goto repeat;
	return 0;
}

/* interpret a subset of GNU ldscripts to handle the dummy libc.so
   files */

ST_FUNC int tcc_load_ldscript(TCCState *s1, int fd)
{
	char cmd[64];
	int t, ret = FILE_NOT_RECOGNIZED;
	unsigned char *text_ptr, *saved_ptr;

	saved_ptr = s1->ld_p;
	s1->ld_p = text_ptr = (void*)tcc_load_text(fd);
	for (;;) {
		t = ld_next(s1, cmd, sizeof(cmd));
		if (t == LD_TOK_EOF)
			break;
		if (!strcmp(cmd, "INPUT") ||
		    !strcmp(cmd, "GROUP")) {
			ret = ld_add_file_list(s1, cmd);
		} else if (!strcmp(cmd, "OUTPUT_FORMAT") ||
			   !strcmp(cmd, "TARGET")) {
			/* ignore some commands */

			ret = ld_add_file_list(s1, cmd);
		} else if (0 == ret) {
			ret = tcc_error_noabort("unexpected '%s'", cmd);
		}
		if (ret)
			break;
	}
	tcc_free(text_ptr);
	s1->ld_p = saved_ptr;
	return ret;
}
#endif
/* !ELF_OBJ_ONLY */
// 31 "libtcc.c" 2
// 1 "tccrun.c" 1
// 21 "tccrun.c"
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 22 "tccrun.c" 2
/* only native compiler supports -run */
#ifdef CONFIG_TCC_BACKTRACE
/* runtime debug info block */

typedef struct rt_context {
	/* tccelf.c:tcc_add_btstub() wants these in that order: */

	union {
		struct {
			Stab_Sym *stab_sym;
			Stab_Sym *stab_sym_end;
			char *stab_str;
		};
		struct {
			unsigned char *dwarf_line;
			unsigned char *dwarf_line_end;
			unsigned char *dwarf_line_str;
		};
	};
	ElfW(Sym) *esym_start;
	ElfW(Sym) *esym_end;
	char *elf_str;
// 6 * PTR_SIZE

	addr_t prog_base;
	void *bounds_start;
	void *top_func;
	struct rt_context *next;
// 10 * PTR_SIZE

	int num_callers;
	int dwarf;
} rt_context;
/* linked list of rt_contexts */

static rt_context *g_rc;
static int signal_set;
static void set_exception_handler(void);
#endif
/* def CONFIG_TCC_BACKTRACE */

typedef struct rt_frame {
	addr_t ip, fp, sp;
} rt_frame;

static TCCState *g_s1;
/* semaphore to protect it */

TCC_SEM(static rt_sem);
static void rt_wait_sem(void)
{
	WAIT_SEM(&rt_sem);
}
static void rt_post_sem(void)
{
	POST_SEM(&rt_sem);
}
static int rt_get_caller_pc(addr_t *paddr, rt_frame *f, int level);
static void rt_exit(rt_frame *f, int code);
/* ------------------------------------------------------------- */
/* defined when included from lib/bt-exe.c */
#ifndef CONFIG_TCC_BACKTRACE_ONLY
// 82 "tccrun.c"
static int protect_pages(void *ptr, unsigned long length, int mode);
static int tcc_relocate_ex(TCCState *s1, void *ptr, unsigned ptr_diff);
static void st_link(TCCState *s1);
static void st_unlink(TCCState *s1);
#ifdef CONFIG_TCC_BACKTRACE

static int _tcc_backtrace(rt_frame *f, const char *fmt, va_list ap);
#endif

static void *win64_add_function_table(TCCState *s1);
static void win64_del_function_table(void *);
#if !defined PAGESIZE
#if defined _SC_PAGESIZE
#define PAGESIZE sysconf(_SC_PAGESIZE)
#else

#define PAGESIZE 4096
#endif
#endif

#define PAGEALIGN(n) ((addr_t)n + (-(addr_t)n & (PAGESIZE-1)))

static int rt_mem(TCCState *s1, int size)
{
	void *ptr;
	int ptr_diff = 0;
// 133 "tccrun.c"
	ptr = tcc_malloc(size += PAGESIZE);/* one extra page to align malloc memory */

	s1->run_ptr = ptr;
	s1->run_size = size;
	return ptr_diff;
}
/* ------------------------------------------------------------- */
/* Do all relocations (needed before using tcc_get_symbol())
   Returns -1 on error. */

LIBTCCAPI int tcc_relocate(TCCState *s1)
{
	int size, ret, ptr_diff;

	if (s1->run_ptr)
		exit(tcc_error_noabort("'tcc_relocate()' twice is no longer supported"));
#ifdef CONFIG_TCC_BACKTRACE

	if (s1->do_backtrace)
		tcc_add_symbol(s1, "_tcc_backtrace", _tcc_backtrace);/* for bt-log.c */

#endif

	size = tcc_relocate_ex(s1, NULL, 0);
	if (size < 0)
		return -1;
	ptr_diff = rt_mem(s1, size);
	if (ptr_diff < 0)
		return -1;
	ret = tcc_relocate_ex(s1, s1->run_ptr, ptr_diff);
	if (ret == 0)
		st_link(s1);
	return ret;
}

ST_FUNC void tcc_run_free(TCCState *s1)
{
	unsigned size;
	void *ptr;
	int i;
	/* free any loaded DLLs */

	for ( i = 0; i < s1->nb_loaded_dlls; i++) {
		DLLReference *ref = s1->loaded_dlls[i];
		if ( ref->handle )

			FreeLibrary((HMODULE)ref->handle);

	}
	/* unmap or unprotect and free memory */

	ptr = s1->run_ptr;
	if (NULL == ptr)
		return;
	st_unlink(s1);
	size = s1->run_size;
	/* unprotect memory to make it usable for malloc again */

	protect_pages((void*)PAGEALIGN(ptr), size - PAGESIZE, 2/*rw*/
		     );

	win64_del_function_table(s1->run_function_table);

	tcc_free(ptr);

}
/* passed from longjmp instead of '0' */

#define RT_EXIT_ZERO 0xE0E00E0E
/* launch the compiled program with the given arguments */

LIBTCCAPI int tcc_run(TCCState *s1, int argc, char **argv)
{
	int (*prog_main)(int, char **, char **), ret;
	const char *top_sym;
	jmp_buf main_jb;
#if defined(__APPLE__) || defined(__FreeBSD__)
	char **envp = NULL;
#elif defined(__OpenBSD__) || defined(__NetBSD__)

	char **envp = environ;
#else

	char **envp = environ;
#endif
	/* tcc -dt -run ... nothing to do if no main() */

	if ((s1->dflag & 16) && (addr_t)-1 == get_sym_addr(s1, "main", 0, 1))
		return 0;

	tcc_add_symbol(s1, "__rt_exit", rt_exit);
	if (s1->nostdlib) {
		s1->run_main = top_sym = s1->elf_entryname ? s1->elf_entryname : "_start";
	} else {
		tcc_add_support(s1, "runmain.o");
		s1->run_main = "_runmain";
		top_sym = "main";
	}
	if (tcc_relocate(s1) < 0)
		return -1;

	prog_main = (void*)get_sym_addr(s1, s1->run_main, 1, 1);
	if ((addr_t)-1 == (addr_t)prog_main)
		return -1;
	errno = 0;/* clean errno value */

	fflush(stdout);
	fflush(stderr);

	ret = tcc_setjmp(s1, main_jb, tcc_get_symbol(s1, top_sym));
	if (0 == ret)
		ret = prog_main(argc, argv, envp);
	else if (RT_EXIT_ZERO == ret)
		ret = 0;

	if (s1->dflag & 16 && ret)/* tcc -dt -run ... */

		fprintf(s1->ppfp, "[returns %d]\n", ret), fflush(s1->ppfp);
	return ret;
}
/* ------------------------------------------------------------- */
/* remove all STB_LOCAL symbols */

static void cleanup_symbols(TCCState *s1)
{
	Section *s = s1->symtab;
	int sym_index, end_sym = s->data_offset / sizeof (ElfSym);
	/* reset symtab */

	s->data_offset = s->link->data_offset = s->hash->data_offset = 0;
	init_symtab(s);
	/* add global symbols again */

	for (sym_index = 1; sym_index < end_sym; ++sym_index) {
		ElfW(Sym) *sym = &((ElfW(Sym) *)s->data)[sym_index];
		const char *name = (char *)s->link->data + sym->st_name;
		if (ELFW(ST_BIND)(sym->st_info) == STB_LOCAL)
			continue;
//printf("sym %s\n", name);

		put_elf_sym(s, sym->st_value, sym->st_size, sym->st_info, sym->st_other,
			    sym->st_shndx, name);
	}
}
/* free all sections except symbols */

static void cleanup_sections(TCCState *s1)
{
	struct {
		Section **secs;
		int nb_secs;
	} *p = (void*)&s1->sections;
	int i, f = 2;
	do {
		for (i = --f; i < p->nb_secs; i++) {
			Section *s = p->secs[i];
			if (s == s1->symtab || s == s1->symtab->link || s == s1->symtab->hash) {
				s->data = tcc_realloc(s->data, s->data_allocated = s->data_offset);
			} else {
				free_section(s), tcc_free(s), p->secs[i] = NULL;
			}
		}
	} while (++p, f);
}
/* ------------------------------------------------------------- */
/* 0 = .text rwx  other rw (memory >= 2 pages a 4096 bytes) */
/* 1 = .text rx   other rw (memory >= 3 pages) */
/* 2 = .text rx  .rdata ro  .data/.bss rw (memory >= 4 pages) */
/* Some targets implement secutiry options that do not allow write in
   executable code. These targets need CONFIG_RUNMEM_RO=1.
   The disadvantage of this is that it requires a little bit more memory. */
#ifndef CONFIG_RUNMEM_RO
// 301 "tccrun.c"
#define CONFIG_RUNMEM_RO 0
#endif
/* relocate code. Return -1 on error, required size if ptr is NULL,
   otherwise copy code into buffer passed by the caller */

static int tcc_relocate_ex(TCCState *s1, void *ptr, unsigned ptr_diff)
{
	Section *s;
	unsigned offset, length, align, i, k, f;
	unsigned n, copy;
	addr_t mem, addr;

	if (NULL == ptr) {

		pe_output_file(s1, NULL);

	}

	offset = copy = 0;
	mem = (addr_t)ptr;
redo:
	if (s1->verbose == 2 && copy)
		printf(&"-----------------------------------------------------\n"[PTR_SIZE*2 -
				8]);
	if (s1->nb_errors)
		return -1;
	if (copy == 3)
		return 0;

	for (k = 0; k < 3; ++k) {/* 0:rx, 1:ro, 2:rw sections */

		n = 0;
		addr = 0;
		for (i = 1; i < s1->nb_sections; i++) {
			static const char shf[] = {
				SHF_ALLOC|SHF_EXECINSTR, SHF_ALLOC, SHF_ALLOC|SHF_WRITE
			};
			s = s1->sections[i];
			if (shf[k] != (s->sh_flags & (SHF_ALLOC|SHF_WRITE|SHF_EXECINSTR)))
				continue;
			length = s->data_offset;
			if (copy == 2) {
				if (addr == 0)
					addr = s->sh_addr;
				n = (s->sh_addr - addr) + length;
				continue;
			}
			if (copy) {/* final step: copy section data to memory */

				if (s1->verbose == 2)
					printf("%d: %-16s %p  len %05x  align %04x\n",
					       k, s->name, (void*)s->sh_addr, length, s->sh_addralign);
				ptr = (void*)s->sh_addr;
				if (k == 0)
					ptr = (void*)(s->sh_addr + ptr_diff);
				if (NULL == s->data || s->sh_type == SHT_NOBITS)
					memset(ptr, 0, length);
				else
					memcpy(ptr, s->data, length);
				continue;
			}

			align = s->sh_addralign;
			if (++n == 1) {
				/* To avoid that x86 processors would reload cached instructions
				                   each time when data is written in the near, we need to make
				                   sure that code and data do not share the same 64 byte unit */

				if (align < 64)
					align = 64;
				/* start new page for different permissions */

				if (k <= CONFIG_RUNMEM_RO)
					align = PAGESIZE;
			}
			s->sh_addralign = align;
			addr = k ? mem + ptr_diff : mem;
			offset += -(addr + offset) & (align - 1);
			s->sh_addr = mem ? addr + offset : 0;
			offset += length;
		}
		if (copy == 2) {/* set permissions */

			if (n == 0)/* no data  */

				continue;

			f = k;
			if (f >= CONFIG_RUNMEM_RO) {
				if (f != 0)
					continue;
				f = 3;/* change only SHF_EXECINSTR to rwx */

			}
			n = PAGEALIGN(n);
			if (s1->verbose == 2) {
				printf("protect         %3s %p  len %05x\n",
				       &"rx\0ro\0rw\0rwx"[f*3], (void*)addr, (unsigned)n);
			}
			if (protect_pages((void*)addr, n, f) < 0)
				return tcc_error_noabort(
					       "mprotect failed (did you mean to configure --with-selinux?)");
		}
	}

	if (0 == mem)
		return PAGEALIGN(offset);

	if (++copy == 2) {
		goto redo;
	}
	if (copy == 3) {

		s1->run_function_table = win64_add_function_table(s1);
		/* remove local symbols and free sections except symtab */

		cleanup_symbols(s1);
		cleanup_sections(s1);
		goto redo;
	}
	/* relocate symbols */

	relocate_syms(s1, s1->symtab, 1);
	/* relocate sections */

	s1->pe_imagebase = mem;

	relocate_sections(s1);
	goto redo;
}
/* ------------------------------------------------------------- */
/* allow to run code in memory */

static int protect_pages(void *ptr, unsigned long length, int mode)
{

	static const unsigned char protect[] = {
		PAGE_EXECUTE_READ,
		PAGE_READONLY,
		PAGE_READWRITE,
		PAGE_EXECUTE_READWRITE
	};
	DWORD old;
	if (!VirtualProtect(ptr, length, protect[mode], &old))
		return -1;
// 467 "tccrun.c"
	return 0;
}

static void *win64_add_function_table(TCCState *s1)
{
	void *p = NULL;
	if (s1->uw_pdata) {
		p = (void*)s1->uw_pdata->sh_addr;
		RtlAddFunctionTable(
			(RUNTIME_FUNCTION*)p,
			s1->uw_pdata->data_offset / sizeof (RUNTIME_FUNCTION),
			s1->pe_imagebase
		);
		s1->uw_pdata = NULL;
	}
	return p;
}

static void win64_del_function_table(void *p)
{
	if (p) {
		RtlDeleteFunctionTable((RUNTIME_FUNCTION*)p);
	}
}

static void bt_link(TCCState *s1)
{
#ifdef CONFIG_TCC_BACKTRACE

	rt_context *rc;
	void *p;

	if (!s1->do_backtrace)
		return;
	rc = tcc_get_symbol(s1, "__rt_info");
	if (!rc)
		return;
	rc->esym_start = (ElfW(Sym) *)(symtab_section->data);
	rc->esym_end = (ElfW(Sym) *)(symtab_section->data +
				     symtab_section->data_offset);
	rc->elf_str = (char *)symtab_section->link->data;
	if (PTR_SIZE == 8 && !s1->dwarf)
		rc->prog_base &= 0xffffffff00000000ULL;
#ifdef CONFIG_TCC_BCHECK

	if (s1->do_bounds_check) {
		if ((p = tcc_get_symbol(s1, "__bound_init")))
			((void(*)(void*,int))p)(rc->bounds_start, 1);
	}
#endif

	rc->next = g_rc, g_rc = rc, s1->rc = rc;
	if (0 == signal_set)
		set_exception_handler(), signal_set = 1;
#endif

}

static void st_link(TCCState *s1)
{
	rt_wait_sem();
	s1->next = g_s1, g_s1 = s1;
	bt_link(s1);
	rt_post_sem();
}
/* remove 'el' from 'list' */

static void ptr_unlink(void *list, void *e, unsigned next)
{
	void **pp, **nn, *p;
	for (pp = list; !!(p = *pp); pp = nn) {
		nn = (void*)((char*)p + next);/* nn = &p->next; */

		if (p == e) {
			*pp = *nn;
			break;
		}
	}
}

static void st_unlink(TCCState *s1)
{
	rt_wait_sem();
#ifdef CONFIG_TCC_BACKTRACE

	ptr_unlink(&g_rc, s1->rc, offsetof(rt_context, next));
#endif

	ptr_unlink(&g_s1, s1, offsetof(TCCState, next));
	rt_post_sem();
}

LIBTCCAPI void *_tcc_setjmp(TCCState *s1, void *p_jmp_buf, void *func,
			    void *p_longjmp)
{
	s1->run_lj = p_longjmp;
	s1->run_jb = p_jmp_buf;
#ifdef CONFIG_TCC_BACKTRACE

	if (s1->rc)
		s1->rc->top_func = func;
#endif

	return p_jmp_buf;
}

LIBTCCAPI void tcc_set_backtrace_func(TCCState *s1, void *data, TCCBtFunc *func)
{
	s1->bt_func = func;
	s1->bt_data = data;
}

static TCCState *rt_find_state(rt_frame *f)
{
	TCCState *s;
	int level;
	addr_t pc;

	s = g_s1;
	if (NULL == s || NULL == s->next) {
		/* play it safe in the simple case when there is only one state */

		return s;
	}
	for (level = 0; level < 8; ++level) {
		if (rt_get_caller_pc(&pc, f, level) < 0)
			break;
		for (s = g_s1; s; s = s->next) {
			if (pc >= (addr_t)s->run_ptr
			    && pc < (addr_t)s->run_ptr + s->run_size)
				return s;
		}
	}
	return NULL;
}

static void rt_exit(rt_frame *f, int code)
{
	TCCState *s;
	rt_wait_sem();
	s = rt_find_state(f);
	rt_post_sem();
	if (s && s->run_lj) {
		if (code == 0)
			code = RT_EXIT_ZERO;
		((void(*)(void*,int))s->run_lj)(s->run_jb, code);
	}
	exit(code);
}
/* ------------------------------------------------------------- */
#else
// if defined CONFIG_TCC_BACKTRACE_ONLY

static void rt_exit(rt_frame *f, int code)
{
	exit(code);
}
#endif
//ndef CONFIG_TCC_BACKTRACE_ONLY
/* ------------------------------------------------------------- */
#ifdef CONFIG_TCC_BACKTRACE
// 617 "tccrun.c"
static int rt_vprintf(const char *fmt, va_list ap)
{
	int ret = vfprintf(stderr, fmt, ap);
	fflush(stderr);
	return ret;
}

static int rt_printf(const char *fmt, ...)
{
	va_list ap;
	int r;
	va_start(ap, fmt);
	r = rt_vprintf(fmt, ap);
	va_end(ap);
	return r;
}

static char *rt_elfsym(rt_context *rc, addr_t wanted_pc, addr_t *func_addr)
{
	ElfW(Sym) *esym;
	for (esym = rc->esym_start + 1; esym < rc->esym_end; ++esym) {
		int type = ELFW(ST_TYPE)(esym->st_info);
		if ((type == STT_FUNC || type == STT_GNU_IFUNC)
		    && wanted_pc >= esym->st_value
		    && wanted_pc < esym->st_value + esym->st_size) {
			*func_addr = esym->st_value;
			return rc->elf_str + esym->st_name;
		}
	}
	return NULL;
}

typedef struct bt_info {
	char file[100];
	int line;
	char func[100];
	addr_t func_pc;
} bt_info;
/* print the position in the source file of PC value 'pc' by reading
   the stabs debug information */

static addr_t rt_printline (rt_context *rc, addr_t wanted_pc, bt_info *bi)
{
	char func_name[128];
	addr_t func_addr, last_pc, pc;
	const char *incl_files[INCLUDE_STACK_SIZE];
	int incl_index, last_incl_index, len, last_line_num, i;
	const char *str, *p;
	Stab_Sym *sym;

	func_name[0] = '\0';
	func_addr = 0;
	incl_index = 0;
	last_pc = (addr_t)-1;
	last_line_num = 1;
	last_incl_index = 0;

	for (sym = rc->stab_sym + 1; sym < rc->stab_sym_end; ++sym) {
		str = rc->stab_str + sym->n_strx;
		pc = sym->n_value;

		switch (sym->n_type) {
		case N_SLINE:
			if (func_addr)
				goto rel_pc;
		case N_SO:
		case N_SOL:
			goto abs_pc;
		case N_FUN:
			if (sym->n_strx == 0)/* end of function */

				goto rel_pc;
abs_pc:
#if PTR_SIZE == 8
			/* Stab_Sym.n_value is only 32bits */

			pc += rc->prog_base;
#endif

			goto check_pc;
rel_pc:
			pc += func_addr;
check_pc:
			if (pc >= wanted_pc && wanted_pc >= last_pc)
				goto found;
			break;
		}

		switch (sym->n_type) {
		/* function start or end */

		case N_FUN:
			if (sym->n_strx == 0)
				goto reset_func;
			p = strchr(str, ':');
			if (0 == p || (len = p - str + 1, len > sizeof func_name))
				len = sizeof func_name;
			pstrcpy(func_name, len, str);
			func_addr = pc;
			break;
		/* line number info */

		case N_SLINE:
			last_pc = pc;
			last_line_num = sym->n_desc;
			last_incl_index = incl_index;
			break;
		/* include files */

		case N_BINCL:
			if (incl_index < INCLUDE_STACK_SIZE)
				incl_files[incl_index++] = str;
			break;
		case N_EINCL:
			if (incl_index > 1)
				incl_index--;
			break;
		/* start/end of translation unit */

		case N_SO:
			incl_index = 0;
			if (sym->n_strx) {
				/* do not add path */

				len = strlen(str);
				if (len > 0 && str[len - 1] != '/')
					incl_files[incl_index++] = str;
			}
reset_func:
			func_name[0] = '\0';
			func_addr = 0;
			last_pc = (addr_t)-1;
			break;
		/* alternative file name (from #line or #include directives) */

		case N_SOL:
			if (incl_index)
				incl_files[incl_index-1] = str;
			break;
		}
	}
	last_incl_index = 0, func_name[0] = 0, func_addr = 0;
found:
	i = last_incl_index;
	if (i > 0) {
		pstrcpy(bi->file, sizeof bi->file, incl_files[--i]);
		bi->line = last_line_num;
	}
	pstrcpy(bi->func, sizeof bi->func, func_name);
	bi->func_pc = func_addr;
	return func_addr;
}
/* ------------------------------------------------------------- */
/* rt_printline - dwarf version */

#define DIR_TABLE_SIZE (64)
#define FILE_TABLE_SIZE (512)
/* timestamp/size/md5/... */
// 777 "tccrun.c"
#define dwarf_ignore_type(ln,end) switch (entry_format[j].form) { case DW_FORM_data1: (ln) += 1; break; case DW_FORM_data2: (ln) += 2; break; case DW_FORM_data4: (ln) += 3; break; case DW_FORM_data8: (ln) += 8; break; case DW_FORM_data16: (ln) += 16; break; case DW_FORM_udata: dwarf_read_uleb128(&(ln), (end)); break; default: goto next_line; }

static addr_t rt_printline_dwarf (rt_context *rc, addr_t wanted_pc, bt_info *bi)
{
	unsigned char *ln;
	unsigned char *cp;
	unsigned char *end;
	unsigned char *opcode_length;
	unsigned long long size;
	unsigned int length;
	unsigned char version;
	unsigned int min_insn_length;
	unsigned int max_ops_per_insn;
	int line_base;
	unsigned int line_range;
	unsigned int opcode_base;
	unsigned int opindex;
	unsigned int col;
	unsigned int i;
	unsigned int j;
	unsigned int len;
	unsigned long long value;
	struct {
		unsigned int type;
		unsigned int form;
	} entry_format[256];
	unsigned int dir_size;

	unsigned int filename_size;
	struct { /*dwarf_filename_struct*/
		unsigned int dir_entry;
		char *name;
	} filename_table[FILE_TABLE_SIZE];
	addr_t last_pc;
	addr_t pc;
	addr_t func_addr;
	int line;
	char *filename;
	char *function;

	filename = NULL;
	function = NULL;
	func_addr = 0;
	line = 0;

	ln = rc->dwarf_line;
	while (ln < rc->dwarf_line_end) {
		dir_size = 0;
		filename_size = 0;
		last_pc = 0;
		pc = 0;
		func_addr = 0;
		line = 1;
		filename = NULL;
		function = NULL;
		length = 4;
		size = dwarf_read_4(ln, rc->dwarf_line_end);
		if (size == 0xffffffffu)// dwarf 64

			length = 8, size = dwarf_read_8(ln, rc->dwarf_line_end);
		end = ln + size;
		if (end < ln || end > rc->dwarf_line_end)
			break;
		version = dwarf_read_2(ln, end);
		if (version >= 5)
			ln += length + 2;// address size, segment selector, prologue Length

		else
			ln += length;// prologue Length

		min_insn_length = dwarf_read_1(ln, end);
		if (version >= 4)
			max_ops_per_insn = dwarf_read_1(ln, end);
		else
			max_ops_per_insn = 1;
		ln++;// Initial value of 'is_stmt'

		line_base = dwarf_read_1(ln, end);
		line_base |= line_base >= 0x80 ? ~0xff : 0;
		line_range = dwarf_read_1(ln, end);
		opcode_base = dwarf_read_1(ln, end);
		opcode_length = ln;
		ln += opcode_base - 1;
		opindex = 0;
		if (version >= 5) {
			col = dwarf_read_1(ln, end);
			for (i = 0; i < col; i++) {
				entry_format[i].type = dwarf_read_uleb128(&ln, end);
				entry_format[i].form = dwarf_read_uleb128(&ln, end);
			}
			dir_size = dwarf_read_uleb128(&ln, end);
			for (i = 0; i < dir_size; i++) {
				for (j = 0; j < col; j++) {
					if (entry_format[j].type == DW_LNCT_path) {
						if (entry_format[j].form != DW_FORM_line_strp)
							goto next_line;

						length == 4 ? dwarf_read_4(ln, end)
						: dwarf_read_8(ln, end);

					} else
						dwarf_ignore_type(ln, end);
				}
			}
			col = dwarf_read_1(ln, end);
			for (i = 0; i < col; i++) {
				entry_format[i].type = dwarf_read_uleb128(&ln, end);
				entry_format[i].form = dwarf_read_uleb128(&ln, end);
			}
			filename_size = dwarf_read_uleb128(&ln, end);
			for (i = 0; i < filename_size; i++)
				for (j = 0; j < col; j++) {
					if (entry_format[j].type == DW_LNCT_path) {
						if (entry_format[j].form != DW_FORM_line_strp)
							goto next_line;
						value = length == 4 ? dwarf_read_4(ln, end)
							: dwarf_read_8(ln, end);
						if (i < FILE_TABLE_SIZE)
							filename_table[i].name =
								(char *)rc->dwarf_line_str + value;
					} else if (entry_format[j].type == DW_LNCT_directory_index) {
						switch (entry_format[j].form) {
						case DW_FORM_data1:
							value = dwarf_read_1(ln, end);
							break;
						case DW_FORM_data2:
							value = dwarf_read_2(ln, end);
							break;
						case DW_FORM_data4:
							value = dwarf_read_4(ln, end);
							break;
						case DW_FORM_udata:
							value = dwarf_read_uleb128(&ln, end);
							break;
						default:
							goto next_line;
						}
						if (i < FILE_TABLE_SIZE)
							filename_table[i].dir_entry = value;
					} else
						dwarf_ignore_type(ln, end);
				}
		} else {
			while ((dwarf_read_1(ln, end))) {

				while (dwarf_read_1(ln, end)) {}
			}
			while ((dwarf_read_1(ln, end))) {
				if (++filename_size < FILE_TABLE_SIZE) {
					filename_table[filename_size - 1].name = (char *)ln - 1;
					while (dwarf_read_1(ln, end)) {}
					filename_table[filename_size - 1].dir_entry =
						dwarf_read_uleb128(&ln, end);
				} else {
					while (dwarf_read_1(ln, end)) {}
					dwarf_read_uleb128(&ln, end);
				}
				dwarf_read_uleb128(&ln, end);// time

				dwarf_read_uleb128(&ln, end);// size

			}
		}
		if (filename_size >= 1)
			filename = filename_table[0].name;
		while (ln < end) {
			last_pc = pc;
			i = dwarf_read_1(ln, end);
			if (i >= opcode_base) {
				if (max_ops_per_insn == 1)
					pc += ((i - opcode_base) / line_range) * min_insn_length;
				else {
					pc += (opindex + (i - opcode_base) / line_range) /
					      max_ops_per_insn * min_insn_length;
					opindex = (opindex + (i - opcode_base) / line_range) %
						  max_ops_per_insn;
				}
				i = (int)((i - opcode_base) % line_range) + line_base;
check_pc:
				if (pc >= wanted_pc && wanted_pc >= last_pc)
					goto found;
				line += i;
			} else {
				switch (i) {
				case 0:
					len = dwarf_read_uleb128(&ln, end);
					cp = ln;
					ln += len;
					if (len == 0)
						goto next_line;
					switch (dwarf_read_1(cp, end)) {
					case DW_LNE_end_sequence:
						break;
					case DW_LNE_set_address:
#if PTR_SIZE == 4
						pc = dwarf_read_4(cp, end);
#else

						pc = dwarf_read_8(cp, end);
#endif

						opindex = 0;
						break;
					case DW_LNE_define_file:/* deprecated */

						if (++filename_size < FILE_TABLE_SIZE) {
							filename_table[filename_size - 1].name = (char *)ln - 1;
							while (dwarf_read_1(ln, end)) {}
							filename_table[filename_size - 1].dir_entry =
								dwarf_read_uleb128(&ln, end);
						} else {
							while (dwarf_read_1(ln, end)) {}
							dwarf_read_uleb128(&ln, end);
						}
						dwarf_read_uleb128(&ln, end);// time

						dwarf_read_uleb128(&ln, end);// size

						break;
					case DW_LNE_hi_user - 1:
						function = (char *)cp;
						func_addr = pc;
						break;
					default:
						break;
					}
					break;
				case DW_LNS_advance_pc:
					if (max_ops_per_insn == 1)
						pc += dwarf_read_uleb128(&ln, end) * min_insn_length;
					else {
						unsigned long long off = dwarf_read_uleb128(&ln, end);

						pc += (opindex + off) / max_ops_per_insn *
						      min_insn_length;
						opindex = (opindex + off) % max_ops_per_insn;
					}
					i = 0;
					goto check_pc;
				case DW_LNS_advance_line:
					line += dwarf_read_sleb128(&ln, end);
					break;
				case DW_LNS_set_file:
					i = dwarf_read_uleb128(&ln, end);
					i -= i > 0 && version < 5;
					if (i < FILE_TABLE_SIZE && i < filename_size)
						filename = filename_table[i].name;
					break;
				case DW_LNS_const_add_pc:
					if (max_ops_per_insn == 1)
						pc += ((255 - opcode_base) / line_range) * min_insn_length;
					else {
						unsigned int off = (255 - opcode_base) / line_range;

						pc += ((opindex + off) / max_ops_per_insn) *
						      min_insn_length;
						opindex = (opindex + off) % max_ops_per_insn;
					}
					i = 0;
					goto check_pc;
				case DW_LNS_fixed_advance_pc:
					i = dwarf_read_2(ln, end);
					pc += i;
					opindex = 0;
					i = 0;
					goto check_pc;
				default:
					for (j = 0; j < opcode_length[i - 1]; j++)
						dwarf_read_uleb128 (&ln, end);
					break;
				}
			}
		}
next_line:
		ln = end;
	}
	filename = function = NULL, func_addr = 0;
found:
	if (filename)
		pstrcpy(bi->file, sizeof bi->file, filename), bi->line = line;
	if (function)
		pstrcpy(bi->func, sizeof bi->func, function);
	bi->func_pc = func_addr;
	return (addr_t)func_addr;
}
/* ------------------------------------------------------------- */
#ifndef CONFIG_TCC_BACKTRACE_ONLY

static
#endif

int _tcc_backtrace(rt_frame *f, const char *fmt, va_list ap)
{
	rt_context *rc, *rc2;
	addr_t pc;
	char skip[40], msg[200];
	int i, level, ret, n, one;
	const char *a, *b;
	bt_info bi;
	addr_t (*getinfo)(rt_context*, addr_t, bt_info*);

	skip[0] = 0;
	/* If fmt is like "^file.c^..." then skip calls from 'file.c' */

	if (fmt[0] == '^' && (b = strchr(a = fmt + 1, fmt[0]))) {
		memcpy(skip, a, b - a), skip[b - a] = 0;
		fmt = b + 1;
	}
	one = 0;
	/* hack for bcheck.c:dprintf(): one level, no newline */

	if (fmt[0] == '\001')
		++fmt, one = 1;
	vsnprintf(msg, sizeof msg, fmt, ap);

	rt_wait_sem();
	rc = g_rc;
	getinfo = rt_printline, n = 6;
	if (rc) {
		if (rc->dwarf)
			getinfo = rt_printline_dwarf;
		if (rc->num_callers)
			n = rc->num_callers;
	}

	for (i = level = 0; level < n; i++) {
		ret = rt_get_caller_pc(&pc, f, i);
		if (ret == -1)
			break;
		memset(&bi, 0, sizeof bi);
		for (rc2 = rc; rc2; rc2 = rc2->next) {
			if (getinfo(rc2, pc, &bi))
				break;
			/* we try symtab symbols (no line number info) */

			if (!!(a = rt_elfsym(rc2, pc, &bi.func_pc))) {
				pstrcpy(bi.func, sizeof bi.func, a);
				break;
			}
		}
//fprintf(stderr, "%d rc %p %p\n", i, (void*)pcfunc, (void*)pc);

		if (skip[0] && strstr(bi.file, skip))
			continue;
#ifndef CONFIG_TCC_BACKTRACE_ONLY

		{
			TCCState *s = rt_find_state(f);
			if (s && s->bt_func) {
				ret = s->bt_func(
					      s->bt_data,
					      (void*)pc,
					      bi.file[0] ? bi.file : NULL,
					      bi.line,
					      bi.func[0] ? bi.func : NULL,
					      level == 0 ? msg : NULL
				      );
				if (ret == 0)
					break;
				goto check_break;
			}
		}
#endif

		if (bi.file[0]) {
			rt_printf("%s:%d", bi.file, bi.line);
		} else {
			rt_printf("0x%08llx", (long long)pc);
		}
		rt_printf(": %s %s", level ? "by" : "at", bi.func[0] ? bi.func : "???");
		if (level == 0) {
			rt_printf(": %s", msg);
			if (one)
				break;
		}
		rt_printf("\n");
#ifndef CONFIG_TCC_BACKTRACE_ONLY

check_break:
#endif

		if (rc2
		    && bi.func_pc
		    && bi.func_pc == (addr_t)rc2->top_func)
			break;
		++level;
	}
	rt_post_sem();
	return 0;
}
/* emit a run time error at position 'pc' */

static int rt_error(rt_frame *f, const char *fmt, ...)
{
	va_list ap;
	char msg[200];
	int ret;
	va_start(ap, fmt);
	snprintf(msg, sizeof msg, "RUNTIME ERROR: %s", fmt);
	ret = _tcc_backtrace(f, msg, ap);
	va_end(ap);
	return ret;
}
/* ------------------------------------------------------------- */
// 1178 "tccrun.c"
#define ucontext_t CONTEXT
/* translate from ucontext_t* to internal rt_context * */

static void rt_getcontext(ucontext_t *uc, rt_frame *rc)
{

	rc->ip = uc->Rip;
	rc->fp = uc->Rbp;
	rc->sp = uc->Rsp;
// 1268 "tccrun.c"
}
/* ------------------------------------------------------------- */
/* WIN32 */
/* signal handler for fatal errors */
// 1351 "tccrun.c"
static long __stdcall cpu_exception_handler(EXCEPTION_POINTERS *ex_info)
{
	rt_frame f;
	unsigned code;
	rt_getcontext(ex_info->ContextRecord, &f);

	switch (code = ex_info->ExceptionRecord->ExceptionCode) {
	case EXCEPTION_ACCESS_VIOLATION:
		rt_error(&f, "invalid memory access");
		break;
	case EXCEPTION_STACK_OVERFLOW:
		rt_error(&f, "stack overflow");
		break;
	case EXCEPTION_INT_DIVIDE_BY_ZERO:
		rt_error(&f, "division by zero");
		break;
	case EXCEPTION_BREAKPOINT:
	case EXCEPTION_SINGLE_STEP:
		f.ip = *(addr_t*)f.sp;
		rt_error(&f, "breakpoint/single-step exception:");
		return EXCEPTION_CONTINUE_SEARCH;
	default:
		rt_error(&f, "caught exception %08x", code);
		break;
	}
	rt_exit(&f, 255);
	return EXCEPTION_EXECUTE_HANDLER;
}
/* Generate a stack backtrace when a CPU exception occurs. */

static void set_exception_handler(void)
{
	SetUnhandledExceptionFilter(cpu_exception_handler);
}
/* ------------------------------------------------------------- */
/* return the PC at frame level 'level'. Return negative if not found */

static int rt_get_caller_pc(addr_t *paddr, rt_frame *rc, int level)
{
	if (level == 0) {
		*paddr = rc->ip;
	} else {
		addr_t fp = rc->fp;
		while (1) {
			if (fp < 0x1000)
				return -1;
			if (0 == --level)
				break;
			/* XXX: check address validity with program info */

			fp = ((addr_t *)fp)[0];
		}
		*paddr = ((addr_t *)fp)[1];
	}
	return 0;
}
/* XXX: only supports linux/bsd */
#else
// for runmain.c:exit(); when CONFIG_TCC_BACKTRACE == 0 */

static int rt_get_caller_pc(addr_t *paddr, rt_frame *f, int level)
{
	if (level)
		return -1;
	*paddr = f->ip;
	return 0;
}
#endif
/* CONFIG_TCC_BACKTRACE */
/* ------------------------------------------------------------- */
#ifdef CONFIG_TCC_STATIC

/* dummy function for profiling */

ST_FUNC void *dlopen(const char *filename, int flag)
{
	return NULL;
}

ST_FUNC void dlclose(void *p)
{
}

ST_FUNC const char *dlerror(void)
{
	return "error";
}

typedef struct TCCSyms {
	char *str;
	void *ptr;
} TCCSyms;

/* add the symbol you want here if no dynamic linking is done */

static TCCSyms tcc_syms[] = {
#if !defined(CONFIG_TCCBOOT)
#define TCCSYM(a) { a, &a, },
	TCCSYM(printf)
	TCCSYM(fprintf)
	TCCSYM(fopen)
	TCCSYM(fclose)
#undef TCCSYM
#endif
	{ NULL, NULL },
};

ST_FUNC void *dlsym(void *handle, const char *symbol)
{
	TCCSyms *p;
	p = tcc_syms;
	while (p->str != NULL) {
		if (!strcmp(p->str, symbol))
			return p->ptr;
		p++;
	}
	return NULL;
}

#endif
/* CONFIG_TCC_STATIC */
/* TCC_IS_NATIVE */
/* ------------------------------------------------------------- */
// 32 "libtcc.c" 2

// 1 "x86_64-gen.c" 1
/*
 *  x86-64 code generator for TCC
 *
 *  Copyright (c) 2008 Shinichiro Hamaji
 *
 *  Based on i386-gen.c by Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef TARGET_DEFS_ONLY

/* number of available registers */

#define NB_REGS         25
#define NB_ASM_REGS     16
#define CONFIG_TCC_ASM

/* a register can belong to several classes. The classes must be
   sorted from more general to more precise (see gv2() code which does
   assumptions on it). */

#define RC_INT     0x0001 /* generic integer register */

#define RC_FLOAT   0x0002 /* generic float register */

#define RC_RAX     0x0004
#define RC_RDX     0x0008
#define RC_RCX     0x0010
#define RC_RSI     0x0020
#define RC_RDI     0x0040
#define RC_ST0     0x0080 /* only for long double */

#define RC_R8      0x0100
#define RC_R9      0x0200
#define RC_R10     0x0400
#define RC_R11     0x0800
#define RC_XMM0    0x1000
#define RC_XMM1    0x2000
#define RC_XMM2    0x4000
#define RC_XMM3    0x8000
#define RC_XMM4    0x10000
#define RC_XMM5    0x20000
#define RC_XMM6    0x40000
#define RC_XMM7    0x80000
#define RC_IRET    RC_RAX /* function return: integer register */

#define RC_IRE2    RC_RDX /* function return: second integer register */

#define RC_FRET    RC_XMM0 /* function return: float register */

#define RC_FRE2    RC_XMM1 /* function return: second float register */

/* pretty names for the registers */

enum {
	TREG_RAX = 0,
	TREG_RCX = 1,
	TREG_RDX = 2,
	TREG_RSP = 4,
	TREG_RSI = 6,
	TREG_RDI = 7,

	TREG_R8 = 8,
	TREG_R9 = 9,
	TREG_R10 = 10,
	TREG_R11 = 11,

	TREG_XMM0 = 16,
	TREG_XMM1 = 17,
	TREG_XMM2 = 18,
	TREG_XMM3 = 19,
	TREG_XMM4 = 20,
	TREG_XMM5 = 21,
	TREG_XMM6 = 22,
	TREG_XMM7 = 23,

	TREG_ST0 = 24,

	TREG_MEM = 0x20
};

#define REX_BASE(reg) (((reg) >> 3) & 1)
#define REG_VALUE(reg) ((reg) & 7)

/* return registers for function */

#define REG_IRET TREG_RAX /* single word int return register */

#define REG_IRE2 TREG_RDX /* second word return register (for long long) */

#define REG_FRET TREG_XMM0 /* float return register */

#define REG_FRE2 TREG_XMM1 /* second float return register */

/* defined if function parameters must be evaluated in reverse order */

#define INVERT_FUNC_PARAMS

/* pointer size, in bytes */

#define PTR_SIZE 8

/* long double size and alignment, in bytes */

#define LDOUBLE_SIZE  16
#define LDOUBLE_ALIGN 16
/* maximum alignment (for aligned attribute support) */

#define MAX_ALIGN     16

/* define if return values need to be extended explicitely
   at caller side (for interfacing with non-TCC compilers) */

#define PROMOTE_RET

#define TCC_TARGET_NATIVE_STRUCT_COPY
ST_FUNC void gen_struct_copy(int size);

/**/

#else
/* ! TARGET_DEFS_ONLY */
/**/
// 117 "x86_64-gen.c"
#define USING_GLOBALS
// 1 "tcc.h" 1
#ifndef _TCC_H
/* _TCC_H */
#endif /* _TCC_H */
// 1990 "tcc.h"
#undef TCC_STATE_VAR
#undef TCC_SET_STATE
#ifdef USING_GLOBALS

#define TCC_STATE_VAR(sym) tcc_state->sym
#define TCC_SET_STATE(fn) fn
#undef USING_GLOBALS
#undef _tcc_error
#else

#define TCC_STATE_VAR(sym) s1->sym
#define TCC_SET_STATE(fn) (tcc_enter_state(s1),fn)
#define _tcc_error use_tcc_error_noabort
#endif
// 119 "x86_64-gen.c" 2
#include <assert.h>

ST_DATA const char *const target_machine_defs =
	"__x86_64__\0"
	"__amd64__\0"
	;

ST_DATA const int reg_classes[NB_REGS] = {
	/* eax */
	RC_INT | RC_RAX,
	/* ecx */
	RC_INT | RC_RCX,
	/* edx */
	RC_INT | RC_RDX,
	0,
	0,
	0,
	RC_RSI,
	RC_RDI,
	RC_R8,
	RC_R9,
	RC_R10,
	RC_R11,
	0,
	0,
	0,
	0,
	/* xmm0 */
	RC_FLOAT | RC_XMM0,
	/* xmm1 */
	RC_FLOAT | RC_XMM1,
	/* xmm2 */
	RC_FLOAT | RC_XMM2,
	/* xmm3 */
	RC_FLOAT | RC_XMM3,
	/* xmm4 */
	RC_FLOAT | RC_XMM4,
	/* xmm5 */
	RC_FLOAT | RC_XMM5,
	/* xmm6 an xmm7 are included so gv() can be used on them,
	       but they are not tagged with RC_FLOAT because they are
	       callee saved on Windows */

	RC_XMM6,
	RC_XMM7,
	/* st0 */
	RC_ST0
};

static unsigned long func_sub_sp_offset;
static int func_ret_sub;
#if defined(CONFIG_TCC_BCHECK)
static addr_t func_bound_offset;
static unsigned long func_bound_ind;
ST_DATA int func_bound_add_epilog;
#endif
// 167 "x86_64-gen.c"
static int func_scratch, func_alloca;
/* XXX: make it faster ? */

ST_FUNC void g(int c)
{
	int ind1;
	if (nocode_wanted)
		return;
	ind1 = ind + 1;
	if (ind1 > cur_text_section->data_allocated)
		section_realloc(cur_text_section, ind1);
	cur_text_section->data[ind] = c;
	ind = ind1;
}

ST_FUNC void o(unsigned int c)
{
	while (c) {
		g(c);
		c = c >> 8;
	}
}

ST_FUNC void gen_le16(int v)
{
	g(v);
	g(v >> 8);
}

ST_FUNC void gen_le32(int c)
{
	g(c);
	g(c >> 8);
	g(c >> 16);
	g(c >> 24);
}

ST_FUNC void gen_le64(int64_t c)
{
	g(c);
	g(c >> 8);
	g(c >> 16);
	g(c >> 24);
	g(c >> 32);
	g(c >> 40);
	g(c >> 48);
	g(c >> 56);
}

static void orex(int ll, int r, int r2, int b)
{
	if ((r & VT_VALMASK) >= VT_CONST)
		r = 0;
	if ((r2 & VT_VALMASK) >= VT_CONST)
		r2 = 0;
	if (ll || REX_BASE(r) || REX_BASE(r2))
		o(0x40 | REX_BASE(r) | (REX_BASE(r2) << 2) | (ll << 3));
	o(b);
}
/* output a symbol and patch all calls to it */

ST_FUNC void gsym_addr(int t, int a)
{
	while (t) {
		unsigned char *ptr = cur_text_section->data + t;
		uint32_t n = read32le(ptr);/* next value */

		write32le(ptr, a < 0 ? -a : a - t - 4);
		t = n;
	}
}

static int is64_type(int t)
{
	return ((t & VT_BTYPE) == VT_PTR ||
		(t & VT_BTYPE) == VT_FUNC ||
		(t & VT_BTYPE) == VT_LLONG);
}
/* instruction + 4 bytes data. Return the address of the data */

static int oad(int c, int s)
{
	int t;
	if (nocode_wanted)
		return s;
	o(c);
	t = ind;
	gen_le32(s);
	return t;
}
/* generate jmp to a label */

#define gjmp2(instr,lbl) oad(instr,lbl)

ST_FUNC void gen_addr32(int r, Sym *sym, int c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_32S, c), c=0;
	gen_le32(c);
}
/* output constant with relocation if 'r & VT_SYM' is true */

ST_FUNC void gen_addr64(int r, Sym *sym, int64_t c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_64, c), c=0;
	gen_le64(c);
}
/* output constant with relocation if 'r & VT_SYM' is true */

ST_FUNC void gen_addrpc32(int r, Sym *sym, int c)
{
	if (r & VT_SYM)
		greloca(cur_text_section, sym, ind, R_X86_64_PC32, c-4), c=4;
	gen_le32(c-4);
}
/* output got address with relocation */

static void gen_gotpcrel(int r, Sym *sym, int c)
{

	tcc_error("internal error: no GOT on PE: %s %x %x | %02x %02x %02x\n",
		  get_tok_str(sym->v, NULL), c, r,
		  cur_text_section->data[ind-3],
		  cur_text_section->data[ind-2],
		  cur_text_section->data[ind-1]
		 );

	greloca(cur_text_section, sym, ind, R_X86_64_GOTPCREL, -4);
	gen_le32(0);
	if (c) {
		/* we use add c, %xxx for displacement */

		orex(1, r, 0, 0x81);
		o(0xc0 + REG_VALUE(r));
		gen_le32(c);
	}
}

static void gen_modrm_impl(int op_reg, int r, Sym *sym, int c, int is_got)
{
	op_reg = REG_VALUE(op_reg) << 3;
	if ((r & VT_VALMASK) == VT_CONST) {
		/* constant memory reference */

		if (!(r & VT_SYM)) {
			/* Absolute memory reference */

			o(0x04 | op_reg);/* [sib] | destreg */

			oad(0x25, c);/* disp32 */

		} else {
			o(0x05 | op_reg);/* (%rip)+disp32 | destreg */

			if (is_got) {
				gen_gotpcrel(r, sym, c);
			} else {
				gen_addrpc32(r, sym, c);
			}
		}
	} else if ((r & VT_VALMASK) == VT_LOCAL) {
		/* currently, we use only ebp as base */

		if (c == (char)c) {
			/* short reference */

			o(0x45 | op_reg);
			g(c);
		} else {
			oad(0x85 | op_reg, c);
		}
	} else if ((r & VT_VALMASK) >= TREG_MEM) {
		if (c) {
			g(0x80 | op_reg | REG_VALUE(r));
			gen_le32(c);
		} else {
			g(0x00 | op_reg | REG_VALUE(r));
		}
	} else {
		g(0x00 | op_reg | REG_VALUE(r));
	}
}
/* generate a modrm reference. 'op_reg' contains the additional 3
   opcode bits */

static void gen_modrm(int op_reg, int r, Sym *sym, int c)
{
	gen_modrm_impl(op_reg, r, sym, c, 0);
}
/* generate a modrm reference. 'op_reg' contains the additional 3
   opcode bits */

static void gen_modrm64(int opcode, int op_reg, int r, Sym *sym, int c)
{
	int is_got;
	is_got = (op_reg & TREG_MEM) && !(sym->type.t & VT_STATIC);
	orex(1, r, op_reg, opcode);
	gen_modrm_impl(op_reg, r, sym, c, is_got);
}
/* load 'r' from value 'sv' */

void load(int r, SValue *sv)
{
	int v, t, ft, fc, fr;
	SValue v1;

	fr = sv->r;
	ft = sv->type.t & ~VT_DEFSIGN;
	fc = sv->c.i;
	if (fc != sv->c.i && (fr & VT_SYM))
		tcc_error("64 bit addend in load");

	ft &= ~(VT_VOLATILE | VT_CONSTANT);
// 392 "x86_64-gen.c"
	v = fr & VT_VALMASK;
	if (fr & VT_LVAL) {
		int b, ll;
		if (v == VT_LLOCAL) {
			v1.type.t = VT_PTR;
			v1.r = VT_LOCAL | VT_LVAL;
			v1.c.i = fc;
			fr = r;
			if (!(reg_classes[fr] & (RC_INT|RC_R11)))
				fr = get_reg(RC_INT);
			load(fr, &v1);
		}
		if (fc != sv->c.i) {
			/* If the addends doesn't fit into a 32bit signed
				       we must use a 64bit move.  We've checked above
				       that this doesn't have a sym associated.  */

			v1.type.t = VT_LLONG;
			v1.r = VT_CONST;
			v1.c.i = sv->c.i;
			fr = r;
			if (!(reg_classes[fr] & (RC_INT|RC_R11)))
				fr = get_reg(RC_INT);
			load(fr, &v1);
			fc = 0;
		}
		ll = 0;
		/* Like GCC we can load from small enough properly sized
			   structs and unions as well.
			   XXX maybe move to generic operand handling, but should
			   occur only with asm, so tccasm.c might also be a better place */

		if ((ft & VT_BTYPE) == VT_STRUCT) {
			int align;
			switch (type_size(&sv->type, &align)) {
			case 1:
				ft = VT_BYTE;
				break;
			case 2:
				ft = VT_SHORT;
				break;
			case 4:
				ft = VT_INT;
				break;
			case 8:
				ft = VT_LLONG;
				break;
			default:
				tcc_error("invalid aggregate type for register load");
				break;
			}
		}
		if ((ft & VT_BTYPE) == VT_FLOAT) {
			b = 0x6e0f66;
			r = REG_VALUE(r);/* movd */

		} else if ((ft & VT_BTYPE) == VT_DOUBLE) {
			b = 0x7e0ff3;/* movq */

			r = REG_VALUE(r);
		} else if ((ft & VT_BTYPE) == VT_LDOUBLE) {
			b = 0xdb, r = 5;/* fldt */

		} else if ((ft & VT_TYPE) == VT_BYTE || (ft & VT_TYPE) == VT_BOOL) {
			b = 0xbe0f;/* movsbl */

		} else if ((ft & VT_TYPE) == (VT_BYTE | VT_UNSIGNED)) {
			b = 0xb60f;/* movzbl */

		} else if ((ft & VT_TYPE) == VT_SHORT) {
			b = 0xbf0f;/* movswl */

		} else if ((ft & VT_TYPE) == (VT_SHORT | VT_UNSIGNED)) {
			b = 0xb70f;/* movzwl */

		} else if ((ft & VT_TYPE) == (VT_VOID)) {
			/* Can happen with zero size structs */

			return;
		} else {
			assert(((ft & VT_BTYPE) == VT_INT)
			       || ((ft & VT_BTYPE) == VT_LLONG)
			       || ((ft & VT_BTYPE) == VT_PTR)
			       || ((ft & VT_BTYPE) == VT_FUNC)
			      );
			ll = is64_type(ft);
			b = 0x8b;
		}
		if (ll) {
			gen_modrm64(b, r, fr, sv->sym, fc);
		} else {
			orex(ll, fr, r, b);
			gen_modrm(r, fr, sv->sym, fc);
		}
	} else {
		if (v == VT_CONST) {
			if (fr & VT_SYM) {

				orex(1,0,r,0x8d);
				o(0x05 + REG_VALUE(r) * 8);/* lea xx(%rip), r */

				gen_addrpc32(fr, sv->sym, fc);
// 486 "x86_64-gen.c"
			} else if (is64_type(ft)) {
				if (sv->c.i >> 32) {
					orex(1,r,0, 0xb8 + REG_VALUE(r));/* movabs $xx, r */

					gen_le64(sv->c.i);
				} else if (sv->c.i > 0) {
					orex(0,r,0, 0xb8 + REG_VALUE(r));/* mov $xx, r */

					gen_le32(sv->c.i);
				} else {
					o(0xc031 + REG_VALUE(r) * 0x900);/* xor r, r */

				}
			} else {
				orex(0,r,0, 0xb8 + REG_VALUE(r));/* mov $xx, r */

				gen_le32(fc);
			}
		} else if (v == VT_LOCAL) {
			orex(1,0,r,0x8d);/* lea xxx(%ebp), r */

			gen_modrm(r, VT_LOCAL, sv->sym, fc);
		} else if (v == VT_CMP) {
			if (fc & 0x100) {
				v = vtop->cmp_r;
				fc &= ~0x100;
				/* This was a float compare.  If the parity bit is
						   set the result was unordered, meaning false for everything
						   except TOK_NE, and true for TOK_NE.  */

				orex(0, r, 0, 0xb0 + REG_VALUE(r));/* mov $0/1,%al */

				g(v ^ fc ^ (v == TOK_NE));
				o(0x037a + (REX_BASE(r) << 8));
			}
			orex(0,r,0, 0x0f);/* setxx %br */

			o(fc);
			o(0xc0 + REG_VALUE(r));
			orex(0,r,0, 0x0f);
			o(0xc0b6 + REG_VALUE(r) * 0x900);/* movzbl %al, %eax */

		} else if (v == VT_JMP || v == VT_JMPI) {
			t = v & 1;
			orex(0,r,0,0);
			oad(0xb8 + REG_VALUE(r), t);/* mov $1, r */

			o(0x05eb + (REX_BASE(r) << 8));/* jmp after */

			gsym(fc);
			orex(0,r,0,0);
			oad(0xb8 + REG_VALUE(r), t ^ 1);/* mov $0, r */

		} else if (v != r) {
			if ((r >= TREG_XMM0) && (r <= TREG_XMM7)) {
				if (v == TREG_ST0) {
					/* gen_cvt_ftof(VT_DOUBLE); */

					o(0xf0245cdd);/* fstpl -0x10(%rsp) */

					/* movsd -0x10(%rsp),%xmmN */

					o(0x100ff2);
					o(0x44 + REG_VALUE(r)*8);/* %xmmN */

					o(0xf024);
				} else {
					assert((v >= TREG_XMM0) && (v <= TREG_XMM7));
					if ((ft & VT_BTYPE) == VT_FLOAT) {
						o(0x100ff3);
					} else {
						assert((ft & VT_BTYPE) == VT_DOUBLE);
						o(0x100ff2);
					}
					o(0xc0 + REG_VALUE(v) + REG_VALUE(r)*8);
				}
			} else if (r == TREG_ST0) {
				assert((v >= TREG_XMM0) && (v <= TREG_XMM7));
				/* gen_cvt_ftof(VT_LDOUBLE); */
				/* movsd %xmmN,-0x10(%rsp) */

				o(0x110ff2);
				o(0x44 + REG_VALUE(r)*8);/* %xmmN */

				o(0xf024);
				o(0xf02444dd);/* fldl -0x10(%rsp) */

			} else {
				orex(is64_type(ft), r, v, 0x89);
				o(0xc0 + REG_VALUE(r) + REG_VALUE(v) * 8);/* mov v, r */

			}
		}
	}
}
/* store register 'r' in lvalue 'v' */

void store(int r, SValue *v)
{
	int fr, bt, ft, fc;
	int op64 = 0;
	/* store the REX prefix in this variable when PIC is enabled */

	int pic = 0;

	fr = v->r & VT_VALMASK;
	ft = v->type.t;
	fc = v->c.i;
	if (fc != v->c.i && (fr & VT_SYM))
		tcc_error("64 bit addend in store");
	ft &= ~(VT_VOLATILE | VT_CONSTANT);
	bt = ft & VT_BTYPE;
	/* XXX: incorrect if float reg to reg */
// 592 "x86_64-gen.c"
	if (bt == VT_FLOAT) {
		o(0x66);
		o(pic);
		o(0x7e0f);/* movd */

		r = REG_VALUE(r);
	} else if (bt == VT_DOUBLE) {
		o(0x66);
		o(pic);
		o(0xd60f);/* movq */

		r = REG_VALUE(r);
	} else if (bt == VT_LDOUBLE) {
		o(0xc0d9);/* fld %st(0) */

		o(pic);
		o(0xdb);/* fstpt */

		r = 7;
	} else {
		if (bt == VT_SHORT)
			o(0x66);
		o(pic);
		if (bt == VT_BYTE || bt == VT_BOOL)
			orex(0, 0, r, 0x88);
		else if (is64_type(bt))
			op64 = 0x89;
		else
			orex(0, 0, r, 0x89);
	}
	if (pic) {
		/* xxx r, (%r11) where xxx is mov, movq, fld, or etc */

		if (op64)
			o(op64);
		o(3 + (r << 3));
	} else if (op64) {
		if (fr == VT_CONST || fr == VT_LOCAL || (v->r & VT_LVAL)) {
			gen_modrm64(op64, r, v->r, v->sym, fc);
		} else if (fr != r) {
			orex(1, fr, r, op64);
			o(0xc0 + fr + r * 8);/* mov r, fr */

		}
	} else {
		if (fr == VT_CONST || fr == VT_LOCAL || (v->r & VT_LVAL)) {
			gen_modrm(r, v->r, v->sym, fc);
		} else if (fr != r) {
			o(0xc0 + fr + r * 8);/* mov r, fr */

		}
	}
}
/* 'is_jmp' is '1' if it is a jump */

static void gcall_or_jmp(int is_jmp)
{
	int r;
	if ((vtop->r & (VT_VALMASK | VT_LVAL)) == VT_CONST &&
	    ((vtop->r & VT_SYM) && (vtop->c.i-4) == (int)(vtop->c.i-4))) {
		/* constant symbolic case -> simple relocation */

		greloca(cur_text_section, vtop->sym, ind + 1, R_X86_64_PLT32,
			(int)(vtop->c.i-4));
		oad(0xe8 + is_jmp, 0);/* call/jmp im */

	} else {
		/* otherwise, indirect call */

		r = TREG_R11;
		load(r, vtop);
		o(0x41);/* REX */

		o(0xff);/* call/jmp *r */

		o(0xd0 + REG_VALUE(r) + (is_jmp << 4));
	}
}
#if defined(CONFIG_TCC_BCHECK)

static void gen_bounds_call(int v)
{
	Sym *sym = external_helper_sym(v);
	oad(0xe8, 0);
	greloca(cur_text_section, sym, ind-4, R_X86_64_PLT32, -4);
}

#define TREG_FASTCALL_1 TREG_RCX

static void gen_bounds_prolog(void)
{
	/* leave some room for bound checking code */

	func_bound_offset = lbounds_section->data_offset;
	func_bound_ind = ind;
	func_bound_add_epilog = 0;
	o(0x0d8d48 + ((TREG_FASTCALL_1 == TREG_RDI) *
		      0x300000)); /*lbound section pointer */

	gen_le32 (0);
	oad(0xb8, 0); /* call to function */

}

static void gen_bounds_epilog(void)
{
	addr_t saved_ind;
	addr_t *bounds_ptr;
	Sym *sym_data;
	int offset_modified = func_bound_offset != lbounds_section->data_offset;

	if (!offset_modified && !func_bound_add_epilog)
		return;

	/* add end of table info */

	bounds_ptr = section_ptr_add(lbounds_section, sizeof(addr_t));
	*bounds_ptr = 0;

	sym_data = get_sym_ref(&char_pointer_type, lbounds_section,
			       func_bound_offset, PTR_SIZE);

	/* generate bound local allocation */

	if (offset_modified) {
		saved_ind = ind;
		ind = func_bound_ind;
		greloca(cur_text_section, sym_data, ind + 3, R_X86_64_PC32, -4);
		ind = ind + 7;
		gen_bounds_call(TOK___bound_local_new);
		ind = saved_ind;
	}

	/* generate bound check local freeing */

	o(0x5250); /* save returned value, if any */

	o(0x20ec8348); /* sub $32,%rsp */

	o(0x290f); /* movaps %xmm0,0x10(%rsp) */

	o(0x102444);
	o(0x240c290f); /* movaps %xmm1,(%rsp) */

	greloca(cur_text_section, sym_data, ind + 3, R_X86_64_PC32, -4);
	o(0x0d8d48 + ((TREG_FASTCALL_1 == TREG_RDI) *
		      0x300000)); /* lea xxx(%rip), %rcx/rdi */

	gen_le32 (0);
	gen_bounds_call(TOK___bound_local_delete);
	o(0x280f); /* movaps 0x10(%rsp),%xmm0 */

	o(0x102444);
	o(0x240c280f); /* movaps (%rsp),%xmm1 */

	o(0x20c48348); /* add $32,%rsp */

	o(0x585a); /* restore returned value, if any */

}
#endif
// 731 "x86_64-gen.c"
#define REGN 4
static const uint8_t arg_regs[REGN] = {
	TREG_RCX, TREG_RDX, TREG_R8, TREG_R9
};
/* Prepare arguments in R10 and R11 rather than RCX and RDX
   because gv() will not ever use these */

static int arg_prepare_reg(int idx)
{
	if (idx == 0 || idx == 1)
		/* idx=0: r10, idx=1: r11 */

		return idx + 10;
	else
		return idx >= 0 && idx < REGN ? arg_regs[idx] : 0;
}
/* Generate function call. The function address is pushed first, then
   all the parameters in call order. This functions pops all the
   parameters and the function address. */

static void gen_offs_sp(int b, int r, int d)
{
	orex(1,0,r & 0x100 ? 0 : r, b);
	if (d == (char)d) {
		o(0x2444 | (REG_VALUE(r) << 3));
		g(d);
	} else {
		o(0x2484 | (REG_VALUE(r) << 3));
		gen_le32(d);
	}
}

static int using_regs(int size)
{
	return !(size > 8 || (size & (size - 1)));
}
/* Return the number of registers needed to return the struct, or 0 if
   returning via struct pointer. */

ST_FUNC int gfunc_sret(CType *vt, int variadic, CType *ret, int *ret_align,
		       int *regsize)
{
	int size, align;
	*ret_align = 1;// Never have to re-align return values for x86-64

	*regsize = 8;
	size = type_size(vt, &align);
	if (!using_regs(size))
		return 0;
	if (size == 8)
		ret->t = VT_LLONG;
	else if (size == 4)
		ret->t = VT_INT;
	else if (size == 2)
		ret->t = VT_SHORT;
	else
		ret->t = VT_BYTE;
	ret->ref = NULL;
	return 1;
}

static int is_sse_float(int t)
{
	int bt;
	bt = t & VT_BTYPE;
	return bt == VT_DOUBLE || bt == VT_FLOAT;
}

static int gfunc_arg_size(CType *type)
{
	int align;
	if (type->t & (VT_ARRAY|VT_BITFIELD))
		return 8;
	return type_size(type, &align);
}

void gfunc_call(int nb_args)
{
	int size, r, args_size, i, d, bt, struct_size;
	int arg;
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gbound_args(nb_args);
#endif

	args_size = (nb_args < REGN ? REGN : nb_args) * PTR_SIZE;
	arg = nb_args;
	/* for struct arguments, we need to call memcpy and the function
	       call breaks register passing arguments we are preparing.
	       So, we process arguments which will be passed by stack first. */

	struct_size = args_size;
	for (i = 0; i < nb_args; i++) {
		SValue *sv;

		--arg;
		sv = &vtop[-i];
		bt = (sv->type.t & VT_BTYPE);
		size = gfunc_arg_size(&sv->type);

		if (using_regs(size))
			continue;/* arguments smaller than 8 bytes passed in registers or on stack */

		if (bt == VT_STRUCT) {
			/* align to stack align size */

			size = (size + 15) & ~15;
			/* generate structure store */

			r = get_reg(RC_INT);
			gen_offs_sp(0x8d, r, struct_size);
			struct_size += size;
			/* generate memcpy call */

			vset(&sv->type, r | VT_LVAL, 0);
			vpushv(sv);
			vstore();
			--vtop;
		} else if (bt == VT_LDOUBLE) {
			gv(RC_ST0);
			gen_offs_sp(0xdb, 0x107, struct_size);
			struct_size += 16;
		}
	}

	if (func_scratch < struct_size)
		func_scratch = struct_size;

	arg = nb_args;
	struct_size = args_size;

	for (i = 0; i < nb_args; i++) {
		--arg;
		bt = (vtop->type.t & VT_BTYPE);

		size = gfunc_arg_size(&vtop->type);
		if (!using_regs(size)) {
			/* align to stack align size */

			size = (size + 15) & ~15;
			if (arg >= REGN) {
				d = get_reg(RC_INT);
				gen_offs_sp(0x8d, d, struct_size);
				gen_offs_sp(0x89, d, arg*8);
			} else {
				d = arg_prepare_reg(arg);
				gen_offs_sp(0x8d, d, struct_size);
			}
			struct_size += size;
		} else {
			if (is_sse_float(vtop->type.t)) {
				if (tcc_state->nosse)
					tcc_error("SSE disabled");
				if (arg >= REGN) {
					gv(RC_XMM0);
					/* movq %xmm0, j*8(%rsp) */

					gen_offs_sp(0xd60f66, 0x100, arg*8);
				} else {
					/* Load directly to xmmN register */

					gv(RC_XMM0 << arg);
					d = arg_prepare_reg(arg);
					/* mov %xmmN, %rxx */

					o(0x66);
					orex(1,d,0, 0x7e0f);
					o(0xc0 + arg*8 + REG_VALUE(d));
				}
			} else {
				if (bt == VT_STRUCT) {
					vtop->type.ref = NULL;
					vtop->type.t = size > 4 ? VT_LLONG : size > 2 ? VT_INT
						       : size > 1 ? VT_SHORT : VT_BYTE;
				}

				r = gv(RC_INT);
				if (arg >= REGN) {
					gen_offs_sp(0x89, r, arg*8);
				} else {
					d = arg_prepare_reg(arg);
					orex(1,d,r,0x89);/* mov */

					o(0xc0 + REG_VALUE(r) * 8 + REG_VALUE(d));
				}
			}
		}
		vtop--;
	}
	save_regs(0);
	/* Copy R10 and R11 into RCX and RDX, respectively */

	if (nb_args > 0) {
		o(0xd1894c);/* mov %r10, %rcx */

		if (nb_args > 1) {
			o(0xda894c);/* mov %r11, %rdx */

		}
	}

	gcall_or_jmp(0);

	if ((vtop->r & VT_SYM) && vtop->sym->v == TOK_alloca) {
		/* need to add the "func_scratch" area after alloca */

		o(0x48);
		func_alloca = oad(0x05, func_alloca);/* add $NN, %rax */

#ifdef CONFIG_TCC_BCHECK

		if (tcc_state->do_bounds_check)
			gen_bounds_call(TOK___bound_alloca_nr); /* new region */

#endif

	}
	vtop--;
}

#define FUNC_PROLOG_SIZE 11
/* generate function prolog of type 't' */

void gfunc_prolog(Sym *func_sym)
{
	CType *func_type = &func_sym->type;
	int addr, reg_param_index, bt, size;
	Sym *sym;
	CType *type;

	func_ret_sub = 0;
	func_scratch = 32;
	func_alloca = 0;
	loc = 0;

	addr = PTR_SIZE * 2;
	ind += FUNC_PROLOG_SIZE;
	func_sub_sp_offset = ind;
	reg_param_index = 0;

	sym = func_type->ref;
	/* if the function returns a structure, then add an
	       implicit pointer parameter */

	size = gfunc_arg_size(&func_vt);
	if (!using_regs(size)) {
		gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
		func_vc = addr;
		reg_param_index++;
		addr += 8;
	}
	/* define parameters */

	while ((sym = sym->next) != NULL) {
		type = &sym->type;
		bt = type->t & VT_BTYPE;
		size = gfunc_arg_size(type);
		if (!using_regs(size)) {
			if (reg_param_index < REGN) {
				gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
			}
			sym_push(sym->v & ~SYM_FIELD, type,
				 VT_LLOCAL | VT_LVAL, addr);
		} else {
			if (reg_param_index < REGN) {
				/* save arguments passed by register */

				if ((bt == VT_FLOAT) || (bt == VT_DOUBLE)) {
					if (tcc_state->nosse)
						tcc_error("SSE disabled");
					o(0xd60f66);/* movq */

					gen_modrm(reg_param_index, VT_LOCAL, NULL, addr);
				} else {
					gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
				}
			}
			sym_push(sym->v & ~SYM_FIELD, type,
				 VT_LOCAL | VT_LVAL, addr);
		}
		addr += 8;
		reg_param_index++;
	}

	while (reg_param_index < REGN) {
		if (func_var) {
			gen_modrm64(0x89, arg_regs[reg_param_index], VT_LOCAL, NULL, addr);
			addr += 8;
		}
		reg_param_index++;
	}
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gen_bounds_prolog();
#endif

}
/* generate function epilog */

void gfunc_epilog(void)
{
	int v, start;
	/* align local size to word & save local variables */

	func_scratch = (func_scratch + 15) & -16;
	loc = (loc & -16) - func_scratch;
#ifdef CONFIG_TCC_BCHECK

	if (tcc_state->do_bounds_check)
		gen_bounds_epilog();
#endif

	o(0xc9);/* leave */

	if (func_ret_sub == 0) {
		o(0xc3);/* ret */

	} else {
		o(0xc2);/* ret n */

		g(func_ret_sub);
		g(func_ret_sub >> 8);
	}

	v = -loc;
	start = func_sub_sp_offset - FUNC_PROLOG_SIZE;
	cur_text_section->data_offset = ind;
	pe_add_unwind_data(start, ind, v);

	ind = start;
	if (v >= 4096) {
		Sym *sym = external_helper_sym(TOK___chkstk);
		oad(0xb8, v);/* mov stacksize, %eax */

		oad(0xe8, 0);/* call __chkstk, (does the stackframe too) */

		greloca(cur_text_section, sym, ind-4, R_X86_64_PLT32, -4);
		o(0x90);/* fill for FUNC_PROLOG_SIZE = 11 bytes */

	} else {
		o(0xe5894855);/* push %rbp, mov %rsp, %rbp */

		o(0xec8148);/* sub rsp, stacksize */

		gen_le32(v);
	}
	ind = cur_text_section->data_offset;
	/* add the "func_scratch" area after each alloca seen */

	gsym_addr(func_alloca, -func_scratch);
}
/* not PE */
// 1631 "x86_64-gen.c"
ST_FUNC void gen_fill_nops(int bytes)
{
	while (bytes--)
		g(0x90);
}
/* generate a jump to a label */

int gjmp(int t)
{
	return gjmp2(0xe9, t);
}
/* generate a jump to a fixed address */

void gjmp_addr(int a)
{
	int r;
	r = a - ind - 2;
	if (r == (char)r) {
		g(0xeb);
		g(r);
	} else {
		oad(0xe9, a - ind - 5);
	}
}

ST_FUNC int gjmp_append(int n, int t)
{
	void *p;
	/* insert vtop->c jump list in t */

	if (n) {
		uint32_t n1 = n, n2;
		while ((n2 = read32le(p = cur_text_section->data + n1)))
			n1 = n2;
		write32le(p, t);
		t = n;
	}
	return t;
}

ST_FUNC int gjmp_cond(int op, int t)
{
	if (op & 0x100) {
		/* This was a float compare.  If the parity flag is set
			       the result was unordered.  For anything except != this
			       means false and we don't jump (anding both conditions).
			       For != this means true (oring both).
			       Take care about inverting the test.  We need to jump
			       to our target if the result was unordered and test wasn't NE,
			       otherwise if unordered we don't want to jump.  */

		int v = vtop->cmp_r;
		op &= ~0x100;
		if (op ^ v ^ (v != TOK_NE))
			o(0x067a);/* jp +6 */

		else {
			g(0x0f);
			t = gjmp2(0x8a, t);/* jp t */

		}
	}
	g(0x0f);
	t = gjmp2(op - 16, t);
	return t;
}
/* generate an integer binary operation */

void gen_opi(int op)
{
	int r, fr, opc, c;
	int ll, uu, cc;

	ll = is64_type(vtop[-1].type.t);
	uu = (vtop[-1].type.t & VT_UNSIGNED) != 0;
	cc = (vtop->r & (VT_VALMASK | VT_LVAL | VT_SYM)) == VT_CONST;

	switch (op) {
	case '+':
	case TOK_ADDC1:/* add with carry generation */

		opc = 0;
gen_op8:
		if (cc && (!ll || (int)vtop->c.i == vtop->c.i)) {
			/* constant case */

			vswap();
			r = gv(RC_INT);
			vswap();
			c = vtop->c.i;
			if (c == (char)c) {
				/* XXX: generate inc and dec for smaller code ? */

				orex(ll, r, 0, 0x83);
				o(0xc0 | (opc << 3) | REG_VALUE(r));
				g(c);
			} else {
				orex(ll, r, 0, 0x81);
				oad(0xc0 | (opc << 3) | REG_VALUE(r), c);
			}
		} else {
			gv2(RC_INT, RC_INT);
			r = vtop[-1].r;
			fr = vtop[0].r;
			orex(ll, r, fr, (opc << 3) | 0x01);
			o(0xc0 + REG_VALUE(r) + REG_VALUE(fr) * 8);
		}
		vtop--;
		if (op >= TOK_ULT && op <= TOK_GT)
			vset_VT_CMP(op);
		break;
	case '-':
	case TOK_SUBC1:/* sub with carry generation */

		opc = 5;
		goto gen_op8;
	case TOK_ADDC2:/* add with carry use */

		opc = 2;
		goto gen_op8;
	case TOK_SUBC2:/* sub with carry use */

		opc = 3;
		goto gen_op8;
	case '&':
		opc = 4;
		goto gen_op8;
	case '^':
		opc = 6;
		goto gen_op8;
	case '|':
		opc = 1;
		goto gen_op8;
	case '*':
		gv2(RC_INT, RC_INT);
		r = vtop[-1].r;
		fr = vtop[0].r;
		orex(ll, fr, r, 0xaf0f);/* imul fr, r */

		o(0xc0 + REG_VALUE(fr) + REG_VALUE(r) * 8);
		vtop--;
		break;
	case TOK_SHL:
		opc = 4;
		goto gen_shift;
	case TOK_SHR:
		opc = 5;
		goto gen_shift;
	case TOK_SAR:
		opc = 7;
gen_shift:
		opc = 0xc0 | (opc << 3);
		if (cc) {
			/* constant case */

			vswap();
			r = gv(RC_INT);
			vswap();
			orex(ll, r, 0, 0xc1);/* shl/shr/sar $xxx, r */

			o(opc | REG_VALUE(r));
			g(vtop->c.i & (ll ? 63 : 31));
		} else {
			/* we generate the shift in ecx */

			gv2(RC_INT, RC_RCX);
			r = vtop[-1].r;
			orex(ll, r, 0, 0xd3);/* shl/shr/sar %cl, r */

			o(opc | REG_VALUE(r));
		}
		vtop--;
		break;
	case TOK_UDIV:
	case TOK_UMOD:
		uu = 1;
		goto divmod;
	case '/':
	case '%':
	case TOK_PDIV:
		uu = 0;
divmod:
		/* first operand must be in eax */
		/* XXX: need better constraint for second operand */

		gv2(RC_RAX, RC_RCX);
		r = vtop[-1].r;
		fr = vtop[0].r;
		vtop--;
		save_reg(TREG_RDX);
		orex(ll, 0, 0, uu ? 0xd231 : 0x99);/* xor %edx,%edx : cqto */

		orex(ll, fr, 0, 0xf7);/* div fr, %eax */

		o((uu ? 0xf0 : 0xf8) + REG_VALUE(fr));
		if (op == '%' || op == TOK_UMOD)
			r = TREG_RDX;
		else
			r = TREG_RAX;
		vtop->r = r;
		break;
	default:
		opc = 7;
		goto gen_op8;
	}
}

void gen_opl(int op)
{
	gen_opi(op);
}
/* generate a floating point operation 'v = t1 op t2' instruction. The
   two operands are guaranteed to have the same floating point type */
/* XXX: need to use ST1 too */

void gen_opf(int op)
{
	int a, ft, fc, swapped, r;
	int bt = vtop->type.t & VT_BTYPE;
	int float_type = bt == VT_LDOUBLE ? RC_ST0 : RC_FLOAT;

	if (op == TOK_NEG) {/* unary minus */

		gv(float_type);
		if (float_type == RC_ST0) {
			o(0xe0d9);/* fchs */

		} else {
			save_reg(vtop->r);
			o(0x80);/* xor $0x80, $n(rbp) */

			gen_modrm(6, vtop->r, NULL, vtop->c.i + (bt == VT_DOUBLE ? 7 : 3));
			o(0x80);
		}
		return;
	}
	/* convert constants to memory references */

	if ((vtop[-1].r & (VT_VALMASK | VT_LVAL)) == VT_CONST) {
		vswap();
		gv(float_type);
		vswap();
	}
	if ((vtop[0].r & (VT_VALMASK | VT_LVAL)) == VT_CONST)
		gv(float_type);
	/* must put at least one value in the floating point register */

	if ((vtop[-1].r & VT_LVAL) &&
	    (vtop[0].r & VT_LVAL)) {
		vswap();
		gv(float_type);
		vswap();
	}
	swapped = 0;
	/* swap the stack if needed so that t1 is the register and t2 is
	       the memory reference */

	if (vtop[-1].r & VT_LVAL) {
		vswap();
		swapped = 1;
	}
	if ((vtop->type.t & VT_BTYPE) == VT_LDOUBLE) {
		if (op >= TOK_ULT && op <= TOK_GT) {
			/* load on stack second operand */

			load(TREG_ST0, vtop);
			save_reg(TREG_RAX);/* eax is used by FP comparison code */

			if (op 