#include "cpu/instr.h"
/*
Put the implementations of `sub' instructions here.
*/

static void instr_execute_2op()
{
    operand_read(&opr_src);
    operand_read(&opr_dest);
    
    opr_src.val = sign_ext(opr_src.val, opr_src.data_size);
    opr_dest.val = sign_ext(opr_dest.val,opr_dest.data_size);
    
    opr_dest.val = alu_sub(opr_src.val, opr_dest.val, data_size);
    operand_write(&opr_dest);
}

make_instr_impl_2op(sub, i, rm, bv)
make_instr_impl_2op(sub,r,rm,v)//0x01
make_instr_impl_2op(sub,r,rm,b)//0x00
make_instr_impl_2op(sub,rm,r,b)//0x02
make_instr_impl_2op(sub,rm,r,v)//0x03
make_instr_impl_2op(sub,i,a,b)
make_instr_impl_2op(sub,i,a,v)


make_instr_impl_2op(sub,i,rm,b)
make_instr_impl_2op(sub,i,rm,v)