# 音频资源

利用音视频资源进行跟读训练是 Enjoy 的核心功能之一。

## 添加音频资源

Enjoy 支持添加本地的音频资源，和在线资源。在音频页面，点击 `添加资源`，在弹窗中输入网址，或者点击 `本地文件` 选择本地计算机的音频文件即可添加。

如果是在线资源，Enjoy 会将文件下载至默认的下载文件夹（`Downdoads` 或者 `我的下载`），然后再自动添加至 [资源库](./settings#资源库保存路径)。

## 跟读音频

添加成功后，会自动跳转至音频播放页面。

打开时，需要先解析音频波形数据（并生成 Pitch contour）和生成音频字幕（使用 [语音转文本服务](./settings#语音转文本服务)）。首次打开时，可能需要等待一些时间。所需数据生成成功之后，后续再次打开时的速度会比较快。

::: tip 卡在加载页面怎么办？
打开音频页面时，会先按照以下步骤进行加载：

1. 解析音频波形数据
2. 语音转文本

如果长时间卡在第一步，可能是因为音频太大（主要跟音频时长有关）导致加载时间过长，甚至失败。如果不是音频大小的原因，可能是出现了其他 bug，请联系开发者。

如果第二步语音转文本失败，请检查是否在正在使用本地 whisper 组件进行语音转文本，在某些电脑上可能因为兼容性和未知问题导致无法使用。如果出现这种情况，请在 [语音转文本服务设置](./settings#语音转文本服务) 中改用其他语音转文本的云服务。
:::

## 播放

点击播放键(或者快捷键 <kbd>Space</kbd>)即可播放或者暂停音频。

Enjoy 会将音频按照句子切分，默认播放模式为“播放单句”，以便逐句反复听练。

其他可选的播放模式有：

- 单句循环
- 播放所有

## 智能断句

Enjoy 按照原音的停顿和标点符号，将当前句子分成几个断句，以便逐一反复练习。

你也可以通过点击当前句子的任意词语（或同时按下 <kbd>Shift</kbd> 进行多选）进行选中单词或者短语，进行听练。

## 录音

Enjoy 会将音频按照句子切分，用户以句子为单位进行跟读练习。在激活的音频句子下，点击红色的录音按钮(或者快捷键 <kbd>r</kbd>)，即可开始录音，用户可以模仿音频朗读当前句子作为练习。

![音频播放页面](/images/enjoy/audio-page.png)
_\* 音频播放页面_

::: tip 录音权限
在 Mac 电脑上，首次使用录音功能时，会弹窗请求麦克风的使用权限，请务必点允许，否则无法使用录音功能。
:::

## 录音对比

将录音的 Pitch contour 与原音对比，以便自纠发音。对比状态下，按下播放键，会同时播放录音和原音。

![录音对比](/images/enjoy/recording-comparing.png)
_\* 录音于原音对比_

## 发音评估

Enjoy 集成了微软 Azure 的发音评估功能，作为自我的发音检查参考。

该功能会以**录音时的句子文本作为参考**，评估录音的发音情况，各指标的详细说明可以参考微软的 [官方文档](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/how-to-pronunciation-assessment?pivots=programming-language-javascript#scripted-assessment-results)。

![发音评估示例](/images/enjoy/pronouce-assessment.png)
_\* 发音评估示例_

::: warning 发音评估的使用建议
该功能是收费功能，每次使用均会在 Enjoy 账户的余额扣费，如果余额不足则需要 [充值](./settings#充值) 后才可继续使用。

值得注意的是，发音评估更侧重于单词的发音是否正确，无法评估音调变化是否正确。
:::

## 修改音频信息

在音频页面上方，切换至列表模式，即可以对音频进行修改操作，例如修改音频标题，添加描述，和删除音频等。
