# 与智能体对话

## 新建智能体

在 `聊天` 页面左侧栏右上角，点 `+` 按钮，弹出添加智能体对话框。

目前 Enjoy 的智能体支持两种类别：

- GPT
- TTS

GPT 智能体可以通过设定不同的提示语，扮演不同的角色，与用户进行文本对话。

TTS 智能体可以将用户输入的文本转换为语音，可以设定不同的语言和音色。

### GPT 智能体

当选择 GPT 类别时，Enjoy 内置了部分提示语的模板，可以从 `模板` 中选择。

![chat-gpt-select-template](/images/enjoy/chat-gpt-select-template.png)

选择任意模板后，智能体名称、描述、提示语会自动填充，也可以根据具体需求进行修改。

点 `保存` 按钮，智能体即创建成功。

### TTS 智能体

当选择 TTS 类别时，除了名称和描述，还需要对 TTS 进行配置。

- 语音引擎： 如果想使用自备 OpenAI 密钥，可以选择 `OpenAI`，否则选择 `EnjoyAI`。
- 语音模型： 当使用 `EnjoyAI` 时，支持 OpenAI 的两个模型，以及 `Azure/Speech`，后者支持更多语言和口音；
- TTS 语言： 仅对 `Azure/Speech` 有效，支持更多语言和口音；
- 语音音色： 当使用 `Azure/Speech` 时，不用语言对应多种音色，选择即可。

![chat-tts-config](/images/enjoy/chat-tts-agent.png)

点 `保存` 按钮，智能体即创建成功。

## 新建聊天

选择任意智能体，在左侧栏下点击 `新聊天` 按钮，即可开始对话。

GPT 智能体会根据**提示语的设定**回答用户的**任何问题**。

![chat-new-chat-gpt](/images/enjoy/chat-new-chat-gpt.png)

TTS 智能体会把用户输入的任意文本转换为语音。

![chat-new-chat-tts](/images/enjoy/chat-new-chat-tts.png)

## 聊天设置

在聊天中，点击右上角齿轮图标，可以对聊天、当前聊天成员进行详细设置。

![chat-settings](/images/enjoy/chat-settings.png)

::: info 提示

在聊天设置中，可以设置 `额外提示语`，该提示语将会被聊天中的所有智能体共享，作为聊天成员额外的 `SYSTEM PRMOPT`。

例如，如果你希望当前聊天限定在某个主题，可以通过聊天的 `额外提示语` 进行设置。

:::

## 聊天成员设置

当智能体被添加至新聊天中时，均可以对其进行更详细的设置。其 LLM 设置默认值为 `软件设置` 中的 `默认 AI 模型`，TTS 设置默认值为 `软件设置` 中的 `默认 TTS 模型`。

![chat-member-settings](/images/enjoy/chat-member-settings.png)

::: info 提示

在聊天成员设置中，可以设置 `额外提示语`，与聊天设置中的 `额外提示语` 类似，但是该提示语仅对当前智能体生效。

例如，多个智能体正在当前聊天中辩论，你希望当前智能体在当前聊天中保持某个特定观点，可以通过聊天成员的 `额外提示语` 进行设置。

在 `提示语预览` 中，可以实时看到当前智能体在当前聊天中完整的 `SYSTEM PROMPT`，其中依次包含了 **聊天额外提示语**、**智能体自身的提示语** 和作为 **聊天成员的额外提示语**。

:::

## 语音输入

在聊天中，点击输入框左侧的麦克风图标，可以激活语音输入。

录音后，Enjoy 会使用配置的 STT 服务将语音转换成文本，消息不会自动发出，而是处于编辑状态。

如果识别的文本不正确，可以手动修改，如果录音不理想，也可以重新录音。如果对自己的表达不满意，可以点击 `修改润色`，AI 给出修改建议，然后可以重新录音。

![chat-refine](/images/enjoy/chat-refine.png)

当一切确认无误时，你可以点击 `发送` 按钮，将消息发出，等待 AI 的回复。

## 聊天建议

如果你想和 AI 进行对话练习，在 `聊天设置` 中可以勾选 `启用聊天助手`， 在输入框右侧会出现一个魔法棒图标，点击后，AI 会根据当前的聊天记录，给出对话建议。

![chat-suggest](/images/enjoy/chat-suggest.png)
