# 常见问题

## 总是报网络错误怎么办？

如果登录时报 `Network Error`，发音评估或者使用其他功能时报 `connect ETIMEDOUT` 错误，可以打开浏览器（不要在微信里打开），尝试打开 [https://enjoy.bot](https://enjoy.bot)。

如果无法打开，或者跳转到了其他不相关页面，说明您当前的网络无法连接上 Enjoy 的服务。

可以按照以下步骤解决：

1. [升级 Enjoy App](./install.md) 至 v0.3.2 以上；
2. 在登录页面，点 `高级设置`（如果已登录，点 `软件设置`/`高级设置`），修改 API 设置，填入 `https://api.getenjoyapp.com`，点保存。

软件自动重载后即可。

另一种办法就是使用代理服务。

## 为什么下载不了 YouTube 视频？

国内网络无法直接访问 YouTube。如果您使用了代理，但无法全局代理，可以在 Enjoy 的 软件设置/高级设置/代理设置 中配置。其中`代理地址`请从您使用的代理软件中获取，例如 `http://localhost:7890`。

## 为什么无法分享录音到社区广场？

分享录音之前，软件需要将录音上传值资源服务器，无法分享多数是因为网络原因导致无法链接资源服务器。可以在 Enjoy 的 软件设置/高级设置/网络状态 中查看资源服务器的连接情况。如果无法连接，请使用全局代理，或者在 软件设置/高级设置/代理设置 中设置代理。

## 如何多设备使用同一个帐号？

Enjoy App 的大部分数据均保存在本地（即您的计算机硬盘），具体来说，保存在一个名为 `EnjoyLibrary` 的文件夹里。

Enjoy 目前不提供云同步的服务。如果您需要在多个设备上使用 Enjoy App，建议使用网盘服务来同步数据。

以百度网盘为例，可以参考以下步骤使用：

1. 将 `/EnjoyLirary` 文件夹（即[资源库保存路径](./settings.md#资源库保存路径)）加入到百度网盘的同步列表中；
2. 每次使用完 Enjoy App，关机之前，确保 `/EnjoyLibrary` 文件夹全部同步完成；
3. 在第二部电脑上，利用网盘，将 `/EnjoyLibrary` 文件夹最新状态同步完成；
4. 在第二部电脑上，登录相同的 Enjoy 帐号使用；
5. 重复 2~4 步骤。

另外需要注意，在利用网盘同步的情况下，不要同一时间在不同设置使用相同的 Enjoy 帐号，这样会导致数据冲突。

## 怎样切换到 Enjoy AI？

如果您一开始使用自备的 OpenAI 密钥，想要切换至 Enjoy AI，可以参考以下步骤：

- 软件设置 / 基本设置 / 默认 AI 引擎，点`修改`按钮，将引擎改为 `Enjoy AI`；

如果您之前有在用智能助手，请注意智能助手的对话，AI 引擎是无法修改的。或者切换默认引擎之后，需要新建一个对话使用。

## 超过每日使用限额怎么办？

Enjoy 的新用户会自动发放一定的体验金，新用户可以无需充值即可体验 Enjoy 的收费服务，但同时还有一个每天使用次数的限制，超过后则会报错。

只要充值任意金额一次，即可解除限制。

## 自备 OpenAI 密钥，还需要充值吗？

Enjoy App 很多功能都基于 AI。为了方便用户使用，Enjoy 提供了 EnjoyAI 服务，集成了当下流行的大模型服务商和热门模型供选择，用户只需要在 Enjoy 充值后即可使用。

当然，Enjoy 也允许用户自定义服务商和密钥，此种情况下，Enjoy 不会收取任何费用。

但是，发音评估功能并非 OpenAI 提供的服务，是 Enjoy 的收费功能，使用前必须保证 Enjoy 账户有余额。

## 为什么本地语音转文本服务无法使用？

Enjoy 集成了 [whipser.cpp](https://github.com/ggerganov/whisper.cpp) 作为本地的语音转文本（STT）服务，但是由于兼容性的问题，某些配置较低或者操作系统版本较低的电脑无法使用。

如果您遇到这种情况，Enjoy 提供了其他 STT 的云服务，可以前往 [软件设置](./settings#语音转文本服务) 进行配置。推荐优先使用 Azure AI。

## 403 Insufficient balance

遇到这个报错，说明您正在使用 Enjoy 的付费功能，但是账户余额不足了。

Enjoy 内有很多功能都由 AI 驱动，比如[智能助手](./ai-assistant)、智能翻译、句子分析等。如果您在 [软件设置](./settings#默认-ai-引擎) 中的配置了 `OpenAI` 作为默认 AI 引擎，在使用这些功能时候，会使用您配置的 OpenAI 信息进行实现，不会涉及 Enjoy 的扣费。

（需要注意的是，[智能助手](./ai-assistant) 的对话一旦创建，AI 引擎无法修改。如果需要切换，比如由 Enjoy AI 换成 Open AI，则需要新建一个对话）

另外，[发音评估](./audios#发音评估) 是收费功能，并非 OpenAI 提供，所以无论 [默认 AI 引擎](./settings#默认-ai-引擎) 选了什么，使用发音评估时，总是会在 Enjoy 账户中扣费。

如果需要充值，请参考[充值](./settings#充值)。

## 如何下载音频、录音

Enjoy 提供了音频、视频、录音的下载功能，以便可以在其他设备使用。
