# 9. 自主计划

感觉上来看，我们生活在一个计划不如变化快的世界里。随着年龄的增加，大多数人可能通过总结错误的经验，误以为计划无用，甚至开始讨厌计划。

然而，在很多地方，计划不仅非常管用，也的确不可或缺。尤其是在学习的过程中更是如此，因为学习和生活最不一样的地方在于，前者不像后者那样充满了意外。与之相对的，练习更是如此 ——  **只要肯短时间内足量重复就一定奏效**，毫无例外。

最初的学习与练习计划可以非常简陋：

> 遇到每一个难点都要**生学硬练**，找到窍门掌握要点之后，再通过**短时间内足量重复**彻底攻克。

任务很简单，剩下的只不过是**安排时间**或者**挤出时间**。

由于**难点**这个东西相当**个性化**，于是每个人都一样，只能自己想办法**为自己设计专项练习**，而后**安排时间自己练习**…… 就是从这里开始，有自学能力的人和没有自学能力的人开始逐步**分化**。前者总是在日积月累，后者却长期滞留在某一处，只因为无法自理。

由于任何真正有用的技能，刚开始的时候都像是**迷宫**，所以，我们要一点一点探索，要反复衡量每一个可能的路径，要不断更新地图…… 在这个过程中所遇到的难点，最初看起来繁杂零落。然而，随着时间的推移，只要我们不断归纳总结，那些繁杂零落的要点终归会被逐步分门别类，于是，我们更容易做到心中有数。只要发现必要，就要重新练习重新验收。

安排时间或者挤出时间本身并不难，真正难的是**保持动力**。

以语音塑造为例。很多人即便是移民到英语国家，转眼五年十年过去，甚至更久，却依然口音浓重，更不用提其他相关且重要的语言能力。除了缺乏自我驱动、自我纠正、自我鼓励、自我监督之外，还有另外一个隐秘的原因 —— 没兴趣。

保持动力的秘密是培养、保持、强化**兴趣**。人都一样，若是对什么东西失去了兴趣，就没办法为之集中**注意力**，更别提学它练它了。兴趣是我们能够**完整执行**学习或训练计划的**发动机**。

很多父母也认同这个道理。所以他们在教育自家孩子之前，常常想办法先去培养孩子的兴趣。这个策略看起来不错，但结果却常常并不理想。兴趣这个东西，往往并不持久，孩子更是如此，他们对任何新鲜事物都感兴趣，但与此同时，他们也可以几乎瞬间之内就会变得对之彻底失去兴趣。

关键在于**兴趣**的**焦点**。

绝大多数人在这方面从未认真思考，于是，他们不假思索自然而然地把兴趣的焦点放在正在练习的项目上。他们会认为自己对某个项目感兴趣，于是有无穷无尽的动力去练习那个项目。与此同时，他们会认为自己对另外一些项目无兴趣，于是，完全没有动力去学习或者练习。

由此产生的分化如此普遍，乃至于人们看到的现象，一方面是，有些人能做好一些事情，却压根做不好另外一些事情；另外一方面是，有些人能做好一些事情，但另外一些人却无论如何都做不好。这个普遍的现象，是很多人产生了错觉，他们误以为，能把什么做好要靠**天分**。人们曾经关于标准音高的普遍误解，根源就来自于此。

实际上，**做得好，只是且只能是练得多、练得久、练得早的结果**。

无论练什么，对大脑来说，本质都是一样的，都是在大脑里用不完的神经元之间新建连接新建网络  —— 如果有可以回收循环利用的连接或网络当然更好。练得好，都一样，都说明通过短时间内足量重复新建了足够多足够强的新连接新网络。练不好或练得不够好，其实还都一样，只不过是没做到短时间内足量重复，或者没有把新建连接新建网络强化到近似连接近似网络无法与之竞争的地步 —— 仅此而已。

到最后都一样，无论练什么，精通程度（*<span class="pho">m</span>*, *mastery*）都是且只能是往多少时间（*<span class="pho">t</span>*, *time*）里倾注了多少注意力（*<span class="pho">a</span>*, *attention*）的结果：

> $m = ta$

其中，时间（*<span class="pho">t</span>*）和注意力（*<span class="pho">a</span>*）都一样，都需要**量足够多**，且**密度足够大**。于是，理论上来讲，能做好一件事的人，用同样的 *<span class="pho">ta</span>* 完全可以同样把任何另外一件事情做到同样精通的程度。

换言之，能踢足球踢到一定境界的人，用他曾经为此付出的 *<span class="pho">ta</span>*，即，往同样量足够多密度足够大的时间里倾注同样量足够多密度足够大的注意力，同样也能弹好钢琴，学好数学，或者说好另外一种语言。

更常见的是，如果一个人在某件事上能做到高度精通，即，*<span class="pho">m</span>* 值非常高，那么他在新学新练另外一件事的时候，虽然依然需要往量足够多密度足够大的时间里倾注量足够多密度足够大的注意力，但，往往需要的 *<span class="pho">ta</span>* 要比第一次少。

**大脑里没有孤岛**。所有的神经元都在同一个无垠的网络之中，每个连接每个局域网，都通过直接或者间接的方式相互连接。更为重要的是，任何技能拆解到一定程度之后，各个细节对应的连接或者网络，其实都可以被众多技能共享，不仅包括那些看起来像近的技能，也包括很多那些表面上看起来毫不关联的技能。

这就解释了为什么越是在某方面格外厉害的人就越发地多才多艺。你当然知道爱因斯坦会拉小提琴，可也许你并不知道的是，人家弹钢琴也同样技艺高超。

![](/images/einstein-playing-piano.png)

事实上，很多伟大的科学家都同时是艺术家，哥白尼、伽利略、麦克斯韦、费曼…… 有人调查过现代科学早期的总计 120 名科学家，其中有 61 名，即，一半以上，被认定为多才多艺的艺术家。有的化学家同时是画家，有的诗人同时是物理学家，有的音乐家同时是历史学家，更不用提你知道的那个无以伦比的天才，莱昂纳多·达芬奇…… 不一而足。所有的（不是几乎，而是所有的）科学家都有自己的业余爱好，且与那个他们为之知名的领域毫无关系……

![](/images/hidden-connection.png)

在科学界里，这种情况非常普遍 —— 从一个毫不相干的领域里突然出现另一个领域里的明星。经济学家出身的托马斯·叟（Thomas Sowell），因为自己的孩子六岁了还不开口说话，于是开始研究心理学，到最后写了篇论文，《聪明的孩子晚说话》，最终竟然成为心理学领域里被引用次数最多的论文之一（就是 Pagerank 极高）。而一个生理学教授，贾雷德·戴蒙德（Jared Mason Diamond），有研究鸟类的业余爱好，结果，在不断考察鸟类的过程中悟到了隐藏在人类发展史背后的另外一个线索，写了一本著名的书，《枪炮、病菌与钢铁：人类社会的命运》，随之开启了一个全新的学科，叫做 “地缘政治”…… 更不用提今天活跃在科技与商业世界里的埃隆·马斯克（Elon Musk）。

大脑是个网络，一切都是关联的，导致的结论不只是**无论学什么都有用**，更重要的是另外一个结论：**学的越多，已经学到的东西就更有用**。—— 这就是**网络效应**（Network effect），即，**梅特卡夫定律**（[Metcalfe' s law](https://en.wikipedia.org/?curid=65776)）：

> 网络中各个节点的价值与网络的节点数量的平方成正比……

也就是说，假设一个技能单独存在的价值是 *1*，但，它与其他 *4* 个技能形成一个网络的时候，那么，整个技能网络的价值，不仅仅是 *5*，可能要与网络节点数量的平方，5^2^，即与 *25* 成正比……

**学的越多学得越快越好越轻松**。

话说回来，我们需要调整我们自己所谓兴趣的**焦点**。

> 兴趣的焦点不应该放在某个**具象**的事物上，而是应该放到**进步**这个**抽象**的概念上。

也就是说，我们真正应该**痴迷**的是**进步**，是**改良**，而不仅仅是某个具体的事物。对大脑来说，不仅练什么都一样，进步或者改良也都一模一样，反正就是不断新建连接新建网络。

这是避开一切**半途而废**的秘密。一次又一次的半途而废，废掉的并不是某个学习目标，而是大脑里一个又一个破破烂烂被启用的烂连接烂网络，不仅没有任何循环利用价值，还不断妨碍新连接新网络的建立。并且，半途而废最终也会在大脑里形成一个网络，竞争力极强的网络，到最后，无论做什么，它都能胜出。懂了这个道理之后，无论是什么，不做倒罢了，只要做了，你怎么舍得半途而废，你怎么敢半途而废？

没有什么比建设自己的大脑皮层更令人痴迷的了吧？

若是带着这样不可剥夺的兴趣，不依赖任何具象事物，也不受任何人影响的兴趣，无论计划简单还是复杂，都只能坚定执行，贯彻到底，容不得任何人或事阻挠 —— 为了自己的脑子。
