# 3.2.12. <span class="pho">l</span>, <span class="pho">r</span>

## 3.2.12.1. 示例

<table>
<tbody>
<tr>
<td colspan="2"><strong>British</strong></td>
<td colspan="2"><strong>American</strong></td>
</tr>
<tr>
<td>D.J.</td>
<td>例词（Example）</td>
<td>IPA</td>
<td>例词（Example）</td>
</tr>
<tr>
<td><span class="pho">l</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_look_2023feb.mp3"></span></td>
<td><b>l</b>ure <span class="pho alt">lʊə</span><span class="speak-word-inline" data-audio-uk-female="/audios/lure-uk-female.mp3" data-audio-uk-male="/audios/lure-uk-male.mp3"></span></td>
<td><span class="pho">l</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_look_2023feb.mp3"></span></td>
<td><b>l</b>ure <span class="pho alt">lʊr</span><span class="speak-word-inline" data-audio-us-female="/audios/lure-us-female.mp3" data-audio-us-male="/audios/lure-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">r</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_run_2023feb.mp3"></span></td>
<td><b>r</b>edraw <span class="pho alt">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-uk-female="/audios/redraw-uk-female.mp3" data-audio-uk-male="/audios/redraw-uk-male.mp3"></span></td>
<td><span class="pho">r</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_run_2023feb.mp3"></span></td>
<td><b>r</b>edraw <span class="pho alt">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-us-female="/audios/redraw-us-female.mp3" data-audio-us-male="/audios/redraw-us-male.mp3"></span></td>
</tr>
</tbody>
</table>

## 3.2.12.2. 舌尖起始位置

<span class="pho">l</span> 发声时舌尖起始位置与 <span class="pho">t/d</span> 相同 —— 即，位置 ③：

<table>
<tbody>
<tr>
<td><img src="/images/articulator-tongue-tip-positions.svg"></img></td>
<td><img src="/images/articulator-tongue-tip-td.svg"></img></td>
</tr>
</tbody>
</table>

<span class="pho">r</span> 发声时舌尖起始位置相对更加靠后 —— 即，位置 ④：

<table>
<tbody>
<tr>
<td><img src="/images/articulator-tongue-tip-positions.svg"></img></td>
<td><img src="/images/articulator-tongue-tip-r.svg"></img></td>
</tr>
</tbody>
</table>

<span class="pho">l</span> 和 <span class="pho">r</span> 处于音节开头的时候，人们一般不会觉得困难，比如 *lot* <span class="pho alt">lɑːt</span><span class="speak-word-inline" data-audio-us-male="/audios/lot-us-male.mp3" data-audio-us-female="/audios/lot-us-female.mp3"></span> 或者 *rot* <span class="pho alt">rɑːt</span><span class="speak-word-inline" data-audio-us-male="/audios/rot-us-male.mp3" data-audio-us-female="/audios/rot-us-female.mp3"></span>……

## 3.2.12.3. 加音 <span class="pho">ᵊ</span>

<span class="pho">l</span> 的困难总是来自于它们处在音节末尾的时候。

不妨尝试着先读一下 *milk* <span class="pho alt">mɪlk</span><span class="speak-word-inline" data-audio-us-male="/audios/milk-us-male.mp3" data-audio-us-female="/audios/milk-us-female.mp3"></span>…… 很多人读出来的实际上是 <span class="pho alt">mjʊk</span>…… 另外一个发音类似的常用单词也常常被误读，*build* <span class="pho alt">bɪld</span> <span class="speak-word-inline" data-audio-us-male="/audios/build-us-male.mp3" data-audio-us-female="/audios/build-us-female.mp3"></span>，基本上总是被误读为 <span class="pho alt">bjʊld</span>。

<span class="pho">l</span> 在音节末尾的时候，有一个看不到的动作，舌尖会向前向上移动直至贴到龈脊。于是，音节末尾的 <span class="pho">l</span> 之前会有一个加音，轻微的 <span class="pho">ᵊ</span>。

说实话，倒也不是特别难，这只不过是几分钟就可以解决的问题。

> * 先反复说 <span class="pho">ə... əl... ə... əl...</span> 这里格外需要注意：嘴唇张开之后没有其它动作，**不要带嘴唇变化造成的 <span class="pho">ʊ</span> 的音色**；从 <span class="pho">ə</span> 到 <span class="pho">l</span> 的过程中，保持声带振动，剩余的全靠舌尖移动完成……
> * 接着直接反复说 <span class="pho">əl... əl...</span>
> * 再反复说 <span class="pho">əlk... əlk...</span>
> * 现在反复说 <span class="pho">mɪᵊlk... mɪᵊlk...</span> 

> [!Note]
> 需要格外注意的有两点：
> * <span class="pho">ɪ</span> 不是 <span class="pho">iː</span> 的简单化短版本（[3.1.3.2](3.1.3-i#_3-1-3-2-短元音-ɪ)），它更接近 <span class="pho">eɪ</span> 的短版本。于是，milk 是 <span class="pho alt">mɪlk</span>，不是 <span class="pho alt">milk</span>，你哪怕把它读成 <span class="pho alt">meɪlk</span> 都可能更准确一些 —— 只不过得想办法把 <span class="pho">eɪ</span> 读得短一点<span class="speak-word-inline" data-audio-us-male="/audios/milk-us-male.mp3" data-audio-us-female="/audios/milk-us-female.mp3"></span>……
> * <span class="pho">l</span> 这个音，在音节末尾的时候，舌尖有个向前移动至龈脊（位置 ③）的动作 —— 这个动作很重要，否则与它相关的连读就说不出来（[4.4.1](4.4-linking#_4-4-1-辅音-元音-consonant-vowel)）。很多人会用 <span class="pho">ʊ</span> 替代这个动作，比如，吧 *result* <span class="pho alt">rɪˈzəlt</span> 读成 <span class="pho alt">rɪˈzəʊt</span>；同样，<span class="pho alt">mɪlk</span> 也实际上被很多人读作 <span class="pho alt">mjʊk</span>…… 必须注意，音节末尾的 <span class="pho">l</span> 只有舌尖动作，**没有嘴唇动作**。再用同样的方式练练 *girl* <span class="pho alt">ɡɝːl</span><span class="speak-word-inline" data-audio-us-male="/audios/girl-us-male.mp3" data-audio-us-female="/audios/girl-us-female.mp3"></span>（常常会被误读成 <span class="pho alt">gəʊ</span>）, *world* <span class="pho alt">wɝːld</span><span class="speak-word-inline" data-audio-us-male="/audios/world-us-male.mp3" data-audio-us-female="/audios/world-us-female.mp3"></span>（常常会被误读成 <span class="pho alt">wəʊd</span>）。

以 <span class="pho">l</span> 处于音节末尾的常用词汇很多，读得时候要注意，要加上 <span class="pho">ᵊ</span>，比如：

> * *fail* <span class="pho alt">feɪl</span> ⭢ <span class="pho alt">feɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/fail-us-male.mp3" data-audio-us-female="/audios/fail-us-female.mp3"></span>
> * *file* <span class="pho alt">faɪl</span> ⭢ <span class="pho alt">faɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/file-us-male.mp3" data-audio-us-female="/audios/file-us-female.mp3"></span>
> * *sell* <span class="pho alt">sel</span> ⭢ <span class="pho alt">seᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/sell-us-male.mp3" data-audio-us-female="/audios/sell-us-female.mp3"></span>
> * *sale* <span class="pho alt">seɪl</span> ⭢ <span class="pho alt">seɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/sale-us-male.mp3" data-audio-us-female="/audios/sale-us-female.mp3"></span>
> * *tell* <span class="pho alt">tel</span> ⭢ <span class="pho alt">teᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/tell-us-male.mp3" data-audio-us-female="/audios/tell-us-female.mp3"></span>
> * *tale* <span class="pho alt">teɪl</span> ⭢ <span class="pho alt">teɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/tale-us-male.mp3" data-audio-us-female="/audios/tale-us-female.mp3"></span>
> * *trail* <span class="pho alt">treɪl</span> ⭢ <span class="pho alt">treɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/trail-us-male.mp3" data-audio-us-female="/audios/trail-us-female.mp3"></span>
> * *drill* <span class="pho alt">drɪl</span> ⭢ <span class="pho alt">drɪᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/drill-us-male.mp3" data-audio-us-female="/audios/drill-us-female.mp3"></span>

> [!Note]
> 
> <span class="pho alt">ʌl</span> 没有 <span class="pho">ᵊ</span> 的加音，因为 <span class="pho">ʌ</span> 和 <span class="pho">ə</span> 原本就非常相近。比如，*ultimate* <span class="pho alt">ˈʌltɪmət</span><span class="speak-word-inline" data-audio-us-male="/audios/ultimate-us-male.mp3" data-audio-us-female="/audios/ultimate-us-female.mp3"></span>，或者 *result* <span class="pho alt">rɪˈzəlt</span><span class="speak-word-inline" data-audio-us-male="/audios/result-us-male.mp3" data-audio-us-female="/audios/result-us-female.mp3"></span>。另外，在自然语流中，<span class="pho alt">iːl</span> 要注意。比如， *reveal*，词典里的音标是 <span class="pho alt">rɪˈviːl</span>， 但它的确读做 <span class="pho alt">rɪˈviːᵊl</span><span class="speak-word-inline" data-audio-us-male="/audios/reveal-us-male.mp3" data-audio-us-female="/audios/reveal-us-female.mp3"></span>，有加音 <span class="pho">ᵊ</span>，但，*revealing*，读作 <span class="pho alt">rɪˈviːlɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/revealing-us-male.mp3" data-audio-us-female="/audios/revealing-us-female.mp3"></span>，没有加音 <span class="pho">ᵊ</span>，可能是因为 <span class="pho">l</span> 被挪到后面和 <span class="pho">ɪŋ</span> 构成了第三个音节 <span class="pho alt">lɪŋ</span>……

<span class="pho">l</span> 在语言学里有个专门的称呼，叫做**音节辅音**（<span class="pho">l</span>, <span class="pho">r</span>, <span class="pho">m</span>, <span class="pho">n</span>, 都是音节辅音），就是因为它的发声动作如果完整的话，前面就会自然附加着一个轻微的元音 <span class="pho">ᵊ</span> 的音色。比如，*little* <span class="pho alt">ˈlɪtl̩</span><span class="speak-word-inline" data-audio-us-male="/audios/little-us-male.mp3" data-audio-us-female="/audios/little-us-female.mp3"></span> —— <span class="pho">l</span> 下面多出的那一个点 <span class="pho">l̩</span> 的意思是说，这里的 <span class="pho">l̩</span> 是个**音节辅音**，相当于 <span class="pho alt">ᵊl</span>…… 当然，很多词典干脆就直接标注成了 <span class="pho alt">ˈlɪtᵊl</span> 或者 <span class="pho alt">ˈlɪtəl</span>。《剑桥英语发声词典》中没有音节辅音符号，也没区分 <span class="pho">ᵊ</span> 和 <span class="pho">ə</span>，标注的是 <span class="pho alt">ˈlɪt̬əl</span>（另外要注意：因为 <span class="pho">t</span> 夹在两个元音之间，变成了弹舌音 <span class="pho">t̬</span>）。

## 3.2.12.4. 舌尖起始位置比较

比较一下以下的辅音发声时**舌尖起始位置**的不同：

![articulator-tongue-tip-positions](/images/articulator-tongue-tip-positions.svg)

> * <span class="pho">t/d</span> 的舌尖起始位置时贴在龈脊的前部 ③；
> * <span class="pho">s/z</span> 要相对于 <span class="pho">t/d</span> 往前一些，贴近但没有接触到牙齿和牙龈的接缝处 ②；
> * <span class="pho">θ/ð</span> 要相对于 <span class="pho">s/z</span>再往前一些，贴在牙齿上，或者伸出牙齿一点点 ①；
> * <span class="pho">ʃ/ʒ</span> 和 <span class="pho">t/d</span> 一样，接近但没有接触到龈脊的那个部位 ③；
> * <span class="pho">tʃ/dʒ</span> 和 <span class="pho">t/d</span> 一样，贴在龈脊的那个部位 ③；
> * <span class="pho">l</span> 和 <span class="pho">t/d</span> 一样，贴在龈脊的那个部位 ③；
> * <span class="pho">r</span> 相对于 <span class="pho">ʃ/ʒ</span> 还要再往后一点，贴在龈脊的那个部位 ④……

| Positions of tongue tip | Consonants                                                                                                                                                                                                                                                     |
| :---------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|            ①            | <span class="pho">θ</span>, <span class="pho">ð</span>                                                                                                                                                                                                         |
|            ②            | <span class="pho">s</span>, <span class="pho">z</span>                                                                                                                                                                                                         |
|            ③            | <span class="pho">t</span>, <span class="pho">d</span>, <span class="pho">l</span>, <span class="pho">ʃ</span>, <span class="pho">ʒ</span>, <span class="pho">tʃ</span>, <span class="pho">dʒ</span>, <span class="pho">tr</span>, <span class="pho">dr</span> |
|            ④            | <span class="pho">r</span>                                                                                                                                                                                                                                     |

## 3.2.12.5. 常见拼写

### <span class="pho">l</span>

* **l**
  * feel <span class="pho alt">fiːl</span> <span class="speak-word-inline" data-audio-us-male="/audios/feel-us-male.mp3" data-audio-us-female="/audios/feel-us-female.mp3"></span>
  * file <span class="pho alt">faɪl</span> <span class="speak-word-inline" data-audio-us-male="/audios/file-us-male.mp3" data-audio-us-female="/audios/file-us-female.mp3"></span>
  * like <span class="pho alt">laɪk</span> <span class="speak-word-inline" data-audio-us-male="/audios/like-us-male.mp3" data-audio-us-female="/audios/like-us-female.mp3"></span>

* **ll**  
  * mill <span class="pho alt">mɪl</span> <span class="speak-word-inline" data-audio-us-male="/audios/mill-us-male.mp3" data-audio-us-female="/audios/mill-us-female.mp3"></span>
  * call <span class="pho alt">kɔːl</span> <span class="speak-word-inline" data-audio-us-male="/audios/call-us-male.mp3" data-audio-us-female="/audios/call-us-female.mp3"></span>
  * thrill <span class="pho alt">θrɪl</span> <span class="speak-word-inline" data-audio-us-male="/audios/thrill-us-male.mp3" data-audio-us-female="/audios/thrill-us-female.mp3"></span>

### <span class="pho">r</span>

* **r**
  * read <span class="pho alt">riːd</span> <span class="speak-word-inline" data-audio-us-male="/audios/read-us-male.mp3" data-audio-us-female="/audios/read-us-female.mp3"></span>
  * road <span class="pho alt">roʊd</span> <span class="speak-word-inline" data-audio-us-male="/audios/road-us-male.mp3" data-audio-us-female="/audios/road-us-female.mp3"></span>
  * ring <span class="pho alt">rɪŋ</span> <span class="speak-word-inline" data-audio-us-male="/audios/ring-us-male.mp3" data-audio-us-female="/audios/ring-us-female.mp3"></span>
* **rr**
  * borrow <span class="pho alt">ˈbɑːr.oʊ</span> <span class="speak-word-inline" data-audio-us-male="/audios/borrow-us-male.mp3" data-audio-us-female="/audios/borrow-us-female.mp3"></span>
  * carry <span class="pho alt">ˈker.i</span> <span class="speak-word-inline" data-audio-us-male="/audios/carry-us-male.mp3" data-audio-us-female="/audios/carry-us-female.mp3"></span>
  * hurry <span class="pho alt">ˈhɝː.i</span> <span class="speak-word-inline" data-audio-us-male="/audios/hurry-us-male.mp3" data-audio-us-female="/audios/hurry-us-female.mp3"></span>
