# 3.3. 变体

虽然几乎每个权威词典都声称自己采用的是 “国际音标”（IPA），可实际上，每个词典的音标标注都各不相同，都是国际音标的一个**自定义子集**。

事实上，音标本身就是个**不完美**的标注系统，无论是英文的音标，还是中文的拼音（或者注音），抑或是其他语言的类似系统，都只是 “尽了全力却终究在一些细节上无法做好” 的那么一种存在 —— 哪怕是历经多年增补修改的国际音标。

幸亏，各种词典的音标不同主要体现在元音上 —— 辅音的标注大抵上都是一样的 —— 所以，掌握了某一个音标体系之后，稍微再挣扎一下，就可以看懂各种词典的音标。

| 元音音标                      | 例词     | 剑桥                             | 牛津                              | 朗文                              | 韦氏                              | 柯林斯                           |
| ----------------------------- | -------- | -------------------------------- | --------------------------------- | --------------------------------- | --------------------------------- | -------------------------------- |
| <span class="pho">ʌ</span>    | *but*    | <span class="pho">bʌt</span>     | <span class="pho">bət</span>      | <span class="pho">bʌt</span>      | <span class="pho">bət</span>      | <span class="pho">bʌt</span>     |
| <span class="pho">ɚ</span>    | *father* | <span class="pho">ˈfɑː.ðɚ</span> | <span class="pho">ˈfɑðər</span>   | <span class="pho">ˈfɑːðər</span>  | <span class="pho">ˈfä-thər</span> | <span class="pho">fɑːðəʳ</span>  |
| <span class="pho">ɝː</span>   | *worker* | <span class="pho">ˈwɝː.kɚ</span> | <span class="pho">ˈwəːrkər</span> | <span class="pho">ˈwɜːrkər</span> | <span class="pho">ˈwər-kər</span> | <span class="pho">wɜːʳkəʳ</span> |
| <span class="pho">ɒ/ɑː</span> | *dog*    | <span class="pho">dɑːɡ</span>    | <span class="pho">dɔɡ</span>      | <span class="pho">dɒːɡ</span>     | <span class="pho">ˈdäg</span>     | <span class="pho">dɔːg</span>    |
| <span class="pho">e</span>    | *bed*    | <span class="pho">bed</span>     | <span class="pho">bɛd</span>      | <span class="pho">bed</span>      | <span class="pho">bed</span>      | <span class="pho">bed</span>     |
| <span class="pho">er</span>   | *air*    | <span class="pho">er</span>      | <span class="pho">ɛr</span>       | <span class="pho">er</span>       | <span class="pho">er</span>       | <span class="pho">eəʳ</span>     |
| <span class="pho">ɪr</span>   | *ear*    | <span class="pho">ɪr</span>      | <span class="pho">ɪr</span>       | <span class="pho">ɪr</span>       | <span class="pho">ir</span>       | <span class="pho">ɪəʳ</span>     |
| <span class="pho">ʊr</span>   | *pure*   | <span class="pho">pjʊr</span>    | <span class="pho">pjʊr</span>     | <span class="pho">pjʊr</span>     | <span class="pho">ˈpyu̇r</span>    | <span class="pho">pjʊəʳ</span>   |
| <span class="pho">oʊ</span>   | *nose*   | <span class="pho">noʊz</span>    | <span class="pho">noʊz</span>     | <span class="pho">noʊz</span>     | <span class="pho">ˈnōz</span>     | <span class="pho">noʊz</span>    |

稍加整理，就会发现，各个词典中最常不同的，变体最多的，其实只有 <span class="pho">ə</span>：

* 短元音版本 <span class="pho">ə</span>[^1]，在某些词典中，可以用来表示 <span class="pho">ʌ</span> —— 比如，牛津词典或韦氏词典里的 *but* <span class="pho alt">bət</span>；
* 短元音儿化音版本 <span class="pho">ɚ</span>, 可能被写作 <span class="pho">ər</span> 或者 <span class="pho">əʳ</span>；进而，在柯林斯词典里，<span class="pho">ɪr</span> 被写作 <span class="pho">ɪəʳ</span>，<span class="pho">er</span> 被写作 <span class="pho">eəʳ</span>, <span class="pho">ʊr</span> 被写作 <span class="pho">ʊəʳ</span>……
* 长元音 <span class="pho">ɝː</span>，可能被写作 <span class="pho">əːr</span>，<span class="pho">ɜːr</span>，或者 <span class="pho">ɜːʳ</span>。

另外，<span class="pho">e</span> 有可能被写成 <span class="pho">ɛ</span>，比如牛津词典。

而 <span class="pho">ɒ/ɑː</span> 最混乱，各有各的写法。比如 *dog*：

| 元音音标                      | 例词  | 剑桥                          | 牛津                         | 朗文                          | 韦氏                          | 柯林斯                        |
| ----------------------------- | ----- | ----------------------------- | ---------------------------- | ----------------------------- | ----------------------------- | ----------------------------- |
| <span class="pho">ɒ/ɑː</span> | *dog* | <span class="pho">dɑːɡ</span> | <span class="pho">dɔɡ</span> | <span class="pho">dɒːɡ</span> | <span class="pho">ˈdäg</span> | <span class="pho">dɔːg</span> |

韦氏词典的音标相对最特殊，可能需要专门适应[^2]。比如，双元音使用上横标表示：

| 剑桥 | <span class="pho">aɪ</span>  | <span class="pho">eɪ</span>  | <span class="pho">oʊ</span>  |
| ---- | --- | --- | --- |
| 韦氏 | <span class="pho">ɪ̅</span>   | <span class="pho">a̅</span>   | <span class="pho">o̅</span>   |

韦氏词典的辅音也相对比较独特。比如，它用 <span class="pho">th</span> 标注 <span class="pho">θ</span> ，用带下划线的 <u><span class="pho">th</span></u> 标注 <span class="pho">ð</span>…… 初学者可以完全不必理会韦氏词典的音标。

其实，快速掌握音标的最简单直接有效的方法就是**勤查词典** —— 看的次数越多，看的密度越高，就自然而然地熟悉了…… 不过，在一段时间里，最好只查一个特定的词典。

另外，在附录 [8.2. 获取 CEPD 音标](8.2-cepd-phonetics-and-sound)中，我介绍了一种可以在 macOS 上快速查询并获得《剑桥英语发声词典》中的音标和发音的方法。

事实上，我们还会遇到很多其它的变体。比如，在 Enjoy App 中，在底层对音频文件进行语音识别的引擎，用的是 espeak，[它就有一套自己的音标体系](https://github.com/espeak-ng/espeak-ng/blob/master/docs/phonemes.md)；而语音评估采用的引擎是微软的 Azure，[它也有自己的一套音标体系](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/speech-ssml-phonetic-sets#section)…… 而真正的解决方案其实是 “**态度上的选择**” —— **不怕麻烦**。说实话，除此之外，根本就没有其它的决方案。

[^1]: 比较罕见的情况下，短元音 <span class="pho">ə</span> 会被写作 <span class="pho">ɜ</span>。
[^2]: https://merriam-webster.com/assets/mw/static/pdf/help/guide-to-pronunciation.pdf
