# 4.5. 句子

一句话由一个或者多个词汇构成 —— 当一句话由多个词汇构成的时候，有个重要的现象：

> * 有些词会被**强读**（***accented** form*）
> * 有些词会被**弱读**（***weak** form*）

即，不是每个词都是以同样的方式读出来的。

仔细听听以下例句：

> **TEXT**:
> * The art of focus in our whirlwind existence can sometimes feel like searching for a needle in a haystack.
> * The <span class="pho alt">ðɪ</span> art <span class="pho alt">ˈɑːrt</span> of <span class="pho alt">ɒv</span> focus <span class="pho alt">ˈfoʊkəs</span> in <span class="pho alt">ɪn</span> our <span class="pho alt">ˌaʊɚ</span> whirlwind <span class="pho alt">ˈwɝːlwɪnd</span> existence <span class="pho alt">ˈɪɡzɪstəns</span> can <span class="pho alt">kæn</span> sometimes <span class="pho alt">ˈsʌmtaɪmz</span> feel <span class="pho alt">ˈfiːl</span> like <span class="pho alt">ˈlaɪk</span> searching <span class="pho alt">ˈsɝːtʃɪŋ</span> for <span class="pho alt">fɔːr</span> a <span class="pho alt">ə</span> needle <span class="pho alt">ˈniːdəl</span> in <span class="pho alt">ɪn</span> a <span class="pho alt">ə</span> haystack <span class="pho alt">ˈheɪstæk</span>
> 
> **AUDIO**:
> * 逐字朗读版本<span class="speak-word-inline" data-audio-us-male="/audios/The-art-of-focus-in-our-whirlwind-existence-can-sometimes-feel-like-searching-for-a-needle-in-a-haystack-all-strong.mp3"></span>
> * 自然连贯版本 <span class="speak-word-inline" data-audio-us-male="/audios/The-art-of-focus-in-our-whirlwind-existence-can-sometimes-feel-like-searching-for-a-needle-in-a-haystack-natural.mp3"></span>
>   * 弱读的词汇：The art *of* focus *in* *our* whirlwind existence *can* sometimes feel *like* searching *for* a needle *in* a haystack.
>   * 相对强读的词汇：The **art** of **focus** in our **whirlwind** existence can **sometimes** **feel** like **searching** for a **needle** in a **haystack**.

这其实是一上来就需要调整（或者纠正）的习惯：

> **不能像词典一样读句子里的每一个单词**。

## 4.5.1. 弱读词汇

首先要学会的是，把一些 “虚词” —— 根据情况，比如助动词、系动词、介词、连词、冠词、代词等等 —— 弱读。

比如，在以上的例句中<span class="speak-word-inline" data-audio-us-male="/audios/The-art-of-focus-in-our-whirlwind-existence-can-sometimes-feel-like-searching-for-a-needle-in-a-haystack-natural.mp3"></span>，*of* 不是 <span class="pho alt">ɒv</span> 而是 <span class="pho alt">əv, əf, ə</span> 甚至 <span class="pho alt">ɤ</span>，*in* 不是带着重音的 <span class="pho alt">ˈɪn</span> 而是很轻的 <span class="pho alt">ɪn, ən</span>, *our* 不是 <span class="pho alt">ˌaʊɚ</span> 而是 <span class="pho alt">ɑr</span>，*can* 不是 <span class="pho alt">kæn</span> 而是 <span class="pho alt">kən</span>，*like* <span class="pho alt">laɪk</span> 中的双元音 <span class="pho">aɪ</span> 读得很短，*for* 不是 <span class="pho alt">fɔːr</span> 而是 <span class="pho alt">fɚ</span>……

以下是其中最常见的强读式、弱读式对照列表。

> [!Note]
> 这个列表不能当作**硬规则**使用，不是所有的虚词都必须被弱读；也不是所有的实词都必须被强读 —— 根据情况，这些词在自然语流中也有被强读的时候。

<div class="two-column">

> * a: <span class="pho alt">eɪ</span> → <span class="pho alt">ə</span>
> * am: <span class="pho alt">æm</span> → <span class="pho alt">əm, m</span>
> * an: <span class="pho alt">æn</span> → <span class="pho alt">ən, n</span>
> * and: <span class="pho alt">ænd</span> → <span class="pho alt">ənd, nd, ən, n</span>
> * any: <span class="pho alt">'eni</span> → <span class="pho alt">əni</span>
> * are: <span class="pho">ɑ:r</span> → <span class="pho alt">ɑr, ɑ, ə</span>
> * as: <span class="pho alt">æz</span> → <span class="pho alt">əz</span>
> * at: <span class="pho alt">æt</span> → <span class="pho alt">ət, ə</span>
> * but: <span class="pho alt">bʌt</span> → <span class="pho alt">bət, bə</span>
> * can: <span class="pho alt">kæn</span> → <span class="pho alt">kən, kn, kŋ</span>
> * could: <span class="pho alt">kʊd</span> → <span class="pho alt">kəd, kd</span>
> * do: <span class="pho alt">duː</span> → <span class="pho alt">du, də, d</span>
> * does: <span class="pho alt">dʌz</span> → <span class="pho alt">dəz</span>
> * for: <span class="pho alt">fɔːr</span> → <span class="pho alt">fɚ, fə, f</span>
> * from: <span class="pho alt">frɑːm</span> → <span class="pho alt">frəm, frm</span>
> * had: <span class="pho alt">hæd</span> → <span class="pho alt">həd, əd, d</span>
> * has: <span class="pho alt">hæz</span> → <span class="pho alt">həz, əz</span>
> * have: <span class="pho alt">hæv</span> → <span class="pho alt">həv, həf, əv, əf</span>
> * he: <span class="pho alt">hiː</span> → <span class="pho alt">hi, iː, i</span>
> * her: <span class="pho alt">hɝː</span> → <span class="pho alt">hɚ, ɚ, ə</span>
> * him: <span class="pho alt">hɪm</span> → <span class="pho alt">im</span>
> * his: <span class="pho alt">hɪz</span> → <span class="pho alt">iz</span>
> * I: <span class="pho alt">ai</span> → <span class="pho alt">ɑː, ɑ, ə</span>
> * is: <span class="pho alt">ɪz</span> → <span class="pho alt">əz, s, z</span>
> * many: <span class="pho alt">'meni</span> → <span class="pho alt">məni</span>
> * me: <span class="pho alt">miː</span> → <span class="pho alt">mi</span>
> * must: <span class="pho alt">mʌst</span> → <span class="pho alt">məst, məs</span>
> * my: <span class="pho alt">mai</span> → <span class="pho alt">mi</span>
> * of: <span class="pho alt">əv</span> → <span class="pho alt">əf, v, f</span>
> * our: <span class="pho alt">ɑʊɚ</span> → <span class="pho">ɑr</span> ⭢ <span class="pho">ɑ/</span>
> * shall: <span class="pho alt">ʃæl</span> → <span class="pho alt">ʃəl</span>
> * she: <span class="pho alt">ʃiː</span> → <span class="pho alt">ʃi</span>
> * should: <span class="pho alt">ʃʊd</span> → <span class="pho alt">ʃəd, ʃd, ʃt</span>
> * so: <span class="pho alt">soʊ</span> → <span class="pho alt">sə</span>
> * some: <span class="pho alt">sʌm</span> → <span class="pho alt">səm, sm</span>
> * such: <span class="pho alt">sʌʧ</span> → <span class="pho alt">səʧ</span>
> * than: <span class="pho alt">ðæn</span> → <span class="pho alt">ðən, ðn</span>
> * that: <span class="pho alt">ðæt</span> → <span class="pho alt">ðət</span>
> * the: <span class="pho">ðə/ði</span> → <span class="pho alt">ð</span>
> * them: <span class="pho alt">ðem</span> → <span class="pho alt">ðəm, ðm, əm, m</span>
> * then: <span class="pho alt">ðen</span> → <span class="pho alt">ðən</span>
> * to: <span class="pho alt">tuː</span> → <span class="pho alt">tu, tə, t</span>
> * us: <span class="pho alt">us</span> → <span class="pho alt">əs</span>
> * was: <span class="pho alt">wɑːz</span> → <span class="pho alt">wəz, wə</span>
> * we: <span class="pho alt">wiː</span> → <span class="pho alt">wi</span>
> * were: <span class="pho alt">wɝː</span> → <span class="pho alt">wɚ, wə</span>
> * when: <span class="pho alt">wen</span> → <span class="pho alt">wən</span>
> * will: <span class="pho alt">wɪl</span> → <span class="pho">wəl, əl, l</span>
> * would: <span class="pho alt">wuːd</span> → <span class="pho alt">wud</span>
> * you: <span class="pho alt">juː</span> → <span class="pho alt">ju, jə</span>

</div>

## 4.5.2. 强读词汇

事实上，在自然语流中，讲话者经常调整**强读**某些单词，目的是为了**强调**（emphasize），用来表达不同的含义。试比较以下同一个句子的 4 个版本[^1]，在不同的版本里，被强读的单词不同：

> * **Marianna** made the **marmalade**.<span class="speak-word-inline" data-audio-us-female="/audios/marm1.wav"></span>
> * **Marianna** made the marmalade.<span class="speak-word-inline" data-audio-us-female="/audios/marm2.wav"></span>
> * **Marianna** **made** the **marmalade**.<span class="speak-word-inline" data-audio-us-female="/audios/marm3.wav"></span>
> * Marianna made the **marmalade**?<span class="speak-word-inline" data-audio-us-female="/audios/marm4.wav"></span>

拿第 1 个版本<span class="speak-word-inline" data-audio-us-female="/audios/marm1.wav"></span>为例，请参照以下图示：

![nuclear-accented-words](/images/nuclear-accented-words.svg)

同样一个句子，**强调**不同的**词**可能表达不同的含义[^2]：

> * Will **you** drive to the office tommorrow? (rather than someone else)
> * Will you **drive** to the office tommorrow? (rather than going some other way)
> * Will you drive **to** the office tommorrow? (rather than from the office)
> * Will you drive to the **office** tommorrow? (rather than somewhere else)
> * Will you drive to the office **tommorrow**? (rather than some other day)

被**强读**的词汇之中，重音音节往往带着**声调** —— 升、降、平、降升。并且，少数重音音节会有被拔高的**音高**。这些都是自然语流的韵律中格外重要的组成部分，也是跟读模仿练习时的重点之一。

## 4.5.3. 强读式与弱读式的区别

如果一个单词被**强调**，即，读作**强读式**，那么这个单词中的：

> * 长元音会被读的很清楚，并且足够长，甚至显得更长一些；
> * 双元音会被读的很饱满，并且显得很有弹性；
> * 落在重音上的短元音都会显得更长一些；
> * 重音所在的音节可能带着不同的**声调**（平调、升调、降调、降升调）……
> * 重音所在的音节可能带着更高的**音高**（往往是 “高”、“中”、“低” 中的 “高”）……

如果一个单词被**弱读**，那么这个单词中的：

> * 长元音会变短；
> * 重音音节会变得与非重音音节一样轻；
> * 很多元音都会发生变化，向 *schwa* <span class="pho">ə</span>靠拢；
> * 很多与辅音相关的停顿会被直接省略；
> * 清辅音 <span class="pho">s</span>、<span class="pho">t</span>、<span class="pho">k</span>、<span class="pho">f</span> 之后的央元音 <span class="pho">ə</span> 可能会直接被省略掉；
> * 整个单词所处的音高往往是 “高”、“中”、“低” 之中的 “低”，最多是 “中”……

其实，哪怕在单独读某一个单词的时候，其中元音的长短都会受到重音重读的影响。比如，*city* 这个单词，重音在第一个音节上，而两处的元音是一样的：<span class="pho alt">ˈsɪ-t̬i</span>；但是只要你把第一个音节读得足够重，自然而然就能感觉到**第一个音节**只能比**第二个音节**更长。

## 4.5.4. 音高变化

当一个单词被强读的时候，这个单词的重音音节的元音可能会有更高的**音高**（*pitch*）—— 尤其是一个句子中**第一个被强读的单词**。

过去，仅凭听力去识别音高（以及后面讲解的各种声调）对绝大多数人来说是完全不可能的。所以，语音的 “韵律”（*prosody*）一直是语言学家们认为极其重要，但学校里无论是老师还是教材都对其无能为力的东西。不过，现在我们可以借助计算机程序把这些过去只能靠听力识别的东西视觉化，进而清楚地 “看到” 它们。

> 以下是一个之前听过的句子：Her *communication* skills are excellent, but her *communication* of the project details needs work.<span class="speak-word-inline" data-audio-us-male="/audios/Her-communication-skills-are-excellent-but-her-communication-of-the-project-details-needs-work-alloy.mp3"></span>

<video controls width="720"> <source src="/videos/Her-communication-skills-are-excellent-but-her-communication-of-the-project-details-needs-work-alloy.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

在 Enjoy App 中，我们可以看到一段音频的完整**波谱**（*waveform*，灰色波形）和**音高变化**（*pitch contour*，蓝色曲线）—— 我们可以 “看到” 第一个 *com**mu**nication* <span class="pho alt">kəˌmjûː.nəˈkeɪ.ʃən</span>的音高最高，具体体现在它的**重音音节**（虽然是 ‘次重音’），<span class="pho alt">ˌmjûː</span> 上，再具体一点，是这个音节的核心，即，它的元音，<span class="pho alt">jûː</span> 上。

> [!Note]
>
> *com**mu**nication* <span class="pho alt">kəˌmjûː.nəˈkeɪ.ʃən</span>，这里的 <span class="pho">◌̂</span> 是我们的自定义符号，用来表示 “那一个音节的**音高**被拔高了”。

事实上，每句话里常常只有一处，或者最多两处（长句），会出现 “音高被拔高的现象”。

## 4.5.5. 声调变化

把中文当作外语学习的时候，最麻烦的一件事是学习中文每个字的声调，一二三四声以及轻声。<span class="pho">ma</span> 这个音，可以有 <span class="pho">mā, má, mǎ, mà</span> 以及 <span class="pho">ma</span>。更令人格外头痛的是：同一个音的不同声调会代表不同的含义。

英文的音节不仅没有指定的声调，并且，声调的变化也不影响音节的含义。一般来说，声调主要在**重音音节**上有所体现。偶尔，在**句末**或者**意群末**的最后一个**非重音音节**也可能带着声调 —— 这时一般只有**平调**。

> [!Note]
> 我们将不得不使用一些自定义符号：<span class="pho">◌̂</span> 表示**音高被拔高**，<span class="pho">◌̅</span>, <span class="pho">◌́</span>, <span class="pho">◌̀</span> 分别表示**平调**、**升调**、**降调**。

理论上，**重音音节**都可以有最常见的三种声调的读法，**平调**、**升调**、**降调**。比如 *big* <span class="pho alt">bɪɡ</span> ⭢ <span class="pho alt">bɪ̅ɡ</span>，<span class="pho alt">bɪ́ɡ</span>，<span class="pho alt">bɪ̀ɡ</span>； *fact* <span class="pho alt">fækt</span> ⭢ <span class="pho alt">fæ̅kt</span>，<span class="pho alt">fǽkt</span>，<span class="pho alt">fæ̀kt</span>…… 而**非重音音节**只有**轻声**（也不需要什么自定义符号标记）。

偶尔，你也会听到一些人会使用**降升调**，一般是在**双元音**上，因为双元音实际上可以被拆分成两个元音…… 比如，*sure* <span class="pho alt">ʃʊr</span> ⭢ <span class="pho alt">ʃʊɚ</span> ⭢ <span class="pho alt">ʃʊ̀ɚ́</span>, *idea* <span class="pho alt">aɪˈdiː.ə</span> ⭢ <span class="pho alt">aɪˈdìː.ə́</span>。**降升调**也可能出现在相邻的两个音节上，前一个音节降调，后一个音节升调，于是听起来像是 “降声调”，再比如，*progress* <span class="pho alt">ˈprɑː.ɡres</span> ⭢ <span class="pho alt">ˈprɑ̀ː.ɡrés</span>
注意：如果**短元音**的音节用**平调**读出来，会自然而然地有所**拉长**。

声调（*intonation*）和音高（*pitch*）也常常配合使用。

> * **重音音节**用更高**音高**（<span class="pho">◌̂</span>）
>   * *component* <span class="pho alt">kəmˈpoʊ.nənt</span> ⭢ <span class="pho alt">kəmˈpôʊ.nənt</span>
>   * *condition*, <span class="pho alt">kənˈdɪʃ.ən</span> ⭢ <span class="pho alt">kənˈdɪ̂ʃ.ən</span>
>  在这种情况下，最后一个音节只能继续**轻声**读出来……
> * **重音音节**用**降调**（<span class="pho">◌̀</span>）
>   * *component*, <span class="pho alt">kəmˈpoʊ.nənt</span> ⭢ <span class="pho alt">kəmˈpòʊ.nənt</span>
>   * *condition*, <span class="pho alt">kənˈdɪʃ.ən</span> ⭢ <span class="pho alt">kənˈdɪ̀ʃ.ən</span>


含有重音的多音节单词读的时候就是相对更为吃力。在日常对话中，人们为了方便会下意识地尽量避免使用多音节单词。在口语中更多且又自然地使用含有重音的多音节单词，多多少少是多年教育的结果 —— 在学校里朗读背诵了更多的内容。

> [!Tip]
> 这是很多人学英语从未养成的习惯（主要是因为从来不可以训练语音）：
> > 在学一个新的英语词汇的时候，**要分别用几个声调各自读很多遍**……

过去，外语教学（无论是教材还是课堂讲解）关于声调（*intonation*）都只能局限在最简单最表象的层面 —— “整句话的升降调”。比如，疑问句用升调，陈述句用降调…… 基本上到此为止。

事实上，自然语流的 “韵律”（*prosody*）同样也体现在**音节**上 —— 准确地讲，主要是体现在 “句子中被**强读**的单词的**重音音节**” 上…… 只不过，在没有计算机辅助的情况下，哪怕是母语使用者也无法逐一分辨 —— 事实上，很多人连自己语音的每个音节声调究竟是如何控制的都无法说清楚。

在 Enjoy 中，随时可以点击某个词汇，去看那个词汇的波谱和音高变化，可以细分到音节 —— 所以，可以 “肉眼分辨” 某个**音节的声调**，到底是平、升、降的哪一种。

![syllable-intonation](/images/syllable-intonation.png)

## 4.5.6. 语速

正如我们之前讲过 “不能像词典一样读句子里的每一个单词” 一样，我们也

> **不能以完全相同的速度读每一个单词或者音节**。

自然语音的**韵律**（*prosody*），包括**停顿**（[pause](4.3-grouping#_4-3-2-停-暂停-pause) or [stop](4.3-grouping#_4-3-3-顿-停顿-stop)）与**高低**（[pitch](4.5-sentences#_4-5-4-音高变化)）、**起伏**（[intonation](4.5-sentences#_4-5-5-声调变化)）、**轻重**（[accented](4.5-sentences#_4-5-2-强读词汇) or [weak](4.5-sentences#_4-5-1-弱读词汇)）、**缓急**（*fast or slow*）。

一个句子里有很多个单词，但有些单词说出来的**速度往往并不相同** —— 也不可能相同。还是这句话，不妨重新听：

> Her communication skills are excellent, but her communication of the project details needs work.<span class="speak-word-inline" data-audio-us-male="/audios/Her-communication-skills-are-excellent-but-her-communication-of-the-project-details-needs-work-alloy.mp3"></span>

反复听几遍就知道了，"*but her communication of the project* **details**" 这个意群里，只有 *details* 这个词放缓了，被强读了，<span class="pho alt">dɪ̅ˈte̅ɪlz</span>，第一个音节甚至都被拉长了（毕竟是平调），但，前面的 "*but her communication of the project*"，每个词，每个音节都读得很快，都被弱读了，乃至于 *communication* <span class="pho alt">kəˌmjuː.nəˈkeɪ.ʃən</span> 里的长元音、双元音都很短，弱化，甚至，感觉上都变成了 <span class="pho alt">kə.məː.nə.kɤ.ʃən</span>…… 其中有不少需要注意的细节，含有很多**音变**（可能需要反复参照[音素详解](3-details)中的内容）。

[^1] 这个例子来自于 [Macquarie University](https://www.mq.edu.au/about/about-the-university/our-faculties/medicine-and-health-sciences/departments-and-centres/department-of-linguistics/our-research/phonetics-and-phonology/speech/phonetics-and-phonology/Intonation-tobi-introduction)
[^2] 这个例子来自于 *Manual of American English Pronunciation*, 4th edition, by Clifford H. Prator, Jr. BettyWallaceRobinett, 1972
