# 什么最健脑？

在过去的两百多年时间里，一方面是大多数人体力变得越来越差，另外一方面是那些主动健身的人成绩越来越好。人们投入了无数的时间与精力去研究如何提高成绩。

马拉松运动员为了跑得更快，改变了呼吸方式、改变了跑步姿势，甚至在不断研究如何改进运动鞋 —— 使用更先进的材质把跑鞋改得越来越轻；与此同时，为了使跑鞋更好地减震以便更有效地保护运动员，迄今为止也不知道更新了多少专利。

登山运动员也一样，除了各种训练方式的改进之外，所有的装备包括登山绳、登山锤、登山鞋和手套都在不断改良，为了减重，通过科技手段，所有衣服的材质全都被更换了不知道多少遍，保暖衣在越来越薄越来越轻的同时，既能更好地吸汗还能更好地透气。

人体的骨骼肌总计 600 多块。在健身房里，每一块肌肉都有许多种专门的训练方法，并且往往有不止一种专门的器械可供使用，并且永远不止一种可供选择…… 并且，无论是方法还是器械，都在不断研究不断改进。

遗憾的是，在健脑方面，人类基本停留在百年甚至千年之前。人们不知道有哪些部位需要训练，甚至压根就没想到还有健脑的必要，当然也因此完全不存在什么针对性训练及其相关设备。

幸运的是，最佳的健脑项目过于显而易见 —— **锻炼自然语言使用能力**，无论哪一种语言。

**掌握并使用自然语言**，也许是所有人终生所能遇见的最复杂且又最系统的大脑工作任务。令人惊讶的是，与此同时，对大脑来说，掌握并使用自然语言，其实并不是生存必需…… 胃坏了牙坏了肯定不行，聋了哑了其实并无所谓，毕竟聋哑实际上并不影响一个人的寿命。

自然语言可以很简单。日常生活里，人们大约只需要 500～1000 的词汇量就足够完成日常必要沟通。当然，自然语言也可以无限复杂。现代汉语大词典收录单字字头 13,000 多个，各类词语 156,000 多条；而牛津英语词典收录了 301,000 个词条。

词汇量的增加，就好像是网络中的节点增加一样，会呈几何级数地增加网络复杂程度。只要 6 个 2x4 的乐高积木块，就可以有 915,103,765 种组合方式。想象一下那么多的词条总计可以有多少种组合方式。在牛津词典里，即便是在严格遵守**如非必要绝不添加**原则的情况下，总计有 577,000 个交互参考说明（*cross-references*）。

科学，主要使用的是**人工语言**。人工语言是自然语言的一个子集，由相对极少的词汇与一些作为补充的符号构成 —— 数学如此、物理如此，化学如此，计算机的编程语言也是如此。从自然语言中提取精简且又系统的人工语言，是人类的一大创举，也使得人类的智慧可以迅速积累极大提高。与此同时，主要由人工语言构成的知识，到最后还是得靠自然语言才能更大面积传播。

与之相对的，我们在学校里花最长时间学习的，也是语文课，从开始上学一直到学校毕业。不仅如此，到了近代，全球的教育体系都一样，都纳入了第二语言学习，且同样贯穿整个在校教育过程 —— 虽然效果并不怎么样。

实际上，如果我们肯穿过表象看透实质的话，学校里的一切课程都是语文课 —— 本质上都是老师们在用**自然语言**讲授用**人工语言**记录并传播的**知识**。很多人数理化成绩不佳，底层原因其实是语文问题。科学知识本身没多复杂，但，语文基础不过关的结果是，课程听不懂，或者题目读不懂，理解不完整，甚至干脆理解错误，这才导致了最终浮现在表面的那些千奇百怪的问题。

顺带说，中国人学英语还是相对来看运气好的。英美国家的人也在学校里学外语，但他们比我们倒霉一点。我们学了英语之后，到哪儿都有用，尤其是在知识的海洋里遨游的时候 —— 这一点也没什么办法，因为目前人类的知识就是主要用英文记录并传播。英美国家的人呢？在学校学了一门西班牙语，除了考试之外哪儿哪儿都用不上，哪怕下了班去个西班牙餐厅，发现人家服务员说的还是英语。（这不是我开的玩笑，而是一位美国大学教授的慨叹和抱怨（*The Case against Education*）。

个体之间的自然语言使用能力，可以是 0 或某个数值与天文数字之间某个数值的差异。从这个角度望过去，每个人无论当前的自然语言使用能力如何，都有无限的提升空间 —— 用它健脑和健身非常不一样。

你跑马拉松，无论如何也不可能只用 3 分钟跑完；你登山，地球上也没有海拔 10,000 米以上的山峰可以让你爬，你去健身，无论怎么练也不可能把自己练成 200 公斤以上 —— 据说目前地球上最重的健身运动员体重是 400 磅，身高 193 厘米，每天要摄入 12,000 卡路里才行，那也只不过是 181.44 公斤。

可自然语言使用能力不一样，无限空间无限可能。你可以把它练得更好，使自己的日常沟通更为有效，或者让自己通过公开讲演获得更多的影响力；你也可以用它写书，虚构类或者非虚构类；你还可以用它写剧本、电视、电影、短剧…… 你还可以学习并使用多种语言，每一种语言都有同样无限的可能性…… 没有尽头。

自然语言使用之于脑力正如马拉松之于体力。如果，跑步是最为普适的**健身运动**，那么，自然语言使用就是最有趣且最为普适的**健脑运动**。

显然，跑步相对于自然语言使用来看更为枯燥。事实上，一切体育运动相对于自然语言使用来看都显得枯燥许多，因为自然语言是更大的更复杂的网络，由更多的节点构成。用得不好就算了，用得好的话，有趣的地方实在是太多。

**跑步**锻炼最多使用最多的是对体力运动来说最重要的器官，**心**与**肺**。而**自然语言使用**对应的是大脑里的**白质**与**灰质**。语言能力更强的人以及多语使用者，从大脑结构上来看，他们都比其他人拥有相对覆盖面积更广的**白质**和密度更高体积更大的**灰质** —— **这不是天生的，这只能是后天训练的结果**。

关键在于，白质和灰质不止用来处理语言…… 事实上，人类无论做什么都用它们靠它们。白质的主要功能之一是协调大脑的各个部分，它的**覆盖面积**越广，大脑各部分之间的**协同效率就**越高。**灰质**是中枢神经系统对信息进行深入处理的部位，它的**密度**越高**体积**越大，人就越聪明，因为那里已经存储、相互关联、可以处理的信息就越多。

脑科学家们对各类专家的大脑进行扫描的结果发现，虽然大家术业有专攻，但到最后，这些人的大脑都具备相同的表征 —— 都是白质覆盖面积相对更广，灰质密度相对更高、灰质体积也相对更大。与此同时，白质覆盖面积相对更广、灰质密度相对更高、灰质体积相对更大的人，无论学什么都更快，无论做什么都更好。不仅如此，这样的人还更擅长处理多任务，所以做事的时候总是效率更高。总而言之，他们的**大脑可塑性**总是相对更强。

并且，随着年龄增加，白质覆盖面积相对更广、灰质密度相对更高、体积相对更大的人，抗衰老能力更强。所谓的**耳聪目明**，实际上并不是耳膜或者眼角膜所决定的，真正决定视力和听力的其实是大脑。如果大脑出了问题，即便耳膜眼角膜都正常，视力和听力也都会出问题。所以，更广覆盖面积的白质，密度更高体积更大的灰质，自然会延缓大脑衰老，也能预防很多老年疾病，比如帕金森症综合症。对普通人都适用的是，更好的大脑机能显然会更少罹患抑郁症。