

# 人人都能用英语

## 目录

- [简介](README.md)
- [第一章：起点](chapter1.md)
- [第二章：口语](chapter2.md)
- [第三章：语音](chapter3.md)
- [第四章：朗读](chapter4.md)
- [第五章：词典](chapter5.md)
- [第六章：语法](chapter6.md)
- [第七章：精读](chapter7.md)
- [第八章：叮嘱](chapter8.md)
- [后记](end.md)

## 前言
>有一天，有个人在 Twitter 上提问：

>> @maozhu1: @xiaolai 还请李老师用 140 字概括一下怎样才能学好英语？

>我回复说：
>
>>其实一个字就够了：“用”。

这本书里的文字，全部的意义，只有两个字：“启发”。

有些知识，不仅要了解，还要深入了解。为了深入了解，不仅要学习，还要实践，更要反复试错，在成功中获得激励，在失败中汲取教训，路漫漫其修远，上下求索才可能修成正果。小到开车，大到创业，各种所需要的知识莫不如是。面对这样的知识，我们要了解：

* What──它究竟是什么？
* Why──为什么它是那个样子？
* How──要掌握它、应用它，必须得遵循什么样的步骤？

然而，有另外一种知识，往往还是格外重要的知识，在知道它的那一瞬间就可能开始发挥重大的作用，甚至，在知道它（What）的那一瞬间，它所有的重大作用全部都发挥完毕（至于 Why 和 How，甚至可能在了解它的 What 那一瞬间早已经不言自明）。

在我个人的记忆里，一路上遇到过很多这种 “只要知道就能够瞬间全部发挥作用” 的知识。学概率统计的时候，遇到 “独立事件” 这个概念，就是这类知识的典型例子。在此之前，我很自然地以为如果连续 9 次抛硬币都是正面朝上，那么第 10 次抛出硬币之后正面朝上的可能性要远远低于背面朝上的可能性 …… 在概率教科书里读到 “独立事件” 的那一瞬间，让我意识到之前的想法是多么的可笑。因为抛硬币正反面的几率是永远都相同的（硬币出现正反面在每次抛时都是相互独立、不受之前结果影响的），各占 50%，所以即便我抛一百次，一万次，甚至更多次都是正面朝上，下一次抛正反面的几率也还是如此，各占 50%。

至此，这个知识的所有作用已经全部发挥完毕：它能够彻头彻尾地改变一些人──那些一不小心看到它实际意义的人。无论是谁，在做几乎所有决定的时候，都要考虑 “可能性”（学称 “概率”）。在我不知道 “独立事件” 这个概念之前所做出的很多决定，换在知道 “独立事件” 这个概念之后，我是无论如何都不会那样选择的──这就是改变，并且是质变。

另一个令我记忆深刻的例子是很小的时候学习编程语言。多年以来，受影响最深的，并不是当时所学的 BASIC，或者是后来所学的 PASCAL，抑或再后来学的 C、C++什么的；受影响最深的是一种思考方式──在运行程序之前，要反复浏览代码，在脑子里进行预演；而不是写完程序直接运行，出错了再说。这是节省时间提高效率的重要方式。刚开始并不知道 “了解了这种操作方式” 给自己带来了多大的影响；可是，许多年之后，观察到身边大多数人从来都没有 “做事之前先在脑子里预演” 的习惯，才明白很小的时候知道了那样的做法给自己带来的巨大好处──并且是没办法给那些不知道的人讲明白的好处。（也许正因为如此，才总是有人这样无奈罢：会的人，自然会了，不会的人，无论如何也不会。）
更为关键的是，这种知识的获取，是 “不可逆的”。在你知道它的那一瞬间，它就已经改变了一切，你的生活因它而变，再也无法复原。我们再也不可能对这种知识视而不见，听而不闻，置之不理，它瞬间就能根深蒂固，无法铲除。比如，真正理解概率统计常识的人，是绝对不会去买彩票的 …… 因为买彩票这种行为在他们眼里相当于不尊重自己的智商和已学过的知识。可与此同时，彩票是地球上最畅销的商品，可见有多少人一生都未曾有机会了解那些重要的知识。

当然，读到这里，读者都会同意：也许最值得传播的（至少应该为之努力的）就是这种知识。传播它们的最大意义，甚至唯一的意义和目的，就是 “启发”。这本书里的文字，全部的意义，只有两个字：“启发”。作者真诚地希望读者在读过这些文字之后，（起码）在英语使用方面有所启发。

也许有些读者会发现里面有 “太多的废话”，那仅仅是因为这类知识的特性：它们太 “貌不惊人”，如果非要它们以本来的面目出现，他们是不会注意到的──无论它们实际上有多么重要。否则，他们早就被这类知识彻头彻尾地改变了 …… 可事实上他们不还是原来那个样子么？

也许有些读者自然而然地依照思维惯性，希望看到更多的 “How”。可正如之前所解释的那样，这类知识中的大多数，读者在了解到 “What” 的那一瞬间，它的作用就已经全部发挥完毕，“Why” 也许只不过是多余的解释，而 “How” 或者不言自明，或者因人而异，需要读者自己摸索……

这类知识注定属于少数人。除了之前已经说过的原因之外，还有另外一个重要的原因：人们只愿传播自己相信的知识──哪怕那所谓的知识根本就是错的。重要的不是对错，重要的是感觉。尽管 “觉得正确” 和 “正确” 相差可能十万八千里，但对大多数人来说根本就是一回事儿，起码，他们情愿那就是一回事儿。所以，容易传递的是那些 “很自然地就令人相信（感觉）是正确的”，而不是 “事实上正确的” 事情。

前些年我写《把时间当作朋友》的时候，多少对它的传播是悲观的，因为我知道那些文字里所传递的绝大多数是这种道理、这类知识──它们的本质决定了其传播的困难程度。所以，那时候，我觉得只要有零星那么几个人能够被那些文字所改变，就已经万幸了。互联网时代充满了奇迹，那些文字在网上以每个月几万点击的数量被浏览。而 2009 年印刷成书出版后，竟然可以在一年之内重印 11 次，再次出乎我的意料。哪怕真正接受那些道理的读者比率再低，由于基数巨大，我知道我还是结结实实地改变了很多人的。

正是这样的动力，使我甘心、耐心地写下这本书里的文字。知道它们无论如何都会再次改变一些人──尽管我自己永远没办法知道最终改变的究竟是哪些人。生活中充满了无奈，然而有些人幸运如我，毕竟能够改变点什么。于是，那些无奈，那些不幸，就多少淡了一些。

事实上，这本书也是《把时间当做朋友》的具体延续。《把时间当做朋友》的主旨很简单：时间不会听从我们的管理，我们最多只能与时间做朋友；与时间做朋友的方法只不过是 “用正确的方式做正确的事情”。而这本书，只不过是 把 “正确的事情” 聚焦在 “用英语” 上而已，而后再看看可能的 “正确的方式” 究竟是什么。

### 李笑来

* 2010 年春于上海初稿
* 2010 年冬于北京修改
* 2015 年于北京重新制作网络开放版本
* 2019 年于北京上传至 GitHub
