# Analytical Writing: "Issue" Task Topics

This page contains the Issue topics for the analytical writing section of the GRE General Test. When you take the test, you will be presented with two Issue topics from this pool.

The wording of some topics in the test might vary slightly from what is presented here. Therefore, read your test topics carefully and respond to the wording as it appears in the actual test.

**Present your perspective on the issue below, using relevant reasons and/or examples to support your views.**

"Important truths begin as outrageous, or at least uncomfortable, attacks upon the accepted wisdom of the time."

———————————————

"Originality does not mean thinking something that was never thought before; it means putting old ideas together in new ways."

———————————————

"Laws should not be rigid or fixed. Instead, they should be flexible enough to take account of various circumstances, times, and places."

———————————————

"It is always an individual who is the impetus for innovation; the details may be worked out by a team, but true innovation results from the enterprise and unique perception of an individual."

———————————————

"The function of science is to reassure; the purpose of art is to upset. Therein lies the value of each."

———————————————

"The study of an academic discipline alters the way we perceive the world. After studying the discipline, we see the same world as before, but with different eyes."

———————————————

"It is possible to pass laws that control or place limits on people's behavior, but legislation cannot reform human nature. Laws cannot change what is in people's hearts and minds."

———————————————

"What most human beings really want to attain is not knowledge, but certainty. Gaining real knowledge requires taking risks and keeping the mind open—but most people prefer to be reassured rather than to learn the complex and often unsettling truth about anything."

———————————————

"Many problems of modern society cannot be solved by laws and the legal system because moral behavior cannot be legislated."

———————————————

"The way students and scholars interpret the materials they work with in their academic fields is more a matter of personality than of training. Different interpretations come about when people with different personalities look at exactly the same objects, facts, data, or events and see different things."

———————————————

"It is dangerous to trust only intelligence."

———————————————

"As we acquire more knowledge, things do not become more comprehensible, but more complex and more mysterious."

———————————————

"It is a grave mistake to theorize before one has data."

———————————————

"Scandals—whether in politics, academia, or other areas—can be useful. They focus our attention on problems in ways that no speaker or reformer ever could."

———————————————

"Practicality is now our great idol, which all powers and talents must serve. Anything that is not obviously practical has little value in today's world."

———————————————

"It is easy to welcome innovation and accept new ideas. What most people find difficult, however, is accepting the way these new ideas are put into practice."

———————————————

"Success, whether academic or professional, involves an ability to survive in a new environment and, eventually, to change it."

———————————————

"If people disregard the great works of the past, it is because these works no longer answer the needs of the present."

———————————————

"As long as people in a society are hungry or out of work or lack the basic skills needed to survive, the use of public resources to support the arts is inappropriate—and, perhaps, even cruel—when one considers all the potential uses of such money."

———————————————

"Education should be equally devoted to enriching the personal lives of students and to training students to be productive workers."

———————————————

"Success in any realm of life comes more often from taking chances or risks than from careful and cautious planning."

———————————————

"It is not the headline-making political events but the seldom-reported social tranformations that have the most lasting significance."

———————————————

"The best preparation for life or a career is not learning to be competitive, but learning to be cooperative."

———————————————

"The goal of politics should not be the pursuit of an ideal, but rather the search for common ground and reasonable consensus."

———————————————

"Technology creates more problems than it solves, and may threaten or damage the quality of life."

———————————————

"The material progress and well-being of one country are necessarily connected to the material progress and well-being of all other countries."

———————————————

"Instead of encouraging conformity, society should show greater appreciation of individual differences."

———————————————

"Truly innovative ideas do not arise from groups of people, but from individuals. When groups try to be creative, the members force each other to compromise and, as a result, creative ideas tend to be weakened and made more conventional. Most original ideas arise from individuals working alone."

———————————————

"The most elusive knowledge is self-knowledge, and it is usually acquired through solitude, rather than through interaction with others."

———————————————

"The purpose of education should be to provide students with a value system, a standard, a set of ideas—not to prepare them for a specific job."

———————————————

"Unlike great thinkers and great artists, the most effective political leaders must often yield to public opinion and abandon principle for the sake of compromise."

———————————————

"The best way to understand the character of a society is to examine the character of the men and women that the society chooses as its heroes or its heroines."

———————————————

"We learn through direct experience; to accept a theory without experiencing it is to learn nothing at all."

———————————————

"As societies all over the world have more and more access to new information, the effects on life-long learning can only be positive."

———————————————

"People are too quick to take action; instead they should stop to think of the possible consequences of what they might do."

———————————————

"Rituals and ceremonies help define a culture. Without them, societies or groups of people have a diminished sense of who they are."

———————————————

"The way people look, dress, and act reveals their attitudes and interests. You can tell much about a society's ideas and values by observing the appearance and behavior of its people."

———————————————

"Progress is best made through discussion among people who have contrasting points of view."

———————————————

"Most people choose a career on the basis of such pragmatic considerations as the needs of the economy, the relative ease of finding a job, and the salary they can expect to make. Hardly anyone is free to choose a career based on his or her natural talents or interest in a particular kind of work."

———————————————

"Any decision-whether made by government, by a corporation, or by an individual person-must take into account future conditions more than present conditions."

———————————————

"If a goal is worthy, then any means taken to attain it is justifiable."

———————————————

"Too much emphasis has been placed on the need for students to challenge the assertions of others. In fact, the ability to compromise and work with others—that is, the ability to achieve social harmony—should be a major goal in every school."

———————————————

"Society should identify those children who have special talents and abilities and begin training them at an early age so that they can eventually excel in their areas of ability. Otherwise, these talents are likely to remain undeveloped."

———————————————

"The bombardment of visual images in contemporary society has the effect of making people less able to focus clearly and extensively on a single issue over a long period of time."

———————————————

"Most important discoveries or creations are accidental: it is usually while seeking the answer to one question that we come across the answer to another."

———————————————

"In order to produce successful original work, scholars and scientists must first study the successful work of others to learn what contributions remain to be made."

———————————————

"In order for any work of art—whether film, literature, sculpture, or a song—to have merit, it must be understandable to most people."

———————————————

"Now that computer technology has made possible the rapid accessing of large amounts of factual information, people are less likely than ever to think deeply or originally. They feel unable to compete with—much less contribute to—the quantity of information that is now available electronically."

———————————————

"The increase in knowledge is forcing people to specialize. As a result, the distance between fields of specialization has become so vast that specialists in different areas are rarely able to influence each other."

———————————————

"The chief benefit of the study of history is to break down the illusion that people in one period of time are significantly different from people who lived at any other time in history."

———————————————

"Learning for learning's sake is an outdated concept. Today, education must serve an ulterior purpose and be directed toward clear goals."

———————————————

"Education is primarily a personal matter; it has little to do with school or college."

———————————————

"Censorship is rarely, if ever, justified."

———————————————

"People often look for similarities, even between very different things, and even when it is unhelpful or harmful to do so. Instead, a thing should be considered on its own terms; we should avoid the tendency to compare it to something else."

———————————————

"People are mistaken when they assume that the problems they confront are more complex and challenging than the problems faced by their predecessors. This illusion is eventually dispelled with increased knowledge and experience."

———————————————

"To remain vigorous, any academic field needs to be led by truly independent thinkers who are willing to ignore established boundaries and challenge long-standing assumptions."

———————————————

"The best way to teach—whether as an educator, employer, or parent—is to praise positive actions and ignore negative ones."

———————————————

"The best way to learn a new subject or skill is to study small segments or details in great depth rather than to start by trying to develop a sense of the whole."

———————————————

"College students—and people in general—prefer to follow directions rather than make their own decisions. Therefore, colleges should eliminate as many choices as possible in order to offer students clear direction."

———————————————

" 'Moderation in all things' is ill-considered advice. Rather, one should say, 'Moderation in most things,' since many areas of human concern require or at least profit from intense focus."

———————————————

"The purpose of education should be to create an academic environment that is separate from the outside world. This kind of environment is ideal because it allows students to focus on important ideas without being held back by practical concerns."

———————————————

"Although innovations such as video, computers, and the Internet seem to offer schools improved methods for instructing students, these technologies all too often distract from real learning."

———————————————

"Most people prefer restrictions and regulations to absolute freedom of choice, although they would probably deny such a preference."

———————————————

"Most people are taught that loyalty is a virtue. But loyalty—whether to one's friends, to one's school or place of employment, or to any institution—is all too often a destructive rather than a positive force."

———————————————

"Encouraging young people to believe that they can accomplish great things if they try hard enough is both misleading and potentially harmful."

———————————————

"Computers and video technology can make facsimiles of original works such as paintings and historical documents available to everyone. The great advantage of this new technology is that it will enable anyone—not just scholars—to conduct in-depth research without having access to the original works."

———————————————

"Conformity almost always leads to a deadening of individual creativity and energy."

———————————————

"Much of the information that people assume is 'factual' actually turns out to be inaccurate. Thus, any piece of information referred to as a 'fact' should be mistrusted since it may well be proven false in the future."

———————————————

"Although it is easy to respond positively to the work of another person or group, it is far more worthwhile to give negative feedback."

———————————————

"An individual's greatness cannot be judged objectively by his or her contemporaries; the most objective evaluators of a person's greatness are people who belong to a later time."

———————————————

"Societies should try to save every plant and animal species, regardless of the expense to humans in effort, time, and financial well-being."

———————————————

"The true value of a civilization is reflected in its artistic creations rather than in its scientific accomplishments."

———————————————

"Most societies do not take their greatest thinkers seriously, even when they claim to admire them."

———————————————

"We can usually learn much more from people whose views we share than from people whose views contradict our own; disagreement can cause stress and inhibit learning."

———————————————

"Competition is ultimately more beneficial than detrimental to society."

———————————————

"It is more important to allocate money for immediate, existing social problems than to spend it on long-term research that might help future generations."

———————————————

"No field of study can advance significantly unless outsiders bring their knowledge and experience to that field of study."

———————————————

"A nation should require all its students to study the same national curriculum until they enter college rather than allow schools in different parts of the nation to determine which academic courses to offer."

———————————————

"The most effective way to understand contemporary culture is to analyze the trends of its youth."

———————————————

"The video camera provides such an accurate and convincing record of contemporary life that it has become a more important form of documentation than written records."

———————————————

"It is often necessary, even desirable, for political leaders to withhold information from the public."

———————————————

"Academic disciplines have become so specialized in recent years that scholars' ideas reach only a narrow audience. Until scholars can reach a wider audience, their ideas will have little use."

———————————————

"Governments must ensure that their major cities receive the financial support they need in order to thrive, because it is primarily in cities that a nation's cultural traditions are preserved and generated."

———————————————

"All nations should help support the development of a global university designed to engage students in the process of solving the world's most persistent social problems."

———————————————

"People's attitudes are determined more by their immediate situation or surroundings than by any internal characteristic."

———————————————

"Many of the world's lesser-known languages are being lost as fewer and fewer people speak them. The governments of countries in which these languages are spoken should act to prevent such languages from becoming extinct."

———————————————

"It is necessary for everyone to read poetry, novels, mythology and other types of imaginative literature."

———————————————

"The stability of a society depends on how it responds to the extremes of human behavior."

———————————————

"Although many people think that the luxuries and conveniences of contemporary life are entirely harmless, in fact, they actually prevent people from developing into truly strong and independent individuals."

———————————————

"There are two types of laws: just and unjust. Every individual in a society has a responsibility to obey just laws and, even more importantly, to disobey and resist unjust laws."

———————————————

"Only by being forced to defend an idea against the doubts and contrasting views of others does one really discover the value of that idea."

———————————————

"If a society is to thrive, it must put its own overall success before the well-being of its individual citizens."

———————————————

"National governments should devote more of their social programs and services to children than to adults."

———————————————

"Reform is seldom brought about by people who are concerned with their own reputation and social standing. Those who are really in earnest about reforming a government, an educational system, or any other institution must be willing to be viewed with disdain by the rest of the world."

———————————————

"Many people believe that a few individuals or small groups (family, friends, teachers, celebrities, for example) have caused them to think and behave in the way they do. Yet it is always society as a whole that defines us and our attitudes, not a few individuals."

———————————————

"Contemporary technology makes available many small pieces of factual information. As a result, people have become so preoccupied with bits of fragmented information that they pay too little attention to the larger issues and overall perspectives."

———————————————

"People in positions of power are most effective when they exercise caution and restraint in the use of that power."

———————————————

"Anyone can make things bigger and more complex. What requires real effort and courage is to move in the opposite direction—in other words, to make things as simple as possible."

———————————————

"Most people would agree that buildings represent a valuable record of any society's past, but controversy arises when old buildings stand on ground that modern planners feel could be better used for modern purposes. In such situations, modern development should be given precedence over the preservation of historic buildings so that contemporary needs can be served."

———————————————

"No one can possibly achieve success in the world by conforming to conventional practices and conventional ways of thinking."

———————————————

"Students should memorize facts only after they have studied the ideas, trends, and concepts that help explain those facts. Students who have learned only facts have learned very little."

———————————————

"Public figures such as actors, politicians, and athletes should expect people to be interested in their private lives. When they seek a public role, they should expect that they will lose at least some of their privacy."

———————————————

"The primary goal of technological advancement should be to increase people's efficiency so that everyone has more leisure time."

———————————————

"Money spent on research is almost always a good investment, even when the results of that research are controversial."

———————————————

"A school or college should pay its teachers at the same rate in all disciplines, regardless of differences in salaries for related fields in the world outside of school. For example, entry-level teachers in mathematics and in the arts should receive the same pay, even if outside of school, math specialists earn a much higher salary on average than do specialists in the arts."

———————————————

"Creating an appealing image has become more important in contemporary society than is the reality or truth behind that image."

———————————————

"Instead of requiring students to take courses in a variety of disciplines—that is, courses ranging from the arts and the humanities to the physical and biological sciences—colleges and universities should allow students to enroll only in those courses that will help prepare them for jobs in their chosen fields. Such concentration is necessary in today's increasingly work-oriented society."

———————————————

"No matter what the situation, it is more harmful to compromise one's beliefs than to adhere to them."

———————————————

"The greatness of individuals can be decided only by those who live after them, not by their contemporaries."

———————————————

"In most societies, competition generally has more of a negative than a positive effect."

———————————————

"In the age of television, reading books is not as important as it once was. People can learn as much by watching television as they can by reading books."

———————————————

"The intellectual benefits of attending a university or college are vastly overrated: most people could learn more by studying and reading on their own for four years than by pursuing a university or college degree."

———————————————

"Scholars and researchers should not be concerned with whether their work makes a contribution to the larger society. It is more important that they pursue their individual interests, however unusual or idiosyncratic those interests may seem."

———————————————

"Such nonmainstream areas of inquiry as astrology, fortune-telling, and psychic and paranormal pursuits play a vital role in society by satisfying human needs that are not addressed by mainstream science."

———————————————

"Because learning is not a solitary activity but one that requires collaboration among people, students of all ages will benefit academically if they work frequently in groups."

———————————————

"To be an effective leader, a public official must maintain the highest ethical and moral standards."

———————————————

"Government should not fund any scientific research whose consequences, either medical or ethical, are unclear."

———————————————

"Government officials should rely on their own judgment rather than unquestioningly carrying out the will of the people whom they serve."

———————————————

"While some leaders in government, sports, industry, and other areas attribute their success to a well-developed sense of competition, a society can better prepare its young people for leadership by instilling in them a sense of cooperation."

———————————————

"Society does not place enough emphasis on the intellect—that is, on reasoning and other cognitive skills."

———————————————

"The study of history places too much emphasis on individuals. The most significant events and trends in history were made possible not by the famous few, but by groups of people whose identities have long been forgotten."

———————————————

"Imaginative works such as novels, plays, films, fairy tales, and legends present a more accurate and meaningful picture of human experience than do factual accounts. Because the creators of fiction shape and focus reality rather than report on it literally, their creations have a more lasting significance."

———————————————

"In order to improve the quality of instruction at the college and university level, all faculty should be required to spend time working outside the academic world in professions relevant to the courses they teach."

———————————————

"Education will be truly effective only when it is specifically designed to meet the individual needs and interests of each student."

———————————————

"Education encourages students to question and criticize, and therefore does little to promote social harmony."

———————————————

"College and university education should be free for all students, fully financed by the government."

———————————————

"History teaches us only one thing: knowing about the past cannot help people to make important decisions today."

———————————————

"Competition for high grades seriously limits the quality of learning at all levels of education."

———————————————

"Governments should focus more on solving the immediate problems of today rather than trying to solve the anticipated problems of the future."

———————————————

"The depth of knowledge to be gained from books is much richer and broader than what can be learned from direct experience."

———————————————

"The increasingly rapid pace of life today causes more problems than it solves."

———————————————

"Too much emphasis is placed on role models. Instead of copying others, people should learn to think and act independently and thus make the choices that are best for them."

———————————————

"The media—and society in general—mistakenly expect an individual to speak for a particular group, whether or not that individual truly represents the views of the entire group."

———————————————

"High-profile awards such as the Nobel Prize are actually damaging to society because they suggest that only a few people deserve such recognition."

———————————————

"The widespread idea that people should make self-improvement a primary goal in their lives is problematic because it assumes that people are intrinsically deficient."

———————————————

"To truly understand your own culture—no matter how you define it—requires personal knowledge of at least one other culture, one that is distinctly different from your own."

———————————————

"Many people know how to attain success, but few know how to make the best use of it."

———————————————

"People have been so encouraged by society to focus on apparent differences that they fail to see meaningful similarities among ideas, individuals, and groups."

———————————————

"As people rely more and more on technology to solve problems, the ability of humans to think for themselves will surely deteriorate."

———————————————

"Colleges should require students to engage in public-service activities in order to assure that each student receives a balanced, well-rounded education."

———————————————

"People make the mistake of treating experts with suspicion and mistrust, no matter how valuable their contributions might be."

———————————————

"Government should place few, if any, restrictions on scientific research and development"

———————————————

"In any profession—business, politics, education, government—those in power should step down after five years. The surest path to success for any enterprise is revitalization through new leadership."

———————————————

"Spending time alone makes one a better companion to others."

———————————————

"One can best understand the most important characteristics of a society by studying its major cities."

———————————————

"In most professions and academic fields, imagination is more important than knowledge."

———————————————

"The most effective way to communicate an idea or value to large groups of people is through the use of images, not language."

———————————————

"The people who make important contributions to society are generally not those who develop their own new ideas, but those who are most gifted at perceiving and coordinating the talents and skills of others."

———————————————

"Truly profound thinkers and highly creative artists are always out of step with their time and their society."

———————————————

"People today are too individualistic. Instead of pursuing self-centered, separate goals, people need to understand that satisfaction comes from working for the greater good of the family, the community, or society as a whole."

———————————————

"Schools should be required to teach the essential interconnectedness of all human beings and thus help eliminate wars, cultural clashes, and other forms of conflict."

———————————————

"Major policy decisions should always be left to politicians and other government experts, who are more informed and thus have better judgment and perspective than do members of the general public."

———————————————

"All students should be required to take courses in the sciences, even if they have no interest in science."

———————————————

"Patriotic reverence for the history of a nation often does more to impede than to encourage progress."

———————————————

"Government should never censor the artistic works or historical displays that a museum wishes to exhibit."

———————————————

"Government should preserve publicly owned wilderness areas in their natural state, even though these areas are often extremely remote and thus accessible to only a few people."

———————————————

"In any field of endeavor, it is impossible to make a significant contribution without first being strongly influenced by past achievements within that field."

———————————————

"Government funding of the arts threatens the integrity of the arts."

———————————————

"Young people should be encouraged to pursue long-term, realistic goals rather than seek immediate fame and recognition."

———————————————

"In any field of inquiry, the beginner is more likely than the expert to make important discoveries."

———————————————

"Technologies not only influence but actually determine social customs and ethics."

———————————————

"Leaders are created primarily by the demands that are placed upon them."

———————————————

"College students should be encouraged to pursue subjects that interest them rather than seek programs that promise entry into the job market."

———————————————

"Most people think that their deeply held values are the result of rational choice, but reason often has little to do with the way people form values."

———————————————

"In any academic area or professional field, it is just as important to recognize the limits of our knowledge and understanding as it is to acquire new facts and information."

———————————————

"The concept of 'individual responsibility' is a necessary fiction. Although societies must hold individuals accountable for their own actions, people's behavior is largely determined by forces not of their own making."

———————————————

"Universities should require every student to take a variety of courses outside the student's field of study because acquiring knowledge of various academic disciplines is the best way to become truly educated."

———————————————

"People work more productively in teams than individually. Teamwork requires cooperation, which motivates people much more than individual competition does."

———————————————

"Although, critics who write about the arts tend to deny the existence of any objective standards for evaluating works of art, they have a responsibility to establish standards by which works of art can be judged."

———————————————

"It is unfortunate but true that political decisions and activities affect all aspects of people's lives."

———————————————

"Colleges and universities should offer more courses on popular music, film, advertising, and television because contemporary culture has much greater relevance for students than do arts and literature of the past."

———————————————

"In any realm of life—whether academic, social, business, or political—the only way to succeed is to take a practical, rather than an idealistic, point of view. Pragmatic behavior guarantees survival, whereas idealistic views tend to be superceded by simpler, more immediate options."

———————————————

"The pressure to achieve high grades in school seriously limits the quality of learning. An educational environment without grades would promote more genuine intellectual development."

———————————————

"Governments should provide funding for artists so that the arts can flourish and be available to all people."

———————————————

"For better or worse, education is a process that involves revising the ideas, beliefs, and values people held in the past."

———————————————

"The study of history has value only to the extent that it is relevant to our daily lives."

———————————————

"It is primarily through formal education that a culture tries to perpetuate the ideas it favors and discredit the ideas it fears."

———————————————

"The true strength of a country is best demonstrated by the willingness of its government to tolerate challenges from its own citizens."

———————————————

"All students should be required to take at least one course in ethics, even if taking the course means a decreased emphasis on academic subjects."

———————————————

"Instant communication systems encourage people to form hasty opinions and give quick replies rather than take the time to develop thoughtful, well-reasoned points of view."

———————————————

"In many countries it is now possible to turn on the television and view government at work. Watching these proceedings can help people understand the issues that affect their lives. The more kinds of government proceedings—trials, debates, meetings, etc—that are televised, the more society will benefit."

———————————————

"The purpose of many advertisements is to make consumers want to buy a product so that they will 'be like' the person in the ad. This practice is effective because it not only sells products but also helps people feel better about themselves."

———————————————

"When we concern ourselves with the study of history, we become storytellers. Because we can never know the past directly but must construct it by interpreting evidence, exploring history is more of a creative enterprise than it is an objective pursuit. All historians are storytellers."

———————————————

"The worldwide distribution of television programs and advertisements is seriously diminishing the differences among cultures."

———————————————

"Some educational systems emphasize the development of students' capacity for reasoning and logical thinking, but students would benefit more from an education that also taught them to explore their own emotions."

———————————————

"It is primarily through our identification with social groups that we define ourselves."

———————————————

"Humanity has made little real progress over the past century or so. Technological innovations have taken place, but the overall condition of humanity is no better. War, violence, and poverty are still with us. Technology cannot change the condition of humanity."

———————————————

"It is through the use of logic and of precise, careful measurement that we become aware of our progress. Without such tools, we have no reference points to indicate how far we have advanced or retreated."

———————————————

"With the growth of global networks in such areas as economics and communication, there is no doubt that every aspect of society—including education, politics, the arts, and the sciences—will benefit greatly from international influences."

———————————————

"In any field of endeavor—the sciences, the humanities, the social sciences, industry, etc.—it is not the attainment of a goal that matters, but rather the ideas and discoveries that are encountered on the way to the goal."

———————————————

"When research priorities are being set for science, education, or any other area, the most important question to consider is: How many people's lives will be improved if the results are successful?"

———————————————

"So much is new and complex today that looking back for an understanding of the past provides little guidance for living in the present."

———————————————

"At various times in the geological past, many species have become extinct as a result of natural, rather than human, processes. Thus, there is no justification for society to make extraordinary efforts, especially at a great cost in money and jobs, to save endangered species."

———————————————

"We owe almost all our knowledge not to people who have agreed, but to people who have disagreed."

———————————————

"It is possible to identify a person's politics within a very short time of meeting him or her. Everything about people—their clothes, their friends, the way they talk, what they eat—reflects their political beliefs."

———————————————

"Instant foods, instant communication, faster transportation-all of these recent developments are designed to save time. Ironically, though, instead of making more leisure time available, these developments have contributed to a pace of human affairs that is more rushed and more frantic than ever before."

———————————————

"The past is no predictor of the future."

———————————————

"Society's external rewards are no measure of true success. True success can be measured only in relation to the goals one sets for oneself."

———————————————

"Facts are stubborn things. They cannot be altered by our wishes, our inclinations, or the dictates of our passions."

———————————————

"It is often asserted that the purpose of education is to free the mind and the spirit. In reality, however, formal education tends to restrain our minds and spirits rather than set them free."

———————————————

"Technology is a necessary but not always a positive force in modern life."

———————————————

"How children are socialized today determines the destiny of society. Unfortunately, we have not yet learned how to raise children who can help bring about a better society."

———————————————

"The arts (painting, music, literature, etc.) reveal the otherwise hidden ideas and impulses of a society."

———————————————

"The university community consists of three different worlds—the sciences, the humanities, and the social sciences. Because each world operates on its own assumptions and has its own special habits of thinking, rarely is there meaningful interaction among the sciences, the humanities, and the social sciences."

———————————————

"The problems of modern society have led many people to complain: 'We live in terrible times.' Yet, given the choice, no one today would prefer to live in any other time."

———————————————

"Students should be encouraged to realize that mental agility and rhetorical skill must be accompanied by sincerity and the true conviction of their own beliefs."

———————————————

"While most of the environmental problems we face result from the use of technology, society must depend upon technology to find solutions to these problems."

———————————————

"The absence of choice is a circumstance that is very, very rare."

———————————————

"What we call progress is a matter of exchanging one problem for another."

———————————————

"Only through mistakes can there be discovery or progress."

———————————————

"Every new generation needs to redefine 'right' and 'wrong' in its own terms and according to the conditions of its own time."

———————————————

"What society has thought to be its greatest social, political, and individual achievements have often resulted in the greatest discontent."

———————————————

"Most people recognize the benefits of individuality, but the fact is that personal economic success requires conformity."

———————————————

"The well-being of a society is enhanced when many of its people question authority."

———————————————

"Artists should pay little attention to their critics.* Criticism tends to undermine and constrain the artist's creativity."

*those who evaluate works of art, such as novels, films, music, paintings, etc.

———————————————

"It is the artist, not the critic,* who gives society something of lasting value."

*a person who evaluates works of art, such as novels, films, music, paintings, etc.

———————————————

"A crucial test of character is whether one is able to adapt to changing social conventions without sacrificing one's principles."

———————————————

"People who are the most deeply committed to an idea or policy are the most critical of it."

———————————————

"Tradition and modernization are incompatible. One must choose between them."

———————————————

"Many people admire idealism, but it usually leads to disappointment or trouble."

———————————————

"The most practical and effective way to protect wilderness areas is to attract more tourists to these areas through environmentally sensitive projects."

———————————————

"Because of television and worldwide computer connections, people can now become familiar with a great many places that they have never visited. As a result, tourism will soon become obsolete."

———————————————

"High-speed electronic communications media, such as electronic mail and television, tend to prevent meaningful and thoughtful communication."

———————————————

"The only responsibility of corporate executives, provided they stay within the law, is to make as much money as possible for their companies."

———————————————

"Students should bring a certain skepticism to whatever they study. They should question what they are taught instead of accepting it passively."

———————————————

"Both parents and communities must be involved in the local schools. Education is too important to leave solely to a group of professional educators."

———————————————

"Contemporary society offers so many ways of learning that reading books is no longer very important."

———————————————

"Choice is an illusion. In reality, our lives are controlled by the society in which we live."

———————————————

"There is no such thing as purely objective observation. All observation is subjective; it is always guided by the observer's expectations or desires."

———————————————

The arts (music, dance, visual arts, etc.) are vitally important to students' education and should therefore receive as much emphasis as mathematics, science, reading and other mainstream subjects."

———————————————

"The human mind will always be superior to machines because machines are only tools of human minds."

———————————————

"The most essential quality of an effective leader is the ability to remain consistently committed to particular principles and objectives. Any leader who is quickly and easily influenced by shifts in popular opinion will accomplish little."

———————————————

"In this age of intensive media coverage, it is no longer possible for a society to regard any woman or man as a hero. The reputation of anyone who is subjected to media scrutiny will eventually be diminished."

———————————————

"One often hears about the need for individuals to take responsibility for their own lives. However, the conditions in which people find themselves have been largely established long before people become aware of them. Thus, the concept of personal responsibility is much more complicated and unrealistic than is often assumed."

———————————————

"Most people live, whether physically or morally, in a very restricted circle. They make use of a very limited portion of the resources available to them until they face a great problem or crisis."

———————————————

"Sometimes imagination is a more valuable asset than experience. People who lack experience are free to imagine what is possible and thus can approach a task without constraints of established habits and attitudes."

———————————————

"In any given field, the leading voices come from people who are motivated not by conviction but by the desire to present opinions and ideas that differ from those held by the majority."

———————————————

"Over the past century, the most significant contribution of technology has been to make people's lives more comfortable."

———————————————

"It is impossible for an effective political leader to tell the truth all the time. Complete honesty is not a useful virtue for a politician."

———————————————

"Critical judgment of work in any given field has little value unless it comes from someone who is an expert in that field."

———————————————

"Those who treat politics and morality as though they were separate realms fail to understand either the one or the other."

———————————————

"The surest indicator of a great nation is not the achievements of its rulers, artists, or scientists, but the general welfare of all its people."

———————————————

"People who pursue their own intellectual interests for purely personal reasons are more likely to benefit the rest of the world than are people who try to act for the public good."