## 1
Community service is an important component of education here at our university. We encourage all students to volunteer for at least one community activity before they graduate. A new community program called "One On One" helps elementary students who've fallen behind. You education majors might be especially interested in it because it offers the opportunity to do some teaching—that is, tutoring in math and English. You'd have to volunteer two hours a week for one semester. You can choose to help a child with math, English, or both. Half-hour lessons are fine, so you could do a half hour of each subject two days a week. Professor Dodge will act as a mentor to the tutors---he'll be available to help you with lesson plans or to offer suggestions for activities. He has office hours every Tuesday and Thursday afternoon. You can sign up for the program with him and begin the tutoring next week. I'm sure you'll enjoy this community service and you'll gain valuable experience at the same time. It looks good on your resume, too, showing that you've had experience with children and that you care about your community. If you'd like to sign up, or if you have any questions, stop by Professor Dodge's office this week.

## 2
I hope you've all finished reading the assigned chapter on insurance so that you're prepared for our discussion today. But, before we start, I'd like to mention a few things your text doesn't go into. It's interesting to note that insurance has existed in some form for a very long time. The earliest insurance policies were what we are called bottomry（use boats as mortgage） contracts. They provided shipping protection for merchants as far back as 3000 B.C. In general, the contracts were often no more than verbal agreements. They granted loans to merchants with the understanding that if a particular shipment of goods was lost at sea, the loan didn't have to be repaid. Interest on the loans varied according to how risky it was to transport the goods. During periods of heavy piracy at sea, for example, the amount of interest and the cost of the policy went up considerably. So, you can see how insurance helped encourage international trade. Even the most cautious merchants became willing to risk shipping their goods over long distances, not to mention in hazardous weather conditions when they had this kind of protection available. Generally speaking, the basic form of an insurance policy has been pretty much the same since the Middle Ages. There are four points that were salient then and remain paramount in all policies today. These were outlined in chapter six and will serve as the basis for the rest of today's discussion. Can anyone tell me what one of those points might be?

## 3
Located at the NASA Research Center in Iowa is a 5,000-gallon vat of water, and inside the tank is an underwater treadmill designed by Dava Newman, an aerospace engineer. For four years Newman observed scuba divers as they simulated walking on the Moon and on Mars on her underwater moving belt. She wanted to discover how the gravity of the Moon and of Mars would affect human movement. To do this, Newman attached weights to the divers and then lowered them into the tank and onto the treadmill. These weights were carefully adjusted so that the divers could experience underwater the gravity of the Moon and of Mars as they walked on the treadmill. Newman concluded that walking on Mars will probably be easier than walking on the Moon. The Moon has less gravity than Mars does, so at lunar gravity, the divers struggled to keep their balance and walked awkwardly. But at Martian gravity, the divers had greater traction and stability and could easily adjust to a pace of 1.5 miles per hour. As Newman gradually increased the speed of the treadmill, the divers took longer, graceful strides until they comfortably settled into an even quicker pace. Newman also noted that at Martian gravity, the divers needed less oxygen. The data Newman collected will help in the future design of Martian space suits. Compared to lunar space suits, Martian space suits will require smaller air tanks; and, to allow for freer movement, the elbow and knee areas of the space suits will also be altered.

## 4
Welcome to Everglades National Park. The Everglades is a watery plain covered with saw grass that's home to numerous species of plants and wildlife. At one and a half million acres, it's too big to see it all today, but this tour will offer you a good sampling. Our tour bus will stop first at Taylor Slough. This is a good place to start because it's home to many of the plants and animals typically associated with the Everglades. You'll see many exotic birds and, of course, our world famous alligators. Don't worry, there's a boardwalk that goes across the marsh, so you can look down at the animals in the water from a safe distance. The boardwalk is high enough to give you a great view of the saw grass prairie. From there we'll head to some other marshy and even jungle like areas that feature wonderful tropical plant life. For those of you who'd like a closer view of the saw grass prairie, you might consider renting a canoe sometime during your visit here. However, don't do this unless you have a very good sense of direction and can negotiate your way through tall grass. We'd hate to have to come looking for you. You have the good fortune of being here in the winter—the best time of year to visit. During the spring and summer, the mosquitoes will just about eat you alive! Right now they're not so bothersome, but you'll still want to use an insect repellent.

## 5
Thank you. It's great to see so many of you interested in this series on "Survival in Outer Space." Please excuse the cameras, we're being videotaped for the local TV stations. Tonight I'm going to talk about the most basic aspect of survival—the space suit. When most of you imagine an astronaut, that's probably the fist thing that comes to mind, right? Well, without space suits, it would not be possible for us to survive in space. For example, outer space is a vacuum—there's no gravity or air pressure; without protection, a body would explode. What's more, we'd cook in the sun or freeze in the shade with temperatures ranging from a toasty 300 degrees above to a cool 300 degrees below zero Fahrenheit. The space suit that NASA has developed is truly a marvel. This photo enlargement here is a life-size image of an actual space suit worn by astronauts on the last space shuttle mission. This part is the torso. It’s made of seven extremely durable layers. This thick insulation protects against temperature extremes and radiation. Next is what they call a "bladder" of oxygen that's an inflatable sac, filled with oxygen, to simulate atmospheric pressure. This bladder presses against the body with the same force as the Earth's atmosphere at sea level. The innermost layers provide liquid cooling and ventilation. Despite all the layers, the suit is flexible, allowing free movement so we can work. Another really sophisticated part of the space suit is the helmet. I brought one along to show you. Can I have a volunteer come and demonstrate?

## 6
Good evening. My name is Pam Jones, and on behalf of the Modern Dance club, I'd like to welcome you to tonight's program. The club is pleased to present the TV version of The Catherine Wheel, Twyla Tharp's rock ballet. This video version of the ballet has been even more successful with audiences than the original theater production. It includes some animation, slow motion, and stop-action freezes that really help the audience understand the dance. The title of the piece refers to Saint Catherine, who died on a wheel in 307 A.D. Nowadays, a Catherine wheel is also a kind of firework. It looks something like a pinwheel. Anyway, the dance is certainly full of fireworks! You'll see how Twyla Tharp explores one family's attempt to confront the violence in modern life. The central symbol of the work is a pineapple, but exactly what it represents has always created a lot of controversy. As you watch, see if you can figure it out. The music for this piece is full of the rhythmic energy of rock music. It was composed by David Byrne. Of the rock band Talking Heads? And the lead dancer in this version was Sara Rudner, who is perfectly suited to Tharp's adventurous choreography. Following the video, dance teacher Mary Parker will lead a discussion about the symbolism Ms. Tharp used. We hope you can stay for that. So, enjoy tonight's video and thank you for your support.

## 7
In our lab today, we'll be testing the hypothesis that babies can count as early as five months of age. The six babies here are all less than six months old. You'll be watching them on closed-circuit TV and measuring their responses. The experiment is based on the well-established observation that babies stare longer if they don't see what they expect to see. First, we're going to let two dolls move slowly in front of the babies. The babies will see the two dolls disappear behind a screen. Your job is to record, in seconds, how long the babies stare at the dolls when the screen is removed. In the next stage, two dolls will again move in front of the babies and disappear. But then a third doll will follow. When the screen is removed, the babies will only see two dolls. If we're right, the babies will now stare longer because they expect three dolls but only see two. It seems remarkable to think that such young children can count. My own research has convinced me that they have this ability from birth. But whether they do or not, perhaps we should raise another question. Should we take advantage of this ability by teaching children mathematics at such a young age? They have great untapped potential, but is it good for parents to pressure young children?
## 8
Before starting our tour of Monticello, I'd like to give you some historical facts that might help you appreciate what you see today even more. Monticello was the very much loved home of Thomas Jefferson for over fifty years. Jefferson, who was, of course, President, was also a great reader and language enthusiast. He read widely on different subjects, including architecture. He wasn't formally trained in architecture, but as a result of his study and observation of other buildings, he was able to help design and build the house. He chose the site himself, naming the estate "Monticello," which means "little mountain" in Italian. In fact, many of the ideas behind the design also came from the Italian architect Andrea Palladio, who lived in the sixteenth century and who had a great influence on the architecture of England. Jefferson, however, ignored one of Palladio's principles, that is, not to build in a high place. Monticello's elevation made the transportation of what was needed at the house—for example, food—especially difficult. But the view from the estate would not be as spectacular if Jefferson had followed Palladio's advice; there really is no boundary between the house and the nature around it, and so Jefferson was able to look out on his beloved state of Virginia from his wonderful vantage point. Now we'll go on to Jefferson's library.

## 9
Now that we've all introduced ourselves to the new members, let's get down to work. As the committee in charge of this year's tree-planting project, we have several items on our agenda. First, we have to review the budget. The president has informed me that the trustees have set aside $3,000 for the purchase of trees and our environmental T-shirt sale netted a profit of $1,500. Second, we have to finalize the choice of trees. As you know, we're working with Richardson's Nursery again this year since everyone seemed pleased with the work he did for us last year. Mr. Richardson has presented us with several choices within our price range that he thinks would meet our needs. He's sent us pictures of the trees for us to look at, but he wanted me to tell you that we're welcome to visit the nursery if we want to see the trees themselves. Lastly, we need to plan some kind of ceremony to commemorate the planting. Several ideas, including a garden party of some sort, have been suggested. So let's get on with it and turn to the first order of business.

## 10
Welcome to the Four Winds Historical Farm, where traditions of the past are preserved for visitors like you. Today, our master thatchers will begin giving this barn behind me a sturdy thatched roof, able to withstand heavy winds and last up to a hundred years. How do they do it? Well, in a nutshell, thatching involves covering the beams or rafters, the wooden skeleton of a roof with reeds or straw. Our thatchers here have harvested their own natural materials for the job, the bundles of water reeds you see lying over there beside the barn. Thatching is certainly uncommon in the Untied States today. I guess that's why so many of you have come to see this demonstration. But it wasn't always that way. In the seventeenth century, the colonists here thatched their roofs with reeds and straw, just as they had done in England. After a while, though, they began to replace the thatch with wooden shingles because wood was so plentiful. And eventually, other roofing materials like stone, slate, and clay tiles came into use. It's a real shame that most people today don't realize how strong and long lasting a thatched roof is. In Ireland, where thatching is still practiced, the roofs can survive winds of up to one hundred ten miles per hour. That's because straw and reeds are so flexible. They bend but don't break in the wind like other materials can. Another advantage is that the roofs keep the house cool in the summer and warm in the winter. And then, of course, there's the roofs' longevity—the average is sixty years, but they can last up to a hundred. With all these reasons to start thatching roofs again, wouldn't it be wonderful to see this disappearing craft return to popularity?

## 11
A lot of people in the United States are coffee drinkers. Over the last few years, a trend has been developing to introduce premium, specially blended coffees, known as "gourmet coffees" into the American market. Boston seems to have been the birthplace of this trend. In fact, major gourmet coffee merchants from other cities like Seattle and San Francisco came to Boston, where today they're engaged in a kind of "coffee war" with Boston's merchants. They are all competing for a significant share of the gourmet coffee market. Surprisingly, the competition among these leading gourmet coffee businesses will not hurt any of them. Experts predict that the gourmet coffee market in the United States is growing and will continue to grow, to the point that gourmet coffee will soon capture half of what is now a 1.5-million-dollar market and will be an 8-million-dollar market by 1999. Studies have shown that coffee drinkers who convert to gourmet coffee seldom go back to the regular brands found in supermarkets. As a result, these brands will be the real losers in the gourmet coffee competition.

## 12
You may remember that a few weeks ago we discussed the question of what photography is. Is it art, or is it a method of reproducing images? Do photographs belong in museums or just in our homes? Today I want to talk about a person who tried to make his professional life an answer to such questions. Alfred Stieglitz went from the United States to Germany to study engineering. While he was there, he became interested in photography and began to experiment with his camera. He took pictures under conditions that most photographers considered too difficult. He took them at night, in the rain, and of people and objects reflected in windows. When he returned to the United States he continued these revolutionary efforts. Stieglitz was the first person to photograph skyscrapers, clouds, and views from an airplane. What Stieglitz was trying to do in these photographs was what he tried to do throughout his life: make photography an art. He felt that photography could be just as good a form of self-expression as painting or drawing. For Stieglitz, his camera was his brush. While many photographers of the late 1800's and early 1900's thought of their work as a reproduction of identical images, Stieglitz saw his as a creative art form.
He understood the power of the camera to capture the moment. In fact, he never retouched his prints or made copies of them. If he were in this classroom today, I'm sure he'd say, "Well, painters don't normally make extra copies of their paintings, do they?"

## 13
So, uh . . . as Jim said, James Polk was the eleventh President, and . . . uh . . . well, my report's about the next President—Zachary Taylor. Taylor was elected in 1849. It's surprising because . . . well, he was the first President that didn't have any previous political experience. The main reason he was chosen as a candidate was because he was a war hero. In the army, his men called him "Old Rough and Ready". I guess because of his . . . "rough edges." He was kind of blunt and he didn't really look like a military hero. He liked to do things like wear civilian clothes instead of a uniform, even in battle. And he was so short and plump he had to be lifted up onto his horse. But he did win a lot of battles and he became more and more popular. So, the Whig party decided to nominate him for the presidency, even though no one knew anything about where he stood on the issues. I couldn't find much about his accomplishments, probably because he was only in office about a year and a half before he died. But one thing, he pushed for the development of the transcontinental railroad because he thought it was important to form a link with the West Coast. There was a lot of wealth in California and Oregon from commerce and minerals and stuff. Also, he established an agricultural bureau in the Department of the Interior and promoted more government aid to agriculture. Well, that's about all I found. Like I said, he died in office in 1850, so his Vice President took over, and that's the next report, so . . . thank you.

## 14
I want to welcome each and every balloon enthusiast to Philadelphia. Thank you for coming here this morning to commemorate the first balloon voyage in the United States. On January 9, 1793, at ten o'clock in the morning, a silk balloon lifted into the skies above this city, which was, at the time, the capital of the country. According to the original records of the flight, the voyage lasted forty-six minutes, from its departure in Philadelphia to its landing across the Delaware River in New Jersey. Though our pilots today will try to approximate the original landing site, they're at the mercy of the winds, so who knows where they'll drift off to. Even the balloonist in 1793 experienced some uncertain weather that day. There were clouds, fog, and mist in various directions. Our reenactment promises to be nothing less than spectacular. The yellow balloon directly behind me is five stories high. It's inflated with helium, unlike the original, which was filled with hydrogen and, unbeknownst to the pilot, potentially explosive. Gas-filled models are pretty uncommon now because of the extremely high cost, so the eighty other balloons in today's launch are hot air, heated by propane burners. These balloons are from all over the country.

## 15
I'm glad you brought up the question of our investigations into the makeup of the Earth's interior. In fact, since this is the topic of your reading assignment for next time, let me spend these last few minutes of class talking about it. There were several important discoveries in the early part of this century that helped geologists develop a more accurate picture of the Earth's interior. The first key discovery had to do with seismic waves. Remember they are the vibrations caused by earthquakes. Well, scientists found that they traveled thousands of miles through the Earth's interior. This finding enabled geologists to study the inner parts of the Earth. You see, these studies revealed that these vibrations were of two types: compression or P waves and shear or S waves. And researchers found that P waves travel through both liquids and solids, while S waves travel only through solid matter. In 1906, a British geologist discovered that P waves slowed down at a certain depth but kept traveling deeper. On the other hand, S waves either disappeared or were reflected back, so he concluded that the depth marked the boundary between a solid mantle and a liquid core. Three years later, another boundary was discovered that between the mantle and the Earth's crust. There's still a lot to be learned about the Earth. For instance, geologists know that the core is hot. Evidence of this is the molten lava that flows out of volcanoes. But we're still not sure what the source of the heat is.

## 16
Today we're going to practice evaluating the main tool used when addressing groups—the voice. There are three main elements that combine to create either a positive or negative experience for listeners. They can result in a voice that is pleasing to listen to and can be used effectively. Or they can create a voice that doesn't hold attention, or even worse, causes an adverse reaction. The three elements are volume, pitch, and pace. When evaluating volume, keep in mind that a good speaker will adjust to the size of both the room and the audience. Of course, with an amplifying device like a microphone, the speaker can use a natural tone. But speakers should not be dependent on microphones; a good speaker can speak loudly without shouting. The second element, pitch, is related to the highness or lowness of the sounds. High pitches are, for most people, more difficult to listen to, so in general speakers should use the lower registers of their voice. During a presentation, it's important to vary pitch to some extent in order to maintain interest. The third element, pace, that is how fast or slow words and sounds are articulated, should also be varied. A slower pace can be used to emphasize important points. Note that the time spent not speaking can be meaningful, too. Pauses ought to be used to signal transitions or create anticipation. Because a pause gives the listeners time to think about what was just said or even to predict what might come next, it can be very effective when moving from one topic to another. What I'd like you to do now is watch and listen to a videotape and use the forms I gave you to rate the speaking voices you hear. Then tonight I want you to go home and read a passage into a tape recorder and evaluate your own voice.

## 17
Let's proceed to the main exhibit hall and look at some of the actual vehicles that have played a prominent role in speeding up mail delivery. Consider how long it used to take to send a letter across a relatively short distance. Back in the 1600's it took two weeks on horseback to get a letter from Boston to New York, a distance of about 260 miles. Crossing a river was also a challenge. Ferry service was so irregular that a carrier would sometimes wait hours just to catch a ferry. For journeys inland, there was always the stagecoach, but the ride was by no means comfortable because it had to be shared with other passengers. The post office was pretty ingenious about some routes. In the nineteenth century, in the Southwestern desert, for instance, camels were brought in to help get the mail through. In Alaska, reindeer were used. This practice was discontinued because of the disagreeable temperament of these animals. We'll stop here a minute so that you can enter this replica of a railway mail car. It was during the Age of the Iron Horse that delivery really started to pick up, in fact, the United States transported most bulk mail by train for nearly 100 years. The first airmail service didn't start until 1918. Please take a few moments to look around. I hope you'll enjoy your tour. And as you continue on your own, may I suggest you visit our impressive philatelic collection. Not only can you look at some of the more unusual stamps issues, but there is an interesting exhibit on how stamps are made.

## 18
Most people think of astronomers as people who spend their time in cold observatories peering through telescopes every night. In fact, a typical astronomer spends most of his or her time analyzing data and may only be at the telescope a few weeks of the year. Some astronomers work on purely theoretical problems and never use a telescope at all. You might not know how rarely images are viewed directly through telescopes. The most common way to observe the skies is to photograph them. The process is very simple. First, a photographic plate is coated with a light-sensitive material. The plate is positioned so that the image received by the telescope is recorded on it. Then the image can be developed, enlarged, and published so that many people can study it. Because most astronomical objects are very remote, the light we receive from them is rather feeble. But by using a telescope as a camera, long time exposures can be made. In this way, objects can be photographed that are a hundred times too faint to be seen by just looking through a telescope.

## 19
Before we start our first lab, I'd like to tell you a little bit about the workbook we'll be using. The first thing I'd like to point out is that the workbook contains a very large amount of material, far more than you could ever handle in a single semester. What you're supposed to do is choose the experiments and activities that you want to do—within a certain framework, of course. Part of my job is to help you make your choices. Next, I'd like to mention that in each workbook chapter, there are usually two subsections. The first is called "Experiments" and the second is called "Activities." In the "Experiments" section, the workbook gives full instructions for all the experiments, including alternate procedures. Choose the procedure you wish—there's plenty of equipment available. In the "Activities" section, you will find suggestions for projects that you can do on your own time. You'll see that there are usually no detailed instructions for the activities—you're supposed to do them your own way. If there are no questions, let's turn to Chapter One now.

## 20
Do you have trouble sleeping at night? Then maybe this is for you. When you worry about needing sleep and toss and turn trying to find a comfortable position, you're probably only making matters worse. What happens when you do that, is that your heart rate actually increases, making it more difficult to relax. You may also have some bad habits that contribute to the problem. Do you rest frequently during the day? Do you get virtually no exercise, or do you exercise strenuously late in the day? Are you preoccupied with sleep, or do you sleep late on weekends? Any or all of these factors might be leading to your insomnia by disrupting your body's natural rhythm. What should you do, then, on those sleepless nights? Don't bother with sleeping pills. They can actually cause worse insomnia later. The best thing to do is drink milk or eat cheese or tuna fish. These are all rich in amino acids and help produce a neurotransmitter in the brain that induces sleep. This neurotransmitter will help you relax, and you'll be on your way to getting a good night's sleep. Until tomorrow's broadcast, this has been another in the series "Hints for Good Health."

## 21
Today we'll examine the role that private transportation, namely, the automobile plays in city planning. A number of sociologists blame the automobile for the decline of the downtown areas of major cities. In the 1950's and 1960's the automobile made it possible to work in the city and yet live in the suburbs many miles away. Shopping patterns changed: instead of patronizing downtown stores, people in the suburbs went to large shopping malls outside the city and closer to home. Merchants in the city failed; and their stores closed. Downtown shopping areas became deserted. In recent years there's been a rebirth of the downtown areas, as many suburbanites have moved back to the city. They've done this, of course, to avoid highways clogged with commuters from the suburbs. I've chosen this particular city planning problem—our dependence on private transportation to discuss in groups. I'm hoping you all will come up with some innovative solutions. Oh, and don't approach the problem from a purely sociological perspective; try to take into account environmental and economic issues as well.

## 22
Word comes from California of a new weapon in the war on household pests. Two scientists working for a firm in Anaheim, California, have developed a method to eliminate insects without using dangerous chemicals. The new poison? Hot air. The basic idea is that insects cannot adjust to temperatures much above normal. In laboratory experiments, cockroaches and termites can't survive much more than a quarter of an hour at 125 degrees Fahrenheit, or about 50 degrees centigrade. The new method involves covering a house with a huge tent and filling it with air heated to around 65 degrees centigrade. Hot air is forced in with fans, and the tent keeps the heat inside the house. Since termites try to escape by hiding in wooden beams, the heat treatment must be continued for a full six hours. But when it's all over, and the insects are dead, there are no toxic residues to endanger humans or pets, and no funny smells. Scientists claim that there is no danger of fire, either, since very few household materials will burn at 65 degrees centigrade. In fact, wood is prepared for construction use by drying it in ovens at 80 degree centigrade, which is substantially hotter than the air used in this procedure.

## 23
I'm sure you realize that your research papers are due in six weeks. I've looked at your proposed topics and made comments about them. The most frequent problem was proposing too broad a topic. Remember, this is only a fifteen-page paper. As I return your topic papers, I'd like to look over the schedule which sketches out what we'll do during the next two weeks. Today is Monday; by Friday, I want your preliminary outline. Please be sure to incorporate the suggestions I've made on your topics in your outlines. Next week I'll have a conference with each of you. I've posted a schedule on my office door. Sign your name to indicate the time you're available for an appointment. In the conference, we'll discuss your preliminary outline. Then you can make the necessary revisions and hand in your final outline, which is due two weeks from today. Use the outline style in your textbook and remember it should be no more than two pages long. Be sure to begin with a thesis statement, that is, with a precise statement of the point you intend to prove and include a conclusion. Have you got all that? Your two-page preliminary outlines are due at the end of this week and the final outlines are due after your conferences. Follow the textbook style and include a thesis statement and a conclusion.

## 24
Before we begin our tour, I'd like to give you some background information on the painter Grant Wood. We’ll be seeing much of his work today. Wood was born in 1881 in Iowa farm country, and became interested in art very early in life. Although he studied art in both Minneapolis and at the Art Institute of Chicago, the strongest influences on his art were European. He spent time in both Germany and France and his study there helped shape his own stylized form of realism. When he returned to Iowa, Wood applied the stylistic realism he had learned in Europe to the rural life he saw around him and that he remembered from his childhood around the turn of the century. His portraits of farm families imitate the static formalism of photographs of early settlers posed in front of their homes. His paintings of farmers at work, and of their tools and animals, demonstrate a serious respect for the life of the Midwestern United States. By the 1930's, Wood was a leading figure of the school of art called "American regionalism." In an effort to sustain a strong Midwestern artistic movement, Wood established an institute of Midwestern art in his home state. Although the institute failed, the paintings you are about to see preserve Wood's vision of pioneer farmers.

## 25
In today's class we'll be examining some nineteenth-century pattern books that were used for building houses. I think it's fair to say that these pattern books were the most important influence on the design of North American houses during the nineteenth century. This was because most people who wanted to build a house couldn't afford to hire an architect. Instead, they bought a pattern book, picked out a plan, and took it to the builder. The difference in cost was substantial. In 1870, for example, hiring an architect would've cost about a hundred dollars. At the same time, a pattern book written by an architect cost only five dollars. At that price, it's easy to see why pattern books were so popular. Some are back in print again today, and of course they cost a lot more than they did a hundred years ago. But they're an invaluable resource for historians, and also for people who restore old houses. I have a modern reprint here that I'll be passing around the room in a moment so that everyone can have a look.

## 26
When I was in British Columbia last July working at the department's archaeological dig, I saw the weirdest rainbow. At first I couldn't believe my eyes because the bands of color I saw weren't in a single half circle arc across the sky. Instead, I saw a full circle of rainbow hues hanging in the sky just above the sea. Inside the circle there was a big white disc and above the circle there was another round band of colors forming a halo. There were curved legs of multicolored light coming off the sides of the circles. It was an incredible sight. I ran back to our main camp and tried to get our cook to come with me to see my fantastic find before it disappeared. He just laughed at my excited story and told me that what I saw was noting special, just some "sun dogs." He said I'd be sure to see many more before I left. And sure enough, I did. When I got back from the dig, I asked Professor Clark about the "sun dogs," and she's going to tell us more about them.

## 27
It seems like only yesterday that I was sitting where you are, just finishing my first year of medical school and wondering if I'd ever get a chance to use all my new knowledge on a real live patient! Well, I have good news for you! You don't have to wait until your third or fourth year of medical school to get some hands-on experience! The dean has invited me here to tell you about the university's rural opportunity program. If you enroll in this program, you can have the opportunity this summer, after your first year of medical school, to spend from four to six weeks observing and assisting a real physician like me in a small rural community. You won't have to compete with other students for time and attention, and you can see what life as a country doctor is really like. The program was designed to encourage medical students like yourselves to consider careers in rural communities that are still understaffed. It seems that medical students are afraid to go into rural family practice for two reasons. First, they don't know much about it. And second, specialists in the cities usually make more money. But, on the up-side, in rural practice, doctors can really get to know their patients and be respected members of the community. I participated in the program when it first started and spent six weeks in a small rural town. Let me tell you, it was really great! I got to work with real patients. I watched the birth of a child, assisted an accident victim, and had lots of really practical hands-on experience—all in one summer. And to my surprise, I found that country life has a lot to offer that city life doesn't—no pollution or traffic jams, for instance! My experience made me want to work where I'm needed and appreciated. I don't miss the city at all!

## 28
In the few minutes that remain of today's class, I'd like to discuss next week's schedule with you. Because I'm presenting a paper at a conference in Detroit on Thursday, I won't be here for either Wednesday's or Friday's class. I will, however, be here for Monday's. Next Friday, a week from today, is the midterm exam, marking the halfway point in the semester. Professor Andrews has agreed to administer the exam. In place of the usual Wednesday class, I've arranged an optional review session. Since it is optional, attendance will not be taken; however, attending the class would be a good idea for those worried about the midterm. So, remember: optional class next Wednesday; midterm, Friday.

## 29
Today's lecture will center on prehistoric people of the Nevada desert. Now, most of these prehistoric desert people moved across the countryside throughout the year. You might think that they were wandering aimlessly—far from it! They actually followed a series of carefully planned moves. Where they moved depended on where food was available—places where plants were ripening or fish were spawning. Now often when these people moved, they carried all their possessions on their backs, but if the journey was long, extra food and tools were sometimes stored in caves or beneath rocks. One of these caves is now an exciting archaeological site. Beyond its small opening is a huge underground grotto. Even though the cave's very large, it was certainly too dark and dusty for the travelers to live in, but it was a great place to hide things, and tremendous amounts of food supplies and artifacts have been found there. The food includes dried fish, seeds, and nuts. The artifacts include stone spear points and knives; the spear points are actually rather small. Here's a picture of some that were found. You can see their size in relation to the hands holding them.

## 30
To us, the environment in which fish dwell often seems cold, dark, and mysterious. But there are advantages to living in water, and they have played an important role in making fish what they are. One is that water isn't subject to sudden temperature changes. Therefore it makes an excellent habitat for a cold-blooded animal. Another advantage is the water's ability to easily support body weight. Protoplasm has approximately the same density as water, so a fish in water is almost weightless. This "weightlessness" in turn means two things: One, a fish can get along with a light weight and simple bone structure, and two, limitations to a fish's size are practically removed. Yet there is one basic difficulty to living in water—the fact that it's incompressible. For a fish to move through water, it must actually shove it aside. Most can do this by wiggling back and forth in snakelike motion. The fish pushes water aside by the forward motion of its head, and with the curve of its body and its flexible tail. Next, the water flows back along the fish's narrowing sides, closing in at the tail, and helping the fish propel itself forward. The fact that water is incompressible has literally shaped the development of fish. A flat and angular shape can be moved through water only with difficulty. And for this reason, fish have a basic shape that is beautifully adapted to deal with this peculiarity.

## 31
Current studies show that what goes on labels is an important consideration for manufacturers, since more than seventy percent of shoppers read food labels when considering whether to buy a product. A recent controversy as to whether labels on prepared foods should educate or merely inform the consumer is over, and a consumer group got its way. The group had maintained that product labels should do more than simply list how many grams of nutrients a food contains. Their contention was that labels should also list the percentage of a day's total nutrients that the product will supply to the consumer, because this information is essential in planning a healthy diet. A government agency disagreed strongly, favoring a label that merely informs the consumer, in other words, a label that only lists the contents of the products. The agency maintained that consumers could decide for themselves if the food is nutritious and is meeting their daily needs. The consumer group, in supporting its case, had cited a survey in which shoppers were shown a food label, and were then asked if they would need more or less of a certain nutrient after eating a serving of this product. The shoppers weren't able to answer the questions easily when they were not given a specific percentage. This study, and others helped get the new regulation passed, and now food products must have the more detailed labels.

## 32
Good afternoon. I'm here today to talk to you about a career with our airline. We're especially interested in recruiting people to fill openings for flight attendants. First of all, to work as a flight attendant with us, you must be accepted into our training program and with so many people applying, it's not easy to be selected. From the thousands of applications that we receive annually, we choose fewer than a thousand people for training. So, we require experience serving the public; and it also helps if you've earned some college credits. Also, not everybody who gets accepted into the training program makes it through. The course meets six days a week for five weeks. The training includes extensive classroom work in such subjects as first aid and passenger psychology as well as practical training in flight procedures and meal service. A lot of our graduates say that our flight attendants develop the skills of a nurse, a headwaiter, and a public relations executive! But, as a flight attendant myself, I can say that all of the hard work is worth it. Of course, I get to travel throughout the country, and the airline pays all of my expenses while I'm away from my base station. And, what I like best of all is that I've made friends with people from all over the country!

## 33
Today I want to talk about the Earth's last major climatic shift, at the end of the last ice age. But first, let's back up a moment and review what we know about climatic change in general. First, we defined "climate" as consistent patterns of weather over significant periods of time. In general, changes in climate occur when the energy balance of the Earth is disturbed. Solar energy enters the Earth's atmosphere as light and is radiated by the Earth's surface as heat. Land, water, and ice each affect this energy exchange differently. The system is so complex that, to date, our best computer models are only crude approximations and are not sophisticated enough to test hypotheses about the causes of climatic change. Of course, that doesn't keep us from speculating. For instance, volcanic activity is one mechanism that might affect climatic change. When large volcanoes erupt, they disperse tons of particles into the upper atmosphere, where the particles then reflect light. Since less light is entering the system of energy exchange, the result would be a cooling of the Earth's surface. Of course, this is just one possible mechanism of global climate change. In all probability, a complete explanation would involve several different mechanisms operating at the same time.

## 34
I know you're anxious to get your permits and get started. But there're just a few things I'd like to mention that might help you avoid trouble during your stay. First of all, make sure you carry adequate water. You'll need it if you're hiking, especially in this heat. A good rule of thumb is to bring one gallon per person per day this time of year. Don't try to rely on the park's natural springs to supply all your water needs. And please, do not use soap in the springs. It's your responsibility to protect the park's natural features. For those of you staying beyond the weekend, make sure that you set up camp well away from dry creekbeds. We may get some heavy rainfall, and those creekbeds could quickly become filled with water, and you and all your equipment might end up washed downstream. When you pick up your permits, you'll also get a park services booklet. It'll tell you everything you need to know about the hiking trails. They vary in length, of course, but most of them are under five miles—relatively easy day hikes. Remember, if you're hiking solo, make sure you let someone know you're going and when they can expect you back. And . . . uh, for your own safety, we recommend that you not climb rock faces. A lot of the rock throughout the park is very unstable. One final word: watch out for poisonous snakes. Rattlesnake activity is at its peak this time of year, especially at night. For your own good, we recommend wearing protective clothing and carry a flashlight after dark.

## 35
Last week we talked about Anne Bradstreet and the role of women in the Puritan colonies. Today I want to talk about some other women who've contributed to American history—some famous and some not-so-famous. The first woman I'd like to talk about is Molly Pitcher. Those of you who are familiar with the name may know her as a hero of the American Revolution. But, in fact, there never was a woman named Molly Pitcher. Her real name was actually Mary Ludwig Hays. She got the nickname Molly Pitcher for her acts of bravery during the Revolutionary War. As the story goes, when Mary's—or Molly's—husband, John Hays, enlisted in the artillery, Mary followed, like many other wives did. She helped out doing washing and cooking for the soldiers. She was known to be a pretty unusual woman. She smoked a pipe and chewed tobacco. Anyway, in the summer of 1778, at the Battle of Monmouth, it was a blistering hot day, maybe over a hundred degrees, and fifty soldiers died of thirst during the battle. Molly wasn't content to stay back at camp. Instead, she ran through gunshots and cannon fire carrying water in pitchers from a small stream out to the thirsty American soldiers. The relief that she brought with her pitchers of water gave her the legendary nickname Molly Pitcher. The story also says that she continued to load and fire her husband's cannon after he was wounded. They say she was so well liked by the other soldiers that they call her "Sergeant Molly." In fact, legend has it that George Washington himself gave her the special military title.

## 36
Today we're going to talk about shyness and discuss recent research on ways to help children learn to interact socially. Many people consider themselves shy. In fact, forty percent of people who took part in our survey said they were shy. That’s two out of every five people. And there are studies to indicate that the tendency toward shyness may be inherited. But just because certain children are timid, doesn't mean they are doomed to be shy forever. There are things parents, teachers, and the children themselves can do to overcome this tendency and even to prevent it. One researcher found that if parents gently push their shy children to try new things, they can help these children become less afraid and less inhibited. Another way to help shy children is to train them in social skills. For example, there are special training groups where children are taught things like looking at other children while talking to them, talking about other people's interests, and even smiling. These groups have been very successful at giving shy children a place to feel safe and accepted, and at building up their self-esteem.

## 37
We've just seen two contemporary large birds that cannot fly: the emu and the ostrich. Over here is an interesting specimen from the past. This stuffed animal is not the giant penguin it appears to be, but an auk. This particular kind of auk is very rare, only 78 skins are known to exist and most are not preserved as well as this one. The great auk, as you can see, was a rather large bird, and it couldn't fly either. However, evidence suggests that the auk was an excellent swimmer and diver. Unfortunately, those abilities did not protect it from being easy prey for hungry sailors who years ago sailed the very cold and often icy waters of Greenland, Iceland, and Scotland. In fact, records indicate that the auk was rather tasty and that its eggs. Excuse me . . . that its eggs and feathers were useful as well. Still, it isn't clear what other factors led to the big bird's demise around 1844, the last time anyone reported seeing one. Of course, we believe it's important to take extra precautions to preserve the remaining great auk skins. After all, these specimens should prove invaluable for future scientific research. Does anyone have any questions before we move on to our next bird exhibit?

## 38
I'd like to begin by thanking Dr. Kane for inviting me to be here today. Although I'm not a geologist, I have been collecting minerals for years. My collection is really diverse because I've traveled all over the world to find them. Today I've brought a few specimens for you to see. After I discuss each one, I'll pass it around so that you can look at it more closely. As you know, feldspars are the most abundant minerals and are divided into a number of types. These first samples are orthoclases. Notice that they vary in color from white to pink to red. This glassy one is found in volcanic rock. In fact, I found it in New Mexico on a collecting trip. This next sample that I'll pass around is a microcline mineral, also called amazonstone. You can identify it by its bright green color. It's often used in jewelry and really is quite attractive. These final samples are all plagioclase feldspars. Many plagioclases are very rare, so I'm particularly proud of the variety in my collection. I've also brought a few slides of some larger mineral samples, and if you'll turn out the light now, I'd like to show them to you.

## 39
Welcome to Yellowstone National Park. Before we begin our nature walk today, I'd like to give you a short history of our National Park Service. The National Park Service began in the late 1800's. A small group of explorers had just completed a month-long exploration of the region that is now Yellowstone. They gathered around a campfire, and after hours of discussion, they decided that they should not claim this land for themselves. They felt it should be accessible to everyone. So they began a campaign to preserve this land for everyone's enjoyment. Two years later, in the late nineteenth century, an act of Congress signed by President Ulysses S. Grant proclaimed the Yellowstone region a public park. It was the first national park in the world. After Yellowstone became a public park, many other areas of great scenic importance were set aside, and in 1916 the National Park Service was established to manage these parks. As a park ranger, I am an employee of the National Park Service. In a national park, park rangers are on duty at all times to answer questions and help visitors in any difficulty. Nature walks, guided tours, and campfire talks are offered by specially training staff members. The park service also protects the animals and plants within the parks.

## 40
I need to make sure you understand how to get housing for next year. When you entered as first-year students this year, the school assigned you to a dorm and a roommate, but next year as returning students you'll choose both your roommate and your dorm. But whether or not you actually get to live in your first choice depends on what number you or your roommate draws in the lottery system. The system gives priority to the students who have been here longest. Fourth-year students get the first block of numbers, third-years get the second block, and second-years—like you'll be—get the third. The lower the number you draw, the sooner you choose. Number one gets the first choice, number two gets the second choice, and so on. You can use either your own or your intended roommate's number to make your room choice. If your roommate for next year has been at the school longer than you have, they'll be in a better block of numbers and so will have a better number than any second-year student. But most of you will probably be rooming with other second-year students and so neither of you may have a great number. You may not get into your first or even second choice. Of course, if you've made plans to live off campus, you don't need to enter the lottery at all. Dorm space will be especially tight this year because the dorms on North Campus will be closed for renovations. This means that those of you who draw the worst numbers won't be able to get dorm housing at all. In that case, the housing office will help you find off-campus housing.

## 41
Before I tell you about the interesting discovery related to Tyrannosaurus rex, I need to review something we studied last semester, the difference between what are commonly called cold-blooded and warm-blooded animals. In warm-blooded animals, birds and mammals, for example, the body temperature normally stays within a narrow range, no matter what the outside temperature is. As a result, a warm-blooded animal is usually active in both cold and hot weather because its body temperature can adjust to the temperature of its environment. On the other hand, cold-blooded animals, such as most reptiles, amphibians, and insects, are unable to create enough heat internally to raise their temperature above the temperature of the environment. So, for example, the temperature of a cold-blooded animal falls when the environment is cool. I hope this distinction is clear. Now, moving on to Tyrannosaurus rex, you may know that dinosaurs, being reptiles, are generally believed to have been cold-blooded. Well, a recent research study found that the chemical composition of the bones of Tyrannosaurus rex was consistent with the bones of an animal that has a very narrow range of internal temperature, indicating that it was probably warm-blooded.

## 42
Thank you all for coming out this evening to meet sociologist Ellen Lambert. Ms. Lambert specializes in research on the workplace and recently has been writing about the future of work. This topic should be of special interest, since I know many of you are already at the forefront of workplace technology. For example, let's have a show of hands to see how many people here telecommute at least part of the time. Hmm. I see eight hands raised. Well, you eight folks who work at home and communicate with your office via computer represent one of the trends Ms. Lambert has described: that people are becoming less tied to the workplace. One of the important tools for telecommuting is electronic mail, or E-mail. E-mail lets you send and receive messages almost immediately on your computer, but you control when you read them and when you respond to them. This technology allows people to have more control over time than when relying solely on the telephone. Our guest tonight will discuss how these important changes will alter the way we work. But, before turning the floor over to Ms. Lambert, I would just like to remind you that she will be available to answer any individual questions at the reception immediately following this talk.

## 43
I'm sure almost every one of you looked at your watch or at a clock before you came to class today. Watches and clocks seem as much a part of our life as breathing or eating. And yet, did you know that watches and clocks were scarce in the United States until the 1850's? In the late 1700's, people didn't know the exact time unless they were near a clock. Those delightful clocks in the squares of European towns were built for the public. After all, most citizens simply couldn't afford a personal timepiece. Well into the 1800's in European and the United States, the main purpose of a watch, which, by the way, was often on a gold chain, was to show others how wealthy you were. The word "wristwatch" didn't even enter the English language until nearly 1900. By then the rapid pace of industrialization in the Unites States meant that measuring time had become essential. How could the factory worker get to work on time unless he or she knew exactly what time it was? Since efficiency was now measured by how fast a job was done, everyone was interested in time. And since industrialization made possible the manufacture of large quantities of goods, watches became fairly inexpensive. Furthermore, electric lights kept factories going around the clock. Being on time had entered the language—and life—of every citizen.

## 44
This room is devoted to electric fish. The eel in the tank behind me can produce a strong jolt of electricity to stun its prey, but most of the fish in here produce only weak electrical impulses that are useful for navigating, locating food, and even for communicating. The knife fish is a good example. This fish navigates, using tiny receptors in the skin that are sensitive to electrical impulses. The knife fish produces an electrical signal, and the receptors in its skin let it know when the signal is distorted by a tree root, or some other obstacle, so it can go around it. Fish also use the ability to produce and detect electrical impulses to communicate. They can tell each other what species they belong to, how big they are, and whether they're male or female. We have a tank here that's specially equipped to convert the inaudible signals the fish produce into sounds you can hear when you put on these headphones. I urge you all to listen in when I'm done speaking. Now have a look at the electric rays. Rays are especially interesting to medical researchers because of the organs they use to produce electricity. These organs contain a chemical that carries signals from one nerve ending to the next, not only in rays, but also in people. By studying these organs, scientists hope to learn more about diseases that interrupt the transmission of impulses from one nerve to another.

## 45
So, why did what is now called "modern dance" begin in the United States? To begin to answer this question, I'll need to backtrack a little bit and talk about classical ballet. By the late 1800's, ballet had lost a lot of its popularity. Most of the ballet dancers who performed in the United States were brought over from Europe. They performed using the rigid techniques that had been passed down through the centuries. Audiences and dancers in the United States were eager for their own, "contemporary" dance form. And, so, around 1900, dancers created one. So, how was this "modern" dance so different from classical ballet? Well, most notably, it wasn't carefully choreographed. Instead, the dance depended on the improvisation and free, personal expression of the dancers. Music and scenery were of little importance to the "modern" dance, and lightness of movement wasn't important either. In fact, modern dancers made no attempt at all to conceal the effort involved in a dance step. But even if improvisation appealed to audiences, many dance critics were less than enthusiastic about the performances. They questioned the artistic integrity of dancers who were not professionally trained and the artistic value of works that had no formal structure. Loie Fuller, after performing Fire Dance, was described as doing little more than turning "round and round like an eggbeater." Yet, the free, personal expression of the pioneer dancers is the basis of the "controlled freedom" of modern dance today.

## 46
Today I want to discuss fossil fuels such as coal, oil, and natural gas. The term "fossil fuel" refers to the trapped remains of plants and animals in sedimentary rock. You see, living plants trap energy from the sun by the process of photosynthesis, and they store the energy in their chemical compounds. Most of that energy is released when the plant dies and decays. However, sometimes organic matter is buried before it decays completely. In this way some of the solar energy becomes trapped in rocks, hence the name fossil fuel. Although the amount of organic matter trapped in any one growing season is small, the accumulated remains from millions of years are considerable. Because the accumulation rate is so slow, millions of times slower than the rate at which we now dig up this organic matter and burn it for energy, we must consider fossil fuels as nonrenewable resources. Tomorrow we'll be discussing alternatives to fossil fuels that can be renewed.

## 47
We've been together now in this pottery class for several weeks, and I feel you are all doing very well. I thought you might be interested in hearing about a ceramics workshop that will be held here at the college next month. Kate Ferguson, who was recently named by Ceramics Monthly as one of the dozen best potters in the world, will be at the recreation center for an intensive seven-day workshop. Participants in the workshop will, Kate has assure me, make a lot of pots and be able to work closely with her on refining their techniques and skills. There's only room for eighteen potters and advanced pottery students in the workshop, so everyone will get personal attention. It costs $175, which included all your materials, and a picnic, which is usually attended by all of the participants at the end of the workshop. A $50 deposit is required ahead of time, with the rest of the tuition due by May 15th. I should mention that this workshop is cosponsored by the Van Howe Chemical Company, which is donating the clay. If you want to register for the workshop you should call the recreation center at 5553080. You should really consider taking advantage of this opportunity.

## 48
You might think that most of the patients at sleep clinics are being treated for sleeplessness, commonly referred to as insomnia, but that is not the case. The majority of sleep-clinic patients suffer from disorders of excessive sleep, or "hypersomnia." While most insomniacs somehow manage to drag themselves through the day and function at acceptable, although not optimal levels, this is not so for people who suffer from hypersomnia. They are incapacitated by irresistible urges to sleep during the day, often in inappropriate situations—at business meetings, in supermarkets, or at parties. Even more dangerous is their failure to remain awake when driving or operating machinery. Falling asleep in such situations could obviously be life-threatening. Many hypersomniacs suffer from narcolepsy, for which the primary symptom is excessive daytime sleepiness. Though not apparent in childhood, this symptom most often appears for the first time during the teen years and continues throughout a person's life. The sleep attacks may occur as many as fifteen to twenty times during the course of the day and last for periods from fifteen minutes up to two hours. What can be done to help those suffering from narcolepsy? There are certain drugs that can help, and specialists suggest voluntary napping to decrease the frequency of such sleep attacks.

## 49
Not long ago, some of you may have read about a team of mountain-climbing scientists who helped to recalculate the elevation of the highest mountain in the world: Mt. Everest. Of course, the elevation of Mt. Everest was determined many years ago, using traditional surveying methods. But these scientists wanted to make a more precise measurement using a new method that takes advantage of recent advances in technology. It's called the Global Positioning System. The Global Positioning System uses 24 satellites that circle the Earth. Each of these satellites is constantly sending out signals. And each signal contains important information that can be used to determine the longitude, latitude, and elevation of any point on the Earth's surface. Well, in order to use this system to calculate Mt. Everest's elevation, scientists needed to put a special receiver on its summit to receive signals from the satellites. The problem with this was that, in the past, the receivers were much too heavy for climbers to carry. But now these receivers have been reduced to about the size and weight of a handheld telephone, so climbers were able to take a receiver to the top of Everest and, from there, to access the satellite system signals that would allow them to determine the precise elevation. And it turns out that the famous peak is actually a few feet higher than was previously thought.

## 50
Human populations near the equator have evolved dark skin over many generations because of exposure to the fierce rays of the Sun. A similar phenomenon has also occurred in other parts of the animal kingdom. The African grass mouse is a good example. Most mice are nocturnal, but the African grass mouse is active during daylight hours. This means that it spends its days searching for food in the semidry bush and scrub habitats of eastern and southern Africa. Its fur is striped, like a chipmunk's, which helps it blend in with its environment. Because it spends a lot of time in the intense tropical sun, the grass mouse has also evolved two separate safeguards against the Sun's ultraviolet radiation. First, like the populations of humans in this region of the world, the skin of the grass mouse contains lots of melanin, or dark pigment. Second, and quite unusual, this mouse has a layer of melanin-pigmented tissue between its skull and skin. This unique "cap" provides an extra measure of protection for the grass mouse and three other types of African mouse-like rodents that are active during the day. The only other species scientists have identified with the same sort of skull adaptation is the white tent-making bat of the Central American tropics. Although these bats sleep during the day, they do so curled up with their heads exposed to the sun.

## 51
We're going to start today talking about congressional aides, that is, the people who work for our congressional representatives, both in Washington and in the representatives' local districts. It used to be that members of Congress had a relatively small staff of people working for them, and the role of these people wasn't of primary importance. But now there are thousands of congressional aides, and they've profoundly affected the way the whole government works. Congressional aides work in two different locations: one, in the congressional representatives' local offices, the districts from which they were elected, and two, in Washington. Staff in the local offices help members of Congress stay in touch with citizens in their districts. These citizens can bring problems in in person, or by mail or phone. This personal connection between the aides and the local people can be helpful when the next election comes around. People remember the help they get from the office of their local congressional representative. But as you know, members of Congress have to spend most of their time in Washington taking care of their legislative duties. Over six thousand new laws are introduced in Congress each session. Without help, representatives would have trouble keeping up with the proposed laws that directly affect their districts. So that's why the congressional aides play a major role in Washington. They keep their bosses informed about pending legislation, organize hearings, and just keep their local congressional representatives up-to-date and informed on what's going on in other parts of Congress. Now another thing congressional aides do is to help develop ideas for laws that their bosses can eventually propose to Congress. This can be called the staff's entrepreneurial function, a bit like a business executive trying to find out what products are most popular. Congressional aides promote or encourage laws they think will be popular with the public. You've also got other employees that work for the whole Congress, not just for individual members. We'll talk about these people next.

## 52
Now, you've been reading articles about the tremendous damage done to life and property by earthquakes. That's why seismologists have been working so hard to develop methods of earthquake prediction. We can now predict earthquakes fairly well, but the predictions only locate potential areas of danger. They don't predict the specific time and location at which an earthquake is likely to occur. Today I want to introduce to you three prediction models that have been developed. The first prediction model looks along earthquake faults, those cracks in the Earth's crust, to find what are known as seismic gaps. Seismic gaps are places where the fault has shown little or no seismic activity for a long time. This theory postulates that such places are due for a major shock. The second model relies on phenomena, like ground flit. Using long cylindrical tubes containing water, observers noted that ground tilt tended to occur before major earthquakes. That led them to correctly predict the big Haicheng quake of 1975, the first successful earthquake prediction scientists have ever made. A million people were evacuated from that Chinese city before the earthquake struck. Unfortunately, this method hasn't worked consistently, so we can't say it's been perfected. The third model is based on the theory that major earthquakes closely follow a series of minor ones. Starting with the measurements and timing of the smaller quakes, a complex formula calculates the "times of increased probability" of a much larger quake. Right now, this method, like the first method, cannot predict specific times and places, but that may change as it is further developed. For the moment, none of these models can predict with reasonable levels of confidence.

## 53
That's an interesting question, Tom. Women did participate in the early days of motion-picture making. One of the most outstanding is Lois Weber. She is credited as the first consistently successful woman film director. In the early 1900's, when she first arrived in Hollywood, Ms. Weber made a series of experimental sound films. Now this was almost 20 years before modern "talking pictures" were developed. The dialogue for her movies was recorded on phonograph records and then synchronized with the action on the movie screen, very innovative for that time. In addition, Weber felt that movies should be educational as well as entertaining. She made several highly controversial movies that dealt with the moral and social issues of her day. And some of her most controversial work addressed issues of particular interest to women. Unfortunately, Weber died in 1939, just as Hollywood was beginning to make films aimed primarily at female audiences, which brings me to my next point.

## 54
Well, if there are no more questions, I would like to continue our discussion of human evolution by looking at Homo erectus, the earliest of our ancestors who stood upright. Homo erectus lived about one and a half million years ago and was given that name because, at the time the first fossil was discovered, it represented the first primate to stand upright. There is evidence now that Homo erectus had sharper mental skills than their predecessors. They constructed the first standardized tool for hunting and butchering. They created an extraordinary stone implement, a large teardrop-shaped hand ax whose design and symmetry reveal a keen sense of aesthetics. This detailing, along with the ax's utilitarian value, strongly suggests that Homo erectus had the ability to conceive of and execute a design to specification. In addition, Homo erectus was the first hominid to use fire. This discovery enticed them to cook meat, which they could flavor and keep from spilling by flame, and which paleontologists now believe may have given them a new disease. Some fossil bones of Homo erectus are grossly deformed, and paleontologists have noted that this condition is similar to that found in people today who have been exposed to chronic overdoses of vitamin A. Apparently Homo erectus first got this disease by eating large amounts of animal liver.

## 55
Yesterday we talked about the anecdote. Today we're going to move on to one of the most popular literary forms in Western literature—the short story. A short story is a piece of prose fiction, usually under 10,000 words. Although it's similar to the anecdote, it's really a separate literary form. You'll remember that the anecdote's sole purpose is to entertain, and that it does this by relating a curious or interesting event. Well, there are also events in short stories, but the short story uses the event as something a character reacts to. The reader's interest is captured by the effect that this event has on the character in the story. We're even likely to reread a short story to better understand the character who is being portrayed and why a certain event led to a certain response or action. A short story, though, is not just a short novel. A novel is narrative. It tells a detailed story that usually takes place over a long period of time. A short story is less comprehensive than a novel, and the focus is on a character's mental reaction to an experience. This reaction is the heart of the short story. Now I want you to think back to the short story you read for homework and I'll give you a list of questions to think about.

## 56
One reason oceanographers analyze the sediment on the ocean floor is to see how long-term changes in Earth's temperature have affected the depth of the ocean. By analyzing the remains of sea animals in old layers of ocean sediment, oceanographers can determine the depth of the ocean in the past. They've analyzed hundreds of such layers, including some from the coldest periods of Earth's history—the ice ages. What they've found is that during the ice ages, the amount of water in the oceans decreased. Water levels in the ocean dropped by about four hundred feet. Water from the ocean evaporated and became frozen in continental glaciers, so it didn't drain back into the ocean. When temperatures eventually rose again, the glaciers melted, and the oceans returned to their former depths. Analysis of sedimentary data indicates that periods of glacial freezing and melting occurred in regular cycles of twenty thousand, forty thousand, and one hundred thousand years. Oceanographers are interested in the history of seawater levels because they hope to use this historical data in order to predict the possible effect that global warming could have on seawater levels. If industrial pollutants are capable of heating global temperatures to the point that glaciers begin to melt, it is urgent for us to know precisely how high sea levels will rise as a result.

## 57
Now let's focus on comics in the 1950's. Early in the decade sales were down, so publishers started looking for some new angle to get their readers interested again. They found what they were looking for with horror comics, stories about ghosts and demons that were often graphically violent. Before long, most of the major publishers were printing horror comics, but it all came to an end a few years later. You see, there was a psychologist named Frederic Wertham who claimed that comic books, the horror books in particular, were a bad influence on children and turned them into juvenile delinquents. Wertham even wrote a book called Seduction of the Innocent that showed specific scenes from comics that he thought were a particularly bad influence on kids. Wertham wasn't the only one down on comics. The United States Senate Subcommittee on Juvenile Delinquency also released a report very critical of comics. The result of all this fuss was the creation of the Comics Code Authority in 1995. This is a self-censoring body created by the publishers. Essentially, for a comic book to be approved by the code, it had to be free of the blood and gore that was usually depicted in most horror comics, and evil could never triumph over good. Children had to be shown that crime did not pay. Well, if comic sales were bad in 1950, things got even worse in 1955. Many small publishers actually went out of business. But the industry rebounded by introducing a new lineup of superheroes, characters like Spider-Man and the Fantastic Four. Now, I've brought with me today some comic books from this era to pass around. They're from my own personal collection, so please be extra careful when handling them.

## 58
As you probably know, log structures are gaining in popularity. They are no longer just the simple country homes that we think of as the traditional log cabin. Some upscale homes now incorporate natural round logs in ceiling beams and walls. People seem to think the rounded logs give their homes a cozy, warm atmosphere. And even people who want to build a traditional log cabin on their own can buy a kit with precut logs that fit together like pieces of a jigsaw puzzle. Before showing you some slides of modern log houses, I'd like to give a little historical background on the subject: Log cabins were first built in the late 1600's along the Delaware River valley. The European immigrants who settled there brought centuries-old traditions of working with logs. And in this heavily wooded area, logs were the material at hand. Log cabins were most popular in the early 1800's with the settlers who were moving west. They provided the answer to the pioneers' need for a safe and sturdy home that an ordinary family could build quickly: they had dirt floors and sliding boards for windows. But the log buildings that have probably had most influence on modern architects are those of the mountain retreats of wealthy New Yorkers. These country houses, which were popular in the early 1900's, typify what's known as the Adirondack style. Now let's look at those slides.

## 59
The Old Canada Road is a long-lost trail between the Canadian province of Quebec and Maine, in the northeast corner of the United States. Yes, it really was lost, and finding it again was a complex process that involved state-of-the-art technology. How the location of the road was pinpointed was very interesting, and I'll return to it as soon as I've given you a little background information. The road was begun in 1817, a few years before Maine even became a state. At the time, Quebec was a major market for livestock, crops, and fish, so a road to Quebec was seen by officials in Maine as necessary for trade. For about 20 years, the movement of people and goods was mostly from Maine to Quebec, but then the trend reversed as thousands of Canadians immigrated to Maine to escape poor crops, a lack of jobs, and the threat of disease. I think it was a cholera epidemic. Besides these negative reasons, major building projects in Maine also made the state very attractive for the Canadians who needed work. I should stress, though, that immigration during that period went in both directions. In fact, the flow of people and goods went completely unhindered. There wasn't even a border post until around 1850. The people of the time saw Maine and Quebec as a single region, mainly because of the strong French influence, which is still evident in Maine today. Eventually, the road fell into disuse as a major railway was completed; finally, people simply forgot about it and that's how it came to be lost. This brings me back to the original topic.

## 60
OK. In the last class we talked about the classification of trees, and we ended up with a basic description of angiosperms. You remember that those are plants with true flowers and seeds that develop inside fruits. The common broadleaf trees we have on campus fall into this category, but our pines don't. Now, I hope you all followed my advice and wore comfortable shoes because, as I said, today we're going to do a little field study. To get started, let me describe a couple of the broadleaf trees we have in front of us. I'm sure you've all noticed this big tree next to Brant Hall. It's a black walnut that must be 80 feet tall. As a matter of fact, there's a plaque identifying it as the tallest black walnut in the state. And from here we can see the beautiful archway of trees at the Commons. They're American elms. The ones along the Commons were planted when the college was founded 120 years ago. They have the distinctive dark green leaves that look lopsided because the two sides of the leaf are unequal. I want you to notice the elm right outside Jackson Hall. Some of its leaves have withered and turned yellow, maybe due to Dutch elm disease. Only a few branches seem affected so far, but if this tree is sick, it'll have to be cut down. Well, let's move on and I'll describe what we see as we go.

## 61
I was really glad when your club invited me to share my coin collection. It's been my passion since I collected my first Lincoln cent in 1971; that's the current penny with Abraham Lincoln's image. Just a little history before I start in on my own collection. Lincoln pennies are made of copper, and they were the first United States coin to bear the likeness of a President. It was back in 1909 when the country was celebrating the centennial of Lincoln's birth in 1809 that the decision was made to redesign the one-cent piece in his honor. Before that, the penny had an American Indian head on it. The new penny was designed by artist Victor David Brenner. This is interesting because he put his initials V.D.B. on the reverse of the coin in its original design. There was a general uproar when the initials were discovered, and only a limited number of the coins were struck with the initials on them. Today a penny with the initials from the San Francisco Mint, called the 1909-SVDB, is worth over $500. Now, when I started my coin collection, I began with the penny for several reasons. There were a lot of them. Several hundred billion have been minted, and there were a lot of people collecting them, so I had plenty of people to trade with and talk to about my collection. Also, it was a coin I could afford to collect as a young teenager. In the twenty-five years since then, I have managed to acquire over 300 coins, some of them very rare. I'll be sharing with you today some of my rarer specimens, including the 1909-SVDB.

## 62
Today I want to talk to you about wasps and their nests. You'll recall that biologists divide species of wasps into two groups: solitary and social. Solitary wasps, as the name implies, do not live together with other wasps. In most species the male and female get together only to mate, and then the female does all the work of building the nest and providing food for the offspring by herself. Solitary wasps usually make nests in the ground and they separate the chambers for individual offspring with bits of grass, stone, or mud, whatever is handy. What about social wasps? They form a community and work together to build and maintain the nest. A nest begins in the spring when a fertile female, called the queen, builds the first few compartments of the nest and lays eggs. The first offspring are small females that cannot lay eggs. These females, called workers, then build a lot of new compartments, and the queen lays more eggs. They also care for the new offspring and defend the nest with their stingers. By the way, only female wasps have stingers. Most social wasps make nests of paper. The females produce the paper by chewing up plant fibers or old wood. They spread the paper in thin layers to make cells in which the queen lays her eggs. Most of you, I'm sure, have seen these nests suspended from trees. They may also be built underground in abandoned rodent burrows.

## 63
One of the most popular myths about the United States in the nineteenth century was that of the free and simple life of the farmer. It was said that farmers worked hard on their own land to produce whatever their families needed. They might sometimes trade with neighbors; but in general they could get along just fine by relying on themselves, not on commercial ties with others. This is how Thomas Jefferson idealized the farmer at the beginning of the nineteenth century, and, at that time, this may have been close to the truth, especially on the frontier. But by mid-century, sweeping changes in agriculture were well under way as farmers began to specialize in the raising of crops such as cotton or corn or wheat. By late in the century, revolutionary advances in farm machinery had vastly increased production of specialized crops. And the extensive network of railroads had linked farmers throughout the country to markets in the East and even overseas. By raising and selling specialized crops, farmers could afford more and finer goods and achieve a much higher standard of living, but at a price. Now, farmers were no longer dependent just on the weather and their own efforts. Their lives were increasingly controlled by banks, which had power to grant or deny loans for new machinery, and by the railroads, which set the rates for shipping their crops to market. As businessmen, farmers now had to worry about national economic depressions and the influence of world supply and demand on, for example, the price of wheat in Kansas. And so, by the end of the nineteenth century, the era of Jefferson's independent farmer had come to a close.

## 64
Before moving on to a new topic, I want to finish up our unit on arachnids by looking at what may seem a very unusual aspect of spider behavior, a species where the young spiders actually consume the body of their mother. Unlike most other spiders, this species lays one, and only one, clutch of 40 eggs in her lifetime. The young spiders hatch in mid-spring or early summer, inside a nest of eucalyptus leaves. Their mother spends the warm summer months bringing home large insects—often 10 times her weight—for meal. The catch is always significantly more than her young spiders can eat. So, the mother fattens herself up on this extra prey and stores the nutrients in her extra unfertilized eggs. As the weather turns colder, there are fewer insect prey to hunt. That's when the nutrients stored in those extra eggs begin to seep into the mother's bloodstream. So, when there are no more insects to feed to the young spiders, they attach themselves to the mother's leg joints and draw nourishment by sucking the nutrient-rich blood. After several weeks, the mother is depleted of all nutrients and she dies. But then how do the young get nourishment? They start to feed on one another. Now, if you recall our discussion of Darwin, you'll see the evolutionary value of this: Only the strongest spiders of the clutch will survive this "cannibalism," and the mother spider will have ensured that her genes have an increased chance of survival through future generations.

## 65
Moving away from newspapers, let's now focus on magazines. Now, the first magazine was a little periodical called The Review, and it was started in London in 1704. It looked a lot like the newspapers of the time, but in terms of its content, it was much different. Newspapers were concerned mainly with news events, but The Review focused on important domestic issues of the day, as well as the policies of the government. Now, in England at the time, people could still be thrown in jail for publishing articles that were critical of the king. And that's what happened to Daniel Defoe. He was the outspoken founder of The Review. Defoe actually wrote the first issue of The Review from prison! You see, he had been arrested because of his writings that criticized the policies of the Church of England, which was headed by the king. After his release, Defoe continued to produce The Review, and the magazine started to appear on a more frequent schedule, about three times a week. It didn't take long for other magazines to start popping up. In 1709, a magazine called The Tatler began publication. This new magazine contained a mixture of news, poetry, political analysis, and philosophical essays.

## 66
There's an art exhibition here on campus which ties in well with the discussions we're had about folk art. It's an exhibition of wildlife art calendars from about a hundred years ago. Like most other folk art, the calendar pictures were not considered to be art in their own day. People just thought of them as a way of decorating a practical object. In fact, the calendar pictures were originally printed as advertising for various companies that made hunting or fishing products, like guns or fishing rods. The calendars were handed out free to customers to thank them for their business. Most people just hung the calendars on their walls where the pictures faded in the sun, and then tore the picture off the calendar as each month passed. As a result, collectors today place a lot of value on calendars that are complete and in good condition. Even though the people who used the calendars didn't regard them as art, the original paintings the prints were made from were often of good quality. In fact, many famous wildlife painters created calendar art at some point in their lives. To them, it was a way of getting their work reproduced and shown around. One aspect of the exhibit that I find very interesting is the way these pictures reflect changing attitudes toward wildlife. The pictures in the exhibit often portray the thrill and adventure of hunting rather than any particular concern for wildlife preservation. But most of today's wildlife art shows animals in their natural surroundings without any humans in the scene. This modern wildlife art appeals to large numbers of nature lovers, even those who oppose the practice of hunting.

## 67
As many of you already know, March is Women's History Month, so it's just a few weeks until the university begins its annual observance. The Women's Studies Program, in conjunction with the College Life Office, is pleased to announce that a full schedule of events is planned throughout March. The opening activity will be a lecture by Dr. Linda Thompson, coordinator of the Women's Studies Program; she'll talk about the status of women on college campuses. All students are invited to attend at eight p.m. on March first in the Student Center, Room 112. On March fourth, the Student Center Café will offer a forum for women poets to read their works. The English department's Kate Benson will read from her recently published poetry collection The Ways of a Woman. Student poets will be encouraged to share their poems as well. Interested people should sign up at the Women's Studies Office. On the fifteenth, come out and hear Thomas Lane, author of the best-selling The Gender Connection, talk about male-female relationships. The talk will be held in the Student Center Auditorium at 7:30 p.m. with a reception to follow. Lots of other events are being planned, including a show of the work of women artists, a panel discussion about women's legal issues, and more. Check the campus paper for times and places, or stay tuned to WRUC for further details.

## 68
Welcome to the largest retrospective exhibit this art museum has ever devoted to an architect. The architect chosen for this honor is Frank Lloyd Wright, probably the greatest United States architect of the twentieth century. Wright has the reputation of being arrogant and insensitive to his clients' needs, but his work is based on a set of principles rather than a style. Because of his belief in unity of design and the elimination of unnecessary detail, he resisted his clients' wishes to introduce what he called foreign objects to his carefully designed interiors. Frank Lloyd Wright always tried to achieve harmony of building and setting. The first drawing in the exhibit, of one of his "Prairie" houses, illustrates this integration of the house with the landscape of the American Midwest. You can see how he stresses the horizontal line with spreading roofs and strips of windows. Outside porches stretch into the gardens, making one harmonious whole. Because of this goal of harmony, you won't see skyscrapers among his designs. Wright was criticized for his impractical houses with leaky flat roofs, but his houses also had great virtues. The design of the Prairie houses, for example, made them warm in winter and cool in summer. The drawings and photos in this exhibit will show the enormity of Frank Lloyd Wright's contribution to modern architecture.

## 69
Today, I'd like to turn our attention to an area of management often overlooked in traditional management courses: small-business management. Small businesses have gone from being traditional small-town stores selling food or clothing to sophisticated, high-tech enterprises. And in addition to the important products they produce, they create jobs for lots of people because there are so many of them. It's important for management to keep in mind which of the customers' needs the business serves, because it can't serve all their needs. Writing a business plan that everyone in the organization understands and follows will help to provide the necessary focus and direction. It's important to state clearly what the purpose of the business is. Additionally, each person within the organization must know what tasks to perform in order to fulfill that purpose. Now, if for some reason a business plan doesn't work, try hard to discover why not, rewrite it, and immediately focus on the new plan. A work of caution, however, never give up a bad plan without replacing it. A business has to have a plan because it can't afford to waste its limited resources. And, as you know, waste leads to unnecessarily high production costs. Production costs are at the heart of the company's ability to make a high quality product and sell it at an affordable price.

## 70
The next style of furniture design I'd like to discuss is Shaker furniture design. The Shakers are a religious group that flourished in the nineteenth-century United States. At that time, the Shakers lived in their own communities and believed in living simply. This ideal of simplicity extended to their furniture design, as you will see. Because the shape of their furniture wasn't supposed to be unnecessarily decorative, the furniture's surface became the only place to create visual pleasure. Shaker furniture used light-colored woods like pine, maple, or cherry. It was often painted blue, green, or yellow. As these slides show, some of their most interesting pieces were made for the workplace. Notice that this sewing table has drawers that can be pulled out from either side. This feature enables two people to sew at the same time. Likewise, if you look closely at these slides of counters and workbenches, you'll notice that these pieces were also designed to be used from more than one side. Thus, several people would be able to work at one time. Nowadays, Shaker furniture design's enjoying a revival. The simple but stylish furniture made by the Shakers is popular among affluent collectors, including such celebrities as Bill Cosby and Oprah Winfrey. As you've seen, the plainness of Shaker furniture makes it strangely modern in appearance. In fact, their austere, minimalist designs have influenced several modern furniture designers, some of whom we'll discuss next.

## 71
Scientists are always on the lookout for alternative sources of energy. Today we're going to discuss one that's so plentiful they say it could supply more energy than all the coal and oil in the world. It's found in something called gas hydrate and, believe it or not, that's a kind of ice. That's right. But the water in this ice was way down below the Earth's surface when it was frozen, so it was under a lot of pressure. And trapped inside the crystals of ice are individual molecules of methane --- that's what's in natural gas. All this makes gas hydrate pretty strange stuff. If you touch a match to a piece of this ice, it'll burst into flame. And when geologists bring a chunk of it up to the surface to study at normal air pressure and temperature, gas hydrate begins to hiss and bubble, and in less than half an hour, the ice melts and the methane inside escapes into the air. Now, as you might guess, this can make gas hydrate kind of hard for miners to handle. And then there's the problem of where it's located in frozen arctic regions or in ocean waters off the Atlantic coast, and up to a mile down. Environmentalists warn that mining it could even be disastrous. Offshore drilling could allow seawater to seep down into the huge icy deposits and release tons of methane up into the atmosphere. And methane, our listeners may recall, is a greenhouse gas that could really worsen the problem of global warming. So, gas hydrate may offer some interesting possibilities. But, with all these drawbacks, I'm not going to hold my breath waiting for it to fuel my furnace.

## 72
Today, I want to talk about the Cariboo gold rush of 1858, which began when gold was discovered in the frontier town of Quesnel Forks in the Canadian province of British Columbia. By 1861 thousands of men had flocked to the region hoping to strike it rich. Naturally, as the town grew, supplies had to be brought in, and this was done with mules. Now the mules were quite reliable, but there were some drawbacks. For example, a mule carrying a heavy load could travel only 15 miles in a day, meaning that a typical trip into Quesnel could take as long as 20 days. So, as the demand for supplies continued to grow, a group of merchants and packers decided to try a new approach, believe it or not, they shipped in a herd of camels. I know that sounds strange, but camel trains had been used quite effectively during the California gold rush some 10 years earlier. But the results in the Cariboo region weren't quite the same. In fact it was a disaster. The camels couldn't carry the heavier loads the merchants expected them to. Their two-toed feet were perfect for desert travel, but they weren't suited for Cariboo's rugged mountain terrain. To make matters worse, the mules became very agitated whenever they came across a camel and that caused a lot of accidents on the treacherous mountain trails. The mulepackers went so far as to threaten the camel owners with a lawsuit. But the reason the merchants finally got rid of the camels is because these animals simply weren't cut out for the job.

## 73
Look at our topographical map and you'll see that the middle third of the North American continent from the Rocky Mountains almost to the Mississippi River is pretty flat. This is the Great Plains. This kind of area is sometimes called a prairie, sometimes a steppe. That's s-t-e-p-p-e. The defining features are level terrain, dry climate, and an absence of trees. The Great Plains are actually the former bed of a shallow inland sea. Over millions of years, sediment left by glaciers, water, and wind smoothed out the dry sea bed. As I said, the Great Plaints are bordered on the west by the Rocky Mountains. And it's really the Rockies that are responsible for the formation of the grasslands. The mountains are so high that they block the heavy moist air traveling eastward form the Pacific Ocean. Lighter, drier air passes over the mountains. Until people intervened with irrigation and farms, only grass could grow on the dry, windy plain. In fact, we can divide the Great Plains into three zones. In the west, where it's driest and windiest, the grass is very short. In the eastern zone, there's more rain and grass grows as high as 360 centimeters. In the middle third, there's a mix of grass species that grow to an intermediate height.

## 74
Did you know you can catch a mood? A bad mood isn't spread by a virus like the flu is, but it can be contagious. Moods sort of drift from person to person unconsciously. Slight, unintentional signals carry the mood. You've probably experienced it yourself. You're around someone who's feeling down and showing it—slumped shoulders, downcast mouth, subdued voice—all that sort of thing. Pretty soon you begin to feel depressed too. Of course, good moods are also catching, not just bad ones. Moods spread in steps. One person's facial expression or whatever is observed by another, who then unconsciously begins to mimic. The process is automatic—a split second mimicry. The person isn't even aware of the copying. A full-blown case of mood transfer develops as this copying continues. Not everyone picks up moods to the same degree. Those who're most susceptible often have strong physiological responses to what's going on around them. You know, people who break out in a nervous sweat easily and whose stomachs churn. People don't all send moods equally well either. The best mood senders are expressive people because mood contagion can't happen without signals. If they aren't there—that is, the person gives no indication of the mood they're in—nobody will pick up the mood.

## 75
We've probably all wondered how a new word gets into the dictionary. Take the word "doofus," for example, spelled d-o-o-f-u-s, meaning a stupid or incompetent person. This word, which has been around since the late 1960's in a slang sense, made it into the Merriam-Webster's Collegiate Dictionary only in 1993. Why did it take so long? Well, first of all, dictionary editors like to wait at least three years to be sure a word is going to last, especially a slang word. They don't want to put in a new word prematurely and then have to take it out in the next edition. But even for words that aren't slang, getting into the dictionary isn't easy. New words have to pass a lot of editorial tests, including how difficult or easy they are to look up. There's also a limit to how thick a dictionary can be or how small its type can get before people feel they don't want to use it. Some words have to come out before others can go in. The Collegiate Dictionary adds about ten thousand words to every edition, but it takes out only a few hundred, so choices have to be made very carefully.

## 76
Did you ever wonder why it is that most people are "programmed" to sleep at night instead of during the day? If there's something about the cycle of light and dark that's telling us when to sleep, then shouldn't the sleep cycle of a blind person be different? As it turns out, many blind people—people with no visual perception of light at all—do have the same sleep cycle as sighted people. So now you're wondering, "How can this happen?" The answer is: hormones, one hormone in particular. It's called melatonin. In sighted people, the level of melatonin goes up at night, or when it's dark, and goes down in the day, or when it's light. It's believed that it's the presence of this hormone in the blood that gives us the urge to sleep. If an increase in melatonin level "programs" sighted people to sleep at night, then what about blind people? A researcher, named Dr. Charles Czeisler, tells about an interesting experiment. He tried shining a bright light into the eyes of some blind people. When he did this, he noticed that the level of the melatonin in the blood of these subjects went down just as it would do for sighted people. Somehow, the eyes of these subjects, even though they were damaged and had no visual perception of light, could tell their brain when there was more or less light. Now, this doesn't work for all blind people; in fact, most of Czeisler's subjects had no hormonal response to light at all. Further research may be able to explain this sensitivity to light in terms of the type of blindness of the subject.

## 77
Since we've been discussing alternative fuels lately, I wanted to pass on to you some information I read about a new fuel that's been in the news a lot lately. It's called A-21. It's composed of water and a chemical known as naphtha. It seems to be a very promising fuel because it's much cleaner than the gasoline that we use today. That's not to say that it doesn't pollute, but it is cleaner. A-21 isn't like some other alternative fuels that require completely new types of engines. A-21 still works in regular, everyday combustion engines—like the ones in cars—with only minor mechanical modifications. So changing over wouldn't be a big deal. You may doubt some of these claims as many researchers have. Some people feared that because it contains about 45 percent water it would freeze in the winter. But a small amount of antifreeze was added to it, and that seems to have solved the problem. A-21 has recently undergone street tests in buses in Reno, Nevada. So far it seems to work just fine. This is a good thing, especially in Nevada, because the state government there has passed a law requiring that a large percentage of vehicles in Nevada run on alternative fuels. A-21 should help.

## 78
Today we're going to continue our discussion of modern art and talk about Charles Csuri. Charles Csuri has been a part of many modern art movements. He's worked in Pop Art, Cubism, and Conceptual Art, but he made his mark as a pioneer in computer art. Even long before computers became popular, he was punching cards and feeding them into the big mainframe computer at Ohio State University. In the beginning, he had to work without a monitor, so he was virtually creating art in the dark. He even learned computer programming so he could experiment with this new tool. Through the computer, Csuri has been able to explore a new world of possibilities. For example, the computer enables him to sculpt in three dimensions. Also, he can look at a sculpture from any angle, and move it around, change the location of the light source, or he can copy it in different colors. Over the years, Csuri received numerous grants for various projects. This money allowed him to train students in computer graphics and animation techniques, and to advance the computer as a medium for artists. Even though he uses modern technology, Csuri still insists he is creating art. He's always told his students to keep the issues of art in focus, and not get so caught up in the technology that you forget about the image.

## 79
Now we're entering Kangaroo Country. In all, there are more than fifty different species of kangaroo, and the advantage of zoos like ours is that you see them in their natural habitat. The ones we have all live in the grasslands. On my right, you can see one of the biggest types: the red kangaroo. It travels about 20 miles per hour. It looks like hard work, but hopping actually lets the kangaroo conserve more energy than another animal could when running on four legs. In fact, up to a certain point, the faster a kangaroo goes the more energy it conserves. Rather than taking more hops to increase speed, the kangaroo makes the length of each jump longer. Let's stop here for a minute. Take a look over on your right at this group of kangaroos resting. Can you see that their ears are moving? Hearing may well be the kangaroo's most important sense. Their two large ears can move independently, so sometimes one ear is pointing forward and the other toward the rear. Kangaroos' eyesight is also excellent. They have a wide field of vision and, like most grazing animals, they are especially good at detecting movement. Before we move on, I'd like to point out one more thing: If you look closely, you can see a joey that's a baby kangaroo peering out of its mother's pouch. Before long that joey will be out of the pouch for good. The mother will push it out by the time it's eight months old.

## 80
Before we adjourn, I'd like to remind everybody about the upcoming fundraising event—the ten kilometer run. The run is being organized to help raise money for the renovation of the old gym. Our gym is in desperate need of repair, and the university must rely entirely on private donations to pay for its renovation. This event will be the students' contribution to the effort. The procedure for participating is quite simple. No entrance fees, no advance registration, and you don't have to be the best athlete on campus. You only need to find sponsors willing to contribute one or more dollars for every kilometer of the race that you complete. So, for example, if you run all ten kilometers, you'll collect ten dollars from someone who has pledged to give you one dollar per kilometer. After the run, a race official will record the number of kilometers you've completed. You can then show the record to your sponsors when you collect the money. You might encourage your friends to run in the race by telling them that there will be awards for everyone who gets five sponsors or more. But above all, it'll just be a lot of fun. So, please spread the word and get everyone involved either as runners or sponsors.

## 81
And as we enter this next gallery, please turn your attention to the statue on your right. It's a bust of the seventh President of the United States, Andrew Jackson. It was done by American sculptor Hiram Powers. Mr. Powers is particularly significant to our sculpture collection here at the Metropolitan Museum of Art. His statue entitled California was the first work by an American artist to become part of the collection at the Met. But back to this piece. When Powers was modeling this bust, he asked the President, who was 68 years old at the time, if he wanted to be made to appear younger than that. President Jackson replied that he didn't; so as you can see, he's shown here with wrinkles and lines of aging etched on his face. Consequently, this bust is considered to be one of the most realistic portrayals of Andrew Jackson. Powers traveled from his studio in Italy to the White House to do the original study for the bust. He did the study in clay, cut he sculpted the final statue from fine Italian marble, as you can see. I should add that the usual practice at the time was to get local artisans to do the actual carving of the marble. Note that the President is draped in a Roman toga. This is because in the nineteenth century that was the customary attire for representations of heads of state and other important figures. Powers kept the bust in his studio until after President Jackson's death, when it was sold to the Democratic Club in New York City. It was lent to us here at the Met in 1874 and twenty years later became part of our permanent collection. Now, if you'll step this way, we'll move on to the next piece.

## 82
If you liked the colorful animals we just saw, you're going to love these next animals: frogs. You might not normally think of frogs as being colorful, but these frogs definitely are. They are the dart-poison frogs of Central and South America. Look at their striking colors, often yellow with black stripes or deep blue with black spots. Beyond being nice to look at, these markings have a purpose. They warn predators that these frogs are poisonous. When threatened, these frogs secrete a substance through their skin that would easily kill whatever animal might try to eat them. Their bright colors communicate this, and so most animals tend not to hunt them. Now, speaking of hunting, for centuries these frogs were sought after by hunters. As you might think, the hunters didn't want to eat the frogs, but rather, they captured them for their poison. They would add the poison to the tips of their hunting arrows. Of course, nowadays most hunters use guns. These days, dart-poison frogs are of less interest to hunters than to medical researchers. Researchers believe that they can make new heart medicine from the poison, because it acts as a stimulant on the body's nervous system. Researchers think they could use it to stimulate a weak heart. There is, however, a problem with doing research on these frogs. Those that are caught in the wild will produce their poison until they die. However, those that are born in captivity, like the ones you see here, will not produce any poison at all.

## 83
Okay, as you look at this next exhibit, you'll notice something quite common—an ordinary bar of soap. Now, soap has been around a long time. In fact, the ancient Phoenicians produced soap as a substance for washing the body way back in 600 B.C. They made it by blending goat's fat with wood ash. The Phoenicians, as you may know, regularly traded along the Mediterranean, and they were the ones who introduced soap to the Greeks and Romans. Now, soap was not something welcomed by all countries. In fact, during the superstitious Middle Ages, many people were afraid to bathe their whole body too frequently. They thought it could be dangerous for their health—that it could even kill them. And even after the production of soap became common in some European countries in the eleventh and twelfth centuries, even then some people in the heart of Europe refused to use it. You'll find it interesting that when a duchess was given a box of soap as a present in 1549, she was so insulted that she had the gift-giver thrown off her estate! But by the nineteenth century the attitude toward soap had changed drastically. In some regions of Europe the tax on soap was so high that people secretly made their own. A baron went so far as to suggest that the wealth of a nation could be judged according to the amount of soap it used. Now, if you turn your attention to the next exhibit, you can see how soap is manufactured today.

## 84
The winds of a tornado are the most violent and destructive ones on Earth. Any of you who have seen one knows very well how frightening and powerful they are. What's interesting about them is that scientists don't actually know exactly why tornadoes occur. We do know, however, what happens when tornadoes are formed. As you remember, a front occurs when cool, dry air from the north meets warm, humid air coming from the south, from the Gulf of Mexico, for tornadoes in the United States. Where these air masses meet, a narrow zone of storm clouds develops, and thunderstorms, and sometimes tornadoes, occur. How is this violent weather produced? Well, a mass of warm, humid air rises very rapidly. As it rises, more warm air rushes in to replace it. This inrushing air also rises, and in some cases, especially when there is extreme thermal instability, begins to rotate. When this happens, the rotating air forms a tornado. Even if you've seen tornadoes only in movies, you know that they can demolish buildings in seconds. This is possible because when a tornado passes over a house, it sucks up air from around the house and so the air pressure outside the house drops rapidly. Inside, pressure remains the same. So, air pressure inside is greater than air pressure outside. The result is that the building explodes outward. Next, we'll talk a little bit about how new technological developments are being used to try to predict tornadoes.

## 85
You'll recall that in last week's class I talked about how the sound made by most animals, though sometimes complex, are different from human language. Only in humans do these sounds represent objects and events. Keep in mind that most animals can only repeat their limited utterances over and over again, while humans can say things that have never been said before. Today I want to focus on human language and how it developed. I doubt you'll be surprised when I say that the evolution of language was slow and laborious. There's some reliable evidence that language began with early humans a million and a half years ago. Through the study of the size and shape of brain fossils, scientists have determined that early human brains, like modern brains, had a left hemisphere slightly larger than the right hemisphere. We know that in modern humans, the left hemisphere's the seat of language. We also know that early human brains had a well-developed frontal section, known as Broca's area, which coordinates the muscles of the mouth and throat. It's clear, then, that early humans had a speech apparatus. They could produce any sound that we can. What we don't know is whether early humans used what they had. Since scholars know virtually nothing about prehistoric speech patterns, all they can do is speculate about how language actually originated. Let me give you a brief summary of some of these theories.

## 86
At last month's meeting you asked me to draw up a report about the possibility of keeping the student center open twenty-four hours a day. I decided that the best way to assess the need for expanded hours was to talk to the people who were still in the student center at closing time. First, over the course of the two weeks, I interviewed more than fifty students as they left the student center at its regular closing time of twelve midnight. About eighty percent of them said they would prefer that the center stay open later. Of the three main uses of the center—eating in the snack bar, recreation in the game room or watching TV, and studying by far the most popular late night activity is—and this may surprise you—studying. Almost all of the people I talked to said that their main reason for being in the center after ten p.m. was to study in groups or to find a quiet place to study because their dorm was too noisy. Of course, many of these people used the snack bar or TV room for breaks. My recommendation is that we ask the administration to keep the center open after midnight for studying. The recreation room and snack bar can still close at the usual time. This should meet the objection that it costs too much to staff the center from midnight to eight a.m., which I'm sure will be the first response.

## 87
These days we take for granted the wide variety of music available on the radio. But, this wasn't always the case. In the early days of radio, stations were capable of broadcasting only a narrow range of sounds, which was all right for the human voice but music didn't sound very good. There was also a great deal of crackling and other static noises that further interfered with the quality of the sound. A man named Edwin Armstrong, who was a music lover, set out to change this. He invented FM radio, a technology that allowed stations to send a broad range of frequencies that greatly improved the quality of the music. Now, you'd think that this would have made him a millionaire; it didn't. Radio stations at that time had invested enormous amounts of money in the old technology. So the last thing they wanted was to invest millions more in the new technology. Nor did they want to have to compete with other radio stations that had a superior sound and could put them out of business. So they pressured the Federal Communications Commission, the department of the United States government that regulates radio stations, to put restrictive regulations on FM radio. The result was that its use was limited to a very small area around New England. Of course as we all know, Edwin Armstrong's FM technology eventually prevailed and was adopted by thousands of stations around the world. But this took years of court battles and he never saw how it came to affect the lives of almost everyone.

## 88
I'm going to talk about a train that exemplifies the rise and fall of passenger trains in the United States: the Twentieth Century Limited. Let me go back just a bit. In 1893, a special train was established to take people from New York to an exposition in Chicago. It was so successful that regular service was then set up between these cities. The inaugural trip of the Twentieth Century Limited was made in 1902. The train was different from what anyone had ever seen before. It was pulled by a steam engine and had five cars: two sleepers, a dining car, an observation car, and a baggage car, which, believe it or not, contained a library. The 42 passengers the train could carry were waited on by a large staff. There were even secretaries and a barber on board. It wasn't long before people had to wait two years to get a reservation. As time passed, technical improvements shortened the trip by a few hours. Perhaps the biggest technological change occurred in 1945, the switch from steam to diesel engines. By the 1960's, people were traveling by car and airplane. Unfortunately, the great old train didn't survive until the end of the century it was named for.

## 89
I understand your professor has been discussing several Eastern Woodland Indian tribes in your study of Native American cultures. As you have probably learned, the Eastern Woodland Indians get their name from the forest-covered areas of the Eastern United States where they lived. The earliest Woodland cultures date back 9,000 years, but the group we'll focus on dates back only to about 700 A.D. We now call these Native Americans the Mississippian culture, because they settled in the Mississippi River valley. This civilization is known for its flat-topped monuments called temple mounds. They were made of earth and used as temples and official residences. The temple mounds were located in the central square of the city, with the huts of the townspeople built in rows around the plaza. The Mississippian people were city dwellers. But some city residents earned their living as farmers, tending the fields of corn, beans, and squash that surrounded the city. The city's artisans made arrowheads, leather goods, pottery, and jewelry. Traders came from far away to exchange raw materials for these items. In the slides I'm about to show, you will see models of a Mississippian city.

## 90
As Dr. Miller mentioned, we're trying to recruit volunteers for the Hawk Mountain Sanctuary. But before I get into the details of the volunteer program, I'd just like to tell you a little about what we do there. One of our main jobs is to keep detailed records of the migration patterns of raptors. For those of you who don't know, raptors are birds of prey, like hawks and eagles. Between August and December, we see around twenty different species migrating from Canada and New England. About 20,000 birds. Part of what attracts them to Hawk Mountain is the location on the East Ridge of the Appalachian Mountains. What happens is that the sun warms the ridge in such a way that air currents are formed. The birds just sort of glide along on the air, so they use up very little energy. As volunteers, you'll be helping us keep accurate counts of the raptors. Any drop in number could mean something's gone wrong in the environment because of pesticides or disease, even hunting. We just had a scare with the broad-winged hawks. Their numbers have dropped drastically over the last ten years. It was suggested that the birds may have changed their migratory route. So for 11 days we had several hundred volunteers—stationed every five miles—to observe and count. And sure enough, they discovered that instead of hugging the Appalachians as they'd always done, the broad-wings were cutting a wide path over the Delaware River. Needless to say, we were greatly relieved.

## 91
Everyone is interested in improving their diet. Adding grains is one of the easiest ways. Many people in the United States have a growing concern about nutrition, so grains are often served in restaurants. And many grains are now available in grocery stores, too, though for some you still have to go to health food stores. You can stock up when you go, though, because uncooked grains keep a long time. You'll find that grains are easy to prepare. Many grains are as simple to cook as spaghetti. Barley, for instance, is just cooked in salted water. Remember, though, whole-grain barley, the most nutritious kind, never will get as tender as spaghetti no matter how long it's cooked. Grain-based salads are easy, too. Just use grains left over from a hot meal. You call even put together a grain salad hours before you need it, since grains don't wilt like lettuce does. But to get back to health factors, all grains are nutritious and many have special benefits. Barley has very little fat. Some experts believe that it may even reduce cholesterol levels. Jasmine rice is also low in fat. And it has a bonus in its wonderful aroma, a very special fragrance.

## 92
Well, in answer to your question, several women actively participated in the Civil War. The one that comes immediately to mind is Mary Walker. She's important because she's the only woman ever to be awarded the Congressional Medal of Honor. As you know, this medal is given to people who've served the United States with exceptional bravery. In addition, she was the only female physician in either of the two armies that fought in that war. Even though she had two medical degrees, many officers made her life difficult because they didn't believe that a woman should be a doctor. However, she refused to back down and leave the army. In fact, she risked her life several times during the war and was even captured at one point, but she was soon released. Umm, after the war, she was arrested several times for wearing pants. And although Congress eventually tried to take her medal away, she refused to give it back and continued to wear it wherever she went. She died in 1919, a year before women received the right to vote, which brings me to my next point.

## 93
So, you see, physical illness can have psychological causes. Now, we just have time to introduce another interesting example of the interaction between the mind and the body, placebos. Placebos—maybe you've heard them called sugar pills—are harmless substances, not always sugar, that are used routinely on groups of sick people in experiments. These experiments test the effectiveness of new drugs. One group is given the new drug, the other group is given a placebo, and the results are measured. As you might guess, some of the people who receive the new drug get better. Surprisingly, however, some of the placebo group also get better. Why? Well, it's an interesting question, one which doctors can't quite answer. Some of the group may have gotten better on their own, without any treatment at all, but research has shown that the very act of taking a medication that you think will make you better, often does make you feel better. Have you ever taken an aspirin and felt better in five minutes? Aspirin doesn't work that fast, does it? Basically, if you believe you will get better, sometimes you do. The history of how doctors and healers have used the mind-body connection to cure people is long and interesting, but I see that it's time to chose, so I'll have to cover this in the next class. You'll have to hold your questions on this topic till then. Before you go, I have some handouts for you concerning the midterm exams next week.

