import * as i18n from "i18next";
import { initReactI18next } from "react-i18next";
import en from "@/i18n/en.json";
import es from "@/i18n/es.json";
import zh_CN from "@/i18n/zh-CN.json";

// the translations
// (tip move them in a JSON file and import them,
// or even better, manage them separated from your code: https://react.i18next.com/guides/multiple-translation-files)
const resources = {
  en: {
    translation: en,
  },
  es: {
    translation: es,
  },
  "zh-CN": {
    translation: zh_CN,
  },
};

i18n
  .use(initReactI18next) // passes i18n down to react-i18next
  .init({
    resources,
    lng: "en",
    supportedLngs: ["en", "es", "zh-CN"],
    fallbackLng: "en",
    interpolation: {
      escapeValue: false, // react already safes from xss
    },
  });

export default i18n;
