# 真假之别

“学习” 的 “真” 与 “假” 区别到底在哪里呢？区别很大，区别也很多，然而，最根本的区别却也简单：

> **不肯花时间。**

人们在 “学习” 上花钱通常并不吝啬，尤其是在 “为孩子的学习花钱” 上。不仅不吝啬，弄不好绝大多数人都很 “铺张” 也很 “夸张”。有则新闻说，有对父母培养三个孩子，说花了恨不得一个多亿…… 结果三个孩子都一样，从名牌大学毕业之后，依然是 “啃老一族”。从绝对金额上来讲，这肯定是极少数家庭才花得起的钱，但，从比例上来讲，父母把绝大多数钱都花在孩子身上，尤其是 “学习” 上，这种现象在全世界都很普遍…… 所谓的 “绝大多数钱”，从比例上来看，超过父母总体收入的 60% 并不罕见，高达 80% 也不稀奇。

可问题在于，“学习” 这个东西，要是花钱就能搞定，天下就没有 “学渣” 了，只有 “学贫”。要是学习只要花钱就能搞定，那么，人群之间的学习成绩差异，或者能力差异，就应该与 “贫富差距” 完美联动，富有就能学习好，贫穷学习就不好，越富学习越好，越穷学习越差…… 显然，这世界并非如此。也幸亏不是如此。

学习不可能没有金钱成本，书本、文具、教师、教练、场地、设备，跟现实中其他的商品一样，都可以明码标价…… 然而，真正的 “成本”，除了 “金钱成本” 之外，更 “贵” 的，其实是 “时间成本”。因为 “钱” 毕竟花完了还可以去赚，可 “时间” 呢？它一去不回，几乎想不到什么方法去 “存储”，也根本不可能 “再生”。

一本书，可能五六十元人民币买回来，但，读完它，根据它的厚度和难度，可能需要一天、一周，甚至一个月或者半年的时间，这还不算践行所需要的时间…… 当然，“一门课” 往往比 “一本书” 更贵，可能几百块甚至几千块，可问题在于，无论如何，时间都比钱更 “贵”。

时间这个东西，“无价” ，有的人的时间是因为没有价值而没有办法标价，乃至于 “无价”；而与此同时，另外一些人的时间不是一个 “空洞的概念”，而是 “生产资料”，甚至是 “万物的存储”，那可是一根 “长度不断延展且直径不断扩大的管道”，价值无限，前途无量，所以没有办法标价，乃至于 “无价”。（参见《财富的真相》）

买来一本新书或者去上一门新课的时候，人们都一样，精神抖擞，暗中想着 “重新做人”…… 可那 “决心” 持续不了几秒 —— 说实话，那早就养成了习惯，下一秒就开始自顾自地安心做回原来的自己了。

自从图书电子化之后，很多之前鲜为人知或者不为人知的数据浮现了出来 —— 所谓 “数据”，就是事实的总结 —— 大多数人在 “花钱” 买了书之后，压根就做不到 “花时间” 看完，哪怕是浮皮潦草囫囵吞枣。据说，Kindle 的后台数据里可以看到清楚的 “打开率”，大抵上也是在 $\frac{1}{4}$ ~ $\frac{1}{3}$ 之间，也就是说，差不多有 $\frac{2}{3}$ ~ $\frac{3}{4}$ 的电子书籍被购买下载之后，从来就没有被打开过。钱倒是花了，时间彻底缺席。这种 “买回来却没看的书” 在日语里还有个专门的词汇，叫做 “[積ん読](https://zh.wikipedia.org/?curid=7394706)”……

2016 年，我在得到平台撰写了一整年的专栏，《通往财富自由之路》，是当年最畅销的专栏。到 2023 年年底，199 元人民币的单价，7 年累计销量超过 30 万…… 可，到最后，有多少人读完了呢？全年最后一讲，第 52 讲，显示 “170,052 人学过”，分母是 “30,177 人加入学习”，算下来大约是 56.65% 的完成率，一半多一点点 —— 其实，这在得到平台上都是 “历史最高完成率” 了。

说来好笑，只要你买来一本书，能够认真读完，或者，上一门课，认真听完，你就已经直接打败了至少 50% 以上的人群；如果书籍或者课程的难度高一点，仅仅 “读完” 或者 “听完” 本身就能打败至少 80% 的人群；如果竟然在 “读完” 或 “听完” 的基础上，还肯继续花时间完成 “学习” 总计至少四个环节 —— “**学**”、“**练**”、“**用**”、“**造**” —— 中的后三个环节，你就能打败 90% 以上的人群，甚至 99.9%、99.99%……（关于 “学习的四个环节”，参见《[自学是门手艺](https://github.com/selfteaching/the-craft-of-selfteaching)》）

如此看来，认真写书、认真讲课的人，总是收获最大，从 “时间成本投入” 上来看，他们自然而然地打败了 99.99% 的人 —— 甚至都不是 “出自故意” —— 因为他们无论在 “学习” 的四个环节中的哪个环节上，完成度都是 100%，不可能有任何例外。

“时间” 这个东西，不管你 “花” 或是 “不花”，它都自顾自地流逝。“花时间” 做 “有用的事”，比如 “学”、“练”、“用”、“造”，真正的难点在于 “**注意力集中**”，并且还要在 “**足够长的时间里持续注意力集中**”。

所以，其实有比 “花钱不花时间” 更为精准的说法：

> **“不肯花注意力”，或者 “不能花注意力”。**

没有被注意力填充的时间，实际上是空洞的时间，这也是为什么很多人 “好像花时间” 了却从无进展的原因，因为他们投入的时间 “并未用注意力填满”，所以才毫无用处。毫不夸张地讲，“掌控自己的注意力”，就是 “掌控自己的命运”…… 对绝大多数人来说，很难有什么 “命不好” 这一说，都是自己无能而已。

绝大多数人甚至 “压根就没有能力用注意力填充时间”。大多数人实在是太不爱惜自己的注意力了 —— 别说 “爱惜” 了，他们甚至 “毫不在意” —— 乃至于自己的多巴胺系统早就被各式各样的力量 “劫持”，反复劫持，叠加劫持，他们甚至无法在任何事情上注意力集中哪怕短短 2 分钟以上…… 这一点 “时长”（或称 “注意广度”）干什么都不够用。（参见《专注的真相》）

很多人不是 “不肯花注意力”，而是 “不能花注意力”，也就是说，他们甚至 “没有能力用注意力填充足够长的时间”。

“启动任务” 中的最大关键在于 “**每天至少三个小时**” —— “三小时”，“至少三小时”，还得是 “每天” —— 并且，请注意，我们指的是 “**每天至少持续注意力集中的三小时**”……

之所以在 “启动任务” 中不讨论方法和技巧，就是因为如果没有 “足够长时间的注意力集中”，一切都是空谈。仔细回想一下吧，过去在 “学” 任何东西的时候，你有没有为它做到 “**投入每天至少持续注意力集中的三小时**”？如果做到了，怎么可能学不会学不好呢？如果从来都没有过，那可不就是 “学了个假习” 吗？很多人终其一生从来都没 “真学” 过任何东西，这怪得了谁呢？

人们普遍会以为自己没学好什么东西，是因为 “缺乏天份”，或者 “没找到正确的方法”…… 都是扯淡。首先，学啥都不用靠天份的。至于 “正确的方法” 么，无论干什么学什么，人类史上就没有过 “绝对最好的方法”，因为 “方法” 这个东西一直都在不断改进；也就是说，历史上人们一直在使用的，从来都是相对于当下或者未来 “相对落后” 或者 “不尽完善” 的 “方法”，可 “相对落后或者不尽完善的方法” 从来也没有阻止少数人学会学好，为什么？**因为 “投入足够的注意力” 从来都是只有极少数人才能做到的事情。**

如果你只是个学生，回头审视一下你经历过的所有所谓 “学习” 罢 —— 从这个视角望过去，你只能憎恨那个 “假学习” 的自己，一直以来，你浪费的不仅是生命，还是更为宝贵的青春，且最终颗粒无收。如果你是父母，亡羊补牢的方法是从现在开始 “真学习”，运气好的话，还可以和自己的孩子一起 “真学习” —— 绝对不要再 “假学习” 了罢。

天下一切学习的真假，都可以用这个简单的数值衡量，真假之间，只有一条细细红线：

> “**每天持续投入的注意力有没有超过三个小时?**”

市面上有个流行的说法，叫做 “一万小时定律”，是 2008 年出版的《异数》（Outliers）的作者马尔科姆·格拉德威尔（Malcolm Gladwell）提出的一个概念。说是，“所有的超群之人，所谓的 ‘异数’，都是通过一万小时以上的刻意训练养成的”。

到底是否 “一万小时” 之后就真的百分之百确定能够 “超群” 成为 “异数”，到最后还是 “因人而异”；但，依我的经验和观察，“**一百小时**” 足以 “起步” —— 其中一部分是 “学” 大部分是 “练”；而 “**一千小时**” 足以 “打下扎实基础” —— 必须用来 “练”，并且只能是 “自己练”；至于剩下的么，都是在 “用” 和 “造” 的过程中完成的 —— 当然，还是 “自己用”、“自己造”，不是吗？

这里面有个重要的细节。这世上大多数有用的技能，实际上并不需要 “超群” 才够用。无论是什么技能，超越六成以上的人群，就已经 “相当够用”，超越 “八成” 以上的人群就已经 “极其好用”…… 并且，真正厉害的，可能是 “**多维竞争力**”；仅仅某项技能超群，在面对 “多维竞争力” 的时候，常常有点无能为力呢。（参见《通往财富自由之路》）所以，没必要被 “一万小时” 吓到，**但，“一千小时” 必须做到。**

“**每天至少三小时**”，“**一年内一千小时的注意力投入**”，这就是 “**真学习**” —— 无论是什么，只要能做到这一点，就都能学会都能做好。否则，就是 “**瞎混**” —— 就这么简单，就这么清楚，就这么确定。

为什么 “每天至少三小时” 呢？

首先，这里面是 “简单的算术” —— “每天至少三小时” 的话，只要一年下来，“一千小时” 就投入完毕。这是任何人都可以接受的 “学会一样东西” —— 或者准确地讲，“为某项技能打下扎实的基础” —— 的 “时间成本”。

那有人会问，我 “一天一小时干三年” 行不行？不行！必须 “每天至少三小时”。虽然投入时间看起来差不多，但效果会被稀释，效果上来看，“一天一小时干三年” 可能只会达到 “一天三小时干一年” 的 $\frac{1}{10}$…… 你自己不就很可能是 “活生生” 的 “平均一天十分钟干了廿年到最后啥都不会” 的实例吗？

更为重要的是，从脑科学的角度来看，这是 “**脑体协调**” 训练的必要强度。一切的学习，本质上来看，都是 “脑体协调训练”，甚至连 “思考” 这类的 “活动”，都是 “脑脑协调” —— 那不还是 “脑体协调” 吗？因为 “大脑” 同样也是一个 “身体器官”。脑神经之间创造新的链接，并将其强化，就是至少需要这样的强度，这也是为什么我们会把所谓的 “努力” 清楚地定义为 “**短时间内足量重复**” 的根据。

还有另外一个考虑，1000 小时，是用来打下坚实的基础的 —— 主要通过 “练” —— 这一部分如果不能尽快完成，那么后面的 “用” 和 “造”，就实在是太 “遥遥无期” 了，策略上来讲不划算。

不仅要自己学会，也要教会自家孩子。人们一生都在 “学习”…… 可是，那 “学习” 到底是真是假呢？到最后，绝大多数人在绝大多数时间里经历的其实都是 “假学习”，其结果是连锁反应，学了个假习，上了个假学，读了个假书，工了个假作，锻了个假练，时不时度个假假，甚至结了个假婚，生养了一个或者几个假孩子，终究虚度了整个假的人生。何苦？

另外，很多人会觉得 “三小时” 很难做到。有一个通用的诀窍就是，“**为了学习，早睡早起**” —— 你可以 6 点起床，也可以 5 点起床，甚至可以 4:30 起床。早上的时间之所以好，是因为 “没有人打搅”，甚至 “没有人知道” —— 在这样的时间里，“专注” 相对更容易更自然。早上两小时，白天或晚上再添一小时，很容易做到。

很多人会被 “每天三小时” 吓到，觉得自己 “压根做不到” —— 那就直接放弃罢。这一条做不到，后面说什么都没用…… 但是，“放弃” 是有 “后果” 的，只要你愿意或者敢于承担那个 “后果”，你就放弃呗 —— 当然，那后果的承担，其实并不是你愿意不愿意所能决定的，你只能承担、必须承担、无论如何都得承担。
