# 说己想说

过往的日子里，人们在 “学习外语” 的时候，最难办的一点是：

> 头脑越复杂的人学习越困难。

反过来，头脑简单的人学外语竟然更快更简单…… 为什么呢？因为他们头脑简单，所以，“想说的话” 都很简单，学起来也更容易。头脑复杂一点的人呢？觉得见面打招呼说 “Hello!” 离开的时候说 “Goodbye!” 算不上是什么 “说外语”。他们 “想要说的话” 相对更难说，意义更深，篇幅更大，结构更复杂，逻辑更严谨…… 起码，他们不大可能满足于只说 “几个词而已”，他们想把某件事儿或者某个想法说清楚 —— 不仅是 “突然之间”，也是 “不知不觉之间”，他们把自己所面临的难度提高到 “不可能” 的地步。

比如，哪怕就上面开篇那一段话，其实没多复杂，也没多深刻，逻辑倒是清晰 —— 但，你自己试试用英语说出来？试试就知道了，小学六年、中学六年、本科四年，十几年的所谓 “学习”，好像并不给力。

“如果我自己有个专属的外教就好了……” —— 谁都有过这样的想法。要么你自己先打打草稿再让他帮你看看，要么干脆让他翻译之后说给你听，而后你再练练…… 可要命的是，你怎么可能有一个专属的随叫随到的外教呢？反正，我没有。这并不仅仅是 “外教贵不贵” 的问题，其实，这更是人口比例问题 —— 中国人口太多。

就算是把所有美国人都请来，也显然不够用。把加拿大所有人口都拉到中国，一个上海市就不够用了（加拿大人口仅相当于上海市人口 —— 两千多万）。再说，把老外请来就可以了么？不一定吧？不是每个老外都识字的、不是每个识字的老外词汇量都足够大的、不是每个词汇量足够大的老外都有文化的（拥有足够的知识储备和思考能力）。

事实上，在中国境内的所谓 “外教”，（我猜）很可能半数以上只不过是徒有虚表而已 —— 很可能全世界都一样 —— 他们其实并没有足够的知识储备，也没有足够的思考能力，更没有足够的学术训练，若是让他们写个托福作文或者 SAT、GRE 作文能得满分的概率实际上很低。这些外教中的绝大多数在美国当初也没能力考进好大学（当然更不见得将来有能力考上研究生或者有能力攻读博士学位）…… 尤其对那些正在准备 TOEFL/SAT/GRE 的中国学生来说，这些 “外教” 之中有多少可以算作是合格的呢？

更进一步，就算有一些确实合格又怎么样呢？数量那么少（肯定是极少数），你我这样的普通人有多大的概率能得到他们的帮助呢？而如果我们真的有机会遇到这样足够合格的外教，我们是否真的能够付得起费用呢（让这样的人免费干活是不是太过分了）？就算我们遇到了且又支付得起费用，我们自己当时的水平是否足以配得上那么昂贵且又珍贵的帮助呢？

**突然之间，人工智能出现了。**

突然之间，**人工智能成了天下最好的 “外语老师”** —— 没有任何中国制造的 “英语老师” 比人工智能更好更管用…… 其实，哪怕任何一个母语使用者（不管是哪一种语言），即，所谓的 “外教”，在 “外语学习” 这一特殊的领域里，都不可能做得比人工智能更好。

你为人工智能设定角色，说：

> 你是我的英语教练。
> 请将我的话改写成英文。
> 不需要逐字翻译。
> 请分析清楚我的内容，而后用英文重新逻辑清晰地组织它。
> 请使用地道的美式英语，纽约腔调。
> 请尽量使用日常词汇，尽量优先使用短语动词或者习惯用语。
> 每个句子最长不应该超过 20 个单词。

然后，你再给它一段你想说的话，比如，就给它文章最开头的那段文字。也许需要略微等待，但它肯定比任何 “人” 的反应都快，它就返回结果，要几个版本就给几个版本…… 以下是某个版本：

> In the past, when people were "learning a foreign language", one of the toughest parts was:
>
> > The more complex-minded individuals found it harder.
>
> Conversely, those with simpler minds learned languages faster... why? Because their thoughts are simple; what they want to say is straightforward and thus easier to learn. What about those with a more intricate mind? To them saying "Hello!" as a greeting or  "Goodbye!" when leaving doesn't really count as “speaking a foreign language”. Their desired expressions are relatively difficult, profound in meaning, larger in scope, structurally complicated and logically stringent… At least they ain't likely satisfied by uttering just “a few words"; They aim at making things clear – not only out of blue but also subconsciously. In doing so they inadvertently raise the difficulty level for themselves up to an impossible notch.

再进一步，它还能生成语音给我们：

<audio src="../audios/b2a0c7a6fcdc2e269f35fd045e5debfe.mp3">

照着读，照着念，反复，直至流利，甚至背诵 —— 完事！

“**想说什么就能说什么**” —— 这实在是太重要了！并且，完全不用担心自己说得对不对，好不好 —— 照着说肯定没毛病 —— 这又是多大的解脱啊？！至于以前你总是担心的是否 “地道”？也全无压力，既然它是人工智能，你要 “纽约腔调” 它就给你 “纽约风格的文本”，你要硅谷的它就给你硅谷的、你要伦敦的、墨尔本的、多伦多的，甚至苏格兰或者爱尔兰的，都行，反正它都会…… 无论你要的是 “日常随意” 还是 “学究口气”，反正什么风格都能给你搞定。

一方面，“最高难度” 降低，而另外一方面，“说自己想说的话” 原本也的确没有多难…… 至少，比想象的容易很多。

传统 “外语教科书”，尤其是 “口语书” 的问题在于，它什么都想教你，毕竟，如果一本 “口语书” 竟然并不全面，那么就根本卖不出去 —— 可实际上，你需要的并不是 “什么都会”，而是 “我想说的，我会说的，我就能说”。

举个例子，一个以 “星巴克” 为场景的对话，若是追求完整的话，感觉上我们所需要学的东西实在是太多了 —— 很奇怪的是，我们在咖啡馆里几乎从来不说 “coffee” 这个词 —— 拿铁、美式咖啡、焦糖玛奇朵、卡布奇诺、脱脂牛奶，低因，糖浆，榛果味糖浆，到底要几泵糖浆…… 可是，对我来说，永远是 latte，hot，medium，然后呢？然后没了！真的没了！人家看我自己一个人，通常不会问几杯？如果人家真的问了，我可能并不需要说话，只需要伸出一个手指头就行了……

同样的道理，当我们在日常相互聊天的过程中，无论多么深入，我们所说的话，其实 “都仅仅是我自己知道的，我自己思考过的内容”，而不是 “无所不知、无所不晓、无所不聊”…… 这就好像我在讲台上讲课一样，我需要做到的是 “在台上的一两个小时里绝对不出错”，而不是 “我什么都知道，我什么都会” —— 我又不是什么 “百科全书”、“搜索引擎”、或者人工智能……

这就是为什么天下没有什么 “口语书” 的确适合你的根本原因 —— 每个人都太不一样了，每个人的感受不同，想法不同，经历不一样，表达方式不一样，哪儿哪儿都不一样，否则，为什么要交流呢？

结果呢？教科书里十句里只有一句我自己用的上的，我想说的十句里有九句教科书里没有…… 多头疼啊？！

所以，必须通过积累为自己创作一个 “**专门为自己定制的口语书**” ——人工智能的出现，完美地解决了这个过往在那么长的时间里令所有人都束手无策的无奈。

历史上，收音机的出现，曾经 “突然增加了多语使用者的数量”，再往前，词典的普及，也发挥过同样的作用，再往后，录音机、电子词典、互联网百科全书、搜索引擎、影视剧的互联网传播，等等等等，都极大提高了多语使用者的数量…… 现在呢？

人工智能的出现，再一次会极大提高多语使用者的数量，并且数量的增加，很可能不止一倍两倍，而是一个或者数个量级的变化。

二十多年前，我曾经慨叹，在教学领域，因为互联网的存在，“每个领域只要有一个老师就够了” —— 我们只需要一个最好的老师，剩下的，都改行吧，干点别的，这样才能更好地贡献社会，这样才有助于提高社会整体效率。

五年过去、十年过去、廿年过去，我的 “预言” 并未成真…… 为什么呢？其实问题并不在于 “互联网是否足够发达”，反思一下，结论是，“谁都没办法证明自己是最好的老师”，同时，“谁都没办法分辨到底谁是最好的老师”……

可这一次不一样，**人工智能是最好的老师** —— 起码，在语言学习方面 —— 因为最近刚刚突然崛起的人工智能所仰仗的就是 “大语言模型”，所以它在文本方面最厉害…… 突然之间，没有哪一个人，无论是不是 “外教”，甚至哪怕 “语言学家”，都比不上人工智能，起码，在 “当外语老师” 这方面。

最惊人的当然是 “**人工智能非常便宜**”，甚至 “便宜得不像话” —— 收费的 OpenAI 每月只需要 20 美元，即，不到 150 元人民币，一年下来也只不过 1,800 元人民币而已…… 并且，一年才 1,800 元费用的人工智能，比什么外教都强。如果仅仅是生成文本的话，还有大量的开源模型可以使用 —— 干脆免费…… 在这种情况下，最大的费用竟然变成了 “买台电脑” 而已。

关键在于，不仅便宜，它还 “不知疲倦”。你只需要告诉它，“帮我检查并修改我的文字中的语法错误，而后把每处修改的原因都另外罗列出来……” —— 你没当过老师，所以你可能不知道，外语老师在 “批改作文” 的时候，要搞死自己多少脑细胞才能完成这样的任务啊！

突然之间，一切都变了。

我在社群里说，我要在 2024 年，改变社群里所有的家长，让他们 “全部都” 变成 “学爸” —— 这里的 “bà”，不是 “霸王” 的 “霸”，而是 “爸妈” 的 “爸”；“学爸” 里的 “爸”，并不专指 “爸爸”，而是指 “父母” 或者 “爸妈”。

我说，我们花上一年的时间，投入起码 1,000 小时的注意力，我们每个人都能做到 “**起码比全中国所有的英语老师都强**” —— “比所有……都强”，你可能会觉得，这口气有点大了吧？然而，这完全不是夸张，而是确定可以做到的事情。

请问，我哪儿来的自信？

很简单啊，我不是厉害，也不是你天才，而是 “**人工智能真的很厉害**”…… 人工智能是天下最好的老师，谁与争锋？有了人工智能之后，我们不需要当老师，事实上也没必要与整个教师群体比较，我们需要做的只不过是 “**助教**” 而已……

> 人工智能是最好的 “老师”，我们是自己最好的 “助教”。

—— 这有什么问题吗？毫无疑问，**只要真的投入在一年时间里 1,000 小时的注意力，人人都能做到**。做不到的，肯定不是因为智商，肯定不是因为天分，肯定没有其它任何原因，只不过是 “做不到一年内投入 1,000 小时注意力” 而已 —— 完全没有任何其它的可能性。

我们只不过是想要 “做好一个合格的助教” 而已，这有什么做不到的么。做，就是了。不做，反正，这一年也会自顾自地流逝。

**自己做自己的助教，自己做自己的学生，并且，还有人工智能作为最好的老师** —— 这就是在这个 “人工智能时代” 里 “自学” 的真相。谁怕谁？

当然了，“说自己想说的话” —— 真的做起来，还是好说不好做…… 因为，绝大多数人终将意识到，自己所面临的最大问题竟然是 “**我好像没什么话要说……**” —— “不知道说什么” 远比 “不会说” 更为可怕。只不过，在此之前，这个真正可怕的问题还没浮现呢，就已经被各种其他肤浅的障碍挡住了而已。

那看似简单明了的 “启动任务” 中，真去做的话，就会发现，除了 “每天练三个小时” 之外，在此之前，“准备自己想说的话” 可能需要的时间比当初误以为的多很多 —— 毕竟，过往的许多年里，很多人上的都是假的 “语文课”…… 当然，也不是没有补救的方法 —— 有空可以去好好听听《李笑来的写作课》，并且还要多听几遍。

另外补充一点，“一上来就开口说”，“一直说”，“不说不算数” —— 这种 “一切都基于口语” 的方式，是不可替换的原则。只要脱离了 “说”，“学外语” 会有不计其数的莫名其妙的问题和困境。比如，很多人有很多单词不是 “读不准”，而是 “干脆读错”…… Github 上有个专门的 repo，“[中国程序员容易发音错误的单词](https://github.com/shimohq/chinese-programmer-wrong-pronunciation)” —— 很多人到最后要耗费不知道多少时间精力去弥补当初遗留下来的问题，可是，如果从一开始就 “一切都基于口语” 的话，从一开始就不会读错，不是吗？