# 生学硬练

“启动任务” 里，我们为什么要那么做呢？

> 第一步，不是 “教学”，不说 “方法”，没有 “技巧”，而是 “**直接干活**”！

我们在《[真假之别](2024-01-09-真假之别.md)》里提到

> …… 无论干什么学什么，人类史上就没有过 “绝对最好的方法”，因为 “方法” 这个东西一直都在不断改进；也就是说，历史上人们一直在使用的，从来都是相对于当下或者未来 “相对落后” 或者 “不尽完善” 的 “方法”，可 “相对落后或者不尽完善的方法” 从来也没有阻止少数人学会学好，为什么？**因为 “投入足够的注意力” 从来都是只有极少数人才能做到的事情。**

除此之外，还有另外一个最关键的理由：

> “语言学习” 的最有效方法本来就是 “**生学硬练**”。

除此之外，其他的了不起都只不过是 “辅助手段” 而已。

人类天生就具备 “开口说话” 的能力 —— 由天下最精密的大脑支持，协调多个同样非常精密的器官，比如嘴唇、舌头、小舌、咽喉，再配合气流的震动，能发出各式各样的声音…… 并且，所有人都一样，都天生具备 “多语” 的能力。

与绝大多数人想象的不一样，甚至相反，“多语能力”，某种意义上，发展过程其实是 “最初最强” 而后 “逐步丧失”。

每个新生儿都有能力通过尝试和摸索，能够学会地球上存在的任何 “音素” —— 即，“声音要素”，无论是 “辅音” 还是 “元音”。他们所谓的 “掌握自己生活环境中所需要的音素”，就是在大脑里创建并强化相应的神经元间连接。

而对于自己的生活环境里并不存在的 “音素”，他们的大脑对之完全忽略，“并未创建相应的连接”，更谈不上 “强化”。比如，中文不需要的 “舌尖颤音”，对韩文来说就是必需；在德语、俄语中常见的 “小舌颤音” 就是英文是不需要的。

甚至，成年后，为了效率，在听觉上，干脆屏蔽掉那些 “用不着的音素”。于是，中国人听不出韩语的 /ᄅ/ 和中文的 /r/ 之间的区别，韩国人听不出英文中 /f/ 和 /p/ 的区别，上海人很可能说的是 “皮肤”（pí hū），福建人可能说的是 “牛逼”（líu bī）…… 都是因为成年之后的 “听觉屏蔽” 造成的。

但，这并不意味着说，“成年之后” 就不能学了，“听觉屏蔽” 之后就永远再也打不开了。脑科学家们的研究结果是，大脑具备极强的可塑性，“新建神经元连接” 不仅可能，并且事实上难度并不高 —— **只要肯练**。所谓 “练” 的意思是说，“短时间内足量重复”，仅此而已。

怎么 “练”？“硬练” —— 跟小朋友咿呀学语一样，“生学硬练”。

在学校里，我们 “学外语” 的方法很奇怪，与 “自然习得” 完全相悖，甚至处处相反。比如，小朋友五六岁，还没上学的时候，并不一定会写字，也不一定会拼音，更别提什么语法，但，已经能说很多很多话了，不是吗？总是有人问，“我零基础可以吗？” 他们所谓的基础，是字母、音标、语法…… 请问，小朋友学说话，靠这些吗？

更早的时候，小朋友大约会在几个月左右，就有可能发出一些奇怪的声音 —— 他们一直在 “尝试”，却暂时无法准确协调各个器官。等他们嘟嘟囔囔开始说话的时候，先能相对准确地发出的声音是基本的元音，而后才是各种辅音，辅音总是说不准，比如，让他们说 “竹子针”，他们说出来的是 “dú d dēn” —— 直到 3 岁左右，已经能说很多话的时候，他们还做不到 “**吐字清晰**”……

在多语环境里，三五岁的小朋友，其实不知道也不在意听到的说出的究竟哪个是英语，哪个是中文，哪个是日语，哪个是韩语或者西班牙语，他们只是知道那是对方发出的声音，辅助着各种 “非语言要素”，比如表情动作等等，去猜测理解那些声音的意思，而后再通过多次尝试之后，自己也能发出差不多的声音，即，我们以为的 “**说话**” 而已。

他们太小，脑子里的概念不可能完善，大人没有任何办法通过 “方法论” 去教他们 “发音”。没有任何一个家长会这样告诉自家的幼儿：

> 你在说 /θ/ 和 /ð/ 的时候，舌尖要略微露出来一点，放在两排牙齿之间，而后通过气流震动发出它们的声音。/θ/ 是清辅音，而 /ð/ 是浊辅音……

再比如，我是朝鲜族，从小生活在多语环境中，因为朝鲜语是母语之一，所以，我会发出 “小舌颤音”。我家老二，小名 “都都”，我叫他的时候，常常用小舌颤音说他的名字，算是图个乐子。

最初的时候，小朋友暂时发不出这个音。他们会 “硬试”，最初发出来的是嘴唇震动的 “噗” —— 喷的口水满天飞，然后自己觉得很好玩…… 我没有任何办法向他们解释清楚，这个小舌颤音是如何发出的，没有任何 “教学方法” 管用。他们也不在意，反正觉得好玩，就不断尝试，这样试试，那样试试，突然某一天，他们就会了。

其实，这样的 “生学硬练” 才是 “自然语言” 的 “自然习得方式”。实际上，日常生活中，我们这样 “生学硬练” 出来的东西很多，弄不好，往往越是重要的，越是这样搞出来的 “本事”。

在我长大的年代里，香港连续剧在中国大火，又由于那个时候可看的东西少，往往是一部剧全国都在追…… 在某部武侠剧里，一个 “武林高手” 在镜头面前有个特写，观众们看到的是，他的耳朵竟然会动！第二天，全班同学都互相问，你的耳朵能动吗？大家都不行…… 在此之前，每个人的耳朵都没动过，也没想到过要动。过了几天，有个同学说他 “会动耳朵” 了！大家惊讶地看他表演…… 再过几天，班上很多同学都 “学” 会了怎么 “动” 耳朵…… 当然，谁都说不明白 “如何动耳朵” 的 “方法论”，都是一样的措辞，“多试试就可以了”。

就是这样 —— 多试试就可以了。

在新疆，所有人在很小的时候就 “学” 会了 “晃脖子”，那是一种其他民族的人少有能做出的动作。你去问他们，到底应该怎么晃脖子，他们说不清楚，就算偶尔有人说得很清楚，你也学不会…… 真的 “学不会” 吗？肯定能学会，至于 “方法论” 么，其实没必要。跟 “动耳朵” 一样，“多试试” 就可以了。很少有人能 “动鼻尖”，生活中，也没有什么这样的 “需求”…… 但，两个版本的《家有仙妻》的主演，无论是电视剧版里的伊丽莎白·蒙哥马利还是电影里的妮可·基德曼都学会了这个动作 —— 怎么学会的？“生学硬练” —— 至于 “方法论” 么，就算告诉你也没用。

即便是到了很多所谓 “高级的领域” 或者 “高级的阶段”，也还是一样的。有人能手把手教，当然很好。但总有一些是身边没有人会的，那怎么办？看书，然后自己学、自己练。有没有可能 “连书都找不到” 呢？当然。没有人可以在身边手把手教，书里也找不到，那怎么办？到最后永远都能仰仗的，再一次只能是 “生学硬练”…… 所以，无论是前段起步，还是后段高阶，主要靠的，只能是 “生学硬练”，别无他法。

曾经，有科学家提出 “语言学习关键期” 的说法，声称 “过了一定的岁数，错过了 ‘语言学习关键期’，就不可能再学好语言了…… 更别说学另外一门外语了”。这个 “假说” 现在早已经被确定是无稽之谈 —— 虽然民间还有很多人 “尚未来得及更新观念”。

其实是反过来的，越是成年人学语言越容易才对 —— 因为一方面，成年人有 “方法论” 辅助，而另外一方面，成年人相对于婴幼儿有更多的 “自我检查”、“自我反省” 的能力。

然而，成年人相对于婴幼儿的确面临一些额外的困难。

婴幼儿学任何东西都是没有 “方法论” 的，他们只会也只能 “生学硬练”。成年人的问题在于，多年的 “学习经验”，已经形成了一个属于自己的 “方法库”，只要是不符合已有库存的方法，就会感到极不适应，潜意识里认为它效率不够高 —— 毕竟，“方法库” 里的东西都是千挑万选才值得收藏的…… 然后，早就忘了当年最简单直接粗暴有效的方式，“生学硬练”，甚至认为那是最低级的，所以早就弃用了，到了甚至干脆想不起来了的地步，非常可惜。

年龄的增加，与之相伴增加的往往并不是能力和耐心，而是 “基于无数次失败而累积起来的浮躁”，越来越心急，越来越沉不住气，越来越想要找到某个 “神奇的方法” 可以 “瞬间解决所有问题” —— 一切的 “速成” 都有巨大的市场，就是这个原因。想要 “速成” 的人，就好像是很多炒股的人变成了赌徒一样，本钱越来越少，损失越来越大，在越来越大的 “回本” 压力下，开始使用 “越来越大的杠杆”，直至 “爆仓”……

婴幼儿不一样，他们站在起点，对什么都好奇，对什么都有兴趣，他们只想自己能够快一点做到 “人人都能做到的事情” —— 说话，就是其中之一 —— 所以，虽然他们只会 “生学硬练”，但，他们有无穷的动力，他们不需要耐心也可以反复尝试无数次，他们不会觉得枯燥，每一次看起来重复的尝试对他们来说都好像第一次那样有趣，每一个小小的收获都可以兴奋不已。他们也不在意别人的看法，他们不会因为自己做不好就不想去做了，相反，那恰恰是他们的动力……

之所以他们只用最原始的方法却最快最易地成功，是因为他们 “重复尝试” 的次数足够多，密度足够大…… 所以，“生学硬练” 的诀窍就在于 “短时间内足量重复”，就是我们所说的 “努力”。

倒是有一个重要的差异。婴幼儿相对于任务更单一，想法更纯粹，不是外界不存在 “干扰”，而是他们对大多数对成年人来说是 “干扰” 的东西 “无感”，甚至 “并无认知”。成年人，了解得更多，反受其累。对成年人来说，相对于 “练”，外界实在是太多干扰，太多羁绊，太多诱惑。

我们的大脑有个很重要的 “自我保护功能” —— “**忘记痛苦**”…… 正因如此，年纪越大，越想不起来自己小时候为了学那些基础得不能更基础的东西，“吃了多少苦”。忘记了自己曾经动不动 “一个字写好几页” 才学会了识字写字，甚至才此之前，一个笔画，无论是 “横竖撇捺”，都单独练了无数遍…… 再早一点，从 “咿呀学语” 到终于算是 “吐字清晰”（元音饱满，辅音准确，语调稳定）其实用了好几年，并且还是 “天天试” —— 不仅是 “天天” 而已，并且还是 “从睁眼到闭眼一直在没心没肺地不断尝试” 的情况下……

“生学硬练”，不是一遍，不是几遍，不是几十遍，也不是几百遍，而是每天反复，到最后干脆 “不知道多少遍”…… 很多成年人只不过是忘了而已。

所以，绝大多数人 “学外语失败”，其实压根就不是什么方法的问题，因为最朴素且最有效的方法，就是 “生学硬练”，谁都会，并且还天生就会…… 真正的问题只在于，没有做到 “短时间内足量重复” —— 从来也没有做到过 “**真学习**”，“**每天至少三小时**”，“**一年内至少一千小时的注意力投入**”。

在 “黑客” 的世界里也一样，破解密码最靠谱的手段，到最后只能是 “暴力破解”，所谓的 “大力出奇迹”，虽然肯定不是最有 “效率” 的方法，但肯定是最能保证 “效果” 的方法。“生学硬练” 就好像是 “暴力破解”，想要保证效果，到最后都一样，都只能靠它。

“人工智能” 也一样。今天人工智能所使用的算法，并不是刚刚才出现的，基本上都是上个世纪五六十年代的研究产物 —— 只不过当时 “算力” 不足，“算力” 也太过昂贵…… 底层逻辑相当于 “暴力破解” 的 “大语言模型”，曾经被认为效率太差，所以曾在相当长一段时间里被束之高阁 —— 结果呢？只要算力价格降到一定程度，可支配的算力大到一定程度，“人工智能” 在 “突然之间” 就爆发了…… 你看，连机器想要变聪明都需要且只能靠 “生学硬练” 呢。

我们并不是因为 “生学硬练” 最靠谱就再也不靠任何 “方法” 或者 “策略” 了，正如 “全靠大力出奇迹才真正崛起的人工智能” 在随后的发展过程中依然在不断改进 “算法” 一样。细节上，有很多必要的方法与策略，但，我们就是得靠相当长一段时间的 “生学硬练” 起步，其他的都不靠谱。

