# 健身健脑

一切的学习都是 “脑体协调”…… 所以，本质上来看，一切的学习，其实都只不过是 “健身” 而已，毕竟，“脑” 也是 “体” 的一部分。

对于迅猛发展的人工智能，我们情绪复杂，甚至有点无所适从…… 某种意义上，对于未来，我们突然失去了信心。连科学家们都在恐慌，有一部分认为：

> **未来的科学家们的主要工作，可能就不是去尽心尽力做研究了，而只不过是绞尽脑汁去理解人工智能的研究结果……**

2023 年的每一天，人们都会得到关于人工智能的更多消息，几乎每一条都有可能令人瞠目结舌。比如，视频里的人讲话，突然之间可以在保持原有音色的基础上，几乎可以实时地转换成任何一种语言，无论是汉语、英语、法语、德语、日语、韩语，还是西班牙语、意大利语 —— 甚至，连口型都可以通过算法实时微调，以便对应不用语言的配音…… “同声传译” 这个曾经格外高级的职业，很有可能就好像是 “司机” 这个职业已经被 “自动驾驶” 大面积威胁一样，在不久的将来销声匿迹。

仅仅几年前，人们还在争论 “学习外语” 的必要性…… 在此类人工智能应用出现之后，原本就比例上占大多数人，现在比例更高了，变成了 “绝大多数”，恨不得远远超过 99%，自然而然且又一厢情愿地得出在他们看来再明显不过的结论，“压根就没有任何必要学么！”

他们说的对吗？他们想的对吗？这个姑且放在一边不去评论，倒是有必要提醒一个他们有意无意忽略的事实 —— “其实，在此之前他们也没学过、也没想好好学过”，也就是说，“有没有人工智能出现，他们反正都不会去学，更不会好好去学”。对他们来说，任何学习都是负担，那是他们在学校里就早早希望能够摆脱的活动。

先把人工智能放在一边，让我们看看两百年前发生的一场变革 —— 工业革命，是如何改变人类的 “体力” 的吧。突然之间，很多人不需要再像以前那样每天做在今天看起来绝对是超量甚至超载的体力劳动了，结果呢？结果异常明显且又不可否认：绝大多数人的体力都一样，很快地下降…… 几代人之后，绝大多数人若是有机会坐时光机穿梭回两百年前，干脆就是 “非弱即残”，一定是那个时代里最令人看不起的 “手无缚鸡之力之辈”。

当然，这个事实长期很隐蔽，因为科技的发展，物资的丰富，医疗技术的进步，营养供给的充足，这一切都造就了另外一个结果，人们的平均寿命增加了，从十九世纪末差不多 30 岁不到，到了二十一世纪初接近 80 岁…… 谁会觉得现代人的体力比古代人差很多有什么了不起的呢？

让我们看看光谱的两端，一方面是绝大多数人的 “体力” 沉沦…… 另外一方面呢？有另外一群人却与此同时通过 “锻炼” 获得了古代人绝对不可能拥有的 “体力”。

作为现代人，我们中的绝大多数，能一口气做 10 个俯卧撑，可能就属于至少前 20% 的人群了；古代人也许体力整体上比我们好，但，估计他们当中能一口气做 100 个俯卧撑的人并不多…… 你猜现在世界纪录保持者能连续做多少个俯卧撑吗？1980 年，日本的吉田实不停地做了 10,507 个俯卧撑。1993 年，美国的查尔斯·塞尔维齐奥在 21 小时 21 分钟内做了 46,001 个俯卧撑……

不仅是 “体力” 的所谓 “极限” 在不停地被突破，更重要的是，虽然依然占总人口的比例极低，但，从绝对数量上来看，其实是越来越多的人练出了越来越强的体力。

1908 的奥运会马拉松纪录是 2 小时 55 分 18 秒，100 多年后的今天，新的纪录大约是 2 小时 2 分 57 秒，同样的距离少用了 50 多分钟，也就是说，减少了 30% 的时间。100 年前，全球只有一个人能跑 2 小时 55 分 18 秒；哪怕是 3 小时 5 分钟，也没几个…… 可现在呢？每年有资格参加波士顿马拉松赛的选手大约有 3 万名，他们中的每一个，都是因为能超过最低成绩，3 小时 5 分钟。

这就是曾经某次 “惊天动地” 的发展（即，工业革命）变化给人类的 “体力” 带来的影响：

> * 绝大多数人的体力已经变得越来越差（事实如此）
> * 自主锻炼的人群比例越来越低（比如，从 20% 降到了 2%）
> * 但，自主锻炼的群体中，更大比例的人获得了比过往更高的成绩（获得好成绩的比例在提高，比如，从 20% 提高到了 80%）
> * 自主锻炼的群体中，最佳成绩在过去万万不能不可想象（比如，4.6 万个俯卧撑）
> * 第一和第二的距离在持续拉长（比如，第二可能只能做到 2 万个俯卧撑）

以此为参照，再让我们想象一下人工智能的 “突然出现” 和 “迅猛发展” 会对人类的 “脑力” 产生什么样的影响呢？

正如工业革命之后生存必需对人类 “体力” 的要求越来越低一样，生存必需对人类 “脑力” 的要求其实也在持续降低。这不是人工智能时代的特殊现象，这是已经持续了很多年的趋势。过去的三五十年里，商品社会高度发展的原因之一，就是被普遍应用的 “傻瓜化设计原则” —— 不需要消费者学习，不需要消费者思考，拿来就可以直接用的东西，才是真正有潜力大卖的商品。

现在，这个已经出现并发挥作用的趋势就要被人工智能无限放大了 —— 因为人工智能降低了 “所有学习的难度”…… 换言之，哪怕迫不得已需要学习，哪怕迫不得已需要思考，也因为人工智能的加持，学习成本和思考成本都会极大幅度降低。最典型的例子是 “个人电脑” 到 “移动电脑” 再到 “移动智能设备” 的变化，设备越来越轻巧，越来越智能 —— 我们不能说用它们的人越来越傻了，但，反过来说，“它们变得越来越来越简单，用起来也越来越方便、越来越不费脑子”，这总是千真万确的。“电脑” 曾经还是有相当学习门槛的日用设备，现在呢？一方面，“把电脑真正用好” 的难度在事实上不断提高，另外一方面，对越来越多的人来说，“傻瓜化的智能手机” 不仅够用，并且 “感觉” 上只能是越来越好用。

于是，时代的发展 “对人类脑力的普遍影响”，其实是与 “对人类体力的普遍影响” 要么平行要么一致：

> * 绝大多数人的脑力已经变得越来越差
> * 自主学习的人群比例越来越低
> * 自主学习的群体中，更大比例的人获得了比过往更高的成绩
> * 自主学习的群体中，最佳成绩在过去万万不能不可想象
> * 第一和第二的距离在持续加大拉长

其实，这样的趋势，在人工智能 “突然出现” 之前早就已经如此了。

2015 年，印度的拉吉维尔·米纳（Rajveer Meena）成为公认的纪录保持者，他背诵了 π 的前 7 万位数字，累计背诵时间长达 9 小时 7 分钟；而日本的原口彰（Akira Haraguchi）声称自己背诵了更令人难以置信的 10 万位数字，是 42 年前所有人背诵数字的近 200 倍。再比如，印度的维卡斯·夏尔马（Vikas Sharma）能在一分钟内就能计算出 12 个大数的根，每个数都有 20 到 51 个数字，根的范围从第 17 根到第 50 根不等，他的速度比许多人把数字打入计算器而后读出答案还要快。

“记得住 π 的前 7 万位数字”  或者 “快速心算某个 51 位的大数的第 50 根” 是 “超级脑力” 的惊人例子，就好像 “4.6 万个俯卧撑” 一样，能够让我们看到 “极限” 不断被突破的实例。但，这样的例子多少对绝大多数 “坚定地自认为是普通人” 的读者或者听众感到淡漠，觉得都跟自己毫无关系。

让我们看一些更接近生活的事实。上个世纪九十年代，满分 677 分的托福考试，在中国大陆，考过 600 分的凤毛麟角，绝大多数人使了吃奶的劲也不过是 550 分左右；现在的 TOEFL 满分改成了 120 分，但，考出 116 以上的比比皆是（相当于满分 677 时期的 657 分左右）…… 不仅如此，考出高分的群体中，初中生的占比一直在不断提高。

在我长大的时代里，很多人终生都无法摆脱 “地方口音”，说不好所谓的 “普通话”。今天呢？今年我们在各个国家都可以见到大量的年轻人能同时说若干种语言（不止两种，不仅仅是 Bilingual 或者 Trilingual），并且完全没有什么所谓的 “地方口音影响”。我家孩子就是这样的，中文、韩文、日文、英文，同样流利，甚至偶尔也说点西班牙语，因为他们的足球教练是不会说外语的西班牙人。

“多语环境”，在过去，是 “可遇不可求” 的，大多数人无法改变自己的出生地点，同样也无法改变自己早期的成长环境…… 天下最自然的 “多语环境”，就是 “家里有人能说不同的语言”，这在过去同样可遇不可求。然而，现在的确不一样了，在人工智能的辅助之下，在父母 “健身健脑” 意识的觉醒之后，只要父母之中有一个人愿意，那么，其实家家都可以为自家的孩子创造 “多语环境” —— 只要父母当中有一人在家里只说另外一种语言就好了…… 想想都觉得神奇。

再退一步，我们不说 “外语” 那么 “难” 的东西，让我们看看更为基础的，我们自己每天使用的 “母语” 吧…… 个体之间的差异也是越来越大。有的人在二十年的时间里认真阅读了一千多本书，有的人不阅读文字已经超过十年之久；有的人每天至少三千字以上地持续创作着，有的人这一生写过的东西不过是学校里考试时的主观题，到最后连 140 字的微博都不见得能写得足够完整。

所以，本质上来看，更为核心的根本不是什么 “要不要学外语” 的问题，也不是 “要不要学什么” 的问题，而是 “**要不要学**” 的问题 —— 或者，说得更干脆一点，是 “**要不要练**” 的问题。而 “学习” 之于 “脑力”，其实就相当于 “锻炼” 之于 “体力”。未来的世界里（其实可能早就如此），绝大多数人会在 “不用学习的世界” 里快乐地沉沦，而另外一些人（比例上依然是极少数，但绝对数量上会越来越多）会在 “学习的乐园” 里疯狂地高歌猛进。

现在，人类 “体力” 的个体差异是普遍 10 和超级 46,001 的差异，那么，对比身体的可塑性和延展性都更强的大脑来说呢？人类个体之间的 “脑力” 差异可以大到什么地步呢？其实，问 “要不要学习” 和 “要不要锻炼” 一样，对一小部分人来说，是不仅不需要问、不应该问，甚至压根就是问不出来的问题。

问题在于，我们没必要成为 “天下最强” 的那个人，在 “健身健脑” 方面，我们其实只需要 “正常” 就可以超越甚至八九成以上的人群。而所谓的 “正常”，无非就是做到 “持续健身”，仅此而已，真的没什么。