# 心理建设

“语言学习关键期” 的谬论曾经大行其道，荼毒生灵无数。“看起来婴幼儿学语言相对于成年人更快更好更容易” 这个 “现象” 之所以存在，原因并不是 “有某个分水岭存在” —— 事实上压根就没有什么分水岭。后来的脑科学发展，从各个角度证明了 “动机” 的关键作用，于是，这个曾经被曲解的 “现象” 现在有了真正合理的解释：

> 婴幼儿相对于成年人，有更强更纯粹的动机 —— 即，跟身边的人一样说话。对他们来说，这是绝对的 “刚需”。

大多数成年人对 “说外语”，并没有足够强的动机，甚至干脆没有。在学校里 “学外语” 更是如此，除了课堂上听一听，课后完成一点作业之外，“说外语” 从来都不是 “刚需”。什么是 “刚需”？就是 “没有不行”。所以，对于 “刚需”，大脑为之设定的 “效能阈值” 可以很高，哪怕 “过高” 都无所谓；可对那些 “可有可无” 的东西，大脑会把 “效能阈值” 调低，反正也无所谓么。

基于 “语言学习关键期” 这个流行谬误，人们设计了很多 “幼教” 方法。很多父母常见的 “为婴幼儿播放英语” 就是其中之一，美其名曰 “洗耳朵”。这种方法真的有效吗？

帕特里夏·库尔（Patricia Kuhl）曾做过一项研究。库尔斯专注于婴儿语言习得的神经学专家。

> 接受测试的九个月大的幼儿全都来自英语环境，研究者让他们开始定期听中文，一共 12 次，每次 25 分钟。幼儿们被分为三组：第一组幼儿有中国人陪同，给他讲中文故事，和他用中文互动；第二组幼儿也是和同一批中国人交流，同样讲故事和互动，但是通过视频完成；第三组幼儿则只听中文录音。研究者预计第一组和第二组幼儿在一岁之后都同样可以辨识出中文语音。结果出乎意料：面对面和中国人交流的幼儿，可以同中国幼儿一样，辨识出中文语音；只听中文录音的幼儿，和看中文视频的幼儿一样，彻底记不住中文语音，一点儿都记不住。没有面对面的交流互动，即使是好看的视频，幼儿依然什么都记不住。

怎么回事？很简单啊！对幼儿来说，只要不是 “身边的人”，就是不重要的，于是，他们根本就没有任何动机。幼儿的 “刚需” 很简单，“不仅尽量也要尽快学会身边的人所做的事情”。至于视频也好录音也罢，跟自己全无关系，没有任何动机去关注。没有了 “动机”，就没有了 “关注”（或者说 “注意力投入”）—— 于是，就等同于 “不存在” —— 这怎么可能有什么 “效果” 呢？

你看，即便是 “相对于成年人学的更高更好更容易的婴幼儿”，在缺乏动机的情况下，他们再会 “生学硬练” 也没用。

所以，在整个 “自学” 过程中，“强化动机” 是最重要的工作。对非婴幼儿来说 —— 只要是 “能听懂道理”，“能用大脑皮层思考” 的人，无论是中小学生，还是在职人员，抑或是离退休人员，都一样 —— 但凡想要真学样东西，就得寻找动机、培养动机、强化动机、呵护动机，并且，还得 “每天都做”，甚至 “时不时就要做”，反正要 “不厌其烦地做”。

李笑来在任何地方都强调：

> **一切都是心理建设。**

就是基于 “动机最重要” 这个事实。“一切都是心理建设” 不是一句空话，并且也不是 “无迹可寻”。2019 年 7 月 12 日，我为《定投改变命运》配套建立了一个社群。“定投策略” 说清楚也就一句话，而所谓的 “践行” 动作，也只有一个字，“买” —— 简单到极致…… 简单吗？简单。容易吗？不容易。陆陆续续，社群最多的时候两万多人，几年下来之后呢？差不多六成的人掉队…… 不过，几年下来，社群里的人都有同样的感受：

> 若不是李笑来几乎天天在社群里像唐僧念经一样做心理建设，我早就掉队了…… 想想真是 “一念之差” —— 可那 “一念” 竟然那么难以坚守……

这就是 “自学”（相对于 “学习” 更为高级的活动）的最核心关键：

> **自我心理建设**

有人帮助 “建设” 很好，自己能够 “建设” 更好…… 当然，有没有别人其实并不重要，虽然 “有” 很难得，“没有” 呢？只能自己来，反正，无论什么，到最后都得靠自己，也只能靠自己。再说，如果自己就能给自己做好心理建设，那么，请问，谁能阻挡你呢？谁能打击你呢？谁都不能。所以，能够为自己做好心理建设的人，总是无往不利，势不可挡。

每个人都一样，在做不同事情的时候大脑会给自己的身体机能设置 “效能阈值” —— 并逐步会形成一种惯性。但，我们已经知道了，其实有可能通过改变自己的 “认知” 改变或者调整自己的 “效能阈值”，甚至我们还可以也应该不断主动刻意地去维护它…… 以便我们尽快达到更好的成绩，甚至巅峰。

既然没有 “上限”，那我们不妨再研究一下 “底限”。

我们的某些身体器官，的确受不了过度使用。比如，人类的膝关节就很脆弱，一旦受伤，很难修复 —— 因为它一方面时刻承重，另外一方面关节内还没有直接的血液循环，受损之后修复的难度极高…… 所以，一般来说，很多体育训练，的确不易过度。并且，这一点的确值得额外提醒：在一切运动的过程中，都要，且尤其要注意膝关节的保护。

但是，我们身体的绝大多数器官，比如，“手指”（弹奏乐器）或者 “舌头”（说各种语言），基本上不存在所谓的 “因过度使用而磨损” 的情况，尤其是 “大脑” —— 而民间所谓的 “用脑过度” 实际上都是那些压根不用脑子甚至不会用脑子的人莫名其妙臆想出来的乱七八糟且毫无实际意义的词汇。所以，在 “多语学习”（无论是不是英语）这方面，或者干脆简单说，在 “说话” 这方面，不存在任何风险，即，风险为零，也因此，收益相对无限大。

许多年前，我曾向我的学生介绍我的学习方法之一：

> 单耳戴蓝牙耳机，尽量全天候播放有声书。

这么做的好处当然是 “有效模拟全天候浸泡外语环境”。并且，是因为用 “单耳”，所以完全不影响原有的生活，有人跟你说话的时候，与没戴耳机也没什么区别。散步的时候，开车的时候，家里，健身房里，都可以 —— 甚至游泳的时候，也有专门的 “防水耳机” 呢。

但，你可能完全想不到，我这样讲，竟然在课上讲被学生投诉过，在博客上写也被读者质疑过…… 而且，不止一次，也并非少数人。他们（甚至很气愤地）说，“那样会毁掉耳膜的！”  他们认为我在向人们传播 “有害的建议”。问题在于，我的确是如此做的啊！并且，也的确因此受益了啊！还有，你试过就知道了，时不时总得左右换换，毕竟蓝牙耳机电量有限，其实每只耳朵都有休息时间的。

到现在我这么做已经二十多年了 —— 最早的几年恨不得全天候，再后来每天听电子书的时间也没低于过三个小时 —— 到现在我也没有 “失聪”。人类的身体器官，比绝大多数人自以为的 “皮实” 得多。

另外一个例子是，很多人认为看电脑屏幕多了对眼睛不好，影响视力…… 这可能是事实。但，学习、研究、工作都离不开电脑，那怎么办？只能是 “**必要成本**” 了呗。总不能因噎废食吧？如果不学习不研究部工作，视力再好，不还是瞎子吗？脑子瞎总比眼睛瞎更可怕吧？又，多年以来，我肯定是人群中 “每天盯着电脑屏幕时间相对较长的人” —— 我从 12 岁就更多地盯着屏幕，到今年 52 岁了（2024），都整整四十年了，也没瞎啊？！视力并没有变得更差啊？！顶多，有点花，怎么了？

很多人 “爱惜” 自己的身体，却完全不在意自己的脑子，是不是有点奇怪？当然你我都一样，听过无数次，“看那么多书不累嘛？脑子都看坏了！” —— 唉…… 有脑子不用的人，为什么要害怕脑子会坏呢？是不是很奇怪？在我们的世界里，我们把这个叫做 “**价值观缺失**” —— 换句话讲就是，“不知道什么重要，也不知道什么更重要，更不知道什么最重要……”

过去，对于这样的投诉或者类似的质疑，我只能表示理解：“我能理解你是非常爱惜自己身体的人…… 但，我自己还是会这么做的。” 现在呢？我都懒得回应。不过，有一点不仅是确定的，也是值得反复向自己 “灌输” 的：

> **脑子是绝对练不坏的。**

既然练不坏，那么就不仅必须练，还必须是使劲练，不练或者少练，都很吃亏 —— 人这一辈子最重要的无非是健身健脑，一切学习都是脑体协调，并且，健脑甚至比健身更重要。就这么简单 —— 你自己选。

所以，在 “健脑” 的过程中，“效能阈值” 总是可以无风险地调到更高水平的。而我们现在的 “实操” 目标，你把它叫做 “学外语” 也好，“学英语” 也罢，甚至 “掌握多语”，说穿了，不就是 “练说话” 吗？怕什么？心疼什么？奇怪。甚至，“短期超频” 也实际上的确无所谓，只要收益足够大，可问题在于，分母（风险）都是零了，怎么弄都是 “无限大” 的啊！犹豫什么呢？

到最后，无论是学什么，还是干什么，都一样的，“**一切都是心理建设**”。毫不夸张地讲，人与人之间的最大差异，就是 “心力” 上的差异，而不是智商、相貌、性别、出身、种族之类的看起来相对直观的差异。到最后，一切的胜利，都是 “**意志的胜利**”…… 更何况，等你活到一定的岁数就明白了，这世界对人生最重要的技能，基本上都不需要做到 “天下第一”，因为比例上来看，**绝大多数人压根就是哪儿哪儿都 “不及格”** —— 很多的时候，若是你赢了，其实真的不见得是因为自己到底有多么强大，只不过是因为对手实在太差。

每天都要 “反复” 为自己做 “心理建设”，呵护自己的 “心力”。“反复” 的意思是说，要像唐僧一样，对自己絮絮叨叨，不厌其烦。不仅如此，还要从各个角度全方位地做 “心理建设”，甚至还要拼命想办法做到 “有创意地做心理建设”，按照罗大佑的说法，就是要不停地 “搞搞新意思”。

首先，“**能不断体会到进步**” 对自己来说是最大最好的 “心理建设”。其实呢，只要你做到 “**用注意力填满时间**”，你不可能不进步的，谁都一样，干什么也都一样。天下所有进步的前提都一样，都是 “用注意力填满时间”，做不到这一点，一切都是胡扯。明白了这个道理，只要环顾一下四周，基本上就会 “自信” 慢慢，因为懂得这么做的人实在是太少了，能做到的人更是少之又少，而你竟然做到了，你还怕什么呢？

另外，请杜绝一个看似不起眼的坏毛病：“在别人身上挑刺”。别人做的好不好，关你什么事？可很多人就是不由自主地宝贵的注意力浪费在别人身上 —— 因为 “自己进步” 很难，因为那需要用很多注意力填满很长的时间，但是，“在别人身上挑刺” 相对太简单，些许的注意力，一不留神就 “发现” 了。然而，这是个大大的陷阱，因为 “在别人身上挑刺”，这个小动作会让自己掉进 “固守型人格” 的陷阱，因为，它会不由自主地出发实际上毫无用处的 “横向比较”。不要忘了，你要养成的是 “进取型人格”，你要做的事 “纵向比较”，“过去的你” 和 “努力过后的你” 之间的比较。为了不断进步，你应该变成一个更多 “内视” 的人，而不是更多 “外视” 的人，多关注自己的成长，甚至 “只关注自己的成长” 才对。

“启动任务” 中，要求每天留下 “训练记录”，就是为了能够让你 “时不时体会到进步”。在 “自我训练”（即，“自学的最关键环节”）之中，还有一个重点就是 “时不时提高训练难度”，因为这是能够让自己体会到 “进步” 的几乎唯一来源。

比 “为自己做心理建设” 更厉害的方式是 “帮助别人做心理建设”。我做了一辈子老师，最明白这个道理。由于我坚信 “**一切都是心理建设**”，所以，在 “教授” 的过程中，我干的最多的事情，就是帮助学生做心理建设，我知道他们最缺的，不是方法不是技巧，不是天分不是智商，他们其实只不过是 “**心力不足**” 而已。

然而，我帮他们絮絮叨叨不厌其烦地反复进行 “心理建设”，最终最大的受益者是谁呢？说来好笑，不一定是他们，而是我自己。对在精神上 “**鼓励他人**”、“**帮助他人**” 绝对不要吝惜，绝对不会浪费，因为到最后，你付出的所有 “心力” 都会返回来加强你自己的 “心力”，没有过例外。

所以，这一年的任务，如果你是父母，带着孩子一块儿做，可能是你最佳的 “帮助他人做心理建设” 的机会，一举多得。不要担心你的孩子做不好，不理解你说的话，他们聪明着呢，他们的观察力细微着呢，啥都看得到，啥都能放到心里。这个过程中，除了你们的能力增长，你能获得更多的尊重，因为你展示了你的进步，孩子能获得更多的心力，因为他们知道不只是自己在遇到问题解决问题。

“在社群中活跃” 也是一种方法，哪怕仅仅是 “加入社群”。“人多” 的好处是，“总有人真的做到”，“总有人真的做好”。他们就是榜样 —— “榜样的力无穷” —— “榜样” 在散发着 “信息素”，而你接收到的 “信息素” 讲清楚地告诉你这不是 “不可能的目标”，这不是 “虚无的目标”，这是 “实实在在的目标”，仅此一点，足矣。当然，最好的是，你自己竟然能够成为 “榜样”，你自己焕发着 “信息素”。

还有很多很多手段，看你的 “创意”，想尽一切办法 “搞搞新意思”。比如，之前李笑来告诉你的 “算个假账”…… 再比如，有可能你连 “学习” 这个词都可以为它改个名字，叫做 “变聪明”。“走！到了让自己变得更聪明的时候了！”，或者，“走！让自己更聪明一点！”

记住，“一切都是心理建设”，“一切胜利都是意志的胜利”，“心力” 是唯一保证你获得 “更多财富” 的东西，要爱护它，呵护它，保护它，不断培养它，强化它…… 到最后，它就是你，你就是它。
