# 拿腔拿调

最初的时候，我们用 TTS 引擎为我们制作 “跟读范本”。以前的 TTS 引擎多少粗糙，不太够用。然而，到了 2020 年前后，几乎所有 TTS 引擎都突然之间一下子摆脱了已经延续了二十多年的 “机器腔”，变得极像真人语音。2019 年 8 月，微软在 Edge 浏览器里发布了 Read Aloud 的功能，为几十种语言提供了若干个 “自然语音”（Natural Voice Options），“自然” 到了令人震惊的地步。这背后，除了对早期的 ToBI 算法的精雕细琢之外，更多的是基于神经网络的深度学习的爆发在起作用，数据足够多，算力足够大，人工智能就可以 “大力出奇迹”……

然而，对学习者、练习者来说，TTS 引擎再好也不够用，核心原因在于，它缺乏 “情感”、“情绪”，于是，“说话过于平淡”。所以，我们必须想办法为自己扩大范围，找更多的材料帮助我们自己。

最直观的是 “有声书”。成立于 1995 年的 [Audible](https://www.audible.com/) 于 2008 年被 [Amazon](https://www.amazon.com/) 以 3 亿美金的价格收购之后，在随后的十多年时间里，其 “书库” 被放大了无数倍。今天，Kindle 上绝大多数新出版的 “畅销书” 都带着 “有声版”。对学习者、练习者来说，更好的消息时，Audible 网站上有大量免费的 “Samples”，即，有声书的 “样书”，虽然都只是片段，但，3 分钟左右的长度，非常适合作为练习材料。Audible 上有声书的朗读者，大多都是训练有素的专业人士，他们的朗读，情绪饱满，语调丰富，只要用工具看看他们朗读的语音的 Pitch Contour（音高变化展示）就知道和 TTS 有多么不一样了。

另外，我们能想到的几乎所有的 “经典”，都可以在 Audible 上找到。圣经，美国宪法，莎士比亚的广播剧，经典少儿读物，各类小说，等等等等，都可以买来作为我们的练习材料。

另外一个比较集中的练习材料来源是 [TED](https://www.ted.com)，它成立于 1984 年，2001 年左右开始做网络运营，免费提供演讲视频。经过几十年的积累，TED 上的 “讲演” 几乎涵盖了所有领域，从科学到商业，并且是全球化的，涵盖的语言超过 100 多种 —— 最多的当然是英语。TED 上的视频，都有完善的 Interactive Transcripts，可以 “点哪句台词就跳到哪里开始播放” 非常方便。

“演讲” 是一种特殊的说话方式。因为在台上，因为要对着很多人说，所以，演讲者在说话的时候，比平时声音略高，吐字更为清晰，情绪更为饱满，同时格外讲究 “说清楚”，力求他人 “听明白”，所以，连逻辑组织和措辞方式都有所不同。

“脱口秀”（Talkshow），其实也是很好的材料，只不过它们总是散落在各处…… 这个类别的练习材料相对集中的地方是 [Youtube](https://www.youtube.com)。只要是你喜欢的脱口秀艺人，在 Youtube 上搜索一下名字，总是可以找到若干个片段甚至集锦。脱口秀作为练习材料的好处在于，除了更有趣之外，脱口秀的内容永远是由很多个小片段组成的，随便截出来一段，都是完整的 “段子”。并且，这种东西值得多看，看多了，自己也会在不知不觉之间变得更有趣一些。

当然，从寻找 “情绪饱满” 的角度望过去，最佳的练习材料肯定是影视剧集。流媒体的发展，使得今天的人们 “完全看不过来”，好电影、好剧集简直没完没了，并且，随着时间的推移，经典在不断积累，数量不断增加。

最好的事情是，几乎所有的经典影视剧集都有完整的字幕。到了 2023 年，OpenAI 的 [Whisper](https://github.com/openai/whisper) 开源，制作字幕的成本突然降低到了几近于零的地步 —— 不管是什么，只要你需要，它就可以以比人工快几万倍的速度帮你搞定字幕，甚至可以做到 “时间轴精确到每个词汇”。

除此之外，也可以偶尔试试 “唱英文歌”，不要怕自己唱歌难听，高高兴兴地唱就是了。Spotify 也好，Youtube 也罢，大多数歌曲都带着 Lyric，若是没有字幕的话，Whisper 处理一下就好。

在 “自然学说话” 的过程中，我们时时刻刻经历的都是 “情绪饱满” 的语音，而不是过往录音教材那种 “标准却又刻板”，或者 TTS 的 “标准却又平淡且千篇一律”。所以，“可以增加情绪饱满的练习材料” 其实是 “外语学习者” 的 “刚需”，否则，“事倍功半”。

有了 “情绪饱满” 的 “练习材料” 之后，所谓的 “秘籍” 就是 “**拿腔拿调地练**”。

不仅要想办法做到 “**音素准确**”，并且可能要仔细分辨 “不同的人” 针对 “相同的音素” 特有的 “不同的发声方式”。比如，已故电影明星[肖恩·康纳利](https://www.imdb.com/name/nm0000125/)（Sean Connery, 1930~2020），说话的方式就相对比较特殊，乃至于 “声音辨识度” 非常高，哪怕不出镜，只听声音就知道是他在说话。印象中比较深刻的是，在 1996 年的《魔幻屠龙》（[Dragonheart](https://www.imdb.com/title/tt0116136/)）中，肖恩·康纳利在片中并未出镜，只是为故事中的一条神龙配音，但，你只要听到神龙 Draco 的第一句台词，“Are the stars shining tonight?”（00:10:24），就知道那只能是肖恩·康纳利的声音…… “拿腔拿调” 地模仿他的方式，就是 “把舌头往后多卷一点点”……

<video src="../videos/are-the-stars-shining-tonight(dragonheart.1996).mp4"></video>

甚至，有的时候，你会 “发现” 如果你不配上一定手脚上的动作，或者一定的脸部表情，你都没办法真正做到 “拿腔拿调” 地十足 “模仿” —— 那就试试呗，反正，“练习” 是私下的，也只能是私下的，管它呢，放开了搞！

到这里，一定会有人不由自主地说 “我没有那个天分……” 可实际上，不管是你以为的 “语言天分”，还是我可以范围更精确地锁定的 “语音天分”，都只不过是一种幻觉 —— 在这里，值得重点深入讲解一下 —— 哪怕有点 “啰嗦”，哪怕有点 “重复”。

作为人类，每个人天生就都有极强的 “语音” 天分。每个新生儿来到这个世上，一个音都不会发的时候，就具备能够说出地球上存在的所有 “音素” 的 “潜力” —— 或者，人们平日里误用的词汇 “天分” —— 哪怕是有一天地球上竟然冒出来了另外一些新的 “音素”，也一样的，地球上的每个新生儿都具备学会它们的 “潜力”。“说话” 和 “走路” 一样，是人类因为那已经刻在基因里所以出生就带着的 “潜力” 或者 “天分”。

如果非要用那个没必要的词汇 “天分” 的话，那么，我们可以理直气壮地声称，也可以用无数的科学根据证明，“你的确拥有天分”，起码，“你一定天生拥有语音天分” —— 除非你拒绝承认你自己属于人类？

“有潜力” 并不等同于 “直接就会” 或者 “一定能够学会”。“有潜力” 的意思是只不过是说 “可以启动” 而已。“说话” 和 “走路” 一样，是每个新生儿根本就不需要 “教” 最终自己就肯定能 “做” 的事情 —— 注意，不是 “会不会” 而是 “做不做” —— 到最后，只要正常，这两件也是每个人都能做好的事情。

在没有任何 “方法论” 作为指导的情况下，每个婴幼儿都只靠 “生学硬练” 逐步开始 “说话”，但，吐字清晰，大抵上需要三年左右的时间。三岁整的孩子，在 “说话” 这件事儿上 “经验不足三年”，所以，即便在他们已经能够说很多话，甚至调理都相当清晰的时候，依然 “吐字不清”，他们说的可能不是 `táng hú lu`（糖葫芦），而是 `dáng hú nu`…… 那有怎样呢？大人无需纠正他们的，早晚有一天，他们会 “自然而然” 地 “突然之间” 做到 “吐字清晰”。

这个过程之中，他们的大脑在为每一个 “音素” 的 “准确发声方式” 创建 “神经元间连接”，而后经过不断的 “调整”、“修正”、“强化”，做到 “吐字清晰”，即，针对每个 “音素” 都形成了 “足够强壮且通畅的神经元间连接” —— 准确地讲，那每一个甚至都应该是很多 “连接” 组合而成的 “网络”。

为了 “提高效率”，大脑会进行 “处理” 上的 “优化”。大脑会从 “优先关注必要音素” 开始逐步过渡到 “忽略不必要的音素”。比如，只以中文普通话为母语的人，除了关注 “口腔内气流共振靠前的 `a、á、ǎ、à`” 之外，没必要去关注其它类似的因素，比如 `æ` 和 `ʌ`，到最后干脆达到了 “屏蔽效果”，所谓的 “听而不闻”。

这当然为 “新语言的习得” 形成了一定的 “障碍”，因为我们的大脑最喜欢 “效率”，能用 就尽量用 “已有的神经元间连接”，因为 “创建新的神经元间连接” 就是异常耗时费力的，对大脑来说，就是 “耗能成本过高” —— 这个过程很累，大脑内部的活动，是真的在 “放电”，这不是 “比喻”，就是字面意义上的真实的 “放电”。“启动任务” 中的练习，三小时很累的，练完了肚子饿的程度，可能不亚于大家误以为更累的 “跑步”。大脑，虽然在体重上只占很小一部分的比例，可实际上却是浑身上下 “能源上开销最大的器官”。

但，**这个 “障碍” 其实是一种 “幻觉”。**这个 “障碍” 的 “大小”，竟然完全是你自己赋予的。你觉得它的确是障碍，它就会成为一个实实在在不可逾越的障碍；你越是轻视它，你就可以更轻松地打败它；若是你竟然对它视而不见，它就压根不存在……

我们对这个所谓的 “障碍” 可以 “彻底忽视” 的理由在于说，“**人类的大脑具备极强的可塑性**”，这是脑科学研究证明的结果，无容置疑，并且，“大脑的可塑性”，从生至死，一直具备，这一点，也是科学证明过的，也无容置疑。换言之，不管你多大岁数，你的大脑都有能力 “创建新的神经元间连接”。

Oxford Handbook of Expertise 的总编，为 Harvard Business Review 出版的 On High Performance 里专门撰写了一篇文章，*The Making of an Expert*，其中提到人类对 “标准音高” 从全盘误解到清楚认知的过程。过去，人们认为 “标准音高”（Perfect Pitch）是一种 “天分”，有就是有，没有就是没有，人群中恨不得只有十万分之一的人拥有这种 “天分”，比如莫扎特 —— 莫扎特可以分辨任何声音的 “音高”（Pitch），哪怕是你在另外一个房间咳嗽一下，他都可以用键盘弹出你刚刚那声咳嗽的 “音高”。

可后来研究者们发现，人们过往误以为的 “天分”，其实都是 “练” 出来的，无一例外 —— **“练出来” 的 “诀窍” 竟然只不过是 “练的久”**…… 对那些被称为 “天才” 的人，他们**真正的 “优势” 其实是 “练得早”，所以才相对 “练得久”**…… 尤其是近年来越来越多的脑科学家们的研究结果在不断支持这个结论，每个人天生可能都有差不多的 “潜力”，只不过，这个 “潜力”，需要 “练” 才能 “实现”…… 换句话讲，很多人不是没有 “天分”，而是因为 “虚度了时光” 才逐步 “失去” 了 “天分”

练习 “标准音高” 没多难，没多复杂，网上甚至有很多免费的 “开源程序”。今天，人群当中拥有 “标准音高” 的比例，早已不再是 “十万分之一”，也不是 “万分之一”、“千分之一”…… 早就超过了 “百分之一”，并且，这个比例还在不断提高 —— 为什么？这不是什么 “有就有没有就没有” 的东西，它只不过是 “**练就有不练就没有的东西**”…… 当然，必须 “短时间内足量重复”，否则，“随便搞搞” 就等于 “压根没有”。

人和人之间毕竟有所差异，所以，人们常说的 “天分” 还有另外一层意思指的是这种 “不可避免的天生差异”。比如，手指短的人可能弹琴相对吃亏一点，个子矮的人可能打篮球相对吃亏一点，长得帅的人在人际沟通中相对可能更有优势，有标准音高的人在学外语尤其是练语音的时候肯定相对更有优势…… 这是 “不可否认” 的事实。

但与此同时，我们总是可以看到更多的 “反例”，手指短的钢琴大师其实不少，个子矮的篮球明星并不罕见，长得丑的谈判专家非常普遍，绝大多数人都没有标准音高却都可以正常说话……

首先，生活中很多重要的技能，其实并不需要做到 “万里挑一” 或者 “百里挑一” 的地步，“够用” 就已经很好了；“优秀” 到一定地步，不一定非要 “超群”，就已经太好了。我们每个人都一样，能做 20 个俯卧撑，可能就很好了，够用了，能做 100 个当然好，但，实在没必要能连续做 46,002 个，不是吗？

当你被要求 “拿腔拿调” 地 “练” 的时候，基于过往的误解，你脑子里的那个声音，“我没有那个天分” 会格外地响亮，与之前让你 “为某些 ‘音素’ 创建新的神经元连接” 的时候你听到的更加震耳欲聋…… **可真相是，那个声音完全出自幻觉 —— 100% 的幻觉。**

**换个观念吧！**

> “天分” 这个东西，就算真的存在，也是 “练出来” 的，而不是像某个配件一样安装进去的。

“换个更合理的观念” 非常划算的，因为那等于 “轻松” 且又 “瞬间” 地 “换了个脑子”。

另外一个 “陈述” 更为准确有效：

> * 你有无穷的 “潜力”……
> * 你的 “潜力” 能否 “实现”，取决于你 “练不练”，“练多久”，“练多早”，“练多狠”……
> * 你能实现 “多少潜力”，取决于你有 “多少时间”……
> * “你的时间” 是否有效，取决于你向其灌注了 “多少注意力”……

最后的 “关键” 来了，你能够往你的 “时间” 里 “灌注” 多少 “注意力”，取决于你的 “动机”（或称 “欲望”），因为它决定了你的大脑为此设定的 “**效能阈值**”。回顾我们的整个 “启动任务” 的设计，全都是顺着这个思路搞下来的，没有效果才怪呢。

你不是为了要 “当演员” 或者为了要 “博眼球” 才要求自己 “拿腔拿调”，你只是为了 “**提高训练效率**”。你的要求的出发点很朴素，只不过是 “效率”。我们可以从各个角度为自己做 “心理建设”；我们可以用很低俗的 “动机” 作为刺激，比如，很多男生当初不管有没有 “天分” 都要练吉他的原因只不过是为了更快更多地与异性接触；我们甚至还可以 “欺骗我们的大脑”，比如 “算假账”…… 但，所有的人都一样，所有人的大脑最喜欢的就是 “提高效率” —— 这可是适用于所有人的 “最佳动机”。