# 只能精读

## 1. 不老实就肯定吃亏

做人可以不老实，学习不老实就非常不划算。在这一点上，我算是捡了便宜。

我的父母从来不吝惜给我买书的钱，于是几乎从记事儿开始，我的主要花销就是买书，直到今天。而在我八九岁的时候，母亲随父亲平反落实政策调动工作，不再做兽医，调到某大学的图书馆工作 —— 于是家里便省下了很多很多买书的钱。从小泡在图书馆里长大，实在是我这一辈子最幸运的事情。

关于读书的态度，我一直感激母亲。很小的时候，有一次坐在那里乱翻书，被母亲看到，她问：“你看什么呢？”

“书呗”，我心不在焉。

“那么翻，你能看懂什么呀？” 母亲好像很随意。

我说，“这种书 …… 随便翻翻就行了……”

母亲顿了一下，过来把我手中的书拿走，扔在桌子上，一字一顿地说：“随便翻翻就行的书，你看它干吗？浪费生命。”

我愣了一下，却很快明白了母亲的意思。这句话一下在就刻在我的脑子里，从来不曾忘记。读书，就要读好书。读好书，就不能随便翻翻。所以，这么多年里，无论我读什么，只要认定那是一本值得读的书，我就会精读，并且往往要精读许多遍。后来我也常常跟学生说，好书，不是 “翻” 的，是 “读” 的 —— 并且，只能是 “精读”（当然，更为文绉绉一点的叫法是 “研读”）。

## 2. 读好书一定要慢

读书一定要慢，因为只有慢读才可能细品。读书与赶路不同，对赶路的人来说，几乎只有终点才意味着一切；如果赶路的人流连路边的风景或者纠缠沿途的遭遇，他就可能无法到达终点甚至误入歧途。然而读书却并非如此，如若读书真的是像是赶路一般，那么打开书直接读最后一句话岂不是最好？

好书对一些人来说就好比氧气一般重要。曾经觉得好书难寻。我至今清楚地记得二十年前得知有个叫乔治奥威尔的伟大作者写过一本好书叫《[动物农庄](https://www.marxists.org/subject/art/literature/children/texts/orwell/animal-farm/index.htm)》却遍觅不得（那时候这本书是禁书）的极端沮丧。转眼二十年过去，互联网改变了一切。只要读得懂英文，在互联网上可以找得到的好书就根本看不完。

甚至你根本不用上什么学习班，找来好书硬啃，是我能想到的最好、最快、最见成效的英语学习方法 —— 尤其在 audiobook 如此丰富的今天，因为我坚信朗读是获得一切语言能力的最根本手段。

身边的朋友总觉得我读书很快，事实上我读书很慢。我从不 “泛读”，因为我知道一本 “翻翻” 就可以了的书是不值得去读的。我总觉得 “泛读” 只有一种用处：用来粗略地判断拿在手中的书质量如何。二十多岁之后，我发现自己甚至在读小说的时候都喜欢一个字都不放过。遇到措辞考究的作者，阅读过程就更是充满了乐趣。尽管自己写字不喜欢太过考究，但是欣赏他人的精心却很容易让自己产生自己其实也挺考究的幻觉 —— 心知肚明那就是幻觉，然而也知道那是有趣而无害的幻觉。

之所以读书慢，也乐于慢，是因为当前的大环境可以给我一个 “极端八卦” 的机会。十多年前我总是慨叹 “Google + Wikipedia + English = Almost Everything”。现在，又有了 “人工智能”，于是，“Google + Wikipedia + English + ChatGPT = Everything”……

看到作者提到某一作品或者另外一个他所敬佩的作者，马上就可以查得到相关信息，一头扎进去给它翻个底朝天才叫一个爽。看到 George Cooper 在 [The Origin of Financial Crises: Central Banks, Credit Bubbles, and the Efficient Market Fallacy (Vintage)](https://www.amazon.com/Origin-Financial-Crises-Central-Efficient/dp/0307473457) 里提到 Hyman Minsky，马上跑到 Wikipedia 上查，或者干脆直接在 Amazon 上搜，就很快就找到 [Hyman Minsky](https://www.amazon.com/stores/Hyman-P.-Minsky/author/B001HOEE5A) 的 [John Maynard Keynes](https://www.amazon.com/John-Maynard-Keynes-Hyman-Minsky-ebook/dp/B0017SYO2O)（这本原本已经绝版的书，因为 George Cooper 等人的引用，而由 McGraw-Hill 出版公司于 2008 年 4 月重新出版）。再把前前后后的八卦挖掘一番，已经是三五个小时，却也乐此不疲。

读书慢的另外一个重要原因是因为我用很啰嗦的方式记笔记。多年的经验使得我不再相信自己的记忆力，常言道 “好记性不如烂笔头”，笑来说 “记笔记一定用 Google”。摘录原文不再耗费力气（伟大的 Copy/Paste），写下批注，甚至干脆写一整篇文章，加以分类关键字（以便将来搜索），相当耗费时间。但这个时间耗费的值当，不记笔记的人无法理解这种时间精力耗费的合理性，正如不成事儿的人永远不知道事无巨细的道理一样。

好书读一遍是不够的。读书的最大惊喜往往来自反复阅读中的 “偶然” 发现。阅读会刺激思考，思考进而会改变阅读的质量，两者会相辅相成，相生却永不相克。这个过程中几乎可以清楚地体会到多巴胺、内啡肽、血清素的分泌，难怪中国古人说 “书中自有颜如玉”，外国人说 “Reading is better than sex”。

## 3. 人们为什么讨厌精读

关于阅读能力的培养，教育设计者原本的意愿和顺序很可能是这样：

1. 先识字，并识足够多的字（显然常用三千汉字肯定是不够的 —— 对那些了与追求知识的人来说）；
2. 习得足够多的词汇量；
3. 学习更多、更复杂的是概念 —— 每一个重要的概念都需要大量的篇幅阐述；
4. 与此同时习得基本的逻辑运用能力，以便能够更有效地理解组织已知概念及其相关信息；
5. 通过不断的精读习得更多的概念理念；
6. 通过大量的泛读扩充补充自己的概念和理念；
7. 通过实践重新理解重要概念，修正对重要理念的理解；
8. 精读与泛读相互补充、交互运用……

但是，基于种种原因，最重要的是因为教育本身就是个太难乃至于难以成功的过程，这个流程中的每个环节都可能出错。

首先很多人其实并没有识足够多的字（其实对于不断追求知识的人来说，只认得却不会用是相当尴尬的一件事情）；其次很多人也没有习得足够的词汇量—— 尤其是那些貌似简单却随时可能形成各种逻辑陷阱的词汇（比如 “所有”，“任何”，“不是 …… 就是……” 等等）；更可怕的并不是哪一个环节出了差错，而是每个环节都多多少少存在缺陷。

很多的时候，整个扭曲的世界观其实只不过是根植于一两个概念的欠缺或者错误理解 —— 比如 “双盲测试” 或者 “斯德哥尔摩综合症” 就是这样的概念。而其实相当简单的逻辑却是许多人一生搞不懂的东西，“害怕犯错” 进而 “担心受到可怕的惩罚” 是大多数人最终未能掌握逻辑思考能力的唯一根源 —— 教育有时不得不依赖 “强制” 而使得 “恐惧” 占据了很多人的心神乃至于永远无法摆脱它的阴影。

所以，某种意义上来说，很多人从未有能力去 “精读” —— 识字不够多，词汇量不够大，概念量不够丰富，逻辑不够严谨，更为可怕的是，无力做到足量的 “注意力集中”…… 一句话，他们压根就不具备 “精读” 的资格。然而人们总是假定自己的能力会随着年龄自动增加，于是，根本站不住脚的假定开始显得极端自然：每个人从学校毕业之后都假定自己识足够多的字、有足够大的词汇量、足够丰富的概念量、足够严谨强大的逻辑思考能力 …… 最要命的是，自以为是地认为自己已经不再需要 “精读” —— 那是中小学生被逼才愿意做的事情 ——“泛读” 才是配得上自己年龄的活动……

他们就好像是股票市场里胡搞瞎搞的投资者一样，时而凭着运气发了点财，甚至是大财，越发地以为自己的成功绝非偶然 —— 心里想着 “我是有来历的，走在芸芸众生中这种感觉尤为强烈……” 但是只要时间足够久（人们越来越长寿这个事实最大的效用就是使得某些幻觉终将破灭而后不得不面对现实），爬得越高就摔得越惨—— 事后却已经没有机会重新来过。

循序渐进扎扎实实地走到最后一个环节的人所掌握的 “泛读” 能力，和大多数人以为的 “泛读” 其实有着天壤之别。前者尽管在 “泛泛而读”，却拥有足够能力 “不漏过任何重要信息”，并且常常还可以做到 “在字里行间读到言外之意”；后者是真的 “泛泛而已”，从未获得过完整的信息，在千疮百孔的零碎信息中获得属于自己的特有幻觉（且不自知）。

另外，还有一种阅读方式，叫做 “**检索式阅读**” —— 为了 “研究” 而采取的一种阅读方式。英文里，“研究” 是 Research，相当于，Search, Search, and RE-Search，所以，所谓的 “研究”，就是 “反复搜索”，相当于中文古文里的 “上下求索”。“研究目标”，会确定 “研究范围”，也就是 “搜索范围”。于是，需要在特定的范围之内，找到特定的材料，可能是 “更好的例子”、可能是 “必需的证据”、可能是 “必要支持”，或者是 “更新的视角”，甚至 “不一样的结论”…… 不一而足。

于是，在 “精读” 之前，常常需要 “关键字搜索” —— 过去，只能靠 “手动一页一页翻”，一边要随时做笔记的同时，还需要足够的记忆力，因为要靠大量的 “记忆碎片” 持续检索、持续记忆、持续对比…… 现在呢，大多都是 “电子文本”，于是，不太一样了。“电子文本” 最大的好处就是 “可搜索”，“可批量搜索”，“可模糊搜索”，于是，工作效率的提高在过去时完全无法想象的。

一旦找到相应的材料之后，开启的，再一次，“只能是精读”。虽然某本书作为 “被搜索范围” 被阅读的部分只有一两页或者甚至一两段，但，这和平日里人们以为的 “泛读” 或者 “跳读” 是不一样的，因为时时刻刻，都是 “有目的的精读”…… 并且，“检索式阅读” 还真不是随便谁都能做的，因为绝大多数人并没有 “研究目标”，正如他们的人生都没有任何目标一样……

到了一定岁数之后再想重新培养自己的 “精读” 能力就已经是几乎不可能的事情了，因为有太多错误的 “模式” 已经养成，各种各样的错误的理解早已错综盘杂，理不清任何头绪。可惜。

## 4. 为什么全都读懂了可是题目就是做不对？

高中毕业之后，就不用再参加 “语文考试”了。于是，很多人开始误以为自己的语言文字能力已经足够好了 —— 殊不知那只不过是不再参加考试所以缺点不会被暴露而已。到了大学，虽然很多人的确不再参加 “语文考试” 了，可是必须参加 “英语考试”（其实还是 “语文”，只不过是 “外语语文”），于是就开始遇到让他们极度恼火的尴尬：

> 为什么这文章全都看懂了，可是题目就是做不对呢？！

我教了许多年的 TOEFL 阅读。刚开始的时候也很奇怪，这些学生怎么可能在看懂文章的前提下做错这么直观的题目呢？我大约花费了两三年时间才彻底弄清楚所谓的 “读懂了” 其实只不过是这些做错题目的考生的幻觉而已。

这种幻觉是如何产生的呢？我翻阅了很多英语领域之外的文献，最终在心理学文献里找到了答案。

原来，人类的大脑有一种特殊且有强大的功能，叫做 “模式识别”（[Pattern Recognization](https://en.wikipedia.org/wiki/Pattern_recognition)）。比如，我们可以在一张很多人的合影中迅速识别出某个特定的人，即便照片上的那个人可能与现在看起来很不一样（比如比现在年轻 20 岁），这样的时候，我们运用的就是模式识别能力。

人类太依赖这种能力了，乃至于模式识别还有一种模糊处理的变体，叫做 “模式拼接”。当我们在处理零散信息的时候，会不由自主地将它们按照某种之前曾经遇到过的模式拼接起来 —— 并且还总是以一种我们自以为有意义的模式。

有些时候，我们会下意识地使用这种功能。比如，你躺在床上，盯着天花板发呆。过一会儿，大脑的模式识别功能就开始自动启动了：天花板上原本毫无关联、毫无意义的几个斑点、纹理开始变得 “有意义” 起来，比如，你好像看到了一张人脸，或者别的图案什么的……

![](../images/figure56.png)

-- Devil's face in the smoke. A famous photo on 9-11 attack.

上面一张照片，是美国 2001nm 年 911 恐怖袭击事件发生时现场拍摄的一张照片，后来在互联网上广泛流传。人们在双塔大厦被撞之后的漫天烟雾中看到了一张 “栩栩如生” 的撒旦面孔。

问题在于，如果一个人在此之前从来没有在任何地方任何时刻见到过撒旦面孔的话，那烟雾的形状再怎么像撒旦或者完全与撒旦一模一样（假设撒旦真的存在的话），此人也无论如何不可能认出来 —— 因为他之前根本就没见过撒旦么！

合理的解释是，人们在此之前在很多地方都见过撒旦的面孔 —— 戏剧、电影、动漫、插画等等，所以在看到原本毫无意义的烟雾形状之时，迅速调用了大脑中曾经存储过得 “模式”（Pattern）,而后用来 “理解” 当时所看到的东西 —— 于是，他们 “看” 到了并不存在的撒旦面孔。

这就解释了为什么那么多做错题目（实际上那些题目非常直观，只要真的读懂了文章，那题目不可能做错）的学生坚信自己读懂了文章。他们实际上根本没有读懂，他们只能读懂文章中的某些部分，而另外一些部分他们读不懂。然而，那些读懂了的部分就好像是天花板上原本无意义的斑点一样，在这些学生不知不觉启动自己的 “模式拼接” 能力之后，变成了貌似有意义的模式 —— 可实际上呢？他们在调用的是自己过往曾经存储过的某些模式；而这些模式实际上他们正在阅读的文章的真实内容无关，甚至干脆相左。于是，他们 “觉得看懂了文章”，实际上看到的却是 “另外一个鬼才知道是什么的东西”，在这种情况下怎么可能做对题目？！

## 5. 精读的方法

读文章还是有一点点的方法的，读考试（TOEFL/IELTS/SAT/GRE/GMAT）里的阅读文章更是如此。但请放心，真正有效的方法总是非常简单的。（以下文字相对抽象一点，但，也许这本身就是一篇很好的阅读材料……）

当我们读进来第一句话（标识为 S1)的时候，任务只有一个，“这句话在说什么？”（What does S1 mean? 标识为 M1）其实，有些时候，这并不是一个简单任务。需要两样东西支撑：1)语法知识；2)概念体系。但是，很多人竟然以为只需要单词就够了。

然而，读进来第二句话（S2）的时候，任务就多了一个：不仅要搞清楚 M2，还要搞清楚 M1 和 M2 之间的关系（标识为 R1&2）—— 这是竟然有很多人从来不做的事情。

M1 和 M2 之间的关系，大抵上分为两种：

1. M1 被 M2 支持。这时，M2 往往可能从三个角度之一（或者三个角度组合使用）去解释 M1——What？（举例、阐述）Why?（因果、比较、分类、目的） How?（方式、手段、步骤）
2. M1 与 M2 共同支持另外一个句子。这时，M1 与 M2 之间可能的关系分别是：并列、递进、转折。

如果，M1、M2、R1~2 都已知，那么即意味着说真正的 “阅读理解” 就已经全部完成。

然而，在考试中，考生往往遇到的情况是：

1. M1 未知、M2 已知、R1&2 已知；
2. M1 已知、M2 未知、R1&2 已知；
3. M1 已知、M2 已知、R1&2 未知；

这与简单数学没什么两样（就好像 “x+y=z”）—— 一个方程式里面有三个变量，其中两个已知，就很容易推导出第三个变量的值。如果三个变量都是已知的，那也不算是什么考试了。

要知道，设计得严谨科学的阅读理解考试中，是不会出现一个方程式里有三个变量其中却竟然有两个未知的情况的 —— 那不叫考试，那叫 “刁难”。这也是我为什么总是劝诫考生，轻易不要相信什么 “模拟题” —— 反正，我研读过的所有非 ETS 官方的题目，大抵上都不严谨、不科学，不管作者和出版机构是多么地权威 ——不信，谁都可以用刚刚说的简单道理去自己做个判断。

同样的道理，段落与段落之间的关系也是如此。不仅要能够概括出第一段的大意（标记为 MP1 ），然后还要再概括出第二段的大意（标记为 MP2），最后还一定要弄清楚二段之间的关系（标记为 RP1&2）—— 这就是更多人坚决不做的事情了 —— 而后又是解方程式了……

道理都已经清楚了（我有的时候很奇怪我究竟是如何运用这样的简单的认知就成了所谓的老师的？），之后就是平时练习的步骤了。

1. 挣扎着搞清楚每一句话的确切含义。运用一切可以运用的手段 —— 查词典，查语法书，甚至去查 Google（1998 以后），还不行，问 ChatGPT（2023 以后）。“自己动手” 比 “花钱让别人替自己干活”（比如，报班上课听讲）在这方面不知道要有效多少倍。
2. 理解每句话之间、每个段落之间的关系。处理段落还有另外一个任务 —— 概括。
3. 整理词汇。要知道，读完一篇文章之后，自己动手整理词汇，远比背单词书效率高出许多 —— 可惜，大多数人并不相信。
4. 反复阅读若干遍。读着读着就可能发现很多第一次读并没有注意到的东西。
5. 复述文章。能够书面或者口头复述刚刚读过的文章，实际上需要很多综合能力：记忆力、逻辑能力、转述能力、重新组织能力、再理解能力等等。
6. 养成相隔若干天后复习的习惯。

（其实，无论哪一种考试，拿来真题，如此处理 50 篇左右的文章，就基本上所向披靡了。TOEFL 考试和国外的所有考试一样，有 [Official Guide](https://www.ets.org/toefl.html)）

鉴于大多数人学英语只是为了应付考试，所以，以上的文字里，是拿着考试文章作为示范的。事实上，读任何文字都可以这样 “品”，只不过，不同类型的文章，“品” 的要点不同而已。读诗品意境，读散文品心境，读小说品情节，读报纸品现实。为了学而读，还要在读与品之外考虑很多事情，作者为什么这么写，这么写好的话好在哪儿，差的话差在哪儿，要是我去写应该怎么写才能更好 …… 等等等等。

## 6. 快速阅读往往并不靠谱

市面上各种各样关于 “快速阅读” 的神话，其实都非常不靠谱。我不相信那种靠改变眼球运动方式提高阅读速度的理论，因为速度的瓶颈根本就不在于 “输入方式”，而在于 “理解能力”。我也绝不相信 “快速阅读” 能靠一个什么 “补习班” 就可以解决 —— 我相信阅读理解速度只能通过积累提高。

各种快速阅读理论都有一个共同的缺陷，它们假定所有的文字都是格式化的 —— 事实上这绝对不可能。只有格式化的数据才能批处理，这是每一个程序员都懂的道理。可问题在于，知识不可能是格式化的，有的简单，有的复杂，有的恰恰因为简单而难以理解并加以应用，而它们之间又相互关联，有着复杂的依存关系。想用一套简单的模式处理所有的数据，这愚昧的痴心妄想。

积累阅读量是提高阅读理解速度唯一方法。读书多的人读书快。尽管好像人们更愿意相信这句话的反方向：那是 “因为读书快所以才读书多”。

观察一下生活。那些只读到初中再也不上学了的人，看书很慢的（姑且不论他们能否看懂），也很省钱：一本几块钱的杂志可以读好几个月。而相比来看，大学生读书就要快出许多，一本杂志在坐地铁的过程中就可能被他翻阅完毕，并且过后还能将其中精彩的内容复述给朋友。为什么有这么大的差异呢？因为二者之间的阅读量积累差异实在是惊人。

心理学家 Blachowicz 博士曾经做过的调查结果可以给我们一个更清楚地解释这个道理的依据：

> 一个五年级的学生，如果每天能够做到独立阅读 10 分钟的话，那么就要比那些不做独立阅读的孩子每年多读 62 万 2 千词……

这个数据告诉我们，一个五年级的孩子，差不多一分钟阅读大约 170 个英文单词。而实际上，中国的小学生如果在阅读中文的时候，可以做到差不多一分钟 200 字以上（因为中文的字都是单音节的，而英文词汇往往不止一个音节）。

如果我们按照 200 字/分钟的阅读速度计算，不算小学时代，仅仅初中三年，平均来看每个孩子每天的阅读量大约是 1.5 万字（仅相当于 75 分钟的阅读量）。换言之，初中时代，一个普通的学生，三年总计阅读量会超过 1600 万字 —— 如果假设平均一本书 20 万字的话，就相当于 80 本书。

到了高中时代，喜好读书的孩子阅读量增长会超乎普通人想象 —— 他们的阅读速度会很自然地提高 2～3 倍，又由于理解能力大幅度提升，他们往往并不需要 “速读”，而是通过 “略读” 获取更多的信息。比如说，作者为了证明一个道理提供了三个例子 —— 体现为三个段落，那么，有更强理解能力、有更多阅读储备的人可能会扫过第一个例子，跳过其它两个例子而去继续阅读下一个章节。因为这样的时候，他们的阅读速读看起来就比其他人快出许多。所以，通常情况下，在初中时代积累了大量阅读量的学生，在高中时代的阅读速度大约会提高 10 倍左右。这样算下来，整个高中三年，喜好阅读的孩子通常会在这个时期保守估计积累超过 1 亿字的阅读量。（这是 “初级阅读者” 的计算，而我们之前用 “熟练阅读者的阅读速度” 也做过一次计算。）

这就好像飞行员也好、汽车司机也罢，夸耀自己驾驶水平时会 “很客观” 地强调自己的驾龄或者里程数一样，一个人的阅读量积累越多，他的阅读理解能力就越强，进而阅读速度就越快，进而阅读量更容易积累，从而形成良性循环。

所以说，真正有用、有意义的快速阅读能力，是靠积累获得的，而非靠什么新鲜的不靠谱理论，或者蒙钱的培训班。

## 7. 给自己种一棵读书种子

经常听人们这样说：“我对英语非常感兴趣”，却很少听到有人这么说：“文字太美了！” 很多人对英语感兴趣，却对母语没兴趣，这只能说明他们不了解文字的意义，只不过是肤浅的实用主义者而已。他们看到的只不过是 “英语好的话薪水高，机会多……” 而已。要不然他们怎么会对越南语、缅甸语不感兴趣？人大多都如此，都想要自己配不上的东西 —— 这是他们的本质，也是他们最终不快乐的根源。当然，他们把这种莫名其妙的行为称之为 “追求”，并且对这个词有着特殊而又浓厚的情感。肤浅的实用主义者对英语的兴趣，就好像是一个不懂工程的人对工具的兴趣一样无聊。

英语不过是一种文字，这一点上来看，它并不比其它的文字更好、更高级、更优美。自认为自己的母语是全天下最美的语言，是最为幼稚的想法（都懒得加上之一）。印象中第一次意识到这种幼稚的存在，是读中学的时候，语文课本里有篇文章叫《最后一课》，作者都德激情地写道，“法语是世界上最美的语言！” 而在另外一个国度（这个国度里所使用的语言是地球上使用者最多的语言：汉语），（中文）语文老师激动地（某种意义上也避重就轻地）讲述着作者都德的爱国热情，一遍一遍地复述着都德那个狭隘民族主义的弱智句子 “法语是世界上最美的语言！” —— 有比这个更为荒唐的场景么？（当然，都德在那个特殊的时代拥有这种（狭隘）民主主义情绪，从另外一个意义上来说更可能应该被理解为 “英雄的”……）

任何语言文字都有它自己固有的独特之处，都有它独特美丽的根源。然而最终，语言文字是用来表述、记录、交流思想的。如果有什么真正美丽或者更加美丽的话，是思想，而不是语言文字本身。美丽的思想，用任何语言表达都美丽，用一种语言表达光芒四射，用另外一种语言表达四射光芒。电影[V for Vendetta](http://en.wikipedia.org/wiki/V_for_Vendetta_(film))中，主角 V 身中无数枪却不死，缓步逼近 Creedy，而 Creedy 的手枪里已经没有了子弹，于是绝望地大喊，“Why won't you die?!” V 淡然地说，“Beneath this mask there is more than flesh. Beneath this mask there is an idea, Mr. Creedy. And ideas are bulletproof.”

<video src="../videos/V.for.Vendetta.2005.beneath.this.idea.mp4" />

印象里第一次深刻体会到多懂一门语言的好处，是终于读到 [Animal Farm](http://en.wikipedia.org/wiki/Animal_Farm) 这本书的时候。这本书在国内许多年前曾经是禁书。经常可以在一些牛人的文章里看到这本书被提及，我却遍寻不得之，极为痛苦。终于有一天，搞到一本 Animal Farm 的英法对照本，于是一口气读完。当时的我当然看不懂法文了，而英文要靠不停地查词典才可以。那所谓的 “一口气” 大约是两个星期 —— 那书其实只不过是薄薄的一个小册子而已。Animal Farm 被誉为 20 世纪最伟大的小说之一。作者乔治·奥威尔（[Geroge Orwell](http://en.wikipedia.org/wiki/George_Orwell)）用他不留情的笔触讲了个让人毛骨悚然的寓言故事。

> 在英格兰有这么一个农场。农场的主人常常酗酒，也不懂得善待农场里的动物们。有一天，主人不在，有一头老猪把大伙召集到谷仓里开了个会。就看它颤颤巍巍爬上台，对台下的动物们说，“I had a dream……”还没讲完，农场主就回来了，动物们吓得赶紧散会。第二天，老猪就去世了。可是那天老猪的讲演却深刻而又顽固地留在动物们的脑海里，尽管大多数的动物并不是很懂老猪说的究竟是什么……后来有一天，有两头猪（猪是所有动物里智商最高的），一头叫Snowball，另外一头叫Napoleon，带着大伙起义了，把农场主赶了出去，占领了农场，建立了Animal Republic…农场里还有很多其它动物，比如，无论谁说什么都点头称是的鸭子们，无私奉献自己的蛋的鸡们，充当警察角色的狗们，一匹为首是瞻兢兢业业的低智商的马Boxer，一个只喜欢花丝带的小母马Mollie，一头什么都看不上愤世嫉俗的老驴Benjamin，还有一只说话不中听的乌鸦 Moses……Animal Republic有七戒，最后一条是“All animals are equal.”

这本书读过很久之后的某一天，我突然意识到，多懂一门语言就相当于多出了一片天空。英语对我来说，不再是要 “学” 那么简单了，而是要用它获得自由，哪怕仅仅是精神上的自由 —— 再说还有什么比精神上的自由更为宝贵的东西呢？

从某种意义上，我一直感激那个在我那个年代里把 *Animal Farm* 这本书禁掉的那个人（或 “那些” 我永远也不会知道是谁的人），如若他（们）未曾设置那样一道貌似不可逾越的障碍，我可能永远不会有这种特殊的体会。其实，这是个格外普遍现象，人们有更强的动机去翻阅 “禁书”……（当然，《动物农庄》早就解禁了，今天在国内随处可以买到它的中译版。）

再后来，有一天听[Randy Pausch](http://en.wikipedia.org/wiki/Randy_Pausch)博士在他的 “[The Last Lecture](https://www.youtube.com/watch?v=ji5_MqicxSo)” 中说 “The brick walls are there for a reason. They're not there to keep us out. The brick walls are there to give us a chance to show how badly we want something…” —— 瞬间，热泪盈眶。

<video src="../videos/Randy-Pausch-Last-Lecture-sample.mp4" />

## 8. 只有人类才善于阅读

人类正是因为有了文字才与其它物种有了本质上的不同。而阅读，对于任何一个正常人类来说都具有非凡的意义。人类之外的物种只能依赖最落后但被称为神奇的方式积累经验：基因遗传。Terry Burnham 和 Jay Phelan 在 MEAN GENE 一书中提到，啄木鸟可以本能地采用最优算法获取食物 —— 而一个 MIT 的数学博士面对同样的问题却不见得可以迅速解决；而啄木鸟的小脑袋在没有受过高等教育的情况下，是如何得到结果的呢？答案是：通过基因遗传。

人类当然可以通过基因遗传积累经验。婴儿尽管没有见过蛇，但只要见到蛇就会嚎啕大哭；婴儿也没有见过枪，但他们却不怕这个比蛇要可怕不知道多少倍的东西 —— 人类祖祖辈辈被蛇咬过不知道多少次；然而，人们认识到枪的危险至今只不过两百年不到，还没来得及形成可以通过基因遗传的 “天生” 的恐惧。

文字的出现，使人类与其他动物区分开来。文字的出现，使得人类的经验积累不再仅仅依赖基因遗传。人类开始使用文字记录并积累信息、获得知识、传播经验 …… 信息爆炸使得我们处于人类史上进步最为惊人的时代，日新月异这个词已经不够 —— 用 “分新秒异” 都并不过分。

人类终于有了文字之后，并没有马上因此获得应有的恩惠。知识的传播与积累并没有一下子变得太过容易。从结绳记事到刻石颂德，从罄竹载罪到纶巾议论，从宣纸录史到革皮藏图，文字的载体从未易于保存、便于传播。小说《西游记》生动地讲了这样一个故事：在文字传播极为困难的时代，获取知识有多么地辛苦。

然而，今天，文字传播的便易也已经到达前所未有的高度。可以说是互联网改变了一切。字处理程序、博客程序（blog engine）、微博客（比如 twitter）以及搜索引擎使得文字的书写、经验知识的记录、传播、共享、检索变得前所未有地容易。任何人只要稍有常识，就可以 “出版” 自己 “体验”、“试错”、“观察” 的文字记。搜索引擎简单而又清爽的界面背后几乎是宇宙量级的信息（用 “海量” 这个词已经不够）。知识共享的精神被前所未有地发扬光大，最直接的也是意义最重大的产物就是免费的维基百科（Wikipedia）。今天，只要拥有足够的阅读能力，任何人都可以获得过去难以获得的 “博士” 级的知识。

在这样的时代里，“阅读” 突破了个体的 “体验” 或者单纯的 “试错” 的种种局限。“体验” 往往只能局限于自己，而 “试错” 局限于自己的阅历。然而，通过 “阅读”，我们可以得知他人的 “体验” 和 “试错” 结果（即所谓的 “经验”）。可以跨越时间、空间，不用说可以跨越种族和国度 —— 文字翻译工具越来越先进，而掌握两种或者两种以上语言的人数也在不停地增加。

“阅读” 的前提是使用文字记载的前人经验已经存在。而文字使得快速的经验积累成为可能 —— “对蛇（爬行动物）的恐惧” 可能需要几百代才能通过记忆遗传变成 “天生的知识”，但是，有了文字之后，一代之间，就有可能积累并获得千百年来积累的知识。现代人只需要通过小学、中学、大学总计差不多十五年左右的时间里，就有机会在学校里把哥白尼、伽利略、牛顿，或者达尔文、门捷列夫，甚至爱因斯坦等历史上的巨人们所拥有的全部知识囊括在自己的脑中。

文字太重要了。但是，明显的另外一个事实是，小学、中学、大学总计差不多十五年左右的时间貌似并不可能，也没有做到 “教育” 出另外一个哥白尼、另外一个伽利略、另外一个牛顿，或者另外一个达尔文、另外一个门捷列夫，甚至另外一个爱因斯坦。显然，还应该有更重要的获取知识的方法，其使用以及传授的难度之高甚至连世世代代的精英们前仆后继呕心沥血精心设计的 “正规教育” 体系都往往以失败告终。

而习得第二语言（甚至更多语言）之后，就多出另外一片天空。而英文目前又是地球上文库信息量最大最高质的文字，而 Wikipedia 的出现，又进一步强化了英语在这方面的地位。尽管有些时候，部分英文书籍有相应的中译版，但，读译本有时很令人头痛，令人不痛快，因为

1. 译文质量差；
2. 译文也许经过裁剪 (censorship)；
3. 译文也必然来得太晚……

也许有些人认为读译文更省时间，然而，从另外一个角度来说，习得第二语言才是真正节省时间提高效率的方法。习得第二语言根本没有那些失败者想像得那么难，相反可能很简单。那些人之所以觉得 “那么难”，其实无非是因为他们在这方面没有成功过而已。做得好的人也知道难，并且真的知道真的有多难，但他们好像并不怕难。其实也对，想想看吧，做什么事不难呢？怕又有什么用呢？

## 9. 轻松搜索电子书

许多年前，获取大量有效信息的方法几乎只有一个，去图书馆；而在国内，图书馆是大城市的特权。互联网改变了一切，电子化的文档某种意义上早已经把纸媒远远抛在了身后。在英文世界里更是如此。

常用的搜索方法有这么几个：

### 1. 在 Google 上直接搜索书名或者作者名。

有些作者可能会直接提供全文下载。比如，诺贝尔经济学奖得主米尔顿弗里德曼（Milton Friedman）的 “[Free to Choose](http://www.freetochoose.net/)” 不仅有文本，还有 PBS 为其制作的 15 集视频。《自私的基因》的作者；理查德道金斯（Richard Dawkins）的个人网站上提供他的大部分著作的下载。

### 2. 在 Google 搜索里指定文件格式

电子书的最常用格式包括这么几个：chm, pdf, djvu。chm 格式无需特殊的阅读器，pdf 需要安装 Adobe Reader；而 djvu 也有自己的阅读器。而很多的时候，网络上这些电子书往往会被压缩成 rar、zip 或其它格式；最好安装一个 WinRAR 或者 7-Zip 解压程序。

搜索时，在 Google 的输入框里输入作者名或者书名，之后填上 “filetype:pdf”。比如：

> Tipping Point filetype:pdf

总之，可以尝试的文件类型有：chm, pdf, djvu, doc, rtf, txt, rar, zip…

### 3. 到 Google Books 上看看有没有可以直接浏览的版本

Google Books 做的非常好，访问地址是http://books.google.com/。很多书籍都可以直接在线阅读；就算没有“Preview”的书籍，也提供检索功能。

### 4. 干脆自定义一个专门的搜索引擎

Google 的自定义搜索引擎（[Google CSE](http://www.google.com/cse/)）功能非常强大。我专门做了一个搜索电子书的 CSE，在这个页面上可以找到：http://is.gd/6nUgW

### 5. 到 WikiPedia 上搜索一下作者和书名

在 WikiPedia 上往往可以找到很多相关信息；作者越著名，书籍越畅销，相关信息就越多。往往会顺藤摸瓜找到更多资源。

## 10. 如何收集好书

如果说好书多得像大海一般汪洋，那么烂书就好像太空一样苍茫。周永年之所以见书必得，是因为那个年代成书太难，传书不易。而今却不一样，出版越来越容易，传播越来越便捷。人们总是说这是个信息爆炸的年代，但是我却深不以为然。要真的是有效信息爆炸就好了 —— 因为它爆炸了，我们就开心死了，爆炸了的有效信息不仅好找，而且好用。可事实上，爆炸的更可能是垃圾信息而已。互联网的出现，某种意义上只是加快了信息流动的速度而已，在有效信息创造方面的提升尽管很明显但效用从目前来看却依然有限。于是，更得益于传播速度增加的是垃圾信息、无效信息。而相对来看，有效信息却前所未有地更加难以寻找、筛选。

所以，花时间选书不仅一点都不浪费时间，更重要的是这个过程等同于在提高自己的生活质量。我个人对各种时间管理技巧都抱有一定程度的狐疑，只相信 “用正确的方法做正确的事情” 才能不虚度光阴。读书时需要消耗时间的，消耗时间等同于消耗生命，只要意识清醒，有谁愿意无谓地浪费生命呢？

最先可以从作者入手，买牛人写的书，尝试着去理解牛人的看法和想法。想了解任何一个学科，都可以先去看看那个学科里当前最著名的人写过哪些书。最著名的人不一定是最好的作者，但，总体上来看，他还是最靠谱一些。我读宏观经济学的时候，第一本教课书读的是 MIT 的经济学教授 Paul Krugman 与 Maurice Obstfeld 合著的那本 [International Economics: Theory and Policy](https://www.amazon.com/International-Economics-Theory-Policy-2-downloads-ebook/dp/B09KNBWY4G)；此书 1998 年第一版，到 2008 年已经是第八版了；同一年，Paul Krugman 获得诺贝尔经济科学奖。这样的作者所写的书，读起来相对更加放心一些 —— 尽管，时时刻刻保留一点怀疑态度没什么不对，也确实应该。再后来，想去认真读一下心理学的时候，我选的第一本书是宾夕法尼亚大学心理学教授 Martin E. P. Seligman 的 [What You Can Change and What You Can't: The Complete Guide to Successful Self-Improvement](https://www.amazon.com/What-You-Change-Cant-Self-Improvement-ebook/dp/B000Q9IWP0)。

有些时候，我们需要去了解一个之前全无了解的领域，这样的时候，我们可能几乎没办法知道那个领域里究竟有哪些牛人。那还有另外一个方法，从版次入手。一般来说，我只买第二版以后的书。大约在 1997 年前后，二十五六岁的我，突然有一天发现自己竟然缺乏足够的逻辑思维能力，于是只好跑到图书馆里找答案。从 “thinking” 这个词入手开始检索，发现有很多书的名字都以 “critical thinking” 为关键字 —— 那之前我都不知道还有这样一个词组（可见我有多么孤陋寡闻）。于是，在一大堆名字里有 “critical thinking” 的书籍里，选择了一本五六年前第一版、当时已经再版四次的书，[Beyond Feelings: A Guide to Critical Thinking](https://www.amazon.com/Beyond-feelings-Vincent-Ryan-Ruggiero-ebook/dp/B0BTKG254X)，作者是 Vincent Ruggiero，此书于 2007 年发行第八版。一点都不夸张地讲，这本书成了我那次重生的起点。直到今天，我都会时不时拿出这本书翻一翻。反复读过这本书之后，顺藤摸瓜又找到一批相关的好书，于是就不停地有着暗爽的机会……

也是用同样的方法找到了 Joseph M. Williams 教授。当时在我需要的时候，找到了他那本在 1981 年首版、2000 年已经第六版的 [Style: Ten Lessons In Clarity and Grace](https://www.amazon.com/Style-Lessons-Joseph-M-Williams-ebook/dp/B084BY6R32)（此书于 2006 年发行第九版），然后一口气买了他的好几本：[Style: Toward Clarity and Grace](https://www.amazon.com/Style-Clarity-Chicago-Writing-Publishing/dp/0226899144)，[The Craft of Argument](https://www.amazon.com/Craft-Argument-Joseph-M-Williams/dp/032101264X)（这本书我买的是第一版，2007 年此书发行第三版），[The Craft of Research](https://www.amazon.com/Research-Chicago-Writing-Editing-Publishing-ebook/dp/B01L0HWJ6E)。

还有一个淘宝的好地方是好书的 “**参考文献**” 部分。老外写书是非常严谨的，他们从来不会隐藏自己的想法的来源和根据，这些都要清清楚楚地罗列在 “参考文献” 之中。那么牛的人物写书所参考的书籍一般都是好书，而那些被参考的文献的作者，也往往都是骨灰级的大牛。而好书的内容中提到的、甚至给予极高评价的书籍，当然也同样值得找来一睹为快。

近两年我选书又多了两个标准：**优选那些有电子版、有声版的书。**电子版的书籍最好的地方在于可以随时搜索，而听有声书实际上是相当节省时间的，因为可以随时随地听，一本厚厚的书，其实全文朗读只不过是区区一二十个小时而已，往往一两周之内可以反复听上好几遍，而且占用的还只不过是走路、打车等无法阅读的时间而已，相当划算。
