import React from 'react';
function CurriculumIcon(
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      width='60'
      height='60'
      viewBox='0 0 60 60'
      fill='none'
      aria-hidden='true'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M15 6L0 0V55L15 60L30 55L45 60L60 55L60 0L45 6L30 0L15 6ZM12.5 24C15.1285 24 17.3264 22.1561 17.8707 19.6912C19.8628 19.3554 22.2378 19.0587 24.5904 19.0077C27.4964 18.9447 30.121 19.2649 31.9469 20.1449C32.8296 20.5703 33.4622 21.0962 33.8796 21.7178C34.2893 22.3279 34.5735 23.151 34.5735 24.3188C34.5735 25.1295 34.3378 25.6225 33.9959 25.998C33.6073 26.4247 32.9532 26.8343 31.9219 27.1922C30.0008 27.859 27.4496 28.1393 24.5266 28.4606C24.2102 28.4954 23.8895 28.5306 23.5648 28.5669C20.4252 28.9175 16.8925 29.3676 14.1462 30.6563C12.7329 31.3196 11.4204 32.2504 10.4666 33.5976C9.49867 34.9646 9 36.6199 9 38.5481C9.00001 40.5376 9.92037 42.1227 11.3028 43.285C12.6248 44.3965 14.3792 45.1412 16.2448 45.6607C19.9853 46.7022 24.8335 47.0124 29.5055 46.9996C34.2155 46.9868 38.9077 46.6433 42.4108 46.3054L42.5226 46.2946C43.5201 47.6901 45.1538 48.5997 47 48.5997C50.0376 48.5997 52.5 46.1373 52.5 43.0997C52.5 40.4036 50.5601 38.1607 48 37.6904V24.8L56.0001 19.9998L46 14L46 16V26V37.6904C43.675 38.1175 41.8615 40.0066 41.5481 42.3694C38.175 42.6849 33.8267 42.9878 29.4945 42.9996C24.9166 43.0122 20.5147 42.6974 17.3177 41.8073C15.7146 41.3609 14.5783 40.8131 13.8769 40.2234C13.2359 39.6844 13 39.1595 13 38.5481C13 37.34 13.3005 36.5172 13.7311 35.909C14.1759 35.2809 14.8613 34.7393 15.8455 34.2774C17.8942 33.316 20.7549 32.9056 24.0087 32.5422C24.3375 32.5054 24.6711 32.4692 25.008 32.4326L25.0081 32.4326C27.8155 32.1274 30.8531 31.7972 33.2334 30.9711C34.5996 30.4969 35.9434 29.8002 36.9534 28.6911C38.01 27.5308 38.5735 26.0585 38.5735 24.3188C38.5735 22.4581 38.1061 20.8368 37.2004 19.4879C36.3024 18.1506 35.0559 17.2029 33.6836 16.5416C30.9995 15.2479 27.6109 14.9413 24.5037 15.0087C21.9248 15.0646 19.368 15.3841 17.2573 15.7381C16.3047 14.1007 14.5309 13 12.5 13C9.46243 13 7 15.4624 7 18.5C7 21.5376 9.46243 24 12.5 24Z'
        fill='black'
      />
    </svg>
  );
}

CurriculumIcon.displayName = 'CurriculumIcon';

export default CurriculumIcon;
