import React from 'react';

const AsSeenInText = (
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element => {
  const fill = props.fill === 'dark' ? 'var(--gray-75)' : 'var(--gray-15)';
  return (
    <svg
      id='featured-logos'
      viewBox='0 40 1700 200'
      xmlns='http://www.w3.org/2000/svg'
      xmlnsXlink='http://www.w3.org/1999/xlink'
      {...props}
      fill={fill}
      role='img'
      aria-labelledby='as-seen-in-logos-label'
    >
      <title id='as-seen-in-logos-label'>
        Wired, Business Insider, Inc. Magazine, Lifehacker, Time, Quartz, USA
        Today, The New York Times, BBC
      </title>
      <defs>
        <path
          d='m684.03 170v0.84c2.51 0 4.46 0.83 4.46 2.79 0 1.11-0.84 2.79-3.35 2.79-1.95 0-6.14-1.12-9.21-2.23-3.62-1.4-6.97-2.52-9.76-2.52-5.58 0-9.49 4.19-9.49 8.93 0 4.19 3.07 5.59 4.18 6.14 0.03-0.05 0.26-0.5 0.28-0.55-0.55-0.56-1.39-1.12-1.39-2.8 0-1.11 1.11-3.06 3.91-3.06 2.51 0 5.86 1.11 10.32 2.51 3.91 1.11 8.09 1.95 10.33 2.23v8.65l-4.19 3.63v0.28l4.19 3.62v12c-2.24 1.4-4.75 1.68-6.98 1.68-4.19 0-7.81-1.12-10.88-4.47 0.76-0.37 4.57-2.23 11.44-5.58v-19.25c-8.37 3.68-13.03 5.73-13.96 6.14 1.12-3.63 4.19-6.14 7.26-7.82-0.03-0.08-0.25-0.75-0.28-0.83-8.37 2.23-15.91 10.04-15.91 19.53 0 11.16 9.21 19.53 19.54 19.53 11.16 0 18.42-8.93 18.42-18.13h-0.56c-1.68 3.62-4.19 6.97-7.26 8.65v-11.45l4.47-3.62v-0.28l-4.47-3.63v-8.65c4.19 0 8.37-2.79 8.37-8.09 0-5.58-5.3-6.98-9.48-6.98zm-18.14 39.35c-1.96-2.51-3.07-5.86-3.07-10.61 0-1.95 0-4.18 0.56-5.86 0.39-0.16 2.34-1 5.86-2.51v17.3c-2.01 1.01-3.13 1.57-3.35 1.68zm29.3 7.53 0.56 0.56 1.67-1.4 6.14 5.59 8.37-5.59-0.28-0.55-2.23 1.39-2.79-2.79v-18.97l2.23-1.68 4.75 3.91v17.02c0 10.6-2.24 12.28-6.98 13.95v0.84c7.81 0.28 15.07-2.23 15.07-15.91v-18.41l2.51-1.96-0.56-0.56-2.23 1.68-6.98-5.86-7.81 5.86v-22.88h-0.56l-9.77 6.69v0.56c1.12 0.56 2.8 1.12 2.8 4.19-0.02 2.1-0.12 12.61-0.28 31.53l-3.63 2.79zm47.72-0.56-6.98-5.58v-3.35l13.12-8.93v-0.28l-6.7-10.04-14.51 7.81v18.42l-2.79 2.23 0.56 0.56 2.51-1.95 9.49 6.97 12.55-10.04-0.28-1.12-6.97 5.3zm-6.98-23.72 0.56-0.28 6.14 9.77-6.7 4.19v-13.68zm66.7-20.65h-0.56c-0.84 2.24-1.96 3.35-4.75 3.35-2.51 0-4.18-1.39-5.3-2.51-0.54 0.61-3.24 3.68-8.09 9.21l0.56 0.56c1.67-1.51 2.6-2.35 2.79-2.51 1.67 1.39 3.07 2.51 6.97 2.79v23.16c-9.87-16.91-15.36-26.31-16.46-28.19-1.4-2.23-3.35-5.3-7.26-5.3-4.46 0-8.37 3.91-7.81 10.05h0.84c0.28-1.68 1.11-3.63 3.07-3.63 1.39 0 2.79 1.4 3.63 2.79v9.21c-5.03 0-8.38 2.23-8.38 6.42 0 2.23 1.12 5.58 4.47 6.42v-0.56c-0.56-0.56-0.84-1.12-0.84-1.96 0-1.39 1.12-2.51 3.07-2.51h1.4v11.72c-5.86 0-10.61 3.35-10.61 8.93 0 5.31 4.47 7.82 9.49 7.54v-0.56c-3.07-0.28-4.46-1.67-4.46-3.63 0-2.51 1.67-3.63 3.9-3.63s4.19 1.4 5.58 3.07c0.54-0.59 3.24-3.57 8.1-8.93l-0.56-0.55c-1.17 1.34-1.83 2.08-1.96 2.23-3.07-2.79-4.74-3.63-8.37-4.19v-27.9l22.33 39.06h1.67v-39.06c4.19-0.28 8.09-3.63 8.09-8.38 0-0.83-0.27-1.67-0.55-2.51zm13.95 44.37-6.98-5.58v-3.35l13.12-8.93v-0.28l-6.7-10.04-14.51 7.81v18.42l-2.79 2.23 0.56 0.56 2.51-1.95 9.49 6.97 12.55-10.04-0.27-1.12-6.98 5.3zm-6.98-23.72 0.56-0.28 6.14 9.77-6.7 4.19v-13.68zm57.49 0-5.3-4.46-6.14 5.58 2.51 2.51v20.93l-6.7-4.19v-17.3l2.23-1.39-6.41-6.14-6.14 5.58 2.51 2.51v20.09l-0.84 0.56-5.86-4.18v-16.75c0-3.9-1.95-5.02-4.19-6.42-1.95-1.39-3.07-2.23-3.07-4.18 0-1.68 1.68-2.51 2.52-3.07v-0.56c-2.24 0-8.1 2.23-8.1 7.53 0 2.8 1.4 3.91 2.79 5.31 1.4 1.39 2.79 2.51 2.79 5.02v16.19l-3.06 2.23 0.55 0.56 2.79-2.24 6.42 5.58 6.98-4.74 7.81 4.74 14.79-8.65v-18.69l3.63-2.79-0.56-0.56-1.95 1.39zm51.07-14.23-6.14-5.58-9.21 6.7v-6.14h-0.84c0.17 27.12 0.26 42.19 0.28 45.21-0.84 0-3.35-0.56-5.3-1.12-0.06-3.77-0.5-33.91-0.56-37.67 0-2.79-1.95-6.7-6.98-6.7-5.02 0-8.37 3.91-8.37 7.81h0.84c0.28-1.67 1.11-3.07 2.79-3.07 1.67 0 3.07 1.12 3.07 4.75v10.88c-5.02 0.28-8.09 3.07-8.09 6.7 0 2.23 1.11 5.58 4.46 5.58v-0.56c-1.12-0.56-1.39-1.39-1.39-1.95 0-1.68 1.39-2.23 3.62-2.23h1.12v17.3c-4.19 1.39-5.86 4.46-5.86 7.81 0 4.74 3.63 8.09 9.21 8.09 3.91 0 7.25-0.55 10.6-1.39 2.79-0.56 6.42-1.4 8.1-1.4 2.23 0 3.06 1.12 3.06 2.51 0 1.96-0.83 2.79-1.95 3.07v0.56c4.47-0.84 7.26-3.63 7.26-7.81 0-4.19-4.19-6.7-8.65-6.7-2.24 0-6.98 0.84-10.33 1.4-3.91 0.83-7.81 1.39-8.93 1.39-1.95 0-4.18-0.84-4.18-3.63 0-2.23 1.95-4.18 6.69-4.18 2.51 0 5.58 0.28 8.65 1.11 3.35 0.84 6.42 1.68 9.21 1.68 4.19 0 7.82-1.4 7.82-7.26v-34.32l3.34-2.79-0.55-0.56-2.79 2.51zm-12 16.19c-1.4 0-2.79-0.84-3.35-1.68v-12.28l2.79-1.95 3.91 3.63v10.6c-1.31 1.12-2.42 1.68-3.35 1.68zm0 5.3c-1.4 0-2.79 0.84-3.35 1.39v-7.25c0.56 0.56 1.95 1.39 3.35 1.39 1.39 0 2.79-0.83 3.35-1.39v7.25c-1.31-0.93-2.42-1.39-3.35-1.39zm-1.12 18.98h-2.23v-16.47c0.56-0.56 1.95-1.39 3.35-1.39 1.39 0 2.51 0.83 3.35 1.39v12c-0.93 2.98-2.42 4.47-4.47 4.47zm33.77-30.7-13.68 7.81v18.14l-2.79 2.23 0.28 0.56 2.23-1.67 8.93 6.69 13.96-8.37v-18.97l-8.93-6.42zm-6.14 3.91 6.97 5.02v19.81l-6.97-4.74v-20.09zm41.02-3.35c-0.84 0.55-1.68 1.11-2.51 1.11-1.12 0-2.51-0.56-3.07-1.39h-0.56l-4.74 5.3-4.75-5.3-8.37 5.58 0.28 0.56 2.23-1.4 2.79 3.07v17.58l-3.63 2.79 0.56 0.56 1.68-1.39 6.69 5.58 8.65-5.86-0.27-0.56-2.52 1.39-3.34-2.79v-19.53c1.39 1.39 3.06 2.79 5.02 2.79 3.91 0.28 6.14-3.63 6.42-8.09h-0.56zm24.56 33.2-12.84-19.53 9.21-14.23h0.56c1.11 1.11 2.79 2.23 4.74 2.23s3.35-1.12 4.19-2.23h0.55c-0.28 5.58-4.18 8.93-6.97 8.93s-4.19-1.4-5.86-2.23c-0.06 0.09-0.34 0.55-0.84 1.39l13.95 20.65 2.79-1.67v0.28l-9.48 6.41zm-24.84-5.02 0.56 0.56 1.67-1.4 6.14 5.59 8.37-5.59-0.56-0.55-2.23 1.39-2.79-2.79v-42.97h-0.28l-10.04 6.69v0.56c1.11 0.56 2.79 0.84 2.79 4.19v31.53l-3.63 2.79zm71.16-46.88v0.84c2.51 0 4.46 0.83 4.46 2.79 0 1.11-0.83 2.79-3.34 2.79-1.96 0-6.14-1.12-9.21-2.23-3.63-1.12-6.98-2.24-9.77-2.24-5.58 0-9.49 4.19-9.49 8.93 0 4.19 3.07 5.58 4.19 6.14 0.03-0.05 0.25-0.5 0.28-0.56-0.84-0.55-1.68-1.11-1.68-2.79 0-1.11 1.12-3.07 3.91-3.07 2.51 0 5.86 1.12 10.32 2.52 3.91 1.11 8.1 1.95 10.33 2.23v8.65l-4.19 3.63v0.28l4.19 3.62v12c-2.23 1.4-4.74 1.68-6.98 1.68-4.18 0-7.81-1.12-10.88-4.47 0.76-0.37 4.58-2.23 11.44-5.58v-19.53c-8.37 3.68-13.02 5.73-13.95 6.14 1.39-3.63 4.46-6.14 7.25-8.1-0.02-0.05-0.25-0.5-0.28-0.55-8.37 2.23-15.9 9.76-15.9 19.25 0 11.16 9.21 19.53 19.53 19.53 11.16 0 18.42-8.93 18.42-18.13h-0.56c-1.67 3.62-4.18 6.97-7.25 8.65v-11.44l4.46-3.63v-0.28l-4.18-3.63v-8.37c4.18 0 8.37-2.79 8.37-8.09 0-5.58-5.3-6.98-9.49-6.98zm-18.14 39.35c-1.95-2.51-3.07-5.86-3.07-10.61 0-1.95 0.28-4.18 0.84-5.86 0.39-0.16 2.34-1 5.86-2.51l-0.28 17.3c-2.01 1.01-3.13 1.57-3.35 1.68zm37.12-35.16-5.59 4.74v0.28l4.75 5.3h0.56l5.58-4.74v-0.28l-5.03-5.3h-0.27zm6.41 42.69-2.79-2.79v-19.25l2.79-1.96-0.55-0.56-1.96 1.68-5.02-5.86-8.09 5.58 0.55 0.84 1.96-1.4 2.51 3.07v18.14l-3.63 2.79 0.28 0.56 1.95-1.4 6.14 5.58 8.38-5.58-0.28-0.83-2.24 1.39zm46.89-0.28-3.07-2.79v-18.97l2.79-2.24-0.56-0.55-2.23 1.95-6.42-5.86-8.37 5.86-6.42-5.86-7.82 5.86-5.02-5.86-8.09 5.58 0.28 0.84 1.95-1.4 2.79 3.07v18.14l-2.23 2.23 6.42 5.3 6.14-5.58-2.52-2.51v-18.97l2.52-1.68 4.18 3.91v16.74l-2.23 2.23 6.42 5.31 6.14-5.58-2.51-2.52v-18.41l2.23-1.4 4.46 3.91v16.74l-1.95 1.95 6.42 5.86 8.65-5.86v-0.83l-1.95 1.39zm19.25-0.28-6.98-5.58v-3.35l13.12-8.93v-0.28l-6.7-10.04-14.51 7.81v18.98l9.77 6.97 12.56-10.04-0.28-0.84-6.98 5.3zm-6.98-23.72 0.56-0.28 6.14 9.77-6.7 4.19v-13.68zm34.05 6.98c3.63-3.07 5.02-7.26 5.02-10.05v-1.67h-0.56c-0.55 1.39-1.67 2.79-3.9 2.79-2.24 0-3.63-1.12-5.03-2.79-0.83 0.46-5.02 2.79-12.55 6.98v10.04c2.84 2.18 4.42 3.39 4.74 3.63-4.74 4.19-5.58 6.98-5.58 9.21 0 2.79 1.39 4.74 3.63 5.58 0.02-0.06 0.25-0.5 0.28-0.56-0.56-0.56-1.12-0.84-1.12-2.23 0-0.84 1.12-2.23 3.35-2.23 2.79 0 4.46 1.95 5.3 2.79 0.8-0.49 4.8-2.9 12-7.26v-10.04h-0.28c-3.18-2.52-4.95-3.91-5.3-4.19zm-6.42 4.19c-0.2-0.17-1.23-1.01-3.07-2.52v-9.76c1.12 2.79 4.19 5.02 7.26 5.02 1.95 0 3.07-0.28 4.46-1.12-1.95 3.35-6.14 6.7-8.65 8.38zm-4.19 8.65c-0.83 0-3.06 0-5.3 1.39 1.4-2.23 5.03-6.14 9.77-8.93 0.22 0.19 1.34 1.12 3.35 2.79l0.28 10.05c-3.17-3.54-5.86-5.3-8.1-5.3z'
          id='newYorkTimes'
        />
        <path
          d='m1446.3 226.25v-70h74.28v70h-74.28zm-171.32 0v-70h74.28v70h-74.28zm85.66 0v-70h74.28v70h-74.28zm125.1-60.76-0.56 0.02-0.54 0.02-0.53 0.03-0.51 0.03-0.49 0.04-0.47 0.05-0.46 0.04-0.44 0.05-0.42 0.06-0.4 0.05-0.39 0.06-0.37 0.06-0.35 0.06-0.33 0.06-0.31 0.07-0.3 0.06-0.28 0.06-0.5 0.12-0.22 0.05-0.2 0.06-0.18 0.05-0.17 0.05-0.15 0.04-0.12 0.04-0.11 0.04-0.09 0.03-0.07 0.02-0.05 0.02-0.03 0.01h-0.01l-1.45 0.48-1.37 0.52-1.3 0.56-1.23 0.6-1.17 0.64-1.09 0.66-1.03 0.7-0.97 0.72-0.91 0.74-0.84 0.76-0.79 0.78-0.74 0.8-0.68 0.8-0.64 0.82-0.58 0.82-0.54 0.82-0.49 0.83-0.44 0.82-0.41 0.81-0.37 0.81-0.33 0.79-0.29 0.78-0.27 0.77-0.23 0.74-0.2 0.72-0.17 0.7-0.15 0.66-0.13 0.64-0.1 0.6-0.08 0.56-0.07 0.53-0.05 0.48-0.04 0.43-0.03 0.39-0.01 0.33-0.01 0.28-0.01 0.22v0.17 0.1 0.03l0.07 1.31 0.12 1.27 0.17 1.22 0.21 1.18 0.26 1.13 0.29 1.1 0.34 1.04 0.36 1.01 0.4 0.97 0.43 0.92 0.46 0.88 0.48 0.85 0.5 0.81 0.51 0.77 0.53 0.73 0.55 0.69 0.56 0.66 0.56 0.62 0.56 0.59 0.57 0.56 0.57 0.52 0.56 0.49 0.56 0.45 0.55 0.43 0.53 0.39 0.52 0.37 0.51 0.33 0.48 0.31 0.46 0.27 0.44 0.25 0.4 0.23 0.38 0.19 0.34 0.18 0.3 0.14 0.27 0.12 0.22 0.1 0.18 0.08 0.13 0.05 0.08 0.03 0.03 0.01 1.32 0.5 1.31 0.43 1.3 0.38 1.29 0.33 1.27 0.28 1.26 0.23 1.25 0.18 1.22 0.14 1.21 0.1 1.18 0.05 1.17 0.03 1.14-0.02 1.12-0.04 1.09-0.08 1.07-0.1 1.04-0.12 1.02-0.15 0.98-0.17 0.95-0.19 0.92-0.2 0.89-0.22 0.85-0.22 0.82-0.24 0.78-0.24 0.74-0.24 0.71-0.25 0.66-0.24 0.62-0.24 0.58-0.24 0.53-0.22 0.49-0.22 0.45-0.2 0.39-0.19 0.35-0.17 0.3-0.16 0.24-0.12 0.19-0.11 0.14-0.08 0.09-0.05 0.03-0.01v-9.64l-0.85 0.53-0.84 0.5-0.82 0.47-0.81 0.45-0.8 0.41-0.78 0.39-0.77 0.36-0.76 0.34-0.74 0.31-0.72 0.29-0.71 0.26-0.69 0.25-0.68 0.23-0.65 0.2-0.64 0.19-0.62 0.17-0.6 0.15-0.58 0.13-0.56 0.12-0.54 0.11-0.52 0.09-0.49 0.08-0.47 0.06-0.45 0.06-0.43 0.05-0.4 0.03-0.38 0.03-0.36 0.02-0.33 0.01-0.3 0.01-0.27 0.01h-0.25l-0.23-0.01h-0.19l-0.16-0.01-0.14-0.01-0.11-0.01-0.08-0.01h-0.04-0.02l-1.46-0.1-1.39-0.16-1.31-0.21-1.24-0.26-1.17-0.31-1.1-0.35-1.04-0.4-0.98-0.43-0.91-0.47-0.85-0.5-0.8-0.52-0.74-0.56-0.69-0.57-0.63-0.6-0.59-0.61-0.54-0.63-0.49-0.63-0.45-0.65-0.41-0.65-0.37-0.65-0.33-0.64-0.3-0.65-0.26-0.63-0.23-0.62-0.2-0.61-0.17-0.6-0.15-0.57-0.13-0.55-0.1-0.52-0.08-0.5-0.07-0.46-0.05-0.42-0.04-0.39-0.02-0.34-0.02-0.3-0.01-0.26v-0.2-0.15-0.09-0.03l0.1-1.34 0.16-1.27 0.22-1.2 0.27-1.14 0.33-1.07 0.38-1.02 0.43-0.95 0.47-0.9 0.51-0.84 0.54-0.79 0.58-0.74 0.6-0.68 0.64-0.64 0.65-0.59 0.68-0.54 0.69-0.5 0.7-0.47 0.71-0.42 0.71-0.38 0.72-0.35 0.72-0.31 0.71-0.28 0.7-0.25 0.69-0.22 0.67-0.19 0.66-0.17 0.64-0.14 0.6-0.12 0.58-0.11 0.55-0.08 0.51-0.07 0.48-0.05 0.42-0.04 0.39-0.03 0.33-0.02 0.28-0.01 0.23-0.01h0.16 0.1 0.04l0.75 0.02 0.74 0.04 0.74 0.05 0.74 0.08 0.73 0.09 0.72 0.1 0.71 0.12 1.4 0.28 0.68 0.16 0.67 0.16 0.66 0.18 0.65 0.18 0.64 0.19 0.62 0.2 0.6 0.2 0.59 0.21 0.57 0.21 0.56 0.21 0.54 0.21 0.52 0.21 0.49 0.21 0.48 0.21 0.46 0.2 0.44 0.2 0.41 0.19 0.39 0.19 0.37 0.18 0.34 0.17 0.31 0.17 0.29 0.15 0.26 0.14 0.24 0.13 0.2 0.11 0.18 0.1 0.14 0.08 0.12 0.07 0.08 0.05 0.05 0.03 0.02 0.01v-9.3l-0.62-0.25-0.6-0.24-0.59-0.23-0.58-0.22-0.57-0.21-0.56-0.21-0.55-0.19-0.54-0.18-0.53-0.17-0.51-0.17-0.5-0.16-0.49-0.14-0.47-0.14-0.46-0.14-0.45-0.12-0.44-0.12-0.42-0.11-0.4-0.1-0.39-0.1-0.38-0.08-0.36-0.09-0.34-0.07-0.33-0.07-0.31-0.07-0.3-0.06-0.27-0.05-0.26-0.05-0.25-0.04-0.22-0.04-0.21-0.03-0.19-0.03-0.17-0.03-0.15-0.02-0.14-0.02-0.11-0.01-0.09-0.02h-0.07l-0.06-0.01h-0.03l-0.01-0.01-0.71-0.06-0.69-0.05-0.67-0.04-0.66-0.03-0.64-0.03-0.62-0.01-0.61-0.01-0.6 0.01h-0.57zm-191.24 50.93h20.23 0.04l0.14-0.01h0.21l0.29-0.02 0.36-0.02 0.43-0.03 0.49-0.05 0.54-0.07 0.58-0.08 0.63-0.11 0.67-0.13 0.7-0.15 0.72-0.19 0.74-0.21 0.76-0.25 0.76-0.28 0.77-0.32 0.77-0.36 0.75-0.41 0.75-0.45 0.72-0.5 0.7-0.54 0.66-0.6 0.63-0.66 0.59-0.71 0.54-0.77 0.49-0.84 0.42-0.9 0.36-0.96 0.29-1.04 0.22-1.1 0.13-1.18 0.05-1.26v-0.03-0.07-0.13l-0.01-0.17-0.01-0.21-0.02-0.25-0.02-0.29-0.05-0.32-0.05-0.36-0.07-0.38-0.09-0.41-0.11-0.43-0.13-0.45-0.16-0.47-0.18-0.49-0.21-0.49-0.24-0.51-0.27-0.51-0.31-0.52-0.35-0.51-0.38-0.52-0.42-0.51-0.47-0.5-0.51-0.5-0.55-0.48-0.61-0.46-0.65-0.45-0.71-0.42-0.77-0.41-0.82-0.37-0.88-0.35-0.93-0.31-1.01-0.28 0.02-0.01 0.05-0.02 0.2-0.1 0.13-0.07 0.17-0.09 0.18-0.1 0.21-0.13 0.22-0.14 0.25-0.15 0.25-0.18 0.27-0.19 0.27-0.22 0.29-0.23 0.29-0.25 0.29-0.28 0.29-0.29 0.29-0.31 0.29-0.33 0.28-0.36 0.28-0.37 0.26-0.4 0.26-0.42 0.24-0.44 0.22-0.46 0.2-0.49 0.19-0.5 0.16-0.54 0.13-0.55 0.11-0.58 0.08-0.61 0.04-0.62 0.02-0.66v-0.03-0.09l0.01-0.16v-0.21l-0.01-0.26-0.01-0.3-0.03-0.35-0.05-0.39-0.06-0.43-0.08-0.46-0.11-0.48-0.13-0.51-0.17-0.54-0.2-0.55-0.23-0.56-0.28-0.57-0.31-0.58-0.37-0.58-0.41-0.58-0.46-0.57-0.51-0.57-0.58-0.55-0.63-0.53-0.7-0.52-0.76-0.49-0.83-0.46-0.9-0.43-0.98-0.4-1.06-0.35-1.14-0.32-1.22-0.26-1.31-0.22-1.4-0.16h-17.65v50.31zm85.66 0h20.23 0.04l0.14-0.01h0.21l0.29-0.02 0.36-0.02 0.43-0.03 0.49-0.05 0.54-0.07 0.58-0.08 0.63-0.11 0.67-0.13 0.7-0.15 0.72-0.19 0.74-0.21 0.76-0.25 0.76-0.28 0.77-0.32 0.77-0.36 0.75-0.41 0.75-0.45 0.72-0.5 0.7-0.54 0.66-0.6 0.63-0.66 0.59-0.71 0.54-0.77 0.48-0.84 0.43-0.9 0.36-0.96 0.29-1.04 0.22-1.1 0.13-1.18 0.05-1.26v-0.03-0.07-0.13l-0.01-0.17-0.01-0.21-0.02-0.25-0.03-0.29-0.04-0.32-0.05-0.36-0.07-0.38-0.09-0.41-0.11-0.43-0.13-0.45-0.16-0.47-0.18-0.49-0.21-0.49-0.24-0.51-0.28-0.51-0.3-0.52-0.35-0.51-0.38-0.52-0.42-0.51-0.47-0.5-0.51-0.5-0.55-0.48-0.61-0.46-0.66-0.45-0.7-0.42-0.77-0.41-0.82-0.37-0.88-0.35-0.94-0.31-1-0.28 0.02-0.01 0.05-0.02 0.08-0.04 0.11-0.06 0.14-0.07 0.17-0.09 0.18-0.1 0.21-0.13 0.22-0.14 0.24-0.15 0.26-0.18 0.27-0.19 0.27-0.22 0.29-0.23 0.29-0.25 0.29-0.28 0.29-0.29 0.29-0.31 0.29-0.33 0.28-0.36 0.28-0.37 0.26-0.4 0.26-0.42 0.24-0.44 0.22-0.46 0.2-0.49 0.19-0.5 0.16-0.54 0.13-0.55 0.11-0.58 0.08-0.61 0.04-0.62 0.01-0.66 0.01-0.03v-0.09l0.01-0.16v-0.21l-0.01-0.26-0.02-0.3-0.02-0.35-0.05-0.39-0.06-0.43-0.08-0.46-0.11-0.48-0.13-0.51-0.17-0.54-0.2-0.55-0.23-0.56-0.28-0.57-0.31-0.58-0.37-0.58-0.41-0.58-0.46-0.57-0.51-0.57-0.58-0.55-0.63-0.53-0.7-0.52-0.76-0.49-0.83-0.46-0.91-0.43-0.97-0.4-1.06-0.35-1.14-0.32-1.22-0.26-1.31-0.22-1.4-0.16h-17.65v50.31zm-62.85-20.97 1.56 0.63 1.2 0.77 0.9 0.87 0.63 0.9 0.41 0.87 0.23 0.79 0.11 0.63 0.04 0.42v0.16l-0.22 1.88-0.61 1.52-0.9 1.2-1.12 0.91-1.24 0.66-1.29 0.46-1.24 0.29-1.12 0.16-0.9 0.07-0.61 0.01-0.22-0.01h-9.46v-13.74h9.46l2.42 0.14 1.97 0.41zm85.66 0 1.56 0.63 1.2 0.77 0.9 0.87 0.62 0.9 0.41 0.87 0.24 0.79 0.11 0.63 0.04 0.42v0.16l-0.22 1.88-0.61 1.52-0.9 1.2-1.12 0.91-1.24 0.66-1.29 0.46-1.24 0.29-1.12 0.16-0.9 0.07-0.61 0.01-0.22-0.01h-9.46v-13.74h9.46l2.42 0.14 1.97 0.41zm-88.37-20.6 1.27 0.81 0.89 0.93 0.58 0.96 0.34 0.9 0.16 0.75 0.04 0.52v0.19l-0.28 2.07-0.76 1.61-1.11 1.23-1.3 0.88-1.38 0.6-1.3 0.37-1.1 0.19-0.77 0.08-0.28 0.01h-6.14v-13.01h7.21l2.22 0.31 1.71 0.6zm85.66 0 1.27 0.81 0.89 0.93 0.58 0.96 0.34 0.9 0.15 0.75 0.05 0.52v0.19l-0.28 2.07-0.76 1.61-1.11 1.23-1.3 0.88-1.38 0.6-1.3 0.37-1.11 0.19-0.76 0.08-0.28 0.01h-6.14v-13.01h7.21l2.22 0.31 1.71 0.6z'
          id='bbc'
        />
        <path
          d='m1466.8 79.39c0-10.69-8.7-19.39-19.38-19.39-10.7 0-19.39 8.7-19.39 19.39s8.69 19.38 19.39 19.38c4.05 0.01 7.99-1.26 11.28-3.63 0.32 0.33 1.94 1.94 4.85 4.86l4.32-4.31-4.83-4.84c2.51-4.89 3.77-8.71 3.76-11.46zm-15.31-0.08-4.31 4.31c4.27 4.28 6.65 6.65 7.12 7.13-2.07 1.26-4.46 1.92-6.88 1.92-7.33 0-13.29-5.96-13.29-13.28 0-7.33 5.96-13.29 13.29-13.29 7.32 0 13.28 5.96 13.28 13.29 0 2.5-0.71 4.96-2.05 7.08l-7.16-7.16zm190.27-18.35v6.16h-11.52v30.82h-6.25v-30.82h-11.52v-6.16h29.29zm-103.87 0-14.25 36.98h6.54l2.67-7.2h17.58l2.67 7.2h6.54l-14.25-36.98h-7.5zm3.75 7.32 6.41 16.7h-12.82l6.41-16.7zm142.39-1.16-20.67 24.58h20.67v6.24h-28.82v-6.57l20.75-24.25h-19.31v-6.1h27.38v6.1zm-172.48 17.24c0 7.93-6.44 14.38-14.37 14.38-7.94 0-14.39-6.45-14.39-14.38v-23.4h6.24v23.4c-0.14 4.57 3.58 8.28 8.15 8.28 4.56 0 8.27-3.71 8.18-8.28v-23.4h6.19v23.4zm87.78-10.43c0-6.78-5.59-12.83-12.55-12.97h-13.7v36.98h6.25v-11.13h5.65l12.88 13.04 4.33-4.29-10.01-10.14c4.76-4.31 7.15-8.14 7.15-11.49zm-20 6.77v-13.54h6.99c3.81 0 6.91 3.04 6.91 6.77 0 3.74-3.1 6.77-6.91 6.77h-6.99z'
          id='quartz'
        />
        <path
          d='m1280.7 53.2c-0.05 0.49-0.6 4.84-1.08 8.35-0.54 3.24-4.87 27.31-6.34 34.51-0.39 2.18-1.58 8.32-1.69 8.94-1.38 0.16-3.01 0.31-4.07 0.35-0.14 0.01-0.38 0.06-0.49 0.06v1.24c0.13 0 0.82 0.05 1.3 0.03 1.17-0.04 4.49-0.2 5.12-0.2 2.39 0 3.98 0.16 6.19 0.21 0.03 0 0.64-0.01 0.9-0.04v-1.26c-0.18 0-0.42-0.01-0.57-0.01-0.62 0.02-2.92-0.15-4.08-0.31 0.13-0.83 2.16-13.29 3.14-18.27 1.85-9.23 3.13-15.77 3.13-15.77 0.03 0.06 0.14 0.33 0.35 0.82l14.64 34.88c1.6 0.01 2.49 0.02 2.67 0.02 0 0 1.52-3.78 3.34-8.02 0.04-0.1 0.17-0.4 0.36-0.84 1.9-4.4 11.32-26.73 11.32-26.73s0.09 0.4 0.23 1.12c0.9 4.38 3.94 20.16 4.58 23.96 0.31 1.96 0.59 3.94 0.76 5.11 0.24 1.65 0.4 3.26 0.4 3.72-0.3 0.01-3.28 0.28-4.41 0.33-0.16 0-0.46 0.01-0.48 0.02v1.26c0.41 0 0.8 0.02 1.19 0.01 2.3-0.04 4.52-0.22 6.82-0.22 2.59 0 6.79 0.23 9.48 0.25 0.3 0 0.84-0.03 0.84-0.03v-1.28c-0.15 0-0.83-0.04-1.08-0.06-1.2-0.09-3.23-0.28-3.75-0.31 0 0-0.33-1.85-0.77-3.98-1.76-8.51-6.76-34.39-7.53-40.75-0.26-2.19-1-7.11-1-7.11h-3.02s-1.53 4.41-2.93 8.44c-0.96 2.75-2.26 6.14-3.25 8.74-4.9 12.86-10.38 24.85-10.38 24.85s-11.67-27.83-12.28-29.44c-0.63-1.61-4.44-12.61-4.44-12.61s-1.98 0.04-3.12 0.02zm-80.69 2.94-0.05 7.16 0.78-0.02c0.04-3.83 0.07-5.95 0.08-6.37 0 0 4.25-0.04 4.8-0.04h7.94l5.12 0.03 0.01 44.3v3.83c-0.07 0.01-0.1 0.01-0.11 0.01-0.68 0.06-3.31 0.22-4.37 0.26-0.24 0-0.39 0.01-0.42 0.01 0 0.13 0.01 1.16 0.01 1.29 0.19 0.01 0.71 0.02 0.77 0.02 2.53-0.03 5.94-0.25 8.35-0.25 2.46 0 5.92 0.24 8.06 0.27 0.21 0 0.46-0.02 0.66-0.02v-1.22h-0.26c-0.68 0-4.45-0.24-4.84-0.29-0.02-0.6-0.09-3.47-0.09-3.53 0-2.98 0.01-17.87 0.02-44.69l3.9-0.01 10.17 0.01c2.04 0.03 3.17 0.04 3.39 0.05 0.03 0.24 0.2 3.47 0.19 3.55 0 0.24 0.13 2.64 0.13 3.23 0.05 0 0.32 0.01 0.8 0.01l-0.06-7.24c0.03-1.96 0.04-3.04 0.04-3.26-2.99 0.08-10.61 0.18-22.43 0.18-10.14-0.01-19.91-0.09-22.62-0.22 0 0 0.01 0.98 0.03 2.95zm47.34-1.67c0.4 0.03 2.76 0.24 3.34 0.26 0.45 0.06 1.09 0.12 1.55 0.16 0 0.41 0.01 3.21 0.01 4.32 0.08 10.48 0.02 33.66-0.01 41.86-0.01 2.37-0.02 3.9-0.02 3.9-0.29 0.09-0.94 0.12-1.64 0.17-0.61 0.04-2.76 0.22-3.24 0.23v1.27c0.2 0 0.56 0.04 0.77 0.04 2.44 0 5.83-0.31 8.33-0.3 2.53 0 5.9 0.31 7.89 0.31 0.17 0 0.58-0.05 0.75-0.04v-1.27h-0.17c-0.08-0.02-2.65-0.13-3.27-0.19-0.33-0.02-1.74-0.15-1.76-0.19 0-0.03-0.01-0.41-0.01-1.04 0.01-0.6 0.01-1.6 0.01-2.68 0-8.27 0.03-32.84 0.03-42.23 0-1.81 0.01-3.29 0.01-4.08 0.55-0.03 2.81-0.27 3.62-0.34 0.03 0 1.1-0.06 1.54-0.09v-1.32c-2.76 0-6.42 0.21-9.11 0.21-2.82 0-6.29-0.22-8.63-0.22 0 0 0.01 1.14 0.01 1.26zm126.95-1.23c-1.85 0.01-6.57 0.05-12.1 0.08-3.4 0.02-6.05 0.04-9.55 0.04-2.45 0.03-5.89 0.13-8.01 0.12-3.38 0-6.14-0.21-7.64-0.22-0.72 0-1.11 0.03-1.31 0.01 0.01 0.02 0.01 1.26 0.01 1.26 0.13 0.02 0.39 0.05 0.64 0.04 0.85 0.06 2.44 0.19 3.24 0.29 0.17 0.03 0.44 0.08 1.2 0.16-0.01 0.28 0.03 3.46 0.03 5.37 0 1.77-0.02 41.26-0.02 41.26 0 0.06-0.09 3.17-0.09 3.42-1.34 0.23-3.92 0.37-4.8 0.38h-0.26v1.25c0.13 0 0.7 0.03 1.03 0.03 1.42-0.01 5.08-0.23 8.81-0.23 2.62-0.01 5.5 0.09 8.42 0.13 3.59 0.05 7.22 0.06 10.49 0.1 5.38 0.08 9.75 0.09 11.17 0.09 0 0 0.17-9.99 0.17-10.8-0.08 0-0.7 0.01-0.78 0.01 0 0.85-0.31 4.02-0.32 4.15-0.1 1.19-0.21 2.44-0.29 3.06 0 0-0.38 0.03-0.57 0.02-0.88-0.01-3.71 0.09-3.77 0.09-0.84 0-5.04 0-12.61 0.01l-8.85-0.15-0.06-2.46c0-11.44-0.01-17.8-0.01-19.07 1.58-0.05 3.99-0.13 5.46-0.13 1.25 0 4.19-0.07 5.83-0.07 4 0.01 7.55 0.04 7.84 0.05 0.65 0.01 1.88 0.05 2.34 0.08 0.02 0.17 0.07 0.43 0.08 0.51 0.24 1.46 0.37 2.47 0.53 3.9 0.02 0.13 0.03 0.26 0.05 0.37h0.91s0.02-0.51 0.01-0.83c-0.02-1.12-0.09-3.36-0.09-5.85 0-1.72 0.1-4.36 0.11-5.62 0-0.34-0.04-0.59-0.04-0.69-0.08 0.01-0.75 0.02-0.83 0.02 0 0.27-0.07 0.68-0.07 0.68-0.07 0.94-0.34 2.15-0.55 3.42-0.06 0.16-0.1 0.38-0.1 0.38-0.1 0.03-2.7 0.17-2.94 0.17-0.09 0-3.88 0.11-3.95 0.11-0.97-0.01-5.83-0.03-14.58-0.06 0.01-12.61 0.02-19.62 0.02-21.03 0 0 1.86-0.06 2.37-0.06 2.11 0 5.53-0.02 9.01-0.01 5.1 0 10.06 0.04 10.07 0.04 0.03 0.02 1.54 0.04 1.56 0.06 0.04 0.03 1.93 0.09 2.39 0.1 0 0 0.04 0.16 0.06 0.36 0.21 2.22 0.38 4.85 0.46 5.78v0.37h0.78c0-1.36-0.07-5.54-0.08-8.2-0.01-0.86 0.01-1.55 0.01-1.95v-0.34h-0.83z'
          id='time'
        />
        <path
          d='m275.98 58.39v43.37h21.37c5.97 0 9.42-0.94 11.94-3.14 3.14-2.83 4.71-7.86 4.71-18.54 0-10.69-1.57-15.71-4.71-18.54-2.52-2.2-5.97-3.15-11.94-3.15h-21.37zm26.71 34.57c-1.26 0.94-2.83 1.26-5.97 1.26h-11.94v-28.6h11.94c3.14 0 4.71 0 5.97 1.26 1.88 1.57 2.51 3.77 2.51 13.2s-0.63 11.63-2.51 12.88zm22.31 18.39h-62.69v-62.7h62.69v62.7zm-113.91-45.73v-7.23h37.08v13.83h-7.86v-6.6h-15.09v10.37h11.95v6.92h-11.95v11.62h15.41v-7.54h7.85v14.77h-37.39v-7.23h5.97v-28.91h-5.97zm-32.69 35.83h8.49c-0.32-2.2-0.63-6.29-0.63-11.63-0.32-6.29-2.2-7.23-6.6-8.17 5.03-0.94 7.23-3.14 7.23-11 0-6.28-0.95-8.8-2.83-10.37-1.26-1.26-3.46-1.89-6.92-1.89h-26.39v43.37h8.8v-16.97h12.25c2.52 0 3.46 0.32 4.4 0.94 0.95 0.63 1.26 1.58 1.26 4.72 0 4.71 0.31 8.17 0.94 11zm-18.85-23.57v-11.94h14.14c1.89 0 2.51 0.31 2.83 0.63 0.62 0.62 1.25 1.57 1.25 5.34s-0.63 5.03-1.25 5.65c-0.32 0.32-0.94 0.63-2.83 0.63-1.89-0.04-6.6-0.14-14.14-0.31zm-22.94 33.47v-62.7h62.69v62.7h-62.69zm-16.34-16.82v7.23h-29.86v-7.23h10.69v-28.91h-10.69v-7.23h29.85v7.23h-10.68v28.91h10.69zm-50.44-36.14h-8.17l-5.97 34.26c-4.15-19.05-6.45-29.63-6.92-31.74-0.31-2.2-1.25-2.52-3.14-2.52h-4.4c-1.88 0-2.83 0.63-3.14 2.52-0.46 2.11-2.77 12.69-6.91 31.74l-5.97-34.26h-8.8c5.09 24.7 7.92 38.43 8.48 41.17 0.32 1.89 0.94 2.2 3.14 2.2h5.97c1.89 0 2.52-0.31 3.15-2.2l6.6-29.85 6.6 29.85c0.31 1.89 0.94 2.2 3.14 2.2h5.65c1.89 0 2.83-0.31 3.15-2.2 1-5.49 3.52-19.21 7.54-41.17zm-58.45 52.96v-62.7h62.69v62.7h-62.69z'
          id='wired'
        />
        <path
          d='m779.89 96.15-0.09-0.2-0.1-0.21-0.18-0.42-0.08-0.21-0.09-0.21-0.16-0.44-0.07-0.21-0.08-0.22-0.07-0.22-0.07-0.23-0.06-0.22-0.07-0.23-0.06-0.22-0.12-0.46-0.05-0.23-0.05-0.24-0.05-0.23-0.05-0.24-0.16-0.96-0.03-0.24-0.06-0.5-0.02-0.24-0.03-0.25-0.02-0.26-0.01-0.25-0.02-0.25-0.03-0.78v-0.26-0.26l0.03-1.22 0.09-1.18 0.14-1.15 0.21-1.12 0.25-1.08 0.31-1.05 0.37-1.01 0.41-0.99 0.46-0.95 0.51-0.91 0.55-0.88 0.6-0.85 0.64-0.82 0.68-0.79 0.72-0.75 0.76-0.72 0.79-0.7 0.83-0.65 0.87-0.63 0.9-0.6 0.92-0.56 0.96-0.54 0.99-0.5 1.01-0.48 1.03-0.44 1.06-0.42 1.08-0.38 1.11-0.36 1.12-0.32 1.13-0.3 1.16-0.26 1.16-0.24 1.19-0.21 1.19-0.18 1.2-0.15 1.21-0.13 1.22-0.1 1.22-0.06 1.23-0.05 1.23-0.01h1.09 0.4l0.45 0.01 0.51 0.02 0.55 0.02 0.59 0.04 0.64 0.04 0.67 0.06 0.71 0.08 0.74 0.09 0.77 0.1 0.79 0.13 0.82 0.15 0.83 0.17 0.85 0.19 0.87 0.22 0.87 0.25 0.88 0.27 0.88 0.3 0.89 0.34 0.88 0.37 0.88 0.4 0.87 0.43 0.85 0.48 0.85 0.51 0.82 0.55 0.8 0.6 0.78 0.63 0.76 0.69 0.72 0.72 0.69 0.78 0.65 0.82 0.62 0.88 0.57 0.93 0.53 0.98 0.47 1.03 0.43 1.09 0.37 1.15 0.32 1.21 0.25 1.27 0.19 1.34-19.85 1.95-0.04-0.74-0.02-0.38-0.03-0.37-0.12-1.11-0.06-0.37-0.06-0.36-0.07-0.36-0.07-0.35-0.18-0.7-0.1-0.34-0.24-0.66-0.13-0.31-0.15-0.32-0.15-0.3-0.17-0.29-0.18-0.29-0.19-0.27-0.42-0.52-0.24-0.24-0.24-0.23-0.27-0.22-0.27-0.2-0.3-0.19-0.3-0.18-0.33-0.16-0.34-0.15-0.36-0.13-0.38-0.12-0.39-0.1-0.42-0.08-0.43-0.07-0.45-0.05-0.48-0.02-0.49-0.01-0.63 0.01-0.6 0.03-0.58 0.06-0.54 0.08-0.52 0.1-0.49 0.13-0.47 0.14-0.44 0.16-0.41 0.19-0.4 0.2-0.37 0.22-0.34 0.23-0.33 0.26-0.3 0.26-0.29 0.29-0.26 0.3-0.25 0.31-0.23 0.32-0.21 0.34-0.19 0.35-0.18 0.36-0.16 0.38-0.15 0.38-0.13 0.39-0.12 0.41-0.11 0.4-0.09 0.42-0.09 0.43-0.07 0.43-0.06 0.43-0.06 0.45-0.04 0.44-0.04 0.45-0.03 0.46-0.02 0.45-0.02 0.46-0.02 0.92v0.46l-0.01 0.46v0.16l0.01 0.46v0.46l0.02 0.92 0.02 0.46 0.03 0.45 0.03 0.46 0.04 0.45 0.05 0.44 0.05 0.45 0.14 0.86 0.09 0.43 0.09 0.42 0.11 0.41 0.13 0.4 0.13 0.39 0.15 0.38 0.16 0.38 0.18 0.36 0.2 0.35 0.21 0.34 0.23 0.32 0.25 0.32 0.26 0.29 0.29 0.29 0.3 0.27 0.33 0.25 0.34 0.23 0.37 0.22 0.39 0.2 0.42 0.19 0.44 0.16 0.46 0.14 0.49 0.13 0.51 0.1 0.54 0.08 0.57 0.06 0.6 0.03 0.62 0.02 0.66-0.02 0.33-0.02 0.33-0.03 0.32-0.04 0.32-0.05 0.62-0.12 0.31-0.08 0.3-0.08 0.3-0.09 0.29-0.1 0.29-0.11 0.28-0.12 0.54-0.26 0.26-0.15 0.25-0.15 0.48-0.34 0.23-0.18 0.22-0.19 0.21-0.2 0.2-0.21 0.19-0.22 0.19-0.23 0.17-0.24 0.16-0.24 0.15-0.26 0.14-0.27 0.13-0.27 0.11-0.29 0.1-0.29 0.09-0.31 0.08-0.31 0.06-0.32 0.06-0.34 0.03-0.34 0.02-0.35 0.01-0.36h19.76l-0.09 1.55-0.26 1.06-0.31 1.01-0.35 0.97-0.38 0.93-0.42 0.89-0.46 0.85-0.49 0.8-0.52 0.77-0.56 0.73-0.58 0.69-0.61 0.66-0.64 0.62-0.66 0.58-0.68 0.55-0.71 0.52-0.73 0.49-0.75 0.46-0.77 0.42-0.78 0.4-0.79 0.37-0.81 0.35-0.83 0.31-0.83 0.29-0.84 0.27-0.85 0.25-0.86 0.22-0.86 0.2-0.86 0.18-0.87 0.16-0.86 0.14-0.87 0.12-0.86 0.11-0.86 0.09-0.85 0.07-0.85 0.06-0.83 0.05-0.83 0.04-0.82 0.02-0.8 0.02h-0.79l-0.96-0.01-0.96-0.02-0.95-0.04-0.95-0.06-0.95-0.08-0.95-0.09-0.94-0.11-0.94-0.13-0.93-0.14-0.92-0.16-0.91-0.18-0.91-0.2-0.9-0.21-0.89-0.23-0.87-0.25-0.87-0.27-0.86-0.28-0.84-0.31-0.83-0.32-0.81-0.34-0.8-0.35-0.79-0.38-0.76-0.4-0.75-0.41-0.74-0.43-0.71-0.45-0.7-0.47-0.67-0.49-0.66-0.51-0.63-0.53-0.62-0.54-0.59-0.57-0.56-0.58-0.54-0.61-0.52-0.62-0.49-0.65-0.47-0.66-0.44-0.69-0.41-0.7-0.2-0.38v12.71h-35.98v-13.3h6.8v-13.87l-0.01-0.31-0.02-0.29-0.03-0.3-0.04-0.28-0.12-0.54-0.08-0.25-0.09-0.25-0.09-0.24-0.11-0.24-0.12-0.22-0.13-0.22-0.14-0.2-0.15-0.2-0.16-0.2-0.34-0.36-0.38-0.32-0.2-0.16-0.21-0.14-0.22-0.14-0.22-0.13-0.24-0.12-0.48-0.22-0.26-0.1-0.25-0.09-0.54-0.16-0.28-0.07-0.28-0.06-0.58-0.1-0.3-0.04-0.3-0.03-0.62-0.04-0.31-0.01h-0.32-0.4l-0.4 0.02-0.4 0.03-0.39 0.05-0.38 0.06-0.37 0.07-0.37 0.08-0.37 0.1-0.35 0.1-0.35 0.12-0.34 0.13-0.33 0.14-0.33 0.15-0.62 0.34-0.3 0.18-0.29 0.19-0.28 0.21-0.27 0.21-0.26 0.22-0.25 0.23-0.24 0.24-0.22 0.25-0.22 0.26-0.21 0.26-0.38 0.56-0.17 0.29-0.16 0.29-0.28 0.62-0.12 0.32-0.11 0.32-0.09 0.33-0.08 0.34-0.07 0.34-0.05 0.35-0.04 0.36-0.02 0.35-0.01 0.37v11.5h6.98v13.3h-36.8v-13.3h6.62v-19.98h-6.62v-13.3h29.01v9.22l0.04-0.03 0.04-0.04 0.2-0.15 0.03-0.04 0.08-0.06 0.07-0.07 0.08-0.06 0.03-0.04 0.04-0.03 0.03-0.04 0.04-0.03 0.23-0.23 0.03-0.04 0.04-0.03 0.03-0.03 0.03-0.04 0.06-0.06 0.03-0.04 0.12-0.12 0.03-0.04 0.02-0.03 0.06-0.06 0.39-0.4 0.4-0.39 0.41-0.38 0.4-0.36 0.41-0.36 0.41-0.34 0.84-0.64 0.42-0.3 0.43-0.29 0.43-0.28 0.44-0.27 0.44-0.26 0.45-0.25 0.44-0.23 0.92-0.44 0.46-0.2 0.47-0.19 0.47-0.18 0.48-0.17 0.48-0.16 0.49-0.15 0.5-0.14 1-0.26 0.51-0.11 1.04-0.2 0.53-0.08 0.54-0.08 0.54-0.07 0.55-0.05 0.55-0.06 0.56-0.04 1.14-0.06 0.58-0.02 0.59-0.01h0.6l0.83 0.01 0.83 0.02 0.83 0.04 0.81 0.05 0.8 0.07 0.78 0.09 0.78 0.11 0.76 0.12 0.75 0.14 0.74 0.16 0.72 0.18 0.71 0.19 0.69 0.21 0.67 0.24 0.66 0.25 0.64 0.27 0.62 0.29 0.6 0.31 0.58 0.33 0.56 0.35 0.54 0.38 0.52 0.39 0.5 0.42 0.47 0.43 0.45 0.46 0.42 0.49 0.4 0.5 0.38 0.53 0.35 0.55 0.32 0.57 0.29 0.6 0.27 0.62 0.23 0.65 0.21 0.67 0.18 0.7 0.15 0.72 0.11 0.75 0.08 0.77 0.05 0.8 0.02 0.82v17.46h5.89l-0.1-0.2-0.1-0.21zm68.74-0.59 1.3 0.56 1.16 0.74 1.01 0.9 0.82 1.05 0.62 1.17 0.39 1.27 0.13 1.35-0.13 1.35-0.39 1.27-0.62 1.17-0.82 1.04-1.01 0.91-1.16 0.74-1.3 0.55-1.41 0.35-1.5 0.12-1.5-0.12-1.41-0.35-1.3-0.55-1.16-0.74-1.01-0.91-0.82-1.04-0.62-1.17-0.38-1.27-0.14-1.35 0.14-1.35 0.38-1.27 0.62-1.17 0.82-1.05 1.01-0.9 1.16-0.74 1.3-0.56 1.41-0.35 1.5-0.12 1.5 0.12 1.41 0.35zm-155.74-32.28v33.36h8.88v13.22h-47.04v-13.22h8.79v-33.36h-8.79v-14.28h47.04v14.28h-8.88z'
          id='inc'
        />
        <path
          d='m392.17 114.4h5.15v-27.52h-5.15v27.52zm18.88-0.41h4.61v-17.37l19.43 17.78v-27.11h-4.6v17.07l-19.44-17.48v27.11zm43.33-3.58c3.14 0 5.35-1.08 5.35-3.48 0-2.08-1.41-2.9-3.87-3.81-0.4-0.14-3.59-1.25-3.99-1.39-3.69-1.31-6.48-3.22-6.48-7.6 0-4.7 4.23-7.25 9.3-7.25 3.11 0 5.94 0.78 8.15 2.16v4.66c-2.3-1.7-4.82-2.87-8.05-2.87-2.78 0-4.86 1.04-4.86 3.2 0 1.96 1.3 2.74 3.6 3.53 0.45 0.16 4.01 1.4 4.45 1.56 4.31 1.52 6.29 3.87 6.29 7.73 0 4.87-4.28 7.55-9.89 7.55-3.69 0-6.83-1.03-8.76-2.33v-4.75c3.68 2.06 6.6 3.09 8.76 3.09zm21.91 3.99h5.15v-27.52h-5.15v27.52zm38.21-13.77c0-5.92-3.1-9.63-8.9-9.63h-5.74v19.24h5.74c5.94-2.49 8.9-5.69 8.9-9.61zm-8.73-13.75c8.16 0 13.43 5.38 13.43 13.75 0 8.39-5.27 13.77-13.43 13.77h-10.6v-27.52h10.6zm39.19 0v4.12h-12.47v6.62h11.18v4.08h-11.18v8.54h12.47v4.16h-17.17v-27.52h17.17zm23.39 12.46c3.02 0 4.73-1.66 4.73-4.21s-1.71-4.21-4.73-4.21h-5.11v8.42h5.11zm-5.11 15.06h-4.55v-27.52h9.75c5.55 0 9.15 2.86 9.15 8.25 0 4.61-2 7.25-6.25 7.93 0.64 0.76 3.87 4.54 9.67 11.34h-5.17l-9.37-11.16h-3.23v11.16zm-169.29-60.62c0-5.07-3.58-7.7-9.32-7.7h-9.63v28.3h10.53c5.73 0 9.32-2.81 9.32-8.11 0-3-1.89-5.63-4.48-6.5 2.01-0.74 3.58-2.95 3.58-5.99zm-14.43-3.55h5.07c3.18 0 4.88 1.15 4.88 3.82 0 2.68-1.7 3.92-4.88 3.92h-5.07v-7.74zm5.92 11.7c3.14 0 4.84 1.57 4.84 4.15 0 2.54-1.71 4.15-4.84 4.15h-5.91v-8.3h5.91zm41.44 1.2v-17.05h-4.66v16.5c0 5.44-2.24 7.97-6.36 7.97s-6.36-2.53-6.36-7.97v-16.5h-4.66v17.01c0 7.79 4.48 11.75 11.02 11.75 6.59 0 11.02-3.96 11.02-11.71zm19.71 11.71c5.6 0 9.86-2.86 9.86-8.02 0-4.1-1.97-6.59-6.28-8.2-0.44-0.17-3.99-1.5-4.43-1.66-2.29-0.83-3.58-1.66-3.58-3.74 0-2.3 2.06-3.41 4.83-3.41 3.23 0 5.74 1.25 8.02 3.05v-4.94c-2.19-1.47-5.01-2.3-8.11-2.3-5.06 0-9.27 2.72-9.27 7.7 0 4.65 2.78 6.68 6.45 8.06 0.4 0.15 3.59 1.33 3.99 1.48 2.46 0.96 3.85 1.84 3.85 4.05 0 2.54-2.19 3.69-5.33 3.69-3.23 0-6.23-1.2-8.74-3.27v5.02c3.38 1.66 6.29 2.49 8.74 2.49zm21.85-28.76v28.3h4.65v-28.3h-4.65zm22.43 28.26v-18.41l18.9 18.85v-28.75h-4.48v18.1l-18.9-18.53v28.74h4.48zm48.01-24.02h-12.09v6.81h10.85v4.19h-10.85v8.78h12.09v4.29h-16.66v-28.31h16.66v4.24zm19.59 24.5c5.6 0 9.85-2.86 9.85-8.02 0-4.1-1.97-6.59-6.27-8.2-0.44-0.17-3.99-1.5-4.43-1.66-2.29-0.83-3.59-1.66-3.59-3.74 0-2.3 2.06-3.41 4.84-3.41 3.22 0 5.73 1.25 8.02 3.05v-4.94c-2.2-1.47-5.02-2.3-8.11-2.3-5.06 0-9.27 2.72-9.27 7.7 0 4.65 2.77 6.68 6.45 8.06 0.4 0.15 3.59 1.33 3.98 1.48 2.47 0.96 3.86 1.84 3.86 4.05 0 2.54-2.2 3.69-5.33 3.69-3.23 0-6.23-1.2-8.74-3.27v5.02c3.38 1.66 6.29 2.49 8.74 2.49zm28.13 0c5.6 0 9.86-2.86 9.86-8.02 0-4.1-1.97-6.59-6.27-8.2-0.45-0.17-3.99-1.5-4.44-1.66-2.28-0.83-3.58-1.66-3.58-3.74 0-2.3 2.06-3.41 4.84-3.41 3.22 0 5.73 1.25 8.02 3.05v-4.94c-2.2-1.47-5.02-2.3-8.11-2.3-5.07 0-9.28 2.72-9.28 7.7 0 4.65 2.78 6.68 6.45 8.06 0.4 0.15 3.59 1.33 3.99 1.48 2.47 0.96 3.86 1.84 3.86 4.05 0 2.54-2.2 3.69-5.34 3.69-3.22 0-6.22-1.2-8.73-3.27v5.02c3.37 1.66 6.29 2.49 8.73 2.49z'
          id='businessInsider'
        />
        <path
          d='m1061.5 67.62 0.6 0.08 0.6 0.11 0.58 0.13 0.57 0.16 0.56 0.19 0.55 0.22 0.53 0.24 0.53 0.27 0.5 0.29 0.49 0.31 0.48 0.34 0.45 0.36 0.44 0.37 0.43 0.4 0.4 0.42 0.38 0.44 0.36 0.46 0.34 0.47 0.31 0.49 0.3 0.51 0.27 0.52 0.24 0.54 0.22 0.55 0.19 0.56 0.16 0.57 0.14 0.59 0.11 0.6 0.07 0.6 0.05 0.62 0.02 0.62v0.77l-0.44 0.02h-0.22l-0.22 0.01h-0.21l-0.21 0.01h-0.21l-0.2 0.01h-0.2l-0.2 0.01h-0.2l-0.2 0.01h-0.19-0.2l-0.19 0.01h-0.19-0.18l-0.19 0.01h-0.18l-0.18 0.01h-0.18-0.18l-0.18 0.01h-0.17l-0.18 0.01h-0.17l-0.17 0.01h-0.17l-0.17 0.01h-0.17l-0.34 0.02v-0.93-0.3l-0.03-0.3-0.04-0.29-0.05-0.29-0.07-0.29-0.08-0.28-0.09-0.27-0.11-0.27-0.12-0.26-0.13-0.26-0.3-0.48-0.17-0.24-0.18-0.22-0.19-0.22-0.2-0.2-0.21-0.2-0.22-0.19-0.22-0.18-0.48-0.32-0.25-0.14-0.26-0.14-0.27-0.12-0.27-0.1-0.28-0.1-0.29-0.08-0.58-0.12-0.3-0.04-0.31-0.02-0.3-0.01-0.31 0.01-0.29 0.02-0.3 0.04-0.28 0.06-0.29 0.06-0.28 0.08-0.27 0.1-0.26 0.1-0.26 0.12-0.26 0.14-0.24 0.14-0.24 0.16-0.23 0.16-0.22 0.18-0.21 0.19-0.4 0.4-0.36 0.44-0.16 0.24-0.15 0.24-0.14 0.24-0.13 0.26-0.12 0.26-0.2 0.54-0.07 0.28-0.07 0.29-0.05 0.29-0.04 0.29-0.02 0.3-0.01 0.3v19.26l0.01 0.31 0.02 0.31 0.04 0.31 0.05 0.3 0.07 0.29 0.07 0.28 0.1 0.28 0.1 0.27 0.12 0.27 0.13 0.26 0.14 0.24 0.15 0.24 0.16 0.24 0.18 0.22 0.18 0.21 0.4 0.4 0.21 0.18 0.22 0.17 0.23 0.17 0.24 0.15 0.24 0.14 0.52 0.24 0.26 0.1 0.27 0.09 0.28 0.08 0.29 0.06 0.28 0.05 0.3 0.04 0.29 0.02 0.31 0.01 0.3-0.01 0.3-0.02 0.58-0.08 0.56-0.14 0.28-0.09 0.27-0.1 0.26-0.11 0.26-0.12 0.25-0.14 0.24-0.14 0.46-0.32 0.22-0.18 0.4-0.38 0.19-0.21 0.18-0.21 0.17-0.23 0.16-0.23 0.15-0.24 0.13-0.24 0.13-0.26 0.11-0.26 0.1-0.26 0.16-0.56 0.05-0.28 0.05-0.29 0.03-0.3 0.01-0.3 1.12 0.08 0.81 0.06 0.26 0.02 0.26 0.01 0.5 0.04 0.24 0.01 0.23 0.02 0.23 0.01 0.22 0.02 0.22 0.01 0.4 0.02 0.36 0.02 0.17 0.01 0.16 0.01 0.15 0.01 0.13 0.01h0.13l0.11 0.01h0.1l0.08 0.01h0.08 0.05 0.05 0.03l-0.05 0.6-0.07 0.59-0.1 0.57-0.13 0.57-0.15 0.56-0.18 0.55-0.21 0.53-0.23 0.52-0.26 0.51-0.28 0.5-0.3 0.48-0.32 0.46-0.34 0.45-0.36 0.44-0.39 0.41-0.4 0.4-0.42 0.38-0.43 0.36-0.45 0.34-0.47 0.31-0.48 0.3-0.5 0.28-0.51 0.25-0.52 0.23-0.54 0.2-0.54 0.18-0.56 0.15-0.56 0.13-0.58 0.1-0.58 0.07-0.59 0.05-0.59 0.01-0.62-0.02-0.61-0.04-0.6-0.08-0.59-0.1-0.58-0.14-0.57-0.16-0.56-0.19-0.55-0.22-0.53-0.24-0.52-0.26-0.5-0.3-0.49-0.31-0.47-0.34-0.45-0.35-0.44-0.38-0.42-0.4-0.39-0.42-0.38-0.44-0.36-0.46-0.33-0.47-0.32-0.49-0.29-0.51-0.26-0.52-0.24-0.54-0.22-0.55-0.19-0.56-0.16-0.57-0.14-0.59-0.1-0.6-0.08-0.6-0.04-0.62-0.02-0.62v-19.26l0.02-0.62 0.04-0.62 0.08-0.6 0.1-0.6 0.14-0.59 0.16-0.57 0.19-0.56 0.22-0.55 0.24-0.54 0.26-0.52 0.29-0.51 0.32-0.49 0.33-0.47 0.36-0.46 0.38-0.44 0.39-0.42 0.42-0.4 0.44-0.37 0.45-0.36 0.47-0.34 0.49-0.31 0.5-0.29 0.52-0.27 0.53-0.24 0.55-0.22 0.56-0.19 0.57-0.16 0.58-0.13 0.59-0.11 0.6-0.08 0.61-0.04 0.62-0.02 0.61 0.02 0.61 0.04zm-90.85-1.13 0.73 0.1 0.7 0.14 0.7 0.18 0.67 0.22 0.67 0.25 0.64 0.28 0.62 0.32 0.61 0.35 0.58 0.38 0.57 0.42 0.54 0.44 0.51 0.46 0.49 0.5 0.46 0.52 0.44 0.54 0.41 0.57 0.38 0.58 0.34 0.61 0.32 0.63 0.28 0.65 0.25 0.66 0.21 0.68 0.18 0.7 0.14 0.71 0.1 0.72 0.06 0.73 0.02 0.75v9.24l-0.01 0.28-0.02 0.27-0.04 0.26-0.05 0.27-0.06 0.25-0.08 0.25-0.09 0.24-0.11 0.24-0.11 0.23-0.13 0.22-0.14 0.21-0.15 0.2-0.16 0.2-0.17 0.19-0.17 0.17-0.19 0.17-0.2 0.16-0.21 0.15-0.21 0.13-0.22 0.13-0.23 0.11-0.23 0.1-0.24 0.09-0.25 0.08-0.25 0.06-0.26 0.05-0.52 0.06h-0.27-11.94v4.16 0.21l0.02 0.2 0.03 0.2 0.04 0.2 0.1 0.38 0.07 0.18 0.08 0.18 0.18 0.34 0.11 0.16 0.11 0.15 0.12 0.15 0.13 0.14 0.14 0.14 0.14 0.13 0.15 0.12 0.15 0.11 0.16 0.11 0.34 0.18 0.18 0.08 0.19 0.07 0.18 0.05 0.19 0.05 0.2 0.04 0.2 0.03 0.2 0.02h0.21 9.16l0.31 8.09-8.62 1.31-0.86 0.11-0.83 0.06-0.81-0.01-0.79-0.05-0.77-0.11-0.74-0.16-0.73-0.21-0.7-0.26-0.67-0.3-0.65-0.34-0.62-0.38-0.6-0.42-0.57-0.46-0.53-0.49-0.51-0.52-0.48-0.55-0.45-0.58-0.42-0.6-0.39-0.63-0.35-0.65-0.32-0.67-0.28-0.69-0.25-0.7-0.21-0.71-0.18-0.73-0.13-0.73-0.1-0.74-0.06-0.75-0.02-0.75v-18.17l0.02-0.75 0.06-0.73 0.1-0.72 0.14-0.71 0.18-0.7 0.21-0.68 0.25-0.66 0.28-0.65 0.32-0.63 0.35-0.61 0.37-0.58 0.41-0.57 0.44-0.54 0.47-0.52 0.49-0.5 0.52-0.46 0.54-0.44 0.56-0.42 0.59-0.38 0.61-0.35 0.63-0.32 0.65-0.28 0.66-0.25 0.69-0.22 0.69-0.18 0.72-0.14 0.73-0.1 0.74-0.06 0.75-0.02 0.74 0.02 0.73 0.06zm147.56 1.15 0.68 0.1 0.67 0.14 0.66 0.18 0.64 0.21 0.62 0.25 0.61 0.28 0.59 0.32 0.57 0.34 0.55 0.38 0.52 0.4 0.51 0.43 0.47 0.46 0.46 0.49 0.42 0.51 0.4 0.53 0.37 0.56 0.35 0.57 0.3 0.6 0.28 0.61 0.25 0.63 0.21 0.65 0.17 0.67 0.14 0.67 0.1 0.69 0.06 0.71 0.02 0.71v9.47l-0.02 0.38-0.03 0.18-0.03 0.17-0.1 0.34-0.06 0.16-0.08 0.16-0.16 0.3-0.1 0.14-0.1 0.13-0.11 0.13-0.12 0.12-0.12 0.11-0.13 0.11-0.13 0.1-0.14 0.09-0.15 0.09-0.15 0.07-0.16 0.07-0.16 0.06-0.16 0.05-0.17 0.05-0.17 0.03-0.17 0.02-0.18 0.02h-0.18-14.87v6.55l0.01 0.35 0.03 0.35 0.05 0.34 0.07 0.34 0.08 0.32 0.1 0.32 0.12 0.32 0.14 0.3 0.15 0.29 0.17 0.29 0.18 0.27 0.19 0.27 0.21 0.25 0.23 0.24 0.23 0.22 0.25 0.22 0.26 0.2 0.27 0.18 0.28 0.17 0.29 0.16 0.3 0.14 0.31 0.12 0.32 0.1 0.32 0.09 0.33 0.07 0.34 0.05 0.35 0.03 0.35 0.01h7.78l0.02 0.42 0.01 0.2v0.2l0.01 0.2 0.01 0.19 0.01 0.18 0.01 0.19 0.02 0.36 0.04 0.68 0.05 0.8 0.01 0.15 0.02 0.15 0.01 0.16 0.01 0.15 0.02 0.15 0.01 0.15 0.02 0.15 0.01 0.14 0.02 0.15-7.39 1.16-0.8 0.11-0.79 0.05h-0.76l-0.74-0.06-0.72-0.11-0.7-0.16-0.68-0.2-0.65-0.25-0.63-0.3-0.6-0.33-0.58-0.38-0.56-0.41-0.52-0.45-0.5-0.48-0.47-0.51-0.43-0.54-0.41-0.56-0.38-0.59-0.34-0.61-0.32-0.63-0.27-0.65-0.25-0.67-0.21-0.68-0.17-0.69-0.13-0.7-0.1-0.71-0.06-0.71-0.02-0.72v-19.1l0.02-0.71 0.06-0.71 0.1-0.69 0.14-0.67 0.17-0.67 0.21-0.65 0.25-0.63 0.28-0.61 0.31-0.6 0.34-0.57 0.37-0.56 0.4-0.53 0.43-0.51 0.45-0.49 0.48-0.46 0.51-0.43 0.53-0.4 0.55-0.38 0.57-0.34 0.59-0.32 0.62-0.28 0.63-0.25 0.64-0.21 0.66-0.18 0.68-0.14 0.69-0.1 0.7-0.06 0.71-0.02 0.71 0.02 0.69 0.06zm-86.37-0.02 0.78 0.1 0.75 0.15 0.73 0.19 0.7 0.22 0.68 0.27 0.66 0.31 0.63 0.34 0.6 0.37 0.58 0.41 0.55 0.44 0.52 0.47 0.5 0.49 0.46 0.53 0.43 0.54 0.41 0.57 0.37 0.59 0.34 0.62 0.3 0.62 0.28 0.65 0.23 0.66 0.21 0.67 0.17 0.69 0.13 0.7 0.09 0.7 0.06 0.71 0.02 0.72v18.33l-0.02 0.7-0.06 0.7-0.1 0.68-0.13 0.67-0.18 0.66-0.2 0.64-0.24 0.63-0.28 0.61-0.3 0.59-0.34 0.58-0.37 0.55-0.39 0.53-0.43 0.5-0.45 0.49-0.47 0.45-0.5 0.44-0.52 0.4-0.55 0.37-0.56 0.35-0.59 0.31-0.6 0.28-0.62 0.25-0.64 0.21-0.65 0.18-0.67 0.14-0.68 0.1-0.69 0.06-0.71 0.02-0.7-0.02-0.7-0.06-0.68-0.1-0.67-0.14-0.66-0.18-0.65-0.21-0.62-0.25-0.61-0.28-0.59-0.31-0.58-0.35-0.55-0.37-0.53-0.4-0.51-0.44-0.48-0.45-0.46-0.49-0.43-0.5-0.4-0.53-0.37-0.55-0.35-0.58-0.31-0.59-0.28-0.61-0.25-0.63-0.21-0.64-0.18-0.66-0.14-0.67-0.1-0.68-0.06-0.7-0.02-0.7v-3.78l0.02-0.7 0.05-0.69 0.08-0.68 0.12-0.66 0.15-0.64 0.19-0.63 0.22-0.61 0.25-0.59 0.28-0.57 0.31-0.55 0.34-0.53 0.37-0.5 0.4-0.49 0.43-0.46 0.46-0.43 0.49-0.4 0.52-0.38 0.54-0.36 0.57-0.32 0.6-0.29 0.63-0.26 0.65-0.23 0.67-0.2 0.7-0.16 0.73-0.13 0.75-0.09 0.77-0.06 0.8-0.02h0.3l0.29 0.01h0.28l0.27 0.01 0.52 0.02 0.48 0.04 0.23 0.01 0.22 0.02 0.22 0.03 0.21 0.02 0.21 0.03 0.2 0.03 0.19 0.02 0.2 0.04 0.18 0.03 0.19 0.03 0.36 0.08 0.17 0.04 0.18 0.04 0.17 0.04 0.17 0.05 0.18 0.04 0.17 0.05 0.17 0.04 0.17 0.05v-4.85-0.37l-0.02-0.36-0.04-0.36-0.04-0.34-0.06-0.34-0.07-0.34-0.09-0.32-0.1-0.31-0.12-0.3-0.13-0.29-0.15-0.28-0.16-0.26-0.18-0.25-0.2-0.24-0.21-0.22-0.23-0.21-0.25-0.19-0.26-0.17-0.28-0.15-0.3-0.14-0.33-0.11-0.33-0.1-0.36-0.08-0.38-0.05-0.4-0.04-0.42-0.01-0.44 0.02-0.46 0.04h0.08-0.27l-0.27 0.01-0.27 0.02-0.28 0.01-0.29 0.02-0.29 0.01-0.58 0.04-1.2 0.08-0.31 0.02-0.3 0.03-0.31 0.02-0.3 0.02-0.31 0.02-0.3 0.03-0.31 0.02-0.3 0.02-0.3 0.03-0.9 0.06-0.87 0.06-0.28 0.01-0.01-0.23-0.01-0.22v-0.22l-0.02-0.4-0.02-0.38-0.01-0.17v-0.17l-0.01-0.17-0.02-0.32-0.01-0.15-0.01-0.16v-0.15l-0.01-0.14-0.03-0.45v-0.14l-0.01-0.15-0.01-0.16-0.01-0.15-0.02-0.32v-0.17l-0.01-0.17-0.01-0.18 0.23-0.08 0.23-0.09 0.48-0.16 0.25-0.08 0.52-0.16 0.27-0.08 0.26-0.07 0.28-0.07 0.27-0.08 0.28-0.07 0.28-0.06 0.29-0.07 0.28-0.06 0.58-0.12 0.58-0.1 0.28-0.05 0.58-0.08 0.29-0.03 0.28-0.04 0.84-0.06 0.27-0.01 0.82 0.01 0.79 0.05zm116.02-0.1 0.33 0.03 0.32 0.03 0.31 0.04 0.29 0.04 0.3 0.05 0.28 0.06 0.54 0.12 0.26 0.08 0.26 0.07 0.25 0.08 0.5 0.18 0.24 0.09 0.72 0.3 0.72 0.33-0.01 0.26-0.04 0.96-0.03 0.69-0.02 0.44-0.02 0.22-0.03 0.63-0.01 0.2-0.01 0.21-0.02 0.4-0.01 0.19-0.01 0.2-0.02 0.38-6.7-0.15-0.44 0.02-0.43 0.06-0.42 0.1-0.4 0.14-0.4 0.17-0.38 0.2-0.37 0.24-0.35 0.26-0.34 0.29-0.31 0.31-0.3 0.33-0.28 0.36-0.26 0.37-0.23 0.38-0.21 0.4-0.19 0.41-0.16 0.42-0.14 0.43-0.1 0.43-0.08 0.43-0.05 0.44-0.02 0.43v30.04h-6.16v-30.04l0.03-0.91 0.1-0.9 0.16-0.89 0.22-0.87 0.27-0.86 0.33-0.83 0.39-0.81 0.45-0.77 0.49-0.75 0.55-0.7 0.59-0.67 0.65-0.63 0.69-0.58 0.73-0.53 0.78-0.48 0.82-0.43 0.86-0.36 0.89-0.3 0.94-0.24 0.96-0.16 1.01-0.1 1.03-0.02 0.35 0.02 0.34 0.02zm-70.63 42.79v-60.15h6.17v60.15h-6.17zm26.19 0h-6.78l-11.7-20.41-0.15-0.27-0.14-0.24-0.12-0.22-0.11-0.21-0.09-0.2-0.08-0.19-0.06-0.17-0.08-0.34-0.01-0.16v-0.17l0.01-0.17 0.04-0.17 0.04-0.18 0.07-0.18 0.08-0.2 0.09-0.21 0.12-0.23 0.13-0.25 0.14-0.26 0.17-0.29 0.18-0.31 10.32-17.1h7.01l-11.63 19.71 12.55 22.42zm-174.07 0h-9.55v-43.29l9.55 0.54v42.75zm-15.64 0h-9.55v-60.69l9.55 0.61v60.08zm83.02-42.02 0.13-0.04 0.14-0.03 0.28-0.08 0.14-0.03 0.15-0.03 0.15-0.04 0.16-0.03 0.15-0.03 0.16-0.02 0.32-0.06 0.16-0.02 0.16-0.03 0.17-0.02 0.16-0.02 0.17-0.03 0.16-0.02 0.17-0.02 0.17-0.01 0.34-0.04 0.16-0.01 0.17-0.02 0.17-0.01 0.16-0.01 0.17-0.01 0.8-0.05h0.16l0.15-0.01h0.15 0.15l0.15-0.01h0.14 0.14l0.49 0.01 0.48 0.04 0.48 0.05 0.47 0.07 0.46 0.1 0.45 0.11 0.45 0.14 0.44 0.15 0.43 0.17 0.43 0.19 0.41 0.21 0.41 0.22 0.39 0.24 0.39 0.26 0.38 0.27 0.36 0.29 0.36 0.3 0.34 0.31 0.33 0.33 0.32 0.34 0.31 0.36 0.29 0.36 0.28 0.38 0.27 0.39 0.26 0.4 0.24 0.41 0.22 0.42 0.21 0.43 0.2 0.44 0.18 0.44 0.17 0.46 0.15 0.46 0.13 0.46 0.12 0.48 0.1 0.48 0.08 0.48 0.07 0.49 0.04 0.49 0.03 0.5 0.01 0.5v30.12h-6.01v-30.12-0.24l-0.02-0.25-0.02-0.24-0.04-0.24-0.04-0.23-0.05-0.23-0.06-0.23-0.07-0.23-0.08-0.22-0.09-0.21-0.2-0.42-0.11-0.2-0.12-0.2-0.26-0.38-0.14-0.18-0.3-0.34-0.16-0.16-0.17-0.16-0.17-0.15-0.18-0.15-0.18-0.13-0.38-0.26-0.2-0.11-0.21-0.11-0.42-0.2-0.44-0.16-0.22-0.07-0.23-0.06-0.24-0.05-0.23-0.04-0.48-0.06-0.5-0.02h-5.85v36.05h-6.16v-60.31h6.16v18.33l0.13-0.04zm-47.76-19.28 0.21 0.01 0.22 0.01 0.21 0.02 0.6 0.06 0.2 0.03 0.19 0.03 0.18 0.03 0.18 0.04 0.18 0.03 0.17 0.04 0.48 0.12 0.15 0.04 0.14 0.04 0.39 0.12 0.22 0.08 0.11 0.05 0.09 0.03 0.09 0.04 0.08 0.04 0.07 0.04 0.07 0.03 0.1 0.06-0.39 9.17h-4.39-0.18l-0.17 0.01-0.18 0.03-0.17 0.03-0.17 0.04-0.17 0.05-0.32 0.12-0.16 0.07-0.15 0.08-0.15 0.09-0.14 0.09-0.14 0.1-0.14 0.11-0.13 0.12-0.24 0.24-0.11 0.13-0.11 0.14-0.1 0.14-0.18 0.3-0.07 0.16-0.08 0.16-0.06 0.16-0.06 0.17-0.05 0.17-0.04 0.18-0.03 0.17-0.02 0.19-0.01 0.18-0.01 0.19v12.94h7.16v9.55h-7.16v24.99h-9.55v-47.48l0.02-0.68 0.05-0.67 0.08-0.67 0.12-0.65 0.15-0.65 0.18-0.64 0.21-0.63 0.24-0.62 0.27-0.61 0.29-0.59 0.32-0.58 0.34-0.56 0.37-0.54 0.4-0.53 0.41-0.5 0.44-0.49 0.46-0.47 0.48-0.44 0.49-0.42 0.52-0.4 0.53-0.37 0.55-0.34 0.56-0.32 0.58-0.28 0.59-0.26 0.6-0.23 0.62-0.19 0.63-0.16 0.63-0.13 0.65-0.09 0.65-0.06 0.66-0.02h0.23l0.22 0.01zm81.04 39.36-1.01 0.28-0.93 0.43-0.82 0.58-0.72 0.71-0.58 0.83-0.43 0.93-0.27 1-0.1 1.08v4.47l0.1 1.08 0.27 1.01 0.43 0.94 0.58 0.83 0.72 0.73 0.82 0.59 0.93 0.45 1.01 0.28 1.07 0.09 1.08-0.09 1.01-0.28 0.92-0.45 0.83-0.59 0.71-0.73 0.58-0.83 0.44-0.94 0.27-1.01 0.09-1.08v-10.4h-5.93l-1.07 0.09zm84.48-14.17-1.01 0.55-0.87 0.73-0.73 0.89-0.54 1.02-0.34 1.13-0.12 1.21v6.47h11.86v-6.47l-0.12-1.21-0.35-1.13-0.55-1.02-0.73-0.89-0.88-0.73-1.01-0.55-1.1-0.35-1.19-0.13-1.2 0.13-1.12 0.35zm-147.45 2.45-0.78 0.79-0.52 0.99-0.18 1.15v4.46h7.16v-4.46l-0.18-1.15-0.51-0.99-0.77-0.79-0.97-0.51-1.11-0.18-1.15 0.18-0.99 0.51zm-39.72-22.05 1.11 0.86 0.86 1.11 0.55 1.3 0.2 1.45-0.2 1.45-0.55 1.3-0.86 1.11-1.11 0.86-1.3 0.55-1.45 0.2-1.45-0.2-1.3-0.55-1.11-0.86-0.86-1.11-0.55-1.3-0.2-1.45 0.2-1.45 0.55-1.3 0.86-1.11 1.11-0.86 1.3-0.55 1.45-0.2 1.45 0.2 1.3 0.55z'
          id='lifehacker'
        />
        <path
          d='m218.37 170.11 1.3 0.13 1.28 0.19 1.27 0.24 1.25 0.29 1.23 0.34 1.2 0.38 1.19 0.44 1.16 0.47 1.14 0.53 1.12 0.56 1.09 0.61 1.06 0.65 1.03 0.69 1 0.73 0.98 0.77 0.94 0.81 0.91 0.84 0.87 0.87 0.84 0.91 0.81 0.94 0.77 0.98 0.72 1 0.7 1.03 0.65 1.06 0.6 1.09 0.57 1.12 0.52 1.14 0.48 1.16 0.43 1.18 0.39 1.21 0.34 1.23 0.29 1.25 0.24 1.27 0.18 1.28 0.14 1.3 0.08 1.31 0.03 1.33-0.03 1.33-0.08 1.32-0.14 1.3-0.18 1.28-0.24 1.27-0.29 1.24-0.34 1.23-0.39 1.21-0.43 1.19-0.48 1.16-0.52 1.14-0.57 1.11-0.6 1.09-0.65 1.06-0.7 1.04-0.72 1-0.77 0.97-0.81 0.95-0.84 0.9-0.87 0.88-0.91 0.84-0.94 0.8-0.98 0.77-1 0.73-1.03 0.69-1.06 0.65-1.09 0.61-1.12 0.57-1.14 0.52-1.16 0.48-1.19 0.43-1.2 0.39-1.23 0.34-1.25 0.28-1.27 0.24-1.28 0.19-1.3 0.14-1.32 0.08-1.32 0.03-1.33-0.03-1.32-0.08-1.3-0.14-1.28-0.19-1.27-0.24-1.25-0.28-1.22-0.34-1.21-0.39-1.19-0.43-1.16-0.48-1.14-0.52-1.12-0.57-1.08-0.61-1.07-0.65-1.03-0.69-1-0.73-0.98-0.77-0.94-0.8-0.91-0.84-0.87-0.88-0.84-0.9-0.81-0.95-0.76-0.97-0.73-1-0.69-1.04-0.65-1.06-0.61-1.09-0.57-1.11-0.52-1.14-0.48-1.16-0.43-1.19-0.39-1.21-0.34-1.23-0.29-1.24-0.23-1.27-0.19-1.28-0.14-1.3-0.08-1.32-0.03-1.33 0.03-1.33 0.08-1.31 0.14-1.3 0.19-1.28 0.23-1.27 0.29-1.25 0.34-1.23 0.39-1.21 0.43-1.18 0.48-1.16 0.52-1.14 0.57-1.12 0.61-1.09 0.65-1.06 0.69-1.03 0.73-1 0.76-0.98 0.81-0.94 0.84-0.91 0.87-0.87 0.91-0.84 0.94-0.81 0.98-0.77 1-0.73 1.03-0.69 1.07-0.65 1.08-0.61 1.12-0.56 1.14-0.53 1.16-0.47 1.19-0.44 1.21-0.38 1.22-0.34 1.25-0.29 1.27-0.24 1.28-0.19 1.3-0.13 1.32-0.08 1.33-0.03 1.32 0.03 1.32 0.08zm92.05 13.06 0.5 0.02 0.96 0.08 0.94 0.12 0.45 0.07 0.45 0.08 0.43 0.09 0.43 0.1 0.42 0.1 0.41 0.12 0.4 0.12 0.39 0.13 0.39 0.14 0.37 0.14 0.37 0.16 0.36 0.16 0.35 0.16 0.34 0.18 0.66 0.36 0.32 0.2 0.3 0.19 0.3 0.21 0.58 0.42 0.27 0.22 0.27 0.23 0.26 0.23-4.49 6.68-0.14-0.15-0.3-0.32-0.16-0.15-0.34-0.3-0.54-0.42-0.2-0.14-0.4-0.26-0.21-0.12-0.22-0.12-0.44-0.22-0.23-0.1-0.24-0.1-0.48-0.18-0.25-0.08-0.52-0.14-0.26-0.06-0.54-0.1-0.28-0.04-0.28-0.03-0.29-0.02-0.29-0.01h-0.3-0.25l-0.24 0.01-0.23 0.02-0.22 0.02-0.21 0.03-0.2 0.03-0.2 0.04-0.36 0.1-0.17 0.06-0.15 0.06-0.3 0.14-0.13 0.08-0.24 0.16-0.11 0.09-0.1 0.09-0.18 0.2-0.07 0.1-0.07 0.11-0.12 0.22-0.04 0.11-0.04 0.12-0.06 0.24-0.02 0.12-0.01 0.13v0.13l0.01 0.2 0.02 0.2 0.04 0.19 0.06 0.18 0.06 0.17 0.09 0.16 0.09 0.15 0.11 0.15 0.13 0.14 0.13 0.13 0.15 0.13 0.15 0.12 0.17 0.12 0.36 0.22 0.4 0.2 0.22 0.1 0.22 0.09 0.46 0.18 0.24 0.09 0.5 0.18 0.26 0.08 0.52 0.18 0.81 0.27 0.28 0.09 0.54 0.17 0.54 0.18 0.53 0.19 0.52 0.19 0.51 0.2 0.5 0.21 0.48 0.22 0.47 0.22 0.46 0.24 0.45 0.25 0.43 0.26 0.41 0.27 0.4 0.29 0.39 0.29 0.37 0.32 0.35 0.32 0.33 0.34 0.31 0.36 0.29 0.37 0.28 0.39 0.25 0.41 0.23 0.42 0.21 0.45 0.19 0.46 0.17 0.48 0.14 0.51 0.11 0.52 0.1 0.55 0.06 0.56 0.04 0.59 0.02 0.62-0.02 0.64-0.04 0.63-0.08 0.62-0.1 0.6-0.14 0.6-0.16 0.58-0.19 0.56-0.22 0.55-0.25 0.54-0.28 0.52-0.3 0.5-0.34 0.48-0.36 0.47-0.39 0.44-0.42 0.43-0.45 0.4-0.47 0.39-0.5 0.36-0.52 0.34-0.56 0.32-0.58 0.29-0.6 0.27-0.64 0.24-0.65 0.22-0.69 0.19-0.71 0.16-0.73 0.14-0.77 0.1-0.78 0.08-0.81 0.04-0.84 0.02h-0.62l-0.61-0.01-0.6-0.04-0.59-0.04-0.58-0.07-0.57-0.07-0.56-0.1-0.55-0.1-0.53-0.12-0.52-0.13-0.52-0.14-0.5-0.15-0.48-0.16-0.48-0.17-0.46-0.18-0.45-0.19-0.43-0.2-0.42-0.2-0.41-0.21-0.39-0.21-0.38-0.22-0.36-0.23-0.35-0.22-0.33-0.23-0.32-0.24-0.3-0.23-0.29-0.24-0.27-0.23-0.26-0.24-0.23-0.24-0.22-0.23 4.82-6.68 0.17 0.21 0.18 0.21 0.19 0.2 0.2 0.21 0.2 0.2 0.22 0.19 0.21 0.19 0.23 0.19 0.23 0.18 0.24 0.18 0.25 0.18 0.25 0.17 0.25 0.16 0.27 0.15 0.26 0.15 0.28 0.15 0.27 0.13 0.29 0.13 0.28 0.12 0.3 0.12 0.29 0.1 0.3 0.1 0.31 0.09 0.3 0.07 0.32 0.07 0.31 0.06 0.32 0.05 0.32 0.04 0.32 0.03 0.33 0.02h0.32 0.25l0.25-0.01 0.24-0.02 0.23-0.02 0.22-0.03 0.21-0.04 0.21-0.05 0.4-0.1 0.36-0.14 0.17-0.08 0.16-0.08 0.16-0.09 0.28-0.2 0.13-0.11 0.12-0.12 0.11-0.12 0.11-0.13 0.09-0.13 0.09-0.15 0.08-0.14 0.07-0.16 0.06-0.16 0.05-0.17 0.04-0.17 0.03-0.18 0.03-0.19 0.01-0.19 0.01-0.2-0.01-0.22-0.02-0.22-0.03-0.21-0.05-0.2-0.06-0.19-0.08-0.19-0.08-0.17-0.1-0.17-0.11-0.16-0.13-0.15-0.14-0.15-0.15-0.14-0.16-0.14-0.17-0.13-0.19-0.12-0.2-0.13-0.21-0.11-0.22-0.12-0.48-0.22-0.26-0.11-0.27-0.1-0.28-0.1-0.29-0.1-0.3-0.11-0.31-0.1-0.66-0.2-0.7-0.2-0.37-0.11-0.48-0.15-0.49-0.16-0.94-0.34-0.47-0.19-0.45-0.19-0.45-0.2-0.44-0.21-0.43-0.23-0.42-0.23-0.41-0.25-0.4-0.26-0.38-0.27-0.37-0.28-0.35-0.3-0.34-0.31-0.32-0.32-0.31-0.34-0.29-0.35-0.27-0.37-0.25-0.39-0.23-0.4-0.21-0.42-0.19-0.44-0.16-0.45-0.15-0.48-0.11-0.49-0.1-0.51-0.06-0.53-0.05-0.56-0.01-0.57 0.02-0.63 0.05-0.61 0.08-0.61 0.12-0.58 0.14-0.58 0.18-0.55 0.21-0.54 0.24-0.53 0.26-0.51 0.3-0.49 0.32-0.47 0.35-0.46 0.38-0.43 0.4-0.42 0.43-0.39 0.45-0.38 0.47-0.36 0.5-0.33 0.52-0.31 0.54-0.29 0.56-0.27 0.58-0.25 0.6-0.22 0.62-0.19 0.64-0.18 0.66-0.14 0.67-0.12 0.69-0.1 0.71-0.07 0.72-0.04 0.74-0.01h0.51l0.51 0.02zm-39.37 20.47 0.01 0.34v0.34l0.02 0.33 0.01 0.33 0.03 0.33 0.02 0.32 0.04 0.32 0.04 0.31 0.05 0.31 0.06 0.3 0.07 0.3 0.08 0.28 0.09 0.28 0.1 0.28 0.11 0.26 0.12 0.25 0.14 0.25 0.15 0.23 0.16 0.22 0.18 0.21 0.2 0.2 0.21 0.19 0.23 0.17 0.25 0.16 0.26 0.14 0.29 0.13 0.3 0.12 0.32 0.09 0.35 0.09 0.36 0.06 0.39 0.05 0.41 0.03h0.43 0.43l0.41-0.03 0.39-0.05 0.36-0.06 0.35-0.09 0.32-0.09 0.3-0.12 0.29-0.13 0.26-0.14 0.25-0.16 0.23-0.17 0.21-0.19 0.2-0.2 0.18-0.21 0.16-0.22 0.15-0.23 0.14-0.25 0.12-0.25 0.11-0.26 0.1-0.28 0.09-0.28 0.08-0.28 0.07-0.3 0.06-0.3 0.05-0.31 0.04-0.31 0.04-0.32 0.02-0.32 0.03-0.33 0.02-0.66 0.02-0.68v-0.33-19.4h9.97v22.24l-0.02 0.76-0.04 0.73-0.07 0.71-0.1 0.69-0.12 0.67-0.16 0.65-0.18 0.63-0.21 0.61-0.24 0.58-0.26 0.57-0.29 0.54-0.32 0.52-0.34 0.5-0.37 0.48-0.4 0.45-0.42 0.43-0.45 0.41-0.47 0.39-0.5 0.36-0.53 0.35-0.55 0.32-0.58 0.29-0.6 0.28-0.62 0.25-0.66 0.22-0.67 0.21-0.7 0.18-0.73 0.15-0.75 0.14-0.77 0.11-0.8 0.08-0.82 0.06-0.84 0.04-0.87 0.01h-0.89l-0.86-0.03-0.83-0.06-0.81-0.07-0.78-0.11-0.76-0.13-0.73-0.15-0.71-0.18-0.68-0.2-0.65-0.22-0.63-0.25-0.6-0.27-0.58-0.3-0.55-0.32-0.52-0.34-0.49-0.37-0.47-0.38-0.45-0.41-0.42-0.43-0.39-0.46-0.36-0.48-0.34-0.49-0.31-0.52-0.28-0.54-0.26-0.57-0.23-0.58-0.2-0.6-0.18-0.63-0.15-0.64-0.12-0.67-0.1-0.68-0.06-0.71-0.04-0.72-0.02-0.75v-22.35h9.97v19.4 0.33zm144.25-20.17 1.5 0.25 1.43 0.35 1.35 0.44 1.28 0.52 1.2 0.6 1.12 0.67 1.05 0.74 0.98 0.8 0.9 0.86 0.82 0.9 0.75 0.96 0.68 0.99 0.61 1.03 0.53 1.06 0.46 1.08 0.39 1.1 0.31 1.12 0.25 1.13 0.17 1.13 0.11 1.12 0.03 1.12-0.03 1.12-0.11 1.13-0.17 1.12-0.25 1.13-0.31 1.11-0.39 1.1-0.46 1.07-0.53 1.06-0.61 1.02-0.68 0.98-0.75 0.95-0.82 0.9-0.9 0.85-0.98 0.79-1.05 0.73-1.12 0.67-1.2 0.59-1.28 0.52-1.35 0.43-1.43 0.35-1.5 0.25-1.59 0.16-1.66 0.05-1.66-0.04-1.58-0.14-1.51-0.25-1.43-0.33-1.35-0.43-1.28-0.51-1.2-0.58-1.12-0.66-1.05-0.73-0.97-0.79-0.9-0.85-0.83-0.9-0.75-0.95-0.68-0.98-0.6-1.03-0.53-1.06-0.46-1.08-0.39-1.11-0.32-1.12-0.25-1.13-0.17-1.14-0.11-1.13-0.03-1.14 0.03-1.13 0.11-1.14 0.17-1.14 0.25-1.13 0.32-1.12 0.39-1.1 0.46-1.09 0.53-1.06 0.6-1.03 0.68-0.99 0.75-0.95 0.83-0.9 0.9-0.85 0.97-0.8 1.05-0.73 1.12-0.67 1.2-0.59 1.28-0.52 1.35-0.43 1.43-0.35 1.51-0.25 1.58-0.16 1.66-0.05 1.66 0.05 1.59 0.16zm95.02 9.41 0.11 0.21 0.12 0.21 0.11 0.23 0.12 0.22 0.11 0.23 0.12 0.23 0.48 0.96 0.11 0.25 0.12 0.24 0.22 0.5 0.11 0.24 0.1 0.25 0.2 0.48 0.18 0.48 0.08 0.23 0.14 0.46 0.06 0.22 0.06 0.21 0.04 0.21 0.04 0.2h0.22l0.04-0.2 0.1-0.42 0.06-0.22 0.14-0.46 0.08-0.23 0.08-0.24 0.27-0.72 0.1-0.25 0.11-0.24 0.1-0.25 0.11-0.25 0.12-0.24 0.11-0.25 0.48-0.96 0.24-0.46 0.12-0.22 0.12-0.23 0.24-0.42 0.12-0.2 4.71-8.66h10.63l-13.04 22.46v12.49h-10.51v-12.49h-0.11l-13.04-22.46h10.95l4.72 8.66 0.1 0.2zm-59.57-8.83 1.41 0.17 1.34 0.23 1.29 0.3 1.23 0.36 1.17 0.43 1.11 0.48 1.04 0.55 0.99 0.61 0.92 0.67 0.86 0.72 0.79 0.78 0.73 0.84 0.66 0.89 0.59 0.95 0.53 1 0.46 1.05 0.39 1.11 0.32 1.15 0.25 1.2 0.18 1.26 0.11 1.3 0.04 1.34-0.04 1.32-0.11 1.28-0.19 1.24-0.25 1.19-0.33 1.14-0.4 1.1-0.47 1.05-0.54 1-0.6 0.95-0.67 0.89-0.74 0.85-0.8 0.78-0.86 0.74-0.93 0.67-0.98 0.62-1.05 0.55-1.11 0.5-1.16 0.43-1.22 0.37-1.28 0.31-1.34 0.24-1.39 0.17-1.44 0.11-1.49 0.03h-12.93v-35.06h12.93l1.52 0.04 1.46 0.1zm-67.18 7.97v26.84h-9.97v-26.84h-8.66v-8.11h27.28v8.11h-8.65zm-34.84 26.84-1.65-5.04h-13.14l-1.65 5.04h-10.18l0.07-0.16 0.18-0.47 0.29-0.76 0.39-1.01 0.46-1.23 0.54-1.44 0.61-1.61 0.65-1.76 0.71-1.88 0.73-1.98 0.76-2.04 0.78-2.08 0.77-2.1 0.78-2.08 0.76-2.04 0.73-1.98 0.7-1.88 0.65-1.76 0.59-1.61 0.54-1.44 0.46-1.24 0.37-1.01 0.28-0.75 0.17-0.47 0.06-0.17h10.96l13.04 34.95h-10.41zm143.63 0-1.65-5.04h-13.14l-1.65 5.04h-10.19l0.08-0.16 0.18-0.47 0.29-0.76 0.39-1.01 0.46-1.23 0.54-1.44 0.61-1.61 0.65-1.76 0.71-1.88 0.73-1.98 0.76-2.04 0.78-2.08 0.77-2.1 0.78-2.08 0.75-2.04 0.74-1.98 0.69-1.88 0.66-1.76 0.59-1.61 0.54-1.44 0.45-1.24 0.38-1.01 0.28-0.75 0.17-0.47 0.06-0.17h10.96l13.04 34.95h-10.41zm-47.44-8h2.19l1.85-0.09 1.66-0.28 1.47-0.46 1.28-0.65 1.09-0.84 0.9-1.04 0.7-1.22 0.51-1.42 0.3-1.61 0.1-1.81-0.1-1.81-0.3-1.61-0.51-1.41-0.7-1.23-0.9-1.03-1.09-0.84-1.28-0.65-1.47-0.47-1.66-0.28-1.85-0.09h-2.19v18.84zm-35.4-18.62-1.17 0.4-1.09 0.56-1 0.72-0.88 0.87-0.75 1.03-0.61 1.18-0.46 1.33-0.28 1.48-0.1 1.63 0.1 1.63 0.28 1.47 0.46 1.33 0.61 1.16 0.75 1.02 0.88 0.86 1 0.7 1.09 0.55 1.17 0.39 1.24 0.24 1.29 0.07 1.3-0.07 1.24-0.24 1.19-0.39 1.1-0.55 1.01-0.7 0.89-0.86 0.77-1.02 0.63-1.16 0.46-1.33 0.29-1.47 0.11-1.63-0.1-1.63-0.29-1.48-0.45-1.33-0.62-1.18-0.76-1.03-0.89-0.87-1-0.72-1.1-0.56-1.2-0.4-1.26-0.25-1.32-0.08-1.29 0.08-1.24 0.25zm-69.34 0.69-0.13 0.74-0.15 0.77-0.18 0.78-0.19 0.79-0.22 0.76-0.22 0.73-2.74 8.43h8.21l-2.73-8.43-0.23-0.73-0.21-0.76-0.2-0.79-0.18-0.78-0.15-0.77-0.13-0.74-0.11-0.69h-0.33l-0.11 0.69zm143.63 0-0.13 0.74-0.15 0.77-0.18 0.78-0.19 0.79-0.22 0.76-0.22 0.73-2.74 8.43h8.21l-2.73-8.43-0.23-0.73-0.22-0.76-0.19-0.79-0.18-0.78-0.15-0.77-0.13-0.74-0.11-0.69h-0.33l-0.11 0.69z'
          id='usaToday'
        />
      </defs>
      <use xlinkHref='#newYorkTimes' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#newYorkTimes'
      />
      <use xlinkHref='#bbc' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#bbc'
      />
      <use xlinkHref='#quartz' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#quartz'
      />
      <use xlinkHref='#time' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#time'
      />
      <use xlinkHref='#wired' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#wired'
      />
      <use xlinkHref='#inc' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#inc'
      />
      <use xlinkHref='#businessInsider' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#businessInsider'
      />
      <use xlinkHref='#lifehacker' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#lifehacker'
      />
      <use xlinkHref='#usaToday' />
      <use
        fillOpacity='0'
        stroke='#000000'
        strokeOpacity='0'
        xlinkHref='#usaToday'
      />
    </svg>
  );
};

AsSeenInText.displayName = 'AsSeenInText';

export default AsSeenInText;
