import React from 'react';

const MicrosoftLogo = (
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element => (
  <svg
    id='microsoft-logo'
    viewBox='939.813 1185 1400 472'
    xmlns='http://www.w3.org/2000/svg'
    xmlnsXlink='http://www.w3.org/1999/xlink'
    fill='var(--quaternary-color)'
    role='img'
    aria-labelledby='microsoft-logo-label'
    {...props}
  >
    <title id='microsoft-logo-label'>Microsoft</title>
    <g>
      <path d=' M 1430.669 1446.063 L 1422.38 1469.547 L 1421.69 1469.547 C 1420.308 1464.251 1417.776 1456.193 1413.631 1446.523 L 1369.196 1334.86 L 1325.683 1334.86 L 1325.683 1512.83 L 1354.462 1512.83 L 1354.462 1403.009 C 1354.462 1396.102 1354.462 1388.274 1354.231 1378.605 C 1354.001 1373.77 1353.541 1370.086 1353.31 1367.323 L 1354.001 1367.323 C 1355.383 1374.23 1356.994 1379.295 1358.145 1382.519 L 1411.559 1512.37 L 1431.82 1512.37 L 1484.773 1381.367 C 1485.924 1378.374 1487.076 1372.388 1488.227 1367.323 L 1488.917 1367.323 C 1488.227 1380.447 1487.766 1392.188 1487.536 1399.326 L 1487.536 1512.14 L 1518.157 1512.14 L 1518.157 1334.4 L 1476.255 1334.4 L 1430.669 1446.063 L 1430.669 1446.063 Z  M 1547.166 1384.591 L 1577.096 1384.591 L 1577.096 1512.14 L 1547.166 1512.14 L 1547.166 1384.591 Z  M 1562.362 1330.716 C 1557.297 1330.716 1553.152 1332.558 1549.699 1335.781 C 1546.245 1339.005 1544.403 1343.149 1544.403 1348.214 C 1544.403 1353.049 1546.245 1357.193 1549.699 1360.416 C 1553.152 1363.64 1557.297 1365.251 1562.362 1365.251 C 1567.427 1365.251 1571.801 1363.409 1575.024 1360.416 C 1578.478 1357.193 1580.32 1353.049 1580.32 1348.214 C 1580.32 1343.379 1578.478 1339.235 1575.024 1335.781 C 1572.031 1332.558 1567.657 1330.716 1562.362 1330.716 Z  M 1683.234 1383.44 C 1677.708 1382.288 1671.952 1381.598 1666.427 1381.598 C 1652.843 1381.598 1640.41 1384.591 1630.05 1390.577 C 1619.689 1396.563 1611.401 1404.851 1606.106 1415.212 C 1600.58 1425.802 1597.817 1438.005 1597.817 1452.049 C 1597.817 1464.251 1600.58 1475.072 1605.876 1484.972 C 1611.171 1494.642 1618.538 1502.47 1628.438 1507.765 C 1637.878 1513.06 1648.929 1515.823 1661.362 1515.823 C 1675.636 1515.823 1687.838 1512.83 1697.508 1507.305 L 1697.738 1507.074 L 1697.738 1479.447 L 1696.587 1480.367 C 1692.213 1483.591 1687.148 1486.353 1682.083 1487.965 C 1676.787 1489.807 1671.952 1490.728 1667.808 1490.728 C 1655.836 1490.728 1646.396 1487.274 1639.72 1479.677 C 1632.813 1472.309 1629.359 1462.179 1629.359 1449.516 C 1629.359 1436.393 1632.813 1426.033 1639.95 1418.435 C 1647.087 1410.837 1656.527 1406.923 1668.038 1406.923 C 1677.708 1406.923 1687.608 1410.147 1696.587 1416.593 L 1697.738 1417.514 L 1697.738 1388.274 L 1697.508 1388.044 C 1693.594 1386.433 1689.22 1384.591 1683.234 1383.44 M 1782.003 1382.519 C 1774.636 1382.519 1767.729 1384.821 1761.743 1389.656 C 1756.678 1393.8 1753.224 1399.786 1750.231 1406.923 L 1750.001 1406.923 L 1750.001 1384.591 L 1720.071 1384.591 L 1720.071 1512.14 L 1750.001 1512.14 L 1750.001 1446.984 C 1750.001 1435.933 1752.303 1426.723 1757.369 1420.047 C 1762.434 1413.14 1768.88 1409.686 1776.708 1409.686 C 1779.471 1409.686 1782.234 1410.377 1785.687 1410.837 C 1788.91 1411.758 1791.213 1412.679 1792.824 1413.83 L 1793.976 1414.751 L 1793.976 1384.821 L 1793.285 1384.591 C 1791.213 1383.209 1787.069 1382.519 1782.003 1382.519 M 1863.506 1381.828 C 1842.555 1381.828 1825.748 1388.044 1814.006 1400.247 C 1802.034 1412.449 1796.278 1429.256 1796.278 1450.437 C 1796.278 1470.237 1802.264 1486.353 1813.776 1498.095 C 1825.287 1509.607 1840.943 1515.593 1860.513 1515.593 C 1881.003 1515.593 1897.35 1509.377 1909.092 1496.944 C 1921.064 1484.512 1926.82 1467.935 1926.82 1447.444 C 1926.82 1427.184 1921.294 1411.067 1910.013 1399.326 C 1899.192 1387.584 1883.306 1381.828 1863.506 1381.828 M 1887.45 1479.907 C 1881.924 1487.044 1873.176 1490.498 1862.355 1490.498 C 1851.534 1490.498 1842.785 1487.044 1836.569 1479.447 C 1830.352 1472.309 1827.359 1461.949 1827.359 1448.826 C 1827.359 1435.242 1830.583 1424.881 1836.569 1417.514 C 1842.785 1410.147 1851.303 1406.463 1862.124 1406.463 C 1872.715 1406.463 1881.003 1409.916 1886.989 1417.053 C 1892.976 1424.191 1896.199 1434.551 1896.199 1448.135 C 1895.738 1461.949 1893.206 1472.77 1887.45 1479.907 M 1993.587 1437.544 C 1984.148 1433.63 1978.162 1430.637 1975.399 1428.105 C 1973.096 1425.802 1971.945 1422.579 1971.945 1418.435 C 1971.945 1414.981 1973.327 1411.528 1976.78 1409.226 C 1980.234 1406.923 1984.148 1405.772 1989.903 1405.772 C 1994.969 1405.772 2000.264 1406.693 2005.329 1408.074 C 2010.394 1409.456 2014.999 1411.528 2018.683 1414.291 L 2019.834 1415.212 L 2019.834 1387.123 L 2019.143 1386.893 C 2015.689 1385.512 2011.085 1384.13 2005.559 1382.979 C 2000.034 1382.058 1994.969 1381.598 1990.824 1381.598 C 1976.55 1381.598 1964.808 1385.051 1955.599 1392.649 C 1946.39 1399.786 1942.015 1409.456 1942.015 1420.737 C 1942.015 1426.723 1942.936 1432.019 1945.008 1436.393 C 1947.08 1440.767 1950.073 1444.912 1954.217 1448.365 C 1958.362 1451.588 1964.348 1455.272 1972.636 1458.726 C 1979.543 1461.719 1984.838 1464.021 1988.062 1465.863 C 1991.285 1467.705 1993.357 1469.777 1994.969 1471.388 C 1996.12 1473.23 1996.81 1475.533 1996.81 1478.526 C 1996.81 1487.044 1990.364 1491.188 1977.241 1491.188 C 1972.176 1491.188 1966.88 1490.267 1960.664 1488.195 C 1954.448 1486.123 1948.692 1483.13 1943.857 1479.677 L 1942.706 1478.756 L 1942.706 1507.995 L 1943.396 1508.226 C 1947.771 1510.298 1953.066 1511.679 1959.513 1513.291 C 1965.959 1514.442 1971.715 1515.363 1976.78 1515.363 C 1992.206 1515.363 2004.869 1511.909 2013.848 1504.312 C 2023.057 1496.944 2027.892 1487.505 2027.892 1475.302 C 2027.892 1466.784 2025.59 1459.186 2020.524 1453.43 C 2013.848 1447.905 2005.559 1442.149 1993.587 1437.544 M 2106.862 1381.828 C 2085.91 1381.828 2069.103 1388.044 2057.362 1400.247 C 2045.62 1412.449 2039.634 1429.256 2039.634 1450.437 C 2039.634 1470.237 2045.62 1486.353 2057.131 1498.095 C 2068.643 1509.607 2084.299 1515.593 2103.869 1515.593 C 2124.359 1515.593 2140.706 1509.377 2152.448 1496.944 C 2164.42 1484.512 2170.176 1467.935 2170.176 1447.444 C 2170.176 1427.184 2164.65 1411.067 2153.369 1399.326 C 2142.548 1387.584 2126.662 1381.828 2106.862 1381.828 M 2130.576 1479.907 C 2125.05 1487.044 2116.301 1490.498 2105.48 1490.498 C 2094.429 1490.498 2085.91 1487.044 2079.694 1479.447 C 2073.478 1472.309 2070.485 1461.949 2070.485 1448.826 C 2070.485 1435.242 2073.708 1424.881 2079.694 1417.514 C 2085.91 1410.147 2094.429 1406.463 2105.25 1406.463 C 2115.61 1406.463 2124.129 1409.916 2130.115 1417.053 C 2136.101 1424.191 2139.324 1434.551 2139.324 1448.135 C 2139.324 1461.949 2136.331 1472.77 2130.576 1479.907 M 2330.187 1409.226 L 2330.187 1384.591 L 2300.027 1384.591 L 2300.027 1346.833 L 2299.106 1347.063 L 2270.557 1355.581 L 2269.866 1355.812 L 2269.866 1384.591 L 2224.741 1384.591 L 2224.741 1368.474 C 2224.741 1361.107 2226.583 1355.351 2229.806 1351.667 C 2233.029 1347.984 2237.864 1346.142 2243.85 1346.142 C 2247.994 1346.142 2252.369 1347.063 2257.203 1349.135 L 2258.355 1349.826 L 2258.355 1323.809 L 2257.664 1323.579 C 2253.52 1322.198 2247.994 1321.277 2240.857 1321.277 C 2231.878 1321.277 2224.05 1323.349 2216.913 1326.802 C 2209.775 1330.716 2204.48 1336.012 2200.566 1343.149 C 2196.652 1350.056 2194.58 1357.884 2194.58 1366.863 L 2194.58 1384.591 L 2173.629 1384.591 L 2173.629 1408.995 L 2194.58 1408.995 L 2194.58 1512.14 L 2224.741 1512.14 L 2224.741 1409.226 L 2269.866 1409.226 L 2269.866 1474.842 C 2269.866 1501.779 2282.529 1515.363 2307.855 1515.363 C 2311.999 1515.363 2316.373 1514.672 2320.517 1513.981 C 2324.892 1513.06 2328.115 1511.909 2329.957 1510.988 L 2330.187 1510.758 L 2330.187 1486.123 L 2329.036 1487.044 C 2327.194 1488.195 2325.583 1489.116 2322.82 1489.807 C 2320.517 1490.498 2318.445 1490.728 2316.834 1490.728 C 2310.848 1490.728 2306.703 1489.347 2303.71 1485.893 C 2300.948 1482.67 2299.566 1477.374 2299.566 1469.547 L 2299.566 1409.226 L 2330.187 1409.226 L 2330.187 1409.226 Z ' />
      <path d=' M 939.813 1275 L 1080.945 1275 L 1080.945 1416.133 L 939.813 1416.133 L 939.813 1275 Z ' />
      <path d=' M 1095.68 1275 L 1236.813 1275 L 1236.813 1416.133 L 1095.68 1416.133 L 1095.68 1275 Z ' />
      <path d=' M 939.813 1430.867 L 1080.945 1430.867 L 1080.945 1572 L 939.813 1572 L 939.813 1430.867 Z ' />
      <path d=' M 1095.68 1430.867 L 1236.813 1430.867 L 1236.813 1572 L 1095.68 1572 L 1095.68 1430.867 Z ' />
    </g>
  </svg>
);

MicrosoftLogo.displayName = 'MicrosoftLogo';

export default MicrosoftLogo;
